/* Copyright (C) 2005 Datapark corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _DPS_CHARSETUTILS_H
#define _DPS_CHARSETUTILS_H

extern __C_LINK void* dps_memmove(void *dst0, const void *src0, size_t length);
extern __C_LINK void* dps_memcpy(void *dst0, const void *src0, size_t length);
extern __C_LINK void* dps_strncpy(void *dst0, const void *src0, size_t length);
extern __C_LINK void* dps_strcpy(void *dst0, const void *src0);
extern __C_LINK void* dps_strcat(void *dst0, const void *src0);
extern __C_LINK void* dps_strncat(void *dst0, const void *src0, size_t length);
extern __C_LINK size_t dps_strlen(const char *src);
extern __C_LINK int dps_tolower(int c);

#ifndef DPS_NULL2EMPTY
#define DPS_NULL2EMPTY(x)	((x)?(x):"")
#endif

#endif /* _DPS_UTILS_H */
