/* Copyright (C) 2003-2006 Datapark corp. All rights reserved.
   Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/
#include "dps_common.h"
#include "dps_utils.h"
#include "dps_unicode.h"
#include "dps_unidata.h"
#include "dps_uniconv.h"
#include "dps_searchtool.h"
#include "dps_boolean.h"
#include "dps_xmalloc.h"
#include "dps_spell.h"
#include "dps_stopwords.h"
#include "dps_word.h"
#include "dps_vars.h"
#include "dps_db.h"
#include "dps_db_int.h"
#include "dps_url.h"
#include "dps_hash.h"
#include "dps_parsehtml.h"
#include "dps_store.h"
#include "dps_doc.h"
#include "dps_conf.h"
#include "dps_result.h"
#include "dps_log.h"
#include "dps_sgml.h"
#include "dps_mutex.h"
#include "dps_chinese.h"
#include "dps_acronym.h"
#include "dps_charsetutils.h"

#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include <math.h>

#ifdef CHASEN
#include <chasen.h>
#endif

#ifdef MECAB
#include <mecab.h>
#endif


#define DEBUG_CACHE

/*
#define DEBUG_PHRASES
*/

/********** QSORT functions *******************************/

static int cmpword(DPS_URL_CRD *s1,DPS_URL_CRD *s2){
        if (s1->coord > s2->coord) return -1;
	if (s1->coord < s2->coord) return 1;
	if (s1->url_id > s2->url_id) return 1;
	if (s1->url_id < s2->url_id) return -1;
	return 0;
}

int DpsCmpUrlid(DPS_URL_CRD *s1, DPS_URL_CRD *s2) {
	if (s1->url_id < s2->url_id) return -1;
	if (s1->url_id > s2->url_id) return 1;
	if (s1->coord < s2->coord) return -1;
	if (s1->coord > s2->coord) return 1;
	return 0;
}



static int DpsCmpPattern(DPS_URLCRDLIST *L, size_t i, size_t j, const char *pattern) {
  
  for(; *pattern != '\0'; pattern++) {
    switch(*pattern) {
    case 'R':
      if (L->Coords[i].coord > L->Coords[j].coord) return -1;
      if (L->Coords[i].coord < L->Coords[j].coord) return 1;
      break;
    case 'r':
      if (L->Coords[i].coord > L->Coords[j].coord) return 1;
      if (L->Coords[i].coord < L->Coords[j].coord) return -1;
      break;
    case 'P':
      if (L->Data[i].pop_rank > L->Data[j].pop_rank) return -1;
      if (L->Data[i].pop_rank < L->Data[j].pop_rank) return 1;
      break;
    case 'p':
      if (L->Data[i].pop_rank > L->Data[j].pop_rank) return 1;
      if (L->Data[i].pop_rank < L->Data[j].pop_rank) return -1;
      break;
    case 'D':
      if (L->Data[i].last_mod_time > L->Data[j].last_mod_time) return -1;
      if (L->Data[i].last_mod_time < L->Data[j].last_mod_time) return 1;
      break;
    case 'd':
      if (L->Data[i].last_mod_time > L->Data[j].last_mod_time) return 1;
      if (L->Data[i].last_mod_time < L->Data[j].last_mod_time) return -1;
      break;
    case 'I':
      {
	register double m1 = L->Data[i].pop_rank, m2 = L->Data[j].pop_rank;
	m1 *= (double)L->Coords[i].coord; m2 *= (double)L->Coords[j].coord;
	if (m1 > m2) return -1;
	if (m1 < m2) return 1;
      }
	break;
    case 'i':
      {
	register double m1 = L->Data[i].pop_rank, m2 = L->Data[j].pop_rank;
	m1 *= (double)L->Coords[i].coord; m2 *= (double)L->Coords[j].coord;
	if (m1 > m2) return 1;
	if (m1 < m2) return -1;
      }
	break;
    case 'A':
      {
	register double m1 = L->Data[i].pop_rank * 1000.0, m2 = L->Data[j].pop_rank * 1000.0;
	m1 += (double)L->Coords[i].coord; m2 += (double)L->Coords[j].coord;
	if (m1 > m2) return -1;
	if (m1 < m2) return 1;
      }
	break;
    case 'a':
      {
	register double m1 = L->Data[i].pop_rank * 1000.0, m2 = L->Data[j].pop_rank * 1000.0;
	m1 += (double)L->Coords[i].coord; m2 += (double)L->Coords[j].coord;
	if (m1 > m2) return 1;
	if (m1 < m2) return -1;
      }
	break;
    }
  }
  return 0;
}

static int DpsCmpSiteid(DPS_URLCRDLIST *L, size_t i, size_t j, const char *pattern) {

        if (L->Data[i].site_id < L->Data[j].site_id) return -1;
	if (L->Data[i].site_id > L->Data[j].site_id) return 1;
	return DpsCmpPattern(L, i, j, pattern);
}


/****************************************************/

void DpsSortSearchWordsByWeight(DPS_URL_CRD *wrd,size_t num){
	if (wrd != NULL && num > 1) DpsSort((void*)wrd, num, sizeof(*wrd), (qsort_cmp)cmpword);
	return;
}

void DpsSortSearchWordsByURL(DPS_URL_CRD *wrd,size_t num){
	if(wrd != NULL && num > 1) DpsSort((void*)wrd, num, sizeof(*wrd),( qsort_cmp)DpsCmpUrlid);
	return;
}


#define med3(func, a, b, c, L, pattern)  (func(L, a, b, pattern) < 0 ?	\
					  (func(L, b, c, pattern) < 0 ? (b) : (func(L, a, c, pattern) < 0 ? (c) : (a))) \
					  : (func(L, b, c, pattern) > 0 ? (b) : (func(L, a, c, pattern) < 0 ? (a) : (c))))



static size_t DpsPartitionSearchWordsBySite(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t p, size_t r, const char *pattern, int merge) {
  DPS_URL_CRD Crd;
  DPS_URLDATA Dat;
  size_t i = p, j = r, m, pl, pm, pn, d;
  size_t PerS;

  pm = (p + r) / 2;
  pl = p;
  pn = r;
  if ( (d = (r - p)) > 40) {
    d /= 8;
    pl = med3(DpsCmpSiteid, pl, pl + d, pl + 2 * d, L, pattern);
    pm = med3(DpsCmpSiteid, pm - d, pm, pm + d, L, pattern);
    pn = med3(DpsCmpSiteid, pn - 2 * d, pn - d, pn, L, pattern);
  }
  m = med3(DpsCmpSiteid, pl, pm, pn, L, pattern);

  while (1) {
    while ((DpsCmpSiteid(L, j, m, pattern) > 0) && (j > p)) j--;
    while ((DpsCmpSiteid(L, i, m, pattern) < 0) && (i < r)) i++;
    if (i < j) {
      Crd = L->Coords[j];
      Dat = L->Data[j];
      L->Coords[j] = L->Coords[i];
      L->Data[j] = L->Data[i];
      L->Coords[i] = Crd;
      L->Data[i] = Dat;
      if (merge) {
	PerS = Res->PerSite[j];
	Res->PerSite[j] = Res->PerSite[i];
	Res->PerSite[i] = PerS;
      }
      if (i == m) m = j;
      else if (j == m) m = i;
      i++;
      j--;
    } else return j;
  }
}



static void DpsQsortSearchWordsBySite(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t p, size_t r, const char *pattern, int merge) {

  DPS_URL_CRD Crd;
  DPS_URLDATA Dat;
  size_t l = p, q;
  size_t PerS;

 DpsQsortBySiteLoop:
  if (l >= r) return;
  if (r - l <= 7) {
    register size_t i, j;

    for (j = l + 1; j <= r; j++) {
      for (i = j; (i > l) && (DpsCmpSiteid(L, i - 1, i, pattern) > 0); i--) {
	  Crd = L->Coords[i];
	  Dat = L->Data[i];
	  L->Coords[i] = L->Coords[i - 1];
	  L->Data[i] = L->Data[i - 1];
	  L->Coords[i - 1] = Crd;
	  L->Data[i - 1] = Dat;
	  if (merge) {
	    PerS = Res->PerSite[i];
	    Res->PerSite[i] = Res->PerSite[i - 1];
	    Res->PerSite[i - 1] = PerS;
	  }
      }
    }

    return;
  }
  q = DpsPartitionSearchWordsBySite(Res, L, l, r, pattern, merge);
  if (q == r) { 
    r--; 
    goto DpsQsortBySiteLoop; 
  }
  DpsQsortSearchWordsBySite(Res, L, l, q, pattern, merge);
  l = q + 1;
  goto DpsQsortBySiteLoop;
  

}


void DpsSortSearchWordsBySite(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t num, const char *pattern) {

  if (num > 1) DpsQsortSearchWordsBySite(Res, L, 0, num - 1, pattern, (Res->PerSite != NULL));

}



static size_t DpsPartitionSearchWordsByPattern(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t p, size_t r, const char *pattern) {
  size_t i = p, j = r, m, pl, pm, pn, d;
  size_t Cnt = 1;
  DPS_URL_CRD Crd;
  DPS_URLDATA Dat;

  pm = (p + r) / 2;
  pl = p;
  pn = r;
  if ( (d = (r - p)) > 40) {
    d /= 8;
    pl = med3(DpsCmpPattern, pl, pl + d, pl + 2 * d, L, pattern);
    pm = med3(DpsCmpPattern, pm - d, pm, pm + d, L, pattern);
    pn = med3(DpsCmpPattern, pn - 2 * d, pn - d, pn, L, pattern);
  }
  m = med3(DpsCmpPattern, pl, pm, pn, L, pattern);

  while (1) {
    while ((DpsCmpPattern(L, j, m, pattern) > 0) && (j > p)) j--;
    while ((DpsCmpPattern(L, i, m, pattern) < 0) && (i < r)) i++;
    if (i < j) {
      Crd = L->Coords[j];
      Dat = L->Data[j];
      L->Coords[j] = L->Coords[i];
      L->Data[j] = L->Data[i];
      L->Coords[i] = Crd;
      L->Data[i] = Dat;
      if (Res->PerSite) {
	Cnt = Res->PerSite[j];
	Res->PerSite[j] = Res->PerSite[i];
	Res->PerSite[i] = Cnt;
      }
      if (i == m) m = j;
      else if (j == m) m = i;
      i++;
      j--;
    } else return j;
  }
}


static void DpsQsortSearchWordsByPattern(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t p, size_t q, const char *pattern) {

  size_t l = p, r = q, c;
  size_t Cnt = 1;
  DPS_URL_CRD Crd;
  DPS_URLDATA Dat;

 DpsQsortByPatternLoop:
  if (l >= r) return;
  if (r - l <= 7) {
    register size_t i, j;

    for (j = l + 1; j <= r; j++) {

      for (i = j; i > l && (DpsCmpPattern(L, i - 1, i, pattern) > 0); i--) {
	Crd = L->Coords[i];
	Dat = L->Data[i];
	L->Coords[i] = L->Coords[i - 1];
	L->Data[i] = L->Data[i - 1];
	L->Coords[i - 1] = Crd;
	L->Data[i - 1] = Dat;
	if (Res->PerSite) {
	  Cnt = Res->PerSite[i];
	  Res->PerSite[i] = Res->PerSite[i - 1];
	  Res->PerSite[i - 1] = Cnt;
	}
      }

    }
    return;
  }
  c = DpsPartitionSearchWordsByPattern(Res, L, l, r, pattern);
  if (c == r) { 
    r--; 
    goto DpsQsortByPatternLoop; 
  }
  DpsQsortSearchWordsByPattern(Res, L, l, c, pattern);
  l = c + 1;
  goto DpsQsortByPatternLoop;
  

}


void DpsSortSearchWordsByPattern(DPS_RESULT *Res, DPS_URLCRDLIST *L, size_t num, const char *pattern) {

  if (num > 1) DpsQsortSearchWordsByPattern(Res, L, 0, num - 1, pattern);

}


static int DpsExpandWord(DPS_AGENT *query, DPS_RESULT *Res, DPS_WIDEWORD *OWord, int *ORDER, int sp, size_t nphrasecmd,
			 int have_bukva_forte, const char *qlang) {
  DPS_WIDEWORDLIST * forms;
  dpsunicode_t *af_uwrd = NULL;
  char *clex;
  DPS_ACRONYM *first, *last;
  int Origin = OWord->origin;
  int ORDER_ADD = *ORDER;
#if 0 && defined HAVE_ASPELL
  AspellCanHaveError *ret;
  AspellSpeller *speller;
  AspellWordList *suggestions;
  AspellStringEnumeration *elements;
  char *lcsword;
  size_t af_len;

  if (sp && query->Flags.use_aspellext && have_bukva_forte) {
/**************************/
    DPS_GETLOCK(query, DPS_LOCK_ASPELL);
    ret = new_aspell_speller(query->aspell_config);
    if (aspell_error(ret) != 0) {
      DpsLog(query, DPS_LOG_ERROR, "aspell error: %s", aspell_error_message(ret));
      delete_aspell_can_have_error(ret);
    } else {
      register int i;
      speller = to_aspell_speller(ret);
      if (aspell_speller_check(speller, (const char *)OWord->uword, -1) == 0) {
	lcsword = (char*)DpsMalloc(12*query->WordParam.max_word_len);
	if (lcsword == NULL) return DPS_ERROR;
	suggestions = aspell_speller_suggest(speller, (const char *)OWord->uword, -1);
	elements = aspell_word_list_elements(suggestions);
	for (i = 0; (i < 2) && ((af_uwrd = (dpsunicode_t*)aspell_string_enumeration_next(elements)) != NULL); ) { 

	  DpsUniStrToLower(af_uwrd);
	  af_len = DpsUniLen(af_uwrd);
	  if (af_len < OWord->ulen && OWord->ulen - af_len > 1) { af_uwrd = NULL; continue;}
	  if (DpsUniStrCmp(af_uwrd, OWord->uword) == 0) { af_uwrd = NULL; continue;}
	  DpsConv(&query->uni_lc, lcsword, 12*query->WordParam.max_word_len, 
		  (char*)(af_uwrd), sizeof(af_uwrd[0])*(DpsUniLen(af_uwrd)+1));
	  if ((strchr(lcsword, ' ') != NULL) || (strchr(lcsword, '-') != NULL)) { af_uwrd = NULL; continue;}
	  if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)*ORDER, Origin | DPS_WORD_ORIGIN_ASPELL, 
			      lcsword, af_uwrd, qlang) != DPS_OK) {
	    DPS_FREE(lcsword);
	    return DPS_ERROR;
	  }
	  af_uwrd = NULL;
	  i++;
	}
	DPS_FREE(lcsword);
	delete_aspell_string_enumeration(elements);
      }
      delete_aspell_speller(speller);
    }
    DPS_RELEASELOCK(query, DPS_LOCK_ASPELL);
  }
#endif

  if(sp && (forms = DpsAllForms(query, OWord)) ) {
    size_t frm;
    for(frm = 0; frm < forms->nwords; frm++) {
      if (DpsUniStrCmp(OWord->uword, forms->Word[frm].uword) == 0) continue;
      DpsConv(&query->uni_lc, OWord->word, 12 * query->WordParam.max_word_len,
	      (char*)(forms->Word[frm].uword),
	      sizeof(forms->Word[frm].uword[0])*(DpsUniLen(forms->Word[frm].uword)+1));
      
      if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)*ORDER, Origin | forms->Word[frm].origin, 
			  OWord->word, forms->Word[frm].uword, qlang) != DPS_OK) {
	return DPS_ERROR;
      }
      OWord->uword = forms->Word[frm].uword;
      OWord->ulen = DpsUniLen(forms->Word[frm].uword);
      if (!(nphrasecmd & 1) && (first = DpsAcronymListFind(&query->Conf->Acronyms, OWord, &last)) != NULL) {

	while(first <= last) {
	  if (DpsAddStackItem(query, Res, DPS_STACK_OR, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	    return DPS_ERROR;
	  }
	  if (first->unroll.nwords > 1) {
	    if (DpsAddStackItem(query, Res, DPS_STACK_PHRASE_LEFT, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      return DPS_ERROR;
	    }
	  }
	  { register size_t z;
	    for (z = 0; z < first->unroll.nwords; z++) {
	      if (z) {
		ORDER_ADD++;
		if (DpsAddStackItem(query, Res, DPS_STACK_AND, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		  return DPS_ERROR;
		}
	      }
	      if (DpsAddStackItem(query, Res, DPS_STACK_LEFT, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		return DPS_ERROR;
	      }
					
#if 1
	      if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)ORDER_ADD, DPS_WORD_ORIGIN_ACRONYM, 
				  first->unroll.Word[z].word, 
				  first->unroll.Word[z].uword, qlang) != DPS_OK) {
		return DPS_ERROR;
	      }
	      OWord->uword = first->unroll.Word[z].uword;
	      OWord->ulen = DpsUniLen(first->unroll.Word[z].uword);
	      OWord->origin = DPS_WORD_ORIGIN_ACRONYM;
	      if (DPS_OK != DpsExpandWord(query, Res, OWord, &ORDER_ADD, sp, (first->unroll.nwords > 1) ? 1 : 0, 0, qlang)) {
		return DPS_ERROR;
	      }
#else
	      if(DpsStopListFind(&query->Conf->StopWords, first->unroll.Word[z].uword, qlang) ||
		 (query->WordParam.min_word_len > first->unroll.Word[z].ulen) ||
		 (query->WordParam.max_word_len < first->unroll.Word[z].ulen)) {
		if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)ORDER_ADD, DPS_WORD_ORIGIN_STOP, 
				    first->unroll.Word[z].word, 
				    first->unroll.Word[z].uword, qlang) != DPS_OK) {
		  return DPS_ERROR;
		}
		Res->items[ORDER_ADD].order_origin |= DPS_WORD_ORIGIN_STOP;
	      } else {
		if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)ORDER_ADD, DPS_WORD_ORIGIN_ACRONYM, 
				    first->unroll.Word[z].word, 
				    first->unroll.Word[z].uword, qlang) != DPS_OK) {
		  return DPS_ERROR;
		}
		OWord->uword = first->unroll.Word[z].uword;
		OWord->ulen = DpsUniLen(first->unroll.Word[z].uword);
		OWord->origin = DPS_WORD_ORIGIN_ACRONYM;
		if (DPS_OK != DpsExpandWord(query, Res, OWord, &ORDER_ADD, sp, (first->unroll.nwords > 1) ? 1 : 0, 0, qlang)) {
		  return DPS_ERROR;
		}
	      }
#endif
	      if (DpsAddStackItem(query, Res, DPS_STACK_RIGHT, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		return DPS_ERROR;
	      }
	    }
	  }
	  if (first->unroll.nwords > 1) {
	    if (DpsAddStackItem(query, Res, DPS_STACK_PHRASE_RIGHT, DPS_STACK_OR, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      return DPS_ERROR;
	    }
	  }
	  first++;
	}
      }
    }
    DpsWideWordListFree(forms);
    DPS_FREE(forms);
    *ORDER = ORDER_ADD;
  }

  if (query->Flags.use_accentext) {
    af_uwrd = DpsUniAccentStrip(OWord->uword);
    if (DpsUniStrCmp(af_uwrd, OWord->uword) != 0) {
      DpsConv(&query->uni_lc, OWord->word, query->WordParam.max_word_len * 12, (char*)af_uwrd, 
	      sizeof(af_uwrd[0])*(DpsUniLen(af_uwrd) + 1));
      clex = DpsTrim(OWord->word, " \t\r\n");

      if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)*ORDER, Origin | DPS_WORD_ORIGIN_ACCENT, 
			  OWord->word, af_uwrd, qlang) != DPS_OK) {
	return DPS_ERROR;
      }
				
      OWord->len = dps_strlen(OWord->word);
      OWord->order = (size_t)*ORDER;
      OWord->count = 0;
      OWord->crcword = DpsStrHash32(OWord->word);
/*      OWord->word = wrd;*/
      OWord->uword = af_uwrd;
      OWord->origin = DPS_WORD_ORIGIN_ACCENT;

      if(sp && (forms = DpsAllForms(query, OWord))) {
	size_t frm;
	for(frm = 0; frm < forms->nwords; frm++) {
	  DpsConv(&query->uni_lc, OWord->word, 12 * query->WordParam.max_word_len,
		  (char*)(forms->Word[frm].uword),
		  sizeof(forms->Word[frm].uword[0])*(DpsUniLen(forms->Word[frm].uword)+1));

	  if (DpsAddStackItem(query, Res, DPS_STACK_WORD, DPS_STACK_OR, (size_t)*ORDER, 
			      Origin | DPS_WORD_ORIGIN_ACCENT | forms->Word[frm].origin, 
			      OWord->word, forms->Word[frm].uword, qlang) != DPS_OK) {
	    return DPS_ERROR;
	  }
	}
	DpsWideWordListFree(forms);
	DPS_FREE(forms);
      }
    }
    DPS_FREE(af_uwrd);
  }
  return DPS_OK;
}


int dps_need2segment(dpsunicode_t *uwrd) {
  register int ctype = DpsUniCType(*uwrd);
  register int res = !(ctype >= DPS_UNI_NUMBER_D && ctype <= DPS_UNI_NUMBER_O);
  for(; res && *uwrd; uwrd++) {
    ctype = DpsUniCType(*uwrd);
    if (ctype != DPS_UNI_UNDEF && ctype != DPS_UNI_LETTER_O && ctype != DPS_UNI_SYMBOL_O) res = 0;
    else if (*uwrd < 0xE01 || (*uwrd > 0xE80 && *uwrd < 0x2E80)) res = 0;
  }
  return res;
}



int DpsPrepare(DPS_AGENT *query, DPS_RESULT *Res) {
	DPS_CHARSET * browser_cs, *sys_int;
	int  ctype, ORDER = -1, seg_ctype;
	dpsunicode_t *ustr, *nfc, *lt, *lex, *seg_ustr, *seg_lt, *seg_lex;
	int search_mode = DpsSearchMode(DpsVarListFindStr(&query->Vars, "m", "all"));
	int word_match   = DpsVarListFindInt(&query->Vars, "wm", DPS_MATCH_FULL);
	int sp   = DpsVarListFindInt(&query->Vars, "sp", 1);
	int add_cmd = DPS_STACK_AND;
	int addwrd, wrd_cmd;
	int notfirstword = 0, have_bukva_forte = 0, seg_have_bukva_forte = 0;
	const char * txt = DpsVarListFindStr(&query->Vars, "q", "");
	const char * qlang = DpsVarListFindStr(&query->Vars, "g", NULL), *rlang;
	char *ltxt;
	size_t i, wlen, llen, nphrasecmd = 0, seg_wlen;
	char *wrd, *clex;
	dpsunicode_t *uwrd;
	DPS_CONV bc_uni;
	const char *lang;
	int toadd = 0;
#if defined HAVE_ASPELL
	AspellCanHaveError *ret;
	AspellSpeller *speller;
	AspellWordList *suggestions;
	AspellStringEnumeration *elements;
	char *asug = NULL;
	DPS_DSTR suggest;
	size_t tlen;
	int have_suggest = 0, use_aspellext = query->Flags.use_aspellext;
#endif

	TRACE_IN(query, "DpsPrepare");

	if (Res->prepared) {TRACE_OUT(query); return 0; }

	if (qlang == NULL || *qlang == '\0') rlang = DpsVarListFindStr(&query->Vars, "g-lc", NULL);
	else rlang = qlang;

#ifdef HAVE_ASPELL
	if (use_aspellext) {
	  aspell_config_replace(query->aspell_config, "lang", (rlang != NULL) ? rlang : "en");

	  ret = new_aspell_speller(query->aspell_config);
	  if (aspell_error(ret) != 0) {
	    DpsLog(query, DPS_LOG_ERROR, "aspell error: %s", aspell_error_message(ret));
	    delete_aspell_can_have_error(ret);
	    use_aspellext = 0;
	  } else {
	    DpsDSTRInit(&suggest, 1024);
	    speller = to_aspell_speller(ret);
	  }
	}
#endif
	
	switch(search_mode) {
	case DPS_MODE_ANY:  add_cmd = DPS_STACK_OR;   break;
	case DPS_MODE_BOOL:
	case DPS_MODE_ALL:  add_cmd = DPS_STACK_AND;  break;
	case DPS_MODE_NEAR: add_cmd = DPS_STACK_NEAR; break;
	}

	DpsWideWordListFree(&Res->WWList);
				  
	if ((wrd = (char*)DpsMalloc(query->WordParam.max_word_len * 12 + 1)) == NULL) {
#ifdef HAVE_ASPELL
	  DpsDSTRFree(&suggest); 
#endif
	  TRACE_OUT(query);
	  return 0; 
	}
	if ((uwrd = (dpsunicode_t*)DpsMalloc(sizeof(dpsunicode_t) * (query->WordParam.max_word_len + 1))) == NULL) { 
	  DPS_FREE(wrd); 
#ifdef HAVE_ASPELL
	  DpsDSTRFree(&suggest); 
#endif
	  TRACE_OUT(query);
	  return 0; 
	}


	if (!(browser_cs = query->Conf->bcs)) {
		browser_cs = DpsGetCharSet("iso-8859-1");
	}
	
	if (!(sys_int = DpsGetCharSet("sys-int"))) {
	        DPS_FREE(uwrd); DPS_FREE(wrd);
#ifdef HAVE_ASPELL
		DpsDSTRFree(&suggest); 
#endif
		TRACE_OUT(query);
		return 0;
	}

	DpsConvInit(&bc_uni, browser_cs, sys_int, query->Conf->CharsToEscape, DPS_RECODE_HTML);
	
	llen = 14 * dps_strlen(txt) + 1;
	ustr = (dpsunicode_t*)(DpsMalloc(sizeof(dpsunicode_t) * llen));
	if (ustr == NULL) {
	        DPS_FREE(uwrd); DPS_FREE(wrd);
#ifdef HAVE_ASPELL
		DpsDSTRFree(&suggest); 
#endif
		TRACE_OUT(query);
		return 0;
	}
	DpsConv(&bc_uni, (char*)ustr, sizeof(dpsunicode_t) * llen, txt, llen);

	/* Create copy of query, converted into LocalCharset (for DpsTrack) */
	ltxt = (char*)DpsMalloc(llen);
	if (ltxt == NULL) {
	  DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr);
#ifdef HAVE_ASPELL
	  DpsDSTRFree(&suggest); 
#endif
	  TRACE_OUT(query);
	  return 0;
	}
	DpsConv(&query->uni_lc, ltxt, llen, (char*)ustr, sizeof(dpsunicode_t) * llen /*bc_uni.obytes*/);
	ltxt[query->uni_lc.obytes] = '\0';
	DpsLog(query, DPS_LOG_DEBUG, "Prepare query: %s, ltxt:%s", txt, ltxt);
	DpsVarListReplaceStr(&query->Vars, "q", ltxt);  /* "q-lc" was here */
	
	DPS_FREE(ltxt);
	
	/* Parse query and build boolean search stack*/
	DpsUniStrToLower(ustr);
	nfc = DpsUniNormalizeNFC(NULL, ustr);
	DPS_FREE(ustr);
	switch(browser_cs->family) {
	case DPS_CHARSET_CHINESE_SIMPLIFIED:
	case DPS_CHARSET_CHINESE_TRADITIONAL: lang = "zh"; break;
	case DPS_CHARSET_JAPANESE: lang = "ja"; break;
	case DPS_CHARSET_THAI: lang = "th"; break;
	case DPS_CHARSET_KOREAN: lang = "ko"; break;
	case DPS_CHARSET_UNICODE: lang = (qlang == NULL) ? "" : qlang; break;
	default: lang = (qlang == NULL) ? "" : qlang;
	}

	DpsLog(query, DPS_LOG_EXTRA, "Segment lang: %s", lang);

	ustr = nfc;
/*	ustr = DpsUniSegment(query, nfc, lang);*/

	lex = (ustr != NULL) ? DpsUniGetSepToken(ustr, &lt , &ctype, &have_bukva_forte) : NULL;
	while(lex){
	  wlen = lt - lex;
	  dps_memmove(uwrd, lex, (dps_min(wlen, query->WordParam.max_word_len)) * sizeof(dpsunicode_t));
	  uwrd[dps_min(wlen, query->WordParam.max_word_len)] = 0;
	  DpsConv(&query->uni_lc, wrd, query->WordParam.max_word_len * 12,(char*)uwrd, sizeof(uwrd[0])*(wlen+1));
	  clex = DpsTrim(wrd, " \t\r\n");

	  DpsLog(query, DPS_LOG_DEBUG, "\t\t\twrd {%d}: %s", wlen, wrd);
			
	  if (DPS_UNI_CTYPECLASS(ctype) != DPS_UNI_BUKVA) {
	    size_t ULen = DpsUniLen(uwrd);
	    int cur_cmd;
	      for (i = 0; i < ULen; i++) {
		        switch(uwrd[i]) {
			case '&':
			case '+': cur_cmd = DPS_STACK_AND;  notfirstword = 0; break;
			case '|': cur_cmd = DPS_STACK_OR;  notfirstword = 0; break;
			case '~': cur_cmd = DPS_STACK_NOT; notfirstword = 0; break;
			case '(': cur_cmd = DPS_STACK_LEFT; notfirstword = 0; break;
			case ')': cur_cmd = DPS_STACK_RIGHT; notfirstword = 0; break;
			case '*': cur_cmd = DPS_STACK_ANYWORD; notfirstword = 0; break;
			case '"':
			case '\'': 
			  if (nphrasecmd & 1) { 
			    cur_cmd = DPS_STACK_PHRASE_RIGHT;
			    notfirstword = 1;
			  } else {
			    cur_cmd = DPS_STACK_PHRASE_LEFT;
			    if (notfirstword) {
			      if (DpsAddStackItem(query, Res, add_cmd, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
				DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
				DpsDSTRFree(&suggest); 
#endif
				TRACE_OUT(query);
				return 0;
			      }
			    }
			    notfirstword = 0;
			  }
			  Res->phrase = 1;
			  nphrasecmd++;
			  break;
			default: continue;
			}
			/*if (nphrasecmd & 1) notfirstword = 0;*/
			if (DpsAddStackItem(query, Res, cur_cmd, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			  DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			  DpsDSTRFree(&suggest); 
#endif
			  TRACE_OUT(query);
			  return 0;
			}
	      }
#ifdef HAVE_ASPELL
	      if (*clex != '\0' && use_aspellext) {
		DpsDSTRAppendStrWithSpace(&suggest, wrd);
	      }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "AND") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_AND, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "NEAR") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_NEAR, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "ANYWORD") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_ANYWORD, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "ANY") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_ANYWORD, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "OR") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_OR, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "NOT") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_NOT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else if (!(nphrasecmd & 1) && (strcasecmp(clex, "~") == 0)) {
	    notfirstword = 0;
	    if (DpsAddStackItem(query, Res, DPS_STACK_NOT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
#ifdef HAVE_ASPELL
	    if (use_aspellext) {
	      DpsDSTRAppendStrWithSpace(&suggest, wrd);
	    }
#endif
	  } else {

	    seg_ustr = (dps_need2segment(uwrd)) ? DpsUniSegment(query, DpsUniDup(uwrd), lang) : DpsUniDup(uwrd);

	    seg_lex = (seg_ustr != NULL) ? DpsUniGetSepToken(seg_ustr, &seg_lt , &seg_ctype, &seg_have_bukva_forte) : NULL;

	    while (seg_lex) {
	      if (DPS_UNI_CTYPECLASS(seg_ctype) != DPS_UNI_BUKVA) goto seg_next;
	      seg_wlen = seg_lt - seg_lex;
	      dps_memmove(uwrd, seg_lex, (dps_min(seg_wlen, query->WordParam.max_word_len)) * sizeof(dpsunicode_t));
	      uwrd[dps_min(seg_wlen, query->WordParam.max_word_len)] = 0;
#ifdef HAVE_ASPELL
	      if (use_aspellext && seg_have_bukva_forte && seg_wlen > 2 
		  && (DpsUniStrChr(uwrd, (dpsunicode_t) '&') == NULL)  /* aspell trap workaround */
		  ) {
		register int ii;
		toadd = 1;
		DpsConv(&query->uni_utf, wrd, query->WordParam.max_word_len * 12, (char*)uwrd, sizeof(uwrd[0])*(seg_wlen+1));
		ii = aspell_speller_check(speller, (const char *)wrd, (int)(tlen = dps_strlen(wrd)) + 1);
		if ( ii == 0) {
		  /* aspell trap workaround */
		  int rd[2];    
		  /* Create write and read pipe */
		  if (pipe(rd) == -1){
		    DpsLog(query, DPS_LOG_ERROR, "DpsPrepare: Cannot make a pipe");
		    return DPS_ERROR;
		  }    
		  /* Fork a clild */
		  if ((query->aspell_pid = fork()) == -1) {
		    DpsLog(query, DPS_LOG_ERROR, "Cannot spawn a child");
		    return DPS_ERROR;
		  }
		  if (query->aspell_pid > 0) {
		    /* Parent process */
		    ssize_t rc;
		    char *pwrd;
/*
#ifdef UNIONWAIT
		    union wait status;
#else
		    int status;
#endif
*/
		    close(rd[1]);
		    if ((rc = read(rd[0], &tlen, sizeof(tlen))) == sizeof(tlen)) {
		      
		      pwrd = (char*)DpsMalloc(tlen + 2);
		      if (read(rd[0], pwrd, tlen) == tlen) {
			pwrd[tlen] = '\0';
			DpsConv(&query->utf_lc, wrd, 12 * query->WordParam.max_word_len, pwrd, sizeof(pwrd[0]) * (tlen  + 1));
			DpsDSTRAppendStrWithSpace(&suggest, wrd);
			have_suggest = 1;
			toadd = 0;
		      }
		      DpsFree(pwrd);
		    }
		    close(rd[0]);
		    /* will wait later, after all output will been made */
/*		    while (waitpid(-1, &status, WNOHANG) > 0);*/
		    
		  } else {
		    /* Child process */
		    close(rd[0]);

		    suggestions = aspell_speller_suggest(speller, (const char *)wrd, (int)tlen);
		    elements = aspell_word_list_elements(suggestions);
		    if ((asug = (char*)aspell_string_enumeration_next(elements)) != NULL) {
		      tlen = dps_strlen(asug);
		      write(rd[1], &tlen, sizeof(tlen));
		      write(rd[1], asug, tlen);
		    }
		    delete_aspell_string_enumeration(elements);
		    close(rd[1]);
		    /* wait till killing by parent */
		    while (1) sleep(1); /*exit(0);*/ 
		  }
		}
	      }
#endif
	      DpsConv(&query->uni_lc, wrd, query->WordParam.max_word_len * 12, (char*)uwrd, sizeof(uwrd[0])*(seg_wlen+1));
#ifdef HAVE_ASPELL
	      if (toadd) {
		DpsDSTRAppendStrWithSpace(&suggest, wrd);
	      }
#endif

	      addwrd = 1;
	      ORDER++;

	      if ( notfirstword /*Res->nitems - Res->ncmds > 0*/ /*Res->items[Res->nitems - 1].cmd == DPS_STACK_WORD */) {
		if (DpsAddStackItem(query, Res, add_cmd, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		  DpsDSTRFree(&suggest); 
#endif
		  TRACE_OUT(query);
		  return 0;
		}
	      }

	      notfirstword = 1;
	      wrd_cmd = DPS_WORD_ORIGIN_QUERY;

	      if (DpsAddStackItem(query, Res, DPS_STACK_LEFT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		DpsDSTRFree(&suggest); 
#endif
		TRACE_OUT(query);
		return 0;
	      }

	      if(word_match==DPS_MATCH_FULL){
		/* Check stopword only when full word         */
		/* Substring searches should not exclude them */
		if(DpsStopListFind(&query->Conf->StopWords, uwrd, qlang) ||
		   (query->WordParam.min_word_len > seg_wlen) ||
		   (query->WordParam.max_word_len < seg_wlen)) {

		  wrd_cmd |= DPS_WORD_ORIGIN_STOP;
		}
	      }
	      if(Res->WWList.nuniq >= DPS_MAXWORDPERQUERY-1){
		addwrd = 0;
	      }

	      if(addwrd){
		DPS_WIDEWORD OWord;
		DPS_ACRONYM *first, *last;
				
		if (DpsAddStackItem(query, Res, DPS_STACK_WORD, add_cmd, (size_t)ORDER, wrd_cmd, wrd, uwrd, qlang) != DPS_OK) {
		  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		  DpsDSTRFree(&suggest); 
#endif
		  TRACE_OUT(query);
		  return 0;
		}
		OWord.len = dps_strlen(wrd);
		OWord.order = (size_t)ORDER;
		OWord.count = 0;
		OWord.crcword = DpsStrHash32(wrd);
		OWord.word = wrd;
		OWord.uword = uwrd;
		OWord.ulen = DpsUniLen(uwrd);
		OWord.origin = 0/*DPS_WORD_ORIGIN_QUERY*/;
				
/*		if (wrd_cmd == DPS_WORD_ORIGIN_STOP) Res->items[ORDER].order_origin = DPS_WORD_ORIGIN_STOP;*/
		Res->items[ORDER].order_origin |= wrd_cmd;

		if (DPS_OK != DpsExpandWord(query, Res, &OWord, &ORDER, sp, nphrasecmd, seg_have_bukva_forte, qlang)) {
		  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		  DpsDSTRFree(&suggest); 
#endif
		  TRACE_OUT(query);
		  return 0;
		}

#if 1
		OWord.uword = uwrd;
		if (sp && !(nphrasecmd & 1)&&(first = DpsAcronymListFind(&query->Conf->Acronyms, &OWord, &last)) != NULL) {
		  while(first <= last) {
		    ORDER++;
		    if (DpsAddStackItem(query, Res, DPS_STACK_OR, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		      DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		      DpsDSTRFree(&suggest); 
#endif
		      TRACE_OUT(query);
		      return 0;
		    }
		    if (first->unroll.nwords > 1) {
		      if (DpsAddStackItem(query, Res, DPS_STACK_PHRASE_LEFT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			DpsDSTRFree(&suggest); 
#endif
			TRACE_OUT(query);
			return 0;
		      }
		    }
		    { register size_t z;
		      for (z = 0; z < first->unroll.nwords; z++) {
			if (z) {
			  ORDER++;
			  if (DpsAddStackItem(query, Res, DPS_STACK_AND, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			    DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			    DpsDSTRFree(&suggest); 
#endif
			    TRACE_OUT(query);
			    return 0;
			  }
			}
			if (DpsAddStackItem(query, Res, DPS_STACK_LEFT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			  DpsDSTRFree(&suggest); 
#endif
			  TRACE_OUT(query);
			  return 0;
			}

#if 1
			if (DpsAddStackItem(query, Res, DPS_STACK_WORD, add_cmd, (size_t)ORDER, DPS_WORD_ORIGIN_ACRONYM, 
					    first->unroll.Word[z].word, 
					    first->unroll.Word[z].uword, qlang) != DPS_OK) {
			  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			  DpsDSTRFree(&suggest); 
#endif
			  TRACE_OUT(query);
			  return 0;
			}
			OWord.uword = first->unroll.Word[z].uword;
			OWord.ulen = DpsUniLen(first->unroll.Word[z].uword);
			OWord.origin = DPS_WORD_ORIGIN_ACRONYM;
			if (DPS_OK != DpsExpandWord(query, Res, &OWord, &ORDER, sp, (first->unroll.nwords > 1) ? 1 : 0, 0, qlang)) {
			  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			  DpsDSTRFree(&suggest); 
#endif
			  TRACE_OUT(query);
			  return 0;
			}

#else
			if(DpsStopListFind(&query->Conf->StopWords, first->unroll.Word[z].uword, qlang) ||
			   (query->WordParam.min_word_len > first->unroll.Word[z].ulen) ||
			   (query->WordParam.max_word_len < first->unroll.Word[z].ulen)) {
			  if (DpsAddStackItem(query, Res, DPS_STACK_WORD, add_cmd, (size_t)ORDER, DPS_WORD_ORIGIN_STOP, 
					      first->unroll.Word[z].word, 
					      first->unroll.Word[z].uword, qlang) != DPS_OK) {
			    DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			    DpsDSTRFree(&suggest); 
#endif
			    TRACE_OUT(query);
			    return 0;
			  }
			  Res->items[ORDER].order_origin |= DPS_WORD_ORIGIN_STOP;
			} else {
			  if (DpsAddStackItem(query, Res, DPS_STACK_WORD, add_cmd, (size_t)ORDER, DPS_WORD_ORIGIN_ACRONYM, 
					      first->unroll.Word[z].word, 
					      first->unroll.Word[z].uword, qlang) != DPS_OK) {
			    DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			    DpsDSTRFree(&suggest); 
#endif
			    TRACE_OUT(query);
			    return 0;
			  }
			  OWord.uword = first->unroll.Word[z].uword;
			  OWord.ulen = DpsUniLen(first->unroll.Word[z].uword);
			  OWord.origin = DPS_WORD_ORIGIN_ACRONYM;
			  if (DPS_OK != DpsExpandWord(query, Res, &OWord, &ORDER, sp, (first->unroll.nwords > 1) ? 1 : 0, 0, qlang)) {
			    DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			    DpsDSTRFree(&suggest); 
#endif
			    TRACE_OUT(query);
			    return 0;
			  }
			}
#endif

			if (DpsAddStackItem(query, Res, DPS_STACK_RIGHT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			  DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			  DpsDSTRFree(&suggest); 
#endif
			  TRACE_OUT(query);
			  return 0;
			}
		      }
		    }
		    if (first->unroll.nwords > 1) {
		      if (DpsAddStackItem(query, Res, DPS_STACK_PHRASE_RIGHT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
			DPS_FREE(uwrd); DPS_FREE(wrd);  DPS_FREE(seg_ustr); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
			DpsDSTRFree(&suggest); 
#endif
			TRACE_OUT(query);
			return 0;
		      }
		    }
		    first++;
		  }
		}

#endif

	      }
	      if (DpsAddStackItem(query, Res, DPS_STACK_RIGHT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
		DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
		DpsDSTRFree(&suggest); 
#endif
		TRACE_OUT(query);
		return 0;
	      }
	    seg_next:
	      seg_lex = DpsUniGetSepToken(NULL, &seg_lt, &seg_ctype, &seg_have_bukva_forte);
	    }
	    DPS_FREE(seg_ustr);
	  }
	  lex = DpsUniGetSepToken(NULL, &lt, &ctype, &have_bukva_forte);
	}
	if (nphrasecmd & 1) {
	  if ((Res->nitems > 0) && (Res->items[Res->nitems-1].cmd == DPS_STACK_PHRASE_LEFT)) {
	    Res->nitems--;
	    Res->ncmds--;
	    while ( Res->nitems > 0 && ( (Res->items[Res->nitems-1].cmd == DPS_STACK_AND)
					 || (Res->items[Res->nitems-1].cmd == DPS_STACK_OR)
					 || (Res->items[Res->nitems-1].cmd == DPS_STACK_NOT) ) ) {
	      Res->nitems--;
	      Res->ncmds--;
	    }
	  } else {

	    if (DpsAddStackItem(query, Res, DPS_STACK_PHRASE_RIGHT, add_cmd, 0, 0, NULL, NULL, qlang) != DPS_OK) {
	      DPS_FREE(uwrd); DPS_FREE(wrd); DPS_FREE(ustr); DPS_FREE(Res->items);
#ifdef HAVE_ASPELL
	      DpsDSTRFree(&suggest); 
#endif
	      TRACE_OUT(query);
	      return 0;
	    }
	  }
	}
	Res->orig_nitems = Res->nitems;

/******************************************************/

	DPS_FREE(ustr); DPS_FREE(uwrd); DPS_FREE(wrd);
#ifdef HAVE_ASPELL
	if (use_aspellext) {
	  delete_aspell_speller(speller);
	  if (have_suggest) {
	    DPS_FREE(Res->Suggest);
	    Res->Suggest = suggest.data;
	    Res->Suggest[suggest.data_size] = '\0';
	    Res->Suggest = DpsStrdup(suggest.data);
	  }
	  DpsDSTRFree(&suggest); 
	}
#endif
	Res->prepared = 1;
	TRACE_OUT(query);
	return(0);
}


#define DPS_N_DISTANCE 0
#define DPS_N_COUNT    1
#ifdef WITH_REL_DISTANCE
#define DPS_N_POSITION 2
#else
#define DPS_N_POSITION 1
#endif

#ifdef WITH_REL_POSITION
#define DPS_N_WRDCOUNT (DPS_N_POSITION + 1)
#else
#define DPS_N_WRDCOUNT DPS_N_POSITION
#endif

#ifdef WITH_REL_WRDCOUNT
#define DPS_N_ADD (DPS_N_WRDCOUNT + 1)
#else
#define DPS_N_ADD DPS_N_WRDCOUNT
#endif


#define WF_ADD(sec)    (wf[(sec)] << (4 + 4 * (((sec) - 1) % 6)))

static unsigned DpsBitCntTable[256] = {
 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
};

static inline int DpsBitsCount(dps_uint4 x) {
  return DpsBitCntTable[ x & 0xFF] + DpsBitCntTable[(x >> 8) & 0xFF] + DpsBitCntTable[(x >> 16) & 0xFF] + DpsBitCntTable[(x >> 24) & 0xFF]; 
}


static inline dps_uint4 DpsCalcCosineWeightFull(dps_uint4 *R, double x, double xy, dps_uint4 *D) {
  register double y = 0.0;

#ifdef WITH_REL_WRDCOUNT
  if (D[DPS_N_WRDCOUNT] > R[DPS_N_WRDCOUNT]) {
    y += DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT],
	    DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]) );*/
  } else {
    y += DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT], 
	    DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]));*/
  }
  y += DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]);
/*  fprintf(stderr, "UNICNT:: R: %d  D: %f -- %f\n", R[DPS_N_COUNT], (double)D[DPS_N_COUNT], 
	  DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]));*/
#endif


#ifdef WITH_REL_POSITION
  if (D[DPS_N_POSITION] > R[DPS_N_POSITION]) {
    y += DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) ));*/
  } else {
    y += DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) ));*/
  }
#endif

#ifdef WITH_REL_DISTANCE
  if (D[DPS_N_DISTANCE] > R[DPS_N_DISTANCE]) {
    y += DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]));*/
  } else {
    y += DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]));*/
  }
#endif

/*  fprintf(stderr, "2. x:%lf  xy:%lf  y:%lf {xy /(x + y):%lf}\n\n", 
	  x, xy, y, xy / (x + y) );*/

    return 100000.0 * xy / (x + y) + 1;

/*  fprintf(stderr, "2. x:%.0lf  xy:%.0lf  y:%lf {0.5*(x + xy) / (x + y):%lf}\n\n", 
	  x, xy, y, 0.5 * (x + xy) / (x + y) );*/

/*  return 50000.0 * (x + xy) / (x + y) + 1;*/

}

static inline dps_uint4 DpsCalcCosineWeightFast(dps_uint4 *R, double x, dps_uint4 *D, size_t nw) {
  register double y = 0.0;
  register size_t i;
  register double xy = 0.0;

  for (i = 0; i < nw; i++) {
    xy += DpsBitsCount(R[DPS_N_ADD + i] ^ D[DPS_N_ADD + i]);
  }

  if (xy >= x) return (dps_uint4)1;

#ifdef WITH_REL_WRDCOUNT
  if (D[DPS_N_WRDCOUNT] > R[DPS_N_WRDCOUNT]) {
    y += DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT],
	    DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]) );*/
  } else {
    y += DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT], 
	    DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]));*/
  }
  y += DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]);
/*  fprintf(stderr, "UNICNT:: R: %d  D: %f -- %f\n", R[DPS_N_COUNT], (double)D[DPS_N_COUNT], 
	  DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]));*/
#endif


#ifdef WITH_REL_POSITION
  if (D[DPS_N_POSITION] > R[DPS_N_POSITION]) {
    y += DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) ));*/
  } else {
    y += DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) ));*/
  }
#endif

#ifdef WITH_REL_DISTANCE
  if (D[DPS_N_DISTANCE] > R[DPS_N_DISTANCE]) {
    y += DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]));*/
  } else {
    y += DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]));*/
  }
#endif

/*  fprintf(stderr, "2. x:%.0lf  xy:%.0lf  y:%lf {(x - xy) / (x + y):%lf}\n\n", 
	  x, xy, y, (x - xy) / (x + y) );*/

  return 100000.0 * (x - xy) / (x + y) + 1;
  
}


static inline dps_uint4 DpsCalcCosineWeightUltra(dps_uint4 *R, double x, double xy, dps_uint4 *D, size_t ns, size_t phr_n) {
  register double y = 1.0;

#ifdef WITH_REL_WRDCOUNT
#if 1
  y += DPS_WRD_CNT_FACTOR * (double)D[DPS_N_WRDCOUNT];
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT],
	    DPS_WRD_CNT_FACTOR * (double) D[DPS_N_WRDCOUNT] );*/
#else
  if (D[DPS_N_WRDCOUNT] > R[DPS_N_WRDCOUNT]) {
    y += DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT],
	    DPS_WRD_CNT_FACTOR * (double) (D[DPS_N_WRDCOUNT] - R[DPS_N_WRDCOUNT]) );*/
  } else {
    y += DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]);
/*    fprintf(stderr, "WRDCNT:: R: %d  D: %d -- %f\n", R[DPS_N_WRDCOUNT], D[DPS_N_WRDCOUNT], 
	    DPS_WRD_CNT_FACTOR * (double) (R[DPS_N_WRDCOUNT] - D[DPS_N_WRDCOUNT]));*/
  }
#endif
  y += DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]);
/*  fprintf(stderr, "UNICNT:: R: %d  D: %f -- %f\n", R[DPS_N_COUNT], (double)D[DPS_N_COUNT], 
	  DPS_UNICNT_FACTOR * ((double) D[DPS_N_COUNT]));*/
#endif


#ifdef WITH_REL_POSITION
  if (D[DPS_N_POSITION] > R[DPS_N_POSITION]) {
    y += DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((D[DPS_N_POSITION] - R[DPS_N_POSITION]) ));*/
  } else {
    y += DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) );
/*    fprintf(stderr, "POS:: R: %d  D: %d -- %f\n", R[DPS_N_POSITION], D[DPS_N_POSITION], 
	    DPS_POSITION_FACTOR * (double) ((R[DPS_N_POSITION] - D[DPS_N_POSITION]) ));*/
  }
#endif

#ifdef WITH_REL_DISTANCE
  if (D[DPS_N_DISTANCE] > R[DPS_N_DISTANCE]) {
    y += DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (D[DPS_N_DISTANCE] - R[DPS_N_DISTANCE]));*/
  } else {
    y += DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]);
/*    fprintf(stderr, "DIST:: R: %d  D: %d -- %f\n", R[DPS_N_DISTANCE], D[DPS_N_DISTANCE], 
	    DPS_DISTANCE_FACTOR * (double) (R[DPS_N_DISTANCE] - D[DPS_N_DISTANCE]));*/
  }
#endif

/*  fprintf(stderr, "2. x:%lf  xy:%lf  y:%lf {xy /(x + y):%lf}\n\n", 
	  x, xy, log(y), xy / (x + log(y)) );*/
/*  fprintf(stderr, "2. x:%lx  xy:%lx  y:%lf {xy /(x + y):%lf}\n\n", 
	  (long)x, (long)xy, y, xy / (x + y) );*/

  return 100000.0 * xy / (x + log(y)) + 1;
  
}


static int DpsOriginWeightFull(int origin) {  /* Weight for origin can be from 1 to 15 */
  if (origin & DPS_WORD_ORIGIN_ASPELL)  return 0x10;
  if (origin & DPS_WORD_ORIGIN_SYNONYM) return 0x20;
  if (origin & DPS_WORD_ORIGIN_ACRONYM) return 0x20;
  if (origin & DPS_WORD_ORIGIN_SPELL)   return 0x40;
  if (origin & DPS_WORD_ORIGIN_ACCENT)  return 0x80;
  if (origin & DPS_WORD_ORIGIN_QUERY)   return 0x90;
  if (origin & DPS_WORD_ORIGIN_COMMON)  return 0xF0;
  return 0;
}

static int DpsOriginWeightFast(int origin) {  /* Weight for origin can be from 1 to 15 */
  if (origin & DPS_WORD_ORIGIN_ASPELL)  return 0x1;
  if (origin & DPS_WORD_ORIGIN_SYNONYM) return 0x5;
  if (origin & DPS_WORD_ORIGIN_SPELL)   return 0xB;
  if (origin & DPS_WORD_ORIGIN_ACRONYM) return 0x3;
  if (origin & DPS_WORD_ORIGIN_ACCENT)  return 0xA;
  if (origin & DPS_WORD_ORIGIN_QUERY)   return 0xE;
  return 0;
}

static int DpsOriginWeightUltra(int origin) {  /* Weight for origin can be from 1 to 15 */
  if (origin & DPS_WORD_ORIGIN_ASPELL)  return 0x010;
  if (origin & DPS_WORD_ORIGIN_SYNONYM) return 0x050;
  if (origin & DPS_WORD_ORIGIN_ACRONYM) return 0x050;
  if (origin & DPS_WORD_ORIGIN_ACCENT)  return 0x330;
  if (origin & DPS_WORD_ORIGIN_SPELL)   return 0x170;
  if (origin & DPS_WORD_ORIGIN_QUERY)   return 0x7C0;
  if (origin & DPS_WORD_ORIGIN_COMMON)  return 0x7F0;
  return 0;
}

#define DPS_DISTANCE_INIT 150

static void DpsGroupByURLFull(DPS_AGENT *query, DPS_RESULT *Res) {
  size_t	i, j = 0, D_size, R_size, phr_n;
  size_t  *count, count_size;
  size_t wordsec, wordpos, prev_wordpos, wordnum, prev_wordnum;
  DPS_URL_CRD *Crd;
  size_t nsections = DpsVarListFindInt(&query->Vars, "NumSections", 256);
  int wf[256];
  dps_uint4 *R, *D;
  double Rbc;
  register double xy;

  TRACE_IN(query, "DpsGroupByURLFull");

  DpsLog(query, DPS_LOG_DEBUG, "max_order: %d", Res->max_order);

  if (DPS_OK != DpsCalcBoolItems(query, Res)) {TRACE_OUT(query); return; }
  if(!Res->CoordList.ncoords || Res->nitems == 0) {TRACE_OUT(query); return; }

  Crd = Res->CoordList.Coords;
  count_size = (Res->max_order + 1) * sizeof(size_t);

  if ((count = (size_t*)DpsXmalloc(count_size + 1)) == NULL) {TRACE_OUT(query); return; }

  DpsWeightFactorsInit(DpsVarListFindStr(&query->Vars, "wf", ""), wf);

  D_size = (1 + Res->WWList.nwords * 256 + DPS_N_ADD) * sizeof(dps_uint4);
  R_size = (1 + DPS_N_ADD) * sizeof(dps_uint4);
  if ((R = (dps_uint4*)DpsXmalloc(R_size)) == NULL) {
    DPS_FREE(count);
    TRACE_OUT(query);
    return;
  }
  if ((D = (dps_uint4*)DpsXmalloc(D_size)) == NULL) {
    DPS_FREE(count); DPS_FREE(R);
    TRACE_OUT(query);
    return;
  }

#ifdef WITH_REL_DISTANCE
  R[DPS_N_DISTANCE] = 1; /*Res->WWList.nuniq;*/ /*(Res->WWList.nuniq == 1) ? 1 : 2;*/ /* Res->WWList.nuniq - 1;*/ /* was: 0 */
#endif
#ifdef WITH_REL_POSITION
  R[DPS_N_POSITION] = DPS_BEST_POSITION;
#endif
#ifdef WITH_REL_WRDCOUNT
  R[DPS_N_WRDCOUNT] = DPS_BEST_WRD_CNT * (Res->max_order + 1);
#endif
  R[DPS_N_COUNT] = 0;

  wordnum = DPS_WRDNUM(Crd[0].coord);
  wordsec = DPS_WRDSEC(Crd[0].coord);
  wordpos = DPS_WRDPOS(Crd[0].coord);

  Rbc = (double)0.0;

  for (j = 0; j < nsections; j++)
    if (wf[j])
      for(i = 0; i < Res->WWList.nwords; i++) {
	Rbc += (double)( (/*0xF*/ wf[j] | DpsOriginWeightFull(Res->WWList.Word[i].origin)));
      }

  D[DPS_N_ADD + 256 * wordnum + wordsec] = /*1;*/
  xy = (wf[wordsec] | DpsOriginWeightFull(Res->WWList.Word[wordnum].origin));

/**********************************************/

#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
  D[DPS_N_POSITION] =  wordpos; /*1000*//*DPS_BEST_AVG_POSITION * Res->WWList.nwords*/ /* + */
#endif
  count[wordnum]++;
  phr_n = 1;
  j = 0;

  for(i = 1; i < Res->CoordList.ncoords; i++) {
    /* Group by url_id */
    prev_wordpos = wordpos;
    prev_wordnum = wordnum;
    wordnum = DPS_WRDNUM(Crd[i].coord);
    wordsec = DPS_WRDSEC(Crd[i].coord);
    wordpos = DPS_WRDPOS(Crd[i].coord);

/*    fprintf(stderr, "wordnum:%d  wordsec:%d  wordpos:%d  WeightFul:%x\n", wordnum, wordsec, wordpos,
	   DpsOriginWeightFull(Res->WWList.Word[wordnum].origin) );*/

    if(Crd[j].url_id == Crd[i].url_id) {
      /* Same document */
#if 1
      register int a = (wf[wordsec] | DpsOriginWeightFull(Res->WWList.Word[wordnum].origin));
      xy += (~D[DPS_N_ADD + 256 * wordnum + wordsec] & a);
/*      fprintf(stderr, "a: %x  D: %x  f: %x\n", a, D[DPS_N_ADD + 256 * wordnum + wordsec], ~D[DPS_N_ADD + 256 * wordnum + wordsec] & a);*/
      D[DPS_N_ADD + 256 * wordnum + wordsec] |= a;
/*      fprintf(stderr, "a: %x  D: %x\n\n", a, D[DPS_N_ADD + 256 * wordnum + wordsec]);*/
#else
      if (D[DPS_N_ADD + 256 * wordnum + wordsec] == 0) {
	D[DPS_N_ADD + 256 * wordnum + wordsec] = 1;
	xy += (double)(wf[wordsec] | DpsOriginWeightFull(Res->WWList.Word[wordnum].origin));
      }
#endif

      phr_n++;
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] += wordpos;*/
#endif
#ifdef WITH_REL_DISTANCE
/*	    D[DPS_N_DISTANCE] += (wordnum == prev_wordnum + 1) ? (wordpos - prev_wordpos) : (1000 + wordpos - prev_wordpos);*/
      D[DPS_N_DISTANCE] += (wordpos - prev_wordpos);
#endif
      count[wordnum]++;

    } else {
      /* Next document */

#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] /= phr_n;*/
#endif
#ifdef WITH_REL_WRDCOUNT
      D[DPS_N_WRDCOUNT] = phr_n;

      { register size_t tt;
	register size_t median = phr_n / (Res->max_order + 1), sum = 0;
	for (tt = 0; tt <= Res->max_order; tt++) {
	  sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
	}
	D[DPS_N_COUNT] = (dps_uint4)sum;
      }
#endif
/*	    fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/
      Crd[j].coord = DpsCalcCosineWeightFull(R, Rbc, xy, D);
      j++;

      Crd[j] = Crd[i];

      bzero((void*)D, D_size);
      bzero((void*)count, count_size);
      phr_n = 1;
#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
      D[DPS_N_POSITION] =  wordpos;
#endif
      count[wordnum] = 1;
/*	    count[Res->WWList.Word[wordnum].order]++;*/
      D[DPS_N_ADD + 256 * wordnum + wordsec] = /*1;*/
      xy = (wf[wordsec] | DpsOriginWeightFull(Res->WWList.Word[wordnum].origin));
    }
  }
  
  /* Check last word */
#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
/*  D[DPS_N_POSITION] /= phr_n;*/
#endif
#ifdef WITH_REL_WRDCOUNT
  D[DPS_N_WRDCOUNT] = phr_n;

  { register size_t tt;
    register size_t median = phr_n / (Res->max_order + 1), sum = 0;
    for (tt = 0; tt <= Res->max_order; tt++) {
      sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
    }
    D[DPS_N_COUNT] = (dps_uint4)sum;
  }
#endif
	
  Res->CoordList.ncoords = j + 1;
/*	fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/
	
  Crd[j].coord = DpsCalcCosineWeightFull(R, Rbc, xy, D);

  DPS_FREE(D);
  DPS_FREE(R);
  DPS_FREE(count);
  TRACE_OUT(query);
  return;
}

static void DpsGroupByURLFast(DPS_AGENT *query, DPS_RESULT *Res) {
  size_t	i, j = 0, D_size, R_size, phr_n;
  size_t  *count, count_size;
  size_t wordsec, wordpos, prev_wordpos, wordnum, prev_wordnum;
  DPS_URL_CRD *Crd;
  size_t nsections = DpsVarListFindInt(&query->Vars, "NumSections", 256);
  int wf[256];
  dps_uint4 *R, *D;
  double Rbc;

  TRACE_IN(query, "DpsGroupByURLFast");

  DpsLog(query, DPS_LOG_DEBUG, "max_order: %d", Res->max_order);

  if (DPS_OK != DpsCalcBoolItems(query, Res)) {TRACE_OUT(query); return; }
  if(!Res->CoordList.ncoords || Res->nitems == 0) {TRACE_OUT(query); return; }

  Crd = Res->CoordList.Coords;
  count_size = (Res->max_order + 1) * sizeof(size_t);

  if ((count = (size_t*)DpsXmalloc(count_size + 1)) == NULL) {TRACE_OUT(query); return; }

  DpsWeightFactorsInit(DpsVarListFindStr(&query->Vars, "wf", ""), wf);

  D_size = (1 + Res->WWList.nwords + DPS_N_ADD) * sizeof(dps_uint4);
  R_size = (1 + Res->WWList.nwords + DPS_N_ADD) * sizeof(dps_uint4);
  if ((R = (dps_uint4*)DpsXmalloc(R_size)) == NULL) {
    DPS_FREE(count);
    TRACE_OUT(query);
    return;
  }
  if ((D = (dps_uint4*)DpsXmalloc(D_size)) == NULL) {
    DPS_FREE(count); DPS_FREE(R);
    TRACE_OUT(query);
    return;
  }

#ifdef WITH_REL_DISTANCE
  R[DPS_N_DISTANCE] = 1; /*Res->WWList.nuniq;*/ /*(Res->WWList.nuniq == 1) ? 1 : 2;*/ /* Res->WWList.nuniq - 1;*/ /* was: 0 */
#endif
#ifdef WITH_REL_POSITION
  R[DPS_N_POSITION] = DPS_BEST_POSITION;
#endif
#ifdef WITH_REL_WRDCOUNT
  R[DPS_N_WRDCOUNT] = DPS_BEST_WRD_CNT * (Res->max_order + 1);
#endif
  R[DPS_N_COUNT] = 0;

  wordnum = DPS_WRDNUM(Crd[0].coord);
  wordsec = DPS_WRDSEC(Crd[0].coord);
  wordpos = DPS_WRDPOS(Crd[0].coord);

  Rbc = (double)0.0;

  for(i = 0; i < Res->WWList.nwords; i++) {
    for (j = 0; j < nsections; j++) {
      R[DPS_N_ADD + i] |= WF_ADD(j);
    }
    R[DPS_N_ADD + i] |= 0xF; 
    Rbc += DpsBitsCount(R[DPS_N_ADD + i]);
/*    Rbc += 32.0;*/
  }
		
  D[DPS_N_ADD + wordnum] |= (WF_ADD(wordsec) | DpsOriginWeightFast(Res->WWList.Word[wordnum].origin));

/**********************************************/

#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
  D[DPS_N_POSITION] =  wordpos; /*1000*//*DPS_BEST_AVG_POSITION * Res->WWList.nwords*/ /* + */
#endif
  count[wordnum]++;
  phr_n = 1;
  j = 0;

  for(i = 1; i < Res->CoordList.ncoords; i++) {
    /* Group by url_id */
    prev_wordpos = wordpos;
    prev_wordnum = wordnum;
    wordnum = DPS_WRDNUM(Crd[i].coord);
    wordsec = DPS_WRDSEC(Crd[i].coord);
    wordpos = DPS_WRDPOS(Crd[i].coord);

/*	  fprintf(stderr, "wordnum:%d  wordsec:%d  wordpos:%d\n", wordnum, wordsec, wordpos);*/

    if(Crd[j].url_id == Crd[i].url_id) {
      /* Same document */
      D[DPS_N_ADD + wordnum] |= (WF_ADD(wordsec) | DpsOriginWeightFast(Res->WWList.Word[wordnum].origin));

      phr_n++;
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] += wordpos;*/
#endif
#ifdef WITH_REL_DISTANCE
/*	    D[DPS_N_DISTANCE] += (wordnum == prev_wordnum + 1) ? (wordpos - prev_wordpos) : (1000 + wordpos - prev_wordpos);*/
      D[DPS_N_DISTANCE] += (wordpos - prev_wordpos);
#endif
      count[wordnum]++;

    } else {
      /* Next document */

#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] /= phr_n;*/
#endif
#ifdef WITH_REL_WRDCOUNT
      D[DPS_N_WRDCOUNT] = phr_n;

      { register size_t tt;
	register size_t median = ((double)phr_n) / (Res->max_order + 1), sum = 0;
	for (tt = 0; tt <= Res->max_order; tt++) {
	  sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
	}
	D[DPS_N_COUNT] = (dps_uint4)sum;
      }

#endif
/*	    fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/
      Crd[j].coord = DpsCalcCosineWeightFast(R, Rbc, D, Res->WWList.nwords);
      j++;

      Crd[j] = Crd[i];

      bzero((void*)D, D_size);
      bzero((void*)count, count_size);
      phr_n = 1;
#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
      D[DPS_N_POSITION] =  wordpos;
#endif
      count[wordnum] = 1;
/*	    count[Res->WWList.Word[wordnum].order]++;*/
      D[DPS_N_ADD + wordnum] = (WF_ADD(wordsec) | DpsOriginWeightFast(Res->WWList.Word[wordnum].origin));
    }
  }

	/* Check last word */
#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
  D[DPS_N_POSITION] /= phr_n;
#endif
#ifdef WITH_REL_WRDCOUNT
  D[DPS_N_WRDCOUNT] = phr_n;

  { register size_t tt;
    register size_t median = ((double)phr_n) / (Res->max_order + 1), sum = 0;
    for (tt = 0; tt <= Res->max_order; tt++) {
      sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
    }
    D[DPS_N_COUNT] = (dps_uint4)sum;
  }
#endif
	
  Res->CoordList.ncoords = j + 1;
/*	fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/
	
  Crd[j].coord = DpsCalcCosineWeightFast(R, Rbc, D, Res->WWList.nwords);

  DPS_FREE(D);
  DPS_FREE(R);
  DPS_FREE(count);
  TRACE_OUT(query);
  return;
}


static void DpsGroupByURLUltra(DPS_AGENT *query, DPS_RESULT *Res) {
  size_t	i, j = 0, D_size, R_size, phr_n;
  size_t  *count, count_size;
  size_t wordsec, wordpos, prev_wordpos, wordnum, prev_wordnum;
  DPS_URL_CRD *Crd;
  size_t nsections = (size_t)DpsVarListFindInt(&query->Vars, "NumSections", 256);
  int wf[256], xy_w;
  dps_uint4 *R, *D;
  double Rbc;
  register double xy, WFsections = 0.0;

  TRACE_IN(query, "DpsGroupByURLUltra");
  
  DpsLog(query, DPS_LOG_DEBUG, "max_order: %d", Res->max_order);

  if (DPS_OK != DpsCalcBoolItems(query, Res)) {TRACE_OUT(query); return; }
  if(!Res->CoordList.ncoords || Res->nitems == 0) {TRACE_OUT(query); return; }

  Crd = Res->CoordList.Coords;
  count_size = (Res->max_order + 1) * sizeof(size_t);

  if ((count = (size_t*)DpsXmalloc(count_size + 1)) == NULL) {TRACE_OUT(query); return; }

  DpsWeightFactorsInit(DpsVarListFindStr(&query->Vars, "wf", ""), wf);

  D_size = (2 + nsections + Res->max_order + DPS_N_ADD) * sizeof(dps_uint4);
  R_size = (1 + DPS_N_ADD) * sizeof(dps_uint4);
  if ((R = (dps_uint4*)DpsXmalloc(R_size)) == NULL) {
    DPS_FREE(count);
    TRACE_OUT(query);
    return;
  }
  if ((D = (dps_uint4*)DpsXmalloc(D_size)) == NULL) {
    DPS_FREE(count); DPS_FREE(R);
    TRACE_OUT(query);
    return;
  }
  { register size_t tt;
    for (tt = 0; tt < nsections; tt++) WFsections += wf[tt];
  }

#ifdef WITH_REL_DISTANCE
  R[DPS_N_DISTANCE] = 1; /*Res->WWList.nuniq;*/ /*(Res->WWList.nuniq == 1) ? 1 : 2;*/ /* Res->WWList.nuniq - 1;*/ /* was: 0 */
#endif
#ifdef WITH_REL_POSITION
  R[DPS_N_POSITION] = DPS_BEST_POSITION;
#endif
#ifdef WITH_REL_WRDCOUNT
  R[DPS_N_WRDCOUNT] = DPS_BEST_WRD_CNT * (Res->max_order + 1);
#endif
  R[DPS_N_COUNT] = 0;

  wordnum = DPS_WRDNUM(Crd[0].coord);
  wordsec = DPS_WRDSEC(Crd[0].coord);
  wordpos = DPS_WRDPOS(Crd[0].coord);

  Rbc =  1.0/*(double)(DpsOriginWeightUltra(DPS_WORD_ORIGIN_COMMON) | 0xF)*/;

  /*if (DPS_WORD_ORIGIN_QUERY & Res->WWList.Word[wordnum].origin)*/ D[DPS_N_ADD + wordsec]=1;
  xy = (double)(wf[wordsec]);
  xy_w = D[DPS_N_ADD + nsections + wordnum] = DpsOriginWeightUltra(Res->WWList.Word[wordnum].origin);

/**********************************************/

#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
  D[DPS_N_POSITION] =  wordpos; /*1000*//*DPS_BEST_AVG_POSITION * Res->WWList.nwords*/ /* + */
#endif
  D[DPS_N_ADD + wordsec] = 1;
  count[wordnum]++;
  phr_n = 1;
  j = 0;

  for(i = 1; i < Res->CoordList.ncoords; i++) {
    /* Group by url_id */
    prev_wordpos = wordpos;
    prev_wordnum = wordnum;
    wordnum = DPS_WRDNUM(Crd[i].coord);
    wordsec = DPS_WRDSEC(Crd[i].coord);
    wordpos = DPS_WRDPOS(Crd[i].coord);
    
/*	  fprintf(stderr, "wordnum:%d  wordsec:%d  wordpos:%d\n", wordnum, wordsec, wordpos);*/

    if(Crd[j].url_id == Crd[i].url_id) {
      /* Same document */
      /*if (DPS_WORD_ORIGIN_QUERY & Res->WWList.Word[wordnum].origin)*/ D[DPS_N_ADD + wordsec] = 1;
      xy += (double)(wf[wordsec]);
      xy_w |= DpsOriginWeightUltra(Res->WWList.Word[wordnum].origin);
      D[DPS_N_ADD + nsections + wordnum] += DpsOriginWeightUltra(Res->WWList.Word[wordnum].origin);

      phr_n++;
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] += wordpos;*/
#endif
#ifdef WITH_REL_DISTANCE
/*	    D[DPS_N_DISTANCE] += (wordnum == prev_wordnum + 1) ? (wordpos - prev_wordpos) : (1000 + wordpos - prev_wordpos);*/
      D[DPS_N_DISTANCE] += (wordpos - prev_wordpos);
#endif
      count[wordnum]++;

    } else {
      /* Next document */

#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
/*	    D[DPS_N_POSITION] /= phr_n;*/
#endif

      xy /= phr_n * 0xF;
      xy *= xy_w;
      xy /= DpsOriginWeightUltra(DPS_WORD_ORIGIN_COMMON);

#ifdef WITH_REL_WRDCOUNT
      D[DPS_N_WRDCOUNT] = 0/*phr_n*/;
#endif

      { register size_t tt, cc = 0;
#ifdef WITH_REL_WRDCOUNT
	register size_t median = ((double)phr_n) / (Res->max_order + 1), sum = 0;
#endif
	for (tt = 0; tt <= Res->max_order; tt++) {
	  if (count[tt]) cc += D[DPS_N_ADD + nsections + tt] / count[tt];
#ifdef WITH_REL_WRDCOUNT
	  sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
	  D[DPS_N_WRDCOUNT] += ((count[tt] > DPS_BEST_WRD_CNT) ? (count[tt] - DPS_BEST_WRD_CNT) : (DPS_BEST_WRD_CNT - count[tt]));
#endif
	}
#ifdef WITH_REL_WRDCOUNT
	D[DPS_N_COUNT] = (dps_uint4)sum;
#endif
	xy *= cc;
	xy /= (Res->max_order + 1) * DpsOriginWeightUltra(DPS_WORD_ORIGIN_QUERY);
      }

/*	    fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/

      { register size_t tt, cc = 1;
	for (tt = 0; tt < nsections; tt++) if (D[DPS_N_ADD + tt]) cc += wf[tt];
	xy *= cc;
	xy /= WFsections;
      }

      Crd[j].coord = DpsCalcCosineWeightUltra(R, Rbc, xy, D, nsections, phr_n);
      j++;

      Crd[j] = Crd[i];

      bzero((void*)D, D_size);
      bzero((void*)count, count_size);
      phr_n = 1;
#ifdef WITH_REL_DISTANCE
      D[DPS_N_DISTANCE] = DPS_DISTANCE_INIT;
#endif
#ifdef WITH_REL_POSITION
      D[DPS_N_POSITION] =  wordpos;
#endif
      count[wordnum] = 1;
/*	    count[Res->WWList.Word[wordnum].order]++;*/
      /*if (DPS_WORD_ORIGIN_QUERY & Res->WWList.Word[wordnum].origin)*/ D[DPS_N_ADD + wordsec] = 1;
      xy = (double)(wf[wordsec]);
      xy_w = D[DPS_N_ADD + nsections + wordnum] = DpsOriginWeightUltra(Res->WWList.Word[wordnum].origin);
    }
  }

	/* Check last word */
#ifdef WITH_REL_DISTANCE
  D[DPS_N_DISTANCE] /= phr_n;
#endif
#ifdef WITH_REL_POSITION
  D[DPS_N_POSITION] /= phr_n;
#endif
#ifdef WITH_REL_WRDCOUNT
  D[DPS_N_WRDCOUNT] = phr_n;
#endif

  xy /= phr_n * 0xF;
  xy *= xy_w;
  xy /= DpsOriginWeightUltra(DPS_WORD_ORIGIN_COMMON);

  { register size_t tt, cc = 0;
#ifdef WITH_REL_WRDCOUNT
    register size_t median = ((double)phr_n) / (Res->max_order + 1), sum = 0;
#endif
    for (tt = 0; tt <= Res->max_order; tt++) {
      if (count[tt]) cc += D[DPS_N_ADD + nsections + tt] / count[tt];
#ifdef WITH_REL_WRDCOUNT
      sum += ((count[tt] > median) ? (count[tt] - median) : (median - count[tt]));
#endif
    }
    D[DPS_N_COUNT] = (dps_uint4)sum;
    xy *= cc;
    xy /= ((Res->max_order + 1) * DpsOriginWeightUltra(DPS_WORD_ORIGIN_QUERY));
  }
	
  Res->CoordList.ncoords = j + 1;
/*	fprintf(stderr, "** URL_ID: %d [phr_n:%d]\n", Crd[j].url_id, phr_n);*/
	
  { register size_t tt, cc = 1;
    for (tt = 0; tt < nsections; tt++) if (D[DPS_N_ADD + tt]) cc += wf[tt];
    xy *= cc;
    xy /= WFsections;
  }

  Crd[j].coord = DpsCalcCosineWeightUltra(R, Rbc, xy, D, nsections, phr_n);

  DPS_FREE(D);
  DPS_FREE(R);
  DPS_FREE(count);
  TRACE_OUT(query);
  return;
}

void DpsGroupByURL(DPS_AGENT *query, DPS_RESULT *Res) {
  int rm = DpsVarListFindInt(&query->Vars, "rm", 
#ifdef FAST_RELEVANCE
			     1
#elif defined FULL_RELEVANCE
			     2
#else
			     3
#endif
			     );

  switch(rm) {
  case 1: DpsGroupByURLFast(query, Res); break;
  case 2: DpsGroupByURLFull(query, Res); break;
  case 3: DpsGroupByURLUltra(query, Res); break;
  default:
#ifdef FAST_RELEVANCE
    DpsGroupByURLFast(query, Res);
#elif defined FULL_RELEVANCE
    DpsGroupByURLFull(query, Res);
#else
    DpsGroupByURLUltra(query, Res);
#endif

  }
  return;
}

void DpsGroupBySite(DPS_AGENT *query, DPS_RESULT *Res){	
	register size_t	i, j = 0, cnt = 1; 
	register urlid_t Doc_site;
	DPS_URL_CRD *Crd = Res->CoordList.Coords;
	DPS_URLDATA *Dat = Res->CoordList.Data;
	register int merge = 1;
#ifdef WITH_GOOGLEGRP
	register int second = 1;
#endif
	
	if(!Res->CoordList.ncoords) return;
	if (Res->PerSite == NULL) {
	  merge = 0;
	  if ((Res->PerSite = (size_t*)DpsMalloc(sizeof(*Res->PerSite) * Res->CoordList.ncoords + 1)) == NULL) return;
	}

	Doc_site = Dat[0].site_id;

	if (merge) {
	  cnt = Res->PerSite[0];
	  for(i = 1; i < Res->CoordList.ncoords; i++){
	    /* Group by site_id */
	    if(Doc_site == Dat[i].site_id){
	      /* Same site */
	      /* adjust document rating rating according nuber of documents from site, if we need this */
	      cnt += Res->PerSite[i];
#ifdef WITH_GOOGLEGRP
	      if (second) {
		j++;
		Crd[j] = Crd[i];
		Dat[j] = Dat[i];
		second = 0;
	      }
#endif
	    }else{
	      /* Next site */
#ifdef WITH_GOOGLEGRP
	      if (second == 0) {
		Res->PerSite[j - 1] = cnt;
		second = 1;
	      }
#endif
	      Res->PerSite[j] = cnt;
	      cnt = Res->PerSite[i];
	      j++;
	      Doc_site = Dat[i].site_id;
	      Crd[j] = Crd[i];
	      Dat[j] = Dat[i];
	    }
	  }
	} else {
	  for(i = 1; i < Res->CoordList.ncoords; i++){
		/* Group by site_id */
		if(Doc_site == Dat[i].site_id){
		/* Same site */
		  /* adjust document rating rating according nuber of documents from site, if we need this */
		  cnt++;
#ifdef WITH_GOOGLEGRP
		  if (second) {
		    j++;
		    Crd[j] = Crd[i];
		    Dat[j] = Dat[i];
		    second = 0;
		  }
#endif
		}else{
		  /* Next site */
#ifdef WITH_GOOGLEGRP
		  if (second == 0) {
		    Res->PerSite[j - 1] = cnt;
		    second = 1;
		  }
#endif
		  Res->PerSite[j] = cnt;
		  j++;
		  Doc_site = Dat[i].site_id;
		  Crd[j] = Crd[i];
		  Dat[j] = Dat[i];
		  cnt = 1;
		}
	  }
	}
#ifdef WITH_GOOGLEGRP
	if (second == 0) {
	  Res->PerSite[j - 1] = cnt;
	}
#endif
	Res->PerSite[j] = cnt;
	Res->CoordList.ncoords = j + 1;

	return;
}



int DpsParseQueryString(DPS_AGENT * Agent,DPS_VARLIST * vars,char * query_string){
	char * tok, *lt;
	size_t len;
	char *str = (char *)DpsMalloc((len = dps_strlen(query_string)) + 7);
	char *qs = (char*)DpsStrdup(query_string);
	char qname[256];

	if ((str == NULL) || qs == NULL) {
	  DPS_FREE(str);
	  DPS_FREE(qs);
	  return 1;
	}

	Agent->nlimits = 0;

	DpsSGMLUnescape(qs);
	
	tok = dps_strtok_r(qs, "&", &lt);
	while(tok){
		char empty[]="";
		char * val;
		const char * lim;
		
		if((val=strchr(tok,'='))){
			*val='\0';
			val++;
		}else{
			val=empty;
		}
		DpsUnescapeCGIQuery(str,val);
		if (strcasecmp(tok, "DoExcerpt") == 0) {
		  int res = !strcasecmp(str, "yes");
		  Agent->Flags.do_excerpt = res;
		} else {
		  DpsVarListReplaceStr(vars,tok,str);
		  dps_snprintf(qname, 256, "query.%s", tok);
		  DpsVarListReplaceStr(vars, qname, str);

		  sprintf(str,"Limit-%s",tok);
		  if((lim=DpsVarListFindStr(vars,str,NULL))){
			int ltype=0;
			const char * type, * fname = NULL;
			char * llt;
			dps_strncpy(str, lim, len);
			
			if((type = dps_strtok_r(str, ":", &llt))) {
			  if(!strcasecmp(type, "category")) {
			    ltype = DPS_LIMTYPE_NESTED; fname = DPS_LIMFNAME_CAT;
			  } else
			  if(!strcasecmp(type, "tag")) {
			    ltype = DPS_LIMTYPE_LINEAR_CRC; fname = DPS_LIMFNAME_TAG;
			  } else
			  if(!strcasecmp(type, "time")) {
			    ltype = DPS_LIMTYPE_TIME; fname = DPS_LIMFNAME_TIME;
			  } else
			  if(!strcasecmp(type, "hostname")) {
			    ltype = DPS_LIMTYPE_LINEAR_CRC; fname = DPS_LIMFNAME_HOST;
			  } else
			  if(!strcasecmp(type, "language")) {
			    ltype = DPS_LIMTYPE_LINEAR_CRC; fname = DPS_LIMFNAME_LANG;
			  } else
			  if(!strcasecmp(type, "content")) {
			    ltype = DPS_LIMTYPE_LINEAR_CRC; fname = DPS_LIMFNAME_CTYPE;
			  } else
			  if(!strcasecmp(type, "siteid")) {
			    ltype = DPS_LIMTYPE_LINEAR_INT; fname = DPS_LIMFNAME_SITE;
			  }
			  if((fname != NULL) && *val != '\0') {
			    DpsAddSearchLimit(Agent,ltype,fname,val);
			  }
			}
		  }
		}
		tok = dps_strtok_r(NULL, "&", &lt);
	}
	
	DPS_FREE(str);
	DPS_FREE(qs);
	return 0;
}


char * DpsHlConvert(DPS_WIDEWORDLIST *List, const char * src, DPS_CONV *lc_uni, DPS_CONV *uni_bc) {
	dpsunicode_t	*tok, *lt, *uni;
	int             ctype, have_bukva_forte;
	char		*hpart, *htxt, *zend;
	size_t		len;
	
	if(!src)return NULL;
	
	if ((len = dps_strlen(src)) == 0) return NULL;
	hpart = (char*)DpsMalloc(len * 14 + 10);
	if (hpart == NULL) return NULL;
	zend = htxt = (char*)DpsMalloc(len * 14 + 10);
	if (htxt == NULL) {
	  DPS_FREE(hpart);
	  return NULL;
	}
	htxt[0]='\0';
	
	/* Convert to unicode */
	uni = (dpsunicode_t *)DpsMalloc((len + 10) * sizeof(dpsunicode_t));
	if (uni == NULL) {
	  DPS_FREE(hpart); DPS_FREE(htxt);
	  return NULL;
	}
	DpsConv(lc_uni, (char*)uni, sizeof(uni[0])*(len+10), src, len+1);
/*	
	if (List != NULL) { 
	  size_t uw; 
	  for(uw = 0; uw < List->nwords; uw++) fprintf(stderr, "w%d:slen:%d|", uw, List->Word[uw].ulen); 
	} else {
	  fprintf(stderr, "List: NULL");
	}
	fprintf(stderr, "\n");
*/

	/* Parse unicode string */
	tok = DpsUniGetSepToken(uni, &lt, &ctype, &have_bukva_forte);
	while(tok){
		int found=0;
		size_t slen,flen;
		int euchar;
		size_t uw;

		flen=lt-tok;

		/* Convert token to BrowserCharset */
		euchar=tok[flen];
		tok[flen]=0;
		hpart[0]='\0';

		DpsConv(uni_bc, hpart, len * 14 + 10, (char*)tok, sizeof(*tok) * flen);
		
		/* Check that it is word to be marked */
		if (List != NULL) {
		  for (uw = 0; uw < List->nwords; uw++) {
		        if (List->Word[uw].origin & DPS_WORD_ORIGIN_STOP) continue;
			slen = List->Word[uw].ulen;
			if ((DpsUniCType(tok[slen]) <= DPS_UNI_BUKVA) && (tok[slen] != 0) && (tok[slen] >= 0x30 )) continue;
			if (!DpsUniStrNCaseCmp(tok, List->Word[uw].uword, slen)) {
			  found = 1;
			  break;
			}
		  }
		}
/*		fprintf(stderr, "tok: %s| flen: %d, found:%d\n", hpart, flen, found);*/
		
		if (found) { *zend = '\2'; zend++; /*dps_strcat(htxt,"\2");*/ }
		/*dps_strcat(htxt,hpart);*/
		dps_strcpy(zend, hpart);
		zend += uni_bc->obytes;
		if (found) { *zend = '\3'; zend++; /*dps_strcat(htxt,"\3");*/ }
		tok[flen]=euchar;

		tok = DpsUniGetSepToken(NULL, &lt, &ctype, &have_bukva_forte);
	}
	*zend = '\0';
	DPS_FREE(hpart);
	DPS_FREE(uni);
	/*
	fprintf(stderr,"otxt='%s'\n",src);
	fprintf(stderr,"htxt='%s'\n",htxt);
	*/
	return(htxt);
}

int DpsConvert(DPS_ENV *Conf, DPS_VARLIST *Env_Vars, DPS_RESULT *Res, DPS_CHARSET *lcs, DPS_CHARSET *bcs){
	size_t		i, r, len;
	DPS_CONV	lc_bc, lc_bc_text, bc_bc;
	char            *newval, *newtxt;
	DPS_VAR         *Var;
	DPS_CHARSET	*sys_int;
	DPS_CONV	lc_uni, uni_bc;
	DPS_CONV	lc_uni_text, uni_bc_text;
	
	sys_int=DpsGetCharSet("sys-int");
	DpsConvInit(&lc_bc, lcs, bcs, Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&lc_bc_text, lcs, bcs, Conf->CharsToEscape, DPS_RECODE_TEXT);
	DpsConvInit(&bc_bc, bcs, bcs, Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&lc_uni, lcs, sys_int, Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&uni_bc, sys_int, bcs, Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&lc_uni_text, lcs, sys_int, Conf->CharsToEscape, DPS_RECODE_TEXT);
	DpsConvInit(&uni_bc_text, sys_int, bcs, Conf->CharsToEscape, DPS_RECODE_TEXT);

#ifdef HAVE_ASPELL
	if (Res->Suggest != NULL) {
/*	  DpsVarListAddStr(Env_Vars, "Suggest", Res->Suggest);*/

	  len = dps_strlen(Res->Suggest);
	  newval = (char*)DpsMalloc(len * 12 + 1);
	  if (newval == NULL) return DPS_ERROR;
	  DpsConv(&lc_bc, newval, len * 12 + 1, Res->Suggest, len + 1);
	  DPS_FREE(Res->Suggest);
	  Res->Suggest = newval;
	  
	}
#endif

	/* Convert word list */
	for(i=0;i<Res->WWList.nwords;i++) {
		DPS_WIDEWORD	*W=&Res->WWList.Word[i];

		len = dps_strlen(W->word);
		newval = (char*)DpsMalloc(len * 12 + 1);
		if (newval == NULL) return DPS_ERROR;
		DpsConv(&lc_bc, newval, len * 12 + 1, W->word, len + 1);
		DPS_FREE(W->word);
		W->word = newval;
	}
	
	/* Convert document sections */
	for(i=0;i<Res->num_rows;i++){
		DPS_DOCUMENT	*D=&Res->Doc[i];
		size_t		sec;
		
		for (r = 0; r < 256; r++)
		for (sec = 0; sec < D->Sections.Root[r].nvars; sec++) {
			Var = &D->Sections.Root[r].Var[sec];

			newval = DpsHlConvert(&Res->WWList, Var->val, &lc_uni, &uni_bc);
			newtxt = DpsHlConvert(&Res->WWList, Var->txt_val, &lc_uni_text, &uni_bc_text);
			DPS_FREE(Var->val);
			DPS_FREE(Var->txt_val);
			Var->val = newval;
			Var->txt_val = newtxt;
		}
	}

	  /* Convert Env_Vars */
	for (r = 0; r < 256; r++)
	  for (i = 0; i < Env_Vars->Root[r].nvars; i++) {
	        Var = &Env_Vars->Root[r].Var[i];
	        len = dps_strlen(Var->val);
		newtxt = (char*)DpsMalloc(len * 12 + 1);
		newval = (char*)DpsMalloc(len * 12 + 1);
		if (newtxt == NULL || newval == NULL) { DPS_FREE(newtxt); return DPS_ERROR; }

/*		if (db->DBDriver != DPS_DB_SEARCHD)*/  /* FIXME: need unification in charset from different DPS_DB */
		  DpsConv(&lc_bc, newval, len * 12 + 1, Var->val, len + 1);
/*		else 
		  DpsConv(&bc_bc, newval, len * 12 + 1, Var->val, len + 1);*/
		DpsConv(&lc_bc_text, newtxt, len * 12 + 1, Var->txt_val, len + 1);
		DPS_FREE(Var->val);
		DPS_FREE(Var->txt_val);
		Var->val = newval;
		Var->txt_val = newtxt;
	}

	return DPS_OK;
}

char* DpsRemoveHiLightDup(const char *s){
	size_t	len=dps_strlen(s)+1;
	char	*res = (char*)DpsMalloc(len);
	char	*d;

	if (res == NULL) return NULL;
	for(d=res;s[0];s++){
		switch(s[0]){
			case '\2':
			case '\3':
				break;
			default:
				*d++=*s;
		}
	}
	*d='\0';
	return res;
}



int DpsCatToTextBuf(DPS_CATEGORY *C, char *textbuf, size_t len) {
	char	*end;
	size_t  i;
	
	textbuf[0]='\0';

/*	dps_snprintf(textbuf,len,"<CAT");
	end=textbuf+dps_strlen(textbuf);*/
	end = textbuf;
	
	for(i = 0; i < C->ncategories; i++) {
	  dps_snprintf(end, len - dps_strlen(textbuf), "<CAT\tid=\"%d\"\tpath=\"%s\"\tlink=\"%s\"\tname=\"%s\">\r\n",
		   C->Category[i].rec_id, C->Category[i].path, C->Category[i].link, C->Category[i].name );
	  end = end + dps_strlen(end);
	}
/*	dps_strcpy(end,">");*/
	return DPS_OK;
}

int DpsCatFromTextBuf(DPS_CATEGORY *C, char *textbuf) {
	const char	*htok, *last;
	DPS_HTMLTOK	tag;
	size_t		i, c;
	
	if (textbuf == NULL) return DPS_OK;
	DpsHTMLTOKInit(&tag);
	
	htok=DpsHTMLToken(textbuf,&last,&tag);
	
	if(!htok || tag.type != DPS_HTML_TAG)
	  return DPS_OK;

	C->Category = (DPS_CATITEM*)DpsRealloc(C->Category, sizeof(DPS_CATITEM) * ((c = C->ncategories) + 1));
	if (C->Category == NULL) {
	  C->ncategories = 0;
	  return DPS_ERROR;
	}
	bzero((void*)&C->Category[c], sizeof(DPS_CATITEM));
	
	for(i = 1; i < tag.ntoks; i++){
		size_t	nlen = tag.toks[i].nlen;
		size_t	vlen = tag.toks[i].vlen;
		char	*name = DpsStrndup(tag.toks[i].name, nlen);
		char	*data = DpsStrndup(tag.toks[i].val, vlen);

		if (!strcmp(name, "id")) {
		  C->Category[c].rec_id = atoi(data);
		} else if (!strcmp(name, "path")) {
		  dps_strncpy(C->Category[c].path, data, 128);
		} else if (!strcmp(name, "link")) {
		  dps_strncpy(C->Category[c].link, data, 128);
		} else if (!strcmp(name, "name")) {
		  dps_strncpy(C->Category[c].name, data, 128);
		}

		DPS_FREE(name);
		DPS_FREE(data);
	}

	C->ncategories++;
	return DPS_OK;
}

dpsunicode_t *DpsUniSegment(DPS_AGENT *Indexer, dpsunicode_t *ustr, const char *lang) {
	DPS_CHARSET     *tis_cs;
	DPS_CONV        uni_tis, tis_uni;
#if defined(CHASEN) || defined(MECAB)
	DPS_CHARSET     *eucjp_cs;
	DPS_CONV        uni_eucjp, eucjp_uni;
	char            *eucstr, *eucstr_seg;
	size_t          reslen;
#endif
	DPS_CHARSET	*sys_int;
	size_t          dstlen = DpsUniLen(ustr);

	if (dstlen < 2) return ustr;

	sys_int = DpsGetCharSet("sys-int");

	tis_cs = DpsGetCharSet("tis-620");
	DpsConvInit(&tis_uni, tis_cs, sys_int, Indexer->Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&uni_tis, sys_int, tis_cs, Indexer->Conf->CharsToEscape, DPS_RECODE_HTML);
	
#if defined(CHASEN) || defined(MECAB)
	eucjp_cs = DpsGetCharSet("euc-jp");
	if (!eucjp_cs) eucjp_cs = DpsGetCharSet("sys-int");
	DpsConvInit(&uni_eucjp, sys_int, eucjp_cs, Indexer->Conf->CharsToEscape, DPS_RECODE_HTML);
	DpsConvInit(&eucjp_uni, eucjp_cs, sys_int, Indexer->Conf->CharsToEscape, DPS_RECODE_HTML);
#endif


#if defined(CHASEN) || defined(MECAB)

	if (lang == NULL || *lang == '\0' || !strncasecmp(lang, "ja", 2)) {
	  eucstr = (char*)DpsMalloc(14 * dstlen + 1);
	  if (eucstr == NULL) return NULL;
	  DpsConv(&uni_eucjp, eucstr, 14 * dstlen + 1, (char*)ustr, (dstlen + 1) * sizeof(dpsunicode_t));

#ifdef CHASEN
	  DPS_GETLOCK(Indexer, DPS_LOCK_SEGMENTER);
	  eucstr_seg = chasen_sparse_tostr(eucstr);
	  DPS_RELEASELOCK(Indexer, DPS_LOCK_SEGMENTER);
#else
	  DPS_GETLOCK(Indexer, DPS_LOCK_CONF);
#ifdef HAVE_PTHREADS
	  mecab_lock(Indexer->Conf->mecab);
#endif
	  eucstr_seg = mecab_sparse_tostr(Indexer->Conf->mecab, eucstr);
#ifdef HAVE_PTHREADS
	  mecab_unlock(Indexer->Conf->mecab);
#endif
	  DPS_RELEASELOCK(Indexer, DPS_LOCK_CONF);
#endif

	  reslen = dps_strlen(eucstr_seg) + 1;
	  ustr = (dpsunicode_t*)DpsRealloc(ustr, reslen * sizeof(dpsunicode_t));
	  if (ustr == NULL) {
	    DPS_FREE(eucstr);
	    return NULL;
	  }
	  DpsConv(&eucjp_uni, (char*)ustr, reslen * sizeof(dpsunicode_t), eucstr_seg, reslen);
	  DPS_FREE(eucstr);
	  dstlen = DpsUniLen(ustr);
	}
/*	else*/
#endif
	  if (lang == NULL || *lang == '\0' || !strncasecmp(lang, "zh", 2)) {
	    dpsunicode_t *seg_ustr;
	    DPS_GETLOCK(Indexer, DPS_LOCK_CONF);
	    seg_ustr = DpsSegmentByFreq(&Indexer->Conf->Chi, ustr);
	    DPS_RELEASELOCK(Indexer, DPS_LOCK_CONF);
	    if (seg_ustr != NULL) {
	      DPS_FREE(ustr);
	      ustr = seg_ustr;
	    }
	    dstlen = DpsUniLen(ustr);
	  }
	
#if defined(CHASEN) || defined(MECAB)
/*	  else*/
#endif
	    if (lang == NULL || *lang == '\0' || !strncasecmp(lang, "th", 2)) {
	      dpsunicode_t *seg_ustr;
	      DPS_GETLOCK(Indexer, DPS_LOCK_CONF);
	      seg_ustr = DpsSegmentByFreq(&Indexer->Conf->Thai, ustr);
	      DPS_RELEASELOCK(Indexer, DPS_LOCK_CONF);
	      if (seg_ustr != NULL) {
		DPS_FREE(ustr);
		ustr = seg_ustr;
	      }
	      dstlen = DpsUniLen(ustr);
	    }

#if defined(CHASEN) || defined(MECAB)
/*	  else*/
#endif
	    if (lang == NULL || *lang == '\0' || !strncasecmp(lang, "ko", 2)) {
	      dpsunicode_t *seg_ustr;
	      DPS_GETLOCK(Indexer, DPS_LOCK_CONF);
	      seg_ustr = DpsSegmentByFreq(&Indexer->Conf->Korean, ustr);
	      DPS_RELEASELOCK(Indexer, DPS_LOCK_CONF);
	      if (seg_ustr != NULL) {
		DPS_FREE(ustr);
		ustr = seg_ustr;
	      }
	      dstlen = DpsUniLen(ustr);
	    }
	return ustr;
}


char * DpsBuildPageURL(DPS_VARLIST * vars, char **dst) {
	size_t i, r, nargs = 0, dstlen = 1;
	char * end;
	for (r = 0; r < 256; r++)
	for(i = 0; i < vars->Root[r].nvars; i++) {
	  dstlen += 7 + dps_strlen(vars->Root[r].Var[i].name) + 3 * dps_strlen(vars->Root[r].Var[i].val);
	}
	*dst = (char*)DpsRealloc(*dst, dstlen);
	if (*dst == NULL) return NULL;
	end = *dst;

	for (r = 0; r < 256; r++)
	for (i = 0; i < vars->Root[r].nvars; i++) {
		dps_strcpy(end, nargs ? "&amp;" : "?");
		end += nargs ? 5 : 1;
		DpsEscapeURL(end, vars->Root[r].Var[i].name);
			
		end = end + dps_strlen(end);
		dps_strcpy(end, "="); end++;
		DpsEscapeURL(end, vars->Root[r].Var[i].val);
			
		end = end + dps_strlen(end);
		nargs++;
	}
	*end = '\0';
	return NULL;
}

void DpsParseQStringUnescaped(DPS_VARLIST *vars, const char *qstring){
	char *tok, *lt; 
	char *qs = (char*)DpsStrdup(qstring);
	char *name = NULL, *arg;

	if (qs != NULL) {
	  DpsUnescapeCGIQuery(qs, qs);
	  name = qs;
	  tok = strchr(qs, '&');
	  while(tok){
	    if (tok[1] == '#') {
	      tok = strchr(tok + 1, '&');
	      continue;
	    }
	    arg = strchr(name, '=');
	    if(arg) *arg++ = '\0';
	    *tok = '\0';
/*	      DpsVarListAddStr(vars,tok,arg?arg:"");*/
	    DpsVarListReplaceStr(vars, name, arg ? arg : "");
	    name = tok + 1;
	    tok = strchr(name, '&');
	  }
	  if (*name) {
	    arg = strchr(name, '=');
	    if(arg) *arg++ = '\0';
/*	      DpsVarListAddStr(vars,tok,arg?arg:"");*/
	    DpsVarListReplaceStr(vars, name, arg ? arg : "");
	  }


	  DpsFree(qs);
	}
}

size_t DpsRemoveNullSections(DPS_URL_CRD *words, size_t n, int *wf) {
  register size_t i, j = 0;
  for (i = 0; i < n; i++) {
/*    fprintf(stderr, "%x:sec:%d  ", words[i].coord, DPS_WRDSEC(words[i].coord));*/
    if (wf[DPS_WRDSEC(words[i].coord)] > 0) words[j++] = words[i];
  }
  return j;
}
