/* Copyright (C) 2005 Datapark corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "dps_config.h"

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "dps_uniconv.h"
#include "dps_sgml.h"

#ifdef HAVE_CHARSET_chinese


/* Big5_hkscs */

/* 0x8840 .. 0xA0FE */
static dpsunicode_t tab_hkscs8840_uni[] = {
 0x0f303, 0x0f304, 0x0f305, 0x0f306, 0x0f307, 0x2010c, 0x0f309, 0x200d1,
 0x200cd, 0x0f30c, 0x0f30d, 0x200cb, 0x21fe8, 0x0f310, 0x200ca, 0x0f312,
 0x0f313, 0x0f314, 0x0f315, 0x2010e, 0x0f317, 0x0f318, 0x00100, 0x000c1,
 0x001cd, 0x000c0, 0x00112, 0x000c9, 0x0011a, 0x000c8, 0x0014c, 0x000d3,
 0x001d1, 0x000d2, 0x0f325, 0x01ebe, 0x0f327, 0x01ec0, 0x000ca, 0x00101,
 0x000e1, 0x001ce, 0x000e0, 0x00251, 0x00113, 0x000e9, 0x0011b, 0x000e8,
 0x0012b, 0x000ed, 0x001d0, 0x000ec, 0x0014d, 0x000f3, 0x001d2, 0x000f2,
 0x0016b, 0x000fa, 0x001d4, 0x000f9, 0x001d6, 0x001d8, 0x001da, 0x001dc,
 0x000fc, 0x0f344, 0x01ebf, 0x0f346, 0x01ec1, 0x000ea, 0x00261, 0x0f34a,
 0x0f34b, 0x2a3a9, 0x21145, 0x0650a, 0x04e3d, 0x06edd, 0x09d4e, 0x091df,
 0x27735, 0x06491, 0x04f1a, 0x04f28, 0x04fa8, 0x05156, 0x05174, 0x0519c,
 0x051e4, 0x052a1, 0x052a8, 0x0533b, 0x0534e, 0x053d1, 0x053d8, 0x056e2,
 0x058f0, 0x05904, 0x05907, 0x05932, 0x05934, 0x05b66, 0x05b9e, 0x05b9f,
 0x05c9a, 0x05e86, 0x0603b, 0x06589, 0x067fe, 0x06804, 0x06865, 0x06d4e,
 0x070bc, 0x07535, 0x07ea4, 0x07eac, 0x07eba, 0x07ec7, 0x07ecf, 0x07edf,
 0x07f06, 0x07f37, 0x0827a, 0x082cf, 0x0836f, 0x089c6, 0x08bbe, 0x08be2,
 0x08f66, 0x08f67, 0x08f6e, 0x07411, 0x07cfc, 0x07dcd, 0x06946, 0x07ac9,
 0x05227, 0x0918c, 0x078b8, 0x0915e, 0x080bc, 0x08d0b, 0x080f6, 0x209e7,
 0x0809f, 0x09ec7, 0x04ccd, 0x09dc9, 0x09e0c, 0x04c3e, 0x29df6, 0x2700e,
 0x09e0a, 0x2a133, 0x035c1, 0x06e9a, 0x0823e, 0x07519, 0x04911, 0x09a6c,
 0x09a8f, 0x09f99, 0x07987, 0x2846c, 0x21dca, 0x205d0, 0x22ae6, 0x04e24,
 0x04e81, 0x04e80, 0x04e87, 0x04ebf, 0x04eeb, 0x04f37, 0x0344c, 0x04fbd,
 0x03e48, 0x05003, 0x05088, 0x0347d, 0x03493, 0x034a5, 0x05186, 0x05905,
 0x051db, 0x051fc, 0x05205, 0x04e89, 0x05279, 0x05290, 0x05327, 0x035c7,
 0x053a9, 0x03551, 0x053b0, 0x03553, 0x053c2, 0x05423, 0x0356d, 0x03572,
 0x03681, 0x05493, 0x054a3, 0x054b4, 0x054b9, 0x054d0, 0x054ef, 0x05518,
 0x05523, 0x05528, 0x03598, 0x0553f, 0x035a5, 0x035bf, 0x055d7, 0x035c5,
 0x27d84, 0x05525, 0x20c42, 0x20d15, 0x2512b, 0x05590, 0x22cc6, 0x039ec,
 0x20341, 0x08e46, 0x24db8, 0x294e5, 0x04053, 0x280be, 0x0777a, 0x22c38,
 0x03a34, 0x047d5, 0x2815d, 0x269f2, 0x24dea, 0x064dd, 0x20d7c, 0x20fb4,
 0x20cd5, 0x210f4, 0x0648d, 0x08e7e, 0x20e96, 0x20c0b, 0x20f64, 0x22ca9,
 0x28256, 0x244d3, 0x20d46, 0x29a4d, 0x280e9, 0x047f4, 0x24ea7, 0x22cc2,
 0x09ab2, 0x03a67, 0x295f4, 0x03fed, 0x03506, 0x252c7, 0x297d4, 0x278c8,
 0x22d44, 0x09d6e, 0x09815, 0x043d9, 0x260a5, 0x064b4, 0x054e3, 0x22d4c,
 0x22bca, 0x21077, 0x039fb, 0x2106f, 0x266da, 0x26716, 0x279a0, 0x064ea,
 0x25052, 0x20c43, 0x08e68, 0x221a1, 0x28b4c, 0x20731, 0x0480b, 0x201a9,
 0x03ffa, 0x05873, 0x22d8d, 0x245c8, 0x204fc, 0x26097, 0x20f4c, 0x20d96,
 0x05579, 0x040bb, 0x043ba, 0x04ab4, 0x22a66, 0x2109d, 0x081aa, 0x098f5,
 0x20d9c, 0x06379, 0x039fe, 0x22775, 0x08dc0, 0x056a1, 0x0647c, 0x03e43,
 0x2a601, 0x20e09, 0x22acf, 0x22cc9, 0x210c8, 0x239c2, 0x03992, 0x03a06,
 0x2829b, 0x03578, 0x25e49, 0x220c7, 0x05652, 0x20f31, 0x22cb2, 0x29720,
 0x034bc, 0x06c3d, 0x24e3b, 0x27574, 0x22e8b, 0x22208, 0x2a65b, 0x28ccd,
 0x20e7a, 0x20c34, 0x2681c, 0x07f93, 0x210cf, 0x22803, 0x22939, 0x035fb,
 0x251e3, 0x20e8c, 0x20f8d, 0x20eaa, 0x03f93, 0x20f30, 0x20d47, 0x2114f,
 0x20e4c, 0x20eab, 0x20ba9, 0x20d48, 0x210c0, 0x2113d, 0x03ff9, 0x22696,
 0x06432, 0x20fad, 0x233f4, 0x27639, 0x22bce, 0x20d7e, 0x20d7f, 0x22c51,
 0x22c55, 0x03a18, 0x20e98, 0x210c7, 0x20f2e, 0x2a632, 0x26b50, 0x28cd2,
 0x28d99, 0x28cca, 0x095aa, 0x054cc, 0x082c4, 0x055b9, 0x29ec3, 0x09c26,
 0x09ab6, 0x2775e, 0x22dee, 0x07140, 0x0816d, 0x080ec, 0x05c1c, 0x26572,
 0x08134, 0x03797, 0x0535f, 0x280bd, 0x091b6, 0x20efa, 0x20e0f, 0x20e77,
 0x20efb, 0x035dd, 0x24deb, 0x03609, 0x20cd6, 0x056af, 0x227b5, 0x210c9,
 0x20e10, 0x20e78, 0x21078, 0x21148, 0x28207, 0x21455, 0x20e79, 0x24e50,
 0x22da4, 0x05a54, 0x2101d, 0x2101e, 0x210f5, 0x210f6, 0x0579c, 0x20e11,
 0x27694, 0x282cd, 0x20fb5, 0x20e7b, 0x2517e, 0x03703, 0x20fb6, 0x21180,
 0x252d8, 0x2a2bd, 0x249da, 0x2183a, 0x24177, 0x2827c, 0x05899, 0x05268,
 0x0361a, 0x2573d, 0x07bb2, 0x05b68, 0x04800, 0x04b2c, 0x09f27, 0x049e7,
 0x09c1f, 0x09b8d, 0x25b74, 0x2313d, 0x055fb, 0x035f2, 0x05689, 0x04e28,
 0x05902, 0x21bc1, 0x2f878, 0x09751, 0x20086, 0x04e5b, 0x04ebb, 0x0353e,
 0x05c23, 0x05f51, 0x05fc4, 0x038fa, 0x0624c, 0x06535, 0x06b7a, 0x06c35,
 0x06c3a, 0x0706c, 0x0722b, 0x04e2c, 0x072ad, 0x248e9, 0x07f52, 0x0793b,
 0x07cf9, 0x07f53, 0x2626a, 0x034c1, 0x2634b, 0x08002, 0x08080, 0x26612,
 0x26951, 0x0535d, 0x08864, 0x089c1, 0x278b2, 0x08ba0, 0x08d1d, 0x09485,
 0x09578, 0x0957f, 0x095e8, 0x28e0f, 0x097e6, 0x09875, 0x098ce, 0x098de,
 0x09963, 0x29810, 0x09c7c, 0x09e1f, 0x09ec4, 0x06b6f, 0x0f907, 0x04e37,
 0x20087, 0x0961d, 0x06237, 0x094a2, 0x0503b, 0x06dfe, 0x29c73, 0x0f57a,
 0x03dc9, 0x0888f, 0x2414e, 0x07077, 0x05cf5, 0x04b20, 0x251cd, 0x03559,
 0x25d30, 0x06122, 0x28a32, 0x08fa7, 0x091f6, 0x07191, 0x06719, 0x073ba,
 0x23281, 0x2a107, 0x03c8b, 0x21980, 0x04b10, 0x078e4, 0x07402, 0x051ae,
 0x2870f, 0x04009, 0x06a63, 0x2a2ba, 0x04223, 0x0860f, 0x07a2a, 0x29947,
 0x28aea, 0x09755, 0x0704d, 0x05324, 0x2207e, 0x093f4, 0x076d9, 0x289e3,
 0x0f5a4, 0x077dd, 0x04ea3, 0x04ff0, 0x050bc, 0x04e2f, 0x04f17, 0x0f5ab,
 0x05434, 0x07d8b, 0x05892, 0x058d0, 0x21db6, 0x05e92, 0x05e99, 0x05fc2,
 0x22712, 0x0658b, 0x233f9, 0x06919, 0x06a43, 0x23c63, 0x06cff, 0x07200,
 0x24505, 0x0738c, 0x03edb, 0x24a13, 0x05b15, 0x074b9, 0x08b83, 0x25ca4,
 0x25695, 0x07a93, 0x07bec, 0x07cc3, 0x07e6c, 0x082f8, 0x08597, 0x0f5cc,
 0x08890, 0x0f5ce, 0x08eb9, 0x0f5d0, 0x08fcf, 0x0855f, 0x099e0, 0x09221,
 0x0f5d5, 0x28db9, 0x2143f, 0x04071, 0x042a2, 0x05a1a, 0x09868, 0x0676b,
 0x04276, 0x0573d, 0x085d6, 0x2497b, 0x082bf, 0x2710d, 0x04c81, 0x26d74,
 0x05d7b, 0x26b15, 0x26fbe, 0x0f5ec, 0x0f5ed, 0x05b96, 0x0f5ef, 0x07e5b,
 0x05d3e, 0x05d48, 0x05d56, 0x03dfc, 0x0380f, 0x05da4, 0x05db9, 0x03820,
 0x03838, 0x05e42, 0x05ebd, 0x05f25, 0x05f83, 0x03908, 0x03914, 0x0393f,
 0x0394d, 0x060d7, 0x0613d, 0x05ce5, 0x03989, 0x061b7, 0x061b9, 0x061cf,
 0x039b8, 0x0622c, 0x06290, 0x062e5, 0x06318, 0x039f8, 0x056b1, 0x03a03,
 0x063e2, 0x063fb, 0x06407, 0x0645a, 0x03a4b, 0x064c0, 0x05d15, 0x05621,
 0x09f9f, 0x03a97, 0x06586, 0x03abd, 0x065ff, 0x06653, 0x03af2, 0x06692,
 0x03b22, 0x06716, 0x03b42, 0x067a4, 0x06800, 0x03b58, 0x0684a, 0x06884,
 0x03b72, 0x03b71, 0x03b7b, 0x06909, 0x06943, 0x0725c, 0x06964, 0x0699f,
 0x06985, 0x03bbc, 0x069d6, 0x03bdd, 0x06a65, 0x06a74, 0x06a71, 0x06a82,
 0x03bec, 0x06a99, 0x03bf2, 0x06aab, 0x06ab5, 0x06ad4, 0x06af6, 0x06b81,
 0x06bc1, 0x06bea, 0x06c75, 0x06caa, 0x03ccb, 0x06d02, 0x06d06, 0x06d26,
 0x06d81, 0x03cef, 0x06da4, 0x06db1, 0x06e15, 0x06e18, 0x06e29, 0x06e86,
 0x289c0, 0x06ebb, 0x06ee2, 0x06eda, 0x09f7f, 0x06ee8, 0x06ee9, 0x06f24,
 0x06f34, 0x03d46, 0x23f41, 0x06f81, 0x06fbe, 0x03d6a, 0x03d75, 0x071b7,
 0x05c99, 0x03d8a, 0x0702c, 0x03d91, 0x07050, 0x07054, 0x0706f, 0x0707f,
 0x07089, 0x20325, 0x043c1, 0x035f1, 0x20ed8, 0x23ed7, 0x057be, 0x26ed3,
 0x0713e, 0x257e0, 0x0364e, 0x069a2, 0x28be9, 0x05b74, 0x07a49, 0x258e1,
 0x294d9, 0x07a65, 0x07a7d, 0x259ac, 0x07abb, 0x07ab0, 0x07ac2, 0x07ac3,
 0x071d1, 0x2648d, 0x041ca, 0x07ada, 0x07add, 0x07aea, 0x041ef, 0x054b2,
 0x25c01, 0x07b0b, 0x07b55, 0x07b29, 0x2530e, 0x25cfe, 0x07ba2, 0x07b6f,
 0x0839c, 0x25bb4, 0x26c7f, 0x07bd0, 0x08421, 0x07b92, 0x07bb8, 0x25d20,
 0x03dad, 0x25c65, 0x08492, 0x07bfa, 0x07c06, 0x07c35, 0x25cc1, 0x07c44,
 0x07c83, 0x24882, 0x07ca6, 0x0667d, 0x24578, 0x07cc9, 0x07cc7, 0x07ce6,
 0x07c74, 0x07cf3, 0x07cf5, 0x07cce, 0x07e67, 0x0451d, 0x26e44, 0x07d5d,
 0x26ed6, 0x0748d, 0x07d89, 0x07dab, 0x07135, 0x07db3, 0x07dd2, 0x24057,
 0x26029, 0x07de4, 0x03d13, 0x07df5, 0x217f9, 0x07de5, 0x2836d, 0x07e1d,
 0x26121, 0x2615a, 0x07e6e, 0x07e92, 0x0432b, 0x0946c, 0x07e27, 0x07f40,
 0x07f41, 0x07f47, 0x07936, 0x262d0, 0x099e1, 0x07f97, 0x26351, 0x07fa3,
 0x21661, 0x20068, 0x0455c, 0x23766, 0x04503, 0x2833a, 0x07ffa, 0x26489,
 0x08005, 0x08008, 0x0801d, 0x08028, 0x0802f, 0x2a087, 0x26cc3, 0x0803b,
 0x0803c, 0x08061, 0x22714, 0x04989, 0x26626, 0x23de3, 0x266e8, 0x06725,
 0x080a7, 0x28a48, 0x08107, 0x0811a, 0x058b0, 0x226f6, 0x06c7f, 0x26498,
 0x24fb8, 0x064e7, 0x2148a, 0x08218, 0x2185e, 0x06a53, 0x24a65, 0x24a95,
 0x0447a, 0x08229, 0x20b0d, 0x26a52, 0x23d7e, 0x04ff9, 0x214fd, 0x084e2,
 0x08362, 0x26b0a, 0x249a7, 0x23530, 0x21773, 0x23df8, 0x082aa, 0x0691b,
 0x2f994, 0x041db, 0x0854b, 0x082d0, 0x0831a, 0x20e16, 0x217b4, 0x036c1,
 0x2317d, 0x2355a, 0x0827b, 0x082e2, 0x08318, 0x23e8b, 0x26da3, 0x26b05,
 0x26b97, 0x235ce, 0x03dbf, 0x0831d, 0x055ec, 0x08385, 0x0450b, 0x26da5,
 0x083ac, 0x083c1, 0x083d3, 0x0347e, 0x26ed4, 0x06a57, 0x0855a, 0x03496,
 0x26e42, 0x22eef, 0x08458, 0x25be4, 0x08471, 0x03dd3, 0x044e4, 0x06aa7,
 0x0844a, 0x23cb5, 0x07958, 0x084a8, 0x26b96, 0x26e77, 0x26e43, 0x084de,
 0x0840f, 0x08391, 0x044a0, 0x08493, 0x084e4, 0x25c91, 0x04240, 0x25cc0,
 0x04543, 0x08534, 0x05af2, 0x26e99, 0x04527, 0x08573, 0x04516, 0x067bf,
 0x08616, 0x28625, 0x2863b, 0x085c1, 0x27088, 0x08602, 0x21582, 0x270cd,
 0x2f9b2, 0x0456a, 0x08628, 0x03648, 0x218a2, 0x053f7, 0x2739a, 0x0867e,
 0x08771, 0x2a0f8, 0x087ee, 0x22c27, 0x087b1, 0x087da, 0x0880f, 0x05661,
 0x0866c, 0x06856, 0x0460f, 0x08845, 0x08846, 0x275e0, 0x23db9, 0x275e4,
 0x0885e, 0x0889c, 0x0465b, 0x088b4, 0x088b5, 0x063c1, 0x088c5, 0x07777,
 0x2770f, 0x08987, 0x0898a, 0x089a6, 0x089a9, 0x089a7, 0x089bc, 0x28a25,
 0x089e7, 0x27924, 0x27abd, 0x08a9c, 0x07793, 0x091fe, 0x08a90, 0x27a59,
 0x07ae9, 0x27b3a, 0x23f8f, 0x04713, 0x27b38, 0x0717c, 0x08b0c, 0x08b1f,
 0x25430, 0x25565, 0x08b3f, 0x08b4c, 0x08b4d, 0x08aa9, 0x24a7a, 0x08b90,
 0x08b9b, 0x08aaf, 0x216df, 0x04615, 0x0884f, 0x08c9b, 0x27d54, 0x27d8f,
 0x2f9d4, 0x03725, 0x27d53, 0x08cd6, 0x27d98, 0x27dbd, 0x08d12, 0x08d03,
 0x21910, 0x08cdb, 0x0705c, 0x08d11, 0x24cc9, 0x03ed0, 0x08d77, 0x08da9,
 0x28002, 0x21014, 0x2498a, 0x03b7c, 0x281bc, 0x2710c, 0x07ae7, 0x08ead,
 0x08eb6, 0x08ec3, 0x092d4, 0x08f19, 0x08f2d, 0x28365, 0x28412, 0x08fa5,
 0x09303, 0x2a29f, 0x20a50, 0x08fb3, 0x0492a, 0x289de, 0x2853d, 0x23dbb,
 0x05ef8, 0x23262, 0x08ff9, 0x2a014, 0x286bc, 0x28501, 0x22325, 0x03980,
 0x26ed7, 0x09037, 0x2853c, 0x27abe, 0x09061, 0x2856c, 0x2860b, 0x090a8,
 0x28713, 0x090c4, 0x286e6, 0x090ae, 0x090fd, 0x09167, 0x03af0, 0x091a9,
 0x091c4, 0x07cac, 0x28933, 0x21e89, 0x0920e, 0x06c9f, 0x09241, 0x09262,
 0x255b9, 0x092b9, 0x28ac6, 0x23c9b, 0x28b0c, 0x255db, 0x20d31, 0x0932c,
 0x0936b, 0x28ae1, 0x28beb, 0x0708f, 0x05ac3, 0x28ae2, 0x28ae5, 0x04965,
 0x09244, 0x28bec, 0x28c39, 0x28bff, 0x09373, 0x0945b, 0x08ebc, 0x09585,
 0x095a6, 0x09426, 0x095a0, 0x06ff6, 0x042b9, 0x2267a, 0x286d8, 0x2127c,
 0x23e2e, 0x049df, 0x06c1c, 0x0967b, 0x09696, 0x0416c, 0x096a3, 0x26ed5,
 0x061da, 0x096b6, 0x078f5, 0x28ae0, 0x096bd, 0x053cc, 0x049a1, 0x26cb8,
 0x20274, 0x26410, 0x290af, 0x290e5, 0x24ad1, 0x21915, 0x2330a, 0x09731,
 0x08642, 0x09736, 0x04a0f, 0x0453d, 0x04585, 0x24ae9, 0x07075, 0x05b41,
 0x0971b, 0x0975c, 0x291d5, 0x09757, 0x05b4a, 0x291eb, 0x0975f, 0x09425,
 0x050d0, 0x230b7, 0x230bc, 0x09789, 0x0979f, 0x097b1, 0x097be, 0x097c0,
 0x097d2, 0x097e0, 0x2546c, 0x097ee, 0x0741c, 0x29433, 0x097ff, 0x097f5,
 0x2941d, 0x2797a, 0x04ad1, 0x09834, 0x09833, 0x0984b, 0x09866, 0x03b0e,
 0x27175, 0x03d51, 0x20630, 0x2415c, 0x25706, 0x098ca, 0x098b7, 0x098c8,
 0x098c7, 0x04aff, 0x26d27, 0x216d3, 0x055b0, 0x098e1, 0x098e6, 0x098ec,
 0x09378, 0x09939, 0x24a29, 0x04b72, 0x29857, 0x29905, 0x099f5, 0x09a0c,
 0x09a3b, 0x09a10, 0x09a58, 0x25725, 0x036c4, 0x290b1, 0x29bd5, 0x09ae0,
 0x09ae2, 0x29b05, 0x09af4, 0x04c0e, 0x09b14, 0x09b2d, 0x28600, 0x05034,
 0x09b34, 0x269a8, 0x038c3, 0x2307d, 0x09b50, 0x09b40, 0x29d3e, 0x05a45,
 0x21863, 0x09b8e, 0x2424b, 0x09c02, 0x09bff, 0x09c0c, 0x29e68, 0x09dd4,
 0x29fb7, 0x2a192, 0x2a1ab, 0x2a0e1, 0x2a123, 0x2a1df, 0x09d7e, 0x09d83,
 0x2a134, 0x09e0e, 0x06888, 0x09dc4, 0x2215b, 0x2a193, 0x2a220, 0x2193b,
 0x2a233, 0x09d39, 0x2a0b9, 0x2a2b4, 0x09e90, 0x09e95, 0x09e9e, 0x09ea2,
 0x04d34, 0x09eaa, 0x09eaf, 0x24364, 0x09ec1, 0x03b60, 0x039e5, 0x03d1d,
 0x04f32, 0x037be, 0x28c2b, 0x09f02, 0x09f08, 0x04b96, 0x09424, 0x26da2,
 0x09f17, 0x09f16, 0x09f39, 0x0569f, 0x0568a, 0x09f45, 0x099b8, 0x2908b,
 0x097f2, 0x0847f, 0x09f62, 0x09f69, 0x07adc, 0x09f8e, 0x07216, 0x04bbe,
 0x24975, 0x249bb, 0x07177, 0x249f8, 0x24348, 0x24a51, 0x0739e, 0x28bda,
 0x218fa, 0x0799f, 0x2897e, 0x28e36, 0x09369, 0x093f3, 0x28a44, 0x092ec,
 0x09381, 0x093cb, 0x2896c, 0x244b9, 0x07217, 0x03eeb, 0x07772, 0x07a43,
 0x070d0, 0x24473, 0x243f8, 0x0717e, 0x217ef, 0x070a3, 0x218be, 0x23599,
 0x03ec7, 0x21885, 0x2542f, 0x217f8, 0x03722, 0x216fb, 0x21839, 0x036e1,
 0x21774, 0x218d1, 0x25f4b, 0x03723, 0x216c0, 0x0575b, 0x24a25, 0x213fe,
 0x212a8, 0x213c6, 0x214b6, 0x08503, 0x236a6, 0x08503, 0x08455, 0x24994,
 0x27165, 0x23e31, 0x2555c, 0x23efb, 0x27052, 0x044f4, 0x236ee, 0x2999d,
 0x26f26, 0x067f9, 0x03733, 0x03c15, 0x03de7, 0x0586c, 0x21922, 0x06810,
 0x04057, 0x2373f, 0x240e1, 0x2408b, 0x2410f, 0x26c21, 0x054cb, 0x0569e,
 0x266b1, 0x05692, 0x20fdf, 0x20ba8, 0x20e0d, 0x093c6, 0x28b13, 0x0939c,
 0x04ef8, 0x0512b, 0x03819, 0x24436, 0x04ebc, 0x20465, 0x2037f, 0x04f4b,
 0x04f8a, 0x25651, 0x05a68, 0x201ab, 0x203cb, 0x03999, 0x2030a, 0x20414,
 0x03435, 0x04f29, 0x202c0, 0x28eb3, 0x20275, 0x08ada, 0x2020c, 0x04e98,
 0x050cd, 0x0510d, 0x04fa2, 0x04f03, 0x24a0e, 0x23e8a, 0x04f42, 0x0502e,
 0x0506c, 0x05081, 0x04fcc, 0x04fe5, 0x05058, 0x050fc, 0x05159, 0x0515b,
 0x0515d, 0x0515e, 0x06e76, 0x23595, 0x23e39, 0x23ebf, 0x06d72, 0x21884,
 0x23e89, 0x051a8, 0x051c3, 0x205e0, 0x044dd, 0x204a3, 0x20492, 0x20491,
 0x08d7a, 0x28a9c, 0x2070e, 0x05259, 0x052a4, 0x20873, 0x052e1, 0x0936e,
 0x0467a, 0x0718c, 0x2438c, 0x20c20, 0x249ac, 0x210e4, 0x069d1, 0x20e1d,
 0x07479, 0x03ede, 0x07499, 0x07414, 0x07456, 0x07398, 0x04b8e, 0x24abc,
 0x2408d, 0x053d0, 0x03584, 0x0720f, 0x240c9, 0x055b4, 0x20345, 0x054cd,
 0x20bc6, 0x0571d, 0x0925d, 0x096f4, 0x09366, 0x057dd, 0x0578d, 0x0577f,
 0x0363e, 0x058cb, 0x05a99, 0x28a46, 0x216fa, 0x2176f, 0x21710, 0x05a2c,
 0x059b8, 0x0928f, 0x05a7e, 0x05acf, 0x05a12, 0x25946, 0x219f3, 0x21861,
 0x24295, 0x036f5, 0x06d05, 0x07443, 0x05a21, 0x25e83, 0x05a81, 0x28bd7,
 0x20413, 0x093e0, 0x0748c, 0x21303, 0x07105, 0x04972, 0x09408, 0x289fb,
 0x093bd, 0x037a0, 0x05c1e, 0x05c9e, 0x05e5e, 0x05e48, 0x21996, 0x2197c,
 0x23aee, 0x05ecd, 0x05b4f, 0x21903, 0x21904, 0x03701, 0x218a0, 0x036dd,
 0x216fe, 0x036d3, 0x0812a, 0x28a47, 0x21dba, 0x23472, 0x289a8, 0x05f0c,
 0x05f0e, 0x21927, 0x217ab, 0x05a6b, 0x2173b, 0x05b44, 0x08614, 0x275fd,
 0x08860, 0x0607e, 0x22860, 0x2262b, 0x05fdb, 0x03eb8, 0x225af, 0x225be,
 0x29088, 0x26f73, 0x061c0, 0x2003e, 0x20046, 0x2261b, 0x06199, 0x06198,
 0x06075, 0x22c9b, 0x22d07, 0x246d4, 0x2914d, 0x06471, 0x24665, 0x22b6a,
 0x03a29, 0x22b22, 0x23450, 0x298ea, 0x22e78, 0x06337, 0x2a45b, 0x064b6,
 0x06331, 0x063d1, 0x249e3, 0x22d67, 0x062a4, 0x22ca1, 0x0643b, 0x0656b,
 0x06972, 0x03bf4, 0x2308e, 0x232ad, 0x24989, 0x232ab, 0x0550d, 0x232e0,
 0x218d9, 0x2943f, 0x066ce, 0x23289, 0x231b3, 0x03ae0, 0x04190, 0x25584,
 0x28b22, 0x2558f, 0x216fc, 0x2555b, 0x25425, 0x078ee, 0x23103, 0x2182a,
 0x23234, 0x03464, 0x2320f, 0x23182, 0x242c9, 0x0668e, 0x26d24, 0x0666b,
 0x04b93, 0x06630, 0x27870, 0x21deb, 0x06663, 0x232d2, 0x232e1, 0x0661e,
 0x25872, 0x038d1, 0x2383a, 0x237bc, 0x03b99, 0x237a2, 0x233fe, 0x074d0,
 0x03b96, 0x0678f, 0x2462a, 0x068b6, 0x0681e, 0x03bc4, 0x06abe, 0x03863,
 0x237d5, 0x24487, 0x06a33, 0x06a52, 0x06ac9, 0x06b05, 0x21912, 0x06511,
 0x06898, 0x06a4c, 0x03bd7, 0x06a7a, 0x06b57, 0x23fc0, 0x23c9a, 0x093a0,
 0x092f2, 0x28bea, 0x28acb, 0x09289, 0x2801e, 0x289dc, 0x09467, 0x06da5,
 0x06f0b, 0x249ec, 0x06d67, 0x23f7f, 0x03d8f, 0x06e04, 0x2403c, 0x05a3d,
 0x06e0a, 0x05847, 0x06d24, 0x07842, 0x0713b, 0x2431a, 0x24276, 0x070f1,
 0x07250, 0x07287, 0x07294, 0x2478f, 0x24725, 0x05179, 0x24aa4, 0x205eb,
 0x0747a, 0x23ef8, 0x2365f, 0x24a4a, 0x24917, 0x25fe1, 0x03f06, 0x03eb1,
 0x24adf, 0x28c23, 0x23f35, 0x060a7, 0x03ef3, 0x074cc, 0x0743c, 0x09387,
 0x07437, 0x0449f, 0x26dea, 0x04551, 0x07583, 0x03f63, 0x24cd9, 0x24d06,
 0x03f58, 0x07555, 0x07673, 0x2a5c6, 0x03b19, 0x07468, 0x28acc, 0x249ab,
 0x2498e, 0x03afb, 0x03dcd, 0x24a4e, 0x03eff, 0x249c5, 0x248f3, 0x091fa,
 0x05732, 0x09342, 0x28ae3, 0x21864, 0x050df, 0x25221, 0x251e7, 0x07778,
 0x23232, 0x0770e, 0x0770f, 0x0777b, 0x24697, 0x23781, 0x03a5e, 0x248f0,
 0x07438, 0x0749b, 0x03ebf, 0x24aba, 0x24ac7, 0x040c8, 0x24a96, 0x261ae,
 0x09307, 0x25581, 0x0781e, 0x0788d, 0x07888, 0x078d2, 0x073d0, 0x07959,
 0x27741, 0x256e3, 0x0410e, 0x0799b, 0x08496, 0x079a5, 0x06a2d, 0x23efa,
 0x07a3a, 0x079f4, 0x0416e, 0x216e6, 0x04132, 0x09235, 0x079f1, 0x20d4c,
 0x2498c, 0x20299, 0x23dba, 0x2176e, 0x03597, 0x0556b, 0x03570, 0x036aa,
 0x201d4, 0x20c0d, 0x07ae2, 0x05a59, 0x226f5, 0x25aaf, 0x25a9c, 0x05a0d,
 0x2025b, 0x078f0, 0x05a2a, 0x25bc6, 0x07afe, 0x041f9, 0x07c5d, 0x07c6d,
 0x04211, 0x25bb3, 0x25ebc, 0x25ea6, 0x07ccd, 0x249f9, 0x217b0, 0x07c8e,
 0x07c7c, 0x07cae, 0x06ab2, 0x07ddc, 0x07e07, 0x07dd3, 0x07f4e, 0x26261,
 0x2615c, 0x27b48, 0x07d97, 0x25e82, 0x0426a, 0x26b75, 0x20916, 0x067d6,
 0x2004e, 0x235cf, 0x057c4, 0x26412, 0x263f8, 0x24962, 0x07fdd, 0x07b27,
 0x2082c, 0x25ae9, 0x25d43, 0x07b0c, 0x25e0e, 0x099e6, 0x08645, 0x09a63,
 0x06a1c, 0x2343f, 0x039e2, 0x249f7, 0x265ad, 0x09a1f, 0x265a0, 0x08480,
 0x27127, 0x26cd1, 0x044ea, 0x08137, 0x04402, 0x080c6, 0x08109, 0x08142,
 0x267b4, 0x098c3, 0x26a42, 0x08262, 0x08265, 0x26a51, 0x08453, 0x26da7,
 0x08610, 0x2721b, 0x05a86, 0x0417f, 0x21840, 0x05b2b, 0x218a1, 0x05ae4,
 0x218d8, 0x086a0, 0x2f9bc, 0x23d8f, 0x0882d, 0x27422, 0x05a02, 0x0886e,
 0x04f45, 0x08887, 0x088bf, 0x088e6, 0x08965, 0x0894d, 0x25683, 0x08954,
 0x27785, 0x27784, 0x28bf5, 0x28bd9, 0x28b9c, 0x289f9, 0x03ead, 0x084a3,
 0x046f5, 0x046cf, 0x037f2, 0x08a3d, 0x08a1c, 0x29448, 0x05f4d, 0x0922b,
 0x24284, 0x065d4, 0x07129, 0x070c4, 0x21845, 0x09d6d, 0x08c9f, 0x08ce9,
 0x27ddc, 0x0599a, 0x077c3, 0x059f0, 0x0436e, 0x036d4, 0x08e2a, 0x08ea7,
 0x24c09, 0x08f30, 0x08f4a, 0x042f4, 0x06c58, 0x06fbb, 0x22321, 0x0489b,
 0x06f79, 0x06e8b, 0x217da, 0x09be9, 0x036b5, 0x2492f, 0x090bb, 0x09097,
 0x05571, 0x04906, 0x091bb, 0x09404, 0x28a4b, 0x04062, 0x28afc, 0x09427,
 0x28c1d, 0x28c3b, 0x084e5, 0x08a2b, 0x09599, 0x095a7, 0x09597, 0x09596,
 0x28d34, 0x07445, 0x03ec2, 0x248ff, 0x24a42, 0x243ea, 0x03ee7, 0x23225,
 0x0968f, 0x28ee7, 0x28e66, 0x28e65, 0x03ecc, 0x249ed, 0x24a78, 0x23fee,
 0x07412, 0x0746b, 0x03efc, 0x09741, 0x290b0, 0x06847, 0x04a1d, 0x29093,
 0x257df, 0x0975d, 0x09368, 0x28989, 0x28c26, 0x28b2f, 0x263be, 0x092ba,
 0x05b11, 0x08b69, 0x0493c, 0x073f9, 0x2421b, 0x0979b, 0x09771, 0x09938,
 0x20f26, 0x05dc1, 0x28bc5, 0x24ab2, 0x0981f, 0x294da, 0x092f6, 0x295d7,
 0x091e5, 0x044c0, 0x28b50, 0x24a67, 0x28b64, 0x098dc, 0x28a45, 0x03f00,
 0x0922a, 0x04925, 0x08414, 0x0993b, 0x0994d, 0x27b06, 0x03dfd, 0x0999b,
 0x04b6f, 0x099aa, 0x09a5c, 0x28b65, 0x258c8, 0x06a8f, 0x09a21, 0x05afe,
 0x09a2f, 0x298f1, 0x04b90, 0x29948, 0x099bc, 0x04bbd, 0x04b97, 0x0937d,
 0x05872, 0x21302, 0x05822, 0x249b8, 0x214e8, 0x07844, 0x2271f, 0x23db8,
 0x068c5, 0x03d7d, 0x09458, 0x03927, 0x06150, 0x22781, 0x2296b, 0x06107,
 0x09c4f, 0x09c53, 0x09c7b, 0x09c35, 0x09c10, 0x09b7f, 0x09bcf, 0x29e2d,
 0x09b9f, 0x2a1f5, 0x2a0fe, 0x09d21, 0x04cae, 0x24104, 0x09e18, 0x04cb0,
 0x09d0c, 0x2a1b4, 0x2a0ed, 0x2a0f3, 0x2992f, 0x09da5, 0x084bd, 0x26e12,
 0x26fdf, 0x26b82, 0x085fc, 0x04533, 0x26da4, 0x26e84, 0x26df0, 0x08420,
 0x085ee, 0x26e00, 0x237d7, 0x26064, 0x079e2, 0x2359c, 0x23640, 0x0492d,
 0x249de, 0x03d62, 0x093db, 0x092be, 0x09348, 0x202bf, 0x078b9, 0x09277,
 0x0944d, 0x04fe4, 0x03440, 0x09064, 0x2555d, 0x0783d, 0x07854, 0x078b6,
 0x0784b, 0x21757, 0x231c9, 0x24941, 0x0369a, 0x04f72, 0x06fda, 0x06fd9,
 0x0701e, 0x0701e, 0x05414, 0x241b5, 0x057bb, 0x058f3, 0x0578a, 0x09d16,
 0x057d7, 0x07134, 0x034af, 0x241ac, 0x071eb, 0x26c40, 0x24f97, 0x05b28,
 0x217b5, 0x28a49, 0x0610c, 0x05ace, 0x05a0b, 0x042bc, 0x24488, 0x0372c,
 0x04b7b, 0x289fc, 0x093bb, 0x093b8, 0x218d6, 0x20f1d, 0x08472, 0x26cc0,
 0x21413, 0x242fa, 0x22c26, 0x243c1, 0x05994, 0x23db7, 0x26741, 0x07da8,
 0x2615b, 0x260a4, 0x249b9, 0x2498b, 0x289fa, 0x092e5, 0x073e2, 0x03ee9,
 0x074b4, 0x28b63, 0x2189f, 0x03ee1, 0x24ab3, 0x06ad8, 0x073f3, 0x073fb,
 0x03ed6, 0x24a3e, 0x24a94, 0x217d9, 0x24a66, 0x203a7, 0x21424, 0x249e5,
 0x07448, 0x24916, 0x070a5, 0x24976, 0x09284, 0x073e6, 0x0935f, 0x204fe,
 0x09331, 0x28ace, 0x28a16, 0x09386, 0x28be7, 0x255d5, 0x04935, 0x28a82,
 0x0716b, 0x24943, 0x20cff, 0x056a4, 0x2061a, 0x20beb, 0x20cb8, 0x05502,
 0x079c4, 0x217fa, 0x07dfe, 0x216c2, 0x24a50, 0x21852, 0x0452e, 0x09401,
 0x0370a, 0x28ac0, 0x249ad, 0x059b0, 0x218bf, 0x21883, 0x27484, 0x05aa1,
 0x036e2, 0x23d5b, 0x036b0, 0x0925f, 0x05a79, 0x28a81, 0x21862, 0x09374,
 0x03ccd, 0x20ab4, 0x04a96, 0x0398a, 0x050f4, 0x03d69, 0x03d4c, 0x2139c,
 0x07175, 0x042fb, 0x28218, 0x06e0f, 0x290e4, 0x044eb, 0x06d57, 0x27e4f,
 0x07067, 0x06caf, 0x03cd6, 0x23fed, 0x23e2d, 0x06e02, 0x06f0c, 0x03d6f,
 0x203f5, 0x07551, 0x036bc, 0x034c8, 0x04680, 0x03eda, 0x04871, 0x059c4,
 0x0926e, 0x0493e, 0x08f41, 0x28c1c, 0x26bc0, 0x05812, 0x057c8, 0x036d6,
 0x21452, 0x070fe, 0x24362, 0x24a71, 0x22fe3, 0x212b0, 0x223bd, 0x068b9,
 0x06967, 0x21398, 0x234e5, 0x27bf4, 0x236df, 0x28a83, 0x237d6, 0x233fa,
 0x24c9f, 0x06a1a, 0x236ad, 0x26cb7, 0x0843e, 0x044df, 0x044ce, 0x26d26,
 0x26d51, 0x26c82, 0x26fde, 0x06f17, 0x27109, 0x0833d, 0x2173a, 0x083ed,
 0x26c80, 0x27053, 0x217db, 0x05989, 0x05a82, 0x217b3, 0x05a61, 0x05a71,
 0x21905, 0x241fc, 0x0372d, 0x059ef, 0x2173c, 0x036c7, 0x0718e, 0x09390,
 0x0669a, 0x242a5, 0x05a6e, 0x05a2b, 0x24293, 0x06a2b, 0x23ef9, 0x27736,
 0x2445b, 0x242ca, 0x0711d, 0x24259, 0x289e1, 0x04fb0, 0x26d28, 0x05cc2,
 0x244ce, 0x27e4d, 0x243bd, 0x06a0c, 0x24256, 0x21304, 0x070a6, 0x07133,
 0x243e9, 0x03da5, 0x06cdf, 0x2f825, 0x24a4f, 0x07e65, 0x059eb, 0x05d2f,
 0x03df3, 0x05f5c, 0x24a5d, 0x217df, 0x07da4, 0x08426, 0x05485, 0x23afa,
 0x23300, 0x20214, 0x0577e, 0x208d5, 0x20619, 0x03fe5, 0x21f9e, 0x2a2b6,
 0x07003, 0x2915b, 0x05d70, 0x0738f, 0x07cd3, 0x28a59, 0x29420, 0x04fc8,
 0x07fe7, 0x072cd, 0x07310, 0x27af4, 0x07338, 0x07339, 0x256f6, 0x07341,
 0x07348, 0x03ea9, 0x27b18, 0x0906c, 0x071f5, 0x248f2, 0x073e1, 0x081f6,
 0x03eca, 0x0770c, 0x03ed1, 0x06ca2, 0x056fd, 0x07419, 0x0741e, 0x0741f,
 0x03ee2, 0x03ef0, 0x03ef4, 0x03efa, 0x074d3, 0x03f0e, 0x03f53, 0x07542,
 0x0756d, 0x07572, 0x0758d, 0x03f7c, 0x075c8, 0x075dc, 0x03fc0, 0x0764d,
 0x03fd7, 0x07674, 0x03fdc, 0x0767a, 0x24f5c, 0x07188, 0x05623, 0x08980,
 0x05869, 0x0401d, 0x07743, 0x04039, 0x06761, 0x04045, 0x035db, 0x07798,
 0x0406a, 0x0406f, 0x05c5e, 0x077be, 0x077cb, 0x058f2, 0x07818, 0x070b9,
 0x0781c, 0x040a8, 0x07839, 0x07847, 0x07851, 0x07866, 0x08448, 0x25535,
 0x07933, 0x06803, 0x07932, 0x04103, 0x04109, 0x07991, 0x07999, 0x08fbb,
 0x07a06, 0x08fbc, 0x04167, 0x07a91, 0x041b2, 0x07abc, 0x08279, 0x041c4,
 0x07acf, 0x07adb, 0x041cf, 0x04e21, 0x07b62, 0x07b6c, 0x07b7b, 0x07c12,
 0x07c1b, 0x04260, 0x0427a, 0x07c7b, 0x07c9c, 0x0428c, 0x07cb8, 0x04294,
 0x07ced, 0x08f93, 0x070c0, 0x20ccf, 0x07dcf, 0x07dd4, 0x07dd0, 0x07dfd,
 0x07fae, 0x07fb4, 0x0729f, 0x04397, 0x08020, 0x08025, 0x07b39, 0x0802e,
 0x08031, 0x08054, 0x03dcc, 0x057b4, 0x070a0, 0x080b7, 0x080e9, 0x043ed,
 0x0810c, 0x0732a, 0x0810e, 0x08112, 0x07560, 0x08114, 0x04401, 0x03b39,
 0x08156, 0x08159, 0x0815a, 0x04413, 0x0583a, 0x0817c, 0x08184, 0x04425,
 0x08193, 0x0442d, 0x081a5, 0x057ef, 0x081c1, 0x081e4, 0x08254, 0x0448f,
 0x082a6, 0x08276, 0x082ca, 0x082d8, 0x082ff, 0x044b0, 0x08357, 0x09669,
 0x0698a, 0x08405, 0x070f5, 0x08464, 0x060e3, 0x08488, 0x04504, 0x084be,
 0x084e1, 0x084f8, 0x08510, 0x08538, 0x08552, 0x0453b, 0x0856f, 0x08570,
 0x085e0, 0x04577, 0x08672, 0x08692, 0x086b2, 0x086ef, 0x09645, 0x0878b,
 0x04606, 0x04617, 0x088ae, 0x088ff, 0x08924, 0x08947, 0x08991, 0x27967,
 0x08a29, 0x08a38, 0x08a94, 0x08ab4, 0x08c51, 0x08cd4, 0x08cf2, 0x08d1c,
 0x04798, 0x0585f, 0x08dc3, 0x047ed, 0x04eee, 0x08e3a, 0x055d8, 0x05754,
 0x08e71, 0x055f5, 0x08eb0, 0x04837, 0x08ece, 0x08ee2, 0x08ee4, 0x08eed,
 0x08ef2, 0x08fb7, 0x08fc1, 0x08fca, 0x08fcc, 0x09033, 0x099c4, 0x048ad,
 0x098e0, 0x09213, 0x0491e, 0x09228, 0x09258, 0x0926b, 0x092b1, 0x092ae,
 0x092bf, 0x092e3, 0x092eb, 0x092f3, 0x092f4, 0x092fd, 0x09343, 0x09384,
 0x093ad, 0x04945, 0x04951, 0x09ebf, 0x09417, 0x05301, 0x0941d, 0x0942d,
 0x0943e, 0x0496a, 0x09454, 0x09479, 0x0952d, 0x095a2, 0x049a7, 0x095f4,
 0x09633, 0x049e5, 0x067a0, 0x04a24, 0x09740, 0x04a35, 0x097b2, 0x097c2,
 0x05654, 0x04ae4, 0x060e8, 0x098b9, 0x04b19, 0x098f1, 0x05844, 0x0990e,
 0x09919, 0x051b4, 0x0991c, 0x09937, 0x09942, 0x0995d, 0x09962, 0x04b70,
 0x099c5, 0x04b9d, 0x09a3c, 0x09b0f, 0x07a83, 0x09b69, 0x09b81, 0x09bdd,
 0x09bf1, 0x09bf4, 0x04c6d, 0x09c20, 0x0376f, 0x21bc2, 0x09d49, 0x09c3a,
 0x09efe, 0x05650, 0x09d93, 0x09dbd, 0x09dc0, 0x09dfc, 0x094f6, 0x08fb6,
 0x09e7b, 0x09eac, 0x09eb1, 0x09ebd, 0x09ec6, 0x094dc, 0x09ee2, 0x09ef1,
 0x09ef8, 0x07ac8, 0x09f44, 0x20094, 0x202b7, 0x203a0, 0x0691a, 0x094c3,
 0x059ac, 0x204d7, 0x05840, 0x094c1, 0x037b9, 0x205d5, 0x20615, 0x20676,
 0x216ba, 0x05757, 0x07173, 0x20ac2, 0x20acd, 0x20bbf, 0x0546a, 0x2f83b,
 0x20bcb, 0x0549e, 0x20bfb, 0x20c3b, 0x20c53, 0x20c65, 0x20c7c, 0x060e7,
 0x20c8d, 0x0567a, 0x20cb5, 0x20cdd, 0x20ced, 0x20d6f, 0x20db2, 0x20dc8,
 0x06955, 0x09c2f, 0x087a5, 0x20e04, 0x20e0e, 0x20ed7, 0x20f90, 0x20f2d,
 0x20e73, 0x05c20, 0x20fbc, 0x05e0b, 0x2105c, 0x2104f, 0x21076, 0x0671e,
 0x2107b, 0x21088, 0x21096, 0x03647, 0x210bf, 0x210d3, 0x2112f, 0x2113b,
 0x05364, 0x084ad, 0x212e3, 0x21375, 0x21336, 0x08b81, 0x21577, 0x21619,
 0x217c3, 0x217c7, 0x04e78, 0x070bb, 0x2182d, 0x2196a, 0x21a2d, 0x21a45,
 0x21c2a, 0x21c70, 0x21cac, 0x21ec8, 0x062c3, 0x21ed5, 0x21f15, 0x07198,
 0x06855, 0x22045, 0x069e9, 0x036c8, 0x2227c, 0x223d7, 0x223fa, 0x2272a,
 0x22871, 0x2294f, 0x082fd, 0x22967, 0x22993, 0x22ad5, 0x089a5, 0x22ae8,
 0x08fa0, 0x22b0e, 0x097b8, 0x22b3f, 0x09847, 0x09abd, 0x22c4c, 0x22c88,
 0x22cb7, 0x25be8, 0x22d08, 0x22d12, 0x22db7, 0x22d95, 0x22e42, 0x22f74,
 0x22fcc, 0x23033, 0x23066, 0x2331f, 0x233de, 0x05fb1, 0x06648, 0x066bf,
 0x27a79, 0x23567, 0x235f3, 0x07201, 0x249ba, 0x077d7, 0x2361a, 0x23716,
 0x07e87, 0x20346, 0x058b5, 0x0670e, 0x06918, 0x23aa7, 0x27657, 0x25fe2,
 0x23e11, 0x23eb9, 0x275fe, 0x2209a, 0x048d0, 0x04ab8, 0x24119, 0x28a9a,
 0x242ee, 0x2430d, 0x2403b, 0x24334, 0x24396, 0x24a45, 0x205ca, 0x051d2,
 0x20611, 0x0599f, 0x21ea8, 0x03bbe, 0x23cff, 0x24404, 0x244d6, 0x05788,
 0x24674, 0x0399b, 0x2472f, 0x285e8, 0x299c9, 0x03762, 0x221c3, 0x08b5e,
 0x28b4e, 0x099d6, 0x24812, 0x248fb, 0x24a15, 0x07209, 0x24ac0, 0x20c78,
 0x05965, 0x24ea5, 0x24f86, 0x20779, 0x08eda, 0x2502c, 0x0528f, 0x0573f,
 0x07171, 0x25299, 0x25419, 0x23f4a, 0x24aa7, 0x055bc, 0x25446, 0x2546e,
 0x26b52, 0x091d4, 0x03473, 0x2553f, 0x27632, 0x2555e, 0x04718, 0x25562,
 0x25566, 0x257c7, 0x2493f, 0x2585d, 0x05066, 0x034fb, 0x233cc, 0x060de,
 0x25903, 0x0477c, 0x28948, 0x25aae, 0x25b89, 0x25c06, 0x21d90, 0x057a1,
 0x07151, 0x06fb6, 0x26102, 0x27c12, 0x09056, 0x261b2, 0x24f9a, 0x08b62,
 0x26402, 0x2644a, 0x05d5b, 0x26bf7, 0x08f36, 0x26484, 0x2191c, 0x08aea,
 0x249f6, 0x26488, 0x23fef, 0x26512, 0x04bc0, 0x265bf, 0x266b5, 0x2271b,
 0x09465, 0x257e1, 0x06195, 0x05a27, 0x2f8cd, 0x04fbb, 0x056b9, 0x24521,
 0x266fc, 0x04e6a, 0x24934, 0x09656, 0x06d8f, 0x26cbd, 0x03618, 0x08977,
 0x26799, 0x2686e, 0x26411, 0x2685e, 0x071df, 0x268c7, 0x07b42, 0x290c0,
 0x20a11, 0x26926, 0x09104, 0x26939, 0x07a45, 0x09df0, 0x269fa, 0x09a26,
 0x26a2d, 0x0365f, 0x26469, 0x20021, 0x07983, 0x26a34, 0x26b5b, 0x05d2c,
 0x23519, 0x083cf, 0x26b9d, 0x046d0, 0x26ca4, 0x0753b, 0x08865, 0x26dae,
 0x058b6, 0x0371c, 0x2258d, 0x2704b, 0x271cd, 0x03c54, 0x27280, 0x27285,
 0x09281, 0x2217a, 0x2728b, 0x09330, 0x272e6, 0x249d0, 0x06c39, 0x0949f,
 0x27450, 0x20ef8, 0x08827, 0x088f5, 0x22926, 0x28473, 0x217b1, 0x06eb8,
 0x24a2a, 0x21820, 0x039a4, 0x036b9, 0x05c10, 0x079e3, 0x0453f, 0x066b6,
 0x29cad, 0x298a4, 0x08943, 0x277cc, 0x27858, 0x056d6, 0x040df, 0x2160a,
 0x039a1, 0x2372f, 0x280e8, 0x213c5, 0x071ad, 0x08366, 0x279dd, 0x291a8,
 0x05a67, 0x04cb7, 0x270af, 0x289ab, 0x279fd, 0x27a0a, 0x27b0b, 0x27d66,
 0x2417a, 0x07b43, 0x0797e, 0x28009, 0x06fb5, 0x2a2df, 0x06a03, 0x28318,
 0x053a2, 0x26e07, 0x093bf, 0x06836, 0x0975d, 0x2816f, 0x28023, 0x269b5,
 0x213ed, 0x2322f, 0x28048, 0x05d85, 0x28c30, 0x28083, 0x05715, 0x09823,
 0x28949, 0x05dab, 0x24988, 0x065be, 0x069d5, 0x053d2, 0x24aa5, 0x23f81,
 0x03c11, 0x06736, 0x28090, 0x280f4, 0x2812e, 0x21fa1, 0x2814f, 0x28189,
 0x281af, 0x2821a, 0x28306, 0x2832f, 0x2838a, 0x035ca, 0x28468, 0x286aa,
 0x048fa, 0x063e6, 0x28956, 0x07808, 0x09255, 0x289b8, 0x043f2, 0x289e7,
 0x043df, 0x289e8, 0x28b46, 0x28bd4, 0x059f8, 0x28c09, 0x08f0b, 0x28fc5,
 0x290ec, 0x07b51, 0x29110, 0x2913c, 0x03df7, 0x2915e, 0x24aca, 0x08fd0,
 0x0728f, 0x0568b, 0x294e7, 0x295e9, 0x295b0, 0x295b8, 0x29732, 0x298d1,
 0x29949, 0x2996a, 0x299c3, 0x29a28, 0x29b0e, 0x29d5a, 0x29d9b, 0x07e9f,
 0x29ef8, 0x29f23, 0x04ca4, 0x09547, 0x2a293, 0x071a2, 0x2a2ff, 0x04d91,
 0x09012, 0x2a5cb, 0x04d9c, 0x20c9c, 0x08fbe, 0x055c1, 0x08fba, 0x224b0,
 0x08fb9, 0x24a93, 0x04509, 0x07e7f, 0x06f56, 0x06ab1, 0x04eea, 0x034e4,
 0x28b2c, 0x2789d, 0x0373a, 0x08e80, 0x217f5, 0x28024, 0x28b6c, 0x28b99,
 0x27a3e, 0x266af, 0x03deb, 0x27655, 0x23cb7, 0x25635, 0x25956, 0x04e9a,
 0x25e81, 0x26258, 0x056bf, 0x20e6d, 0x08e0e, 0x05b6d, 0x23e88, 0x24c9e,
 0x063de, 0x062d0, 0x217f6, 0x2187b, 0x06530, 0x0562d, 0x25c4a, 0x0541a,
 0x25311, 0x03dc6, 0x29d98, 0x04c7d, 0x05622, 0x0561e, 0x07f49, 0x25ed8,
 0x05975, 0x23d40, 0x08770, 0x04e1c, 0x20fea, 0x20d49, 0x236ba, 0x08117,
 0x09d5e, 0x08d18, 0x0763b, 0x09c45, 0x0764e, 0x077b9, 0x09345, 0x05432,
 0x08148, 0x082f7, 0x05625, 0x08132, 0x08418, 0x080bd, 0x055ea, 0x07962,
 0x05643, 0x05416, 0x20e9d, 0x035ce, 0x05605, 0x055f1, 0x066f1, 0x282e2,
 0x0362d, 0x07534, 0x055f0, 0x055ba, 0x05497, 0x05572, 0x20c41, 0x20c96,
 0x05ed0, 0x25148, 0x20e76, 0x22c62, 0x20ea2, 0x09eab, 0x07d5a, 0x055de,
 0x21075, 0x0629d, 0x0976d, 0x05494, 0x08ccd, 0x071f6, 0x09176, 0x063fc,
 0x063b9, 0x063fe, 0x05569, 0x22b43, 0x09c72, 0x22eb3, 0x0519a, 0x034df,
 0x20da7, 0x051a7, 0x0544d, 0x0551e, 0x05513, 0x07666, 0x08e2d, 0x2688a,
 0x075b1, 0x080b6, 0x08804, 0x08786, 0x088c7, 0x081b6, 0x0841c, 0x210c1,
 0x044ec, 0x07304, 0x24706, 0x05b90, 0x0830b, 0x26893, 0x0567b, 0x226f4,
 0x27d2f, 0x241a3, 0x27d73, 0x26ed0, 0x272b6, 0x09170, 0x211d9, 0x09208,
 0x23cfc, 0x2a6a9, 0x20eac, 0x20ef9, 0x07266, 0x21ca2, 0x0474e, 0x24fc2,
 0x27ff9, 0x20feb, 0x040fa, 0x09c5d, 0x0651f, 0x22da0, 0x048f3, 0x247e0,
 0x29d7c, 0x20fec, 0x20e0a, 0x06062, 0x275a3, 0x20fed, 0x0ed2b, 0x26048,
 0x21187, 0x071a3, 0x07e8e, 0x09d50, 0x04e1a, 0x04e04, 0x03577, 0x05b0d,
 0x06cb2, 0x05367, 0x036ac, 0x039dc, 0x0537d, 0x036a5, 0x24618, 0x0589a,
 0x24b6e, 0x0822d, 0x0544b, 0x057aa, 0x25a95, 0x20979, 0x0ed43, 0x03a52,
 0x22465, 0x07374, 0x29eac, 0x04d09, 0x09bed, 0x23cfe, 0x29f30, 0x04c5b,
 0x24fa9, 0x2959e, 0x29fde, 0x0845c, 0x23db6, 0x272b2, 0x267b3, 0x23720,
 0x0632e, 0x07d25, 0x23ef7, 0x23e2c, 0x03a2a, 0x09008, 0x052cc, 0x03e74,
 0x0367a, 0x045e9, 0x2048e, 0x07640, 0x05af0, 0x20eb6, 0x0787a, 0x047b6,
 0x058a7, 0x040bf, 0x0567c, 0x09b8b, 0x05d74, 0x07654, 0x2a434, 0x09e85,
 0x04ce1, 0x075f9, 0x037fb, 0x06119, 0x230da, 0x243f2, 0x0ed73, 0x0565d,
 0x212a9, 0x057a7, 0x24963, 0x29e06, 0x05234, 0x270ae, 0x035ad, 0x06c4a,
 0x09d7c, 0x07c56, 0x09b39, 0x057de, 0x2176c, 0x05c53, 0x064d3, 0x294d0,
 0x26335, 0x27164, 0x086ad, 0x20d28, 0x26d22, 0x24ae2, 0x20d71, 0x0ed8c,
 0x051fe, 0x21f0f, 0x05d8e, 0x09703, 0x21dd1, 0x09e81, 0x0904c, 0x07b1f,
 0x09b02, 0x05cd1, 0x07ba3, 0x06268, 0x06335, 0x09aff, 0x07bcf, 0x09b2a,
 0x07c7e, 0x09b2e, 0x07c42, 0x07c86, 0x09c15, 0x07bfc, 0x09b09, 0x09f17,
 0x09c1b, 0x2493e, 0x09f5a, 0x05573, 0x05bc3, 0x04ffd, 0x09e98, 0x04ff2,
 0x05260, 0x03e06, 0x052d1, 0x05767, 0x05056, 0x059b7, 0x05e12, 0x097c8,
 0x09dab, 0x08f5c, 0x05469, 0x097b4, 0x09940, 0x097ba, 0x0532c, 0x06130,
 0x0692c, 0x053da, 0x09c0a, 0x09d02, 0x04c3b, 0x09641, 0x06980, 0x050a6,
 0x07546, 0x2176d, 0x099da, 0x05273, 0x0edc9, 0x09159, 0x09681, 0x0915c,
 0x0edcd, 0x09151, 0x28e97, 0x0637f, 0x26d23, 0x06aca, 0x05611, 0x0918e,
 0x0757a, 0x06285, 0x203fc, 0x0734f, 0x07c70, 0x25c21, 0x23cfd, 0x0eddc,
 0x24919, 0x076d6, 0x09b9d, 0x04e2a, 0x20cd4, 0x083be, 0x08842, 0x0ede4,
 0x05c4a, 0x069c0, 0x050ed, 0x0577a, 0x0521f, 0x05df5, 0x04ece, 0x06c31,
 0x201f2, 0x04f39, 0x0549c, 0x054da, 0x0529a, 0x08d82, 0x035fe, 0x05f0c,
 0x035f3, 0x0edf6, 0x06b52, 0x0917c, 0x09fa5, 0x09b97, 0x0982e, 0x098b4,
 0x09aba, 0x09ea8, 0x09e84, 0x0717a, 0x07b14, 0x0ee02, 0x06bfa, 0x08818,
 0x07f78, 0x0ee06, 0x05620, 0x2a64a, 0x08e77, 0x09f53, 0x0ee0b, 0x08dd4,
 0x08e4f, 0x09e1c, 0x08e01, 0x06282, 0x2837d, 0x08e28, 0x08e75, 0x07ad3,
 0x24a77, 0x07a3e, 0x078d8, 0x06cea, 0x08a67, 0x07607, 0x28a5a, 0x09f26,
 0x06cce, 0x087d6, 0x075c3, 0x2a2b2, 0x07853, 0x2f840, 0x08d0c, 0x072e2,
 0x07371, 0x08b2d, 0x07302, 0x074f1, 0x08ceb, 0x24abb, 0x0862f, 0x05fba,
 0x088a0, 0x044b7, 0x0ee2f, 0x2183b, 0x26e05, 0x0ee32, 0x08a7e, 0x2251b,
 0x0ee35, 0x060fd, 0x07667, 0x09ad7, 0x09d44, 0x0936e, 0x09b8f, 0x087f5,
 0x0ee3d, 0x0880f, 0x08cf7, 0x0732c, 0x09721, 0x09bb0, 0x035d6, 0x072b2,
 0x04c07, 0x07c51, 0x0994a, 0x26159, 0x06159, 0x04c04, 0x09e96, 0x0617d,
 0x0ee4d, 0x0575f, 0x0616f, 0x062a6, 0x06239, 0x062ce, 0x03a5c, 0x061e2,
 0x053aa, 0x233f5, 0x06364, 0x06802, 0x035d2, 0x05d57, 0x28bc2, 0x08fda,
 0x28e39, 0x0ee5e, 0x050d9, 0x21d46, 0x07906, 0x05332, 0x09638, 0x20f3b,
 0x04065, 0x0ee66, 0x077fe, 0x0ee68, 0x07cc2, 0x25f1a, 0x07cda, 0x07a2d,
 0x08066, 0x08063, 0x07d4d, 0x07505, 0x074f2, 0x08994, 0x0821a, 0x0670c,
 0x08062, 0x27486, 0x0805b, 0x074f0, 0x08103, 0x07724, 0x08989, 0x267cc,
 0x07553, 0x26ed1, 0x087a9, 0x087ce, 0x081c8, 0x0878c, 0x08a49, 0x08cad,
 0x08b43, 0x0772b, 0x074f8, 0x084da, 0x03635, 0x069b2, 0x08da6, 0x0ee8c,
 0x089a9, 0x07468, 0x06db9, 0x087c1, 0x24011, 0x074e7, 0x03ddb, 0x07176,
 0x060a4, 0x0619c, 0x03cd1, 0x07162, 0x06077, 0x0ee9a, 0x07f71, 0x28b2d,
 0x07250, 0x060e9, 0x04b7e, 0x05220, 0x03c18, 0x23cc7, 0x25ed7, 0x27656,
 0x25531, 0x21944, 0x212fe, 0x29903, 0x26ddc, 0x270ad, 0x05cc1, 0x261ad,
 0x28a0f, 0x23677, 0x200ee, 0x26846, 0x24f0e, 0x04562, 0x05b1f, 0x2634c,
 0x09f50, 0x09ea6, 0x2626b
};

/* 0xFA40 .. 0xFEFE */
static dpsunicode_t tab_hkscsFA40_uni[] = {
 0x20547, 0x092db, 0x205df, 0x23fc5, 0x0854c, 0x042b5, 0x073ef, 0x051b5,
 0x03649, 0x24942, 0x289e4, 0x09344, 0x219db, 0x082ee, 0x23cc8, 0x0783c,
 0x06744, 0x062df, 0x24933, 0x289aa, 0x202a0, 0x26bb3, 0x21305, 0x04fab,
 0x224ed, 0x05008, 0x26d29, 0x27a84, 0x23600, 0x24ab1, 0x22513, 0x05029,
 0x2037e, 0x05fa4, 0x20380, 0x20347, 0x06edb, 0x2041f, 0x0507d, 0x05101,
 0x0347a, 0x0510e, 0x0986c, 0x03743, 0x08416, 0x249a4, 0x20487, 0x05160,
 0x233b4, 0x0516a, 0x20bff, 0x220fc, 0x202e5, 0x22530, 0x2058e, 0x23233,
 0x21983, 0x05b82, 0x0877d, 0x205b3, 0x23c99, 0x051b2, 0x051b8, 0x09d34,
 0x051c9, 0x051cf, 0x051d1, 0x03cdc, 0x051d3, 0x24aa6, 0x051b3, 0x051e2,
 0x05342, 0x051ed, 0x083cd, 0x0693e, 0x2372d, 0x05f7b, 0x0520b, 0x05226,
 0x0523c, 0x052b5, 0x05257, 0x05294, 0x052b9, 0x052c5, 0x07c15, 0x08542,
 0x052e0, 0x0860d, 0x26b13, 0x05305, 0x28ade, 0x05549, 0x06ed9, 0x23f80,
 0x20954, 0x23fec, 0x05333, 0x03039, 0x20be2, 0x06ccb, 0x21726, 0x0681b,
 0x073d5, 0x0604a, 0x03eaa, 0x038cc, 0x216e8, 0x071dd, 0x044a2, 0x0536d,
 0x05374, 0x286ab, 0x0537e, 0x0537f, 0x21596, 0x21613, 0x077e6, 0x05393,
 0x28a9b, 0x053a0, 0x053ab, 0x053ae, 0x073a7, 0x25772, 0x03f59, 0x0739c,
 0x053c1, 0x053c5, 0x06c49, 0x04e49, 0x057fe, 0x053d9, 0x03aab, 0x20b8f,
 0x053e0, 0x23feb, 0x22da3, 0x053f6, 0x20c77, 0x05413, 0x07079, 0x0552b,
 0x06657, 0x06d5b, 0x0546d, 0x26b53, 0x20d74, 0x0555d, 0x0548f, 0x054a4,
 0x047a6, 0x2170d, 0x20edd, 0x03db4, 0x20d4d, 0x289bc, 0x22698, 0x05547,
 0x04ced, 0x0542f, 0x07417, 0x05586, 0x055a9, 0x05605, 0x218d7, 0x2403a,
 0x04552, 0x24435, 0x066b3, 0x210b4, 0x05637, 0x066cd, 0x2328a, 0x066a4,
 0x066ad, 0x0564d, 0x0564f, 0x078f1, 0x056f1, 0x09787, 0x053fe, 0x05700,
 0x056ef, 0x056ed, 0x28b66, 0x03623, 0x2124f, 0x05746, 0x241a5, 0x06c6e,
 0x0708b, 0x05742, 0x036b1, 0x26c7e, 0x057e6, 0x21416, 0x05803, 0x21454,
 0x24363, 0x05826, 0x24bf5, 0x0585c, 0x058aa, 0x03561, 0x058e0, 0x058dc,
 0x2123c, 0x058fb, 0x05bff, 0x05743, 0x2a150, 0x24278, 0x093d3, 0x035a1,
 0x0591f, 0x068a6, 0x036c3, 0x06e59, 0x2163e, 0x05a24, 0x05553, 0x21692,
 0x08505, 0x059c9, 0x20d4e, 0x26c81, 0x26d2a, 0x217dc, 0x059d9, 0x217fb,
 0x217b2, 0x26da6, 0x06d71, 0x21828, 0x216d5, 0x059f9, 0x26e45, 0x05aab,
 0x05a63, 0x036e6, 0x249a9, 0x05a77, 0x03708, 0x05a96, 0x07465, 0x05ad3,
 0x26fa1, 0x22554, 0x03d85, 0x21911, 0x03732, 0x216b8, 0x05e83, 0x052d0,
 0x05b76, 0x06588, 0x05b7c, 0x27a0e, 0x04004, 0x0485d, 0x20204, 0x05bd5,
 0x06160, 0x21a34, 0x259cc, 0x205a5, 0x05bf3, 0x05b9d, 0x04d10, 0x05c05,
 0x21b44, 0x05c13, 0x073ce, 0x05c14, 0x21ca5, 0x26b28, 0x05c49, 0x048dd,
 0x05c85, 0x05ce9, 0x05cef, 0x05d8b, 0x21df9, 0x21e37, 0x05d10, 0x05d18,
 0x05d46, 0x21ea4, 0x05cba, 0x05dd7, 0x082fc, 0x0382d, 0x24901, 0x22049,
 0x22173, 0x08287, 0x03836, 0x03bc2, 0x05e2e, 0x06a8a, 0x05e75, 0x05e7a,
 0x244bc, 0x20cd3, 0x053a6, 0x04eb7, 0x05ed0, 0x053a8, 0x21771, 0x05e09,
 0x05ef4, 0x28482, 0x05ef9, 0x05efb, 0x038a0, 0x05efc, 0x0683e, 0x0941b,
 0x05f0d, 0x201c1, 0x2f894, 0x03ade, 0x048ae, 0x2133a, 0x05f3a, 0x26888,
 0x223d0, 0x05f58, 0x22471, 0x05f63, 0x097bd, 0x26e6e, 0x05f72, 0x09340,
 0x28a36, 0x05fa7, 0x05db6, 0x03d5f, 0x25250, 0x21f6a, 0x270f8, 0x22668,
 0x091d6, 0x2029e, 0x28a29, 0x06031, 0x06685, 0x21877, 0x03963, 0x03dc7,
 0x03639, 0x05790, 0x227b4, 0x07971, 0x03e40, 0x0609e, 0x060a4, 0x060b3,
 0x24982, 0x2498f, 0x27a53, 0x074a4, 0x050e1, 0x05aa0, 0x06164, 0x08424,
 0x06142, 0x2f8a6, 0x26ed2, 0x06181, 0x051f4, 0x20656, 0x06187, 0x05baa,
 0x23fb7, 0x2285f, 0x061d3, 0x28b9d, 0x2995d, 0x061d0, 0x03932, 0x22980,
 0x228c1, 0x06023, 0x0615c, 0x0651e, 0x0638b, 0x20118, 0x062c5, 0x21770,
 0x062d5, 0x22e0d, 0x0636c, 0x249df, 0x03a17, 0x06438, 0x063f8, 0x2138e,
 0x217fc, 0x06490, 0x06f8a, 0x22e36, 0x09814, 0x2408c, 0x2571d, 0x064e1,
 0x064e5, 0x0947b, 0x03a66, 0x0643a, 0x03a57, 0x0654d, 0x06f16, 0x24a28,
 0x24a23, 0x06585, 0x0656d, 0x0655f, 0x2307e, 0x065b5, 0x24940, 0x04b37,
 0x065d1, 0x040d8, 0x21829, 0x065e0, 0x065e3, 0x05fdf, 0x23400, 0x06618,
 0x231f7, 0x231f8, 0x06644, 0x231a4, 0x231a5, 0x0664b, 0x20e75, 0x06667,
 0x251e6, 0x06673, 0x06674, 0x21e3d, 0x23231, 0x285f4, 0x231c8, 0x25313,
 0x077c5, 0x228f7, 0x099a4, 0x06702, 0x2439c, 0x24a21, 0x03b2b, 0x069fa,
 0x237c2, 0x0675e, 0x06767, 0x06762, 0x241cd, 0x290ed, 0x067d7, 0x044e9,
 0x06822, 0x06e50, 0x0923c, 0x06801, 0x233e6, 0x26da0, 0x0685d, 0x2346f,
 0x069e1, 0x06a0b, 0x28adf, 0x06973, 0x068c3, 0x235cd, 0x06901, 0x06900,
 0x03d32, 0x03a01, 0x2363c, 0x03b80, 0x067ac, 0x06961, 0x28a4a, 0x042fc,
 0x06936, 0x06998, 0x03ba1, 0x203c9, 0x08363, 0x05090, 0x069f9, 0x23659,
 0x2212a, 0x06a45, 0x23703, 0x06a9d, 0x03bf3, 0x067b1, 0x06ac8, 0x2919c,
 0x03c0d, 0x06b1d, 0x20923, 0x060de, 0x06b35, 0x06b74, 0x227cd, 0x06eb5,
 0x23adb, 0x203b5, 0x21958, 0x03740, 0x05421, 0x23b5a, 0x06be1, 0x23efc,
 0x06bdc, 0x06c37, 0x2248b, 0x248f1, 0x26b51, 0x06c5a, 0x08226, 0x06c79,
 0x23dbc, 0x044c5, 0x23dbd, 0x241a4, 0x2490c, 0x24900, 0x23cc9, 0x036e5,
 0x03ceb, 0x20d32, 0x09b83, 0x231f9, 0x22491, 0x07f8f, 0x06837, 0x26d25,
 0x26da1, 0x26deb, 0x06d96, 0x06d5c, 0x06e7c, 0x06f04, 0x2497f, 0x24085,
 0x26e72, 0x08533, 0x26f74, 0x051c7, 0x06c9c, 0x06e1d, 0x0842e, 0x28b21,
 0x06e2f, 0x23e2f, 0x07453, 0x23f82, 0x079cc, 0x06e4f, 0x05a91, 0x2304b,
 0x06ff8, 0x0370d, 0x06f9d, 0x23e30, 0x06efa, 0x21497, 0x2403d, 0x04555,
 0x093f0, 0x06f44, 0x06f5c, 0x03d4e, 0x06f74, 0x29170, 0x03d3b, 0x06f9f,
 0x24144, 0x06fd3, 0x24091, 0x24155, 0x24039, 0x23ff0, 0x23fb4, 0x2413f,
 0x051df, 0x24156, 0x24157, 0x24140, 0x261dd, 0x0704b, 0x0707e, 0x070a7,
 0x07081, 0x070cc, 0x070d5, 0x070d6, 0x070df, 0x04104, 0x03de8, 0x071b4,
 0x07196, 0x24277, 0x0712b, 0x07145, 0x05a88, 0x0714a, 0x0716e, 0x05c9c,
 0x24365, 0x0714f, 0x09362, 0x242c1, 0x0712c, 0x2445a, 0x24a27, 0x24a22,
 0x071ba, 0x28be8, 0x070bd, 0x0720e, 0x09442, 0x07215, 0x05911, 0x09443,
 0x07224, 0x09341, 0x25605, 0x0722e, 0x07240, 0x24974, 0x068bd, 0x07255,
 0x07257, 0x03e55, 0x23044, 0x0680d, 0x06f3d, 0x07282, 0x0732a, 0x0732b,
 0x24823, 0x2882b, 0x048ed, 0x28804, 0x07328, 0x0732e, 0x073cf, 0x073aa,
 0x20c3a, 0x26a2e, 0x073c9, 0x07449, 0x241e2, 0x216e7, 0x24a24, 0x06623,
 0x036c5, 0x249b7, 0x2498d, 0x249fb, 0x073f7, 0x07415, 0x06903, 0x24a26,
 0x07439, 0x205c3, 0x03ed7, 0x0745c, 0x228ad, 0x07460, 0x28eb2, 0x07447,
 0x073e4, 0x07476, 0x083b9, 0x0746c, 0x03730, 0x07474, 0x093f1, 0x06a2c,
 0x07482, 0x04953, 0x24a8c, 0x2415f, 0x24a79, 0x28b8f, 0x05b46, 0x28c03,
 0x2189e, 0x074c8, 0x21988, 0x0750e, 0x074e9, 0x0751e, 0x28ed9, 0x21a4b,
 0x05bd7, 0x28eac, 0x09385, 0x0754d, 0x0754a, 0x07567, 0x0756e, 0x24f82,
 0x03f04, 0x24d13, 0x0758e, 0x0745d, 0x0759e, 0x075b4, 0x07602, 0x0762c,
 0x07651, 0x0764f, 0x0766f, 0x07676, 0x263f5, 0x07690, 0x081ef, 0x037f8,
 0x26911, 0x2690e, 0x076a1, 0x076a5, 0x076b7, 0x076cc, 0x26f9f, 0x08462,
 0x2509d, 0x2517d, 0x21e1c, 0x0771e, 0x07726, 0x07740, 0x064af, 0x25220,
 0x07758, 0x232ac, 0x077af, 0x28964, 0x28968, 0x216c1, 0x077f4, 0x07809,
 0x21376, 0x24a12, 0x068ca, 0x078af, 0x078c7, 0x078d3, 0x096a5, 0x0792e,
 0x255e0, 0x078d7, 0x07934, 0x078b1, 0x2760c, 0x08fb8, 0x08884, 0x28b2b,
 0x26083, 0x2261c, 0x07986, 0x08900, 0x06902, 0x07980, 0x25857, 0x0799d,
 0x27b39, 0x0793c, 0x079a9, 0x06e2a, 0x27126, 0x03ea8, 0x079c6, 0x2910d,
 0x079d4
};



int dps_mb_wc_big5hkscs(DPS_CONV *conv, DPS_CHARSET *cs, dpsunicode_t *pwc, const unsigned char *s, const unsigned char *e) {

  if ((e - s) > 1) {
    int hi = s[0];
    hi = (hi << 8) + s[1];
    if ((hi >= 0x8840) && (hi <= 0xA0FE)) {
      pwc[0] = tab_hkscs8840_uni[hi - 0x8840];
      conv->ocodes = 1;
      return conv->icodes = 2;
    }
    if ((hi >= 0xFA40) && (hi <= 0xFEFE)) {
      pwc[0] = tab_hkscsFA40_uni[hi - 0xFA40];
      conv->ocodes = 1;
      return conv->icodes = 2;
    }
  }
  return dps_mb_wc_cp950(conv, cs, pwc, s, e);
}


int dps_wc_mb_big5hkscs(DPS_CONV *conv, DPS_CHARSET *cs, const dpsunicode_t *wc, unsigned char *s, unsigned char *e) {
  register dps_uint4 code = 0;
  register int c0 = ((*wc) >> 8) & 255;
  register int c1 = (*wc) & 255;
  
  switch(c0) {
  case 0x00: switch(c1) {
    case 0xc0: code = 0x8859; break;
    case 0xc1: code = 0x8857; break;
    case 0xc8: code = 0x885d; break;
    case 0xc9: code = 0x885b; break;
    case 0xca: code = 0x8866; break;
    case 0xd2: code = 0x8861; break;
    case 0xd3: code = 0x885f; break;
    case 0xe0: code = 0x886a; break;
    case 0xe1: code = 0x8868; break;
    case 0xe8: code = 0x886f; break;
    case 0xe9: code = 0x886d; break;
    case 0xea: code = 0x88a7; break;
    case 0xec: code = 0x8873; break;
    case 0xed: code = 0x8871; break;
    case 0xf2: code = 0x8877; break;
    case 0xf3: code = 0x8875; break;
    case 0xf9: code = 0x887b; break;
    case 0xfa: code = 0x8879; break;
    case 0xfc: code = 0x88a2; break;
    default: break;
    }
    break;
  case 0x01: switch(c1) {
    case 0x00: code = 0x8856; break;
    case 0x01: code = 0x8867; break;
    case 0x12: code = 0x885a; break;
    case 0x13: code = 0x886c; break;
    case 0x1a: code = 0x885c; break;
    case 0x1b: code = 0x886e; break;
    case 0x2b: code = 0x8870; break;
    case 0x4c: code = 0x885e; break;
    case 0x4d: code = 0x8874; break;
    case 0x6b: code = 0x8878; break;
    case 0xcd: code = 0x8858; break;
    case 0xce: code = 0x8869; break;
    case 0xd0: code = 0x8872; break;
    case 0xd1: code = 0x8860; break;
    case 0xd2: code = 0x8876; break;
    case 0xd4: code = 0x887a; break;
    case 0xd6: code = 0x887c; break;
    case 0xd8: code = 0x887d; break;
    case 0xda: code = 0x887e; break;
    case 0xdc: code = 0x88a1; break;
    default: break;
    }
    break;
  case 0x02: switch(c1) {
    case 0x51: code = 0x886b; break;
    case 0x61: code = 0x88a8; break;
    default: break;
    }
    break;
  case 0x1e: switch(c1) {
    case 0xbe: code = 0x8863; break;
    case 0xbf: code = 0x88a4; break;
    case 0xc0: code = 0x8865; break;
    case 0xc1: code = 0x88a6; break;
    default: break;
    }
    break;
  case 0x30: switch(c1) {
    case 0x39: code = 0xfac5; break;
    default: break;
    }
    break;
  case 0x34: switch(c1) {
    case 0x35: code = 0x9277; break;
    case 0x40: code = 0x96df; break;
    case 0x4c: code = 0x89d5; break;
    case 0x64: code = 0x93cd; break;
    case 0x73: code = 0x9bdf; break;
    case 0x7a: code = 0xfa68; break;
    case 0x7d: code = 0x89da; break;
    case 0x7e: code = 0x8f59; break;
    case 0x93: code = 0x89db; break;
    case 0x96: code = 0x8f5d; break;
    case 0xa5: code = 0x89dc; break;
    case 0xaf: code = 0x96f7; break;
    case 0xbc: code = 0x8ada; break;
    case 0xc1: code = 0x8bdc; break;
    case 0xc8: code = 0x97db; break;
    case 0xdf: code = 0x9e53; break;
    case 0xe4: code = 0x9daa; break;
    case 0xfb: code = 0x9bea; break;
    }
    break;
  case 0x35: switch(c1) {
    case 0x06: code = 0x8a6e; break;
    case 0x3e: code = 0x8bc8; break;
    case 0x51: code = 0x89e8; break;
    case 0x53: code = 0x89ea; break;
    case 0x59: code = 0x8c4b; break;
    case 0x61: code = 0xfb70; break;
    case 0x6d: code = 0x89ed; break;
    case 0x70: code = 0x94dd; break;
    case 0x72: code = 0x89ee; break;
    case 0x77: code = 0x9eb4; break;
    case 0x78: code = 0x8ad3; break;
    case 0x84: code = 0x92db; break;
    case 0x97: code = 0x94db; break;
    case 0x98: code = 0x89f9; break;
    case 0xa1: code = 0xfb7a; break;
    case 0xa5: code = 0x89fb; break;
    case 0xad: code = 0x9efc; break;
    case 0xbf: code = 0x89fc; break;
    case 0xc1: code = 0x89bf; break;
    case 0xc5: code = 0x89fe; break;
    case 0xc7: code = 0x89e6; break;
    case 0xca: code = 0x9d46; break;
    case 0xce: code = 0x9dee; break;
    case 0xd2: code = 0xa07e; break;
    case 0xd6: code = 0xa068; break;
    case 0xdb: code = 0x98e9; break;
    case 0xdd: code = 0x8b68; break;
    case 0xf1: code = 0x8dfd; break;
    case 0xf2: code = 0x8bbe; break;
    case 0xf3: code = 0x9fd9; break;
    case 0xfb: code = 0x8aeb; break;
    case 0xfe: code = 0x9fd7; break;
    }
    break;
  case 0x36: switch(c1) {
    case 0x09: code = 0x8b6a; break;
    case 0x18: code = 0x9c5c; break;
    case 0x1a: code = 0x8bb1; break;
    case 0x23: code = 0xfb5e; break;
    case 0x2d: code = 0x9df3; break;
    case 0x35: code = 0xa0d0; break;
    case 0x39: code = 0xfc66; break;
    case 0x3e: code = 0x92e9; break;
    case 0x47: code = 0x9aec; break;
    case 0x48: code = 0x8fab; break;
    case 0x49: code = 0xfa48; break;
    case 0x4e: code = 0x8e45; break;
    case 0x5f: code = 0x9c6f; break;
    case 0x7a: code = 0x9ede; break;
    case 0x81: code = 0x89ef; break;
    case 0x9a: code = 0x96e9; break;
    case 0xa5: code = 0x9ebb; break;
    case 0xaa: code = 0x94de; break;
    case 0xac: code = 0x9eb8; break;
    case 0xb0: code = 0x97ba; break;
    case 0xb1: code = 0xfb65; break;
    case 0xb5: code = 0x95d6; break;
    case 0xb9: code = 0x9cbb; break;
    case 0xbc: code = 0x97da; break;
    case 0xc1: code = 0x8f45; break;
    case 0xc3: code = 0xfb7d; break;
    case 0xc4: code = 0x9158; break;
    case 0xc5: code = 0xfe64; break;
    case 0xc7: code = 0x9856; break;
    case 0xc8: code = 0x9b4d; break;
    case 0xd3: code = 0x935b; break;
    case 0xd4: code = 0x95c7; break;
    case 0xd6: code = 0x97e7; break;
    case 0xdd: code = 0x9359; break;
    case 0xe1: code = 0x91f5; break;
    case 0xe2: code = 0x97b8; break;
    case 0xe5: code = 0xfda2; break;
    case 0xe6: code = 0xfbb6; break;
    case 0xf5: code = 0x92fa; break;
    }
    break;
  case 0x37: switch(c1) {
    case 0x01: code = 0x9357; break;
    case 0x03: code = 0x8ba6; break;
    case 0x08: code = 0xfbb9; break;
    case 0x0a: code = 0x97b0; break;
    case 0x0d: code = 0xfdc4; break;
    case 0x1c: code = 0x9ca1; break;
    case 0x22: code = 0x91f2; break;
    case 0x23: code = 0x91f9; break;
    case 0x25: code = 0x8ff1; break;
    case 0x2c: code = 0x9745; break;
    case 0x2d: code = 0x9853; break;
    case 0x30: code = 0xfe78; break;
    case 0x32: code = 0xfbc1; break;
    case 0x33: code = 0x9251; break;
    case 0x3a: code = 0x9dad; break;
    case 0x40: code = 0xfd6c; break;
    case 0x43: code = 0xfa6b; break;
    case 0x62: code = 0x9bc2; break;
    case 0x6f: code = 0x9a7b; break;
    case 0x97: code = 0x8b60; break;
    case 0xa0: code = 0x934b; break;
    case 0xb9: code = 0x9abd; break;
    case 0xbe: code = 0x91b7; break;
    case 0xf2: code = 0x95b4; break;
    case 0xf8: code = 0xfec5; break;
    case 0xfb: code = 0x9ef0; break;
    }
    break;
  case 0x38: switch(c1) {
    case 0x0f: code = 0x8d64; break;
    case 0x19: code = 0x9269; break;
    case 0x20: code = 0x8d67; break;
    case 0x2d: code = 0xfbea; break;
    case 0x36: code = 0xfbef; break;
    case 0x38: code = 0x8d68; break;
    case 0x63: code = 0x93eb; break;
    case 0xa0: code = 0xfc42; break;
    case 0xc3: code = 0x9166; break;
    case 0xcc: code = 0xfacd; break;
    case 0xd1: code = 0x93dd; break;
    case 0xfa: code = 0x8bcc; break;
    }
    break;
  case 0x39: switch(c1) {
    case 0x08: code = 0x8d6d; break;
    case 0x14: code = 0x8d6e; break;
    case 0x27: code = 0x96a8; break;
    case 0x32: code = 0xfca6; break;
    case 0x3f: code = 0x8d6f; break;
    case 0x4d: code = 0x8d70; break;
    case 0x63: code = 0xfc64; break;
    case 0x80: code = 0x9060; break;
    case 0x89: code = 0x8d74; break;
    case 0x8a: code = 0x97c3; break;
    case 0x92: code = 0x8ad0; break;
    case 0x99: code = 0x9274; break;
    case 0x9b: code = 0x9bbe; break;
    case 0xa1: code = 0x9cc8; break;
    case 0xa4: code = 0x9cba; break;
    case 0xb8: code = 0x8d78; break;
    case 0xdc: code = 0x9eb9; break;
    case 0xe2: code = 0x955a; break;
    case 0xe5: code = 0x91b4; break;
    case 0xec: code = 0x8a48; break;
    case 0xf8: code = 0x8d7d; break;
    case 0xfb: code = 0x8a7d; break;
    case 0xfe: code = 0x8ac2; break;
    }
    break;
  case 0x3a: switch(c1) {
    case 0x01: code = 0xfd4a; break;
    case 0x03: code = 0x8da1; break;
    case 0x06: code = 0x8ad1; break;
    case 0x17: code = 0xfcb4; break;
    case 0x18: code = 0x8b47; break;
    case 0x29: code = 0x93a4; break;
    case 0x2a: code = 0x9eda; break;
    case 0x34: code = 0x8a51; break;
    case 0x4b: code = 0x8da6; break;
    case 0x52: code = 0x9ec5; break;
    case 0x57: code = 0xfcc4; break;
    case 0x5c: code = 0xa078; break;
    case 0x5e: code = 0x94b5; break;
    case 0x66: code = 0xfcc2; break;
    case 0x67: code = 0x8a6b; break;
    case 0x97: code = 0x8dab; break;
    case 0xab: code = 0xfae8; break;
    case 0xbd: code = 0x8dad; break;
    case 0xde: code = 0xfc49; break;
    case 0xe0: code = 0x93c1; break;
    case 0xf0: code = 0x906f; break;
    case 0xf2: code = 0x8db0; break;
    case 0xfb: code = 0x947e; break;
    }
    break;
  case 0x3b: switch(c1) {
    case 0x0e: code = 0x90fa; break;
    case 0x19: code = 0x9479; break;
    case 0x22: code = 0x8db2; break;
    case 0x2b: code = 0xfcee; break;
    case 0x39: code = 0x997b; break;
    case 0x42: code = 0x8db4; break;
    case 0x58: code = 0x8db7; break;
    case 0x60: code = 0x91b3; break;
    case 0x71: code = 0x8dbb; break;
    case 0x72: code = 0x8dba; break;
    case 0x7b: code = 0x8dbc; break;
    case 0x7c: code = 0x9044; break;
    case 0x80: code = 0xfd4c; break;
    case 0x96: code = 0x93e4; break;
    case 0x99: code = 0x93e0; break;
    case 0xa1: code = 0xfd53; break;
    case 0xbc: code = 0x8dc3; break;
    case 0xbe: code = 0x9bb8; break;
    case 0xc2: code = 0xfbf0; break;
    case 0xc4: code = 0x93e9; break;
    case 0xd7: code = 0x93f6; break;
    case 0xdd: code = 0x8dc5; break;
    case 0xec: code = 0x8dca; break;
    case 0xf2: code = 0x8dcc; break;
    case 0xf3: code = 0xfd5d; break;
    case 0xf4: code = 0x93b5; break;
    }
    break;
  case 0x3c: switch(c1) {
    case 0x0d: code = 0xfd61; break;
    case 0x11: code = 0x9cf8; break;
    case 0x15: code = 0x9252; break;
    case 0x18: code = 0xa0e8; break;
    case 0x54: code = 0x9ca5; break;
    case 0x8b: code = 0x8c56; break;
    case 0xcb: code = 0x8dd6; break;
    case 0xcd: code = 0x97c0; break;
    case 0xd1: code = 0xa0de; break;
    case 0xd6: code = 0x97d2; break;
    case 0xdc: code = 0xfaa5; break;
    case 0xeb: code = 0xfda3; break;
    case 0xef: code = 0x8ddb; break;
    }
    break;
  case 0x3d: switch(c1) {
    case 0x13: code = 0x8eaf; break;
    case 0x1d: code = 0x91b5; break;
    case 0x32: code = 0xfd49; break;
    case 0x3b: code = 0xfdd1; break;
    case 0x46: code = 0x8deb; break;
    case 0x4c: code = 0x97c6; break;
    case 0x4e: code = 0xfdce; break;
    case 0x51: code = 0x90fc; break;
    case 0x5f: code = 0xfc59; break;
    case 0x62: code = 0x96d6; break;
    case 0x69: code = 0x97c5; break;
    case 0x6a: code = 0x8def; break;
    case 0x6f: code = 0x97d7; break;
    case 0x75: code = 0x8df0; break;
    case 0x7d: code = 0x96a6; break;
    case 0x85: code = 0xfbbf; break;
    case 0x8a: code = 0x8df3; break;
    case 0x8f: code = 0x9449; break;
    case 0x91: code = 0x8df5; break;
    case 0xa5: code = 0x9872; break;
    case 0xad: code = 0x8e6b; break;
    case 0xb4: code = 0xfafd; break;
    case 0xbf: code = 0x8f50; break;
    case 0xc6: code = 0x9dcc; break;
    case 0xc7: code = 0xfc65; break;
    case 0xc9: code = 0x8c44; break;
    case 0xcc: code = 0x996e; break;
    case 0xcd: code = 0x94a1; break;
    case 0xd3: code = 0x8f63; break;
    case 0xdb: code = 0xa0da; break;
    case 0xe7: code = 0x9253; break;
    case 0xe8: code = 0xfde9; break;
    case 0xeb: code = 0x9db5; break;
    case 0xf3: code = 0x9879; break;
    case 0xf7: code = 0x9d5d; break;
    case 0xfc: code = 0x8d63; break;
    case 0xfd: code = 0x9669; break;
    }
    break;
  case 0x3e: switch(c1) {
    case 0x06: code = 0x9f70; break;
    case 0x40: code = 0xfc6a; break;
    case 0x43: code = 0x8ac7; break;
    case 0x48: code = 0x89d7; break;
    case 0x55: code = 0xfe4d; break;
    case 0x74: code = 0x9edd; break;
    case 0xa8: code = 0xfefb; break;
    case 0xa9: code = 0x98bc; break;
    case 0xaa: code = 0xfacc; break;
    case 0xad: code = 0x95b0; break;
    case 0xb1: code = 0x9464; break;
    case 0xb8: code = 0x936f; break;
    case 0xbf: code = 0x94b9; break;
    case 0xc2: code = 0x95ec; break;
    case 0xc7: code = 0x91ee; break;
    case 0xca: code = 0x98c3; break;
    case 0xcc: code = 0x95f6; break;
    case 0xd0: code = 0x8ffd; break;
    case 0xd1: code = 0x98c5; break;
    case 0xd6: code = 0x9766; break;
    case 0xd7: code = 0xfe6e; break;
    case 0xda: code = 0x97dd; break;
    case 0xdb: code = 0x8caa; break;
    case 0xde: code = 0x92d2; break;
    case 0xe1: code = 0x9761; break;
    case 0xe2: code = 0x98cb; break;
    case 0xe7: code = 0x95f0; break;
    case 0xe9: code = 0x975d; break;
    case 0xeb: code = 0x91e3; break;
    case 0xf0: code = 0x98cc; break;
    case 0xf3: code = 0x9469; break;
    case 0xf4: code = 0x98cd; break;
    case 0xfa: code = 0x98ce; break;
    case 0xfc: code = 0x95fc; break;
    case 0xff: code = 0x94a3; break;
    }
    break;
  case 0x3f: switch(c1) {
    case 0x00: code = 0x9662; break;
    case 0x04: code = 0xfeb6; break;
    case 0x06: code = 0x9463; break;
    case 0x0e: code = 0x98d0; break;
    case 0x53: code = 0x98d1; break;
    case 0x58: code = 0x9475; break;
    case 0x59: code = 0xfae0; break;
    case 0x63: code = 0x9472; break;
    case 0x7c: code = 0x98d6; break;
    case 0x93: code = 0x8af0; break;
    case 0xc0: code = 0x98d9; break;
    case 0xd7: code = 0x98db; break;
    case 0xdc: code = 0x98dd; break;
    case 0xe5: code = 0x98a8; break;
    case 0xed: code = 0x8a6d; break;
    case 0xf9: code = 0x8afb; break;
    case 0xfa: code = 0x8aae; break;
    }
    break;
  case 0x40: switch(c1) {
    case 0x04: code = 0xfbc9; break;
    case 0x09: code = 0x8c5d; break;
    case 0x1d: code = 0x98e4; break;
    case 0x39: code = 0x98e6; break;
    case 0x45: code = 0x98e8; break;
    case 0x53: code = 0x8a4d; break;
    case 0x57: code = 0x9257; break;
    case 0x62: code = 0x95df; break;
    case 0x65: code = 0xa0ac; break;
    case 0x6a: code = 0x98eb; break;
    case 0x6f: code = 0x98ec; break;
    case 0x71: code = 0x8cc3; break;
    case 0xa8: code = 0x98f4; break;
    case 0xbb: code = 0x8ab8; break;
    case 0xbf: code = 0x9ee7; break;
    case 0xc8: code = 0x94bc; break;
    case 0xd8: code = 0xfcd1; break;
    case 0xdf: code = 0x9cc6; break;
    case 0xfa: code = 0x9e7e; break;
    }
    break;
  case 0x41: switch(c1) {
    case 0x03: code = 0x98fe; break;
    case 0x04: code = 0xfde8; break;
    case 0x09: code = 0x9940; break;
    case 0x0e: code = 0x94c9; break;
    case 0x32: code = 0x94d3; break;
    case 0x67: code = 0x9946; break;
    case 0x6c: code = 0x90c0; break;
    case 0x6e: code = 0x94d1; break;
    case 0x7f: code = 0x9573; break;
    case 0x90: code = 0x93c2; break;
    case 0xb2: code = 0x9948; break;
    case 0xc4: code = 0x994b; break;
    case 0xca: code = 0x8e55; break;
    case 0xcf: code = 0x994e; break;
    case 0xdb: code = 0x8efe; break;
    case 0xef: code = 0x8e59; break;
    case 0xf9: code = 0x94ec; break;
    }
    break;
  case 0x42: switch(c1) {
    case 0x11: code = 0x94ef; break;
    case 0x23: code = 0x8c60; break;
    case 0x40: code = 0x8f74; break;
    case 0x60: code = 0x9955; break;
    case 0x6a: code = 0x9544; break;
    case 0x76: code = 0x8ccb; break;
    case 0x7a: code = 0x9956; break;
    case 0x8c: code = 0x9959; break;
    case 0x94: code = 0x995b; break;
    case 0xa2: code = 0x8cc4; break;
    case 0xb5: code = 0xfa45; break;
    case 0xb9: code = 0x90b7; break;
    case 0xbc: code = 0x9743; break;
    case 0xf4: code = 0x95cd; break;
    case 0xfb: code = 0x97c9; break;
    case 0xfc: code = 0xfd50; break;
    }
    break;
  case 0x43: switch(c1) {
    case 0x2b: code = 0x8eb9; break;
    case 0x6e: code = 0x95c6; break;
    case 0x97: code = 0x9967; break;
    case 0xba: code = 0x8ab9; break;
    case 0xc1: code = 0x8dfc; break;
    case 0xd9: code = 0x8a76; break;
    case 0xdf: code = 0x9d51; break;
    case 0xed: code = 0x9973; break;
    case 0xf2: code = 0x9d4f; break;
    }
    break;
  case 0x44: switch(c1) {
    case 0x01: code = 0x997a; break;
    case 0x02: code = 0x9564; break;
    case 0x13: code = 0x99a1; break;
    case 0x25: code = 0x99a5; break;
    case 0x2d: code = 0x99a7; break;
    case 0x7a: code = 0x8eed; break;
    case 0x8f: code = 0x99ad; break;
    case 0x9f: code = 0x946e; break;
    case 0xa0: code = 0x8f70; break;
    case 0xa2: code = 0xfad0; break;
    case 0xb0: code = 0x99b3; break;
    case 0xb7: code = 0xa053; break;
    case 0xc0: code = 0x965c; break;
    case 0xc5: code = 0xfd7a; break;
    case 0xce: code = 0x97fe; break;
    case 0xdd: code = 0x92bd; break;
    case 0xdf: code = 0x97fd; break;
    case 0xe4: code = 0x8f64; break;
    case 0xe9: code = 0xfcf7; break;
    case 0xea: code = 0x9562; break;
    case 0xeb: code = 0x97cd; break;
    case 0xec: code = 0x9e64; break;
    case 0xf4: code = 0x924c; break;
    }
    break;
  case 0x45: switch(c1) {
    case 0x03: code = 0x8ec9; break;
    case 0x04: code = 0x99bc; break;
    case 0x09: code = 0x9da5; break;
    case 0x0b: code = 0x8f54; break;
    case 0x16: code = 0x8f7c; break;
    case 0x1d: code = 0x8ea2; break;
    case 0x27: code = 0x8f7a; break;
    case 0x2e: code = 0x97ae; break;
    case 0x33: code = 0x96c8; break;
    case 0x3b: code = 0x99c3; break;
    case 0x3d: code = 0x90d6; break;
    case 0x3f: code = 0x9cbe; break;
    case 0x43: code = 0x8f76; break;
    case 0x51: code = 0x9470; break;
    case 0x52: code = 0xfb4b; break;
    case 0x55: code = 0xfdca; break;
    case 0x5c: code = 0x8ec7; break;
    case 0x62: code = 0xa0f9; break;
    case 0x6a: code = 0x8fa9; break;
    case 0x77: code = 0x99c7; break;
    case 0x85: code = 0x90d7; break;
    case 0xe9: code = 0x9edf; break;
    }
    break;
  case 0x46: switch(c1) {
    case 0x06: code = 0x99ce; break;
    case 0x0f: code = 0x8fba; break;
    case 0x15: code = 0x8feb; break;
    case 0x17: code = 0x99cf; break;
    case 0x5b: code = 0x8fc2; break;
    case 0x7a: code = 0x92c9; break;
    case 0x80: code = 0x97dc; break;
    case 0xcf: code = 0x95b3; break;
    case 0xd0: code = 0x9c79; break;
    case 0xf5: code = 0x95b2; break;
    }
    break;
  case 0x47: switch(c1) {
    case 0x13: code = 0x8fdb; break;
    case 0x18: code = 0x9be3; break;
    case 0x4e: code = 0x9e7a; break;
    case 0x7c: code = 0x9bee; break;
    case 0x98: code = 0x99de; break;
    case 0xa6: code = 0xfafa; break;
    case 0xb6: code = 0x9ee5; break;
    case 0xd5: code = 0x8a52; break;
    case 0xed: code = 0x99e1; break;
    case 0xf4: code = 0x8a67; break;
    }
    break;
  case 0x48: switch(c1) {
    case 0x00: code = 0x8bb5; break;
    case 0x0b: code = 0x8aac; break;
    case 0x37: code = 0x99e9; break;
    case 0x5d: code = 0xfbca; break;
    case 0x71: code = 0x97de; break;
    case 0x9b: code = 0x95d1; break;
    case 0xad: code = 0x99f5; break;
    case 0xae: code = 0xfc4a; break;
    case 0xd0: code = 0x9ba9; break;
    case 0xdd: code = 0xfbdc; break;
    case 0xed: code = 0xfe56; break;
    case 0xf3: code = 0x9ea4; break;
    case 0xfa: code = 0x9d49; break;
    }
    break;
  case 0x49: switch(c1) {
    case 0x06: code = 0x95db; break;
    case 0x11: code = 0x89c5; break;
    case 0x1e: code = 0x99f8; break;
    case 0x25: code = 0x9664; break;
    case 0x2a: code = 0x9055; break;
    case 0x2d: code = 0x96d4; break;
    case 0x35: code = 0x977c; break;
    case 0x3c: code = 0x964d; break;
    case 0x3e: code = 0x97e1; break;
    case 0x45: code = 0x9a48; break;
    case 0x51: code = 0x9a49; break;
    case 0x53: code = 0xfe7d; break;
    case 0x65: code = 0x90aa; break;
    case 0x6a: code = 0x9a50; break;
    case 0x72: code = 0x9347; break;
    case 0x89: code = 0x8ed8; break;
    case 0xa1: code = 0x90c9; break;
    case 0xa7: code = 0x9a55; break;
    case 0xdf: code = 0x90bc; break;
    case 0xe5: code = 0x9a58; break;
    case 0xe7: code = 0x8bb8; break;
    }
    break;
  case 0x4a: switch(c1) {
    case 0x0f: code = 0x90d5; break;
    case 0x1d: code = 0x9641; break;
    case 0x24: code = 0x9a5a; break;
    case 0x35: code = 0x9a5c; break;
    case 0x96: code = 0x97c2; break;
    case 0xb4: code = 0x8abb; break;
    case 0xb8: code = 0x9baa; break;
    case 0xd1: code = 0x90f5; break;
    case 0xe4: code = 0x9a60; break;
    case 0xff: code = 0x9145; break;
    }
    break;
  case 0x4b: switch(c1) {
    case 0x10: code = 0x8c58; break;
    case 0x19: code = 0x9a63; break;
    case 0x20: code = 0x8c49; break;
    case 0x2c: code = 0x8bb6; break;
    case 0x37: code = 0xfccf; break;
    case 0x6f: code = 0x966b; break;
    case 0x70: code = 0x9a6e; break;
    case 0x72: code = 0x914f; break;
    case 0x7b: code = 0x9746; break;
    case 0x7e: code = 0xa0e6; break;
    case 0x8e: code = 0x92d7; break;
    case 0x90: code = 0x9675; break;
    case 0x93: code = 0x93d4; break;
    case 0x96: code = 0x91bb; break;
    case 0x97: code = 0x9679; break;
    case 0x9d: code = 0x9a70; break;
    case 0xbd: code = 0x9678; break;
    case 0xbe: code = 0x91cd; break;
    case 0xc0: code = 0x9c4a; break;
    }
    break;
  case 0x4c: switch(c1) {
    case 0x04: code = 0xa06f; break;
    case 0x07: code = 0xa06a; break;
    case 0x0e: code = 0x915f; break;
    case 0x3b: code = 0x9fa5; break;
    case 0x3e: code = 0x89ba; break;
    case 0x5b: code = 0x9ecd; break;
    case 0x6d: code = 0x9a79; break;
    case 0x7d: code = 0x9dce; break;
    case 0x81: code = 0x8cd2; break;
    case 0xa4: code = 0x9d73; break;
    case 0xae: code = 0x96b9; break;
    case 0xb0: code = 0x96bc; break;
    case 0xb7: code = 0x9cd1; break;
    case 0xcd: code = 0x89b7; break;
    case 0xe1: code = 0x9eee; break;
    case 0xed: code = 0xfb43; break;
    }
    break;
  case 0x4d: switch(c1) {
    case 0x09: code = 0x9ec9; break;
    case 0x10: code = 0xfbd3; break;
    case 0x34: code = 0x91ae; break;
    case 0x91: code = 0x9d78; break;
    case 0x9c: code = 0x9d7b; break;
    }
    break;
  case 0x4e: switch(c1) {
    case 0x04: code = 0x9eb3; break;
    case 0x1a: code = 0x9eb2; break;
    case 0x1c: code = 0x9dd6; break;
    case 0x21: code = 0x994f; break;
    case 0x24: code = 0x89ce; break;
    case 0x28: code = 0x8bc0; break;
    case 0x2a: code = 0x9fc4; break;
    case 0x2c: code = 0x8bd4; break;
    case 0x2f: code = 0x8c72; break;
    case 0x37: code = 0x8bf9; break;
    case 0x3d: code = 0x8946; break;
    case 0x49: code = 0xfae5; break;
    case 0x5b: code = 0x8bc6; break;
    case 0x6a: code = 0x9c57; break;
    case 0x78: code = 0x9afb; break;
    case 0x80: code = 0x89d0; break;
    case 0x81: code = 0x89cf; break;
    case 0x87: code = 0x89d1; break;
    case 0x89: code = 0x89e2; break;
    case 0x98: code = 0x927e; break;
    case 0x9a: code = 0x9dba; break;
    case 0xa3: code = 0x8c6f; break;
    case 0xb7: code = 0xfbf8; break;
    case 0xbb: code = 0x8bc7; break;
    case 0xbc: code = 0x926b; break;
    case 0xbf: code = 0x89d2; break;
    case 0xce: code = 0x9fcf; break;
    case 0xea: code = 0x9da9; break;
    case 0xeb: code = 0x89d3; break;
    case 0xee: code = 0x99e2; break;
    case 0xf8: code = 0x9267; break;
    }
    break;
  case 0x4f: switch(c1) {
    case 0x03: code = 0x92a4; break;
    case 0x17: code = 0x8c73; break;
    case 0x1a: code = 0x894e; break;
    case 0x28: code = 0x894f; break;
    case 0x29: code = 0x9278; break;
    case 0x32: code = 0x91b6; break;
    case 0x37: code = 0x89d4; break;
    case 0x39: code = 0x9fd2; break;
    case 0x42: code = 0x92a7; break;
    case 0x45: code = 0x95a2; break;
    case 0x4b: code = 0x926e; break;
    case 0x72: code = 0x96ea; break;
    case 0x8a: code = 0x926f; break;
    case 0xa2: code = 0x92a3; break;
    case 0xa8: code = 0x8950; break;
    case 0xab: code = 0xfa57; break;
    case 0xb0: code = 0x9866; break;
    case 0xbb: code = 0x9c53; break;
    case 0xbd: code = 0x89d6; break;
    case 0xc8: code = 0x98b2; break;
    case 0xcc: code = 0x92ab; break;
    case 0xe4: code = 0x96de; break;
    case 0xe5: code = 0x92ac; break;
    case 0xf0: code = 0x8c70; break;
    case 0xf2: code = 0x9f6e; break;
    case 0xf9: code = 0x8ef2; break;
    case 0xfd: code = 0x9f6c; break;
    }
    break;
  case 0x50: switch(c1) {
    case 0x03: code = 0x89d8; break;
    case 0x08: code = 0xfa59; break;
    case 0x29: code = 0xfa5f; break;
    case 0x2e: code = 0x92a8; break;
    case 0x34: code = 0x9163; break;
    case 0x3b: code = 0x8c40; break;
    case 0x56: code = 0x9f73; break;
    case 0x58: code = 0x92ad; break;
    case 0x66: code = 0x9be9; break;
    case 0x6c: code = 0x92a9; break;
    case 0x7d: code = 0xfa66; break;
    case 0x81: code = 0x92aa; break;
    case 0x88: code = 0x89d9; break;
    case 0x90: code = 0xfd56; break;
    case 0xa6: code = 0x9fa8; break;
    case 0xbc: code = 0x8c71; break;
    case 0xcd: code = 0x92a1; break;
    case 0xd0: code = 0x90e3; break;
    case 0xd9: code = 0xa0a6; break;
    case 0xdf: code = 0x94ab; break;
    case 0xe1: code = 0xfc72; break;
    case 0xed: code = 0x9fcb; break;
    case 0xf4: code = 0x97c4; break;
    case 0xfc: code = 0x92ae; break;
    }
    break;
  case 0x51: switch(c1) {
    case 0x01: code = 0xfa67; break;
    case 0x0d: code = 0x92a2; break;
    case 0x0e: code = 0xfa69; break;
    case 0x2b: code = 0x9268; break;
    case 0x56: code = 0x8951; break;
    case 0x59: code = 0x92af; break;
    case 0x5b: code = 0x92b0; break;
    case 0x5d: code = 0x92b1; break;
    case 0x5e: code = 0x92b2; break;
    case 0x60: code = 0xfa6f; break;
    case 0x6a: code = 0xfa71; break;
    case 0x74: code = 0x8952; break;
    case 0x79: code = 0x945a; break;
    case 0x86: code = 0x89dd; break;
    case 0x9a: code = 0x9e52; break;
    case 0x9c: code = 0x8953; break;
    case 0xa7: code = 0x9e55; break;
    case 0xa8: code = 0x92ba; break;
    case 0xae: code = 0x8c5b; break;
    case 0xb2: code = 0xfa7d; break;
    case 0xb3: code = 0xfaa8; break;
    case 0xb4: code = 0x9a68; break;
    case 0xb5: code = 0xfa47; break;
    case 0xb8: code = 0xfa7e; break;
    case 0xc3: code = 0x92bb; break;
    case 0xc7: code = 0xfdb6; break;
    case 0xc9: code = 0xfaa2; break;
    case 0xcf: code = 0xfaa3; break;
    case 0xd1: code = 0xfaa4; break;
    case 0xd2: code = 0x9bb4; break;
    case 0xd3: code = 0xfaa6; break;
    case 0xdb: code = 0x89df; break;
    case 0xdf: code = 0xfddb; break;
    case 0xe2: code = 0xfaa9; break;
    case 0xe4: code = 0x8954; break;
    case 0xed: code = 0xfaab; break;
    case 0xf4: code = 0xfc7a; break;
    case 0xfc: code = 0x89e0; break;
    case 0xfe: code = 0x9f4f; break;
    }
    break;
  case 0x52: switch(c1) {
    case 0x05: code = 0x89e1; break;
    case 0x0b: code = 0xfab0; break;
    case 0x1f: code = 0x9fcd; break;
    case 0x20: code = 0xa0e7; break;
    case 0x26: code = 0xfab1; break;
    case 0x27: code = 0x89a6; break;
    case 0x34: code = 0x9efa; break;
    case 0x3c: code = 0xfab2; break;
    case 0x57: code = 0xfab4; break;
    case 0x59: code = 0x92c4; break;
    case 0x60: code = 0x9f6f; break;
    case 0x68: code = 0x8bb0; break;
    case 0x73: code = 0x9fac; break;
    case 0x79: code = 0x89e3; break;
    case 0x8f: code = 0x9bd3; break;
    case 0x90: code = 0x89e4; break;
    case 0x94: code = 0xfab5; break;
    case 0x9a: code = 0x9fd5; break;
    case 0xa1: code = 0x8955; break;
    case 0xa4: code = 0x92c5; break;
    case 0xa8: code = 0x8956; break;
    case 0xb5: code = 0xfab3; break;
    case 0xb9: code = 0xfab6; break;
    case 0xc5: code = 0xfab7; break;
    case 0xcc: code = 0x9edc; break;
    case 0xd0: code = 0xfbc4; break;
    case 0xd1: code = 0x9f71; break;
    case 0xe0: code = 0xfaba; break;
    case 0xe1: code = 0x92c7; break;
    }
    break;
  case 0x53: switch(c1) {
    case 0x01: code = 0x9a4c; break;
    case 0x05: code = 0xfabd; break;
    case 0x24: code = 0x8c68; break;
    case 0x27: code = 0x89e5; break;
    case 0x2c: code = 0x9f7d; break;
    case 0x32: code = 0xa0a9; break;
    case 0x33: code = 0xfac4; break;
    case 0x3b: code = 0x8957; break;
    case 0x42: code = 0xfaaa; break;
    case 0x4e: code = 0x8958; break;
    case 0x5d: code = 0x8be3; break;
    case 0x5f: code = 0x8b61; break;
    case 0x64: code = 0x9af1; break;
    case 0x67: code = 0x9eb7; break;
    case 0x6d: code = 0xfad1; break;
    case 0x74: code = 0xfad2; break;
    case 0x7d: code = 0x9eba; break;
    case 0x7e: code = 0xfad4; break;
    case 0x7f: code = 0xfad5; break;
    case 0x93: code = 0xfad9; break;
    case 0xa0: code = 0xfadb; break;
    case 0xa2: code = 0x9ce0; break;
    case 0xa6: code = 0xfbf7; break;
    case 0xa8: code = 0xfbfa; break;
    case 0xa9: code = 0x89e7; break;
    case 0xaa: code = 0xa07a; break;
    case 0xab: code = 0xfadc; break;
    case 0xae: code = 0xfadd; break;
    case 0xb0: code = 0x89e9; break;
    case 0xc1: code = 0xfae2; break;
    case 0xc2: code = 0x89eb; break;
    case 0xc5: code = 0xfae3; break;
    case 0xcc: code = 0x90c8; break;
    case 0xd0: code = 0x92da; break;
    case 0xd1: code = 0x8959; break;
    case 0xd2: code = 0x9cf5; break;
    case 0xd8: code = 0x895a; break;
    case 0xd9: code = 0xfae7; break;
    case 0xda: code = 0x9fa2; break;
    case 0xe0: code = 0xfaea; break;
    case 0xf6: code = 0xfaed; break;
    case 0xf7: code = 0x8fad; break;
    case 0xfe: code = 0xfb59; break;
    }
    break;
  case 0x54: switch(c1) {
    case 0x13: code = 0xfaef; break;
    case 0x14: code = 0x96ef; break;
    case 0x16: code = 0x9dec; break;
    case 0x1a: code = 0x9dca; break;
    case 0x21: code = 0xfd6d; break;
    case 0x23: code = 0x89ec; break;
    case 0x2f: code = 0xfb44; break;
    case 0x32: code = 0x9de2; break;
    case 0x34: code = 0x8c75; break;
    case 0x4b: code = 0x9ec0; break;
    case 0x4d: code = 0x9e56; break;
    case 0x69: code = 0x9f79; break;
    case 0x6a: code = 0x9ac7; break;
    case 0x6d: code = 0xfaf4; break;
    case 0x85: code = 0x98a1; break;
    case 0x8f: code = 0xfaf8; break;
    case 0x93: code = 0x89f0; break;
    case 0x94: code = 0x9e47; break;
    case 0x97: code = 0x9df7; break;
    case 0x9c: code = 0x9fd3; break;
    case 0x9e: code = 0x9aca; break;
    case 0xa3: code = 0x89f1; break;
    case 0xa4: code = 0xfaf9; break;
    case 0xb2: code = 0x8e5a; break;
    case 0xb4: code = 0x89f2; break;
    case 0xb9: code = 0x89f3; break;
    case 0xcb: code = 0x925d; break;
    case 0xcc: code = 0x8b51; break;
    case 0xcd: code = 0x92e0; break;
    case 0xd0: code = 0x89f4; break;
    case 0xda: code = 0x9fd4; break;
    case 0xe3: code = 0x8a79; break;
    case 0xef: code = 0x89f5; break;
    }
    break;
  case 0x55: switch(c1) {
    case 0x02: code = 0x97a7; break;
    case 0x0d: code = 0x93ba; break;
    case 0x13: code = 0x9e58; break;
    case 0x18: code = 0x89f6; break;
    case 0x1e: code = 0x9e57; break;
    case 0x23: code = 0x89f7; break;
    case 0x25: code = 0x8a41; break;
    case 0x28: code = 0x89f8; break;
    case 0x2b: code = 0xfaf1; break;
    case 0x3f: code = 0x89fa; break;
    case 0x47: code = 0xfb42; break;
    case 0x49: code = 0xfabf; break;
    case 0x53: code = 0xfba3; break;
    case 0x5d: code = 0xfaf7; break;
    case 0x69: code = 0x9e4e; break;
    case 0x6b: code = 0x94dc; break;
    case 0x71: code = 0x95da; break;
    case 0x72: code = 0x9df8; break;
    case 0x73: code = 0x9f6a; break;
    case 0x79: code = 0x8ab7; break;
    case 0x86: code = 0xfb46; break;
    case 0x90: code = 0x8a46; break;
    case 0xa9: code = 0xfb47; break;
    case 0xb0: code = 0x9148; break;
    case 0xb4: code = 0x92de; break;
    case 0xb9: code = 0x8b53; break;
    case 0xba: code = 0x9df6; break;
    case 0xbc: code = 0x9bda; break;
    case 0xc1: code = 0x9d7e; break;
    case 0xd7: code = 0x89fd; break;
    case 0xd8: code = 0x99e4; break;
    case 0xde: code = 0x9e43; break;
    case 0xea: code = 0x9de9; break;
    case 0xec: code = 0x8f52; break;
    case 0xf0: code = 0x9df5; break;
    case 0xf1: code = 0x9df0; break;
    case 0xf5: code = 0x99e7; break;
    case 0xfb: code = 0x8bbd; break;
    }
    break;
  case 0x56: switch(c1) {
    case 0x05: code = 0x9def; break;
/*    case 0x05: code = 0xfb48; break;*/
    case 0x11: code = 0x9fb7; break;
    case 0x1e: code = 0x9dd0; break;
    case 0x20: code = 0x9feb; break;
    case 0x21: code = 0x8da9; break;
    case 0x22: code = 0x9dcf; break;
    case 0x23: code = 0x98e1; break;
    case 0x25: code = 0x9de5; break;
    case 0x2d: code = 0x9dc8; break;
    case 0x37: code = 0xfb4f; break;
    case 0x43: code = 0x9deb; break;
    case 0x4d: code = 0xfb54; break;
    case 0x4f: code = 0xfb55; break;
    case 0x50: code = 0x9aa2; break;
    case 0x52: code = 0x8ad6; break;
    case 0x54: code = 0x9a5f; break;
    case 0x5d: code = 0x9ef5; break;
    case 0x61: code = 0x8fb7; break;
    case 0x7a: code = 0x9ad2; break;
    case 0x7b: code = 0x9e6a; break;
    case 0x7c: code = 0x9ee8; break;
    case 0x89: code = 0x8bbf; break;
    case 0x8a: code = 0x91c2; break;
    case 0x8b: code = 0x9d62; break;
    case 0x92: code = 0x9260; break;
    case 0x9e: code = 0x925e; break;
    case 0x9f: code = 0x91c1; break;
    case 0xa1: code = 0x8ac5; break;
    case 0xa4: code = 0x97a3; break;
    case 0xaf: code = 0x8b6c; break;
    case 0xb1: code = 0x8d7e; break;
    case 0xb9: code = 0x9c54; break;
    case 0xbf: code = 0x9dbd; break;
    case 0xd6: code = 0x9cc5; break;
    case 0xe2: code = 0x895b; break;
    case 0xed: code = 0xfb5c; break;
    case 0xef: code = 0xfb5b; break;
    case 0xf1: code = 0xfb57; break;
    case 0xfd: code = 0x98c7; break;
    }
    break;
  case 0x57: switch(c1) {
    case 0x00: code = 0xfb5a; break;
    case 0x15: code = 0x9cee; break;
    case 0x1d: code = 0x92e2; break;
    case 0x32: code = 0x94a7; break;
    case 0x3d: code = 0x8ccc; break;
    case 0x3f: code = 0x9bd4; break;
    case 0x42: code = 0xfb64; break;
    case 0x43: code = 0xfb76; break;
    case 0x46: code = 0xfb60; break;
    case 0x54: code = 0x99e5; break;
    case 0x57: code = 0x9ac2; break;
    case 0x5b: code = 0x91fb; break;
    case 0x5f: code = 0xa073; break;
    case 0x67: code = 0x9f72; break;
    case 0x7a: code = 0x9fcc; break;
    case 0x7e: code = 0x98a5; break;
    case 0x7f: code = 0x92e8; break;
    case 0x88: code = 0x9bbc; break;
    case 0x8a: code = 0x96f3; break;
    case 0x8d: code = 0x92e7; break;
    case 0x90: code = 0xfc67; break;
    case 0x9c: code = 0x8b7d; break;
    case 0xa1: code = 0x9bf4; break;
    case 0xa7: code = 0x9ef7; break;
    case 0xaa: code = 0x9ec1; break;
    case 0xb4: code = 0x996f; break;
    case 0xbb: code = 0x96f1; break;
    case 0xbe: code = 0x8e41; break;
    case 0xc4: code = 0x954a; break;
    case 0xc8: code = 0x97e6; break;
    case 0xd7: code = 0x96f5; break;
    case 0xdd: code = 0x92e6; break;
    case 0xde: code = 0x9f42; break;
    case 0xe6: code = 0xfb67; break;
    case 0xef: code = 0x99a9; break;
    case 0xfe: code = 0xfae6; break;
    }
    break;
  case 0x58: switch(c1) {
    case 0x03: code = 0xfb69; break;
    case 0x12: code = 0x97e5; break;
    case 0x22: code = 0x967d; break;
    case 0x26: code = 0xfb6c; break;
    case 0x3a: code = 0x99a2; break;
    case 0x40: code = 0x9abb; break;
    case 0x44: code = 0x9a65; break;
    case 0x47: code = 0x944e; break;
    case 0x5c: code = 0xfb6e; break;
    case 0x5f: code = 0x99df; break;
    case 0x69: code = 0x98e3; break;
    case 0x6c: code = 0x9254; break;
    case 0x72: code = 0x967b; break;
    case 0x73: code = 0x8aaf; break;
    case 0x92: code = 0x8c77; break;
    case 0x99: code = 0x8baf; break;
    case 0x9a: code = 0x9ebd; break;
    case 0xa7: code = 0x9ee6; break;
    case 0xaa: code = 0xfb6f; break;
    case 0xb0: code = 0x8ee1; break;
    case 0xb5: code = 0x9b7d; break;
    case 0xb6: code = 0x9c7e; break;
    case 0xcb: code = 0x92ea; break;
    case 0xd0: code = 0x8c78; break;
    case 0xdc: code = 0xfb72; break;
    case 0xe0: code = 0xfb71; break;
    case 0xf0: code = 0x895c; break;
    case 0xf2: code = 0x98f0; break;
    case 0xf3: code = 0x96f2; break;
    case 0xfb: code = 0xfb74; break;
    }
    break;
  case 0x59: switch(c1) {
    case 0x02: code = 0x8bc1; break;
    case 0x04: code = 0x895d; break;
    case 0x05: code = 0x89de; break;
    case 0x07: code = 0x895e; break;
    case 0x11: code = 0xfe42; break;
    case 0x1f: code = 0xfb7b; break;
    case 0x32: code = 0x895f; break;
    case 0x34: code = 0x8960; break;
    case 0x65: code = 0x9bcd; break;
    case 0x75: code = 0x9dd3; break;
    case 0x89: code = 0x984c; break;
    case 0x94: code = 0x9752; break;
    case 0x9a: code = 0x95c3; break;
    case 0x9f: code = 0x9bb6; break;
    case 0xac: code = 0x9ab9; break;
    case 0xb0: code = 0x97b3; break;
    case 0xb7: code = 0x9f74; break;
    case 0xb8: code = 0x92f1; break;
    case 0xc4: code = 0x97df; break;
    case 0xc9: code = 0xfba6; break;
    case 0xd9: code = 0xfbab; break;
    case 0xeb: code = 0x9877; break;
    case 0xef: code = 0x9854; break;
    case 0xf0: code = 0x95c5; break;
    case 0xf8: code = 0x9d55; break;
    case 0xf9: code = 0xfbb2; break;
    }
    break;
  case 0x5a: switch(c1) {
    case 0x02: code = 0x957e; break;
    case 0x0b: code = 0x9742; break;
    case 0x0d: code = 0x94e6; break;
    case 0x12: code = 0x92f5; break;
    case 0x1a: code = 0x8cc5; break;
    case 0x21: code = 0x92fd; break;
    case 0x24: code = 0xfba2; break;
    case 0x27: code = 0x9c51; break;
    case 0x2a: code = 0x94e9; break;
    case 0x2b: code = 0x985c; break;
    case 0x2c: code = 0x92f0; break;
    case 0x3d: code = 0x944c; break;
    case 0x45: code = 0x916b; break;
    case 0x54: code = 0x8b78; break;
    case 0x59: code = 0x94e2; break;
    case 0x61: code = 0x984f; break;
    case 0x63: code = 0xfbb5; break;
    case 0x67: code = 0x9cd0; break;
    case 0x68: code = 0x9271; break;
    case 0x6b: code = 0x9365; break;
    case 0x6e: code = 0x985b; break;
    case 0x71: code = 0x9850; break;
    case 0x77: code = 0xfbb8; break;
    case 0x79: code = 0x97bc; break;
    case 0x7e: code = 0x92f3; break;
    case 0x81: code = 0x9340; break;
    case 0x82: code = 0x984d; break;
    case 0x86: code = 0x9572; break;
    case 0x88: code = 0xfdef; break;
    case 0x91: code = 0xfdc1; break;
    case 0x96: code = 0xfbba; break;
    case 0x99: code = 0x92eb; break;
    case 0xa0: code = 0xfc73; break;
    case 0xa1: code = 0x97b7; break;
    case 0xab: code = 0xfbb4; break;
    case 0xc3: code = 0x90a7; break;
    case 0xce: code = 0x9741; break;
    case 0xcf: code = 0x92f4; break;
    case 0xd3: code = 0xfbbc; break;
    case 0xe4: code = 0x9577; break;
    case 0xf0: code = 0x9ee2; break;
    case 0xf2: code = 0x8f78; break;
    case 0xfe: code = 0x9672; break;
    }
    break;
  case 0x5b: switch(c1) {
    case 0x0d: code = 0x9eb5; break;
    case 0x11: code = 0x964b; break;
    case 0x15: code = 0x8cac; break;
    case 0x1f: code = 0xa0fa; break;
    case 0x28: code = 0x96fc; break;
    case 0x2b: code = 0x9575; break;
    case 0x41: code = 0x90da; break;
    case 0x44: code = 0x9367; break;
    case 0x46: code = 0xfea4; break;
    case 0x4a: code = 0x90df; break;
    case 0x4f: code = 0x9354; break;
    case 0x66: code = 0x8961; break;
    case 0x68: code = 0x8bb4; break;
    case 0x6d: code = 0x9dc0; break;
    case 0x74: code = 0x8e48; break;
    case 0x76: code = 0xfbc5; break;
    case 0x7c: code = 0xfbc7; break;
    case 0x82: code = 0xfa79; break;
    case 0x90: code = 0x9e67; break;
    case 0x96: code = 0x8cd9; break;
    case 0x9d: code = 0xfbd2; break;
    case 0x9e: code = 0x8962; break;
    case 0x9f: code = 0x8963; break;
    case 0xaa: code = 0xfc7d; break;
    case 0xc3: code = 0x9f6b; break;
    case 0xd5: code = 0xfbcc; break;
    case 0xd7: code = 0xfeae; break;
    case 0xf3: code = 0xfbd1; break;
    case 0xff: code = 0xfb75; break;
    }
    break;
  case 0x5c: switch(c1) {
    case 0x05: code = 0xfbd4; break;
    case 0x10: code = 0x9cbc; break;
    case 0x13: code = 0xfbd6; break;
    case 0x14: code = 0xfbd8; break;
    case 0x1c: code = 0x8b5d; break;
    case 0x1e: code = 0x934c; break;
    case 0x20: code = 0x9ae2; break;
    case 0x23: code = 0x8bc9; break;
    case 0x49: code = 0xfbdb; break;
    case 0x4a: code = 0x9fc9; break;
    case 0x53: code = 0x9f44; break;
    case 0x5e: code = 0x98ed; break;
    case 0x85: code = 0xfbdd; break;
    case 0x99: code = 0x8df2; break;
    case 0x9a: code = 0x8964; break;
    case 0x9c: code = 0xfdf2; break;
    case 0x9e: code = 0x934d; break;
    case 0xba: code = 0xfbe7; break;
    case 0xc1: code = 0xa0f2; break;
    case 0xc2: code = 0x9868; break;
    case 0xd1: code = 0x9f58; break;
    case 0xe5: code = 0x8d73; break;
    case 0xe9: code = 0xfbde; break;
    case 0xef: code = 0xfbdf; break;
    case 0xf5: code = 0x8c48; break;
    }
    break;
  case 0x5d: switch(c1) {
    case 0x10: code = 0xfbe3; break;
    case 0x15: code = 0x8da8; break;
    case 0x18: code = 0xfbe4; break;
    case 0x2c: code = 0x9c75; break;
    case 0x2f: code = 0x9878; break;
    case 0x3e: code = 0x8d60; break;
    case 0x46: code = 0xfbe5; break;
    case 0x48: code = 0x8d61; break;
    case 0x56: code = 0x8d62; break;
    case 0x57: code = 0xa0a1; break;
    case 0x5b: code = 0x9c40; break;
    case 0x70: code = 0x98ad; break;
    case 0x74: code = 0x9eea; break;
    case 0x7b: code = 0x8cd4; break;
    case 0x85: code = 0x9ceb; break;
    case 0x8b: code = 0xfbe0; break;
    case 0x8e: code = 0x9f51; break;
    case 0xa4: code = 0x8d65; break;
    case 0xab: code = 0x9cf1; break;
    case 0xb6: code = 0xfc58; break;
    case 0xb9: code = 0x8d66; break;
    case 0xc1: code = 0x9654; break;
    case 0xd7: code = 0xfbe8; break;
    case 0xf5: code = 0x9fce; break;
    }
    break;
  case 0x5e: switch(c1) {
    case 0x09: code = 0xfbfc; break;
    case 0x0b: code = 0x9ae4; break;
    case 0x12: code = 0x9f75; break;
    case 0x2e: code = 0xfbf1; break;
    case 0x42: code = 0x8d69; break;
    case 0x48: code = 0x934f; break;
    case 0x5e: code = 0x934e; break;
    case 0x75: code = 0xfbf3; break;
    case 0x7a: code = 0xfbf4; break;
    case 0x83: code = 0xfbc3; break;
    case 0x86: code = 0x8965; break;
    case 0x92: code = 0x8c7a; break;
    case 0x99: code = 0x8c7b; break;
    case 0xbd: code = 0x8d6a; break;
    case 0xcd: code = 0x9353; break;
    case 0xd0: code = 0xfbf9; break;
/*    case 0xd0: code = 0x9dfb; break;*/
    case 0xf4: code = 0xfbfd; break;
    case 0xf8: code = 0x9059; break;
    case 0xf9: code = 0xfc40; break;
    case 0xfb: code = 0xfc41; break;
    case 0xfc: code = 0xfc43; break;
    }
    break;
  case 0x5f: switch(c1) {
    case 0x0c: code = 0x9361; break;
/*    case 0x0c: code = 0x9fd8; break;*/
    case 0x0d: code = 0xfc46; break;
    case 0x0e: code = 0x9362; break;
    case 0x25: code = 0x8d6b; break;
    case 0x3a: code = 0xfc4c; break;
    case 0x4d: code = 0x95b8; break;
    case 0x51: code = 0x8bca; break;
    case 0x58: code = 0xfc4f; break;
    case 0x5c: code = 0x987a; break;
    case 0x63: code = 0xfc51; break;
    case 0x72: code = 0xfc54; break;
    case 0x7b: code = 0xfaaf; break;
    case 0x83: code = 0x8d6c; break;
    case 0xa4: code = 0xfa61; break;
    case 0xa7: code = 0xfc57; break;
    case 0xb1: code = 0x9b70; break;
    case 0xba: code = 0xa051; break;
    case 0xc2: code = 0x8c7c; break;
    case 0xc4: code = 0x8bcb; break;
    case 0xdb: code = 0x936e; break;
    case 0xdf: code = 0xfcd5; break;
    }
    break;
  case 0x60: switch(c1) {
    case 0x23: code = 0xfca9; break;
    case 0x31: code = 0xfc61; break;
    case 0x3b: code = 0x8966; break;
    case 0x4a: code = 0xfacb; break;
    case 0x62: code = 0x9ea9; break;
    case 0x75: code = 0x937a; break;
    case 0x77: code = 0xa0e0; break;
    case 0x7e: code = 0x936b; break;
    case 0x9e: code = 0xfc6b; break;
    case 0xa4: code = 0xa0dc; break;
/*    case 0xa4: code = 0xfc6c; break;*/
    case 0xa7: code = 0x9468; break;
    case 0xb3: code = 0xfc6d; break;
    case 0xd7: code = 0x8d71; break;
    case 0xde: code = 0x9bec; break;
/*    case 0xde: code = 0xfd64; break;*/
    case 0xe3: code = 0x99ba; break;
    case 0xe7: code = 0x9ad0; break;
    case 0xe8: code = 0x9a61; break;
    case 0xe9: code = 0xa0e5; break;
    case 0xfd: code = 0xa05b; break;
    }
    break;
  case 0x61: switch(c1) {
    case 0x07: code = 0x96ac; break;
    case 0x0c: code = 0x9740; break;
    case 0x19: code = 0x9ef1; break;
    case 0x22: code = 0x8c4d; break;
    case 0x30: code = 0x9f7e; break;
    case 0x3d: code = 0x8d72; break;
    case 0x42: code = 0xfc76; break;
    case 0x50: code = 0x96a9; break;
    case 0x59: code = 0xa06e; break;
    case 0x5c: code = 0xfcaa; break;
    case 0x60: code = 0xfbcd; break;
    case 0x64: code = 0xfc74; break;
    case 0x6f: code = 0xa074; break;
    case 0x7d: code = 0xa071; break;
    case 0x81: code = 0xfc79; break;
    case 0x87: code = 0xfc7c; break;
    case 0x95: code = 0x9c50; break;
    case 0x98: code = 0x9379; break;
    case 0x99: code = 0x9378; break;
    case 0x9c: code = 0xa0dd; break;
    case 0xb7: code = 0x8d75; break;
    case 0xb9: code = 0x8d76; break;
    case 0xc0: code = 0x9374; break;
    case 0xcf: code = 0x8d77; break;
    case 0xd0: code = 0xfca5; break;
    case 0xd3: code = 0xfca2; break;
    case 0xda: code = 0x90c3; break;
    case 0xe2: code = 0xa079; break;
    }
    break;
  case 0x62: switch(c1) {
    case 0x2c: code = 0x8d79; break;
    case 0x37: code = 0x8bfc; break;
    case 0x39: code = 0xa076; break;
    case 0x4c: code = 0x8bcd; break;
    case 0x68: code = 0x9f5a; break;
    case 0x82: code = 0x9ff4; break;
    case 0x85: code = 0x9fba; break;
    case 0x90: code = 0x8d7a; break;
    case 0x9d: code = 0x9e45; break;
    case 0xa4: code = 0x93b0; break;
    case 0xa6: code = 0xa075; break;
    case 0xc3: code = 0x9b46; break;
    case 0xc5: code = 0xfcae; break;
    case 0xce: code = 0xa077; break;
    case 0xd0: code = 0x9dc4; break;
    case 0xd5: code = 0xfcb0; break;
    case 0xdf: code = 0xfa51; break;
    case 0xe5: code = 0x8d7b; break;
    }
    break;
  case 0x63: switch(c1) {
    case 0x18: code = 0x8d7c; break;
    case 0x2e: code = 0x9ed6; break;
    case 0x31: code = 0x93ac; break;
    case 0x35: code = 0x9f5b; break;
    case 0x37: code = 0x93a9; break;
    case 0x64: code = 0xa07c; break;
    case 0x6c: code = 0xfcb2; break;
    case 0x79: code = 0x8ac1; break;
    case 0x7f: code = 0x9fb4; break;
    case 0x8b: code = 0xfcac; break;
    case 0xb9: code = 0x9e4c; break;
    case 0xc1: code = 0x8fc5; break;
    case 0xd1: code = 0x93ad; break;
    case 0xde: code = 0x9dc3; break;
    case 0xe2: code = 0x8da2; break;
    case 0xe6: code = 0x9d4a; break;
    case 0xf8: code = 0xfcb6; break;
    case 0xfb: code = 0x8da3; break;
    case 0xfc: code = 0x9e4b; break;
    case 0xfe: code = 0x9e4d; break;
    }
    break;
  case 0x64: switch(c1) {
    case 0x07: code = 0x8da4; break;
    case 0x32: code = 0x8afd; break;
    case 0x38: code = 0xfcb5; break;
    case 0x3a: code = 0xfcc3; break;
    case 0x3b: code = 0x93b2; break;
    case 0x5a: code = 0x8da5; break;
    case 0x71: code = 0x93a1; break;
    case 0x7c: code = 0x8ac6; break;
    case 0x8d: code = 0x8a5b; break;
    case 0x90: code = 0xfcb9; break;
    case 0x91: code = 0x894d; break;
    case 0xaf: code = 0xfed4; break;
    case 0xb4: code = 0x8a78; break;
    case 0xb6: code = 0x93ab; break;
    case 0xc0: code = 0x8da7; break;
    case 0xd3: code = 0x9f45; break;
    case 0xdd: code = 0x8a56; break;
    case 0xe1: code = 0xfcbf; break;
    case 0xe5: code = 0xfcc0; break;
    case 0xe7: code = 0x8ee6; break;
    case 0xea: code = 0x8aa4; break;
    }
    break;
  case 0x65: switch(c1) {
    case 0x0a: code = 0x8943; break;
    case 0x11: code = 0x93f3; break;
    case 0x1e: code = 0xfcab; break;
    case 0x1f: code = 0x9ea2; break;
    case 0x30: code = 0x9dc7; break;
    case 0x35: code = 0x8bce; break;
    case 0x4d: code = 0xfcc5; break;
    case 0x5f: code = 0xfccb; break;
    case 0x6b: code = 0x93b3; break;
    case 0x6d: code = 0xfcca; break;
    case 0x85: code = 0xfcc9; break;
    case 0x86: code = 0x8dac; break;
    case 0x88: code = 0xfbc6; break;
    case 0x89: code = 0x8967; break;
    case 0x8b: code = 0x8c7e; break;
    case 0xb5: code = 0xfccd; break;
    case 0xbe: code = 0x9cf3; break;
    case 0xd1: code = 0xfcd0; break;
    case 0xd4: code = 0x95bb; break;
    case 0xe0: code = 0xfcd3; break;
    case 0xe3: code = 0xfcd4; break;
    case 0xff: code = 0x8dae; break;
    }
    break;
  case 0x66: switch(c1) {
    case 0x18: code = 0xfcd7; break;
    case 0x1e: code = 0x93db; break;
    case 0x23: code = 0xfe63; break;
    case 0x30: code = 0x93d5; break;
    case 0x44: code = 0xfcda; break;
    case 0x48: code = 0x9b71; break;
    case 0x4b: code = 0xfcdd; break;
    case 0x53: code = 0x8daf; break;
    case 0x57: code = 0xfaf2; break;
    case 0x63: code = 0x93d8; break;
    case 0x67: code = 0xfcdf; break;
    case 0x6b: code = 0x93d3; break;
    case 0x73: code = 0xfce1; break;
    case 0x74: code = 0xfce2; break;
    case 0x7d: code = 0x8e76; break;
    case 0x85: code = 0xfc62; break;
    case 0x8e: code = 0x93d1; break;
    case 0x92: code = 0x8db1; break;
    case 0x9a: code = 0x9859; break;
    case 0xa4: code = 0xfb52; break;
    case 0xad: code = 0xfb53; break;
    case 0xb3: code = 0xfb4d; break;
    case 0xb6: code = 0x9cbf; break;
    case 0xbf: code = 0x9b72; break;
    case 0xcd: code = 0xfb50; break;
    case 0xce: code = 0x93be; break;
    case 0xf1: code = 0x9df1; break;
    }
    break;
  case 0x67: switch(c1) {
    case 0x02: code = 0xfceb; break;
    case 0x0c: code = 0xa0bb; break;
    case 0x0e: code = 0x9b7e; break;
    case 0x16: code = 0x8db3; break;
    case 0x19: code = 0x8c52; break;
    case 0x1e: code = 0x9ae8; break;
    case 0x25: code = 0x8edc; break;
    case 0x36: code = 0x9cf9; break;
    case 0x44: code = 0xfa50; break;
    case 0x5e: code = 0xfcf1; break;
    case 0x61: code = 0x98e7; break;
    case 0x62: code = 0xfcf3; break;
    case 0x67: code = 0xfcf2; break;
    case 0x6b: code = 0x8cca; break;
    case 0x8f: code = 0x93e5; break;
    case 0xa0: code = 0x9a59; break;
    case 0xa4: code = 0x8db5; break;
    case 0xac: code = 0xfd4d; break;
    case 0xb1: code = 0xfd5e; break;
    case 0xbf: code = 0x8f7d; break;
    case 0xd6: code = 0x9547; break;
    case 0xd7: code = 0xfcf6; break;
    case 0xf9: code = 0x9250; break;
    case 0xfe: code = 0x8968; break;
    }
    break;
  case 0x68: switch(c1) {
    case 0x00: code = 0x8db6; break;
    case 0x01: code = 0xfcfb; break;
    case 0x02: code = 0xa07d; break;
    case 0x03: code = 0x98fc; break;
    case 0x04: code = 0x8969; break;
    case 0x0d: code = 0xfe4f; break;
    case 0x10: code = 0x9256; break;
    case 0x1b: code = 0xfac9; break;
    case 0x1e: code = 0x93e8; break;
    case 0x22: code = 0xfcf8; break;
    case 0x36: code = 0x9ce3; break;
    case 0x37: code = 0xfda9; break;
    case 0x3e: code = 0xfc44; break;
    case 0x47: code = 0x9640; break;
    case 0x4a: code = 0x8db8; break;
    case 0x55: code = 0x9b4a; break;
    case 0x56: code = 0x8fb9; break;
    case 0x5d: code = 0xfcfe; break;
    case 0x65: code = 0x896a; break;
    case 0x84: code = 0x8db9; break;
    case 0x88: code = 0x917e; break;
    case 0x98: code = 0x93f4; break;
    case 0xa6: code = 0xfb7c; break;
    case 0xb6: code = 0x93e7; break;
    case 0xb9: code = 0x97ef; break;
    case 0xbd: code = 0xfe4a; break;
    case 0xc3: code = 0xfd45; break;
    case 0xc5: code = 0x96a5; break;
    case 0xca: code = 0xfee0; break;
    }
    break;
  case 0x69: switch(c1) {
    case 0x00: code = 0xfd48; break;
    case 0x01: code = 0xfd47; break;
    case 0x02: code = 0xfef2; break;
    case 0x03: code = 0xfe6a; break;
    case 0x09: code = 0x8dbd; break;
    case 0x18: code = 0x9ba1; break;
    case 0x19: code = 0x8ca2; break;
    case 0x1a: code = 0x9ab7; break;
    case 0x1b: code = 0x8efc; break;
    case 0x2c: code = 0x9fa1; break;
    case 0x36: code = 0xfd51; break;
    case 0x3e: code = 0xfaad; break;
    case 0x43: code = 0x8dbe; break;
    case 0x46: code = 0x89a4; break;
    case 0x55: code = 0x9ad9; break;
    case 0x61: code = 0xfd4e; break;
    case 0x64: code = 0x8dc0; break;
    case 0x67: code = 0x97f0; break;
    case 0x72: code = 0x93b4; break;
    case 0x73: code = 0xfd44; break;
    case 0x80: code = 0x9fa7; break;
    case 0x85: code = 0x8dc2; break;
    case 0x8a: code = 0x99b6; break;
    case 0x98: code = 0xfd52; break;
    case 0x9f: code = 0x8dc1; break;
    case 0xa2: code = 0x8e46; break;
    case 0xb2: code = 0xa0d1; break;
    case 0xc0: code = 0x9fca; break;
    case 0xd1: code = 0x92cf; break;
    case 0xd5: code = 0x9cf4; break;
    case 0xd6: code = 0x8dc4; break;
    case 0xe1: code = 0xfd41; break;
    case 0xe9: code = 0x9b4c; break;
    case 0xf9: code = 0xfd57; break;
    case 0xfa: code = 0xfcef; break;
    }
    break;
  case 0x6a: switch(c1) {
    case 0x03: code = 0x9cde; break;
    case 0x0b: code = 0xfd42; break;
    case 0x0c: code = 0x986c; break;
    case 0x1a: code = 0x97f9; break;
    case 0x1c: code = 0x9558; break;
    case 0x2b: code = 0x985e; break;
    case 0x2c: code = 0xfe7b; break;
    case 0x2d: code = 0x94cd; break;
    case 0x33: code = 0x93ee; break;
    case 0x43: code = 0x8ca3; break;
    case 0x45: code = 0xfd5a; break;
    case 0x4c: code = 0x93f5; break;
    case 0x52: code = 0x93ef; break;
    case 0x53: code = 0x8eea; break;
    case 0x57: code = 0x8f5b; break;
    case 0x63: code = 0x8c5e; break;
    case 0x65: code = 0x8dc6; break;
    case 0x71: code = 0x8dc8; break;
    case 0x74: code = 0x8dc7; break;
    case 0x7a: code = 0x93f7; break;
    case 0x82: code = 0x8dc9; break;
    case 0x8a: code = 0xfbf2; break;
    case 0x8f: code = 0x9670; break;
    case 0x99: code = 0x8dcb; break;
    case 0x9d: code = 0xfd5c; break;
    case 0xa7: code = 0x8f65; break;
    case 0xab: code = 0x8dcd; break;
    case 0xb1: code = 0x9da8; break;
    case 0xb2: code = 0x94f9; break;
    case 0xb5: code = 0x8dce; break;
    case 0xbe: code = 0x93ea; break;
    case 0xc8: code = 0xfd5f; break;
    case 0xc9: code = 0x93f0; break;
    case 0xca: code = 0x9fb6; break;
    case 0xd4: code = 0x8dcf; break;
    case 0xd8: code = 0x9763; break;
    case 0xf6: code = 0x8dd0; break;
    }
    break;
  case 0x6b: switch(c1) {
    case 0x05: code = 0x93f1; break;
    case 0x1d: code = 0xfd62; break;
    case 0x35: code = 0xfd65; break;
    case 0x52: code = 0x9fdb; break;
    case 0x57: code = 0x93f8; break;
    case 0x6f: code = 0x8bf7; break;
    case 0x74: code = 0xfd66; break;
    case 0x7a: code = 0x8bcf; break;
    case 0x81: code = 0x8dd1; break;
    case 0xc1: code = 0x8dd2; break;
    case 0xdc: code = 0xfd71; break;
    case 0xe1: code = 0xfd6f; break;
    case 0xea: code = 0x8dd3; break;
    case 0xfa: code = 0x9fe7; break;
    }
    break;
  case 0x6c: switch(c1) {
    case 0x1c: code = 0x90bd; break;
    case 0x31: code = 0x9fd0; break;
    case 0x35: code = 0x8bd0; break;
    case 0x37: code = 0xfd72; break;
    case 0x39: code = 0x9cae; break;
    case 0x3a: code = 0x8bd1; break;
    case 0x3d: code = 0x8adb; break;
    case 0x49: code = 0xfae4; break;
    case 0x4a: code = 0x9efd; break;
    case 0x58: code = 0x95ce; break;
    case 0x5a: code = 0xfd76; break;
    case 0x6e: code = 0xfb62; break;
    case 0x75: code = 0x8dd4; break;
    case 0x79: code = 0xfd78; break;
    case 0x7f: code = 0x8ee3; break;
    case 0x9c: code = 0xfdb7; break;
    case 0x9f: code = 0x9076; break;
    case 0xa2: code = 0x98c6; break;
    case 0xaa: code = 0x8dd5; break;
    case 0xaf: code = 0x97d1; break;
    case 0xb2: code = 0x9eb6; break;
    case 0xcb: code = 0xfac7; break;
    case 0xce: code = 0xa042; break;
    case 0xdf: code = 0x9873; break;
    case 0xea: code = 0x9ffc; break;
    case 0xff: code = 0x8ca5; break;
    }
    break;
  case 0x6d: switch(c1) {
    case 0x02: code = 0x8dd7; break;
    case 0x05: code = 0x92fb; break;
    case 0x06: code = 0x8dd8; break;
    case 0x24: code = 0x944f; break;
    case 0x26: code = 0x8dd9; break;
    case 0x4e: code = 0x896b; break;
    case 0x57: code = 0x97ce; break;
    case 0x5b: code = 0xfaf3; break;
    case 0x5c: code = 0xfdae; break;
    case 0x67: code = 0x9447; break;
    case 0x71: code = 0xfbaf; break;
    case 0x72: code = 0x92b7; break;
    case 0x81: code = 0x8dda; break;
    case 0x8f: code = 0x9c5a; break;
    case 0x96: code = 0xfdad; break;
    case 0xa4: code = 0x8ddc; break;
    case 0xa5: code = 0x9444; break;
    case 0xb1: code = 0x8ddd; break;
    case 0xb9: code = 0xa0d6; break;
    case 0xfe: code = 0x8c41; break;
    }
    break;
  case 0x6e: switch(c1) {
    case 0x02: code = 0x97d5; break;
    case 0x04: code = 0x944a; break;
    case 0x0a: code = 0x944d; break;
    case 0x0f: code = 0x97cb; break;
    case 0x15: code = 0x8dde; break;
    case 0x18: code = 0x8ddf; break;
    case 0x1d: code = 0xfdb8; break;
    case 0x29: code = 0x8de0; break;
    case 0x2a: code = 0xfef9; break;
    case 0x2f: code = 0xfdbb; break;
    case 0x4f: code = 0xfdc0; break;
    case 0x50: code = 0xfcf9; break;
    case 0x59: code = 0xfb7e; break;
    case 0x76: code = 0x92b3; break;
    case 0x7c: code = 0xfdaf; break;
    case 0x86: code = 0x8de1; break;
    case 0x8b: code = 0x95d3; break;
    case 0x9a: code = 0x89c1; break;
    case 0xb5: code = 0xfd68; break;
    case 0xb8: code = 0x9cb7; break;
    case 0xbb: code = 0x8de3; break;
    case 0xd9: code = 0xfac0; break;
    case 0xda: code = 0x8de5; break;
    case 0xdb: code = 0xfa64; break;
    case 0xdd: code = 0x8947; break;
    case 0xe2: code = 0x8de4; break;
    case 0xe8: code = 0x8de7; break;
    case 0xe9: code = 0x8de8; break;
    case 0xfa: code = 0xfdc7; break;
    }
    break;
  case 0x6f: switch(c1) {
    case 0x04: code = 0xfdb0; break;
    case 0x0b: code = 0x9445; break;
    case 0x0c: code = 0x97d6; break;
    case 0x16: code = 0xfcc6; break;
    case 0x17: code = 0x9844; break;
    case 0x24: code = 0x8de9; break;
    case 0x34: code = 0x8dea; break;
    case 0x3d: code = 0xfe50; break;
    case 0x44: code = 0xfdcc; break;
    case 0x56: code = 0x9da7; break;
    case 0x5c: code = 0xfdcd; break;
    case 0x74: code = 0xfdcf; break;
    case 0x79: code = 0x95d2; break;
    case 0x81: code = 0x8ded; break;
    case 0x8a: code = 0xfcba; break;
    case 0x9d: code = 0xfdc5; break;
    case 0x9f: code = 0xfdd2; break;
    case 0xb5: code = 0x9cdc; break;
    case 0xb6: code = 0x9bf6; break;
    case 0xbb: code = 0x95cf; break;
    case 0xbe: code = 0x8dee; break;
    case 0xd3: code = 0xfdd4; break;
    case 0xd9: code = 0x96ec; break;
    case 0xda: code = 0x96eb; break;
    case 0xf6: code = 0x90b6; break;
    case 0xf8: code = 0xfdc3; break;
    }
    break;
  case 0x70: switch(c1) {
    case 0x03: code = 0x98ab; break;
    case 0x1e: code = 0x96ed; break;
      /* case 0x1e: code = 0x96ee; break;*/
    case 0x2c: code = 0x8df4; break;
    case 0x4b: code = 0xfde0; break;
    case 0x4d: code = 0x8c67; break;
    case 0x50: code = 0x8df6; break;
    case 0x54: code = 0x8df7; break;
    case 0x5c: code = 0x8ffa; break;
    case 0x67: code = 0x97d0; break;
    case 0x6c: code = 0x8bd2; break;
    case 0x6f: code = 0x8df8; break;
    case 0x75: code = 0x90d9; break;
    case 0x77: code = 0x8c47; break;
    case 0x79: code = 0xfaf0; break;
    case 0x7e: code = 0xfde1; break;
    case 0x7f: code = 0x8df9; break;
    case 0x81: code = 0xfde3; break;
    case 0x89: code = 0x8dfa; break;
    case 0x8b: code = 0xfb63; break;
    case 0x8f: code = 0x90a6; break;
    case 0xa0: code = 0x9970; break;
    case 0xa3: code = 0x91eb; break;
    case 0xa5: code = 0x9770; break;
    case 0xa6: code = 0x986f; break;
    case 0xa7: code = 0xfde2; break;
    case 0xb9: code = 0x98f2; break;
    case 0xbb: code = 0x9afc; break;
    case 0xbc: code = 0x896c; break;
    case 0xbd: code = 0xfdfd; break;
    case 0xc0: code = 0x995e; break;
    case 0xc4: code = 0x95bd; break;
    case 0xcc: code = 0xfde4; break;
    case 0xd0: code = 0x91e6; break;
    case 0xd5: code = 0xfde5; break;
    case 0xd6: code = 0xfde6; break;
    case 0xdf: code = 0xfde7; break;
    case 0xf1: code = 0x9454; break;
    case 0xf5: code = 0x99b8; break;
    case 0xfe: code = 0x97e9; break;
    }
    break;
  case 0x71: switch(c1) {
    case 0x05: code = 0x9346; break;
    case 0x1d: code = 0x9863; break;
    case 0x29: code = 0x95bc; break;
    case 0x2b: code = 0xfded; break;
    case 0x2c: code = 0xfdf7; break;
    case 0x33: code = 0x9870; break;
    case 0x34: code = 0x96f6; break;
    case 0x35: code = 0x8ea9; break;
    case 0x3b: code = 0x9451; break;
    case 0x3e: code = 0x8e43; break;
    case 0x40: code = 0x8b5a; break;
    case 0x45: code = 0xfdee; break;
    case 0x4a: code = 0xfdf0; break;
    case 0x4f: code = 0xfdf4; break;
    case 0x51: code = 0x9bf5; break;
    case 0x62: code = 0xa0df; break;
    case 0x6b: code = 0x977e; break;
    case 0x6e: code = 0xfdf1; break;
    case 0x71: code = 0x9bd5; break;
    case 0x73: code = 0x9ac3; break;
    case 0x75: code = 0x97c8; break;
    case 0x76: code = 0xa0db; break;
    case 0x77: code = 0x91d0; break;
    case 0x7a: code = 0x9fe4; break;
    case 0x7c: code = 0x8fdd; break;
    case 0x7e: code = 0x91e9; break;
    case 0x88: code = 0x98e0; break;
    case 0x8c: code = 0x92ca; break;
    case 0x8e: code = 0x9857; break;
    case 0x91: code = 0x8c51; break;
    case 0x96: code = 0xfdeb; break;
    case 0x98: code = 0x9b49; break;
    case 0xa2: code = 0x9d76; break;
    case 0xa3: code = 0x9eaf; break;
    case 0xad: code = 0x9ccc; break;
    case 0xb4: code = 0xfdea; break;
    case 0xb7: code = 0x8df1; break;
    case 0xba: code = 0xfdfb; break;
    case 0xd1: code = 0x8e53; break;
    case 0xdd: code = 0xfacf; break;
    case 0xdf: code = 0x9c62; break;
    case 0xeb: code = 0x96f9; break;
    case 0xf5: code = 0x98bf; break;
    case 0xf6: code = 0x9e49; break;
    }
    break;
  case 0x72: switch(c1) {
    case 0x00: code = 0x8ca7; break;
    case 0x01: code = 0x9b76; break;
    case 0x09: code = 0x9bca; break;
    case 0x0e: code = 0xfdfe; break;
    case 0x0f: code = 0x92dc; break;
    case 0x15: code = 0xfe41; break;
    case 0x16: code = 0x91cc; break;
    case 0x17: code = 0x91e2; break;
    case 0x24: code = 0xfe44; break;
    case 0x2b: code = 0x8bd3; break;
    case 0x2e: code = 0xfe47; break;
    case 0x40: code = 0xfe48; break;
    case 0x50: code = 0xa0e4; break;
      /* case 0x50: code = 0x9455; break;*/
    case 0x55: code = 0xfe4b; break;
    case 0x57: code = 0xfe4c; break;
    case 0x5c: code = 0x8dbf; break;
    case 0x66: code = 0x9e78; break;
    case 0x82: code = 0xfe51; break;
    case 0x87: code = 0x9456; break;
    case 0x8f: code = 0x9d61; break;
    case 0x94: code = 0x9457; break;
    case 0x9f: code = 0x9966; break;
    case 0xad: code = 0x8bd5; break;
    case 0xb2: code = 0xa069; break;
    case 0xcd: code = 0x98b4; break;
    case 0xe2: code = 0xa049; break;
    }
    break;
  case 0x73: switch(c1) {
    case 0x02: code = 0xa04c; break;
    case 0x04: code = 0x9e65; break;
    case 0x10: code = 0x98b5; break;
    case 0x28: code = 0xfe58; break;
    case 0x2a: code = 0xfe52; break;
      /* case 0x2a: code = 0x9975; break;*/
    case 0x2b: code = 0xfe53; break;
    case 0x2c: code = 0xa065; break;
    case 0x2e: code = 0xfe59; break;
    case 0x38: code = 0x98b7; break;
    case 0x39: code = 0x98b8; break;
    case 0x41: code = 0x98ba; break;
    case 0x48: code = 0x98bb; break;
    case 0x4f: code = 0x9fbc; break;
    case 0x71: code = 0xa04a; break;
    case 0x74: code = 0x9ec7; break;
    case 0x8c: code = 0x8ca9; break;
    case 0x8f: code = 0x98ae; break;
    case 0x98: code = 0x92d6; break;
    case 0x9c: code = 0xfae1; break;
    case 0x9e: code = 0x91d4; break;
    case 0xa7: code = 0xfade; break;
    case 0xaa: code = 0xfe5b; break;
    case 0xba: code = 0x8c53; break;
    case 0xc9: code = 0xfe5e; break;
    case 0xce: code = 0xfbd7; break;
    case 0xcf: code = 0xfe5a; break;
    case 0xd0: code = 0x94c5; break;
    case 0xd5: code = 0xfaca; break;
    case 0xe1: code = 0x98c1; break;
    case 0xe2: code = 0x975c; break;
    case 0xe4: code = 0xfe74; break;
    case 0xe6: code = 0x9773; break;
    case 0xef: code = 0xfa46; break;
    case 0xf3: code = 0x9764; break;
    case 0xf7: code = 0xfe68; break;
    case 0xf9: code = 0x964e; break;
    case 0xfb: code = 0x9765; break;
    }
    break;
  case 0x74: switch(c1) {
    case 0x02: code = 0x8c5a; break;
    case 0x11: code = 0x89a1; break;
    case 0x12: code = 0x95fa; break;
    case 0x14: code = 0x92d4; break;
    case 0x15: code = 0xfe69; break;
    case 0x17: code = 0xfb45; break;
    case 0x19: code = 0x98c8; break;
    case 0x1c: code = 0x90ef; break;
    case 0x1e: code = 0x98c9; break;
    case 0x1f: code = 0x98ca; break;
    case 0x37: code = 0x946d; break;
    case 0x38: code = 0x94b7; break;
    case 0x39: code = 0xfe6c; break;
    case 0x3c: code = 0x946b; break;
    case 0x43: code = 0x92fc; break;
    case 0x45: code = 0x95eb; break;
    case 0x47: code = 0xfe73; break;
    case 0x48: code = 0x976e; break;
    case 0x49: code = 0xfe5f; break;
    case 0x53: code = 0xfdbd; break;
    case 0x56: code = 0x92d5; break;
    case 0x5c: code = 0xfe6f; break;
    case 0x5d: code = 0xfeb9; break;
    case 0x60: code = 0xfe71; break;
    case 0x65: code = 0xfbbb; break;
    case 0x68: code = 0xa0d5; break;
      /* case 0x68: code = 0x947a; break;*/
    case 0x6b: code = 0x95fb; break;
    case 0x6c: code = 0xfe77; break;
    case 0x74: code = 0xfe79; break;
    case 0x76: code = 0xfe75; break;
    case 0x79: code = 0x92d1; break;
    case 0x7a: code = 0x945d; break;
    case 0x82: code = 0xfe7c; break;
    case 0x8c: code = 0x9344; break;
    case 0x8d: code = 0x8ea6; break;
    case 0x99: code = 0x92d3; break;
    case 0x9b: code = 0x94b8; break;
    case 0xa4: code = 0xfc71; break;
    case 0xb4: code = 0x975e; break;
    case 0xb9: code = 0x8cad; break;
    case 0xc8: code = 0xfea7; break;
    case 0xcc: code = 0x946a; break;
    case 0xd0: code = 0x93e3; break;
    case 0xd3: code = 0x98cf; break;
    case 0xe7: code = 0xa0d9; break;
    case 0xe9: code = 0xfeaa; break;
    case 0xf0: code = 0xa0bf; break;
    case 0xf1: code = 0xa04d; break;
    case 0xf2: code = 0xa0b8; break;
    case 0xf8: code = 0xa0ce; break;
    }
    break;
  case 0x75: switch(c1) {
    case 0x05: code = 0xa0b7; break;
    case 0x0e: code = 0xfea9; break;
    case 0x19: code = 0x89c3; break;
    case 0x1e: code = 0xfeab; break;
    case 0x34: code = 0x9df4; break;
    case 0x35: code = 0x896d; break;
    case 0x3b: code = 0x9c7b; break;
    case 0x42: code = 0x98d2; break;
    case 0x46: code = 0x9fa9; break;
    case 0x4a: code = 0xfeb2; break;
    case 0x4d: code = 0xfeb1; break;
    case 0x51: code = 0x97d9; break;
    case 0x53: code = 0xa0c4; break;
    case 0x55: code = 0x9476; break;
    case 0x60: code = 0x9978; break;
    case 0x67: code = 0xfeb3; break;
    case 0x6d: code = 0x98d3; break;
    case 0x6e: code = 0xfeb4; break;
    case 0x72: code = 0x98d4; break;
    case 0x7a: code = 0x9fb9; break;
    case 0x83: code = 0x9471; break;
    case 0x8d: code = 0x98d5; break;
    case 0x8e: code = 0xfeb8; break;
    case 0x9e: code = 0xfeba; break;
    case 0xb1: code = 0x9e5c; break;
    case 0xb4: code = 0xfebb; break;
    case 0xc3: code = 0xa044; break;
    case 0xc8: code = 0x98d7; break;
    case 0xdc: code = 0x98d8; break;
    case 0xf9: code = 0x9eef; break;
    }
    break;
  case 0x76: switch(c1) {
    case 0x02: code = 0xfebc; break;
    case 0x07: code = 0x9ffe; break;
    case 0x2c: code = 0xfebd; break;
    case 0x3b: code = 0x9ddd; break;
    case 0x40: code = 0x9ee1; break;
    case 0x4d: code = 0x98da; break;
    case 0x4e: code = 0x9ddf; break;
    case 0x4f: code = 0xfebf; break;
    case 0x51: code = 0xfebe; break;
    case 0x54: code = 0x9eeb; break;
    case 0x66: code = 0x9e59; break;
    case 0x67: code = 0xa05c; break;
    case 0x6f: code = 0xfec0; break;
    case 0x73: code = 0x9477; break;
    case 0x74: code = 0x98dc; break;
    case 0x76: code = 0xfec1; break;
    case 0x7a: code = 0x98de; break;
    case 0x90: code = 0xfec3; break;
    case 0xa1: code = 0xfec8; break;
    case 0xa5: code = 0xfec9; break;
    case 0xb7: code = 0xfeca; break;
    case 0xcc: code = 0xfecb; break;
    case 0xd6: code = 0x9fc2; break;
    case 0xd9: code = 0x8c6b; break;
    }
    break;
  case 0x77: switch(c1) {
    case 0x0c: code = 0x98c4; break;
    case 0x0e: code = 0x94b0; break;
    case 0x0f: code = 0x94b1; break;
    case 0x1e: code = 0xfed1; break;
    case 0x24: code = 0xa0c1; break;
    case 0x26: code = 0xfed2; break;
    case 0x2b: code = 0xa0cd; break;
    case 0x40: code = 0xfed3; break;
    case 0x43: code = 0x98e5; break;
    case 0x58: code = 0xfed6; break;
    case 0x72: code = 0x91e4; break;
    case 0x77: code = 0x8fc7; break;
    case 0x78: code = 0x94ae; break;
    case 0x7a: code = 0x8a4f; break;
    case 0x7b: code = 0x94b2; break;
    case 0x93: code = 0x8fd4; break;
    case 0x98: code = 0x98ea; break;
    case 0xaf: code = 0xfed8; break;
    case 0xb9: code = 0x9de0; break;
    case 0xbe: code = 0x98ee; break;
    case 0xc3: code = 0x95c4; break;
    case 0xc5: code = 0xfce8; break;
    case 0xcb: code = 0x98ef; break;
    case 0xd7: code = 0x9b78; break;
    case 0xdd: code = 0x8c6e; break;
    case 0xe6: code = 0xfad8; break;
    case 0xf4: code = 0xfedc; break;
    case 0xfe: code = 0xa0ae; break;
    }
    break;
  case 0x78: switch(c1) {
    case 0x08: code = 0x9d4c; break;
    case 0x09: code = 0xfedd; break;
    case 0x18: code = 0x98f1; break;
    case 0x1c: code = 0x98f3; break;
    case 0x1e: code = 0x94c1; break;
    case 0x39: code = 0x98f5; break;
    case 0x3c: code = 0xfa4f; break;
    case 0x3d: code = 0x96e2; break;
    case 0x42: code = 0x9450; break;
    case 0x44: code = 0x96a2; break;
    case 0x47: code = 0x98f6; break;
    case 0x4b: code = 0x96e5; break;
    case 0x51: code = 0x98f7; break;
    case 0x53: code = 0xa046; break;
    case 0x54: code = 0x96e3; break;
    case 0x66: code = 0x98f8; break;
    case 0x7a: code = 0x9ee4; break;
    case 0x88: code = 0x94c3; break;
    case 0x8d: code = 0x94c2; break;
    case 0xaf: code = 0xfee1; break;
    case 0xb1: code = 0xfee9; break;
    case 0xb6: code = 0x96e4; break;
    case 0xb8: code = 0x89ac; break;
    case 0xb9: code = 0x96db; break;
    case 0xc7: code = 0xfee2; break;
    case 0xd2: code = 0x94c4; break;
    case 0xd3: code = 0xfee3; break;
    case 0xd7: code = 0xfee7; break;
    case 0xd8: code = 0x9ffb; break;
    case 0xe4: code = 0x8c59; break;
    case 0xee: code = 0x93c9; break;
    case 0xf0: code = 0x94e8; break;
    case 0xf1: code = 0xfb56; break;
    case 0xf5: code = 0x90c5; break;
    }
    break;
  case 0x79: switch(c1) {
    case 0x06: code = 0xa0a8; break;
    case 0x2e: code = 0xfee5; break;
    case 0x32: code = 0x98fd; break;
    case 0x33: code = 0x98fb; break;
    case 0x34: code = 0xfee8; break;
    case 0x36: code = 0x8ebf; break;
    case 0x3b: code = 0x8bd8; break;
    case 0x3c: code = 0xfef7; break;
    case 0x58: code = 0x8f68; break;
    case 0x59: code = 0x94c6; break;
    case 0x62: code = 0x9dea; break;
    case 0x71: code = 0xfc69; break;
    case 0x7e: code = 0x9cda; break;
    case 0x80: code = 0xfef3; break;
    case 0x83: code = 0x9c72; break;
    case 0x86: code = 0xfef0; break;
    case 0x87: code = 0x89c9; break;
    case 0x91: code = 0x9941; break;
    case 0x99: code = 0x9942; break;
    case 0x9b: code = 0x94ca; break;
    case 0x9d: code = 0xfef5; break;
    case 0x9f: code = 0x91d7; break;
    case 0xa5: code = 0x94cc; break;
    case 0xa9: code = 0xfef8; break;
    case 0xc4: code = 0x97a8; break;
    case 0xc6: code = 0xfefc; break;
    case 0xcc: code = 0xfdbf; break;
    case 0xd4: code = 0xfefe; break;
    case 0xe2: code = 0x96d1; break;
    case 0xe3: code = 0x9cbd; break;
    case 0xf1: code = 0x94d5; break;
    case 0xf4: code = 0x94d0; break;
    }
    break;
  case 0x7a: switch(c1) {
    case 0x06: code = 0x9944; break;
    case 0x2a: code = 0x8c63; break;
    case 0x2d: code = 0xa0b3; break;
    case 0x3a: code = 0x94cf; break;
    case 0x3e: code = 0x9ffa; break;
    case 0x43: code = 0x91e5; break;
    case 0x45: code = 0x9c6a; break;
    case 0x49: code = 0x8e49; break;
    case 0x65: code = 0x8e4c; break;
    case 0x7d: code = 0x8e4d; break;
    case 0x83: code = 0x9a73; break;
    case 0x91: code = 0x9947; break;
    case 0x93: code = 0x8cb1; break;
    case 0xb0: code = 0x8e50; break;
    case 0xbb: code = 0x8e4f; break;
    case 0xbc: code = 0x9949; break;
    case 0xc2: code = 0x8e51; break;
    case 0xc3: code = 0x8e52; break;
    case 0xc8: code = 0x9ab2; break;
    case 0xc9: code = 0x89a5; break;
    case 0xcf: code = 0x994c; break;
    case 0xd3: code = 0x9ff8; break;
    case 0xda: code = 0x8e56; break;
    case 0xdb: code = 0x994d; break;
    case 0xdc: code = 0x91ca; break;
    case 0xdd: code = 0x8e57; break;
    case 0xe2: code = 0x94e1; break;
    case 0xe7: code = 0x9047; break;
    case 0xe9: code = 0x8fd8; break;
    case 0xea: code = 0x8e58; break;
    case 0xfe: code = 0x94eb; break;
    }
    break;
  case 0x7b: switch(c1) {
    case 0x0b: code = 0x8e5c; break;
    case 0x0c: code = 0x9553; break;
    case 0x14: code = 0x9fe5; break;
    case 0x1f: code = 0x9f56; break;
    case 0x27: code = 0x954f; break;
    case 0x29: code = 0x8e5e; break;
    case 0x39: code = 0x996a; break;
    case 0x42: code = 0x9c64; break;
    case 0x43: code = 0x9cd9; break;
    case 0x51: code = 0x9d5a; break;
    case 0x55: code = 0x8e5d; break;
    case 0x62: code = 0x9950; break;
    case 0x6c: code = 0x9951; break;
    case 0x6f: code = 0x8e62; break;
    case 0x7b: code = 0x9952; break;
    case 0x92: code = 0x8e68; break;
    case 0xa2: code = 0x8e61; break;
    case 0xa3: code = 0x9f59; break;
    case 0xb2: code = 0x8bb3; break;
    case 0xb8: code = 0x8e69; break;
    case 0xcf: code = 0x9f5d; break;
    case 0xd0: code = 0x8e66; break;
    case 0xec: code = 0x8cb2; break;
    case 0xfa: code = 0x8e6e; break;
    case 0xfc: code = 0x9f64; break;
    }
    break;
  case 0x7c: switch(c1) {
    case 0x06: code = 0x8e6f; break;
    case 0x12: code = 0x9953; break;
    case 0x15: code = 0xfab8; break;
    case 0x1b: code = 0x9954; break;
    case 0x35: code = 0x8e70; break;
    case 0x42: code = 0x9f61; break;
    case 0x44: code = 0x8e72; break;
    case 0x51: code = 0xa06b; break;
    case 0x56: code = 0x9f40; break;
    case 0x5d: code = 0x94ed; break;
    case 0x6d: code = 0x94ee; break;
    case 0x70: code = 0x9fbd; break;
    case 0x74: code = 0x8e7b; break;
    case 0x7b: code = 0x9957; break;
    case 0x7c: code = 0x94f7; break;
    case 0x7e: code = 0x9f5f; break;
    case 0x83: code = 0x8e73; break;
    case 0x86: code = 0x9f62; break;
    case 0x8e: code = 0x94f6; break;
    case 0x9c: code = 0x9958; break;
    case 0xa6: code = 0x8e75; break;
    case 0xac: code = 0x9072; break;
    case 0xae: code = 0x94f8; break;
    case 0xb8: code = 0x995a; break;
    case 0xc2: code = 0xa0b0; break;
    case 0xc3: code = 0x8cb3; break;
    case 0xc7: code = 0x8e79; break;
    case 0xc9: code = 0x8e78; break;
    case 0xcd: code = 0x94f3; break;
    case 0xce: code = 0x8e7e; break;
    case 0xd3: code = 0x98af; break;
    case 0xda: code = 0xa0b2; break;
    case 0xe6: code = 0x8e7a; break;
    case 0xed: code = 0x995c; break;
    case 0xf3: code = 0x8e7c; break;
    case 0xf5: code = 0x8e7d; break;
    case 0xf9: code = 0x8bd9; break;
    case 0xfc: code = 0x89a2; break;
    }
    break;
  case 0x7d: switch(c1) {
    case 0x25: code = 0x9ed7; break;
    case 0x4d: code = 0xa0b6; break;
    case 0x5a: code = 0x9e42; break;
    case 0x5d: code = 0x8ea4; break;
    case 0x89: code = 0x8ea7; break;
    case 0x8b: code = 0x8c76; break;
    case 0x97: code = 0x9542; break;
    case 0xa4: code = 0x987d; break;
    case 0xa8: code = 0x9755; break;
    case 0xab: code = 0x8ea8; break;
    case 0xb3: code = 0x8eaa; break;
    case 0xcd: code = 0x89a3; break;
    case 0xcf: code = 0x9960; break;
    case 0xd0: code = 0x9962; break;
    case 0xd2: code = 0x8eab; break;
    case 0xd3: code = 0x94fc; break;
    case 0xd4: code = 0x9961; break;
    case 0xdc: code = 0x94fa; break;
    case 0xe4: code = 0x8eae; break;
    case 0xe5: code = 0x8eb2; break;
    case 0xf5: code = 0x8eb0; break;
    case 0xfd: code = 0x9963; break;
    case 0xfe: code = 0x97aa; break;
    }
    break;
  case 0x7e: switch(c1) {
    case 0x07: code = 0x94fb; break;
    case 0x1d: code = 0x8eb4; break;
    case 0x27: code = 0x8ebb; break;
    case 0x5b: code = 0x8cdc; break;
    case 0x65: code = 0x9876; break;
    case 0x67: code = 0x8ea1; break;
    case 0x6c: code = 0x8cb4; break;
    case 0x6e: code = 0x8eb7; break;
    case 0x7f: code = 0x9da6; break;
    case 0x87: code = 0x9b7b; break;
    case 0x8e: code = 0x9eb0; break;
    case 0x92: code = 0x8eb8; break;
    case 0x9f: code = 0x9d70; break;
    case 0xa4: code = 0x896e; break;
    case 0xac: code = 0x896f; break;
    case 0xba: code = 0x8970; break;
    case 0xc7: code = 0x8971; break;
    case 0xcf: code = 0x8972; break;
    case 0xdf: code = 0x8973; break;
    }
    break;
  case 0x7f: switch(c1) {
    case 0x06: code = 0x8974; break;
    case 0x37: code = 0x8975; break;
    case 0x40: code = 0x8ebc; break;
    case 0x41: code = 0x8ebd; break;
    case 0x47: code = 0x8ebe; break;
    case 0x49: code = 0x9dd1; break;
    case 0x4e: code = 0x94fd; break;
    case 0x52: code = 0x8bd7; break;
    case 0x53: code = 0x8bda; break;
    case 0x71: code = 0xa0e2; break;
    case 0x78: code = 0x9fe9; break;
    case 0x8f: code = 0xfda8; break;
    case 0x93: code = 0x8ae7; break;
    case 0x97: code = 0x8ec2; break;
    case 0xa3: code = 0x8ec4; break;
    case 0xae: code = 0x9964; break;
    case 0xb4: code = 0x9965; break;
    case 0xdd: code = 0x954e; break;
    case 0xe7: code = 0x98b3; break;
    case 0xfa: code = 0x8ecb; break;
    }
    break;
  case 0x80: switch(c1) {
    case 0x02: code = 0x8bdf; break;
    case 0x05: code = 0x8ecd; break;
    case 0x08: code = 0x8ece; break;
    case 0x1d: code = 0x8ecf; break;
    case 0x20: code = 0x9968; break;
    case 0x25: code = 0x9969; break;
    case 0x28: code = 0x8ed0; break;
    case 0x2e: code = 0x996b; break;
    case 0x2f: code = 0x8ed1; break;
    case 0x31: code = 0x996c; break;
    case 0x3b: code = 0x8ed4; break;
    case 0x3c: code = 0x8ed5; break;
    case 0x54: code = 0x996d; break;
    case 0x5b: code = 0xa0be; break;
    case 0x61: code = 0x8ed6; break;
    case 0x62: code = 0xa0bc; break;
    case 0x63: code = 0xa0b5; break;
    case 0x66: code = 0xa0b4; break;
    case 0x80: code = 0x8be0; break;
    case 0x9f: code = 0x89b5; break;
    case 0xa7: code = 0x8edd; break;
    case 0xb6: code = 0x9e5d; break;
    case 0xb7: code = 0x9971; break;
    case 0xbc: code = 0x89ae; break;
    case 0xbd: code = 0x9de8; break;
    case 0xc6: code = 0x9565; break;
    case 0xe9: code = 0x9972; break;
    case 0xec: code = 0x8b5c; break;
    case 0xf6: code = 0x89b1; break;
    }
    break;
  case 0x81: switch(c1) {
    case 0x03: code = 0xa0c0; break;
    case 0x07: code = 0x8edf; break;
    case 0x09: code = 0x9566; break;
    case 0x0c: code = 0x9974; break;
    case 0x0e: code = 0x9976; break;
    case 0x12: code = 0x9977; break;
    case 0x14: code = 0x9979; break;
    case 0x17: code = 0x9dda; break;
    case 0x1a: code = 0x8ee0; break;
    case 0x2a: code = 0x935c; break;
    case 0x32: code = 0x9de6; break;
    case 0x34: code = 0x8b5f; break;
    case 0x37: code = 0x9563; break;
    case 0x42: code = 0x9567; break;
    case 0x48: code = 0x9de3; break;
    case 0x56: code = 0x997c; break;
    case 0x59: code = 0x997d; break;
    case 0x5a: code = 0x997e; break;
    case 0x6d: code = 0x8b5b; break;
    case 0x7c: code = 0x99a3; break;
    case 0x84: code = 0x99a4; break;
    case 0x93: code = 0x99a6; break;
    case 0xa5: code = 0x99a8; break;
    case 0xaa: code = 0x8abe; break;
    case 0xb6: code = 0x9e61; break;
    case 0xc1: code = 0x99aa; break;
    case 0xc8: code = 0xa0c8; break;
    case 0xe4: code = 0x99ab; break;
    case 0xef: code = 0xfec4; break;
    case 0xf6: code = 0x98c2; break;
    }
    break;
  case 0x82: switch(c1) {
    case 0x18: code = 0x8ee8; break;
    case 0x1a: code = 0xa0ba; break;
    case 0x26: code = 0xfd77; break;
    case 0x29: code = 0x8eee; break;
    case 0x2d: code = 0x9ebf; break;
    case 0x3e: code = 0x89c2; break;
    case 0x54: code = 0x99ac; break;
    case 0x62: code = 0x956b; break;
    case 0x65: code = 0x956c; break;
    case 0x76: code = 0x99af; break;
    case 0x79: code = 0x994a; break;
    case 0x7a: code = 0x8976; break;
    case 0x7b: code = 0x8f48; break;
    case 0x87: code = 0xfbee; break;
    case 0xa6: code = 0x99ae; break;
    case 0xaa: code = 0x8efb; break;
    case 0xbf: code = 0x8cd0; break;
    case 0xc4: code = 0x8b52; break;
    case 0xca: code = 0x99b0; break;
    case 0xcf: code = 0x8977; break;
    case 0xd0: code = 0x8f41; break;
    case 0xd8: code = 0x99b1; break;
    case 0xe2: code = 0x8f49; break;
    case 0xee: code = 0xfa4d; break;
    case 0xf7: code = 0x9de4; break;
    case 0xf8: code = 0x8cb5; break;
    case 0xfc: code = 0xfbe9; break;
    case 0xfd: code = 0x9b54; break;
    case 0xff: code = 0x99b2; break;
    }
    break;
  case 0x83: switch(c1) {
    case 0x0b: code = 0x9e68; break;
    case 0x18: code = 0x8f4a; break;
    case 0x1a: code = 0x8f42; break;
    case 0x1d: code = 0x8f51; break;
    case 0x3d: code = 0x9846; break;
    case 0x57: code = 0x99b4; break;
    case 0x62: code = 0x8ef5; break;
    case 0x63: code = 0xfd55; break;
    case 0x66: code = 0x9ccd; break;
    case 0x6f: code = 0x8978; break;
    case 0x85: code = 0x8f53; break;
    case 0x91: code = 0x8f6f; break;
    case 0x9c: code = 0x8e63; break;
    case 0xac: code = 0x8f56; break;
    case 0xb9: code = 0xfe76; break;
    case 0xbe: code = 0x9fc6; break;
    case 0xc1: code = 0x8f57; break;
    case 0xcd: code = 0xfaac; break;
    case 0xcf: code = 0x9c77; break;
    case 0xd3: code = 0x8f58; break;
    case 0xed: code = 0x9848; break;
    }
    break;
  case 0x84: switch(c1) {
    case 0x05: code = 0x99b7; break;
    case 0x0f: code = 0x8f6e; break;
    case 0x14: code = 0x9665; break;
    case 0x16: code = 0xfa6c; break;
    case 0x18: code = 0x9de7; break;
    case 0x1c: code = 0x9e62; break;
    case 0x20: code = 0x96cc; break;
    case 0x21: code = 0x8e67; break;
    case 0x24: code = 0xfc75; break;
    case 0x26: code = 0x987e; break;
    case 0x2e: code = 0xfdb9; break;
    case 0x3e: code = 0x97fc; break;
    case 0x48: code = 0x98f9; break;
    case 0x4a: code = 0x8f66; break;
    case 0x53: code = 0x956e; break;
    case 0x55: code = 0x9245; break;
    case 0x58: code = 0x8f60; break;
    case 0x5c: code = 0x9ed1; break;
    case 0x62: code = 0xfecd; break;
    case 0x64: code = 0x99b9; break;
    case 0x71: code = 0x8f62; break;
    case 0x72: code = 0x974c; break;
    case 0x7f: code = 0x91c7; break;
    case 0x80: code = 0x955f; break;
    case 0x88: code = 0x99bb; break;
    case 0x92: code = 0x8e6d; break;
    case 0x93: code = 0x8f71; break;
    case 0x96: code = 0x94cb; break;
    case 0xa3: code = 0x95b1; break;
    case 0xa8: code = 0x8f69; break;
    case 0xad: code = 0x9af2; break;
    case 0xbd: code = 0x96c3; break;
    case 0xbe: code = 0x99bd; break;
    case 0xda: code = 0xa0cf; break;
    case 0xde: code = 0x8f6d; break;
    case 0xe1: code = 0x99be; break;
    case 0xe2: code = 0x8ef4; break;
    case 0xe4: code = 0x8f72; break;
    case 0xe5: code = 0x95e4; break;
    case 0xf8: code = 0x99bf; break;
    }
    break;
  case 0x85: switch(c1) {
    case 0x03: code = 0x9244; break;
      /* case 0x03: code = 0x9242; break;*/
    case 0x05: code = 0xfba5; break;
    case 0x10: code = 0x99c0; break;
    case 0x33: code = 0xfdb4; break;
    case 0x34: code = 0x8f77; break;
    case 0x38: code = 0x99c1; break;
    case 0x42: code = 0xfab9; break;
    case 0x4b: code = 0x8f40; break;
    case 0x4c: code = 0xfa44; break;
    case 0x52: code = 0x99c2; break;
    case 0x5a: code = 0x8f5c; break;
    case 0x5f: code = 0x8cbd; break;
    case 0x6f: code = 0x99c4; break;
    case 0x70: code = 0x99c5; break;
    case 0x73: code = 0x8f7b; break;
    case 0x97: code = 0x8cb6; break;
    case 0xc1: code = 0x8fa3; break;
    case 0xd6: code = 0x8cce; break;
    case 0xe0: code = 0x99c6; break;
    case 0xee: code = 0x96cd; break;
    case 0xfc: code = 0x96c7; break;
    }
    break;
  case 0x86: switch(c1) {
    case 0x02: code = 0x8fa5; break;
    case 0x0d: code = 0xfabb; break;
    case 0x0f: code = 0x8c61; break;
    case 0x10: code = 0x9570; break;
    case 0x14: code = 0x9368; break;
    case 0x16: code = 0x8f7e; break;
    case 0x28: code = 0x8faa; break;
    case 0x2f: code = 0xa050; break;
    case 0x42: code = 0x90d3; break;
    case 0x45: code = 0x9556; break;
    case 0x6c: code = 0x8fb8; break;
    case 0x72: code = 0x99c8; break;
    case 0x7e: code = 0x8faf; break;
    case 0x92: code = 0x99c9; break;
    case 0xa0: code = 0x9579; break;
    case 0xad: code = 0x9f49; break;
    case 0xb2: code = 0x99ca; break;
    case 0xef: code = 0x99cb; break;
    }
    break;
  case 0x87: switch(c1) {
    case 0x70: code = 0x9dd5; break;
    case 0x71: code = 0x8fb0; break;
    case 0x7d: code = 0xfa7a; break;
    case 0x86: code = 0x9e5f; break;
    case 0x8b: code = 0x99cd; break;
    case 0x8c: code = 0xa0c9; break;
    case 0xa5: code = 0x9adb; break;
    case 0xa9: code = 0xa0c6; break;
    case 0xb1: code = 0x8fb4; break;
    case 0xc1: code = 0xa0d7; break;
    case 0xce: code = 0xa0c7; break;
    case 0xd6: code = 0xa043; break;
    case 0xda: code = 0x8fb5; break;
    case 0xee: code = 0x8fb2; break;
    case 0xf5: code = 0xa061; break;
    }
    break;
  case 0x88: switch(c1) {
    case 0x04: code = 0x9e5e; break;
    case 0x0f: code = 0x8fb6; break;
      /* case 0x0f: code = 0xa063; break;*/
    case 0x18: code = 0x9fe8; break;
    case 0x27: code = 0x9cb2; break;
    case 0x2d: code = 0x957c; break;
    case 0x42: code = 0x9fc7; break;
    case 0x45: code = 0x8fbb; break;
    case 0x46: code = 0x8fbc; break;
    case 0x4f: code = 0x8fec; break;
    case 0x5e: code = 0x8fc0; break;
    case 0x60: code = 0x936a; break;
    case 0x64: code = 0x8be4; break;
    case 0x65: code = 0x9c7c; break;
    case 0x6e: code = 0x95a1; break;
    case 0x84: code = 0xfeec; break;
    case 0x87: code = 0x95a3; break;
    case 0x8f: code = 0x8c45; break;
    case 0x90: code = 0x8cb8; break;
    case 0x9c: code = 0x8fc1; break;
    case 0xa0: code = 0xa052; break;
    case 0xae: code = 0x99d0; break;
    case 0xb4: code = 0x8fc3; break;
    case 0xb5: code = 0x8fc4; break;
    case 0xbf: code = 0x95a4; break;
    case 0xc5: code = 0x8fc6; break;
    case 0xc7: code = 0x9e60; break;
    case 0xe6: code = 0x95a5; break;
    case 0xf5: code = 0x9cb3; break;
    case 0xff: code = 0x99d1; break;
    }
    break;
  case 0x89: switch(c1) {
    case 0x00: code = 0xfef1; break;
    case 0x24: code = 0x99d2; break;
    case 0x43: code = 0x9cc2; break;
    case 0x47: code = 0x99d3; break;
    case 0x4d: code = 0x95a7; break;
    case 0x54: code = 0x95a9; break;
    case 0x65: code = 0x95a6; break;
    case 0x77: code = 0x9c5d; break;
    case 0x80: code = 0x98e2; break;
    case 0x87: code = 0x8fc9; break;
    case 0x89: code = 0xa0c2; break;
    case 0x8a: code = 0x8fca; break;
    case 0x91: code = 0x99d4; break;
    case 0x94: code = 0xa0b9; break;
    case 0xa5: code = 0x9b58; break;
    case 0xa6: code = 0x8fcb; break;
    case 0xa7: code = 0x8fcd; break;
    case 0xa9: code = 0xa0d4; break;
      /* case 0xa9: code = 0x8fcc; break;*/
    case 0xbc: code = 0x8fce; break;
    case 0xc1: code = 0x8be5; break;
    case 0xc6: code = 0x8979; break;
    case 0xe7: code = 0x8fd0; break;
    }
    break;
  case 0x8a: switch(c1) {
    case 0x1c: code = 0x95b6; break;
    case 0x29: code = 0x99d6; break;
    case 0x2b: code = 0x95e5; break;
    case 0x38: code = 0x99d7; break;
    case 0x3d: code = 0x95b5; break;
    case 0x49: code = 0xa0ca; break;
    case 0x67: code = 0x9ffd; break;
    case 0x7e: code = 0xa058; break;
    case 0x90: code = 0x8fd6; break;
    case 0x94: code = 0x99d8; break;
    case 0x9c: code = 0x8fd3; break;
    case 0xa9: code = 0x8fe5; break;
    case 0xaf: code = 0x8fe9; break;
    case 0xb4: code = 0x99d9; break;
    case 0xda: code = 0x927c; break;
    case 0xea: code = 0x9c45; break;
    }
    break;
  case 0x8b: switch(c1) {
    case 0x0c: code = 0x8fde; break;
    case 0x1f: code = 0x8fdf; break;
    case 0x2d: code = 0xa04b; break;
    case 0x3f: code = 0x8fe2; break;
    case 0x43: code = 0xa0cc; break;
    case 0x4c: code = 0x8fe3; break;
    case 0x4d: code = 0x8fe4; break;
    case 0x5e: code = 0x9bc4; break;
    case 0x62: code = 0x9bfc; break;
    case 0x69: code = 0x964c; break;
    case 0x81: code = 0x9af6; break;
    case 0x83: code = 0x8cae; break;
    case 0x90: code = 0x8fe7; break;
    case 0x9b: code = 0x8fe8; break;
    case 0xa0: code = 0x8be7; break;
    case 0xbe: code = 0x897a; break;
    case 0xe2: code = 0x897b; break;
    }
    break;
  case 0x8c: switch(c1) {
    case 0x51: code = 0x99da; break;
    case 0x9b: code = 0x8fed; break;
    case 0x9f: code = 0x95c0; break;
    case 0xad: code = 0xa0cb; break;
    case 0xcd: code = 0x9e48; break;
    case 0xd4: code = 0x99db; break;
    case 0xd6: code = 0x8ff3; break;
    case 0xdb: code = 0x8ff9; break;
    case 0xe9: code = 0x95c1; break;
    case 0xeb: code = 0xa04e; break;
    case 0xf2: code = 0x99dc; break;
    case 0xf7: code = 0xa064; break;
    }
    break;
  case 0x8d: switch(c1) {
    case 0x03: code = 0x8ff7; break;
    case 0x0b: code = 0x89b0; break;
    case 0x0c: code = 0xa048; break;
    case 0x11: code = 0x8ffb; break;
    case 0x12: code = 0x8ff6; break;
    case 0x18: code = 0x9ddc; break;
    case 0x1c: code = 0x99dd; break;
    case 0x1d: code = 0x8be8; break;
    case 0x77: code = 0x8ffe; break;
    case 0x7a: code = 0x92c1; break;
    case 0x82: code = 0x9fd6; break;
    case 0xa6: code = 0xa0d2; break;
    case 0xa9: code = 0x9040; break;
    case 0xc0: code = 0x8ac4; break;
    case 0xc3: code = 0x99e0; break;
    case 0xd4: code = 0x9ff0; break;
    }
    break;
  case 0x8e: switch(c1) {
    case 0x01: code = 0x9ff3; break;
    case 0x0e: code = 0x9dbf; break;
    case 0x28: code = 0x9ff6; break;
    case 0x2a: code = 0x95c8; break;
    case 0x2d: code = 0x9e5a; break;
    case 0x3a: code = 0x99e3; break;
    case 0x46: code = 0x8a4a; break;
    case 0x4f: code = 0x9ff1; break;
    case 0x68: code = 0x8aa7; break;
    case 0x71: code = 0x99e6; break;
    case 0x75: code = 0x9ff7; break;
    case 0x77: code = 0x9fed; break;
    case 0x7e: code = 0x8a5c; break;
    case 0x80: code = 0x9dae; break;
    case 0xa7: code = 0x95c9; break;
    case 0xad: code = 0x9048; break;
    case 0xb0: code = 0x99e8; break;
    case 0xb6: code = 0x9049; break;
    case 0xb9: code = 0x8cba; break;
    case 0xbc: code = 0x90b1; break;
    case 0xc3: code = 0x904a; break;
    case 0xce: code = 0x99ea; break;
    case 0xda: code = 0x9bd1; break;
    case 0xe2: code = 0x99eb; break;
    case 0xe4: code = 0x99ec; break;
    case 0xed: code = 0x99ed; break;
    case 0xf2: code = 0x99ee; break;
    }
    break;
  case 0x8f: switch(c1) {
    case 0x0b: code = 0x9d57; break;
    case 0x19: code = 0x904c; break;
    case 0x2d: code = 0x904d; break;
    case 0x30: code = 0x95cb; break;
    case 0x36: code = 0x9c42; break;
    case 0x41: code = 0x97e2; break;
    case 0x4a: code = 0x95cc; break;
    case 0x5c: code = 0x9f78; break;
    case 0x66: code = 0x897c; break;
    case 0x67: code = 0x897d; break;
    case 0x6e: code = 0x897e; break;
    case 0x93: code = 0x995d; break;
    case 0xa0: code = 0x9b5a; break;
    case 0xa5: code = 0x9050; break;
    case 0xa7: code = 0x8c4f; break;
    case 0xb3: code = 0x9054; break;
    case 0xb6: code = 0x9aa8; break;
    case 0xb7: code = 0x99ef; break;
    case 0xb8: code = 0xfeeb; break;
    case 0xb9: code = 0x9da3; break;
    case 0xba: code = 0x9da1; break;
    case 0xbb: code = 0x9943; break;
    case 0xbc: code = 0x9945; break;
    case 0xbe: code = 0x9d7d; break;
    case 0xc1: code = 0x99f0; break;
    case 0xca: code = 0x99f1; break;
    case 0xcc: code = 0x99f2; break;
    case 0xcf: code = 0x8cbc; break;
    case 0xd0: code = 0x9d60; break;
    case 0xda: code = 0xa0a3; break;
    case 0xf9: code = 0x905b; break;
    }
    break;
  case 0x90: switch(c1) {
    case 0x08: code = 0x9edb; break;
    case 0x12: code = 0x9d79; break;
    case 0x33: code = 0x99f3; break;
    case 0x37: code = 0x9062; break;
    case 0x4c: code = 0x9f55; break;
    case 0x56: code = 0x9bf9; break;
    case 0x61: code = 0x9065; break;
    case 0x64: code = 0x96e0; break;
    case 0x6c: code = 0x98be; break;
    case 0x97: code = 0x95d9; break;
    case 0xa8: code = 0x9068; break;
    case 0xae: code = 0x906c; break;
    case 0xbb: code = 0x95d8; break;
    case 0xc4: code = 0x906a; break;
    case 0xfd: code = 0x906d; break;
    }
    break;
  case 0x91: switch(c1) {
    case 0x04: code = 0x9c68; break;
    case 0x51: code = 0x9fb2; break;
    case 0x59: code = 0x9fae; break;
    case 0x5c: code = 0x9fb0; break;
    case 0x5e: code = 0x89ad; break;
    case 0x67: code = 0x906e; break;
    case 0x70: code = 0x9e71; break;
    case 0x76: code = 0x9e4a; break;
    case 0x7c: code = 0x9fdc; break;
    case 0x8c: code = 0x89ab; break;
    case 0x8e: code = 0x9fb8; break;
    case 0xa9: code = 0x9070; break;
    case 0xb6: code = 0x8b63; break;
    case 0xbb: code = 0x95dc; break;
    case 0xc4: code = 0x9071; break;
    case 0xd4: code = 0x9bde; break;
    case 0xd6: code = 0xfc5e; break;
    case 0xdf: code = 0x8949; break;
    case 0xe5: code = 0x965b; break;
    case 0xf6: code = 0x8c50; break;
    case 0xfa: code = 0x94a6; break;
    case 0xfe: code = 0x8fd5; break;
    }
    break;
  case 0x92: switch(c1) {
    case 0x08: code = 0x9e73; break;
    case 0x0e: code = 0x9075; break;
    case 0x13: code = 0x99f7; break;
    case 0x21: code = 0x8cbf; break;
    case 0x28: code = 0x99f9; break;
    case 0x2a: code = 0x9663; break;
    case 0x2b: code = 0x95b9; break;
    case 0x35: code = 0x94d4; break;
    case 0x3c: code = 0xfcfa; break;
    case 0x41: code = 0x9077; break;
    case 0x44: code = 0x90ab; break;
    case 0x55: code = 0x9d4d; break;
    case 0x58: code = 0x99fa; break;
    case 0x5d: code = 0x92e3; break;
    case 0x5f: code = 0x97bb; break;
    case 0x62: code = 0x9078; break;
    case 0x6b: code = 0x99fb; break;
    case 0x6e: code = 0x97e0; break;
    case 0x77: code = 0x96dc; break;
    case 0x81: code = 0x9ca8; break;
    case 0x84: code = 0x9772; break;
    case 0x89: code = 0x9440; break;
    case 0x8f: code = 0x92f2; break;
    case 0xae: code = 0x99fd; break;
    case 0xb1: code = 0x99fc; break;
    case 0xb9: code = 0x907a; break;
    case 0xba: code = 0x964a; break;
    case 0xbe: code = 0x96d8; break;
    case 0xbf: code = 0x99fe; break;
    case 0xd4: code = 0x904b; break;
    case 0xdb: code = 0xfa41; break;
    case 0xe3: code = 0x9a40; break;
    case 0xe5: code = 0x975b; break;
    case 0xeb: code = 0x9a41; break;
    case 0xec: code = 0x91dd; break;
    case 0xf2: code = 0x93fc; break;
    case 0xf3: code = 0x9a42; break;
    case 0xf4: code = 0x9a43; break;
    case 0xf6: code = 0x9659; break;
    case 0xfd: code = 0x9a44; break;
    }
    break;
  case 0x93: switch(c1) {
    case 0x03: code = 0x9051; break;
    case 0x07: code = 0x94bf; break;
    case 0x2c: code = 0x90a2; break;
    case 0x30: code = 0x9cab; break;
    case 0x31: code = 0x9776; break;
    case 0x40: code = 0xfc55; break;
    case 0x41: code = 0xfe45; break;
    case 0x42: code = 0x94a8; break;
    case 0x43: code = 0x9a45; break;
    case 0x44: code = 0xfa4b; break;
    case 0x45: code = 0x9de1; break;
    case 0x48: code = 0x96d9; break;
    case 0x5f: code = 0x9774; break;
    case 0x62: code = 0xfdf5; break;
    case 0x66: code = 0x92e5; break;
    case 0x68: code = 0x9645; break;
    case 0x69: code = 0x91da; break;
    case 0x6b: code = 0x90a3; break;
    case 0x6e: code = 0xa05f; break;
      /* case 0x6e: code = 0x92c8; break;*/
    case 0x73: code = 0x90af; break;
    case 0x74: code = 0x97bf; break;
    case 0x78: code = 0x914c; break;
    case 0x7d: code = 0x967a; break;
    case 0x81: code = 0x91de; break;
    case 0x84: code = 0x9a46; break;
    case 0x85: code = 0xfeb0; break;
    case 0x86: code = 0x9779; break;
    case 0x87: code = 0x946c; break;
    case 0x90: code = 0x9858; break;
    case 0x9c: code = 0x9266; break;
    case 0xa0: code = 0x93fb; break;
    case 0xad: code = 0x9a47; break;
    case 0xb8: code = 0x9749; break;
    case 0xbb: code = 0x9748; break;
    case 0xbd: code = 0x934a; break;
    case 0xbf: code = 0x9ce2; break;
    case 0xc6: code = 0x9264; break;
    case 0xcb: code = 0x91df; break;
    case 0xd3: code = 0xfb79; break;
    case 0xdb: code = 0x96d7; break;
    case 0xe0: code = 0x9343; break;
    case 0xf0: code = 0xfdcb; break;
    case 0xf1: code = 0xfe7a; break;
    case 0xf3: code = 0x91db; break;
    case 0xf4: code = 0x8c6a; break;
    }
    break;
  case 0x94: switch(c1) {
    case 0x01: code = 0x97af; break;
    case 0x04: code = 0x95dd; break;
    case 0x08: code = 0x9348; break;
    case 0x17: code = 0x9a4b; break;
    case 0x1b: code = 0xfc45; break;
    case 0x1d: code = 0x9a4d; break;
    case 0x24: code = 0x91bc; break;
    case 0x25: code = 0x90e2; break;
    case 0x26: code = 0x90b4; break;
    case 0x27: code = 0x95e1; break;
    case 0x2d: code = 0x9a4e; break;
    case 0x3e: code = 0x9a4f; break;
    case 0x42: code = 0xfe40; break;
    case 0x43: code = 0xfe43; break;
    case 0x4d: code = 0x96dd; break;
    case 0x54: code = 0x9a51; break;
    case 0x58: code = 0x96a7; break;
    case 0x5b: code = 0x90b0; break;
    case 0x65: code = 0x9c4e; break;
    case 0x67: code = 0x9443; break;
    case 0x6c: code = 0x8eba; break;
    case 0x79: code = 0x9a52; break;
    case 0x7b: code = 0xfcc1; break;
    case 0x85: code = 0x8be9; break;
    case 0x9f: code = 0x9caf; break;
    case 0xa2: code = 0x8bfd; break;
    case 0xc1: code = 0x9abc; break;
    case 0xc3: code = 0x9ab8; break;
    case 0xdc: code = 0x9aae; break;
    case 0xf6: code = 0x9aa7; break;
    }
    break;
  case 0x95: switch(c1) {
    case 0x2d: code = 0x9a53; break;
    case 0x47: code = 0x9d74; break;
    case 0x78: code = 0x8bea; break;
    case 0x7f: code = 0x8beb; break;
    case 0x85: code = 0x90b2; break;
    case 0x96: code = 0x95e9; break;
    case 0x97: code = 0x95e8; break;
    case 0x99: code = 0x95e6; break;
    case 0xa0: code = 0x90b5; break;
    case 0xa2: code = 0x9a54; break;
    case 0xa6: code = 0x90b3; break;
    case 0xa7: code = 0x95e7; break;
    case 0xaa: code = 0x8b50; break;
    case 0xe8: code = 0x8bec; break;
    case 0xf4: code = 0x9a56; break;
    }
    break;
  case 0x96: switch(c1) {
    case 0x1d: code = 0x8bfb; break;
    case 0x33: code = 0x9a57; break;
    case 0x38: code = 0xa0aa; break;
    case 0x41: code = 0x9fa6; break;
    case 0x45: code = 0x99cc; break;
    case 0x56: code = 0x9c59; break;
    case 0x69: code = 0x99b5; break;
    case 0x7b: code = 0x90be; break;
    case 0x81: code = 0x9faf; break;
    case 0x8f: code = 0x95f2; break;
    case 0x96: code = 0x90bf; break;
    case 0xa3: code = 0x90c1; break;
    case 0xa5: code = 0xfee4; break;
    case 0xb6: code = 0x90c4; break;
    case 0xbd: code = 0x90c7; break;
    case 0xf4: code = 0x92e4; break;
    }
    break;
  case 0x97: switch(c1) {
    case 0x03: code = 0x9f52; break;
    case 0x1b: code = 0x90db; break;
    case 0x21: code = 0xa066; break;
    case 0x31: code = 0x90d2; break;
    case 0x36: code = 0x90d4; break;
    case 0x40: code = 0x9a5b; break;
    case 0x41: code = 0x95fd; break;
    case 0x51: code = 0x8bc4; break;
    case 0x55: code = 0x8c66; break;
    case 0x57: code = 0x90de; break;
    case 0x5c: code = 0x90dc; break;
    case 0x5d: code = 0x9ce4; break;
      /* case 0x5d: code = 0x9644; break;*/
    case 0x5f: code = 0x90e1; break;
    case 0x6d: code = 0x9e46; break;
    case 0x71: code = 0x9651; break;
    case 0x87: code = 0xfb58; break;
    case 0x89: code = 0x90e6; break;
    case 0x9b: code = 0x9650; break;
    case 0x9f: code = 0x90e7; break;
    case 0xb1: code = 0x90e8; break;
    case 0xb2: code = 0x9a5d; break;
    case 0xb4: code = 0x9f7a; break;
    case 0xb8: code = 0x9b5c; break;
    case 0xba: code = 0x9f7c; break;
    case 0xbd: code = 0xfc52; break;
    case 0xbe: code = 0x90e9; break;
    case 0xc0: code = 0x90ea; break;
    case 0xc2: code = 0x9a5e; break;
    case 0xc8: code = 0x9f76; break;
    case 0xd2: code = 0x90eb; break;
    case 0xe0: code = 0x90ec; break;
    case 0xe6: code = 0x8bee; break;
    case 0xee: code = 0x90ee; break;
    case 0xf2: code = 0x91c6; break;
    case 0xf5: code = 0x90f2; break;
    case 0xff: code = 0x90f1; break;
    }
    break;
  case 0x98: switch(c1) {
    case 0x14: code = 0xfcbc; break;
    case 0x15: code = 0x8a74; break;
    case 0x1f: code = 0x9657; break;
    case 0x23: code = 0x9cef; break;
    case 0x2e: code = 0x9fdf; break;
    case 0x33: code = 0x90f7; break;
    case 0x34: code = 0x90f6; break;
    case 0x47: code = 0x9b5e; break;
    case 0x4b: code = 0x90f8; break;
    case 0x66: code = 0x90f9; break;
    case 0x68: code = 0x8cc9; break;
    case 0x6c: code = 0xfa6a; break;
    case 0x75: code = 0x8bef; break;
    case 0xb4: code = 0x9fe0; break;
    case 0xb7: code = 0x9142; break;
    case 0xb9: code = 0x9a62; break;
    case 0xc3: code = 0x9569; break;
    case 0xc7: code = 0x9144; break;
    case 0xc8: code = 0x9143; break;
    case 0xca: code = 0x9141; break;
    case 0xce: code = 0x8bf0; break;
    case 0xdc: code = 0x9660; break;
    case 0xde: code = 0x8bf1; break;
    case 0xe0: code = 0x99f6; break;
    case 0xe1: code = 0x9149; break;
    case 0xe6: code = 0x914a; break;
    case 0xec: code = 0x914b; break;
    case 0xf1: code = 0x9a64; break;
    case 0xf5: code = 0x8abf; break;
    }
    break;
  case 0x99: switch(c1) {
    case 0x0e: code = 0x9a66; break;
    case 0x19: code = 0x9a67; break;
    case 0x1c: code = 0x9a69; break;
    case 0x37: code = 0x9a6a; break;
    case 0x38: code = 0x9652; break;
    case 0x39: code = 0x914d; break;
    case 0x3b: code = 0x9666; break;
    case 0x40: code = 0x9f7b; break;
    case 0x42: code = 0x9a6b; break;
    case 0x4a: code = 0xa06c; break;
    case 0x4d: code = 0x9667; break;
    case 0x5d: code = 0x9a6c; break;
    case 0x62: code = 0x9a6d; break;
    case 0x63: code = 0x8bf2; break;
    case 0x9b: code = 0x966a; break;
    case 0xa4: code = 0xfcea; break;
    case 0xaa: code = 0x966c; break;
    case 0xb8: code = 0x91c4; break;
    case 0xbc: code = 0x9677; break;
    case 0xc4: code = 0x99f4; break;
    case 0xc5: code = 0x9a6f; break;
    case 0xd6: code = 0x9bc6; break;
    case 0xda: code = 0x9fab; break;
    case 0xe0: code = 0x8cbe; break;
    case 0xe1: code = 0x8ec1; break;
    case 0xe6: code = 0x9555; break;
    case 0xf5: code = 0x9152; break;
    }
    break;
  case 0x9a: switch(c1) {
    case 0x0c: code = 0x9153; break;
    case 0x10: code = 0x9155; break;
    case 0x1f: code = 0x955d; break;
    case 0x21: code = 0x9671; break;
    case 0x26: code = 0x9c6d; break;
    case 0x2f: code = 0x9673; break;
    case 0x3b: code = 0x9154; break;
    case 0x3c: code = 0x9a71; break;
    case 0x58: code = 0x9156; break;
    case 0x5c: code = 0x966d; break;
    case 0x63: code = 0x9557; break;
    case 0x6c: code = 0x89c6; break;
    case 0x8f: code = 0x89c7; break;
    case 0xb2: code = 0x8a6a; break;
    case 0xb6: code = 0x8b57; break;
    case 0xba: code = 0x9fe1; break;
    case 0xbd: code = 0x9b5f; break;
    case 0xd7: code = 0xa05d; break;
    case 0xe0: code = 0x915b; break;
    case 0xe2: code = 0x915c; break;
    case 0xf4: code = 0x915e; break;
    case 0xff: code = 0x9f5c; break;
    }
    break;
  case 0x9b: switch(c1) {
    case 0x02: code = 0x9f57; break;
    case 0x09: code = 0x9f65; break;
    case 0x0f: code = 0x9a72; break;
    case 0x14: code = 0x9160; break;
    case 0x2a: code = 0x9f5e; break;
    case 0x2d: code = 0x9161; break;
    case 0x2e: code = 0x9f60; break;
    case 0x34: code = 0x9164; break;
    case 0x39: code = 0x9f41; break;
    case 0x40: code = 0x9169; break;
    case 0x50: code = 0x9168; break;
    case 0x69: code = 0x9a74; break;
    case 0x7f: code = 0x96b2; break;
    case 0x81: code = 0x9a75; break;
    case 0x83: code = 0xfda5; break;
    case 0x8b: code = 0x9ee9; break;
    case 0x8d: code = 0x8bba; break;
    case 0x8e: code = 0x916d; break;
    case 0x8f: code = 0xa060; break;
    case 0x97: code = 0x9fde; break;
    case 0x9d: code = 0x9fc3; break;
    case 0x9f: code = 0x96b5; break;
    case 0xb0: code = 0xa067; break;
    case 0xcf: code = 0x96b3; break;
    case 0xdd: code = 0x9a76; break;
    case 0xe9: code = 0x95d5; break;
    case 0xed: code = 0x9eca; break;
    case 0xf1: code = 0x9a77; break;
    case 0xf4: code = 0x9a78; break;
    case 0xff: code = 0x9170; break;
    }
    break;
  case 0x9c: switch(c1) {
    case 0x02: code = 0x916f; break;
    case 0x0a: code = 0x9fa3; break;
    case 0x0c: code = 0x9171; break;
    case 0x10: code = 0x96b1; break;
    case 0x15: code = 0x9f63; break;
    case 0x1b: code = 0x9f67; break;
    case 0x1f: code = 0x8bb9; break;
    case 0x20: code = 0x9a7a; break;
    case 0x26: code = 0x8b56; break;
    case 0x2f: code = 0x9ada; break;
    case 0x35: code = 0x96b0; break;
    case 0x3a: code = 0x9a7e; break;
    case 0x45: code = 0x9dde; break;
    case 0x4f: code = 0x96ad; break;
    case 0x53: code = 0x96ae; break;
    case 0x5d: code = 0x9ea1; break;
    case 0x72: code = 0x9e50; break;
    case 0x7b: code = 0x96af; break;
    case 0x7c: code = 0x8bf4; break;
    }
    break;
  case 0x9d: switch(c1) {
    case 0x02: code = 0x9fa4; break;
    case 0x0c: code = 0x96bd; break;
    case 0x16: code = 0x96f4; break;
    case 0x21: code = 0x96b8; break;
    case 0x34: code = 0xfaa1; break;
    case 0x39: code = 0x91a7; break;
    case 0x44: code = 0xa05e; break;
    case 0x49: code = 0x9a7d; break;
    case 0x4e: code = 0x8948; break;
    case 0x50: code = 0x9eb1; break;
    case 0x5e: code = 0x9ddb; break;
    case 0x6d: code = 0x95bf; break;
    case 0x6e: code = 0x8a73; break;
    case 0x7c: code = 0x9efe; break;
    case 0x7e: code = 0x917a; break;
    case 0x83: code = 0x917b; break;
    case 0x93: code = 0x9aa3; break;
    case 0xa5: code = 0x96c2; break;
    case 0xab: code = 0x9f77; break;
    case 0xbd: code = 0x9aa4; break;
    case 0xc0: code = 0x9aa5; break;
    case 0xc4: code = 0x91a1; break;
    case 0xc9: code = 0x89b8; break;
    case 0xd4: code = 0x9173; break;
    case 0xf0: code = 0x9c6b; break;
    case 0xfc: code = 0x9aa6; break;
    }
    break;
  case 0x9e: switch(c1) {
    case 0x0a: code = 0x89bd; break;
    case 0x0c: code = 0x89b9; break;
    case 0x0e: code = 0x917d; break;
    case 0x18: code = 0x96bb; break;
    case 0x1c: code = 0x9ff2; break;
    case 0x1f: code = 0x8bf5; break;
    case 0x7b: code = 0x9aa9; break;
    case 0x81: code = 0x9f54; break;
    case 0x84: code = 0x9fe3; break;
    case 0x85: code = 0x9eed; break;
    case 0x90: code = 0x91aa; break;
    case 0x95: code = 0x91ab; break;
    case 0x96: code = 0xa070; break;
    case 0x98: code = 0x9f6d; break;
    case 0x9e: code = 0x91ac; break;
    case 0xa2: code = 0x91ad; break;
    case 0xa6: code = 0xa0fd; break;
    case 0xa8: code = 0x9fe2; break;
    case 0xaa: code = 0x91af; break;
    case 0xab: code = 0x9e41; break;
    case 0xac: code = 0x9aaa; break;
    case 0xaf: code = 0x91b0; break;
    case 0xb1: code = 0x9aab; break;
    case 0xbd: code = 0x9aac; break;
    case 0xbf: code = 0x9a4a; break;
    case 0xc1: code = 0x91b2; break;
    case 0xc4: code = 0x8bf6; break;
    case 0xc6: code = 0x9aad; break;
    case 0xc7: code = 0x89b6; break;
    case 0xe2: code = 0x9aaf; break;
    case 0xf1: code = 0x9ab0; break;
    case 0xf8: code = 0x9ab1; break;
    case 0xfe: code = 0x9aa1; break;
    }
    break;
  case 0x9f: switch(c1) {
    case 0x02: code = 0x91b9; break;
    case 0x08: code = 0x91ba; break;
    case 0x16: code = 0x91bf; break;
    case 0x17: code = 0x9f66; break;
      /* case 0x17: code = 0x91be; break;*/
    case 0x26: code = 0xa041; break;
    case 0x27: code = 0x8bb7; break;
    case 0x39: code = 0x91c0; break;
    case 0x44: code = 0x9ab3; break;
    case 0x45: code = 0x91c3; break;
    case 0x50: code = 0xa0fc; break;
    case 0x53: code = 0x9fee; break;
    case 0x5a: code = 0x9f69; break;
    case 0x62: code = 0x91c8; break;
    case 0x69: code = 0x91c9; break;
    case 0x7f: code = 0x8de6; break;
    case 0x8e: code = 0x91cb; break;
    case 0x99: code = 0x89c8; break;
    case 0x9f: code = 0x8daa; break;
    case 0xa5: code = 0x9fdd; break;
    }
    break;
  case 0xe0: switch(c1) {
    case 0x00: code = 0xfa40; break;
    case 0x01: code = 0xfa41; break;
    case 0x02: code = 0xfa42; break;
    case 0x03: code = 0xfa43; break;
    case 0x04: code = 0xfa44; break;
    case 0x05: code = 0xfa45; break;
    case 0x06: code = 0xfa46; break;
    case 0x07: code = 0xfa47; break;
    case 0x08: code = 0xfa48; break;
    case 0x09: code = 0xfa49; break;
    case 0x0a: code = 0xfa4a; break;
    case 0x0b: code = 0xfa4b; break;
    case 0x0c: code = 0xfa4c; break;
    case 0x0d: code = 0xfa4d; break;
    case 0x0e: code = 0xfa4e; break;
    case 0x0f: code = 0xfa4f; break;
    case 0x10: code = 0xfa50; break;
    case 0x11: code = 0xfa51; break;
    case 0x12: code = 0xfa52; break;
    case 0x13: code = 0xfa53; break;
    case 0x14: code = 0xfa54; break;
    case 0x15: code = 0xfa55; break;
    case 0x16: code = 0xfa56; break;
    case 0x17: code = 0xfa57; break;
    case 0x18: code = 0xfa58; break;
    case 0x19: code = 0xfa59; break;
    case 0x1a: code = 0xfa5a; break;
    case 0x1b: code = 0xfa5b; break;
    case 0x1c: code = 0xfa5c; break;
    case 0x1d: code = 0xfa5d; break;
    case 0x1e: code = 0xfa5e; break;
    case 0x1f: code = 0xfa5f; break;
    case 0x20: code = 0xfa60; break;
    case 0x21: code = 0xfa61; break;
    case 0x22: code = 0xfa62; break;
    case 0x23: code = 0xfa63; break;
    case 0x24: code = 0xfa64; break;
    case 0x25: code = 0xfa65; break;
    case 0x26: code = 0xfa66; break;
    case 0x27: code = 0xfa67; break;
    case 0x28: code = 0xfa68; break;
    case 0x29: code = 0xfa69; break;
    case 0x2a: code = 0xfa6a; break;
    case 0x2b: code = 0xfa6b; break;
    case 0x2c: code = 0xfa6c; break;
    case 0x2d: code = 0xfa6d; break;
    case 0x2e: code = 0xfa6e; break;
    case 0x2f: code = 0xfa6f; break;
    case 0x30: code = 0xfa70; break;
    case 0x31: code = 0xfa71; break;
    case 0x32: code = 0xfa72; break;
    case 0x33: code = 0xfa73; break;
    case 0x34: code = 0xfa74; break;
    case 0x35: code = 0xfa75; break;
    case 0x36: code = 0xfa76; break;
    case 0x37: code = 0xfa77; break;
    case 0x38: code = 0xfa78; break;
    case 0x39: code = 0xfa79; break;
    case 0x3a: code = 0xfa7a; break;
    case 0x3b: code = 0xfa7b; break;
    case 0x3c: code = 0xfa7c; break;
    case 0x3d: code = 0xfa7d; break;
    case 0x3e: code = 0xfa7e; break;
    case 0x3f: code = 0xfaa1; break;
    case 0x40: code = 0xfaa2; break;
    case 0x41: code = 0xfaa3; break;
    case 0x42: code = 0xfaa4; break;
    case 0x43: code = 0xfaa5; break;
    case 0x44: code = 0xfaa6; break;
    case 0x45: code = 0xfaa7; break;
    case 0x46: code = 0xfaa8; break;
    case 0x47: code = 0xfaa9; break;
    case 0x48: code = 0xfaaa; break;
    case 0x49: code = 0xfaab; break;
    case 0x4a: code = 0xfaac; break;
    case 0x4b: code = 0xfaad; break;
    case 0x4c: code = 0xfaae; break;
    case 0x4d: code = 0xfaaf; break;
    case 0x4e: code = 0xfab0; break;
    case 0x4f: code = 0xfab1; break;
    case 0x50: code = 0xfab2; break;
    case 0x51: code = 0xfab3; break;
    case 0x52: code = 0xfab4; break;
    case 0x53: code = 0xfab5; break;
    case 0x54: code = 0xfab6; break;
    case 0x55: code = 0xfab7; break;
    case 0x56: code = 0xfab8; break;
    case 0x57: code = 0xfab9; break;
    case 0x58: code = 0xfaba; break;
    case 0x59: code = 0xfabb; break;
    case 0x5a: code = 0xfabc; break;
    case 0x5b: code = 0xfabd; break;
    case 0x5c: code = 0xfabe; break;
    case 0x5d: code = 0xfabf; break;
    case 0x5e: code = 0xfac0; break;
    case 0x5f: code = 0xfac1; break;
    case 0x60: code = 0xfac2; break;
    case 0x61: code = 0xfac3; break;
    case 0x62: code = 0xfac4; break;
    case 0x63: code = 0xfac5; break;
    case 0x64: code = 0xfac6; break;
    case 0x65: code = 0xfac7; break;
    case 0x66: code = 0xfac8; break;
    case 0x67: code = 0xfac9; break;
    case 0x68: code = 0xfaca; break;
    case 0x69: code = 0xfacb; break;
    case 0x6a: code = 0xfacc; break;
    case 0x6b: code = 0xfacd; break;
    case 0x6c: code = 0xface; break;
    case 0x6d: code = 0xfacf; break;
    case 0x6e: code = 0xfad0; break;
    case 0x6f: code = 0xfad1; break;
    case 0x70: code = 0xfad2; break;
    case 0x71: code = 0xfad3; break;
    case 0x72: code = 0xfad4; break;
    case 0x73: code = 0xfad5; break;
    case 0x74: code = 0xfad6; break;
    case 0x75: code = 0xfad7; break;
    case 0x76: code = 0xfad8; break;
    case 0x77: code = 0xfad9; break;
    case 0x78: code = 0xfada; break;
    case 0x79: code = 0xfadb; break;
    case 0x7a: code = 0xfadc; break;
    case 0x7b: code = 0xfadd; break;
    case 0x7c: code = 0xfade; break;
    case 0x7d: code = 0xfadf; break;
    case 0x7e: code = 0xfae0; break;
    case 0x7f: code = 0xfae1; break;
    case 0x80: code = 0xfae2; break;
    case 0x81: code = 0xfae3; break;
    case 0x82: code = 0xfae4; break;
    case 0x83: code = 0xfae5; break;
    case 0x84: code = 0xfae6; break;
    case 0x85: code = 0xfae7; break;
    case 0x86: code = 0xfae8; break;
    case 0x87: code = 0xfae9; break;
    case 0x88: code = 0xfaea; break;
    case 0x89: code = 0xfaeb; break;
    case 0x8a: code = 0xfaec; break;
    case 0x8b: code = 0xfaed; break;
    case 0x8c: code = 0xfaee; break;
    case 0x8d: code = 0xfaef; break;
    case 0x8e: code = 0xfaf0; break;
    case 0x8f: code = 0xfaf1; break;
    case 0x90: code = 0xfaf2; break;
    case 0x91: code = 0xfaf3; break;
    case 0x92: code = 0xfaf4; break;
    case 0x93: code = 0xfaf5; break;
    case 0x94: code = 0xfaf6; break;
    case 0x95: code = 0xfaf7; break;
    case 0x96: code = 0xfaf8; break;
    case 0x97: code = 0xfaf9; break;
    case 0x98: code = 0xfafa; break;
    case 0x99: code = 0xfafb; break;
    case 0x9a: code = 0xfafc; break;
    case 0x9b: code = 0xfafd; break;
    case 0x9c: code = 0xfafe; break;
    case 0x9d: code = 0xfb40; break;
    case 0x9e: code = 0xfb41; break;
    case 0x9f: code = 0xfb42; break;
    case 0xa0: code = 0xfb43; break;
    case 0xa1: code = 0xfb44; break;
    case 0xa2: code = 0xfb45; break;
    case 0xa3: code = 0xfb46; break;
    case 0xa4: code = 0xfb47; break;
    case 0xa5: code = 0xfb48; break;
    case 0xa6: code = 0xfb49; break;
    case 0xa7: code = 0xfb4a; break;
    case 0xa8: code = 0xfb4b; break;
    case 0xa9: code = 0xfb4c; break;
    case 0xaa: code = 0xfb4d; break;
    case 0xab: code = 0xfb4e; break;
    case 0xac: code = 0xfb4f; break;
    case 0xad: code = 0xfb50; break;
    case 0xae: code = 0xfb51; break;
    case 0xaf: code = 0xfb52; break;
    case 0xb0: code = 0xfb53; break;
    case 0xb1: code = 0xfb54; break;
    case 0xb2: code = 0xfb55; break;
    case 0xb3: code = 0xfb56; break;
    case 0xb4: code = 0xfb57; break;
    case 0xb5: code = 0xfb58; break;
    case 0xb6: code = 0xfb59; break;
    case 0xb7: code = 0xfb5a; break;
    case 0xb8: code = 0xfb5b; break;
    case 0xb9: code = 0xfb5c; break;
    case 0xba: code = 0xfb5d; break;
    case 0xbb: code = 0xfb5e; break;
    case 0xbc: code = 0xfb5f; break;
    case 0xbd: code = 0xfb60; break;
    case 0xbe: code = 0xfb61; break;
    case 0xbf: code = 0xfb62; break;
    case 0xc0: code = 0xfb63; break;
    case 0xc1: code = 0xfb64; break;
    case 0xc2: code = 0xfb65; break;
    case 0xc3: code = 0xfb66; break;
    case 0xc4: code = 0xfb67; break;
    case 0xc5: code = 0xfb68; break;
    case 0xc6: code = 0xfb69; break;
    case 0xc7: code = 0xfb6a; break;
    case 0xc8: code = 0xfb6b; break;
    case 0xc9: code = 0xfb6c; break;
    case 0xca: code = 0xfb6d; break;
    case 0xcb: code = 0xfb6e; break;
    case 0xcc: code = 0xfb6f; break;
    case 0xcd: code = 0xfb70; break;
    case 0xce: code = 0xfb71; break;
    case 0xcf: code = 0xfb72; break;
    case 0xd0: code = 0xfb73; break;
    case 0xd1: code = 0xfb74; break;
    case 0xd2: code = 0xfb75; break;
    case 0xd3: code = 0xfb76; break;
    case 0xd4: code = 0xfb77; break;
    case 0xd5: code = 0xfb78; break;
    case 0xd6: code = 0xfb79; break;
    case 0xd7: code = 0xfb7a; break;
    case 0xd8: code = 0xfb7b; break;
    case 0xd9: code = 0xfb7c; break;
    case 0xda: code = 0xfb7d; break;
    case 0xdb: code = 0xfb7e; break;
    case 0xdc: code = 0xfba1; break;
    case 0xdd: code = 0xfba2; break;
    case 0xde: code = 0xfba3; break;
    case 0xdf: code = 0xfba4; break;
    case 0xe0: code = 0xfba5; break;
    case 0xe1: code = 0xfba6; break;
    case 0xe2: code = 0xfba7; break;
    case 0xe3: code = 0xfba8; break;
    case 0xe4: code = 0xfba9; break;
    case 0xe5: code = 0xfbaa; break;
    case 0xe6: code = 0xfbab; break;
    case 0xe7: code = 0xfbac; break;
    case 0xe8: code = 0xfbad; break;
    case 0xe9: code = 0xfbae; break;
    case 0xea: code = 0xfbaf; break;
    case 0xeb: code = 0xfbb0; break;
    case 0xec: code = 0xfbb1; break;
    case 0xed: code = 0xfbb2; break;
    case 0xee: code = 0xfbb3; break;
    case 0xef: code = 0xfbb4; break;
    case 0xf0: code = 0xfbb5; break;
    case 0xf1: code = 0xfbb6; break;
    case 0xf2: code = 0xfbb7; break;
    case 0xf3: code = 0xfbb8; break;
    case 0xf4: code = 0xfbb9; break;
    case 0xf5: code = 0xfbba; break;
    case 0xf6: code = 0xfbbb; break;
    case 0xf7: code = 0xfbbc; break;
    case 0xf8: code = 0xfbbd; break;
    case 0xf9: code = 0xfbbe; break;
    case 0xfa: code = 0xfbbf; break;
    case 0xfb: code = 0xfbc0; break;
    case 0xfc: code = 0xfbc1; break;
    case 0xfd: code = 0xfbc2; break;
    case 0xfe: code = 0xfbc3; break;
    case 0xff: code = 0xfbc4; break;
    }
    break;
  case 0xe1: switch(c1) {
    case 0x00: code = 0xfbc5; break;
    case 0x01: code = 0xfbc6; break;
    case 0x02: code = 0xfbc7; break;
    case 0x03: code = 0xfbc8; break;
    case 0x04: code = 0xfbc9; break;
    case 0x05: code = 0xfbca; break;
    case 0x06: code = 0xfbcb; break;
    case 0x07: code = 0xfbcc; break;
    case 0x08: code = 0xfbcd; break;
    case 0x09: code = 0xfbce; break;
    case 0x0a: code = 0xfbcf; break;
    case 0x0b: code = 0xfbd0; break;
    case 0x0c: code = 0xfbd1; break;
    case 0x0d: code = 0xfbd2; break;
    case 0x0e: code = 0xfbd3; break;
    case 0x0f: code = 0xfbd4; break;
    case 0x10: code = 0xfbd5; break;
    case 0x11: code = 0xfbd6; break;
    case 0x12: code = 0xfbd7; break;
    case 0x13: code = 0xfbd8; break;
    case 0x14: code = 0xfbd9; break;
    case 0x15: code = 0xfbda; break;
    case 0x16: code = 0xfbdb; break;
    case 0x17: code = 0xfbdc; break;
    case 0x18: code = 0xfbdd; break;
    case 0x19: code = 0xfbde; break;
    case 0x1a: code = 0xfbdf; break;
    case 0x1b: code = 0xfbe0; break;
    case 0x1c: code = 0xfbe1; break;
    case 0x1d: code = 0xfbe2; break;
    case 0x1e: code = 0xfbe3; break;
    case 0x1f: code = 0xfbe4; break;
    case 0x20: code = 0xfbe5; break;
    case 0x21: code = 0xfbe6; break;
    case 0x22: code = 0xfbe7; break;
    case 0x23: code = 0xfbe8; break;
    case 0x24: code = 0xfbe9; break;
    case 0x25: code = 0xfbea; break;
    case 0x26: code = 0xfbeb; break;
    case 0x27: code = 0xfbec; break;
    case 0x28: code = 0xfbed; break;
    case 0x29: code = 0xfbee; break;
    case 0x2a: code = 0xfbef; break;
    case 0x2b: code = 0xfbf0; break;
    case 0x2c: code = 0xfbf1; break;
    case 0x2d: code = 0xfbf2; break;
    case 0x2e: code = 0xfbf3; break;
    case 0x2f: code = 0xfbf4; break;
    case 0x30: code = 0xfbf5; break;
    case 0x31: code = 0xfbf6; break;
    case 0x32: code = 0xfbf7; break;
    case 0x33: code = 0xfbf8; break;
    case 0x34: code = 0xfbf9; break;
    case 0x35: code = 0xfbfa; break;
    case 0x36: code = 0xfbfb; break;
    case 0x37: code = 0xfbfc; break;
    case 0x38: code = 0xfbfd; break;
    case 0x39: code = 0xfbfe; break;
    case 0x3a: code = 0xfc40; break;
    case 0x3b: code = 0xfc41; break;
    case 0x3c: code = 0xfc42; break;
    case 0x3d: code = 0xfc43; break;
    case 0x3e: code = 0xfc44; break;
    case 0x3f: code = 0xfc45; break;
    case 0x40: code = 0xfc46; break;
    case 0x41: code = 0xfc47; break;
    case 0x42: code = 0xfc48; break;
    case 0x43: code = 0xfc49; break;
    case 0x44: code = 0xfc4a; break;
    case 0x45: code = 0xfc4b; break;
    case 0x46: code = 0xfc4c; break;
    case 0x47: code = 0xfc4d; break;
    case 0x48: code = 0xfc4e; break;
    case 0x49: code = 0xfc4f; break;
    case 0x4a: code = 0xfc50; break;
    case 0x4b: code = 0xfc51; break;
    case 0x4c: code = 0xfc52; break;
    case 0x4d: code = 0xfc53; break;
    case 0x4e: code = 0xfc54; break;
    case 0x4f: code = 0xfc55; break;
    case 0x50: code = 0xfc56; break;
    case 0x51: code = 0xfc57; break;
    case 0x52: code = 0xfc58; break;
    case 0x53: code = 0xfc59; break;
    case 0x54: code = 0xfc5a; break;
    case 0x55: code = 0xfc5b; break;
    case 0x56: code = 0xfc5c; break;
    case 0x57: code = 0xfc5d; break;
    case 0x58: code = 0xfc5e; break;
    case 0x59: code = 0xfc5f; break;
    case 0x5a: code = 0xfc60; break;
    case 0x5b: code = 0xfc61; break;
    case 0x5c: code = 0xfc62; break;
    case 0x5d: code = 0xfc63; break;
    case 0x5e: code = 0xfc64; break;
    case 0x5f: code = 0xfc65; break;
    case 0x60: code = 0xfc66; break;
    case 0x61: code = 0xfc67; break;
    case 0x62: code = 0xfc68; break;
    case 0x63: code = 0xfc69; break;
    case 0x64: code = 0xfc6a; break;
    case 0x65: code = 0xfc6b; break;
    case 0x66: code = 0xfc6c; break;
    case 0x67: code = 0xfc6d; break;
    case 0x68: code = 0xfc6e; break;
    case 0x69: code = 0xfc6f; break;
    case 0x6a: code = 0xfc70; break;
    case 0x6b: code = 0xfc71; break;
    case 0x6c: code = 0xfc72; break;
    case 0x6d: code = 0xfc73; break;
    case 0x6e: code = 0xfc74; break;
    case 0x6f: code = 0xfc75; break;
    case 0x70: code = 0xfc76; break;
    case 0x71: code = 0xfc77; break;
    case 0x72: code = 0xfc78; break;
    case 0x73: code = 0xfc79; break;
    case 0x74: code = 0xfc7a; break;
    case 0x75: code = 0xfc7b; break;
    case 0x76: code = 0xfc7c; break;
    case 0x77: code = 0xfc7d; break;
    case 0x78: code = 0xfc7e; break;
    case 0x79: code = 0xfca1; break;
    case 0x7a: code = 0xfca2; break;
    case 0x7b: code = 0xfca3; break;
    case 0x7c: code = 0xfca4; break;
    case 0x7d: code = 0xfca5; break;
    case 0x7e: code = 0xfca6; break;
    case 0x7f: code = 0xfca7; break;
    case 0x80: code = 0xfca8; break;
    case 0x81: code = 0xfca9; break;
    case 0x82: code = 0xfcaa; break;
    case 0x83: code = 0xfcab; break;
    case 0x84: code = 0xfcac; break;
    case 0x85: code = 0xfcad; break;
    case 0x86: code = 0xfcae; break;
    case 0x87: code = 0xfcaf; break;
    case 0x88: code = 0xfcb0; break;
    case 0x89: code = 0xfcb1; break;
    case 0x8a: code = 0xfcb2; break;
    case 0x8b: code = 0xfcb3; break;
    case 0x8c: code = 0xfcb4; break;
    case 0x8d: code = 0xfcb5; break;
    case 0x8e: code = 0xfcb6; break;
    case 0x8f: code = 0xfcb7; break;
    case 0x90: code = 0xfcb8; break;
    case 0x91: code = 0xfcb9; break;
    case 0x92: code = 0xfcba; break;
    case 0x93: code = 0xfcbb; break;
    case 0x94: code = 0xfcbc; break;
    case 0x95: code = 0xfcbd; break;
    case 0x96: code = 0xfcbe; break;
    case 0x97: code = 0xfcbf; break;
    case 0x98: code = 0xfcc0; break;
    case 0x99: code = 0xfcc1; break;
    case 0x9a: code = 0xfcc2; break;
    case 0x9b: code = 0xfcc3; break;
    case 0x9c: code = 0xfcc4; break;
    case 0x9d: code = 0xfcc5; break;
    case 0x9e: code = 0xfcc6; break;
    case 0x9f: code = 0xfcc7; break;
    case 0xa0: code = 0xfcc8; break;
    case 0xa1: code = 0xfcc9; break;
    case 0xa2: code = 0xfcca; break;
    case 0xa3: code = 0xfccb; break;
    case 0xa4: code = 0xfccc; break;
    case 0xa5: code = 0xfccd; break;
    case 0xa6: code = 0xfcce; break;
    case 0xa7: code = 0xfccf; break;
    case 0xa8: code = 0xfcd0; break;
    case 0xa9: code = 0xfcd1; break;
    case 0xaa: code = 0xfcd2; break;
    case 0xab: code = 0xfcd3; break;
    case 0xac: code = 0xfcd4; break;
    case 0xad: code = 0xfcd5; break;
    case 0xae: code = 0xfcd6; break;
    case 0xaf: code = 0xfcd7; break;
    case 0xb0: code = 0xfcd8; break;
    case 0xb1: code = 0xfcd9; break;
    case 0xb2: code = 0xfcda; break;
    case 0xb3: code = 0xfcdb; break;
    case 0xb4: code = 0xfcdc; break;
    case 0xb5: code = 0xfcdd; break;
    case 0xb6: code = 0xfcde; break;
    case 0xb7: code = 0xfcdf; break;
    case 0xb8: code = 0xfce0; break;
    case 0xb9: code = 0xfce1; break;
    case 0xba: code = 0xfce2; break;
    case 0xbb: code = 0xfce3; break;
    case 0xbc: code = 0xfce4; break;
    case 0xbd: code = 0xfce5; break;
    case 0xbe: code = 0xfce6; break;
    case 0xbf: code = 0xfce7; break;
    case 0xc0: code = 0xfce8; break;
 case 0xc1: code = 0xfce9; break;
 case 0xc2: code = 0xfcea; break;
 case 0xc3: code = 0xfceb; break;
 case 0xc4: code = 0xfcec; break;
 case 0xc5: code = 0xfced; break;
 case 0xc6: code = 0xfcee; break;
 case 0xc7: code = 0xfcef; break;
 case 0xc8: code = 0xfcf0; break;
 case 0xc9: code = 0xfcf1; break;
 case 0xca: code = 0xfcf2; break;
 case 0xcb: code = 0xfcf3; break;
 case 0xcc: code = 0xfcf4; break;
 case 0xcd: code = 0xfcf5; break;
 case 0xce: code = 0xfcf6; break;
 case 0xcf: code = 0xfcf7; break;
 case 0xd0: code = 0xfcf8; break;
 case 0xd1: code = 0xfcf9; break;
 case 0xd2: code = 0xfcfa; break;
 case 0xd3: code = 0xfcfb; break;
 case 0xd4: code = 0xfcfc; break;
 case 0xd5: code = 0xfcfd; break;
 case 0xd6: code = 0xfcfe; break;
 case 0xd7: code = 0xfd40; break;
 case 0xd8: code = 0xfd41; break;
 case 0xd9: code = 0xfd42; break;
 case 0xda: code = 0xfd43; break;
 case 0xdb: code = 0xfd44; break;
 case 0xdc: code = 0xfd45; break;
 case 0xdd: code = 0xfd46; break;
 case 0xde: code = 0xfd47; break;
 case 0xdf: code = 0xfd48; break;
 case 0xe0: code = 0xfd49; break;
 case 0xe1: code = 0xfd4a; break;
 case 0xe2: code = 0xfd4b; break;
 case 0xe3: code = 0xfd4c; break;
 case 0xe4: code = 0xfd4d; break;
 case 0xe5: code = 0xfd4e; break;
 case 0xe6: code = 0xfd4f; break;
 case 0xe7: code = 0xfd50; break;
 case 0xe8: code = 0xfd51; break;
 case 0xe9: code = 0xfd52; break;
 case 0xea: code = 0xfd53; break;
 case 0xeb: code = 0xfd54; break;
 case 0xec: code = 0xfd55; break;
 case 0xed: code = 0xfd56; break;
 case 0xee: code = 0xfd57; break;
 case 0xef: code = 0xfd58; break;
 case 0xf0: code = 0xfd59; break;
 case 0xf1: code = 0xfd5a; break;
 case 0xf2: code = 0xfd5b; break;
 case 0xf3: code = 0xfd5c; break;
 case 0xf4: code = 0xfd5d; break;
 case 0xf5: code = 0xfd5e; break;
 case 0xf6: code = 0xfd5f; break;
 case 0xf7: code = 0xfd60; break;
 case 0xf8: code = 0xfd61; break;
 case 0xf9: code = 0xfd62; break;
 case 0xfa: code = 0xfd63; break;
 case 0xfb: code = 0xfd64; break;
 case 0xfc: code = 0xfd65; break;
 case 0xfd: code = 0xfd66; break;
 case 0xfe: code = 0xfd67; break;
 case 0xff: code = 0xfd68; break;
    }
    break;
  case 0xe2: switch(c1) {
 case 0x00: code = 0xfd69; break;
 case 0x01: code = 0xfd6a; break;
 case 0x02: code = 0xfd6b; break;
 case 0x03: code = 0xfd6c; break;
 case 0x04: code = 0xfd6d; break;
 case 0x05: code = 0xfd6e; break;
 case 0x06: code = 0xfd6f; break;
 case 0x07: code = 0xfd70; break;
 case 0x08: code = 0xfd71; break;
 case 0x09: code = 0xfd72; break;
 case 0x0a: code = 0xfd73; break;
 case 0x0b: code = 0xfd74; break;
 case 0x0c: code = 0xfd75; break;
 case 0x0d: code = 0xfd76; break;
 case 0x0e: code = 0xfd77; break;
 case 0x0f: code = 0xfd78; break;
 case 0x10: code = 0xfd79; break;
 case 0x11: code = 0xfd7a; break;
 case 0x12: code = 0xfd7b; break;
 case 0x13: code = 0xfd7c; break;
 case 0x14: code = 0xfd7d; break;
 case 0x15: code = 0xfd7e; break;
 case 0x16: code = 0xfda1; break;
 case 0x17: code = 0xfda2; break;
 case 0x18: code = 0xfda3; break;
 case 0x19: code = 0xfda4; break;
 case 0x1a: code = 0xfda5; break;
 case 0x1b: code = 0xfda6; break;
 case 0x1c: code = 0xfda7; break;
 case 0x1d: code = 0xfda8; break;
 case 0x1e: code = 0xfda9; break;
 case 0x1f: code = 0xfdaa; break;
 case 0x20: code = 0xfdab; break;
 case 0x21: code = 0xfdac; break;
 case 0x22: code = 0xfdad; break;
 case 0x23: code = 0xfdae; break;
 case 0x24: code = 0xfdaf; break;
 case 0x25: code = 0xfdb0; break;
 case 0x26: code = 0xfdb1; break;
 case 0x27: code = 0xfdb2; break;
 case 0x28: code = 0xfdb3; break;
 case 0x29: code = 0xfdb4; break;
 case 0x2a: code = 0xfdb5; break;
 case 0x2b: code = 0xfdb6; break;
 case 0x2c: code = 0xfdb7; break;
 case 0x2d: code = 0xfdb8; break;
 case 0x2e: code = 0xfdb9; break;
 case 0x2f: code = 0xfdba; break;
 case 0x30: code = 0xfdbb; break;
 case 0x31: code = 0xfdbc; break;
 case 0x32: code = 0xfdbd; break;
 case 0x33: code = 0xfdbe; break;
 case 0x34: code = 0xfdbf; break;
 case 0x35: code = 0xfdc0; break;
 case 0x36: code = 0xfdc1; break;
 case 0x37: code = 0xfdc2; break;
 case 0x38: code = 0xfdc3; break;
 case 0x39: code = 0xfdc4; break;
 case 0x3a: code = 0xfdc5; break;
 case 0x3b: code = 0xfdc6; break;
 case 0x3c: code = 0xfdc7; break;
 case 0x3d: code = 0xfdc8; break;
 case 0x3e: code = 0xfdc9; break;
 case 0x3f: code = 0xfdca; break;
 case 0x40: code = 0xfdcb; break;
 case 0x41: code = 0xfdcc; break;
 case 0x42: code = 0xfdcd; break;
 case 0x43: code = 0xfdce; break;
 case 0x44: code = 0xfdcf; break;
 case 0x45: code = 0xfdd0; break;
 case 0x46: code = 0xfdd1; break;
 case 0x47: code = 0xfdd2; break;
 case 0x48: code = 0xfdd3; break;
 case 0x49: code = 0xfdd4; break;
 case 0x4a: code = 0xfdd5; break;
 case 0x4b: code = 0xfdd6; break;
 case 0x4c: code = 0xfdd7; break;
 case 0x4d: code = 0xfdd8; break;
 case 0x4e: code = 0xfdd9; break;
 case 0x4f: code = 0xfdda; break;
 case 0x50: code = 0xfddb; break;
 case 0x51: code = 0xfddc; break;
 case 0x52: code = 0xfddd; break;
 case 0x53: code = 0xfdde; break;
 case 0x54: code = 0xfddf; break;
 case 0x55: code = 0xfde0; break;
 case 0x56: code = 0xfde1; break;
 case 0x57: code = 0xfde2; break;
 case 0x58: code = 0xfde3; break;
 case 0x59: code = 0xfde4; break;
 case 0x5a: code = 0xfde5; break;
 case 0x5b: code = 0xfde6; break;
 case 0x5c: code = 0xfde7; break;
 case 0x5d: code = 0xfde8; break;
 case 0x5e: code = 0xfde9; break;
 case 0x5f: code = 0xfdea; break;
 case 0x60: code = 0xfdeb; break;
 case 0x61: code = 0xfdec; break;
 case 0x62: code = 0xfded; break;
 case 0x63: code = 0xfdee; break;
 case 0x64: code = 0xfdef; break;
 case 0x65: code = 0xfdf0; break;
 case 0x66: code = 0xfdf1; break;
 case 0x67: code = 0xfdf2; break;
 case 0x68: code = 0xfdf3; break;
 case 0x69: code = 0xfdf4; break;
 case 0x6a: code = 0xfdf5; break;
 case 0x6b: code = 0xfdf6; break;
 case 0x6c: code = 0xfdf7; break;
 case 0x6d: code = 0xfdf8; break;
 case 0x6e: code = 0xfdf9; break;
 case 0x6f: code = 0xfdfa; break;
 case 0x70: code = 0xfdfb; break;
 case 0x71: code = 0xfdfc; break;
 case 0x72: code = 0xfdfd; break;
 case 0x73: code = 0xfdfe; break;
 case 0x74: code = 0xfe40; break;
 case 0x75: code = 0xfe41; break;
 case 0x76: code = 0xfe42; break;
 case 0x77: code = 0xfe43; break;
 case 0x78: code = 0xfe44; break;
 case 0x79: code = 0xfe45; break;
 case 0x7a: code = 0xfe46; break;
 case 0x7b: code = 0xfe47; break;
 case 0x7c: code = 0xfe48; break;
 case 0x7d: code = 0xfe49; break;
 case 0x7e: code = 0xfe4a; break;
 case 0x7f: code = 0xfe4b; break;
 case 0x80: code = 0xfe4c; break;
 case 0x81: code = 0xfe4d; break;
 case 0x82: code = 0xfe4e; break;
 case 0x83: code = 0xfe4f; break;
 case 0x84: code = 0xfe50; break;
 case 0x85: code = 0xfe51; break;
 case 0x86: code = 0xfe52; break;
 case 0x87: code = 0xfe53; break;
 case 0x88: code = 0xfe54; break;
 case 0x89: code = 0xfe55; break;
 case 0x8a: code = 0xfe56; break;
 case 0x8b: code = 0xfe57; break;
 case 0x8c: code = 0xfe58; break;
 case 0x8d: code = 0xfe59; break;
 case 0x8e: code = 0xfe5a; break;
 case 0x8f: code = 0xfe5b; break;
 case 0x90: code = 0xfe5c; break;
 case 0x91: code = 0xfe5d; break;
 case 0x92: code = 0xfe5e; break;
 case 0x93: code = 0xfe5f; break;
 case 0x94: code = 0xfe60; break;
 case 0x95: code = 0xfe61; break;
 case 0x96: code = 0xfe62; break;
 case 0x97: code = 0xfe63; break;
 case 0x98: code = 0xfe64; break;
 case 0x99: code = 0xfe65; break;
 case 0x9a: code = 0xfe66; break;
 case 0x9b: code = 0xfe67; break;
 case 0x9c: code = 0xfe68; break;
 case 0x9d: code = 0xfe69; break;
 case 0x9e: code = 0xfe6a; break;
 case 0x9f: code = 0xfe6b; break;
 case 0xa0: code = 0xfe6c; break;
 case 0xa1: code = 0xfe6d; break;
 case 0xa2: code = 0xfe6e; break;
 case 0xa3: code = 0xfe6f; break;
 case 0xa4: code = 0xfe70; break;
 case 0xa5: code = 0xfe71; break;
 case 0xa6: code = 0xfe72; break;
 case 0xa7: code = 0xfe73; break;
 case 0xa8: code = 0xfe74; break;
 case 0xa9: code = 0xfe75; break;
 case 0xaa: code = 0xfe76; break;
 case 0xab: code = 0xfe77; break;
 case 0xac: code = 0xfe78; break;
 case 0xad: code = 0xfe79; break;
 case 0xae: code = 0xfe7a; break;
 case 0xaf: code = 0xfe7b; break;
 case 0xb0: code = 0xfe7c; break;
 case 0xb1: code = 0xfe7d; break;
 case 0xb2: code = 0xfe7e; break;
 case 0xb3: code = 0xfea1; break;
 case 0xb4: code = 0xfea2; break;
 case 0xb5: code = 0xfea3; break;
 case 0xb6: code = 0xfea4; break;
 case 0xb7: code = 0xfea5; break;
 case 0xb8: code = 0xfea6; break;
 case 0xb9: code = 0xfea7; break;
 case 0xba: code = 0xfea8; break;
 case 0xbb: code = 0xfea9; break;
 case 0xbc: code = 0xfeaa; break;
 case 0xbd: code = 0xfeab; break;
 case 0xbe: code = 0xfeac; break;
 case 0xbf: code = 0xfead; break;
 case 0xc0: code = 0xfeae; break;
 case 0xc1: code = 0xfeaf; break;
 case 0xc2: code = 0xfeb0; break;
 case 0xc3: code = 0xfeb1; break;
 case 0xc4: code = 0xfeb2; break;
 case 0xc5: code = 0xfeb3; break;
 case 0xc6: code = 0xfeb4; break;
 case 0xc7: code = 0xfeb5; break;
 case 0xc8: code = 0xfeb6; break;
 case 0xc9: code = 0xfeb7; break;
 case 0xca: code = 0xfeb8; break;
 case 0xcb: code = 0xfeb9; break;
 case 0xcc: code = 0xfeba; break;
 case 0xcd: code = 0xfebb; break;
 case 0xce: code = 0xfebc; break;
 case 0xcf: code = 0xfebd; break;
 case 0xd0: code = 0xfebe; break;
 case 0xd1: code = 0xfebf; break;
 case 0xd2: code = 0xfec0; break;
 case 0xd3: code = 0xfec1; break;
 case 0xd4: code = 0xfec2; break;
 case 0xd5: code = 0xfec3; break;
 case 0xd6: code = 0xfec4; break;
 case 0xd7: code = 0xfec5; break;
 case 0xd8: code = 0xfec6; break;
 case 0xd9: code = 0xfec7; break;
 case 0xda: code = 0xfec8; break;
 case 0xdb: code = 0xfec9; break;
 case 0xdc: code = 0xfeca; break;
 case 0xdd: code = 0xfecb; break;
 case 0xde: code = 0xfecc; break;
 case 0xdf: code = 0xfecd; break;
 case 0xe0: code = 0xfece; break;
 case 0xe1: code = 0xfecf; break;
 case 0xe2: code = 0xfed0; break;
 case 0xe3: code = 0xfed1; break;
 case 0xe4: code = 0xfed2; break;
 case 0xe5: code = 0xfed3; break;
 case 0xe6: code = 0xfed4; break;
 case 0xe7: code = 0xfed5; break;
 case 0xe8: code = 0xfed6; break;
 case 0xe9: code = 0xfed7; break;
 case 0xea: code = 0xfed8; break;
 case 0xeb: code = 0xfed9; break;
 case 0xec: code = 0xfeda; break;
 case 0xed: code = 0xfedb; break;
 case 0xee: code = 0xfedc; break;
 case 0xef: code = 0xfedd; break;
 case 0xf0: code = 0xfede; break;
 case 0xf1: code = 0xfedf; break;
 case 0xf2: code = 0xfee0; break;
 case 0xf3: code = 0xfee1; break;
 case 0xf4: code = 0xfee2; break;
 case 0xf5: code = 0xfee3; break;
 case 0xf6: code = 0xfee4; break;
 case 0xf7: code = 0xfee5; break;
 case 0xf8: code = 0xfee6; break;
 case 0xf9: code = 0xfee7; break;
 case 0xfa: code = 0xfee8; break;
 case 0xfb: code = 0xfee9; break;
 case 0xfc: code = 0xfeea; break;
 case 0xfd: code = 0xfeeb; break;
 case 0xfe: code = 0xfeec; break;
 case 0xff: code = 0xfeed; break;
    }
    break;
  case 0xe3: switch(c1) {
 case 0x00: code = 0xfeee; break;
 case 0x01: code = 0xfeef; break;
 case 0x02: code = 0xfef0; break;
 case 0x03: code = 0xfef1; break;
 case 0x04: code = 0xfef2; break;
 case 0x05: code = 0xfef3; break;
 case 0x06: code = 0xfef4; break;
 case 0x07: code = 0xfef5; break;
 case 0x08: code = 0xfef6; break;
 case 0x09: code = 0xfef7; break;
 case 0x0a: code = 0xfef8; break;
 case 0x0b: code = 0xfef9; break;
 case 0x0c: code = 0xfefa; break;
 case 0x0d: code = 0xfefb; break;
 case 0x0e: code = 0xfefc; break;
 case 0x0f: code = 0xfefd; break;
 case 0x10: code = 0xfefe; break;
 case 0x11: code = 0x8e40; break;
 case 0x12: code = 0x8e41; break;
 case 0x13: code = 0x8e42; break;
 case 0x14: code = 0x8e43; break;
 case 0x15: code = 0x8e44; break;
 case 0x16: code = 0x8e45; break;
 case 0x17: code = 0x8e46; break;
 case 0x18: code = 0x8e47; break;
 case 0x19: code = 0x8e48; break;
 case 0x1a: code = 0x8e49; break;
 case 0x1b: code = 0x8e4a; break;
 case 0x1c: code = 0x8e4b; break;
 case 0x1d: code = 0x8e4c; break;
 case 0x1e: code = 0x8e4d; break;
 case 0x1f: code = 0x8e4e; break;
 case 0x20: code = 0x8e4f; break;
 case 0x21: code = 0x8e50; break;
 case 0x22: code = 0x8e51; break;
 case 0x23: code = 0x8e52; break;
 case 0x24: code = 0x8e53; break;
 case 0x25: code = 0x8e54; break;
 case 0x26: code = 0x8e55; break;
 case 0x27: code = 0x8e56; break;
 case 0x28: code = 0x8e57; break;
 case 0x29: code = 0x8e58; break;
 case 0x2a: code = 0x8e59; break;
 case 0x2b: code = 0x8e5a; break;
 case 0x2c: code = 0x8e5b; break;
 case 0x2d: code = 0x8e5c; break;
 case 0x2e: code = 0x8e5d; break;
 case 0x2f: code = 0x8e5e; break;
 case 0x30: code = 0x8e5f; break;
 case 0x31: code = 0x8e60; break;
 case 0x32: code = 0x8e61; break;
 case 0x33: code = 0x8e62; break;
 case 0x34: code = 0x8e63; break;
 case 0x35: code = 0x8e64; break;
 case 0x36: code = 0x8e65; break;
 case 0x37: code = 0x8e66; break;
 case 0x38: code = 0x8e67; break;
 case 0x39: code = 0x8e68; break;
 case 0x3a: code = 0x8e69; break;
 case 0x3b: code = 0x8e6a; break;
 case 0x3c: code = 0x8e6b; break;
 case 0x3d: code = 0x8e6c; break;
 case 0x3e: code = 0x8e6d; break;
 case 0x3f: code = 0x8e6e; break;
 case 0x40: code = 0x8e6f; break;
 case 0x41: code = 0x8e70; break;
 case 0x42: code = 0x8e71; break;
 case 0x43: code = 0x8e72; break;
 case 0x44: code = 0x8e73; break;
 case 0x45: code = 0x8e74; break;
 case 0x46: code = 0x8e75; break;
 case 0x47: code = 0x8e76; break;
 case 0x48: code = 0x8e77; break;
 case 0x49: code = 0x8e78; break;
 case 0x4a: code = 0x8e79; break;
 case 0x4b: code = 0x8e7a; break;
 case 0x4c: code = 0x8e7b; break;
 case 0x4d: code = 0x8e7c; break;
 case 0x4e: code = 0x8e7d; break;
 case 0x4f: code = 0x8e7e; break;
 case 0x50: code = 0x8ea1; break;
 case 0x51: code = 0x8ea2; break;
 case 0x52: code = 0x8ea3; break;
 case 0x53: code = 0x8ea4; break;
 case 0x54: code = 0x8ea5; break;
 case 0x55: code = 0x8ea6; break;
 case 0x56: code = 0x8ea7; break;
 case 0x57: code = 0x8ea8; break;
 case 0x58: code = 0x8ea9; break;
 case 0x59: code = 0x8eaa; break;
 case 0x5a: code = 0x8eab; break;
 case 0x5b: code = 0x8eac; break;
 case 0x5c: code = 0x8ead; break;
 case 0x5d: code = 0x8eae; break;
 case 0x5e: code = 0x8eaf; break;
 case 0x5f: code = 0x8eb0; break;
 case 0x60: code = 0x8eb1; break;
 case 0x61: code = 0x8eb2; break;
 case 0x62: code = 0x8eb3; break;
 case 0x63: code = 0x8eb4; break;
 case 0x64: code = 0x8eb5; break;
 case 0x65: code = 0x8eb6; break;
 case 0x66: code = 0x8eb7; break;
 case 0x67: code = 0x8eb8; break;
 case 0x68: code = 0x8eb9; break;
 case 0x69: code = 0x8eba; break;
 case 0x6a: code = 0x8ebb; break;
 case 0x6b: code = 0x8ebc; break;
 case 0x6c: code = 0x8ebd; break;
 case 0x6d: code = 0x8ebe; break;
 case 0x6e: code = 0x8ebf; break;
 case 0x6f: code = 0x8ec0; break;
 case 0x70: code = 0x8ec1; break;
 case 0x71: code = 0x8ec2; break;
 case 0x72: code = 0x8ec3; break;
 case 0x73: code = 0x8ec4; break;
 case 0x74: code = 0x8ec5; break;
 case 0x75: code = 0x8ec6; break;
 case 0x76: code = 0x8ec7; break;
 case 0x77: code = 0x8ec8; break;
 case 0x78: code = 0x8ec9; break;
 case 0x79: code = 0x8eca; break;
 case 0x7a: code = 0x8ecb; break;
 case 0x7b: code = 0x8ecc; break;
 case 0x7c: code = 0x8ecd; break;
 case 0x7d: code = 0x8ece; break;
 case 0x7e: code = 0x8ecf; break;
 case 0x7f: code = 0x8ed0; break;
 case 0x80: code = 0x8ed1; break;
 case 0x81: code = 0x8ed2; break;
 case 0x82: code = 0x8ed3; break;
 case 0x83: code = 0x8ed4; break;
 case 0x84: code = 0x8ed5; break;
 case 0x85: code = 0x8ed6; break;
 case 0x86: code = 0x8ed7; break;
 case 0x87: code = 0x8ed8; break;
 case 0x88: code = 0x8ed9; break;
 case 0x89: code = 0x8eda; break;
 case 0x8a: code = 0x8edb; break;
 case 0x8b: code = 0x8edc; break;
 case 0x8c: code = 0x8edd; break;
 case 0x8d: code = 0x8ede; break;
 case 0x8e: code = 0x8edf; break;
 case 0x8f: code = 0x8ee0; break;
 case 0x90: code = 0x8ee1; break;
 case 0x91: code = 0x8ee2; break;
 case 0x92: code = 0x8ee3; break;
 case 0x93: code = 0x8ee4; break;
 case 0x94: code = 0x8ee5; break;
 case 0x95: code = 0x8ee6; break;
 case 0x96: code = 0x8ee7; break;
 case 0x97: code = 0x8ee8; break;
 case 0x98: code = 0x8ee9; break;
 case 0x99: code = 0x8eea; break;
 case 0x9a: code = 0x8eeb; break;
 case 0x9b: code = 0x8eec; break;
 case 0x9c: code = 0x8eed; break;
 case 0x9d: code = 0x8eee; break;
 case 0x9e: code = 0x8eef; break;
 case 0x9f: code = 0x8ef0; break;
 case 0xa0: code = 0x8ef1; break;
 case 0xa1: code = 0x8ef2; break;
 case 0xa2: code = 0x8ef3; break;
 case 0xa3: code = 0x8ef4; break;
 case 0xa4: code = 0x8ef5; break;
 case 0xa5: code = 0x8ef6; break;
 case 0xa6: code = 0x8ef7; break;
 case 0xa7: code = 0x8ef8; break;
 case 0xa8: code = 0x8ef9; break;
 case 0xa9: code = 0x8efa; break;
 case 0xaa: code = 0x8efb; break;
 case 0xab: code = 0x8efc; break;
 case 0xac: code = 0x8efd; break;
 case 0xad: code = 0x8efe; break;
 case 0xae: code = 0x8f40; break;
 case 0xaf: code = 0x8f41; break;
 case 0xb0: code = 0x8f42; break;
 case 0xb1: code = 0x8f43; break;
 case 0xb2: code = 0x8f44; break;
 case 0xb3: code = 0x8f45; break;
 case 0xb4: code = 0x8f46; break;
 case 0xb5: code = 0x8f47; break;
 case 0xb6: code = 0x8f48; break;
 case 0xb7: code = 0x8f49; break;
 case 0xb8: code = 0x8f4a; break;
 case 0xb9: code = 0x8f4b; break;
 case 0xba: code = 0x8f4c; break;
 case 0xbb: code = 0x8f4d; break;
 case 0xbc: code = 0x8f4e; break;
 case 0xbd: code = 0x8f4f; break;
 case 0xbe: code = 0x8f50; break;
 case 0xbf: code = 0x8f51; break;
 case 0xc0: code = 0x8f52; break;
 case 0xc1: code = 0x8f53; break;
 case 0xc2: code = 0x8f54; break;
 case 0xc3: code = 0x8f55; break;
 case 0xc4: code = 0x8f56; break;
 case 0xc5: code = 0x8f57; break;
 case 0xc6: code = 0x8f58; break;
 case 0xc7: code = 0x8f59; break;
 case 0xc8: code = 0x8f5a; break;
 case 0xc9: code = 0x8f5b; break;
 case 0xca: code = 0x8f5c; break;
 case 0xcb: code = 0x8f5d; break;
 case 0xcc: code = 0x8f5e; break;
 case 0xcd: code = 0x8f5f; break;
 case 0xce: code = 0x8f60; break;
 case 0xcf: code = 0x8f61; break;
 case 0xd0: code = 0x8f62; break;
 case 0xd1: code = 0x8f63; break;
 case 0xd2: code = 0x8f64; break;
 case 0xd3: code = 0x8f65; break;
 case 0xd4: code = 0x8f66; break;
 case 0xd5: code = 0x8f67; break;
 case 0xd6: code = 0x8f68; break;
 case 0xd7: code = 0x8f69; break;
 case 0xd8: code = 0x8f6a; break;
 case 0xd9: code = 0x8f6b; break;
 case 0xda: code = 0x8f6c; break;
 case 0xdb: code = 0x8f6d; break;
 case 0xdc: code = 0x8f6e; break;
 case 0xdd: code = 0x8f6f; break;
 case 0xde: code = 0x8f70; break;
 case 0xdf: code = 0x8f71; break;
 case 0xe0: code = 0x8f72; break;
 case 0xe1: code = 0x8f73; break;
 case 0xe2: code = 0x8f74; break;
 case 0xe3: code = 0x8f75; break;
 case 0xe4: code = 0x8f76; break;
 case 0xe5: code = 0x8f77; break;
 case 0xe6: code = 0x8f78; break;
 case 0xe7: code = 0x8f79; break;
 case 0xe8: code = 0x8f7a; break;
 case 0xe9: code = 0x8f7b; break;
 case 0xea: code = 0x8f7c; break;
 case 0xeb: code = 0x8f7d; break;
 case 0xec: code = 0x8f7e; break;
 case 0xed: code = 0x8fa1; break;
 case 0xee: code = 0x8fa2; break;
 case 0xef: code = 0x8fa3; break;
 case 0xf0: code = 0x8fa4; break;
 case 0xf1: code = 0x8fa5; break;
 case 0xf2: code = 0x8fa6; break;
 case 0xf3: code = 0x8fa7; break;
 case 0xf4: code = 0x8fa8; break;
 case 0xf5: code = 0x8fa9; break;
 case 0xf6: code = 0x8faa; break;
 case 0xf7: code = 0x8fab; break;
 case 0xf8: code = 0x8fac; break;
 case 0xf9: code = 0x8fad; break;
 case 0xfa: code = 0x8fae; break;
 case 0xfb: code = 0x8faf; break;
 case 0xfc: code = 0x8fb0; break;
 case 0xfd: code = 0x8fb1; break;
 case 0xfe: code = 0x8fb2; break;
 case 0xff: code = 0x8fb3; break;
    }
    break;
  case 0xe4: switch(c1) {
 case 0x00: code = 0x8fb4; break;
 case 0x01: code = 0x8fb5; break;
 case 0x02: code = 0x8fb6; break;
 case 0x03: code = 0x8fb7; break;
 case 0x04: code = 0x8fb8; break;
 case 0x05: code = 0x8fb9; break;
 case 0x06: code = 0x8fba; break;
 case 0x07: code = 0x8fbb; break;
 case 0x08: code = 0x8fbc; break;
 case 0x09: code = 0x8fbd; break;
 case 0x0a: code = 0x8fbe; break;
 case 0x0b: code = 0x8fbf; break;
 case 0x0c: code = 0x8fc0; break;
 case 0x0d: code = 0x8fc1; break;
 case 0x0e: code = 0x8fc2; break;
 case 0x0f: code = 0x8fc3; break;
 case 0x10: code = 0x8fc4; break;
 case 0x11: code = 0x8fc5; break;
 case 0x12: code = 0x8fc6; break;
 case 0x13: code = 0x8fc7; break;
 case 0x14: code = 0x8fc8; break;
 case 0x15: code = 0x8fc9; break;
 case 0x16: code = 0x8fca; break;
 case 0x17: code = 0x8fcb; break;
 case 0x18: code = 0x8fcc; break;
 case 0x19: code = 0x8fcd; break;
 case 0x1a: code = 0x8fce; break;
 case 0x1b: code = 0x8fcf; break;
 case 0x1c: code = 0x8fd0; break;
 case 0x1d: code = 0x8fd1; break;
 case 0x1e: code = 0x8fd2; break;
 case 0x1f: code = 0x8fd3; break;
 case 0x20: code = 0x8fd4; break;
 case 0x21: code = 0x8fd5; break;
 case 0x22: code = 0x8fd6; break;
 case 0x23: code = 0x8fd7; break;
 case 0x24: code = 0x8fd8; break;
 case 0x25: code = 0x8fd9; break;
 case 0x26: code = 0x8fda; break;
 case 0x27: code = 0x8fdb; break;
 case 0x28: code = 0x8fdc; break;
 case 0x29: code = 0x8fdd; break;
 case 0x2a: code = 0x8fde; break;
 case 0x2b: code = 0x8fdf; break;
 case 0x2c: code = 0x8fe0; break;
 case 0x2d: code = 0x8fe1; break;
 case 0x2e: code = 0x8fe2; break;
 case 0x2f: code = 0x8fe3; break;
 case 0x30: code = 0x8fe4; break;
 case 0x31: code = 0x8fe5; break;
 case 0x32: code = 0x8fe6; break;
 case 0x33: code = 0x8fe7; break;
 case 0x34: code = 0x8fe8; break;
 case 0x35: code = 0x8fe9; break;
 case 0x36: code = 0x8fea; break;
 case 0x37: code = 0x8feb; break;
 case 0x38: code = 0x8fec; break;
 case 0x39: code = 0x8fed; break;
 case 0x3a: code = 0x8fee; break;
 case 0x3b: code = 0x8fef; break;
 case 0x3c: code = 0x8ff0; break;
 case 0x3d: code = 0x8ff1; break;
 case 0x3e: code = 0x8ff2; break;
 case 0x3f: code = 0x8ff3; break;
 case 0x40: code = 0x8ff4; break;
 case 0x41: code = 0x8ff5; break;
 case 0x42: code = 0x8ff6; break;
 case 0x43: code = 0x8ff7; break;
 case 0x44: code = 0x8ff8; break;
 case 0x45: code = 0x8ff9; break;
 case 0x46: code = 0x8ffa; break;
 case 0x47: code = 0x8ffb; break;
 case 0x48: code = 0x8ffc; break;
 case 0x49: code = 0x8ffd; break;
 case 0x4a: code = 0x8ffe; break;
 case 0x4b: code = 0x9040; break;
 case 0x4c: code = 0x9041; break;
 case 0x4d: code = 0x9042; break;
 case 0x4e: code = 0x9043; break;
 case 0x4f: code = 0x9044; break;
 case 0x50: code = 0x9045; break;
 case 0x51: code = 0x9046; break;
 case 0x52: code = 0x9047; break;
 case 0x53: code = 0x9048; break;
 case 0x54: code = 0x9049; break;
 case 0x55: code = 0x904a; break;
 case 0x56: code = 0x904b; break;
 case 0x57: code = 0x904c; break;
 case 0x58: code = 0x904d; break;
 case 0x59: code = 0x904e; break;
 case 0x5a: code = 0x904f; break;
 case 0x5b: code = 0x9050; break;
 case 0x5c: code = 0x9051; break;
 case 0x5d: code = 0x9052; break;
 case 0x5e: code = 0x9053; break;
 case 0x5f: code = 0x9054; break;
 case 0x60: code = 0x9055; break;
 case 0x61: code = 0x9056; break;
 case 0x62: code = 0x9057; break;
 case 0x63: code = 0x9058; break;
 case 0x64: code = 0x9059; break;
 case 0x65: code = 0x905a; break;
 case 0x66: code = 0x905b; break;
 case 0x67: code = 0x905c; break;
 case 0x68: code = 0x905d; break;
 case 0x69: code = 0x905e; break;
 case 0x6a: code = 0x905f; break;
 case 0x6b: code = 0x9060; break;
 case 0x6c: code = 0x9061; break;
 case 0x6d: code = 0x9062; break;
 case 0x6e: code = 0x9063; break;
 case 0x6f: code = 0x9064; break;
 case 0x70: code = 0x9065; break;
 case 0x71: code = 0x9066; break;
 case 0x72: code = 0x9067; break;
 case 0x73: code = 0x9068; break;
 case 0x74: code = 0x9069; break;
 case 0x75: code = 0x906a; break;
 case 0x76: code = 0x906b; break;
 case 0x77: code = 0x906c; break;
 case 0x78: code = 0x906d; break;
 case 0x79: code = 0x906e; break;
 case 0x7a: code = 0x906f; break;
 case 0x7b: code = 0x9070; break;
 case 0x7c: code = 0x9071; break;
 case 0x7d: code = 0x9072; break;
 case 0x7e: code = 0x9073; break;
 case 0x7f: code = 0x9074; break;
 case 0x80: code = 0x9075; break;
 case 0x81: code = 0x9076; break;
 case 0x82: code = 0x9077; break;
 case 0x83: code = 0x9078; break;
 case 0x84: code = 0x9079; break;
 case 0x85: code = 0x907a; break;
 case 0x86: code = 0x907b; break;
 case 0x87: code = 0x907c; break;
 case 0x88: code = 0x907d; break;
 case 0x89: code = 0x907e; break;
 case 0x8a: code = 0x90a1; break;
 case 0x8b: code = 0x90a2; break;
 case 0x8c: code = 0x90a3; break;
 case 0x8d: code = 0x90a4; break;
 case 0x8e: code = 0x90a5; break;
 case 0x8f: code = 0x90a6; break;
 case 0x90: code = 0x90a7; break;
 case 0x91: code = 0x90a8; break;
 case 0x92: code = 0x90a9; break;
 case 0x93: code = 0x90aa; break;
 case 0x94: code = 0x90ab; break;
 case 0x95: code = 0x90ac; break;
 case 0x96: code = 0x90ad; break;
 case 0x97: code = 0x90ae; break;
 case 0x98: code = 0x90af; break;
 case 0x99: code = 0x90b0; break;
 case 0x9a: code = 0x90b1; break;
 case 0x9b: code = 0x90b2; break;
 case 0x9c: code = 0x90b3; break;
 case 0x9d: code = 0x90b4; break;
 case 0x9e: code = 0x90b5; break;
 case 0x9f: code = 0x90b6; break;
 case 0xa0: code = 0x90b7; break;
 case 0xa1: code = 0x90b8; break;
 case 0xa2: code = 0x90b9; break;
 case 0xa3: code = 0x90ba; break;
 case 0xa4: code = 0x90bb; break;
 case 0xa5: code = 0x90bc; break;
 case 0xa6: code = 0x90bd; break;
 case 0xa7: code = 0x90be; break;
 case 0xa8: code = 0x90bf; break;
 case 0xa9: code = 0x90c0; break;
 case 0xaa: code = 0x90c1; break;
 case 0xab: code = 0x90c2; break;
 case 0xac: code = 0x90c3; break;
 case 0xad: code = 0x90c4; break;
 case 0xae: code = 0x90c5; break;
 case 0xaf: code = 0x90c6; break;
 case 0xb0: code = 0x90c7; break;
 case 0xb1: code = 0x90c8; break;
 case 0xb2: code = 0x90c9; break;
 case 0xb3: code = 0x90ca; break;
 case 0xb4: code = 0x90cb; break;
 case 0xb5: code = 0x90cc; break;
 case 0xb6: code = 0x90cd; break;
 case 0xb7: code = 0x90ce; break;
 case 0xb8: code = 0x90cf; break;
 case 0xb9: code = 0x90d0; break;
 case 0xba: code = 0x90d1; break;
 case 0xbb: code = 0x90d2; break;
 case 0xbc: code = 0x90d3; break;
 case 0xbd: code = 0x90d4; break;
 case 0xbe: code = 0x90d5; break;
 case 0xbf: code = 0x90d6; break;
 case 0xc0: code = 0x90d7; break;
 case 0xc1: code = 0x90d8; break;
 case 0xc2: code = 0x90d9; break;
 case 0xc3: code = 0x90da; break;
 case 0xc4: code = 0x90db; break;
 case 0xc5: code = 0x90dc; break;
 case 0xc6: code = 0x90dd; break;
 case 0xc7: code = 0x90de; break;
 case 0xc8: code = 0x90df; break;
 case 0xc9: code = 0x90e0; break;
 case 0xca: code = 0x90e1; break;
 case 0xcb: code = 0x90e2; break;
 case 0xcc: code = 0x90e3; break;
 case 0xcd: code = 0x90e4; break;
 case 0xce: code = 0x90e5; break;
 case 0xcf: code = 0x90e6; break;
 case 0xd0: code = 0x90e7; break;
 case 0xd1: code = 0x90e8; break;
 case 0xd2: code = 0x90e9; break;
 case 0xd3: code = 0x90ea; break;
 case 0xd4: code = 0x90eb; break;
 case 0xd5: code = 0x90ec; break;
 case 0xd6: code = 0x90ed; break;
 case 0xd7: code = 0x90ee; break;
 case 0xd8: code = 0x90ef; break;
 case 0xd9: code = 0x90f0; break;
 case 0xda: code = 0x90f1; break;
 case 0xdb: code = 0x90f2; break;
 case 0xdc: code = 0x90f3; break;
 case 0xdd: code = 0x90f4; break;
 case 0xde: code = 0x90f5; break;
 case 0xdf: code = 0x90f6; break;
 case 0xe0: code = 0x90f7; break;
 case 0xe1: code = 0x90f8; break;
 case 0xe2: code = 0x90f9; break;
 case 0xe3: code = 0x90fa; break;
 case 0xe4: code = 0x90fb; break;
 case 0xe5: code = 0x90fc; break;
 case 0xe6: code = 0x90fd; break;
 case 0xe7: code = 0x90fe; break;
 case 0xe8: code = 0x9140; break;
 case 0xe9: code = 0x9141; break;
 case 0xea: code = 0x9142; break;
 case 0xeb: code = 0x9143; break;
 case 0xec: code = 0x9144; break;
 case 0xed: code = 0x9145; break;
 case 0xee: code = 0x9146; break;
 case 0xef: code = 0x9147; break;
 case 0xf0: code = 0x9148; break;
 case 0xf1: code = 0x9149; break;
 case 0xf2: code = 0x914a; break;
 case 0xf3: code = 0x914b; break;
 case 0xf4: code = 0x914c; break;
 case 0xf5: code = 0x914d; break;
 case 0xf6: code = 0x914e; break;
 case 0xf7: code = 0x914f; break;
 case 0xf8: code = 0x9150; break;
 case 0xf9: code = 0x9151; break;
 case 0xfa: code = 0x9152; break;
 case 0xfb: code = 0x9153; break;
 case 0xfc: code = 0x9154; break;
 case 0xfd: code = 0x9155; break;
 case 0xfe: code = 0x9156; break;
 case 0xff: code = 0x9157; break;
    }
    break;
  case 0xe5: switch(c1) {
 case 0x00: code = 0x9158; break;
 case 0x01: code = 0x9159; break;
 case 0x02: code = 0x915a; break;
 case 0x03: code = 0x915b; break;
 case 0x04: code = 0x915c; break;
 case 0x05: code = 0x915d; break;
 case 0x06: code = 0x915e; break;
 case 0x07: code = 0x915f; break;
 case 0x08: code = 0x9160; break;
 case 0x09: code = 0x9161; break;
 case 0x0a: code = 0x9162; break;
 case 0x0b: code = 0x9163; break;
 case 0x0c: code = 0x9164; break;
 case 0x0d: code = 0x9165; break;
 case 0x0e: code = 0x9166; break;
 case 0x0f: code = 0x9167; break;
 case 0x10: code = 0x9168; break;
 case 0x11: code = 0x9169; break;
 case 0x12: code = 0x916a; break;
 case 0x13: code = 0x916b; break;
 case 0x14: code = 0x916c; break;
 case 0x15: code = 0x916d; break;
 case 0x16: code = 0x916e; break;
 case 0x17: code = 0x916f; break;
 case 0x18: code = 0x9170; break;
 case 0x19: code = 0x9171; break;
 case 0x1a: code = 0x9172; break;
 case 0x1b: code = 0x9173; break;
 case 0x1c: code = 0x9174; break;
 case 0x1d: code = 0x9175; break;
 case 0x1e: code = 0x9176; break;
 case 0x1f: code = 0x9177; break;
 case 0x20: code = 0x9178; break;
 case 0x21: code = 0x9179; break;
 case 0x22: code = 0x917a; break;
 case 0x23: code = 0x917b; break;
 case 0x24: code = 0x917c; break;
 case 0x25: code = 0x917d; break;
 case 0x26: code = 0x917e; break;
 case 0x27: code = 0x91a1; break;
 case 0x28: code = 0x91a2; break;
 case 0x29: code = 0x91a3; break;
 case 0x2a: code = 0x91a4; break;
 case 0x2b: code = 0x91a5; break;
 case 0x2c: code = 0x91a6; break;
 case 0x2d: code = 0x91a7; break;
 case 0x2e: code = 0x91a8; break;
 case 0x2f: code = 0x91a9; break;
 case 0x30: code = 0x91aa; break;
 case 0x31: code = 0x91ab; break;
 case 0x32: code = 0x91ac; break;
 case 0x33: code = 0x91ad; break;
 case 0x34: code = 0x91ae; break;
 case 0x35: code = 0x91af; break;
 case 0x36: code = 0x91b0; break;
 case 0x37: code = 0x91b1; break;
 case 0x38: code = 0x91b2; break;
 case 0x39: code = 0x91b3; break;
 case 0x3a: code = 0x91b4; break;
 case 0x3b: code = 0x91b5; break;
 case 0x3c: code = 0x91b6; break;
 case 0x3d: code = 0x91b7; break;
 case 0x3e: code = 0x91b8; break;
 case 0x3f: code = 0x91b9; break;
 case 0x40: code = 0x91ba; break;
 case 0x41: code = 0x91bb; break;
 case 0x42: code = 0x91bc; break;
 case 0x43: code = 0x91bd; break;
 case 0x44: code = 0x91be; break;
 case 0x45: code = 0x91bf; break;
 case 0x46: code = 0x91c0; break;
 case 0x47: code = 0x91c1; break;
 case 0x48: code = 0x91c2; break;
 case 0x49: code = 0x91c3; break;
 case 0x4a: code = 0x91c4; break;
 case 0x4b: code = 0x91c5; break;
 case 0x4c: code = 0x91c6; break;
 case 0x4d: code = 0x91c7; break;
 case 0x4e: code = 0x91c8; break;
 case 0x4f: code = 0x91c9; break;
 case 0x50: code = 0x91ca; break;
 case 0x51: code = 0x91cb; break;
 case 0x52: code = 0x91cc; break;
 case 0x53: code = 0x91cd; break;
 case 0x54: code = 0x91ce; break;
 case 0x55: code = 0x91cf; break;
 case 0x56: code = 0x91d0; break;
 case 0x57: code = 0x91d1; break;
 case 0x58: code = 0x91d2; break;
 case 0x59: code = 0x91d3; break;
 case 0x5a: code = 0x91d4; break;
 case 0x5b: code = 0x91d5; break;
 case 0x5c: code = 0x91d6; break;
 case 0x5d: code = 0x91d7; break;
 case 0x5e: code = 0x91d8; break;
 case 0x5f: code = 0x91d9; break;
 case 0x60: code = 0x91da; break;
 case 0x61: code = 0x91db; break;
 case 0x62: code = 0x91dc; break;
 case 0x63: code = 0x91dd; break;
 case 0x64: code = 0x91de; break;
 case 0x65: code = 0x91df; break;
 case 0x66: code = 0x91e0; break;
 case 0x67: code = 0x91e1; break;
 case 0x68: code = 0x91e2; break;
 case 0x69: code = 0x91e3; break;
 case 0x6a: code = 0x91e4; break;
 case 0x6b: code = 0x91e5; break;
 case 0x6c: code = 0x91e6; break;
 case 0x6d: code = 0x91e7; break;
 case 0x6e: code = 0x91e8; break;
 case 0x6f: code = 0x91e9; break;
 case 0x70: code = 0x91ea; break;
 case 0x71: code = 0x91eb; break;
 case 0x72: code = 0x91ec; break;
 case 0x73: code = 0x91ed; break;
 case 0x74: code = 0x91ee; break;
 case 0x75: code = 0x91ef; break;
 case 0x76: code = 0x91f0; break;
 case 0x77: code = 0x91f1; break;
 case 0x78: code = 0x91f2; break;
 case 0x79: code = 0x91f3; break;
 case 0x7a: code = 0x91f4; break;
 case 0x7b: code = 0x91f5; break;
 case 0x7c: code = 0x91f6; break;
 case 0x7d: code = 0x91f7; break;
 case 0x7e: code = 0x91f8; break;
 case 0x7f: code = 0x91f9; break;
 case 0x80: code = 0x91fa; break;
 case 0x81: code = 0x91fb; break;
 case 0x82: code = 0x91fc; break;
 case 0x83: code = 0x91fd; break;
 case 0x84: code = 0x91fe; break;
 case 0x85: code = 0x9240; break;
 case 0x86: code = 0x9241; break;
 case 0x87: code = 0x9242; break;
 case 0x88: code = 0x9243; break;
 case 0x89: code = 0x9244; break;
 case 0x8a: code = 0x9245; break;
 case 0x8b: code = 0x9246; break;
 case 0x8c: code = 0x9247; break;
 case 0x8d: code = 0x9248; break;
 case 0x8e: code = 0x9249; break;
 case 0x8f: code = 0x924a; break;
 case 0x90: code = 0x924b; break;
 case 0x91: code = 0x924c; break;
 case 0x92: code = 0x924d; break;
 case 0x93: code = 0x924e; break;
 case 0x94: code = 0x924f; break;
 case 0x95: code = 0x9250; break;
 case 0x96: code = 0x9251; break;
 case 0x97: code = 0x9252; break;
 case 0x98: code = 0x9253; break;
 case 0x99: code = 0x9254; break;
 case 0x9a: code = 0x9255; break;
 case 0x9b: code = 0x9256; break;
 case 0x9c: code = 0x9257; break;
 case 0x9d: code = 0x9258; break;
 case 0x9e: code = 0x9259; break;
 case 0x9f: code = 0x925a; break;
 case 0xa0: code = 0x925b; break;
 case 0xa1: code = 0x925c; break;
 case 0xa2: code = 0x925d; break;
 case 0xa3: code = 0x925e; break;
 case 0xa4: code = 0x925f; break;
 case 0xa5: code = 0x9260; break;
 case 0xa6: code = 0x9261; break;
 case 0xa7: code = 0x9262; break;
 case 0xa8: code = 0x9263; break;
 case 0xa9: code = 0x9264; break;
 case 0xaa: code = 0x9265; break;
 case 0xab: code = 0x9266; break;
 case 0xac: code = 0x9267; break;
 case 0xad: code = 0x9268; break;
 case 0xae: code = 0x9269; break;
 case 0xaf: code = 0x926a; break;
 case 0xb0: code = 0x926b; break;
 case 0xb1: code = 0x926c; break;
 case 0xb2: code = 0x926d; break;
 case 0xb3: code = 0x926e; break;
 case 0xb4: code = 0x926f; break;
 case 0xb5: code = 0x9270; break;
 case 0xb6: code = 0x9271; break;
 case 0xb7: code = 0x9272; break;
 case 0xb8: code = 0x9273; break;
 case 0xb9: code = 0x9274; break;
 case 0xba: code = 0x9275; break;
 case 0xbb: code = 0x9276; break;
 case 0xbc: code = 0x9277; break;
 case 0xbd: code = 0x9278; break;
 case 0xbe: code = 0x9279; break;
 case 0xbf: code = 0x927a; break;
 case 0xc0: code = 0x927b; break;
 case 0xc1: code = 0x927c; break;
 case 0xc2: code = 0x927d; break;
 case 0xc3: code = 0x927e; break;
 case 0xc4: code = 0x92a1; break;
 case 0xc5: code = 0x92a2; break;
 case 0xc6: code = 0x92a3; break;
 case 0xc7: code = 0x92a4; break;
 case 0xc8: code = 0x92a5; break;
 case 0xc9: code = 0x92a6; break;
 case 0xca: code = 0x92a7; break;
 case 0xcb: code = 0x92a8; break;
 case 0xcc: code = 0x92a9; break;
 case 0xcd: code = 0x92aa; break;
 case 0xce: code = 0x92ab; break;
 case 0xcf: code = 0x92ac; break;
 case 0xd0: code = 0x92ad; break;
 case 0xd1: code = 0x92ae; break;
 case 0xd2: code = 0x92af; break;
 case 0xd3: code = 0x92b0; break;
 case 0xd4: code = 0x92b1; break;
 case 0xd5: code = 0x92b2; break;
 case 0xd6: code = 0x92b3; break;
 case 0xd7: code = 0x92b4; break;
 case 0xd8: code = 0x92b5; break;
 case 0xd9: code = 0x92b6; break;
 case 0xda: code = 0x92b7; break;
 case 0xdb: code = 0x92b8; break;
 case 0xdc: code = 0x92b9; break;
 case 0xdd: code = 0x92ba; break;
 case 0xde: code = 0x92bb; break;
 case 0xdf: code = 0x92bc; break;
 case 0xe0: code = 0x92bd; break;
 case 0xe1: code = 0x92be; break;
 case 0xe2: code = 0x92bf; break;
 case 0xe3: code = 0x92c0; break;
 case 0xe4: code = 0x92c1; break;
 case 0xe5: code = 0x92c2; break;
 case 0xe6: code = 0x92c3; break;
 case 0xe7: code = 0x92c4; break;
 case 0xe8: code = 0x92c5; break;
 case 0xe9: code = 0x92c6; break;
 case 0xea: code = 0x92c7; break;
 case 0xeb: code = 0x92c8; break;
 case 0xec: code = 0x92c9; break;
 case 0xed: code = 0x92ca; break;
 case 0xee: code = 0x92cb; break;
 case 0xef: code = 0x92cc; break;
 case 0xf0: code = 0x92cd; break;
 case 0xf1: code = 0x92ce; break;
 case 0xf2: code = 0x92cf; break;
 case 0xf3: code = 0x92d0; break;
 case 0xf4: code = 0x92d1; break;
 case 0xf5: code = 0x92d2; break;
 case 0xf6: code = 0x92d3; break;
 case 0xf7: code = 0x92d4; break;
 case 0xf8: code = 0x92d5; break;
 case 0xf9: code = 0x92d6; break;
 case 0xfa: code = 0x92d7; break;
 case 0xfb: code = 0x92d8; break;
 case 0xfc: code = 0x92d9; break;
 case 0xfd: code = 0x92da; break;
 case 0xfe: code = 0x92db; break;
 case 0xff: code = 0x92dc; break;
    }
    break;
  case 0xe6: switch(c1) {
 case 0x00: code = 0x92dd; break;
 case 0x01: code = 0x92de; break;
 case 0x02: code = 0x92df; break;
 case 0x03: code = 0x92e0; break;
 case 0x04: code = 0x92e1; break;
 case 0x05: code = 0x92e2; break;
 case 0x06: code = 0x92e3; break;
 case 0x07: code = 0x92e4; break;
 case 0x08: code = 0x92e5; break;
 case 0x09: code = 0x92e6; break;
 case 0x0a: code = 0x92e7; break;
 case 0x0b: code = 0x92e8; break;
 case 0x0c: code = 0x92e9; break;
 case 0x0d: code = 0x92ea; break;
 case 0x0e: code = 0x92eb; break;
 case 0x0f: code = 0x92ec; break;
 case 0x10: code = 0x92ed; break;
 case 0x11: code = 0x92ee; break;
 case 0x12: code = 0x92ef; break;
 case 0x13: code = 0x92f0; break;
 case 0x14: code = 0x92f1; break;
 case 0x15: code = 0x92f2; break;
 case 0x16: code = 0x92f3; break;
 case 0x17: code = 0x92f4; break;
 case 0x18: code = 0x92f5; break;
 case 0x19: code = 0x92f6; break;
 case 0x1a: code = 0x92f7; break;
 case 0x1b: code = 0x92f8; break;
 case 0x1c: code = 0x92f9; break;
 case 0x1d: code = 0x92fa; break;
 case 0x1e: code = 0x92fb; break;
 case 0x1f: code = 0x92fc; break;
 case 0x20: code = 0x92fd; break;
 case 0x21: code = 0x92fe; break;
 case 0x22: code = 0x9340; break;
 case 0x23: code = 0x9341; break;
 case 0x24: code = 0x9342; break;
 case 0x25: code = 0x9343; break;
 case 0x26: code = 0x9344; break;
 case 0x27: code = 0x9345; break;
 case 0x28: code = 0x9346; break;
 case 0x29: code = 0x9347; break;
 case 0x2a: code = 0x9348; break;
 case 0x2b: code = 0x9349; break;
 case 0x2c: code = 0x934a; break;
 case 0x2d: code = 0x934b; break;
 case 0x2e: code = 0x934c; break;
 case 0x2f: code = 0x934d; break;
 case 0x30: code = 0x934e; break;
 case 0x31: code = 0x934f; break;
 case 0x32: code = 0x9350; break;
 case 0x33: code = 0x9351; break;
 case 0x34: code = 0x9352; break;
 case 0x35: code = 0x9353; break;
 case 0x36: code = 0x9354; break;
 case 0x37: code = 0x9355; break;
 case 0x38: code = 0x9356; break;
 case 0x39: code = 0x9357; break;
    case 0x3a: code = 0x9358; break;
    case 0x3b: code = 0x9359; break;
    case 0x3c: code = 0x935a; break;
    case 0x3d: code = 0x935b; break;
    case 0x3e: code = 0x935c; break;
    case 0x3f: code = 0x935d; break;
 case 0x40: code = 0x935e; break;
 case 0x41: code = 0x935f; break;
 case 0x42: code = 0x9360; break;
 case 0x43: code = 0x9361; break;
 case 0x44: code = 0x9362; break;
 case 0x45: code = 0x9363; break;
 case 0x46: code = 0x9364; break;
 case 0x47: code = 0x9365; break;
 case 0x48: code = 0x9366; break;
 case 0x49: code = 0x9367; break;
 case 0x4a: code = 0x9368; break;
 case 0x4b: code = 0x9369; break;
 case 0x4c: code = 0x936a; break;
 case 0x4d: code = 0x936b; break;
 case 0x4e: code = 0x936c; break;
 case 0x4f: code = 0x936d; break;
 case 0x50: code = 0x936e; break;
 case 0x51: code = 0x936f; break;
 case 0x52: code = 0x9370; break;
 case 0x53: code = 0x9371; break;
 case 0x54: code = 0x9372; break;
 case 0x55: code = 0x9373; break;
 case 0x56: code = 0x9374; break;
 case 0x57: code = 0x9375; break;
 case 0x58: code = 0x9376; break;
 case 0x59: code = 0x9377; break;
 case 0x5a: code = 0x9378; break;
 case 0x5b: code = 0x9379; break;
 case 0x5c: code = 0x937a; break;
 case 0x5d: code = 0x937b; break;
 case 0x5e: code = 0x937c; break;
 case 0x5f: code = 0x937d; break;
 case 0x60: code = 0x937e; break;
 case 0x61: code = 0x93a1; break;
 case 0x62: code = 0x93a2; break;
 case 0x63: code = 0x93a3; break;
 case 0x64: code = 0x93a4; break;
 case 0x65: code = 0x93a5; break;
 case 0x66: code = 0x93a6; break;
 case 0x67: code = 0x93a7; break;
 case 0x68: code = 0x93a8; break;
 case 0x69: code = 0x93a9; break;
 case 0x6a: code = 0x93aa; break;
 case 0x6b: code = 0x93ab; break;
 case 0x6c: code = 0x93ac; break;
 case 0x6d: code = 0x93ad; break;
 case 0x6e: code = 0x93ae; break;
 case 0x6f: code = 0x93af; break;
 case 0x70: code = 0x93b0; break;
 case 0x71: code = 0x93b1; break;
 case 0x72: code = 0x93b2; break;
 case 0x73: code = 0x93b3; break;
 case 0x74: code = 0x93b4; break;
 case 0x75: code = 0x93b5; break;
 case 0x76: code = 0x93b6; break;
 case 0x77: code = 0x93b7; break;
 case 0x78: code = 0x93b8; break;
 case 0x79: code = 0x93b9; break;
 case 0x7a: code = 0x93ba; break;
 case 0x7b: code = 0x93bb; break;
 case 0x7c: code = 0x93bc; break;
 case 0x7d: code = 0x93bd; break;
 case 0x7e: code = 0x93be; break;
 case 0x7f: code = 0x93bf; break;
 case 0x80: code = 0x93c0; break;
 case 0x81: code = 0x93c1; break;
 case 0x82: code = 0x93c2; break;
 case 0x83: code = 0x93c3; break;
 case 0x84: code = 0x93c4; break;
 case 0x85: code = 0x93c5; break;
 case 0x86: code = 0x93c6; break;
 case 0x87: code = 0x93c7; break;
 case 0x88: code = 0x93c8; break;
 case 0x89: code = 0x93c9; break;
 case 0x8a: code = 0x93ca; break;
 case 0x8b: code = 0x93cb; break;
 case 0x8c: code = 0x93cc; break;
 case 0x8d: code = 0x93cd; break;
 case 0x8e: code = 0x93ce; break;
 case 0x8f: code = 0x93cf; break;
 case 0x90: code = 0x93d0; break;
 case 0x91: code = 0x93d1; break;
 case 0x92: code = 0x93d2; break;
 case 0x93: code = 0x93d3; break;
 case 0x94: code = 0x93d4; break;
 case 0x95: code = 0x93d5; break;
 case 0x96: code = 0x93d6; break;
 case 0x97: code = 0x93d7; break;
 case 0x98: code = 0x93d8; break;
 case 0x99: code = 0x93d9; break;
 case 0x9a: code = 0x93da; break;
 case 0x9b: code = 0x93db; break;
 case 0x9c: code = 0x93dc; break;
 case 0x9d: code = 0x93dd; break;
 case 0x9e: code = 0x93de; break;
 case 0x9f: code = 0x93df; break;
 case 0xa0: code = 0x93e0; break;
 case 0xa1: code = 0x93e1; break;
 case 0xa2: code = 0x93e2; break;
 case 0xa3: code = 0x93e3; break;
 case 0xa4: code = 0x93e4; break;
 case 0xa5: code = 0x93e5; break;
 case 0xa6: code = 0x93e6; break;
 case 0xa7: code = 0x93e7; break;
 case 0xa8: code = 0x93e8; break;
 case 0xa9: code = 0x93e9; break;
 case 0xaa: code = 0x93ea; break;
 case 0xab: code = 0x93eb; break;
 case 0xac: code = 0x93ec; break;
 case 0xad: code = 0x93ed; break;
 case 0xae: code = 0x93ee; break;
 case 0xaf: code = 0x93ef; break;
 case 0xb0: code = 0x93f0; break;
 case 0xb1: code = 0x93f1; break;
 case 0xb2: code = 0x93f2; break;
 case 0xb3: code = 0x93f3; break;
 case 0xb4: code = 0x93f4; break;
 case 0xb5: code = 0x93f5; break;
 case 0xb6: code = 0x93f6; break;
 case 0xb7: code = 0x93f7; break;
 case 0xb8: code = 0x93f8; break;
 case 0xb9: code = 0x93f9; break;
 case 0xba: code = 0x93fa; break;
 case 0xbb: code = 0x93fb; break;
 case 0xbc: code = 0x93fc; break;
 case 0xbd: code = 0x93fd; break;
 case 0xbe: code = 0x93fe; break;
 case 0xbf: code = 0x9440; break;
 case 0xc0: code = 0x9441; break;
 case 0xc1: code = 0x9442; break;
 case 0xc2: code = 0x9443; break;
 case 0xc3: code = 0x9444; break;
 case 0xc4: code = 0x9445; break;
 case 0xc5: code = 0x9447; break;
/* case 0xc5: code = 0x9446; break;*/
 case 0xc7: code = 0x9448; break;
 case 0xc8: code = 0x9449; break;
 case 0xc9: code = 0x944a; break;
 case 0xca: code = 0x944b; break;
 case 0xcb: code = 0x944c; break;
 case 0xcc: code = 0x944d; break;
 case 0xcd: code = 0x944e; break;
 case 0xce: code = 0x944f; break;
 case 0xcf: code = 0x9450; break;
 case 0xd0: code = 0x9451; break;
 case 0xd1: code = 0x9452; break;
 case 0xd2: code = 0x9453; break;
 case 0xd3: code = 0x9454; break;
 case 0xd4: code = 0x9455; break;
 case 0xd5: code = 0x9456; break;
 case 0xd6: code = 0x9457; break;
 case 0xd7: code = 0x9458; break;
 case 0xd8: code = 0x9459; break;
 case 0xd9: code = 0x945a; break;
 case 0xda: code = 0x945b; break;
 case 0xdb: code = 0x945c; break;
 case 0xdc: code = 0x945d; break;
 case 0xdd: code = 0x945e; break;
 case 0xde: code = 0x945f; break;
 case 0xdf: code = 0x9460; break;
 case 0xe0: code = 0x9461; break;
 case 0xe1: code = 0x9462; break;
 case 0xe2: code = 0x9463; break;
 case 0xe3: code = 0x9464; break;
 case 0xe4: code = 0x9465; break;
 case 0xe5: code = 0x9466; break;
 case 0xe6: code = 0x9467; break;
 case 0xe7: code = 0x9468; break;
 case 0xe8: code = 0x9469; break;
 case 0xe9: code = 0x946a; break;
 case 0xea: code = 0x946b; break;
 case 0xeb: code = 0x946c; break;
 case 0xec: code = 0x946d; break;
 case 0xed: code = 0x946e; break;
 case 0xee: code = 0x946f; break;
 case 0xef: code = 0x9470; break;
 case 0xf0: code = 0x9471; break;
 case 0xf1: code = 0x9472; break;
 case 0xf2: code = 0x9473; break;
 case 0xf3: code = 0x9474; break;
 case 0xf4: code = 0x9475; break;
 case 0xf5: code = 0x9476; break;
 case 0xf6: code = 0x9477; break;
 case 0xf7: code = 0x9478; break;
 case 0xf8: code = 0x9479; break;
 case 0xf9: code = 0x947a; break;
 case 0xfa: code = 0x947b; break;
 case 0xfb: code = 0x947c; break;
 case 0xfc: code = 0x947d; break;
 case 0xfd: code = 0x947e; break;
 case 0xfe: code = 0x94a1; break;
 case 0xff: code = 0x94a2; break;
    }
    break;
  case 0xe7: switch(c1) {
 case 0x00: code = 0x94a3; break;
 case 0x01: code = 0x94a4; break;
 case 0x02: code = 0x94a5; break;
 case 0x03: code = 0x94a6; break;
 case 0x04: code = 0x94a7; break;
 case 0x05: code = 0x94a8; break;
 case 0x06: code = 0x94a9; break;
 case 0x07: code = 0x94aa; break;
 case 0x08: code = 0x94ab; break;
 case 0x09: code = 0x94ac; break;
 case 0x0a: code = 0x94ad; break;
 case 0x0b: code = 0x94ae; break;
 case 0x0c: code = 0x94af; break;
 case 0x0d: code = 0x94b0; break;
 case 0x0e: code = 0x94b1; break;
 case 0x0f: code = 0x94b2; break;
 case 0x10: code = 0x94b3; break;
 case 0x11: code = 0x94b4; break;
 case 0x12: code = 0x94b5; break;
 case 0x13: code = 0x94b6; break;
 case 0x14: code = 0x94b7; break;
 case 0x15: code = 0x94b8; break;
 case 0x16: code = 0x94b9; break;
 case 0x17: code = 0x94ba; break;
 case 0x18: code = 0x94bb; break;
 case 0x19: code = 0x94bc; break;
 case 0x1a: code = 0x94bd; break;
 case 0x1b: code = 0x94be; break;
 case 0x1c: code = 0x94bf; break;
 case 0x1d: code = 0x94c0; break;
 case 0x1e: code = 0x94c1; break;
 case 0x1f: code = 0x94c2; break;
 case 0x20: code = 0x94c3; break;
 case 0x21: code = 0x94c4; break;
 case 0x22: code = 0x94c5; break;
 case 0x23: code = 0x94c6; break;
 case 0x24: code = 0x94c7; break;
 case 0x25: code = 0x94c8; break;
 case 0x26: code = 0x94c9; break;
 case 0x27: code = 0x94ca; break;
 case 0x28: code = 0x94cb; break;
 case 0x29: code = 0x94cc; break;
 case 0x2a: code = 0x94cd; break;
 case 0x2b: code = 0x94ce; break;
 case 0x2c: code = 0x94cf; break;
 case 0x2d: code = 0x94d0; break;
 case 0x2e: code = 0x94d1; break;
 case 0x2f: code = 0x94d2; break;
 case 0x30: code = 0x94d3; break;
 case 0x31: code = 0x94d4; break;
 case 0x32: code = 0x94d5; break;
 case 0x33: code = 0x94d6; break;
 case 0x34: code = 0x94d7; break;
 case 0x35: code = 0x94d8; break;
 case 0x36: code = 0x94d9; break;
 case 0x37: code = 0x94da; break;
 case 0x38: code = 0x94db; break;
 case 0x39: code = 0x94dc; break;
 case 0x3a: code = 0x94dd; break;
 case 0x3b: code = 0x94de; break;
 case 0x3c: code = 0x94df; break;
 case 0x3d: code = 0x94e0; break;
 case 0x3e: code = 0x94e1; break;
 case 0x3f: code = 0x94e2; break;
 case 0x40: code = 0x94e3; break;
 case 0x41: code = 0x94e4; break;
 case 0x42: code = 0x94e5; break;
 case 0x43: code = 0x94e6; break;
 case 0x44: code = 0x94e7; break;
 case 0x45: code = 0x94e8; break;
 case 0x46: code = 0x94e9; break;
 case 0x47: code = 0x94ea; break;
 case 0x48: code = 0x94eb; break;
 case 0x49: code = 0x94ec; break;
 case 0x4a: code = 0x94ed; break;
 case 0x4b: code = 0x94ee; break;
 case 0x4c: code = 0x94ef; break;
 case 0x4d: code = 0x94f0; break;
 case 0x4e: code = 0x94f1; break;
 case 0x4f: code = 0x94f2; break;
 case 0x50: code = 0x94f3; break;
 case 0x51: code = 0x94f4; break;
 case 0x52: code = 0x94f5; break;
 case 0x53: code = 0x94f6; break;
 case 0x54: code = 0x94f7; break;
 case 0x55: code = 0x94f8; break;
 case 0x56: code = 0x94f9; break;
 case 0x57: code = 0x94fa; break;
 case 0x58: code = 0x94fb; break;
 case 0x59: code = 0x94fc; break;
 case 0x5a: code = 0x94fd; break;
 case 0x5b: code = 0x94fe; break;
 case 0x5c: code = 0x9540; break;
 case 0x5d: code = 0x9541; break;
 case 0x5e: code = 0x9542; break;
 case 0x5f: code = 0x9543; break;
 case 0x60: code = 0x9544; break;
 case 0x61: code = 0x9545; break;
 case 0x62: code = 0x9546; break;
 case 0x63: code = 0x9547; break;
 case 0x64: code = 0x9548; break;
 case 0x65: code = 0x9549; break;
 case 0x66: code = 0x954a; break;
 case 0x67: code = 0x954b; break;
 case 0x68: code = 0x954c; break;
 case 0x69: code = 0x954d; break;
 case 0x6a: code = 0x954e; break;
 case 0x6b: code = 0x954f; break;
 case 0x6c: code = 0x9550; break;
 case 0x6d: code = 0x9551; break;
 case 0x6e: code = 0x9552; break;
 case 0x6f: code = 0x9553; break;
 case 0x70: code = 0x9554; break;
 case 0x71: code = 0x9555; break;
 case 0x72: code = 0x9556; break;
 case 0x73: code = 0x9557; break;
 case 0x74: code = 0x9558; break;
 case 0x75: code = 0x9559; break;
 case 0x76: code = 0x955a; break;
 case 0x77: code = 0x955b; break;
 case 0x78: code = 0x955c; break;
 case 0x79: code = 0x955d; break;
 case 0x7a: code = 0x955e; break;
 case 0x7b: code = 0x955f; break;
 case 0x7c: code = 0x9560; break;
 case 0x7d: code = 0x9561; break;
 case 0x7e: code = 0x9562; break;
 case 0x7f: code = 0x9563; break;
 case 0x80: code = 0x9564; break;
 case 0x81: code = 0x9565; break;
 case 0x82: code = 0x9566; break;
 case 0x83: code = 0x9567; break;
 case 0x84: code = 0x9568; break;
 case 0x85: code = 0x9569; break;
 case 0x86: code = 0x956a; break;
 case 0x87: code = 0x956b; break;
 case 0x88: code = 0x956c; break;
 case 0x89: code = 0x956d; break;
 case 0x8a: code = 0x956e; break;
 case 0x8b: code = 0x956f; break;
 case 0x8c: code = 0x9570; break;
 case 0x8d: code = 0x9571; break;
 case 0x8e: code = 0x9572; break;
 case 0x8f: code = 0x9573; break;
 case 0x90: code = 0x9574; break;
 case 0x91: code = 0x9575; break;
 case 0x92: code = 0x9576; break;
 case 0x93: code = 0x9577; break;
 case 0x94: code = 0x9578; break;
 case 0x95: code = 0x9579; break;
 case 0x96: code = 0x957a; break;
 case 0x97: code = 0x957b; break;
 case 0x98: code = 0x957c; break;
 case 0x99: code = 0x957d; break;
 case 0x9a: code = 0x957e; break;
 case 0x9b: code = 0x95a1; break;
 case 0x9c: code = 0x95a2; break;
 case 0x9d: code = 0x95a3; break;
 case 0x9e: code = 0x95a4; break;
 case 0x9f: code = 0x95a5; break;
 case 0xa0: code = 0x95a6; break;
 case 0xa1: code = 0x95a7; break;
 case 0xa2: code = 0x95a8; break;
 case 0xa3: code = 0x95a9; break;
 case 0xa4: code = 0x95aa; break;
 case 0xa5: code = 0x95ab; break;
 case 0xa6: code = 0x95ac; break;
 case 0xa7: code = 0x95ad; break;
 case 0xa8: code = 0x95ae; break;
 case 0xa9: code = 0x95af; break;
 case 0xaa: code = 0x95b0; break;
 case 0xab: code = 0x95b1; break;
 case 0xac: code = 0x95b2; break;
 case 0xad: code = 0x95b3; break;
 case 0xae: code = 0x95b4; break;
 case 0xaf: code = 0x95b5; break;
 case 0xb0: code = 0x95b6; break;
 case 0xb1: code = 0x95b7; break;
 case 0xb2: code = 0x95b8; break;
 case 0xb3: code = 0x95b9; break;
 case 0xb4: code = 0x95ba; break;
 case 0xb5: code = 0x95bb; break;
 case 0xb6: code = 0x95bc; break;
 case 0xb7: code = 0x95bd; break;
 case 0xb8: code = 0x95be; break;
 case 0xb9: code = 0x95bf; break;
 case 0xba: code = 0x95c0; break;
 case 0xbb: code = 0x95c1; break;
 case 0xbc: code = 0x95c2; break;
 case 0xbd: code = 0x95c3; break;
 case 0xbe: code = 0x95c4; break;
 case 0xbf: code = 0x95c5; break;
 case 0xc0: code = 0x95c6; break;
 case 0xc1: code = 0x95c7; break;
 case 0xc2: code = 0x95c8; break;
 case 0xc3: code = 0x95c9; break;
 case 0xc4: code = 0x95ca; break;
 case 0xc5: code = 0x95cb; break;
 case 0xc6: code = 0x95cc; break;
 case 0xc7: code = 0x95cd; break;
 case 0xc8: code = 0x95ce; break;
 case 0xc9: code = 0x95cf; break;
 case 0xca: code = 0x95d0; break;
 case 0xcb: code = 0x95d1; break;
 case 0xcc: code = 0x95d2; break;
 case 0xcd: code = 0x95d3; break;
 case 0xce: code = 0x95d4; break;
 case 0xcf: code = 0x95d5; break;
 case 0xd0: code = 0x95d6; break;
 case 0xd1: code = 0x95d7; break;
 case 0xd2: code = 0x95d8; break;
 case 0xd3: code = 0x95d9; break;
 case 0xd4: code = 0x95da; break;
 case 0xd5: code = 0x95db; break;
 case 0xd6: code = 0x95dc; break;
 case 0xd7: code = 0x95dd; break;
 case 0xd8: code = 0x95de; break;
 case 0xd9: code = 0x95df; break;
 case 0xda: code = 0x95e0; break;
 case 0xdb: code = 0x95e1; break;
 case 0xdc: code = 0x95e2; break;
 case 0xdd: code = 0x95e3; break;
 case 0xde: code = 0x95e4; break;
 case 0xdf: code = 0x95e5; break;
 case 0xe0: code = 0x95e6; break;
 case 0xe1: code = 0x95e7; break;
 case 0xe2: code = 0x95e8; break;
 case 0xe3: code = 0x95e9; break;
 case 0xe4: code = 0x95ea; break;
 case 0xe5: code = 0x95eb; break;
 case 0xe6: code = 0x95ec; break;
 case 0xe7: code = 0x95ed; break;
 case 0xe8: code = 0x95ee; break;
 case 0xe9: code = 0x95ef; break;
 case 0xea: code = 0x95f0; break;
 case 0xeb: code = 0x95f1; break;
 case 0xec: code = 0x95f2; break;
 case 0xed: code = 0x95f3; break;
 case 0xee: code = 0x95f4; break;
 case 0xef: code = 0x95f5; break;
 case 0xf0: code = 0x95f6; break;
 case 0xf1: code = 0x95f7; break;
 case 0xf2: code = 0x95f8; break;
 case 0xf3: code = 0x95f9; break;
 case 0xf4: code = 0x95fa; break;
 case 0xf5: code = 0x95fb; break;
 case 0xf6: code = 0x95fc; break;
 case 0xf7: code = 0x95fd; break;
 case 0xf8: code = 0x95fe; break;
 case 0xf9: code = 0x9640; break;
 case 0xfa: code = 0x9641; break;
 case 0xfb: code = 0x9642; break;
 case 0xfc: code = 0x9643; break;
 case 0xfd: code = 0x9644; break;
 case 0xfe: code = 0x9645; break;
 case 0xff: code = 0x9646; break;
    }
    break;
  case 0xe8: switch(c1) {
 case 0x00: code = 0x9647; break;
 case 0x01: code = 0x9648; break;
 case 0x02: code = 0x9649; break;
 case 0x03: code = 0x964a; break;
 case 0x04: code = 0x964b; break;
 case 0x05: code = 0x964c; break;
 case 0x06: code = 0x964d; break;
 case 0x07: code = 0x964e; break;
 case 0x08: code = 0x964f; break;
 case 0x09: code = 0x9650; break;
 case 0x0a: code = 0x9651; break;
 case 0x0b: code = 0x9652; break;
 case 0x0c: code = 0x9653; break;
 case 0x0d: code = 0x9654; break;
 case 0x0e: code = 0x9655; break;
 case 0x0f: code = 0x9656; break;
 case 0x10: code = 0x9657; break;
 case 0x11: code = 0x9658; break;
 case 0x12: code = 0x9659; break;
 case 0x13: code = 0x965a; break;
 case 0x14: code = 0x965b; break;
 case 0x15: code = 0x965c; break;
 case 0x16: code = 0x965d; break;
 case 0x17: code = 0x965e; break;
 case 0x18: code = 0x965f; break;
 case 0x19: code = 0x9660; break;
 case 0x1a: code = 0x9661; break;
 case 0x1b: code = 0x9662; break;
 case 0x1c: code = 0x9663; break;
 case 0x1d: code = 0x9664; break;
 case 0x1e: code = 0x9665; break;
 case 0x1f: code = 0x9666; break;
 case 0x20: code = 0x9667; break;
 case 0x21: code = 0x9668; break;
 case 0x22: code = 0x9669; break;
 case 0x23: code = 0x966a; break;
 case 0x24: code = 0x966b; break;
 case 0x25: code = 0x966c; break;
 case 0x26: code = 0x966d; break;
 case 0x27: code = 0x966e; break;
 case 0x28: code = 0x966f; break;
 case 0x29: code = 0x9670; break;
 case 0x2a: code = 0x9671; break;
 case 0x2b: code = 0x9672; break;
 case 0x2c: code = 0x9673; break;
 case 0x2d: code = 0x9674; break;
 case 0x2e: code = 0x9675; break;
 case 0x2f: code = 0x9676; break;
 case 0x30: code = 0x9677; break;
 case 0x31: code = 0x9678; break;
 case 0x32: code = 0x9679; break;
 case 0x33: code = 0x967a; break;
 case 0x34: code = 0x967b; break;
 case 0x35: code = 0x967c; break;
 case 0x36: code = 0x967d; break;
 case 0x37: code = 0x967e; break;
 case 0x38: code = 0x96a1; break;
 case 0x39: code = 0x96a2; break;
 case 0x3a: code = 0x96a3; break;
 case 0x3b: code = 0x96a4; break;
 case 0x3c: code = 0x96a5; break;
 case 0x3d: code = 0x96a6; break;
 case 0x3e: code = 0x96a7; break;
 case 0x3f: code = 0x96a8; break;
 case 0x40: code = 0x96a9; break;
 case 0x41: code = 0x96aa; break;
 case 0x42: code = 0x96ab; break;
 case 0x43: code = 0x96ac; break;
 case 0x44: code = 0x96ad; break;
 case 0x45: code = 0x96ae; break;
 case 0x46: code = 0x96af; break;
 case 0x47: code = 0x96b0; break;
 case 0x48: code = 0x96b1; break;
 case 0x49: code = 0x96b2; break;
 case 0x4a: code = 0x96b3; break;
 case 0x4b: code = 0x96b4; break;
 case 0x4c: code = 0x96b5; break;
 case 0x4d: code = 0x96b6; break;
 case 0x4e: code = 0x96b7; break;
 case 0x4f: code = 0x96b8; break;
 case 0x50: code = 0x96b9; break;
 case 0x51: code = 0x96ba; break;
 case 0x52: code = 0x96bb; break;
 case 0x53: code = 0x96bc; break;
 case 0x54: code = 0x96bd; break;
 case 0x55: code = 0x96be; break;
 case 0x56: code = 0x96bf; break;
 case 0x57: code = 0x96c0; break;
 case 0x58: code = 0x96c1; break;
 case 0x59: code = 0x96c2; break;
 case 0x5a: code = 0x96c3; break;
 case 0x5b: code = 0x96c4; break;
 case 0x5c: code = 0x96c5; break;
 case 0x5d: code = 0x96c6; break;
 case 0x5e: code = 0x96c7; break;
 case 0x5f: code = 0x96c8; break;
 case 0x60: code = 0x96c9; break;
 case 0x61: code = 0x96ca; break;
 case 0x62: code = 0x96cb; break;
 case 0x63: code = 0x96cc; break;
 case 0x64: code = 0x96cd; break;
 case 0x65: code = 0x96ce; break;
 case 0x66: code = 0x96cf; break;
 case 0x67: code = 0x96d0; break;
 case 0x68: code = 0x96d1; break;
 case 0x69: code = 0x96d2; break;
 case 0x6a: code = 0x96d3; break;
 case 0x6b: code = 0x96d4; break;
 case 0x6c: code = 0x96d5; break;
 case 0x6d: code = 0x96d6; break;
 case 0x6e: code = 0x96d7; break;
 case 0x6f: code = 0x96d8; break;
 case 0x70: code = 0x96d9; break;
 case 0x71: code = 0x96da; break;
 case 0x72: code = 0x96db; break;
 case 0x73: code = 0x96dc; break;
 case 0x74: code = 0x96dd; break;
 case 0x75: code = 0x96de; break;
 case 0x76: code = 0x96df; break;
 case 0x77: code = 0x96e0; break;
 case 0x78: code = 0x96e1; break;
 case 0x79: code = 0x96e2; break;
 case 0x7a: code = 0x96e3; break;
 case 0x7b: code = 0x96e4; break;
 case 0x7c: code = 0x96e5; break;
 case 0x7d: code = 0x96e6; break;
 case 0x7e: code = 0x96e7; break;
 case 0x7f: code = 0x96e8; break;
 case 0x80: code = 0x96e9; break;
 case 0x81: code = 0x96ea; break;
 case 0x82: code = 0x96eb; break;
 case 0x83: code = 0x96ec; break;
 case 0x84: code = 0x96ed; break;
 case 0x85: code = 0x96ee; break;
 case 0x86: code = 0x96ef; break;
 case 0x87: code = 0x96f0; break;
 case 0x88: code = 0x96f1; break;
 case 0x89: code = 0x96f2; break;
 case 0x8a: code = 0x96f3; break;
 case 0x8b: code = 0x96f4; break;
 case 0x8c: code = 0x96f5; break;
 case 0x8d: code = 0x96f6; break;
 case 0x8e: code = 0x96f7; break;
 case 0x8f: code = 0x96f8; break;
 case 0x90: code = 0x96f9; break;
 case 0x91: code = 0x96fa; break;
 case 0x92: code = 0x96fb; break;
 case 0x93: code = 0x96fc; break;
 case 0x94: code = 0x96fd; break;
 case 0x95: code = 0x96fe; break;
 case 0x96: code = 0x9740; break;
 case 0x97: code = 0x9741; break;
 case 0x98: code = 0x9742; break;
 case 0x99: code = 0x9743; break;
 case 0x9a: code = 0x9744; break;
 case 0x9b: code = 0x9745; break;
 case 0x9c: code = 0x9746; break;
 case 0x9d: code = 0x9747; break;
 case 0x9e: code = 0x9748; break;
 case 0x9f: code = 0x9749; break;
 case 0xa0: code = 0x974a; break;
 case 0xa1: code = 0x974b; break;
 case 0xa2: code = 0x974c; break;
 case 0xa3: code = 0x974d; break;
 case 0xa4: code = 0x974e; break;
 case 0xa5: code = 0x974f; break;
 case 0xa6: code = 0x9750; break;
 case 0xa7: code = 0x9751; break;
 case 0xa8: code = 0x9752; break;
 case 0xa9: code = 0x9753; break;
 case 0xaa: code = 0x9754; break;
 case 0xab: code = 0x9755; break;
 case 0xac: code = 0x9756; break;
 case 0xad: code = 0x9757; break;
 case 0xae: code = 0x9758; break;
 case 0xaf: code = 0x9759; break;
 case 0xb0: code = 0x975a; break;
 case 0xb1: code = 0x975b; break;
 case 0xb2: code = 0x975c; break;
 case 0xb3: code = 0x975d; break;
 case 0xb4: code = 0x975e; break;
 case 0xb5: code = 0x975f; break;
 case 0xb6: code = 0x9760; break;
 case 0xb7: code = 0x9761; break;
 case 0xb8: code = 0x9762; break;
 case 0xb9: code = 0x9763; break;
 case 0xba: code = 0x9764; break;
 case 0xbb: code = 0x9765; break;
 case 0xbc: code = 0x9766; break;
 case 0xbd: code = 0x9767; break;
 case 0xbe: code = 0x9768; break;
 case 0xbf: code = 0x9769; break;
 case 0xc0: code = 0x976a; break;
 case 0xc1: code = 0x976b; break;
 case 0xc2: code = 0x976c; break;
 case 0xc3: code = 0x976d; break;
 case 0xc4: code = 0x976e; break;
 case 0xc5: code = 0x976f; break;
 case 0xc6: code = 0x9770; break;
 case 0xc7: code = 0x9771; break;
 case 0xc8: code = 0x9772; break;
 case 0xc9: code = 0x9773; break;
 case 0xca: code = 0x9774; break;
 case 0xcb: code = 0x9775; break;
 case 0xcc: code = 0x9776; break;
 case 0xcd: code = 0x9777; break;
 case 0xce: code = 0x9778; break;
 case 0xcf: code = 0x9779; break;
 case 0xd0: code = 0x977a; break;
 case 0xd1: code = 0x977b; break;
 case 0xd2: code = 0x977c; break;
 case 0xd3: code = 0x977d; break;
 case 0xd4: code = 0x977e; break;
 case 0xd5: code = 0x97a1; break;
 case 0xd6: code = 0x97a2; break;
 case 0xd7: code = 0x97a3; break;
 case 0xd8: code = 0x97a4; break;
 case 0xd9: code = 0x97a5; break;
 case 0xda: code = 0x97a6; break;
 case 0xdb: code = 0x97a7; break;
 case 0xdc: code = 0x97a8; break;
 case 0xdd: code = 0x97a9; break;
 case 0xde: code = 0x97aa; break;
 case 0xdf: code = 0x97ab; break;
 case 0xe0: code = 0x97ac; break;
 case 0xe1: code = 0x97ad; break;
 case 0xe2: code = 0x97ae; break;
 case 0xe3: code = 0x97af; break;
 case 0xe4: code = 0x97b0; break;
 case 0xe5: code = 0x97b1; break;
 case 0xe6: code = 0x97b2; break;
 case 0xe7: code = 0x97b3; break;
 case 0xe8: code = 0x97b4; break;
 case 0xe9: code = 0x97b5; break;
 case 0xea: code = 0x97b6; break;
 case 0xeb: code = 0x97b7; break;
 case 0xec: code = 0x97b8; break;
 case 0xed: code = 0x97b9; break;
 case 0xee: code = 0x97ba; break;
 case 0xef: code = 0x97bb; break;
 case 0xf0: code = 0x97bc; break;
 case 0xf1: code = 0x97bd; break;
 case 0xf2: code = 0x97be; break;
 case 0xf3: code = 0x97bf; break;
 case 0xf4: code = 0x97c0; break;
 case 0xf5: code = 0x97c1; break;
 case 0xf6: code = 0x97c2; break;
 case 0xf7: code = 0x97c3; break;
 case 0xf8: code = 0x97c4; break;
 case 0xf9: code = 0x97c5; break;
 case 0xfa: code = 0x97c6; break;
 case 0xfb: code = 0x97c7; break;
 case 0xfc: code = 0x97c8; break;
 case 0xfd: code = 0x97c9; break;
 case 0xfe: code = 0x97ca; break;
 case 0xff: code = 0x97cb; break;
    }
    break;
  case 0xe9: switch(c1) {
 case 0x00: code = 0x97cc; break;
 case 0x01: code = 0x97cd; break;
 case 0x02: code = 0x97ce; break;
 case 0x03: code = 0x97cf; break;
 case 0x04: code = 0x97d0; break;
 case 0x05: code = 0x97d1; break;
 case 0x06: code = 0x97d2; break;
 case 0x07: code = 0x97d3; break;
 case 0x08: code = 0x97d4; break;
 case 0x09: code = 0x97d5; break;
 case 0x0a: code = 0x97d6; break;
 case 0x0b: code = 0x97d7; break;
 case 0x0c: code = 0x97d8; break;
 case 0x0d: code = 0x97d9; break;
 case 0x0e: code = 0x97da; break;
 case 0x0f: code = 0x97db; break;
 case 0x10: code = 0x97dc; break;
 case 0x11: code = 0x97dd; break;
 case 0x12: code = 0x97de; break;
 case 0x13: code = 0x97df; break;
 case 0x14: code = 0x97e0; break;
 case 0x15: code = 0x97e1; break;
 case 0x16: code = 0x97e2; break;
 case 0x17: code = 0x97e3; break;
 case 0x18: code = 0x97e4; break;
 case 0x19: code = 0x97e5; break;
 case 0x1a: code = 0x97e6; break;
 case 0x1b: code = 0x97e7; break;
 case 0x1c: code = 0x97e8; break;
 case 0x1d: code = 0x97e9; break;
 case 0x1e: code = 0x97ea; break;
 case 0x1f: code = 0x97eb; break;
 case 0x20: code = 0x97ec; break;
 case 0x21: code = 0x97ed; break;
 case 0x22: code = 0x97ee; break;
 case 0x23: code = 0x97ef; break;
 case 0x24: code = 0x97f0; break;
 case 0x25: code = 0x97f1; break;
 case 0x26: code = 0x97f2; break;
 case 0x27: code = 0x97f3; break;
 case 0x28: code = 0x97f4; break;
 case 0x29: code = 0x97f5; break;
 case 0x2a: code = 0x97f6; break;
 case 0x2b: code = 0x97f7; break;
 case 0x2c: code = 0x97f8; break;
 case 0x2d: code = 0x97f9; break;
 case 0x2e: code = 0x97fa; break;
 case 0x2f: code = 0x97fb; break;
 case 0x30: code = 0x97fc; break;
 case 0x31: code = 0x97fd; break;
 case 0x32: code = 0x97fe; break;
 case 0x33: code = 0x9840; break;
 case 0x34: code = 0x9841; break;
 case 0x35: code = 0x9842; break;
 case 0x36: code = 0x9843; break;
 case 0x37: code = 0x9844; break;
 case 0x38: code = 0x9845; break;
 case 0x39: code = 0x9846; break;
 case 0x3a: code = 0x9847; break;
 case 0x3b: code = 0x9848; break;
 case 0x3c: code = 0x9849; break;
 case 0x3d: code = 0x984a; break;
 case 0x3e: code = 0x984b; break;
 case 0x3f: code = 0x984c; break;
 case 0x40: code = 0x984d; break;
 case 0x41: code = 0x984e; break;
 case 0x42: code = 0x984f; break;
 case 0x43: code = 0x9850; break;
 case 0x44: code = 0x9851; break;
 case 0x45: code = 0x9852; break;
 case 0x46: code = 0x9853; break;
 case 0x47: code = 0x9854; break;
 case 0x48: code = 0x9855; break;
 case 0x49: code = 0x9856; break;
 case 0x4a: code = 0x9857; break;
 case 0x4b: code = 0x9858; break;
 case 0x4c: code = 0x9859; break;
 case 0x4d: code = 0x985a; break;
 case 0x4e: code = 0x985b; break;
 case 0x4f: code = 0x985c; break;
 case 0x50: code = 0x985d; break;
 case 0x51: code = 0x985e; break;
 case 0x52: code = 0x985f; break;
 case 0x53: code = 0x9860; break;
 case 0x54: code = 0x9861; break;
 case 0x55: code = 0x9862; break;
 case 0x56: code = 0x9863; break;
 case 0x57: code = 0x9864; break;
 case 0x58: code = 0x9865; break;
 case 0x59: code = 0x9866; break;
 case 0x5a: code = 0x9867; break;
 case 0x5b: code = 0x9868; break;
 case 0x5c: code = 0x9869; break;
 case 0x5d: code = 0x986a; break;
 case 0x5e: code = 0x986b; break;
 case 0x5f: code = 0x986c; break;
 case 0x60: code = 0x986d; break;
 case 0x61: code = 0x986e; break;
 case 0x62: code = 0x986f; break;
 case 0x63: code = 0x9870; break;
 case 0x64: code = 0x9871; break;
 case 0x65: code = 0x9872; break;
 case 0x66: code = 0x9873; break;
 case 0x67: code = 0x9874; break;
 case 0x68: code = 0x9875; break;
 case 0x69: code = 0x9876; break;
 case 0x6a: code = 0x9877; break;
 case 0x6b: code = 0x9878; break;
 case 0x6c: code = 0x9879; break;
 case 0x6d: code = 0x987a; break;
 case 0x6e: code = 0x987b; break;
 case 0x6f: code = 0x987c; break;
 case 0x70: code = 0x987d; break;
 case 0x71: code = 0x987e; break;
 case 0x72: code = 0x98a1; break;
 case 0x73: code = 0x98a2; break;
 case 0x74: code = 0x98a3; break;
 case 0x75: code = 0x98a4; break;
 case 0x76: code = 0x98a5; break;
 case 0x77: code = 0x98a6; break;
 case 0x78: code = 0x98a7; break;
 case 0x79: code = 0x98a8; break;
 case 0x7a: code = 0x98a9; break;
 case 0x7b: code = 0x98aa; break;
 case 0x7c: code = 0x98ab; break;
 case 0x7d: code = 0x98ac; break;
 case 0x7e: code = 0x98ad; break;
 case 0x7f: code = 0x98ae; break;
 case 0x80: code = 0x98af; break;
 case 0x81: code = 0x98b0; break;
 case 0x82: code = 0x98b1; break;
 case 0x83: code = 0x98b2; break;
 case 0x84: code = 0x98b3; break;
 case 0x85: code = 0x98b4; break;
 case 0x86: code = 0x98b5; break;
 case 0x87: code = 0x98b6; break;
 case 0x88: code = 0x98b7; break;
 case 0x89: code = 0x98b8; break;
 case 0x8a: code = 0x98b9; break;
 case 0x8b: code = 0x98ba; break;
 case 0x8c: code = 0x98bb; break;
 case 0x8d: code = 0x98bc; break;
 case 0x8e: code = 0x98bd; break;
 case 0x8f: code = 0x98be; break;
 case 0x90: code = 0x98bf; break;
 case 0x91: code = 0x98c0; break;
 case 0x92: code = 0x98c1; break;
 case 0x93: code = 0x98c2; break;
 case 0x94: code = 0x98c3; break;
 case 0x95: code = 0x98c4; break;
 case 0x96: code = 0x98c5; break;
 case 0x97: code = 0x98c6; break;
 case 0x98: code = 0x98c7; break;
 case 0x99: code = 0x98c8; break;
 case 0x9a: code = 0x98c9; break;
 case 0x9b: code = 0x98ca; break;
 case 0x9c: code = 0x98cb; break;
 case 0x9d: code = 0x98cc; break;
 case 0x9e: code = 0x98cd; break;
 case 0x9f: code = 0x98ce; break;
 case 0xa0: code = 0x98cf; break;
 case 0xa1: code = 0x98d0; break;
 case 0xa2: code = 0x98d1; break;
 case 0xa3: code = 0x98d2; break;
 case 0xa4: code = 0x98d3; break;
 case 0xa5: code = 0x98d4; break;
 case 0xa6: code = 0x98d5; break;
 case 0xa7: code = 0x98d6; break;
 case 0xa8: code = 0x98d7; break;
 case 0xa9: code = 0x98d8; break;
 case 0xaa: code = 0x98d9; break;
 case 0xab: code = 0x98da; break;
 case 0xac: code = 0x98db; break;
 case 0xad: code = 0x98dc; break;
 case 0xae: code = 0x98dd; break;
 case 0xaf: code = 0x98de; break;
 case 0xb0: code = 0x98df; break;
 case 0xb1: code = 0x98e0; break;
 case 0xb2: code = 0x98e1; break;
 case 0xb3: code = 0x98e2; break;
 case 0xb4: code = 0x98e3; break;
 case 0xb5: code = 0x98e4; break;
 case 0xb6: code = 0x98e5; break;
 case 0xb7: code = 0x98e6; break;
 case 0xb8: code = 0x98e7; break;
 case 0xb9: code = 0x98e8; break;
 case 0xba: code = 0x98e9; break;
 case 0xbb: code = 0x98ea; break;
 case 0xbc: code = 0x98eb; break;
 case 0xbd: code = 0x98ec; break;
 case 0xbe: code = 0x98ed; break;
 case 0xbf: code = 0x98ee; break;
 case 0xc0: code = 0x98ef; break;
 case 0xc1: code = 0x98f0; break;
 case 0xc2: code = 0x98f1; break;
 case 0xc3: code = 0x98f2; break;
 case 0xc4: code = 0x98f3; break;
 case 0xc5: code = 0x98f4; break;
 case 0xc6: code = 0x98f5; break;
 case 0xc7: code = 0x98f6; break;
 case 0xc8: code = 0x98f7; break;
 case 0xc9: code = 0x98f8; break;
 case 0xca: code = 0x98f9; break;
 case 0xcb: code = 0x98fa; break;
 case 0xcc: code = 0x98fb; break;
 case 0xcd: code = 0x98fc; break;
 case 0xce: code = 0x98fd; break;
 case 0xcf: code = 0x98fe; break;
 case 0xd0: code = 0x9940; break;
 case 0xd1: code = 0x9941; break;
 case 0xd2: code = 0x9942; break;
 case 0xd3: code = 0x9943; break;
 case 0xd4: code = 0x9944; break;
 case 0xd5: code = 0x9945; break;
 case 0xd6: code = 0x9946; break;
 case 0xd7: code = 0x9947; break;
 case 0xd8: code = 0x9948; break;
 case 0xd9: code = 0x9949; break;
 case 0xda: code = 0x994a; break;
 case 0xdb: code = 0x994b; break;
 case 0xdc: code = 0x994c; break;
 case 0xdd: code = 0x994d; break;
 case 0xde: code = 0x994e; break;
 case 0xdf: code = 0x994f; break;
 case 0xe0: code = 0x9950; break;
 case 0xe1: code = 0x9951; break;
 case 0xe2: code = 0x9952; break;
 case 0xe3: code = 0x9953; break;
 case 0xe4: code = 0x9954; break;
 case 0xe5: code = 0x9955; break;
 case 0xe6: code = 0x9956; break;
 case 0xe7: code = 0x9957; break;
 case 0xe8: code = 0x9958; break;
 case 0xe9: code = 0x9959; break;
 case 0xea: code = 0x995a; break;
 case 0xeb: code = 0x995b; break;
 case 0xec: code = 0x995c; break;
 case 0xed: code = 0x995d; break;
 case 0xee: code = 0x995e; break;
 case 0xef: code = 0x995f; break;
 case 0xf0: code = 0x9960; break;
 case 0xf1: code = 0x9961; break;
 case 0xf2: code = 0x9962; break;
 case 0xf3: code = 0x9963; break;
 case 0xf4: code = 0x9964; break;
 case 0xf5: code = 0x9965; break;
 case 0xf6: code = 0x9966; break;
 case 0xf7: code = 0x9967; break;
 case 0xf8: code = 0x9968; break;
 case 0xf9: code = 0x9969; break;
 case 0xfa: code = 0x996a; break;
 case 0xfb: code = 0x996b; break;
 case 0xfc: code = 0x996c; break;
 case 0xfd: code = 0x996d; break;
 case 0xfe: code = 0x996e; break;
 case 0xff: code = 0x996f; break;
    }
    break;
  case 0xea: switch(c1) {
 case 0x00: code = 0x9970; break;
 case 0x01: code = 0x9971; break;
 case 0x02: code = 0x9972; break;
 case 0x03: code = 0x9973; break;
 case 0x04: code = 0x9974; break;
 case 0x05: code = 0x9975; break;
 case 0x06: code = 0x9976; break;
 case 0x07: code = 0x9977; break;
 case 0x08: code = 0x9978; break;
 case 0x09: code = 0x9979; break;
 case 0x0a: code = 0x997a; break;
 case 0x0b: code = 0x997b; break;
 case 0x0c: code = 0x997c; break;
 case 0x0d: code = 0x997d; break;
 case 0x0e: code = 0x997e; break;
 case 0x0f: code = 0x99a1; break;
 case 0x10: code = 0x99a2; break;
 case 0x11: code = 0x99a3; break;
 case 0x12: code = 0x99a4; break;
 case 0x13: code = 0x99a5; break;
 case 0x14: code = 0x99a6; break;
 case 0x15: code = 0x99a7; break;
 case 0x16: code = 0x99a8; break;
 case 0x17: code = 0x99a9; break;
 case 0x18: code = 0x99aa; break;
 case 0x19: code = 0x99ab; break;
 case 0x1a: code = 0x99ac; break;
 case 0x1b: code = 0x99ad; break;
 case 0x1c: code = 0x99ae; break;
 case 0x1d: code = 0x99af; break;
 case 0x1e: code = 0x99b0; break;
 case 0x1f: code = 0x99b1; break;
 case 0x20: code = 0x99b2; break;
 case 0x21: code = 0x99b3; break;
 case 0x22: code = 0x99b4; break;
 case 0x23: code = 0x99b5; break;
 case 0x24: code = 0x99b6; break;
 case 0x25: code = 0x99b7; break;
 case 0x26: code = 0x99b8; break;
 case 0x27: code = 0x99b9; break;
 case 0x28: code = 0x99ba; break;
 case 0x29: code = 0x99bb; break;
 case 0x2a: code = 0x99bc; break;
 case 0x2b: code = 0x99bd; break;
 case 0x2c: code = 0x99be; break;
 case 0x2d: code = 0x99bf; break;
 case 0x2e: code = 0x99c0; break;
 case 0x2f: code = 0x99c1; break;
 case 0x30: code = 0x99c2; break;
 case 0x31: code = 0x99c3; break;
 case 0x32: code = 0x99c4; break;
 case 0x33: code = 0x99c5; break;
 case 0x34: code = 0x99c6; break;
 case 0x35: code = 0x99c7; break;
 case 0x36: code = 0x99c8; break;
 case 0x37: code = 0x99c9; break;
 case 0x38: code = 0x99ca; break;
 case 0x39: code = 0x99cb; break;
 case 0x3a: code = 0x99cc; break;
 case 0x3b: code = 0x99cd; break;
 case 0x3c: code = 0x99ce; break;
 case 0x3d: code = 0x99cf; break;
 case 0x3e: code = 0x99d0; break;
 case 0x3f: code = 0x99d1; break;
 case 0x40: code = 0x99d2; break;
 case 0x41: code = 0x99d3; break;
 case 0x42: code = 0x99d4; break;
 case 0x43: code = 0x99d5; break;
 case 0x44: code = 0x99d6; break;
 case 0x45: code = 0x99d7; break;
 case 0x46: code = 0x99d8; break;
 case 0x47: code = 0x99d9; break;
 case 0x48: code = 0x99da; break;
 case 0x49: code = 0x99db; break;
 case 0x4a: code = 0x99dc; break;
 case 0x4b: code = 0x99dd; break;
 case 0x4c: code = 0x99de; break;
 case 0x4d: code = 0x99df; break;
 case 0x4e: code = 0x99e0; break;
 case 0x4f: code = 0x99e1; break;
 case 0x50: code = 0x99e2; break;
 case 0x51: code = 0x99e3; break;
 case 0x52: code = 0x99e4; break;
 case 0x53: code = 0x99e5; break;
 case 0x54: code = 0x99e6; break;
 case 0x55: code = 0x99e7; break;
 case 0x56: code = 0x99e8; break;
 case 0x57: code = 0x99e9; break;
 case 0x58: code = 0x99ea; break;
 case 0x59: code = 0x99eb; break;
 case 0x5a: code = 0x99ec; break;
 case 0x5b: code = 0x99ed; break;
 case 0x5c: code = 0x99ee; break;
 case 0x5d: code = 0x99ef; break;
 case 0x5e: code = 0x99f0; break;
 case 0x5f: code = 0x99f1; break;
 case 0x60: code = 0x99f2; break;
 case 0x61: code = 0x99f3; break;
 case 0x62: code = 0x99f4; break;
 case 0x63: code = 0x99f5; break;
 case 0x64: code = 0x99f6; break;
 case 0x65: code = 0x99f7; break;
 case 0x66: code = 0x99f8; break;
 case 0x67: code = 0x99f9; break;
 case 0x68: code = 0x99fa; break;
 case 0x69: code = 0x99fb; break;
 case 0x6a: code = 0x99fc; break;
 case 0x6b: code = 0x99fd; break;
 case 0x6c: code = 0x99fe; break;
 case 0x6d: code = 0x9a40; break;
 case 0x6e: code = 0x9a41; break;
 case 0x6f: code = 0x9a42; break;
 case 0x70: code = 0x9a43; break;
 case 0x71: code = 0x9a44; break;
 case 0x72: code = 0x9a45; break;
 case 0x73: code = 0x9a46; break;
 case 0x74: code = 0x9a47; break;
 case 0x75: code = 0x9a48; break;
 case 0x76: code = 0x9a49; break;
 case 0x77: code = 0x9a4a; break;
 case 0x78: code = 0x9a4b; break;
 case 0x79: code = 0x9a4c; break;
 case 0x7a: code = 0x9a4d; break;
 case 0x7b: code = 0x9a4e; break;
 case 0x7c: code = 0x9a4f; break;
 case 0x7d: code = 0x9a50; break;
 case 0x7e: code = 0x9a51; break;
 case 0x7f: code = 0x9a52; break;
 case 0x80: code = 0x9a53; break;
 case 0x81: code = 0x9a54; break;
 case 0x82: code = 0x9a55; break;
 case 0x83: code = 0x9a56; break;
 case 0x84: code = 0x9a57; break;
 case 0x85: code = 0x9a58; break;
 case 0x86: code = 0x9a59; break;
 case 0x87: code = 0x9a5a; break;
 case 0x88: code = 0x9a5b; break;
 case 0x89: code = 0x9a5c; break;
 case 0x8a: code = 0x9a5d; break;
 case 0x8b: code = 0x9a5e; break;
 case 0x8c: code = 0x9a5f; break;
 case 0x8d: code = 0x9a60; break;
 case 0x8e: code = 0x9a61; break;
 case 0x8f: code = 0x9a62; break;
 case 0x90: code = 0x9a63; break;
 case 0x91: code = 0x9a64; break;
 case 0x92: code = 0x9a65; break;
 case 0x93: code = 0x9a66; break;
 case 0x94: code = 0x9a67; break;
 case 0x95: code = 0x9a68; break;
 case 0x96: code = 0x9a69; break;
 case 0x97: code = 0x9a6a; break;
 case 0x98: code = 0x9a6b; break;
 case 0x99: code = 0x9a6c; break;
 case 0x9a: code = 0x9a6d; break;
 case 0x9b: code = 0x9a6e; break;
 case 0x9c: code = 0x9a6f; break;
 case 0x9d: code = 0x9a70; break;
 case 0x9e: code = 0x9a71; break;
 case 0x9f: code = 0x9a72; break;
 case 0xa0: code = 0x9a73; break;
 case 0xa1: code = 0x9a74; break;
 case 0xa2: code = 0x9a75; break;
 case 0xa3: code = 0x9a76; break;
 case 0xa4: code = 0x9a77; break;
 case 0xa5: code = 0x9a78; break;
 case 0xa6: code = 0x9a79; break;
 case 0xa7: code = 0x9a7a; break;
 case 0xa8: code = 0x9a7b; break;
 case 0xa9: code = 0x9a7c; break;
 case 0xaa: code = 0x9a7d; break;
 case 0xab: code = 0x9a7e; break;
 case 0xac: code = 0x9aa1; break;
 case 0xad: code = 0x9aa2; break;
 case 0xae: code = 0x9aa3; break;
 case 0xaf: code = 0x9aa4; break;
 case 0xb0: code = 0x9aa5; break;
 case 0xb1: code = 0x9aa6; break;
 case 0xb2: code = 0x9aa7; break;
 case 0xb3: code = 0x9aa8; break;
 case 0xb4: code = 0x9aa9; break;
 case 0xb5: code = 0x9aaa; break;
 case 0xb6: code = 0x9aab; break;
 case 0xb7: code = 0x9aac; break;
 case 0xb8: code = 0x9aad; break;
 case 0xb9: code = 0x9aae; break;
 case 0xba: code = 0x9aaf; break;
 case 0xbb: code = 0x9ab0; break;
 case 0xbc: code = 0x9ab1; break;
 case 0xbd: code = 0x9ab2; break;
 case 0xbe: code = 0x9ab3; break;
 case 0xbf: code = 0x9ab4; break;
 case 0xc0: code = 0x9ab5; break;
 case 0xc1: code = 0x9ab6; break;
 case 0xc2: code = 0x9ab7; break;
 case 0xc3: code = 0x9ab8; break;
 case 0xc4: code = 0x9ab9; break;
 case 0xc5: code = 0x9aba; break;
 case 0xc6: code = 0x9abb; break;
 case 0xc7: code = 0x9abc; break;
 case 0xc8: code = 0x9abd; break;
 case 0xc9: code = 0x9abe; break;
 case 0xca: code = 0x9abf; break;
 case 0xcb: code = 0x9ac0; break;
 case 0xcc: code = 0x9ac1; break;
 case 0xcd: code = 0x9ac2; break;
 case 0xce: code = 0x9ac3; break;
 case 0xcf: code = 0x9ac4; break;
 case 0xd0: code = 0x9ac5; break;
 case 0xd1: code = 0x9ac6; break;
 case 0xd2: code = 0x9ac7; break;
 case 0xd3: code = 0x9ac8; break;
 case 0xd4: code = 0x9ac9; break;
 case 0xd5: code = 0x9aca; break;
 case 0xd6: code = 0x9acb; break;
 case 0xd7: code = 0x9acc; break;
 case 0xd8: code = 0x9acd; break;
 case 0xd9: code = 0x9ace; break;
 case 0xda: code = 0x9acf; break;
 case 0xdb: code = 0x9ad0; break;
 case 0xdc: code = 0x9ad1; break;
 case 0xdd: code = 0x9ad2; break;
 case 0xde: code = 0x9ad3; break;
 case 0xdf: code = 0x9ad4; break;
 case 0xe0: code = 0x9ad5; break;
 case 0xe1: code = 0x9ad6; break;
 case 0xe2: code = 0x9ad7; break;
 case 0xe3: code = 0x9ad8; break;
 case 0xe4: code = 0x9ad9; break;
 case 0xe5: code = 0x9ada; break;
 case 0xe6: code = 0x9adb; break;
 case 0xe7: code = 0x9adc; break;
 case 0xe8: code = 0x9add; break;
 case 0xe9: code = 0x9ade; break;
 case 0xea: code = 0x9adf; break;
 case 0xeb: code = 0x9ae0; break;
 case 0xec: code = 0x9ae1; break;
 case 0xed: code = 0x9ae2; break;
 case 0xee: code = 0x9ae3; break;
 case 0xef: code = 0x9ae4; break;
 case 0xf0: code = 0x9ae5; break;
 case 0xf1: code = 0x9ae6; break;
 case 0xf2: code = 0x9ae7; break;
 case 0xf3: code = 0x9ae8; break;
 case 0xf4: code = 0x9ae9; break;
 case 0xf5: code = 0x9aea; break;
 case 0xf6: code = 0x9aeb; break;
 case 0xf7: code = 0x9aec; break;
 case 0xf8: code = 0x9aed; break;
 case 0xf9: code = 0x9aee; break;
 case 0xfa: code = 0x9aef; break;
 case 0xfb: code = 0x9af0; break;
 case 0xfc: code = 0x9af1; break;
 case 0xfd: code = 0x9af2; break;
 case 0xfe: code = 0x9af3; break;
 case 0xff: code = 0x9af4; break;
    }
    break;
  case 0xeb: switch(c1) {
 case 0x00: code = 0x9af5; break;
 case 0x01: code = 0x9af6; break;
 case 0x02: code = 0x9af7; break;
 case 0x03: code = 0x9af8; break;
 case 0x04: code = 0x9af9; break;
 case 0x05: code = 0x9afa; break;
 case 0x06: code = 0x9afb; break;
 case 0x07: code = 0x9afc; break;
 case 0x08: code = 0x9afd; break;
 case 0x09: code = 0x9afe; break;
 case 0x0a: code = 0x9b40; break;
 case 0x0b: code = 0x9b41; break;
 case 0x0c: code = 0x9b42; break;
 case 0x0d: code = 0x9b43; break;
 case 0x0e: code = 0x9b44; break;
 case 0x0f: code = 0x9b45; break;
 case 0x10: code = 0x9b46; break;
 case 0x11: code = 0x9b47; break;
 case 0x12: code = 0x9b48; break;
 case 0x13: code = 0x9b49; break;
 case 0x14: code = 0x9b4a; break;
 case 0x15: code = 0x9b4b; break;
 case 0x16: code = 0x9b4c; break;
 case 0x17: code = 0x9b4d; break;
 case 0x18: code = 0x9b4e; break;
 case 0x19: code = 0x9b4f; break;
 case 0x1a: code = 0x9b50; break;
 case 0x1b: code = 0x9b51; break;
 case 0x1c: code = 0x9b52; break;
 case 0x1d: code = 0x9b53; break;
 case 0x1e: code = 0x9b54; break;
 case 0x1f: code = 0x9b55; break;
 case 0x20: code = 0x9b56; break;
 case 0x21: code = 0x9b57; break;
 case 0x22: code = 0x9b58; break;
 case 0x23: code = 0x9b59; break;
 case 0x24: code = 0x9b5a; break;
 case 0x25: code = 0x9b5b; break;
 case 0x26: code = 0x9b5c; break;
 case 0x27: code = 0x9b5d; break;
 case 0x28: code = 0x9b5e; break;
 case 0x29: code = 0x9b5f; break;
 case 0x2a: code = 0x9b60; break;
 case 0x2c: code = 0x9b62; break;
 case 0x2d: code = 0x9b63; break;
 case 0x2e: code = 0x9b64; break;
 case 0x2f: code = 0x9b65; break;
 case 0x30: code = 0x9b66; break;
 case 0x31: code = 0x9b67; break;
 case 0x32: code = 0x9b68; break;
 case 0x33: code = 0x9b69; break;
 case 0x34: code = 0x9b6a; break;
 case 0x35: code = 0x9b6b; break;
 case 0x36: code = 0x9b6c; break;
 case 0x37: code = 0x9b6d; break;
 case 0x38: code = 0x9b6e; break;
 case 0x39: code = 0x9b6f; break;
 case 0x3a: code = 0x9b70; break;
 case 0x3b: code = 0x9b71; break;
 case 0x3c: code = 0x9b72; break;
 case 0x3d: code = 0x9b73; break;
 case 0x3e: code = 0x9b74; break;
 case 0x3f: code = 0x9b75; break;
 case 0x40: code = 0x9b76; break;
 case 0x41: code = 0x9b77; break;
 case 0x42: code = 0x9b78; break;
 case 0x43: code = 0x9b79; break;
 case 0x44: code = 0x9b7a; break;
 case 0x45: code = 0x9b7b; break;
 case 0x46: code = 0x9b7c; break;
 case 0x47: code = 0x9b7d; break;
 case 0x48: code = 0x9b7e; break;
 case 0x49: code = 0x9ba1; break;
 case 0x4a: code = 0x9ba2; break;
 case 0x4b: code = 0x9ba3; break;
 case 0x4c: code = 0x9ba4; break;
 case 0x4d: code = 0x9ba5; break;
 case 0x4e: code = 0x9ba6; break;
 case 0x4f: code = 0x9ba7; break;
 case 0x50: code = 0x9ba8; break;
 case 0x51: code = 0x9ba9; break;
 case 0x52: code = 0x9baa; break;
 case 0x53: code = 0x9bab; break;
 case 0x54: code = 0x9bac; break;
 case 0x55: code = 0x9bad; break;
 case 0x56: code = 0x9bae; break;
 case 0x57: code = 0x9baf; break;
 case 0x58: code = 0x9bb0; break;
 case 0x59: code = 0x9bb1; break;
 case 0x5a: code = 0x9bb2; break;
 case 0x5b: code = 0x9bb3; break;
 case 0x5c: code = 0x9bb4; break;
 case 0x5d: code = 0x9bb5; break;
 case 0x5e: code = 0x9bb6; break;
 case 0x5f: code = 0x9bb7; break;
 case 0x60: code = 0x9bb8; break;
 case 0x61: code = 0x9bb9; break;
 case 0x62: code = 0x9bba; break;
 case 0x63: code = 0x9bbb; break;
 case 0x64: code = 0x9bbc; break;
 case 0x65: code = 0x9bbd; break;
 case 0x66: code = 0x9bbe; break;
 case 0x67: code = 0x9bbf; break;
 case 0x68: code = 0x9bc0; break;
 case 0x69: code = 0x9bc1; break;
 case 0x6a: code = 0x9bc2; break;
 case 0x6b: code = 0x9bc3; break;
 case 0x6c: code = 0x9bc4; break;
 case 0x6d: code = 0x9bc5; break;
 case 0x6e: code = 0x9bc6; break;
 case 0x6f: code = 0x9bc7; break;
 case 0x70: code = 0x9bc8; break;
 case 0x71: code = 0x9bc9; break;
 case 0x72: code = 0x9bca; break;
 case 0x73: code = 0x9bcb; break;
 case 0x74: code = 0x9bcc; break;
 case 0x75: code = 0x9bcd; break;
 case 0x76: code = 0x9bce; break;
 case 0x77: code = 0x9bcf; break;
 case 0x78: code = 0x9bd0; break;
 case 0x79: code = 0x9bd1; break;
 case 0x7a: code = 0x9bd2; break;
 case 0x7b: code = 0x9bd3; break;
 case 0x7c: code = 0x9bd4; break;
 case 0x7d: code = 0x9bd5; break;
 case 0x7e: code = 0x9bd6; break;
 case 0x7f: code = 0x9bd7; break;
 case 0x80: code = 0x9bd8; break;
 case 0x81: code = 0x9bd9; break;
 case 0x82: code = 0x9bda; break;
 case 0x83: code = 0x9bdb; break;
 case 0x84: code = 0x9bdc; break;
 case 0x85: code = 0x9bdd; break;
 case 0x86: code = 0x9bde; break;
 case 0x87: code = 0x9bdf; break;
 case 0x88: code = 0x9be0; break;
 case 0x89: code = 0x9be1; break;
 case 0x8a: code = 0x9be2; break;
 case 0x8b: code = 0x9be3; break;
 case 0x8c: code = 0x9be4; break;
 case 0x8d: code = 0x9be5; break;
 case 0x8e: code = 0x9be6; break;
 case 0x8f: code = 0x9be7; break;
 case 0x90: code = 0x9be8; break;
 case 0x91: code = 0x9be9; break;
 case 0x92: code = 0x9bea; break;
 case 0x93: code = 0x9beb; break;
 case 0x94: code = 0x9bec; break;
 case 0x95: code = 0x9bed; break;
 case 0x96: code = 0x9bee; break;
 case 0x97: code = 0x9bef; break;
 case 0x98: code = 0x9bf0; break;
 case 0x99: code = 0x9bf1; break;
 case 0x9a: code = 0x9bf2; break;
 case 0x9b: code = 0x9bf3; break;
 case 0x9c: code = 0x9bf4; break;
 case 0x9d: code = 0x9bf5; break;
 case 0x9e: code = 0x9bf6; break;
 case 0x9f: code = 0x9bf7; break;
 case 0xa0: code = 0x9bf8; break;
 case 0xa1: code = 0x9bf9; break;
 case 0xa2: code = 0x9bfa; break;
 case 0xa3: code = 0x9bfb; break;
 case 0xa4: code = 0x9bfc; break;
 case 0xa5: code = 0x9bfd; break;
 case 0xa6: code = 0x9bfe; break;
 case 0xa7: code = 0x9c40; break;
 case 0xa8: code = 0x9c41; break;
 case 0xa9: code = 0x9c42; break;
 case 0xaa: code = 0x9c43; break;
 case 0xab: code = 0x9c44; break;
 case 0xac: code = 0x9c45; break;
 case 0xad: code = 0x9c46; break;
 case 0xae: code = 0x9c47; break;
 case 0xaf: code = 0x9c48; break;
 case 0xb0: code = 0x9c49; break;
 case 0xb1: code = 0x9c4a; break;
 case 0xb2: code = 0x9c4b; break;
 case 0xb3: code = 0x9c4c; break;
 case 0xb4: code = 0x9c4d; break;
 case 0xb5: code = 0x9c4e; break;
 case 0xb6: code = 0x9c4f; break;
 case 0xb7: code = 0x9c50; break;
 case 0xb8: code = 0x9c51; break;
 case 0xb9: code = 0x9c52; break;
 case 0xba: code = 0x9c53; break;
 case 0xbb: code = 0x9c54; break;
 case 0xbc: code = 0x9c55; break;
 case 0xbd: code = 0x9c56; break;
 case 0xbe: code = 0x9c57; break;
 case 0xbf: code = 0x9c58; break;
 case 0xc0: code = 0x9c59; break;
 case 0xc1: code = 0x9c5a; break;
 case 0xc2: code = 0x9c5b; break;
 case 0xc3: code = 0x9c5c; break;
 case 0xc4: code = 0x9c5d; break;
 case 0xc5: code = 0x9c5e; break;
 case 0xc6: code = 0x9c5f; break;
 case 0xc7: code = 0x9c60; break;
 case 0xc8: code = 0x9c61; break;
 case 0xca: code = 0x9c63; break;
 case 0xcb: code = 0x9c64; break;
 case 0xcc: code = 0x9c65; break;
 case 0xcd: code = 0x9c66; break;
 case 0xce: code = 0x9c67; break;
 case 0xcf: code = 0x9c68; break;
 case 0xd0: code = 0x9c69; break;
 case 0xd1: code = 0x9c6a; break;
 case 0xd2: code = 0x9c6b; break;
 case 0xd3: code = 0x9c6c; break;
 case 0xd4: code = 0x9c6d; break;
 case 0xd5: code = 0x9c6e; break;
 case 0xd6: code = 0x9c6f; break;
 case 0xd7: code = 0x9c70; break;
 case 0xd8: code = 0x9c71; break;
 case 0xd9: code = 0x9c72; break;
 case 0xda: code = 0x9c73; break;
 case 0xdb: code = 0x9c74; break;
 case 0xdc: code = 0x9c75; break;
 case 0xdd: code = 0x9c76; break;
 case 0xde: code = 0x9c77; break;
 case 0xdf: code = 0x9c78; break;
 case 0xe0: code = 0x9c79; break;
 case 0xe1: code = 0x9c7a; break;
 case 0xe2: code = 0x9c7b; break;
 case 0xe3: code = 0x9c7c; break;
 case 0xe4: code = 0x9c7d; break;
 case 0xe5: code = 0x9c7e; break;
 case 0xe6: code = 0x9ca1; break;
 case 0xe7: code = 0x9ca2; break;
 case 0xe8: code = 0x9ca3; break;
 case 0xe9: code = 0x9ca4; break;
 case 0xea: code = 0x9ca5; break;
 case 0xeb: code = 0x9ca6; break;
 case 0xec: code = 0x9ca7; break;
 case 0xed: code = 0x9ca8; break;
 case 0xee: code = 0x9ca9; break;
 case 0xef: code = 0x9caa; break;
 case 0xf0: code = 0x9cab; break;
 case 0xf1: code = 0x9cac; break;
 case 0xf2: code = 0x9cad; break;
 case 0xf3: code = 0x9cae; break;
 case 0xf4: code = 0x9caf; break;
 case 0xf5: code = 0x9cb0; break;
 case 0xf6: code = 0x9cb1; break;
 case 0xf7: code = 0x9cb2; break;
 case 0xf8: code = 0x9cb3; break;
 case 0xf9: code = 0x9cb4; break;
 case 0xfa: code = 0x9cb5; break;
 case 0xfb: code = 0x9cb6; break;
 case 0xfc: code = 0x9cb7; break;
 case 0xfd: code = 0x9cb8; break;
 case 0xfe: code = 0x9cb9; break;
 case 0xff: code = 0x9cba; break;
    }
    break;
  case 0xec: switch(c1) {
 case 0x00: code = 0x9cbb; break;
 case 0x01: code = 0x9cbc; break;
 case 0x02: code = 0x9cbd; break;
 case 0x03: code = 0x9cbe; break;
 case 0x04: code = 0x9cbf; break;
 case 0x05: code = 0x9cc0; break;
 case 0x06: code = 0x9cc1; break;
 case 0x07: code = 0x9cc2; break;
 case 0x08: code = 0x9cc3; break;
 case 0x09: code = 0x9cc4; break;
 case 0x0a: code = 0x9cc5; break;
 case 0x0b: code = 0x9cc6; break;
 case 0x0c: code = 0x9cc7; break;
 case 0x0d: code = 0x9cc8; break;
 case 0x0e: code = 0x9cc9; break;
 case 0x0f: code = 0x9cca; break;
 case 0x10: code = 0x9ccb; break;
 case 0x11: code = 0x9ccc; break;
 case 0x12: code = 0x9ccd; break;
 case 0x13: code = 0x9cce; break;
 case 0x14: code = 0x9ccf; break;
 case 0x15: code = 0x9cd0; break;
 case 0x16: code = 0x9cd1; break;
 case 0x17: code = 0x9cd2; break;
 case 0x18: code = 0x9cd3; break;
 case 0x19: code = 0x9cd4; break;
 case 0x1a: code = 0x9cd5; break;
 case 0x1b: code = 0x9cd6; break;
 case 0x1c: code = 0x9cd7; break;
 case 0x1d: code = 0x9cd8; break;
 case 0x1e: code = 0x9cd9; break;
 case 0x1f: code = 0x9cda; break;
 case 0x20: code = 0x9cdb; break;
 case 0x21: code = 0x9cdc; break;
 case 0x22: code = 0x9cdd; break;
 case 0x23: code = 0x9cde; break;
 case 0x24: code = 0x9cdf; break;
 case 0x25: code = 0x9ce0; break;
 case 0x26: code = 0x9ce1; break;
 case 0x27: code = 0x9ce2; break;
 case 0x28: code = 0x9ce3; break;
 case 0x29: code = 0x9ce4; break;
 case 0x2a: code = 0x9ce5; break;
 case 0x2b: code = 0x9ce6; break;
 case 0x2c: code = 0x9ce7; break;
 case 0x2d: code = 0x9ce8; break;
 case 0x2e: code = 0x9ce9; break;
 case 0x2f: code = 0x9cea; break;
 case 0x30: code = 0x9ceb; break;
 case 0x31: code = 0x9cec; break;
 case 0x32: code = 0x9ced; break;
 case 0x33: code = 0x9cee; break;
 case 0x34: code = 0x9cef; break;
 case 0x35: code = 0x9cf0; break;
 case 0x36: code = 0x9cf1; break;
 case 0x37: code = 0x9cf2; break;
 case 0x38: code = 0x9cf3; break;
 case 0x39: code = 0x9cf4; break;
 case 0x3a: code = 0x9cf5; break;
 case 0x3b: code = 0x9cf6; break;
 case 0x3c: code = 0x9cf7; break;
 case 0x3d: code = 0x9cf8; break;
 case 0x3e: code = 0x9cf9; break;
 case 0x3f: code = 0x9cfa; break;
 case 0x40: code = 0x9cfb; break;
 case 0x41: code = 0x9cfc; break;
 case 0x42: code = 0x9cfd; break;
 case 0x43: code = 0x9cfe; break;
 case 0x44: code = 0x9d40; break;
 case 0x45: code = 0x9d41; break;
 case 0x46: code = 0x9d42; break;
 case 0x47: code = 0x9d43; break;
 case 0x48: code = 0x9d44; break;
 case 0x49: code = 0x9d45; break;
 case 0x4a: code = 0x9d46; break;
 case 0x4b: code = 0x9d47; break;
 case 0x4c: code = 0x9d48; break;
 case 0x4d: code = 0x9d49; break;
 case 0x4e: code = 0x9d4a; break;
 case 0x4f: code = 0x9d4b; break;
 case 0x50: code = 0x9d4c; break;
 case 0x51: code = 0x9d4d; break;
 case 0x52: code = 0x9d4e; break;
 case 0x53: code = 0x9d4f; break;
 case 0x54: code = 0x9d50; break;
 case 0x55: code = 0x9d51; break;
 case 0x56: code = 0x9d52; break;
 case 0x57: code = 0x9d53; break;
 case 0x58: code = 0x9d54; break;
 case 0x59: code = 0x9d55; break;
 case 0x5a: code = 0x9d56; break;
 case 0x5b: code = 0x9d57; break;
 case 0x5c: code = 0x9d58; break;
 case 0x5d: code = 0x9d59; break;
 case 0x5e: code = 0x9d5a; break;
 case 0x5f: code = 0x9d5b; break;
 case 0x60: code = 0x9d5c; break;
 case 0x61: code = 0x9d5d; break;
 case 0x62: code = 0x9d5e; break;
 case 0x63: code = 0x9d5f; break;
 case 0x64: code = 0x9d60; break;
 case 0x65: code = 0x9d61; break;
 case 0x66: code = 0x9d62; break;
 case 0x67: code = 0x9d63; break;
 case 0x68: code = 0x9d64; break;
 case 0x69: code = 0x9d65; break;
 case 0x6a: code = 0x9d66; break;
 case 0x6b: code = 0x9d67; break;
 case 0x6c: code = 0x9d68; break;
 case 0x6d: code = 0x9d69; break;
 case 0x6e: code = 0x9d6a; break;
 case 0x6f: code = 0x9d6b; break;
 case 0x70: code = 0x9d6c; break;
 case 0x71: code = 0x9d6d; break;
 case 0x72: code = 0x9d6e; break;
 case 0x73: code = 0x9d6f; break;
 case 0x74: code = 0x9d70; break;
 case 0x75: code = 0x9d71; break;
 case 0x76: code = 0x9d72; break;
 case 0x77: code = 0x9d73; break;
 case 0x78: code = 0x9d74; break;
 case 0x79: code = 0x9d75; break;
 case 0x7a: code = 0x9d76; break;
 case 0x7b: code = 0x9d77; break;
 case 0x7c: code = 0x9d78; break;
 case 0x7d: code = 0x9d79; break;
 case 0x7e: code = 0x9d7a; break;
 case 0x7f: code = 0x9d7b; break;
 case 0x80: code = 0x9d7c; break;
 case 0x81: code = 0x9d7d; break;
 case 0x82: code = 0x9d7e; break;
 case 0x83: code = 0x9da1; break;
 case 0x84: code = 0x9da2; break;
 case 0x85: code = 0x9da3; break;
 case 0x86: code = 0x9da4; break;
 case 0x87: code = 0x9da5; break;
 case 0x88: code = 0x9da6; break;
 case 0x89: code = 0x9da7; break;
 case 0x8a: code = 0x9da8; break;
 case 0x8b: code = 0x9da9; break;
 case 0x8c: code = 0x9daa; break;
 case 0x8d: code = 0x9dab; break;
 case 0x8e: code = 0x9dac; break;
 case 0x8f: code = 0x9dad; break;
 case 0x90: code = 0x9dae; break;
 case 0x91: code = 0x9daf; break;
 case 0x92: code = 0x9db0; break;
 case 0x93: code = 0x9db1; break;
 case 0x94: code = 0x9db2; break;
 case 0x95: code = 0x9db3; break;
 case 0x96: code = 0x9db4; break;
 case 0x97: code = 0x9db5; break;
 case 0x98: code = 0x9db6; break;
 case 0x99: code = 0x9db7; break;
 case 0x9a: code = 0x9db8; break;
 case 0x9b: code = 0x9db9; break;
 case 0x9c: code = 0x9dba; break;
 case 0x9d: code = 0x9dbb; break;
 case 0x9e: code = 0x9dbc; break;
 case 0x9f: code = 0x9dbd; break;
 case 0xa0: code = 0x9dbe; break;
 case 0xa1: code = 0x9dbf; break;
 case 0xa2: code = 0x9dc0; break;
 case 0xa3: code = 0x9dc1; break;
 case 0xa4: code = 0x9dc2; break;
 case 0xa5: code = 0x9dc3; break;
 case 0xa6: code = 0x9dc4; break;
 case 0xa7: code = 0x9dc5; break;
 case 0xa8: code = 0x9dc6; break;
 case 0xa9: code = 0x9dc7; break;
 case 0xaa: code = 0x9dc8; break;
 case 0xab: code = 0x9dc9; break;
 case 0xac: code = 0x9dca; break;
 case 0xad: code = 0x9dcb; break;
 case 0xae: code = 0x9dcc; break;
 case 0xaf: code = 0x9dcd; break;
 case 0xb0: code = 0x9dce; break;
 case 0xb1: code = 0x9dcf; break;
 case 0xb2: code = 0x9dd0; break;
 case 0xb3: code = 0x9dd1; break;
 case 0xb4: code = 0x9dd2; break;
 case 0xb5: code = 0x9dd3; break;
 case 0xb6: code = 0x9dd4; break;
 case 0xb7: code = 0x9dd5; break;
 case 0xb8: code = 0x9dd6; break;
 case 0xb9: code = 0x9dd7; break;
 case 0xba: code = 0x9dd8; break;
 case 0xbb: code = 0x9dd9; break;
 case 0xbc: code = 0x9dda; break;
 case 0xbd: code = 0x9ddb; break;
 case 0xbe: code = 0x9ddc; break;
 case 0xbf: code = 0x9ddd; break;
 case 0xc0: code = 0x9dde; break;
 case 0xc1: code = 0x9ddf; break;
 case 0xc2: code = 0x9de0; break;
 case 0xc3: code = 0x9de1; break;
 case 0xc4: code = 0x9de2; break;
 case 0xc5: code = 0x9de3; break;
 case 0xc6: code = 0x9de4; break;
 case 0xc7: code = 0x9de5; break;
 case 0xc8: code = 0x9de6; break;
 case 0xc9: code = 0x9de7; break;
 case 0xca: code = 0x9de8; break;
 case 0xcb: code = 0x9de9; break;
 case 0xcc: code = 0x9dea; break;
 case 0xcd: code = 0x9deb; break;
 case 0xce: code = 0x9dec; break;
 case 0xcf: code = 0x9ded; break;
 case 0xd0: code = 0x9dee; break;
 case 0xd1: code = 0x9def; break;
 case 0xd2: code = 0x9df0; break;
 case 0xd3: code = 0x9df1; break;
 case 0xd4: code = 0x9df2; break;
 case 0xd5: code = 0x9df3; break;
 case 0xd6: code = 0x9df4; break;
 case 0xd7: code = 0x9df5; break;
 case 0xd8: code = 0x9df6; break;
 case 0xd9: code = 0x9df7; break;
 case 0xda: code = 0x9df8; break;
 case 0xdb: code = 0x9df9; break;
 case 0xdc: code = 0x9dfa; break;
 case 0xdd: code = 0x9dfb; break;
 case 0xde: code = 0x9dfc; break;
 case 0xdf: code = 0x9dfd; break;
 case 0xe0: code = 0x9dfe; break;
 case 0xe1: code = 0x9e40; break;
 case 0xe2: code = 0x9e41; break;
 case 0xe3: code = 0x9e42; break;
 case 0xe4: code = 0x9e43; break;
 case 0xe5: code = 0x9e44; break;
 case 0xe6: code = 0x9e45; break;
 case 0xe7: code = 0x9e46; break;
 case 0xe8: code = 0x9e47; break;
 case 0xe9: code = 0x9e48; break;
 case 0xea: code = 0x9e49; break;
 case 0xeb: code = 0x9e4a; break;
 case 0xec: code = 0x9e4b; break;
 case 0xed: code = 0x9e4c; break;
 case 0xee: code = 0x9e4d; break;
 case 0xef: code = 0x9e4e; break;
 case 0xf0: code = 0x9e4f; break;
 case 0xf1: code = 0x9e50; break;
 case 0xf2: code = 0x9e51; break;
 case 0xf3: code = 0x9e52; break;
 case 0xf4: code = 0x9e53; break;
 case 0xf5: code = 0x9e54; break;
 case 0xf6: code = 0x9e55; break;
 case 0xf7: code = 0x9e56; break;
 case 0xf8: code = 0x9e57; break;
 case 0xf9: code = 0x9e58; break;
 case 0xfa: code = 0x9e59; break;
 case 0xfb: code = 0x9e5a; break;
 case 0xfc: code = 0x9e5b; break;
 case 0xfd: code = 0x9e5c; break;
 case 0xfe: code = 0x9e5d; break;
 case 0xff: code = 0x9e5e; break;
    }
    break;
  case 0xed: switch(c1) {
 case 0x00: code = 0x9e5f; break;
 case 0x01: code = 0x9e60; break;
 case 0x02: code = 0x9e61; break;
 case 0x03: code = 0x9e62; break;
 case 0x04: code = 0x9e63; break;
 case 0x05: code = 0x9e64; break;
 case 0x06: code = 0x9e65; break;
 case 0x07: code = 0x9e66; break;
 case 0x08: code = 0x9e67; break;
 case 0x09: code = 0x9e68; break;
 case 0x0a: code = 0x9e69; break;
 case 0x0b: code = 0x9e6a; break;
 case 0x0c: code = 0x9e6b; break;
 case 0x0d: code = 0x9e6c; break;
 case 0x0e: code = 0x9e6d; break;
 case 0x0f: code = 0x9e6e; break;
 case 0x10: code = 0x9e6f; break;
 case 0x11: code = 0x9e70; break;
 case 0x12: code = 0x9e71; break;
 case 0x13: code = 0x9e72; break;
 case 0x14: code = 0x9e73; break;
 case 0x15: code = 0x9e74; break;
 case 0x16: code = 0x9e75; break;
 case 0x17: code = 0x9e76; break;
 case 0x18: code = 0x9e77; break;
 case 0x19: code = 0x9e78; break;
 case 0x1a: code = 0x9e79; break;
 case 0x1b: code = 0x9e7a; break;
 case 0x1c: code = 0x9e7b; break;
 case 0x1d: code = 0x9e7c; break;
 case 0x1e: code = 0x9e7d; break;
 case 0x1f: code = 0x9e7e; break;
 case 0x20: code = 0x9ea1; break;
 case 0x21: code = 0x9ea2; break;
 case 0x22: code = 0x9ea3; break;
 case 0x23: code = 0x9ea4; break;
 case 0x24: code = 0x9ea5; break;
 case 0x25: code = 0x9ea6; break;
 case 0x26: code = 0x9ea7; break;
 case 0x27: code = 0x9ea8; break;
 case 0x28: code = 0x9ea9; break;
 case 0x29: code = 0x9eaa; break;
 case 0x2a: code = 0x9eab; break;
 case 0x2b: code = 0x9eac; break;
 case 0x2c: code = 0x9ead; break;
 case 0x2d: code = 0x9eae; break;
 case 0x2e: code = 0x9eaf; break;
 case 0x2f: code = 0x9eb0; break;
 case 0x30: code = 0x9eb1; break;
 case 0x31: code = 0x9eb2; break;
 case 0x32: code = 0x9eb3; break;
 case 0x33: code = 0x9eb4; break;
 case 0x34: code = 0x9eb5; break;
 case 0x35: code = 0x9eb6; break;
 case 0x36: code = 0x9eb7; break;
 case 0x37: code = 0x9eb8; break;
 case 0x38: code = 0x9eb9; break;
 case 0x39: code = 0x9eba; break;
 case 0x3a: code = 0x9ebb; break;
 case 0x3b: code = 0x9ebc; break;
 case 0x3c: code = 0x9ebd; break;
 case 0x3d: code = 0x9ebe; break;
 case 0x3e: code = 0x9ebf; break;
 case 0x3f: code = 0x9ec0; break;
 case 0x40: code = 0x9ec1; break;
 case 0x41: code = 0x9ec2; break;
 case 0x42: code = 0x9ec3; break;
 case 0x43: code = 0x9ec4; break;
 case 0x44: code = 0x9ec5; break;
 case 0x45: code = 0x9ec6; break;
 case 0x46: code = 0x9ec7; break;
 case 0x47: code = 0x9ec8; break;
 case 0x48: code = 0x9ec9; break;
 case 0x49: code = 0x9eca; break;
 case 0x4a: code = 0x9ecb; break;
 case 0x4b: code = 0x9ecc; break;
 case 0x4c: code = 0x9ecd; break;
 case 0x4d: code = 0x9ece; break;
 case 0x4e: code = 0x9ecf; break;
 case 0x4f: code = 0x9ed0; break;
 case 0x50: code = 0x9ed1; break;
 case 0x51: code = 0x9ed2; break;
 case 0x52: code = 0x9ed3; break;
 case 0x53: code = 0x9ed4; break;
 case 0x54: code = 0x9ed5; break;
 case 0x55: code = 0x9ed6; break;
 case 0x56: code = 0x9ed7; break;
 case 0x57: code = 0x9ed8; break;
 case 0x58: code = 0x9ed9; break;
 case 0x59: code = 0x9eda; break;
 case 0x5a: code = 0x9edb; break;
 case 0x5b: code = 0x9edc; break;
 case 0x5c: code = 0x9edd; break;
 case 0x5d: code = 0x9ede; break;
 case 0x5e: code = 0x9edf; break;
 case 0x5f: code = 0x9ee0; break;
 case 0x60: code = 0x9ee1; break;
 case 0x61: code = 0x9ee2; break;
 case 0x62: code = 0x9ee3; break;
 case 0x63: code = 0x9ee4; break;
 case 0x64: code = 0x9ee5; break;
 case 0x65: code = 0x9ee6; break;
 case 0x66: code = 0x9ee7; break;
 case 0x67: code = 0x9ee8; break;
 case 0x68: code = 0x9ee9; break;
 case 0x69: code = 0x9eea; break;
 case 0x6a: code = 0x9eeb; break;
 case 0x6b: code = 0x9eec; break;
 case 0x6c: code = 0x9eed; break;
 case 0x6d: code = 0x9eee; break;
 case 0x6e: code = 0x9eef; break;
 case 0x6f: code = 0x9ef0; break;
 case 0x70: code = 0x9ef1; break;
 case 0x71: code = 0x9ef2; break;
 case 0x72: code = 0x9ef3; break;
 case 0x73: code = 0x9ef4; break;
 case 0x74: code = 0x9ef5; break;
 case 0x75: code = 0x9ef6; break;
 case 0x76: code = 0x9ef7; break;
 case 0x77: code = 0x9ef8; break;
 case 0x78: code = 0x9ef9; break;
 case 0x79: code = 0x9efa; break;
 case 0x7a: code = 0x9efb; break;
 case 0x7b: code = 0x9efc; break;
 case 0x7c: code = 0x9efd; break;
 case 0x7d: code = 0x9efe; break;
 case 0x7e: code = 0x9f40; break;
 case 0x7f: code = 0x9f41; break;
 case 0x80: code = 0x9f42; break;
 case 0x81: code = 0x9f43; break;
 case 0x82: code = 0x9f44; break;
 case 0x83: code = 0x9f45; break;
 case 0x84: code = 0x9f46; break;
 case 0x85: code = 0x9f47; break;
 case 0x86: code = 0x9f48; break;
 case 0x87: code = 0x9f49; break;
 case 0x88: code = 0x9f4a; break;
 case 0x89: code = 0x9f4b; break;
 case 0x8a: code = 0x9f4c; break;
 case 0x8b: code = 0x9f4d; break;
 case 0x8c: code = 0x9f4e; break;
 case 0x8d: code = 0x9f4f; break;
 case 0x8e: code = 0x9f50; break;
 case 0x8f: code = 0x9f51; break;
 case 0x90: code = 0x9f52; break;
 case 0x91: code = 0x9f53; break;
 case 0x92: code = 0x9f54; break;
 case 0x93: code = 0x9f55; break;
 case 0x94: code = 0x9f56; break;
 case 0x95: code = 0x9f57; break;
 case 0x96: code = 0x9f58; break;
 case 0x97: code = 0x9f59; break;
 case 0x98: code = 0x9f5a; break;
 case 0x99: code = 0x9f5b; break;
 case 0x9a: code = 0x9f5c; break;
 case 0x9b: code = 0x9f5d; break;
 case 0x9c: code = 0x9f5e; break;
 case 0x9d: code = 0x9f5f; break;
 case 0x9e: code = 0x9f60; break;
 case 0x9f: code = 0x9f61; break;
 case 0xa0: code = 0x9f62; break;
 case 0xa1: code = 0x9f63; break;
 case 0xa2: code = 0x9f64; break;
 case 0xa3: code = 0x9f65; break;
 case 0xa4: code = 0x9f66; break;
 case 0xa5: code = 0x9f67; break;
 case 0xa6: code = 0x9f68; break;
 case 0xa7: code = 0x9f69; break;
 case 0xa8: code = 0x9f6a; break;
 case 0xa9: code = 0x9f6b; break;
 case 0xaa: code = 0x9f6c; break;
 case 0xab: code = 0x9f6d; break;
 case 0xac: code = 0x9f6e; break;
 case 0xad: code = 0x9f6f; break;
 case 0xae: code = 0x9f70; break;
 case 0xaf: code = 0x9f71; break;
 case 0xb0: code = 0x9f72; break;
 case 0xb1: code = 0x9f73; break;
 case 0xb2: code = 0x9f74; break;
 case 0xb3: code = 0x9f75; break;
 case 0xb4: code = 0x9f76; break;
 case 0xb5: code = 0x9f77; break;
 case 0xb6: code = 0x9f78; break;
 case 0xb7: code = 0x9f79; break;
 case 0xb8: code = 0x9f7a; break;
 case 0xb9: code = 0x9f7b; break;
 case 0xba: code = 0x9f7c; break;
 case 0xbb: code = 0x9f7d; break;
 case 0xbc: code = 0x9f7e; break;
 case 0xbd: code = 0x9fa1; break;
 case 0xbe: code = 0x9fa2; break;
 case 0xbf: code = 0x9fa3; break;
 case 0xc0: code = 0x9fa4; break;
 case 0xc1: code = 0x9fa5; break;
 case 0xc2: code = 0x9fa6; break;
 case 0xc3: code = 0x9fa7; break;
 case 0xc4: code = 0x9fa8; break;
 case 0xc5: code = 0x9fa9; break;
 case 0xc6: code = 0x9faa; break;
 case 0xc7: code = 0x9fab; break;
 case 0xc8: code = 0x9fac; break;
 case 0xc9: code = 0x9fad; break;
 case 0xca: code = 0x9fae; break;
 case 0xcb: code = 0x9faf; break;
 case 0xcc: code = 0x9fb0; break;
 case 0xcd: code = 0x9fb1; break;
 case 0xce: code = 0x9fb2; break;
 case 0xcf: code = 0x9fb3; break;
 case 0xd0: code = 0x9fb4; break;
 case 0xd1: code = 0x9fb5; break;
 case 0xd2: code = 0x9fb6; break;
 case 0xd3: code = 0x9fb7; break;
 case 0xd4: code = 0x9fb8; break;
 case 0xd5: code = 0x9fb9; break;
 case 0xd6: code = 0x9fba; break;
 case 0xd7: code = 0x9fbb; break;
 case 0xd8: code = 0x9fbc; break;
 case 0xd9: code = 0x9fbd; break;
 case 0xda: code = 0x9fbe; break;
 case 0xdb: code = 0x9fbf; break;
 case 0xdc: code = 0x9fc0; break;
 case 0xdd: code = 0x9fc1; break;
 case 0xde: code = 0x9fc2; break;
 case 0xdf: code = 0x9fc3; break;
 case 0xe0: code = 0x9fc4; break;
 case 0xe1: code = 0x9fc5; break;
 case 0xe2: code = 0x9fc6; break;
 case 0xe3: code = 0x9fc7; break;
 case 0xe4: code = 0x9fc8; break;
 case 0xe5: code = 0x9fc9; break;
 case 0xe6: code = 0x9fca; break;
 case 0xe7: code = 0x9fcb; break;
 case 0xe8: code = 0x9fcc; break;
 case 0xe9: code = 0x9fcd; break;
 case 0xea: code = 0x9fce; break;
 case 0xeb: code = 0x9fcf; break;
 case 0xec: code = 0x9fd0; break;
 case 0xed: code = 0x9fd1; break;
 case 0xee: code = 0x9fd2; break;
 case 0xef: code = 0x9fd3; break;
 case 0xf0: code = 0x9fd4; break;
 case 0xf1: code = 0x9fd5; break;
 case 0xf2: code = 0x9fd6; break;
 case 0xf3: code = 0x9fd7; break;
 case 0xf4: code = 0x9fd8; break;
 case 0xf5: code = 0x9fd9; break;
 case 0xf6: code = 0x9fda; break;
 case 0xf7: code = 0x9fdb; break;
 case 0xf8: code = 0x9fdc; break;
 case 0xf9: code = 0x9fdd; break;
 case 0xfa: code = 0x9fde; break;
 case 0xfb: code = 0x9fdf; break;
 case 0xfc: code = 0x9fe0; break;
 case 0xfd: code = 0x9fe1; break;
 case 0xfe: code = 0x9fe2; break;
 case 0xff: code = 0x9fe3; break;
    }
    break;
  case 0xee: switch(c1) {
 case 0x00: code = 0x9fe4; break;
 case 0x01: code = 0x9fe5; break;
 case 0x02: code = 0x9fe6; break;
 case 0x03: code = 0x9fe7; break;
 case 0x04: code = 0x9fe8; break;
 case 0x05: code = 0x9fe9; break;
 case 0x06: code = 0x9fea; break;
 case 0x07: code = 0x9feb; break;
 case 0x08: code = 0x9fec; break;
 case 0x09: code = 0x9fed; break;
 case 0x0a: code = 0x9fee; break;
 case 0x0b: code = 0x9fef; break;
 case 0x0c: code = 0x9ff0; break;
 case 0x0d: code = 0x9ff1; break;
 case 0x0e: code = 0x9ff2; break;
 case 0x0f: code = 0x9ff3; break;
 case 0x10: code = 0x9ff4; break;
 case 0x11: code = 0x9ff5; break;
 case 0x12: code = 0x9ff6; break;
 case 0x13: code = 0x9ff7; break;
 case 0x14: code = 0x9ff8; break;
 case 0x15: code = 0x9ff9; break;
 case 0x16: code = 0x9ffa; break;
 case 0x17: code = 0x9ffb; break;
 case 0x18: code = 0x9ffc; break;
 case 0x19: code = 0x9ffd; break;
 case 0x1a: code = 0x9ffe; break;
 case 0x1b: code = 0xa040; break;
 case 0x1c: code = 0xa041; break;
 case 0x1d: code = 0xa042; break;
 case 0x1e: code = 0xa043; break;
 case 0x1f: code = 0xa044; break;
 case 0x20: code = 0xa045; break;
 case 0x21: code = 0xa046; break;
 case 0x22: code = 0xa047; break;
 case 0x23: code = 0xa048; break;
 case 0x24: code = 0xa049; break;
 case 0x25: code = 0xa04a; break;
 case 0x26: code = 0xa04b; break;
 case 0x27: code = 0xa04c; break;
 case 0x28: code = 0xa04d; break;
 case 0x29: code = 0xa04e; break;
 case 0x2a: code = 0xa04f; break;
 case 0x2b: code = 0xa050; break;
 case 0x2c: code = 0xa051; break;
 case 0x2d: code = 0xa052; break;
 case 0x2e: code = 0xa053; break;
 case 0x2f: code = 0xa054; break;
 case 0x30: code = 0xa055; break;
 case 0x31: code = 0xa056; break;
 case 0x32: code = 0xa057; break;
 case 0x33: code = 0xa058; break;
 case 0x34: code = 0xa059; break;
 case 0x35: code = 0xa05a; break;
 case 0x36: code = 0xa05b; break;
 case 0x37: code = 0xa05c; break;
 case 0x38: code = 0xa05d; break;
 case 0x39: code = 0xa05e; break;
 case 0x3a: code = 0xa05f; break;
 case 0x3b: code = 0xa060; break;
 case 0x3c: code = 0xa061; break;
 case 0x3d: code = 0xa062; break;
 case 0x3e: code = 0xa063; break;
 case 0x3f: code = 0xa064; break;
 case 0x40: code = 0xa065; break;
 case 0x41: code = 0xa066; break;
 case 0x42: code = 0xa067; break;
 case 0x43: code = 0xa068; break;
 case 0x44: code = 0xa069; break;
 case 0x45: code = 0xa06a; break;
 case 0x46: code = 0xa06b; break;
 case 0x47: code = 0xa06c; break;
 case 0x48: code = 0xa06d; break;
 case 0x49: code = 0xa06e; break;
 case 0x4a: code = 0xa06f; break;
 case 0x4b: code = 0xa070; break;
 case 0x4c: code = 0xa071; break;
 case 0x4d: code = 0xa072; break;
 case 0x4e: code = 0xa073; break;
 case 0x4f: code = 0xa074; break;
 case 0x50: code = 0xa075; break;
 case 0x51: code = 0xa076; break;
 case 0x52: code = 0xa077; break;
 case 0x53: code = 0xa078; break;
 case 0x54: code = 0xa079; break;
 case 0x55: code = 0xa07a; break;
 case 0x56: code = 0xa07b; break;
 case 0x57: code = 0xa07c; break;
 case 0x58: code = 0xa07d; break;
 case 0x59: code = 0xa07e; break;
 case 0x5a: code = 0xa0a1; break;
 case 0x5b: code = 0xa0a2; break;
 case 0x5c: code = 0xa0a3; break;
 case 0x5d: code = 0xa0a4; break;
 case 0x5e: code = 0xa0a5; break;
 case 0x5f: code = 0xa0a6; break;
 case 0x60: code = 0xa0a7; break;
 case 0x61: code = 0xa0a8; break;
 case 0x62: code = 0xa0a9; break;
 case 0x63: code = 0xa0aa; break;
 case 0x64: code = 0xa0ab; break;
 case 0x65: code = 0xa0ac; break;
 case 0x66: code = 0xa0ad; break;
 case 0x67: code = 0xa0ae; break;
 case 0x68: code = 0xa0af; break;
 case 0x69: code = 0xa0b0; break;
 case 0x6a: code = 0xa0b1; break;
 case 0x6b: code = 0xa0b2; break;
 case 0x6c: code = 0xa0b3; break;
 case 0x6d: code = 0xa0b4; break;
 case 0x6e: code = 0xa0b5; break;
 case 0x6f: code = 0xa0b6; break;
 case 0x70: code = 0xa0b7; break;
 case 0x71: code = 0xa0b8; break;
 case 0x72: code = 0xa0b9; break;
 case 0x73: code = 0xa0ba; break;
 case 0x74: code = 0xa0bb; break;
 case 0x75: code = 0xa0bc; break;
 case 0x76: code = 0xa0bd; break;
 case 0x77: code = 0xa0be; break;
 case 0x78: code = 0xa0bf; break;
 case 0x79: code = 0xa0c0; break;
 case 0x7a: code = 0xa0c1; break;
 case 0x7b: code = 0xa0c2; break;
 case 0x7c: code = 0xa0c3; break;
 case 0x7d: code = 0xa0c4; break;
 case 0x7e: code = 0xa0c5; break;
 case 0x7f: code = 0xa0c6; break;
 case 0x80: code = 0xa0c7; break;
 case 0x81: code = 0xa0c8; break;
 case 0x82: code = 0xa0c9; break;
 case 0x83: code = 0xa0ca; break;
 case 0x84: code = 0xa0cb; break;
 case 0x85: code = 0xa0cc; break;
 case 0x86: code = 0xa0cd; break;
 case 0x87: code = 0xa0ce; break;
 case 0x88: code = 0xa0cf; break;
 case 0x89: code = 0xa0d0; break;
 case 0x8a: code = 0xa0d1; break;
 case 0x8b: code = 0xa0d2; break;
 case 0x8c: code = 0xa0d3; break;
 case 0x8d: code = 0xa0d4; break;
 case 0x8e: code = 0xa0d5; break;
 case 0x8f: code = 0xa0d6; break;
 case 0x90: code = 0xa0d7; break;
 case 0x91: code = 0xa0d8; break;
 case 0x92: code = 0xa0d9; break;
 case 0x93: code = 0xa0da; break;
 case 0x94: code = 0xa0db; break;
 case 0x95: code = 0xa0dc; break;
 case 0x96: code = 0xa0dd; break;
 case 0x97: code = 0xa0de; break;
 case 0x98: code = 0xa0df; break;
 case 0x99: code = 0xa0e0; break;
 case 0x9a: code = 0xa0e1; break;
 case 0x9b: code = 0xa0e2; break;
 case 0x9c: code = 0xa0e3; break;
 case 0x9d: code = 0xa0e4; break;
 case 0x9e: code = 0xa0e5; break;
 case 0x9f: code = 0xa0e6; break;
 case 0xa0: code = 0xa0e7; break;
 case 0xa1: code = 0xa0e8; break;
 case 0xa2: code = 0xa0e9; break;
 case 0xa3: code = 0xa0ea; break;
 case 0xa4: code = 0xa0eb; break;
 case 0xa5: code = 0xa0ec; break;
 case 0xa6: code = 0xa0ed; break;
 case 0xa7: code = 0xa0ee; break;
 case 0xa8: code = 0xa0ef; break;
 case 0xa9: code = 0xa0f0; break;
 case 0xaa: code = 0xa0f1; break;
 case 0xab: code = 0xa0f2; break;
 case 0xac: code = 0xa0f3; break;
 case 0xad: code = 0xa0f4; break;
 case 0xae: code = 0xa0f5; break;
 case 0xaf: code = 0xa0f6; break;
 case 0xb0: code = 0xa0f7; break;
 case 0xb1: code = 0xa0f8; break;
 case 0xb2: code = 0xa0f9; break;
 case 0xb3: code = 0xa0fa; break;
 case 0xb4: code = 0xa0fb; break;
 case 0xb5: code = 0xa0fc; break;
 case 0xb6: code = 0xa0fd; break;
 case 0xb7: code = 0xa0fe; break;
    }
    break;
  case 0xf3: switch(c1) {
 case 0x03: code = 0x8840; break;
 case 0x04: code = 0x8841; break;
 case 0x05: code = 0x8842; break;
 case 0x06: code = 0x8843; break;
 case 0x07: code = 0x8844; break;
 case 0x08: code = 0x8845; break;
 case 0x09: code = 0x8846; break;
 case 0x0a: code = 0x8847; break;
 case 0x0b: code = 0x8848; break;
 case 0x0c: code = 0x8849; break;
 case 0x0d: code = 0x884a; break;
 case 0x0e: code = 0x884b; break;
 case 0x0f: code = 0x884c; break;
 case 0x10: code = 0x884d; break;
 case 0x11: code = 0x884e; break;
 case 0x12: code = 0x884f; break;
 case 0x13: code = 0x8850; break;
 case 0x14: code = 0x8851; break;
 case 0x15: code = 0x8852; break;
 case 0x16: code = 0x8853; break;
 case 0x17: code = 0x8854; break;
 case 0x18: code = 0x8855; break;
 case 0x19: code = 0x8856; break;
 case 0x1a: code = 0x8857; break;
 case 0x1b: code = 0x8858; break;
 case 0x1c: code = 0x8859; break;
 case 0x1d: code = 0x885a; break;
 case 0x1e: code = 0x885b; break;
 case 0x1f: code = 0x885c; break;
 case 0x20: code = 0x885d; break;
 case 0x21: code = 0x885e; break;
 case 0x22: code = 0x885f; break;
 case 0x23: code = 0x8860; break;
 case 0x24: code = 0x8861; break;
 case 0x25: code = 0x8862; break;
 case 0x26: code = 0x8863; break;
 case 0x27: code = 0x8864; break;
 case 0x28: code = 0x8865; break;
 case 0x29: code = 0x8866; break;
 case 0x2a: code = 0x8867; break;
 case 0x2b: code = 0x8868; break;
 case 0x2c: code = 0x8869; break;
 case 0x2d: code = 0x886a; break;
 case 0x2e: code = 0x886b; break;
 case 0x2f: code = 0x886c; break;
 case 0x30: code = 0x886d; break;
 case 0x31: code = 0x886e; break;
 case 0x32: code = 0x886f; break;
 case 0x33: code = 0x8870; break;
 case 0x34: code = 0x8871; break;
 case 0x35: code = 0x8872; break;
 case 0x36: code = 0x8873; break;
 case 0x37: code = 0x8874; break;
 case 0x38: code = 0x8875; break;
 case 0x39: code = 0x8876; break;
 case 0x3a: code = 0x8877; break;
 case 0x3b: code = 0x8878; break;
 case 0x3c: code = 0x8879; break;
 case 0x3d: code = 0x887a; break;
 case 0x3e: code = 0x887b; break;
 case 0x3f: code = 0x887c; break;
 case 0x40: code = 0x887d; break;
 case 0x41: code = 0x887e; break;
 case 0x42: code = 0x88a1; break;
 case 0x43: code = 0x88a2; break;
 case 0x44: code = 0x88a3; break;
 case 0x45: code = 0x88a4; break;
 case 0x46: code = 0x88a5; break;
 case 0x47: code = 0x88a6; break;
 case 0x48: code = 0x88a7; break;
 case 0x49: code = 0x88a8; break;
 case 0x4a: code = 0x88a9; break;
 case 0x4b: code = 0x88aa; break;
 case 0xa0: code = 0x8940; break;
 case 0xa1: code = 0x8941; break;
 case 0xa3: code = 0x8943; break;
 case 0xa6: code = 0x8946; break;
 case 0xa7: code = 0x8947; break;
 case 0xa8: code = 0x8948; break;
 case 0xa9: code = 0x8949; break;
 case 0xac: code = 0x894c; break;
 case 0xad: code = 0x894d; break;
 case 0xae: code = 0x894e; break;
 case 0xaf: code = 0x894f; break;
 case 0xb0: code = 0x8950; break;
 case 0xb1: code = 0x8951; break;
 case 0xb2: code = 0x8952; break;
 case 0xb3: code = 0x8953; break;
 case 0xb4: code = 0x8954; break;
 case 0xb5: code = 0x8955; break;
 case 0xb6: code = 0x8956; break;
 case 0xb7: code = 0x8957; break;
 case 0xb8: code = 0x8958; break;
 case 0xb9: code = 0x8959; break;
 case 0xba: code = 0x895a; break;
 case 0xbb: code = 0x895b; break;
 case 0xbc: code = 0x895c; break;
 case 0xbd: code = 0x895d; break;
 case 0xbe: code = 0x895e; break;
 case 0xbf: code = 0x895f; break;
 case 0xc0: code = 0x8960; break;
 case 0xc1: code = 0x8961; break;
 case 0xc2: code = 0x8962; break;
 case 0xc3: code = 0x8963; break;
 case 0xc4: code = 0x8964; break;
 case 0xc5: code = 0x8965; break;
 case 0xc6: code = 0x8966; break;
 case 0xc7: code = 0x8967; break;
 case 0xc8: code = 0x8968; break;
 case 0xc9: code = 0x8969; break;
 case 0xca: code = 0x896a; break;
 case 0xcb: code = 0x896b; break;
 case 0xcc: code = 0x896c; break;
 case 0xcd: code = 0x896d; break;
 case 0xce: code = 0x896e; break;
 case 0xcf: code = 0x896f; break;
 case 0xd0: code = 0x8970; break;
 case 0xd1: code = 0x8971; break;
 case 0xd2: code = 0x8972; break;
 case 0xd3: code = 0x8973; break;
 case 0xd4: code = 0x8974; break;
 case 0xd5: code = 0x8975; break;
 case 0xd6: code = 0x8976; break;
 case 0xd7: code = 0x8977; break;
 case 0xd8: code = 0x8978; break;
 case 0xd9: code = 0x8979; break;
 case 0xda: code = 0x897a; break;
 case 0xdb: code = 0x897b; break;
 case 0xdc: code = 0x897c; break;
 case 0xdd: code = 0x897d; break;
 case 0xde: code = 0x897e; break;
 case 0xdf: code = 0x89a1; break;
 case 0xe0: code = 0x89a2; break;
 case 0xe1: code = 0x89a3; break;
 case 0xe2: code = 0x89a4; break;
 case 0xe3: code = 0x89a5; break;
 case 0xe4: code = 0x89a6; break;
 case 0xe9: code = 0x89ab; break;
 case 0xea: code = 0x89ac; break;
 case 0xeb: code = 0x89ad; break;
 case 0xec: code = 0x89ae; break;
 case 0xee: code = 0x89b0; break;
 case 0xef: code = 0x89b1; break;
 case 0xf0: code = 0x89b2; break;
 case 0xf3: code = 0x89b5; break;
 case 0xf4: code = 0x89b6; break;
 case 0xf5: code = 0x89b7; break;
 case 0xf6: code = 0x89b8; break;
 case 0xf7: code = 0x89b9; break;
 case 0xf8: code = 0x89ba; break;
 case 0xf9: code = 0x89bb; break;
 case 0xfa: code = 0x89bc; break;
 case 0xfb: code = 0x89bd; break;
 case 0xfc: code = 0x89be; break;
 case 0xfd: code = 0x89bf; break;
 case 0xff: code = 0x89c1; break;
    }
    break;
  case 0xf4: switch(c1) {
 case 0x00: code = 0x89c2; break;
 case 0x01: code = 0x89c3; break;
 case 0x03: code = 0x89c5; break;
 case 0x04: code = 0x89c6; break;
 case 0x05: code = 0x89c7; break;
 case 0x06: code = 0x89c8; break;
 case 0x07: code = 0x89c9; break;
 case 0x08: code = 0x89ca; break;
 case 0x09: code = 0x89cb; break;
 case 0x0a: code = 0x89cc; break;
 case 0x0b: code = 0x89cd; break;
 case 0x0c: code = 0x89ce; break;
 case 0x0d: code = 0x89cf; break;
 case 0x0e: code = 0x89d0; break;
 case 0x0f: code = 0x89d1; break;
 case 0x10: code = 0x89d2; break;
 case 0x11: code = 0x89d3; break;
 case 0x12: code = 0x89d4; break;
 case 0x13: code = 0x89d5; break;
 case 0x14: code = 0x89d6; break;
 case 0x15: code = 0x89d7; break;
 case 0x16: code = 0x89d8; break;
 case 0x17: code = 0x89d9; break;
 case 0x18: code = 0x89da; break;
 case 0x19: code = 0x89db; break;
 case 0x1a: code = 0x89dc; break;
 case 0x1b: code = 0x89dd; break;
 case 0x1c: code = 0x89de; break;
 case 0x1d: code = 0x89df; break;
 case 0x1e: code = 0x89e0; break;
 case 0x1f: code = 0x89e1; break;
 case 0x20: code = 0x89e2; break;
 case 0x21: code = 0x89e3; break;
 case 0x22: code = 0x89e4; break;
 case 0x23: code = 0x89e5; break;
 case 0x24: code = 0x89e6; break;
 case 0x25: code = 0x89e7; break;
 case 0x26: code = 0x89e8; break;
 case 0x27: code = 0x89e9; break;
 case 0x28: code = 0x89ea; break;
 case 0x29: code = 0x89eb; break;
 case 0x2a: code = 0x89ec; break;
 case 0x2b: code = 0x89ed; break;
 case 0x2c: code = 0x89ee; break;
 case 0x2d: code = 0x89ef; break;
 case 0x2e: code = 0x89f0; break;
 case 0x2f: code = 0x89f1; break;
 case 0x30: code = 0x89f2; break;
 case 0x31: code = 0x89f3; break;
 case 0x32: code = 0x89f4; break;
 case 0x33: code = 0x89f5; break;
 case 0x34: code = 0x89f6; break;
 case 0x35: code = 0x89f7; break;
 case 0x36: code = 0x89f8; break;
 case 0x37: code = 0x89f9; break;
 case 0x38: code = 0x89fa; break;
 case 0x39: code = 0x89fb; break;
 case 0x3a: code = 0x89fc; break;
 case 0x3b: code = 0x89fd; break;
 case 0x3c: code = 0x89fe; break;
 case 0x3d: code = 0x8a40; break;
 case 0x3e: code = 0x8a41; break;
 case 0x40: code = 0x8a43; break;
 case 0x41: code = 0x8a44; break;
 case 0x42: code = 0x8a45; break;
 case 0x43: code = 0x8a46; break;
 case 0x44: code = 0x8a47; break;
 case 0x45: code = 0x8a48; break;
 case 0x46: code = 0x8a49; break;
 case 0x47: code = 0x8a4a; break;
 case 0x48: code = 0x8a4b; break;
 case 0x49: code = 0x8a4c; break;
 case 0x4a: code = 0x8a4d; break;
 case 0x4b: code = 0x8a4e; break;
 case 0x4c: code = 0x8a4f; break;
 case 0x4d: code = 0x8a50; break;
 case 0x4e: code = 0x8a51; break;
 case 0x4f: code = 0x8a52; break;
 case 0x50: code = 0x8a53; break;
 case 0x51: code = 0x8a54; break;
 case 0x52: code = 0x8a55; break;
 case 0x53: code = 0x8a56; break;
 case 0x54: code = 0x8a57; break;
 case 0x55: code = 0x8a58; break;
 case 0x56: code = 0x8a59; break;
 case 0x57: code = 0x8a5a; break;
 case 0x58: code = 0x8a5b; break;
 case 0x59: code = 0x8a5c; break;
 case 0x5a: code = 0x8a5d; break;
 case 0x5b: code = 0x8a5e; break;
 case 0x5c: code = 0x8a5f; break;
 case 0x5d: code = 0x8a60; break;
 case 0x5e: code = 0x8a61; break;
 case 0x5f: code = 0x8a62; break;
 case 0x61: code = 0x8a64; break;
 case 0x62: code = 0x8a65; break;
 case 0x63: code = 0x8a66; break;
 case 0x64: code = 0x8a67; break;
 case 0x65: code = 0x8a68; break;
 case 0x66: code = 0x8a69; break;
 case 0x67: code = 0x8a6a; break;
 case 0x68: code = 0x8a6b; break;
 case 0x69: code = 0x8a6c; break;
 case 0x6a: code = 0x8a6d; break;
 case 0x6b: code = 0x8a6e; break;
 case 0x6c: code = 0x8a6f; break;
 case 0x6d: code = 0x8a70; break;
 case 0x6e: code = 0x8a71; break;
 case 0x6f: code = 0x8a72; break;
 case 0x70: code = 0x8a73; break;
 case 0x71: code = 0x8a74; break;
 case 0x73: code = 0x8a76; break;
 case 0x74: code = 0x8a77; break;
 case 0x75: code = 0x8a78; break;
 case 0x76: code = 0x8a79; break;
 case 0x77: code = 0x8a7a; break;
 case 0x78: code = 0x8a7b; break;
 case 0x79: code = 0x8a7c; break;
 case 0x7a: code = 0x8a7d; break;
 case 0x7b: code = 0x8a7e; break;
 case 0x7c: code = 0x8aa1; break;
 case 0x7d: code = 0x8aa2; break;
 case 0x7e: code = 0x8aa3; break;
 case 0x7f: code = 0x8aa4; break;
 case 0x80: code = 0x8aa5; break;
 case 0x81: code = 0x8aa6; break;
 case 0x82: code = 0x8aa7; break;
 case 0x83: code = 0x8aa8; break;
 case 0x84: code = 0x8aa9; break;
 case 0x85: code = 0x8aaa; break;
 case 0x87: code = 0x8aac; break;
 case 0x88: code = 0x8aad; break;
 case 0x89: code = 0x8aae; break;
 case 0x8a: code = 0x8aaf; break;
 case 0x8b: code = 0x8ab0; break;
 case 0x8d: code = 0x8ab2; break;
 case 0x8e: code = 0x8ab3; break;
 case 0x8f: code = 0x8ab4; break;
 case 0x90: code = 0x8ab5; break;
 case 0x91: code = 0x8ab6; break;
 case 0x92: code = 0x8ab7; break;
 case 0x93: code = 0x8ab8; break;
 case 0x94: code = 0x8ab9; break;
 case 0x96: code = 0x8abb; break;
 case 0x97: code = 0x8abc; break;
 case 0x98: code = 0x8abd; break;
 case 0x99: code = 0x8abe; break;
 case 0x9a: code = 0x8abf; break;
 case 0x9b: code = 0x8ac0; break;
 case 0x9c: code = 0x8ac1; break;
 case 0x9d: code = 0x8ac2; break;
 case 0x9e: code = 0x8ac3; break;
 case 0x9f: code = 0x8ac4; break;
 case 0xa0: code = 0x8ac5; break;
 case 0xa1: code = 0x8ac6; break;
 case 0xa2: code = 0x8ac7; break;
 case 0xa4: code = 0x8ac9; break;
 case 0xa5: code = 0x8aca; break;
 case 0xa6: code = 0x8acb; break;
 case 0xa7: code = 0x8acc; break;
 case 0xa9: code = 0x8ace; break;
 case 0xaa: code = 0x8acf; break;
 case 0xab: code = 0x8ad0; break;
 case 0xac: code = 0x8ad1; break;
 case 0xad: code = 0x8ad2; break;
 case 0xae: code = 0x8ad3; break;
 case 0xaf: code = 0x8ad4; break;
 case 0xb0: code = 0x8ad5; break;
 case 0xb1: code = 0x8ad6; break;
 case 0xb2: code = 0x8ad7; break;
 case 0xb3: code = 0x8ad8; break;
 case 0xb4: code = 0x8ad9; break;
 case 0xb5: code = 0x8ada; break;
 case 0xb6: code = 0x8adb; break;
 case 0xb7: code = 0x8adc; break;
 case 0xba: code = 0x8adf; break;
 case 0xbb: code = 0x8ae0; break;
 case 0xbc: code = 0x8ae1; break;
 case 0xbd: code = 0x8ae2; break;
 case 0xbe: code = 0x8ae3; break;
 case 0xbf: code = 0x8ae4; break;
 case 0xc0: code = 0x8ae5; break;
 case 0xc1: code = 0x8ae6; break;
 case 0xc2: code = 0x8ae7; break;
 case 0xc3: code = 0x8ae8; break;
 case 0xc4: code = 0x8ae9; break;
 case 0xc5: code = 0x8aea; break;
 case 0xc6: code = 0x8aeb; break;
 case 0xc7: code = 0x8aec; break;
 case 0xc8: code = 0x8aed; break;
 case 0xc9: code = 0x8aee; break;
 case 0xca: code = 0x8aef; break;
 case 0xcb: code = 0x8af0; break;
 case 0xcc: code = 0x8af1; break;
 case 0xcd: code = 0x8af2; break;
 case 0xce: code = 0x8af3; break;
 case 0xcf: code = 0x8af4; break;
 case 0xd1: code = 0x8af6; break;
 case 0xd2: code = 0x8af7; break;
 case 0xd3: code = 0x8af8; break;
 case 0xd4: code = 0x8af9; break;
 case 0xd5: code = 0x8afa; break;
 case 0xd6: code = 0x8afb; break;
 case 0xd7: code = 0x8afc; break;
 case 0xd8: code = 0x8afd; break;
 case 0xd9: code = 0x8afe; break;
 case 0xda: code = 0x8b40; break;
 case 0xdb: code = 0x8b41; break;
 case 0xdc: code = 0x8b42; break;
 case 0xdd: code = 0x8b43; break;
 case 0xde: code = 0x8b44; break;
 case 0xdf: code = 0x8b45; break;
 case 0xe0: code = 0x8b46; break;
 case 0xe1: code = 0x8b47; break;
 case 0xe2: code = 0x8b48; break;
 case 0xe3: code = 0x8b49; break;
 case 0xe4: code = 0x8b4a; break;
 case 0xe5: code = 0x8b4b; break;
 case 0xe6: code = 0x8b4c; break;
 case 0xe7: code = 0x8b4d; break;
 case 0xe8: code = 0x8b4e; break;
 case 0xe9: code = 0x8b4f; break;
 case 0xea: code = 0x8b50; break;
 case 0xeb: code = 0x8b51; break;
 case 0xec: code = 0x8b52; break;
 case 0xed: code = 0x8b53; break;
 case 0xef: code = 0x8b55; break;
 case 0xf0: code = 0x8b56; break;
 case 0xf1: code = 0x8b57; break;
 case 0xf2: code = 0x8b58; break;
 case 0xf3: code = 0x8b59; break;
 case 0xf4: code = 0x8b5a; break;
 case 0xf5: code = 0x8b5b; break;
 case 0xf6: code = 0x8b5c; break;
 case 0xf7: code = 0x8b5d; break;
 case 0xf8: code = 0x8b5e; break;
 case 0xf9: code = 0x8b5f; break;
 case 0xfa: code = 0x8b60; break;
 case 0xfb: code = 0x8b61; break;
 case 0xfc: code = 0x8b62; break;
 case 0xfd: code = 0x8b63; break;
 case 0xfe: code = 0x8b64; break;
 case 0xff: code = 0x8b65; break;
    }
    break;
  case 0xf5: switch(c1) {
 case 0x00: code = 0x8b66; break;
 case 0x01: code = 0x8b67; break;
 case 0x02: code = 0x8b68; break;
 case 0x03: code = 0x8b69; break;
 case 0x04: code = 0x8b6a; break;
 case 0x05: code = 0x8b6b; break;
 case 0x06: code = 0x8b6c; break;
 case 0x07: code = 0x8b6d; break;
 case 0x08: code = 0x8b6e; break;
 case 0x09: code = 0x8b6f; break;
 case 0x0a: code = 0x8b70; break;
 case 0x0b: code = 0x8b71; break;
 case 0x0c: code = 0x8b72; break;
 case 0x0d: code = 0x8b73; break;
 case 0x0e: code = 0x8b74; break;
 case 0x0f: code = 0x8b75; break;
 case 0x10: code = 0x8b76; break;
 case 0x11: code = 0x8b77; break;
 case 0x12: code = 0x8b78; break;
 case 0x13: code = 0x8b79; break;
 case 0x14: code = 0x8b7a; break;
 case 0x15: code = 0x8b7b; break;
 case 0x16: code = 0x8b7c; break;
 case 0x17: code = 0x8b7d; break;
 case 0x18: code = 0x8b7e; break;
 case 0x19: code = 0x8ba1; break;
 case 0x1a: code = 0x8ba2; break;
 case 0x1b: code = 0x8ba3; break;
 case 0x1c: code = 0x8ba4; break;
 case 0x1d: code = 0x8ba5; break;
 case 0x1e: code = 0x8ba6; break;
 case 0x1f: code = 0x8ba7; break;
 case 0x20: code = 0x8ba8; break;
 case 0x21: code = 0x8ba9; break;
 case 0x22: code = 0x8baa; break;
 case 0x23: code = 0x8bab; break;
 case 0x24: code = 0x8bac; break;
 case 0x25: code = 0x8bad; break;
 case 0x26: code = 0x8bae; break;
 case 0x27: code = 0x8baf; break;
 case 0x28: code = 0x8bb0; break;
 case 0x29: code = 0x8bb1; break;
 case 0x2a: code = 0x8bb2; break;
 case 0x2b: code = 0x8bb3; break;
 case 0x2c: code = 0x8bb4; break;
 case 0x2d: code = 0x8bb5; break;
 case 0x2e: code = 0x8bb6; break;
 case 0x2f: code = 0x8bb7; break;
 case 0x30: code = 0x8bb8; break;
 case 0x31: code = 0x8bb9; break;
 case 0x32: code = 0x8bba; break;
 case 0x33: code = 0x8bbb; break;
 case 0x34: code = 0x8bbc; break;
 case 0x35: code = 0x8bbd; break;
 case 0x36: code = 0x8bbe; break;
 case 0x37: code = 0x8bbf; break;
 case 0x38: code = 0x8bc0; break;
 case 0x39: code = 0x8bc1; break;
 case 0x3a: code = 0x8bc2; break;
 case 0x3b: code = 0x8bc3; break;
 case 0x3c: code = 0x8bc4; break;
 case 0x3d: code = 0x8bc5; break;
 case 0x3e: code = 0x8bc6; break;
 case 0x3f: code = 0x8bc7; break;
 case 0x40: code = 0x8bc8; break;
 case 0x41: code = 0x8bc9; break;
 case 0x42: code = 0x8bca; break;
 case 0x43: code = 0x8bcb; break;
 case 0x44: code = 0x8bcc; break;
 case 0x45: code = 0x8bcd; break;
 case 0x46: code = 0x8bce; break;
 case 0x47: code = 0x8bcf; break;
 case 0x48: code = 0x8bd0; break;
 case 0x49: code = 0x8bd1; break;
 case 0x4a: code = 0x8bd2; break;
 case 0x4b: code = 0x8bd3; break;
 case 0x4c: code = 0x8bd4; break;
 case 0x4d: code = 0x8bd5; break;
 case 0x4e: code = 0x8bd6; break;
 case 0x4f: code = 0x8bd7; break;
 case 0x50: code = 0x8bd8; break;
 case 0x51: code = 0x8bd9; break;
 case 0x52: code = 0x8bda; break;
 case 0x53: code = 0x8bdb; break;
 case 0x54: code = 0x8bdc; break;
 case 0x56: code = 0x8bde; break;
 case 0x57: code = 0x8bdf; break;
 case 0x58: code = 0x8be0; break;
 case 0x59: code = 0x8be1; break;
 case 0x5a: code = 0x8be2; break;
 case 0x5b: code = 0x8be3; break;
 case 0x5c: code = 0x8be4; break;
 case 0x5d: code = 0x8be5; break;
 case 0x5e: code = 0x8be6; break;
 case 0x5f: code = 0x8be7; break;
 case 0x60: code = 0x8be8; break;
 case 0x61: code = 0x8be9; break;
 case 0x62: code = 0x8bea; break;
 case 0x63: code = 0x8beb; break;
 case 0x64: code = 0x8bec; break;
 case 0x65: code = 0x8bed; break;
 case 0x66: code = 0x8bee; break;
 case 0x67: code = 0x8bef; break;
 case 0x68: code = 0x8bf0; break;
 case 0x69: code = 0x8bf1; break;
 case 0x6a: code = 0x8bf2; break;
 case 0x6b: code = 0x8bf3; break;
 case 0x6c: code = 0x8bf4; break;
 case 0x6d: code = 0x8bf5; break;
 case 0x6e: code = 0x8bf6; break;
 case 0x6f: code = 0x8bf7; break;
 case 0x70: code = 0x8bf8; break;
 case 0x71: code = 0x8bf9; break;
 case 0x72: code = 0x8bfa; break;
 case 0x73: code = 0x8bfb; break;
 case 0x74: code = 0x8bfc; break;
 case 0x75: code = 0x8bfd; break;
 case 0x77: code = 0x8c40; break;
 case 0x78: code = 0x8c41; break;
 case 0x79: code = 0x8c42; break;
 case 0x7a: code = 0x8c43; break;
 case 0x7b: code = 0x8c44; break;
 case 0x7c: code = 0x8c45; break;
 case 0x7d: code = 0x8c46; break;
 case 0x7e: code = 0x8c47; break;
 case 0x7f: code = 0x8c48; break;
 case 0x80: code = 0x8c49; break;
 case 0x81: code = 0x8c4a; break;
 case 0x82: code = 0x8c4b; break;
 case 0x83: code = 0x8c4c; break;
 case 0x84: code = 0x8c4d; break;
 case 0x85: code = 0x8c4e; break;
 case 0x86: code = 0x8c4f; break;
 case 0x87: code = 0x8c50; break;
 case 0x88: code = 0x8c51; break;
 case 0x89: code = 0x8c52; break;
 case 0x8a: code = 0x8c53; break;
 case 0x8b: code = 0x8c54; break;
 case 0x8c: code = 0x8c55; break;
 case 0x8d: code = 0x8c56; break;
 case 0x8e: code = 0x8c57; break;
 case 0x8f: code = 0x8c58; break;
 case 0x90: code = 0x8c59; break;
 case 0x91: code = 0x8c5a; break;
 case 0x92: code = 0x8c5b; break;
 case 0x93: code = 0x8c5c; break;
 case 0x94: code = 0x8c5d; break;
 case 0x95: code = 0x8c5e; break;
 case 0x96: code = 0x8c5f; break;
 case 0x97: code = 0x8c60; break;
 case 0x98: code = 0x8c61; break;
 case 0x9a: code = 0x8c63; break;
 case 0x9b: code = 0x8c64; break;
 case 0x9c: code = 0x8c65; break;
 case 0x9d: code = 0x8c66; break;
 case 0x9e: code = 0x8c67; break;
 case 0x9f: code = 0x8c68; break;
 case 0xa0: code = 0x8c69; break;
 case 0xa1: code = 0x8c6a; break;
 case 0xa2: code = 0x8c6b; break;
 case 0xa3: code = 0x8c6c; break;
 case 0xa4: code = 0x8c6d; break;
 case 0xa5: code = 0x8c6e; break;
 case 0xa6: code = 0x8c6f; break;
 case 0xa7: code = 0x8c70; break;
 case 0xa8: code = 0x8c71; break;
 case 0xa9: code = 0x8c72; break;
 case 0xaa: code = 0x8c73; break;
 case 0xab: code = 0x8c74; break;
 case 0xac: code = 0x8c75; break;
 case 0xad: code = 0x8c76; break;
 case 0xae: code = 0x8c77; break;
 case 0xaf: code = 0x8c78; break;
 case 0xb0: code = 0x8c79; break;
 case 0xb1: code = 0x8c7a; break;
 case 0xb2: code = 0x8c7b; break;
 case 0xb3: code = 0x8c7c; break;
 case 0xb4: code = 0x8c7d; break;
 case 0xb5: code = 0x8c7e; break;
 case 0xb6: code = 0x8ca1; break;
 case 0xb7: code = 0x8ca2; break;
 case 0xb8: code = 0x8ca3; break;
 case 0xb9: code = 0x8ca4; break;
 case 0xba: code = 0x8ca5; break;
 case 0xbc: code = 0x8ca7; break;
 case 0xbd: code = 0x8ca8; break;
 case 0xbe: code = 0x8ca9; break;
 case 0xbf: code = 0x8caa; break;
 case 0xc0: code = 0x8cab; break;
 case 0xc1: code = 0x8cac; break;
 case 0xc2: code = 0x8cad; break;
 case 0xc3: code = 0x8cae; break;
 case 0xc4: code = 0x8caf; break;
 case 0xc5: code = 0x8cb0; break;
 case 0xc6: code = 0x8cb1; break;
 case 0xc7: code = 0x8cb2; break;
 case 0xc8: code = 0x8cb3; break;
 case 0xc9: code = 0x8cb4; break;
 case 0xca: code = 0x8cb5; break;
 case 0xcb: code = 0x8cb6; break;
 case 0xcc: code = 0x8cb7; break;
 case 0xcd: code = 0x8cb8; break;
 case 0xce: code = 0x8cb9; break;
 case 0xcf: code = 0x8cba; break;
 case 0xd0: code = 0x8cbb; break;
 case 0xd1: code = 0x8cbc; break;
 case 0xd2: code = 0x8cbd; break;
 case 0xd3: code = 0x8cbe; break;
 case 0xd4: code = 0x8cbf; break;
 case 0xd5: code = 0x8cc0; break;
 case 0xd6: code = 0x8cc1; break;
 case 0xd7: code = 0x8cc2; break;
 case 0xd8: code = 0x8cc3; break;
 case 0xd9: code = 0x8cc4; break;
 case 0xda: code = 0x8cc5; break;
 case 0xde: code = 0x8cc9; break;
 case 0xdf: code = 0x8cca; break;
 case 0xe0: code = 0x8ccb; break;
 case 0xe1: code = 0x8ccc; break;
 case 0xe3: code = 0x8cce; break;
 case 0xe4: code = 0x8ccf; break;
 case 0xe5: code = 0x8cd0; break;
 case 0xe6: code = 0x8cd1; break;
 case 0xe7: code = 0x8cd2; break;
 case 0xe8: code = 0x8cd3; break;
 case 0xe9: code = 0x8cd4; break;
 case 0xea: code = 0x8cd5; break;
 case 0xeb: code = 0x8cd6; break;
 case 0xec: code = 0x8cd7; break;
 case 0xed: code = 0x8cd8; break;
 case 0xee: code = 0x8cd9; break;
 case 0xef: code = 0x8cda; break;
 case 0xf1: code = 0x8cdc; break;
    }
    break;
  case 0xf6: switch(c1) {
 case 0x34: code = 0x8d60; break;
 case 0x35: code = 0x8d61; break;
 case 0x36: code = 0x8d62; break;
 case 0x37: code = 0x8d63; break;
 case 0x38: code = 0x8d64; break;
 case 0x39: code = 0x8d65; break;
 case 0x3a: code = 0x8d66; break;
 case 0x3b: code = 0x8d67; break;
 case 0x3c: code = 0x8d68; break;
 case 0x3d: code = 0x8d69; break;
 case 0x3e: code = 0x8d6a; break;
 case 0x3f: code = 0x8d6b; break;
 case 0x40: code = 0x8d6c; break;
 case 0x41: code = 0x8d6d; break;
 case 0x42: code = 0x8d6e; break;
 case 0x43: code = 0x8d6f; break;
 case 0x44: code = 0x8d70; break;
 case 0x45: code = 0x8d71; break;
 case 0x46: code = 0x8d72; break;
 case 0x47: code = 0x8d73; break;
 case 0x48: code = 0x8d74; break;
 case 0x49: code = 0x8d75; break;
 case 0x4a: code = 0x8d76; break;
 case 0x4b: code = 0x8d77; break;
 case 0x4c: code = 0x8d78; break;
 case 0x4d: code = 0x8d79; break;
 case 0x4e: code = 0x8d7a; break;
 case 0x4f: code = 0x8d7b; break;
 case 0x50: code = 0x8d7c; break;
 case 0x51: code = 0x8d7d; break;
 case 0x52: code = 0x8d7e; break;
 case 0x53: code = 0x8da1; break;
 case 0x54: code = 0x8da2; break;
 case 0x55: code = 0x8da3; break;
 case 0x56: code = 0x8da4; break;
 case 0x57: code = 0x8da5; break;
 case 0x58: code = 0x8da6; break;
 case 0x59: code = 0x8da7; break;
 case 0x5a: code = 0x8da8; break;
 case 0x5b: code = 0x8da9; break;
 case 0x5c: code = 0x8daa; break;
 case 0x5d: code = 0x8dab; break;
 case 0x5e: code = 0x8dac; break;
 case 0x5f: code = 0x8dad; break;
 case 0x60: code = 0x8dae; break;
 case 0x61: code = 0x8daf; break;
 case 0x62: code = 0x8db0; break;
 case 0x63: code = 0x8db1; break;
 case 0x64: code = 0x8db2; break;
 case 0x65: code = 0x8db3; break;
 case 0x66: code = 0x8db4; break;
 case 0x67: code = 0x8db5; break;
 case 0x68: code = 0x8db6; break;
 case 0x69: code = 0x8db7; break;
 case 0x6a: code = 0x8db8; break;
 case 0x6b: code = 0x8db9; break;
 case 0x6c: code = 0x8dba; break;
 case 0x6d: code = 0x8dbb; break;
 case 0x6e: code = 0x8dbc; break;
 case 0x6f: code = 0x8dbd; break;
 case 0x70: code = 0x8dbe; break;
 case 0x71: code = 0x8dbf; break;
 case 0x72: code = 0x8dc0; break;
 case 0x73: code = 0x8dc1; break;
 case 0x74: code = 0x8dc2; break;
 case 0x75: code = 0x8dc3; break;
 case 0x76: code = 0x8dc4; break;
 case 0x77: code = 0x8dc5; break;
 case 0x78: code = 0x8dc6; break;
 case 0x79: code = 0x8dc7; break;
 case 0x7a: code = 0x8dc8; break;
 case 0x7b: code = 0x8dc9; break;
 case 0x7c: code = 0x8dca; break;
 case 0x7d: code = 0x8dcb; break;
 case 0x7e: code = 0x8dcc; break;
 case 0x7f: code = 0x8dcd; break;
 case 0x80: code = 0x8dce; break;
 case 0x81: code = 0x8dcf; break;
 case 0x82: code = 0x8dd0; break;
 case 0x83: code = 0x8dd1; break;
 case 0x84: code = 0x8dd2; break;
 case 0x85: code = 0x8dd3; break;
 case 0x86: code = 0x8dd4; break;
 case 0x87: code = 0x8dd5; break;
 case 0x88: code = 0x8dd6; break;
 case 0x89: code = 0x8dd7; break;
 case 0x8a: code = 0x8dd8; break;
 case 0x8b: code = 0x8dd9; break;
 case 0x8c: code = 0x8dda; break;
 case 0x8d: code = 0x8ddb; break;
 case 0x8e: code = 0x8ddc; break;
 case 0x8f: code = 0x8ddd; break;
 case 0x90: code = 0x8dde; break;
 case 0x91: code = 0x8ddf; break;
 case 0x92: code = 0x8de0; break;
 case 0x93: code = 0x8de1; break;
 case 0x94: code = 0x8de2; break;
 case 0x95: code = 0x8de3; break;
 case 0x96: code = 0x8de4; break;
 case 0x97: code = 0x8de5; break;
 case 0x98: code = 0x8de6; break;
 case 0x99: code = 0x8de7; break;
 case 0x9a: code = 0x8de8; break;
 case 0x9b: code = 0x8de9; break;
 case 0x9c: code = 0x8dea; break;
 case 0x9d: code = 0x8deb; break;
 case 0x9e: code = 0x8dec; break;
 case 0x9f: code = 0x8ded; break;
 case 0xa0: code = 0x8dee; break;
 case 0xa1: code = 0x8def; break;
 case 0xa2: code = 0x8df0; break;
 case 0xa3: code = 0x8df1; break;
 case 0xa4: code = 0x8df2; break;
 case 0xa5: code = 0x8df3; break;
 case 0xa6: code = 0x8df4; break;
 case 0xa7: code = 0x8df5; break;
 case 0xa8: code = 0x8df6; break;
 case 0xa9: code = 0x8df7; break;
 case 0xaa: code = 0x8df8; break;
 case 0xab: code = 0x8df9; break;
 case 0xac: code = 0x8dfa; break;
 case 0xad: code = 0x8dfb; break;
 case 0xae: code = 0x8dfc; break;
 case 0xaf: code = 0x8dfd; break;
 case 0xb0: code = 0x8dfe; break;
    }
    break;
  case 0xf9: switch(c1) {
    case 0x07: code = 0x8bf8; break;
    }
    break;
  case 0x200: switch(c1) {
    case 0x21: code = 0x9c71; break;
    case 0x3e: code = 0x9375; break;
    case 0x46: code = 0x9376; break;
    case 0x4e: code = 0x9548; break;
    case 0x68: code = 0x8ec6; break;
    case 0x86: code = 0x8bc5; break;
    case 0x87: code = 0x8bfa; break;
    case 0x94: code = 0x9ab4; break;
    case 0xca: code = 0x884e; break;
    case 0xcb: code = 0x884b; break;
    case 0xcd: code = 0x8848; break;
    case 0xd1: code = 0x8847; break;
    case 0xee: code = 0xa0f6; break;
    }
    break;
  case 0x201: switch(c1) {
    case 0x0c: code = 0x8845; break;
    case 0x0e: code = 0x8853; break;
    case 0x18: code = 0xfcad; break;
    case 0xa9: code = 0x8aad; break;
    case 0xab: code = 0x9272; break;
    case 0xc1: code = 0xfc47; break;
    case 0xd4: code = 0x94df; break;
    case 0xf2: code = 0x9fd1; break;
    }
    break;
  case 0x202: switch(c1) {
    case 0x04: code = 0xfbcb; break;
    case 0x0c: code = 0x927d; break;
    case 0x14: code = 0x98a4; break;
    case 0x5b: code = 0x94e7; break;
    case 0x74: code = 0x90cb; break;
    case 0x75: code = 0x927b; break;
    case 0x99: code = 0x94d8; break;
    case 0x9e: code = 0xfc5f; break;
    case 0xa0: code = 0xfa54; break;
    case 0xb7: code = 0x9ab5; break;
    case 0xbf: code = 0x96da; break;
    case 0xc0: code = 0x9279; break;
    case 0xe5: code = 0xfa74; break;
    }
    break;
  case 0x203: switch(c1) {
 case 0x0a: code = 0x9275; break;
 case 0x25: code = 0x8dfb; break;
 case 0x41: code = 0x8a49; break;
 case 0x45: code = 0x92df; break;
 case 0x46: code = 0x9b7c; break;
 case 0x47: code = 0xfa63; break;
 case 0x7e: code = 0xfa60; break;
 case 0x7f: code = 0x926d; break;
 case 0x80: code = 0xfa62; break;
 case 0xa0: code = 0x9ab6; break;
 case 0xa7: code = 0x976b; break;
 case 0xb5: code = 0xfd6a; break;
 case 0xc9: code = 0xfd54; break;
 case 0xcb: code = 0x9273; break;
 case 0xf5: code = 0x97d8; break;
 case 0xfc: code = 0x9fbb; break;
    }
    break;
  case 0x204: switch(c1) {
 case 0x13: code = 0x9342; break;
 case 0x14: code = 0x9276; break;
 case 0x1f: code = 0xfa65; break;
 case 0x65: code = 0x926c; break;
 case 0x87: code = 0xfa6e; break;
 case 0x8e: code = 0x9ee0; break;
 case 0x91: code = 0x92c0; break;
 case 0x92: code = 0x92bf; break;
 case 0xa3: code = 0x92be; break;
 case 0xd7: code = 0x9aba; break;
 case 0xfc: code = 0x8ab3; break;
 case 0xfe: code = 0x9775; break;
    }
    break;
  case 0x205: switch(c1) {
 case 0x47: code = 0xfa40; break;
 case 0x8e: code = 0xfa76; break;
 case 0xa5: code = 0xfbd0; break;
 case 0xb3: code = 0xfa7b; break;
 case 0xc3: code = 0xfe6d; break;
 case 0xca: code = 0x9bb3; break;
 case 0xd0: code = 0x89cc; break;
 case 0xd5: code = 0x9abe; break;
 case 0xdf: code = 0xfa42; break;
 case 0xe0: code = 0x92bc; break;
 case 0xeb: code = 0x945c; break;
    }
    break;
  case 0x206: switch(c1) {
 case 0x11: code = 0x9bb5; break;
 case 0x15: code = 0x9abf; break;
 case 0x19: code = 0x98a7; break;
 case 0x1a: code = 0x97a4; break;
 case 0x30: code = 0x90fd; break;
 case 0x56: code = 0xfc7b; break;
 case 0x76: code = 0x9ac0; break;
    }
    break;
  case 0x207: switch(c1) {
    case 0x0e: code = 0x92c3; break;
    case 0x31: code = 0x8aaa; break;
    case 0x79: code = 0x9bd0; break;
    }
    break;
  case 0x208: switch(c1) {
    case 0x2c: code = 0x9550; break;
    case 0x73: code = 0x92c6; break;
    case 0xd5: code = 0x98a6; break;
    }
    break;
  case 0x209: switch(c1) {
    case 0x16: code = 0x9546; break;
    case 0x23: code = 0xfd63; break;
    case 0x54: code = 0xfac2; break;
    case 0x79: code = 0x9ec3; break;
    case 0xe7: code = 0x89b2; break;
    }
    break;
  case 0x20a: switch(c1) {
    case 0x11: code = 0x9c66; break;
    case 0x50: code = 0x9053; break;
    case 0xb4: code = 0x97c1; break;
    case 0xc2: code = 0x9ac4; break;
    case 0xcd: code = 0x9ac5; break;
    }
    break;
  case 0x20b: switch(c1) {
 case 0x0d: code = 0x8eef; break;
 case 0x8f: code = 0xfae9; break;
 case 0xa8: code = 0x9262; break;
 case 0xa9: code = 0x8af7; break;
 case 0xbf: code = 0x9ac6; break;
 case 0xc6: code = 0x92e1; break;
 case 0xcb: code = 0x9ac9; break;
 case 0xe2: code = 0xfac6; break;
 case 0xeb: code = 0x97a5; break;
 case 0xfb: code = 0x9acb; break;
 case 0xff: code = 0xfa72; break;
    }
    break;
  case 0x20c: switch(c1) {
 case 0x0b: code = 0x8a5e; break;
 case 0x0d: code = 0x94e0; break;
 case 0x20: code = 0x92cc; break;
 case 0x34: code = 0x8ae5; break;
 case 0x3a: code = 0xfe5c; break;
 case 0x3b: code = 0x9acc; break;
 case 0x41: code = 0x9df9; break;
 case 0x42: code = 0x8a43; break;
 case 0x43: code = 0x8aa6; break;
 case 0x53: code = 0x9acd; break;
 case 0x65: code = 0x9ace; break;
 case 0x77: code = 0xfaee; break;
 case 0x78: code = 0x9bcc; break;
 case 0x7c: code = 0x9acf; break;
 case 0x8d: code = 0x9ad1; break;
 case 0x96: code = 0x9dfa; break;
 case 0x9c: code = 0x9d7c; break;
 case 0xb5: code = 0x9ad3; break;
 case 0xb8: code = 0x97a6; break;
 case 0xcf: code = 0x995f; break;
 case 0xd3: code = 0xfbf6; break;
 case 0xd4: code = 0x9fc5; break;
 case 0xd5: code = 0x8a59; break;
 case 0xd6: code = 0x8b6b; break;
 case 0xdd: code = 0x9ad4; break;
 case 0xed: code = 0x9ad5; break;
 case 0xff: code = 0x97a2; break;
    }
    break;
  case 0x20d: switch(c1) {
 case 0x15: code = 0x8a44; break;
 case 0x28: code = 0x9f4a; break;
 case 0x31: code = 0x90a1; break;
 case 0x32: code = 0xfda4; break;
 case 0x46: code = 0x8a64; break;
 case 0x47: code = 0x8af2; break;
 case 0x48: code = 0x8af8; break;
 case 0x49: code = 0x9dd8; break;
 case 0x4c: code = 0x94d6; break;
 case 0x4d: code = 0xfafe; break;
 case 0x4e: code = 0xfba7; break;
 case 0x6f: code = 0x9ad6; break;
 case 0x71: code = 0x9f4d; break;
 case 0x74: code = 0xfaf6; break;
 case 0x7c: code = 0x8a57; break;
 case 0x7e: code = 0x8b43; break;
 case 0x7f: code = 0x8b44; break;
 case 0x96: code = 0x8ab6; break;
 case 0x9c: code = 0x8ac0; break;
 case 0xa7: code = 0x9e54; break;
 case 0xb2: code = 0x9ad7; break;
 case 0xc8: code = 0x9ad8; break;
    }
    break;
  case 0x20e: switch(c1) {
 case 0x04: code = 0x9adc; break;
 case 0x09: code = 0x8aca; break;
 case 0x0a: code = 0x9ea8; break;
 case 0x0d: code = 0x9263; break;
 case 0x0e: code = 0x9add; break;
 case 0x0f: code = 0x8b65; break;
 case 0x10: code = 0x8b6f; break;
 case 0x11: code = 0x8b7e; break;
 case 0x16: code = 0x8f43; break;
 case 0x1d: code = 0x92d0; break;
 case 0x4c: code = 0x8af4; break;
 case 0x6d: code = 0x9dbe; break;
 case 0x73: code = 0x9ae1; break;
 case 0x75: code = 0xfcde; break;
 case 0x76: code = 0x9dfd; break;
 case 0x77: code = 0x8b66; break;
 case 0x78: code = 0x8b70; break;
 case 0x79: code = 0x8b75; break;
 case 0x7a: code = 0x8ae4; break;
 case 0x7b: code = 0x8ba4; break;
 case 0x8c: code = 0x8aed; break;
 case 0x96: code = 0x8a5d; break;
 case 0x98: code = 0x8b48; break;
 case 0x9d: code = 0x9ded; break;
 case 0xa2: code = 0x9e40; break;
 case 0xaa: code = 0x8aef; break;
 case 0xab: code = 0x8af6; break;
 case 0xac: code = 0x9e76; break;
 case 0xb6: code = 0x9ee3; break;
 case 0xd7: code = 0x9ade; break;
 case 0xd8: code = 0x8dfe; break;
 case 0xdd: code = 0xfafc; break;
 case 0xf8: code = 0x9cb1; break;
 case 0xf9: code = 0x9e77; break;
 case 0xfa: code = 0x8b64; break;
 case 0xfb: code = 0x8b67; break;
    }
    break;
  case 0x20f: switch(c1) {
 case 0x1d: code = 0x974b; break;
 case 0x26: code = 0x9653; break;
 case 0x2d: code = 0x9ae0; break;
 case 0x2e: code = 0x8b4a; break;
 case 0x30: code = 0x8af1; break;
 case 0x31: code = 0x8ad7; break;
 case 0x3b: code = 0xa0ab; break;
 case 0x4c: code = 0x8ab5; break;
 case 0x64: code = 0x8a5f; break;
 case 0x8d: code = 0x8aee; break;
 case 0x90: code = 0x9adf; break;
 case 0xad: code = 0x8afe; break;
 case 0xb4: code = 0x8a58; break;
 case 0xb5: code = 0x8ba3; break;
 case 0xb6: code = 0x8ba7; break;
 case 0xbc: code = 0x9ae3; break;
 case 0xdf: code = 0x9261; break;
 case 0xea: code = 0x9dd7; break;
 case 0xeb: code = 0x9e7d; break;
 case 0xec: code = 0x9ea7; break;
 case 0xed: code = 0x9eab; break;
    }
    break;
  case 0x210: switch(c1) {
 case 0x14: code = 0x9042; break;
 case 0x1d: code = 0x8b79; break;
 case 0x1e: code = 0x8b7a; break;
 case 0x4f: code = 0x9ae6; break;
 case 0x5c: code = 0x9ae5; break;
 case 0x6f: code = 0x8a7e; break;
 case 0x75: code = 0x9e44; break;
 case 0x76: code = 0x9ae7; break;
 case 0x77: code = 0x8a7c; break;
 case 0x78: code = 0x8b71; break;
 case 0x7b: code = 0x9ae9; break;
 case 0x88: code = 0x9aea; break;
 case 0x96: code = 0x9aeb; break;
 case 0x9d: code = 0x8abd; break;
 case 0xb4: code = 0xfb4e; break;
 case 0xbf: code = 0x9aed; break;
 case 0xc0: code = 0x8af9; break;
 case 0xc1: code = 0x9e63; break;
 case 0xc7: code = 0x8b49; break;
 case 0xc8: code = 0x8ace; break;
 case 0xc9: code = 0x8b6e; break;
 case 0xcf: code = 0x8ae8; break;
 case 0xd3: code = 0x9aee; break;
 case 0xe4: code = 0x92ce; break;
 case 0xf4: code = 0x8a5a; break;
 case 0xf5: code = 0x8b7b; break;
 case 0xf6: code = 0x8b7c; break;
    }
    break;
  case 0x211: switch(c1) {
 case 0x2f: code = 0x9aef; break;
 case 0x3b: code = 0x9af0; break;
 case 0x3d: code = 0x8afa; break;
 case 0x45: code = 0x8941; break;
 case 0x48: code = 0x8b72; break;
 case 0x4f: code = 0x8af3; break;
 case 0x80: code = 0x8ba8; break;
 case 0x87: code = 0x9eae; break;
 case 0xd9: code = 0x9e72; break;
    }
    break;
  case 0x212: switch(c1) {
    case 0x3c: code = 0xfb73; break;
    case 0x4f: code = 0xfb5f; break;
    case 0x7c: code = 0x90ba; break;
    case 0xa8: code = 0x91fe; break;
    case 0xa9: code = 0x9ef6; break;
    case 0xb0: code = 0x97ed; break;
    case 0xe3: code = 0x9af3; break;
    case 0xfe: code = 0xa0ee; break;
    }
    break;
  case 0x213: switch(c1) {
 case 0x02: code = 0x967c; break;
 case 0x03: code = 0x9345; break;
 case 0x04: code = 0x986e; break;
 case 0x05: code = 0xfa56; break;
 case 0x36: code = 0x9af5; break;
 case 0x3a: code = 0xfc4b; break;
 case 0x75: code = 0x9af4; break;
 case 0x76: code = 0xfede; break;
 case 0x8e: code = 0xfcb7; break;
 case 0x98: code = 0x97f1; break;
 case 0x9c: code = 0x97c7; break;
 case 0xc5: code = 0x9ccb; break;
 case 0xc6: code = 0x9240; break;
 case 0xed: code = 0x9ce8; break;
 case 0xfe: code = 0x91fd; break;
    }
    break;
  case 0x214: switch(c1) {
 case 0x13: code = 0x974e; break;
 case 0x16: code = 0xfb68; break;
 case 0x24: code = 0x976c; break;
 case 0x3f: code = 0x8cc2; break;
 case 0x52: code = 0x97e8; break;
 case 0x54: code = 0xfb6a; break;
 case 0x55: code = 0x8b74; break;
 case 0x8a: code = 0x8ee7; break;
 case 0x97: code = 0xfdc8; break;
 case 0xb6: code = 0x9241; break;
 case 0xe8: code = 0x96a1; break;
 case 0xfd: code = 0x8ef3; break;
    }
    break;
  case 0x215: switch(c1) {
    case 0x77: code = 0x9af7; break;
    case 0x82: code = 0x8fa6; break;
    case 0x96: code = 0xfad6; break;
    }
    break;
  case 0x216: switch(c1) {
 case 0x0a: code = 0x9cc7; break;
 case 0x13: code = 0xfad7; break;
 case 0x19: code = 0x9af8; break;
 case 0x3e: code = 0xfba1; break;
 case 0x61: code = 0x8ec5; break;
 case 0x92: code = 0xfba4; break;
 case 0xb8: code = 0xfbc2; break;
 case 0xba: code = 0x9ac1; break;
 case 0xc0: code = 0x91fa; break;
 case 0xc1: code = 0xfedb; break;
 case 0xc2: code = 0x97ab; break;
 case 0xd3: code = 0x9147; break;
 case 0xd5: code = 0xfbb1; break;
 case 0xdf: code = 0x8fea; break;
 case 0xe6: code = 0x94d2; break;
 case 0xe7: code = 0xfe61; break;
 case 0xe8: code = 0xface; break;
 case 0xfa: code = 0x92ed; break;
 case 0xfb: code = 0x91f3; break;
 case 0xfc: code = 0x93c6; break;
 case 0xfe: code = 0x935a; break;
    }
    break;
  case 0x217: switch(c1) {
 case 0x0d: code = 0xfafb; break;
 case 0x10: code = 0x92ef; break;
 case 0x26: code = 0xfac8; break;
 case 0x3a: code = 0x9847; break;
 case 0x3b: code = 0x9366; break;
 case 0x3c: code = 0x9855; break;
 case 0x57: code = 0x96e6; break;
 case 0x6c: code = 0x9f43; break;
 case 0x6d: code = 0x9faa; break;
 case 0x6e: code = 0x94da; break;
 case 0x6f: code = 0x92ee; break;
 case 0x70: code = 0xfcaf; break;
 case 0x71: code = 0xfbfb; break;
 case 0x73: code = 0x8ef9; break;
 case 0x74: code = 0x91f6; break;
 case 0xab: code = 0x9364; break;
 case 0xb0: code = 0x94f5; break;
 case 0xb1: code = 0x9cb6; break;
 case 0xb2: code = 0xfbad; break;
 case 0xb3: code = 0x984e; break;
 case 0xb4: code = 0x8f44; break;
 case 0xb5: code = 0x96fd; break;
 case 0xc3: code = 0x9af9; break;
 case 0xc7: code = 0x9afa; break;
 case 0xd9: code = 0x9769; break;
 case 0xda: code = 0x95d4; break;
 case 0xdb: code = 0x984b; break;
 case 0xdc: code = 0xfbaa; break;
 case 0xdf: code = 0x987c; break;
 case 0xef: code = 0x91ea; break;
 case 0xf5: code = 0x9daf; break;
 case 0xf6: code = 0x9dc5; break;
 case 0xf8: code = 0x91f1; break;
 case 0xf9: code = 0x8eb1; break;
 case 0xfa: code = 0x97a9; break;
 case 0xfb: code = 0xfbac; break;
 case 0xfc: code = 0xfcb8; break;
    }
    break;
  case 0x218: switch(c1) {
 case 0x20: code = 0x9cb9; break;
 case 0x28: code = 0xfbb0; break;
 case 0x29: code = 0xfcd2; break;
 case 0x2a: code = 0x93cb; break;
 case 0x2d: code = 0x9afd; break;
 case 0x39: code = 0x91f4; break;
 case 0x3a: code = 0x8bac; break;
 case 0x3b: code = 0xa055; break;
 case 0x40: code = 0x9574; break;
 case 0x45: code = 0x95be; break;
 case 0x52: code = 0x97ad; break;
 case 0x5e: code = 0x8ee9; break;
 case 0x61: code = 0x92f8; break;
 case 0x62: code = 0x97be; break;
 case 0x63: code = 0x916c; break;
 case 0x64: code = 0x94aa; break;
 case 0x77: code = 0xfc63; break;
 case 0x7b: code = 0x9dc6; break;
 case 0x83: code = 0x97b5; break;
 case 0x84: code = 0x92b8; break;
 case 0x85: code = 0x91ef; break;
 case 0x9e: code = 0xfea6; break;
 case 0x9f: code = 0x9760; break;
 case 0xa0: code = 0x9358; break;
 case 0xa1: code = 0x9576; break;
 case 0xa2: code = 0x8fac; break;
 case 0xbe: code = 0x91ec; break;
 case 0xbf: code = 0x97b4; break;
 case 0xd1: code = 0x91f7; break;
 case 0xd6: code = 0x974a; break;
 case 0xd7: code = 0xfb49; break;
 case 0xd8: code = 0x9578; break;
 case 0xd9: code = 0x93bc; break;
 case 0xfa: code = 0x91d6; break;
    }
    break;
  case 0x219: switch(c1) {
 case 0x03: code = 0x9355; break;
 case 0x04: code = 0x9356; break;
 case 0x05: code = 0x9851; break;
 case 0x10: code = 0x8ff8; break;
 case 0x11: code = 0xfbc0; break;
 case 0x12: code = 0x93f2; break;
 case 0x15: code = 0x90d0; break;
 case 0x1c: code = 0x9c44; break;
 case 0x22: code = 0x9255; break;
 case 0x27: code = 0x9363; break;
 case 0x3b: code = 0x91a5; break;
 case 0x44: code = 0xa0ed; break;
 case 0x58: code = 0xfd6b; break;
 case 0x6a: code = 0x9afe; break;
 case 0x7c: code = 0x9351; break;
 case 0x80: code = 0x8c57; break;
 case 0x83: code = 0xfa78; break;
 case 0x88: code = 0xfea8; break;
 case 0x96: code = 0x9350; break;
 case 0xdb: code = 0xfa4c; break;
 case 0xf3: code = 0x92f7; break;
    }
    break;
  case 0x21a: switch(c1) {
    case 0x2d: code = 0x9b40; break;
    case 0x34: code = 0xfbce; break;
    case 0x45: code = 0x9b41; break;
    case 0x4b: code = 0xfead; break;
    }
    break;
  case 0x21b: switch(c1) {
    case 0x44: code = 0xfbd5; break;
    case 0xc1: code = 0x8bc2; break;
    case 0xc2: code = 0x9a7c; break;
    }
    break;
  case 0x21c: switch(c1) {
    case 0x2a: code = 0x9b42; break;
    case 0x70: code = 0x9b43; break;
    case 0xa2: code = 0x9e79; break;
    case 0xa5: code = 0xfbd9; break;
    case 0xac: code = 0x9b44; break;
    }
    break;
  case 0x21d: switch(c1) {
    case 0x46: code = 0xa0a7; break;
    case 0x90: code = 0x9bf3; break;
    case 0xb6: code = 0x8c79; break;
    case 0xba: code = 0x935e; break;
    case 0xca: code = 0x89cb; break;
    case 0xd1: code = 0x9f53; break;
    case 0xeb: code = 0x93d7; break;
    case 0xf9: code = 0xfbe1; break;
    }
    break;
  case 0x21e: switch(c1) {
    case 0x1c: code = 0xfed0; break;
    case 0x37: code = 0xfbe2; break;
    case 0x3d: code = 0xfce3; break;
    case 0x89: code = 0x9074; break;
    case 0xa4: code = 0xfbe6; break;
    case 0xa8: code = 0x9bb7; break;
    case 0xc8: code = 0x9b45; break;
    case 0xd5: code = 0x9b47; break;
    }
    break;
  case 0x21f: switch(c1) {
    case 0x0f: code = 0x9f50; break;
    case 0x15: code = 0x9b48; break;
    case 0x6a: code = 0xfc5b; break;
    case 0x9e: code = 0x98a9; break;
    case 0xa1: code = 0x9cfd; break;
    case 0xe8: code = 0x884c; break;
    }
    break;
  case 0x220: switch(c1) {
    case 0x45: code = 0x9b4b; break;
    case 0x49: code = 0xfbec; break;
    case 0x7e: code = 0x8c69; break;
    case 0x9a: code = 0x9ba8; break;
    case 0xc7: code = 0x8ad5; break;
    case 0xfc: code = 0xfa73; break;
    }
    break;
  case 0x221: switch(c1) {
    case 0x2a: code = 0xfd59; break;
    case 0x5b: code = 0x91a2; break;
    case 0x73: code = 0xfbed; break;
    case 0x7a: code = 0x9ca9; break;
    case 0xa1: code = 0x8aa8; break;
    case 0xc3: code = 0x9bc3; break;
    }
    break;
  case 0x222: switch(c1) {
    case 0x08: code = 0x8ae1; break;
    case 0x7c: code = 0x9b4e; break;
    }
    break;
  case 0x223: switch(c1) {
    case 0x21: code = 0x95d0; break;
    case 0x25: code = 0x905f; break;
    case 0xbd: code = 0x97ee; break;
    case 0xd0: code = 0xfc4e; break;
    case 0xd7: code = 0x9b4f; break;
    case 0xfa: code = 0x9b50; break;
    }
    break;
  case 0x224: switch(c1) {
    case 0x65: code = 0x9ec6; break;
    case 0x71: code = 0xfc50; break;
    case 0x8b: code = 0xfd73; break;
    case 0x91: code = 0xfda7; break;
    case 0xb0: code = 0x9da2; break;
    case 0xed: code = 0xfa58; break;
    }
    break;
  case 0x225: switch(c1) {
    case 0x13: code = 0xfa5e; break;
    case 0x1b: code = 0xa059; break;
    case 0x30: code = 0xfa75; break;
    case 0x54: code = 0xfbbe; break;
    case 0x8d: code = 0x9ca2; break;
    case 0xaf: code = 0x9370; break;
    case 0xbe: code = 0x9371; break;
    }
    break;
  case 0x226: switch(c1) {
    case 0x1b: code = 0x9377; break;
    case 0x1c: code = 0xfeef; break;
    case 0x2b: code = 0x936d; break;
    case 0x68: code = 0xfc5d; break;
    case 0x7a: code = 0x90b8; break;
    case 0x96: code = 0x8afc; break;
    case 0x98: code = 0xfb41; break;
    case 0xf4: code = 0x9e6b; break;
    case 0xf5: code = 0x94e3; break;
    case 0xf6: code = 0x8ee2; break;
    }
    break;
  case 0x227: switch(c1) {
    case 0x12: code = 0x8c7d; break;
    case 0x14: code = 0x8ed7; break;
    case 0x1b: code = 0x9c4d; break;
    case 0x1f: code = 0x96a3; break;
    case 0x2a: code = 0x9b51; break;
    case 0x75: code = 0x8ac3; break;
    case 0x81: code = 0x96aa; break;
    case 0xb4: code = 0xfc68; break;
    case 0xb5: code = 0x8b6d; break;
    case 0xcd: code = 0xfd67; break;
    }
    break;
  case 0x228: switch(c1) {
    case 0x03: code = 0x8ae9; break;
    case 0x5f: code = 0xfca1; break;
    case 0x60: code = 0x936c; break;
    case 0x71: code = 0x9b52; break;
    case 0xad: code = 0xfe70; break;
    case 0xc1: code = 0xfca8; break;
    case 0xf7: code = 0xfce9; break;
    }
    break;
  case 0x229: switch(c1) {
    case 0x26: code = 0x9cb4; break;
    case 0x39: code = 0x8aea; break;
    case 0x4f: code = 0x9b53; break;
    case 0x67: code = 0x9b55; break;
    case 0x6b: code = 0x96ab; break;
    case 0x80: code = 0xfca7; break;
    case 0x93: code = 0x9b56; break;
    }
    break;
  case 0x22a: switch(c1) {
    case 0x66: code = 0x8abc; break;
    case 0xcf: code = 0x8acb; break;
    case 0xd5: code = 0x9b57; break;
    case 0xe6: code = 0x89cd; break;
    case 0xe8: code = 0x9b59; break;
    }
    break;
  case 0x22b: switch(c1) {
    case 0x0e: code = 0x9b5b; break;
    case 0x22: code = 0x93a5; break;
    case 0x3f: code = 0x9b5d; break;
    case 0x43: code = 0x9e4f; break;
    case 0x6a: code = 0x93a3; break;
    case 0xca: code = 0x8a7b; break;
    case 0xce: code = 0x8b42; break;
    }
    break;
  case 0x22c: switch(c1) {
    case 0x26: code = 0x9750; break;
    case 0x27: code = 0x8fb3; break;
    case 0x38: code = 0x8a50; break;
    case 0x4c: code = 0x9b60; break;
    case 0x51: code = 0x8b45; break;
    case 0x55: code = 0x8b46; break;
    case 0x62: code = 0x9dfe; break;
    case 0x88: code = 0x9b62; break;
    case 0x9b: code = 0x937b; break;
    case 0xa1: code = 0x93b1; break;
    case 0xa9: code = 0x8a60; break;
    case 0xb2: code = 0x8ad8; break;
    case 0xb7: code = 0x9b63; break;
    case 0xc2: code = 0x8a69; break;
    case 0xc6: code = 0x8a47; break;
    case 0xc9: code = 0x8acc; break;
    }
    break;
  case 0x22d: switch(c1) {
    case 0x07: code = 0x937c; break;
    case 0x08: code = 0x9b65; break;
    case 0x12: code = 0x9b66; break;
    case 0x44: code = 0x8a72; break;
    case 0x4c: code = 0x8a7a; break;
    case 0x67: code = 0x93af; break;
    case 0x8d: code = 0x8ab0; break;
    case 0x95: code = 0x9b68; break;
    case 0xa0: code = 0x9ea3; break;
    case 0xa3: code = 0xfaec; break;
    case 0xa4: code = 0x8b77; break;
    case 0xb7: code = 0x9b67; break;
    case 0xee: code = 0x8b59; break;
    }
    break;
  case 0x22e: switch(c1) {
    case 0x0d: code = 0xfcb1; break;
    case 0x36: code = 0xfcbb; break;
    case 0x42: code = 0x9b69; break;
    case 0x78: code = 0x93a8; break;
    case 0x8b: code = 0x8ae0; break;
    case 0xb3: code = 0x9e51; break;
    case 0xef: code = 0x8f5f; break;
    }
    break;
  case 0x22f: switch(c1) {
    case 0x74: code = 0x9b6a; break;
    case 0xcc: code = 0x9b6b; break;
    case 0xe3: code = 0x97ec; break;
    }
    break;
  case 0x230: switch(c1) {
 case 0x33: code = 0x9b6c; break;
 case 0x44: code = 0xfe4e; break;
 case 0x4b: code = 0xfdc2; break;
 case 0x66: code = 0x9b6d; break;
 case 0x7d: code = 0x9167; break;
 case 0x7e: code = 0xfccc; break;
 case 0x8e: code = 0x93b6; break;
 case 0xb7: code = 0x90e4; break;
 case 0xbc: code = 0x90e5; break;
 case 0xda: code = 0x9ef2; break;
    }
    break;
  case 0x231: switch(c1) {
 case 0x03: code = 0x93ca; break;
 case 0x3d: code = 0x8bbc; break;
 case 0x7d: code = 0x8f46; break;
 case 0x82: code = 0x93cf; break;
 case 0xa4: code = 0xfcdb; break;
 case 0xa5: code = 0xfcdc; break;
 case 0xb3: code = 0x93c0; break;
 case 0xc8: code = 0xfce6; break;
 case 0xc9: code = 0x96e7; break;
 case 0xf7: code = 0xfcd8; break;
 case 0xf8: code = 0xfcd9; break;
 case 0xf9: code = 0xfda6; break;
    }
    break;
  case 0x232: switch(c1) {
 case 0x0f: code = 0x93ce; break;
 case 0x25: code = 0x95f1; break;
 case 0x2f: code = 0x9ce9; break;
 case 0x31: code = 0xfce4; break;
 case 0x32: code = 0x94af; break;
 case 0x33: code = 0xfa77; break;
 case 0x34: code = 0x93cc; break;
 case 0x62: code = 0x905a; break;
 case 0x81: code = 0x8c54; break;
 case 0x89: code = 0x93bf; break;
 case 0x8a: code = 0xfb51; break;
 case 0xab: code = 0x93b9; break;
 case 0xac: code = 0xfed7; break;
 case 0xad: code = 0x93b7; break;
 case 0xd2: code = 0x93d9; break;
 case 0xe0: code = 0x93bb; break;
 case 0xe1: code = 0x93da; break;
    }
    break;
  case 0x233: switch(c1) {
 case 0x00: code = 0x98a3; break;
 case 0x0a: code = 0x90d1; break;
 case 0x1f: code = 0x9b6e; break;
 case 0xb4: code = 0xfa70; break;
 case 0xcc: code = 0x9beb; break;
 case 0xde: code = 0x9b6f; break;
 case 0xe6: code = 0xfcfc; break;
 case 0xf4: code = 0x8b40; break;
 case 0xf5: code = 0xa07b; break;
 case 0xf9: code = 0x8ca1; break;
 case 0xfa: code = 0x97f7; break;
 case 0xfe: code = 0x93e2; break;
    }
    break;
  case 0x234: switch(c1) {
 case 0x00: code = 0xfcd6; break;
 case 0x3f: code = 0x9559; break;
 case 0x50: code = 0x93a6; break;
 case 0x6f: code = 0xfd40; break;
 case 0x72: code = 0x935f; break;
 case 0xe5: code = 0x97f2; break;
    }
    break;
  case 0x235: switch(c1) {
 case 0x19: code = 0x9c76; break;
 case 0x30: code = 0x8ef8; break;
 case 0x5a: code = 0x8f47; break;
 case 0x67: code = 0x9b74; break;
 case 0x95: code = 0x92b4; break;
 case 0x99: code = 0x91ed; break;
 case 0x9c: code = 0x96d2; break;
 case 0xcd: code = 0xfd46; break;
 case 0xce: code = 0x8f4f; break;
 case 0xcf: code = 0x9549; break;
 case 0xf3: code = 0x9b75; break;
    }
    break;
  case 0x236: switch(c1) {
 case 0x00: code = 0xfa5c; break;
 case 0x1a: code = 0x9b79; break;
 case 0x3c: code = 0xfd4b; break;
 case 0x40: code = 0x96d3; break;
 case 0x59: code = 0xfd58; break;
 case 0x5f: code = 0x945f; break;
 case 0x77: code = 0xa0f5; break;
 case 0xa6: code = 0x9243; break;
 case 0xad: code = 0x97fa; break;
 case 0xba: code = 0x9dd9; break;
 case 0xdf: code = 0x97f4; break;
 case 0xee: code = 0x924d; break;
    }
    break;
  case 0x237: switch(c1) {
 case 0x03: code = 0xfd5b; break;
 case 0x16: code = 0x9b7a; break;
 case 0x20: code = 0x9ed5; break;
 case 0x2d: code = 0xfaae; break;
 case 0x2f: code = 0x9cc9; break;
 case 0x3f: code = 0x9258; break;
 case 0x66: code = 0x8ec8; break;
 case 0x81: code = 0x94b4; break;
 case 0xa2: code = 0x93e1; break;
 case 0xbc: code = 0x93df; break;
 case 0xc2: code = 0xfcf0; break;
 case 0xd5: code = 0x93ec; break;
 case 0xd6: code = 0x97f6; break;
 case 0xd7: code = 0x96cf; break;
    }
    break;
  case 0x238: switch(c1) {
    case 0x3a: code = 0x93de; break;
    }
    break;
  case 0x239: switch(c1) {
    case 0xc2: code = 0x8acf; break;
    }
    break;
  case 0x23a: switch(c1) {
    case 0xa7: code = 0x9ba2; break;
    case 0xdb: code = 0xfd69; break;
    case 0xee: code = 0x9352; break;
    case 0xfa: code = 0x98a2; break;
    }
    break;
  case 0x23b: switch(c1) {
    case 0x5a: code = 0xfd6e; break;
    }
    break;
  case 0x23c: switch(c1) {
 case 0x63: code = 0x8ca4; break;
 case 0x99: code = 0xfa7c; break;
 case 0x9a: code = 0x93fa; break;
 case 0x9b: code = 0x907c; break;
 case 0xb5: code = 0x8f67; break;
 case 0xb7: code = 0x9db7; break;
 case 0xc7: code = 0xa0e9; break;
 case 0xc8: code = 0xfa4e; break;
 case 0xc9: code = 0xfda1; break;
 case 0xfc: code = 0x9e74; break;
 case 0xfd: code = 0x9fbf; break;
 case 0xfe: code = 0x9ecb; break;
 case 0xff: code = 0x9bb9; break;
    }
    break;
  case 0x23d: switch(c1) {
 case 0x40: code = 0x9dd4; break;
 case 0x5b: code = 0x97b9; break;
 case 0x7e: code = 0x8ef1; break;
 case 0x8f: code = 0x957b; break;
 case 0xb6: code = 0x9ed2; break;
 case 0xb7: code = 0x9753; break;
 case 0xb8: code = 0x96a4; break;
 case 0xb9: code = 0x8fbe; break;
 case 0xba: code = 0x94d9; break;
 case 0xbb: code = 0x9058; break;
 case 0xbc: code = 0xfd79; break;
 case 0xbd: code = 0xfd7b; break;
 case 0xe3: code = 0x8eda; break;
 case 0xf8: code = 0x8efa; break;
    }
    break;
  case 0x23e: switch(c1) {
 case 0x11: code = 0x9ba5; break;
 case 0x2c: code = 0x9ed9; break;
 case 0x2d: code = 0x97d4; break;
 case 0x2e: code = 0x90bb; break;
 case 0x2f: code = 0xfdbc; break;
 case 0x30: code = 0xfdc6; break;
 case 0x31: code = 0x9248; break;
 case 0x39: code = 0x92b5; break;
 case 0x88: code = 0x9dc1; break;
 case 0x89: code = 0x92b9; break;
 case 0x8a: code = 0x92a6; break;
 case 0x8b: code = 0x8f4b; break;
 case 0xb9: code = 0x9ba6; break;
 case 0xbf: code = 0x92b6; break;
 case 0xd7: code = 0x8e40; break;
 case 0xf7: code = 0x9ed8; break;
 case 0xf8: code = 0x945e; break;
 case 0xf9: code = 0x985f; break;
 case 0xfa: code = 0x94ce; break;
 case 0xfb: code = 0x924a; break;
 case 0xfc: code = 0xfd70; break;
    }
    break;
  case 0x23f: switch(c1) {
 case 0x35: code = 0x9467; break;
 case 0x41: code = 0x8dec; break;
 case 0x4a: code = 0x9bd8; break;
 case 0x7f: code = 0x9448; break;
 case 0x80: code = 0xfac1; break;
 case 0x81: code = 0x9cf7; break;
 case 0x82: code = 0xfdbe; break;
 case 0x8f: code = 0x8fda; break;
 case 0xb4: code = 0xfdd9; break;
 case 0xb7: code = 0xfc7e; break;
 case 0xc0: code = 0x93f9; break;
 case 0xc5: code = 0xfa43; break;
 case 0xeb: code = 0xfaeb; break;
 case 0xec: code = 0xfac3; break;
 case 0xed: code = 0x97d3; break;
 case 0xee: code = 0x95f9; break;
 case 0xef: code = 0x9c48; break;
 case 0xf0: code = 0xfdd8; break;
    }
    break;
  case 0x240: switch(c1) {
 case 0x11: code = 0xa0d8; break;
 case 0x39: code = 0xfdd7; break;
 case 0x3a: code = 0xfb4a; break;
 case 0x3b: code = 0x9baf; break;
 case 0x3c: code = 0x944b; break;
 case 0x3d: code = 0xfdc9; break;
 case 0x57: code = 0x8eac; break;
 case 0x85: code = 0xfdb2; break;
 case 0x8b: code = 0x925a; break;
 case 0x8c: code = 0xfcbd; break;
 case 0x8d: code = 0x92d9; break;
 case 0x91: code = 0xfdd5; break;
 case 0xc9: code = 0x92dd; break;
 case 0xe1: code = 0x9259; break;
    }
    break;
  case 0x241: switch(c1) {
 case 0x04: code = 0x96ba; break;
 case 0x0f: code = 0x925b; break;
 case 0x19: code = 0x9bab; break;
 case 0x3f: code = 0xfdda; break;
 case 0x40: code = 0xfdde; break;
 case 0x44: code = 0xfdd3; break;
 case 0x4e: code = 0x8c46; break;
 case 0x55: code = 0xfdd6; break;
 case 0x56: code = 0xfddc; break;
 case 0x57: code = 0xfddd; break;
 case 0x5c: code = 0x90fe; break;
 case 0x5f: code = 0xfea1; break;
 case 0x77: code = 0x8bad; break;
 case 0x7a: code = 0x9cd8; break;
 case 0xa3: code = 0x9e6d; break;
 case 0xa4: code = 0xfd7c; break;
 case 0xa5: code = 0xfb61; break;
 case 0xac: code = 0x96f8; break;
 case 0xb5: code = 0x96f0; break;
 case 0xcd: code = 0xfcf4; break;
 case 0xe2: code = 0xfe60; break;
 case 0xfc: code = 0x9852; break;
    }
    break;
  case 0x242: switch(c1) {
 case 0x1b: code = 0x964f; break;
 case 0x4b: code = 0x916e; break;
 case 0x56: code = 0x986d; break;
 case 0x59: code = 0x9864; break;
 case 0x76: code = 0x9453; break;
 case 0x77: code = 0xfdec; break;
 case 0x78: code = 0xfb78; break;
 case 0x84: code = 0x95ba; break;
 case 0x93: code = 0x985d; break;
 case 0x95: code = 0x92f9; break;
 case 0xa5: code = 0x985a; break;
 case 0xc1: code = 0xfdf6; break;
 case 0xc9: code = 0x93d0; break;
 case 0xca: code = 0x9862; break;
 case 0xee: code = 0x9bad; break;
 case 0xfa: code = 0x974f; break;
    }
    break;
  case 0x243: switch(c1) {
 case 0x0d: code = 0x9bae; break;
 case 0x1a: code = 0x9452; break;
 case 0x34: code = 0x9bb0; break;
 case 0x48: code = 0x91d2; break;
 case 0x62: code = 0x97ea; break;
 case 0x63: code = 0xfb6b; break;
 case 0x64: code = 0x91b1; break;
 case 0x65: code = 0xfdf3; break;
 case 0x8c: code = 0x92cb; break;
 case 0x96: code = 0x9bb1; break;
 case 0x9c: code = 0xfcec; break;
 case 0xbd: code = 0x986b; break;
 case 0xc1: code = 0x9751; break;
 case 0xe9: code = 0x9871; break;
 case 0xea: code = 0x95ef; break;
 case 0xf2: code = 0x9ef3; break;
 case 0xf8: code = 0x91e8; break;
    }
    break;
  case 0x244: switch(c1) {
 case 0x04: code = 0x9bba; break;
 case 0x35: code = 0xfb4c; break;
 case 0x36: code = 0x926a; break;
 case 0x5a: code = 0xfdf8; break;
 case 0x5b: code = 0x9861; break;
 case 0x73: code = 0x91e7; break;
 case 0x87: code = 0x93ed; break;
 case 0x88: code = 0x9744; break;
 case 0xb9: code = 0x91e1; break;
 case 0xbc: code = 0xfbf5; break;
 case 0xce: code = 0x9869; break;
 case 0xd3: code = 0x8a62; break;
 case 0xd6: code = 0x9bbb; break;
    }
    break;
  case 0x245: switch(c1) {
    case 0x05: code = 0x8ca8; break;
    case 0x21: code = 0x9c55; break;
    case 0x78: code = 0x8e77; break;
    case 0xc8: code = 0x8ab2; break;
    }
    break;
  case 0x246: switch(c1) {
 case 0x18: code = 0x9ebc; break;
 case 0x2a: code = 0x93e6; break;
 case 0x65: code = 0x93a2; break;
 case 0x74: code = 0x9bbd; break;
 case 0x97: code = 0x94b3; break;
 case 0xd4: code = 0x937d; break;
    }
    break;
  case 0x247: switch(c1) {
 case 0x06: code = 0x9e66; break;
 case 0x25: code = 0x9459; break;
 case 0x2f: code = 0x9bbf; break;
 case 0x8f: code = 0x9458; break;
 case 0xe0: code = 0x9ea5; break;
    }
    break;
  case 0x248: switch(c1) {
 case 0x12: code = 0x9bc7; break;
 case 0x23: code = 0xfe54; break;
 case 0x82: code = 0x8e74; break;
 case 0xe9: code = 0x8bd6; break;
 case 0xf0: code = 0x94b6; break;
 case 0xf1: code = 0xfd74; break;
 case 0xf2: code = 0x98c0; break;
 case 0xf3: code = 0x94a5; break;
 case 0xfb: code = 0x9bc8; break;
 case 0xff: code = 0x95ed; break;
    }
    break;
  case 0x249: switch(c1) {
 case 0x00: code = 0xfd7e; break;
 case 0x01: code = 0xfbeb; break;
 case 0x0c: code = 0xfd7d; break;
 case 0x16: code = 0x976f; break;
 case 0x17: code = 0x9461; break;
 case 0x19: code = 0x9fc1; break;
 case 0x2f: code = 0x95d7; break;
 case 0x33: code = 0xfa52; break;
 case 0x34: code = 0x9c58; break;
 case 0x3e: code = 0x9f68; break;
 case 0x3f: code = 0x9be7; break;
 case 0x40: code = 0xfcce; break;
 case 0x41: code = 0x96e8; break;
 case 0x42: code = 0xfa49; break;
 case 0x43: code = 0x97a1; break;
 case 0x62: code = 0x954d; break;
 case 0x63: code = 0x9ef8; break;
 case 0x74: code = 0xfe49; break;
 case 0x75: code = 0x91ce; break;
 case 0x76: code = 0x9771; break;
 case 0x7b: code = 0x8ccf; break;
 case 0x7f: code = 0xfdb1; break;
 case 0x82: code = 0xfc6e; break;
 case 0x88: code = 0x9cf2; break;
 case 0x89: code = 0x93b8; break;
 case 0x8a: code = 0x9043; break;
 case 0x8b: code = 0x9759; break;
 case 0x8c: code = 0x94d7; break;
 case 0x8d: code = 0xfe66; break;
 case 0x8e: code = 0x947d; break;
 case 0x8f: code = 0xfc6f; break;
 case 0x94: code = 0x9246; break;
 case 0xa4: code = 0xfa6d; break;
 case 0xa7: code = 0x8ef7; break;
 case 0xa9: code = 0xfbb7; break;
 case 0xab: code = 0x947c; break;
 case 0xac: code = 0x92cd; break;
 case 0xad: code = 0x97b2; break;
 case 0xb7: code = 0xfe65; break;
 case 0xb8: code = 0x967e; break;
 case 0xb9: code = 0x9758; break;
 case 0xba: code = 0x9b77; break;
 case 0xbb: code = 0x91cf; break;
 case 0xc5: code = 0x94a4; break;
 case 0xd0: code = 0x9cad; break;
 case 0xda: code = 0x8bab; break;
 case 0xde: code = 0x96d5; break;
 case 0xdf: code = 0xfcb3; break;
 case 0xe3: code = 0x93ae; break;
 case 0xe5: code = 0x976d; break;
 case 0xec: code = 0x9446; break;
 case 0xed: code = 0x95f7; break;
 case 0xf6: code = 0x9c46; break;
 case 0xf7: code = 0x955b; break;
 case 0xf8: code = 0x91d1; break;
 case 0xf9: code = 0x94f4; break;
 case 0xfb: code = 0xfe67; break;
    }
    break;
  case 0x24a: switch(c1) {
 case 0x0e: code = 0x92a5; break;
 case 0x12: code = 0xfedf; break;
 case 0x13: code = 0x8cab; break;
 case 0x15: code = 0x9bc9; break;
 case 0x21: code = 0xfced; break;
 case 0x22: code = 0xfdfa; break;
 case 0x23: code = 0xfcc8; break;
 case 0x24: code = 0xfe62; break;
 case 0x25: code = 0x91fc; break;
 case 0x26: code = 0xfe6b; break;
 case 0x27: code = 0xfdf9; break;
 case 0x28: code = 0xfcc7; break;
 case 0x29: code = 0x914e; break;
 case 0x2a: code = 0x9cb8; break;
 case 0x3e: code = 0x9767; break;
 case 0x42: code = 0x95ee; break;
 case 0x45: code = 0x9bb2; break;
 case 0x4a: code = 0x9460; break;
 case 0x4e: code = 0x94a2; break;
 case 0x4f: code = 0x9875; break;
 case 0x50: code = 0x97ac; break;
 case 0x51: code = 0x91d3; break;
 case 0x5d: code = 0x987b; break;
 case 0x65: code = 0x8eeb; break;
 case 0x66: code = 0x976a; break;
 case 0x67: code = 0x965e; break;
 case 0x71: code = 0x97eb; break;
 case 0x77: code = 0x9ff9; break;
 case 0x78: code = 0x95f8; break;
 case 0x79: code = 0xfea2; break;
 case 0x7a: code = 0x8fe6; break;
 case 0x8c: code = 0xfe7e; break;
 case 0x93: code = 0x9da4; break;
 case 0x94: code = 0x9768; break;
 case 0x95: code = 0x8eec; break;
 case 0x96: code = 0x94bd; break;
 case 0xa4: code = 0x945b; break;
 case 0xa5: code = 0x9cf6; break;
 case 0xa6: code = 0xfaa7; break;
 case 0xa7: code = 0x9bd9; break;
 case 0xb1: code = 0xfa5d; break;
 case 0xb2: code = 0x9656; break;
 case 0xb3: code = 0x9762; break;
 case 0xba: code = 0x94ba; break;
 case 0xbb: code = 0xa04f; break;
 case 0xbc: code = 0x92d8; break;
 case 0xc0: code = 0x9bcb; break;
 case 0xc7: code = 0x94bb; break;
 case 0xca: code = 0x9d5f; break;
 case 0xd1: code = 0x90cf; break;
 case 0xdf: code = 0x9465; break;
 case 0xe2: code = 0x9f4c; break;
 case 0xe9: code = 0x90d8; break;
    }
    break;
  case 0x24b: switch(c1) {
    case 0x6e: code = 0x9ebe; break;
    case 0xf5: code = 0xfb6d; break;
    }
    break;
  case 0x24c: switch(c1) {
    case 0x09: code = 0x95ca; break;
    case 0x9e: code = 0x9dc2; break;
    case 0x9f: code = 0x97f8; break;
    case 0xc9: code = 0x8ffc; break;
    case 0xd9: code = 0x9473; break;
    }
    break;
  case 0x24d: switch(c1) {
 case 0x06: code = 0x9474; break;
 case 0x13: code = 0xfeb7; break;
 case 0xb8: code = 0x8a4b; break;
 case 0xea: code = 0x8a55; break;
 case 0xeb: code = 0x8b69; break;
    }
    break;
  case 0x24e: switch(c1) {
    case 0x3b: code = 0x8adc; break;
 case 0x50: code = 0x8b76; break;
 case 0xa5: code = 0x9bce; break;
 case 0xa7: code = 0x8a68; break;
    }
    break;
  case 0x24f: switch(c1) {
 case 0x0e: code = 0xa0f8; break;
 case 0x5c: code = 0x98df; break;
 case 0x82: code = 0xfeb5; break;
 case 0x86: code = 0x9bcf; break;
 case 0x97: code = 0x96fb; break;
 case 0x9a: code = 0x9bfb; break;
 case 0xa9: code = 0x9ece; break;
 case 0xb8: code = 0x8ee5; break;
 case 0xc2: code = 0x9e7b; break;
    }
    break;
  case 0x250: switch(c1) {
 case 0x2c: code = 0x9bd2; break;
 case 0x52: code = 0x8aa5; break;
 case 0x9d: code = 0xfece; break;
    }
    break;
  case 0x251: switch(c1) {
 case 0x2b: code = 0x8a45; break;
 case 0x48: code = 0x9dfc; break;
 case 0x7d: code = 0xfecf; break;
 case 0x7e: code = 0x8ba5; break;
 case 0xcd: code = 0x8c4a; break;
 case 0xe3: code = 0x8aec; break;
 case 0xe6: code = 0xfce0; break;
 case 0xe7: code = 0x94ad; break;
    }
    break;
  case 0x252: switch(c1) {
 case 0x20: code = 0xfed5; break;
 case 0x21: code = 0x94ac; break;
 case 0x50: code = 0xfc5a; break;
 case 0x99: code = 0x9bd6; break;
 case 0xc7: code = 0x8a6f; break;
 case 0xd8: code = 0x8ba9; break;
    }
    break;
  case 0x253: switch(c1) {
 case 0x0e: code = 0x8e5f; break;
 case 0x11: code = 0x9dcb; break;
 case 0x13: code = 0xfce7; break;
    }
    break;
  case 0x254: switch(c1) {
 case 0x19: code = 0x9bd7; break;
 case 0x25: code = 0x93c8; break;
 case 0x2f: code = 0x91f0; break;
 case 0x30: code = 0x8fe0; break;
 case 0x46: code = 0x9bdb; break;
 case 0x6c: code = 0x90ed; break;
 case 0x6e: code = 0x9bdc; break;
    }
    break;
  case 0x255: switch(c1) {
 case 0x31: code = 0xa0ec; break;
 case 0x35: code = 0x98fa; break;
 case 0x3f: code = 0x9be0; break;
 case 0x5b: code = 0x93c7; break;
 case 0x5c: code = 0x9249; break;
 case 0x5d: code = 0x96e1; break;
 case 0x5e: code = 0x9be2; break;
 case 0x62: code = 0x9be4; break;
 case 0x65: code = 0x8fe1; break;
 case 0x66: code = 0x9be5; break;
 case 0x81: code = 0x94c0; break;
 case 0x84: code = 0x93c3; break;
 case 0x8f: code = 0x93c5; break;
 case 0xb9: code = 0x9079; break;
 case 0xd5: code = 0x977b; break;
 case 0xdb: code = 0x907e; break;
 case 0xe0: code = 0xfee6; break;
    }
    break;
  case 0x256: switch(c1) {
 case 0x05: code = 0xfe46; break;
 case 0x35: code = 0x9db8; break;
 case 0x51: code = 0x9270; break;
 case 0x83: code = 0x95a8; break;
 case 0x95: code = 0x8cb0; break;
 case 0xe3: code = 0x94c8; break;
 case 0xf6: code = 0x98b9; break;
    }
    break;
  case 0x257: switch(c1) {
 case 0x06: code = 0x9140; break;
 case 0x1d: code = 0xfcbe; break;
 case 0x25: code = 0x9157; break;
 case 0x3d: code = 0x8bb2; break;
 case 0x72: code = 0xfadf; break;
 case 0xc7: code = 0x9be6; break;
 case 0xdf: code = 0x9643; break;
 case 0xe0: code = 0x8e44; break;
 case 0xe1: code = 0x9c4f; break;
    }
    break;
  case 0x258: switch(c1) {
 case 0x57: code = 0xfef4; break;
 case 0x5d: code = 0x9be8; break;
 case 0x72: code = 0x93dc; break;
 case 0xc8: code = 0x966f; break;
 case 0xe1: code = 0x8e4a; break;
    }
    break;
  case 0x259: switch(c1) {
 case 0x03: code = 0x9bed; break;
 case 0x46: code = 0x92f6; break;
 case 0x56: code = 0x9db9; break;
 case 0xac: code = 0x8e4e; break;
 case 0xcc: code = 0xfbcf; break;
    }
    break;
  case 0x25a: switch(c1) {
 case 0x95: code = 0x9ec2; break;
 case 0x9c: code = 0x94e5; break;
 case 0xae: code = 0x9bf0; break;
 case 0xaf: code = 0x94e4; break;
 case 0xe9: code = 0x9551; break;
    }
    break;
  case 0x25b: switch(c1) {
 case 0x74: code = 0x8bbb; break;
 case 0x89: code = 0x9bf1; break;
 case 0xb3: code = 0x94f0; break;
 case 0xb4: code = 0x8e64; break;
 case 0xc6: code = 0x94ea; break;
 case 0xe4: code = 0x8f61; break;
 case 0xe8: code = 0x9b64; break;
    }
    break;
  case 0x25c: switch(c1) {
 case 0x01: code = 0x8e5b; break;
 case 0x06: code = 0x9bf2; break;
 case 0x21: code = 0x9fbe; break;
 case 0x4a: code = 0x9dc9; break;
 case 0x65: code = 0x8e6c; break;
 case 0x91: code = 0x8f73; break;
 case 0xa4: code = 0x8caf; break;
 case 0xc0: code = 0x8f75; break;
 case 0xc1: code = 0x8e71; break;
 case 0xfe: code = 0x8e60; break;
    }
    break;
  case 0x25d: switch(c1) {
 case 0x20: code = 0x8e6a; break;
 case 0x30: code = 0x8c4c; break;
 case 0x43: code = 0x9552; break;
    }
    break;
  case 0x25e: switch(c1) {
 case 0x0e: code = 0x9554; break;
 case 0x49: code = 0x8ad4; break;
 case 0x81: code = 0x9dbb; break;
 case 0x82: code = 0x9543; break;
 case 0x83: code = 0x92fe; break;
 case 0xa6: code = 0x94f2; break;
 case 0xbc: code = 0x94f1; break;
 case 0xd7: code = 0xa0ea; break;
 case 0xd8: code = 0x9dd2; break;
    }
    break;
  case 0x25f: switch(c1) {
 case 0x1a: code = 0xa0b1; break;
 case 0x4b: code = 0x91f8; break;
 case 0xe1: code = 0x9462; break;
 case 0xe2: code = 0x9ba4; break;
    }
    break;
  case 0x260: switch(c1) {
 case 0x29: code = 0x8ead; break;
 case 0x48: code = 0x9ead; break;
 case 0x64: code = 0x96d0; break;
 case 0x83: code = 0xfeee; break;
 case 0x97: code = 0x8ab4; break;
 case 0xa4: code = 0x9757; break;
 case 0xa5: code = 0x8a77; break;
    }
    break;
  case 0x261: switch(c1) {
 case 0x02: code = 0x9bf7; break;
 case 0x21: code = 0x8eb5; break;
 case 0x59: code = 0xa06d; break;
 case 0x5a: code = 0x8eb6; break;
 case 0x5b: code = 0x9756; break;
 case 0x5c: code = 0x9540; break;
 case 0xad: code = 0xa0f3; break;
 case 0xae: code = 0x94be; break;
 case 0xb2: code = 0x9bfa; break;
 case 0xdd: code = 0xfddf; break;
    }
    break;
  case 0x262: switch(c1) {
 case 0x58: code = 0x9dbc; break;
 case 0x61: code = 0x94fe; break;
 case 0x6a: code = 0x8bdb; break;
 case 0x6b: code = 0xa0fe; break;
 case 0xd0: code = 0x8ec0; break;
    }
    break;
  case 0x263: switch(c1) {
 case 0x35: code = 0x9f47; break;
 case 0x4b: code = 0x8bde; break;
 case 0x4c: code = 0xa0fb; break;
 case 0x51: code = 0x8ec3; break;
 case 0xbe: code = 0x9649; break;
 case 0xf5: code = 0xfec2; break;
 case 0xf8: code = 0x954c; break;
    }
    break;
  case 0x264: switch(c1) {
 case 0x02: code = 0x9bfd; break;
 case 0x10: code = 0x90cc; break;
 case 0x11: code = 0x9c60; break;
 case 0x12: code = 0x954b; break;
 case 0x4a: code = 0x9bfe; break;
 case 0x69: code = 0x9c70; break;
 case 0x84: code = 0x9c43; break;
 case 0x88: code = 0x9c47; break;
 case 0x89: code = 0x8ecc; break;
 case 0x8d: code = 0x8e54; break;
 case 0x98: code = 0x8ee4; break;
    }
    break;
  case 0x265: switch(c1) {
 case 0x12: code = 0x9c49; break;
 case 0x72: code = 0x8b5e; break;
 case 0xa0: code = 0x955e; break;
 case 0xad: code = 0x955c; break;
 case 0xbf: code = 0x9c4b; break;
    }
    break;
  case 0x266: switch(c1) {
 case 0x12: code = 0x8be1; break;
 case 0x26: code = 0x8ed9; break;
 case 0xaf: code = 0x9db4; break;
 case 0xb1: code = 0x925f; break;
 case 0xb5: code = 0x9c4c; break;
 case 0xda: code = 0x8aa1; break;
 case 0xe8: code = 0x8edb; break;
 case 0xfc: code = 0x9c56; break;
    }
    break;
  case 0x267: switch(c1) {
 case 0x16: code = 0x8aa2; break;
 case 0x41: code = 0x9754; break;
 case 0x99: code = 0x9c5e; break;
 case 0xb3: code = 0x9ed4; break;
 case 0xb4: code = 0x9568; break;
 case 0xcc: code = 0xa0c3; break;
    }
    break;
  case 0x268: switch(c1) {
 case 0x1c: code = 0x8ae6; break;
 case 0x46: code = 0xa0f7; break;
 case 0x5e: code = 0x9c61; break;
 case 0x6e: code = 0x9c5f; break;
 case 0x88: code = 0xfc4d; break;
 case 0x8a: code = 0x9e5b; break;
 case 0x93: code = 0x9e69; break;
 case 0xc7: code = 0x9c63; break;
    }
    break;
  case 0x269: switch(c1) {
 case 0x0e: code = 0xfec7; break;
 case 0x11: code = 0xfec6; break;
 case 0x26: code = 0x9c67; break;
 case 0x39: code = 0x9c69; break;
 case 0x51: code = 0x8be2; break;
 case 0xa8: code = 0x9165; break;
 case 0xb5: code = 0x9ce7; break;
 case 0xf2: code = 0x8a54; break;
 case 0xfa: code = 0x9c6c; break;
    }
    break;
  case 0x26a: switch(c1) {
 case 0x2d: code = 0x9c6e; break;
 case 0x2e: code = 0xfe5d; break;
 case 0x34: code = 0x9c73; break;
 case 0x42: code = 0x956a; break;
 case 0x51: code = 0x956d; break;
 case 0x52: code = 0x8ef0; break;
    }
    break;
  case 0x26b: switch(c1) {
 case 0x05: code = 0x8f4d; break;
 case 0x0a: code = 0x8ef6; break;
 case 0x13: code = 0xfabc; break;
 case 0x15: code = 0x8cd5; break;
 case 0x28: code = 0xfbda; break;
 case 0x50: code = 0x8b4c; break;
 case 0x51: code = 0xfd75; break;
 case 0x52: code = 0x9bdd; break;
 case 0x53: code = 0xfaf5; break;
 case 0x5b: code = 0x9c74; break;
 case 0x75: code = 0x9545; break;
 case 0x82: code = 0x96c6; break;
 case 0x96: code = 0x8f6a; break;
 case 0x97: code = 0x8f4e; break;
 case 0x9d: code = 0x9c78; break;
 case 0xb3: code = 0xfa55; break;
 case 0xc0: code = 0x97e4; break;
 case 0xf7: code = 0x9c41; break;
    }
    break;
  case 0x26c: switch(c1) {
 case 0x21: code = 0x925c; break;
 case 0x40: code = 0x96fa; break;
 case 0x7e: code = 0xfb66; break;
 case 0x7f: code = 0x8e65; break;
 case 0x80: code = 0x9849; break;
 case 0x81: code = 0xfba8; break;
 case 0x82: code = 0x9842; break;
 case 0xa4: code = 0x9c7a; break;
 case 0xb7: code = 0x97fb; break;
 case 0xb8: code = 0x90ca; break;
 case 0xbd: code = 0x9c5b; break;
 case 0xc0: code = 0x974d; break;
 case 0xc3: code = 0x8ed3; break;
 case 0xd1: code = 0x9561; break;
    }
    break;
  case 0x26d: switch(c1) {
 case 0x22: code = 0x9f4b; break;
 case 0x23: code = 0x9fb5; break;
 case 0x24: code = 0x93d2; break;
 case 0x25: code = 0xfdaa; break;
 case 0x26: code = 0x9840; break;
 case 0x27: code = 0x9146; break;
 case 0x28: code = 0x9867; break;
 case 0x29: code = 0xfa5a; break;
 case 0x2a: code = 0xfba9; break;
 case 0x51: code = 0x9841; break;
 case 0x74: code = 0x8cd3; break;
 case 0xa0: code = 0xfcfd; break;
 case 0xa1: code = 0xfdab; break;
 case 0xa2: code = 0x91bd; break;
 case 0xa3: code = 0x8f4c; break;
 case 0xa4: code = 0x96c9; break;
 case 0xa5: code = 0x8f55; break;
 case 0xa6: code = 0xfbae; break;
 case 0xa7: code = 0x956f; break;
 case 0xae: code = 0x9c7d; break;
 case 0xdc: code = 0xa0f0; break;
 case 0xea: code = 0x946f; break;
 case 0xeb: code = 0xfdac; break;
 case 0xf0: code = 0x96cb; break;
    }
    break;
  case 0x26e: switch(c1) {
 case 0x00: code = 0x96ce; break;
 case 0x05: code = 0xa056; break;
 case 0x07: code = 0x9ce1; break;
 case 0x12: code = 0x96c4; break;
 case 0x42: code = 0x8f5e; break;
 case 0x43: code = 0x8f6c; break;
 case 0x44: code = 0x8ea3; break;
 case 0x45: code = 0xfbb3; break;
 case 0x6e: code = 0xfc53; break;
 case 0x72: code = 0xfdb3; break;
 case 0x77: code = 0x8f6b; break;
 case 0x84: code = 0x96ca; break;
 case 0x99: code = 0x8f79; break;
 case 0xd0: code = 0x9e6f; break;
 case 0xd1: code = 0xa0c5; break;
 case 0xd2: code = 0xfc78; break;
 case 0xd3: code = 0x8e42; break;
 case 0xd4: code = 0x8f5a; break;
 case 0xd5: code = 0x90c2; break;
 case 0xd6: code = 0x8ea5; break;
 case 0xd7: code = 0x9061; break;
    }
    break;
  case 0x26f: switch(c1) {
 case 0x26: code = 0x924f; break;
 case 0x73: code = 0x9373; break;
 case 0x74: code = 0xfdb5; break;
 case 0x9f: code = 0xfecc; break;
 case 0xa1: code = 0xfbbd; break;
 case 0xbe: code = 0x8cd6; break;
 case 0xde: code = 0x9843; break;
 case 0xdf: code = 0x96c5; break;
    }
    break;
  case 0x270: switch(c1) {
 case 0x0e: code = 0x89bc; break;
 case 0x4b: code = 0x9ca3; break;
 case 0x52: code = 0x924b; break;
 case 0x53: code = 0x984a; break;
 case 0x88: code = 0x8fa4; break;
 case 0xad: code = 0xa0f1; break;
 case 0xae: code = 0x9efb; break;
 case 0xaf: code = 0x9cd2; break;
 case 0xcd: code = 0x8fa7; break;
 case 0xf8: code = 0xfc5c; break;
    }
    break;
  case 0x271: switch(c1) {
 case 0x09: code = 0x9845; break;
 case 0x0c: code = 0x9046; break;
 case 0x0d: code = 0x8cd1; break;
 case 0x26: code = 0xfefa; break;
 case 0x27: code = 0x9560; break;
 case 0x64: code = 0x9f48; break;
 case 0x65: code = 0x9247; break;
 case 0x75: code = 0x90fb; break;
 case 0xcd: code = 0x9ca4; break;
    }
    break;
  case 0x272: switch(c1) {
 case 0x1b: code = 0x9571; break;
 case 0x80: code = 0x9ca6; break;
 case 0x85: code = 0x9ca7; break;
 case 0x8b: code = 0x9caa; break;
 case 0xb2: code = 0x9ed3; break;
 case 0xb6: code = 0x9e70; break;
 case 0xe6: code = 0x9cac; break;
    }
    break;
  case 0x273: switch(c1) {
    case 0x9a: code = 0x8fae; break;
    }
    break;
  case 0x274: switch(c1) {
 case 0x22: code = 0x957d; break;
 case 0x50: code = 0x9cb0; break;
 case 0x84: code = 0x97b6; break;
 case 0x86: code = 0xa0bd; break;
    }
    break;
  case 0x275: switch(c1) {
 case 0x74: code = 0x8adf; break;
 case 0xa3: code = 0x9eaa; break;
 case 0xe0: code = 0x8fbd; break;
 case 0xe4: code = 0x8fbf; break;
 case 0xfd: code = 0x9369; break;
 case 0xfe: code = 0x9ba7; break;
    }
    break;
  case 0x276: switch(c1) {
 case 0x0c: code = 0xfeea; break;
 case 0x32: code = 0x9be1; break;
 case 0x39: code = 0x8b41; break;
 case 0x55: code = 0x9db6; break;
 case 0x56: code = 0xa0eb; break;
 case 0x57: code = 0x9ba3; break;
 case 0x94: code = 0x8ba1; break;
    }
    break;
  case 0x277: switch(c1) {
 case 0x0f: code = 0x8fc8; break;
 case 0x35: code = 0x894c; break;
 case 0x36: code = 0x9860; break;
 case 0x41: code = 0x94c7; break;
 case 0x5e: code = 0x8b58; break;
 case 0x84: code = 0x95ab; break;
 case 0x85: code = 0x95aa; break;
 case 0xcc: code = 0x9cc3; break;
    }
    break;
  case 0x278: switch(c1) {
 case 0x58: code = 0x9cc4; break;
 case 0x70: code = 0x93d6; break;
 case 0x9d: code = 0x9dac; break;
 case 0xb2: code = 0x8be6; break;
 case 0xc8: code = 0x8a71; break;
    }
    break;
  case 0x279: switch(c1) {
 case 0x24: code = 0x8fd1; break;
 case 0x67: code = 0x99d5; break;
 case 0x7a: code = 0x90f4; break;
 case 0xa0: code = 0x8aa3; break;
 case 0xdd: code = 0x9cce; break;
 case 0xfd: code = 0x9cd4; break;
    }
    break;
  case 0x27a: switch(c1) {
 case 0x0a: code = 0x9cd5; break;
 case 0x0e: code = 0xfbc8; break;
 case 0x3e: code = 0x9db3; break;
 case 0x53: code = 0xfc70; break;
 case 0x59: code = 0x8fd7; break;
 case 0x79: code = 0x9b73; break;
 case 0x84: code = 0xfa5b; break;
 case 0xbd: code = 0x8fd2; break;
 case 0xbe: code = 0x9064; break;
 case 0xf4: code = 0x98b6; break;
    }
    break;
  case 0x27b: switch(c1) {
 case 0x06: code = 0x9668; break;
 case 0x0b: code = 0x9cd6; break;
 case 0x18: code = 0x98bd; break;
 case 0x38: code = 0x8fdc; break;
 case 0x39: code = 0xfef6; break;
 case 0x3a: code = 0x8fd9; break;
 case 0x48: code = 0x9541; break;
 case 0xf4: code = 0x97f3; break;
    }
    break;
  case 0x27c: switch(c1) {
    case 0x12: code = 0x9bf8; break;
    }
    break;
  case 0x27d: switch(c1) {
 case 0x2f: code = 0x9e6c; break;
 case 0x53: code = 0x8ff2; break;
 case 0x54: code = 0x8fee; break;
 case 0x66: code = 0x9cd7; break;
 case 0x73: code = 0x9e6e; break;
 case 0x84: code = 0x8a40; break;
 case 0x8f: code = 0x8fef; break;
 case 0x98: code = 0x8ff4; break;
 case 0xbd: code = 0x8ff5; break;
 case 0xdc: code = 0x95c2; break;
    }
    break;
  case 0x27e: switch(c1) {
    case 0x4d: code = 0x986a; break;
    case 0x4f: code = 0x97cf; break;
    }
    break;
  case 0x27f: switch(c1) {
    case 0xf9: code = 0x9e7c; break;
    }
    break;
  case 0x280: switch(c1) {
 case 0x02: code = 0x9041; break;
 case 0x09: code = 0x9cdb; break;
 case 0x1e: code = 0x9441; break;
 case 0x23: code = 0x9ce6; break;
 case 0x24: code = 0x9db0; break;
 case 0x48: code = 0x9cea; break;
 case 0x83: code = 0x9ced; break;
 case 0x90: code = 0x9cfa; break;
 case 0xbd: code = 0x8b62; break;
 case 0xbe: code = 0x8a4e; break;
 case 0xe8: code = 0x9cca; break;
 case 0xe9: code = 0x8a66; break;
 case 0xf4: code = 0x9cfb; break;
    }
    break;
  case 0x281: switch(c1) {
 case 0x2e: code = 0x9cfc; break;
 case 0x4f: code = 0x9cfe; break;
 case 0x5d: code = 0x8a53; break;
 case 0x6f: code = 0x9ce5; break;
 case 0x89: code = 0x9d40; break;
 case 0xaf: code = 0x9d41; break;
 case 0xbc: code = 0x9045; break;
    }
    break;
  case 0x282: switch(c1) {
 case 0x07: code = 0x8b73; break;
 case 0x18: code = 0x97ca; break;
 case 0x1a: code = 0x9d42; break;
 case 0x56: code = 0x8a61; break;
 case 0x7c: code = 0x8bae; break;
 case 0x9b: code = 0x8ad2; break;
 case 0xcd: code = 0x8ba2; break;
 case 0xe2: code = 0x9df2; break;
    }
    break;
  case 0x283: switch(c1) {
 case 0x06: code = 0x9d43; break;
 case 0x18: code = 0x9cdf; break;
 case 0x2f: code = 0x9d44; break;
 case 0x3a: code = 0x8eca; break;
 case 0x65: code = 0x904e; break;
 case 0x6d: code = 0x8eb3; break;
 case 0x7d: code = 0x9ff5; break;
 case 0x8a: code = 0x9d45; break;
    }
    break;
  case 0x284: switch(c1) {
 case 0x12: code = 0x904f; break;
 case 0x68: code = 0x9d47; break;
 case 0x6c: code = 0x89ca; break;
 case 0x73: code = 0x9cb5; break;
 case 0x82: code = 0xfbfe; break;
    }
    break;
  case 0x285: switch(c1) {
 case 0x01: code = 0x905e; break;
 case 0x3c: code = 0x9063; break;
 case 0x3d: code = 0x9057; break;
 case 0x6c: code = 0x9066; break;
 case 0xe8: code = 0x9bc0; break;
 case 0xf4: code = 0xfce5; break;
    }
    break;
  case 0x286: switch(c1) {
 case 0x00: code = 0x9162; break;
 case 0x0b: code = 0x9067; break;
 case 0x25: code = 0x8fa1; break;
 case 0x3b: code = 0x8fa2; break;
 case 0xaa: code = 0x9d48; break;
 case 0xab: code = 0xfad3; break;
 case 0xbc: code = 0x905d; break;
 case 0xd8: code = 0x90b9; break;
 case 0xe6: code = 0x906b; break;
    }
    break;
  case 0x287: switch(c1) {
 case 0x0f: code = 0x8c5c; break;
 case 0x13: code = 0x9069; break;
    }
    break;
  case 0x288: switch(c1) {
 case 0x04: code = 0xfe57; break;
 case 0x2b: code = 0xfe55; break;
    }
    break;
  case 0x289: switch(c1) {
 case 0x33: code = 0x9073; break;
 case 0x48: code = 0x9bef; break;
 case 0x49: code = 0x9cf0; break;
 case 0x56: code = 0x9d4b; break;
 case 0x64: code = 0xfed9; break;
 case 0x68: code = 0xfeda; break;
 case 0x6c: code = 0x91e0; break;
 case 0x7e: code = 0x91d8; break;
 case 0x89: code = 0x9646; break;
 case 0xa8: code = 0x9360; break;
 case 0xaa: code = 0xfa53; break;
 case 0xab: code = 0x9cd3; break;
 case 0xb8: code = 0x9d4e; break;
 case 0xbc: code = 0xfb40; break;
 case 0xc0: code = 0x8de2; break;
 case 0xdc: code = 0x9442; break;
 case 0xde: code = 0x9056; break;
 case 0xe1: code = 0x9865; break;
 case 0xe3: code = 0x8c6c; break;
 case 0xe4: code = 0xfa4a; break;
 case 0xe7: code = 0x9d50; break;
 case 0xe8: code = 0x9d52; break;
 case 0xf9: code = 0x95af; break;
 case 0xfa: code = 0x975a; break;
 case 0xfb: code = 0x9349; break;
 case 0xfc: code = 0x9747; break;
    }
    break;
  case 0x28a: switch(c1) {
 case 0x0f: code = 0xa0f4; break;
 case 0x16: code = 0x9778; break;
 case 0x25: code = 0x8fcf; break;
 case 0x29: code = 0xfc60; break;
 case 0x32: code = 0x8c4e; break;
 case 0x36: code = 0xfc56; break;
 case 0x44: code = 0x91dc; break;
 case 0x45: code = 0x9661; break;
 case 0x46: code = 0x92ec; break;
 case 0x47: code = 0x935d; break;
 case 0x48: code = 0x8ede; break;
 case 0x49: code = 0x96fe; break;
 case 0x4a: code = 0xfd4f; break;
 case 0x4b: code = 0x95de; break;
 case 0x59: code = 0x98b0; break;
 case 0x5a: code = 0xa040; break;
 case 0x81: code = 0x97bd; break;
 case 0x82: code = 0x977d; break;
 case 0x83: code = 0x97f5; break;
 case 0x9a: code = 0x9bac; break;
 case 0x9b: code = 0xfada; break;
 case 0x9c: code = 0x92c2; break;
 case 0xc0: code = 0x97b1; break;
 case 0xc6: code = 0x907b; break;
 case 0xcb: code = 0x93fe; break;
 case 0xcc: code = 0x947b; break;
 case 0xce: code = 0x9777; break;
 case 0xde: code = 0xfabe; break;
 case 0xdf: code = 0xfd43; break;
 case 0xe0: code = 0x90c6; break;
 case 0xe1: code = 0x90a4; break;
 case 0xe2: code = 0x90a8; break;
 case 0xe3: code = 0x94a9; break;
 case 0xe5: code = 0x90a9; break;
 case 0xea: code = 0x8c65; break;
 case 0xfc: code = 0x95e0; break;
    }
    break;
  case 0x28b: switch(c1) {
 case 0x0c: code = 0x907d; break;
 case 0x13: code = 0x9265; break;
 case 0x21: code = 0xfdba; break;
 case 0x22: code = 0x93c4; break;
 case 0x2b: code = 0xfeed; break;
 case 0x2c: code = 0x9dab; break;
 case 0x2d: code = 0xa0e3; break;
 case 0x2f: code = 0x9648; break;
 case 0x46: code = 0x9d53; break;
 case 0x4c: code = 0x8aa9; break;
 case 0x4e: code = 0x9bc5; break;
 case 0x50: code = 0x965d; break;
 case 0x63: code = 0x975f; break;
 case 0x64: code = 0x965f; break;
 case 0x65: code = 0x966e; break;
 case 0x66: code = 0xfb5d; break;
 case 0x6c: code = 0x9db1; break;
 case 0x8f: code = 0xfea3; break;
 case 0x99: code = 0x9db2; break;
 case 0x9c: code = 0x95ae; break;
 case 0x9d: code = 0xfca3; break;
 case 0xc2: code = 0xa0a2; break;
 case 0xc5: code = 0x9655; break;
 case 0xd4: code = 0x9d54; break;
 case 0xd7: code = 0x9341; break;
 case 0xd9: code = 0x95ad; break;
 case 0xda: code = 0x91d5; break;
 case 0xe7: code = 0x977a; break;
 case 0xe8: code = 0xfdfc; break;
 case 0xe9: code = 0x8e47; break;
 case 0xea: code = 0x93fd; break;
 case 0xeb: code = 0x90a5; break;
 case 0xec: code = 0x90ac; break;
 case 0xf5: code = 0x95ac; break;
 case 0xff: code = 0x90ae; break;
    }
    break;
  case 0x28c: switch(c1) {
 case 0x03: code = 0xfea5; break;
 case 0x09: code = 0x9d56; break;
 case 0x1c: code = 0x97e3; break;
 case 0x1d: code = 0x95e2; break;
 case 0x23: code = 0x9466; break;
 case 0x26: code = 0x9647; break;
 case 0x2b: code = 0x91b8; break;
 case 0x30: code = 0x9cec; break;
 case 0x39: code = 0x90ad; break;
 case 0x3b: code = 0x95e3; break;
 case 0xca: code = 0x8b4f; break;
 case 0xcd: code = 0x8ae3; break;
 case 0xd2: code = 0x8b4d; break;
    }
    break;
  case 0x28d: switch(c1) {
    case 0x34: code = 0x95ea; break;
    case 0x99: code = 0x8b4e; break;
    case 0xb9: code = 0x8cc1; break;
    }
    break;
  case 0x28e: switch(c1) {
 case 0x0f: code = 0x8bed; break;
 case 0x36: code = 0x91d9; break;
 case 0x39: code = 0xa0a4; break;
 case 0x65: code = 0x95f5; break;
 case 0x66: code = 0x95f4; break;
 case 0x97: code = 0x9fb3; break;
 case 0xac: code = 0xfeaf; break;
 case 0xb2: code = 0xfe72; break;
 case 0xb3: code = 0x927a; break;
 case 0xd9: code = 0xfeac; break;
 case 0xe7: code = 0x95f3; break;
    }
    break;
  case 0x28f: switch(c1) {
    case 0xc5: code = 0x9d58; break;
    }
    break;
  case 0x290: switch(c1) {
 case 0x88: code = 0x9372; break;
 case 0x8b: code = 0x91c5; break;
 case 0x93: code = 0x9642; break;
 case 0xaf: code = 0x90cd; break;
 case 0xb0: code = 0x95fe; break;
 case 0xb1: code = 0x9159; break;
 case 0xc0: code = 0x9c65; break;
 case 0xe4: code = 0x97cc; break;
 case 0xe5: code = 0x90ce; break;
 case 0xec: code = 0x9d59; break;
 case 0xed: code = 0xfcf5; break;
    }
    break;
  case 0x291: switch(c1) {
 case 0x0d: code = 0xfefd; break;
 case 0x10: code = 0x9d5b; break;
 case 0x3c: code = 0x9d5c; break;
 case 0x4d: code = 0x937e; break;
 case 0x5b: code = 0x98ac; break;
 case 0x5e: code = 0x9d5e; break;
 case 0x70: code = 0xfdd0; break;
 case 0x9c: code = 0xfd60; break;
 case 0xa8: code = 0x9ccf; break;
 case 0xd5: code = 0x90dd; break;
 case 0xeb: code = 0x90e0; break;
    }
    break;
  case 0x294: switch(c1) {
 case 0x1d: code = 0x90f3; break;
 case 0x20: code = 0x98b1; break;
 case 0x33: code = 0x90f0; break;
 case 0x3f: code = 0x93bd; break;
 case 0x48: code = 0x95b7; break;
 case 0xd0: code = 0x9f46; break;
 case 0xd9: code = 0x8e4b; break;
 case 0xda: code = 0x9658; break;
 case 0xe5: code = 0x8a4c; break;
 case 0xe7: code = 0x9d63; break;
    }
    break;
  case 0x295: switch(c1) {
 case 0x9e: code = 0x9ecf; break;
 case 0xb0: code = 0x9d65; break;
 case 0xb8: code = 0x9d66; break;
 case 0xd7: code = 0x965a; break;
 case 0xe9: code = 0x9d64; break;
 case 0xf4: code = 0x8a6c; break;
    }
    break;
  case 0x297: switch(c1) {
    case 0x20: code = 0x8ad9; break;
    case 0x32: code = 0x9d67; break;
    case 0xd4: code = 0x8a70; break;
    default: break;
    }
    break;
  case 0x298: switch(c1) {
 case 0x10: code = 0x8bf3; break;
 case 0x57: code = 0x9150; break;
 case 0xa4: code = 0x9cc1; break;
 case 0xd1: code = 0x9d68; break;
 case 0xea: code = 0x93a7; break;
 case 0xf1: code = 0x9674; break;
    }
    break;
  case 0x299: switch(c1) {
 case 0x03: code = 0xa0ef; break;
 case 0x05: code = 0x9151; break;
 case 0x2f: code = 0x96c1; break;
 case 0x47: code = 0x8c64; break;
 case 0x48: code = 0x9676; break;
 case 0x49: code = 0x9d69; break;
 case 0x5d: code = 0xfca4; break;
 case 0x6a: code = 0x9d6a; break;
 case 0x9d: code = 0x924e; break;
 case 0xc3: code = 0x9d6b; break;
 case 0xc9: code = 0x9bc1; break;
    }
    break;
  case 0x29a: switch(c1) {
 case 0x28: code = 0x9d6c; break;
 case 0x4d: code = 0x8a65; break;
    }
    break;
  case 0x29b: switch(c1) {
 case 0x05: code = 0x915d; break;
 case 0x0e: code = 0x9d6d; break;
 case 0xd5: code = 0x915a; break;
    }
    break;
  case 0x29c: switch(c1) {
 case 0x73: code = 0x8c42; break;
 case 0xad: code = 0x9cc0; break;
    }
    break;
  case 0x29d: switch(c1) {
 case 0x3e: code = 0x916a; break;
 case 0x5a: code = 0x9d6e; break;
 case 0x7c: code = 0x9ea6; break;
 case 0x98: code = 0x9dcd; break;
 case 0x9b: code = 0x9d6f; break;
 case 0xf6: code = 0x89bb; break;
    }
    break;
  case 0x29e: switch(c1) {
 case 0x06: code = 0x9ef9; break;
 case 0x2d: code = 0x96b4; break;
 case 0x68: code = 0x9172; break;
 case 0xac: code = 0x9ec8; break;
 case 0xc3: code = 0x8b55; break;
 case 0xf8: code = 0x9d71; break;
    }
    break;
  case 0x29f: switch(c1) {
 case 0x23: code = 0x9d72; break;
 case 0x30: code = 0x9ecc; break;
 case 0xb7: code = 0x9174; break;
 case 0xde: code = 0x9ed0; break;
    }
    break;
  case 0x2a0: switch(c1) {
 case 0x14: code = 0x905c; break;
 case 0x87: code = 0x8ed2; break;
 case 0xb9: code = 0x91a8; break;
 case 0xe1: code = 0x9177; break;
 case 0xed: code = 0x96bf; break;
 case 0xf3: code = 0x96c0; break;
 case 0xf8: code = 0x8fb1; break;
 case 0xfe: code = 0x96b7; break;
    }
    break;
  case 0x2a1: switch(c1) {
 case 0x07: code = 0x8c55; break;
 case 0x23: code = 0x9178; break;
 case 0x33: code = 0x89be; break;
 case 0x34: code = 0x917c; break;
 case 0x50: code = 0xfb77; break;
 case 0x92: code = 0x9175; break;
 case 0x93: code = 0x91a3; break;
 case 0xab: code = 0x9176; break;
 case 0xb4: code = 0x96be; break;
 case 0xdf: code = 0x9179; break;
 case 0xf5: code = 0x96b6; break;
    }
    break;
  case 0x2a2: switch(c1) {
    case 0x20: code = 0x91a4; break;
    case 0x33: code = 0x91a6; break;
    case 0x93: code = 0x9d75; break;
    case 0x9f: code = 0x9052; break;
    case 0xb2: code = 0xa045; break;
    case 0xb4: code = 0x91a9; break;
    case 0xb6: code = 0x98aa; break;
    case 0xba: code = 0x8c5f; break;
    case 0xbd: code = 0x8baa; break;
    case 0xdf: code = 0x9cdd; break;
    case 0xff: code = 0x9d77; break;
    }
    break;
  case 0x2a3: switch(c1) {
    case 0xa9: code = 0x8940; break;
    }break;
  case 0x2a4: switch(c1) {
    case 0x34: code = 0x9eec; break;
    case 0x5b: code = 0x93aa; break;
    }
    break;
  case 0x2a5: switch(c1) {
    case 0xc6: code = 0x9478; break;
    case 0xcb: code = 0x9d7a; break;
    }
    break;
  case 0x2a6: switch(c1) {
    case 0x01: code = 0x8ac9; break;
    case 0x32: code = 0x8b4b; break;
    case 0x4a: code = 0x9fec; break;
    case 0x5b: code = 0x8ae2; break;
    case 0xa9: code = 0x9e75; break;
    }
    break;
  case 0x2f8: switch(c1) {
    case 0x25: code = 0x9874; break;
    case 0x3b: code = 0x9ac8; break;
    case 0x40: code = 0xa047; break;
    case 0x78: code = 0x8bc3; break;
    case 0x94: code = 0xfc48; break;
    case 0xa6: code = 0xfc77; break;
    case 0xcd: code = 0x9c52; break;
    }
    break;
  case 0x2f9: switch(c1) {
    case 0x94: code = 0x8efd; break;
    case 0xb2: code = 0x8fa8; break;
    case 0xbc: code = 0x957a; break;
    case 0xd4: code = 0x8ff0; break;
    }
  default: break;
  }
  if(code == 0) return dps_wc_mb_cp950(conv, cs, wc, s, e);

  conv->icodes = 1;
  s[0] = (code >> 8) & 0xFF;
  s[1] = code & 0xFF;
  
  return conv->ocodes = 2;
}


#endif /* HAVE_CHARSET_chinese*/

