/* Copyright (C) 2003-2006 Datapark corp. All rights reserved.
   Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "dps_config.h"
#include <string.h>
#include "dps_uniconv.h"
#include "dps_charsetutils.h"


int dps_wc_mb_sys_int (DPS_CONV *conv, DPS_CHARSET *cs, const dpsunicode_t *wc, unsigned char *s, unsigned char *e) {
  
  conv->icodes = conv->ocodes = 1;

  if ( s+sizeof(dpsunicode_t) > e)
    return DPS_CHARSET_TOOSMALL;
  
  dps_memcpy(s, wc, sizeof(dpsunicode_t));
  
  return sizeof(dpsunicode_t);
}


int dps_mb_wc_sys_int (DPS_CONV *conv, DPS_CHARSET *cs, dpsunicode_t *pwc, const unsigned char *s, const unsigned char *e) {
  
  conv->icodes = conv->ocodes = 1;

  if (s+sizeof(dpsunicode_t) > e)
    return DPS_CHARSET_TOOFEW(0);
  
  dps_memcpy(pwc, s, sizeof(dpsunicode_t));
  
  return sizeof(dpsunicode_t);
}

