/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import java.lang.reflect.Field;
import java.util.LinkedList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerRegistry {
    public static final String[] GENERIC_JAVA_COMPILERS = new String[]{"edu.rice.cs.drjava.model.compiler.Javac150FromSetLocation", "edu.rice.cs.drjava.model.compiler.Javac150FromClasspath", "edu.rice.cs.drjava.model.compiler.Javac150FromToolsJar", "edu.rice.cs.drjava.model.compiler.JSR14v20FromSetLocation", "edu.rice.cs.drjava.model.compiler.JSR14v12FromSetLocation", "edu.rice.cs.drjava.model.compiler.JSR14FromSetLocation"};
    static final String[][] DEFAULT_COMPILERS = new String[][]{GENERIC_JAVA_COMPILERS, {"edu.rice.cs.drjava.model.compiler.Javac141FromSetLocation", "edu.rice.cs.drjava.model.compiler.Javac141FromClasspath", "edu.rice.cs.drjava.model.compiler.Javac141FromToolsJar"}, {"edu.rice.cs.drjava.model.compiler.JavacFromSetLocation", "edu.rice.cs.drjava.model.compiler.JavacFromClasspath", "edu.rice.cs.drjava.model.compiler.JavacFromToolsJar"}};
    public static final CompilerRegistry ONLY = new CompilerRegistry();
    private ClassLoader _baseClassLoader;
    private CompilerInterface _activeCompiler = NoCompilerAvailable.ONLY;

    private CompilerRegistry() {
        this._baseClassLoader = this.getClass().getClassLoader();
    }

    public void setBaseClassLoader(ClassLoader l) {
        this._baseClassLoader = l;
    }

    public ClassLoader getBaseClassLoader() {
        return this._baseClassLoader;
    }

    public CompilerInterface[] getAvailableCompilers() {
        LinkedList<CompilerInterface> availableCompilers = new LinkedList<CompilerInterface>();
        String[][] arr$ = DEFAULT_COMPILERS;
        int len$ = arr$.length;
        block2: for (int i$ = 0; i$ < len$; ++i$) {
            String[] row;
            for (String name : row = arr$[i$]) {
                try {
                    if (!this._createCompiler(name, availableCompilers)) continue;
                    continue block2;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (availableCompilers.size() == 0) {
            availableCompilers.add(NoCompilerAvailable.ONLY);
        }
        return availableCompilers.toArray(new CompilerInterface[availableCompilers.size()]);
    }

    private boolean _createCompiler(String name, LinkedList<CompilerInterface> availableCompilers) throws Throwable {
        CompilerInterface compiler = this._instantiateCompiler(name);
        if (compiler.isAvailable()) {
            if (this._activeCompiler == NoCompilerAvailable.ONLY) {
                this._activeCompiler = compiler;
            }
            availableCompilers.add(compiler);
            return true;
        }
        return false;
    }

    public boolean isNoCompilerAvailable() {
        return this.getActiveCompiler() == NoCompilerAvailable.ONLY;
    }

    public void setActiveCompiler(CompilerInterface compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException("Cannot set active compiler to null.");
        }
        this._activeCompiler = compiler;
    }

    public CompilerInterface getActiveCompiler() {
        if (this._activeCompiler == NoCompilerAvailable.ONLY) {
            this.getAvailableCompilers();
        }
        if (this._activeCompiler.isAvailable()) {
            return this._activeCompiler;
        }
        return NoCompilerAvailable.ONLY;
    }

    private CompilerInterface _instantiateCompiler(String name) throws Throwable {
        Class<?> clazz = this._baseClassLoader.loadClass(name);
        return CompilerRegistry.createCompiler(clazz);
    }

    public static CompilerInterface createCompiler(Class clazz) throws Throwable {
        try {
            Field field = clazz.getField("ONLY");
            Object val = field.get(null);
            return (CompilerInterface)val;
        }
        catch (Throwable t) {
            return (CompilerInterface)clazz.newInstance();
        }
    }
}

