/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.DebugAction;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.JPDADebugger;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import java.io.File;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentDebugAction<T extends EventRequest>
extends DebugAction<T> {
    protected String _className;
    protected File _file;
    protected OpenDefinitionsDocument _doc;

    public DocumentDebugAction(JPDADebugger manager, OpenDefinitionsDocument doc, int offset) throws DebugException {
        super(manager);
        try {
            if (offset >= 0) {
                this._className = doc.getQualifiedClassName(offset);
            }
        }
        catch (ClassNameNotFoundException cnnfe) {
            try {
                this._className = doc.getQualifiedClassName();
            }
            catch (ClassNameNotFoundException cnnfe2) {
                this._className = "";
            }
        }
        try {
            this._file = doc.getFile();
        }
        catch (FileMovedException fme) {
            throw new DebugException(new StringBuffer().append("This document's file no longer exists: ").append(fme.getMessage()).toString());
        }
        catch (IllegalStateException ise) {
            throw new DebugException(new StringBuffer().append("This document has no file: ").append(ise.getMessage()).toString());
        }
        this._doc = doc;
    }

    public String getClassName() {
        return this._className;
    }

    public File getFile() {
        return this._file;
    }

    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public boolean createRequests(Vector<ReferenceType> refTypes) throws DebugException {
        this._createRequests(refTypes);
        if (this._requests.size() > 0) {
            this._prepareRequests(this._requests);
            return true;
        }
        return false;
    }

    protected void _initializeRequests(Vector<ReferenceType> refTypes) throws DebugException {
        if (refTypes.size() > 0) {
            this.createRequests(refTypes);
        }
        this._manager.getPendingRequestManager().addPendingRequest(this);
    }

    protected abstract void _createRequests(Vector<ReferenceType> var1) throws DebugException;

    @Override
    protected void _prepareRequest(T request) {
        super._prepareRequest(request);
        request.putProperty("document", this._doc);
    }
}

