/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.AbstractReducedModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.IndentInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;

public class ReducedModelComment
extends AbstractReducedModel {
    TokenList.Iterator _walker;

    public ReducedModelComment() {
        this._walker = this._cursor._copy();
    }

    public void insertChar(char ch) {
        switch (ch) {
            case '*': {
                this.insertSpecial("*");
                break;
            }
            case '/': {
                this.insertSpecial("/");
                break;
            }
            case '\n': {
                this.insertNewline();
                break;
            }
            case '\\': {
                this.insertSpecial("\\");
                break;
            }
            case '\'': {
                this.insertQuote("'");
                break;
            }
            case '\"': {
                this.insertQuote("\"");
                break;
            }
            default: {
                this._insertGap(1);
            }
        }
    }

    private void insertSpecial(String special) {
        if (this._tokens.isEmpty()) {
            this._cursor.insertNewBrace(special);
            return;
        }
        if (this._cursor.atStart()) {
            this._cursor.next();
        }
        if (this._cursor.atEnd()) {
            this._checkPreviousInsertSpecial(special);
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
            this._cursor._splitCurrentIfCommentBlock(true, true);
            this._cursor.next();
            this._cursor.insertNewBrace(special);
            this.move(-2);
            this._updateBasedOnCurrentState();
            this.move(2);
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isGap()) {
            this._cursor.insertBraceToGap(special);
            this._cursor.prev();
            this._cursor.prev();
            this._updateBasedOnCurrentState();
            this._cursor.next();
            this._cursor.next();
        } else if (this._cursor.getBlockOffset() == 0 && ((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
            this._cursor._splitCurrentIfCommentBlock(false, special.equals("\\"));
            this._checkPreviousInsertSpecial(special);
        } else {
            this._checkPreviousInsertSpecial(special);
        }
    }

    private void _checkPreviousInsertSpecial(String special) {
        if (special.equals("\\")) {
            this._checkPreviousInsertBackSlash();
        } else {
            this._checkPreviousInsertCommentChar(special);
        }
    }

    private void _checkPreviousInsertBackSlash() {
        if (!this._cursor.atStart() && !this._cursor.atFirstItem() && ((ReducedToken)this._cursor.prevItem()).getType().equals("\\")) {
            ((ReducedToken)this._cursor.prevItem()).setType("\\\\");
            this._updateBasedOnCurrentState();
            return;
        }
        this._cursor.insertNewBrace("\\");
        this._cursor.prev();
        this._updateBasedOnCurrentState();
        if (((ReducedToken)this._cursor.current()).getSize() == 2) {
            this._cursor.setBlockOffset(1);
        } else {
            this._cursor.next();
        }
    }

    private void _checkPreviousInsertCommentChar(String special) {
        if (!this._cursor.atStart() && !this._cursor.atFirstItem()) {
            if (((ReducedToken)this._cursor.prevItem()).getType().equals("/") && ((ReducedToken)this._cursor.prevItem()).getState() == FREE) {
                ((ReducedToken)this._cursor.prevItem()).setType("/" + special);
                this._updateBasedOnCurrentState();
                return;
            }
            if (((ReducedToken)this._cursor.prevItem()).getType().equals("*") && this.getStateAtCurrent() == INSIDE_BLOCK_COMMENT && special.equals("/")) {
                ((ReducedToken)this._cursor.prevItem()).setType("*" + special);
                ((ReducedToken)this._cursor.prevItem()).setState(FREE);
                this._updateBasedOnCurrentState();
                return;
            }
        }
        this._cursor.insertNewBrace(special);
        this._cursor.prev();
        this._updateBasedOnCurrentState();
        if (((ReducedToken)this._cursor.current()).getSize() == 2) {
            this._cursor.setBlockOffset(1);
        } else {
            this._cursor.next();
        }
    }

    public void insertNewline() {
        if (this._cursor.atStart()) {
            this._insertNewEndOfLine();
        } else if (this._cursor.atEnd()) {
            this._insertNewEndOfLine();
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
            this._cursor._splitCurrentIfCommentBlock(true, true);
            this._cursor.next();
            this._cursor.insert(Brace.MakeBrace("\n", this.getStateAtCurrent()));
            this._cursor.prev();
            this._updateBasedOnCurrentState();
            this._cursor.next();
            this._cursor.next();
            this._cursor.setBlockOffset(0);
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isGap()) {
            this._cursor.insertBraceToGap("\n");
            this._cursor.prev();
            this._cursor.prev();
            this._updateBasedOnCurrentState();
            this._cursor.next();
            this._cursor.next();
        } else {
            this._insertNewEndOfLine();
        }
    }

    private void _insertNewEndOfLine() {
        this._cursor.insertNewBrace("\n");
        this._cursor.prev();
        this._updateBasedOnCurrentState();
        this._cursor.next();
        this._cursor.setBlockOffset(0);
    }

    public void insertQuote(String quote) {
        if (this._cursor.atStart()) {
            this._insertNewQuote(quote);
        } else if (this._cursor.atEnd()) {
            this._insertNewQuote(quote);
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
            this._cursor._splitCurrentIfCommentBlock(true, true);
            this._cursor.next();
            this._cursor.insert(Brace.MakeBrace(quote, this.getStateAtCurrent()));
            this._cursor.prev();
            this._updateBasedOnCurrentState();
            if (!((ReducedToken)this._cursor.current()).isMultipleCharBrace()) {
                this._cursor.next();
            }
            this._cursor.next();
            this._cursor.setBlockOffset(0);
        } else if (this._cursor.getBlockOffset() > 0 && ((ReducedToken)this._cursor.current()).isGap()) {
            this._cursor.insertBraceToGap(quote);
            this._cursor.prev();
            this._cursor.prev();
            this._updateBasedOnCurrentState();
            this._cursor.next();
            this._cursor.next();
        } else {
            this._insertNewQuote(quote);
        }
    }

    private void _insertNewQuote(String quote) {
        String insert = this._getQuoteType(quote);
        this._cursor.insertNewBrace(insert);
        this._cursor.prev();
        this._updateBasedOnCurrentState();
        this._cursor.next();
        this._cursor.setBlockOffset(0);
    }

    private String _getQuoteType(String quote) {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return quote;
        }
        if (((ReducedToken)this._cursor.prevItem()).getType().equals("\\")) {
            this._cursor.prev();
            this._cursor.remove();
            return "\\" + quote;
        }
        return quote;
    }

    protected void insertGapBetweenMultiCharBrace(int length) {
        if (this._cursor.getBlockOffset() > 1) {
            throw new IllegalArgumentException("OFFSET TOO BIG:  " + this._cursor.getBlockOffset());
        }
        this._cursor._splitCurrentIfCommentBlock(true, true);
        this._cursor.next();
        this._insertNewGap(length);
        this._cursor.prev();
        this._cursor.prev();
        this._updateBasedOnCurrentState();
        this._cursor.next();
        this._cursor.next();
    }

    private void _updateBasedOnCurrentState() {
        TokenList.Iterator copyCursor = this._cursor._copy();
        copyCursor.updateBasedOnCurrentState();
        copyCursor.dispose();
    }

    public void move(int count) {
        this._cursor.move(count);
    }

    public void delete(int count) {
        if (count == 0) {
            return;
        }
        this._cursor.delete(count);
        int absOff = this.absOffset();
        int movement = absOff < 2 ? absOff : 2;
        this._cursor.move(-movement);
        this._updateBasedOnCurrentState();
        this._cursor.move(movement);
    }

    protected ReducedModelState moveWalkerGetState(int relLocation) {
        this._walker.move(relLocation);
        return this._walker.getStateAtCurrent();
    }

    protected void resetWalkerLocationToCursor() {
        this._walker.dispose();
        this._walker = this._cursor._copy();
    }

    void getDistToPreviousNewline(IndentInfo braceInfo) {
        braceInfo.distToNewline = braceInfo.distToPrevNewline = this._getDistToPreviousNewline(this._cursor._copy());
    }

    private int _getDistToPreviousNewline(TokenList.Iterator copyCursor) {
        int walkcount = copyCursor.getBlockOffset();
        if (!copyCursor.atStart()) {
            copyCursor.prev();
        }
        while (!copyCursor.atStart() && !((ReducedToken)copyCursor.current()).getType().equals("\n")) {
            walkcount += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.prev();
        }
        if (copyCursor.atStart()) {
            return -1;
        }
        return walkcount;
    }

    void getDistToIndentNewline(IndentInfo braceInfo) {
        TokenList.Iterator copyCursor = this._cursor._copy();
        if (braceInfo.distToBrace == -1 || copyCursor.atStart()) {
            return;
        }
        copyCursor.move(-braceInfo.distToBrace);
        int walkcount = this._getDistToPreviousNewline(copyCursor);
        braceInfo.distToNewline = walkcount == -1 ? -1 : walkcount + braceInfo.distToBrace;
    }

    void getDistToCurrentBraceNewline(IndentInfo braceInfo) {
        TokenList.Iterator copyCursor = this._cursor._copy();
        if (braceInfo.distToBraceCurrent == -1 || copyCursor.atStart()) {
            return;
        }
        copyCursor.move(-braceInfo.distToBraceCurrent);
        int walkcount = this._getDistToPreviousNewline(copyCursor);
        braceInfo.distToNewlineCurrent = walkcount == -1 ? -1 : walkcount + braceInfo.distToBraceCurrent;
    }

    public int getDistToPreviousNewline(int relLoc) {
        TokenList.Iterator copyCursor = this._cursor._copy();
        copyCursor.move(-relLoc);
        int dist = this._getDistToPreviousNewline(copyCursor);
        copyCursor.dispose();
        if (dist == -1) {
            return -1;
        }
        return dist + relLoc;
    }

    public int getDistToNextNewline() {
        TokenList.Iterator copyCursor = this._cursor._copy();
        if (copyCursor.atStart()) {
            copyCursor.next();
        }
        if (copyCursor.atEnd() || ((ReducedToken)copyCursor.current()).getType().equals("\n")) {
            return 0;
        }
        int walkcount = ((ReducedToken)copyCursor.current()).getSize() - this._cursor.getBlockOffset();
        copyCursor.next();
        while (!copyCursor.atEnd() && !((ReducedToken)copyCursor.current()).getType().equals("\n")) {
            walkcount += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.next();
        }
        return walkcount;
    }
}

