/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.print;

import edu.rice.cs.drjava.model.print.PagePrinter;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;

public class DrJavaBook
implements Pageable {
    private ArrayList<PagePrinter> _pagePrinters = new ArrayList();
    private PageFormat _format;
    private String _filename;
    public static final Font PRINT_FONT = new Font("Monospaced", 0, 9);
    public static final Font FOOTER_FONT = new Font("Monospaced", 0, 8);
    public static final Font LINE_FONT = new Font("Monospaced", 2, 8);
    public float LINE_NUM_WIDTH;
    private static FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, true);

    public DrJavaBook(String text, String filename, PageFormat format) {
        this._format = format;
        this._filename = filename;
        TextLayout textl = new TextLayout("XXX ", LINE_FONT, DEFAULT_FRC);
        this.LINE_NUM_WIDTH = textl.getAdvance();
        this.setUpPagePrinters(text);
    }

    private void setUpPagePrinters(String text) {
        String thisText;
        int linenum = 0;
        int reallinenum = 1;
        FontRenderContext frc = new FontRenderContext(null, false, true);
        TextLayout textl = new TextLayout("X", PRINT_FONT, frc);
        float lineHeight = textl.getLeading() + textl.getAscent();
        int linesPerPage = (int)(this._format.getImageableHeight() / (double)lineHeight) - 1;
        HashMap<TextAttribute, Font> map = new HashMap<TextAttribute, Font>();
        map.put(TextAttribute.FONT, PRINT_FONT);
        char[] carraigeReturn = new char[]{'\n'};
        String lineSeparator = new String(carraigeReturn);
        try {
            thisText = text.substring(0, text.indexOf(lineSeparator));
            text = text.substring(text.indexOf(lineSeparator) + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            thisText = text;
            text = "";
        }
        int page = 0;
        PagePrinter thisPagePrinter = new PagePrinter(page, this._filename, this);
        this._pagePrinters.add(thisPagePrinter);
        while (!thisText.equals("") || !text.equals("")) {
            if (thisText.equals("")) {
                thisText = " ";
            }
            AttributedCharacterIterator charIterator = new AttributedString(thisText, map).getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(charIterator, frc);
            boolean isCarryLine = false;
            while (measurer.getPosition() < charIterator.getEndIndex()) {
                TextLayout pageNumber = new TextLayout(" ", LINE_FONT, DEFAULT_FRC);
                if (!isCarryLine) {
                    pageNumber = new TextLayout("" + reallinenum, LINE_FONT, DEFAULT_FRC);
                }
                thisPagePrinter.add(measurer.nextLayout((float)this._format.getImageableWidth() - this.LINE_NUM_WIDTH), pageNumber);
                if (++linenum == linesPerPage * (page + 1)) {
                    thisPagePrinter = new PagePrinter(++page, this._filename, this);
                    this._pagePrinters.add(thisPagePrinter);
                }
                isCarryLine = true;
            }
            ++reallinenum;
            try {
                thisText = text.substring(0, text.indexOf(lineSeparator));
                text = text.substring(text.indexOf(lineSeparator) + 1);
            }
            catch (StringIndexOutOfBoundsException e) {
                thisText = text;
                text = "";
            }
        }
    }

    public int getNumberOfPages() {
        return this._pagePrinters.size();
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this._format;
    }

    public Printable getPrintable(int pageIndex) {
        return this._pagePrinters.get(pageIndex);
    }
}

