/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerErrorModel;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.ui.ErrorPanel;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CompilerErrorPanel
extends ErrorPanel {
    private boolean _compileHasOccurred = false;
    private CompilerErrorListPane _errorListPane;
    private final JComboBox _compilerChoiceBox;

    public CompilerErrorPanel(SingleDisplayModel model, MainFrame frame) {
        super(model, frame, "Compiler Output", "Compiler");
        this._numErrors = 0;
        this._errorListPane = new CompilerErrorListPane();
        this.setErrorListPane(this._errorListPane);
        this._compilerChoiceBox = new JComboBox<CompilerInterface>(this.getModel().getCompilerModel().getAvailableCompilers());
        this._compilerChoiceBox.setEditable(false);
        this._compilerChoiceBox.setSelectedItem(this.getModel().getCompilerModel().getActiveCompiler());
        this._compilerChoiceBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CompilerInterface compiler = (CompilerInterface)CompilerErrorPanel.access$000(CompilerErrorPanel.this).getSelectedItem();
                if (compiler != null) {
                    CompilerErrorPanel.this.getModel().getCompilerModel().setActiveCompiler(compiler);
                } else {
                    CompilerErrorPanel.this.getModel().getCompilerModel().setActiveCompiler(NoCompilerAvailable.ONLY);
                }
                CompilerErrorPanel.this.getModel().getCompilerModel().resetCompilerErrors();
                CompilerErrorPanel.access$102(CompilerErrorPanel.this, false);
                CompilerErrorPanel.this.reset();
            }
        });
        this.customPanel.add((Component)this._compilerChoiceBox, "North");
        DrJava.getConfig().addOptionListener(OptionConstants.JAVAC_LOCATION, new CompilerLocationOptionListener(null));
        DrJava.getConfig().addOptionListener(OptionConstants.JSR14_LOCATION, new CompilerLocationOptionListener(null));
        DrJava.getConfig().addOptionListener(OptionConstants.EXTRA_COMPILERS, new CompilerLocationOptionListener(null));
    }

    public CompilerErrorListPane getErrorListPane() {
        return this._errorListPane;
    }

    public void setCompilationInProgress() {
        this._errorListPane.setCompilationInProgress();
    }

    protected CompilerErrorModel getErrorModel() {
        return this.getModel().getCompilerModel().getCompilerErrorModel();
    }

    protected void _close() {
        super._close();
        this.getModel().getCompilerModel().resetCompilerErrors();
        this.reset();
    }

    public void reset() {
        this._numErrors = this.getModel().getCompilerModel().getNumErrors();
        this._errorListPane.updateListPane(true);
    }

    public ErrorPanel.ErrorListPane getErrorListPane() {
        return this.getErrorListPane();
    }

    static JComboBox access$000(CompilerErrorPanel x0) {
        return x0._compilerChoiceBox;
    }

    static boolean access$102(CompilerErrorPanel x0, boolean x1) {
        x0._compileHasOccurred = x1;
        return x0._compileHasOccurred;
    }

    static boolean access$100(CompilerErrorPanel x0) {
        return x0._compileHasOccurred;
    }

    class CompilerErrorListPane
    extends ErrorPanel.ErrorListPane {
        CompilerErrorListPane() {
            super(CompilerErrorPanel.this);
        }

        protected void _updateWithErrors() throws BadLocationException {
            SwingDocument doc = new SwingDocument();
            String failureName = "error";
            if (CompilerErrorPanel.this.getErrorModel().hasOnlyWarnings()) {
                failureName = "warning";
            }
            this._updateWithErrors(failureName, "found", doc);
        }

        public void setCompilationInProgress() {
            this._errorListPositions = new Position[0];
            CompilerErrorPanel.access$102(CompilerErrorPanel.this, true);
            SwingDocument doc = new SwingDocument();
            try {
                doc.insertString(0, "Compilation in progress, please wait...", ErrorPanel.NORMAL_ATTRIBUTES);
            }
            catch (BadLocationException ble) {
                throw new UnexpectedException(ble);
            }
            this.setDocument(doc);
            this.selectNothing();
        }

        protected void _updateNoErrors(boolean done) throws BadLocationException {
            SwingDocument doc = new SwingDocument();
            String message = CompilerErrorPanel.access$100(CompilerErrorPanel.this) ? "Last compilation completed successfully." : (CompilerErrorPanel.this.getModel().getCompilerModel().getAvailableCompilers().length == 0 ? "No compiler is available.  Please specify one in\nthe Preferences dialog in the Edit menu." : (CompilerErrorPanel.this.getModel().getCompilerModel().getActiveCompiler() == NoCompilerAvailable.ONLY ? "No compiler available." : CompilerErrorPanel.this.getModel().getCompilerModel().getActiveCompiler().getName() + " compiler ready."));
            doc.insertString(0, message, ErrorPanel.NORMAL_ATTRIBUTES);
            this.setDocument(doc);
            this._updateScrollButtons();
            this.selectNothing();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompilerLocationOptionListener<T>
    implements OptionListener<T> {
        private CompilerLocationOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<T> oce) {
            CompilerErrorPanel.access$000(CompilerErrorPanel.this).removeAllItems();
            CompilerInterface[] availCompilers = CompilerErrorPanel.this.getModel().getCompilerModel().getAvailableCompilers();
            for (int i = 0; i < availCompilers.length; ++i) {
                CompilerErrorPanel.access$000(CompilerErrorPanel.this).addItem(availCompilers[i]);
            }
        }

        CompilerLocationOptionListener(1 x1) {
            this();
        }
    }
}

