/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.FindReplaceMachine;
import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.AbstractDocumentInterface;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

class FindReplaceDialog
extends TabbedPanel {
    private JButton _findNextButton;
    private JButton _findPreviousButton;
    private JButton _replaceButton;
    private JButton _replaceFindNextButton;
    private JButton _replaceFindPreviousButton;
    private JButton _replaceAllButton;
    private JTextPane _findField;
    private JTextPane _replaceField;
    private JLabel _findLabelBot;
    private JCheckBox _ignoreCommentsAndStrings;
    private JCheckBox _matchCase;
    private JCheckBox _searchAllDocuments;
    private JCheckBox _matchWholeWord;
    private FindReplaceMachine _machine;
    private SingleDisplayModel _model;
    private DefinitionsPane _defPane = null;
    private boolean _caretChanged;
    private CaretListener _caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
                    FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
                    FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
                    FindReplaceDialog.access$300(FindReplaceDialog.this).positionChanged();
                    FindReplaceDialog.access$402(FindReplaceDialog.this, true);
                }
            });
        }
    };
    private Action _findNextAction = new AbstractAction("Find Next"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.findNext();
        }
    };
    private Action _findPreviousAction = new AbstractAction("Find Previous"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.findPrevious();
        }
    };
    private Action _doFindAction = new AbstractAction("Do Find"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.access$500(FindReplaceDialog.this);
        }
    };
    private Action _replaceAction = new AbstractAction("Replace"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.access$600(FindReplaceDialog.this);
            FindReplaceDialog.access$300(FindReplaceDialog.this).setFindWord(FindReplaceDialog.access$700(FindReplaceDialog.this).getText());
            String replaceWord = FindReplaceDialog.access$800(FindReplaceDialog.this).getText();
            FindReplaceDialog.access$300(FindReplaceDialog.this).setReplaceWord(replaceWord);
            FindReplaceDialog.this._frame.clearStatusMessage();
            boolean replaced = FindReplaceDialog.access$300(FindReplaceDialog.this).replaceCurrent();
            if (replaced) {
                FindReplaceDialog.access$900(FindReplaceDialog.this, replaceWord.length());
            }
            FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
            FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
            FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
            FindReplaceDialog.access$1000(FindReplaceDialog.this).requestFocusInWindow();
        }
    };
    private Action _replaceFindNextAction = new AbstractAction("Replace/Find Next"){

        public void actionPerformed(ActionEvent e) {
            if (FindReplaceDialog.this.getSearchBackwards()) {
                FindReplaceDialog.access$300(FindReplaceDialog.this).positionChanged();
                FindReplaceDialog.this.findNext();
            }
            FindReplaceDialog.access$600(FindReplaceDialog.this);
            FindReplaceDialog.access$300(FindReplaceDialog.this).setFindWord(FindReplaceDialog.access$700(FindReplaceDialog.this).getText());
            String replaceWord = FindReplaceDialog.access$800(FindReplaceDialog.this).getText();
            FindReplaceDialog.access$300(FindReplaceDialog.this).setReplaceWord(replaceWord);
            FindReplaceDialog.this._frame.clearStatusMessage();
            boolean replaced = FindReplaceDialog.access$300(FindReplaceDialog.this).replaceCurrent();
            if (replaced) {
                FindReplaceDialog.access$900(FindReplaceDialog.this, replaceWord.length());
                FindReplaceDialog.this.findNext();
                FindReplaceDialog.access$1100(FindReplaceDialog.this).requestFocusInWindow();
            } else {
                FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
                FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
                FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplaceDialog.this._frame.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceFindPreviousAction = new AbstractAction("Replace/Find Previous"){

        public void actionPerformed(ActionEvent e) {
            if (!FindReplaceDialog.this.getSearchBackwards()) {
                FindReplaceDialog.access$300(FindReplaceDialog.this).positionChanged();
                FindReplaceDialog.this.findPrevious();
            }
            FindReplaceDialog.access$600(FindReplaceDialog.this);
            FindReplaceDialog.access$300(FindReplaceDialog.this).setFindWord(FindReplaceDialog.access$700(FindReplaceDialog.this).getText());
            String replaceWord = FindReplaceDialog.access$800(FindReplaceDialog.this).getText();
            FindReplaceDialog.access$300(FindReplaceDialog.this).setReplaceWord(replaceWord);
            FindReplaceDialog.this._frame.clearStatusMessage();
            boolean replaced = FindReplaceDialog.access$300(FindReplaceDialog.this).replaceCurrent();
            if (replaced) {
                FindReplaceDialog.access$900(FindReplaceDialog.this, replaceWord.length());
                FindReplaceDialog.this.findPrevious();
                FindReplaceDialog.access$1200(FindReplaceDialog.this).requestFocusInWindow();
            } else {
                FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
                FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
                FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
                Toolkit.getDefaultToolkit().beep();
                FindReplaceDialog.this._frame.setStatusMessage("Replace failed.");
            }
        }
    };
    private Action _replaceAllAction = new AbstractAction("Replace All"){

        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.access$600(FindReplaceDialog.this);
            FindReplaceDialog.access$300(FindReplaceDialog.this).setFindWord(FindReplaceDialog.access$700(FindReplaceDialog.this).getText());
            FindReplaceDialog.access$300(FindReplaceDialog.this).setReplaceWord(FindReplaceDialog.access$800(FindReplaceDialog.this).getText());
            FindReplaceDialog.this._frame.clearStatusMessage();
            int count = FindReplaceDialog.access$300(FindReplaceDialog.this).replaceAll();
            Toolkit.getDefaultToolkit().beep();
            FindReplaceDialog.this._frame.setStatusMessage("Replaced " + count + " occurrence" + (count == 1 ? "" : "s") + ".");
            FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
            FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
            FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
        }
    };
    Action _standardNewlineAction = new TextAction("NewLine Action"){

        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            String text = c.getText();
            int caretPos = c.getCaretPosition();
            String textBeforeCaret = text.substring(0, caretPos);
            String textAfterCaret = text.substring(caretPos);
            c.setText(textBeforeCaret.concat("\n").concat(textAfterCaret));
            c.setCaretPosition(caretPos + 1);
        }
    };

    public FindReplaceDialog(MainFrame frame, SingleDisplayModel model) {
        super(frame, "Find/Replace");
        this._model = model;
        this._machine = new FindReplaceMachine(this._model, this._model.getDocumentIterator());
        this._updateMachine();
        this._findNextButton = new JButton(this._findNextAction);
        this._findPreviousButton = new JButton(this._findPreviousAction);
        this._replaceButton = new JButton(this._replaceAction);
        this._replaceFindNextButton = new JButton(this._replaceFindNextAction);
        this._replaceFindPreviousButton = new JButton(this._replaceFindPreviousAction);
        this._replaceAllButton = new JButton(this._replaceAllAction);
        this._replaceAction.setEnabled(false);
        this._replaceFindNextAction.setEnabled(false);
        this._replaceFindPreviousAction.setEnabled(false);
        this._findField = new JTextPane(new DefaultStyledDocument());
        this._replaceField = new JTextPane(new SwingDocument());
        int tabForward = 0;
        int tabBackward = 1;
        this._findField.setFocusTraversalKeys(tabForward, null);
        this._replaceField.setFocusTraversalKeys(tabForward, null);
        this._findField.setFocusTraversalKeys(tabBackward, null);
        this._replaceField.setFocusTraversalKeys(tabBackward, null);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2);
        KeyStroke ctrlTab = KeyStroke.getKeyStroke(9, 2);
        InputMap findIM = this._findField.getInputMap();
        InputMap replaceIM = this._replaceField.getInputMap();
        findIM.put(enter, "Do Find");
        findIM.put(ctrlEnter, "Insert Newline");
        findIM.put(ctrlTab, "Insert Tab");
        replaceIM.put(enter, "Insert Newline");
        replaceIM.put(ctrlEnter, "Insert Newline");
        replaceIM.put(ctrlTab, "Insert Tab");
        DefaultEditorKit.InsertTabAction insertTabAction = new DefaultEditorKit.InsertTabAction();
        ActionMap findAM = this._findField.getActionMap();
        ActionMap replaceAM = this._replaceField.getActionMap();
        findAM.put("Do Find", this._doFindAction);
        findAM.put("Insert Newline", this._standardNewlineAction);
        findAM.put("Insert Tab", insertTabAction);
        replaceAM.put("Insert Newline", this._standardNewlineAction);
        replaceAM.put("Insert Tab", insertTabAction);
        new ForegroundColorListener(this._findField);
        new BackgroundColorListener(this._findField);
        new ForegroundColorListener(this._replaceField);
        new BackgroundColorListener(this._replaceField);
        Font font = DrJava.getConfig().getSetting(OptionConstants.FONT_MAIN);
        this.setFieldFont(font);
        JLabel _replaceLabelTop = new JLabel("Replace", 4);
        JLabel _replaceLabelBot = new JLabel("With", 4);
        JPanel replaceLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel replaceLabelPanel = new JPanel(new GridLayout(2, 1));
        replaceLabelPanelTop.add((Component)_replaceLabelTop, "South");
        replaceLabelPanelBot.add((Component)_replaceLabelBot, "North");
        replaceLabelPanel.add(replaceLabelPanelTop);
        replaceLabelPanel.add(replaceLabelPanelBot);
        JLabel _findLabelTop = new JLabel("Find", 4);
        this._findLabelBot = new JLabel("Next", 4);
        JPanel findLabelPanelTop = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanelBot = new JPanel(new BorderLayout(5, 5));
        JPanel findLabelPanel = new JPanel(new GridLayout(2, 1));
        findLabelPanelTop.add((Component)_findLabelTop, "South");
        findLabelPanelBot.add((Component)this._findLabelBot, "North");
        findLabelPanel.add(findLabelPanelTop);
        findLabelPanel.add(findLabelPanelBot);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 0, 5, 0));
        buttons.add(this._findNextButton);
        buttons.add(this._findPreviousButton);
        buttons.add(this._replaceFindNextButton);
        buttons.add(this._replaceFindPreviousButton);
        buttons.add(this._replaceButton);
        buttons.add(this._replaceAllButton);
        boolean matchCaseSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_MATCH_CASE);
        this._matchCase = new JCheckBox("Match Case", matchCaseSelected);
        this._machine.setMatchCase(matchCaseSelected);
        this._matchCase.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                FindReplaceDialog.access$300(FindReplaceDialog.this).setMatchCase(selected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_MATCH_CASE, Autobox.valueOf(selected));
                FindReplaceDialog.access$700(FindReplaceDialog.this).requestFocusInWindow();
            }
        });
        boolean searchAllSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_ALL_DOCUMENTS);
        this._searchAllDocuments = new JCheckBox("Search All Documents", searchAllSelected);
        this._machine.setSearchAllDocuments(searchAllSelected);
        this._searchAllDocuments.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                FindReplaceDialog.access$300(FindReplaceDialog.this).setSearchAllDocuments(selected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_ALL_DOCUMENTS, Autobox.valueOf(selected));
                FindReplaceDialog.access$700(FindReplaceDialog.this).requestFocusInWindow();
            }
        });
        boolean matchWordSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_WHOLE_WORD);
        this._matchWholeWord = new JCheckBox("Whole Word", matchWordSelected);
        if (matchWordSelected) {
            this._machine.setMatchWholeWord();
        } else {
            this._machine.setFindAnyOccurrence();
        }
        this._matchWholeWord.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    FindReplaceDialog.access$300(FindReplaceDialog.this).setMatchWholeWord();
                } else {
                    FindReplaceDialog.access$300(FindReplaceDialog.this).setFindAnyOccurrence();
                }
                DrJava.getConfig().setSetting(OptionConstants.FIND_WHOLE_WORD, Autobox.valueOf(selected));
                FindReplaceDialog.access$700(FindReplaceDialog.this).requestFocusInWindow();
            }
        });
        boolean ignoreCommentsSelected = DrJava.getConfig().getSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS);
        this._ignoreCommentsAndStrings = new JCheckBox("No Comments/Strings", ignoreCommentsSelected);
        this._machine.setIgnoreCommentsAndStrings(ignoreCommentsSelected);
        this._ignoreCommentsAndStrings.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                FindReplaceDialog.access$300(FindReplaceDialog.this).setIgnoreCommentsAndStrings(selected);
                DrJava.getConfig().setSetting(OptionConstants.FIND_NO_COMMENTS_STRINGS, Autobox.valueOf(selected));
                FindReplaceDialog.access$700(FindReplaceDialog.this).requestFocusInWindow();
            }
        });
        this.removeAll();
        this._closePanel = new JPanel(new BorderLayout());
        this._closePanel.add((Component)this._closeButton, "North");
        JPanel _lowerCheckPanel = new JPanel(new FlowLayout(0, 0, 0));
        _lowerCheckPanel.add(this._matchWholeWord);
        _lowerCheckPanel.add(this._ignoreCommentsAndStrings);
        _lowerCheckPanel.setMaximumSize(new Dimension(1000, 40));
        JPanel _matchCaseAndAllDocsPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._matchCase.setPreferredSize(this._matchWholeWord.getPreferredSize());
        _matchCaseAndAllDocsPanel.add(this._matchCase);
        _matchCaseAndAllDocsPanel.add(this._searchAllDocuments);
        _matchCaseAndAllDocsPanel.setMaximumSize(new Dimension(1000, 40));
        BorderlessScrollPane _findPane = new BorderlessScrollPane(this._findField);
        BorderlessScrollPane _replacePane = new BorderlessScrollPane(this._replaceField);
        _findPane.setHorizontalScrollBarPolicy(30);
        _replacePane.setHorizontalScrollBarPolicy(30);
        JPanel findPanel = new JPanel(new BorderLayout(5, 5));
        findPanel.add((Component)findLabelPanel, "West");
        findPanel.add((Component)_findPane, "Center");
        JPanel replacePanel = new JPanel(new BorderLayout(5, 5));
        replacePanel.add((Component)replaceLabelPanel, "West");
        replacePanel.add((Component)_replacePane, "Center");
        JPanel leftPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        leftPanel.add(findPanel);
        leftPanel.add(replacePanel);
        Box optionsPanel = new Box(1);
        optionsPanel.add(_matchCaseAndAllDocsPanel);
        optionsPanel.add(_lowerCheckPanel);
        optionsPanel.add(Box.createGlue());
        JPanel midPanel = new JPanel(new BorderLayout(5, 5));
        midPanel.add((Component)leftPanel, "Center");
        midPanel.add((Component)optionsPanel, "East");
        JPanel _rightPanel = new JPanel(new BorderLayout(5, 5));
        _rightPanel.add((Component)midPanel, "Center");
        _rightPanel.add((Component)this._closePanel, "East");
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(_rightPanel);
        newPanel.add(Box.createVerticalStrut(5));
        newPanel.add(buttons);
        newPanel.add(Box.createVerticalStrut(5));
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        this.add(newPanel);
        this._findField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void insertUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            public void removeUpdate(DocumentEvent e) {
                this._updateHelper();
            }

            private void _updateHelper() {
                Utilities.invokeLater(new Runnable(){

                    public void run() {
                        FindReplaceDialog.access$300(FindReplaceDialog.this).makeCurrentOffsetStart();
                        FindReplaceDialog.this.updateFirstDocInSearch();
                        FindReplaceDialog.access$000(FindReplaceDialog.this).setEnabled(false);
                        FindReplaceDialog.access$100(FindReplaceDialog.this).setEnabled(false);
                        FindReplaceDialog.access$200(FindReplaceDialog.this).setEnabled(false);
                        FindReplaceDialog.access$300(FindReplaceDialog.this).positionChanged();
                        if (FindReplaceDialog.access$700(FindReplaceDialog.this).getText().equals("")) {
                            FindReplaceDialog.access$1300(FindReplaceDialog.this).setEnabled(false);
                        } else {
                            FindReplaceDialog.access$1300(FindReplaceDialog.this).setEnabled(true);
                        }
                        FindReplaceDialog.this.updateUI();
                    }
                });
            }
        });
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        this._findField.selectAll();
        return this._findField.requestFocusInWindow();
    }

    JTextPane getFindField() {
        return this._findField;
    }

    void findNext() {
        this._machine.setSearchBackwards(false);
        this._findLabelBot.setText("Next");
        this._doFind();
    }

    void findPrevious() {
        this._machine.setSearchBackwards(true);
        this._findLabelBot.setText("Prev");
        this._doFind();
    }

    void beginListeningTo(DefinitionsPane defPane) {
        if (this._defPane == null) {
            this._displayed = true;
            this._defPane = defPane;
            this._defPane.addCaretListener(this._caretListener);
            this._caretChanged = true;
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            if (!this._machine.isOnMatch() || this._findField.getText().equals("")) {
                this._replaceAction.setEnabled(false);
                this._replaceFindNextAction.setEnabled(false);
                this._replaceFindPreviousAction.setEnabled(false);
            } else {
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            }
            if (this._findField.getText().equals("")) {
                this._replaceAllAction.setEnabled(false);
            } else {
                this._replaceAllAction.setEnabled(true);
            }
        } else {
            throw new UnexpectedException(new RuntimeException("FindReplaceDialog should not be listening to anything"));
        }
        this._frame.clearStatusMessage();
    }

    public void stopListening() {
        if (this._defPane != null) {
            this._defPane.removeCaretListener(this._caretListener);
            this._defPane = null;
            this._displayed = false;
            this._frame.clearStatusMessage();
        }
    }

    private void _doFind() {
        if (this._findField.getText().length() > 0) {
            this._updateMachine();
            this._machine.setFindWord(this._findField.getText());
            this._machine.setReplaceWord(this._replaceField.getText());
            this._frame.clearStatusMessage();
            FindResult fr = this._machine.findNext();
            AbstractDocumentInterface doc = fr.getDocument();
            OpenDefinitionsDocument matchDoc = this._model.getODDForDocument(doc);
            OpenDefinitionsDocument openDoc = this._defPane.getOpenDefDocument();
            int pos = fr.getFoundOffset();
            if (pos != -1) {
                Caret c = this._defPane.getCaret();
                c.setDot(c.getDot());
                if (!matchDoc.equals(openDoc)) {
                    this._model.setActiveDocument(matchDoc);
                } else {
                    this._model.refreshActiveDocument();
                }
                this._defPane.setCaretPosition(pos);
                this._caretChanged = true;
                this._updateMachine();
            } else {
                this._model.refreshActiveDocument();
            }
            if (fr.getWrapped() && !this._machine.getSearchAllDocuments()) {
                Toolkit.getDefaultToolkit().beep();
                if (!this._machine.getSearchBackwards()) {
                    this._frame.setStatusMessage("Search wrapped to beginning.");
                } else {
                    this._frame.setStatusMessage("Search wrapped to end.");
                }
            }
            if (fr.getAllDocsWrapped() && this._machine.getSearchAllDocuments()) {
                Toolkit.getDefaultToolkit().beep();
                this._frame.setStatusMessage("Search wrapped around all documents.");
            }
            if (pos >= 0) {
                this._selectFoundItem();
                this._replaceAction.setEnabled(true);
                this._replaceFindNextAction.setEnabled(true);
                this._replaceFindPreviousAction.setEnabled(true);
                this._machine.setLastFindWord();
            } else {
                Toolkit.getDefaultToolkit().beep();
                StringBuffer statusMessage = new StringBuffer("Search text \"");
                if (this._machine.getFindWord().length() <= 50) {
                    statusMessage.append(this._machine.getFindWord());
                } else {
                    statusMessage.append(this._machine.getFindWord().substring(0, 49) + "...");
                }
                statusMessage.append("\" not found.");
                this._frame.setStatusMessage(statusMessage.toString());
            }
        }
        this._findField.requestFocusInWindow();
    }

    protected void _close() {
        this._defPane.requestFocusInWindow();
        if (this._displayed) {
            this.stopListening();
        }
        super._close();
    }

    public void setSearchBackwards(boolean b) {
        this._machine.setSearchBackwards(b);
    }

    public boolean getSearchBackwards() {
        return this._machine.getSearchBackwards();
    }

    public void setFieldFont(Font f) {
        this._findField.setFont(f);
        this._replaceField.setFont(f);
    }

    public void updateFirstDocInSearch() {
        this._machine.setFirstDoc(this._model.getActiveDocument());
    }

    private void _updateMachine() {
        if (this._caretChanged) {
            OpenDefinitionsDocument doc = this._model.getActiveDocument();
            this._machine.setDocument(doc);
            if (this._machine.getFirstDoc() == null) {
                this._machine.setFirstDoc(doc);
            }
            this._machine.setStart(this._defPane.getCaretPosition());
            this._machine.setPosition(this._defPane.getCaretPosition());
            this._caretChanged = false;
        }
    }

    private void _selectReplacedItem(int length) {
        int to = this._machine.getCurrentOffset();
        int from = this._machine.getSearchBackwards() ? to + length : to - length;
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem() {
        int position;
        int to = position = this._machine.getCurrentOffset();
        int from = !this._machine.getSearchBackwards() ? position - this._machine.getFindWord().length() : position + this._machine.getFindWord().length();
        this._selectFoundItem(from, to);
    }

    private void _selectFoundItem(int from, int to) {
        this._defPane.centerViewOnOffset(from);
        this._defPane.select(from, to);
        this._defPane.getCaret().setSelectionVisible(true);
    }

    public DefinitionsPane getDefPane() {
        return this._defPane;
    }

    public JButton getFindNextButton() {
        return this._findNextButton;
    }

    static Action access$000(FindReplaceDialog x0) {
        return x0._replaceAction;
    }

    static Action access$100(FindReplaceDialog x0) {
        return x0._replaceFindNextAction;
    }

    static Action access$200(FindReplaceDialog x0) {
        return x0._replaceFindPreviousAction;
    }

    static FindReplaceMachine access$300(FindReplaceDialog x0) {
        return x0._machine;
    }

    static boolean access$402(FindReplaceDialog x0, boolean x1) {
        x0._caretChanged = x1;
        return x0._caretChanged;
    }

    static void access$500(FindReplaceDialog x0) {
        x0._doFind();
    }

    static void access$600(FindReplaceDialog x0) {
        x0._updateMachine();
    }

    static JTextPane access$700(FindReplaceDialog x0) {
        return x0._findField;
    }

    static JTextPane access$800(FindReplaceDialog x0) {
        return x0._replaceField;
    }

    static void access$900(FindReplaceDialog x0, int x1) {
        x0._selectReplacedItem(x1);
    }

    static JButton access$1000(FindReplaceDialog x0) {
        return x0._replaceButton;
    }

    static JButton access$1100(FindReplaceDialog x0) {
        return x0._replaceFindNextButton;
    }

    static JButton access$1200(FindReplaceDialog x0) {
        return x0._replaceFindPreviousButton;
    }

    static Action access$1300(FindReplaceDialog x0) {
        return x0._replaceAllAction;
    }
}

