/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.FileSelectorComponent;
import java.awt.Frame;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOptionComponent
extends OptionComponent<File>
implements OptionConstants {
    private FileSelectorComponent _component;

    public FileOptionComponent(FileOption opt, String text, Frame parent, JFileChooser jfc) {
        super(opt, text, parent);
        this._component = new FileSelectorComponent(parent, jfc, 30, 10.0f);
        File setting = (File)DrJava.getConfig().getSetting(this._option);
        if (setting != this._option.getDefault()) {
            this._component.setFileField(setting);
        }
    }

    public FileOptionComponent(FileOption opt, String text, Frame parent, String description, JFileChooser jfc) {
        this(opt, text, parent, jfc);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._component.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    @Override
    public boolean updateConfig() {
        File componentFile = this._component.getFileFromField();
        File currentFile = (File)DrJava.getConfig().getSetting(this._option);
        if (componentFile != null && !componentFile.equals(currentFile)) {
            DrJava.getConfig().setSetting(this._option, componentFile);
        } else if (componentFile == null) {
            DrJava.getConfig().setSetting(this._option, this._option.getDefault());
        }
        return true;
    }

    @Override
    public void setValue(File value) {
        this._component.setFileField(value);
    }

    @Override
    public JComponent getComponent() {
        return this._component;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._component.setFileFilter(fileFilter);
    }

    @Override
    public void setValue(Object x0) {
        this.setValue((File)x0);
    }
}

