/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStrokeOptionComponent
extends OptionComponent<KeyStroke>
implements Comparable {
    private static final int DIALOG_HEIGHT = 185;
    public static final Hashtable<KeyStroke, KeyStrokeOptionComponent> _keyToKSOC = new Hashtable();
    private JButton _button;
    private JTextField _keyField;
    private JPanel _panel;
    private static GetKeyDialog _getKeyDialog = null;
    private KeyStroke _key;

    public KeyStrokeOptionComponent(KeyStrokeOption opt, String text, final Frame parent) {
        super(opt, text, parent);
        this._key = DrJava.getConfig().getSetting(opt);
        this._button = new JButton();
        this._button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (KeyStrokeOptionComponent.access$000() == null) {
                    KeyStrokeOptionComponent.access$002(new GetKeyDialog(parent, "Specify Shortcut", true));
                }
                KeyStrokeOptionComponent.access$000().promptKey(KeyStrokeOptionComponent.this);
            }
        });
        this._button.setText("...");
        this._button.setMaximumSize(new Dimension(10, 10));
        this._button.setMinimumSize(new Dimension(10, 10));
        this._keyField = new JTextField();
        this._keyField.setEditable(false);
        this._keyField.setBackground(Color.white);
        this._keyField.setHorizontalAlignment(0);
        this._keyField.setText(this._option.format(this._key));
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._keyField, "Center");
        this._panel.add((Component)this._button, "East");
        GridLayout gl = new GridLayout(1, 0);
        gl.setHgap(15);
        _keyToKSOC.put(this._key, this);
    }

    public KeyStrokeOptionComponent(KeyStrokeOption opt, String text, Frame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._button.setToolTipText(description);
        this._keyField.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    public String toString() {
        return new StringBuffer().append("<KSOC>label:").append(this.getLabelText()).append("ks: ").append(this.getKeyStroke()).append("jb: ").append(this._button.getText()).append("</KSOC>\n").toString();
    }

    @Override
    public boolean updateConfig() {
        if (!this._key.equals(this.getConfigKeyStroke())) {
            DrJava.getConfig().setSetting(this._option, this._key);
            this.setValue(this._key);
        }
        return true;
    }

    @Override
    public void setValue(KeyStroke value) {
        this._key = value;
        this._keyField.setText(this._option.format(value));
    }

    public int compareTo(Object o) {
        if (o instanceof KeyStrokeOptionComponent) {
            KeyStrokeOptionComponent other = (KeyStrokeOptionComponent)o;
            return this.getLabelText().compareTo(other.getLabelText());
        }
        return 1;
    }

    public KeyStroke getKeyStroke() {
        return this._key;
    }

    public KeyStroke getConfigKeyStroke() {
        return (KeyStroke)DrJava.getConfig().getSetting(this._option);
    }

    @Override
    public JComponent getComponent() {
        return this._panel;
    }

    @Override
    public void setValue(Object x0) {
        this.setValue((KeyStroke)x0);
    }

    static GetKeyDialog access$000() {
        return _getKeyDialog;
    }

    static GetKeyDialog access$002(GetKeyDialog x0) {
        _getKeyDialog = x0;
        return _getKeyDialog;
    }

    private class GetKeyDialog
    extends JDialog {
        private InputField _inputField;
        private JButton _clearButton;
        private JButton _cancelButton;
        private JButton _okButton;
        private JLabel _instructionLabel;
        private JLabel _currentLabel;
        private JLabel _actionLabel;
        private JPanel _inputAndClearPanel;
        private JPanel _cancelAndOKPanel;
        private KeyStroke _currentKeyStroke;
        private KeyStrokeOptionComponent _ksoc;

        public GetKeyDialog(Frame f, String title, boolean modal) {
            super(f, title, modal);
            this._inputField = new InputField(null);
            this._clearButton = new JButton("Clear");
            this._clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GetKeyDialog.access$200(GetKeyDialog.this).setText("");
                    GetKeyDialog.access$300(GetKeyDialog.this).setText("<none>");
                    GetKeyDialog.access$402(GetKeyDialog.this, KeyStrokeOption.NULL_KEYSTROKE);
                    GetKeyDialog.access$200(GetKeyDialog.this).requestFocusInWindow();
                }
            });
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    GetKeyDialog.access$200(GetKeyDialog.this).requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._okButton = new JButton("OK");
            this._okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (!GetKeyDialog.access$500(GetKeyDialog.this).getKeyStroke().equals(GetKeyDialog.access$400(GetKeyDialog.this))) {
                        _keyToKSOC.remove(GetKeyDialog.access$500(GetKeyDialog.this).getKeyStroke());
                        KeyStrokeOptionComponent conflict = _keyToKSOC.get(GetKeyDialog.access$400(GetKeyDialog.this));
                        if (conflict != null) {
                            _keyToKSOC.remove(GetKeyDialog.access$400(GetKeyDialog.this));
                            conflict.setValue(KeyStrokeOption.NULL_KEYSTROKE);
                        }
                        _keyToKSOC.put(GetKeyDialog.access$400(GetKeyDialog.this), GetKeyDialog.access$500(GetKeyDialog.this));
                        GetKeyDialog.access$500(GetKeyDialog.this).setValue(GetKeyDialog.access$400(GetKeyDialog.this));
                    }
                    GetKeyDialog.access$200(GetKeyDialog.this).requestFocusInWindow();
                    GetKeyDialog.this.dispose();
                }
            });
            this._instructionLabel = new JLabel("Type in the keystroke you want to use and click \"OK\"");
            this._currentLabel = new JLabel("Current action bound to the keystroke:");
            this._actionLabel = new JLabel("<none>");
            this._inputAndClearPanel = new JPanel(new BorderLayout());
            this._inputAndClearPanel.add((Component)this._inputField, "Center");
            this._inputAndClearPanel.add((Component)this._clearButton, "East");
            this._cancelAndOKPanel = new JPanel(new GridLayout(1, 0));
            this._cancelAndOKPanel.add(this._okButton);
            this._cancelAndOKPanel.add(this._cancelButton);
            JPanel panel = (JPanel)this.getContentPane();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(this._instructionLabel);
            panel.add(this._inputAndClearPanel);
            panel.add(this._currentLabel);
            panel.add(this._actionLabel);
            panel.add(this._cancelAndOKPanel);
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            this.centerOnScreen();
            this.pack();
        }

        public void promptKey(KeyStrokeOptionComponent k) {
            this._ksoc = k;
            this._instructionLabel.setText("Type in the keystroke you want to use for \"" + k.getLabelText() + "\" and click \"OK\"");
            this._currentKeyStroke = k.getKeyStroke();
            this._actionLabel.setText(k.getLabelText());
            this._inputField.setText(KeyStrokeOptionComponent.this._option.format(this._currentKeyStroke));
            this.setSize((int)this._instructionLabel.getPreferredSize().getWidth() + 30, 185);
            this.centerOnScreen();
            super.setVisible(true);
        }

        private void centerOnScreen() {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = this.getSize();
            this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        }

        static InputField access$200(GetKeyDialog x0) {
            return x0._inputField;
        }

        static JLabel access$300(GetKeyDialog x0) {
            return x0._actionLabel;
        }

        static KeyStroke access$402(GetKeyDialog x0, KeyStroke x1) {
            x0._currentKeyStroke = x1;
            return x0._currentKeyStroke;
        }

        static KeyStroke access$400(GetKeyDialog x0) {
            return x0._currentKeyStroke;
        }

        static KeyStrokeOptionComponent access$500(GetKeyDialog x0) {
            return x0._ksoc;
        }

        private class InputField
        extends JTextField {
            private InputField() {
            }

            public void processKeyEvent(KeyEvent e) {
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (e.getID() == 401) {
                    this.setText(KeyStrokeOptionComponent.this._option.format(ks));
                    KeyStrokeOptionComponent configKs = _keyToKSOC.get(ks);
                    if (configKs == null) {
                        GetKeyDialog.access$300(GetKeyDialog.this).setText("<none>");
                    } else {
                        String name = configKs.getLabelText();
                        GetKeyDialog.access$300(GetKeyDialog.this).setText(name);
                    }
                    GetKeyDialog.access$402(GetKeyDialog.this, ks);
                }
            }

            InputField(1 x1) {
                this();
            }
        }
    }
}

