/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalHashMap<Type1, Type2> {
    HashMap<Type1, Type2> forward = new HashMap();
    HashMap<Type2, Type1> backward = new HashMap();

    public void put(Type1 key, Type2 value) {
        if (this.forward.containsKey(key)) {
            throw new IllegalArgumentException(new StringBuffer().append("Key ").append(key).append(" exists in hash already.").toString());
        }
        if (this.forward.containsValue(value)) {
            throw new IllegalArgumentException(new StringBuffer().append("Double hashes must be one to one. ").append(value).append(" exists already in hash.").toString());
        }
        this.forward.put(key, value);
        this.backward.put(value, key);
    }

    public Type2 getValue(Type1 key) {
        return this.forward.get(key);
    }

    public Type1 getKey(Type2 value) {
        return this.backward.get(value);
    }

    public boolean containsKey(Type1 key) {
        return this.forward.containsKey(key);
    }

    public boolean containsValue(Type2 value) {
        return this.backward.containsKey(value);
    }

    public Iterator<Type2> valuesIterator() {
        return new BHMIterator();
    }

    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    public Collection<Type2> values() {
        return this.forward.values();
    }

    public Object[] valuesArray() {
        return this.values().toArray();
    }

    public Type2[] valuesArray(Type2[] a) {
        return this.values().toArray(a);
    }

    public Type2 removeValue(Type1 key) {
        Type2 tmp = this.forward.remove(key);
        this.backward.remove(tmp);
        return tmp;
    }

    public Type1 removeKey(Type2 value) {
        Type1 tmp = this.backward.remove(value);
        this.forward.remove(tmp);
        return tmp;
    }

    public int size() {
        return this.forward.size();
    }

    public void clear() {
        this.forward = new HashMap();
        this.backward = new HashMap();
    }

    public String toString() {
        String ret = "";
        ret = new StringBuffer().append("forward = ").append(this.forward.values()).append("\nbackward = ").append(this.backward.values()).toString();
        return ret;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BHMIterator
    implements Iterator<Type2> {
        Iterator<Type2> forwardIt;
        Type2 lastValue;

        BHMIterator() {
            this.forwardIt = BidirectionalHashMap.this.forward.values().iterator();
            this.lastValue = null;
        }

        @Override
        public boolean hasNext() {
            return this.forwardIt.hasNext();
        }

        @Override
        public Type2 next() {
            this.lastValue = this.forwardIt.next();
            return this.lastValue;
        }

        @Override
        public void remove() {
            this.forwardIt.remove();
            BidirectionalHashMap.this.backward.remove(this.lastValue);
            this.lastValue = null;
        }
    }
}

