/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

import edu.rice.cs.util.sexp.Atom;
import edu.rice.cs.util.sexp.BoolAtom;
import edu.rice.cs.util.sexp.BooleanToken;
import edu.rice.cs.util.sexp.Cons;
import edu.rice.cs.util.sexp.Empty;
import edu.rice.cs.util.sexp.LeftParenToken;
import edu.rice.cs.util.sexp.Lexer;
import edu.rice.cs.util.sexp.LexingException;
import edu.rice.cs.util.sexp.NumberAtom;
import edu.rice.cs.util.sexp.NumberToken;
import edu.rice.cs.util.sexp.QuotedTextAtom;
import edu.rice.cs.util.sexp.QuotedTextToken;
import edu.rice.cs.util.sexp.RightParenToken;
import edu.rice.cs.util.sexp.SEList;
import edu.rice.cs.util.sexp.SExp;
import edu.rice.cs.util.sexp.SExpParseException;
import edu.rice.cs.util.sexp.SExpToken;
import edu.rice.cs.util.sexp.TextAtom;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SExpParser {
    public static List<SEList> parse(File f) throws SExpParseException, IOException {
        return SExpParser.parse(new FileReader(f));
    }

    public static List<SEList> parse(String s) throws SExpParseException {
        return SExpParser.parse(new StringReader(s));
    }

    public static List<SEList> parse(Reader r) throws SExpParseException {
        try {
            return new ParseHelper(r).parseMultiple();
        }
        catch (LexingException e) {
            throw new SExpParseException(e.getMessage());
        }
        catch (PrivateParseException e) {
            throw new SExpParseException(e.getMessage());
        }
    }

    private static class PrivateParseException
    extends RuntimeException {
        public PrivateParseException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseHelper {
        private Lexer _lex;

        public ParseHelper(Reader r) {
            this._lex = new Lexer(r);
        }

        public List<SEList> parseMultiple() {
            SEList exp;
            ArrayList<SEList> l = new ArrayList<SEList>();
            while ((exp = this.parseTopLevelExp()) != null) {
                l.add(exp);
            }
            return l;
        }

        public SEList parseTopLevelExp() {
            SExpToken t = this._lex.readToken();
            if (t == LeftParenToken.ONLY) {
                return this.parseList();
            }
            if (t == null) {
                return null;
            }
            throw new PrivateParseException(new StringBuffer().append("A top-level s-expression must be a list. Invalid start of list: ").append(t).toString());
        }

        public SExp parseExp() {
            SExpToken t = this._lex.readToken();
            this.assertNotEOF(t);
            if (t == LeftParenToken.ONLY) {
                return this.parseList();
            }
            return this.parseAtom(t);
        }

        private SEList parseList() {
            LinkedList<SExp> list = new LinkedList<SExp>();
            SExpToken t = this._lex.peek();
            this.assertNotEOF(t);
            while (t != RightParenToken.ONLY) {
                list.addFirst(this.parseExp());
                t = this._lex.peek();
            }
            this._lex.readToken();
            SEList cons = Empty.ONLY;
            for (SExp exp : list) {
                cons = new Cons(exp, cons);
            }
            return cons;
        }

        private Atom parseAtom(SExpToken t) {
            if (t instanceof BooleanToken) {
                if (((BooleanToken)t).getValue()) {
                    return BoolAtom.TRUE;
                }
                return BoolAtom.FALSE;
            }
            if (t instanceof NumberToken) {
                return new NumberAtom(((NumberToken)t).getValue());
            }
            if (t instanceof QuotedTextToken) {
                return new QuotedTextAtom(t.getText());
            }
            return new TextAtom(t.getText());
        }

        private void assertNotEOF(SExpToken t) {
            if (t == null) {
                throw new PrivateParseException(new StringBuffer().append("Unexpected <EOF> at line ").append(this._lex.lineno()).toString());
            }
        }
    }
}

