/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.Action;

public class DelegatingAction
implements Action {
    private static final String[] KEYS_TO_DELEGATE = new String[]{"Name"};
    private HashMap<String, Object> _localProperties = new HashMap();
    private Action _delegatee;
    private final LinkedList<PropertyChangeListener> _listenerList = new LinkedList();

    public Object getValue(String key) {
        this._checkState();
        if (this._isDelegatedKey(key)) {
            return this._delegatee.getValue(key);
        }
        return this._localProperties.get(key);
    }

    private boolean _isDelegatedKey(String key) {
        for (int i = 0; i < KEYS_TO_DELEGATE.length; ++i) {
            if (!KEYS_TO_DELEGATE[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    public void putValue(String key, Object value) {
        this._checkState();
        if (this._isDelegatedKey(key)) {
            this._delegatee.putValue(key, value);
        } else {
            Object old = this._localProperties.get(key);
            this._localProperties.put(key, value);
            ListIterator itor = this._listenerList.listIterator();
            PropertyChangeEvent event = new PropertyChangeEvent(this, key, old, value);
            while (itor.hasNext()) {
                PropertyChangeListener listener = (PropertyChangeListener)itor.next();
                listener.propertyChange(event);
            }
        }
    }

    public void setEnabled(boolean b) {
        this._checkState();
        this._delegatee.setEnabled(b);
    }

    public boolean isEnabled() {
        this._checkState();
        return this._delegatee.isEnabled();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._checkState();
        this._delegatee.addPropertyChangeListener(listener);
        this._listenerList.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._checkState();
        this._delegatee.removePropertyChangeListener(listener);
        this._listenerList.remove(listener);
    }

    public void actionPerformed(ActionEvent ae) {
        this._checkState();
        this._delegatee.actionPerformed(ae);
    }

    public void setDelegatee(Action newDelegatee) {
        if (newDelegatee == null) {
            throw new IllegalArgumentException("setDelegatee(null) is not allowed!");
        }
        Boolean enabled = newDelegatee.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
        PropertyChangeEvent enabledEvent = new PropertyChangeEvent(newDelegatee, "enabled", Boolean.FALSE, enabled);
        PropertyChangeEvent[] events = null;
        if (this._delegatee != null) {
            events = new PropertyChangeEvent[KEYS_TO_DELEGATE.length];
            for (int i = 0; i < KEYS_TO_DELEGATE.length; ++i) {
                Object oldValue = this._delegatee.getValue(KEYS_TO_DELEGATE[i]);
                Object newValue = newDelegatee.getValue(KEYS_TO_DELEGATE[i]);
                events[i] = new PropertyChangeEvent(newDelegatee, KEYS_TO_DELEGATE[i], oldValue, newValue);
            }
        }
        ListIterator itor = this._listenerList.listIterator();
        while (itor.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)itor.next();
            if (this._delegatee != null) {
                this._delegatee.removePropertyChangeListener(listener);
            }
            newDelegatee.addPropertyChangeListener(listener);
            if (events != null) {
                for (int i = 0; i < events.length; ++i) {
                    listener.propertyChange(events[i]);
                }
            }
            listener.propertyChange(enabledEvent);
        }
        this._delegatee = newDelegatee;
    }

    private void _checkState() {
        if (this._delegatee == null) {
            throw new IllegalStateException("delegatee is null!");
        }
    }
}

