/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.util.Lambda;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.EditDocumentInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PopupConsole
implements Serializable {
    private static final String INPUT_ENTERED_NAME = "Input Entered";
    private static final String INSERT_NEWLINE_NAME = "Insert Newline";
    private JTextArea _inputBox;
    private Action _insertNewlineAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JTextArea source = (JTextArea)e.getSource();
            source.insert("\n", source.getCaretPosition());
        }
    };
    private String _title;
    private Component _parentComponent;
    private EditDocumentInterface _doc;
    private ConsoleDocument _console;
    private Runnable _interruptCommand;
    private Lambda<Object, String> _insertTextCommand;
    private final Object commandLock = new Object();
    private boolean monitorNotified = false;
    private volatile boolean inputAborted = false;

    public PopupConsole(Component owner, EditDocumentInterface doc, ConsoleDocument console, JTextArea inputBox, String title) {
        this.setParent(owner);
        this._doc = doc;
        this._console = console;
        this.setInputBox(inputBox);
        this.setTitle(title);
    }

    public String getConsoleInput() {
        Frame parentFrame = JOptionPane.getFrameForComponent(this._parentComponent);
        if (parentFrame.isVisible()) {
            return this.showDialog(parentFrame) + "\n";
        }
        return this.silentInput() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptConsole() {
        Object object = this.commandLock;
        synchronized (object) {
            if (this._interruptCommand != null) {
                this._interruptCommand.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertConsoleText(String txt) {
        Object object = this.commandLock;
        synchronized (object) {
            if (this._insertTextCommand == null) {
                throw new IllegalStateException("Console not ready for text insertion");
            }
            this._insertTextCommand.apply(txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConsoleReady() throws InterruptedException {
        Object object = this.commandLock;
        synchronized (object) {
            while (this._interruptCommand == null) {
                this.commandLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsoleReady() {
        Object object = this.commandLock;
        synchronized (object) {
            return this._interruptCommand != null;
        }
    }

    public void setInputBox(JTextArea inputBox) {
        this._inputBox = inputBox == null ? new InputBox() : inputBox;
        InputMap im = this._inputBox.getInputMap();
        im.put(KeyStroke.getKeyStroke(10, 1), INSERT_NEWLINE_NAME);
        ActionMap am = this._inputBox.getActionMap();
        am.put(INSERT_NEWLINE_NAME, this._insertNewlineAction);
    }

    public JTextArea getInputBox() {
        return this._inputBox;
    }

    public void setParent(Component c) {
        this._parentComponent = c;
    }

    public Component getParent() {
        return this._parentComponent;
    }

    public void setTitle(String title) {
        this._title = title == null ? "Console" : title;
    }

    public String getTitle() {
        return this._title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String showDialog(Frame parentFrame) {
        final JDialog dialog = this.createDialog(this._inputBox, parentFrame);
        Object object = this.commandLock;
        synchronized (object) {
            this._interruptCommand = new Runnable(){

                public void run() {
                    dialog.setVisible(false);
                }
            };
            this._insertTextCommand = new Lambda<Object, String>(){

                @Override
                public Object apply(String input) {
                    PopupConsole.access$000(PopupConsole.this).insert(input, PopupConsole.access$000(PopupConsole.this).getCaretPosition());
                    return null;
                }

                @Override
                public Object apply(Object x0) {
                    return this.apply((String)x0);
                }
            };
            this.commandLock.notifyAll();
        }
        dialog.setVisible(true);
        dialog.dispose();
        object = this.commandLock;
        synchronized (object) {
            this._interruptCommand = null;
            this._insertTextCommand = null;
        }
        String input = this._inputBox.getText();
        if (this.inputAborted) {
            this.inputAborted = false;
            throw new IllegalStateException("System.in aborted");
        }
        this._doc.append(input + "\n", "System.in");
        this._console.append(input + "\n", "System.in");
        return input;
    }

    private JDialog createDialog(JTextArea inputBox, Frame parentFrame) {
        final JDialog dialog = new JDialog(parentFrame, this._title, true);
        inputBox.setText("");
        Container cp = dialog.getContentPane();
        cp.add((Component)new JScrollPane(inputBox), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JLabel label = new JLabel("Enter a full line of input. Hit SHIFT+<Enter> for an embedded newline character ");
        buttonPanel.add(label);
        AbstractAction inputEnteredAction = new AbstractAction("Done"){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        JButton doneButton = new JButton(inputEnteredAction);
        buttonPanel.add(doneButton);
        dialog.getRootPane().setDefaultButton(doneButton);
        AbstractAction inputAbortedAction = new AbstractAction("Abort"){

            public void actionPerformed(ActionEvent e) {
                PopupConsole.access$102(PopupConsole.this, true);
                PopupConsole.this.interruptConsole();
            }
        };
        JButton abortButton = new JButton(inputAbortedAction);
        buttonPanel.add(abortButton);
        cp.add((Component)buttonPanel, "South");
        inputBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), INPUT_ENTERED_NAME);
        inputBox.getActionMap().put(INPUT_ENTERED_NAME, inputEnteredAction);
        buttonPanel.setSize(600, 80);
        dialog.setSize(600, 200);
        dialog.setLocationRelativeTo(parentFrame);
        return dialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String silentInput() {
        final Object monitor = new Object();
        this.monitorNotified = false;
        final StringBuffer input = new StringBuffer();
        Object object = this.commandLock;
        synchronized (object) {
            this._insertTextCommand = new Lambda<Object, String>(){

                @Override
                public Object apply(String s) {
                    input.append(s);
                    return null;
                }

                @Override
                public Object apply(Object x0) {
                    return this.apply((String)x0);
                }
            };
            this._interruptCommand = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    PopupConsole.access$202(PopupConsole.this, null);
                    PopupConsole.access$302(PopupConsole.this, null);
                    Object object = monitor;
                    synchronized (object) {
                        PopupConsole.access$402(PopupConsole.this, true);
                        monitor.notify();
                    }
                }
            };
            this.commandLock.notifyAll();
        }
        object = monitor;
        synchronized (object) {
            try {
                while (!this.monitorNotified) {
                    monitor.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        object = this.commandLock;
        synchronized (object) {
            return input.toString();
        }
    }

    static JTextArea access$000(PopupConsole x0) {
        return x0._inputBox;
    }

    static boolean access$102(PopupConsole x0, boolean x1) {
        x0.inputAborted = x1;
        return x0.inputAborted;
    }

    static Lambda access$202(PopupConsole x0, Lambda x1) {
        x0._insertTextCommand = x1;
        return x0._insertTextCommand;
    }

    static Runnable access$302(PopupConsole x0, Runnable x1) {
        x0._interruptCommand = x1;
        return x0._interruptCommand;
    }

    static boolean access$402(PopupConsole x0, boolean x1) {
        x0.monitorNotified = x1;
        return x0.monitorNotified;
    }

    private static class InputBox
    extends JTextArea {
        private static final int BORDER_WIDTH = 1;
        private static final int INNER_BUFFER_WIDTH = 3;
        private static final int OUTER_BUFFER_WIDTH = 2;

        public InputBox() {
            this.setBorder(this._createBorder());
            this.setLineWrap(true);
        }

        private Border _createBorder() {
            Border outerouter = BorderFactory.createLineBorder(this.getBackground(), 2);
            Border outer = BorderFactory.createLineBorder(this.getForeground(), 1);
            Border inner = BorderFactory.createLineBorder(this.getBackground(), 3);
            CompoundBorder temp = BorderFactory.createCompoundBorder(outer, inner);
            return BorderFactory.createCompoundBorder(outerouter, temp);
        }
    }
}

