/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.DocumentEditCondition;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.EditDocumentInterface;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class ConsoleDocument
implements EditDocumentInterface {
    public static final String DEFAULT_STYLE = "default";
    public static final String SYSTEM_OUT_STYLE = "System.out";
    public static final String SYSTEM_ERR_STYLE = "System.err";
    public static final String SYSTEM_IN_STYLE = "System.in";
    public static final String DEFAULT_CONSOLE_PROMPT = "";
    protected final EditDocumentInterface _document;
    protected volatile Runnable _beep;
    protected volatile int _promptPos;
    protected volatile String _prompt;
    protected volatile boolean _hasPrompt;
    protected DrJavaBook _book;

    public ConsoleDocument(EditDocumentInterface adapter) {
        this._document = adapter;
        this._beep = new Runnable(){

            public void run() {
            }
        };
        this._promptPos = 0;
        this._prompt = DEFAULT_CONSOLE_PROMPT;
        this._hasPrompt = false;
        this._document.setEditCondition(new ConsoleEditCondition());
    }

    public boolean hasPrompt() {
        return this._hasPrompt;
    }

    public String getPrompt() {
        return this._prompt;
    }

    public void setPrompt(String prompt) {
        this.acquireWriteLock();
        this._prompt = prompt;
        this.releaseWriteLock();
    }

    public DocumentEditCondition getEditCondition() {
        return this._document.getEditCondition();
    }

    public void setEditCondition(DocumentEditCondition condition) {
        this._document.setEditCondition(condition);
    }

    public int getPromptPos() {
        return this._promptPos;
    }

    public void setPromptPos(int newPos) {
        this.acquireReadLock();
        this._promptPos = newPos;
        this.releaseReadLock();
    }

    public void setBeep(Runnable beep) {
        this.acquireReadLock();
        this._beep = beep;
        this.releaseReadLock();
    }

    public void reset() {
        this.acquireWriteLock();
        try {
            this.forceRemoveText(0, this._document.getLength());
            this._promptPos = 0;
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void insertPrompt() {
        this.acquireWriteLock();
        try {
            this.forceInsertText(this._document.getLength(), this._prompt, DEFAULT_STYLE);
            this._promptPos = this._document.getLength();
            this._hasPrompt = true;
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disablePrompt() {
        this.acquireWriteLock();
        try {
            this._hasPrompt = false;
            this._promptPos = this._document.getLength();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void insertNewLine(int pos) {
        this.acquireWriteLock();
        try {
            int len = this._document.getLength();
            if (pos > len) {
                pos = len;
            } else if (pos < 0) {
                pos = 0;
            }
            String newLine = System.getProperty("line.separator");
            this.insertText(pos, newLine, DEFAULT_STYLE);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPositionBeforePrompt() {
        this.acquireReadLock();
        try {
            if (this._hasPrompt) {
                int n = this._promptPos - this._prompt.length();
                return n;
            }
            int n = this._document.getLength();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void insertBeforeLastPrompt(String text, String style) {
        this.acquireWriteLock();
        try {
            int pos = this.getPositionBeforePrompt();
            this._promptPos += text.length();
            this._addToStyleLists(pos, text, style);
            this._document.forceInsertText(pos, text, style);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(int offs, String str, String style) throws EditDocumentException {
        this.acquireWriteLock();
        try {
            if (offs < this._promptPos) {
                this._beep.run();
            } else {
                this._addToStyleLists(offs, str, style);
                this._document.insertText(offs, str, style);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String str, String style) throws EditDocumentException {
        this.acquireWriteLock();
        try {
            int offs = this._document.getLength();
            this._addToStyleLists(offs, str, style);
            this._document.insertText(offs, str, style);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInsertText(int offs, String str, String style) throws EditDocumentException {
        this.acquireWriteLock();
        try {
            this._addToStyleLists(offs, str, style);
            this._document.forceInsertText(offs, str, style);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void _addToStyleLists(int offs, String str, String style) {
        if (this._document instanceof SwingDocument) {
            ((SwingDocument)this._document).addColoring(offs, offs + str.length(), style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeText(int offs, int len) throws EditDocumentException {
        this.acquireWriteLock();
        try {
            if (offs < this._promptPos) {
                this._beep.run();
            } else {
                this._document.removeText(offs, len);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void forceRemoveText(int offs, int len) throws EditDocumentException {
        this._document.forceRemoveText(offs, len);
    }

    public int getLength() {
        return this._document.getLength();
    }

    public String getDocText(int offs, int len) throws EditDocumentException {
        return this._document.getDocText(offs, len);
    }

    public String getCurrentInput() {
        this.acquireReadLock();
        try {
            String string = this.getDocText(this._promptPos, this._document.getLength() - this._promptPos);
            return string;
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void clearCurrentInput() {
        this._clearCurrentInputText();
    }

    protected void _clearCurrentInputText() {
        this.acquireWriteLock();
        try {
            this.removeText(this._promptPos, this._document.getLength() - this._promptPos);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String getDefaultStyle() {
        return DEFAULT_STYLE;
    }

    public Pageable getPageable() throws IllegalStateException {
        return this._book;
    }

    public void preparePrintJob() {
        this._book = new DrJavaBook(this.getDocText(0, this.getLength()), "Console", new PageFormat());
    }

    public void print() throws PrinterException {
        this.preparePrintJob();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(this._book);
        if (printJob.printDialog()) {
            printJob.print();
        }
        this.cleanUpPrintJob();
    }

    public void cleanUpPrintJob() {
        this._book = null;
    }

    public void acquireReadLock() {
        this._document.acquireReadLock();
    }

    public void releaseReadLock() {
        this._document.releaseReadLock();
    }

    public void acquireWriteLock() {
        this._document.acquireWriteLock();
    }

    public void releaseWriteLock() {
        this._document.releaseWriteLock();
    }

    class ConsoleEditCondition
    extends DocumentEditCondition {
        ConsoleEditCondition() {
        }

        public boolean canInsertText(int offs) {
            return this.canRemoveText(offs);
        }

        public boolean canRemoveText(int offs) {
            if (offs < ConsoleDocument.this._promptPos) {
                ConsoleDocument.this._beep.run();
                return false;
            }
            return true;
        }
    }
}

