/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.text;

import edu.rice.cs.util.text.DocumentEditCondition;
import edu.rice.cs.util.text.EditDocumentException;
import edu.rice.cs.util.text.EditDocumentInterface;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.util.Hashtable;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;

public class SWTDocumentAdapter
implements EditDocumentInterface {
    protected StyledText _pane;
    protected StyledTextContent _text;
    protected Hashtable<String, SWTStyle> _styles;
    protected DocumentEditCondition _condition;
    protected boolean _forceInsert;
    protected boolean _forceRemove;
    protected EditDocumentException _editException;

    public SWTDocumentAdapter(StyledText pane) {
        this._pane = pane;
        this._text = pane.getContent();
        this._styles = new Hashtable();
        this._condition = new DocumentEditCondition();
        this._forceInsert = false;
        this._forceRemove = false;
        this._editException = null;
        this.addVerifyListener(new ConditionListener());
    }

    public void addVerifyListener(VerifyListener l) {
        this._pane.addVerifyListener(l);
    }

    public void removeVerifyListener(VerifyListener l) {
        this._pane.removeVerifyListener(l);
    }

    public void addModifyListener(ModifyListener l) {
        this._pane.addModifyListener(l);
    }

    public void removeModifyListener(ModifyListener l) {
        this._pane.removeModifyListener(l);
    }

    public void addDocStyle(String name, SWTStyle s) {
        this._styles.put(name, s);
    }

    public DocumentEditCondition getEditCondition() {
        return this._condition;
    }

    public void setEditCondition(DocumentEditCondition condition) {
        this._condition = condition;
    }

    public void insertText(int offs, String str, String style) throws EditDocumentException {
        if (this._condition.canInsertText(offs)) {
            this.forceInsertText(offs, str, style);
        }
    }

    public synchronized void forceInsertText(final int offs, final String str, String style) throws EditDocumentException {
        SWTStyle s = null;
        if (style != null) {
            s = this._styles.get(style);
        }
        final SWTStyle chosenStyle = s;
        this._editException = null;
        this._forceInsert = true;
        this._pane.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    SWTDocumentAdapter.this._pane.replaceTextRange(offs, 0, str);
                    if (chosenStyle != null) {
                        StyleRange range = new StyleRange();
                        range.start = offs;
                        range.length = str.length();
                        range.fontStyle = chosenStyle.getFontStyle();
                        range.foreground = chosenStyle.getColor();
                        SWTDocumentAdapter.this._pane.setStyleRange(range);
                    }
                }
                catch (IllegalArgumentException e) {
                    SWTDocumentAdapter.this._editException = new EditDocumentException(e);
                }
            }
        });
        this._forceInsert = false;
        if (this._editException != null) {
            throw this._editException;
        }
    }

    public void removeText(int offs, int len) throws EditDocumentException {
        if (this._condition.canRemoveText(offs)) {
            this.forceRemoveText(offs, len);
        }
    }

    public synchronized void forceRemoveText(final int offs, final int len) throws EditDocumentException {
        this._editException = null;
        this._forceRemove = true;
        this._pane.getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    SWTDocumentAdapter.this._pane.replaceTextRange(offs, len, "");
                }
                catch (IllegalArgumentException e) {
                    SWTDocumentAdapter.this._editException = new EditDocumentException(e);
                }
            }
        });
        this._forceRemove = false;
        if (this._editException != null) {
            throw this._editException;
        }
    }

    public int getLength() {
        return this._text.getCharCount();
    }

    public String getDocText(int offs, int len) throws EditDocumentException {
        try {
            return this._text.getTextRange(offs, len);
        }
        catch (IllegalArgumentException e) {
            throw new EditDocumentException(e);
        }
    }

    public void append(String str, String style) {
        int offs = this.getLength();
        this.forceInsertText(offs, str, style);
    }

    public void highlightRange(int offset, int length, Color color) {
        StyleRange range = new StyleRange();
        range.start = offset;
        range.length = length;
        range.background = color;
        this._pane.setStyleRange(range);
    }

    public void acquireReadLock() {
    }

    public void releaseReadLock() {
    }

    public void acquireWriteLock() {
    }

    public void releaseWriteLock() {
    }

    public String getDefaultStyle() {
        return "NONE";
    }

    public Pageable getPageable() throws IllegalStateException {
        return null;
    }

    public void print() throws PrinterException {
    }

    public static class SWTStyle {
        protected Color _color;
        protected int _fontStyle;

        public SWTStyle(Color color, int fontStyle) {
            this._color = color;
            this._fontStyle = fontStyle;
        }

        public Color getColor() {
            return this._color;
        }

        public int getFontStyle() {
            return this._fontStyle;
        }
    }

    protected class ConditionListener
    implements VerifyListener {
        protected ConditionListener() {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = e.text.length() == 0 ? this._canRemove(e) : (e.start == e.end ? this._canInsert(e) : this._canRemove(e) && this._canInsert(e));
        }

        protected boolean _canInsert(VerifyEvent e) {
            return SWTDocumentAdapter.this._forceInsert || SWTDocumentAdapter.this._condition.canInsertText(e.start);
        }

        protected boolean _canRemove(VerifyEvent e) {
            return SWTDocumentAdapter.this._forceRemove || SWTDocumentAdapter.this._condition.canRemoveText(e.start);
        }
    }
}

