/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import koala.dynamicjava.interpreter.AbstractTypeChecker;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.interpreter.throwable.WrongVersionException;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForEachStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.SimpleAllocation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeChecker15
extends AbstractTypeChecker {
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public TypeChecker15(Context ctx) {
        super(ctx);
    }

    @Override
    public Class<?> visit(ForEachStatement node) {
        this.context.enterScope();
        this.context.define(node.getVars().get(0), null);
        this.context.define(node.getVars().get(1), null);
        FormalParameter param = node.getParameter();
        Expression coll = node.getCollection();
        Node body = node.getBody();
        Class paramTypeClass = (Class)param.acceptVisitor(this);
        Class collTypeClass = (Class)coll.acceptVisitor(this);
        body.acceptVisitor(this);
        if (collTypeClass.isArray()) {
            Class<?> component = collTypeClass.getComponentType();
            if (!paramTypeClass.isAssignableFrom(component)) {
                throw new ExecutionError("collection.type", node);
            }
        } else if (!(class$java$util$Collection == null ? (class$java$util$Collection = TypeChecker15.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collTypeClass)) {
            throw new ExecutionError("collection.type", node);
        }
        node.getBody().acceptVisitor(this);
        node.setProperty("variables", this.context.leaveScope());
        return null;
    }

    @Override
    protected void checkGenericReferenceType(ReferenceType node) {
    }

    @Override
    protected void checkVarArgs(MethodDeclaration node) {
        try {
            (class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = TypeChecker15.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method).getMethod("isVarArgs", new Class[0]);
        }
        catch (Throwable t) {
            throw new WrongVersionException("Variable Arguments are currently only supported in the InteractionsPane for Java Version 1.5 or better.");
        }
    }

    @Override
    protected void staticImportHandler(ImportDeclaration node) {
        try {
            if (node.isStaticImportClass()) {
                this.context.declareClassStaticImport(node.getName());
            } else {
                this.context.declareMemberStaticImport(node.getName());
            }
        }
        catch (ClassNotFoundException e) {
            throw new CatchedExceptionError(e, (Node)node);
        }
    }

    @Override
    protected SimpleAllocation _box(Expression exp, Class<?> refType) {
        Constructor<?> constructor;
        String refTypeName = refType.getName();
        PrimitiveType primType = TypeChecker15._correspondingPrimType(refType);
        try {
            constructor = refType.getConstructor(primType.getValue());
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(new StringBuffer().append("The constructor for ").append(refTypeName).append(" not found.").toString());
        }
        ReferenceType ref = new ReferenceType(refTypeName, exp.getFilename(), exp.getBeginLine(), exp.getBeginColumn(), exp.getEndLine(), exp.getEndColumn());
        CastExpression castExp = new CastExpression(primType, exp, exp.getFilename(), exp.getBeginLine(), exp.getBeginColumn(), exp.getEndLine(), exp.getEndColumn());
        castExp.setProperty("type", primType.getValue());
        LinkedList<Expression> args = new LinkedList<Expression>();
        args.add(castExp);
        SimpleAllocation alloc = new SimpleAllocation(ref, args, exp.getFilename(), exp.getBeginLine(), exp.getBeginColumn(), exp.getEndLine(), exp.getEndColumn());
        alloc.setProperty("constructor", constructor);
        return alloc;
    }

    @Override
    protected ObjectMethodCall _unbox(Expression child, Class<?> type) {
        Method method;
        String methodName = "";
        Class<Object> unboxedType = type;
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeChecker15.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            methodName = "booleanValue";
            unboxedType = Boolean.TYPE;
        } else if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = TypeChecker15.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            methodName = "byteValue";
            unboxedType = Byte.TYPE;
        } else if (type == (class$java$lang$Character == null ? (class$java$lang$Character = TypeChecker15.class$("java.lang.Character")) : class$java$lang$Character)) {
            methodName = "charValue";
            unboxedType = Character.TYPE;
        } else if (type == (class$java$lang$Short == null ? (class$java$lang$Short = TypeChecker15.class$("java.lang.Short")) : class$java$lang$Short)) {
            methodName = "shortValue";
            unboxedType = Short.TYPE;
        } else if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = TypeChecker15.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            methodName = "intValue";
            unboxedType = Integer.TYPE;
        } else if (type == (class$java$lang$Long == null ? (class$java$lang$Long = TypeChecker15.class$("java.lang.Long")) : class$java$lang$Long)) {
            methodName = "longValue";
            unboxedType = Long.TYPE;
        } else if (type == (class$java$lang$Float == null ? (class$java$lang$Float = TypeChecker15.class$("java.lang.Float")) : class$java$lang$Float)) {
            methodName = "floatValue";
            unboxedType = Float.TYPE;
        } else if (type == (class$java$lang$Double == null ? (class$java$lang$Double = TypeChecker15.class$("java.lang.Double")) : class$java$lang$Double)) {
            methodName = "doubleValue";
            unboxedType = Double.TYPE;
        } else {
            throw new ExecutionError("unbox.type", child);
        }
        try {
            method = type.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(new StringBuffer().append("The method ").append(methodName).append(" not found.").toString());
        }
        ObjectMethodCall methodCall = new ObjectMethodCall(child, methodName, null, child.getFilename(), child.getBeginLine(), child.getBeginColumn(), child.getEndLine(), child.getEndColumn());
        methodCall.setProperty("method", method);
        methodCall.setProperty("type", unboxedType);
        return methodCall;
    }

    @Override
    public /* synthetic */ Object visit(ForEachStatement x0) {
        return this.visit(x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

