/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType
extends Type {
    public static final String ELEMENT_TYPE = "elementType";
    private Type elementType;

    public ArrayType(Type et, int dim) {
        this(et, dim, null, 0, 0, 0, 0);
    }

    public ArrayType(Type et, int dim, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (et == null) {
            throw new IllegalArgumentException("et == null");
        }
        if (dim < 1) {
            throw new IllegalArgumentException("dim < 1");
        }
        this.elementType = dim > 1 ? new ArrayType(et, dim - 1, fn, bl, bc, el, ec) : et;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public void setElementType(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.elementType = t;
        this.firePropertyChange(ELEMENT_TYPE, this.elementType, this.elementType);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.getElementType()).append(")").toString();
    }
}

