/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.tree.ContinueTarget;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ForSlashEachStatement;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends ForSlashEachStatement
implements ContinueTarget {
    public static final String INITIALIZATION = "initialization";
    public static final String CONDITION = "condition";
    public static final String UPDATE = "update";
    public static final String BODY = "body";
    private List<Node> initialization;
    private Expression condition;
    private List<Node> update;
    private Node body;
    private List<String> labels;

    public ForStatement(List<Node> init, Expression cond, List<Node> updt, Node body) {
        this(init, cond, updt, body, null, 0, 0, 0, 0);
    }

    public ForStatement(List<Node> init, Expression cond, List<Node> updt, Node body, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (body == null) {
            throw new IllegalArgumentException("body == null");
        }
        this.initialization = init;
        this.condition = cond;
        this.update = updt;
        this.body = body;
        this.labels = new LinkedList<String>();
    }

    public List<Node> getInitialization() {
        return this.initialization;
    }

    public void setInitialization(List<Node> l) {
        this.initialization = l;
        this.firePropertyChange(INITIALIZATION, this.initialization, this.initialization);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression e) {
        this.condition = e;
        this.firePropertyChange(CONDITION, this.condition, this.condition);
    }

    public List<Node> getUpdate() {
        return this.update;
    }

    public void setUpdate(List<Node> l) {
        this.update = l;
        this.firePropertyChange(UPDATE, this.update, this.update);
    }

    public Node getBody() {
        return this.body;
    }

    public void setBody(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node == null");
        }
        this.body = node;
        this.firePropertyChange(BODY, this.body, this.body);
    }

    @Override
    public void addLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        this.labels.add(label);
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.getInitialization()).append(" ").append(this.getCondition()).append(" ").append(this.getUpdate()).append(" ").append(this.getBody()).append(")").toString();
    }
}

