/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.visitor.Visitor;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDeclaration
extends Node {
    public static final String NAME = "name";
    public static final String PACKAGE = "package";
    private String name;
    private boolean pckage;
    private boolean sttic;

    public ImportDeclaration(List<IdentifierToken> ident, boolean pkg, boolean sttc) {
        this(ident, pkg, sttc, null, 0, 0, 0, 0);
    }

    public ImportDeclaration(List<IdentifierToken> ident, boolean pkg, boolean sttc, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (ident == null) {
            throw new IllegalArgumentException("ident == null");
        }
        if (sttc) {
            TigerUtilities.assertTigerEnabled("Static Import is not supported before Java 1.5");
        }
        this.pckage = pkg;
        this.sttic = sttc;
        this.name = TreeUtilities.listToName(ident);
    }

    public ImportDeclaration(String nm, boolean pkg, boolean sttc, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (nm == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.pckage = pkg;
        this.sttic = sttc;
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public boolean isPackage() {
        return this.pckage;
    }

    public boolean isStaticImportClass() {
        return this.sttic && this.pckage;
    }

    public void setPackage(boolean b) {
        this.pckage = b;
        this.firePropertyChange(PACKAGE, this.pckage, this.pckage);
    }

    public boolean isStatic() {
        return this.sttic;
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(this.toStringHelper()).append(")").toString();
    }

    public String toStringHelper() {
        return new StringBuffer().append(this.getName()).append(" ").append(this.isPackage()).append(" ").append(this.isStatic()).toString();
    }
}

