/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.util.AmbiguousFieldException;
import koala.dynamicjava.util.AmbiguousFunctionException;
import koala.dynamicjava.util.AmbiguousMethodException;
import koala.dynamicjava.util.TigerUtilities;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtilities {
    static /* synthetic */ Class class$java$lang$Object;

    public static Constructor lookupConstructor(Class<?> cl, Class<?>[] ac) throws NoSuchMethodException {
        TigerUsage tu;
        List<Constructor> all = ReflectionUtilities.getConstructors(cl, ac.length);
        LinkedList<Constructor> compatible = new LinkedList<Constructor>();
        for (Constructor c : all) {
            if (!ReflectionUtilities.hasCompatibleSignatures(c.getParameterTypes(), ac)) continue;
            compatible.add(c);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificConstructor(compatible);
        }
        for (Constructor c : all) {
            tu = new TigerUsage();
            if (!ReflectionUtilities.hasAutoBoxingCompatibleSignatures(c.getParameterTypes(), ac, tu)) continue;
            tu.checkForCompatibleUsage();
            compatible.add(c);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificBoxingConstructor(compatible);
        }
        for (Constructor c : all) {
            tu = new TigerUsage();
            if (!ReflectionUtilities.hasVarArgsCompatibleSignatures(c.getParameterTypes(), ac, tu)) continue;
            tu.checkForCompatibleUsage();
            compatible.add(c);
        }
        if (compatible.isEmpty()) {
            throw new NoSuchMethodException(ReflectionUtilities.generateNotFoundMsg("constructor", cl.getName(), ac));
        }
        if (compatible.size() > 1) {
            throw new AmbiguousMethodException(new StringBuffer().append("both constructors match: ").append(compatible.get(0)).append(", and ").append(compatible.get(1)).toString());
        }
        return (Constructor)compatible.get(0);
    }

    public static List<Constructor> getConstructors(Class<?> cl, int params) {
        LinkedList<Constructor> result = new LinkedList<Constructor>();
        Constructor<?>[] ms = cl.getDeclaredConstructors();
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i].getParameterTypes().length > params + 1) continue;
            result.add(ms[i]);
        }
        return result;
    }

    public static Method lookupMethod(Class<?> cl, String name, List<Class> ac) throws NoSuchMethodException {
        return ReflectionUtilities.lookupMethod(cl, name, ac.toArray(new Class[0]));
    }

    public static Method lookupMethod(Class<?> cl, String name, Class<?>[] ac) throws NoSuchMethodException {
        TigerUsage tu;
        List<Method> all = ReflectionUtilities.getMethods(cl, name, ac.length);
        LinkedList<Method> compatible = new LinkedList<Method>();
        for (Method m : all) {
            if (!ReflectionUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            compatible.add(m);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificMethod(compatible);
        }
        for (Method m : all) {
            tu = new TigerUsage();
            if (!ReflectionUtilities.hasAutoBoxingCompatibleSignatures(m.getParameterTypes(), ac, tu)) continue;
            tu.checkForCompatibleUsage();
            compatible.add(m);
        }
        if (!compatible.isEmpty()) {
            return ReflectionUtilities.selectTheMostSpecificBoxingMethod(compatible);
        }
        for (Method m : all) {
            tu = new TigerUsage();
            if (!ReflectionUtilities.hasVarArgsCompatibleSignatures(m.getParameterTypes(), ac, tu)) continue;
            tu.checkForCompatibleUsage();
            compatible.add(m);
        }
        if (compatible.isEmpty()) {
            throw new NoSuchMethodException(ReflectionUtilities.generateNotFoundMsg("method", new StringBuffer().append(cl.getName()).append(".").append(name).toString(), ac));
        }
        if (compatible.size() == 1) {
            return (Method)compatible.get(0);
        }
        throw new AmbiguousMethodException((Method)compatible.get(0), (Method)compatible.get(1));
    }

    public static List<Method> getMethods(Class<?> cl, String name, int params) {
        LinkedList<Method> result = new LinkedList<Method>();
        if (cl.isInterface()) {
            Method[] ms = cl.getDeclaredMethods();
            for (int i = 0; i < ms.length; ++i) {
                if (!ms[i].getName().equals(name) || ms[i].getParameterTypes().length > params + 1) continue;
                result.add(ms[i]);
            }
            Class<?>[] cs = cl.getInterfaces();
            for (int i = 0; i < cs.length; ++i) {
                result.addAll(ReflectionUtilities.getMethods(cs[i], name, params));
            }
            if (cs.length == 0) {
                result.addAll(ReflectionUtilities.getMethods(class$java$lang$Object == null ? (class$java$lang$Object = ReflectionUtilities.class$("java.lang.Object")) : class$java$lang$Object, name, params));
            }
        } else {
            for (Class<?> c = cl; c != null; c = c.getSuperclass()) {
                Method[] ms = c.getDeclaredMethods();
                for (int i = 0; i < ms.length; ++i) {
                    if (!ms[i].getName().equals(name) || ms[i].getParameterTypes().length > params + 1) continue;
                    result.add(ms[i]);
                }
            }
        }
        return result;
    }

    public static Method lookupOuterMethod(Class<?> cl, String name, Class<?>[] ac) throws NoSuchMethodException {
        Class<?> c;
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class<?> clazz = c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                Method m = ReflectionUtilities.lookupMethod(c, name, ac);
                if (!sc || Modifier.isStatic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchMethodException(ReflectionUtilities.generateNotFoundMsg("method", name, ac));
    }

    public static Field getField(Class<?> cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        for (Class<?> c = cl; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                Class<?>[] ints = c.getInterfaces();
                Field f = null;
                for (int i = 0; i < ints.length; ++i) {
                    Field tmp = null;
                    try {
                        tmp = ReflectionUtilities.getField(ints[i], name);
                    }
                    catch (NoSuchFieldException ex) {
                        // empty catch block
                    }
                    if (tmp == null) continue;
                    if (f != null && !f.equals(tmp)) {
                        throw new AmbiguousFieldException(name);
                    }
                    f = tmp;
                }
                if (f == null) continue;
                return f;
            }
        }
        throw new NoSuchFieldException(name);
    }

    public static Field getOuterField(Class<?> cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        Class<?> c;
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class<?> clazz = c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                Field f = ReflectionUtilities.getField(c, name);
                if (!sc || Modifier.isStatic(f.getModifiers())) {
                    return f;
                }
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchFieldException(name);
    }

    protected static Method selectTheMostSpecificMethod(List<Method> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<Method> it = list.iterator();
        Method best = it.next();
        while (TigerUtilities.isBridge(best)) {
            if (it.hasNext()) {
                best = it.next();
                continue;
            }
            return null;
        }
        Method ambiguous = null;
        while (it.hasNext()) {
            Method curr = it.next();
            if (TigerUtilities.isBridge(curr)) continue;
            Object[] a1 = best.getParameterTypes();
            Object[] a2 = curr.getParameterTypes();
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isCompatible(a1[i], a2[i]);
                boolean from1to2 = ReflectionUtilities.isCompatible(a2[i], a1[i]);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                if (Arrays.equals(a1, a2)) {
                    Class<?> c1 = best.getDeclaringClass();
                    Class<?> c2 = curr.getDeclaringClass();
                    boolean c1IsSuperOrSame = c1.isAssignableFrom(c2);
                    boolean c2IsSuperOrSame = c2.isAssignableFrom(c1);
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousMethodException(best, ambiguous);
        }
        return best;
    }

    public static MethodDeclaration selectTheMostSpecificFunction(List<MethodDeclaration> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<MethodDeclaration> it = list.iterator();
        MethodDeclaration best = it.next();
        while (best.isBridge()) {
            if (it.hasNext()) {
                best = it.next();
                continue;
            }
            return null;
        }
        MethodDeclaration ambiguous = null;
        while (it.hasNext()) {
            MethodDeclaration curr = it.next();
            if (curr.isBridge()) continue;
            List<FormalParameter> l1 = best.getParameters();
            List<FormalParameter> l2 = curr.getParameters();
            Class[] a1 = new Class[l1.size()];
            Class[] a2 = new Class[l2.size()];
            Iterator<FormalParameter> it1 = l1.iterator();
            Iterator<FormalParameter> it2 = l2.iterator();
            int i = 0;
            while (it1.hasNext() && it2.hasNext()) {
                a1[i] = NodeProperties.getType(it1.next());
                a2[i++] = NodeProperties.getType(it2.next());
            }
            boolean better1 = false;
            boolean better2 = false;
            for (i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isCompatible(a1[i], a2[i]);
                boolean from1to2 = ReflectionUtilities.isCompatible(a2[i], a1[i]);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousFunctionException(new StringBuffer().append("Both functions match: ").append(best).append(", and ").append(ambiguous).toString());
        }
        return best;
    }

    protected static Constructor selectTheMostSpecificConstructor(List<Constructor> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<Constructor> it = list.iterator();
        Constructor best = it.next();
        Constructor ambiguous = null;
        while (it.hasNext()) {
            Constructor curr = it.next();
            Object[] a1 = best.getParameterTypes();
            Object[] a2 = curr.getParameterTypes();
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isCompatible(a1[i], a2[i]);
                boolean from1to2 = ReflectionUtilities.isCompatible(a2[i], a1[i]);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                if (Arrays.equals(a1, a2)) {
                    Class c1 = best.getDeclaringClass();
                    Class c2 = curr.getDeclaringClass();
                    boolean c1IsSuperOrSame = c1.isAssignableFrom(c2);
                    boolean c2IsSuperOrSame = c2.isAssignableFrom(c1);
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousMethodException(new StringBuffer().append("Both constructors match: ").append(best).append(", and ").append(ambiguous).toString());
        }
        return best;
    }

    protected static Method selectTheMostSpecificBoxingMethod(List<Method> list) {
        if (list.isEmpty()) {
            return null;
        }
        TigerUsage tu = new TigerUsage();
        Iterator<Method> it = list.iterator();
        Method best = it.next();
        Method ambiguous = null;
        while (it.hasNext()) {
            Method curr = it.next();
            Object[] a1 = best.getParameterTypes();
            Object[] a2 = curr.getParameterTypes();
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isBoxCompatible(a1[i], a2[i], tu);
                boolean from1to2 = ReflectionUtilities.isBoxCompatible(a2[i], a1[i], tu);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                if (Arrays.equals(a1, a2)) {
                    Class<?> c1 = best.getDeclaringClass();
                    Class<?> c2 = curr.getDeclaringClass();
                    boolean c1IsSuperOrSame = c1.isAssignableFrom(c2);
                    boolean c2IsSuperOrSame = c2.isAssignableFrom(c1);
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousMethodException(best, ambiguous);
        }
        return best;
    }

    public static MethodDeclaration selectTheMostSpecificBoxingFunction(List<MethodDeclaration> list) {
        if (list.isEmpty()) {
            return null;
        }
        TigerUsage tu = new TigerUsage();
        Iterator<MethodDeclaration> it = list.iterator();
        MethodDeclaration best = it.next();
        MethodDeclaration ambiguous = null;
        while (it.hasNext()) {
            MethodDeclaration curr = it.next();
            List<FormalParameter> l1 = best.getParameters();
            List<FormalParameter> l2 = curr.getParameters();
            Class[] a1 = new Class[l1.size()];
            Class[] a2 = new Class[l2.size()];
            Iterator<FormalParameter> it1 = l1.iterator();
            Iterator<FormalParameter> it2 = l2.iterator();
            int i = 0;
            while (it1.hasNext() && it2.hasNext()) {
                a1[i] = NodeProperties.getType(it1.next());
                a2[i++] = NodeProperties.getType(it2.next());
            }
            boolean better1 = false;
            boolean better2 = false;
            for (i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isBoxCompatible(a1[i], a2[i], tu);
                boolean from1to2 = ReflectionUtilities.isBoxCompatible(a2[i], a1[i], tu);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousFunctionException(new StringBuffer().append("Both functions match: ").append(best).append(", and ").append(ambiguous).toString());
        }
        return best;
    }

    protected static Constructor selectTheMostSpecificBoxingConstructor(List<Constructor> list) {
        if (list.isEmpty()) {
            return null;
        }
        TigerUsage tu = new TigerUsage();
        Iterator<Constructor> it = list.iterator();
        Constructor best = it.next();
        Constructor ambiguous = null;
        while (it.hasNext()) {
            Constructor curr = it.next();
            Object[] a1 = best.getParameterTypes();
            Object[] a2 = curr.getParameterTypes();
            boolean better1 = false;
            boolean better2 = false;
            for (int i = 0; i < a1.length; ++i) {
                boolean from2to1 = ReflectionUtilities.isBoxCompatible(a1[i], a2[i], tu);
                boolean from1to2 = ReflectionUtilities.isBoxCompatible(a2[i], a1[i], tu);
                if (from1to2 && !from2to1) {
                    better1 = true;
                }
                if (!from2to1 || from1to2) continue;
                better2 = true;
            }
            if (!(better1 ^ better2)) {
                if (Arrays.equals(a1, a2)) {
                    Class c1 = best.getDeclaringClass();
                    Class c2 = curr.getDeclaringClass();
                    boolean c1IsSuperOrSame = c1.isAssignableFrom(c2);
                    boolean c2IsSuperOrSame = c2.isAssignableFrom(c1);
                    if (c1IsSuperOrSame && !c2IsSuperOrSame) {
                        best = curr;
                        continue;
                    }
                    if (c2IsSuperOrSame && !c1IsSuperOrSame) continue;
                }
                ambiguous = curr;
                continue;
            }
            if (!better2) continue;
            best = curr;
            ambiguous = null;
        }
        if (ambiguous != null) {
            throw new AmbiguousMethodException(new StringBuffer().append("Both constructors match: ").append(best).append(", and ").append(ambiguous).toString());
        }
        return best;
    }

    public static boolean hasCompatibleSignatures(Class<?>[] a1, Class<?>[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (ReflectionUtilities.isCompatible(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAutoBoxingCompatibleSignatures(Class<?>[] a1, Class<?>[] a2, TigerUsage tu) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (ReflectionUtilities.isBoxCompatible(a1[i], a2[i], tu)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVarArgsCompatibleSignatures(Class<?>[] a1, Class<?>[] a2, TigerUsage tu) {
        if (a1.length == 0) {
            return a2.length == 0;
        }
        if (a1.length > a2.length + 1) {
            return false;
        }
        for (int i = 0; i < a1.length - 1; ++i) {
            if (ReflectionUtilities.isBoxCompatible(a1[i], a2[i], tu)) continue;
            return false;
        }
        int lastIdx1 = a1.length - 1;
        Class<?> lastElt1 = a1[lastIdx1];
        if (lastElt1.isArray() && a2.length == a1.length - 1) {
            tu.varArgsAreUsed();
            return true;
        }
        if (lastElt1.isArray() && (a2[lastIdx1] == null || !a2[lastIdx1].isArray())) {
            tu.varArgsAreUsed();
            Class<?> varArgsType = lastElt1.getComponentType();
            for (int i = lastIdx1; i < a2.length; ++i) {
                if (ReflectionUtilities.isBoxCompatible(varArgsType, a2[i], tu)) continue;
                return false;
            }
        } else if (a1.length != a2.length || !ReflectionUtilities.isBoxCompatible(lastElt1, a2[lastIdx1], tu)) {
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Class<?> c1, Class<?> c2) {
        if (c1.isPrimitive()) {
            if (c1 != c2) {
                if (c1 == Integer.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Character.TYPE;
                }
                if (c1 == Long.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE;
                }
                if (c1 == Short.TYPE) {
                    return c2 == Byte.TYPE;
                }
                if (c1 == Float.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE;
                }
                if (c1 == Double.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE || c2 == Float.TYPE;
                }
                return false;
            }
            return true;
        }
        return c2 == null ? true : c1.isAssignableFrom(c2);
    }

    public static boolean isBoxCompatible(Class<?> c1, Class<?> c2, TigerUsage tu) {
        if (c1.isPrimitive()) {
            if (!c2.isPrimitive()) {
                tu.autoBoxingIsUsed();
            }
            if (c1 != (c2 = TigerUtilities.correspondingPrimType(c2))) {
                if (c1 == Integer.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Character.TYPE;
                }
                if (c1 == Long.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE;
                }
                if (c1 == Short.TYPE) {
                    return c2 == Byte.TYPE;
                }
                if (c1 == Float.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE;
                }
                if (c1 == Double.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE || c2 == Float.TYPE;
                }
                return false;
            }
            return true;
        }
        if (c2 != null && c2.isPrimitive()) {
            tu.autoBoxingIsUsed();
            c2 = TigerUtilities.correspondingBoxingType(c2);
        }
        return c2 == null ? true : c1.isAssignableFrom(c2);
    }

    protected static String generateNotFoundMsg(String methodType, String mName, Class<?>[] ac) {
        String msg = new StringBuffer().append(methodType).append(" ").append(mName).append("(").toString();
        if (ac.length > 0) {
            msg = new StringBuffer().append(msg).append(ac[0].getName()).toString();
        }
        for (int i = 1; i < ac.length; ++i) {
            msg = new StringBuffer().append(msg).append(",").append(ac[i].getName()).toString();
        }
        msg = new StringBuffer().append(msg).append(")").toString();
        return msg;
    }

    protected ReflectionUtilities() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    public static class TigerUsage {
        private boolean _autoBox = false;
        private boolean _varArgs = false;

        public void autoBoxingIsUsed() {
            this._autoBox = true;
        }

        public boolean isAutoBoxingUsed() {
            return this._autoBox;
        }

        public void varArgsAreUsed() {
            this._varArgs = true;
        }

        public boolean areVarArgsUsed() {
            return this._varArgs;
        }

        public void checkForCompatibleUsage() {
            String msg = "only allowed in Java 2 v1.5 or better";
            if (this._autoBox && this._varArgs) {
                TigerUtilities.assertTigerEnabled("Auto-boxing and variable arguments are" + msg);
            } else if (this._varArgs) {
                TigerUtilities.assertTigerEnabled("Variable arguments are" + msg);
            } else if (this._autoBox) {
                TigerUtilities.assertTigerEnabled("Auto-boxing is" + msg);
            }
        }

        public String toString() {
            return "TigerUsage: {Boxing:" + this._autoBox + ", VarArgs:" + this._varArgs + "}";
        }
    }
}

