/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import koala.dynamicjava.interpreter.throwable.WrongVersionException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerUtilities {
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;
    public static final float VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static boolean _tigerEnabled;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static void resetVersion() {
        try {
            Integer.valueOf(5);
            _tigerEnabled = true;
        }
        catch (Throwable t) {
            _tigerEnabled = (double)VERSION >= 1.5;
        }
    }

    public static boolean isTigerEnabled() {
        return _tigerEnabled;
    }

    public static void setTigerEnabled(boolean enabled) {
        _tigerEnabled = enabled;
    }

    public static void assertTigerEnabled(String msg) {
        if (!_tigerEnabled) {
            throw new WrongVersionException(msg);
        }
    }

    public static boolean isVarArgs(Method m) {
        return _tigerEnabled && (m.getModifiers() & 0x80) != 0;
    }

    public static boolean isVarArgs(Constructor c) {
        return _tigerEnabled && (c.getModifiers() & 0x80) != 0;
    }

    public static boolean isBridge(Method m) {
        return (m.getModifiers() & 0x40) != 0;
    }

    public static boolean isEnum(Class<?> c) {
        return _tigerEnabled && c.getSuperclass() != null && c.getSuperclass().getName().equals("java.lang.Enum");
    }

    public static boolean isEnumConstant(Field f) {
        return _tigerEnabled && (f.getModifiers() & 0x4000) != 0;
    }

    public static Class<?> correspondingBoxingType(Class<?> primType) {
        if (primType == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TigerUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (primType == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = TigerUtilities.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (primType == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = TigerUtilities.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (primType == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = TigerUtilities.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (primType == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = TigerUtilities.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (primType == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = TigerUtilities.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (primType == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = TigerUtilities.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (primType == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = TigerUtilities.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return primType;
    }

    public static Class<?> correspondingPrimType(Class<?> refType) {
        if (refType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TigerUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (refType == (class$java$lang$Byte == null ? (class$java$lang$Byte = TigerUtilities.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (refType == (class$java$lang$Character == null ? (class$java$lang$Character = TigerUtilities.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (refType == (class$java$lang$Short == null ? (class$java$lang$Short = TigerUtilities.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        if (refType == (class$java$lang$Integer == null ? (class$java$lang$Integer = TigerUtilities.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (refType == (class$java$lang$Long == null ? (class$java$lang$Long = TigerUtilities.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (refType == (class$java$lang$Float == null ? (class$java$lang$Float = TigerUtilities.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (refType == (class$java$lang$Double == null ? (class$java$lang$Double = TigerUtilities.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        return refType;
    }

    public static boolean isBoxingType(Class<?> c) {
        return c == (class$java$lang$Integer == null ? (class$java$lang$Integer = TigerUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) || c == (class$java$lang$Long == null ? (class$java$lang$Long = TigerUtilities.class$("java.lang.Long")) : class$java$lang$Long) || c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TigerUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c == (class$java$lang$Double == null ? (class$java$lang$Double = TigerUtilities.class$("java.lang.Double")) : class$java$lang$Double) || c == (class$java$lang$Character == null ? (class$java$lang$Character = TigerUtilities.class$("java.lang.Character")) : class$java$lang$Character) || c == (class$java$lang$Short == null ? (class$java$lang$Short = TigerUtilities.class$("java.lang.Short")) : class$java$lang$Short) || c == (class$java$lang$Byte == null ? (class$java$lang$Byte = TigerUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) || c == (class$java$lang$Float == null ? (class$java$lang$Float = TigerUtilities.class$("java.lang.Float")) : class$java$lang$Float);
    }

    public static boolean isIntegralType(Class<?> c) {
        return c == Integer.TYPE || c == (class$java$lang$Integer == null ? (class$java$lang$Integer = TigerUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) || c == Long.TYPE || c == (class$java$lang$Long == null ? (class$java$lang$Long = TigerUtilities.class$("java.lang.Long")) : class$java$lang$Long) || c == Byte.TYPE || c == (class$java$lang$Byte == null ? (class$java$lang$Byte = TigerUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) || c == Character.TYPE || c == (class$java$lang$Character == null ? (class$java$lang$Character = TigerUtilities.class$("java.lang.Character")) : class$java$lang$Character) || c == Short.TYPE || c == (class$java$lang$Short == null ? (class$java$lang$Short = TigerUtilities.class$("java.lang.Short")) : class$java$lang$Short);
    }

    public static boolean boxesTo(Class<?> prim, Class<?> ref) {
        return prim == Integer.TYPE && ref == (class$java$lang$Integer == null ? (class$java$lang$Integer = TigerUtilities.class$("java.lang.Integer")) : class$java$lang$Integer) || prim == Long.TYPE && ref == (class$java$lang$Long == null ? (class$java$lang$Long = TigerUtilities.class$("java.lang.Long")) : class$java$lang$Long) || prim == Byte.TYPE && ref == (class$java$lang$Byte == null ? (class$java$lang$Byte = TigerUtilities.class$("java.lang.Byte")) : class$java$lang$Byte) || prim == Character.TYPE && ref == (class$java$lang$Character == null ? (class$java$lang$Character = TigerUtilities.class$("java.lang.Character")) : class$java$lang$Character) || prim == Short.TYPE && ref == (class$java$lang$Short == null ? (class$java$lang$Short = TigerUtilities.class$("java.lang.Short")) : class$java$lang$Short) || prim == Boolean.TYPE && ref == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TigerUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean) || prim == Float.TYPE && ref == (class$java$lang$Float == null ? (class$java$lang$Float = TigerUtilities.class$("java.lang.Float")) : class$java$lang$Float) || prim == Double.TYPE && ref == (class$java$lang$Double == null ? (class$java$lang$Double = TigerUtilities.class$("java.lang.Double")) : class$java$lang$Double);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        TigerUtilities.resetVersion();
    }
}

