/*
 * du2ps is a modification of xdu
 * 1992 1994 Takanori Nagae <nagae@an.ip.titech.ac.jp>
 *           Shigeru Makino <mac@research.co.jp>
 */
/*
 * The following is the copyright & permission notices of xdu
 */
/*
 * XDU - X Window System Interface.
 * Display the output of "du" in an X window.
 *
 *
 * Phillip C. Dykstra
 * <phil@BRL.MIL>
 * 4 Sep 1991.
 *
 * Copyright (C)    Phillip C. Dykstra  1991
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the authors name not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>
#include <sys/param.h>

extern char *malloc(), *calloc(), *strcpy();

#define strdup(_s_) strcpy(malloc(strlen(_s_)+ 1),_s_)

#define MAXDEPTH  80    /* max elements in a path */

#ifndef MAXPATH
#	define MAXPATH   4096  /* max total pathname length */
#endif

#define NCOLS_PORTRAIT 7
#define NCOLS_LANDSCAPE 10 
#define MIN_DEPTH 0
#define MARGIN 50
#define FONT_SIZE 8
#define FONT_FAMILY "Times-Roman"
#define LINE_WIDTH 0.5
#define HEAD_SEP 5.0
#define A4_WIDTH 595.275591
#define A4_HEIGHT 841.889764
#define B4_WIDTH 728.503937
#define B4_HEIGHT 1031.811024
#define B5_WIDTH 515.905512
#define B5_HEIGHT 728.503937
#define US_WIDTH (8.5 * 72)
#define US_HEIGHT (11 * 72)

enum _ps_type_ { EPS, PORTRAIT, LANDSCAPE };

/*
 * Node Structure
 * Each node in the path tree is linked in with one of these.
 */
typedef struct _node_ {
    struct _node_ *peer;  /* siblings */
    struct _node_ *child; /* list of children if !NULL */
    int nchild;		  /* number of children */
    int size;             /* from here down */
    char *name;
} Node;

#define NODE_NULL ((Node *)0)
