/*
 * getopt.c
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the authors name not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */
#include "du2ps.h"

int orientation, ncols;
double paper_width, paper_height, margin, font_size, linewidth;
char *font_family;
int ps_type;

static char *usage[] ={
	"du2ps [options] < infile > outfile",
	"OPTIONS:",
	"  -land       ... landscape",
	"  -b4         ... B4",
	"  -b5         ... B5",
	"  -us         ... US letter",
	"  -sa         ... sort alphabetically",
	"  -ff name    ... font family name",
	"  -fs size    ... font size",
	"  -ms size    ... margin size",
	"  -lw size    ... line width",
	"  -ncols num  ... number of columns",
	"  -eps w h    ... output an epsfile contained in BoundingBox:0 0 w h",
	NULL,
};

void getopt(argc, argv)
int argc;
char **argv;
{
	extern void print_message();
	extern int (*cmp)(), cmp_alph(), cmp_size();

	int	i;

	ncols = NCOLS_PORTRAIT;
	paper_width = A4_WIDTH;
	paper_height = A4_HEIGHT;
	font_family = strdup(FONT_FAMILY);
	font_size = FONT_SIZE;
	margin = MARGIN;
	linewidth = LINE_WIDTH;
	cmp = cmp_size;
	ps_type = PORTRAIT;

	/* default values */
	for(i = 1; argc > i;){
		if(!strcmp("-land", argv[i])){
			ps_type = LANDSCAPE;
			ncols = NCOLS_LANDSCAPE;
			i++;
		} else if(!strcmp("-sa", argv[i])){
			cmp = cmp_alph;
			i++;
		} else if(!strcmp("-b4", argv[i])){
			paper_width = B4_WIDTH;
			paper_height = B4_HEIGHT;
			i++;
		} else if(!strcmp("-b5", argv[i])){
			paper_width = B5_WIDTH;
			paper_height = B5_HEIGHT;
			i++;
		} else if(!strcmp("-us", argv[i])){
			paper_width = US_WIDTH;
			paper_height = US_HEIGHT;
			i++;
		} else if(!strcmp("-ff", argv[i])){
			font_family = strdup(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-fs", argv[i])){
			font_size = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-ms", argv[i])){
			margin = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-lw", argv[i])){
			linewidth = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-ncols", argv[i])){
			ncols = atoi(argv[i + 1]);
			i += 2;
			if (ncols > MAXDEPTH) {
				fprintf(stderr, "too large '-ncols'\n");
				exit (1);
			}
		} else if(!strcmp("-eps", argv[i])){
			paper_width = atof(argv[i + 1]);
			paper_height = atof(argv[i + 2]);
			ps_type = EPS;
			i += 3;
		} else {
			fprintf(stderr, "unknown option %s\n", argv[i]);
			print_message(usage);
			exit(1);
		}
	}
}
