/*
 * nodeop.c
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the authors name not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */
#include "du2ps.h"

Node *top;
int (*cmp)();

static void
drawrect(nodep, y, height, depth)
Node *nodep;
double y, height;
int depth;
{
	printf("%d (%s \\(%d\\)) %.2f %.2f\n",
        depth, nodep->name, nodep->size, height, y);
}

/*
 * create a new node with the given name and set other initial values
 */
static Node *
makenode(name)
char *name;
{
	Node *nodep;

	if (NULL == (nodep = (Node *) malloc(
		(unsigned) (sizeof(Node) + strlen(name) + 1)))) {
		fprintf(stderr, "malloc error\n");
		exit (1);
	}
	nodep->child = nodep->peer = NODE_NULL;
	nodep->nchild = nodep->size = 0;
	nodep->name = (char *) &nodep[1];
	strcpy(nodep->name, name);
	return nodep;
}


static void
addtree(nodep, path, size)
Node *nodep;
char *path[];
int size;
{
	Node *child;

	/* check all children for a match */
	for(child = nodep->child; NODE_NULL != child; child = child->peer){
		if(!strcmp(path[0], child->name)) break;
	}

	if (NODE_NULL == child) {
		child = nodep->child;
		nodep->child = makenode(path[0]);
		nodep->child->peer = child;
		child = nodep->child;
		nodep->nchild++;
	}

	if (NULL == path[1]) {
		child->size = size;
	}
	else {
		addtree(child, &path[1], size);
	}
	return;
}

int
cmp_alph(p, q)
Node **p, **q;
{
	return strcmp((*p)->name, (*q)->name);
}

int
cmp_size(p, q)
Node **p, **q;
{
	return ((*q)->size - (*p)->size);
}

static void
sorttree(nodep)
Node *nodep;
{
	Node *child;
	Node **nodtbl;
	int i, ind;

	if (NODE_NULL == nodep->child) return;

	if (NULL == (nodtbl = (Node **) malloc(
		sizeof(Node *) * nodep->nchild))) {
		fprintf(stderr, "malloc error\n");
		exit (1);
	}

	for(child = nodep->child, ind = 0;
		NODE_NULL != child; child = child->peer, ind++){
		nodtbl[ind] = child;
		if (NODE_NULL != child->child) {
			sorttree(child);
		}
	}

	if (2 <= nodep->nchild) {
		qsort((char *) nodtbl, nodep->nchild, sizeof(Node *), cmp);

		nodep->child = nodtbl[0];
		for (i = 1; i < nodep->nchild; ++i) {
			nodtbl[i - 1]->peer = nodtbl[i];
		}
		nodtbl[i - 1]->peer = NODE_NULL;
	}

	free(nodtbl);

	return;
}


static void
drawchildren(nodep, y, h, depth)
Node *nodep; /* node whose children we should draw */
double y, h;
int depth;
{
	Node *np;

    /* for each child */
	for(np = nodep->child; NODE_NULL != np; np = np->peer){
		double height = h * np->size / nodep->size;

		drawrect(np, y, height, depth);

		/* draw children in subrectangle */
		drawchildren(np, y, height, depth + 1);
		y -= height;
    }
}

/*
 * reads du output,
 * builds hierarchy structure,
 * returns the top directory name.
 */
#define MAXLL MAXPATH+80
char *
parse()
{
	char buf[MAXLL], name[MAXPATH+1], *n;
	char *path[MAXDEPTH]; /* break up path into this list */
	int depth, size;

	top = makenode("..");
	while(NULL != fgets(buf, MAXLL, stdin)){

		sscanf(buf, "%d %s\n", &size, n = name);
		if('/' == *n) n++;     /* skip leading / */
		path[depth = 0] = n;
			
		for(; NULL != *n; n++){
			if('/' == *n){
				*n = NULL;
				path[++depth] = n + 1;
				if(depth > MAXDEPTH) break;
			}
		}
		path[++depth] = NULL;
		addtree(top, path, size);
	}
	sorttree(top);

	/*
	 * descend hierarchy until the number of children is not 1.
	 * if the directory size is 0, then total the sizes of the children.
	 */
	for(n = name; 0 == top->size;){
		Node *np;

		if (1 == top->nchild) {
			top = top->child;
			while (NULL != *n) n++;
			*n = '/';
		}
		else if(1 < top->nchild){
			for(np = top->child; NODE_NULL != np; np = np->peer){
				top->size = top->size + np->size;
			}
			break;
		}
		else break;
	}
	*n = NULL;
	return strdup(name);
}

void
drawnode(canvas_height)
double canvas_height;
{
	/* draw the top directory */
	drawrect(top, canvas_height, canvas_height, 0);
	/* draw children recursively */ 
	drawchildren(top, canvas_height, canvas_height, 1);
}
