/* $Id: du2ps.c,v 3.1 2005/02/19 08:29:53 mac Exp $
 *
 * du2ps.c
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the authors name not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */
#include "du2ps.h"

static char *prolog[] ={
	"%!",
	"%%Creator: du2ps",
	NULL,
};

static char *procs[] ={
	"/readToken { currentfile token pop } bind def",
	"",
	"/rect { % width height x y",
	"  newpath moveto",
	"  1 index 0 rlineto 0 exch rlineto neg 0 rlineto closepath",
	"} bind def",
	"",
	"/rectShow {",
	"  /depth readToken def",
	"  depth 0 lt { exit } if",
	"  /str readToken def",
	"  /height readToken def",
	"  /y readToken def",
	"  /h readToken def",
	"  /s readToken def",
	"  /b readToken def",
	"  depth ncols lt { % if",
	"    /x cellwidth depth mul def",
	"    newpath x y moveto",
	"    cellwidth 0 rlineto 0 height neg rlineto cellwidth neg 0 rlineto",
	"    closepath",
	"    gsave h s b sethsbcolor fill grestore stroke",
	"    0 0 0 sethsbcolor",
	"    height fontsize gt { % if",
	"      x emheight 3 div add y height emheight add 2 div sub moveto",
	"      str show",
	"    } if",
	"  } if",
	"} bind def",
	"",
	"newpath 0 0 moveto (M) false charpath pathbbox",
	"/emheight exch def pop pop pop",
	NULL,
};

void
print_message(char **mes)
{
	for(; NULL != *mes; mes++) puts(*mes);
}

int
main(int argc, char *argv[])
{
	extern void getopt(int argc, char **argv), drawnode(double canvas_height);
	extern char *parse(void);
	extern double paper_height, paper_width, margin, font_size,
		linewidth;
	extern int ps_type, ncols;
	extern char *font_family;
	double canvas_width, canvas_height;
	time_t secsnow;

	getopt(argc, argv);
	print_message(prolog);
	switch(ps_type){
	case EPS:
		canvas_width = paper_width - linewidth;
		canvas_height = paper_height - 2 * font_size - linewidth;
		printf("%%%%BoundingBox: 0 0 %f %f\n\n", paper_width, paper_height);
		puts("gsave 12 dict begin");
		printf("%f %f translate\n", .5 * linewidth, .5 * linewidth);
		break;
	case PORTRAIT:
		canvas_width = paper_width - 2 * margin;
		canvas_height = paper_height - 2 * margin;
		printf("\n%f %f translate\n", margin, margin);
		break;
	case LANDSCAPE:
		canvas_width = paper_height - 2 * margin;
		canvas_height = paper_width - 2 * margin;
		puts("-90 rotate");
		printf("\n%f %f translate\n", margin - paper_height, margin);
		break;
	}
	printf("/fontsize %f def\n", font_size);
	printf("/%s findfont fontsize scalefont setfont\n", font_family);
	printf("/ncols %d def\n", ncols); 
	printf("/cellwidth %f ncols div def\n", canvas_width);
	print_message(procs);
	printf("newpath %f %f 0 0 rect .9 setgray fill\n",
		canvas_width, canvas_height); 
	printf("%f setlinewidth 0 setgray\n", linewidth);
	printf("0 %f emheight add moveto\n", canvas_height);
	printf("(The number of disk blocks used at %s) show\n", parse());
	printf("%f %f emheight add moveto\n", canvas_width, canvas_height);
	time(&secsnow);
	printf("(%s) dup stringwidth pop neg 0 rmoveto show\n", ctime(&secsnow));
	puts("{ rectShow } loop");
	drawnode(canvas_height);
	puts("-1");
	puts((EPS == ps_type)? "end grestore" : "showpage");
	return(0);
}
