/* $Id: getopt.c,v 3.1 2005/02/19 08:29:53 mac Exp $
 *
 * getopt.c
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the authors name not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 */
#include "du2ps.h"

int orientation, ncols;
double paper_width, paper_height, margin, font_size, linewidth;
char *font_family;
int ps_type;

static char *usage[] ={
	"",
	"du2ps - filter for converting output of du to PostScript file",
	"Version 2.3",
	"This program is free software; you can redistribute it and/or",
	"modify it under the terms of the GNU General Public License",
	"as published by the Free Software Foundation; either version 2",
	"of the License, or any later version.",
	"",
	"du2ps [options] < infile > outfile",
	"OPTIONS:",
	"  -land       ... landscape",
	"  -port       ... portrait (default)",
	"  -a3         ... A3",
	"  -a4         ... A4 (default)",
	"  -b4         ... B4",
	"  -b5         ... B5",
	"  -us         ... US letter",
	"  -sa         ... sort by alphabetically",
	"  -ss         ... sort by volume (default)",
	"  -bw         ... monochrome (default)",
	"  -color      ... color mode (8 colors)",
	"  -ncolor num ... number of color",
	"  -ff name    ... font family name",
	"  -fs size    ... font size",
	"  -ms size    ... margin size",
	"  -lw size    ... line width",
	"  -ncols num  ... number of columns",
	"  -eps w h    ... output an epsfile contained in BoundingBox:0 0 w h",
	NULL,
};

void getopt(int argc, char **argv)
{
	extern void print_message(char **mes);
	extern int (*cmp)(), cmp_alph(Node **p, Node **q), cmp_size(Node **p, Node **q);
	extern unsigned dhue;

	int	i;

	ncols = NCOLS_PORTRAIT;
	paper_width = A4_WIDTH;
	paper_height = A4_HEIGHT;
	font_family = strdup(FONT_FAMILY);
	font_size = FONT_SIZE;
	margin = MARGIN;
	linewidth = LINE_WIDTH;
	cmp = cmp_size;
	ps_type = PORTRAIT;
	dhue = 0;

	/* default values */
	for(i = 1; argc > i;){
		if(!strcmp("-land", argv[i])){
			ps_type = LANDSCAPE;
			ncols = NCOLS_LANDSCAPE;
			i++;
		} else if(!strcmp("-port", argv[i])){
			ps_type = PORTRAIT;
			ncols = NCOLS_PORTRAIT;
			i++;
		} else if(!strcmp("-ss", argv[i])){
			cmp = cmp_size;
			i++;
		} else if(!strcmp("-sa", argv[i])){
			cmp = cmp_alph;
			i++;
		} else if(!strcmp("-bw", argv[i])){
			dhue = 0;
			i++;
		} else if(!strcmp("-color", argv[i])){
			dhue = 0x8000 / 8;
			i++;
		} else if(!strcmp("-ncolor", argv[i])){
			dhue = atoi(argv[i+1]);
			if (dhue < 2) {
				dhue = 0;
			} else {
				dhue = 0x8000 / dhue;
			}
			i+= 2;
		} else if(!strcmp("-a3", argv[i])){
			paper_width = A3_WIDTH;
			paper_height = A3_HEIGHT;
			i++;
		} else if(!strcmp("-a4", argv[i])){
			paper_width = A4_WIDTH;
			paper_height = A4_HEIGHT;
			i++;
		} else if(!strcmp("-b4", argv[i])){
			paper_width = B4_WIDTH;
			paper_height = B4_HEIGHT;
			i++;
		} else if(!strcmp("-b5", argv[i])){
			paper_width = B5_WIDTH;
			paper_height = B5_HEIGHT;
			i++;
		} else if(!strcmp("-us", argv[i])){
			paper_width = US_WIDTH;
			paper_height = US_HEIGHT;
			i++;
		} else if(!strcmp("-ff", argv[i])){
			font_family = strdup(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-fs", argv[i])){
			font_size = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-ms", argv[i])){
			margin = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-lw", argv[i])){
			linewidth = atof(argv[i + 1]);
			i += 2;
		} else if(!strcmp("-ncols", argv[i])){
			ncols = atoi(argv[i + 1]);
			i += 2;
			if (ncols > MAXDEPTH) {
				fprintf(stderr, "too large '-ncols'\n");
				exit (EPERM);
			}
		} else if(!strcmp("-eps", argv[i])){
			paper_width = atof(argv[i + 1]);
			paper_height = atof(argv[i + 2]);
			ps_type = EPS;
			i += 3;
		} else {
			fprintf(stderr, "unknown option %s\n", argv[i]);
			print_message(usage);
			exit(EPERM);
		}
	}
}
