﻿<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes"/>

  <xsl:template match="check">
    <html>
      <body>
        <a name="top"></a>
        <div class="app">
          <div class="h3">
            <h3>Summary</h3>
            <p>Report generated by
              <a href="http://sourceforge.net/projects/duplo">Duplo
                  v<xsl:value-of select="//duplo/@version"/> (C/C++/Java/C#/VB.Net Duplicate Source Code Block Finder)
              </a>
            </p>
            <p>
              Copyright (2005) Christian M. Ammann
              <xsl:apply-templates/><br/>
              Copyright (2006) Trevor D'Arcy-Evans
            </p>
          </div>
          <xsl:apply-templates select="." mode="summary"/>

          <h3>Configuration</h3>
          <p>
            <xsl:apply-templates select="." mode="config"/>
          </p>

          <div class="h3">
            <h3>Duplications</h3>
            <xsl:for-each select="set">
              <p>
                <xsl:apply-templates select="." mode="filelist"/>
              </p>
            </xsl:for-each>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="check" mode="config">
    <table border="1" width="100%" cellspacing="2" cellpadding="3">
      <tr>
        <td>Minimum block size (lines)</td>
        <td><xsl:value-of select="@Min_block_size"/></td>
      </tr>
      <tr>
        <td>Minimum characters per line</td>
        <td><xsl:value-of select="@Min_char_line"/></td>
      </tr>
      <tr>
        <td>Ignore preprocessor</td>
        <td><xsl:value-of select="@Ignore_prepro"/></td>
      </tr>
      <tr>
        <td>Ignore same filenames</td>
        <td><xsl:value-of select="@Ignore_same_filename"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="check" mode="summary">
    <table border="1" width="100%" cellspacing="2" cellpadding="3">
      <tr>
        <td>Time</td>
        <td><xsl:value-of select="./summary/@Time"/> seconds</td>
      </tr>
      <tr>
        <td>Similarity threshold (lines)</td>
        <td><xsl:value-of select="./@Min_block_size"/></td>
      </tr>
      <tr>
        <td>Number of files</td>
        <td><xsl:value-of select="./summary/@Num_files"/></td>
      </tr>
      <tr>
        <td>Duplicate blocks</td>
        <td><xsl:value-of select="sum(./summary/@Duplicate_blocks)"/></td>
      </tr>
      <tr>
        <td>Duplicate lines of code</td>
        <td><xsl:value-of select="./summary/@Duplicate_lines_of_code"/></td>
      </tr>
      <tr>
        <td>Total lines of code</td>
        <td><xsl:value-of select="sum(./summary/@Total_lines_of_code)"/></td>
      </tr>
      <tr>
        <td>% Duplication (lines)</td>
        <td><xsl:value-of select="format-number(sum(./summary/@Duplicate_lines_of_code) div sum(./summary/@Total_lines_of_code), '#.00%')"/></td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="set" mode="filelist">
      <xsl:for-each select="block">
          <a>
              <xsl:attribute name="href">
              <xsl:value-of select="./@SourceFile"/>
              </xsl:attribute>

              <xsl:value-of select="./@SourceFile"/> [<xsl:value-of select="./@StartLineNumber"/>]
              <xsl:apply-templates/><br/>
          </a>
      </xsl:for-each>
      <xsl:apply-templates select="." mode="linelist"/>
  </xsl:template>

  <xsl:template match="lines" mode="linelist">
      <blockquote>
      <xsl:for-each select="line">
          <pre><xsl:value-of select="./@Text"/></pre>
      </xsl:for-each>
      </blockquote>
      <xsl:apply-templates/><br/>
  </xsl:template>

</xsl:stylesheet>
