/* Copyright (C) 2006 G.P. Halkes
   Licensed under the Open Software License version 2.0 */

/* #define LEAVE_FILES */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "definitions.h"

static TempFile files[4];
static int openIndex = 0;

#ifndef LEAVE_FILES
static bool inited;

/** Remove up all the created files. */
static void cleanup(void) {
	int i;
	for (i = 0; i < openIndex; i++) {
		fclose(files[i].file);
		remove(files[i].name);
	}
}
#endif

/** Create a temporary file. */
TempFile *tempFile(void) {
#ifdef LEAVE_FILES
	/* In case we are testing and want to see the temporary files,
	   we use these names. */
	static const char *names[4] = { "oldTokens", "oldWhitespace", "newTokens", "newWhitespace" };

	strcpy(files[openIndex].name, names[openIndex]);
	if ((files[openIndex].file = fopen(files[openIndex].name, "w+")) == NULL)
		return NULL;
#else
	/* Create temporary file. */
	int fd;
	
	if (!inited) {
		/* Make sure the umask is set so that we don't introduce a security risk. */
		umask(~S_IRWXU);
		/* Make sure we will remove temporary files on exit. */
		atexit(cleanup);
		inited = true;
	}

	strcpy(files[openIndex].name, TEMPLATE);
	if ((fd = mkstemp(files[openIndex].name)) < 0)
		return NULL;
	if ((files[openIndex].file = fdopen(fd, "r+")) == NULL)
		return NULL;
#endif	
	return files + openIndex++;
}
