// All pixmaps that the editor requires
// Copyright (C) 2000 Core Technologies.

// This file is part of e93.
//
// e93 is free software; you can redistribute it and/or modify
// it under the terms of the e93 LICENSE AGREEMENT.
//
// e93 is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// e93 LICENSE AGREEMENT for more details.
//
// You should have received a copy of the e93 LICENSE AGREEMENT
// along with e93; see the file "LICENSE.TXT".


#include	"includes.h"

static char localErrorFamily[]="Xpixmapinit";

enum
{
	BADALLOCATE
};

static char *errorMembers[]=
{
	"BadAllocate"
};

static char *errorDescriptions[]=
{
	"Failed to allocate pixmap",
};

// bitmap patterns for scroll arrows

static char
	leftArrowBitmap[] =
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x38,0x00,
		0x00,0x1c,0x00,0x00,0x1f,0x00,0x80,0x0f,0x00,0xe0,0xff,0x07,
		0xf0,0xff,0x07,0xfc,0xff,0x07,0xfe,0xff,0x07,0xfc,0xff,0x07,
		0xf0,0xff,0x07,0xe0,0xff,0x07,0x80,0x0f,0x00,0x00,0x1f,0x00,
		0x00,0x1c,0x00,0x00,0x38,0x00,0x00,0x60,0x00,0x00,0x00,0x00
	};

static char
	rightArrowBitmap[] =
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0xc0,0x01,0x00,
		0x80,0x03,0x00,0x80,0x0f,0x00,0x00,0x1f,0x00,0xfe,0x7f,0x00,
		0xfe,0xff,0x00,0xfe,0xff,0x03,0xfe,0xff,0x07,0xfe,0xff,0x03,
		0xfe,0xff,0x00,0xfe,0x7f,0x00,0x00,0x1f,0x00,0x80,0x0f,0x00,
		0x80,0x03,0x00,0xc0,0x01,0x00,0x60,0x00,0x00,0x00,0x00,0x00
	};

static char
	upArrowBitmap[] =
	{
		0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
		0x00,0x1f,0x00,0x80,0x3f,0x00,0x80,0x3f,0x00,0xc0,0x7f,0x00,
		0xe0,0xff,0x00,0xe0,0xff,0x00,0xf0,0xff,0x01,0xf8,0xff,0x03,
		0xb8,0xbf,0x03,0x8c,0x3f,0x06,0x84,0x3f,0x04,0x80,0x3f,0x00,
		0x80,0x3f,0x00,0x80,0x3f,0x00,0x80,0x3f,0x00,0x00,0x00,0x00
	};

static char
	downArrowBitmap[] =
	{
		0x00,0x00,0x00,0x80,0x3f,0x00,0x80,0x3f,0x00,0x80,0x3f,0x00,
		0x80,0x3f,0x00,0x84,0x3f,0x04,0x8c,0x3f,0x06,0xb8,0xbf,0x03,
		0xf8,0xff,0x03,0xf0,0xff,0x01,0xe0,0xff,0x00,0xe0,0xff,0x00,
		0xc0,0x7f,0x00,0x80,0x3f,0x00,0x80,0x3f,0x00,0x00,0x1f,0x00,
		0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x04,0x00,0x00,0x00,0x00
	};

// bitmap patterns for check boxes

static char
	checkBoxBitmap[]=
	{
		0x00,0x00,0xfe,0x7f,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,
		0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,0x02,0x40,
		0x02,0x40,0x02,0x40,0xfe,0x7f,0x00,0x00
	};

static char
	checkedBoxBitmap[]=
	{
		0x00,0x00,0xfe,0x7f,0x06,0x60,0x0a,0x50,0x12,0x48,0x22,0x44,
		0x42,0x42,0x82,0x41,0x82,0x41,0x42,0x42,0x22,0x44,0x12,0x48,
		0x0a,0x50,0x06,0x60,0xfe,0x7f,0x00,0x00
	};

// bitmap patterns for sub menu arrow


static char
	subMenuBitmap[]=
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x30,0x00,0x00,0xf0,0x00,0x00,0xe0,0x03,0x00,
		0xc0,0x0f,0x00,0xc0,0x3f,0x00,0xc0,0xff,0x00,0xc0,0x3f,0x00,
		0xc0,0x0f,0x00,0xe0,0x03,0x00,0xf0,0x00,0x00,0x30,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	};

// bitmap patterns for document icons

static char
	documentIconBitmap[]=
	{
		0xfc,0xff,0xff,0xff,0x1f,0x00,0x04,0x00,0x00,0x00,0x30,0x00,
		0x04,0x00,0x00,0x00,0x50,0x00,0x04,0x00,0x00,0x00,0x90,0x00,
		0x04,0x00,0x00,0x00,0x10,0x01,0x04,0x00,0x00,0x00,0x10,0x02,
		0x04,0x00,0x00,0x00,0x10,0x04,0x04,0x00,0x00,0x00,0x10,0x08,
		0x04,0x00,0x00,0x00,0x10,0x10,0x04,0x00,0x00,0x00,0xf0,0x3f,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0xc0,0x07,0x7c,0x20,
		0x04,0x00,0xf0,0x0e,0xf7,0x20,0x04,0x00,0x70,0x1c,0xe1,0x20,
		0x04,0x00,0x38,0x1c,0xe0,0x21,0x04,0x00,0x38,0x1c,0xe0,0x20,
		0x04,0x00,0x38,0x1c,0xf0,0x20,0x04,0xf0,0x38,0x1c,0x3c,0x20,
		0x04,0xfc,0x39,0x1c,0x1f,0x20,0x04,0xce,0x31,0x1e,0x7f,0x20,
		0x04,0xc7,0xe0,0x0f,0xf8,0x20,0x04,0x77,0x80,0x0f,0xf0,0x20,
		0x84,0x1f,0x00,0x07,0xf0,0x20,0x84,0x07,0x80,0x07,0xe0,0x20,
		0x84,0x03,0xc0,0x43,0x70,0x20,0x84,0xc7,0xe0,0xe1,0x70,0x20,
		0x04,0x7f,0x78,0xe0,0x39,0x20,0x04,0x1e,0x0e,0xc0,0x0f,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0xfc,0xff,0xff,0xff,0xff,0x3f
	};

static char
	documentModifiedIconBitmap[]=
	{
		0xfc,0xff,0xff,0xff,0x1f,0x00,0x04,0x00,0x00,0x00,0x30,0x00,
		0x04,0x00,0x00,0x00,0x50,0x00,0x04,0x00,0x00,0x00,0x90,0x00,
		0x04,0x00,0x00,0x00,0x10,0x01,0x04,0x00,0x00,0x00,0x10,0x02,
		0x04,0x00,0x00,0x00,0x10,0x04,0x04,0x00,0x00,0x00,0x10,0x08,
		0x04,0x00,0x00,0x00,0x10,0x10,0x04,0x00,0x00,0x00,0xf0,0x3f,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0xc0,0x07,0x7c,0x20,
		0x04,0x00,0xf0,0x0e,0xf7,0x20,0x04,0x00,0x70,0x1c,0xe1,0x20,
		0x04,0x00,0x38,0x1c,0xe0,0x21,0x04,0x00,0x38,0x1c,0xe0,0x20,
		0x04,0x00,0x38,0x1c,0xf0,0x20,0x04,0xf0,0x38,0x1c,0x3c,0x20,
		0x04,0xfc,0x39,0x1c,0x1f,0x20,0x04,0xce,0x31,0x1e,0x7f,0x20,
		0x04,0xc7,0xe0,0x0f,0xf8,0x20,0x04,0x77,0x80,0x0f,0xf0,0x20,
		0x84,0x1f,0x00,0x07,0xf0,0x20,0x84,0x07,0x80,0x07,0xe0,0x20,
		0x84,0x03,0xc0,0x43,0x70,0x20,0x84,0xc7,0xe0,0xe1,0x70,0x20,
		0x04,0x7f,0x78,0xe0,0x39,0x20,0x04,0x1e,0x0e,0xc0,0x0f,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0x74,0x1C,0x60,0x62,0x01,0x23,
		0x64,0x0C,0x40,0x10,0x00,0x22,0x64,0x8C,0x71,0xBB,0x99,0x23,
		0xA4,0x4A,0x4A,0x12,0x55,0x22,0xA4,0x4A,0x4A,0x12,0x4D,0x22,
		0x24,0x49,0x4A,0x12,0x45,0x22,0x74,0x9D,0xB1,0x3A,0x99,0x25,
		0x04,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00,0x00,0x00,0x20,
		0x04,0x00,0x00,0x00,0x00,0x20,0xfc,0xff,0xff,0xff,0xff,0x3f
	};

static char
	editorIconBitmap[]=
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x07,0x7c,0x00,
		0x00,0x00,0xf0,0x0e,0xf7,0x00,0x00,0x00,0x70,0x1c,0xe1,0x00,
		0x00,0x00,0x38,0x1c,0xe0,0x01,0x00,0x00,0x38,0x1c,0xe0,0x00,
		0x00,0x00,0x38,0x1c,0xf0,0x00,0x00,0xf0,0x38,0x1c,0x3c,0x00,
		0x00,0xfc,0x39,0x1c,0x1f,0x00,0x00,0xce,0x31,0x1e,0x7f,0x00,
		0x00,0xc7,0xe0,0x0f,0xf8,0x00,0x00,0x77,0x80,0x0f,0xf0,0x00,
		0x80,0x1f,0x00,0x07,0xf0,0x00,0x80,0x07,0x80,0x07,0xe0,0x00,
		0x80,0x03,0xc0,0x43,0x70,0x00,0x80,0xc7,0xe0,0xe1,0x70,0x00,
		0x00,0x7f,0x78,0xe0,0x39,0x00,0x00,0x1e,0x0e,0xc0,0x0f,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	};


bool InitPixmaps()
// make bits into pixmaps for easy drawing later on
// if there is a problem, SetError, return false
{
	if((leftArrowPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&leftArrowBitmap[0],SCROLLICONWIDTH,SCROLLICONHEIGHT))!=None)
	{
		if((rightArrowPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&rightArrowBitmap[0],SCROLLICONWIDTH,SCROLLICONHEIGHT))!=None)
		{
			if((upArrowPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&upArrowBitmap[0],SCROLLICONWIDTH,SCROLLICONHEIGHT))!=None)
			{
				if((downArrowPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&downArrowBitmap[0],SCROLLICONWIDTH,SCROLLICONHEIGHT))!=None)
				{
					if((checkBoxPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&checkBoxBitmap[0],CHECKBOXWIDTH,CHECKBOXHEIGHT))!=None)
					{
						if((checkedBoxPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&checkedBoxBitmap[0],CHECKBOXWIDTH,CHECKBOXHEIGHT))!=None)
						{
							if((subMenuPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&subMenuBitmap[0],SUBMENUARROWWIDTH,SUBMENUARROWHEIGHT))!=None)
							{
								if((documentIconPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&documentIconBitmap[0],ICONWIDTH,ICONHEIGHT))!=None)
								{
									if((documentModifiedIconPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&documentModifiedIconBitmap[0],ICONWIDTH,ICONHEIGHT))!=None)
									{
										if((editorIconPixmap=XCreateBitmapFromData(xDisplay,RootWindow(xDisplay,xScreenNum),&editorIconBitmap[0],ICONWIDTH,ICONHEIGHT))!=None)
										{
											return(true);
										}
										XFreePixmap(xDisplay,documentModifiedIconPixmap);
									}
									XFreePixmap(xDisplay,documentIconPixmap);
								}
								XFreePixmap(xDisplay,subMenuPixmap);
							}
							XFreePixmap(xDisplay,checkedBoxPixmap);
						}
						XFreePixmap(xDisplay,checkBoxPixmap);
					}
					XFreePixmap(xDisplay,downArrowPixmap);
				}
				XFreePixmap(xDisplay,upArrowPixmap);
			}
			XFreePixmap(xDisplay,rightArrowPixmap);
		}
		XFreePixmap(xDisplay,leftArrowPixmap);
	}
	SetError(localErrorFamily,errorMembers[BADALLOCATE],errorDescriptions[BADALLOCATE]);
	return(false);
}

void UnInitPixmaps()
// get rid of all pixmaps created by InitPixmaps
{
	XFreePixmap(xDisplay,editorIconPixmap);
	XFreePixmap(xDisplay,documentModifiedIconPixmap);
	XFreePixmap(xDisplay,documentIconPixmap);
	XFreePixmap(xDisplay,subMenuPixmap);
	XFreePixmap(xDisplay,checkedBoxPixmap);
	XFreePixmap(xDisplay,checkBoxPixmap);
	XFreePixmap(xDisplay,downArrowPixmap);
	XFreePixmap(xDisplay,upArrowPixmap);
	XFreePixmap(xDisplay,rightArrowPixmap);
	XFreePixmap(xDisplay,leftArrowPixmap);
}
