#ifndef HTMLTIDY_PLATFORM_H
#define HTMLTIDY_PLATFORM_H

/* platform.h

  (c) 1998-2000 (W3C) MIT, INRIA, Keio University
  (c) 2001 eGenix.com Software GmbH, Langenfeld
  See tidy.c for the copyright notice.
*/

/*
  Uncomment and edit this #define if you want
  to specify the config file at compile-time

#define CONFIG_FILE "/etc/tidy_config.txt"
*/

/*
  Uncomment this if you are on a Unix system supporting
  the call getpwnam() and the HOME environment variable.
  It enables tidy to find config files named ~/.tidyrc
  and ~your/.tidyrc etc if the HTML_TIDY environment
  variable is not set. Contributed by Todd Lewis.

#define SUPPORT_GETPWNAM
*/

#include <ctype.h>
#include <stdio.h>
#include <setjmp.h>  /* for longjmp on error exit */
#include <stdlib.h>
#include <stdarg.h>  /* may need <varargs.h> for Unix V */
#include <string.h>
#include <assert.h>

#ifdef SUPPORT_GETPWNAM
#include <pwd.h>
#endif

#ifdef NEEDS_UNISTD_H
#include <unistd.h>  /* needed for unlink on some Unix systems */
#endif

/*
 Tidy preserves the last modified time for the files it
 cleans up. If your platform doesn't support <sys/utime.h>
 and the futime function, then set PRESERVEFILETIMES to 0
*/
#define PRESERVEFILETIMES 0

#if PRESERVEFILETIMES
#include <sys/types.h> 
#include <sys/stat.h>
#include <sys/utime.h>

/*
   MS Windows needs _ prefix for Unix file functions
   Tidy uses for preserving the lasted modified time
*/
#ifdef _WIN32
#define futime _futime
#define fstat _fstat
#define utimbuf _utimbuf
#define stat _stat
#endif /* _WIN32 */
#endif /* PRESERVEFILETIMES */

/* APIs which are supposed to be published in the shared lib, must be
   marked for export. The DL_EXPORT(type) macro marks an API for
   DLL-export. Note that this is only needed when compiling the lib
   itself (the symbol COMPILING_TIDY must be defined in this case). */
#undef DL_EXPORT
#ifdef COMPILING_TIDY
# if (defined(_MSC_VER) && _MSC_VER > 850 || defined(__MINGW32__) || defined(__BEOS__))
#  ifdef __cplusplus
#    define DL_EXPORT(RTYPE) extern "C" RTYPE __declspec(dllexport) 
#  else
#    define DL_EXPORT(RTYPE) extern RTYPE __declspec(dllexport) 
#  endif
# elif defined(__WATCOMC__)
#    define DL_EXPORT(RTYPE) extern RTYPE __export 
# elif defined(__IBMC__)
#    define DL_EXPORT(RTYPE) extern RTYPE _Export 
# else
#    define DL_EXPORT(RTYPE) extern RTYPE 
# endif
#else
# define DL_EXPORT(RTYPE) extern RTYPE 
#endif

/*
  bool is a reserved word in some but
  not all C++ compilers depending on age
  work around is to avoid bool altogether
  by introducing a new enum called Bool
*/
typedef enum
{
   no,
   yes
} Bool;

/* for null pointers */
#define null 0

/*
  Win32 defines _unlink as per Unix unlink function; dito for snprintf
  and vsnprintf.
*/

#ifdef _WIN32
#define unlink _unlink
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#endif


/* EOF */
#endif

