""" mxNumber - Arbitrary precision numbers provided by GNU MP (GMP).

    Copyright (c) 2001-2002, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further information on copyrights,
    or contact the author. All Rights Reserved.

"""
from Number import *
from Number import __version__

### Lazy import submodules
#from mx.Misc import LazyModule

#ISO = LazyModule.LazyModule('ISO',locals(),globals())

#del LazyModule

### Make the types pickleable:

# Shortcuts for pickle (reduces the pickle's length)
def _F(value, precision,
       Float=Float):
    return Float(value, precision)

def _R(num, den,
       Rational=Rational):
    return Rational(num, den)

def _I(value,
       Integer=Integer):
    return Integer(value)

# Module init
class modinit:

    ### Register the two types
    import copy_reg

    # XXX Pickling floats is not safe yet -- the string format doesn't
    #     carry enough information to guarantee the f = loads(dumps(f))
    def pickle_Float(obj,
                     str=str):
        return _F,(str(obj), obj.precision)

    def pickle_Rational(obj,
                        str=str):
        return _R,(str(obj.numerator), str(obj.denominator))

    def pickle_Integer(obj,
                       str=str):
        return _I,(str(obj),)

    copy_reg.pickle(FloatType, pickle_Float, _F)
    copy_reg.pickle(RationalType, pickle_Rational, _R)
    copy_reg.pickle(IntegerType, pickle_Integer, _I)

del modinit
