#ifndef MXNUMBER_H
#define MXNUMBER_H
/* 
  mxNumber - Arbitrary precision numbers provided by the GNU MP library.

  Copyright (c) 2001-2002, eGenix.com Software GmbH; mailto:info@egenix.com
  See the documentation for further copyright information or contact
  the author (mailto:mal@lemburg.com).
  
*/

/* The extension's name; must be the same as the init function's suffix */
#define MXNUMBER_MODULE "mxNumber"

/* Name of the package or module that provides the extensions C API.
   If the extension is used inside a package, provide the complete
   import path. */
#define MXNUMBER_API_MODULE "mx.Number"

/* --- No servicable parts below this line ----------------------*/

/* Include generic mx extension header file */
#include "mxh.h"

#ifdef MX_BUILDING_MXNUMBER
# define MXNUMBER_EXTERNALIZE MX_EXPORT
#else
# define MXNUMBER_EXTERNALIZE MX_IMPORT
#endif

/* Include the GNU MP header file */
#include "gmp.h"

#ifdef __cplusplus
extern "C" {
#endif

/* --- mxInteger Object ------------------------------------------*/

/* Note: even though GNU MP numbers are mutable, we don't make use
   of this feature after initial creation. */

typedef struct {
    PyObject_HEAD
    
    /* Value */
    mpz_t value;

    /* Cached hash value */
    long hash;

} mxIntegerObject;

/* Type checking macro */

#define mxInteger_Check(v) \
        (((mxIntegerObject *)(v))->ob_type == mxNumber.Integer_Type)

/* --- mxRational Object ------------------------------------------*/

/* Note: even though GNU MP numbers are mutable, we don't make use
   of this feature after initial creation. */

typedef struct {
    PyObject_HEAD
    
    /* Value */
    mpq_t value;

    /* Cached hash value */
    long hash;

} mxRationalObject;

/* Type checking macro */

#define mxRational_Check(v) \
        (((mxRationalObject *)(v))->ob_type == mxNumber.Rational_Type)

/* --- mxFloat Object ------------------------------------------*/

/* Note: even though GNU MP numbers are mutable, we don't make use
   of this feature after initial creation. */

typedef struct {
    PyObject_HEAD
    
    /* Value */
    mpf_t value;

    /* Cached hash value */
    long hash;

} mxFloatObject;

/* Type checking macro */

#define mxFloat_Check(v) \
        (((mxFloatObject *)(v))->ob_type == mxNumber.Float_Type)

/* --- C API ----------------------------------------------------*/

/* C API for usage by other Python modules */
typedef struct {
	 
    /* Integer type object */
    PyTypeObject *Integer_Type;

    /* Rational type object */
    PyTypeObject *Rational_Type;

    /* Float type object */
    PyTypeObject *Float_Type;

} mxNumberModule_APIObject;

#ifndef MX_BUILDING_MXNUMBER

/* --- C API ----------------------------------------------------*/

/* Interfacestructure to C API for other modules.
   Call mxNumber_ImportModuleAPI() to initialize this
   structure. After that usage is simple:

   PyObject *v;
	
   v = mxNumber.Integer_FromString("1234");
   if (!v)
       goto onError;
   ...

*/



static 
mxNumberModule_APIObject mxNumber;

/* You *must* call this before using any of the functions in
   mxNumber and check its outcome; otherwise all accesses will
   result in a segfault. Returns 0 on success. */

#ifndef DPRINTF
# define DPRINTF if (0) printf
#endif

static
int mxNumber_ImportModuleAndAPI(void)
{
    PyObject *mod = 0, *v = 0;
    char *apimodule = MXNUMBER_API_MODULE;
    char *apiname = MXNUMBER_MODULE"API";
    void *api;
    
    DPRINTF("Importing the %s C API...\n",apimodule);
    mod = PyImport_ImportModule(apimodule);
    if (mod == NULL)
	goto onError;
    DPRINTF(" %s package found\n",apimodule);
    v = PyObject_GetAttrString(mod,apiname);
    if (v == NULL)
	goto onError;
    Py_DECREF(mod);
    DPRINTF(" API object %s found\n",apiname);
    api = PyCObject_AsVoidPtr(v);
    if (api == NULL)
	goto onError;
    Py_DECREF(v);
    memcpy(&mxNumber,api,sizeof(mxNumber));
    DPRINTF(" API object loaded and initialized.\n");
    return 0;
    
 onError:
    DPRINTF(" not found.\n");
    Py_XDECREF(mod);
    Py_XDECREF(v);
    return -1;
}

#endif

/* EOF */
#ifdef __cplusplus
}
#endif
#endif
