#!/usr/local/bin/python2.0

""" Configuration for the eGenix mx EXPERIMENTAL distribution.

    Copyright (c) 1997-2000, Marc-Andre Lemburg; mailto:mal@lemburg.com
    Copyright (c) 2000-2003, eGenix.com Software GmbH; mailto:info@egenix.com
    See the documentation for further information on copyrights,
    or contact the author. All Rights Reserved.
"""
from mxSetup import mx_Extension
import sys, glob, os

#
# Package version
#
version = '0.9.0'

#
# Setup information
#
name = "egenix-mx-experimental"

#
# Meta-Data
#
description = "eGenix mx-Extensions - EXPERIMENTAL package"
long_description = """\
The eGenix mx Extension Series are a collection of
Python extensions written in ANSI C and Python
which provide a large spectrum of useful additions
to everyday Python programming.

This package includes experimental subpackages of the 
series. Please understand that the software in these 
packages is still in alpha state and does not meet the 
quality standards of production quality software.

This software is brought to you by eGenix.com. The included
subpackages are either covered by the eGenix.com Public
License or the eGenix.com Commercial License and/or other
licenses. Please check the  subpackage documentation for
details or contact eGenix.com for more license information.
"""
license = (
"Copyright (c) 2000-2003, eGenix.com Software GmbH, All Rights Reserved"
)
author = "Marc-Andre Lemburg"
author_email = "mal@egenix.com"
url = "http://www.egenix.com/files/python/eGenix-mx-Extensions.html"

#
# Python packages
#
packages = [
    
    'mx',

    # mxNumber
    'mx.Number',
    'mx.Number.mxNumber',

    # mxTidy
    'mx.Tidy',
    'mx.Tidy.mxTidy',
    
    # mxURL
    'mx.URL',
    'mx.URL.mxURL',
    
    # mxUID
    'mx.UID',
    'mx.UID.mxUID',
    
    ]

#
# C libraries
#

libraries = [

    # libtidy.a needed by mxTidy
    ('libtidy',
     {'sources':
      glob.glob(os.path.join('mx','Tidy','mxTidy','libtidy','*.c')),
      'include_dirs':
      [os.path.join('mx','Tidy','mxTidy','libtidy')],
      'macros':
      [('COMPILING_TIDY', 1)],
      }),

    ]

#
# C Extensions
#
ext_modules = [

    # mxTidy
    mx_Extension('mx.Tidy.mxTidy.mxTidy',
                 ['mx/Tidy/mxTidy/mxTidy.c'],
                 include_dirs=['mx/Tidy/mxTidy',
                               'mx/Tidy/mxTidy/libtidy'],
                 libraries=['libtidy'],
                 library_dirs=['mx/Tidy/mxTidy/libtidy']),

    # mxURL
    mx_Extension('mx.URL.mxURL.mxURL',
                 ['mx/URL/mxURL/mxURL.c'],
                 include_dirs=['mx/URL/mxURL']),

    # mxUID
    mx_Extension('mx.UID.mxUID.mxUID',
                 ['mx/UID/mxUID/mxUID.c'],
                 include_dirs=['mx/UID/mxUID']),

    ]

# mxNumber
if sys.version[:3] >= '2.1':
    if sys.platform[:3] == 'win':
        ext_modules[len(ext_modules):] = [

            mx_Extension('mx.Number.mxNumber.mxNumber',
                         ['mx/Number/mxNumber/mxNumber.c'],
                         include_dirs=['mx/Number/mxNumber',
                                       'mx/Number/mxNumber/win32'],
                         libraries=['gmp31'],
                         library_dirs=['mx/Number/mxNumber/win32']),
            ]
    else:
        ext_modules[len(ext_modules):] = [

            mx_Extension('mx.Number.mxNumber.mxNumber',
                         ['mx/Number/mxNumber/mxNumber.c'],
                         include_dirs=['mx/Number/mxNumber'],
                         libraries=['gmp'],
                         optional_libraries=[('mpfr', ['gmp.h', 'mpfr.h']),
                                             ]),

            ]
else:
    print '*** WARNING: mxNumber needs Python 2.1 or later.',
    print '    mxNumber will not be built !'

#
# Data files
#
data_files = [

    # mxNumber
    'mx/Number/Doc/mxNumber.html',
    'mx/Number/Doc/mxLicense.html',
    'mx/Number/COPYRIGHT',
    'mx/Number/LICENSE',
    'mx/Number/README',
    'mx/Number/mxNumber/mxNumber.h',
    'mx/Number/mxNumber/mxh.h',
    'mx/Number/mxNumber/gmp.h',

    # mxTidy
    'mx/Tidy/Doc/mxTidy.html',
    'mx/Tidy/Doc/mxLicense.html',
    'mx/Tidy/Doc/Overview.html',
    'mx/Tidy/Doc/pending.html',
    'mx/Tidy/Doc/release-notes.html',
    'mx/Tidy/Doc/tidy.gif',
    'mx/Tidy/COPYRIGHT',
    'mx/Tidy/LICENSE',
    'mx/Tidy/README',
    'mx/Tidy/mxTidy/mxTidy.h',
    'mx/Tidy/mxTidy/mxh.h',
    'mx/Tidy/mxTidy/input.html',

    # mxURL
    'mx/URL/Doc/mxURL.html',
    'mx/URL/Doc/mxLicense.html',
    'mx/URL/COPYRIGHT',
    'mx/URL/LICENSE',
    'mx/URL/README',
    'mx/URL/mxURL/mxURL.h',
    'mx/URL/mxURL/mxh.h',

    # mxUID
    'mx/UID/Doc/mxUID.html',
    'mx/UID/Doc/mxLicense.html',
    'mx/UID/COPYRIGHT',
    'mx/UID/LICENSE',
    'mx/UID/README',
    'mx/UID/mxUID/mxUID.h',
    'mx/UID/mxUID/mxh.h',

    ]

if sys.platform[:3] == 'win':
    data_files[len(data_files):] = [

        # mxNumber
        'mx/Number/mxNumber/gmp31.dll',

        ]
    
