/*
   File: backend.c
   Finishes the compilation by assembling and linking the code

   CVS ID: "$Id: backend.c,v 1.6 2005/03/19 14:50:10 marcs Exp $"
*/

/* include <config.h> if autoconfigured */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* global includes */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif /* HAVE_SYS_WAIT_H */
#include <errno.h>
#ifdef WIN32
#include <windows.h>
#endif /* WIN32 */

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_string.h>

/* local includes */
#include "options.h"

/* Dit moet nog via configure uitgezocht worden */
#if defined(sun)
#if !defined(__SVR4) && !defined(__svr4__)
import char *sys_errlist[];
#define strerror(errnum) sys_errlist[errnum]
#endif /* !defined(__SVR4) && !defined(__svr4__) */
#endif /* defined(sun) */

#ifdef WIN32
static char* flatten (char *argv [])
	{ char **ptr, *result;
	  int length = 0;
	  for (ptr = argv; (*ptr) != NULL; ptr++)
	     { if (ptr == argv)
		  result = dcg_malloc (length + (strlen (*ptr) + 2) * sizeof (char));
	       else dcg_realloc (&result, length + (strlen (*ptr) + 2) * sizeof (char));
	       strcpy (result + length, *ptr);
	       length += (strlen (*ptr) + 1);
	       result [length - 1] = ' ';
	       result [length] = '\0';
	     };
	  dcg_realloc (&result, length * sizeof (char));
	  result [length - 1] = '\0';
	  return (result);
	}
#endif /* WIN32 */

static int spawn_and_wait (char *argv[])
#ifdef WIN32
	{ STARTUPINFO si;
	  PROCESS_INFORMATION pi;
	  char *cmdline;
#else
	{ pid_t pid;
	  int status;
#endif /* WIN32 */

	  /* when full verbose, dump command to spawn */
	  if (full_verbose)
	     { char **ptr;
	       eprint ("     ");
	       for (ptr = argv; (*ptr) != NULL; ptr++)
		  { eprint (" ");
		    eprint (*ptr);
		  };
	       eprint ("\n");
	     };

#ifdef WIN32
	  memset ((void *) &si, 0, sizeof (si));
	  si.cb = sizeof (si);
	  memset ((void *) &pi, 0, sizeof (pi));
	  cmdline = flatten (argv); 
	  if (!CreateProcess (NULL, cmdline, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi))
	     panic ("could not create process: error %d", GetLastError ());
	  else
	     { /* Parent code */
	       DWORD result = WaitForSingleObject (pi.hProcess, INFINITE);
	       CloseHandle (pi.hProcess);
	       CloseHandle (pi.hThread);
	       if (result == WAIT_OBJECT_0) return (0);
	       return (1);
	     }
#else
	  /* Fork off process */
	  pid = fork ();
	  if (pid < 0)
	     { /* could not fork, bad if so */
	       panic ("could not fork: %s", strerror (errno));
	     }
	  else if (pid == 0)
	     { /* child code */
	       execvp (argv[0], argv);

	       /* if we reach this point, we could not exec */
	       panic ("could not exec %s: %s", argv[0], strerror (errno));
	     };

	  /* parent code: wait for child to finish */
	  waitpid (pid, &status, 0);
	  return (status);
#endif /* WIN32 */
	};

/* TMPDIR is the usual environment variable to consult */ 
#ifndef TMPDIR
#define TMPDIR "TMPDIR"
#endif

/* Define the usual default temporary directory */
#ifndef DEFAULT_TMP_DIR
#define DEFAULT_TMP_DIR "/tmp"
#endif

static void do_assemble ()
	{ char buf[MAXPATHLEN + 1];
	  char *ass_argv[12];
	  int status;
	  int ix = 0;

	  /* Define the name of the object file */
	  if (!generate_object)
	     { /* We do not want to leave the object code in place */
	       string temp_dir = getenv (TMPDIR);
	       if (temp_dir == NULL) temp_dir = DEFAULT_TMP_DIR;
	       sprintf (buf, "%s/elan_%d.o", temp_dir, (int) getpid ());
	     }
	  else if (target_fname != NULL)	/* -o name given */
	     strcpy (buf, target_fname);
	  else sprintf (buf, "%s.o", basename);
	  object_fname = new_string (buf);

	  /* Fill in the argument vector to assemble */
	  warning ("   assembling machine code...");
	  ass_argv[ix++] = "gcc";
	  ass_argv[ix++] = "-c";
	  ass_argv[ix++] = assembler_fname;
	  ass_argv[ix++] = "-o";
	  ass_argv[ix++] = object_fname;
	  ass_argv[ix] = NULL;
	  status = spawn_and_wait (ass_argv);

	  /* Delete the generated assembler file */
	  if (unlink (assembler_fname))
	     panic ("could not delete '%s'", assembler_fname);
	  if (status) exit (4);
	};

static void do_link ()
	{ char buf[MAXPATHLEN + 1];
	  char **ld_argv;
	  char *exe_name;
	  int nr_args = library_search_path -> size + link_library_names -> size + 10;
	  int status;
	  int ix = 0;
	  int iy;
	  ld_argv = (char **) dcg_calloc (nr_args, sizeof (char *));

	  /* Define the name of the executable */
	  if (target_fname != NULL)		/* -o name given */
	     exe_name = target_fname;
	  else exe_name = basename;

	  /* Fill in the argument vector to link */
	  warning ("   linking object code...");
	  ld_argv[ix++] = "gcc";
	  ld_argv[ix++] = "-o";
	  ld_argv[ix++] = exe_name;
	  ld_argv[ix++] = object_fname;
	  for (iy = 0; iy < library_search_path -> size; iy++)
	     { sprintf (buf, "-L%s", library_search_path -> array[iy]);
	       ld_argv[ix++] = new_string (buf);
	     };
	  for (iy = 0; iy < link_library_names -> size; iy++)
	     { sprintf (buf, "-l%s", link_library_names -> array[iy]);
	       ld_argv[ix++] = new_string (buf);
	     };
	  ld_argv[ix++] = "-lerts";
#ifdef CURSES_LIB 
	  ld_argv[ix++] = CURSES_LIB;
#endif
#ifdef THREAD_LIB
	  ld_argv[ix++] = THREAD_LIB;
#endif
	  ld_argv[ix++] = "-lm";
	  ld_argv[ix] = NULL;
	  status = spawn_and_wait (ld_argv);

	  /* Delete the generated object file */
	  if (unlink (object_fname))
	     panic ("could not delete '%s'", object_fname);
	  if (status) exit (4);
	};

void assemble_and_link ()
	{ /* If we only have to generate assembler, we are done */
	  if (generate_assembler) return;
	  do_assemble ();
	  if (generate_object) return;
	  do_link ();
	};
