/* /usr/local/modulef/ascii/exp/s/ft3d/hsvrbw.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int hsvrbw_(real *hh, real *s, real *v, real *r, real *b, 
	real *w)
{
    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal a, c, f, h, t;

/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++F3UT+ 
*/
/*  BUT :  CONVERTI UNE COULEUR DECRITE EN HSV EN RBW */
/*  RBW : Posede 3 axes: (Red,green) (Blue,yellow) (White,black) */
/*        Les coordonnees sur ces 3 axes varient entre -1. et 1. */
/*        0, 0, 0  --> grey */
/*        1, 0, 0  --> red */
/*        0, 1, 0  --> blue */
/*        0, 0, 1  --> white */
/*       -1, 0, 0  --> green */
/*        0,-1, 0  --> yellow */
/*        0, 0,-1  --> black */
/*        1, 1, 0  --> magenta */
/*        1,-1, 0  --> orange */
/*       -1,-1, 0  --> chartreuse */
/*       -1, 1, 0  --> cyan */
/*        X, Y, 1  --> color_light */
/*        X, Y,-1  --> color_dark */
/*  Voir:  Computer&Graphics 1993  Vol17 No5 pages 597-602 */
/*                THE RBW COLOR MODEL */
/*                  Ken W. SHIRRIFF */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
    if (*v * (2.f - *s) > 1.f) {
	a = 1.5f - *v + *v * *s;
	*w = 1.f;
    } else {
	a = *v + .5f;
	*w = -1.f;
    }
    t = sqrt(a * a - *v * 2.f * *s);
    c = a - t;
    *w *= 2.f - a - t;
    if (c == 0.) {
	*r = 0.f;
	*b = 0.f;
    } else {
	h = *hh * 6.f;
	if (h <= 1.) {
	    f = h * 2.f - 1.f;
	    *r = c;
	    *b = -c;
	} else if (h <= 2.) {
	    f = 3.f - h * 2.f;
	    *r = -c;
	    *b = -c;
	} else if (h <= 4.) {
	    f = h - 3.f;
	    *r = -c;
	    *b = c;
	} else if (h <= 6.) {
	    f = 5.f - h;
	    *r = c;
	    *b = c;
	}
	if (f >= 0.) {
	    *r = (1.f - f) * *r;
	} else {
	    *b = (f + 1.f) * *b;
	}
    }
    return 0;
} /* hsvrbw_ */

