#include <stdio.h>   
#include <string.h>   
#include <math.h>  
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "underscore.h"
#include "key_board.h"

#define min(A, B) ((A) < (B) ? (A) : (B))
#define max(A, B) ((A) > (B) ? (A) : (B))
   
#define MAXSHORT 0xFFFF

#define X_POS 20
#define Y_POS 20

#define BLACK_to_RGB 1
#define CMY_to_WHITE 2

#define STRINGTITLE "Fortran 3D Modulef"
#ifdef __alpha
typedef long integer;
typedef double real;
#else
typedef int integer;
typedef float real;
#endif

GC gc; Window window;

XColor colorcell_defs[4096];
float red[4096], green[4096], blue[4096];
unsigned long foreground, background;

XPoint points[1000];
int npoints;
int shiftlock=0,shift=0,control=0,alt=0; /* etat de touche modifieur X11*/
 
Display *dpy;
Colormap color_map,color_map_sys;
Visual *visual;
 
int nbpolices;
char **listfonts;   /* pointe sur une liste de noms de fonts */
Font font_id;
         
/* pour modifier la fenetre on sauve le fenetre initiale */
    XWindowChanges values;   
    char *windowid; /* chaine de la variable system WINDOWID definie pour un xterm */
    Window init_window;
    Window root_init;
    int x_init, y_init;
    unsigned int width_init, height_init;
    unsigned int border_width_init;
    unsigned int depth_init;


call(x11opendisplay) (string)
char *string;
{
  int ii = 0;

  while (string[ii++] != ' ') ;
  string[ii-1]='\0';
  dpy=0;
  if ( (dpy = XOpenDisplay(string)) == NULL)
  {
    printf("Perif-x11: Couldn't open display ! \n");
    printf("   XOpenDisplay (\"%s\") \n",   string); 
    exit (1);
  }
}


call(x11ecran)(xmm, ymm, xp, yp)
integer *xmm,*ymm,*xp,*yp; 
{
    *ymm = XDisplayHeightMM(dpy,DefaultScreen(dpy));
    *xmm = XDisplayWidthMM (dpy,DefaultScreen(dpy));
    *yp  = XDisplayHeight  (dpy,DefaultScreen(dpy));
    *xp  = XDisplayWidth   (dpy,DefaultScreen(dpy));
}

call(x11fen)(xpx,ypx,dxpx,dypx,border,border_h)
integer *xpx,*ypx,*dxpx,*dypx,*border,*border_h; 
{   XWindowAttributes    win_attributes;
    int rx,ry;
    Window dummywin;
    
    windowid=0;
    windowid=getenv("WINDOWID");
    
    if(windowid) {
      printf(" WINDOWID= \"%s\"\n",windowid);
      init_window = atoi(windowid);
      if( XGetGeometry(dpy, init_window, &root_init, &x_init, &y_init
         ,&width_init, &height_init, &border_width_init, &depth_init))
        {
	  *xpx = x_init;
	  *ypx = y_init;
	  *dxpx  = width_init;
	  *dypx  = height_init;
	  *border = border_width_init;
	  *border_h=0;
	  
	  XGetWindowAttributes(dpy,init_window,&win_attributes);
	  rx=win_attributes.x;
	  ry=win_attributes.y;
	  (void) XTranslateCoordinates(dpy,init_window,win_attributes.root,0,0
				       ,&rx,&ry,&dummywin);
	  /*      printf(" Absolute upper-left X:  %d \n",rx);
		  printf(" Absolute upper-left Y:  %d \n",ry);
		  printf(" xpx=:  %d \n", *xpx);
		  printf(" ypx=:  %d \n", *ypx);
		  printf(" border=:  %d \n", *border);
					   */
	  if( ( *xpx + *border) != rx) {  
	    /* cas de MOTIF   */
	    *border=10; *border_h= *border * 2 + 2;
	    *xpx= rx ; *ypx= ry ;
	    x_init=rx;  y_init=ry;
	  }}
      else 
	{ 
	  printf(" WE COULD NOT CHANGE THE WINDOW SIZE (PB WINDOWID) \n");
	  *xpx=0; *ypx=0; *dxpx=0; *dypx=0; *border=8; *border_h=20;
	}}
    else
      { 
	printf(" WE COULD NOT CHANGE THE WINDOW SIZE\n");
	*xpx=0; *ypx=0; *dxpx=0; *dypx=0; *border=8; *border_h=20;
      }
}
    
call(x11device)(choix,x_pad,y_pad,dx_pad,dy_pad,x_aff,y_aff,dx_aff,dy_aff
		    ,border,nbcolo,nbplans,fcolor,fstereo,
		sizefonts,namefont,nbchar,nbfonts,maxfonts,choixtab)
integer  *choix;                               /* in  */
integer *x_pad,*y_pad,*dx_pad,*dy_pad,*x_aff,*y_aff,*dx_aff,*dy_aff;  /* in */
integer *border;                              /* in  */
integer *nbcolo;                              /* out */
integer *nbplans;                             /* out */
integer *fcolor;                              /* out   0=gray  1=couleur */
integer *fstereo;                             /* out   0=non  1=oui */
integer *sizefonts, *nbchar, *nbfonts;        /* out */
integer *maxfonts;                            /* in  */
char namefont[][255];                     /* out */
integer* choixtab;                            /* in */
{
    int x, y, i, k=0, whitepixel,blackpixel;
    char* j;
    char *title=STRINGTITLE;
    unsigned char utitle[80];
 
    unsigned int width, height, border_width;
      
    Font font;

    XEvent event;

    XSetWindowAttributes attributes;
    XSizeHints hints;
    XGCValues gcvalues;
    char **MyXListFonts() ;
    
    for(i=0; title[i]!='\0'; i++) utitle[i]=title[i];

/* tentative de changement de la taille de la fenetre initiale  */
    if(windowid) {
      values.x= *x_pad;
      values.y= *y_pad;
      values.width= *dx_pad;
      values.height= *dy_pad;
      XConfigureWindow(dpy,init_window,
         CWX | CWY | CWWidth | CWHeight, &values);
/*      (void) XGetSizeHints(dpy,init_window, &hints, PPosition | PSize);
/*      hints.x= *x_pad;
/*      hints.y= *y_pad;
/*      hints.width= *dx_pad;
/*      hints.height= *dy_pad;
/*      hints.flags= PPosition | PSize;
/*      XSetNormalHints(dpy,init_window, &hints);
*/
      }

    x = *x_aff;   /* position de la fenetre graphique  */
    y = *y_aff;
    width        = (unsigned int) *dx_aff;     /*  taille de la fenetre graphique  */
    height       = (unsigned int) *dy_aff;
    border_width = (unsigned int) *border;

    visual = DefaultVisual(dpy, DefaultScreen(dpy));
    *fcolor=0;  /* pas couleur */
    *fstereo=0; /* non */
    *nbplans=visual->bits_per_rgb;
    color_map_sys = DefaultColormap (dpy, DefaultScreen (dpy)); 
    
    retry:
    switch (visual->class)
    {
      case GrayScale  : { printf("GrayScale : \n");
                          if( *choixtab==0) /* table couleur f3d  NON MODIFIABLE */
                              k=2; 
                          else  /* table couleur systeme + f3d  NON MODIFIABLE */
                              k=16; 
                          color_map = XCreateColormap (dpy, RootWindow (dpy, DefaultScreen (dpy)),
                                                       visual,AllocAll);
                          *nbcolo = min (*nbcolo, visual->map_entries);
                          call(x11readcolormap)(red, green, blue, color_map_sys, *nbcolo); 
                          call(x11makegreys)(&red[k], &green[k], &blue[k], *nbcolo - k
                                                 , &whitepixel, &blackpixel);
                          for(i=0; i<k; i++)
                             blue[i] = green[i] = red[i] = 0.3*red[i] + 0.59*green[i] + 0.11*blue[i];
                          call(x11writecolormap)(red, green, blue, color_map, *nbcolo);
                          foreground = (unsigned long) (0.3*red[0] + 0.59*green[0] + 0.11*blue[0])<0.5
                                                        ?(whitepixel+k):(blackpixel+k);
                          background = (unsigned long) 0;
                          break;
                        }
      case PseudoColor: { printf("PseudoColor : \n");
                          if( *choixtab==0){ /* table couleur f3d  MODIFIABLE */
                             color_map = XCreateColormap (dpy, RootWindow (dpy, DefaultScreen (dpy)),
                                                       visual,AllocAll);
                             *nbcolo = min (*nbcolo, visual->map_entries);
                             *fstereo=(visual->map_entries >= 256);
                             k=0; 
                             call(x11makecolors)(red, green, blue, *nbcolo,
                                      &whitepixel, &blackpixel);
                            }
                          else{  /* table couleur systeme + f3d   NON MODIFIABLE */
                             color_map = XCreateColormap (dpy, RootWindow (dpy, DefaultScreen (dpy)),
                                                       visual,AllocAll);
                             *nbcolo = min (*nbcolo, visual->map_entries);
                             call(x11readcolormap)(red, green, blue, color_map_sys, *nbcolo);
                             k=16; 
                             call(x11makecolors)(&red[k], &green[k], &blue[k], *nbcolo - k
                                           , &whitepixel, &blackpixel);
                            }
                          call(x11writecolormap)(red, green, blue, color_map, *nbcolo);
                          foreground = (unsigned long) (0.3*red[0] + 0.59*green[0] + 0.11*blue[0])<0.5?(whitepixel+k):(blackpixel+k);
                          background = (unsigned long) 0;
                          *fcolor=1;
                          break;
                        }
      case DirectColor: { printf("DirectColor : not yet implemented in F3D\n");
                         printf("Essai de convertion en PseudoColor...\n");
                         visual->class=PseudoColor;
                         foreground = WhitePixel (dpy, DefaultScreen (dpy) );
                         background = BlackPixel (dpy, DefaultScreen (dpy) );
                         *fcolor=1;
                         goto retry;
                        }
      case StaticGray : {printf("StaticGray \n");
                          k=0;
                          color_map = DefaultColormap (dpy, DefaultScreen (dpy));
                          *nbcolo = min (*nbcolo, visual->map_entries);
                          call(x11readcolormap)(red, green, blue, color_map, *nbcolo);
                          call(x11makegreys)(&red[k], &green[k], &blue[k], *nbcolo - k
                                                 , &whitepixel, &blackpixel);
                          foreground = (unsigned long) (0.3*red[0] + 0.59*green[0] + 0.11*blue[0])<0.5
                                                        ?(whitepixel+k):(blackpixel+k);
                          background = (unsigned long) 0;

                          break;
                        }
      case StaticColor: { printf("StaticColor \n");
                          color_map = DefaultColormap (dpy, DefaultScreen (dpy));
                          *nbcolo = min (*nbcolo, visual->map_entries);
                          call(x11readcolormap)(red, green, blue, color_map, *nbcolo);
                          call(x11makecolors)(&red, &green, &blue, *nbcolo
                                            , &whitepixel, &blackpixel);
                          foreground = WhitePixel (dpy, DefaultScreen (dpy) );
                          background = BlackPixel (dpy, DefaultScreen (dpy) );
                          *fcolor=1;
                          break;
                        }
      case TrueColor  : { printf("TrueColors  : NOT YET WELL IMPLEMENTED IN F3D\n");
                         k =0;
                         printf("Essai de TrueColor... ON FAIT COMME SI PSEUDO_COLOR...\n");
                          color_map = DefaultColormap (dpy, DefaultScreen (dpy));
                          foreground = WhitePixel (dpy, DefaultScreen (dpy) );
                          background = BlackPixel (dpy, DefaultScreen (dpy) );
                          *nbcolo = 256; 
                         call(x11makecolors)(&red, &green, &blue, *nbcolo
                                            , &whitepixel, &blackpixel);
                         *fcolor=1;


                          call(x11writecolormap)(red, green, blue, color_map, *nbcolo);
                          foreground = (unsigned long) (0.3*red[0] + 0.59*green[0] + 0.11*blue[0])<0.5?(whitepixel+k):(blackpixel+k) ;
                          background = (unsigned long) 0;
                          *fcolor=1;
                          break;   
                        }
   }

    printf(" map_entries= %d  nbcolo= %d  bits_per_rgb= %d couleur = %d stereo = %d\n"
                ,visual->map_entries,*nbcolo,visual->bits_per_rgb,*fcolor,*fstereo);
    printf("     foreground= %d   background= %d \n",foreground,background);
    if(*nbcolo == 2){printf(" table couleur: r= %f v= %f b= %f \n",red[0],green[0],blue[0]);
                     printf("              : r= %f v= %f b= %f \n",red[1],green[1],blue[1]); 
                    }
    printf(" foreground = %d background = %d\n",foreground,background);
    attributes.background_pixel = background;
    attributes.border_pixel     = foreground;
    attributes.backing_store    = Always;
    attributes.colormap         = color_map;

    window = XCreateWindow(dpy, RootWindow(dpy, DefaultScreen(dpy)),
                           x, y, width, height, border_width,
                           CopyFromParent, InputOutput, visual,
                           CWBackPixel | CWBorderPixel | CWBackingStore | CWColormap,
                           &attributes);
    XChangeProperty(dpy, window, XA_WM_NAME, XA_STRING, 8
                  , PropModeReplace, utitle , strlen(title) ); 

    MyXSelectInput (dpy, window, ExposureMask
                               | KeyPressMask
                               | KeyReleaseMask
                               | ButtonPressMask
                               | ButtonReleaseMask
/*                               | ResizeRedirectMask   */
                               | StructureNotifyMask
                   ); 

    XMapWindow(dpy, window);
         
    listfonts = XListFonts (dpy, "1*", 1, &i);
    if ( i == 0 )  listfonts = XListFonts (dpy, "*", 1, &i);
    if ( i != 0 )
      font_id = XLoadFont (dpy, *listfonts);
    else
    { printf ("No font available !\n"); exit (1); }
    XFreeFontNames( listfonts);
    gcvalues.foreground = foreground;
    gcvalues.background = background;
    gcvalues.function   = GXcopy    ;
    gcvalues.font       = font_id   ;
    gc = XCreateGC(dpy, window, GCForeground | GCBackground | GCFunction | GCFont, &gcvalues);
    
    XSetFillRule(dpy,gc,WindingRule);
      
    FlushEvent();

    listfonts = MyXListFonts (dpy, *maxfonts, nbfonts); 
    nbpolices = *nbfonts;
    printf("Nunber of fonts = %d\n", nbpolices);
    
/*  l'analyse des noms est faite en fortran  */
    k=0;
    for (k=0; k<nbpolices; k++ )
      { * (nbchar + k) = strlen ( *(listfonts + k) );
        strcpy(namefont[k],listfonts[k]);
      }
}

call(x11initrvb)(nbcolor, r, v, b, color, icolor)
integer *nbcolor, *icolor, *color;
float *r, *v, *b;
{
  int i;

  *color  = (int) foreground;
  *icolor = (int) foreground;
 
  for (i=0; i< *nbcolor; i++)
  {
    *(r+i) = red[i]  ;
    *(v+i) = green[i];
    *(b+i) = blue[i] ;
  }
}


call(x11readcolormap)(r, v, b,color_map, nbcolor)
real r[], v[], b[];
Colormap color_map;  /* recupere la table de couleur system dans r,v,b */
integer nbcolor;
{
  XColor rgb_def, hardware_def,colorcell_defs;
  unsigned short maxvalue;
  int i;

  XLookupColor (dpy, color_map, "white", &rgb_def, &hardware_def);
  maxvalue = hardware_def.red;

  for ( i = 0 ; i < nbcolor ; i++ )
  {
    colorcell_defs.pixel = (unsigned long) i;
    XQueryColor (dpy, color_map, &colorcell_defs);

    r[i] = ((float) colorcell_defs.red   / (float) maxvalue);
    v[i] = ((float) colorcell_defs.green / (float) maxvalue);
    b[i] = ((float) colorcell_defs.blue  / (float) maxvalue);
  }
}


call(x11writecolormap)(r, v, b, color_map, nbcolor)
real r[], v[], b[];
Colormap color_map;
integer nbcolor;      /*  ecrit r,v,b dans color_map */
{
  int i;
  /*XColor colorcell_defs[4096];*/
  
  if (visual->class != TrueColor)
   {
    for ( i = 0 ; i < nbcolor ; i++ )
    {
     colorcell_defs[i].pixel = (unsigned long) i;
     colorcell_defs[i].red   = (unsigned short) ( r[i] * (float) MAXSHORT );
     colorcell_defs[i].green = (unsigned short) ( v[i] * (float) MAXSHORT );
     colorcell_defs[i].blue  = (unsigned short) ( b[i] * (float) MAXSHORT );
     colorcell_defs[i].flags = DoRed | DoGreen | DoBlue;
    }
   XStoreColors (dpy, color_map, colorcell_defs, nbcolor);
  }
  else 
   {
    for ( i = 0 ; i < nbcolor ; i++ )
    {
     colorcell_defs[i].pixel = (unsigned long) i;
     colorcell_defs[i].red   = (unsigned short) ( r[i] * (float) MAXSHORT );
     colorcell_defs[i].green = (unsigned short) ( v[i] * (float) MAXSHORT );
     colorcell_defs[i].blue  = (unsigned short) ( b[i] * (float) MAXSHORT );
     colorcell_defs[i].flags = DoRed | DoGreen | DoBlue;
     XAllocColor(dpy, color_map, &colorcell_defs[i]);
    }
  }
}




call(x11makecolors)(r, v, b, nbcolors, whitepixel, blackpixel)
real r[], v[], b[];
integer nbcolors, *whitepixel,*blackpixel;
{
  long  size; 
  int i;
  int index=0;
   size=nbcolors;

   if (nbcolors == 1000)
     call(x11makecubics)(r, v, b, &index, 10);
   else if (nbcolors == 4096)
     call(x11makecubics)(r, v, b, &index, 16);
   else
     call(zcolor)(r, v, b, &size);

       
   for(i = 0; i < nbcolors; i++)
     { if(r[i]==1. && v[i]==1. && b[i]==1.) *whitepixel = i;
       else if(r[i]==0. && v[i]==0. && b[i]==0.) *blackpixel = i;
     }
}



call(x11makegreys)(r, v, b, nbcolors, whitepixel,blackpixel)
real r[], v[], b[];
integer nbcolors, *whitepixel, *blackpixel;
{
  long size;
  int i;

  size=nbcolors;
  call(zgrey)(r, v, b, &size);
  for ( i = 0 ; i < nbcolors; i++ ) 
     { if(r[i]==1. && v[i]==1. && b[i]==1.) *whitepixel = i;
       else if(r[i]==0. && v[i]==0. && b[i]==0.) *blackpixel = i;
     }
}
 

call(x11makemediums)(r, v, b, index, size, type)
real r[], v[], b[];
integer *index, type, size;
{
  int color_axe, delta_color, i;
  float color_value, offset_value;

  if ( type == BLACK_to_RGB ) 
  {
    offset_value = 0.0;
    delta_color  = 1;
  }
  else
  {
    offset_value = 1.0;
    delta_color  = -1;
  }

  size++;

  for ( i = 1 ; i < size ; i++ )
  {
    color_value = (float) i  / (float) size * (float) delta_color;

    for ( color_axe = 1 ; color_axe < 7 ; color_axe++ )
    {

      r[*index] = offset_value + color_value * (float) ( color_axe % 2 );
      v[*index] = offset_value + color_value * (float) ((color_axe / 2) % 2);
      b[*index] = offset_value + color_value * (float) ((color_axe / 4) % 2);

      (*index)++;
    }
  }  
}

call(x11makecubics)(r, v, b, index, size)
real r[], v[], b[];
integer *index, size;
{
  float redvalue, greenvalue, bluevalue, delta_color;
  int ired, igreen, iblue, i;

  i = *index; delta_color = max ((float) (size - 1), 1.0);

  for ( ired = 0; ired < size; ired++ )
  {
    redvalue = (float) ired / delta_color;
    for ( igreen = 0; igreen < size; igreen++ )
    {
      greenvalue = (float) igreen / delta_color;
      for ( iblue = 0; iblue < size; iblue++ )
      {
        bluevalue = (float) iblue / delta_color;

        r[i] = redvalue  ;
        v[i] = greenvalue;
        b[i] = bluevalue ;

        i++;
      }
    }
  }
  *index = i;
}



call(x11loadwhite)(r, v, b, index)
real r[], v[], b[];
integer index;
{
  int i;

  for ( i = index; i < 256; i++)
    r[i] = v[i] = b[i] = 1.0;
}

call(x11changecolormap)(r1, g1, b1, r, g, b, i1, i2, i3)
real r1[], g1[], b1[];
real r[],  g[],  b[];
integer *i1, *i2, *i3;
{
  int itab, i;
  /* XColor colorcell_defs[4096]; */

  if (visual->class == PseudoColor)
  { *i3 = 0;
    for ( i = 0 ; i < (*i2) - (*i1) + 1 ; i++ ) 
    { itab = i + *i1;

      r[itab] = r1[i];
      g[itab] = g1[i];
      b[itab] = b1[i];

      red[itab]   = r1[i];
      green[itab] = g1[i];
      blue[itab]  = b1[i];

      colorcell_defs[i].pixel = (unsigned long) itab;
      colorcell_defs[i].red   = (unsigned short) ( r1[i] * (float) MAXSHORT );
      colorcell_defs[i].green = (unsigned short) ( g1[i] * (float) MAXSHORT );
      colorcell_defs[i].blue  = (unsigned short) ( b1[i] * (float) MAXSHORT );
      colorcell_defs[i].flags = DoRed | DoGreen | DoBlue;
    }
    XStoreColors ( dpy, color_map, colorcell_defs, (*i2) - (*i1) + 1 );
  }
  else if (visual->class == TrueColor)
   {
     *i3 = 0;
    for ( i = 0 ; i < (*i2) - (*i1) + 1 ; i++ )
    { itab = i + *i1;

      r[itab] = r1[i];
      g[itab] = g1[i];
      b[itab] = b1[i];

      red[itab]   = r1[i];
      green[itab] = g1[i];
      blue[itab]  = b1[i];

      colorcell_defs[i].pixel = (unsigned long) itab;
      colorcell_defs[i].red   = (unsigned short) ( r1[i] * (float) MAXSHORT );
      colorcell_defs[i].green = (unsigned short) ( g1[i] * (float) MAXSHORT );
      colorcell_defs[i].blue  = (unsigned short) ( b1[i] * (float) MAXSHORT );
      colorcell_defs[i].flags = DoRed | DoGreen | DoBlue;
      XAllocColor(dpy, color_map, &colorcell_defs[i]);
    }
   }
 else
    *i3 = -1;
}
 
call(x11loadcolor)(icolor)
integer *icolor;
{ 
  unsigned long  pixel = colorcell_defs[*icolor].pixel;
  /*  if (*icolor > visual->map_entries)
   fprintf(stderr, "icolor: %d\n", *icolor);*/
  XSetForeground (dpy, gc, pixel);
}




call(x11loadfont)(i,namefonts)
integer *i;         
char *namefonts;
 
{
  char *font;
  
  if ( ( 0 <= *i ) && (*i <= nbpolices - 1 ) )
  {
/*    printf("On cherche la font %d parmis les %d\n", *i, nbpolices); */
 
/*    XFlush(dpy); */
    font = * (listfonts + *i);
    bcopy (font, namefonts, strlen(font));
    XUnloadFont(dpy,font_id);
    font_id = XLoadFont(dpy,font);
 
    XSetFont (dpy, gc, font_id);
  }    
  else
  {
    printf("x11loadfont : requested font not found, font unchanged\n");
  }
}

call(x11textextend)(i,string,nbcar,extend,taille)
integer *i,*nbcar,*extend,*taille;
char *string;
{  
  int dir,asc,desc,k;
  XCharStruct overall;

  XQueryTextExtents(dpy,font_id,string,*nbcar,&dir,&asc,&desc,&overall); 
  *extend= overall.width;  
  *taille= overall.ascent;
}


call(x11enddev)(dev)  
integer *dev;
{ 
  if(windowid) {    /* on remet la fenetre initiale */
      values.x = x_init;
      values.y = y_init;
      values.width = width_init;
      values.height = height_init;
      XConfigureWindow(dpy,init_window,
         CWX | CWY | CWWidth | CWHeight, &values);
  }
 
/*  XRaiseWindow (dpy,window);
/*  XFreeFontNames(listfonts);
*/
  XUnloadFont(dpy,font_id);
  XFreeGC(dpy,gc);
  XFreeColormap(dpy,color_map);
  XFreeColormap(dpy,color_map_sys);

/*  XDeleteProperty(dpy,window,XA_WM_NAME); 
/*  XFlush(dpy); 
/*  XFree(dpy);
/*  XDestroySubwindows(dpy,window);
/*  XDestroyWindow(dpy,window);
/*  FlushEvent(); 
*/

  if( *dev >= 0){   /* fermeture totale */
    printf("x11enddev: Total CloseDisplay (XPending= %d)\n",XPending(dpy));
    XCloseDisplay(dpy);  }
  else   {   /* fermeture temporaire */
    printf("x11enddev: Temporary CloseDisplay \n");
    XCloseDisplay(dpy);  }
} 

call(x11clean)() 
{
  XFlush(dpy); 
  XClearWindow(dpy, window);
}

call(x11szscrn)(x,y)
integer *x , *y ;
{
  XWindowAttributes wattrib;
  
loop:
  XGetWindowAttributes(dpy, window, &wattrib); 
  *x = wattrib.width;
  *y = wattrib.height;
/*  printf("width= %d  height= %d \n",*x,*y);*/
  if(*x == 65535 || *y == 65535 ){
/*    XFlush(dpy); */
    goto loop;}
} 
 
call(x11verif)(codop)
 integer* codop;
{  XWindowAttributes wattrib;
  XGetWindowAttributes(dpy, window, &wattrib); 
  if(wattrib.width == 65535 || wattrib.height == 65535 )
   {printf("BUG P_X11 codop= %d \n",*codop);
    call(tilt)(); }
}

call(x11txtsrn)(string,lstr,x1,y1)
char string[];
integer *lstr, *x1, *y1;
{ 
  XDrawString(dpy, window, gc, *x1, *y1, string, *lstr);
/*   call(viderbuff)(); */
}

call(x11mark)(string,x1,y1)
char string[];
integer *x1,*y1;
{
  XDrawString(dpy, window, gc, *x1, *y1, string, 1);
/*  call(viderbuff)(); */
}

call(x11blackwhite)(i)
integer *i;
{
  if ( *i == 0)
  {
    XSetForeground(dpy,gc,background);
/* XSetBackground(dpy,gc,background);
   XSetWindowBackground(dpy,window,background); */} 
  else
  {
      XSetForeground(dpy,gc,foreground);
/*    XSetBackground(dpy,gc,foreground);
    XSetWindowBackground(dpy,window,foreground) */;
  }
/*  call(viderbuff)(); */
}

call(x11facette)(pts,n)
integer *n ;
XPoint *pts;
{
  int npts;
  
  npts = *n;
  
  XFillPolygon(dpy, window, gc, pts, npts, Complex, CoordModeOrigin);
/*  call(viderbuff)(); */
  
}

call(x11draw3)(ptype)
integer *ptype ;
{
  XGCValues gcvalues;
  int type;

  type=  *ptype;
  switch (type)
  {
    case 0  : {gcvalues.line_style = LineSolid;     break;}
    case 1  : {gcvalues.line_style = LineOnOffDash; break;}
    default : {gcvalues.line_style = LineDoubleDash;break;}
  }
  XChangeGC(dpy, gc, GCLineStyle, &gcvalues);
}  

call(x11thick)(pepais)
integer *pepais;
{
  XGCValues gcvalues;

  gcvalues.line_width = *pepais;
  XChangeGC(dpy, gc, GCLineWidth, &gcvalues);
}


call(x11linsrn)(x1,x2,y1,y2)
integer *x1,*x2,*y1,*y2;
{   
  XDrawLine(dpy, window, gc, *x1, *x2, *y1, *y2); 
/*  call(viderbuff)(); */
}

call(getxycx11)(ibutton,x1,y1)
integer *ibutton,*x1,*y1 ;
{
  XEvent event;
  int i,flag,nb;
  XComposeStatus status;
  char buffer[20];
  KeySym keysym;   /*  incidence */

  flag=0;
  while (!flag)
  { XNextEvent(dpy, &event);
    if(event.type == Expose)
    { *ibutton = call(keyboa).redraw ;
      *x1=0;
      *y1=0;
      flag=1;
      FlushEvent();
/*      printf(" GETXY X11  EXPOSURE  %X \n",*ibutton); */
    }
    else if(event.type == ConfigureNotify)
    { *ibutton = call(keyboa).resize ;
      *x1=0;
      *y1=0;
      flag=1;
/*      printf(" GETXY X11  RESIZE REQUEST %X \n",*ibutton); */
    }
    else if(event.type == ButtonRelease) 
    { *x1 = event.xbutton.x;
      *y1 = event.xbutton.y; 
      if      (event.xbutton.button == Button1) *ibutton=251;
      else if (event.xbutton.button == Button2) *ibutton=252;
      else                                      *ibutton=253; 
      flag=1;
    }
    else if(event.type == KeyPress)
    { *x1 = event.xkey.x;
      *y1 = event.xkey.y; 
      *ibutton= event.xkey.keycode ;
       keysym=0;
       nb=XLookupString(&event.xkey,buffer,20,&keysym,&status);

/*        printf("nb= %d keysym= %d buffer=",nb,keysym);
/*        for(i=0;i<20;i++)
/*         printf(" %d ",(int)buffer[i]);
/*        printf("\n");
*/

/*       voir    /usr/include/X11/keysymdef.h + ap_keysym */

       if (nb != 0) 
         {*ibutton = buffer[0];
          flag= 1; 
         }
       else
         {
/*          if     (IsFunctionKey(keysym))     printf("function down\n");
          else if(IsModifierKey(keysym))     printf("modifier down\n");
          else if(IsKeypadKey(keysym))       printf(" keypad down\n");
          else if(IsMiscFunctionKey(keysym)) printf(" misc function down\n");
          else if(IsPFKey(keysym))           printf(" PF key down\n");
*/

          switch(keysym) 
            {
/* Cursor control & motion */

            case XK_Left :
              flag = 1;
              *ibutton = call(keyboa).curs_left;
              break;
            case XK_Up :
              flag = 1;
              *ibutton = call(keyboa).curs_up;
              break;
            case XK_Right :
              flag = 1;
              *ibutton = call(keyboa).curs_right;
              break;
            case XK_Down :
              flag = 1;
              *ibutton = call(keyboa).curs_down;
              break;
            case XK_Next :
              flag = 1;
              *ibutton = call(keyboa).pad_down;
              break;
            case XK_Prior :
              flag = 1;
              *ibutton = call(keyboa).pad_up;
              break;
            case XK_End :
              flag = 1;
              *ibutton = call(keyboa).marg_right;
              break;
            case XK_Begin :
              flag = 1;
              *ibutton = call(keyboa).marg_left;
              break;

/* Misc Functions */

            case XK_Select :
              flag = 1;
              *ibutton = call(keyboa).mark;
              break;
/*
            case XK_Print :
              flag = 1;
              *ibutton = ;
              break;  
            case XK_Execute :
              flag = 1;
              *ibutton = ;
              break;  
            case XK_Insert :
              flag = 1;
              *ibutton = ;
              break;
*/
            case XK_Undo :
              flag = 1;
              *ibutton = call(keyboa).undo;
              break;
/*
            case XK_Redo :
              flag = 1;
              *ibutton = ;
              break;
            case XK_Menu :
              flag = 1;
              *ibutton = ;
              break;
            case XK_Find :
              flag = 1;
              *ibutton = ;
              break;
*/

            case XK_Cancel :
              flag = 1;
              *ibutton = call(keyboa).line_del;
              break;
            case XK_Help :
              flag = 1;
              *ibutton = call(keyboa).help;
              break;

/*            case XK_Break :
              flag = 1;
              *ibutton = ;
              break;
            case XK_Mode_switch :
              flag = 1;
              *ibutton = ;
              break;
            case XK_script_switch :
              flag = 1;
              *ibutton = ;
              break;
            case XK_Num_Lock :
              flag = 1;
              *ibutton = ;
              break;
*/
            case XK_F1 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct1 : call(keyboa).funct1 ;
              break;
            case XK_F2 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct2 : call(keyboa).funct2 ;
              break;
            case XK_F3 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct3 : call(keyboa).funct3 ;
              break;
            case XK_F4 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct4 : call(keyboa).funct4 ;
              break;
            case XK_F5 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct5 : call(keyboa).funct5 ;
              break;
            case XK_F6 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct6 : call(keyboa).funct6 ;
              break;
            case XK_F7 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct7 : call(keyboa).funct7 ;
              break;
            case XK_F8 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct8 : call(keyboa).funct8 ;
              break;
            case XK_F9 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct9 : call(keyboa).funct9 ;
              break;
            case XK_F10 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct10 : call(keyboa).funct10 ;
              break;
            case XK_F11 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct11 : call(keyboa).funct11 ;
              break;
            case XK_F12 :
              flag = 1;
              *ibutton = shift ? call(keyboa).sfunct12 : call(keyboa).funct12 ;
              break;
            case XK_Shift_L :
              shift=1;
              break;
            case XK_Shift_R :
              shift=1;
              break;
           case XK_Control_L :
              control=1;
              break;
            case XK_Control_R :
              control=1;
              break;
            case XK_Caps_Lock :
              shiftlock = 1 ;
              break;
            case XK_Shift_Lock :
              shiftlock = 1 ;
              break;
            case XK_Meta_L :
              alt=1;
              break;
            case XK_Meta_R :
              alt=1;
              break;
            case XK_Alt_L :
              alt=1;
              break;
            case XK_Alt_R :
              alt=1;
              break;
            } /* end switch */
         }
    }
    else if(event.type == KeyRelease)
    { *x1 = event.xkey.x;
      *y1 = event.xkey.y; 
      *ibutton= event.xkey.keycode ;
       keysym=0;
       nb=XLookupString(&event.xkey,buffer,20,&keysym,&status);
/*          if     (IsFunctionKey(keysym))     printf("function up\n");
          else if(IsModifierKey(keysym))     printf("modifier up\n");
          else if(IsKeypadKey(keysym))       printf(" keypad up\n");
          else if(IsMiscFunctionKey(keysym)) printf(" misc function up\n");
          else if(IsPFKey(keysym))           printf(" PF key up\n");
*/
       if (nb == 0) 
         {
          switch(keysym)
            {
            case XK_Shift_L :
              shift=0;
              break;
            case XK_Shift_R :
              shift=0;
              break;
           case XK_Control_L :
              control=0;
              break;
            case XK_Control_R :
              control=0;
              break;
            case XK_Caps_Lock :
              shiftlock = 0 ;
              break;
            case XK_Shift_Lock :
              shiftlock = 0 ;
              break;
            case XK_Meta_L :
              alt=0;
              break;
            case XK_Meta_R :
              alt=0;
              break;
            case XK_Alt_L :
              alt=0;
              break;
            case XK_Alt_R :
              alt=0;
              break;
            } /* end switch */

         }
    }
  }
}
   

call(viderbuff)()
{
  XRaiseWindow (dpy,window);
  XFlush(dpy); 
}


call(setalufunction)(value)
integer *value ;
{
  XGCValues gcvalues;

  gcvalues.function = *value;
  XChangeGC(dpy, gc, GCFunction, &gcvalues);
}

/* wait for a typed char to continue */
call(ggpause)()
{
  XEvent event;

  XNextEvent(dpy, &event);
  switch(event.type)
  {
    case KeyPress: break;
  }
}


call(drawrectangle)(x,y,width,height)
integer  *x, *y, *width, *height;
{
  XDrawRectangle(dpy, window, gc, *x, *y, *width, *height);
/*  call(viderbuff)(); */
}

call(drawfilledrect)(x,y,width,height)
integer  *x, *y, *width, *height;
{
  XFillRectangle(dpy, window, gc, *x, *y, *width, *height); 
/*  call(viderbuff)(); */
}
      
call(drawarc)(x,y,width,height,angle1,angle2)
integer *angle1,*angle2, *x, *y, *width, *height;
{ 
  XDrawArc(dpy, window, gc, *x, *y, *width, *height, *angle1, *angle2);
/*   call(viderbuff)(); */
}

call(drawfilledarc)(x,y,width,height,angle1,angle2)
integer *angle1,*angle2, *x, *y, *width, *height;
{
  XFillArc(dpy, window, gc, *x, *y, *width, *height, *angle1, *angle2);
/*  call(viderbuff)(); */
}



MyXSelectInput(dpy, w, mask)
Display *dpy;
Window w;
int mask;
{
  XSetWindowAttributes attributes;
  attributes.event_mask = mask;
  XChangeWindowAttributes(dpy, w, CWEventMask, &attributes);
}


Punt(str)
char *str;
{
  fprintf(stderr, "Punt: %s\n", str);
  exit(1);
}

call(selgraphix11)()
{
  XRaiseWindow (dpy,window);
}

char **MyXListFonts(dpy, nbmax, nbreel)
  Display *dpy;   /* in */
  integer nbmax;      /* in */
  integer *nbreel;    /* out */
{
  char **list;
  int n;
   
    list = XListFonts (dpy, "*-iso88*", nbmax, &n);
    *nbreel=n;
    /* si necessaire, on prend un filtre plus large */
    if (*nbreel == 0) list = XListFonts (dpy, "*", nbmax, &n);
    *nbreel=n;
  return (list) ;
}

call(x11hardcopy)(nbcolo, iimp, idlf, xpr, fname)
integer * nbcolo;
integer * iimp;
integer * idlf;
char * xpr;
char * fname;
{ int i;
  char buf[255];
/* sprintf(buf,"xwd -xy -id 0x%lx | xpr -device ps -rv | lpr ",window);
   system(buf);
*/
/* sprintf(buf,"xwd -id  0x%lx > /tmp/XWDZ ",window);  /* DEBUG */
/* printf("%s\n",buf);
/* system(buf);
*/
 

/* creation du fichier postscript  */    
 if(*nbcolo ==2)
   sprintf(buf,"xwd -id  0x%lx | %s ",window,xpr);
 else
   sprintf(buf,"xwd -xy -id  0x%lx | %s ",window,xpr);
 printf("%s\n",buf);
 system(buf);

 if(*iimp){  /* impression du fichier postscript */
   if(*nbcolo ==2)
     if (*idlf)
       sprintf(buf,"prf_f3d -hardcopyX11_bw -nc -d %s ",fname);
     else
       sprintf(buf,"prf_f3d -hardcopyX11_bw -nc -nd %s ",fname);
   else
     if (*idlf)
       sprintf(buf,"prf_f3d -hardcopyX11_color -nc -d %s ",fname);
     else
       sprintf(buf,"prf_f3d -hardcopyX11_color -nc -nd %s ",fname);

  printf("%s\n",buf);
  system(buf);
  }
}
call(x11cliphard)(ClipRect)
 integer * ClipRect;
{ int xo=0,yo=0,nbr=1,ordre=Unsorted;
   XRectangle r[1];

/*   XFlush(dpy); */
   r[0].x = ClipRect[0];
   r[0].y = ClipRect[1];
   r[0].width = ClipRect[2];
   r[0].height = ClipRect[3];
   XSetClipRectangles(dpy,gc,xo,yo,r,nbr,ordre); 
}
call(x11setplanmask)(mask)
 integer *mask;
{
 switch (*mask)
 {
  case   2:{XSetPlaneMask(dpy,gc,15);break;}
  case   4:{XSetPlaneMask(dpy,gc,240);break;}
  default :{XSetPlaneMask(dpy,gc,AllPlanes);break;}
 }
      
}
FlushEvent()
{
  XEvent event;
  while (XPending(dpy))
   XNextEvent(dpy, &event);
} 
