
/********************************************************

	VAX-style Date and Time functions.
	
	These have become de-facto FORTRAN standards.
	
	Also includes a FORTRAN-90 style datetime function.
	
	IMT 23 Sep 97

********************************************************/



#if defined(TPM_F2C) || defined(SPM_F2C) || defined(CW_F2C_MAC)

#include <TextUtils.h>
#include <OSUtils.h>

#include "f2c.h"



/*
	Returns a date string of the form DD-MMM-YY
	in the leftmost 9 characters of s
	
	Typical FORTRAN call syntax:
	
		character today*9
		call date( today )
*/

int date_( char* s, ftnlen len )
{
	static char* months[] =
		{ "JAN", "FEB", "MAR", "APR", "MAY", "JUN", 
		  "JUL", "AUG", "SEP", "OCT", "NOV", "DEC" };
	
	char        	temp[12];
	Str31			buf;
	int				i, maxLen;
	long 			tempInt;
	DateTimeRec		dateTime;
	
	GetTime( &dateTime );
	
	// Stuff in the day
	tempInt = dateTime.day / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[0] = buf[1];
	tempInt = dateTime.day % 10;
	NumToString( tempInt, buf );
	temp[1] = buf[1];
	temp[2] = '-';
	
	// Stuff in the month
	temp[3] = months[ dateTime.month-1 ][0];
	temp[4] = months[ dateTime.month-1 ][1];
	temp[5] = months[ dateTime.month-1 ][2];	
	temp[6] = '-';
	
	// Stuff in the year (2-digit)
	tempInt = (dateTime.year % 100) / 10;		// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[7] =  buf[1];
	tempInt = dateTime.year % 10;
	NumToString( tempInt, buf );
	temp[8] = buf[1];
	
	maxLen = (len < 9) ? len : 9;
	for ( i = 0; i < maxLen; i++ )
		s[i] = temp[i];

	return 1;
}





/*
	Returns a time string of the form HH:MM:SS	
	in the leftmost 8 characters of s

	Typical FORTRAN call syntax:
	
		character now*8
		call time( now )
*/

int time_( char *s, ftnlen len )
{
	char        	temp[12];
	Str31			buf;
	int				i, maxLen;
	long 			tempInt;
	DateTimeRec		dateTime;
	
	GetTime( &dateTime );
	
	// Stuff in the hours
	tempInt = dateTime.hour / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[0] = buf[1];
	tempInt = dateTime.hour % 10;
	NumToString( tempInt, buf );
	temp[1] = buf[1];
	temp[2] = ':';
	
	// Stuff in the minutes	
	tempInt = dateTime.minute / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[3] = buf[1];
	tempInt = dateTime.minute % 10;
	NumToString( tempInt, buf );
	temp[4] = buf[1];
	temp[5] = ':';
	
	// Stuff in the seconds	
	tempInt = dateTime.second / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[6] = buf[1];
	tempInt = dateTime.second % 10;
	NumToString( tempInt, buf );
	temp[7] = buf[1];	
	
	maxLen = (len < 8) ? len : 8;
	for ( i = 0; i < maxLen; i++ )
		s[i] = temp[i];

	return 1;
}




/*
	Return the following as integer values:
	
		year: 	the year
		month:	the month
		day:	the day

	Typical FORTRAN call syntax:
	
		integer month, day, year
		call idate( month, day, year )
*/

int idate_( integer* month, integer* day, integer* year )
{
	DateTimeRec		dateTime;
	
	GetTime( &dateTime );
	
	*month = dateTime.month;
	*day = dateTime.day;
	*year = dateTime.year;
	
	return 1;
}





/*
	Return the following:
	
		date 		a string of the form YYMMDD	in the leftmost 6 characters
		time 		a string of the form HHMMSS.SSS	in the leftmost 10 characters
		zone 		a string of the form +HHMM in the leftmost 5 characters	
		        	( contains the time zone difference with respect to GMT)
		values[0] 	the year
		values[1]	the month
		values[2]	the day
		values[3]	the GMT time difference in minutes
		values[4]	the hour
		values[5]	the minutes
		values[6]	the seconds
		values[7]	the milliseconds (always zero)	

	Typical FORTRAN call syntax:
	
		character sdate*6, stime*10, szone*5
		dimension idatev(8)
		call date( sdate, stime, szone, idatev )
*/


int datetime_( char* date, char* time, char* zone, integer* values, 
				ftnlen dateLen, ftnlen timeLen, ftnlen zoneLen )
{
	char        		temp[12];
	Str31				buf;
	int					i, maxLen;
	long 				tempInt;
	long 				gmtDeltaSec, tempLong;
	DateTimeRec			dateTime;
	MachineLocation 	loc;
	
	GetTime( &dateTime );
	
	// Stuff in the year (4-digit)
	tempInt = dateTime.year;
	NumToString( tempInt, buf );
	for ( i = 0; i < 4; i++ )
		temp[i] = buf[i+1];
		
	// Stuff in the day
	tempInt = dateTime.month / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[4] = buf[1];
	tempInt = dateTime.month % 10;
	NumToString( tempInt, buf );
	temp[5] = buf[1];
	
	// Stuff in the day
	tempInt = dateTime.day / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[6] = buf[1];
	tempInt = dateTime.day % 10;
	NumToString( tempInt, buf );
	temp[7] = buf[1];
	
	maxLen = (dateLen < 8) ? dateLen : 8;
	for ( i = 0; i < maxLen; i++ )
		date[i] = temp[i];
	
	
	// Stuff in the hours
	tempInt = dateTime.hour / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[0] = buf[1];
	tempInt = dateTime.hour % 10;
	NumToString( tempInt, buf );
	temp[1] = buf[1];
	
	// Stuff in the minutes	
	tempInt = dateTime.minute / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[2] = buf[1];
	tempInt = dateTime.minute % 10;
	NumToString( tempInt, buf );
	temp[3] = buf[1];
	
	// Stuff in the seconds	
	tempInt = dateTime.second / 10;				// Do this to get lead zero if needed
	NumToString( tempInt, buf );
	temp[4] = buf[1];
	tempInt = dateTime.second % 10;
	NumToString( tempInt, buf );
	temp[5] = buf[1];	

	// Zero out the milliseconds
	temp[6] = '.';
	temp[7] = temp[8] = temp[9] = '0';
	
	maxLen = (timeLen < 10) ? timeLen : 10;
	for ( i = 0; i < maxLen; i++ )
		time[i] = temp[i];

	
	// Stuff in the zone
	ReadLocation( &loc );
	
	gmtDeltaSec = loc.u.gmtDelta & 0x00FFFFFF;
	tempLong = 1 << 23;
	if ( gmtDeltaSec ^ tempLong )
		gmtDeltaSec = gmtDeltaSec | 0xFF000000;
	
	// Get sign...
	if ( gmtDeltaSec < 0 )
	{
		temp[0] = '-';
		gmtDeltaSec *= -1;				// Force positive for following computations
	}
	else
		temp[0] = '+';
		
	// Get hours...
	tempInt = gmtDeltaSec / (60*60);		// Hours
	NumToString( tempInt / 10, buf );		// Lead digit (perhaps zero)
	temp[1] = buf[1];
	NumToString( tempInt % 10, buf );
	temp[2] = buf[1];
	
	// Get minutes...
	tempInt = (gmtDeltaSec - tempInt*60*60) / 60;			// minutes
	NumToString( tempInt / 10, buf );						// Lead digit (perhaps zero)
	temp[3] = buf[1];
	NumToString( tempInt % 10, buf );
	temp[4] = buf[1];
	
	maxLen = (zoneLen < 5) ? zoneLen : 5;
	for ( i = 0; i < maxLen; i++ )
		zone[i] = temp[i];

	// Set up the values array	
	values[0] = dateTime.year;
	values[1] = dateTime.month;
	values[2] = dateTime.day;
	values[3] = gmtDeltaSec / 60;				// minutes
	values[4] = dateTime.hour;
	values[5] = dateTime.minute;
	values[6] = dateTime.second;
	values[7] = 0;
	
	return 1;
}

#endif	/* MacOS compilers */
