#include "emc2_.h"
/* Table of constant values */

static integer c__50 = 50;
static integer c__3 = 3;
static integer c__0 = 0;
static integer c__2 = 2;
static integer c__9 = 9;
static integer c__1 = 1;
static integer c__4 = 4;
static integer c__10 = 10;
static integer c__5 = 5;

/* Subroutine */ int addmsh_(void)
{
    /* Format strings */
    static char fmt_2299[] = "(\002nb de sommets =\002,i6,\002; nb de triang"
	    "les =\002,i6,\002; nb de quadrangles =\002,i6,\002; nb de sous d"
	    "omaines =\002,i4,\002; nb d'aretes =\002,i5)";

    /* System generated locals */
    address a__1[3], a__2[2], a__3[4];
    integer i__1[3], i__2, i__3[2], i__4[4], i__5, i__6, i__7, i__8;
    real r__1;
    char ch__1[109], ch__2[15], ch__3[115], ch__4[122], ch__5[98], ch__6[110],
	     ch__7[103];
    cllist cl__1;

    /* Builtin functions */
    integer s_cmp(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_rsue(cilist *), do_uio(integer *, char *, ftnlen),
	     e_rsue(void), s_rsle(cilist *), e_rsle(void), f_clos(cllist *), 
	    s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;

    /* Local variables */
    static real pmin[2], pmax[2];
    static char type[80];
    static integer nbsd1, i, j, k;
#define xwork ((real *)bdwrk1_1.work)
    static char forme[11], cherr[80];
    static logical setapavue;
    extern /* Subroutine */ int addms1_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *);
    static integer ii, nf;
    static char fichie[80];
    extern /* Subroutine */ int addref_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
#define coulls ((integer *)&ctabco_1)
#define tri ((integer *)&bdwrk1_1)
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen);
    static integer err, cas;
    static char buf[132];
    static integer ftq[10];
    static real fx, fy;
    static integer nba1;
    static real mx, my, mmx;
    static integer nbd3, nbe1;
    static real mmy, hx, hy;
    extern /* Subroutine */ int intext_(char *, integer *, char *, integer *, 
	    ftnlen, ftnlen), scrtch_(char *, ftnlen), rdmesh_(integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *), addnop_(integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    static integer nbq1, nbs1, nbt1;
    extern /* Subroutine */ int genadj_(integer *, real *, integer *, integer 
	    *), chtrgl_(void), vbdmsh_(void);

    /* Fortran I/O blocks */
    static cilist io___10 = { 0, 6, 0, 0, 0 };
    static cilist io___19 = { 1, 0, 1, 0, 0 };
    static cilist io___20 = { 1, 0, 1, 0, 0 };
    static cilist io___22 = { 1, 0, 0, 0, 0 };
    static cilist io___23 = { 1, 0, 1, 0, 0 };
    static cilist io___24 = { 1, 0, 1, 0, 0 };
    static cilist io___25 = { 1, 0, 1, 0, 0 };
    static cilist io___26 = { 1, 0, 1, 0, 0 };
    static cilist io___27 = { 1, 0, 0, 0, 0 };
    static cilist io___28 = { 1, 0, 1, 0, 0 };
    static cilist io___30 = { 1, 0, 1, 0, 0 };
    static cilist io___31 = { 1, 0, 0, 0, 0 };
    static cilist io___32 = { 1, 0, 1, 0, 0 };
    static cilist io___33 = { 1, 0, 1, 0, 0 };
    static cilist io___34 = { 1, 0, 0, 0, 0 };
    static cilist io___37 = { 1, 0, 1, 0, 0 };
    static cilist io___39 = { 1, 0, 1, 0, 0 };
    static icilist io___41 = { 0, cherr, 0, "(i10)", 80, 1 };
    static cilist io___42 = { 0, 6, 0, 0, 0 };
    static cilist io___43 = { 0, 6, 0, 0, 0 };
    static cilist io___44 = { 0, 6, 0, 0, 0 };
    static icilist io___56 = { 0, buf, 0, fmt_2299, 132, 1 };
    static icilist io___57 = { 0, cherr, 0, "(i10)", 80, 1 };
    static icilist io___58 = { 0, cherr, 0, "(i10)", 80, 1 };
    static icilist io___59 = { 0, cherr, 0, "(i10)", 80, 1 };


/* ================================================= */
/* c%include 'emc2_cr8.ins' */
/* ----- expendue pour eviter plus pb de transformation -------- */
/*   F. Hecht le  10/89 --------- */
/* ------------------ */
/*     definition des structures des donnees */
/*     point   p(0:3) : p(0)=0.  p(1)=x  p(2)=y */
/*     droite  d(0:3) : d(0)=-1. d(1)=a  d(2)=b  d(3)=c */
/*     cercle  c(0:3) : c(0)=r>0 c(1)=cx c(2)=cy */
/*    arc     a(0:5) : a(0)=-2. a(1)=cx a(2)=cy a(3)=px a(4)=py a(5)=angle
*/
/*     segment s(0:4) : s(0)=-3. s(1)=x1 s(2)=y1 s(3)=x2 s(4)=y2 */
/*     vide    v(0:3) : v(0)=-1000. */

/*          eps relatif a la boite de travail (calcule par qboite) */
/* ------- fin de l'expantion --------------- */
/*                        nombre maxi de menus */
/*                        nombre maxi de cases des menus */
/*               masque de travail (xmin,xmax,ymin,ymax) */
/*               masque auto (pour voir tout objet  (xmin,xmax,ymin,ymax) 
*/
/*               pour flip flop designation par touches */
/*               device de travail */
/*               parametres suplementaires du terminal en sortie */
/*               parametres suplementaires du terminal en entree */
/*               appli =application courante, peut valoir: */
/*               calcu = 1 si calculette */
/*               calcu = 0 si pas calculette */
/*               fenetre de travail (ou l'on affiche les objets) */
/*                     (xmin,xmax,ymin,ymax) c.m. */
/*               taille de l'ecran (xmin,xmax,ymin,ymax) c.m. */
/*               couleur de l'ecran */
/*               fenetre reservee pour: */
/*                  - afficher l'etat de certaines variables */
/*                  - ecrire une ligne de scratch (messages systeme) */
/*              couleur fenetre reservee */
/*              fenetres de travail reservees */
/*              couleur fenetre de travail (1)= bas   (2)= haut */
/*              couleur de trace des objets arc, seg,... (vert) */
/*              couleur de trace d'autres elements points,...(rouge) */
/*                       ------ pour les menus ------ */
/*              fenetre de chacun des menus (xmin,xmax,ymin,ymax) c.m. */
/*             (nombre de lignes, nombre colonnes) de chacun des menus */
/*             valeurs retournees pas les cases de chacun des menus */
/*                     (on trace les lignes en premier) */
/*             menus actifs  (true si actif false sinon) */
/*             activation des cases de chacun des menus */
/*                    si = .true.  case active */
/*                       = .false. case inactive */
/*             marquage des cases des menus: */
/*           vmark marque en v */
/*           cmark marque en carre plein */
/*           qmark marque en pomme */
/*           unmark demarque la case */
/*              les valeurs correspondent a celles du mac. */
/*           caracteres correspondants */
/*              couleur de chacun des menus */
/*              taille des caracteres du menu */
/* -----------------------------------------------------------------------
 */
/*              texte des cases de chacun des menus */
/*              texte donnant le nom de chacun des menus */
/* -----------------------------------------------------------------------
 */
/*     taille maxi de la pile circulaire des masques */
/*            ------ pour la gestion de l'ecran ------- */
/*             pile circulaire des masques  (mxmsq) */
/*             pointeur courant sur la pile circulaire des masques */
/* -----------------------------------------------------------------------
 */
/*                    ------ pour l'etat du systeme ------ */
/*              scrtc=.true. si ligne de scratch ecrite */
/*              pour application construction */
/*              pour application 2 */
/*           taille dx,dy,x,y de la boite de travail : permet de calculer 
*/
/*           un eps ad hoc et non haddock (pour hecht tintin n'est pas la)
 */
/*              pour application 3 */
/*     cosmnt = cos de la borne inf des angles des triangles */
/*     cosmxt = cos de la borne sup des angles des triangles */
/*     cosmnt = cos de la borne inf des angles des quadrangles */
/*     cosmxt = cos de la borne sup des angles des quadrangles */
/*     mkelem = .true. => marquage des element ayant un angle */
/*                         hors des limites */
/*     bgptf = .true. => on peut bouger les points frontieres */
/* -----------------------------------------------------------------------
 */
/*           epaisseur des traits en mm. */
/*           epafac= epaisseure des traits effaces sur tektro */
/* -----------------------------------------------------------------------
 */
/*                   data rendues par le scan0 (scanner de design) */
/*           mode de contrainte (plupro | extrem | centre | milieu ) */
/*           vlmenu=(la valeur associee a la case) si on a pointe un menu 
*/
/*           vlmenu=(coord,p,d,c,a,s,sommet,triang,arete,sous_dom) */
/*               si on a pointe dans la fenetre de travail */
/*             et x,y sont les coordonnees du point designe */
/*                si le resultat de la designation est un point . */
/*             et xdesig,ydesig sont les coordonnees du pointe */
/*               dans masque (utilisateur). */
/*            adr= adresse dans la bd de l"element ou de son support */
/*              adr = nil si coord et pas de contrainte */

/*            (nucase) numero de la case designe du menu (numenu). */
/*            numer valeur numerique. */

/*            types des pointes */
/*             mode de contrainte en designation */
/* -----------------------------------------------------------------------
 */
/*              adresse des element designer dans la bd_mshg */
/*              aireta(i) = 2* aire du triangle de sommet i,i+1(3),(x,y) 
*/
/* -----------------------------------------------------------------------
 */
/*                    trace et interpretation */
/*              nombre maxi de d'imbrication de fichiers a interpretes */
/*             trace=numero etiquette de la trace si =0 pas de trace */
/*             interp=numero etiquette de l'interpretation */
/*                 si =0 pas d'interpretation */
/*             ptintr=numero courant du fichier a interpreter */
/*                 si =0 alors getxy */
/*            tracex nom du fichier de trace */
/* -----------------------------------------------------------------------
 */
/*                      definition  de la bd......... */
/*          nbnode:nombre de noeuds */
/*          raison:raison */
/*          nuref :numero de reference de l'element      (droit et gauche)
 */
/*          nuref1:numero de reference de l'extremitee 1 (droit et gauche)
 */
/*          nuref2:numero de reference de l'extremitee 2 (droit et gauche)
 */
/*          adp1,adp2: adresse des points extremitees 1 ou 2 de l'element 
*/
/*          fissur:indique si l'element est fissure */
/*          adjabd: tete de liste des adjacents */
/*         conx  : chainage circulaire des elements des composantes connex
es*/
/*                  gauche  et droite aux quelles appartient l'element */
/*         cnx   : indique quelle chainage des composantes connexes il fau
t*/
/*                  prendre pour la suite de conx */
/*          compos: pointeurs inverses vers les 2 composantes aux quelles 
*/
/*                  appartient l'element */

/*          typebd: type de la bd (const,apli2,apli3,...) */
/*          comp  : tete de la liste de toutes les composantes */
/*          sdomn ; tete de la liste des sous domaines */
/*          link  : tete de la liste des elements en suivants */
/*  ............................. parametres pour la bd ................. 
*/
/*          taille maxi de la bd */
/*      parameter(mxbd=5000) */
/*          partie reservee de la bd (en adresse negative) */
/* .......................................................................
 */
/*               1: ptbd  = fin de la bd de application construction */
/*          ptbd+1:finbd  = point extremite pour application 2 */
/*         finbd+1:finbd3 = element genere par application 3 */
/*                  ( par les transformation) */
/* -----------------------------------------------------------------------
 */
/*           nombre maxi de noeuds sur un element de bd */
/*           nombre maxi de points de definition pour une spline */
/*           nombre maxi de points generes sur la spline */
/*           decoupage en quadrangles ou quadrangles decoupes en triangles
 */

/* ----------------- parametre de l'application 3 ------------------------
 */

/*      parameter(nbpmxx=15000,nbamxx=5000,nbtmxx=2*nbpmxx-2,nbsdmxx=1000 
*/
/*     +         ,lwork=11*nbpmxx+nbtmxx) */
/*      la variable ibidon pour l'alignement */
/*      les sommets */
/*      les elements */
/*     les aretes */
/*      les sous domaines */
/*-----------------------------------------------------------------------
-*/
/*  - nbs : nb de sommets */
/*  - nbsrft nb de sommets ref par la triangulation */
/*  - nbtrou nb de trou dans le maillage */
/*  - nbt : nb de triangles */
/*  - nba : nb d'arete frontiere */

/*  - cr(1:2,nbs): coordonnees du  sommet i */
/*  - abcurv(i)  :abscisse curviligne du sommet i si il est interne a */
/*      une ligne de support sinon on a nul. */
/*  - refs(i)    : adresse dans la bd du support d sommet i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - nsorig(i)  : numero du sommet origine */
/*      (si il n'y a pas de fissure nsorig(i)=i */
/*      sinon nsorign(i) donne le sommet dupliquer) */

/*  - nsea(1:3,ie) : les 3 numeros des 3 sommets de du triangle ie */
/*      tournant dans le sens direct */
/*  - nsea(4:6,ie) : (d4,d5,d6) donnee des 3 aretes ai */
/*      ai est forme des sommets nsea(i-3,ie),nsea(mod(i,3)+1,ie) */
/*      si di < 0 alors arete i est frontiere et -di est pointeur */
/*        de l'arete dans aretbd */
/*      sinon arete est interne et di = 8*ta + ata */
/*        ou ta est le numero du triangle adjacent a l'arete */
/*        et ata est le numero de l'arete dans ta */
/*  - reft(ie) : numero de ref du triangle ie ou chainage des */
/*      triangles d'un sous domaine reft(ie) traingle suivant */
/*  - anovue(ie): tableau donnant les aretes non vue du triangle ie */
/*      anovue(ie) = 0 => tout les aretes sont vue */
/*      anovue(ie) = 1 => l'arete 4 n'est pas  vue */
/*      anovue(ie) = 2 => l'arete 5 n'est pas  vue */
/*      anovue(ie) = 3 => l'arete 6 n'est pas  vue */
/*      anovue(ie) = 4 => aucune aretes n'est vue */
/*           (il faut decoupe le triangle en 3 en ajoutant */
/*            un point au barycentre) */

/*  - aretbd(1:2,i) : les 2 sommets de l'arete i */
/*  - areadj(gauche:droite,i) : (d3,d4) meme definition que pour nsea */
/*  - refa(i) :  adresse dans la bd du support de l'arete i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - optdrw : option de tracer 0 => tout */
/*                              1 => pas de ref */

/* -----------------------------------------------------------------------
 */
/*  tableau de tavail */
/*     real h(nbpmx) */
/*      integer ci(2,nbpmx) */
/* -------------------------- extension des noms de fichiers ------------ 
*/
/*        bd_emc2 */
/*        bd_emc2.bak */
/*        data */
/*        nopo */
/*        mesh */
/*        msh_emc2   l'ancien format .mesh de Hetch */
/*        am */
/*        amfmt */
/*        amdba */
/*        trace */
/*        base */
/*        set, */
/*        cnet */
/* ------------------------------------------------------------------- */
/* ................................. fin  ................................
 */
L5:
    intext_("donnez le type du maillage (nopo am am_fmt mesh amdba msh ftq m"
	    "sh_emc2):", &c__50, type, &ii, 72L, 80L);
/*     call intext('give the type of mesh '                             #G
B*/
/*   +          //'(nopo am am_fmt mesh amdba msh ftq msh_emc2):'       #G
B*/
/*   +          ,50,type,ii)                                            #G
B*/
    if (ii == 0 || s_cmp(type, "MSH_EMC2", 80L, 8L) == 0 || s_cmp(type, "msh"
	    "_emc2", 80L, 8L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".msh_emc2", 80L, 9L);
	ii = i_len(".msh_emc2", 9L);
    } else if (s_cmp(type, "MESH", 80L, 4L) == 0 || s_cmp(type, "mesh", 80L, 
	    4L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".mesh", 80L, 5L);
	ii = i_len(".mesh", 5L);
    } else if (s_cmp(type, "NOPO", 80L, 4L) == 0 || s_cmp(type, "nopo", 80L, 
	    4L) == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".nopo", 80L, 5L);
	ii = i_len(".nopo", 5L);
    } else if (s_cmp(type, "AM", 80L, 2L) == 0 || s_cmp(type, "am", 80L, 2L) 
	    == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".am", 80L, 3L);
	ii = i_len(".am", 3L);
    } else if (s_cmp(type, "AM_FMT", 80L, 6L) == 0 || s_cmp(type, "am_fmt", 
	    80L, 6L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".am_fmt", 80L, 7L);
	ii = i_len(".am_fmt", 7L);
    } else if (s_cmp(type, "MSH", 80L, 3L) == 0 || s_cmp(type, "msh", 80L, 3L)
	     == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".msh", 80L, 4L);
	ii = i_len(".msh", 4L);
    } else if (s_cmp(type, "FTQ", 80L, 3L) == 0 || s_cmp(type, "ftq", 80L, 3L)
	     == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".ftq", 80L, 4L);
	ii = i_len(".ftq", 4L);
    } else if (s_cmp(type, "AMDBA", 80L, 5L) == 0 || s_cmp(type, "amdba", 80L,
	     5L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".amdba", 80L, 6L);
	ii = i_len(".amdba", 6L);
    } else {
/*       call scrtch('bad type : '''//type(1:ii)//''' retry')         
  #GB*/
/* Writing concatenation */
	i__1[0] = 16, a__1[0] = "mauvais type : '";
	i__1[1] = ii, a__1[1] = type;
	i__1[2] = 13, a__1[2] = "' recommencez";
	s_cat(ch__1, a__1, i__1, &c__3, 109L);
	scrtch_(ch__1, ii + 29);
	goto L5;
    }
L10:
    intext_("donnez le prefix des noms de fichiers de generation:", &c__50, 
	    fichie, &i, 52L, 80L);
/*     call intext('Give the prefix part of files name generation:'     #G
B*/
/*   +          ,50,fichie,i)                                           #G
B*/
    if (i == 0) {
	scrtch_("nom de fichier vide, on abandonne !", 35L);
/*      call scrtch('file name empty => cancel !')                    
  #GB*/
	return 0;
    }
    i__2 = i;
    s_copy(fichie + i__2, type, 80 - i__2, 80L);
/* Writing concatenation */
    i__3[0] = 4, a__2[0] = "old,";
    i__3[1] = 11, a__2[1] = forme;
    s_cat(ch__2, a__2, i__3, &c__2, 15L);
    if (fouvri_(&nf, fichie, ch__2, &c__0, i + ii, 15L) != 0) {
	if (s_cmp(type, ".msh_emc2", 80L, 9L) == 0) {
/* on essaie l'ancienne extension ( .mesh */
	    s_wsle(&io___10);
	    do_lio(&c__9, &c__1, "Essaie ancienne version en  .mesh", 33L);
	    e_wsle();
	    i__2 = i;
	    s_copy(fichie + i__2, ".mesh", 80 - i__2, 5L);
	    ii = i_len(".mesh", 5L);
/* Writing concatenation */
	    i__3[0] = 4, a__2[0] = "old,";
	    i__3[1] = 11, a__2[1] = forme;
	    s_cat(ch__2, a__2, i__3, &c__2, 15L);
	    if (fouvri_(&nf, fichie, ch__2, &c__0, i + ii, 15L) != 0) {
		scrtch_("pb dans open de votre fichier  .mesh", 36L);
		goto L10;
	    }
	} else {
	    scrtch_("pb dans open de votre fichier, changer de nom.", 46L);
	    goto L10;
	}
    }
/* Writing concatenation */
    i__4[0] = 16, a__3[0] = "open du fichier ";
    i__4[1] = 11, a__3[1] = forme;
    i__4[2] = 8, a__3[2] = " de nom:";
    i__4[3] = i + ii, a__3[3] = fichie;
    s_cat(ch__3, a__3, i__4, &c__4, 115L);
    scrtch_(ch__3, i + ii + 35);
/* -----------------------------------------------------------------------
 */

    bdpec5_1.nuref[128] = 0;
    bdpec5_1.nuref[129] = 0;
    err = 0;
    cas = 1000000;
    setapavue = FALSE_;
    nbd3 = bdmsh4_1.finbd3;
    nba1 = bdmsh1_1.nba;
    nbsd1 = bdmsh1_1.nbsd;
    if (s_cmp(type, ".msh_emc2", 80L, 9L) == 0) {
/* .msh_emc2  (ancient .mesh ) */
	addms1_(&nf, bdwrk1_1.work, &nbt1, &nbs1, &nba1, &nbsd1, &nbd3, &err);
	if (err != 0) {
	    goto L1000;
	}
	if (nbd3 > bdpec1_1.mxbd) {
	    goto L2000;
	}
	cas = 10;
    } else if (s_cmp(type, ".mesh", 80L, 5L) == 0) {
/* vrais .mesh */
	rdmesh_(&nf, bdwrk1_1.work, &nbt1, &nbs1, &nba1, &nbsd1, &nbd3, &err);
	if (err != 0) {
	    goto L1000;
	}
	if (nbd3 > bdpec1_1.mxbd) {
	    goto L2000;
	}
	cas = 1;
	setapavue = TRUE_;
    } else if (s_cmp(type, ".nopo", 80L, 5L) == 0) {
	i__2 = (bdmsh0_1.nbtmx << 1) + 1;
	addnop_(&bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2, &nf, &nbt1, &nbs1, 
		&err);
	if (err != 0) {
	    goto L1000;
	}
	cas = 2;
    } else if (s_cmp(type, ".am", 80L, 3L) == 0) {
	io___19.ciunit = nf;
	i__2 = s_rsue(&io___19);
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = do_uio(&c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = do_uio(&c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = e_rsue();
L100001:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___20.ciunit = nf;
	i__2 = s_rsue(&io___20);
	if (i__2 != 0) {
	    goto L100002;
	}
	i__5 = bdmsh1_1.nbt + nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_uio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (
			ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100002;
		}
	    }
	}
	i__6 = bdmsh1_1.nbs + nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__6; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_uio(&c__1, (char *)&bdmsh5_1.cr[i + (j << 1) - 3], (
			ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100002;
		}
	    }
	}
	i__7 = bdmsh1_1.nbt + nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__7; ++i) {
	    i__2 = do_uio(&c__1, (char *)&bdmsha_1.reft[i - 1], (ftnlen)
		    sizeof(integer));
	    if (i__2 != 0) {
		goto L100002;
	    }
	}
	i__8 = bdmsh1_1.nbs + nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__8; ++i) {
	    i__2 = do_uio(&c__1, (char *)&bdmsh8_1.refs[i - 1], (ftnlen)
		    sizeof(integer));
	    if (i__2 != 0) {
		goto L100002;
	    }
	}
	i__2 = e_rsue();
L100002:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".am_fmt", 80L, 7L) == 0) {
	io___22.ciunit = nf;
	i__2 = s_rsle(&io___22);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___23.ciunit = nf;
	i__2 = s_rsle(&io___23);
	if (i__2 != 0) {
	    goto L100003;
	}
	i__5 = nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + j * 6 
			- 7], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100003;
		}
	    }
	}
	i__2 = e_rsle();
L100003:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___24.ciunit = nf;
	i__2 = s_rsle(&io___24);
	if (i__2 != 0) {
	    goto L100004;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100004;
		}
	    }
	}
	i__2 = e_rsle();
L100004:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___25.ciunit = nf;
	i__2 = s_rsle(&io___25);
	if (i__2 != 0) {
	    goto L100005;
	}
	i__5 = nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__5; ++i) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[i - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100005;
	    }
	}
	i__2 = e_rsle();
L100005:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___26.ciunit = nf;
	i__2 = s_rsle(&io___26);
	if (i__2 != 0) {
	    goto L100006;
	}
	i__5 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__5; ++i) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[i - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100006;
	    }
	}
	i__2 = e_rsle();
L100006:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".amdba", 80L, 6L) == 0) {
	io___27.ciunit = nf;
	i__2 = s_rsle(&io___27);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___28.ciunit = nf;
	i__2 = s_rsle(&io___28);
	if (i__2 != 0) {
	    goto L100007;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100007;
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (k + 
			bdmsh1_1.nbs << 1) - 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100007;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[k + 
		    bdmsh1_1.nbs - 1], (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100007;
	    }
	}
	i__2 = e_rsle();
L100007:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___30.ciunit = nf;
	i__2 = s_rsle(&io___30);
	if (i__2 != 0) {
	    goto L100008;
	}
	i__5 = nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100008;
	    }
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + (k + 
			bdmsh1_1.nbt) * 6 - 7], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100008;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[k + 
		    bdmsh1_1.nbt - 1], (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100008;
	    }
	}
	i__2 = e_rsle();
L100008:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".msh", 80L, 4L) == 0) {
	io___31.ciunit = nf;
	i__2 = s_rsle(&io___31);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___32.ciunit = nf;
	i__2 = s_rsle(&io___32);
	if (i__2 != 0) {
	    goto L100009;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100009;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100009;
	    }
	}
	i__2 = e_rsle();
L100009:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___33.ciunit = nf;
	i__2 = s_rsle(&io___33);
	if (i__2 != 0) {
	    goto L100010;
	}
	i__5 = nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + j * 6 
			- 7], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100010;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100010;
	    }
	}
	i__2 = e_rsle();
L100010:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".ftq", 80L, 4L) == 0) {
	err = 0;
	io___34.ciunit = nf;
	i__2 = s_rsle(&io___34);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbe1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbq1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1 + (nbq1 << 1);
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	nbt1 = bdmsh1_1.nbt;
	i__2 = nbe1;
	for (i = 1; i <= i__2; ++i) {
	    err = i;
	    io___37.ciunit = nf;
	    i__5 = s_rsle(&io___37);
	    if (i__5 != 0) {
		goto L100011;
	    }
	    i__5 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    if (i__5 != 0) {
		goto L100011;
	    }
	    i__6 = k + 1;
	    for (j = 1; j <= i__6; ++j) {
		i__5 = do_lio(&c__3, &c__1, (char *)&ftq[j - 1], (ftnlen)
			sizeof(integer));
		if (i__5 != 0) {
		    goto L100011;
		}
	    }
	    i__5 = e_rsle();
L100011:
	    if (i__5 < 0) {
		goto L3000;
	    }
	    if (i__5 > 0) {
		goto L1000;
	    }
	    if (k == 3) {
		++nbt1;
		bdmsh9_1.nsea[nbt1 * 6 - 6] = ftq[0];
		bdmsh9_1.nsea[nbt1 * 6 - 5] = ftq[1];
		bdmsh9_1.nsea[nbt1 * 6 - 4] = ftq[2];
		bdmsha_1.reft[nbt1 - 1] = ftq[3];
		bdmshb_1.apavue[nbt1 - 1] = 0;
	    } else if (k == 4) {
		++nbt1;
		bdmsh9_1.nsea[nbt1 * 6 - 6] = ftq[0];
		bdmsh9_1.nsea[nbt1 * 6 - 5] = ftq[1];
		bdmsh9_1.nsea[nbt1 * 6 - 4] = ftq[2];
		bdmsha_1.reft[nbt1 - 1] = ftq[4];
		bdmshb_1.apavue[nbt1 - 1] = 3;
		++nbt1;
		bdmsh9_1.nsea[nbt1 * 6 - 6] = ftq[0];
		bdmsh9_1.nsea[nbt1 * 6 - 5] = ftq[2];
		bdmsh9_1.nsea[nbt1 * 6 - 4] = ftq[3];
		bdmsha_1.reft[nbt1 - 1] = ftq[4];
		bdmshb_1.apavue[nbt1 - 1] = 1;
	    } else {
		scrtch_("Big Bug in file .ftq ni triangle,ni quad", 40L);
		goto L1000;
	    }
	}
	err = 100000;
	io___39.ciunit = nf;
	i__2 = s_rsle(&io___39);
	if (i__2 != 0) {
	    goto L100012;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100012;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100012;
	    }
	}
	i__2 = e_rsle();
L100012:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
	setapavue = TRUE_;
	err = 0;
    } else {
/* Writing concatenation */
	i__3[0] = 29, a__2[0] = "ERREUR addmsh dans les types ";
	i__3[1] = ii - 1, a__2[1] = type + 1;
	s_cat(ch__1, a__2, i__3, &c__2, 109L);
	scrtch_(ch__1, ii + 28);
	err = 1;
    }
L100:
    cl__1.cerr = 0;
    cl__1.cunit = nf;
    cl__1.csta = 0;
    f_clos(&cl__1);
    if (err != 0) {
	return 0;
    }
    if (cas == 1) {
	i__2 = nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__2; ++i) {
	    if (! setapavue) {
		bdmshb_1.apavue[i - 1] = 0;
	    }
	    for (j = 4; j <= 6; ++j) {
		bdmsh9_1.nsea[j + i * 6 - 7] = 0;
/* L110: */
	    }
	}
	i__2 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__2; ++i) {
	    bdmsh6_1.nsorig[i - 1] = i;
/* L115: */
	}
    } else {
/*       shift des sommets origne */
	i__2 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__2; ++i) {
	    bdmsh6_1.nsorig[i - 1] += bdmsh1_1.nbs;
/* L116: */
	}
    }
/*     shift des elements ------------------------------------- */
    i__2 = nbt1;
    for (i = bdmsh1_1.nbt + 1; i <= i__2; ++i) {
	for (j = 1; j <= 3; ++j) {
	    bdmsh9_1.nsea[j + i * 6 - 7] += bdmsh1_1.nbs;
	    if (bdmsh9_1.nsea[j + i * 6 - 7] <= bdmsh1_1.nbs || bdmsh9_1.nsea[
		    j + i * 6 - 7] > nbs1) {
		scrtch_("les elements du maillage lu sont incorrects, on ne "
			"fait rien", 60L);
		return 0;
	    }
/* L120: */
	}
    }
/*     shift des aretes -------------------------------------- */
    i__2 = nba1;
    for (i = bdmsh1_1.nba + 1; i <= i__2; ++i) {
	bdmshc_1.aretbd[(i << 1) - 2] += bdmsh1_1.nbs;
	bdmshc_1.aretbd[(i << 1) - 1] += bdmsh1_1.nbs;
/* L130: */
    }
    if (cas <= 9) {
/*        def des sous domaines et construction des aretes & bd */
	i__2 = (bdmsh0_1.lwork - nbs1) / 3;
	addref_(bdwrk1_1.work, &bdwrk1_1.work[nbs1], &i__2, &nbs1, &nba1, &
		nbt1, &nbsd1, &nbd3, &err);
	if (err != 0) {
	    s_wsfi(&io___41);
	    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
	    e_wsfi();
/* Writing concatenation */
	    i__3[0] = 42, a__2[0] = "le maillage lu est mauvais on ne fait r"
		    "ien";
	    i__3[1] = 80, a__2[1] = cherr;
	    s_cat(ch__4, a__2, i__3, &c__2, 122L);
	    scrtch_(ch__4, 122L);
	    return 0;
	}
	if (nba1 > bdmsh0_1.nbamx || nbsd1 > nbsd1 || nbd3 > bdpec1_1.mxbd) {
	    s_wsle(&io___42);
	    do_lio(&c__9, &c__1, "nba1=", 5L);
	    do_lio(&c__3, &c__1, (char *)&nba1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdmsh0_1.nbamx, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    s_wsle(&io___43);
	    do_lio(&c__9, &c__1, "nbsd1=", 6L);
	    do_lio(&c__3, &c__1, (char *)&nbsd1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdmsh0_1.nbsdmx, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    s_wsle(&io___44);
	    do_lio(&c__9, &c__1, "nbd3=", 5L);
	    do_lio(&c__3, &c__1, (char *)&nbd3, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec1_1.mxbd, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    scrtch_("pas assez de place memoire,on ne fait rien", 42L);
/*          call scrtch('not enough memory, nothing is done')     
      #GB*/
	    return 0;
	}
    }

    if (nbs1 <= bdmsh1_1.nbs) {
	return 0;
    }
    if (cas < 1000) {
	pmin[0] = bdmsh5_1.cr[0];
	pmin[1] = bdmsh5_1.cr[1];
	pmax[0] = bdmsh5_1.cr[0];
	pmax[1] = bdmsh5_1.cr[1];
	i__2 = nbs1;
	for (i = 2; i <= i__2; ++i) {
/* Computing MIN */
	    r__1 = bdmsh5_1.cr[(i << 1) - 2];
	    pmin[0] = dmin(r__1,pmin[0]);
/* Computing MAX */
	    r__1 = bdmsh5_1.cr[(i << 1) - 2];
	    pmax[0] = dmax(r__1,pmax[0]);
/* Computing MIN */
	    r__1 = bdmsh5_1.cr[(i << 1) - 1];
	    pmin[1] = dmin(r__1,pmin[1]);
/* Computing MAX */
	    r__1 = bdmsh5_1.cr[(i << 1) - 1];
	    pmax[1] = dmax(r__1,pmax[1]);
/* L140: */
	}
	mmx = (pmin[0] + pmax[0]) / 2.f;
	mmy = (pmin[1] + pmax[1]) / 2.f;
	fx = (pec_1.fentre[1] - pec_1.fentre[0]) / 2.f;
	fy = (pec_1.fentre[3] - pec_1.fentre[2]) / 2.f;
	mx = (pmax[0] - pmin[0]) / 2.f;
	my = (pmax[1] - pmin[1]) / 2.f;
	if (mx != 0.f) {
	    hx = fx / mx;
	} else {
	    hx = fx;
	}
	hy = hx;
	if (fy < my * hy) {
	    if (my != 0.f) {
		hy = fy / my;
	    } else {
		hy = 1.f;
	    }
	    hx = hy;
	}
	if (hx == 0.f || hy == 0.f) {
	    hx = 1.f;
	    hy = 1.f;
	}
	pec_1.masque[0] = mmx - fx * 1.05f / hx;
	pec_1.masque[1] = mmx + fx * 1.05f / hx;
	pec_1.masque[2] = mmy - fy * 1.05f / hy;
	pec_1.masque[3] = mmy + fy * 1.05f / hy;
	etat_1.echel = hx;
	bdmsh1_1.nbt = nbt1;
	bdmsh1_1.nbs = nbs1;
	bdmsh1_1.nba = nba1;
	bdmsh1_1.nbsd = nbsd1;
	bdmsh4_1.finbd3 = nbd3;
	i__2 = bdmsh0_1.nbpmx + bdmsh0_1.nbtmx;
	genadj_(&bdwrk1_1.work[bdmsh0_1.nbpmx], &xwork[bdmsh0_1.nbpmx], &
		bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2);
/*        call genadj(ci,tri,nbpmx+nbtmx) */
	chtrgl_();
/* L2299: */
	s_wsfi(&io___56);
	do_fio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbsd, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nba, (ftnlen)sizeof(integer));
	e_wsfi();
	scrtch_(buf, 132L);
    } else {
	scrtch_("ERREUR dans addmesh", 19L);
    }
    vbdmsh_();
    return 0;
L1000:
    s_wsfi(&io___57);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 18, a__2[0] = "ERREUR de lecture:";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__5, a__2, i__3, &c__2, 98L);
    scrtch_(ch__5, 98L);
    err = 1;
    goto L100;
L2000:
    s_wsfi(&io___58);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 30, a__2[0] = "trop de chose on ne fait rien:";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__6, a__2, i__3, &c__2, 110L);
    scrtch_(ch__6, 110L);
    err = 2;
    goto L100;
L3000:
    s_wsfi(&io___59);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 23, a__2[0] = "ERREUR fin de fichier: ";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__7, a__2, i__3, &c__2, 103L);
    scrtch_(ch__7, 103L);
    err = 3;
    goto L100;
} /* addmsh_ */

#undef tri
#undef coulls
#undef xwork


/* Subroutine */ int ecrmsh_(void)
{
    /* System generated locals */
    address a__1[3], a__2[4], a__3[2];
    integer i__1[3], i__2, i__3[4], i__4, i__5, i__6, i__7, i__8[2];
    char ch__1[109], ch__2[115];
    cllist cl__1;

    /* Builtin functions */
    integer s_cmp(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsue(cilist *), do_uio(integer *, char *, ftnlen),
	     e_wsue(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen)
	    , e_wsfe(void), f_clos(cllist *);

    /* Local variables */
    static char type[80];
    static integer i, j;
#define xwork ((real *)bdwrk1_1.work)
    static integer lsomm[4];
    static char forme[11];
    extern /* Subroutine */ int ecrms1_(integer *, integer *, integer *);
    static integer ii, nf;
    static char fichie[80];
    extern /* Subroutine */ int genadj_(integer *, real *, integer *, integer 
	    *);
#define coulls ((integer *)&ctabco_1)
#define tri ((integer *)&bdwrk1_1)
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen);
    static integer err, nbselem, ra4[4];
    static char yes[10];
    extern integer rfsomm_(integer *), rfaret_(integer *, integer *), mshele_(
	    integer *, integer *, integer *);
    extern /* Subroutine */ int scrtch_(char *, ftnlen), intext_(char *, 
	    integer *, char *, integer *, ftnlen, ftnlen), ecrnop_(integer *, 
	    integer *, integer *, integer *), chtrgl_(void);

    /* Fortran I/O blocks */
    static cilist io___70 = { 0, 0, 0, 0, 0 };
    static cilist io___71 = { 0, 0, 0, 0, 0 };
    static cilist io___72 = { 0, 0, 0, 0, 0 };
    static cilist io___73 = { 0, 0, 0, 0, 0 };
    static cilist io___74 = { 0, 0, 0, 0, 0 };
    static cilist io___76 = { 0, 0, 0, 0, 0 };
    static cilist io___77 = { 0, 0, 0, 0, 0 };
    static cilist io___78 = { 0, 0, 0, 0, 0 };
    static cilist io___79 = { 0, 0, 0, 0, 0 };
    static cilist io___80 = { 0, 0, 0, 0, 0 };
    static cilist io___81 = { 0, 0, 0, 0, 0 };
    static cilist io___85 = { 0, 0, 0, 0, 0 };
    static cilist io___86 = { 0, 0, 0, 0, 0 };
    static cilist io___87 = { 0, 0, 0, 0, 0 };
    static cilist io___88 = { 0, 0, 0, 0, 0 };
    static cilist io___89 = { 0, 0, 0, 0, 0 };
    static cilist io___91 = { 0, 0, 0, 0, 0 };
    static cilist io___92 = { 0, 0, 0, 0, 0 };
    static cilist io___93 = { 0, 0, 0, 0, 0 };
    static cilist io___94 = { 0, 0, 0, "(2(3(1x,     i6),3x))", 0 };
    static cilist io___95 = { 0, 0, 0, "(2(2(1x,1pe14.6),3x))", 0 };
    static cilist io___96 = { 0, 0, 0, "(10(1x,i7))", 0 };
    static cilist io___97 = { 0, 0, 0, "(10(1x,i7))", 0 };
    static cilist io___98 = { 0, 0, 0, 0, 0 };
    static cilist io___99 = { 0, 0, 0, "(1(2(1x,1pe14.6),3x,i5))", 0 };
    static cilist io___100 = { 0, 0, 0, "(1(3(1x,     i6),3x,i5))", 0 };
    static cilist io___101 = { 0, 0, 0, "(1(2(1x,     i6),3x,i5))", 0 };
    static cilist io___102 = { 0, 0, 0, 0, 0 };
    static cilist io___103 = { 0, 0, 0, 0, 0 };
    static cilist io___104 = { 0, 0, 0, "(1(2(1x,1pe14.6),3x,i5))", 0 };
    static cilist io___105 = { 0, 0, 0, 0, 0 };
    static cilist io___106 = { 0, 0, 0, "(1(1x,i10,2(1x,1pe15.7),4x,i5))", 0 }
	    ;
    static cilist io___107 = { 0, 0, 0, "(1(1x,i6,3(1x,i6),4x,i5))", 0 };


/* ================================================= */
/* c%include 'emc2_cr8.ins' */
/* ----- expendue pour eviter plus pb de transformation -------- */
/*   F. Hecht le  10/89 --------- */
/* ------------------ */
/*     definition des structures des donnees */
/*     point   p(0:3) : p(0)=0.  p(1)=x  p(2)=y */
/*     droite  d(0:3) : d(0)=-1. d(1)=a  d(2)=b  d(3)=c */
/*     cercle  c(0:3) : c(0)=r>0 c(1)=cx c(2)=cy */
/*    arc     a(0:5) : a(0)=-2. a(1)=cx a(2)=cy a(3)=px a(4)=py a(5)=angle
*/
/*     segment s(0:4) : s(0)=-3. s(1)=x1 s(2)=y1 s(3)=x2 s(4)=y2 */
/*     vide    v(0:3) : v(0)=-1000. */

/*          eps relatif a la boite de travail (calcule par qboite) */
/* ------- fin de l'expantion --------------- */
/*                        nombre maxi de menus */
/*                        nombre maxi de cases des menus */
/*               masque de travail (xmin,xmax,ymin,ymax) */
/*               masque auto (pour voir tout objet  (xmin,xmax,ymin,ymax) 
*/
/*               pour flip flop designation par touches */
/*               device de travail */
/*               parametres suplementaires du terminal en sortie */
/*               parametres suplementaires du terminal en entree */
/*               appli =application courante, peut valoir: */
/*               calcu = 1 si calculette */
/*               calcu = 0 si pas calculette */
/*               fenetre de travail (ou l'on affiche les objets) */
/*                     (xmin,xmax,ymin,ymax) c.m. */
/*               taille de l'ecran (xmin,xmax,ymin,ymax) c.m. */
/*               couleur de l'ecran */
/*               fenetre reservee pour: */
/*                  - afficher l'etat de certaines variables */
/*                  - ecrire une ligne de scratch (messages systeme) */
/*              couleur fenetre reservee */
/*              fenetres de travail reservees */
/*              couleur fenetre de travail (1)= bas   (2)= haut */
/*              couleur de trace des objets arc, seg,... (vert) */
/*              couleur de trace d'autres elements points,...(rouge) */
/*                       ------ pour les menus ------ */
/*              fenetre de chacun des menus (xmin,xmax,ymin,ymax) c.m. */
/*             (nombre de lignes, nombre colonnes) de chacun des menus */
/*             valeurs retournees pas les cases de chacun des menus */
/*                     (on trace les lignes en premier) */
/*             menus actifs  (true si actif false sinon) */
/*             activation des cases de chacun des menus */
/*                    si = .true.  case active */
/*                       = .false. case inactive */
/*             marquage des cases des menus: */
/*           vmark marque en v */
/*           cmark marque en carre plein */
/*           qmark marque en pomme */
/*           unmark demarque la case */
/*              les valeurs correspondent a celles du mac. */
/*           caracteres correspondants */
/*              couleur de chacun des menus */
/*              taille des caracteres du menu */
/* -----------------------------------------------------------------------
 */
/*              texte des cases de chacun des menus */
/*              texte donnant le nom de chacun des menus */
/* -----------------------------------------------------------------------
 */
/*     taille maxi de la pile circulaire des masques */
/*            ------ pour la gestion de l'ecran ------- */
/*             pile circulaire des masques  (mxmsq) */
/*             pointeur courant sur la pile circulaire des masques */
/* -----------------------------------------------------------------------
 */
/*                    ------ pour l'etat du systeme ------ */
/*              scrtc=.true. si ligne de scratch ecrite */
/*              pour application construction */
/*              pour application 2 */
/*           taille dx,dy,x,y de la boite de travail : permet de calculer 
*/
/*           un eps ad hoc et non haddock (pour hecht tintin n'est pas la)
 */
/*              pour application 3 */
/*     cosmnt = cos de la borne inf des angles des triangles */
/*     cosmxt = cos de la borne sup des angles des triangles */
/*     cosmnt = cos de la borne inf des angles des quadrangles */
/*     cosmxt = cos de la borne sup des angles des quadrangles */
/*     mkelem = .true. => marquage des element ayant un angle */
/*                         hors des limites */
/*     bgptf = .true. => on peut bouger les points frontieres */
/* -----------------------------------------------------------------------
 */
/*           epaisseur des traits en mm. */
/*           epafac= epaisseure des traits effaces sur tektro */
/* -----------------------------------------------------------------------
 */
/*                   data rendues par le scan0 (scanner de design) */
/*           mode de contrainte (plupro | extrem | centre | milieu ) */
/*           vlmenu=(la valeur associee a la case) si on a pointe un menu 
*/
/*           vlmenu=(coord,p,d,c,a,s,sommet,triang,arete,sous_dom) */
/*               si on a pointe dans la fenetre de travail */
/*             et x,y sont les coordonnees du point designe */
/*                si le resultat de la designation est un point . */
/*             et xdesig,ydesig sont les coordonnees du pointe */
/*               dans masque (utilisateur). */
/*            adr= adresse dans la bd de l"element ou de son support */
/*              adr = nil si coord et pas de contrainte */

/*            (nucase) numero de la case designe du menu (numenu). */
/*            numer valeur numerique. */

/*            types des pointes */
/*             mode de contrainte en designation */
/* -----------------------------------------------------------------------
 */
/*              adresse des element designer dans la bd_mshg */
/*              aireta(i) = 2* aire du triangle de sommet i,i+1(3),(x,y) 
*/
/* -----------------------------------------------------------------------
 */
/*                    trace et interpretation */
/*              nombre maxi de d'imbrication de fichiers a interpretes */
/*             trace=numero etiquette de la trace si =0 pas de trace */
/*             interp=numero etiquette de l'interpretation */
/*                 si =0 pas d'interpretation */
/*             ptintr=numero courant du fichier a interpreter */
/*                 si =0 alors getxy */
/*            tracex nom du fichier de trace */
/* -----------------------------------------------------------------------
 */
/*                      definition  de la bd......... */
/*          nbnode:nombre de noeuds */
/*          raison:raison */
/*          nuref :numero de reference de l'element      (droit et gauche)
 */
/*          nuref1:numero de reference de l'extremitee 1 (droit et gauche)
 */
/*          nuref2:numero de reference de l'extremitee 2 (droit et gauche)
 */
/*          adp1,adp2: adresse des points extremitees 1 ou 2 de l'element 
*/
/*          fissur:indique si l'element est fissure */
/*          adjabd: tete de liste des adjacents */
/*         conx  : chainage circulaire des elements des composantes connex
es*/
/*                  gauche  et droite aux quelles appartient l'element */
/*         cnx   : indique quelle chainage des composantes connexes il fau
t*/
/*                  prendre pour la suite de conx */
/*          compos: pointeurs inverses vers les 2 composantes aux quelles 
*/
/*                  appartient l'element */

/*          typebd: type de la bd (const,apli2,apli3,...) */
/*          comp  : tete de la liste de toutes les composantes */
/*          sdomn ; tete de la liste des sous domaines */
/*          link  : tete de la liste des elements en suivants */
/*  ............................. parametres pour la bd ................. 
*/
/*          taille maxi de la bd */
/*      parameter(mxbd=5000) */
/*          partie reservee de la bd (en adresse negative) */
/* .......................................................................
 */
/*               1: ptbd  = fin de la bd de application construction */
/*          ptbd+1:finbd  = point extremite pour application 2 */
/*         finbd+1:finbd3 = element genere par application 3 */
/*                  ( par les transformation) */
/* -----------------------------------------------------------------------
 */
/*           nombre maxi de noeuds sur un element de bd */
/*           nombre maxi de points de definition pour une spline */
/*           nombre maxi de points generes sur la spline */
/*           decoupage en quadrangles ou quadrangles decoupes en triangles
 */

/* ----------------- parametre de l'application 3 ------------------------
 */

/*      parameter(nbpmxx=15000,nbamxx=5000,nbtmxx=2*nbpmxx-2,nbsdmxx=1000 
*/
/*     +         ,lwork=11*nbpmxx+nbtmxx) */
/*      la variable ibidon pour l'alignement */
/*      les sommets */
/*      les elements */
/*     les aretes */
/*      les sous domaines */
/*-----------------------------------------------------------------------
-*/
/*  - nbs : nb de sommets */
/*  - nbsrft nb de sommets ref par la triangulation */
/*  - nbtrou nb de trou dans le maillage */
/*  - nbt : nb de triangles */
/*  - nba : nb d'arete frontiere */

/*  - cr(1:2,nbs): coordonnees du  sommet i */
/*  - abcurv(i)  :abscisse curviligne du sommet i si il est interne a */
/*      une ligne de support sinon on a nul. */
/*  - refs(i)    : adresse dans la bd du support d sommet i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - nsorig(i)  : numero du sommet origine */
/*      (si il n'y a pas de fissure nsorig(i)=i */
/*      sinon nsorign(i) donne le sommet dupliquer) */

/*  - nsea(1:3,ie) : les 3 numeros des 3 sommets de du triangle ie */
/*      tournant dans le sens direct */
/*  - nsea(4:6,ie) : (d4,d5,d6) donnee des 3 aretes ai */
/*      ai est forme des sommets nsea(i-3,ie),nsea(mod(i,3)+1,ie) */
/*      si di < 0 alors arete i est frontiere et -di est pointeur */
/*        de l'arete dans aretbd */
/*      sinon arete est interne et di = 8*ta + ata */
/*        ou ta est le numero du triangle adjacent a l'arete */
/*        et ata est le numero de l'arete dans ta */
/*  - reft(ie) : numero de ref du triangle ie ou chainage des */
/*      triangles d'un sous domaine reft(ie) traingle suivant */
/*  - anovue(ie): tableau donnant les aretes non vue du triangle ie */
/*      anovue(ie) = 0 => tout les aretes sont vue */
/*      anovue(ie) = 1 => l'arete 4 n'est pas  vue */
/*      anovue(ie) = 2 => l'arete 5 n'est pas  vue */
/*      anovue(ie) = 3 => l'arete 6 n'est pas  vue */
/*      anovue(ie) = 4 => aucune aretes n'est vue */
/*           (il faut decoupe le triangle en 3 en ajoutant */
/*            un point au barycentre) */

/*  - aretbd(1:2,i) : les 2 sommets de l'arete i */
/*  - areadj(gauche:droite,i) : (d3,d4) meme definition que pour nsea */
/*  - refa(i) :  adresse dans la bd du support de l'arete i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - optdrw : option de tracer 0 => tout */
/*                              1 => pas de ref */

/* -----------------------------------------------------------------------
 */
/*  tableau de tavail */
/*     real h(nbpmx) */
/*      integer ci(2,nbpmx) */
/* -------------------------- extension des noms de fichiers ------------ 
*/
/*        bd_emc2 */
/*        bd_emc2.bak */
/*        data */
/*        nopo */
/*        mesh */
/*        msh_emc2   l'ancien format .mesh de Hetch */
/*        am */
/*        amfmt */
/*        amdba */
/*        trace */
/*        base */
/*        set, */
/*        cnet */
/* ------------------------------------------------------------------- */
/* ................................. fin  ................................
 */
L5:
    if (bdmsh1_1.nbt == 0) {
	scrtch_(" il n'y a rien a ecrire ", 24L);
	return 0;
    }
    intext_("donnez le type du maillage (nopo am am_fmt mesh amdba msh ftq m"
	    "sh_emc2):", &c__50, type, &ii, 72L, 80L);
/*     call intext('give the type of mesh '                             #G
B*/
    if (ii == 0 || s_cmp(type, "MSH_EMC2", 80L, 8L) == 0 || s_cmp(type, "msh"
	    "_emc2", 80L, 8L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".msh_emc2", 80L, 9L);
	ii = i_len(".msh_emc2", 9L);
    } else if (s_cmp(type, "MESH", 80L, 4L) == 0 || s_cmp(type, "mesh", 80L, 
	    4L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".mesh", 80L, 5L);
	ii = i_len(".mesh", 5L);
    } else if (s_cmp(type, "NOPO", 80L, 4L) == 0 || s_cmp(type, "nopo", 80L, 
	    4L) == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".nopo", 80L, 5L);
	ii = i_len(".nopo", 5L);
    } else if (s_cmp(type, "AM", 80L, 2L) == 0 || s_cmp(type, "am", 80L, 2L) 
	    == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".am", 80L, 3L);
	ii = i_len(".am", 3L);
    } else if (s_cmp(type, "AM_FMT", 80L, 6L) == 0 || s_cmp(type, "am_fmt", 
	    80L, 6L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".am_fmt", 80L, 7L);
	ii = i_len(".am_fmt", 7L);
    } else if (s_cmp(type, "MSH", 80L, 3L) == 0 || s_cmp(type, "msh", 80L, 3L)
	     == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".msh", 80L, 4L);
	ii = i_len(".msh", 4L);
    } else if (s_cmp(type, "FTQ", 80L, 3L) == 0 || s_cmp(type, "ftq", 80L, 3L)
	     == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".ftq", 80L, 4L);
	ii = i_len(".ftq", 4L);
    } else if (s_cmp(type, "AMDBA", 80L, 5L) == 0 || s_cmp(type, "amdba", 80L,
	     5L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".amdba", 80L, 6L);
	ii = i_len(".amdba", 6L);
    } else {
/* Writing concatenation */
	i__1[0] = 16, a__1[0] = "mauvais type : '";
	i__1[1] = ii, a__1[1] = type;
	i__1[2] = 13, a__1[2] = "' recommencez";
	s_cat(ch__1, a__1, i__1, &c__3, 109L);
	scrtch_(ch__1, ii + 29);
	goto L5;
    }
L10:
    intext_("donnez le prefix des noms de fichiers type(1:ii) de generation:",
	     &c__50, fichie, &i, 63L, 80L);
/*     call intext('give the prefix part of file''s names: '            #G
B*/
/*    +     //'type(1:ii)'//' for generation:',50,fichie,i)             #G
B*/
    if (i == 0) {
	scrtch_("nom de fichier vide, on abandonne !", 35L);
/*      call scrtch('file name empty => cancel !')                    
  #GB*/
	return 0;
    }
    i__2 = i;
    s_copy(fichie + i__2, type, 80 - i__2, 80L);
    if (fouvri_(&nf, fichie, forme, &c__0, i + ii, 11L) != 0) {
	scrtch_("pb dans open de votre fichier, changer de nom.", 46L);
/*      call scrtch('pb in open of your file, change the name.')      
  #GB*/
	goto L10;
    }
/* Writing concatenation */
    i__3[0] = 16, a__2[0] = "open du fichier ";
    i__3[1] = 11, a__2[1] = forme;
    i__3[2] = 8, a__2[2] = " de nom:";
    i__3[3] = i + ii, a__2[3] = fichie;
    s_cat(ch__2, a__2, i__3, &c__4, 115L);
    scrtch_(ch__2, i + ii + 35);
/* -----on compresse le maillage ----------------- */
    i__2 = bdmsh0_1.nbpmx + bdmsh0_1.nbtmx;
    genadj_(&bdwrk1_1.work[bdmsh0_1.nbpmx], &xwork[bdmsh0_1.nbpmx], &
	    bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2);
    bdpec5_1.nuref[128] = 0;
    err = 0;
    if (s_cmp(type, ".msh_emc2", 80L, 9L) == 0) {
/* .msh_emc2  (ancient .mesh ) */
	ecrms1_(&nf, bdwrk1_1.work, &bdwrk1_1.work[bdpec1_1.mxbd + 1]);
    } else if (s_cmp(type, ".mesh", 80L, 5L) == 0) {
/* vrais  .mesh */
	io___70.ciunit = nf;
	s_wsle(&io___70);
	do_lio(&c__9, &c__1, "MeshVersionFormatted", 20L);
	do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	e_wsle();
	io___71.ciunit = nf;
	s_wsle(&io___71);
	do_lio(&c__9, &c__1, "Dimension", 9L);
	e_wsle();
	io___72.ciunit = nf;
	s_wsle(&io___72);
	do_lio(&c__3, &c__1, (char *)&c__2, (ftnlen)sizeof(integer));
	e_wsle();
	io___73.ciunit = nf;
	s_wsle(&io___73);
	do_lio(&c__9, &c__1, "Vertices", 8L);
	e_wsle();
	io___74.ciunit = nf;
	s_wsle(&io___74);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	e_wsle();
	i__2 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__2; ++j) {
	    io___76.ciunit = nf;
	    s_wsle(&io___76);
	    for (i = 1; i <= 2; ++i) {
		do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (
			bdmsh6_1.nsorig[j - 1] << 1) - 3], (ftnlen)sizeof(
			real));
	    }
	    i__4 = rfsomm_(&j);
	    do_lio(&c__3, &c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	    e_wsle();
	}
	if (bdmsh1_1.nba > 0) {
	    io___77.ciunit = nf;
	    s_wsle(&io___77);
	    do_lio(&c__9, &c__1, "Edges", 5L);
	    e_wsle();
	    io___78.ciunit = nf;
	    s_wsle(&io___78);
	    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nba, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    i__2 = bdmsh1_1.nba;
	    for (j = 1; j <= i__2; ++j) {
		io___79.ciunit = nf;
		s_wsle(&io___79);
		for (i = 1; i <= 2; ++i) {
		    do_lio(&c__3, &c__1, (char *)&bdmshc_1.aretbd[i + (j << 1)
			     - 3], (ftnlen)sizeof(integer));
		}
		i__5 = -j;
		i__4 = rfaret_(&c__0, &i__5);
		do_lio(&c__3, &c__1, (char *)&i__4, (ftnlen)sizeof(integer));
		e_wsle();
	    }
	}
	if (bdmsh1_1.nbtria > 0) {
	    io___80.ciunit = nf;
	    s_wsle(&io___80);
	    do_lio(&c__9, &c__1, "Triangles", 9L);
	    e_wsle();
	    io___81.ciunit = nf;
	    s_wsle(&io___81);
	    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    i__2 = bdmsh1_1.nbt;
	    for (j = 1; j <= i__2; ++j) {
		nbselem = mshele_(&j, lsomm, ra4);
		if (nbselem == 3) {
		    io___85.ciunit = nf;
		    s_wsle(&io___85);
		    i__4 = nbselem;
		    for (i = 1; i <= i__4; ++i) {
			do_lio(&c__3, &c__1, (char *)&lsomm[i - 1], (ftnlen)
				sizeof(integer));
		    }
		    do_lio(&c__3, &c__1, (char *)&bdmshf_1.refsd[
			    bdmsha_1.reft[j - 1] - 1], (ftnlen)sizeof(integer)
			    );
		    e_wsle();
		}
	    }
	}
	if (bdmsh1_1.nbquad > 0) {
	    io___86.ciunit = nf;
	    s_wsle(&io___86);
	    do_lio(&c__9, &c__1, "Quadrangles", 11L);
	    e_wsle();
	    io___87.ciunit = nf;
	    s_wsle(&io___87);
	    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    i__2 = bdmsh1_1.nbt;
	    for (j = 1; j <= i__2; ++j) {
		nbselem = mshele_(&j, lsomm, ra4);
		if (nbselem == 4) {
		    io___88.ciunit = nf;
		    s_wsle(&io___88);
		    i__4 = nbselem;
		    for (i = 1; i <= i__4; ++i) {
			do_lio(&c__3, &c__1, (char *)&lsomm[i - 1], (ftnlen)
				sizeof(integer));
		    }
		    do_lio(&c__3, &c__1, (char *)&bdmshf_1.refsd[
			    bdmsha_1.reft[j - 1] - 1], (ftnlen)sizeof(integer)
			    );
		    e_wsle();
		}
	    }
	}
	io___89.ciunit = nf;
	s_wsle(&io___89);
	do_lio(&c__9, &c__1, "End", 3L);
	e_wsle();
    } else if (s_cmp(type, ".nopo", 80L, 5L) == 0) {
/* old        call ecrnop(tri,nbtmx*2+1,nf,err) */
/* --      verif ref ssd */
	j = 0;
	i__2 = bdmsh1_1.nbsd;
	for (i = 1; i <= i__2; ++i) {
	    if (bdmshf_1.refsd[i - 1] == 0 && bdmshf_1.refsd[i - 1] != 
		    -1073741824 && bdmsh2_1.tetsd[bdmshj_1.ptorsd[i - 1] - 1] 
		    > 0) {
		++j;
	    }
	}
	if (j != 0) {
L20:
/*       call intext('Be carefull some ref. domain are equal to 0 
 '    #GB*/
/*   +    // '(Bug in comaco), do you continue (y,n)  ',10,yes,i) 
      #GB*/
	    intext_("Attention , il y a des ref de sous domaine nulle (Bug d"
		    "ans comaco), On continue  (o,n)  ", &c__10, yes, &i, 88L, 
		    10L);
	    if (i != 1) {
		goto L20;
	    } else if (*yes == 'n' || *yes == 'N') {
/*          on ne fait rien */
	    } else if (*yes != 'y' && *yes != 'Y' && *yes != 'o' && *yes != 
		    'O') {
		goto L20;
	    } else {
		ecrnop_(bdwrk1_1.work, &bdmsh0_1.lwork, &nf, &err);
	    }
	} else {
	    ecrnop_(bdwrk1_1.work, &bdmsh0_1.lwork, &nf, &err);
	}
    } else if (s_cmp(type, ".am", 80L, 3L) == 0) {
	io___91.ciunit = nf;
	s_wsue(&io___91);
	do_uio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
	do_uio(&c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	e_wsue();
	io___92.ciunit = nf;
	s_wsue(&io___92);
	i__2 = bdmsh1_1.nbt;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_uio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	}
	i__4 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_uio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	}
	i__5 = bdmsh1_1.nbt;
	for (i = 1; i <= i__5; ++i) {
	    do_uio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	i__6 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__6; ++i) {
	    i__7 = rfsomm_(&i);
	    do_uio(&c__1, (char *)&i__7, (ftnlen)sizeof(integer));
	}
	e_wsue();
    } else if (s_cmp(type, ".am_fmt", 80L, 7L) == 0) {
	io___93.ciunit = nf;
	s_wsle(&io___93);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "  -- nbs,nbt ", 13L);
	e_wsle();
	io___94.ciunit = nf;
	s_wsfe(&io___94);
	i__2 = bdmsh1_1.nbt;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	}
	e_wsfe();
	io___95.ciunit = nf;
	s_wsfe(&io___95);
	i__2 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	}
	e_wsfe();
	io___96.ciunit = nf;
	s_wsfe(&io___96);
	i__2 = bdmsh1_1.nbt;
	for (i = 1; i <= i__2; ++i) {
	    do_fio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	e_wsfe();
	io___97.ciunit = nf;
	s_wsfe(&io___97);
	i__2 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__2; ++i) {
	    i__4 = rfsomm_(&i);
	    do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else if (s_cmp(type, ".msh", 80L, 4L) == 0) {
	io___98.ciunit = nf;
	s_wsle(&io___98);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nba, (ftnlen)sizeof(integer));
	e_wsle();
	io___99.ciunit = nf;
	s_wsfe(&io___99);
	i__4 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	    i__2 = rfsomm_(&j);
	    do_fio(&c__1, (char *)&i__2, (ftnlen)sizeof(integer));
	}
	e_wsfe();
	io___100.ciunit = nf;
	s_wsfe(&io___100);
	i__2 = bdmsh1_1.nbt;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	    do_fio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[j - 1] - 1], (ftnlen)sizeof(
		    integer));
	}
	e_wsfe();
	io___101.ciunit = nf;
	s_wsfe(&io___101);
	i__2 = bdmsh1_1.nba;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmshc_1.aretbd[i + (j << 1) - 3], (
			ftnlen)sizeof(integer));
	    }
	    i__5 = -j;
	    i__4 = rfaret_(&c__0, &i__5);
	    do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else if (s_cmp(type, ".ftq", 80L, 4L) == 0) {
	io___102.ciunit = nf;
	s_wsle(&io___102);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	i__4 = bdmsh1_1.nbtria + bdmsh1_1.nbquad;
	do_lio(&c__3, &c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(integer)
		);
	e_wsle();
	i__4 = bdmsh1_1.nbt;
	for (j = 1; j <= i__4; ++j) {
	    nbselem = mshele_(&j, lsomm, ra4);
	    if (nbselem != 0) {
		io___103.ciunit = nf;
		s_wsle(&io___103);
		do_lio(&c__3, &c__1, (char *)&nbselem, (ftnlen)sizeof(integer)
			);
		i__5 = nbselem;
		for (i = 1; i <= i__5; ++i) {
		    do_lio(&c__3, &c__1, (char *)&lsomm[i - 1], (ftnlen)
			    sizeof(integer));
		}
		do_lio(&c__3, &c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[j 
			- 1] - 1], (ftnlen)sizeof(integer));
		e_wsle();
	    }
	}
	io___104.ciunit = nf;
	s_wsfe(&io___104);
	i__4 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	    i__5 = rfsomm_(&j);
	    do_fio(&c__1, (char *)&i__5, (ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else if (s_cmp(type, ".amdba", 80L, 6L) == 0) {
	io___105.ciunit = nf;
	s_wsle(&io___105);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "  -- nbs,nbt ", 13L);
	e_wsle();
	io___106.ciunit = nf;
	s_wsfe(&io___106);
	i__5 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__5; ++i) {
	    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
	    for (j = 1; j <= 2; ++j) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[j + (bdmsh6_1.nsorig[i - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	    i__4 = rfsomm_(&i);
	    do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	}
	e_wsfe();
	io___107.ciunit = nf;
	s_wsfe(&io___107);
	i__4 = bdmsh1_1.nbt;
	for (j = 1; j <= i__4; ++j) {
	    do_fio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	    do_fio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[j - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else {
/* Writing concatenation */
	i__8[0] = 29, a__3[0] = "ERREUR ecrmsh dans les types ";
	i__8[1] = ii - 1, a__3[1] = type + 1;
	s_cat(ch__1, a__3, i__8, &c__2, 109L);
	scrtch_(ch__1, ii + 28);
	err = 1;
    }
    if (err != 0) {
	scrtch_("ERREUR generation pas assez de place memoire", 44L);
	cl__1.cerr = 0;
	cl__1.cunit = nf;
	cl__1.csta = "delete";
	f_clos(&cl__1);
    } else {
	cl__1.cerr = 0;
	cl__1.cunit = nf;
	cl__1.csta = 0;
	f_clos(&cl__1);
    }
    chtrgl_();
    return 0;
} /* ecrmsh_ */

#undef tri
#undef coulls
#undef xwork


/* Subroutine */ int rdmesh_(integer *nf, integer *refpts, integer *nbt1, 
	integer *nbs1, integer *nba1, integer *nbsd1, integer *nbd3, integer *
	err)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_rsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_rsfe(void), i_indx(char *, char *, ftnlen, ftnlen), s_rsle(
	    cilist *), e_rsle(void);

    /* Local variables */
#define xwork ((real *)bdwrk1_1.work)
    static char ligne[80];
    static integer i, j, k;
#define coulls ((integer *)&ctabco_1)
#define tri ((integer *)&bdwrk1_1)
    static integer nbe, ftq[5];

    /* Fortran I/O blocks */
    static cilist io___111 = { 0, 6, 0, 0, 0 };
    static cilist io___112 = { 1, 0, 1, "(a)", 0 };
    static cilist io___114 = { 0, 6, 0, 0, 0 };
    static cilist io___115 = { 0, 6, 0, 0, 0 };
    static cilist io___116 = { 0, 6, 0, 0, 0 };
    static cilist io___117 = { 1, 0, 1, "(a)", 0 };
    static cilist io___118 = { 0, 6, 0, 0, 0 };
    static cilist io___119 = { 1, 0, 1, 0, 0 };
    static cilist io___121 = { 0, 6, 0, 0, 0 };
    static cilist io___122 = { 1, 0, 1, 0, 0 };
    static cilist io___124 = { 1, 0, 1, 0, 0 };
    static cilist io___126 = { 1, 0, 1, 0, 0 };
    static cilist io___127 = { 1, 0, 1, 0, 0 };
    static cilist io___128 = { 1, 0, 1, 0, 0 };
    static cilist io___130 = { 1, 0, 1, 0, 0 };
    static cilist io___132 = { 1, 0, 1, 0, 0 };
    static cilist io___133 = { 1, 0, 1, 0, 0 };
    static cilist io___134 = { 0, 6, 0, 0, 0 };
    static cilist io___135 = { 0, 6, 0, 0, 0 };
    static cilist io___136 = { 0, 6, 0, 0, 0 };


/* ================================================= */
/* c%include 'emc2_cr8.ins' */
/* ----- expendue pour eviter plus pb de transformation -------- */
/*   F. Hecht le  10/89 --------- */
/* ------------------ */
/*     definition des structures des donnees */
/*     point   p(0:3) : p(0)=0.  p(1)=x  p(2)=y */
/*     droite  d(0:3) : d(0)=-1. d(1)=a  d(2)=b  d(3)=c */
/*     cercle  c(0:3) : c(0)=r>0 c(1)=cx c(2)=cy */
/*    arc     a(0:5) : a(0)=-2. a(1)=cx a(2)=cy a(3)=px a(4)=py a(5)=angle
*/
/*     segment s(0:4) : s(0)=-3. s(1)=x1 s(2)=y1 s(3)=x2 s(4)=y2 */
/*     vide    v(0:3) : v(0)=-1000. */

/*          eps relatif a la boite de travail (calcule par qboite) */
/* ------- fin de l'expantion --------------- */
/*                        nombre maxi de menus */
/*                        nombre maxi de cases des menus */
/*               masque de travail (xmin,xmax,ymin,ymax) */
/*               masque auto (pour voir tout objet  (xmin,xmax,ymin,ymax) 
*/
/*               pour flip flop designation par touches */
/*               device de travail */
/*               parametres suplementaires du terminal en sortie */
/*               parametres suplementaires du terminal en entree */
/*               appli =application courante, peut valoir: */
/*               calcu = 1 si calculette */
/*               calcu = 0 si pas calculette */
/*               fenetre de travail (ou l'on affiche les objets) */
/*                     (xmin,xmax,ymin,ymax) c.m. */
/*               taille de l'ecran (xmin,xmax,ymin,ymax) c.m. */
/*               couleur de l'ecran */
/*               fenetre reservee pour: */
/*                  - afficher l'etat de certaines variables */
/*                  - ecrire une ligne de scratch (messages systeme) */
/*              couleur fenetre reservee */
/*              fenetres de travail reservees */
/*              couleur fenetre de travail (1)= bas   (2)= haut */
/*              couleur de trace des objets arc, seg,... (vert) */
/*              couleur de trace d'autres elements points,...(rouge) */
/*                       ------ pour les menus ------ */
/*              fenetre de chacun des menus (xmin,xmax,ymin,ymax) c.m. */
/*             (nombre de lignes, nombre colonnes) de chacun des menus */
/*             valeurs retournees pas les cases de chacun des menus */
/*                     (on trace les lignes en premier) */
/*             menus actifs  (true si actif false sinon) */
/*             activation des cases de chacun des menus */
/*                    si = .true.  case active */
/*                       = .false. case inactive */
/*             marquage des cases des menus: */
/*           vmark marque en v */
/*           cmark marque en carre plein */
/*           qmark marque en pomme */
/*           unmark demarque la case */
/*              les valeurs correspondent a celles du mac. */
/*           caracteres correspondants */
/*              couleur de chacun des menus */
/*              taille des caracteres du menu */
/* -----------------------------------------------------------------------
 */
/*              texte des cases de chacun des menus */
/*              texte donnant le nom de chacun des menus */
/* -----------------------------------------------------------------------
 */
/*     taille maxi de la pile circulaire des masques */
/*            ------ pour la gestion de l'ecran ------- */
/*             pile circulaire des masques  (mxmsq) */
/*             pointeur courant sur la pile circulaire des masques */
/* -----------------------------------------------------------------------
 */
/*                    ------ pour l'etat du systeme ------ */
/*              scrtc=.true. si ligne de scratch ecrite */
/*              pour application construction */
/*              pour application 2 */
/*           taille dx,dy,x,y de la boite de travail : permet de calculer 
*/
/*           un eps ad hoc et non haddock (pour hecht tintin n'est pas la)
 */
/*              pour application 3 */
/*     cosmnt = cos de la borne inf des angles des triangles */
/*     cosmxt = cos de la borne sup des angles des triangles */
/*     cosmnt = cos de la borne inf des angles des quadrangles */
/*     cosmxt = cos de la borne sup des angles des quadrangles */
/*     mkelem = .true. => marquage des element ayant un angle */
/*                         hors des limites */
/*     bgptf = .true. => on peut bouger les points frontieres */
/* -----------------------------------------------------------------------
 */
/*           epaisseur des traits en mm. */
/*           epafac= epaisseure des traits effaces sur tektro */
/* -----------------------------------------------------------------------
 */
/*                   data rendues par le scan0 (scanner de design) */
/*           mode de contrainte (plupro | extrem | centre | milieu ) */
/*           vlmenu=(la valeur associee a la case) si on a pointe un menu 
*/
/*           vlmenu=(coord,p,d,c,a,s,sommet,triang,arete,sous_dom) */
/*               si on a pointe dans la fenetre de travail */
/*             et x,y sont les coordonnees du point designe */
/*                si le resultat de la designation est un point . */
/*             et xdesig,ydesig sont les coordonnees du pointe */
/*               dans masque (utilisateur). */
/*            adr= adresse dans la bd de l"element ou de son support */
/*              adr = nil si coord et pas de contrainte */

/*            (nucase) numero de la case designe du menu (numenu). */
/*            numer valeur numerique. */

/*            types des pointes */
/*             mode de contrainte en designation */
/* -----------------------------------------------------------------------
 */
/*              adresse des element designer dans la bd_mshg */
/*              aireta(i) = 2* aire du triangle de sommet i,i+1(3),(x,y) 
*/
/* -----------------------------------------------------------------------
 */
/*                    trace et interpretation */
/*              nombre maxi de d'imbrication de fichiers a interpretes */
/*             trace=numero etiquette de la trace si =0 pas de trace */
/*             interp=numero etiquette de l'interpretation */
/*                 si =0 pas d'interpretation */
/*             ptintr=numero courant du fichier a interpreter */
/*                 si =0 alors getxy */
/*            tracex nom du fichier de trace */
/* -----------------------------------------------------------------------
 */
/*                      definition  de la bd......... */
/*          nbnode:nombre de noeuds */
/*          raison:raison */
/*          nuref :numero de reference de l'element      (droit et gauche)
 */
/*          nuref1:numero de reference de l'extremitee 1 (droit et gauche)
 */
/*          nuref2:numero de reference de l'extremitee 2 (droit et gauche)
 */
/*          adp1,adp2: adresse des points extremitees 1 ou 2 de l'element 
*/
/*          fissur:indique si l'element est fissure */
/*          adjabd: tete de liste des adjacents */
/*         conx  : chainage circulaire des elements des composantes connex
es*/
/*                  gauche  et droite aux quelles appartient l'element */
/*         cnx   : indique quelle chainage des composantes connexes il fau
t*/
/*                  prendre pour la suite de conx */
/*          compos: pointeurs inverses vers les 2 composantes aux quelles 
*/
/*                  appartient l'element */

/*          typebd: type de la bd (const,apli2,apli3,...) */
/*          comp  : tete de la liste de toutes les composantes */
/*          sdomn ; tete de la liste des sous domaines */
/*          link  : tete de la liste des elements en suivants */
/*  ............................. parametres pour la bd ................. 
*/
/*          taille maxi de la bd */
/*      parameter(mxbd=5000) */
/*          partie reservee de la bd (en adresse negative) */
/* .......................................................................
 */
/*               1: ptbd  = fin de la bd de application construction */
/*          ptbd+1:finbd  = point extremite pour application 2 */
/*         finbd+1:finbd3 = element genere par application 3 */
/*                  ( par les transformation) */
/* -----------------------------------------------------------------------
 */
/*           nombre maxi de noeuds sur un element de bd */
/*           nombre maxi de points de definition pour une spline */
/*           nombre maxi de points generes sur la spline */
/*           decoupage en quadrangles ou quadrangles decoupes en triangles
 */

/* ----------------- parametre de l'application 3 ------------------------
 */

/*      parameter(nbpmxx=15000,nbamxx=5000,nbtmxx=2*nbpmxx-2,nbsdmxx=1000 
*/
/*     +         ,lwork=11*nbpmxx+nbtmxx) */
/*      la variable ibidon pour l'alignement */
/*      les sommets */
/*      les elements */
/*     les aretes */
/*      les sous domaines */
/*-----------------------------------------------------------------------
-*/
/*  - nbs : nb de sommets */
/*  - nbsrft nb de sommets ref par la triangulation */
/*  - nbtrou nb de trou dans le maillage */
/*  - nbt : nb de triangles */
/*  - nba : nb d'arete frontiere */

/*  - cr(1:2,nbs): coordonnees du  sommet i */
/*  - abcurv(i)  :abscisse curviligne du sommet i si il est interne a */
/*      une ligne de support sinon on a nul. */
/*  - refs(i)    : adresse dans la bd du support d sommet i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - nsorig(i)  : numero du sommet origine */
/*      (si il n'y a pas de fissure nsorig(i)=i */
/*      sinon nsorign(i) donne le sommet dupliquer) */

/*  - nsea(1:3,ie) : les 3 numeros des 3 sommets de du triangle ie */
/*      tournant dans le sens direct */
/*  - nsea(4:6,ie) : (d4,d5,d6) donnee des 3 aretes ai */
/*      ai est forme des sommets nsea(i-3,ie),nsea(mod(i,3)+1,ie) */
/*      si di < 0 alors arete i est frontiere et -di est pointeur */
/*        de l'arete dans aretbd */
/*      sinon arete est interne et di = 8*ta + ata */
/*        ou ta est le numero du triangle adjacent a l'arete */
/*        et ata est le numero de l'arete dans ta */
/*  - reft(ie) : numero de ref du triangle ie ou chainage des */
/*      triangles d'un sous domaine reft(ie) traingle suivant */
/*  - anovue(ie): tableau donnant les aretes non vue du triangle ie */
/*      anovue(ie) = 0 => tout les aretes sont vue */
/*      anovue(ie) = 1 => l'arete 4 n'est pas  vue */
/*      anovue(ie) = 2 => l'arete 5 n'est pas  vue */
/*      anovue(ie) = 3 => l'arete 6 n'est pas  vue */
/*      anovue(ie) = 4 => aucune aretes n'est vue */
/*           (il faut decoupe le triangle en 3 en ajoutant */
/*            un point au barycentre) */

/*  - aretbd(1:2,i) : les 2 sommets de l'arete i */
/*  - areadj(gauche:droite,i) : (d3,d4) meme definition que pour nsea */
/*  - refa(i) :  adresse dans la bd du support de l'arete i */
/*      (nul si il n'y a pas de support dans la bd) */
/*  - optdrw : option de tracer 0 => tout */
/*                              1 => pas de ref */

/* -----------------------------------------------------------------------
 */
/*  tableau de tavail */
/*     real h(nbpmx) */
/*      integer ci(2,nbpmx) */
/* -------------------------- extension des noms de fichiers ------------ 
*/
/*        bd_emc2 */
/*        bd_emc2.bak */
/*        data */
/*        nopo */
/*        mesh */
/*        msh_emc2   l'ancien format .mesh de Hetch */
/*        am */
/*        amfmt */
/*        amdba */
/*        trace */
/*        base */
/*        set, */
/*        cnet */
/* ------------------------------------------------------------------- */
/* ................................. fin  ................................
 */
/* ==================================================== */
/* %include 'cmmlistes.ins' */
/*              externals pour les listes */
/*     taille des tableaux  car et  cdr */
/*              subroutines de gestion de listes */
/*     inilst */
/*     back */
/*     freel */
/*     get */
    s_wsle(&io___111);
    do_lio(&c__9, &c__1, "Lecture  .mesh", 14L);
    e_wsle();
    io___112.ciunit = *nf;
    i__1 = s_rsfe(&io___112);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_fio(&c__1, ligne, 80L);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsfe();
    if (i__1 != 0) {
	goto L1000;
    }
    s_wsle(&io___114);
    do_lio(&c__9, &c__1, ">>>>", 4L);
    do_lio(&c__9, &c__1, ligne, 80L);
    e_wsle();
    if (i_indx(ligne, "MeshVersionFormatted", 80L, 20L) == 0) {
	s_wsle(&io___115);
	do_lio(&c__9, &c__1, " Mauvaise premiere ligne", 24L);
	e_wsle();
	s_wsle(&io___116);
	do_lio(&c__9, &c__1, ">>> \"", 5L);
	do_lio(&c__9, &c__1, ligne, 80L);
	do_lio(&c__9, &c__1, "\" <<<", 5L);
	e_wsle();
	goto L1000;
    }
L9999:
    io___117.ciunit = *nf;
    i__1 = s_rsfe(&io___117);
    if (i__1 != 0) {
	goto L100013;
    }
    i__1 = do_fio(&c__1, ligne, 80L);
    if (i__1 != 0) {
	goto L100013;
    }
    i__1 = e_rsfe();
L100013:
    if (i__1 < 0) {
	goto L2000;
    }
    if (i__1 > 0) {
	goto L1000;
    }
    s_wsle(&io___118);
    do_lio(&c__9, &c__1, ">>>>", 4L);
    do_lio(&c__9, &c__1, ligne, 80L);
    e_wsle();
    if (i_indx(ligne, "Dimension", 80L, 9L) != 0) {
	io___119.ciunit = *nf;
	i__1 = s_rsle(&io___119);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsle();
	if (k != 2) {
	    s_wsle(&io___121);
	    do_lio(&c__9, &c__1, " mauvaise dimension", 19L);
	    do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    e_wsle();
	    goto L1000;
	}
	goto L9999;
    } else if (i_indx(ligne, "Vertices", 80L, 8L) != 0) {
	io___122.ciunit = *nf;
	i__1 = s_rsle(&io___122);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&(*nbs1), (ftnlen)sizeof(integer))
		;
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsle();
	*nbs1 = bdmsh1_1.nbs + *nbs1;
	if (*nbs1 > bdmsh0_1.nbpmx) {
	    *err = 1;
	    return 0;
	}
	i__1 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__1; ++j) {
	    io___124.ciunit = *nf;
	    i__2 = s_rsle(&io___124);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	}
	goto L9999;
    } else if (i_indx(ligne, "Edges", 80L, 5L) != 0) {
	io___126.ciunit = *nf;
	i__1 = s_rsle(&io___126);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&(*nba1), (ftnlen)sizeof(integer))
		;
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsle();
	*nba1 = bdmsh1_1.nba + *nba1;
	if (*nba1 > bdmsh0_1.nbamx) {
	    *err = 1;
	    return 0;
	}
	i__1 = *nba1;
	for (j = bdmsh1_1.nba + 1; j <= i__1; ++j) {
	    io___127.ciunit = *nf;
	    i__2 = s_rsle(&io___127);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmshc_1.aretbd[i + (j <<
			 1) - 3], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmshe_1.refa[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	}
	goto L9999;
    } else if (i_indx(ligne, "Triangles", 80L, 9L) != 0) {
	io___128.ciunit = *nf;
	i__1 = s_rsle(&io___128);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&nbe, (ftnlen)sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsle();
	*nbt1 = bdmsh1_1.nbt;
	if (*nbt1 + nbe > bdmsh0_1.nbtmx) {
	    *err = 1;
	    return 0;
	}
	i__1 = nbe;
	for (j = 1; j <= i__1; ++j) {
	    io___130.ciunit = *nf;
	    i__2 = s_rsle(&io___130);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 4; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&ftq[i - 1], (ftnlen)
			sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = e_rsle();
	    ++(*nbt1);
	    bdmsh9_1.nsea[*nbt1 * 6 - 6] = ftq[0];
	    bdmsh9_1.nsea[*nbt1 * 6 - 5] = ftq[1];
	    bdmsh9_1.nsea[*nbt1 * 6 - 4] = ftq[2];
	    bdmsha_1.reft[*nbt1 - 1] = ftq[3];
	    bdmshb_1.apavue[*nbt1 - 1] = 0;
	}
	goto L9999;
    } else if (i_indx(ligne, "Quadrangles", 80L, 11L) != 0) {
	io___132.ciunit = *nf;
	i__1 = s_rsle(&io___132);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&nbe, (ftnlen)sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsle();
	*nbt1 = bdmsh1_1.nbt;
	if (*nbt1 + (nbe << 1) > bdmsh0_1.nbtmx) {
	    *err = 1;
	    return 0;
	}
	i__1 = nbe;
	for (j = 1; j <= i__1; ++j) {
	    io___133.ciunit = *nf;
	    i__2 = s_rsle(&io___133);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__3, &c__5, (char *)&ftq[0], (ftnlen)sizeof(
		    integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	    ++(*nbt1);
	    bdmsh9_1.nsea[*nbt1 * 6 - 6] = ftq[0];
	    bdmsh9_1.nsea[*nbt1 * 6 - 5] = ftq[1];
	    bdmsh9_1.nsea[*nbt1 * 6 - 4] = ftq[2];
	    bdmsha_1.reft[*nbt1 - 1] = ftq[4];
	    bdmshb_1.apavue[*nbt1 - 1] = 3;
	    ++(*nbt1);
	    bdmsh9_1.nsea[*nbt1 * 6 - 6] = ftq[0];
	    bdmsh9_1.nsea[*nbt1 * 6 - 5] = ftq[2];
	    bdmsh9_1.nsea[*nbt1 * 6 - 4] = ftq[3];
	    bdmsha_1.reft[*nbt1 - 1] = ftq[4];
	    bdmshb_1.apavue[*nbt1 - 1] = 1;
	}
	goto L9999;
    } else {
	s_wsle(&io___134);
	do_lio(&c__9, &c__1, "\"", 1L);
	do_lio(&c__9, &c__1, ligne, 80L);
	do_lio(&c__9, &c__1, "\"", 1L);
	e_wsle();
	goto L9999;
    }
L1000:
    *err = 1;
    s_wsle(&io___135);
    do_lio(&c__9, &c__1, "ERREUR de lecture .mesh ", 24L);
    e_wsle();
    return 0;
L2000:
    *err = 0;
    s_wsle(&io___136);
    do_lio(&c__9, &c__1, "OK Fin lecture .mesh", 20L);
    e_wsle();
    return 0;
} /* rdmesh_ */

#undef tri
#undef coulls
#undef xwork


