#include <assert.h>
#include <stdlib.h>
#include "emc2_h.h"

/* Subroutine */ int acnt_(real *ar, real *cc)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double r_mod(real *, real *);

    /* Local variables */
    extern /* Subroutine */ int draw_(real *);
    real pvct;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    real dist1, dist2;

    extern doublereal atang2_(real *, real *);
    real p1[4], p2[4], a1, a0;
    extern doublereal dtp1xx_(real *, real *);
    real tg[2];
    real pp[4], tg1[2], tg2[2], dx, dy;

    /* Fortran I/O blocks */
    static cilist io___17 = { 0, 6, 0, 0, 0 };



/*      on sait que l'arc ar est tangent a l'objet cc */
/*     pour faire un bel arrondi, elle modifie cc */
/*        ceci ne peut se faire que si cc a pour type arc ou segment */


/*     premier point de l'arc */
    p1[0] = 0.f;
    p1[1] = ar[3];
    p1[2] = ar[4];
/*     deuxieme point de l'arc */
    dx = ar[3] - ar[1];
    dy = ar[4] - ar[2];
    p2[0] = 0.f;
    p2[1] = ar[1] + dx * cos(ar[5]) - dy * sin(ar[5]);
    p2[2] = ar[2] + dx * sin(ar[5]) + dy * cos(ar[5]);
/*     distances de p1 et p2 a cc */
    dist1 = dtp1xx_(p1, cc);
    dist2 = dtp1xx_(p2, cc);
/*     tangentes aux extremitees de l'arc ar (orientees vers son exterieu 
*/
    tg1[0] = p1[2] - ar[2];
    tg1[1] = -(doublereal)(p1[1] - ar[1]);
    tg2[0] = -(doublereal)(p2[2] - ar[2]);
    tg2[1] = p2[1] - ar[1];
    if (ar[5] < 0.f) {
	tg1[0] = -(doublereal)tg1[0];
	tg1[1] = -(doublereal)tg1[1];
	tg2[0] = -(doublereal)tg2[0];
	tg2[1] = -(doublereal)tg2[1];
    }
/*     pp,tg point et la tangente en ce point qui est le plus proche de c 
*/
    pp[0] = 0.f;
    if (dist1 < dist2) {
	pp[1] = p1[1];
	pp[2] = p1[2];
	tg[0] = tg1[0];
	tg[1] = tg1[1];
    } else {
	pp[1] = p2[1];
	pp[2] = p2[2];
	tg[0] = tg2[0];
	tg[1] = tg2[1];
    }
    if (cc[0] == -3.f) {
/*        print*,'cc est un segment',cc(1),cc(2),cc(3),cc(4) */
	ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	draw_(cc);
	if ((cc[1] - pp[1]) * tg[0] + (cc[2] - pp[2]) * tg[1] > 0.f) {
	    cc[3] = pp[1];
	    cc[4] = pp[2];
	} else {
	    cc[1] = pp[1];
	    cc[2] = pp[2];
	}
	ligh3_(&c_n1, &c_n1, &pec_1.colove);
	draw_(cc);
    } else if (cc[0] == -2.f) {
/*        print*,'cc est un arc',cc(1),cc(2),cc(3),cc(4),cc(5) */
	ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	draw_(cc);
	r__1 = pp[2] - cc[2];
	r__2 = pp[1] - cc[1];
	a0 = atang2_(&r__1, &r__2);
	r__1 = cc[4] - cc[2];
	r__2 = cc[3] - cc[1];
	a1 = atang2_(&r__1, &r__2);
/*       on rend a0 et a1 de meme signe ( >0) */
	if (a0 < 0.f) {
	    a0 += 6.283185306f;
	}
	if (a1 < 0.f) {
	    a1 += 6.283185306f;
	}
	pvct = (pp[1] - cc[1]) * tg[1] - (pp[2] - cc[2]) * tg[0];
	s_wsle(&io___17);
	do_lio(&c__9, &c__1, "acnt:a0=", 8L);
	do_lio(&c__4, &c__1, (char *)&a0, (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " a1=", 4L);
	do_lio(&c__4, &c__1, (char *)&a1, (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " pvct=", 6L);
	do_lio(&c__4, &c__1, (char *)&pvct, (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " cc(5)=", 7L);
	do_lio(&c__4, &c__1, (char *)&cc[5], (ftnlen)sizeof(real));
	e_wsle();
	if (pvct > 0.f) {
	    if (cc[5] > 0.f) {
/*           on bouge le point p1 de cc */
		cc[3] = pp[1];
		cc[4] = pp[2];
		r__2 = (r__1 = cc[5] + a1 - a0, dabs(r__1));
		cc[5] = r_mod(&r__2, &c_b28);
	    } else {
/*           on bouge le point p2 de cc (c'est a dire rien que
 l'angle) */
		if (a1 - a0 < 0.f) {
		    cc[5] = -(doublereal)(a1 - a0 + 6.283185306f);
		} else {
		    r__1 = a1 - a0;
		    cc[5] = -(doublereal)r_mod(&r__1, &c_b28);
		}
	    }
	} else {
	    if (cc[5] > 0.f) {
/*           on bouge le point p2 de cc (c'est a dire rien que
 l'angle) */
		if (a0 - a1 < 0.f) {
		    cc[5] = a0 - a1 + 6.283185306f;
		} else {
		    r__1 = a0 - a1;
		    cc[5] = r_mod(&r__1, &c_b28);
		}
	    } else {
/*           on bouge le point p1 de cc */
		cc[3] = pp[1];
		cc[4] = pp[2];
		r__2 = (r__1 = cc[5] - a0 + a1, dabs(r__1));
		cc[5] = -(doublereal)r_mod(&r__2, &c_b28);
	    }
	}
	ligh3_(&c_n1, &c_n1, &pec_1.colove);
	draw_(cc);
    }
    return 0;
} /* acnt_ */




/* Subroutine */ int acursp_(real *x, real *y, integer *nn, real *eps, real *
	acurv, integer *nbacur, real *fx, real *fy)
{
    /* Initialized data */

    static real m[16]	/* was [4][4] */ = { 2.f,-2.f,1.f,1.f,-3.f,3.f,-2.f,
	    -1.f,0.f,0.f,1.f,0.f,1.f,0.f,0.f,0.f };

    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real cold, scal, cnew, xold, yold, step, xnew, ynew, a, c[3], d;
    integer i, j, k, l, n;
    real * p /*[1002]	/* was [501][2] */, t, w[12]	/* was [4][3] */, 
	    cumul, dd, lambda;
    integer nd;
    real tg[6]	/* was [2][3] */, tt;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    real normal[3];
    integer ptacur;
    real longsp;
    integer option;
    real ddd;

    /* Fortran I/O blocks */
    static cilist io___49 = { 0, 6, 0, 0, 0 };
    static cilist io___50 = { 0, 6, 0, 0, 0 };
    assert(p = (real *) malloc(1002*sizeof(real)));

/* =======================================================================
 */

/* but : rend les coordonnees 'fx,fy' des 'nbacur' points dont on connait 
*/
/*       curvilignes 'acurv' sur la spline  (0...1) */

/* parametres d'entree : x      : tableau des abcisses des points de cont 
*/
/* --------------------- y      : tableau des ordonnees des points de con 
*/
/*                       nn     : nombre de points */
/*                       eps    : les reels egaux a eps pres sont pris eg 
*/
/*                       acurv  : tableau des abscisses curvilignes ( ord 
*/
/*                       nbacur : taille du tableau acurv */

/* parametres de sortie : fx,fy : tableaux des coordonnees des points d'a 
*/
/*                                curvilignes  acurv */


/* auteur :     saltel eric modulef 16/7/92c */
/* -------- */



/*           nombre maxi de noeuds sur un element de bd */
/*           nombre maxi de points de definition pour une spline */
/*           nombre maxi de points generes sur la spline */
/*      real densit,xgen(maxgen),ygen(maxgen) */
/*      integer nbgen,tgen(1:mxpdef) */
    /* Parameter adjustments */
    --fy;
    --fx;
    --acurv;

    /* Function Body */
/*     longueur de la spline */
    option = 0;
/*     Calcul de la longeur */
/*     --------------------- */
    longsp = 0.f;
/* W      densit=1. */
/* W7     continue */
/* W      call genspl(x,y,nn,eps,densit,xgen,ygen,maxgen */
/* W     +                                   ,nbgen,tgen) */
/* W      if(nbgen.ge.maxgen)then */
/* W        densit=densit/2. */
/* W        goto 7 */
/* W      endif */
/* W      do 4 i=1,nbgen-1 */
/* W       longsp=longsp+sqrt((xgen(i)-xgen(i+1))**2+(ygen(i)-ygen(i+1))**
 */
/* W4     continue */
/* W */
    n = *nn;
    if (n >= 500) {
/*       ERREUR */
	scrtch_("ERREUR:ACURSP: SPLINE AVEC TROP DE POINTS. ON TRONQUE...", 
		56L);
	n = 499;
    }
    i__1 = n;
    for (i = 1; i <= i__1; ++i) {
	p[i] = x[i];
	p[i + 501] = y[i];
/* L87655: */
    }
    step = .1f;
/*     teste si courbe fermee */
/* Computing 2nd power */
    r__1 = p[1] - p[n];
/* Computing 2nd power */
    r__2 = p[502] - p[n + 501];
    if (sqrt(r__1 * r__1 + r__2 * r__2) <= *eps) {
/*       courbe fermee, on rajoute en 0 le point n-1 */
/*       courbe fermee, on rajoute en n+1 le point 2 */
	for (i = 1; i <= 2; ++i) {
	    p[i * 501 - 501] = p[n - 1 + i * 501 - 501];
	    p[n + 1 + i * 501 - 501] = p[i * 501 - 499];
/* L87656: */
	}
    } else {
	if (n == 2) {
	    for (i = 1; i <= 2; ++i) {
/*           on rajoute un point p(0) virtuel symetrique de p(
2) */
/*                           / point p(1) */
		p[i * 501 - 501] = p[i * 501 - 500] * 2.f - p[i * 501 - 499];
/*           on rajoute un point  p(n+1) virtuel symetrique de
 p(n-1) */
/*                           / point p(n) */
		p[n + 1 + i * 501 - 501] = p[n + i * 501 - 501] * 2.f - p[n - 
			1 + i * 501 - 501];
/* L87657: */
	    }
	} else {
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(1),p(2) */
/* Computing 2nd power */
		r__1 = p[i * 501 - 499] - p[i * 501 - 500];
		dd += r__1 * r__1;
/* L87658: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(1),p(2) */
		normal[i - 1] = (p[i * 501 - 499] - p[i * 501 - 500]) / dd;
/* L87659: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[i * 501 - 500] + p[i * 501 - 499]) * 
			.5f;
/*           produit scalaire   normal.p(3) */
		scal += normal[i - 1] * p[i * 501 - 498];
/* L87660: */
	    }
/*         on rajoute un point p(0) virtuel symetrique de p(3) */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[i * 501 - 501] = p[i * 501 - 498] - (d + scal) * 2.f * 
			normal[i - 1];
/* L87661: */
	    }
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(n-1),p(n) */
/* Computing 2nd power */
		r__1 = p[n - 1 + i * 501 - 501] - p[n + i * 501 - 501];
		dd += r__1 * r__1;
/* L87662: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(n-1),p(n) */
		normal[i - 1] = (p[n + i * 501 - 501] - p[n - 1 + i * 501 - 
			501]) / dd;
/* L87663: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[n - 1 + i * 501 - 501] + p[n + i * 
			501 - 501]) * .5f;
/*           produit scalaire normal.p(n-2) */
		scal += normal[i - 1] * p[n - 2 + i * 501 - 501];
/* L87664: */
	    }
/*         on rajoute un point p(n+1) virtuel symetrique de p(n-2)
 */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[n + 1 + i * 501 - 501] = p[n - 2 + i * 501 - 501] - (d + 
			scal) * 2.f * normal[i - 1];
/* L87665: */
	    }
	}
    }
L10:
/*     parcourt de la spline */
    cumul = 0.f;
    ptacur = 1;
    xold = p[1];
    yold = p[502];
/*     abscisse curviligne precedante */
    cold = 0.f;
/*     -- parcour des n-1 morceau ---- */
    i__1 = n - 1;
    for (i = 1; i <= i__1; ++i) {
/*       longueur de p(i),p(i+1) */
	d = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 1 + nd * 501 - 501];
	    d += r__1 * r__1;
/* L87667: */
	}
	d = sqrt(d);
/*       longueur de p(i+1),p(i-1) */
	dd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + 1 + nd * 501 - 501] - p[i - 1 + nd * 501 - 501];
	    dd += r__1 * r__1;
/* L87668: */
	}
	dd = sqrt(dd);
/*       longueur de p(i),p(i+2) */
	ddd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 2 + nd * 501 - 501];
	    ddd += r__1 * r__1;
/* L87669: */
	}
	ddd = sqrt(ddd);
	if (dd <= d * 1e-5f) {
	    dd = 1.f;
	}
	if (ddd <= d * 1e-5f) {
	    ddd = 1.f;
	}
/*       calcul des tangentes aux 2 points p(i) et p(i+1) */
/* Computing MIN */
	r__1 = d, r__2 = dd * .5f, r__1 = min(r__1,r__2), r__2 = ddd * .5f;
	a = dmin(r__1,r__2);
	for (nd = 1; nd <= 2; ++nd) {
	    tg[(nd << 1) - 2] = a * ((p[i + 1 + nd * 501 - 501] - p[i - 1 + 
		    nd * 501 - 501]) / dd);
	    tg[(nd << 1) - 1] = a * ((p[i + 2 + nd * 501 - 501] - p[i + nd * 
		    501 - 501]) / ddd);
/* L87670: */
	}
	for (nd = 1; nd <= 2; ++nd) {
	    for (k = 1; k <= 4; ++k) {
		w[k + (nd << 2) - 5] = 0.f;
		for (l = 1; l <= 2; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * p[i + l - 1 
			    + nd * 501 - 501];
/* L87673: */
		}
		for (l = 3; l <= 4; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * tg[l - 2 + (
			    nd << 1) - 3];
/* L87674: */
		}
/* L87672: */
	    }
/* L87671: */
	}
/* --- un arc de spline */
/*        do 87675 t=0.,1.-step+0.51*step,step */
	for (j = 0; j <= 10; ++j) {
	    t = step * j;
	    for (nd = 1; nd <= 2; ++nd) {
/* Computing 3rd power */
		r__1 = t, r__2 = r__1;
/* Computing 2nd power */
		r__3 = t;
		c[nd - 1] = r__2 * (r__1 * r__1) * w[(nd << 2) - 4] + r__3 * 
			r__3 * w[(nd << 2) - 3] + t * w[(nd << 2) - 2] + w[(
			nd << 2) - 1];
/* L87676: */
	    }
	    xnew = c[0];
	    ynew = c[1];
/* Computing 2nd power */
	    r__1 = xnew - xold;
/* Computing 2nd power */
	    r__2 = ynew - yold;
	    cumul += sqrt(r__1 * r__1 + r__2 * r__2);
/*  -- option = 0 => qnu de la longeur */
/*  -- option = 1 generation --- */
	    if (option == 1) {
/*          abscisse curviligne de xnew,ynew */
		cnew = cumul / longsp;
L1:
		if (acurv[ptacur] <= cnew) {
/*           acurv entre cold et cnew */
		    lambda = (acurv[ptacur] - cold) / (cnew - cold);
		    tt = t - (1.f - lambda) * step;
/* Computing 3rd power */
		    r__1 = tt, r__2 = r__1;
/* Computing 2nd power */
		    r__3 = tt;
		    fx[ptacur] = r__2 * (r__1 * r__1) * w[0] + r__3 * r__3 * 
			    w[1] + tt * w[2] + w[3];
/* Computing 3rd power */
		    r__1 = tt, r__2 = r__1;
/* Computing 2nd power */
		    r__3 = tt;
		    fy[ptacur] = r__2 * (r__1 * r__1) * w[4] + r__3 * r__3 * 
			    w[5] + tt * w[6] + w[7];
		    ++ptacur;
		    if (ptacur <= *nbacur) {
			goto L1;
		    } else { free(p);
			return 0;
		    }
		}
	    }
	    xold = xnew;
	    yold = ynew;
	    cold = cnew;
/* L87675: */
	}
/* L87666: */
    }
    longsp = cumul;
    ++option;
    if (option == 1) {
	goto L10;
    }
/*      if(ptacur.le.nbacur)then */
/*        print*,'ERREUR:ACURSP: N''A PAS PU TOUT TRAITER???' */
/*        call scrtch('ERREUR:ACURSP: N''A PAS PU TOUT TRAITER???') */
    s_wsle(&io___49);
    do_lio(&c__9, &c__1, "ptacur=", 7L);
    do_lio(&c__3, &c__1, (char *)&ptacur, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " nbacur=", 8L);
    do_lio(&c__3, &c__1, (char *)&(*nbacur), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " nn=", 4L);
    do_lio(&c__3, &c__1, (char *)&(*nn), (ftnlen)sizeof(integer));
    e_wsle();
    i__1 = *nbacur;
    for (i = 1; i <= i__1; ++i) {
	s_wsle(&io___50);
	do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "   acurv=", 9L);
	do_lio(&c__4, &c__1, (char *)&acurv[i], (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " fx=", 4L);
	do_lio(&c__4, &c__1, (char *)&fx[i], (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " fy=", 4L);
	do_lio(&c__4, &c__1, (char *)&fy[i], (ftnlen)sizeof(real));
	e_wsle();
    }
/*      endif */
     free(p);
    return 0;
} /* acursp_ */

doublereal acurxy_(integer *i, real *xx, real *yy, real *xxx, real *yyy)
{
    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2, r__3, r__4, r__5, r__6;

    /* Builtin functions */
    double r_mod(real *, real *), cos(doublereal), sin(doublereal), sqrt(
	    doublereal);

    /* Local variables */
    real long_, * xgen /*[2000]*/,* ygen/*[2000]*/;
    integer *tgen /*[500]*/;

    integer j, n, nbgen, k;
    extern doublereal atang2_(real *, real *);
    real ac;
    real dalpha, dx, dy, dxx, dyy, ang, ang1, ang2;
    integer ptt;
    real densit, *xsp/*[501]*/, *ysp/*[501]*/;
    extern /* Subroutine */ int genspl_(real *, real *, integer *, real *, 
	    real *, real *, real *, integer *, integer *, integer *);
/*	    [0-9][0-9][0-9][]]*/
   assert( xgen = (real*) malloc(sizeof(real)*2000));
   assert( ygen = (real*) malloc(sizeof(real)*2000));
   assert( tgen = (integer*) malloc(sizeof(integer)*500));
   assert( xsp = (real*) malloc(sizeof(real)*501));
   assert( ysp = (real*) malloc(sizeof(real)*501));
   
/*   le xx,yy est projete sur  l'element i (xxx,yyy) a l'abscisse curvili 
*/

    *xxx = *xx;
    *yyy = *yy;
    ret_val = 0.f;
/*      print *,'acurxy ',i,xx,yy */
    if (*i <= 0 || *i > bdmsh4_1.finbd3) { 
	 goto LE999;/*return ret_val;*/
    }
    if (bdpec2_1.bd[*i * 6 + 384] == -2.f) {
	dx = bdpec2_1.bd[*i * 6 + 387] - bdpec2_1.bd[*i * 6 + 385];
	dy = bdpec2_1.bd[*i * 6 + 388] - bdpec2_1.bd[*i * 6 + 386];
	dxx = *xx - bdpec2_1.bd[*i * 6 + 385];
	dyy = *yy - bdpec2_1.bd[*i * 6 + 386];
	ang1 = atang2_(&dyy, &dxx);
	ang2 = atang2_(&dy, &dx);
	r__1 = ang1 - ang2 + 6.283185306f;
	ang = r_mod(&r__1, &c_b28);
	if (bdpec2_1.bd[*i * 6 + 389] < 0.f) {
	    ret_val = ang - 6.283185306f;
	} else {
	    ret_val = ang;
	}
/* Computing MIN */
/* Computing MAX */
	r__3 = 0.f, r__4 = ang / bdpec2_1.bd[*i * 6 + 389];
	r__1 = 1.f, r__2 = dmax(r__3,r__4);
	ret_val = dmin(r__1,r__2);
	dalpha = bdpec2_1.bd[*i * 6 + 389] * ret_val;
	*xxx = bdpec2_1.bd[*i * 6 + 385] + dx * cos(dalpha) - dy * sin(dalpha)
		;
	*yyy = bdpec2_1.bd[*i * 6 + 386] + dx * sin(dalpha) + dy * cos(dalpha)
		;
/*        print *,'acurxy arc ',i,xx,yy,xxx,yyy,acurxy */
    } else if (bdpec2_1.bd[*i * 6 + 384] == -3.f) {
	dx = bdpec2_1.bd[*i * 6 + 387] - bdpec2_1.bd[*i * 6 + 385];
	dy = bdpec2_1.bd[*i * 6 + 388] - bdpec2_1.bd[*i * 6 + 386];
	dxx = *xx - bdpec2_1.bd[*i * 6 + 385];
	dyy = *yy - bdpec2_1.bd[*i * 6 + 386];
/* Computing MIN */
/* Computing MAX */
/* Computing 2nd power */
	r__5 = dx;
/* Computing 2nd power */
	r__6 = dy;
	r__3 = 0.f, r__4 = (dxx * dx + dyy * dy) / (r__5 * r__5 + r__6 * r__6)
		;
	r__1 = 1.f, r__2 = dmax(r__3,r__4);
	ret_val = dmin(r__1,r__2);
	*xxx = bdpec2_1.bd[*i * 6 + 385] + dx * ret_val;
	*yyy = bdpec2_1.bd[*i * 6 + 386] + dy * ret_val;
/*        print *,'acurxy seg:',i,xx,yy,xxx,yyy,acurxy */
    } else if (bdpec2_1.bd[*i * 6 + 384] == -4.f) {
	ptt = bdpec2_1.bd[*i * 6 + 386];
	n = 0;
L3:
	if (ptt != 0) {
	    ++n;
	    if (n <= 500) {
		xsp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 385];
		ysp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 386];
		ptt = listed_1.cdr[ptt - 1];
		goto L3;
	    }
	}
	densit = 1.f;
	if (n < 2) {
	    *xx = 0.f;
	    *yy = 0.f;
	  /* return ret_val;*/goto LE999;
	}
	genspl_(xsp, ysp, &n, &eps_1.eps, &densit, xgen, ygen, &c__2000, &
		nbgen, tgen);
	long_ = 0.f;
	k = 1;
	ac = 0.f;
/* Computing 2nd power */
	r__1 = *xx - xgen[0];
/* Computing 2nd power */
	r__2 = *yy - ygen[0];
	dx = r__1 * r__1 + r__2 * r__2;
	i__1 = nbgen - 1;
	for (j = 1; j <= i__1; ++j) {
/* Computing 2nd power */
	    r__1 = xgen[j - 1] - xgen[j];
/* Computing 2nd power */
	    r__2 = ygen[j - 1] - ygen[j];
	    long_ += sqrt(r__1 * r__1 + r__2 * r__2);
/* Computing 2nd power */
	    r__1 = *xx - xgen[j];
/* Computing 2nd power */
	    r__2 = *yy - ygen[j];
	    dxx = r__1 * r__1 + r__2 * r__2;
	    if (dxx < dx) {
		ac = long_;
		k = j + 1;
		dx = dxx;
	    }
/* L4: */
	}
	ret_val = ac / long_;
	*xxx = xgen[k - 1];
	*yyy = ygen[k - 1];
	dxx = *xx - xgen[k - 1];
	dyy = *yy - ygen[k - 1];
	if (k > 1) {
	    dx = xgen[k - 2] - xgen[k - 1];
	    dy = ygen[k - 2] - ygen[k - 1];
/* Computing 2nd power */
	    r__1 = dx;
/* Computing 2nd power */
	    r__2 = dy;
	    ac = (dxx * dx + dyy * dy) / (r__1 * r__1 + r__2 * r__2);
	    if (ac > 0.f && ac <= 1.f) {
		*xxx += ac * dx;
		*yyy += ac * dy;
		ret_val -= long_ * ac;
		/*return ret_val;*/goto LE999;
	    }
	}
	if (k < nbgen) {
	    dx = xgen[k] - xgen[k - 1];
	    dy = ygen[k] - ygen[k - 1];
/* Computing 2nd power */
	    r__1 = dx;
/* Computing 2nd power */
	    r__2 = dy;
	    ac = (dxx * dx + dyy * dy) / (r__1 * r__1 + r__2 * r__2);
	    if (ac > 0.f && ac <= 1.f) {
		*xxx += ac * dx;
		*yyy += ac * dy;
		ret_val += long_ * ac;
		/*return ret_val;*/ goto LE999;
	    }
	}
    }
    LE999: free(xgen);free(ygen);free(tgen);free(xsp);free(ysp);
    return ret_val;
} /* acurxy_ */




/* Subroutine */ int addms1_(integer *nf, integer *refpts, integer *nbt1, 
	integer *nbs1, integer *nba1, integer *nbsd1, integer *nbd3, integer *
	err)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    cilist ci__1;

    /* Builtin functions */
    integer s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_rsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_rsfe(void), i_indx(char *, char *, ftnlen, ftnlen), s_wsle(
	    cilist *), e_wsle(void), s_cmp(char *, char *, ftnlen, ftnlen), 
	    i_nint(real *);

    /* Local variables */
    extern integer cons_(integer *, integer *);
    char type[10];

    char ligne[80];
    integer i, j, k, j1, j2;
    extern integer appenx_(integer *, integer *);
    integer tetspl, version;

    /* Fortran I/O blocks */
    static cilist io___78 = { 1, 0, 1, 0, 0 };
    static cilist io___80 = { 1, 0, 1, 0, 0 };
    static cilist io___83 = { 0, 6, 0, 0, 0 };
    static cilist io___84 = { 1, 0, 1, 0, 0 };
    static cilist io___85 = { 0, 6, 0, 0, 0 };
    static cilist io___86 = { 1, 0, 1, 0, 0 };
    static cilist io___87 = { 0, 6, 0, 0, 0 };
    static cilist io___88 = { 1, 0, 1, 0, 0 };
    static cilist io___89 = { 1, 0, 1, 0, 0 };
    static cilist io___90 = { 0, 6, 0, 0, 0 };
    static cilist io___91 = { 1, 0, 1, 0, 0 };
    static cilist io___92 = { 0, 6, 0, 0, 0 };
    static cilist io___93 = { 1, 0, 1, 0, 0 };
    static cilist io___94 = { 0, 6, 0, 0, 0 };
    static cilist io___95 = { 1, 0, 1, 0, 0 };
    static cilist io___96 = { 1, 0, 1, 0, 0 };
    static cilist io___97 = { 0, 6, 0, 0, 0 };
    static cilist io___98 = { 1, 0, 1, 0, 0 };
    static cilist io___99 = { 1, 0, 1, 0, 0 };
    static cilist io___102 = { 0, 6, 0, 0, 0 };
    static cilist io___103 = { 1, 0, 1, 0, 0 };
    static cilist io___104 = { 1, 0, 1, 0, 0 };
    static cilist io___105 = { 0, 6, 0, 0, 0 };
    static cilist io___106 = { 1, 0, 1, 0, 0 };
    static cilist io___107 = { 1, 0, 1, 0, 0 };
    static cilist io___108 = { 0, 6, 0, 0, 0 };
    static cilist io___109 = { 1, 0, 1, 0, 0 };
    static cilist io___111 = { 0, 6, 0, 0, 0 };
    static cilist io___112 = { 1, 0, 0, 0, 0 };
    static cilist io___114 = { 1, 0, 0, 0, 0 };
    static cilist io___115 = { 1, 0, 0, 0, 0 };
    static cilist io___118 = { 1, 0, 0, 0, 0 };
    static cilist io___119 = { 0, 6, 0, 0, 0 };


    io___78.ciunit = *nf;
    i__1 = s_rsle(&io___78);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&(*nbt1), (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&(*nbs1), (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&(*nba1), (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&(*nbsd1), (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    *nbt1 = bdmsh1_1.nbt + *nbt1;
    *nbs1 = bdmsh1_1.nbs + *nbs1;
    *nba1 = bdmsh1_1.nba + *nba1;
    *nbsd1 = bdmsh1_1.nbsd + *nbsd1;
    if (*nbt1 > bdmsh0_1.nbtmx || *nbs1 > bdmsh0_1.nbpmx || *nba1 > 
	    bdmsh0_1.nbamx || *nbsd1 > bdmsh0_1.nbsdmx) {
	*err = 1;
	return 0;
    }
    ci__1.cierr = 1;
    ci__1.ciend = 1;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    i__1 = s_rsfe(&ci__1);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_fio(&c__1, ligne, 80L);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsfe();
    if (i__1 != 0) {
	goto L1000;
    }
    if (i_indx(ligne, "version0", 80L, 8L) != 0) {
	io___80.ciunit = *nf;
	i__1 = s_rsle(&io___80);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__2 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__1 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	}
	i__1 = e_rsle();
	i__1 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__1; ++j) {
	    bdmsh6_1.nsorig[j - 1] = j - bdmsh1_1.nbs;
	    bdmsh7_1.abcurv[j - 1] = 0.f;
/* L1: */
	}
	s_wsle(&io___83);
	do_lio(&c__9, &c__1, "fin lecture cr version 0", 24L);
	e_wsle();
    } else if (i_indx(ligne, "version2", 80L, 8L) == 0) {
	io___84.ciunit = *nf;
	i__1 = s_rsle(&io___84);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__2 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__1 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	    i__1 = do_lio(&c__4, &c__1, (char *)&bdmsh7_1.abcurv[j - 1], (
		    ftnlen)sizeof(real));
	    if (i__1 != 0) {
		goto L1000;
	    }
	}
	i__1 = e_rsle();
	i__1 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__1; ++j) {
	    bdmsh6_1.nsorig[j - 1] = j - bdmsh1_1.nbs;
/* L2: */
	}
	s_wsle(&io___85);
	do_lio(&c__9, &c__1, "fin lecture cr version 0", 24L);
	e_wsle();
    } else {
	io___86.ciunit = *nf;
	i__1 = s_rsle(&io___86);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__2 = *nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__1 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	    i__1 = do_lio(&c__4, &c__1, (char *)&bdmsh7_1.abcurv[j - 1], (
		    ftnlen)sizeof(real));
	    if (i__1 != 0) {
		goto L1000;
	    }
	    i__1 = do_lio(&c__3, &c__1, (char *)&bdmsh6_1.nsorig[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__1 != 0) {
		goto L1000;
	    }
	}
	i__1 = e_rsle();
	s_wsle(&io___87);
	do_lio(&c__9, &c__1, "fin lecture cr version 1", 24L);
	e_wsle();
    }
    io___88.ciunit = *nf;
    i__1 = s_rsle(&io___88);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    io___89.ciunit = *nf;
    i__1 = s_rsle(&io___89);
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = *nba1;
    for (j = bdmsh1_1.nba + 1; j <= i__2; ++j) {
	for (i = 1; i <= 2; ++i) {
	    i__1 = do_lio(&c__3, &c__1, (char *)&bdmshc_1.aretbd[i + (j << 1) 
		    - 3], (ftnlen)sizeof(integer));
	    if (i__1 != 0) {
		goto L1000;
	    }
	}
    }
    i__1 = e_rsle();
    s_wsle(&io___90);
    do_lio(&c__9, &c__1, "fin lecture aretbd", 18L);
    e_wsle();
    ci__1.cierr = 1;
    ci__1.ciend = 1;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    i__1 = s_rsfe(&ci__1);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_fio(&c__1, ligne, 80L);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsfe();
    if (i__1 != 0) {
	goto L1000;
    }
    if (i_indx(ligne, "version2", 80L, 8L) == 0) {
	io___91.ciunit = *nf;
	i__1 = s_rsle(&io___91);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__2 = *nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__1 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + j * 6 
			- 7], (ftnlen)sizeof(integer));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	}
	i__1 = e_rsle();
	i__1 = *nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__1; ++j) {
	    bdmshb_1.apavue[j - 1] = 0;
/* L3: */
	}
	s_wsle(&io___92);
	do_lio(&c__9, &c__1, "fin lecture nsea version 0", 26L);
	e_wsle();
    } else {
	io___93.ciunit = *nf;
	i__1 = s_rsle(&io___93);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__2 = *nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__1 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + j * 6 
			- 7], (ftnlen)sizeof(integer));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	    i__1 = do_lio(&c__3, &c__1, (char *)&bdmshb_1.apavue[j - 1], (
		    ftnlen)sizeof(integer));
	    if (i__1 != 0) {
		goto L1000;
	    }
	}
	i__1 = e_rsle();
	s_wsle(&io___94);
	do_lio(&c__9, &c__1, "fin lecture nsea version 1", 26L);
	e_wsle();
    }
    io___95.ciunit = *nf;
    i__1 = s_rsle(&io___95);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    io___96.ciunit = *nf;
    i__1 = s_rsle(&io___96);
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = *nbt1;
    for (i = bdmsh1_1.nbt + 1; i <= i__2; ++i) {
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[i - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = e_rsle();
    s_wsle(&io___97);
    do_lio(&c__9, &c__1, "fin lecture reft", 16L);
    e_wsle();
    io___98.ciunit = *nf;
    i__1 = s_rsle(&io___98);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    io___99.ciunit = *nf;
    i__1 = s_rsle(&io___99);
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = *nbsd1;
    for (j = bdmsh1_1.nbsd + 1; j <= i__2; ++j) {
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmshf_1.refsd[j - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmshj_1.ptorsd[j - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmshi_1.strfsd[j - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
	for (j2 = 1; j2 <= 3; ++j2) {
	    for (j1 = 1; j1 <= 3; ++j1) {
		i__1 = do_lio(&c__5, &c__1, (char *)&bdmshh_1.trfsd[j1 + (j2 
			+ j * 3) * 3 - 13], (ftnlen)sizeof(doublereal));
		if (i__1 != 0) {
		    goto L1000;
		}
	    }
	}
    }
    i__1 = e_rsle();
    s_wsle(&io___102);
    do_lio(&c__9, &c__1, "fin lecture refsd", 17L);
    e_wsle();
    io___103.ciunit = *nf;
    i__1 = s_rsle(&io___103);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    io___104.ciunit = *nf;
    i__1 = s_rsle(&io___104);
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = *nbs1;
    for (i = bdmsh1_1.nbs + 1; i <= i__2; ++i) {
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[i - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = e_rsle();
    s_wsle(&io___105);
    do_lio(&c__9, &c__1, "fin lecture refs", 16L);
    e_wsle();
    io___106.ciunit = *nf;
    i__1 = s_rsle(&io___106);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    io___107.ciunit = *nf;
    i__1 = s_rsle(&io___107);
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = *nba1;
    for (i = bdmsh1_1.nba + 1; i <= i__2; ++i) {
	i__1 = do_lio(&c__3, &c__1, (char *)&bdmshe_1.refa[i - 1], (ftnlen)
		sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = e_rsle();
    s_wsle(&io___108);
    do_lio(&c__9, &c__1, "fin lecture refa", 16L);
    e_wsle();
    io___109.ciunit = *nf;
    i__1 = s_rsle(&io___109);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&(*nbd3), (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsle();
    *nbd3 = bdmsh4_1.finbd3 + *nbd3;
    if (*nbd3 > bdpec1_1.mxbd) {
	return 0;
    }
    ci__1.cierr = 1;
    ci__1.ciend = 1;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    i__1 = s_rsfe(&ci__1);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_fio(&c__1, ligne, 80L);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsfe();
    if (i__1 != 0) {
	goto L1000;
    }
    if (i_indx(ligne, "version2", 80L, 8L) != 0) {
	version = 2;
    } else if (i_indx(ligne, "version0", 80L, 8L) != 0) {
	version = 0;
    } else {
	version = 1;
    }
    s_wsle(&io___111);
    do_lio(&c__9, &c__1, "lecture bd version  ", 20L);
    do_lio(&c__3, &c__1, (char *)&version, (ftnlen)sizeof(integer));
    e_wsle();
    i__1 = *nbd3;
    for (j = bdmsh4_1.finbd3 + 1; j <= i__1; ++j) {
	if (version == 0) {
	    io___112.ciunit = *nf;
	    i__2 = s_rsle(&io___112);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__9, &c__1, type, 10L);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 5; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i + j * 6 + 
			384], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    for (i = 1; i <= 1; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[i + (j << 
			1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec6_1.nuref1[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec7_1.nuref2[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[j + 64], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[j + 64], (
		    ftnlen)sizeof(real));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	    bdpec6_1.nuref1[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec6_1.nuref1[(j << 1) + 129] = bdpec6_1.nuref1[(j << 1) + 128] 
		    + bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 129] = bdpec7_1.nuref2[(j << 1) + 128] 
		    + bdmsh4_1.finbd3;
	    bdpecd_1.fissur[j + 64] = FALSE_;
	} else if (version == 1) {
	    io___114.ciunit = *nf;
	    i__2 = s_rsle(&io___114);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__9, &c__1, type, 10L);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 5; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i + j * 6 + 
			384], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[i + (j << 
			1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec6_1.nuref1[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec7_1.nuref2[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[j + 64], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[j + 64], (
		    ftnlen)sizeof(real));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[j + 64], (
		    ftnlen)sizeof(logical));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	    bdpec6_1.nuref1[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec6_1.nuref1[(j << 1) + 129] += bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 129] += bdmsh4_1.finbd3;
	    bdpecd_1.fissur[j + 64] = FALSE_;
	} else {
	    io___115.ciunit = *nf;
	    i__2 = s_rsle(&io___115);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__9, &c__1, type, 10L);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    for (i = 1; i <= 5; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i + j * 6 + 
			384], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[i + (j << 
			1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec6_1.nuref1[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
		i__2 = do_lio(&c__3, &c__1, (char *)&bdpec7_1.nuref2[i + (j <<
			 1) + 127], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L1000;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[j + 64], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[j + 64], (
		    ftnlen)sizeof(real));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[j + 64], (
		    ftnlen)sizeof(logical));
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsle();
	    bdpec6_1.nuref1[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec6_1.nuref1[(j << 1) + 129] += bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 128] += bdmsh4_1.finbd3;
	    bdpec7_1.nuref2[(j << 1) + 129] += bdmsh4_1.finbd3;
	}
	if (s_cmp(type, "arc", 10L, 3L) == 0) {
	    bdpec2_1.bd[j * 6 + 384] = -2.f;
	} else if (s_cmp(type, "segment", 10L, 7L) == 0) {
	    bdpec2_1.bd[j * 6 + 384] = -3.f;
	} else if (s_cmp(type, "point", 10L, 5L) == 0) {
	    bdpec2_1.bd[j * 6 + 384] = 0.f;
	} else if (s_cmp(type, "spline", 10L, 6L) == 0) {
	    bdpec2_1.bd[j * 6 + 384] = -4.f;
	    tetspl = 0;
	    if (*nbd3 + i_nint(&bdpec2_1.bd[j * 6 + 385]) > bdpec1_1.mxbd) {
		return 0;
	    }
	    i__2 = i_nint(&bdpec2_1.bd[j * 6 + 385]);
	    for (k = 1; k <= i__2; ++k) {
		++(*nbd3);
		bdpec2_1.bd[*nbd3 * 6 + 384] = 0.f;
		io___118.ciunit = *nf;
		i__3 = s_rsle(&io___118);
		if (i__3 != 0) {
		    goto L1000;
		}
		i__3 = do_lio(&c__9, &c__1, type, 10L);
		if (i__3 != 0) {
		    goto L1000;
		}
		for (i = 1; i <= 2; ++i) {
		    i__3 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i + *
			    nbd3 * 6 + 384], (ftnlen)sizeof(real));
		    if (i__3 != 0) {
			goto L1000;
		    }
		}
		i__3 = e_rsle();
		i__3 = cons_(nbd3, &c__0);
		tetspl = appenx_(&tetspl, &i__3);
		if (s_cmp(type, "pt spline", 10L, 9L) != 0) {
		    *err = 100;
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
		    return 0;
		}
		bdpec5_1.nuref[(*nbd3 << 1) + 128] = 0;
		bdpec5_1.nuref[(*nbd3 << 1) + 129] = 0;
		bdpec6_1.nuref1[(*nbd3 << 1) + 128]  = 0;
		bdpec6_1.nuref1[(*nbd3 << 1) + 129]  = 0;
		bdpec7_1.nuref2[(*nbd3 << 1) + 128]  = 0;
		bdpec7_1.nuref2[(*nbd3 << 1) + 129]  = 0;
		bdpec4_1.raison[*nbd3 + 64] = 1.f;
		bdpec3_1.nbnode[*nbd3 + 64] = 2;
/* L10: */
	    }
	    bdpec2_1.bd[j * 6 + 386] = (real) tetspl;
	} else {
	    bdpec2_1.bd[j * 6 + 384] = -1e3f;
	}
/* L20: */
    }
    i__1 = *nbs1;
    for (i = bdmsh1_1.nbs + 1; i <= i__1; ++i) {
	if (bdmsh8_1.refs[i - 1] > 0) {
	    bdmsh8_1.refs[i - 1] += bdmsh4_1.finbd3;
	} else if (bdmsh8_1.refs[i - 1] < 0) {
	    bdmsh8_1.refs[i - 1] -= bdmsh4_1.finbd3;
	}
/* L40: */
    }
    i__1 = *nba1;
    for (i = bdmsh1_1.nba + 1; i <= i__1; ++i) {
	if (bdmshe_1.refa[i - 1] > 0) {
	    bdmshe_1.refa[i - 1] += bdmsh4_1.finbd3;
	} else if (bdmshe_1.refa[i - 1] < 0) {
	    bdmshe_1.refa[i - 1] -= bdmsh4_1.finbd3;
	} else {
	    bdmshe_1.refa[i - 1] = 0;
	}
/* L50: */
    }
    i__1 = *nbsd1;
    for (i = bdmsh1_1.nbsd + 1; i <= i__1; ++i) {
	bdmshj_1.ptorsd[i - 1] += bdmsh1_1.nbsd;
	bdmsh2_1.tetsd[i - 1] = 1073741824;
/* L60: */
    }
/*     chanaige  des element d'un meme  sous domaine */
    i__1 = *nbt1;
    for (i = bdmsh1_1.nbt + 1; i <= i__1; ++i) {
	j = bdmsha_1.reft[i - 1] + bdmsh1_1.nbsd;
	bdmsha_1.reft[i - 1] = bdmsh2_1.tetsd[j - 1];
	bdmsh2_1.tetsd[j - 1] = i;
/* L70: */
    }
    return 0;
L1000:
    *err = 1;
    s_wsle(&io___119);
    do_lio(&c__9, &c__1, "ERREUR de lecture ", 18L);
    e_wsle();
    return 0;
} /* addms1_ */



#ifdef addmsh_ 
/* Subroutine */ int addmsh_(void)
{
    /* Format strings */
    static char fmt_2299[] = "(\002nb de sommets =\002,i6,\002; nb de triang"
	    "les =\002,i6,\002; nb de quadrangles =\002,i6,\002; nb de sous d"
	    "omaines =\002,i4,\002; nb d'aretes =\002,i5)";

    /* System generated locals */
    address a__1[3], a__2[2], a__3[4];
    integer i__1[3], i__2, i__3[2], i__4[4], i__5, i__6, i__7, i__8;
    real r__1;
    char ch__1[99], ch__2[15], ch__3[115], ch__4[109], ch__5[122], ch__6[98], 
	    ch__7[110], ch__8[103];
    icilist ici__1;
    cllist cl__1;

    /* Builtin functions */
    integer s_cmp(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_rsue(cilist *), do_uio(integer *, char *, ftnlen), e_rsue(void),
	     s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), f_clos(cllist *), s_wsfi(icilist *), do_fio(integer 
	    *, char *, ftnlen), e_wsfi(void), s_wsle(cilist *), e_wsle(void);

    /* Local variables */
    real pmin[2], pmax[2];
    char type[80];
    integer nbsd1, i, j, k;

    char forme[11], cherr[80];
    extern /* Subroutine */ int addms1_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *);
    integer ii, nf;
    char fichie[80];
    extern /* Subroutine */ int addref_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen);
    integer err, cas;
    char buf[132];
    real fx, fy, mx;
    integer nba1;
    real my, mmx, mmy;
    integer nbd3;
    real hx, hy;
    extern /* Subroutine */ int intext_(char *, integer *, char *, integer *, 
	    ftnlen, ftnlen), scrtch_(char *, ftnlen), addnop_(integer *, 
	    integer *, integer *, integer *, integer *, integer *), genadj_(
	    integer *, real *, integer *, integer *), chtrgl_(void);
    integer nbs1, nbt1;
    extern /* Subroutine */ int vbdmsh_(void);

    /* Fortran I/O blocks */
    static cilist io___136 = { 1, 0, 1, 0, 0 };
    static cilist io___137 = { 1, 0, 1, 0, 0 };
    static cilist io___139 = { 1, 0, 0, 0, 0 };
    static cilist io___140 = { 1, 0, 1, 0, 0 };
    static cilist io___141 = { 1, 0, 1, 0, 0 };
    static cilist io___142 = { 1, 0, 1, 0, 0 };
    static cilist io___143 = { 1, 0, 1, 0, 0 };
    static cilist io___144 = { 1, 0, 0, 0, 0 };
    static cilist io___145 = { 1, 0, 1, 0, 0 };
    static cilist io___147 = { 1, 0, 1, 0, 0 };
    static cilist io___149 = { 0, 6, 0, 0, 0 };
    static cilist io___150 = { 0, 6, 0, 0, 0 };
    static cilist io___151 = { 0, 6, 0, 0, 0 };


L5:
/*     call intext('donnez le type du maillage '                        #F
R*/
/*   +          /*'(nopo am am_fmt mesh amdba):'                        #F*/
R*/
/*   +          ,50,type,ii)                                            #F
R*/
    intext_("give the type of mesh (nopo am am_fmt mesh amdba):", &c__50, 
	    type, &ii, 50L, 80L);
    if (ii == 0 || s_cmp(type, "MESH", 80L, 4L) == 0 || s_cmp(type, "mesh", 
	    80L, 4L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".mesh", 80L, 5L);
	ii = i_len(".mesh", 5L);
    } else if (s_cmp(type, "NOPO", 80L, 4L) == 0 || s_cmp(type, "nopo", 80L, 
	    4L) == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".nopo", 80L, 5L);
	ii = i_len(".nopo", 5L);
    } else if (s_cmp(type, "AM", 80L, 2L) == 0 || s_cmp(type, "am", 80L, 2L) 
	    == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".am", 80L, 3L);
	ii = i_len(".am", 3L);
    } else if (s_cmp(type, "AM_FMT", 80L, 6L) == 0 || s_cmp(type, "am_fmt", 
	    80L, 6L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".am_fmt", 80L, 7L);
	ii = i_len(".am_fmt", 7L);
    } else if (s_cmp(type, "AMDBA", 80L, 5L) == 0 || s_cmp(type, "amdba", 80L,
	     5L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".amdba", 80L, 6L);
	ii = i_len(".amdba", 6L);
    } else {
/* Writing concatenation */
	i__1[0] = 12, a__1[0] = "bad type : '";
	i__1[1] = ii, a__1[1] = type;
	i__1[2] = 7, a__1[2] = "' retry";
	s_cat(ch__1, a__1, i__1, &c__3, 99L);
	scrtch_(ch__1, ii + 19);
/*       call scrtch('mauvais type : '''/*type(1:ii)//''' recommencez'*/
) #FR*/
	goto L5;
    }
L10:
/*     call intext('donnez le prefix des noms de fichiers de generation:#F
R*/
/*   +          ,50,fichie,i)                                           #F
R*/
    intext_("Give the prefix part of files name generation:", &c__50, fichie, 
	    &i, 46L, 80L);
    if (i == 0) {
/*      call scrtch('nom de fichier vide, on abandonne !')            
  #FR*/
	scrtch_("file name empty => cancel !", 27L);
	return 0;
    }
    i__2 = i;
    s_copy(fichie + i__2, type, 80 - i__2, 80L);
/* Writing concatenation */
    i__3[0] = 4, a__2[0] = "old,";
    i__3[1] = 11, a__2[1] = forme;
    s_cat(ch__2, a__2, i__3, &c__2, 15L);
    if (fouvri_(&nf, fichie, ch__2, &c__0, i + ii, 15L) != 0) {
	scrtch_("pb dans open de votre fichier, changer de nom.", 46L);
	goto L10;
    }
/* Writing concatenation */
    i__4[0] = 16, a__3[0] = "open du fichier ";
    i__4[1] = 11, a__3[1] = forme;
    i__4[2] = 8, a__3[2] = " de nom:";
    i__4[3] = i + ii, a__3[3] = fichie;
    s_cat(ch__3, a__3, i__4, &c__4, 115L);
    scrtch_(ch__3, i + ii + 35);
/* -----------------------------------------------------------------------
 */

    bdpec5_1.nuref[128] = 0;
    bdpec5_1.nuref[129] = 0;
    err = 0;
    cas = 1000000;
    nbd3 = bdmsh4_1.finbd3;
    nba1 = bdmsh1_1.nba;
    nbsd1 = bdmsh1_1.nbsd;
    if (s_cmp(type, ".mesh", 80L, 5L) == 0) {
	addms1_(&nf, bdwrk1_1.work, &nbt1, &nbs1, &nba1, &nbsd1, &nbd3, &err);
	if (err != 0) {
	    goto L1000;
	}
	if (nbd3 > bdpec1_1.mxbd) {
	    goto L2000;
	}
	cas = 10;
    } else if (s_cmp(type, ".nopo", 80L, 5L) == 0) {
	i__2 = (bdmsh0_1.nbtmx << 1) + 1;
	addnop_(&bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2, &nf, &nbt1, &nbs1, 
		&err);
	if (err != 0) {
	    goto L1000;
	}
	cas = 2;
    } else if (s_cmp(type, ".am", 80L, 3L) == 0) {
	io___136.ciunit = nf;
	i__2 = s_rsue(&io___136);
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = do_uio(&c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = do_uio(&c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L100001;
	}
	i__2 = e_rsue();
L100001:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___137.ciunit = nf;
	i__2 = s_rsue(&io___137);
	if (i__2 != 0) {
	    goto L100002;
	}
	i__5 = bdmsh1_1.nbt + nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_uio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (
			ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100002;
		}
	    }
	}
	i__6 = bdmsh1_1.nbs + nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__6; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_uio(&c__1, (char *)&bdmsh5_1.cr[i + (j << 1) - 3], (
			ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100002;
		}
	    }
	}
	i__7 = bdmsh1_1.nbt + nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__7; ++i) {
	    i__2 = do_uio(&c__1, (char *)&bdmsha_1.reft[i - 1], (ftnlen)
		    sizeof(integer));
	    if (i__2 != 0) {
		goto L100002;
	    }
	}
	i__8 = bdmsh1_1.nbs + nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__8; ++i) {
	    i__2 = do_uio(&c__1, (char *)&bdmsh8_1.refs[i - 1], (ftnlen)
		    sizeof(integer));
	    if (i__2 != 0) {
		goto L100002;
	    }
	}
	i__2 = e_rsue();
L100002:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".am_fmt", 80L, 7L) == 0) {
	io___139.ciunit = nf;
	i__2 = s_rsle(&io___139);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___140.ciunit = nf;
	i__2 = s_rsle(&io___140);
	if (i__2 != 0) {
	    goto L100003;
	}
	i__5 = nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + j * 6 
			- 7], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100003;
		}
	    }
	}
	i__2 = e_rsle();
L100003:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___141.ciunit = nf;
	i__2 = s_rsle(&io___141);
	if (i__2 != 0) {
	    goto L100004;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (j << 1) 
			- 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100004;
		}
	    }
	}
	i__2 = e_rsle();
L100004:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___142.ciunit = nf;
	i__2 = s_rsle(&io___142);
	if (i__2 != 0) {
	    goto L100005;
	}
	i__5 = nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__5; ++i) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[i - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100005;
	    }
	}
	i__2 = e_rsle();
L100005:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___143.ciunit = nf;
	i__2 = s_rsle(&io___143);
	if (i__2 != 0) {
	    goto L100006;
	}
	i__5 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__5; ++i) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[i - 1], (
		    ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100006;
	    }
	}
	i__2 = e_rsle();
L100006:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else if (s_cmp(type, ".amdba", 80L, 6L) == 0) {
	io___144.ciunit = nf;
	i__2 = s_rsle(&io___144);
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbs1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	if (i__2 != 0) {
	    goto L1000;
	}
	i__2 = e_rsle();
	nbs1 = bdmsh1_1.nbs + nbs1;
	nbt1 = bdmsh1_1.nbt + nbt1;
	if (nbt1 > bdmsh0_1.nbtmx || nbs1 > bdmsh0_1.nbpmx) {
	    goto L2000;
	}
	io___145.ciunit = nf;
	i__2 = s_rsle(&io___145);
	if (i__2 != 0) {
	    goto L100007;
	}
	i__5 = nbs1;
	for (j = bdmsh1_1.nbs + 1; j <= i__5; ++j) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100007;
	    }
	    for (i = 1; i <= 2; ++i) {
		i__2 = do_lio(&c__4, &c__1, (char *)&bdmsh5_1.cr[i + (k + 
			bdmsh1_1.nbs << 1) - 3], (ftnlen)sizeof(real));
		if (i__2 != 0) {
		    goto L100007;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh8_1.refs[k + 
		    bdmsh1_1.nbs - 1], (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100007;
	    }
	}
	i__2 = e_rsle();
L100007:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	io___147.ciunit = nf;
	i__2 = s_rsle(&io___147);
	if (i__2 != 0) {
	    goto L100008;
	}
	i__5 = nbt1;
	for (j = bdmsh1_1.nbt + 1; j <= i__5; ++j) {
	    i__2 = do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100008;
	    }
	    for (i = 1; i <= 3; ++i) {
		i__2 = do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + (k + 
			bdmsh1_1.nbt) * 6 - 7], (ftnlen)sizeof(integer));
		if (i__2 != 0) {
		    goto L100008;
		}
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&bdmsha_1.reft[k + 
		    bdmsh1_1.nbt - 1], (ftnlen)sizeof(integer));
	    if (i__2 != 0) {
		goto L100008;
	    }
	}
	i__2 = e_rsle();
L100008:
	if (i__2 < 0) {
	    goto L3000;
	}
	if (i__2 > 0) {
	    goto L1000;
	}
	cas = 1;
    } else {
/* Writing concatenation */
	i__3[0] = 29, a__2[0] = "ERREUR addmsh dans les types ";
	i__3[1] = ii - 1, a__2[1] = type + 1;
	s_cat(ch__4, a__2, i__3, &c__2, 109L);
	scrtch_(ch__4, ii + 28);
	err = 1;
    }
L100:
    cl__1.cerr = 0;
    cl__1.cunit = nf;
    cl__1.csta = 0;
    f_clos(&cl__1);
    if (err != 0) {
	return 0;
    }
    if (cas == 1) {
	i__2 = nbt1;
	for (i = bdmsh1_1.nbt + 1; i <= i__2; ++i) {
	    bdmshb_1.apavue[i - 1] = 0;
	    for (j = 4; j <= 6; ++j) {
		bdmsh9_1.nsea[j + i * 6 - 7] = 0;
/* L110: */
	    }
	}
	i__2 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__2; ++i) {
	    bdmsh6_1.nsorig[i - 1] = i;
/* L115: */
	}
    } else {
/*       shift des sommets origne */
	i__2 = nbs1;
	for (i = bdmsh1_1.nbs + 1; i <= i__2; ++i) {
	    bdmsh6_1.nsorig[i - 1] += bdmsh1_1.nbs;
/* L116: */
	}
    }
/*     shift des elements ------------------------------------- */
    i__2 = nbt1;
    for (i = bdmsh1_1.nbt + 1; i <= i__2; ++i) {
	for (j = 1; j <= 3; ++j) {
	    bdmsh9_1.nsea[j + i * 6 - 7] += bdmsh1_1.nbs;
	    if (bdmsh9_1.nsea[j + i * 6 - 7] <= bdmsh1_1.nbs || bdmsh9_1.nsea[
		    j + i * 6 - 7] > nbs1) {
		scrtch_("les elements du maillage lu sont incorrects, on ne "
			"fait rien", 60L);
		return 0;
	    }
/* L120: */
	}
    }
/*     shift des aretes -------------------------------------- */
    i__2 = nba1;
    for (i = bdmsh1_1.nba + 1; i <= i__2; ++i) {
	bdmshc_1.aretbd[(i << 1) - 2] += bdmsh1_1.nbs;
	bdmshc_1.aretbd[(i << 1) - 1] += bdmsh1_1.nbs;
/* L130: */
    }
    if (cas <= 9) {
/*        def des sous domaines et construction des aretes & bd */
	i__2 = (bdmsh0_1.lwork - nbs1) / 3;
	addref_(bdwrk1_1.work, &bdwrk1_1.work[nbs1], &i__2, &nbs1, &nba1, &
		nbt1, &nbsd1, &nbd3, &err);
	if (err != 0) {
	    ici__1.icierr = 0;
	    ici__1.icirnum = 1;
	    ici__1.icirlen = 80;
	    ici__1.iciunit = cherr;
	    ici__1.icifmt = "(i10)";
	    s_wsfi(&ici__1);
	    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
	    e_wsfi();
/* Writing concatenation */
	    i__3[0] = 42, a__2[0] = "le maillage lu est mauvais on ne fait r"
		    "ien";
	    i__3[1] = 80, a__2[1] = cherr;
	    s_cat(ch__5, a__2, i__3, &c__2, 122L);
	    scrtch_(ch__5, 122L);
	    return 0;
	}
	if (nba1 > bdmsh0_1.nbamx || nbsd1 > nbsd1 || nbd3 > bdpec1_1.mxbd) {
	    s_wsle(&io___149);
	    do_lio(&c__9, &c__1, "nba1=", 5L);
	    do_lio(&c__3, &c__1, (char *)&nba1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdmsh0_1.nbamx, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    s_wsle(&io___150);
	    do_lio(&c__9, &c__1, "nbsd1=", 6L);
	    do_lio(&c__3, &c__1, (char *)&nbsd1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdmsh0_1.nbsdmx, (ftnlen)sizeof(
		    integer));
	    e_wsle();
	    s_wsle(&io___151);
	    do_lio(&c__9, &c__1, "nbd3=", 5L);
	    do_lio(&c__3, &c__1, (char *)&nbd3, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec1_1.mxbd, (ftnlen)sizeof(
		    integer));
	    e_wsle();
/*          call scrtch('pas assez de place memoire,on ne fait rie
n')   #FR*/
	    scrtch_("not enough memory, nothing is done", 34L);
	    return 0;
	}
    }

    if (nbs1 <= bdmsh1_1.nbs) {
	return 0;
    }
    if (cas < 1000) {
	pmin[0] = bdmsh5_1.cr[0];
	pmin[1] = bdmsh5_1.cr[1];
	pmax[0] = bdmsh5_1.cr[0];
	pmax[1] = bdmsh5_1.cr[1];
	i__2 = nbs1;
	for (i = 2; i <= i__2; ++i) {
/* Computing MIN */
	    r__1 = bdmsh5_1.cr[(i << 1) - 2];
	    pmin[0] = dmin(r__1,pmin[0]);
/* Computing MAX */
	    r__1 = bdmsh5_1.cr[(i << 1) - 2];
	    pmax[0] = dmax(r__1,pmax[0]);
/* Computing MIN */
	    r__1 = bdmsh5_1.cr[(i << 1) - 1];
	    pmin[1] = dmin(r__1,pmin[1]);
/* Computing MAX */
	    r__1 = bdmsh5_1.cr[(i << 1) - 1];
	    pmax[1] = dmax(r__1,pmax[1]);
/* L140: */
	}
	mmx = (pmin[0] + pmax[0]) / 2.f;
	mmy = (pmin[1] + pmax[1]) / 2.f;
	fx = (pec_1.fentre[1] - pec_1.fentre[0]) / 2.f;
	fy = (pec_1.fentre[3] - pec_1.fentre[2]) / 2.f;
	mx = (pmax[0] - pmin[0]) / 2.f;
	my = (pmax[1] - pmin[1]) / 2.f;
	if (mx != 0.f) {
	    hx = fx / mx;
	} else {
	    hx = fx;
	}
	hy = hx;
	if (fy < my * hy) {
	    if (my != 0.f) {
		hy = fy / my;
	    } else {
		hy = 1.f;
	    }
	    hx = hy;
	}
	if (hx == 0.f || hy == 0.f) {
	    hx = 1.f;
	    hy = 1.f;
	}
	pec_1.masque[0] = mmx - fx * 1.05f / hx;
	pec_1.masque[1] = mmx + fx * 1.05f / hx;
	pec_1.masque[2] = mmy - fy * 1.05f / hy;
	pec_1.masque[3] = mmy + fy * 1.05f / hy;
	etat_1.echel = hx;
	bdmsh1_1.nbt = nbt1;
	bdmsh1_1.nbs = nbs1;
	bdmsh1_1.nba = nba1;
	bdmsh1_1.nbsd = nbsd1;
	bdmsh4_1.finbd3 = nbd3;
	i__2 = bdmsh0_1.nbpmx + bdmsh0_1.nbtmx;
/*#define xwork ((real *) bdwrk1_3.work)*/
	genadj_(&bdwrk1_1.work[bdmsh0_1.nbpmx], &bdwrk1_3.xwork[bdmsh0_1.nbpmx], &
		bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2);
/*#undef xwork*/
/*        call genadj(ci,tri,nbpmx+nbtmx) */
	chtrgl_();
/* L2299: */
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 132;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_2299;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nbsd, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&bdmsh1_1.nba, (ftnlen)sizeof(integer));
	e_wsfi();
	scrtch_(buf, 132L);
    } else {
	scrtch_("ERREUR dans addmesh", 19L);
    }
    vbdmsh_();
    return 0;
L1000:
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 80;
    ici__1.iciunit = cherr;
    ici__1.icifmt = "(i10)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 18, a__2[0] = "ERREUR de lecture:";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__6, a__2, i__3, &c__2, 98L);
    scrtch_(ch__6, 98L);
    err = 1;
    goto L100;
L2000:
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 80;
    ici__1.iciunit = cherr;
    ici__1.icifmt = "(i10)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 30, a__2[0] = "trop de chose on ne fait rien:";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__7, a__2, i__3, &c__2, 110L);
    scrtch_(ch__7, 110L);
    err = 2;
    goto L100;
L3000:
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 80;
    ici__1.iciunit = cherr;
    ici__1.icifmt = "(i10)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&err, (ftnlen)sizeof(integer));
    e_wsfi();
/* Writing concatenation */
    i__3[0] = 23, a__2[0] = "ERREUR fin de fichier: ";
    i__3[1] = 80, a__2[1] = cherr;
    s_cat(ch__8, a__2, i__3, &c__2, 103L);
    scrtch_(ch__8, 103L);
    err = 3;
    goto L100;
} /* addmsh_ */
#endif



/* Subroutine */ int addnop_(integer *nop5, integer *lnop5x, integer *nf, 
	integer *nbt1, integer *nbs1, integer *err)
{
    /* System generated locals */
    integer i__1, i__2;
    alist al__1;
    /*static*/ integer equiv_27[27];

    /* Builtin functions */
    integer f_rew(alist *), s_rsue(cilist *), e_rsue(void), do_uio(integer *, 
	    char *, ftnlen), s_cmp(char *, char *, ftnlen, ftnlen), s_wsle(
	    cilist *), do_lio(integer *, integer *, char *, ftnlen), e_wsle(
	    void);

    /* Local variables */
#define ndim (equiv_27)
#define nqua (equiv_27 + 8)
    integer nref[8];
#define ntri (equiv_27 + 7)
    integer lnop5, i, j;

    integer netat, ntacm, nopoi[4], i5;
    extern /* Subroutine */ int addnp5_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *);
    integer ie;
#define ne (equiv_27 + 4)
    char ch4[4];
    integer niveau;
#define np (equiv_27 + 21)
#define ncopnp (equiv_27 + 3)
    integer npo;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
#define nop2 (equiv_27)

    /* Fortran I/O blocks */
    /*static*/ cilist io___173 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___174 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___181 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___182 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___183 = { 0, 0, 1, 0, 0 };
    /*static*/ cilist io___184 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___185 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___186 = { 0, 0, 1, 0, 0 };
    /*static*/ cilist io___187 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___188 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___189 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___191 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___197 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___198 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___199 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    --nop5;

    /* Function Body */
    *err = 1;
    al__1.aerr = 0;
    al__1.aunit = *nf;
    f_rew(&al__1);
    io___173.ciunit = *nf;
    i__1 = s_rsue(&io___173);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsue();
    if (i__1 != 0) {
	goto L1000;
    }
    *err = 2;
    io___174.ciunit = *nf;
    i__1 = s_rsue(&io___174);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_uio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    for (i = 1; i <= 29; ++i) {
	i__1 = do_uio(&c__1, ch4, 4L);
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = do_uio(&c__1, (char *)&niveau, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_uio(&c__1, (char *)&netat, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_uio(&c__1, (char *)&ntacm, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = e_rsue();
    if (i__1 != 0) {
	goto L1000;
    }
    if (s_cmp(ch4, "NOPO", 4L, 4L) != 0) {
	*err = 2;
	s_wsle(&io___181);
	do_lio(&c__9, &c__1, " on a pas lu une sd nopo mais :", 31L);
	do_lio(&c__9, &c__1, ch4, 4L);
	e_wsle();
	return 0;
    }
    s_wsle(&io___182);
    do_lio(&c__9, &c__1, " nb de tableau assoCie :", 24L);
    do_lio(&c__3, &c__1, (char *)&ntacm, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&niveau, (ftnlen)sizeof(integer));
    e_wsle();
    if (ntacm > 0) {
	i__1 = ntacm;
	for (i = 0; i <= i__1; ++i) {
	    *err = 100;
	    io___183.ciunit = *nf;
	    i__2 = s_rsue(&io___183);
	    if (i__2 != 0) {
		goto L1000;
	    }
	    i__2 = e_rsue();
	    if (i__2 != 0) {
		goto L1000;
	    }
/* L5: */
	}
    }
    *err = 2;
    io___184.ciunit = *nf;
    i__1 = s_rsue(&io___184);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_uio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    for (i = 1; i <= 27; ++i) {
	i__1 = do_uio(&c__1, (char *)&nop2[i - 1], (ftnlen)sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = e_rsue();
    if (i__1 != 0) {
	goto L1000;
    }
    s_wsle(&io___185);
    do_lio(&c__9, &c__1, " ndim=", 6L);
    do_lio(&c__3, &c__1, (char *)&(*ndim), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, "ne=", 3L);
    do_lio(&c__3, &c__1, (char *)&(*ne), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, "ntri=", 5L);
    do_lio(&c__3, &c__1, (char *)&(*ntri), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, "nqua=", 5L);
    do_lio(&c__3, &c__1, (char *)&(*nqua), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, "ncopnp=", 7L);
    do_lio(&c__3, &c__1, (char *)&(*ncopnp), (ftnlen)sizeof(integer));
    e_wsle();
    if (*ne != *ntri + *nqua) {
	return 0;
    }
    if (*ndim != 2) {
	return 0;
    }
    *nbs1 = bdmsh1_1.nbs + *np;
    i__1 = *nbs1;
    for (i = bdmsh1_1.nbs + 1; i <= i__1; ++i) {
	bdmsh8_1.refs[i - 1] = 0;
	bdmsh6_1.nsorig[i - 1] = i - bdmsh1_1.nbs;
/* L6: */
    }
    *err = -1;
    *nbt1 = bdmsh1_1.nbt + *ntri + (*nqua << 1);
    if (*nbt1 > bdmsh0_1.nbtmx) {
	return 0;
    }
    if (*nbs1 > bdmsh0_1.nbpmx) {
	return 0;
    }
    *err = 3;
    if (nop2[24] > 0) {
	io___186.ciunit = *nf;
	i__1 = s_rsue(&io___186);
	if (i__1 != 0) {
	    goto L1000;
	}
	i__1 = e_rsue();
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    io___187.ciunit = *nf;
    s_rsue(&io___187);
    do_uio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
    i__1 = *nbs1;
    for (j = bdmsh1_1.nbs + 1; j <= i__1; ++j) {
	for (i = 1; i <= 2; ++i) {
	    do_uio(&c__1, (char *)&bdmsh5_1.cr[i + (j << 1) - 3], (ftnlen)
		    sizeof(real));
	}
    }
    e_rsue();
    s_wsle(&io___188);
    do_lio(&c__9, &c__1, "fin lecture nopo4 (coor)", 24L);
    e_wsle();
    *err = 5;
    io___189.ciunit = *nf;
    i__1 = s_rsue(&io___189);
    if (i__1 != 0) {
	goto L1000;
    }
    i__1 = do_uio(&c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L1000;
    }
    i__2 = min(lnop5,*lnop5x);
    for (i = 1; i <= i__2; ++i) {
	i__1 = do_uio(&c__1, (char *)&nop5[i], (ftnlen)sizeof(integer));
	if (i__1 != 0) {
	    goto L1000;
	}
    }
    i__1 = e_rsue();
    if (i__1 != 0) {
	goto L1000;
    }
    s_wsle(&io___191);
    do_lio(&c__9, &c__1, "fin lecture nopo5", 17L);
    e_wsle();
    *err = 99;
    if (lnop5 > *lnop5x) {
	scrtch_("Le fichier NOPO est trop gros", 29L);
	return 0;
    }
    i5 = 1;
    *nbt1 = bdmsh1_1.nbt;
    i__1 = *ne;
    for (ie = 1; ie <= i__1; ++ie) {
	++(*nbt1);
	addnp5_(&nop5[1], &i5, ncopnp, &bdmsha_1.reft[*nbt1 - 1], &npo, nopoi,
		 nref, err);
	if (*err != 0) {
	    return 0;
	}
	if (npo != 3 && npo != 4) {
	    s_wsle(&io___197);
	    do_lio(&c__9, &c__1, " le nb de point de l'element est # 3 4", 
		    38L);
	    do_lio(&c__3, &c__1, (char *)&npo, (ftnlen)sizeof(integer));
	    e_wsle();
	    *err = 1004;
	    return 0;
	}
/*       print *,'t=',ie,',npo=',npo,'reft=',reft(nbt1) */
/*     &        ,'ref=',(nref(i),i=1,npo+npo) */
	bdmsh9_1.nsea[*nbt1 * 6 - 6] = nopoi[0];
	bdmsh9_1.nsea[*nbt1 * 6 - 5] = nopoi[1];
	bdmsh9_1.nsea[*nbt1 * 6 - 4] = nopoi[2];
	bdmsh9_1.nsea[*nbt1 * 6 - 3] = nref[npo];
	bdmsh9_1.nsea[*nbt1 * 6 - 2] = nref[npo + 1];
	bdmsh9_1.nsea[*nbt1 * 6 - 1] = nref[npo + 2];
	bdmshb_1.apavue[*nbt1 - 1] = 0;
	if (npo == 4) {
	    bdmshb_1.apavue[*nbt1 - 1] = 3;
	    bdmsh9_1.nsea[*nbt1 * 6 - 1] = 0;
	    ++(*nbt1);
	    bdmsha_1.reft[*nbt1 - 1] = bdmsha_1.reft[*nbt1 - 2];
	    bdmsh9_1.nsea[*nbt1 * 6 - 6] = nopoi[0];
	    bdmsh9_1.nsea[*nbt1 * 6 - 5] = nopoi[2];
	    bdmsh9_1.nsea[*nbt1 * 6 - 4] = nopoi[3];
	    bdmsh9_1.nsea[*nbt1 * 6 - 3] = 0;
	    bdmsh9_1.nsea[*nbt1 * 6 - 2] = nref[npo + 2];
	    bdmsh9_1.nsea[*nbt1 * 6 - 1] = nref[npo + 3];
	    bdmshb_1.apavue[*nbt1 - 1] = 1;
	}
	i__2 = npo;
	for (i = 1; i <= i__2; ++i) {
	    bdmsh8_1.refs[nopoi[i - 1] + bdmsh1_1.nbs - 1] = nref[i - 1];
/* L10: */
	}
/* L20: */
    }
    *err = 0;
    s_wsle(&io___198);
    do_lio(&c__9, &c__1, " return addnop", 14L);
    e_wsle();
    return 0;
L1000:
    s_wsle(&io___199);
    do_lio(&c__9, &c__1, "ERREUR de lecture", 17L);
    e_wsle();
    return 0;
} /* addnop_ */

#undef nop2
#undef ncopnp
#undef np
#undef tri
#undef coulls
#undef ne
/*#undef xwork*/
#undef ntri
#undef nqua
#undef ndim


/* Subroutine */ int addnp5_(integer *m, integer *ia, integer *ncopnp, 
	integer *ndsde, integer *npo, integer *nopoi, integer *nref, integer *
	err)
{
    /* Initialized data */

    /*static*/ integer ns[2] = { 3,4 };
    /*static*/ integer na[2] = { 3,4 };
    /*static*/ integer ng[2] = { 6,8 };

    /* Format strings */
/*    static char fmt_9998[] = "(\002 il y a une incompatibilite entre les num"
	    "eros de \002,\002references et le type de l element\002,/,/,\002"
	    " ining =\002,i9,/,\002 ncge =\002,i9,/,/,\002ERREUR dans addnp"
	    "5\002,/,132(\002&\002))";*/

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void);

    /* Local variables */
    integer ncge, nmae, i, ining, k1, ka, ks;

    /* Fortran I/O blocks */
    /*static*/ cilist io___204 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___211 = { 0, 6, 0,  "(\002 il y a une incompatibilite entre les num"
	    "eros de \002,\002references et le type de l element\002,/,/,\002"
	    " ining =\002,i9,/,\002 ncge =\002,i9,/,/,\002ERREUR dans addnp"
	    "5\002,/,132(\002&\002))", 0 };
    /*static*/ cilist io___212 = { 0, 6, 0, 0, 0 };


/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
*/
/*             s.p. addnp5 */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
*/
/*  but : clear le tableau nop5 */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
*/
/*  programmeur : f. hecht inria */
/* ...................................................................... 
*/
    /* Parameter adjustments */
    --nref;
    --nopoi;
    --m;

    /* Function Body */
    *err = 0;
    ncge = m[*ia];
    if (ncge != 3 && ncge != 4) {
	s_wsle(&io___204);
	do_lio(&c__9, &c__1, "addnop5: ERREUR type de l'element =", 35L);
	do_lio(&c__3, &c__1, (char *)&ncge, (ftnlen)sizeof(integer));
	e_wsle();
	*err = -105;
	return 0;
    }
    ++(*ia);
    nmae = m[*ia];
    ++(*ia);
    *ndsde = m[*ia];
    ++(*ia);
    *npo = m[*ia];
    if (*npo > 5 && *ncopnp == 1) {
	goto L9995;
    }
    i__1 = *npo;
    for (i = 1; i <= i__1; ++i) {
	++(*ia);
	if (*ncopnp == 1) {
	    nopoi[i] = m[*ia];
	}
/* L1: */
    }
    if (*ncopnp != 1) {
	++(*ia);
	*npo = m[*ia];
	if (*npo > 5) {
	    goto L9995;
	}
	i__1 = *npo;
	for (i = 1; i <= i__1; ++i) {
	    ++(*ia);
	    nopoi[i] = m[*ia];
/* L2: */
	}
    }
    i__1 = ng[ncge - 3];
    for (i = 1; i <= i__1; ++i) {
	nref[i] = 0;
/* L5: */
    }
    ++(*ia);
    if (nmae == 0) {
	return 0;
    }
    if (ncge > 7) {
	return 0;
    }
    ining = m[*ia];
    ks = ns[ncge - 3];
    ka = ks + na[ncge - 3];
    switch (ining) {
	case 1:  goto L30;
	case 2:  goto L40;
	case 3:  goto L50;
    }
L30:
    *err = -1005;
    return 0;
L40:
    k1 = ks + 1;
    if (k1 > ka) {
	goto L9999;
    }
    i__1 = ka;
    for (i = k1; i <= i__1; ++i) {
	++(*ia);
	nref[i] = m[*ia];
/* L7: */
    }
L50:
    k1 = 1;
    if (k1 > ks) {
	goto L9999;
    }
    i__1 = ks;
    for (i = 1; i <= i__1; ++i) {
	++(*ia);
	nref[i] = m[*ia];
/* L8: */
    }
    ++(*ia);
    return 0;
L9999:
    s_wsfe(&io___211);
    do_fio(&c__1, (char *)&ining, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&ncge, (ftnlen)sizeof(integer));
    e_wsfe();
    *err = 1;
    return 0;
L9995:
    s_wsle(&io___212);
    do_lio(&c__9, &c__1, " nb point trop grand dans nop5 ", 31L);
    do_lio(&c__3, &c__1, (char *)&(*npo), (ftnlen)sizeof(integer));
    e_wsle();
    *err = 2;
    return 0;
} /* addnp5_ */

/* Subroutine */ int addomn_(integer *ptdomn)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4;

    /* Local variables */
    extern integer cons_(integer *, integer *);



/*     ptdomn=pointeur sur nouveau domaine cree */
/*     elle cree les listes initiales d'un domaine */


    i__3 = cons_(&c__0, &c__0);
    i__2 = cons_(&i__3, &c__0);
    i__1 = cons_(&i__2, &c__0);
    bdpec1_1.sdomn = cons_(&i__1, &bdpec1_1.sdomn);
    *ptdomn = bdpec1_1.sdomn;
/*     liste pour decoupage en triangles ou en quadrangles */
/*     initialement: nil     ,nil     , triangles ,oui    ,oui */
/*                   ^         ^                   ^        ^ */
/*                 @ 1er ,   @ 2iem               coins , regulier */
/*                 element   element */
    i__4 = cons_(&c__0, &c__0);
    i__3 = cons_(&c__0, &i__4);
    i__2 = cons_(&c__0, &i__3);
    i__1 = cons_(&c__0, &i__2);
    listed_1.cdr[listea_1.car[listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1]
	     - 1] = cons_(&c__309, &i__1);
    return 0;
} /* addomn_ */




/* Subroutine */ int addray_(real *c, real *r, real *cc)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer i;


/*     dans cc on retrouve c plus r */



    for (i = 0; i <= 3; ++i) {
/* L10: */
	cc[i] = c[i];
    }
    if (c[0] >= 0.f) {
	cc[0] = (r__1 = c[0] + *r, dabs(r__1));
    } else if (c[0] == -1.f) {
/* Computing 2nd power */
	r__1 = c[1];
/* Computing 2nd power */
	r__2 = c[2];
	cc[3] = c[3] + *r * sqrt(r__1 * r__1 + r__2 * r__2);
    }
    return 0;
} /* addray_ */

#undef coulls


/* Subroutine */ int addref_(integer *k, integer *aw, integer *la, integer *
	nbs1, integer *nba1, integer *nbt1, integer *nbsd1, integer *nbd3, 
	integer *err)
{
    /* Initialized data */

    /*static*/ integer p3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i, j, t;

    integer r, i1, i2, j1, j2, ie;
    integer pt, laa;

    /* Fortran I/O blocks */
    /*static*/ cilist io___230 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___231 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___233 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    aw -= 4;
    --k;

    /* Function Body */
    *err = 0;
    i__1 = *nbs1;
    for (i = 1; i <= i__1; ++i) {
	k[i] = 0;
/* L110: */
    }
    laa = 0;
    i__1 = *nbt1;
    for (ie = bdmsh1_1.nbt + 1; ie <= i__1; ++ie) {
	for (i = 1; i <= 3; ++i) {
	    j1 = bdmsh9_1.nsea[i + ie * 6 - 7];
	    j2 = bdmsh9_1.nsea[p3[i - 1] + ie * 6 - 7];
	    i1 = min(j1,j2);
	    i2 = max(j1,j2);
	    pt = k[i1];
L130:
	    if (pt == 0) {
		++laa;
		if (laa > *la) {
		    s_wsle(&io___230);
		    do_lio(&c__9, &c__1, " fatal ERROR addref: la taille du "
			    "tableau a (1:", 47L);
		    do_lio(&c__3, &c__1, (char *)&(*la), (ftnlen)sizeof(
			    integer));
		    do_lio(&c__9, &c__1, ") est insuffisant =", 19L);
		    i__2 = (*nbt1 - bdmsh1_1.nbt << 1) + (*nbs1 - 
			    bdmsh1_1.nbs) + 10;
		    do_lio(&c__3, &c__1, (char *)&i__2, (ftnlen)sizeof(
			    integer));
		    e_wsle();
		    *err = 4;
		    return 0;
		}
		aw[laa * 3 + 1] = k[i1];
		aw[laa * 3 + 2] = i2;
		aw[laa * 3 + 3] = bdmsh9_1.nsea[i + 3 + ie * 6 - 7];
		k[i1] = laa;
		bdmsh9_1.nsea[i + 3 + ie * 6 - 7] = laa;
	    } else {
		if (i2 == aw[pt * 3 + 2]) {
		    bdmsh9_1.nsea[i + 3 + ie * 6 - 7] = pt;
		} else {
		    pt = aw[pt * 3 + 1];
		    goto L130;
		}
	    }
/* L140: */
	}
/* L150: */
    }
    s_wsle(&io___231);
    do_lio(&c__9, &c__1, " le nb de trou du maillage lu est = ", 36L);
    i__1 = -(*nbt1 - bdmsh1_1.nbt) + laa - (*nbs1 - bdmsh1_1.nbs) + 1;
    do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " si le maillage est connexe", 27L);
    e_wsle();
    i__1 = laa;
    for (i = 1; i <= i__1; ++i) {
	aw[i * 3 + 1] = 0;
	aw[i * 3 + 2] = 0;
/* L155: */
    }
    i__1 = *nbt1;
    for (ie = bdmsh1_1.nbt + 1; ie <= i__1; ++ie) {
	for (i = 4; i <= 6; ++i) {
	    j = bdmsh9_1.nsea[i + ie * 6 - 7];
	    if (aw[j * 3 + 1] == 0 && aw[j * 3 + 2] == 0) {
		aw[j * 3 + 1] = ie;
		aw[j * 3 + 2] = i;
	    } else {
		if (aw[j * 3 + 1] > 0) {
		    if (bdmsha_1.reft[aw[j * 3 + 1] - 1] == bdmsha_1.reft[ie 
			    - 1] && aw[j * 3 + 3] == 0) {
			aw[j * 3 + 1] = 0;
			aw[j * 3 + 2] = 1;
		    } else {
			aw[j * 3 + 1] = -ie;
			aw[j * 3 + 2] = i;
		    }
		} else {
		    s_wsle(&io___233);
		    do_lio(&c__9, &c__1, "il y a des aretes referencees plus"
			    " de 2 fois", 44L);
		    e_wsle();
		    *err = 3;
		    return 0;
		}
	    }
/* L160: */
	}
/* L170: */
    }
    i__1 = *nbs1;
    for (i = bdmsh1_1.nbs + 1; i <= i__1; ++i) {
	k[i] = 0;
	if (bdmsh8_1.refs[i - 1] != 0) {
	    ++(*nbd3);
	    if (*nbd3 > bdpec1_1.mxbd) {
		return 0;
	    }
	    k[i] = *nbd3;
	    bdpec2_1.bd[*nbd3 * 6 + 384] = 0.f;
	    bdpec2_1.bd[*nbd3 * 6 + 385] = bdmsh5_1.cr[(i << 1) - 2];
	    bdpec2_1.bd[*nbd3 * 6 + 386] = bdmsh5_1.cr[(i << 1) - 1];
	    bdpec5_1.nuref[(*nbd3 << 1) + 128] = bdmsh8_1.refs[i - 1];
	    bdpec5_1.nuref[(*nbd3 << 1) + 129] = bdmsh8_1.refs[i - 1];
	    bdpecd_1.fissur[*nbd3 + 64] = FALSE_;
	    bdmsh8_1.refs[i - 1] = *nbd3;
	}
/* L180: */
    }
    i__1 = laa;
    for (i = 1; i <= i__1; ++i) {
	if (aw[i * 3 + 1] != 0) {
	    i1 = bdmsh9_1.nsea[p3[aw[i * 3 + 2] - 4] + (i__2 = aw[i * 3 + 1], 
		    abs(i__2)) * 6 - 7];
	    i2 = bdmsh9_1.nsea[aw[i * 3 + 2] - 3 + (i__2 = aw[i * 3 + 1], abs(
		    i__2)) * 6 - 7];
	    if (k[i1] == 0) {
		++(*nbd3);
		if (*nbd3 > bdpec1_1.mxbd) {
		    return 0;
		}
		k[i1] = *nbd3;
		bdpec2_1.bd[*nbd3 * 6 + 384] = 0.f;
		bdpec2_1.bd[*nbd3 * 6 + 385] = bdmsh5_1.cr[(i1 << 1) - 2];
		bdpec2_1.bd[*nbd3 * 6 + 386] = bdmsh5_1.cr[(i1 << 1) - 1];
		bdpec5_1.nuref[(*nbd3 << 1) + 128] = bdmsh8_1.refs[i1 - 1];
		bdpec5_1.nuref[(*nbd3 << 1) + 129] = bdmsh8_1.refs[i1 - 1];
		bdpecd_1.fissur[*nbd3 + 64] = FALSE_;
		bdmsh8_1.refs[i1 - 1] = *nbd3;
	    }
	    if (k[i2] == 0) {
		++(*nbd3);
		if (*nbd3 > bdpec1_1.mxbd) {
		    return 0;
		}
		k[i2] = *nbd3;
		bdpec2_1.bd[*nbd3 * 6 + 384] = 0.f;
		bdpec2_1.bd[*nbd3 * 6 + 385] = bdmsh5_1.cr[(i2 << 1) - 2];
		bdpec2_1.bd[*nbd3 * 6 + 386] = bdmsh5_1.cr[(i2 << 1) - 1];
		bdpec5_1.nuref[(*nbd3 << 1) + 128] = bdmsh8_1.refs[i2 - 1];
		bdpec5_1.nuref[(*nbd3 << 1) + 129] = bdmsh8_1.refs[i2 - 1];
		bdpecd_1.fissur[*nbd3 + 64] = FALSE_;
		bdmsh8_1.refs[i2 - 1] = *nbd3;
	    }
	    ++(*nbd3);
	    if (*nbd3 > bdpec1_1.mxbd) {
		return 0;
	    }
	    bdpec2_1.bd[*nbd3 * 6 + 384] = -3.f;
	    bdpec2_1.bd[*nbd3 * 6 + 385] = bdmsh5_1.cr[(i1 << 1) - 2];
	    bdpec2_1.bd[*nbd3 * 6 + 386] = bdmsh5_1.cr[(i1 << 1) - 1];
	    bdpec2_1.bd[*nbd3 * 6 + 387] = bdmsh5_1.cr[(i2 << 1) - 2];
	    bdpec2_1.bd[*nbd3 * 6 + 388] = bdmsh5_1.cr[(i2 << 1) - 1];
	    bdpec5_1.nuref[(*nbd3 << 1) + 128] = aw[i * 3 + 3];
	    bdpec5_1.nuref[(*nbd3 << 1) + 129] = aw[i * 3 + 3];
	    bdpec6_1.nuref1[(*nbd3 << 1) + 128] = k[i1];
	    bdpec6_1.nuref1[(*nbd3 << 1) + 129] = k[i1];
	    bdpec7_1.nuref2[(*nbd3 << 1) + 128] = k[i2];
	    bdpec7_1.nuref2[(*nbd3 << 1) + 129] = k[i2];
	    bdpec8_1.adp1[*nbd3 + 64] = k[i1];
	    bdpec9_1.adp2[*nbd3 + 64] = k[i2];
	    bdpec4_1.raison[*nbd3 + 64] = 1.f;
	    bdpec3_1.nbnode[*nbd3 + 64] = 2;
	    bdpecd_1.fissur[*nbd3 + 64] = FALSE_;
	    ++(*nba1);
	    if (*nba1 > bdmsh0_1.nbamx) {
		return 0;
	    }
	    bdmshc_1.aretbd[(*nba1 << 1) - 2] = i1;
	    bdmshc_1.aretbd[(*nba1 << 1) - 1] = i2;
	    bdmshe_1.refa[*nba1 - 1] = *nbd3;
	}
/* L200: */
    }
    *nbsd1 = bdmsh1_1.nbsd;
    i__1 = *nbt1;
    for (t = bdmsh1_1.nbt + 1; t <= i__1; ++t) {
	r = bdmsha_1.reft[t - 1];
	i__2 = *nbsd1;
	for (i = bdmsh1_1.nbsd + 1; i <= i__2; ++i) {
	    if (r == bdmshf_1.refsd[i - 1]) {
		goto L15;
	    }
/* L10: */
	}
	++(*nbsd1);
	i = *nbsd1;
	if (*nbsd1 > bdmsh0_1.nbsdmx) {
	    return 0;
	}
	bdmshi_1.strfsd[*nbsd1 - 1] = 1;
	bdmshf_1.refsd[*nbsd1 - 1] = r;
	bdmsh2_1.tetsd[*nbsd1 - 1] = 1073741824;
	bdmshj_1.ptorsd[*nbsd1 - 1] = *nbsd1;
L15:
	bdmsha_1.reft[t - 1] = bdmsh2_1.tetsd[i - 1];
	bdmsh2_1.tetsd[i - 1] = t;
/* L30: */
    }
    return 0;
} /* addref_ */




integer adjatr_(integer *tete)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *), cons_(integer *, 
	    integer *);
    integer indx;

    real x1, y1, x2, y2;
    integer i, k, *extrm/*[1024]*/;
    extern /* Subroutine */ int freel_(integer *);
    extern doublereal atgadj_(integer *, integer *, real *, real *, real *, 
	    real *);
    real * criter/*[1024]*/;
    integer *ref/*[1024]*/, pt;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), srtri2_(real *, 
	    integer *, integer *, integer *);

    assert( ref = (integer*) malloc(sizeof(integer)*1024));
    assert( extrm = (integer*) malloc(sizeof(integer)*1024));
    assert( criter = (real*) malloc(sizeof(real)*1024));

/*     in ; */
/*         tete = tete de liste des elements de bd dont une extremitee es 
*/
/*             chaque cons a son car qui pointe sur un cons dont le car p 
*/
/*             la bd et dont le cdr est le numero de l'extremitee qui pas 
*/
/*     out: */
/*     la liste est triee par angle/ox croissant des tangentes aux adjace 
*/
/*     les recherches se font entre 1 et ptbd */


    ret_val = 0;
    indx = 0;
    pt = *tete;
L1:
/*     pour tous les elements adjacents au point */
    if (pt != 0) {
	i = caar_(&pt);
	k = cdar_(&pt);
	x1 = bdpec2_1.bd[bdpec8_1.adp1[i + 64] * 6 + 385];
	y1 = bdpec2_1.bd[bdpec8_1.adp1[i + 64] * 6 + 386];
	x2 = bdpec2_1.bd[bdpec9_1.adp2[i + 64] * 6 + 385];
	y2 = bdpec2_1.bd[bdpec9_1.adp2[i + 64] * 6 + 386];
/*       calcul de l'angle/ox de la tangente a l'adjacent */
	++indx;
	if (indx > 1024) {
	    scrtch_("ADJATR:ERREUR: PLUS DE PLACE POUR TRIER", 39L);
	    free(ref);free(extrm);free(criter);
	    return ret_val;
	}
	if (k == 1) {
	    criter[indx - 1] = atgadj_(&i, &k, &x1, &y1, &x2, &y2);
	} else {
	    criter[indx - 1] = atgadj_(&i, &k, &x2, &y2, &x1, &y1);
	}
	ref[indx - 1] = i;
	extrm[indx - 1] = k;
	pt = listed_1.cdr[pt - 1];
	goto L1;
    }
/*     trie des elements adjacents en xx,yy */
    if (indx == 0) {
/*       pas d'adjacents en ce point */
    free(ref);free(extrm);free(criter);
	return ret_val;
    } else if (indx > 1) {
/*       trie selon criter croissant */
	srtri2_(criter, ref, extrm, &indx);
    }
    for (i = indx; i >= 1; --i) {
	i__1 = cons_(&ref[i - 1], &extrm[i - 1]);
	ret_val = cons_(&i__1, &ret_val);
/* L2: */
    }
    freel_(tete);
    free(ref);free(extrm);free(criter);
    return ret_val;
} /* adjatr_ */




/* Subroutine */ int afcalc_(void)
{
    /* Format strings */
    /*static*/ char fmt_1[] = "(g12.6)";

    /* System generated locals */
    real r__1, r__2;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);

    extern /* Subroutine */ int thick_(real *), fentr2_(real *, real *, real *
	    , real *), masqu2_(real *, real *, real *, real *), drw3tx_(real *
	    , real *, integer *);
    char buf[12];
    extern /* Subroutine */ int noirci_(real *), limits_(integer *);


/*     elle affiche la valeur de la calculette dans la fenetre reservee */
/*          (mxmenu-2) */


    noirci_(&pec_1.fmenu[52]);
    ligh3_(&c_n1, &c_n1, &pec_1.colomn[13]);
    fentr2_(&pec_1.fmenu[52], &pec_1.fmenu[53], &pec_1.fmenu[54], &
	    pec_1.fmenu[55]);
    masqu2_(&pec_1.fmenu[52], &pec_1.fmenu[53], &pec_1.fmenu[54], &
	    pec_1.fmenu[55]);
    thick_(&c_b604);
/*     materialisation du cadre reserve */
    limits_(&c__0);
/*     ecriture de la valeur de la calculette */
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 12;
    ici__1.iciunit = buf;
    ici__1.icifmt = fmt_1;
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&cdesig_1.numer, (ftnlen)sizeof(real));
    e_wsfi();
    drw3tx_(&pec_1.szchmn[13], &c_b609, &c__0);
    r__1 = pec_1.fmenu[52] + .1f;
    r__2 = pec_1.fmenu[54] + .1f;
    txt2d_(buf, &c__12, &r__1, &r__2, 12L);
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* afcalc_ */


