#include <assert.h>
#include <stdlib.h>

#include "emc2_h.h"

/* Subroutine */ int ptangc_(real *pp, real *pp1, integer *ad, real *pj)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real dist, pptg[6];

    extern /* Subroutine */ int ptgcc_(real *, real *, real *, real *);
    real tg[3];
    extern /* Subroutine */ int scrtch_(char *, ftnlen);


/*      on sort pj la deuxieme extremitee du segment tangent a bd(ad) en 
*/
/*      allant de pp a pj dans le sens de bd(ad) */
/*      pp1 est le support de bd(ad) */



/*       print*,'on calcul la tangente en ce point a la contrainte' */
    ptgcc_(pptg, pp, pp1, &c_b609);
    if (pptg[0] == -1e3f) {
	scrtch_("ERREUR:PTANGC:PEUT PAS CALCULER LE POINT DE TANGENCE", 52L);
	pptg[1] = pp[1];
	pptg[2] = pp[2];
    }
    tg[0] = 0.f;
    tg[1] = -(doublereal)(pptg[2] - bdpec2_1.bd[*ad * 6 + 386]);
    tg[2] = pptg[1] - bdpec2_1.bd[*ad * 6 + 385];
/* Computing 2nd power */
    r__1 = tg[1];
/* Computing 2nd power */
    r__2 = tg[2];
    dist = sqrt(r__1 * r__1 + r__2 * r__2);
    tg[1] /= dist;
    tg[2] /= dist;
    if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
/*        la contrainte est un arc, le segment va aller dans son sens 
*/
/*        tangente au point pptg de l'arc orientee dans son sens */
	if (bdpec2_1.bd[*ad * 6 + 389] < 0.f) {
	    tg[1] = -(doublereal)tg[1];
	    tg[2] = -(doublereal)tg[2];
	}
    }
    pj[1] = pptg[1] + tg[1] * etat_1.distan;
    pj[2] = pptg[2] + tg[2] * etat_1.distan;
    return 0;
} /* ptangc_ */




/* Subroutine */ int ptgcc_(real *ptg, real *c1, real *c2, real *v)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int itd1d_(real *, real *, real *), pjp1d_(real *,
	     real *, real *, real *);
    real r1, r2, pp[4];
    real r1r2, dc1c2;


/*     rend ptg le point de tangence entre c1 et c2 */


    ptg[0] = -1e3f;
    if (c1[0] >= 0.f) {
	if (c2[0] == -1.f) {
	    r__1 = -(doublereal)(*v);
	    pjp1d_(ptg, c1, c2, &r__1);
	} else if (c2[0] >= 0.f) {
/* Computing 2nd power */
	    r__1 = c2[1] - c1[1];
/* Computing 2nd power */
	    r__2 = c2[2] - c1[2];
	    dc1c2 = sqrt(r__1 * r__1 + r__2 * r__2);
	    r1 = c1[0];
	    r2 = c2[0];
	    if (dc1c2 <= r1 || dc1c2 <= r2) {
		if (r1 > r2) {
		    r2 = -(doublereal)r2;
		} else {
		    r1 = -(doublereal)r1;
		}
	    }
	    r1r2 = r1 + r2;
	    if (dc1c2 > eps_1.eps && r1r2 > eps_1.eps) {
		ptg[0] = 0.f;
		ptg[1] = (c1[1] * r2 + c2[1] * r1) / r1r2;
		ptg[2] = (c1[2] * r2 + c2[2] * r1) / r1r2;
	    } else {
		ptg[0] = 0.f;
		ptg[1] = (c1[1] + c2[1]) * .5f;
		ptg[2] = (c1[2] + c2[2]) * .5f;
	    }
	}
    } else if (c1[0] == -1.f) {
	if (c2[0] >= 0.f) {
	    r__1 = -(doublereal)(*v);
	    pjp1d_(ptg, c2, c1, &r__1);
	} else if (c2[0] == -1.f) {
/*        c2 est une droite */
	    itd1d_(pp, c1, c2);
	    r__1 = -(doublereal)(*v);
	    pjp1d_(ptg, pp, c2, &r__1);
	}
    }
    return 0;
} /* ptgcc_ */

#undef coulls


/* Subroutine */ int qboite_(void)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */
    integer imax;
    real xmin, ymin, xmax, ymax;

    integer i;
    real fx, fy, dx, dy, fxm, fym;



/*     calcul la boite de travail et le eps */

    xmin = 1e30f;
    xmax = -1e30f;
    ymin = 1e30f;
    ymax = -1e30f;
    if (pec_1.appli == 511) {
	imax = bdpec1_1.ptbd;
    } else if (pec_1.appli == 513) {
	imax = bdpec1_1.finbd;
    } else if (pec_1.appli == 514) {
	imax = bdmsh4_1.finbd3;
    } else {
/* Computing MAX */
	i__1 = max(bdpec1_1.ptbd,bdpec1_1.finbd);
	imax = max(i__1,bdmsh4_1.finbd3);
/*        print*,'qboite: appli=',appli */
    }
    i__1 = imax;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == 0.f) {
/*         point */
/* Computing MIN */
	    r__1 = xmin, r__2 = bdpec2_1.bd[i * 6 + 385];
	    xmin = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = xmax, r__2 = bdpec2_1.bd[i * 6 + 385];
	    xmax = dmax(r__1,r__2);
/* Computing MIN */
	    r__1 = ymin, r__2 = bdpec2_1.bd[i * 6 + 386];
	    ymin = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = ymax, r__2 = bdpec2_1.bd[i * 6 + 386];
	    ymax = dmax(r__1,r__2);
	} else if (bdpec2_1.bd[i * 6 + 384] == -3.f) {
/* Computing MIN */
	    r__1 = xmin, r__2 = bdpec2_1.bd[i * 6 + 385], r__1 = min(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 387];
	    xmin = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = xmax, r__2 = bdpec2_1.bd[i * 6 + 385], r__1 = max(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 387];
	    xmax = dmax(r__1,r__2);
/* Computing MIN */
	    r__1 = ymin, r__2 = bdpec2_1.bd[i * 6 + 386], r__1 = min(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 388];
	    ymin = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = ymax, r__2 = bdpec2_1.bd[i * 6 + 386], r__1 = max(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 388];
	    ymax = dmax(r__1,r__2);
	} else if (bdpec2_1.bd[i * 6 + 384] == -2.f) {
	    dx = bdpec2_1.bd[i * 6 + 387] - bdpec2_1.bd[i * 6 + 385];
	    dy = bdpec2_1.bd[i * 6 + 388] - bdpec2_1.bd[i * 6 + 386];
	    fx = bdpec2_1.bd[i * 6 + 385] + dx * cos(bdpec2_1.bd[i * 6 + 389])
		     - dy * sin(bdpec2_1.bd[i * 6 + 389]);
	    fy = bdpec2_1.bd[i * 6 + 386] + dx * sin(bdpec2_1.bd[i * 6 + 389])
		     + dy * cos(bdpec2_1.bd[i * 6 + 389]);
	    fxm = bdpec2_1.bd[i * 6 + 385] + dx * cos(bdpec2_1.bd[i * 6 + 389]
		     * .5f) - dy * sin(bdpec2_1.bd[i * 6 + 389] * .5f);
	    fym = bdpec2_1.bd[i * 6 + 386] + dx * sin(bdpec2_1.bd[i * 6 + 389]
		     * .5f) + dy * cos(bdpec2_1.bd[i * 6 + 389] * .5f);
/* Computing MIN */
	    r__1 = xmin, r__2 = bdpec2_1.bd[i * 6 + 385], r__1 = min(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 387], r__1 = min(r__1,
		    r__2), r__1 = min(r__1,fx);
	    xmin = dmin(r__1,fxm);
/* Computing MAX */
	    r__1 = xmax, r__2 = bdpec2_1.bd[i * 6 + 385], r__1 = max(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 387], r__1 = max(r__1,
		    r__2), r__1 = max(r__1,fx);
	    xmax = dmax(r__1,fxm);
/* Computing MIN */
	    r__1 = ymin, r__2 = bdpec2_1.bd[i * 6 + 386], r__1 = min(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 388], r__1 = min(r__1,
		    r__2), r__1 = min(r__1,fy);
	    ymin = dmin(r__1,fym);
/* Computing MAX */
	    r__1 = ymax, r__2 = bdpec2_1.bd[i * 6 + 386], r__1 = max(r__1,
		    r__2), r__2 = bdpec2_1.bd[i * 6 + 388], r__1 = max(r__1,
		    r__2), r__1 = max(r__1,fy);
	    ymax = dmax(r__1,fym);
	}
/* L1: */
    }
    if (xmax == -1e30f || xmin == 1e30f || ymax == -1e30f || ymin == 1e30f) {
	xmin = pec_1.masque[0];
	xmax = pec_1.masque[1];
	ymin = pec_1.masque[2];
	ymax = pec_1.masque[3];
    }
    etat_1.boite[0] = xmax - xmin;
    etat_1.boite[1] = ymax - ymin;
    etat_1.boite[2] = xmin;
    etat_1.boite[3] = ymin;
    eps_1.eps = dmax(etat_1.boite[0],etat_1.boite[1]) * 5e-6f;
    return 0;
} /* qboite_ */




/* Subroutine */ int razbd_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */

    integer i;
    extern /* Subroutine */ int inilst_(void);



/*      raz de la bd */

    i__1 = bdpec1_1.mxbd;
    for (i = -64; i <= i__1; ++i) {
/*        nbnode(i)=2 */
/*        raison(i)=1. */
/*        nuref(gauche,i) =0 */
/*        nuref(droit,i) =0 */
/*        nuref1(gauche,i) =0 */
/*        nuref1(droit,i) =0 */
/*        nuref2(gauche,i) =0 */
/*        nuref2(droit,i) =0 */
/*        adjabd(i)=nil */
	bdpec8_1.adp1[i + 64] = 0;
	bdpec9_1.adp2[i + 64] = 0;
	bdpecd_1.fissur[i + 64] = FALSE_;
/*        do 2 j=0,5 */
/*          bd(j,i)=vide */
/* 2       continue */
	bdpec2_1.bd[i * 6 + 384] = -1e3f;
/* L1: */
    }
    bdpec1_1.ptbd = 0;
    bdpec1_1.finbd = 0;
    bdmsh4_1.finbd3 = 0;
    bdmsh1_1.nbt = 0;
    bdmsh1_1.nbs = 0;
    bdmsh1_1.nba = 0;
    bdmsh1_1.nbsd = 0;
    bdmsh1_1.nbtria = 0;
    bdmsh1_1.nbquad = 0;
/*     init pour les listes */
    bdpec1_1.comp = 0;
    bdpec1_1.sdomn = 0;
    bdpec1_1.link = 0;
    inilst_();
    return 0;
} /* razbd_ */




/* Subroutine */ int raztag_(integer *tag, integer *n)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i;

    /* Parameter adjustments */
    --tag;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
/* L1: */
	tag[i] = 0;
    }
    return 0;
} /* raztag_ */

integer rcpnt1_(integer *n, real *x, real *c, integer *i, real *coef)
{
    /* System generated locals */
    integer c_dim1, c_offset, ret_val, i__1;

    /* Local variables */
    integer j, k;

/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  BUT : SUBROUTINE DE RCPNTS */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  PROGRAMMEUR :  F.HECHT INRIA  MAI 1986 */
/*  ................................................................... */
    /* Parameter adjustments */
    c_dim1 = *n;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    x -= 3;

    /* Function Body */
    k = 1;
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	k *= (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef) + 1;
/* L10: */
    }
    ret_val = k;
    return ret_val;
} /* rcpnt1_ */

/* Subroutine */ int rcpnt2_(integer *n, real *x, real *c, integer *i, 
	integer *cas, integer *nbcas, real *coef)
{
    /* System generated locals */
    integer c_dim1, c_offset, i__1, i__2;

    /* Local variables */
    integer j, k, i1, i2;

/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  BUT : SUBROUTINE DE RCPNTS */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  PROGRAMMEUR :  F.HECHT INRIA   MAI 1986 */
/*  ................................................................... */
/* Computing 2nd power */
    i__1 = *n;
    /* Parameter adjustments */
    --cas;
    c_dim1 = *n;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    x -= 3;

    /* Function Body */
    *nbcas = 1;
/*       K = 1 */
    cas[1] = 1;
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	i1 = (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef - .25f)
		 + 1;
	i2 = (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef + .25f)
		 + 1;
	if (i1 != i2) {
	    i__2 = *nbcas;
	    for (k = 1; k <= i__2; ++k) {
		cas[k + *nbcas] = cas[k] * i2;
		cas[k] *= i1;
/* L10: */
	    }
	    *nbcas += *nbcas;
	} else {
	    i__2 = *nbcas;
	    for (k = 1; k <= i__2; ++k) {
		cas[k] *= i1;
/* L20: */
	    }
	}
/* L30: */
    }
    return 0;
} /* rcpnt2_ */

/* Subroutine */ int rcpnts_(integer *n, real *c1, integer *n1, real *c2, 
	integer *n2, integer *p1, integer *p2, real *eps, integer *hcd, 
	integer *nbhcd, integer *nbpoc)
{
    /* Format strings */
    static char fmt_200[] = "(\002 %% ERREUR RCPNTS : DIMENSION DE L'ESPACE "
	    "<1 OU >3 \002)";

    /* System generated locals */
    integer c1_dim1, c1_offset, c2_dim1, c2_offset, i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    real coef, epsr;
    integer i, j, k, l, p, nbcas;
    real x[6]	/* was [2][3] */;
    extern integer iinfo_(char *, ftnlen);
    extern /* Subroutine */ int arret_(integer *);
    extern integer rcpnt1_(integer *, real *, real *, integer *, real *);
    extern /* Subroutine */ int rcpnt2_(integer *, real *, real *, integer *, 
	    integer *, integer *, real *);
    integer imprim, cas[8];

    /* Fortran I/O blocks */
    /*static*/ cilist io___2887 = { 0, 0, 0, fmt_200, 0 };


/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  BUT : RETROUVER LES POINT EGAUX DES 2 ENSEMBLES DE POINTS */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  PARAMETRES : */
/*  ---------- */
/*  ENTREE : */
/*       N             DIMENSION DE L'ESPACE 1 ,2, OU 3 */
/*       C1(1:N,1:N1)  TABLEAU DES COORDONNEES DES POINTS DE L'ENSEMBLE 1 
*/
/*       N1            NB DE POINTS DE L'ENSEMBLE 1 */
/*       C2(1:N,1:N2)  TABLEAU DES COORDONNEES DES POINTS DE L'ENSEMBLE 2 
*/
/*       N2            NB DE POINTS DE L'ENSEMBLE 2 */
/*       EPS           EPSILON RELATIF DEFINISANT L'EGALITE DE 2 POINTS */
/*       NBHCD         TAILLE DE LA TABLE DE HCODE (GENERALEMENT 1024) */
/*       HCD(0:NBHCD-1)TABLEAU DE TRAVAIL */
/*       P1(1:N1)      TABLEAU DE TRAVAIL */
/* SORTIE : */
/*       P2(1:N2)    P(I) = 0  => LE POINT I DE L'ENSEMBLE 2 N'A PAS ETE 
*/
/*                                 RETROUVE DANS L'ENSEMBLE 1 */
/*                   P(I) > 0  => LE POINT I DE L'ENSEMBLE 2 ETE 'EGAL' */
/*                                AU POINT P(I) L'ENSEMBLE 1 */
/*       P1(1:N1)    LE STOCKAGE INVERSE */
/*       NBPOC       NOMBRE DE POINT COMMUN */

/*     RESTRICTION : IL FAUT QUE LES POINTS DE L'ENSEMBLE 1 SOIT SEPARES 
*/
/*     D'AU MOINS 2*EPSR POUR QUE LE RESULTAT SOIT COHERANT ( SINON UN */
/*     POINT DE 2 POURAIT ETRE EGAL A 2 POINTS DE 1). */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*  PROGRAMMEUR :  F.HECHT INRIA  MAI 1986 */
/*  ................................................................... */
    /* Parameter adjustments */
    --p2;
    --p1;
    c2_dim1 = *n;
    c2_offset = c2_dim1 + 1;
    c2 -= c2_offset;
    c1_dim1 = *n;
    c1_offset = c1_dim1 + 1;
    c1 -= c1_offset;

    /* Function Body */
/* L200: */
    imprim = iinfo_("IMPRIMANTE", 10L);
/*     --- CALCULE LES EXTREMUMS DES POINTS */
    if (*n > 3 || *n < 1) {
	io___2887.ciunit = imprim;
	s_wsfe(&io___2887);
	do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
	e_wsfe();
	arret_(&c__200);
	s_stop("", 0L);
    }
    *nbpoc = 0;
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	x[(j << 1) - 2] = c1[j + c1_dim1];
	x[(j << 1) - 1] = c1[j + c1_dim1];
/* L10: */
    }
    i__1 = *n1;
    for (i = 2; i <= i__1; ++i) {
	i__2 = *n;
	for (j = 1; j <= i__2; ++j) {
/* Computing MIN */
	    r__1 = x[(j << 1) - 2], r__2 = c1[j + i * c1_dim1];
	    x[(j << 1) - 2] = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = x[(j << 1) - 1], r__2 = c1[j + i * c1_dim1];
	    x[(j << 1) - 1] = dmax(r__1,r__2);
/* L20: */
	}
    }
    i__2 = *n2;
    for (i = 1; i <= i__2; ++i) {
	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
/* Computing MIN */
	    r__1 = x[(j << 1) - 2], r__2 = c2[j + i * c2_dim1];
	    x[(j << 1) - 2] = dmin(r__1,r__2);
/* Computing MAX */
	    r__1 = x[(j << 1) - 1], r__2 = c2[j + i * c2_dim1];
	    x[(j << 1) - 1] = dmax(r__1,r__2);
/* L30: */
	}
    }
    epsr = 1e-20f;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
/* Computing MAX */
	r__1 = epsr, r__2 = x[(i << 1) - 1] - x[(i << 1) - 2];
	epsr = dmax(r__1,r__2);
/* L35: */
    }
/* Computing MAX */
    r__1 = *eps * 2.f;
    coef = 1.f / (epsr * dmax(r__1,9.765625e-4f));
    epsr *= *eps;
    i__1 = *nbhcd - 1;
    for (i = 0; i <= i__1; ++i) {
	hcd[i] = 0;
/* L40: */
    }
    i__1 = *n1;
    for (i = 1; i <= i__1; ++i) {
	k = rcpnt1_(n, x, &c1[c1_offset], &i, &coef) % *nbhcd;
	p1[i] = hcd[k];
	hcd[k] = i;
/* L50: */
    }
    i__1 = *n2;
    for (i = 1; i <= i__1; ++i) {
	rcpnt2_(n, x, &c2[c2_offset], &i, cas, &nbcas, &coef);
	i__2 = nbcas;
	for (k = 1; k <= i__2; ++k) {
	    p = hcd[cas[k - 1] % *nbhcd];
L70:
	    if (p != 0) {
		i__3 = *n;
		for (l = 1; l <= i__3; ++l) {
		    if ((r__1 = c1[l + p * c1_dim1] - c2[l + i * c2_dim1], 
			    dabs(r__1)) <= epsr) {
			goto L80;
		    }
		    p = p1[p];
		    goto L70;
L80:
		    ;
		}
/*         LES POINT P EST I SONT EGAUX */
		++(*nbpoc);
		p2[i] = p;
		goto L100;
	    }
/* L90: */
	}
	p2[i] = 0;
L100:
	;
    }
    i__1 = *n1;
    for (i = 1; i <= i__1; ++i) {
	p1[i] = 0;
/* L110: */
    }
    i__1 = *n2;
    for (i = 1; i <= i__1; ++i) {
	if (p2[i] != 0) {
	    p1[p2[i]] = i;
	}
/* L120: */
    }
    return 0;
} /* rcpnts_ */

/* Subroutine */ int refelm_(integer *j)
{
    /* Local variables */

    integer i;
    extern /* Subroutine */ int drawad_(integer *, integer *);


/*     elle affecte nureff au jeme element de bd */


    i = abs(*j);
    drawad_(&i, &c_n1);
/*      print*,'refelm:fissur: ',fissur,' j=',j */
    if (bdpecd_1.fissur[i + 64]) {
	if (*j > 0) {
	    bdpec5_1.nuref[(i << 1) + 128] = etat_1.nureff;
	} else {
	    bdpec5_1.nuref[(i << 1) + 129] = etat_1.nureff;
	}
    } else {
	bdpec5_1.nuref[(i << 1) + 128] = etat_1.nureff;
	bdpec5_1.nuref[(i << 1) + 129] = etat_1.nureff;
    }
    drawad_(&i, &c__0);
    return 0;
} /* refelm_ */




/* Subroutine */ int refext_(integer *j)
{
    /* Local variables */
    integer cote;

    integer i;
    extern /* Subroutine */ int drawad_(integer *, integer *), coherx_(
	    integer *, integer *);


/*     elle affecte nureff aux 2 extremitees du jeme element de bd */
/*     dans le cas de fissure si j>0 a gauche */
/*                            si j<0 a droite */


    i = abs(*j);
    drawad_(&i, &c_n1);
    if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == -3.f 
	    || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	if (bdpecd_1.fissur[i + 64]) {
	    if (*j > 0) {
		cote = 1;
	    } else {
		cote = 2;
	    }
	    bdpec6_1.nuref1[cote + (i << 1) + 127] = etat_1.nureff;
	    bdpec7_1.nuref2[cote + (i << 1) + 127] = etat_1.nureff;
	} else {
	    bdpec6_1.nuref1[(i << 1) + 128] = etat_1.nureff;
	    bdpec7_1.nuref2[(i << 1) + 128] = etat_1.nureff;
	    bdpec6_1.nuref1[(i << 1) + 129] = etat_1.nureff;
	    bdpec7_1.nuref2[(i << 1) + 129] = etat_1.nureff;
	}
    } else {
	bdpec5_1.nuref[(i << 1) + 128] = etat_1.nureff;
	bdpec5_1.nuref[(i << 1) + 129] = etat_1.nureff;
    }
/*     coherence aux 2 extremites */
    coherx_(&i, &c__1);
    coherx_(&i, &c__2);
    drawad_(&i, &c__0);
    return 0;
} /* refext_ */




/*     f_lisp */
integer removv_(integer *s, integer *l)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern integer cons_(integer *, integer *);
    integer pt, der;


/*    renvoie une liste qui est la liste l moins la liste s */
/*     on teste si il existe une cellule de l tel que son car = s */
/*     elle ne modifie pas la liste l ni s */


    ret_val = 0;
    if (*l != 0) {
	pt = *l;
L1:
	if (pt != 0) {
	    if (listea_1.car[pt - 1] != *s) {
		if (ret_val == 0) {
		    ret_val = cons_(&listea_1.car[pt - 1], &c__0);
		    der = ret_val;
		} else {
		    listed_1.cdr[der - 1] = cons_(&listea_1.car[pt - 1], &
			    c__0);
		    der = listed_1.cdr[der - 1];
		}
	    }
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
    }
    return ret_val;
} /* removv_ */

/*     f_lisp */
integer removx_(integer *s, integer *l)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern /* Subroutine */ int back_(integer *);
    integer preced, pt, pt1;


/*    retire la liste s a la liste l et prend la valeur de l */
/*         si s n'est pas dans l : l est inchange */
/*     on teste si il existe une cellule de l tel que son car = s */
/*     elle ne modifie pas la liste s */
/*     elle modifie la liste l */


    if (*l != 0) {
	pt = *l;
	preced = 0;
L1:
	if (pt != 0) {
	    if (listea_1.car[pt - 1] == *s) {
		if (preced == 0) {
		    *l = listed_1.cdr[pt - 1];
		} else {
		    listed_1.cdr[preced - 1] = listed_1.cdr[pt - 1];
		}
		pt1 = pt;
		pt = listed_1.cdr[pt - 1];
		back_(&pt1);
		goto L1;
	    }
	    preced = pt;
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
    }
    ret_val = *l;
    return ret_val;
} /* removx_ */

/* Subroutine */ int reselm_(integer *j)
{
    /* Local variables */

    integer i;
    extern /* Subroutine */ int drawad_(integer *, integer *);


/*      affect raisoo a l'element j */


    i = abs(*j);
    drawad_(&i, &c_n1);
    bdpec4_1.raison[i + 64] = etat_1.raisoo;
    drawad_(&i, &c__0);
    return 0;
} /* reselm_ */




/* Subroutine */ int restbd_(integer *etiq)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_cmp(char *, char *, ftnlen, ftnlen), s_wsle(
	    cilist *), e_wsle(void);

    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *), cddr_(integer *), 
	    cons_(integer *, integer *), last_(integer *);
    integer nrfg, nrfd, nusd;
    extern /* Subroutine */ int bd2bd_(void), bd3bd_(void), bdbd2_(void);
    char type[16];
    integer nrf1d, nrf2d, nrf1g, nrf2g;
    extern integer caaar_(integer *), cdaar_(integer *), cdddr_(integer *);

    integer i, j, count, refbd, debut;
    extern integer cdaaar_(integer *);
    extern integer cddddr_(integer *);
    integer pt1, ptcomp, ptdomn, nbcomp, nbptin, typeco, nuextr, pt;
    real dx, dy, cx, cy;
    char sensco[6], buf[130];
    integer chaine;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), qboite_(void), 
	    addomn_(integer *);
    integer adbd;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2920 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2924 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2935 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2941 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2948 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2949 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2950 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2951 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2952 = { 0, 6, 0, 0, 0 };





    if (pec_1.appli == 513 || pec_1.appli == 514) {
	if (bdpec1_1.sdomn != 0) {
	    scrtch_("IL Y A DEJA UNE BD, on perd les domaines", 40L);
	    if (pec_1.appli == 513) {
		bd2bd_();
	    } else if (pec_1.appli == 514) {
		bd3bd_();
	    }
	}
	bdpec1_1.comp = 0;
	bdpec1_1.sdomn = 0;
	bdpec1_1.link = 0;
	bdpec1_1.finbd = 0;
	bdmsh4_1.finbd3 = 0;
    } else {
	scrtch_("RESTBD:ATTENTION RESTAURATION DE BD SANS LES DOMAINES", 53L);
    }
    count = 0;
/*      lecture de la premiere carte commentaire */
    io___2920.ciunit = *etiq;
    i__1 = s_rsle(&io___2920);
    if (i__1 != 0) {
	goto L100011;
    }
    i__1 = do_lio(&c__9, &c__1, buf, 130L);
    if (i__1 != 0) {
	goto L100011;
    }
    i__1 = e_rsle();
L100011:
    if (i__1 < 0) {
	goto L2;
    }
    if (i__1 > 0) {
	goto L3;
    }
    i = bdpec1_1.ptbd;
    debut = bdpec1_1.ptbd;
L1:
    ++i;
L5:
    io___2924.ciunit = *etiq;
    i__1 = s_rsle(&io___2924);
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__9, &c__1, type, 16L);
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&chaine, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 385], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 386], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 387], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 388], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 389], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[i + 64], (ftnlen)
	    sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[i + 64], (ftnlen)
	    sizeof(real));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrfg, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrfd, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrf1g, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrf1d, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrf2g, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__3, &c__1, (char *)&nrf2d, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[i + 64], (ftnlen)
	    sizeof(logical));
    if (i__1 != 0) {
	goto L100012;
    }
    i__1 = e_rsle();
L100012:
    if (i__1 < 0) {
	goto L2;
    }
    if (i__1 > 0) {
	goto L3;
    }
    if (i > bdpec1_1.mxbd) {
	scrtch_("RESTBD: LA BD EST PLEINE!... ", 29L);
	goto L2;
    }
    if (s_cmp(type, "POINT", 16L, 5L) == 0 || s_cmp(type, "DROITE", 16L, 6L) 
	    == 0 || s_cmp(type, "CERCLE", 16L, 6L) == 0 || s_cmp(type, "ARC", 
	    16L, 3L) == 0 || s_cmp(type, "SEGMENT", 16L, 7L) == 0) {
	bdpec5_1.nuref[(i << 1) + 128] = nrfg;
	bdpec6_1.nuref1[(i << 1) + 128] = nrf1g;
	bdpec7_1.nuref2[(i << 1) + 128] = nrf2g;
	bdpec5_1.nuref[(i << 1) + 129] = nrfd;
	bdpec6_1.nuref1[(i << 1) + 129] = nrf1d;
	bdpec7_1.nuref2[(i << 1) + 129] = nrf2d;
	bdpece_1.adjabd[i + 64] = 0;
	bdpec8_1.adp1[i + 64] = 0;
	bdpec9_1.adp2[i + 64] = 0;
	goto L1;
    } else if (s_cmp(type, "SPLINE", 16L, 6L) == 0) {
	bdpec5_1.nuref[(i << 1) + 128] = nrfg;
	bdpec6_1.nuref1[(i << 1) + 128] = nrf1g;
	bdpec7_1.nuref2[(i << 1) + 128] = nrf2g;
	bdpec5_1.nuref[(i << 1) + 129] = nrfd;
	bdpec6_1.nuref1[(i << 1) + 129] = nrf1d;
	bdpec7_1.nuref2[(i << 1) + 129] = nrf2d;
	bdpece_1.adjabd[i + 64] = 0;
	bdpec8_1.adp1[i + 64] = 0;
	bdpec9_1.adp2[i + 64] = 0;
	pt1 = 0;
	i__1 = (integer) bdpec2_1.bd[i * 6 + 385];
	for (j = 1; j <= i__1; ++j) {
	    io___2935.ciunit = *etiq;
	    i__2 = s_rsle(&io___2935);
	    if (i__2 != 0) {
		goto L100013;
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&adbd, (ftnlen)sizeof(integer)
		    );
	    if (i__2 != 0) {
		goto L100013;
	    }
	    i__2 = e_rsle();
L100013:
	    if (i__2 < 0) {
		goto L2;
	    }
	    if (i__2 > 0) {
		goto L3;
	    }
/*          on tient compte du deplacement du a une bd initialemen
t non v */
	    adbd += debut;
	    if (last_(&pt1) != 0) {
		listed_1.cdr[last_(&pt1) - 1] = cons_(&adbd, &c__0);
	    } else {
		bdpec2_1.bd[i * 6 + 386] = (real) cons_(&adbd, &c__0);
		pt1 = bdpec2_1.bd[i * 6 + 386];
	    }
/* L100: */
	}
	goto L1;
    } else if (s_cmp(type, "DOMAINE", 16L, 7L) == 0) {
	nbcomp = bdpec2_1.bd[i * 6 + 384];
	nbptin = bdpec2_1.bd[i * 6 + 385];
	nusd = bdpec2_1.bd[i * 6 + 386];
	if ((pec_1.appli == 513 || pec_1.appli == 514) && count == 0) {
/*          on met ptbd dans count pour faire d'une pierre deux co
ups */
	    bdpec1_1.ptbd = i - 1;
	    count = bdpec1_1.ptbd;
/*          calcul de la boite de travail et du eps */
	    qboite_();
/*          on converti la bd en bd2 */
	    bdpec1_1.typebd = 511;
	    bdbd2_();
	    i = bdpec1_1.finbd + 1;
	}
	if (pec_1.appli == 513 || pec_1.appli == 514) {
	    addomn_(&ptdomn);
	    listea_1.car[caaar_(&ptdomn) - 1] = nusd;
	}
	i__1 = nbcomp;
	for (j = 1; j <= i__1; ++j) {
	    io___2941.ciunit = *etiq;
	    i__2 = s_rsle(&io___2941);
	    if (i__2 != 0) {
		goto L100014;
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&adbd, (ftnlen)sizeof(integer)
		    );
	    if (i__2 != 0) {
		goto L100014;
	    }
	    i__2 = do_lio(&c__9, &c__1, sensco, 6L);
	    if (i__2 != 0) {
		goto L100014;
	    }
	    i__2 = e_rsle();
L100014:
	    if (i__2 < 0) {
		goto L2;
	    }
	    if (i__2 > 0) {
		goto L3;
	    }
	    if (s_cmp(sensco, "GAUCHE", 6L, 6L) == 0) {
		typeco = 1;
	    } else {
		typeco = 2;
	    }
	    if (pec_1.appli == 513 || pec_1.appli == 514) {
		ptcomp = bdpec1_1.comp;
L13:
		if (ptcomp != 0) {
		    refbd = listea_1.car[listea_1.car[ptcomp - 1] - 1];
		    nuextr = listed_1.cdr[listea_1.car[ptcomp - 1] - 1];
L14:
		    if (refbd != adbd + debut || nuextr != typeco) {
			pt = bdpeca_1.conx[nuextr + (refbd << 1) + 127];
			nuextr = bdpecb_1.cnx[nuextr + (refbd << 1) + 127];
			refbd = pt;
			if (refbd != caar_(&ptcomp) || nuextr != cdar_(&
				ptcomp)) {
/*                  element suivant dans la compos
ante ptcomp */
			    goto L14;
			}
		    } else {
/*                on a trouver l'element */
/*                on met la composante en fin de liste
 des composantes du */
			if (listed_1.cdr[listea_1.car[ptdomn - 1] - 1] == 0) {
			    listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = 
				    cons_(&ptcomp, &c__0);
			} else {
			    i__2 = cdar_(&ptdomn);
			    listed_1.cdr[last_(&i__2) - 1] = cons_(&ptcomp, &
				    c__0);
			}
/*                composante suivante du domaine */
			goto L11;
		    }
/*              composante suivante dans la liste de toute
s les composant */
		    ptcomp = listed_1.cdr[ptcomp - 1];
		    goto L13;
		}
/*            on a parcouru toutes les composantes et on a rie
n trouve */
		scrtch_("ERREUR: L'ELEMENT N'APPARTIENT A AUCUNE COMPOSANTE?"
			"....", 55L);
		s_wsle(&io___2948);
		do_lio(&c__9, &c__1, "ADBD=", 5L);
		do_lio(&c__3, &c__1, (char *)&adbd, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " TYPECO=", 8L);
		do_lio(&c__3, &c__1, (char *)&typeco, (ftnlen)sizeof(integer))
			;
		do_lio(&c__9, &c__1, " SENSCO=", 8L);
		do_lio(&c__9, &c__1, sensco, 6L);
		e_wsle();
		s_wsle(&io___2949);
		do_lio(&c__9, &c__1, "TYPE=", 5L);
		do_lio(&c__9, &c__1, type, 16L);
		e_wsle();
		goto L1;
	    }
L11:
	    ;
	}
	i__1 = nbptin;
	for (j = 1; j <= i__1; ++j) {
	    io___2950.ciunit = *etiq;
	    i__2 = s_rsle(&io___2950);
	    if (i__2 != 0) {
		goto L100015;
	    }
	    i__2 = do_lio(&c__3, &c__1, (char *)&adbd, (ftnlen)sizeof(integer)
		    );
	    if (i__2 != 0) {
		goto L100015;
	    }
	    i__2 = do_lio(&c__9, &c__1, sensco, 6L);
	    if (i__2 != 0) {
		goto L100015;
	    }
	    i__2 = e_rsle();
L100015:
	    if (i__2 < 0) {
		goto L2;
	    }
	    if (i__2 > 0) {
		goto L3;
	    }
	    if (pec_1.appli == 513 || pec_1.appli == 514) {
/*            on tient compte du deplacement du a une bd initi
alement non */
		adbd += debut;
/*            on le met en fin de liste des elements interieur
s du domain */
		if (listed_1.cdr[caar_(&ptdomn) - 1] == 0) {
		    listed_1.cdr[caar_(&ptdomn) - 1] = cons_(&adbd, &c__0);
		} else {
		    i__2 = cdaar_(&ptdomn);
		    listed_1.cdr[last_(&i__2) - 1] = cons_(&adbd, &c__0);
		}
	    }
/* L12: */
	}
    } else if (s_cmp(type, "TRIANGLE", 16L, 8L) == 0 || s_cmp(type, "QUADRAN"
	    "GLE", 16L, 10L) == 0 || s_cmp(type, "BANDE", 16L, 5L) == 0) {
/*        triangle ou quadrangle */
	if (pec_1.appli == 513 || pec_1.appli == 514) {
	    pt1 = cdaaar_(&ptdomn);
	    listea_1.car[pt1 - 1] = bdpec2_1.bd[i * 6 + 384];
	    listea_1.car[listed_1.cdr[pt1 - 1] - 1] = bdpec2_1.bd[i * 6 + 385]
		    ;
	    listea_1.car[cddr_(&pt1) - 1] = bdpec2_1.bd[i * 6 + 386];
	    listea_1.car[cdddr_(&pt1) - 1] = bdpec2_1.bd[i * 6 + 387];
	    listea_1.car[cddddr_(&pt1) - 1] = bdpec2_1.bd[i * 6 + 388];
	    if (s_cmp(type, "TRIANGLE", 16L, 8L) != 0) {
/*            on tient compte du deplacement */
		listea_1.car[listed_1.cdr[pt1 - 1] - 1] += debut;
		listea_1.car[cddr_(&pt1) - 1] = listea_1.car[cddr_(&pt1) - 1] 
			+ debut;
		if (s_cmp(type, "BANDE", 16L, 5L) == 0) {
		    listea_1.car[cdddr_(&pt1) - 1] = listea_1.car[cdddr_(&pt1)
			     - 1] + debut;
		    listea_1.car[cddddr_(&pt1) - 1] = listea_1.car[cddddr_(&
			    pt1) - 1] + debut;
		}
	    }
	}
    } else if (s_cmp(type, "ECHELLE", 16L, 7L) == 0) {
	etat_1.echel = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "RAYON", 16L, 5L) == 0) {
	etat_1.rayon = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "ANGLE", 16L, 5L) == 0) {
	etat_1.angle = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "DISTANCE", 16L, 8L) == 0) {
	etat_1.distan = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "RAPPORT", 16L, 7L) == 0) {
	etat_1.raport = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "NOMBRE", 16L, 6L) == 0) {
	etat_1.nombre = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "NUREF", 16L, 5L) == 0) {
	etat_1.nureff = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "NB_INTERVALS", 16L, 12L) == 0) {
	etat_1.nbintr = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "RAISON", 16L, 6L) == 0) {
	etat_1.raisoo = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "NUDSD", 16L, 5L) == 0) {
	etat_1.nudsd = bdpec2_1.bd[i * 6 + 384];
    } else if (s_cmp(type, "MASQUE", 16L, 6L) == 0) {
	pec_1.masque[0] = bdpec2_1.bd[i * 6 + 384];
	pec_1.masque[1] = bdpec2_1.bd[i * 6 + 385];
	pec_1.masque[2] = bdpec2_1.bd[i * 6 + 386];
	pec_1.masque[3] = bdpec2_1.bd[i * 6 + 387];
	if (pec_1.masque[0] >= pec_1.masque[1]) {
	    pec_1.masque[1] = pec_1.masque[0] + 1.f;
	}
	if (pec_1.masque[2] >= pec_1.masque[3]) {
	    pec_1.masque[3] = pec_1.masque[2] + 1.f;
	}
    } else {
/*        sinon: */
	scrtch_("RESTBD:ON NE COMPREND PAS CE QUE L'ON A LU", 42L);
	s_wsle(&io___2951);
	do_lio(&c__9, &c__1, "RESTBD:ON A LU:", 15L);
	do_lio(&c__9, &c__1, type, 16L);
	do_lio(&c__3, &c__1, (char *)&chaine, (ftnlen)sizeof(integer));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 386], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 387], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 388], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 389], (ftnlen)
		sizeof(real));
	do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[i + 64], (ftnlen)sizeof(
		integer));
	do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[i + 64], (ftnlen)sizeof(
		real));
	do_lio(&c__3, &c__1, (char *)&nrfg, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nrfd, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nrf1g, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nrf1d, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nrf2g, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nrf2d, (ftnlen)sizeof(integer));
	e_wsle();
	bdpec2_1.bd[i * 6 + 384] = -1e3f;
    }
/*      on lit la suite sans incrementer i */
    goto L5;
L3:
    scrtch_("RESTBD:ERREUR DE LECTURE EN RESTAURATION DE BD", 46L);
    s_wsle(&io___2952);
    do_lio(&c__9, &c__1, "RESTBD:IL Y A UNE ERREUR DE LECTURE EN ", 39L);
    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " TYPE=", 6L);
    do_lio(&c__9, &c__1, type, 16L);
    do_lio(&c__9, &c__1, " CHAINE=", 8L);
    do_lio(&c__3, &c__1, (char *)&chaine, (ftnlen)sizeof(integer));
    e_wsle();
    goto L1;
L2:
    if ((pec_1.appli == 513 || pec_1.appli == 514) && count == 0) {
/*        on n'a pas trouver de domaine, donc on n'a pas converti la b
d e */
	count = bdpec1_1.ptbd;
	bdpec1_1.ptbd = i - 1;
/*        calcul de la boite de travail et du eps */
	qboite_();
	bdpec1_1.typebd = 511;
	bdbd2_();
    } else if (pec_1.appli == 511) {
	bdpec1_1.ptbd = i - 1;
    }

/*      ajustage du masque (si on a change d'ecran) */

    dx = (pec_1.fentre[1] - pec_1.fentre[0]) / etat_1.echel;
    dy = (pec_1.fentre[3] - pec_1.fentre[2]) / etat_1.echel;
    cx = (pec_1.masque[0] + pec_1.masque[1]) / 2.f;
    cy = (pec_1.masque[2] + pec_1.masque[3]) / 2.f;
    pec_1.masque[0] = cx - dx / 2.f;
    pec_1.masque[1] = cx + dx / 2.f;
    pec_1.masque[2] = cy - dy / 2.f;
    pec_1.masque[3] = cy + dy / 2.f;
    for (i = 0; i <= 8; ++i) {
	pececr_1.pmsq[i * 4] = pec_1.masque[0];
	pececr_1.pmsq[(i << 2) + 1] = pec_1.masque[1];
	pececr_1.pmsq[(i << 2) + 2] = pec_1.masque[2];
	pececr_1.pmsq[(i << 2) + 3] = pec_1.masque[3];
/* L999: */
    }
    return 0;
} /* restbd_ */




/*     f_lisp */
integer revers_(integer *pt1)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern integer cons_(integer *, integer *);
    integer pt;


/*     renvoie revers= pointeur sur la liste inversee */
/*     elle ne modifie pas la liste pt1 */


    pt = *pt1;
    ret_val = 0;
L1:
    if (pt != 0) {
	ret_val = cons_(&listea_1.car[pt - 1], &ret_val);
	pt = listed_1.cdr[pt - 1];
	goto L1;
    }
    return ret_val;
} /* revers_ */

integer rfaret_(integer *it, integer *ia)
{
    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i;


    /* Fortran I/O blocks */
    /*static*/ cilist io___2962 = { 0, 6, 0, 0, 0 };


/* -----------------------------------------------------------------------
 */
/*     donner la reference de l'arete ia du triangle it si it non nul */
/*     donner la reference de l'arete ia de aretbd */
/* -----------------------------------------------------------------------
 */
    if (*it == 0) {
	i = *ia;
    } else {
	i = bdmsh9_1.nsea[*ia + *it * 6 - 7];
    }
    if (i < 0) {
	i = bdmshe_1.refa[-i - 1];
	if (i > 0) {
	    i = bdpec5_1.nuref[(i << 1) + 128];
	} else if (i < 0) {
	    i = bdpec5_1.nuref[(-i << 1) + 129];
	} else {
	    s_wsle(&io___2962);
	    do_lio(&c__9, &c__1, " rfaret: BIZARRE it,ia,i=", 25L);
	    do_lio(&c__3, &c__1, (char *)&(*it), (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&(*ia), (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, "on la met la ref a 0", 20L);
	    e_wsle();
	    i = 0;
	}
    } else {
	i = 0;
    }
    ret_val = i;
    return ret_val;
} /* rfaret_ */




integer rfsomm_(integer *is)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */


/* -----------------------------------------------------------------------
 */
/*     donner la reference du sommet is */
/* -----------------------------------------------------------------------
 */
    if (bdmsh8_1.refs[*is - 1] > 0) {
	ret_val = bdpec5_1.nuref[(bdmsh8_1.refs[*is - 1] << 1) + 128];
    } else if (bdmsh8_1.refs[*is - 1] < 0) {
	ret_val = bdpec5_1.nuref[(-bdmsh8_1.refs[*is - 1] << 1) + 129];
    } else {
	ret_val = 0;
    }
    return ret_val;
} /* rfsomm_ */




/* Subroutine */ int rot2d_(doublereal *trf, real *alpha, real *x, real *y)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */
    extern /* Subroutine */ int cmp2d_(doublereal *, doublereal *), trl2d_(
	    doublereal *, real *, real *);
    doublereal trf0[9]	/* was [3][3] */;


    /* Parameter adjustments */
    trf -= 4;

    /* Function Body */
    trf0[0] = cos(*alpha);
    trf0[1] = sin(*alpha);
    trf0[2] = 0.f;
    trf0[3] = -(doublereal)sin(*alpha);
    trf0[4] = cos(*alpha);
    trf0[5] = 0.f;
    trf0[6] = 0.f;
    trf0[7] = 0.f;
    trf0[8] = 1.f;

    r__1 = -(doublereal)(*x);
    r__2 = -(doublereal)(*y);
    trl2d_(&trf[4], &r__1, &r__2);
    cmp2d_(&trf[4], trf0);
    trl2d_(&trf[4], x, y);
    return 0;
} /* rot2d_ */

integer rpcnt1_(integer *n, real *x, real *c, integer *i, real *coef)
{
    /* System generated locals */
    integer c_dim1, c_offset, ret_val, i__1;

    /* Local variables */
    integer j, k;

/* -----------------------------------------------------------------------
 */
/*      subroutine de rpcnts */
/* -----------------------------------------------------------------------
 */
/*    programmeur f.hecht mai 1986 */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
    /* Parameter adjustments */
    c_dim1 = *n;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    x -= 3;

    /* Function Body */
    k = 1;
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	k *= (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef) + 1;
/* L10: */
    }
    ret_val = k;
    return ret_val;
} /* rpcnt1_ */

/* Subroutine */ int rpcnt2_(integer *n, real *x, real *c, integer *i, 
	integer *cas, integer *nbcas, real *coef)
{
    /* System generated locals */
    integer c_dim1, c_offset, i__1, i__2;

    /* Local variables */
    integer j, k, i1, i2;

/* -----------------------------------------------------------------------
 */
/*      subroutine de rpcnts */
/* -----------------------------------------------------------------------
 */
/*    programmeur f.hecht mai 1986 */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
/* Computing 2nd power */
    i__1 = *n;
    /* Parameter adjustments */
    --cas;
    c_dim1 = *n;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    x -= 3;

    /* Function Body */
    *nbcas = 1;
    cas[1] = 1;
    i__1 = *n;
    for (j = 1; j <= i__1; ++j) {
	i1 = (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef - .25f)
		 + 1;
	i2 = (integer) ((c[j + *i * c_dim1] - x[(j << 1) + 1]) * *coef + .25f)
		 + 1;
	if (i1 != i2) {
	    i__2 = *nbcas;
	    for (k = 1; k <= i__2; ++k) {
		cas[k + *nbcas] = cas[k] * i2;
		cas[k] *= i1;
/* L10: */
	    }
	    *nbcas += *nbcas;
	} else {
	    i__2 = *nbcas;
	    for (k = 1; k <= i__2; ++k) {
		cas[k] *= i1;
/* L20: */
	    }
	}
/* L30: */
    }
    return 0;
} /* rpcnt2_ */

/* Subroutine */ int rtbd_(integer *i, real *stack)
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */
    extern integer cons_(integer *, integer *);

    extern integer alloc_(void);
    integer j;
    real aa, a11, a12, a22, a21, bb;
    extern integer revers_(integer *);
    real cx, cy, dx, dy, ddx, ddy, cc;
    integer pt, pt1;

/*        si i=0 rotation de centre stack(*,1) + angle     de bd(*,adr) */
/*        si i=1 translation de stack(*,1) a stack(*,2)    de bd(*,adr) */
/*        si i=2 homothetie de centre stack(*,1) + raport  de bd(*,adr) */
/*        si i=3 symetrie par rapport a stack(*,1)         de bd(*,adr) */



    /* Parameter adjustments */
    stack -= 6;

    /* Function Body */
    if (cdesig_1.adr == 0) {
	return 0;
    }
    dx = 0.f;
    dy = 0.f;
    a11 = 1.f;
    a12 = 0.f;
    a21 = 0.f;
    a22 = 1.f;
    cx = 0.f;
    cy = 0.f;
    if (*i == 0) {
/*        rotation */
	cx = stack[7];
	cy = stack[8];
	a11 = cos(etat_1.angle);
	a22 = a11;
	a12 = -(doublereal)sin(etat_1.angle);
	a21 = -(doublereal)a12;
    } else if (*i == 1) {
/*        translation */
	dx = stack[13] - stack[7];
	dy = stack[14] - stack[8];
    } else if (*i == 2) {
/*        homothetie */
	cx = stack[7];
	cy = stack[8];
	a11 = etat_1.raport;
	a22 = etat_1.raport;
    } else if (*i == 3) {
/*        symetrie */
	if (stack[6] >= 0.f) {
	    cx = stack[7];
	    cy = stack[8];
	    a11 = -1.f;
	    a22 = -1.f;
	} else if (stack[6] == -1.f) {
	    dx = stack[7] * -2.f * stack[9];
	    dy = stack[8] * -2.f * stack[9];
/* Computing 2nd power */
	    r__1 = stack[7];
	    a11 = 1.f - r__1 * r__1 * 2.f;
	    a12 = stack[7] * -2.f * stack[8];
	    a21 = a12;
/* Computing 2nd power */
	    r__1 = stack[8];
	    a22 = 1.f - r__1 * r__1 * 2.f;
	}
    }
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] >= 0.f) {
	ddx = bdpec2_1.bd[cdesig_1.adr * 6 + 385] - cx;
	ddy = bdpec2_1.bd[cdesig_1.adr * 6 + 386] - cy;
	if (*i == 2) {
	    bdpec2_1.bd[cdesig_1.adr * 6 + 384] *= etat_1.raport;
	}
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = dx + cx + ddx * a11 + ddy * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = dy + cy + ddx * a21 + ddy * a22;
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -1.f) {
	aa = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	bb = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	cc = bdpec2_1.bd[cdesig_1.adr * 6 + 387] + aa * cx + bb * cy;
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = aa * a11 + bb * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = aa * a21 + bb * a22;
	bdpec2_1.bd[cdesig_1.adr * 6 + 387] = cc - bdpec2_1.bd[cdesig_1.adr * 
		6 + 385] * (cx + dx) - bdpec2_1.bd[cdesig_1.adr * 6 + 386] * (
		cy + dy);
	if (*i == 3 && stack[6] == -1.f) {
/*          symetrie /droite */
	    bdpec2_1.bd[cdesig_1.adr * 6 + 385] = -(doublereal)bdpec2_1.bd[
		    cdesig_1.adr * 6 + 385];
	    bdpec2_1.bd[cdesig_1.adr * 6 + 386] = -(doublereal)bdpec2_1.bd[
		    cdesig_1.adr * 6 + 386];
	    bdpec2_1.bd[cdesig_1.adr * 6 + 387] = -(doublereal)bdpec2_1.bd[
		    cdesig_1.adr * 6 + 387];
	}
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -3.f) {
	ddx = bdpec2_1.bd[cdesig_1.adr * 6 + 385] - cx;
	ddy = bdpec2_1.bd[cdesig_1.adr * 6 + 386] - cy;
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = dx + cx + ddx * a11 + ddy * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = dy + cy + ddx * a21 + ddy * a22;
	ddx = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - cx;
	ddy = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - cy;
	bdpec2_1.bd[cdesig_1.adr * 6 + 387] = dx + cx + ddx * a11 + ddy * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 388] = dy + cy + ddx * a21 + ddy * a22;
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -2.f) {
	ddx = bdpec2_1.bd[cdesig_1.adr * 6 + 385] - cx;
	ddy = bdpec2_1.bd[cdesig_1.adr * 6 + 386] - cy;
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = dx + cx + ddx * a11 + ddy * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = dy + cy + ddx * a21 + ddy * a22;
	ddx = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - cx;
	ddy = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - cy;
	bdpec2_1.bd[cdesig_1.adr * 6 + 387] = dx + cx + ddx * a11 + ddy * a12;
	bdpec2_1.bd[cdesig_1.adr * 6 + 388] = dy + cy + ddx * a21 + ddy * a22;
	if (*i == 3 && stack[6] == -1.f) {
/*          symetrie /droite */
	    bdpec2_1.bd[cdesig_1.adr * 6 + 389] = -(doublereal)bdpec2_1.bd[
		    cdesig_1.adr * 6 + 389];
	}
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -4.f) {
	pt = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	if (pt != 0) {
	    pt1 = listea_1.car[pt - 1];
	} else {
	    pt1 = 0;
	}
	if (etat_1.nombre >= 2) {
	    bdpec2_1.bd[cdesig_1.adr * 6 + 386] = 0.f;
	}
L1:
	if (pt != 0) {
	    ddx = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385] - cx;
	    ddy = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386] - cy;
	    if (etat_1.nombre >= 2) {
/*              on cree une copie transformee */
		j = alloc_();
		if (j == 0) {
		    return 0;
		}
		i__1 = (integer) bdpec2_1.bd[cdesig_1.adr * 6 + 386];
		bdpec2_1.bd[cdesig_1.adr * 6 + 386] = (real) cons_(&j, &i__1);
		bdpec2_1.bd[j * 6 + 384] = 0.f;
		bdpec2_1.bd[j * 6 + 385] = dx + cx + ddx * a11 + ddy * a12;
		bdpec2_1.bd[j * 6 + 386] = dy + cy + ddx * a21 + ddy * a22;
	    } else {
/*              on transforme sur place */
/*              teste si spline fermee: avec la meme ref au po
int */
/*              on ne transforme pas 2 fois ce point */
		if (listed_1.cdr[pt - 1] != 0 || listea_1.car[pt - 1] != pt1) 
			{
		    bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385] = dx + cx + 
			    ddx * a11 + ddy * a12;
		    bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386] = dy + cy + 
			    ddx * a21 + ddy * a22;
		}
	    }
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
	if (etat_1.nombre >= 2) {
	    i__1 = (integer) bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	    bdpec2_1.bd[cdesig_1.adr * 6 + 386] = (real) revers_(&i__1);
	}
    }
    return 0;
} /* rtbd_ */




/* Subroutine */ int sauvbd_(integer *etiq)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2, r__3, r__4, r__5;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern integer cdar_(integer *), cadr_(integer *);
    integer depl, nrfg, nrfd;
    char type[16];
    integer nrf1d, nrf2d, nrf1g, nrf2g;
    extern integer caaar_(integer *), cdaar_(integer *), caddr_(integer *);

    integer i;
    extern integer caaaar_(integer *), cadddr_(integer *), cdaaar_(integer *);
    extern integer cddddr_(integer *), length_(integer *);
    integer ptdomn, pt1, nbcomp, nbptin, mxchai;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2995 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3006 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3007 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3009 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3013 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3014 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3015 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3016 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3017 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3018 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3019 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3020 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3021 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3022 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3023 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3024 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3025 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3026 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3027 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3028 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3029 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3030 = { 0, 0, 0, 0, 0 };




/*     dans work on a le numero de l'element */
/*                   (apres l'elimination des vides) */

/*      print*,'nouveau sauvetage de bd' */
    io___2995.ciunit = *etiq;
    s_wsle(&io___2995);
    do_lio(&c__9, &c__1, "'-- TYPE  N       BD(1) BD(2) BD(3) BD(4) BD(5) NB"
	    "NODE RAISON NUREFG NUREFD NUREF1G NUREF1D NUREF2G NUREF2D'", 108L)
	    ;
    e_wsle();
    depl = 0;
    mxchai = 0;
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	nrfg = bdpec5_1.nuref[(i << 1) + 128];
	nrf1g = bdpec6_1.nuref1[(i << 1) + 128];
	nrf2g = bdpec7_1.nuref2[(i << 1) + 128];
	nrfd = bdpec5_1.nuref[(i << 1) + 129];
	nrf1d = bdpec6_1.nuref1[(i << 1) + 129];
	nrf2d = bdpec7_1.nuref2[(i << 1) + 129];
	if (bdpec2_1.bd[i * 6 + 384] == 0.f) {
	    bdwrk1_1.work[i - 1] = i - depl;
	    s_copy(type, "'POINT'", 16L, 7L);
	} else if (bdpec2_1.bd[i * 6 + 384] > 0.f) {
	    bdwrk1_1.work[i - 1] = i - depl;
	    s_copy(type, "'CERCLE'", 16L, 8L);
	} else if (bdpec2_1.bd[i * 6 + 384] == -1.f) {
	    bdwrk1_1.work[i - 1] = i - depl;
	    s_copy(type, "'DROITE'", 16L, 8L);
	} else if (bdpec2_1.bd[i * 6 + 384] == -3.f) {
	    bdwrk1_1.work[i - 1] = i - depl;
	    s_copy(type, "'SEGMENT'", 16L, 9L);
	} else if (bdpec2_1.bd[i * 6 + 384] == -2.f) {
	    bdwrk1_1.work[i - 1] = i - depl;
	    s_copy(type, "'ARC'", 16L, 5L);
	} else {
	    ++depl;
	    bdwrk1_1.work[i - 1] = -1;
	}
/* Computing MAX */
	i__2 = mxchai, i__3 = bdwrk1_1.work[i - 1];
	mxchai = max(i__2,i__3);
	if (bdwrk1_1.work[i - 1] != -1) {
	    io___3006.ciunit = *etiq;
	    s_wsle(&io___3006);
	    do_lio(&c__9, &c__1, type, 16L);
	    do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[i - 1], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 385], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 386], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 387], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 388], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 389], (ftnlen)
		    sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[i + 64], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[i + 64], (ftnlen)
		    sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&nrfg, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrfd, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf1g, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf1d, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf2g, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf2d, (ftnlen)sizeof(integer));
	    do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[i + 64], (ftnlen)
		    sizeof(logical));
	    e_wsle();
	}
/* L1: */
    }
/*      sauvetage des splines en dernier pour etre sur que touts les poin 
*/
/*      on deja ete crees */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    ++mxchai;
	    bdwrk1_1.work[i - 1] = mxchai;
	    s_copy(type, "'SPLINE'", 16L, 8L);
	    nrfg = bdpec5_1.nuref[(i << 1) + 128];
	    nrf1g = bdpec6_1.nuref1[(i << 1) + 128];
	    nrf2g = bdpec7_1.nuref2[(i << 1) + 128];
	    nrfd = bdpec5_1.nuref[(i << 1) + 129];
	    nrf1d = bdpec6_1.nuref1[(i << 1) + 129];
	    nrf2d = bdpec7_1.nuref2[(i << 1) + 129];
/*          endif */
	    i__2 = (integer) bdpec2_1.bd[i * 6 + 386];
	    bdpec2_1.bd[i * 6 + 385] = (real) length_(&i__2);
	    io___3007.ciunit = *etiq;
	    s_wsle(&io___3007);
	    do_lio(&c__9, &c__1, type, 16L);
	    do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[i - 1], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 385], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 386], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 387], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 388], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 389], (ftnlen)
		    sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[i + 64], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[i + 64], (ftnlen)
		    sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&nrfg, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrfd, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf1g, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf1d, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf2g, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nrf2d, (ftnlen)sizeof(integer));
	    do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[i + 64], (ftnlen)
		    sizeof(logical));
	    e_wsle();
/*         sauvetage des adresses des points */
	    pt1 = bdpec2_1.bd[i * 6 + 386];
L100:
	    if (pt1 != 0) {
		io___3009.ciunit = *etiq;
		s_wsle(&io___3009);
		do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[listea_1.car[pt1 
			- 1] - 1], (ftnlen)sizeof(integer));
		e_wsle();
		pt1 = listed_1.cdr[pt1 - 1];
		goto L100;
	    }
	}
/* L2: */
    }
/*      pour appli2 et appli3 on sauve les domaines */
    if (pec_1.appli == 513 || pec_1.appli == 514) {
/*        sauvetage des domaines */
/*           'domaine' bidon nbcomp nbint  nusd */
/*              *(nuelm ( 'droite' | 'gauche'))  (1 ... nbcomp) */
/*              *(nuelm   'interieur'        )  (1 ... nbint ) */
	ptdomn = bdpec1_1.sdomn;
L20:
	if (ptdomn != 0) {
/*          nombre de composantes de ce domaine */
	    nbcomp = 0;
/*          parcourt des composantes et des elements interieurs du
 domain */
/*                                      (ptdomn) */
	    pt1 = cdar_(&ptdomn);
L21:
	    if (pt1 != 0) {
		if (listea_1.car[pt1 - 1] != 0) {
		    ++nbcomp;
		}
/*            composante suivante */
		pt1 = listed_1.cdr[pt1 - 1];
		goto L21;
	    }
/*          nombre d'elements interieurs a ce domaine */
	    nbptin = 0;
	    pt1 = cdaar_(&ptdomn);
L22:
	    if (pt1 != 0) {
		++nbptin;
/*            point interieur suivant */
		pt1 = listed_1.cdr[pt1 - 1];
		goto L22;
	    }
/*          on ecrit le nombre de composantes et le nombre d'eleme
nts int */
/*          le numero de domaine */
	    io___3013.ciunit = *etiq;
	    s_wsle(&io___3013);
	    do_lio(&c__9, &c__1, "'DOMAINE'", 9L);
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    r__1 = (real) nbcomp;
	    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
	    r__2 = (real) nbptin;
	    do_lio(&c__4, &c__1, (char *)&r__2, (ftnlen)sizeof(real));
	    r__3 = (real) caaaar_(&ptdomn);
	    do_lio(&c__4, &c__1, (char *)&r__3, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
	    e_wsle();
/*          re parcourt des composantes et des elements interieurs
 du dom */
	    pt1 = cdar_(&ptdomn);
L23:
	    if (pt1 != 0) {
		if (listea_1.car[pt1 - 1] != 0) {
/*              on ecrit le numero du 1er element de la co
mposante */
/*                       et (droit | gauche) */
		    if (cdaar_(&pt1) == 1) {
			io___3014.ciunit = *etiq;
			s_wsle(&io___3014);
			do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[caaar_(&
				pt1) - 1], (ftnlen)sizeof(integer));
			do_lio(&c__9, &c__1, " 'GAUCHE'", 9L);
			e_wsle();
		    } else {
			io___3015.ciunit = *etiq;
			s_wsle(&io___3015);
			do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[caaar_(&
				pt1) - 1], (ftnlen)sizeof(integer));
			do_lio(&c__9, &c__1, " 'DROITE'", 9L);
			e_wsle();
		    }
		}
/*            composante suivante dans le domaine */
		pt1 = listed_1.cdr[pt1 - 1];
		goto L23;
	    }
/*          reparcourt des elements interieurs */
	    pt1 = cdaar_(&ptdomn);
L24:
	    if (pt1 != 0) {
/*            on ecrit l'adresse dans la bd des elements au de
placement p */
/*            du aux elements vides de la bd (work) */
		io___3016.ciunit = *etiq;
		s_wsle(&io___3016);
		do_lio(&c__3, &c__1, (char *)&bdwrk1_1.work[listea_1.car[pt1 
			- 1] - 1], (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " 'INTERIEUR'", 12L);
		e_wsle();
/*            element interieur suivant */
		pt1 = listed_1.cdr[pt1 - 1];
		goto L24;
	    }
/*          triangle ou quadrangle */
	    pt1 = cdaaar_(&ptdomn);
	    if (listea_1.car[pt1 - 1] == 309) {
		io___3017.ciunit = *etiq;
		s_wsle(&io___3017);
		do_lio(&c__9, &c__1, "'TRIANGLE'", 10L);
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		r__1 = (real) listea_1.car[pt1 - 1];
		do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
		e_wsle();
	    } else if (listea_1.car[pt1 - 1] == 310) {
		io___3018.ciunit = *etiq;
		s_wsle(&io___3018);
		do_lio(&c__9, &c__1, "'QUADRANGLE'", 12L);
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		r__1 = (real) listea_1.car[pt1 - 1];
		do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
		r__2 = (real) bdwrk1_1.work[cadr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__2, (ftnlen)sizeof(real));
		r__3 = (real) bdwrk1_1.work[caddr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__3, (ftnlen)sizeof(real));
		r__4 = (real) cadddr_(&pt1);
		do_lio(&c__4, &c__1, (char *)&r__4, (ftnlen)sizeof(real));
		r__5 = (real) listea_1.car[cddddr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__5, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
		e_wsle();
	    } else if (listea_1.car[pt1 - 1] == 312) {
		io___3019.ciunit = *etiq;
		s_wsle(&io___3019);
		do_lio(&c__9, &c__1, "'BANDE'", 7L);
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		r__1 = (real) listea_1.car[pt1 - 1];
		do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
		r__2 = (real) bdwrk1_1.work[cadr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__2, (ftnlen)sizeof(real));
		r__3 = (real) bdwrk1_1.work[caddr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__3, (ftnlen)sizeof(real));
		r__4 = (real) bdwrk1_1.work[cadddr_(&pt1) - 1];
		do_lio(&c__4, &c__1, (char *)&r__4, (ftnlen)sizeof(real));
		r__5 = (real) bdwrk1_1.work[listea_1.car[cddddr_(&pt1) - 1] - 
			1];
		do_lio(&c__4, &c__1, (char *)&r__5, (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
		do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
		e_wsle();
	    }
/*          domaine suivant */
	    ptdomn = listed_1.cdr[ptdomn - 1];
	    goto L20;
	}
    }
/*            etat du system */
    io___3020.ciunit = *etiq;
    s_wsle(&io___3020);
    do_lio(&c__9, &c__1, "'MASQUE'", 8L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&pec_1.masque[0], (ftnlen)sizeof(real));
    do_lio(&c__4, &c__1, (char *)&pec_1.masque[1], (ftnlen)sizeof(real));
    do_lio(&c__4, &c__1, (char *)&pec_1.masque[2], (ftnlen)sizeof(real));
    do_lio(&c__4, &c__1, (char *)&pec_1.masque[3], (ftnlen)sizeof(real));
    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0 0. 0 0 0  0 0 0 ", 19L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3021.ciunit = *etiq;
    s_wsle(&io___3021);
    do_lio(&c__9, &c__1, "'RAYON'", 7L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.rayon, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3022.ciunit = *etiq;
    s_wsle(&io___3022);
    do_lio(&c__9, &c__1, "'ANGLE'", 7L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.angle, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3023.ciunit = *etiq;
    s_wsle(&io___3023);
    do_lio(&c__9, &c__1, "'DISTANCE'", 10L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.distan, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3024.ciunit = *etiq;
    s_wsle(&io___3024);
    do_lio(&c__9, &c__1, "'RAPPORT'", 9L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.raport, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3025.ciunit = *etiq;
    s_wsle(&io___3025);
    do_lio(&c__9, &c__1, "'NOMBRE'", 8L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    r__1 = (real) etat_1.nombre;
    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3026.ciunit = *etiq;
    s_wsle(&io___3026);
    do_lio(&c__9, &c__1, "'ECHELLE'", 9L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.echel, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3027.ciunit = *etiq;
    s_wsle(&io___3027);
    do_lio(&c__9, &c__1, "'NUREF'", 7L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    r__1 = (real) etat_1.nureff;
    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3028.ciunit = *etiq;
    s_wsle(&io___3028);
    do_lio(&c__9, &c__1, "'NB_INTERVALS'", 14L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    r__1 = (real) etat_1.nbintr;
    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3029.ciunit = *etiq;
    s_wsle(&io___3029);
    do_lio(&c__9, &c__1, "'RAISON'", 8L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_lio(&c__4, &c__1, (char *)&etat_1.raisoo, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    io___3030.ciunit = *etiq;
    s_wsle(&io___3030);
    do_lio(&c__9, &c__1, "'NUDSD'", 7L);
    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    r__1 = (real) etat_1.nudsd;
    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " 0. 0. 0. 0. 0. ", 16L);
    do_lio(&c__9, &c__1, "0 0. 0 0 0  0 0 0 ", 18L);
    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
    e_wsle();
    return 0;
} /* sauvbd_ */




/* Subroutine */ int scan0_(integer *type)
{
    /* Initialized data */
#ifdef FRENCH
    static integer chatyp[128] = { 0,0,0,0,0,0,0,0,0,0,306,0,0,306,0,0,0,0,0,
            0,0,0,0,0,0,0,501,0,0,0,0,0,0,0,0,0,0,0,0,0,9019,9020,9014,9012,
            9021,9013,9016,9015,9000,9001,9002,9003,9004,9005,9006,9007,9008,
            9009,0,0,314,306,0,0,0,304,0,303,302,9010,309,0,0,358,0,0,310,0,0,
            0,301,307,311,305,313,0,308,0,315,0,0,0,0,0,0,0,312,304,0,303,302,
            9010,309,0,0,355,0,0,310,313,0,0,301,307,311,305,313,0,308,0,315,
            0,0,0,9018,0,312,0 };
    static integer esctyp[128] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,353,0,352,0,0,0,0,0,0,0,354,0,0,351,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,353,0,352,0,0,0,0,0,0,0,354,0,0,
            351,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
    static char fmt_888[] = "(\002VOUS AVEZ POINTE SUR UNE CASE INACTIVE D"
	    "U\002,\002 MENU\002,i3,\002 CASE=\002,i2,\002 RECOMMENCEZ!\002)";
#else

    static integer chatyp[128] = { 0,0,0,353,0,352,0,0,0,0,306,0,0,306,351,0,
	    351,0,0,0,0,0,0,0,0,0,501,0,0,0,0,0,351,0,0,0,0,0,0,0,9019,9020,
	    9014,9012,9021,9013,9016,9015,9000,9001,9002,9003,9004,9005,9006,
	    9007,9008,9009,0,0,314,306,0,0,0,304,0,303,310,9010,309,0,0,358,0,
	    0,302,313,0,0,301,307,311,305,313,0,308,0,315,0,0,0,0,0,0,0,312,
	    304,0,303,310,9010,309,0,0,355,0,0,302,313,0,0,301,307,311,305,
	    313,0,308,0,315,0,0,0,9018,0,312,0 };
    static integer esctyp[128] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	    0,0,0,0,0,0,0,0,0,0,0,0,0,353,0,352,0,0,0,0,0,0,0,354,351,0,351,0,
	    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,353,0,352,0,0,0,0,0,0,0,354,351,
	    0,351,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
    static char fmt_888[] = "(\002You pick an inactive box of the         "
	    " \002,\002 menu\002,i3,\002 box =\002,i2,\002   Retry    !\002)";

#endif
    static integer flipc = 0;

    /* Format strings */

    /* System generated locals */
    address a__1[3], a__2[2];
    integer i__1, i__2[3], i__3[2];
    char ch__1[55], ch__2[29];
    icilist ici__1;
    cllist cl__1;

    /* Builtin functions */
    integer s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_cmp(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_wsle(cilist *), e_wsle(void), f_clos(cllist *), s_wsfi(icilist *
	    ), do_fio(integer *, char *, ftnlen), e_wsfi(void);

    /* Local variables */
    static integer numn;
    static char txcs[16];
    static integer icha1;
    static char txmn[16], char1[1];
    extern logical init2_(integer *);
    static integer i, j, k;
    extern /* Subroutine */ int clean_(void);

    extern /* Subroutine */ int flipq_(integer *);
    static real aa, bb, cc, dd;
    extern /* Subroutine */ int masqu2_(real *, real *, real *, real *), 
	    afcalc_(void), affich_(void);
    static char resize[1], redraw[1], buf[130];
    extern /* Subroutine */ int scrtch_(char *, ftnlen), menumk_(integer *, 
	    integer *, integer *), getxyc_(real *, real *, char *, ftnlen), 
	    afmenu_(integer *), afetat_(void), fentri_(real *, real *, real *,
	     real *), masqui_(real *, real *, real *, real *), wtrace_(void);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3037 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___3040 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3041 = { 0, 6, 0, 0, 0 };


/*       scanner de niveau 0 (designation), renvoie type=vlmenu */


/*      flip_flop calculette  0=numerique, 1=fonctions */
/*     include 'emc2_abrev.ins'                                         #F
R*/

/*      print*,'......... scan0 .........' */
    *redraw = '\376';
    *resize = '\377';

L1001:
    if (traint_1.ptintr != 0) {
	io___3037.ciunit = traint_1.interp[traint_1.ptintr - 1];
	i__1 = s_rsle(&io___3037);
	if (i__1 != 0) {
	    goto L100016;
	}
	i__1 = do_lio(&c__9, &c__1, txmn, 16L);
	if (i__1 != 0) {
	    goto L100016;
	}
	i__1 = do_lio(&c__9, &c__1, txcs, 16L);
	if (i__1 != 0) {
	    goto L100016;
	}
	i__1 = do_lio(&c__4, &c__1, (char *)&cdesig_1.x, (ftnlen)sizeof(real))
		;
	if (i__1 != 0) {
	    goto L100016;
	}
	i__1 = do_lio(&c__4, &c__1, (char *)&cdesig_1.y, (ftnlen)sizeof(real))
		;
	if (i__1 != 0) {
	    goto L100016;
	}
	i__1 = e_rsle();
L100016:
	if (i__1 < 0) {
	    goto L1000;
	}
	if (i__1 > 0) {
	    goto L1009;
	}
	cdesig_1.xdesig = cdesig_1.x;
	cdesig_1.ydesig = cdesig_1.y;
	if (s_cmp(txmn, "ECRAN           ", 16L, 16L) == 0) {
	    cdesig_1.vlmenu = 300;
	    *type = cdesig_1.vlmenu;
	} else {
	    for (cdesig_1.numenu = 1; cdesig_1.numenu <= 16; 
		    ++cdesig_1.numenu) {
		if (pec_1.acmenu[cdesig_1.numenu - 1] && s_cmp(
			pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), txmn, 
			16L, 16L) == 0) {
		    for (cdesig_1.nucase = 1; cdesig_1.nucase <= 32; 
			    ++cdesig_1.nucase) {
			if (pec_1.flcase[cdesig_1.nucase + (cdesig_1.numenu <<
				 5) - 33] && s_cmp(pectxt_1.txcase + (
				cdesig_1.nucase + (cdesig_1.numenu << 5) - 33 
				<< 4), txcs, 16L, 16L) == 0) {
			    cdesig_1.vlmenu = pec_1.vcase[cdesig_1.nucase + (
				    cdesig_1.numenu << 5) - 33];
			    *type = cdesig_1.vlmenu;
/*                  print*,'scan0:interp:numenu=',
numenu,' nucase=',nucas */
/*                 si pop flip flop calculette */
			    if (cdesig_1.numenu == 15 && cdesig_1.nucase == 
				    18 || cdesig_1.numenu == 16 && 
				    cdesig_1.nucase == 32) {
/*                    print*,'scan0: flip_flop
_calculette',flipc */
				flipq_(&flipc);
/*                   on re scan */
				goto L1001;
			    } else {
/*                   cas normal */
				return 0;
			    }
			}
/* L998: */
		    }
/*              print*,txcs,':case inconnue dans le menu:'
,txmn */
/* Writing concatenation */
		    i__2[0] = 16, a__1[0] = txcs;
		    i__2[1] = 23, a__1[1] = ":CASE INCONNUE DU MENU:";
		    i__2[2] = 16, a__1[2] = txmn;
		    s_cat(ch__1, a__1, i__2, &c__3, 55L);
		    scrtch_(ch__1, 55L);
		    goto L1001;
		}
/* L999: */
	    }
	    s_wsle(&io___3040);
	    do_lio(&c__9, &c__1, "MENU INCONNU:", 13L);
	    do_lio(&c__9, &c__1, txmn, 16L);
	    e_wsle();
/* Writing concatenation */
	    i__3[0] = 13, a__2[0] = "MENU INCONNU:";
	    i__3[1] = 16, a__2[1] = txmn;
	    s_cat(ch__2, a__2, i__3, &c__2, 29L);
	    scrtch_(ch__2, 29L);
	    goto L1001;
	}
	return 0;
L1009:
	s_wsle(&io___3041);
	do_lio(&c__9, &c__1, "err dans le read a l'interpretation", 35L);
	e_wsle();
	scrtch_("err dans le read a l'interpretation", 35L);
L1000:
/*       end of file a l'interpretation */
/*        print*,'fin interpration au niveau:',ptintr */
	cl__1.cerr = 0;
	cl__1.cunit = traint_1.interp[traint_1.ptintr - 1];
	cl__1.csta = 0;
	f_clos(&cl__1);
	--traint_1.ptintr;
#ifdef FRENCH
	scrtch_("FIN DE INTERPRETATION", 21L);
#else
	scrtch_("END OF INTERPRETATION", 21L);
#endif
	if (traint_1.ptintr == 0) {
/*         demarquage de la case */
	    menumk_(&c__3, &c__11, &c__0);
	}
	pec_1.fliflo = TRUE_;
	goto L1001;
    }
L10:
    if (pec_1.fliflo) {
	getxyc_(&cdesig_1.x, &cdesig_1.y, char1, 1L);
/*        print *,' getxyc :',x,y,char1 */
	/*	printf("fliflo getxyc %g %g %d \n",cdesig_1.x,cdesig_1.y,*char1);*/
	cdesig_1.xdesig = cdesig_1.x;
	cdesig_1.ydesig = cdesig_1.y;
	pec_1.fliflo = FALSE_;
	icha1 = *char1;

		if (*char1 == *resize) {
	    if (init2_(&c__1)) {
/*         on ne retrace pas parce que on va recevoir un redra
w */
/*         tout de suite apres */
/*          --- on rescan ---- */
	    }
	    goto L10;
	} else if (*char1 == *redraw) {
	    clean_();
	    afmenu_(&c__0);
	    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &
		    pec_1.masque[3]);
	    affich_();
	    afetat_();
	    afcalc_();
/*          fenetre et masque d'entree du curseur */
	    fentri_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &
		    pec_1.ecran[3]);
	    masqui_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &
		    pec_1.ecran[3]);
	    pec_1.fliflo = TRUE_;
/*          --- on rescan ---- */
	    goto L10;
	} else if (icha1 == 27) {
	    getxyc_(&cdesig_1.x, &cdesig_1.y, char1, 1L);
	    /*	printf("esc getxyc %g %g %d \n",cdesig_1.x,cdesig_1.y,*char1);*/
	    cdesig_1.xdesig = cdesig_1.x;
	    cdesig_1.ydesig = cdesig_1.y;
	    icha1 = *char1;
	    if (icha1 <= 127) {
		icha1 = esctyp[icha1];
	    } else {
		icha1 = 0;
	    }
	} else if (icha1 <= 127) {
	    icha1 = chatyp[icha1];
	} else {
	    icha1 = 0;
	}
    } else {
	icha1 = 0;
    }
/*  --- la fenetre a changer de taille on reachiffe */
    if (init2_(&c__1)) {
	clean_();
	afmenu_(&c__0);
	masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &
		pec_1.masque[3]);
	affich_();
	afetat_();
	afcalc_();
/*      fenetre et masque d'entree du curseur */
	fentri_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]
		);
	masqui_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]
		);
	pec_1.fliflo = TRUE_;
/*  --- on rescan ---- */
	goto L10;
    }
    if (icha1 == 0) {
	pec_1.fliflo = TRUE_;
/*       est on dans un menu? */
	for (numn = 1; numn <= 16; ++numn) {
	    if (pec_1.acmenu[numn - 1]) {
/*           menu actif */
		if (cdesig_1.x >= pec_1.fmenu[(numn << 2) - 4] && cdesig_1.x 
			<= pec_1.fmenu[(numn << 2) - 3] && cdesig_1.y >= 
			pec_1.fmenu[(numn << 2) - 2] && cdesig_1.y <= 
			pec_1.fmenu[(numn << 2) - 1]) {
/*             on est dans fenetre du menu k */
		    cdesig_1.x = (cdesig_1.x - pec_1.fmenu[(numn << 2) - 4]) *
			     pec_1.cmenu[(numn << 1) - 1] / (pec_1.fmenu[(
			    numn << 2) - 3] - pec_1.fmenu[(numn << 2) - 4]);
		    cdesig_1.y = (pec_1.fmenu[(numn << 2) - 1] - cdesig_1.y) *
			     pec_1.cmenu[(numn << 1) - 2] / (pec_1.fmenu[(
			    numn << 2) - 1] - pec_1.fmenu[(numn << 2) - 2]);
		    cdesig_1.xdesig = cdesig_1.x;
		    cdesig_1.ydesig = cdesig_1.y;
		    j = cdesig_1.x + 1;
		    i = cdesig_1.y + 1;
		    k = j + (i - 1) * pec_1.cmenu[(numn << 1) - 1];
		    if (! pec_1.flcase[k + (numn << 5) - 33]) {
			ici__1.icierr = 0;
			ici__1.icirnum = 1;
			ici__1.icirlen = 130;
			ici__1.iciunit = buf;
			ici__1.icifmt = fmt_888;
			s_wsfi(&ici__1);
			do_fio(&c__1, (char *)&numn, (ftnlen)sizeof(integer));
			do_fio(&c__1, (char *)&k, (ftnlen)sizeof(integer));
			e_wsfi();
			scrtch_(buf, 130L);
			goto L10;
		    }
		    cdesig_1.vlmenu = pec_1.vcase[k + (numn << 5) - 33];
		    *type = cdesig_1.vlmenu;
		    cdesig_1.numenu = numn;
		    cdesig_1.nucase = k;
/*              print*,'scan0:vous avez pointer le menu:',
txcase(k,numn) */
/*     +            ,'=',vlmenu,'. scan0 retourne:',type,x
,y */
/*              print*,'scan0:numenu=',numenu,' nucase=',n
ucase */
/*             raz de la ligne de scratch */
		    if (etat_1.scrtc) {
			scrtch_(" ", 1L);
		    }
		    if (traint_1.trace != 0) {
			wtrace_();
		    }
/*             si pop flip flop calculette */
		    if (cdesig_1.numenu == 15 && cdesig_1.nucase == 18 || 
			    cdesig_1.numenu == 16 && cdesig_1.nucase == 32) {
			flipq_(&flipc);
/*               on re scan */
			goto L10;
		    } else {
/*               cas normal */
			return 0;
		    }
		}
	    }
/* L1: */
	}
/*       est on dans la fenetre de travail? */
	if (cdesig_1.x >= pec_1.fentre[0] && cdesig_1.x <= pec_1.fentre[1] && 
		cdesig_1.y >= pec_1.fentre[2] && cdesig_1.y <= pec_1.fentre[3]
		) {
/*         on est dans fentre */
	    cdesig_1.vlmenu = 300;
	    *type = cdesig_1.vlmenu;
	    aa = (pec_1.fentre[0] - pec_1.fentre[1]) / (pec_1.masque[0] - 
		    pec_1.masque[1]);
	    bb = pec_1.fentre[0] - pec_1.masque[0] * aa;
	    cc = (pec_1.fentre[2] - pec_1.fentre[3]) / (pec_1.masque[2] - 
		    pec_1.masque[3]);
	    dd = pec_1.fentre[2] - pec_1.masque[2] * cc;
	    cdesig_1.x = (cdesig_1.x - bb) / aa;
	    cdesig_1.y = (cdesig_1.y - dd) / cc;
	    cdesig_1.xdesig = cdesig_1.x;
	    cdesig_1.ydesig = cdesig_1.y;
	} else {
/*         pointe errone */
/*         call scrtch('VOUS AVEZ POINTE SUR RIEN, RECOMMENCEZ' //
      #FR*/
/*    +                ', ET VISEZ JUSTE!')                       
      #FR*/
#ifdef FRENCH 
	    scrtch_("VOUS AVEZ POINTE SUR RIEN, RECOMMENCEZ ET VISEZ JUSTE!", 
		    54L);
#else

	    scrtch_("YOU PICK NOTHING, RETRY !", 25L);
#endif
/*          print*,'x=',x,' y=',y,' fentre=',fentre */
/*          print*,'ecran=',ecran */
	    goto L10;
	}
    } else {
	*type = icha1;
	for (numn = 1; numn <= 16; ++numn) {
	    if (pec_1.acmenu[numn - 1]) {
/*          menu actif */
		for (k = 1; k <= 32; ++k) {
		    if (*type == pec_1.vcase[k + (numn << 5) - 33]) {
			cdesig_1.vlmenu = pec_1.vcase[k + (numn << 5) - 33];
			cdesig_1.numenu = numn;
			cdesig_1.nucase = k;
/*              print*,'vous activez le menu:',txcase(
k,numn) */
/*     +            ,'=',vlmenu,'. scan0 retourne:',ty
pe */
/*             raz de la ligne de scratch */
			if (etat_1.scrtc) {
			    scrtch_(" ", 1L);
			}
/*             si on n'est pas dans la fenetre et si 
*/
/*              on ne designe pas un element (numero d
e menu p ... spl et */
/*              on ne se sert pas de x,y */
/*              print *,' fliflo avant =',fliflo */
			pec_1.fliflo = pec_1.fliflo || cdesig_1.x < 
				pec_1.fentre[0] || cdesig_1.x > pec_1.fentre[
				1] || cdesig_1.y < pec_1.fentre[2] || 
				cdesig_1.y > pec_1.fentre[3] || *type < 301 ||
				 *type > 313 || *type == 306;
/*              print *,' fliflo apres =',fliflo,x,y,t
ype,fentre */
			if (traint_1.trace != 0) {
			    wtrace_();
			}
/*              print*,'scan0:numenu=',numenu,' nucase
=',nucase */
/*             si pop flip flop calculette */
			if (cdesig_1.numenu == 15 && cdesig_1.nucase == 18 || 
				cdesig_1.numenu == 16 && cdesig_1.nucase == 
				32) {
			    flipq_(&flipc);
/*               on re scan */
			    goto L10;
			} else {
/*               cas normal */
			    return 0;
			}
		    }
/* L99: */
		}
	    }
/* L100: */
	}
	goto L10;
    }
/*      print*,'scan0 retourne:',type,' x=',x,' y=',y,' fliflo=',fliflo */
/*     raz de la ligne de scratch */
    if (etat_1.scrtc) {
	scrtch_(" ", 1L);
    }
    if (traint_1.trace != 0) {
	wtrace_();
    }
    return 0;
} /* scan0_ */




/* Subroutine */ int scrtch_(char *string, ftnlen string_len)
{
    /* System generated locals */
    address a__1[3];
    integer i__1, i__2, i__3[3];
    real r__1;

    /* Builtin functions */
    integer i_len(char *, ftnlen), i_indx(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    real f[4];
    integer i, l;

    extern /* Subroutine */ int thick_(real *), dring_(void), fentr2_(real *, 
	    real *, real *, real *), masqu2_(real *, real *, real *, real *), 
	    drw3tx_(real *, real *, integer *);
    real ym;
    char buf[256];
    extern /* Subroutine */ int noirci_(real *), limits_(integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3061 = { 0, 6, 0, 0, 0 };



/*     affiche dans la fenetre reserv (en haut), string */



    ym = (pec_1.reserv[2] + pec_1.reserv[3]) / 2.1f;
    f[0] = pec_1.reserv[0];
    f[1] = pec_1.reserv[1];
    f[2] = ym;
    f[3] = pec_1.reserv[3];
    noirci_(f);
    fentr2_(f, &f[1], &f[2], &f[3]);
    masqu2_(&c_b609, &c_b614, &c_b609, &c_b614);
    ligh3_(&c_n1, &c_n1, &pec_1.colore[1]);
    thick_(&c_b619);
    limits_(&c__0);
/*     si le texte n'est pas vide on l'affiche */
    thick_(&c_b604);
    r__1 = (pec_1.reserv[1] - pec_1.reserv[0]) / 132.f;
    drw3tx_(&r__1, &c_b609, &c__0);
    for (i = i_len(string, string_len); i >= 1; --i) {
	if (string[i - 1] != ' ') {
	    goto L2;
	}
/* L1: */
    }
L2:
/* Computing MIN */
    i__1 = i, i__2 = 256 - (i_len(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4)
	    , 16L) + 2);
    l = min(i__1,i__2);
    if (l >= 1 || *string != ' ') {
	i = i_indx(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), " ", 16L, 1L)
		;
	if (i == 0) {
	    i = i_len(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), 16L);
	}
/* Writing concatenation */
	i__3[0] = i, a__1[0] = pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4);
	i__3[1] = 1, a__1[1] = ":";
	i__3[2] = l, a__1[2] = string;
	s_cat(buf, a__1, i__3, &c__3, 256L);
	i__1 = i + 1 + l;
	txt2d_(buf, &i__1, &c_b661, &c_b662, 256L);
	s_wsle(&io___3061);
	do_lio(&c__9, &c__1, "SCRTCH:", 7L);
	do_lio(&c__9, &c__1, buf, i + 1 + l);
	e_wsle();
	dring_();
	etat_1.scrtc = TRUE_;
    } else {
	etat_1.scrtc = FALSE_;
    }
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* scrtch_ */




integer sens_(integer *refbd)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double r_sign(real *, real *);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real dist;
    extern /* Subroutine */ int gnin_(real *, real *, real *, integer *, real 
	    *);

    real p1[6], c2[6], r;
    integer i;
    extern /* Subroutine */ int drp1p2_(real *, real *, real *);
    real dd;
    extern doublereal dtp1xx_(real *, real *);
    real pp1[6], pp2[6], p1p2[6], ss[6];
    integer pt, pt1, nbg;
    real res, * xc/*[2001]*/, *yc/*[2001]*/;

    /* Fortran I/O blocks */
    /*static*/ cilist io___3081 = { 0, 6, 0, 0, 0 };



/*     sens=gauche si x,y du cote >0 (gauche) de bd(*,refbd) -1 */
/*               sinon droit */
    assert(xc = (real *) malloc(sizeof(real)*2001));
    assert(yc = (real *) malloc(sizeof(real)*2001));

    p1[0] = 0.f;
    p1[1] = cdesig_1.xdesig;
    p1[2] = cdesig_1.ydesig;
    for (i = 0; i <= 5; ++i) {
/* L1: */
	c2[i] = bdpec2_1.bd[i + *refbd * 6 + 384];
    }
    if (c2[0] == -3.f) {
	pp1[0] = 0.f;
	pp1[1] = c2[1];
	pp1[2] = c2[2];
	pp2[0] = 0.f;
	pp2[1] = c2[3];
	pp2[2] = c2[4];
	drp1p2_(p1p2, pp1, pp2);
	r__1 = p1p2[1] * p1[1] + p1p2[2] * p1[2] + p1p2[3];
	ret_val = r_sign(&c_b614, &r__1);
    } else if (c2[0] == -2.f) {
/* Computing 2nd power */
	r__1 = c2[1] - c2[3];
/* Computing 2nd power */
	r__2 = c2[2] - c2[4];
	r = r__1 * r__1 + r__2 * r__2;
/* Computing 2nd power */
	r__2 = p1[1] - c2[1];
/* Computing 2nd power */
	r__3 = p1[2] - c2[2];
	r__1 = r - (r__2 * r__2 + r__3 * r__3);
	ret_val = r_sign(&c_b614, &r__1);
	if (c2[5] < 0.f) {
	    ret_val = -ret_val;
	}
    } else if (bdpec2_1.bd[*refbd * 6 + 384] == -4.f) {
	dist = 1e30f;
	ss[0] = -3.f;
	pp1[0] = 0.f;
	pp1[1] = 0.f;
	pp1[2] = 0.f;
	pp2[0] = 0.f;
	pp2[1] = 1.f;
	pp2[2] = 1.f;
	pt = bdpec2_1.bd[*refbd * 6 + 386];
	pt1 = listea_1.car[pt - 1];
/*       1er point */
	ss[1] = bdpec2_1.bd[pt1 * 6 + 385];
	ss[2] = bdpec2_1.bd[pt1 * 6 + 386];
L3:
	if (pt != 0) {
	    pt1 = listea_1.car[pt - 1];
/*         dernier point */
	    ss[3] = bdpec2_1.bd[pt1 * 6 + 385];
	    ss[4] = bdpec2_1.bd[pt1 * 6 + 386];
	    pt = listed_1.cdr[pt - 1];
	    goto L3;
	}
/*       on cree 8 fois plus de points intermediaires que de points de
 co */
/* Computing MIN */
	i__1 = 127, i__2 = (integer) bdpec2_1.bd[*refbd * 6 + 385] << 3;
	nbg = min(i__1,i__2);
	res = 1.f;
/*        print*,'nbg=',nbg */
	gnin_(&bdpec2_1.bd[*refbd * 6 + 384], &xc[1], &yc[1], &nbg, &res);
	xc[0] = ss[1];
	yc[0] = ss[2];
	xc[nbg - 1] = ss[3];
	yc[nbg - 1] = ss[4];
/*        print*,'1er=',ss(1),ss(2) */
/*        print*,'der=',ss(3),ss(4) */
/*        do i=0,nbg-1 */
/*          print*,i,' xc=',xc(i),' yc=',yc(i) */
/*        enddo */
	i__1 = nbg - 1;
	for (i = 1; i <= i__1; ++i) {
/*          print*,'i=',i */
	    ss[3] = xc[i];
	    ss[4] = yc[i];
	    dd = dtp1xx_(p1, ss);
	    if (dd < dist) {
		dist = dd;
		pp1[1] = ss[1];
		pp1[2] = ss[2];
		pp2[1] = ss[3];
		pp2[2] = ss[4];
	    }
	    ss[1] = ss[3];
	    ss[2] = ss[4];
/* L2: */
	}
/* x        pt=bd(2,refbd) */
/* x        if(pt.ne.nil)then */
/* x          pt1=car(pt) */
/* x          ss(1)=bd(1,pt1) */
/* x          ss(2)=bd(2,pt1) */
/* x          pt=cdr(pt) */
/* x2         continue */
/* x          if(pt.ne.nil)then */
/* x            pt1=car(pt) */
/* x            ss(3)=bd(1,pt1) */
/* x            ss(4)=bd(2,pt1) */
/* x            dd=dtp1xx(p1,ss) */
/* x            if(dd.lt.dist)then */
/* x              dist=dd */
/* x              pp1(1)=ss(1) */
/* x              pp1(2)=ss(2) */
/* x              pp2(1)=ss(3) */
/* x              pp2(2)=ss(4) */
/* x            endif */
/* x            ss(1)=ss(3) */
/* x            ss(2)=ss(4) */
/* x            pt=cdr(pt) */
/* x            goto 2 */
/* x          endif */
/* x        endif */
	drp1p2_(p1p2, pp1, pp2);
/* c        if(sign(1.,p1p2(1)*p1(1)+p1p2(2)*p1(2)+p1p2(3)).eq.1.)then
 */
/* c          sens=gauche */
/* c        else */
/* c          sens=droit */
/* c        endif */
	r__1 = p1p2[1] * p1[1] + p1p2[2] * p1[2] + p1p2[3];
	ret_val = r_sign(&c_b614, &r__1);
    } else {
	s_wsle(&io___3081);
	do_lio(&c__9, &c__1, "SENS:ERREUR: MAUVAIS TYPE", 25L);
	do_lio(&c__4, &c__1, (char *)&c2[0], (ftnlen)sizeof(real));
	e_wsle();
	ret_val = 1;
    }
    if (ret_val != 1) {
	ret_val = 2;
    }
    free(xc);free(yc);
    return ret_val;
} /* sens_ */




/* Subroutine */ int softcp_(void)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer echi, idev;
    extern /* Subroutine */ int clip_(logical *), ligh3_(integer *, integer *,
	     integer *), draw3_(integer *);
    extern logical init2_(integer *);
    integer i;
    extern /* Subroutine */ int clean_(void);

    extern /* Subroutine */ int thick_(real *), masqu2_(real *, real *, real *
	    , real *), afcalc_(void), affich_(void);
    real cx;
    char buf[256];
    real savfnt[4], savmsq[4], savecr[4], savech, dx, dy, cy, mmx, mmy, fx, 
	    fy, mx, my, hx, hy;
    integer paramo[10], parami[10];
    char string[80];
    logical drwmenu, tmplgq;
    extern /* Subroutine */ int intext_(char *, integer *, char *, integer *, 
	    ftnlen, ftnlen), scrtch_(char *, ftnlen), enddev_(integer *), 
	    defdev_(integer *, integer *, integer *, char *, ftnlen), inicol_(
	    void), limits_(integer *), afmenu_(integer *), menumk_(integer *, 
	    integer *, integer *), afetat_(void), fentri_(real *, real *, 
	    real *, real *), masqui_(real *, real *, real *, real *), szscrn_(
	    real *, real *, real *, real *), device_(integer *, integer *, 
	    char *, ftnlen), devici_(integer *, integer *), inqfac_(logical *)
	    ;
    logical ffac;

    /* Fortran I/O blocks */
    /*static*/ cilist io___3089 = { 0, 6, 0, 0, 0 };


    idev = 0;
    intext_("<rc> => constant scale, v => change scale,(+ => menu, other => "
	    "cancel soft copy)", &c__100, buf, &echi, 80L, 256L);
/*     call intext( '<rc> => echelle constante, v => echelle variable,' #F
R*/
/*   +           // '(+ => menu, autre => annuler le soft copy)',       #F
R*/
/*   +              100,buf,echi)                                       #F
R*/
    if (echi == 0) {
	*buf = 'v';
    }
    drwmenu = *buf == '+';
    if (*buf != 'v' && *buf != 'V' && *buf != '+') {
	s_wsle(&io___3089);
	do_lio(&c__9, &c__1, "'", 1L);
	i__1 = echi;
	for (i = 1; i <= i__1; ++i) {
	    do_lio(&c__9, &c__1, buf + (i - 1), 1L);
	}
	do_lio(&c__9, &c__1, "'", 1L);
	e_wsle();
	scrtch_("on abandonne le soft copy ( le caractere n'est pas dans 'vV"
		"+<cr>')", 66L);
	return 0;
    }
    if (pec_1.appli == 514) {
/*        call intext(' trace des reference (cr=> oui, autre => non):'
  #FR*/
	intext_(" draw the reference (cr=> yes, other => no):", &c__100, buf, 
		&i, 44L, 256L);
	if (i != 0) {
	    bdmshm_1.optdrw = 1;
	}
    }
    savech = etat_1.echel;
    for (i = 1; i <= 4; ++i) {
	savecr[i - 1] = pec_1.ecran[i - 1];
	savfnt[i - 1] = pec_1.fentre[i - 1];
	savmsq[i - 1] = pec_1.masque[i - 1];
/* L1300: */
    }
    i__1 = -pec_1.devic;
    enddev_(&i__1);
    defdev_(&idev, paramo, parami, string, 80L);
    clip_((logical*)&c__1);
/*       init des indices des couleurs */
    inicol_();
/*       init position des menus et des fenetres et de leurs couleurs */
    tmplgq = init2_(&c__0);
/*     demande de la taille de l'ecran */
/*     restauration des menus actifs */
    if (pec_1.appli == 511) {
	pec_1.acmenu[0] = TRUE_;
	pec_1.acmenu[3] = TRUE_;
    } else if (pec_1.appli == 513) {
	pec_1.acmenu[0] = FALSE_;
	pec_1.acmenu[3] = FALSE_;
	pec_1.acmenu[5] = TRUE_;
	pec_1.acmenu[11] = TRUE_;
    } else if (pec_1.appli == 514) {
	pec_1.acmenu[0] = FALSE_;
	pec_1.acmenu[3] = FALSE_;
	pec_1.acmenu[6] = TRUE_;
	pec_1.acmenu[12] = TRUE_;
    }
    if (drwmenu) {
	clip_((logical*)&c__1);
	ligh3_(&c_n1, &c_n1, &pec_1.coloec);
	draw3_(&c__0);
	thick_(&c_b604);
	limits_(&c__0);
	afmenu_(&c_n1);
/*       demarquage de la case softcopy */
	menumk_(&c__3, &c__8, &c__0);
	if (pec_1.appli == 511) {
/*          marquage de la case constuction */
	    menumk_(&c__3, &c__12, &c__18);
	} else if (pec_1.appli == 513) {
/*          marquage de la case maillage */
	    menumk_(&c__3, &c__13, &c__18);
	} else if (pec_1.appli == 514) {
/*          marquage de la case ed_mesh */
	    menumk_(&c__3, &c__14, &c__18);
	}
	masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &
		pec_1.masque[3]);
	afetat_();
	afcalc_();
/*       fenetre et masque d'entree du curseur */
	fentri_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]
		);
	masqui_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]
		);
    } else {
	szscrn_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &
		pec_1.fentre[3]);
	pec_1.fentre[0] += .2f;
	pec_1.fentre[1] += -.2f;
	pec_1.fentre[2] += .2f;
	pec_1.fentre[3] += -.2f;
	pec_1.ecran[0] = pec_1.fentre[0];
	pec_1.ecran[1] = pec_1.fentre[1];
	pec_1.ecran[2] = pec_1.fentre[2];
	pec_1.ecran[3] = pec_1.fentre[3];
    }
    etat_1.echel = savech;
    pec_1.masque[0] = savmsq[0];
    pec_1.masque[1] = savmsq[1];
    pec_1.masque[2] = savmsq[2];
    pec_1.masque[3] = savmsq[3];
    if (echi == 0) {
/*       echelle constante */
	dx = (pec_1.fentre[1] - pec_1.fentre[0]) / etat_1.echel;
	dy = (pec_1.fentre[3] - pec_1.fentre[2]) / etat_1.echel;
	cx = (pec_1.masque[0] + pec_1.masque[1]) / 2.f;
	cy = (pec_1.masque[2] + pec_1.masque[3]) / 2.f;
	pec_1.masque[0] = cx - dx / 2.f;
	pec_1.masque[1] = cx + dx / 2.f;
	pec_1.masque[2] = cy - dy / 2.f;
	pec_1.masque[3] = cy + dy / 2.f;
    } else {
/*       echelle variable */
/*       rendre le masque de memes proportions que la fenetre */
	mmx = (pec_1.masque[0] + pec_1.masque[1]) / 2.f;
	mmy = (pec_1.masque[2] + pec_1.masque[3]) / 2.f;
	fx = (pec_1.fentre[1] - pec_1.fentre[0]) / 2.f;
	fy = (pec_1.fentre[3] - pec_1.fentre[2]) / 2.f;
	mx = (pec_1.masque[1] - pec_1.masque[0]) / 2.f;
	my = (pec_1.masque[3] - pec_1.masque[2]) / 2.f;
	if (mx != 0.f) {
	    hx = fx / mx;
	} else {
	    hx = fx;
	}
	hy = hx;
	if (fy < my * hy) {
	    if (my != 0.f) {
		hy = fy / my;
	    } else {
		hy = 1.f;
	    }
	    hx = hy;
	}
	if (hx == 0.f || hy == 0.f) {
	    hx = 1.f;
	    hy = 1.f;
	}
	pec_1.masque[0] = mmx - fx / hx;
	pec_1.masque[1] = mmx + fx / hx;
	pec_1.masque[2] = mmy - fy / hy;
	pec_1.masque[3] = mmy + fy / hy;
	etat_1.echel = hx;
    }
    ligh3_(&c_n1, &c_n1, &pec_1.coloec);
    thick_(&c_b619);
    draw3_(&c__0);
    limits_(&c__0);
    thick_(&c_b604);
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    affich_();
    bdmshm_1.optdrw = 0;
    i__1 = -idev;
    enddev_(&i__1);
    device_(&pec_1.devic, pec_1.parout, pecstr_1.parstr, 80L);
    devici_(&pec_1.devic, pec_1.parin);
/*      init des indices des couleurs */
    inicol_();
/*      init position des menus et des fenetres et de leurs couleurs */
    tmplgq = init2_(&c__0);
/*      restauration des menus actifs */
    if (pec_1.appli == 511) {
	pec_1.acmenu[0] = TRUE_;
	pec_1.acmenu[3] = TRUE_;
    } else if (pec_1.appli == 513) {
	pec_1.acmenu[0] = FALSE_;
	pec_1.acmenu[3] = FALSE_;
	pec_1.acmenu[5] = TRUE_;
	pec_1.acmenu[11] = TRUE_;
    } else if (pec_1.appli == 514) {
	pec_1.acmenu[0] = FALSE_;
	pec_1.acmenu[3] = FALSE_;
	pec_1.acmenu[6] = TRUE_;
	pec_1.acmenu[12] = TRUE_;
    }
    for (i = 1; i <= 4; ++i) {
	pec_1.ecran[i - 1] = savecr[i - 1];
	pec_1.fentre[i - 1] = savfnt[i - 1];
	pec_1.masque[i - 1] = savmsq[i - 1];
/* L1301: */
    }
    etat_1.echel = savech;
    inqfac_(&ffac);
    if (! ffac) {
/*          tektro ou device sans effacement selectif */
	clean_();
    }
    clip_((logical*)&c__1);
    ligh3_(&c_n1, &c_n1, &pec_1.coloec);
    draw3_(&c__0);
    thick_(&c_b604);
    limits_(&c__0);
    afmenu_(&c_n1);
/*        demarquage de la case softcopy */
    menumk_(&c__3, &c__8, &c__0);
    if (pec_1.appli == 511) {
/*         marquage de la case constuction */
	menumk_(&c__3, &c__12, &c__18);
    } else if (pec_1.appli == 513) {
/*        marquage de la case maillage */
	menumk_(&c__3, &c__13, &c__18);
    } else if (pec_1.appli == 514) {
/*         marquage de la case ed_mesh */
	menumk_(&c__3, &c__14, &c__18);
    }
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    affich_();
    afetat_();
    afcalc_();
/*      fenetre et masque d'entree du curseur */
    fentri_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]);
    masqui_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]);
    return 0;
} /* softcp_ */




integer sproch_(real *xx, real *yy)
{
    /* System generated locals */
    integer ret_val;
    real r__1, r__2;

    /* Local variables */
    real dist;
    integer i;

    real disti;
    extern integer tproch_(real *, real *);

    cdsmsh_1.adrtri = tproch_(xx, yy);
    if (cdsmsh_1.adrtri == 0) {
	ret_val = 0;
    } else {
	i = bdmsh9_1.nsea[cdsmsh_1.adrtri * 6 - 6];
	ret_val = i;
/* Computing 2nd power */
	r__1 = bdmsh5_1.cr[(i << 1) - 2] - *xx;
/* Computing 2nd power */
	r__2 = bdmsh5_1.cr[(i << 1) - 1] - *yy;
	dist = r__1 * r__1 + r__2 * r__2;
	i = bdmsh9_1.nsea[cdsmsh_1.adrtri * 6 - 5];
/* Computing 2nd power */
	r__1 = bdmsh5_1.cr[(i << 1) - 2] - *xx;
/* Computing 2nd power */
	r__2 = bdmsh5_1.cr[(i << 1) - 1] - *yy;
	disti = r__1 * r__1 + r__2 * r__2;
	if (disti < dist) {
	    ret_val = i;
	    dist = disti;
	}
	i = bdmsh9_1.nsea[cdsmsh_1.adrtri * 6 - 4];
/* Computing 2nd power */
	r__1 = bdmsh5_1.cr[(i << 1) - 2] - *xx;
/* Computing 2nd power */
	r__2 = bdmsh5_1.cr[(i << 1) - 1] - *yy;
	disti = r__1 * r__1 + r__2 * r__2;
	if (disti < dist) {
	    ret_val = i;
/* x          dist = disti */
	}
    }
    return ret_val;
} /* sproch_ */




/* Subroutine */ int srtri2_(real *criter, integer *record1, integer *record2,
	 integer *n)
{
    /*static*/ real crit;
    /*static*/ integer i, j, l, r, rec1, rec2;


/*     trie selon les valeurs de criter croissantes */
/*     record1 et record2 suivent le reordonnancement */

/* -bug -O sur hp9000-700 */

/*      print*,'heapii: on trie',n,' objets' */
    /* Parameter adjustments */
    --record2;
    --record1;
    --criter;

    /* Function Body */
    if (*n <= 1) {
	return 0;
    }
/*      print *,'E',n,criter,':',record1,':',record2 */
    l = *n / 2 + 1;
    r = *n;
L2:
    if (l <= 1) {
	goto L20;
    }
    --l;
    rec1 = record1[l];
    rec2 = record2[l];
    crit = criter[l];
    goto L3;
L20:
    rec1 = record1[r];
    rec2 = record2[r];
    crit = criter[r];
    record1[r] = record1[1];
    record2[r] = record2[1];
    criter[r] = criter[1];
    --r;
    if (r == 1) {
	goto L999;
    }
L3:
    j = l;
L4:
    i = j;
    j <<= 1;
    if (j - r < 0) {
	goto L5;
    } else if (j == r) {
	goto L6;
    } else {
	goto L8;
    }
L5:
    if (criter[j] < criter[j + 1]) {
	++j;
    }
L6:
    if (crit >= criter[j]) {
	goto L8;
    }
    record1[i] = record1[j];
    record2[i] = record2[j];
    criter[i] = criter[j];
    goto L4;
L8:
    record1[i] = rec1;
    record2[i] = rec2;
    criter[i] = crit;
    goto L2;
L999:
    record1[1] = rec1;
    record2[1] = rec2;
    criter[1] = crit;
/*      print *,'S',n,criter,':',record1,':',record2 */
    return 0;
} /* srtri2_ */

/* Subroutine */ int strint_(integer *i, char *string, integer *l, ftnlen 
	string_len)
{
    /* System generated locals */
    integer i__1, i__2;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);

    /* Local variables */
    integer j;
    char str[10];

/* --------------------------------------------------------------------- 
*/
/*     but transformer l'entier i en chaine string est l est longueur */
/* -------------------------------------------------------------------- */
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 10;
    ici__1.iciunit = str;
    ici__1.icifmt = "(I10)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&(*i), (ftnlen)sizeof(integer));
    e_wsfi();
    j = 1;
L1:
    if (str[j - 1] == ' ') {
	++j;
	if (j < 10) {
	    goto L1;
	}
    }
    s_copy(string, str + (j - 1), string_len, 10 - (j - 1));
/* Computing MIN */
    i__1 = i_len(string, string_len), i__2 = 11 - j;
    *l = min(i__1,i__2);
    return 0;
} /* strint_ */

doublereal surfa_(real *xc, real *yc, real *xx1, real *yy1, real *alpha, 
	integer *nbnode, real *raison)
{
    /* System generated locals */
    integer i__1;
    real ret_val, r__1;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), pow_ri(real *, integer *);

    /* Local variables */
    real a;
    integer i;
    extern doublereal surfs_(real *, real *, real *, real *);
    real x1, y1, x2, y2, dx, dy, dalpha, xf, yf;
    real rap;


/*     renvoie la valeur de la surface en dessous de l'arc */

    dx = *xx1 - *xc;
    dy = *yy1 - *yc;
    xf = *xc + dx * cos(*alpha) - dy * sin(*alpha);
    yf = *yc + dx * sin(*alpha) + dy * cos(*alpha);
    if ((r__1 = *alpha - 6.283185306f, dabs(r__1)) <= 5e-6f) {
	xf = *xx1;
	yf = *yy1;
    }
    if (*nbnode <= 2) {
	ret_val = surfs_(xx1, yy1, &xf, &yf);
    } else {
	if (*raison == 1.f) {
	    dalpha = *alpha / (*nbnode - 1);
	} else {
	    i__1 = *nbnode - 1;
	    rap = (*raison - 1.f) / (pow_ri(raison, &i__1) - 1.f);
	    dalpha = *alpha * rap;
	}
	x1 = *xx1;
	y1 = *yy1;
	a = 0.f;
	ret_val = 0.f;
	i__1 = *nbnode - 2;
	for (i = 1; i <= i__1; ++i) {
	    a += dalpha;
	    x2 = *xc + dx * cos(a) - dy * sin(a);
	    y2 = *yc + dx * sin(a) + dy * cos(a);
	    dalpha *= *raison;
	    ret_val += surfs_(&x1, &y1, &x2, &y2);
	    x1 = x2;
	    y1 = y2;
/* L1: */
	}
	ret_val += surfs_(&x1, &y1, &xf, &yf);
    }
    return ret_val;
} /* surfa_ */

#undef coulls


doublereal surfs_(real *x1, real *y1, real *x2, real *y2)
{
    /* System generated locals */
    real ret_val;


/*     renvoie la valeur de la surface en dessous du segment */

    ret_val = (*y1 + *y2) * (*x1 - *x2) / 2.f;
    return ret_val;
} /* surfs_ */

doublereal surfsp_(integer *iadr)
{
    /* System generated locals */
    integer i__1;
    real ret_val;

    /* Local variables */
    extern integer last_(integer *);
    extern /* Subroutine */ int gnin_(real *, real *, real *, integer *, real 
	    *);

    extern doublereal surfs_(real *, real *, real *, real *);
    integer i;
    integer pt;
    real xx[1000], yy[1000], xx1, yy1, xx2, yy2;


/*     renvoie la valeur de la surface en dessous la spline */

    ret_val = 0.f;
    gnin_(&bdpec2_1.bd[*iadr * 6 + 384], xx, yy, &bdpec3_1.nbnode[*iadr + 64],
	     &bdpec4_1.raison[*iadr + 64]);
    pt = bdpec2_1.bd[*iadr * 6 + 386];
    xx1 = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
    yy1 = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
    pt = last_(&pt);
    xx2 = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
    yy2 = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
    i__1 = bdpec3_1.nbnode[*iadr + 64] - 2;
    for (i = 1; i <= i__1; ++i) {
	ret_val += surfs_(&xx1, &yy1, &xx[i - 1], &yy[i - 1]);
	xx1 = xx[i - 1];
	yy1 = yy[i - 1];
/* L1: */
    }
    ret_val += surfs_(&xx1, &yy1, &xx2, &yy2);
/*      print*,'surfsp=',surfsp */
    return ret_val;
} /* surfsp_ */




logical testpx_(real *p1, real *c2)
{
    /* System generated locals */
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);
    double r_mod(real *, real *);

    /* Local variables */
    extern /* Subroutine */ int tilt_(void);

    extern doublereal atang2_(real *, real *);
    extern /* Subroutine */ int drp1p2_(real *, real *, real *), dp1d1a_(real 
	    *, real *, real *, real *);
    real dd[6];
    real ang1, ang2, ang, pp1[4], pp2[4], ps1, ps2, p1p2[6];
    extern /* Subroutine */ int scrtch_(char *, ftnlen), enddev_(integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3154 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3164 = { 0, 6, 0, 0, 0 };


/*         si c2 est un segment renvoie true si la projection orthogonale 
*/
/*                              est dans le segment */
/*         si c2 est un arc     renvoie true si p1 appartient a l'angle d 
*/
/*         si c2 est une spline renvoie true si la projection orthogonale 
*/
/*                              est dans la spline */


    if (p1[0] != 0.f) {
	scrtch_("TESTPX:POINT DE MAUVAIS TYPE", 28L);
	s_wsle(&io___3154);
	do_lio(&c__9, &c__1, "TESTPX:POINT DE MAUVAIS TYPE", 28L);
	do_lio(&c__4, &c__1, (char *)&p1[0], (ftnlen)sizeof(real));
	e_wsle();
	ret_val = FALSE_;
	enddev_(&pec_1.devic);
	assert(0 /* tilt() */);
	s_stop("FATAL ERROR TESTPX 1", 20L);
    }
    if (c2[0] == -3.f) {
	pp1[0] = 0.f;
	pp1[1] = c2[1];
	pp1[2] = c2[2];
	pp2[0] = 0.f;
	pp2[1] = c2[3];
	pp2[2] = c2[4];
	drp1p2_(p1p2, pp1, pp2);
	dp1d1a_(dd, p1, p1p2, &c_b2168);
	ps1 = dd[1] * c2[1] + dd[2] * c2[2] + dd[3];
	ps2 = dd[1] * c2[3] + dd[2] * c2[4] + dd[3];
/* Computing 2nd power */
	r__1 = etat_1.echel;
	if (ps1 * ps2 <= -(doublereal)eps_1.eps / (r__1 * r__1)) {
	    ret_val = TRUE_;
	} else {
	    ret_val = FALSE_;
	}
    } else if (c2[0] == -2.f) {
	r__1 = p1[2] - c2[2];
	r__2 = p1[1] - c2[1];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = c2[4] - c2[2];
	r__2 = c2[3] - c2[1];
	ang2 = atang2_(&r__1, &r__2);
	r__1 = ang1 - ang2 + 6.283185306f;
	ang = r_mod(&r__1, &c_b28);
	if (c2[5] < -5e-6f) {
	    ang += -6.283185306f;
	    if (ang >= c2[5]) {
		ret_val = TRUE_;
	    } else {
		ret_val = FALSE_;
	    }
	} else {
	    if (ang <= c2[5]) {
		ret_val = TRUE_;
	    } else {
		ret_val = FALSE_;
	    }
	}
    } else if (c2[0] == -4.f) {
/*        call scrtch('testpx: spline: non implemente') */
	ret_val = TRUE_;
    } else if (c2[0] == -1.f) {
	ret_val = TRUE_;
    } else if (c2[0] >= 0.f) {
	ret_val = TRUE_;
    } else if (c2[0] == -1e3f) {
	ret_val = TRUE_;
    } else {
	scrtch_("TESTPX: MAUVAIS TYPE", 20L);
	s_wsle(&io___3164);
	do_lio(&c__9, &c__1, "TESTPX: MAUVAIS TYPE", 20L);
	do_lio(&c__4, &c__1, (char *)&c2[0], (ftnlen)sizeof(real));
	e_wsle();
	ret_val = FALSE_;
	enddev_(&pec_1.devic);
	assert(0 /* tilt() */);
	s_stop("FATAL ERROR TESTPX 2", 20L);
    }
    return ret_val;
} /* testpx_ */




/* Subroutine */ int topocc_(real *c1, real *c2, integer *topo)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sqrt(doublereal);

    /* Local variables */
    real dray;
    extern /* Subroutine */ int itd1d_(real *, real *, real *);
    real a, p[4];
    extern doublereal dtc1c2_(real *, real *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3166 = { 0, 6, 0, 0, 0 };



/*     topo =0 si c1^c2=0   (c1 et c2 exterieurs l'un a l'autre) */
/*     topo =1 si c1^c2=c1  (c1 dans c2) (jamais si c1 est une droite) */
/*     topo =2 si c1^c2=c2  (c2 dans c1) (jamais si c2 est une droite) */
/*     topo =3 si c1^c2#0   (c1 et c2 s'intersectent) */



    if (c1[0] == -1e3f || c2[0] == -1e3f) {
	s_wsle(&io___3166);
	do_lio(&c__9, &c__1, "TOPOCC ERREUR DE TYPE", 21L);
	e_wsle();
	*topo = 0;
    } else if (c1[0] == -1.f) {
	if (c2[0] == -1.f) {
	    itd1d_(p, c1, c2);
	    if (p[0] == -1e3f) {
		*topo = 0;
	    } else {
		*topo = 3;
	    }
	} else {
/*         c1 une droite et c2 un cercle */
	    if (dtc1c2_(c1, c2) > c2[0]) {
		if (c1[1] * c2[1] + c1[2] * c2[2] + c1[3] > 0.f) {
/*              c2 a l'interieur de c1 */
		    *topo = 2;
		} else {
		    *topo = 0;
		}
	    } else {
		*topo = 3;
	    }
	}
    } else if (c2[0] == -1.f) {
	if (dtc1c2_(c1, c2) > c1[0]) {
	    if (c2[1] * c1[1] + c2[2] * c1[2] + c2[3] > 0.f) {
		*topo = 1;
	    } else {
		*topo = 0;
	    }
	} else {
	    *topo = 3;
	}
    } else {
/*       c1 et c2 sont des cercles */
/* Computing 2nd power */
	r__1 = c1[1] - c2[1];
/* Computing 2nd power */
	r__2 = c1[2] - c2[2];
	a = sqrt(r__1 * r__1 + r__2 * r__2);
	dray = (r__1 = c1[0] - c2[0], dabs(r__1));
	if (a > c1[0] + c2[0] + eps_1.eps) {
/*         non intersection cercles exterieurs l'un a l'autre */
	    *topo = 0;
	} else if (dray > a + eps_1.eps) {
/*         non intersection cercles interieurs */
	    if (c1[0] > c2[0]) {
		*topo = 2;
	    } else {
		*topo = 1;
	    }
	} else if ((r__1 = c1[0] + c2[0] - a, dabs(r__1)) <= eps_1.eps) {
/*         tangence cercles exterieurs */
	    *topo = 0;
	} else if ((r__1 = dray - a, dabs(r__1)) <= eps_1.eps) {
/*         tangence cercles interieurs */
	    if ((r__1 = c1[0] - c2[0], dabs(r__1)) < eps_1.eps) {
/*           cercles concentriques de meme rayon */
		*topo = 1;
	    } else if (c1[0] > c2[0]) {
		*topo = 2;
	    } else {
		*topo = 1;
	    }
	} else {
/*         intersection des cercles */
	    *topo = 3;
	}
    }
    return 0;
} /* topocc_ */

#undef coulls


integer tproch_(real *xx, real *yy)
{
    /* Initialized data */

    static integer p3[3] = { 2,3,1 };

    /* System generated locals */
    integer ret_val, i__1;
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer ires, i, j, k;

    integer nbesd;
    real aa[12]	/* was [3][4] */;
    integer ie;
    real v11, v12;
    real v21, v22;
    integer iep, ie1, isd;
    extern /* Subroutine */ int gauspp_(real *, integer *, integer *, real *, 
	    integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3179 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3189 = { 0, 6, 0, 0, 0 };


    i__1 = bdmsh1_1.nbsd;
    for (isd = 1; isd <= i__1; ++isd) {
	if (bdmshf_1.refsd[isd - 1] != -1073741824) {
	    if (bdmshj_1.ptorsd[isd - 1] == isd) {
		*xx = cdesig_1.x;
		*yy = cdesig_1.y;
	    } else {
		aa[9] = cdesig_1.x;
		aa[10] = cdesig_1.y;
		aa[11] = 1.f;
		for (i = 1; i <= 3; ++i) {
		    for (j = 1; j <= 3; ++j) {
			aa[j + i * 3 - 4] = bdmshh_1.trfsd[j + (i + isd * 3) *
				 3 - 13];
/* L5: */
		    }
		}
		gauspp_(aa, &c__3, &c__4, &c_b7748, &ires);
		if (ires != 0) {
		    s_wsle(&io___3179);
		    do_lio(&c__9, &c__1, "ERREUR trf non inversible", 25L);
		    e_wsle();
		    goto L30;
		}
		*xx = aa[9];
		*yy = aa[10];
/*          print *,'tproche: x,y = ',x,y,' xx,yy =',xx,yy */
	    }
	    iep = 0;
	    ie = bdmsh2_1.tetsd[isd - 1];
	    nbesd = 0;
L10:
	    if (ie == 1073741824) {
/*          print *,'nb d''element du sous domaine ',isd,' est
 : ',nbesd */
		goto L30;
	    } else if (bdmsh9_1.nsea[ie * 6 - 6] == 0) {
/*          suppression des element vides */
		if (iep == 0) {
		    bdmsh2_1.tetsd[isd - 1] = bdmsha_1.reft[ie - 1];
		} else {
		    bdmsha_1.reft[iep - 1] = bdmsha_1.reft[ie - 1];
		}
/*          chainage des elements vide */
/*           print *,'tproch: on dechaine l''element ',ie,reft
(ie),finsd */
		ie1 = bdmsha_1.reft[ie - 1];
		bdmsha_1.reft[ie - 1] = bdmsh3_1.freetr;
		bdmsh3_1.freetr = ie;
		ie = ie1;
		goto L10;
	    } else {
		++nbesd;
		iep = ie;
		ie = bdmsha_1.reft[iep - 1];
/*          test de rejection rapide sur la boite comptant le 
triangle ie */
		i = bdmsh9_1.nsea[iep * 6 - 6];
		j = bdmsh9_1.nsea[iep * 6 - 5];
		k = bdmsh9_1.nsea[iep * 6 - 4];
/* Computing MIN */
		r__1 = bdmsh5_1.cr[(i << 1) - 2], r__2 = bdmsh5_1.cr[(j << 1) 
			- 2], r__1 = min(r__1,r__2), r__2 = bdmsh5_1.cr[(k << 
			1) - 2];
		if (*xx < dmin(r__1,r__2)) {
		    goto L10;
		}
/* Computing MAX */
		r__1 = bdmsh5_1.cr[(i << 1) - 2], r__2 = bdmsh5_1.cr[(j << 1) 
			- 2], r__1 = max(r__1,r__2), r__2 = bdmsh5_1.cr[(k << 
			1) - 2];
		if (*xx > dmax(r__1,r__2)) {
		    goto L10;
		}
/* Computing MIN */
		r__1 = bdmsh5_1.cr[(i << 1) - 1], r__2 = bdmsh5_1.cr[(j << 1) 
			- 1], r__1 = min(r__1,r__2), r__2 = bdmsh5_1.cr[(k << 
			1) - 1];
		if (*yy < dmin(r__1,r__2)) {
		    goto L10;
		}
/* Computing MAX */
		r__1 = bdmsh5_1.cr[(i << 1) - 1], r__2 = bdmsh5_1.cr[(j << 1) 
			- 1], r__1 = max(r__1,r__2), r__2 = bdmsh5_1.cr[(k << 
			1) - 1];
		if (*yy > dmax(r__1,r__2)) {
		    goto L10;
		}
/*          test de rejection exacte */
		for (k = 1; k <= 3; ++k) {
		    i = bdmsh9_1.nsea[k + iep * 6 - 7];
		    j = bdmsh9_1.nsea[p3[k - 1] + iep * 6 - 7];
		    v11 = bdmsh5_1.cr[(j << 1) - 2] - bdmsh5_1.cr[(i << 1) - 
			    2];
		    v21 = bdmsh5_1.cr[(j << 1) - 1] - bdmsh5_1.cr[(i << 1) - 
			    1];
		    v12 = *xx - bdmsh5_1.cr[(i << 1) - 2];
		    v22 = *yy - bdmsh5_1.cr[(i << 1) - 1];
		    cdsmsh_1.aireta[k - 1] = v11 * v22 - v12 * v21;
		    if (cdsmsh_1.aireta[k - 1] < 0.f) {
			goto L10;
		    }
/* L20: */
		}
		cdsmsh_1.adrssd = isd;
		ret_val = iep;
		return ret_val;
	    }
	}
L30:
	;
    }
    s_wsle(&io___3189);
    do_lio(&c__9, &c__1, " on n'a pas  designe de triangle", 32L);
    e_wsle();
    cdsmsh_1.adrssd = 0;
    ret_val = 0;
    return ret_val;
} /* tproch_ */




logical traspl_(real *x, real *y, integer *n, real *eps, real *densit, real *
	tg1, real *tg2)
{
    /* Initialized data */

    /*static*/ real m[16]	/* was [4][4] */ = { 2.f,-2.f,1.f,1.f,-3.f,3.f,-2.f,
	    -1.f,0.f,0.f,1.f,0.f,1.f,0.f,0.f,0.f };

    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3, r__4, r__5;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real scal, step, a, c[2], d;
    integer i, k, l;
    real *p  /*[1002]*/	/* was [501][2] */, t, w[8]	/* was [4][2] */;
    extern /* Subroutine */ int lin2to_(real *, real *);
    real dd;
    integer nd;
    extern /* Subroutine */ int mov2to_(real *, real *);
    real tg[4]	/* was [2][2] */, depart[2], normal[2], ddd, old[2];
    assert(p = (real *) malloc(sizeof(real)*1002));

/* =======================================================================
 */

/* but : approche les points ( x(i),y(i) ) de r2 par une courbe */
/* ----  et la tracer */

/* parametres d'entree : x      : tableau des abcisses */
/* --------------------- y      : tableau des ordonnees */
/*                       n      : nombre de points a tracer */
/*                       eps    : les reels egaux a eps pres sont pris eg 
*/
/*                       densit : densite lineique de points de tracer */

/* parametres de sortie : densit : si densit est < 0 densit est rendu pos 
*/
/*                      : tg1,tg2: tangentes aux 2 extremitees */

/* auteur :     saltel eric modulef 29/9/86 */
/* -------- */



    /* Parameter adjustments */
    --tg2;
    --tg1;

    /* Function Body */
    ret_val = FALSE_;
    if (*n <= 1) { free(p);
	return ret_val;
    }
    depart[0] = x[1];
    depart[1] = y[1];
    old[0] = x[1];
    old[1] = y[1];
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	p[i] = x[i];
	p[i + 501] = y[i];
/* L87655: */
    }
    step = .1f;
/*     teste si courbe fermee */
/* Computing 2nd power */
    r__1 = p[1] - p[*n];
/* Computing 2nd power */
    r__2 = p[502] - p[*n + 501];
    if (sqrt(r__1 * r__1 + r__2 * r__2) <= *eps) {
/*       courbe fermee, on rajoute en 0 le point n-1 */
/*       courbe fermee, on rajoute en n+1 le point 2 */
	for (i = 1; i <= 2; ++i) {
	    p[i * 501 - 501] = p[*n - 1 + i * 501 - 501];
	    p[*n + 1 + i * 501 - 501] = p[i * 501 - 499];
/* L87656: */
	}
    } else {
	if (*n == 2) {
	    for (i = 1; i <= 2; ++i) {
/*           on rajoute un point p(0) virtuel symetrique de p(
2) */
/*                           / point p(1) */
		p[i * 501 - 501] = p[i * 501 - 500] * 2.f - p[i * 501 - 499];
/*           on rajoute un point  p(n+1) virtuel symetrique de
 p(n-1) */
/*                           / point p(n) */
		p[*n + 1 + i * 501 - 501] = p[*n + i * 501 - 501] * 2.f - p[*
			n - 1 + i * 501 - 501];
/* L87657: */
	    }
	} else {
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(1),p(2) */
/* Computing 2nd power */
		r__1 = p[i * 501 - 499] - p[i * 501 - 500];
		dd += r__1 * r__1;
/* L87658: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(1),p(2) */
		normal[i - 1] = (p[i * 501 - 499] - p[i * 501 - 500]) / dd;
/* L87659: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[i * 501 - 500] + p[i * 501 - 499]) * 
			.5f;
/*           produit scalaire   normal.p(3) */
		scal += normal[i - 1] * p[i * 501 - 498];
/* L87660: */
	    }
/*         on rajoute un point p(0) virtuel symetrique de p(3) */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[i * 501 - 501] = p[i * 501 - 498] - (d + scal) * 2.f * 
			normal[i - 1];
/* L87661: */
	    }
/*          call mov2to((p(1,1)+p(2,1))/2.,(p(1,2)+p(2,2))/2.) */
/*          call lin2of(normal(2),-normal(1)) */
/*          call txt2d('0',1,p(0,1),p(0,2)) */
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(n-1),p(n) */
/* Computing 2nd power */
		r__1 = p[*n - 1 + i * 501 - 501] - p[*n + i * 501 - 501];
		dd += r__1 * r__1;
/* L87662: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(n-1),p(n) */
		normal[i - 1] = (p[*n + i * 501 - 501] - p[*n - 1 + i * 501 - 
			501]) / dd;
/* L87663: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[*n - 1 + i * 501 - 501] + p[*n + i * 
			501 - 501]) * .5f;
/*           produit scalaire normal.p(n-2) */
		scal += normal[i - 1] * p[*n - 2 + i * 501 - 501];
/* L87664: */
	    }
/*         on rajoute un point p(n+1) virtuel symetrique de p(n-2)
 */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[*n + 1 + i * 501 - 501] = p[*n - 2 + i * 501 - 501] - (d + 
			scal) * 2.f * normal[i - 1];
/* L87665: */
	    }
/*          call mov2to((p(n-1,1)+p(n,1))/2.,(p(n-1,2)+p(n,2))/2.)
 */
/*          call lin2of(normal(2),-normal(1)) */
/*          call txt2d('n+1',3,p(n+1,1),p(n+1,2)) */
	}
    }
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
/*       longueur de p(i),p(i+1) */
	d = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 1 + nd * 501 - 501];
	    d += r__1 * r__1;
/* L87667: */
	}
	d = sqrt(d);
/*       longueur de p(i+1),p(i-1) */
	dd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + 1 + nd * 501 - 501] - p[i - 1 + nd * 501 - 501];
	    dd += r__1 * r__1;
/* L87668: */
	}
	dd = sqrt(dd);
/*       longueur de p(i),p(i+2) */
	ddd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 2 + nd * 501 - 501];
	    ddd += r__1 * r__1;
/* L87669: */
	}
	ddd = sqrt(ddd);
	if (dd <= d * 1e-5f) {
	    dd = 1.f;
	}
	if (ddd <= d * 1e-5f) {
	    ddd = 1.f;
	}
/*       calcul des tangentes aux 2 points p(i) et p(i+1) */
/* Computing MIN */
	r__1 = d, r__2 = dd * .5f, r__1 = min(r__1,r__2), r__2 = ddd * .5f;
	a = dmin(r__1,r__2);
	for (nd = 1; nd <= 2; ++nd) {
	    tg[(nd << 1) - 2] = a * ((p[i + 1 + nd * 501 - 501] - p[i - 1 + 
		    nd * 501 - 501]) / dd);
	    tg[(nd << 1) - 1] = a * ((p[i + 2 + nd * 501 - 501] - p[i + nd * 
		    501 - 501]) / ddd);
/* L87670: */
	}
	for (nd = 1; nd <= 2; ++nd) {
	    for (k = 1; k <= 4; ++k) {
		w[k + (nd << 2) - 5] = 0.f;
		for (l = 1; l <= 2; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * p[i + l - 1 
			    + nd * 501 - 501];
/* L87673: */
		}
		for (l = 3; l <= 4; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * tg[l - 2 + (
			    nd << 1) - 3];
/* L87674: */
		}
/* L87672: */
	    }
/* L87671: */
	}
	r__1 = step * .51f + 1.f;
	r__2 = step;
	for (t = 0.f; r__2 < 0 ? t >= r__1 : t <= r__1; t += r__2) {
	    for (nd = 1; nd <= 2; ++nd) {
/* Computing 3rd power */
		r__3 = t, r__4 = r__3;
/* Computing 2nd power */
		r__5 = t;
		c[nd - 1] = r__4 * (r__3 * r__3) * w[(nd << 2) - 4] + r__5 * 
			r__5 * w[(nd << 2) - 3] + t * w[(nd << 2) - 2] + w[(
			nd << 2) - 1];
		tg2[nd] = c[nd - 1] - old[nd - 1];
		old[nd - 1] = c[nd - 1];
		if (i == 1 && t == step) {
		    tg1[nd] = c[nd - 1] - depart[nd - 1];
		}
/* L87676: */
	    }
	    if (t == 0.f) {
		mov2to_(c, &c[1]);
	    } else {
		lin2to_(c, &c[1]);
	    }
/* L87675: */
	}
/* L87666: */
    }
    dd = 0.f;
    ddd = 0.f;
    for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	r__2 = tg1[nd];
	dd += r__2 * r__2;
/* Computing 2nd power */
	r__2 = tg2[nd];
	ddd += r__2 * r__2;
/* L87677: */
    }
    dd = sqrt(dd);
    ddd = sqrt(ddd);
    for (nd = 1; nd <= 2; ++nd) {
	tg1[nd] /= dd;
	tg2[nd] /= ddd;
/* L87678: */
    }
    ret_val = TRUE_;
    free(p);return ret_val;
} /* traspl_ */

/* Subroutine */ int trl2d_(doublereal *trf, real *x, real *y)
{
    extern /* Subroutine */ int cmp2d_(doublereal *, doublereal *);
    doublereal trf0[9]	/* was [3][3] */;

    /* Parameter adjustments */
    trf -= 4;

    /* Function Body */
    trf0[0] = 1.f;
    trf0[1] = 0.f;
    trf0[2] = 0.f;
    trf0[3] = 0.f;
    trf0[4] = 1.f;
    trf0[5] = 0.f;
    trf0[6] = *x;
    trf0[7] = *y;
    trf0[8] = 1.f;
    cmp2d_(&trf[4], trf0);
    return 0;
} /* trl2d_ */

/* Subroutine */ int unfiss_(integer *j)
{
    /* Local variables */

    integer i;
    extern /* Subroutine */ int drawad_(integer *, integer *), coherx_(
	    integer *, integer *);

/*     de_fissure l'element j */

    i = abs(*j);
    drawad_(&i, &c_n1);
    bdpec5_1.nuref[(i << 1) + 129] = bdpec5_1.nuref[(i << 1) + 128];
    bdpec6_1.nuref1[(i << 1) + 129] = bdpec6_1.nuref1[(i << 1) + 128];
    bdpec7_1.nuref2[(i << 1) + 129] = bdpec7_1.nuref2[(i << 1) + 128];
    bdpecd_1.fissur[i + 64] = FALSE_;
/*     coherence aux 2 extremites */
    coherx_(&i, &c__1);
    coherx_(&i, &c__2);
    drawad_(&i, &c__0);
    return 0;
} /* unfiss_ */




/* Subroutine */ int vbdmsh_(void)
{
    /* Initialized data */

    /*static*/ integer mod3[7] = { 2,3,1,2,3,1,2 };

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i, j, k;

    integer a8, k8;

    /* Fortran I/O blocks */
    /*static*/ cilist io___3219 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3225 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3226 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3227 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3228 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3229 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3230 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3231 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3232 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3233 = { 0, 6, 0, 0, 0 };


    s_wsle(&io___3219);
    do_lio(&c__9, &c__1, " verif bd mesh ", 15L);
    e_wsle();
/* w */
/* w      do 1 i=1,max(ptbd,finbd,finbd3) */
/* w        if(bd(0,i).eq.arc.or.bd(0,i).eq.segmen.or.bd(0,i).eq.spline) 
*/
/* w     +  then */
/* wc         suppression des points extremite */
/* w          if(nuref1(gauche,i).le.0.or.nuref1(gauche,i).gt.finbd3) then
 */
/* w            print *,'probleme dans la bd ext1 en:',i,nuref1(gauche,i) 
*/
/* w     +             ,finbd3 */
/* w            finbd3 = finbd3 + 1 */
/* w            nuref1(gauche,i)=finbd3 */
/* w            nuref1(droit,i)=finbd3 */
/* w            nuref(gauche,finbd3) = 0 */
/* w            nuref(droit,finbd3) = 0 */
/* w            bd(0,finbd3) = point */
/* w            bd(1,finbd3) = 0 */
/* w            bd(2,finbd3) = 0 */
/* w          endif */
/* w          if(nuref2(gauche,i).le.0.or.nuref2(gauche,i).gt.finbd3) then
 */
/* w            print *,'probleme dans la bd ext2 en:',i,nuref2(gauche,i) 
*/
/* w     +             ,finbd3 */
/* w            finbd3 = finbd3 + 1 */
/* w            nuref2(gauche,i)=finbd3 */
/* w            nuref2(droit,i)=finbd3 */
/* w            nuref(gauche,finbd3) = 0 */
/* w            nuref(droit,finbd3) = 0 */
/* w            bd(0,finbd3) = point */
/* w            bd(1,finbd3) = 0 */
/* w            bd(2,finbd3) = 0 */
/* w          endif */
/* w        endif */
/* w1     continue */
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	if (bdmsh9_1.nsea[i * 6 - 6] > 0) {
	    for (j = 4; j <= 6; ++j) {
		k = bdmsh9_1.nsea[j + i * 6 - 7];
		if (k > 0) {
		    k8 = k / 8;
		    a8 = k - (k8 << 3);
		    if (k8 <= 0 || k8 > bdmsh1_1.nbt) {
			s_wsle(&io___3225);
			do_lio(&c__9, &c__1, "ERREUR t a =", 12L);
			do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(
				integer));
			do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " TA AA =", 8L);
			do_lio(&c__3, &c__1, (char *)&k8, (ftnlen)sizeof(
				integer));
			do_lio(&c__3, &c__1, (char *)&a8, (ftnlen)sizeof(
				integer));
			e_wsle();
		    } else if (a8 < 4 || a8 > 6) {
			s_wsle(&io___3226);
			do_lio(&c__9, &c__1, "ERREUR t a =", 12L);
			do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(
				integer));
			do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " TA AA =", 8L);
			do_lio(&c__3, &c__1, (char *)&k8, (ftnlen)sizeof(
				integer));
			do_lio(&c__3, &c__1, (char *)&a8, (ftnlen)sizeof(
				integer));
			e_wsle();
		    } else if (bdmsh9_1.nsea[a8 + k8 * 6 - 7] != j + (i << 3))
			     {
			s_wsle(&io___3227);
			do_lio(&c__9, &c__1, " ERREUR adjtri t  ", 18L);
			do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " s=", 3L);
			for (k = 1; k <= 6; ++k) {
			    do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k + i 
				    * 6 - 7], (ftnlen)sizeof(integer));
			}
			e_wsle();
			s_wsle(&io___3228);
			do_lio(&c__9, &c__1, "               ta ", 18L);
			do_lio(&c__3, &c__1, (char *)&k8, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " s=", 3L);
			for (k = 1; k <= 6; ++k) {
			    do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k + 
				    k8 * 6 - 7], (ftnlen)sizeof(integer));
			}
			e_wsle();
		    } else {
			if (bdmsh9_1.nsea[a8 - 3 + k8 * 6 - 7] != 
				bdmsh9_1.nsea[mod3[j - 1] + i * 6 - 7]) {
			    s_wsle(&io___3229);
			    do_lio(&c__9, &c__1, " ERREUR somme1 t  ", 18L);
			    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " s=", 3L);
			    for (k = 1; k <= 6; ++k) {
				do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k 
					+ i * 6 - 7], (ftnlen)sizeof(integer))
					;
			    }
			    e_wsle();
			    s_wsle(&io___3230);
			    do_lio(&c__9, &c__1, "               ta ", 18L);
			    do_lio(&c__3, &c__1, (char *)&k8, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " s=", 3L);
			    for (k = 1; k <= 6; ++k) {
				do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k 
					+ k8 * 6 - 7], (ftnlen)sizeof(integer)
					);
			    }
			    e_wsle();
			} else if (bdmsh9_1.nsea[mod3[a8 - 1] + k8 * 6 - 7] !=
				 bdmsh9_1.nsea[j - 3 + i * 6 - 7]) {
			    s_wsle(&io___3231);
			    do_lio(&c__9, &c__1, " ERREUR somme2 t  ", 18L);
			    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " s=", 3L);
			    for (k = 1; k <= 6; ++k) {
				do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k 
					+ i * 6 - 7], (ftnlen)sizeof(integer))
					;
			    }
			    e_wsle();
			    s_wsle(&io___3232);
			    do_lio(&c__9, &c__1, "               ta ", 18L);
			    do_lio(&c__3, &c__1, (char *)&k8, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " s=", 3L);
			    for (k = 1; k <= 6; ++k) {
				do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[k 
					+ k8 * 6 - 7], (ftnlen)sizeof(integer)
					);
			    }
			    e_wsle();
			}
		    }
		} else if (k < 0) {
		} else {
		    s_wsle(&io___3233);
		    do_lio(&c__9, &c__1, "BIZARRE il y a des triangles front"
			    "iere sans ref ", 48L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		}
/* L80: */
	    }
	}
/* L100: */
    }
    return 0;
} /* vbdmsh_ */




/* Subroutine */ int veribd_(void)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern logical eqbd_(real *, real *);
    extern integer cons_(integer *, integer *), last_(integer *);

    integer i, j, newbd;
    extern /* Subroutine */ int degen_(integer *), drp1p2_(real *, real *, 
	    real *);
    extern integer length_(integer *);
    integer pt, pt1;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), invers_(integer *), 
	    overdc_(integer *);

/*     verifie la bd (ellimination des elements en doubles) */
/*                   (extremitee en plein dans un element) */



/*     creation de touts les supports des elements */
/*       on les met apres ptbd (entre ptbd+1 et newbd)  inclus */
/*       le nuref du support sert de tete de liste des elements qui ont l 
*/
/*        support */
    newbd = bdpec1_1.ptbd;
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (newbd > bdpec1_1.mxbd - 3) {
	    scrtch_("ERREUR:VERIBD:PLUS DE PLACE EN BD POUR VERIFIER", 47L);
	    goto L999;
	}
/*       ellimination des degenerescences de bd(*,adr) */
	degen_(&i);
	if (bdpec2_1.bd[i * 6 + 384] == -2.f) {
	    if ((r__2 = (r__1 = bdpec2_1.bd[i * 6 + 389], dabs(r__1)) - 
		    6.283185306f, dabs(r__2)) <= 5e-6f) {
/*           arc ferme on force 4 noeuds */
/* Computing MAX */
		i__2 = bdpec3_1.nbnode[i + 64];
		bdpec3_1.nbnode[i + 64] = max(i__2,4);
	    } else if ((r__1 = bdpec2_1.bd[i * 6 + 389], dabs(r__1)) >= 
		    3.1415876530000002f) {
/*           arc d'angle > pi on force 3 noeuds */
/* Computing MAX */
		i__2 = bdpec3_1.nbnode[i + 64];
		bdpec3_1.nbnode[i + 64] = max(i__2,3);
	    }
/*         on force l'angle de l'arc a etre positif */
	    if (bdpec2_1.bd[i * 6 + 389] < 0.f) {
		invers_(&i);
	    }
	    ++newbd;
/* Computing 2nd power */
	    r__1 = bdpec2_1.bd[i * 6 + 387] - bdpec2_1.bd[i * 6 + 385];
/* Computing 2nd power */
	    r__2 = bdpec2_1.bd[i * 6 + 388] - bdpec2_1.bd[i * 6 + 386];
	    bdpec2_1.bd[newbd * 6 + 384] = sqrt(r__1 * r__1 + r__2 * r__2);
	    bdpec2_1.bd[newbd * 6 + 385] = bdpec2_1.bd[i * 6 + 385];
	    bdpec2_1.bd[newbd * 6 + 386] = bdpec2_1.bd[i * 6 + 386];
	    bdpec2_1.bd[newbd * 6 + 387] = 0.f;
	} else if (bdpec2_1.bd[i * 6 + 384] == -3.f) {
/* Computing MAX */
	    i__2 = bdpec3_1.nbnode[i + 64];
	    bdpec3_1.nbnode[i + 64] = max(i__2,2);
	    ++newbd;
	    bdpec2_1.bd[(newbd + 1) * 6 + 384] = 0.f;
	    bdpec2_1.bd[(newbd + 1) * 6 + 385] = bdpec2_1.bd[i * 6 + 385];
	    bdpec2_1.bd[(newbd + 1) * 6 + 386] = bdpec2_1.bd[i * 6 + 386];
	    bdpec2_1.bd[(newbd + 2) * 6 + 384] = 0.f;
	    bdpec2_1.bd[(newbd + 2) * 6 + 385] = bdpec2_1.bd[i * 6 + 387];
	    bdpec2_1.bd[(newbd + 2) * 6 + 386] = bdpec2_1.bd[i * 6 + 388];
	    drp1p2_(&bdpec2_1.bd[newbd * 6 + 384], &bdpec2_1.bd[(newbd + 1) * 
		    6 + 384], &bdpec2_1.bd[(newbd + 2) * 6 + 384]);
/*         normalisation de la droite */
	    if (bdpec2_1.bd[newbd * 6 + 385] < -5e-6f) {
		bdpec2_1.bd[newbd * 6 + 385] = -(doublereal)bdpec2_1.bd[newbd 
			* 6 + 385];
		bdpec2_1.bd[newbd * 6 + 386] = -(doublereal)bdpec2_1.bd[newbd 
			* 6 + 386];
		bdpec2_1.bd[newbd * 6 + 387] = -(doublereal)bdpec2_1.bd[newbd 
			* 6 + 387];
	    } else if ((r__1 = bdpec2_1.bd[newbd * 6 + 385], dabs(r__1)) <= 
		    5e-6f) {
		if (bdpec2_1.bd[newbd * 6 + 386] < -5e-6f) {
		    bdpec2_1.bd[newbd * 6 + 386] = -(doublereal)bdpec2_1.bd[
			    newbd * 6 + 386];
		    bdpec2_1.bd[newbd * 6 + 387] = -(doublereal)bdpec2_1.bd[
			    newbd * 6 + 387];
		}
	    }
	} else if (bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    pt = listea_1.car[(integer) bdpec2_1.bd[i * 6 + 386] - 1];
	    i__2 = (integer) bdpec2_1.bd[i * 6 + 386];
	    pt1 = listea_1.car[last_(&i__2) - 1];
	    if (pt == 0 || pt1 == 0) {
		bdpec2_1.bd[i * 6 + 384] = -1e3f;
		goto L1;
	    }
/* Computing 2nd power */
	    r__1 = bdpec2_1.bd[pt1 * 6 + 385] - bdpec2_1.bd[pt * 6 + 385];
/* Computing 2nd power */
	    r__2 = bdpec2_1.bd[pt1 * 6 + 386] - bdpec2_1.bd[pt * 6 + 386];
	    if (sqrt(r__1 * r__1 + r__2 * r__2) <= eps_1.eps) {
/*           spline fermee on lui force 4 noeuds */
/* Computing MAX */
		i__2 = bdpec3_1.nbnode[i + 64];
		bdpec3_1.nbnode[i + 64] = max(i__2,4);
	    }
	    goto L1;
	} else {
/*         autre type, on ne fait rien */
	    goto L1;
	}
/*       recherche si le support (newbd) cree n'existe pas deja  (j) 
*/
/*       on chaine l'element i dans la liste (nuref) du support (j ou 
new */
	i__2 = newbd - 1;
	for (j = bdpec1_1.ptbd + 1; j <= i__2; ++j) {
	    if (eqbd_(&bdpec2_1.bd[newbd * 6 + 384], &bdpec2_1.bd[j * 6 + 384]
		    )) {
/*           support identiques on chaine i sur j et on elimin
e newbd */
		bdpec5_1.nuref[(j << 1) + 128] = cons_(&i, &bdpec5_1.nuref[(j 
			<< 1) + 128]);
		--newbd;
		goto L1;
	    }
/* L2: */
	}
/*       ici on n'a pas trouve de support identique: on garde celui ci
 */
	bdpec5_1.nuref[(newbd << 1) + 128] = cons_(&i, &c__0);
L1:
	;
    }
L999:
/*     parcourt des supports, ceux qui ont plusieurs elements dessus sont 
*/
/*     interessant, car dans ce cas, il faut tester si les elements se */
/*     superposent */
    i__1 = newbd;
    for (i = bdpec1_1.ptbd + 1; i <= i__1; ++i) {
/*       teste si il a plusieurs elements sur ce support */
	if (length_(&bdpec5_1.nuref[(i << 1) + 128]) > 1) {
/*         plusieurs elements sur ce support on suprime ceux qui s
e super */
	    overdc_(&i);
	}
/* L3: */
    }
    i__1 = newbd;
    for (i = bdpec1_1.ptbd + 1; i <= i__1; ++i) {
	bdpec2_1.bd[i * 6 + 384] = -1e3f;
/* L4: */
    }
    return 0;
} /* veribd_ */




doublereal verifc_(integer *ptcomp)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *), cons_(integer *, 
	    integer *), last_(integer *);

    extern doublereal surfa_(real *, real *, real *, real *, real *, integer *
	    , real *), surfs_(real *, real *, real *, real *);
    integer i, adres2, pttbd;
    extern /* Subroutine */ int freel_(integer *);
    extern doublereal surfsp_(integer *);
    integer adress, pt, nuextr;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);


/*     verifie si la composante ptcomp est fermee et que */
/*     les numeros de ref des extremitees des lignes sont les memes) */
/*     elle retire les elements pendants de la composante (ptcomp) */

/*     elle link les elements de la bd dans le tableau link */
/*     de facon a ce que l'on parcourt les elements dans le sens defini */
/*     par celui d'adresse ptcomp jusqu'a ce que la composante soit ferme 
*/
/*       elle renvoie la valeur de la surface de la composante */


    ret_val = 0.f;
    if (*ptcomp == 0) {
	scrtch_("COMPOSANTE VIDE", 15L);
	return ret_val;
    }
    if (bdpec1_1.link != 0) {
	freel_(&bdpec1_1.link);
    }
    adress = caar_(ptcomp);
    adres2 = adress;
/*     chainage des arc et des segments et des splines dans la liste link 
*/
/*     on met en tete l'element adress */
    bdpec1_1.link = cons_(&adress, &c__0);
    nuextr = cdar_(ptcomp);
    pttbd = adress;
/*     on suit les chainages conx a partir de adress */
/*     jusqu"a ce que l'on retrouve adres2 */
L2:
/*       calcule de la surface */
    i = pttbd;
/*       si la composante est a meme a gauche et a droite alors on saute 
*/
/*       l'element de bd (interieur vide) */
    if (bdpecc_1.compos[(i << 1) + 128] != bdpecc_1.compos[(i << 1) + 129]) {
	if (nuextr == 2) {
/*            print*,'verifc:composante droite' */
	    if (bdpec2_1.bd[i * 6 + 384] == -3.f) {
		ret_val -= surfs_(&bdpec2_1.bd[i * 6 + 385], &bdpec2_1.bd[i * 
			6 + 386], &bdpec2_1.bd[i * 6 + 387], &bdpec2_1.bd[i * 
			6 + 388]);
	    } else if (bdpec2_1.bd[i * 6 + 384] == -2.f) {
		ret_val -= surfa_(&bdpec2_1.bd[i * 6 + 385], &bdpec2_1.bd[i * 
			6 + 386], &bdpec2_1.bd[i * 6 + 387], &bdpec2_1.bd[i * 
			6 + 388], &bdpec2_1.bd[i * 6 + 389], &bdpec3_1.nbnode[
			i + 64], &bdpec4_1.raison[i + 64]);
	    } else {
/*             spline */
		ret_val -= surfsp_(&i);
	    }
	} else {
/*            print*,'verifc:composante gauche' */
	    if (bdpec2_1.bd[i * 6 + 384] == -3.f) {
		ret_val += surfs_(&bdpec2_1.bd[i * 6 + 385], &bdpec2_1.bd[i * 
			6 + 386], &bdpec2_1.bd[i * 6 + 387], &bdpec2_1.bd[i * 
			6 + 388]);
	    } else if (bdpec2_1.bd[i * 6 + 384] == -2.f) {
		ret_val += surfa_(&bdpec2_1.bd[i * 6 + 385], &bdpec2_1.bd[i * 
			6 + 386], &bdpec2_1.bd[i * 6 + 387], &bdpec2_1.bd[i * 
			6 + 388], &bdpec2_1.bd[i * 6 + 389], &bdpec3_1.nbnode[
			i + 64], &bdpec4_1.raison[i + 64]);
	    } else {
/*             spline */
		ret_val += surfsp_(&i);
	    }
	}
    }
    pt = bdpeca_1.conx[nuextr + (pttbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (pttbd << 1) + 127];
    pttbd = pt;
/*     dans le cas ou adress=adres2 on ne veut pas mettre adress 2 fois */
    if (pttbd != adress) {
/*       on rajoute l"element en queue de la liste */
	listed_1.cdr[last_(&bdpec1_1.link) - 1] = cons_(&pttbd, &c__0);
    }
    if (pttbd != adres2 || nuextr != cdar_(ptcomp)) {
	goto L2;
    }
/*      print*,'verifc: surface=',verifc */
    return ret_val;
} /* verifc_ */




logical verifd_(integer *ptdomn)
{
    /* Format strings */
    static char fmt_3009[] = "(1x,\002Sous domaine=\002,i4,\002 sera TRIANGU"
	    "LE car il a\002,\002 une mauvaise definition du 1er cote du quad"
	    "rilatere\002)";
    static char fmt_3800[] = "(1x,\002ATTENTION: LE NOMBRE DE POINTS DU SOUS"
	    " DOMAINE\002,i4,\002 EST IMPAIRE \002)";
    static char fmt_3000[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en T"
	    "RIANGLES\002)";
    static char fmt_3001[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en Q"
	    "UADRANGLES\002)";
    static char fmt_3101[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en B"
	    "ANDE(triangle)\002)";
    static char fmt_3002[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en Q"
	    "UADRANGLES\002,\002 eux memes decoupes en triangles reguliers"
	    "\002,\002, coins traites\002)";
    static char fmt_3003[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en Q"
	    "UADRANGLES\002,\002 eux memes decoupes non regulierement en tria"
	    "ngles\002,\002, coins traites\002)";
    static char fmt_3004[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en Q"
	    "UADRANGLES\002,\002 eux memes decoupes  en triangles regulier"
	    "s\002,\002, coins non traites\002)";
    static char fmt_3005[] = "(1x,\002Sous domaine=\002,i4,\002 decoupe en Q"
	    "UADRANGLES\002,\002 eux memes decoupes non regulierement en tria"
	    "ngles\002,\002, coins non traites\002)";

    /* System generated locals */
    integer i__1, i__2, i__3;
    logical ret_val;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfi(icilist *), do_fio(integer *, char *, ftnlen)
	    , e_wsfi(void);

    /* Local variables */
    extern integer cadr_(integer *), cadar_(integer *), caddr_(integer *);

    integer count;
    extern integer ligne_(integer *, integer *, integer *);
    integer compt;
    extern /* Subroutine */ int freel_(integer *);
    extern integer ligne1_(integer *, integer *, integer *);
    extern /* Subroutine */ int freed_(integer *);
    integer compt1, compt2;
    extern integer caaaar_(integer *), cadddr_(integer *), cdaaar_(integer *);
    extern integer cddddr_(integer *), removx_(integer *, integer *);
    char buf[132];
    integer pt1, pt2;
    real surfac;
    extern doublereal verifc_(integer *);
    integer numesd, ptt, ptcomp, comptc;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    extern integer nbintlk_(integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3254 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3261 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3262 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3263 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3266 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3270 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3271 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3272 = { 0, 6, 0, 0, 0 };




    s_wsle(&io___3254);
    do_lio(&c__9, &c__1, "verification domaine pour appli2", 32L);
    e_wsle();
    ret_val = TRUE_;
    if (*ptdomn == 0) {
	scrtch_("DOMAINE VIDE", 12L);
	return ret_val;
    }
/*     numero de sous domaine */
    numesd = caaaar_(ptdomn);
    ptt = cdaaar_(ptdomn);
/* L999: */
/*     triangles ou quadrangles? */
    if (listea_1.car[ptt - 1] != 309) {
/*       liberation des composantes interieures et des elements interi
eur */
	freel_(&listed_1.cdr[listed_1.cdr[listea_1.car[*ptdomn - 1] - 1] - 1])
		;
	freel_(&listed_1.cdr[listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1])
		;
/*       les 2  pointeurs sur la bd sont'ils bons */
	if (cadr_(&ptt) == 0 || caddr_(&ptt) == 0) {
	    ici__1.icierr = 0;
	    ici__1.icirnum = 1;
	    ici__1.icirlen = 132;
	    ici__1.iciunit = buf;
	    ici__1.icifmt = fmt_3009;
	    s_wsfi(&ici__1);
	    do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
	    e_wsfi();
	    listea_1.car[ptt - 1] = 309;
	} else {
	    ptcomp = cadar_(ptdomn);
/*         nombre de points sur la premiere ligne */
/*         verification du nombre de points sur la composante */
	    i__1 = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
		    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
	    comptc = nbintlk_(&i__1);
	    if (listea_1.car[ptt - 1] == 310) {
/*          nombre de points sur le premier cote */
		i__2 = cadr_(&ptt);
		i__3 = caddr_(&ptt);
		i__1 = ligne1_(&i__2, &ptcomp, &i__3);
		compt = nbintlk_(&i__1);
		if ((comptc - (compt << 1)) % 2 != 0) {
/*           le nombre de points sur la composante est imp
aire */
		    ici__1.icierr = 0;
		    ici__1.icirnum = 1;
		    ici__1.icirlen = 132;
		    ici__1.iciunit = buf;
		    ici__1.icifmt = fmt_3800;
		    s_wsfi(&ici__1);
		    do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
		    e_wsfi();
		    scrtch_(buf, 132L);
		    s_wsle(&io___3261);
		    do_lio(&c__9, &c__1, "VERIFD:NOMBRE DE POINT SUR COMPOSA"
			    "NTE=", 38L);
		    do_lio(&c__3, &c__1, (char *)&comptc, (ftnlen)sizeof(
			    integer));
		    do_lio(&c__9, &c__1, " NOMBRE DE POINTS SUR 1ER COTE=", 
			    31L);
		    do_lio(&c__3, &c__1, (char *)&compt, (ftnlen)sizeof(
			    integer));
		    e_wsle();
		    ret_val = FALSE_;
		    return ret_val;
		}
	    } else if (listea_1.car[ptt - 1] == 312) {
		s_wsle(&io___3262);
		i__1 = cadr_(&ptt);
		do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&ptcomp, (ftnlen)sizeof(integer))
			;
		i__2 = caddr_(&ptt);
		do_lio(&c__3, &c__1, (char *)&i__2, (ftnlen)sizeof(integer));
		e_wsle();
		s_wsle(&io___3263);
		i__1 = cadddr_(&ptt);
		do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&ptcomp, (ftnlen)sizeof(integer))
			;
		i__2 = cadddr_(&listed_1.cdr[ptt - 1]);
		do_lio(&c__3, &c__1, (char *)&i__2, (ftnlen)sizeof(integer));
		e_wsle();
		i__2 = cadr_(&ptt);
		i__3 = caddr_(&ptt);
		i__1 = ligne1_(&i__2, &ptcomp, &i__3);
		compt1 = nbintlk_(&i__1);
		i__2 = cadddr_(&ptt);
		i__3 = cadddr_(&listed_1.cdr[ptt - 1]);
		i__1 = ligne1_(&i__2, &ptcomp, &i__3);
		compt2 = nbintlk_(&i__1);
		s_wsle(&io___3266);
		do_lio(&c__9, &c__1, " comptc =", 9L);
		do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer))
			;
		do_lio(&c__3, &c__1, (char *)&compt2, (ftnlen)sizeof(integer))
			;
		do_lio(&c__3, &c__1, (char *)&comptc, (ftnlen)sizeof(integer))
			;
		e_wsle();
	    } else {
		ici__1.icierr = 0;
		ici__1.icirnum = 1;
		ici__1.icirlen = 132;
		ici__1.iciunit = buf;
		ici__1.icifmt = "(a,i9,a)";
		s_wsfi(&ici__1);
		do_fio(&c__1, " type de domaine inconnue ", 26L);
		do_fio(&c__1, (char *)&listea_1.car[ptt - 1], (ftnlen)sizeof(
			integer));
		do_fio(&c__1, " on met des traingles ", 22L);
		e_wsfi();
		listea_1.car[ptt - 1] = 309;
		scrtch_(buf, 132L);
	    }
	}
    }
    if (listea_1.car[ptt - 1] == 309) {
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 132;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_3000;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
	e_wsfi();
    } else if (listea_1.car[ptt - 1] == 310) {
/*       quadrangles */
	if (cadr_(&ptt) == 0 || caddr_(&ptt) == 0) {
	    scrtch_("ERREUR VOUS N'AVEZ PAS DEFINI LE 1ER COTE!", 42L);
	    return ret_val;
	}
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 132;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_3001;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
	e_wsfi();
    } else if (listea_1.car[ptt - 1] == 312) {
	if (cadr_(&ptt) == 0 || caddr_(&ptt) == 0) {
	    scrtch_("ERREUR VOUS N'AVEZ PAS DEFINI LE 1ER COTE!", 42L);
	    return ret_val;
	}
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 132;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_3101;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
	e_wsfi();
    } else {
/*       quadrangles decoupes en triangles */
/*       coins traites ou pas */
	if (cadddr_(&ptt) == 0) {
/*         triangles reguliers ou pas? */
	    if (listea_1.car[cddddr_(&ptt) - 1] == 0) {
		ici__1.icierr = 0;
		ici__1.icirnum = 1;
		ici__1.icirlen = 132;
		ici__1.iciunit = buf;
		ici__1.icifmt = fmt_3002;
		s_wsfi(&ici__1);
		do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
		e_wsfi();
	    } else {
		ici__1.icierr = 0;
		ici__1.icirnum = 1;
		ici__1.icirlen = 132;
		ici__1.iciunit = buf;
		ici__1.icifmt = fmt_3003;
		s_wsfi(&ici__1);
		do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
		e_wsfi();
	    }
	} else {
/*         triangles reguliers ou pas? */
	    if (listea_1.car[cddddr_(&ptt) - 1] == 0) {
		ici__1.icierr = 0;
		ici__1.icirnum = 1;
		ici__1.icirlen = 132;
		ici__1.iciunit = buf;
		ici__1.icifmt = fmt_3004;
		s_wsfi(&ici__1);
		do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
		e_wsfi();
	    } else {
		ici__1.icierr = 0;
		ici__1.icirnum = 1;
		ici__1.icirlen = 132;
		ici__1.iciunit = buf;
		ici__1.icifmt = fmt_3005;
		s_wsfi(&ici__1);
		do_fio(&c__1, (char *)&numesd, (ftnlen)sizeof(integer));
		e_wsfi();
	    }
	}
    }
    scrtch_(buf, 132L);
    pt1 = listed_1.cdr[listea_1.car[*ptdomn - 1] - 1];
/*     parcourt des composantes */
    count = 0;
L1:
    if (pt1 != 0) {
	++count;
	if (listea_1.car[pt1 - 1] == 0) {
	    scrtch_("VERIFD:On detruit ce domaine ,il est verole", 43L);
	    freed_(ptdomn);
	    *ptdomn = 0;
	    ret_val = FALSE_;
	    return ret_val;
	} else {
	    surfac = verifc_(&listea_1.car[pt1 - 1]);
	    if (count == 1) {
/*           composante exterieure */
		if (surfac < 0.f) {
		    scrtch_("VERIFD:COMPOSANTE EXTERIEURE DE SURFACE NEGATIVE"
			    , 48L);
		    s_wsle(&io___3270);
		    do_lio(&c__9, &c__1, "VERIFD: COMPOSANTE EXTERIEURE NEGA"
			    "TIVE", 38L);
		    do_lio(&c__4, &c__1, (char *)&surfac, (ftnlen)sizeof(real)
			    );
		    e_wsle();
		    ret_val = FALSE_;
		}
	    } else {
/*           composante interieure */
		if (surfac > 0.f) {
		    scrtch_("VERIFD:COMPOSANTE INTERIEURE DE SURFACE POSITIVE"
			    , 48L);
		    s_wsle(&io___3271);
		    do_lio(&c__9, &c__1, "VERIFD: COMPOSANTE INTERIEURE POSI"
			    "TIVE", 38L);
		    do_lio(&c__4, &c__1, (char *)&surfac, (ftnlen)sizeof(real)
			    );
		    e_wsle();
		    ret_val = FALSE_;
		}
	    }
	}
	pt1 = listed_1.cdr[pt1 - 1];
	goto L1;
    }
    pt1 = listed_1.cdr[listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1];
/*     parcourt des elements interieurs */
L2:
    if (pt1 != 0) {
	if (bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384] != 0.f && 
		bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384] != -3.f && 
		bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384] != -2.f && 
		bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384] != -4.f) {
	    scrtch_("ON RETIRE UNE REF VEROLEE A UN ELEMENT INTERIEUR", 48L);
	    s_wsle(&io___3272);
	    do_lio(&c__9, &c__1, " DE TYPE:", 9L);
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[listea_1.car[pt1 - 1] * 
		    6 + 384], (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&pt1, (ftnlen)sizeof(integer));
	    e_wsle();
	    pt2 = pt1;
	    pt1 = listed_1.cdr[pt1 - 1];
	    if (*ptdomn != 0) {
		listed_1.cdr[listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1] 
			= removx_(&listea_1.car[pt2 - 1], &listed_1.cdr[
			listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1]);
	    }
	    ret_val = FALSE_;
	} else {
	    pt1 = listed_1.cdr[pt1 - 1];
	}
	goto L2;
    }
    return ret_val;
} /* verifd_ */




logical verift_(void)
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    extern /* Subroutine */ int back_(integer *);

    extern integer ligne_(integer *, integer *, integer *);
    extern /* Subroutine */ int freel_(integer *);
    extern integer removx_(integer *, integer *);
    extern logical verifd_(integer *);
    integer ptdomn, ptcomp;
    extern /* Subroutine */ int aligne_(integer *);

/*     elle verifie touts les domaines et les composantes */


/*      print*,'verift:verification de toute la bd' */
L999:
    ret_val = TRUE_;
/*      print*,'verift:verification des composantes' */
    ptcomp = bdpec1_1.comp;
    freel_(&bdpec1_1.link);
L1:
    if (ptcomp != 0) {
	if (listea_1.car[listea_1.car[ptcomp - 1] - 1] == 0) {
/*          print*,'verift:suprime cellule vide de composante' */
	    bdpec1_1.comp = removx_(&listea_1.car[ptcomp - 1], &bdpec1_1.comp)
		    ;
	    back_(&listea_1.car[ptcomp - 1]);
	    ptcomp = bdpec1_1.comp;
	    goto L1;
	}
	bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
		ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
	aligne_(&bdpec1_1.link);
	if (bdpec1_1.link == 0) {
/*          print*,'verift:apres ligne, link=nil, on recommence to
ut' */
	    goto L999;
	}
	freel_(&bdpec1_1.link);
	ptcomp = listed_1.cdr[ptcomp - 1];
	goto L1;
    }
/*      print*,'verift:verification des domaines' */
/*      print*,'verift:suprime  cellule vide de domaine' */
    bdpec1_1.sdomn = removx_(&c__0, &bdpec1_1.sdomn);
    ptdomn = bdpec1_1.sdomn;
L2:
    if (ptdomn != 0) {
	ret_val = ret_val && verifd_(&ptdomn);
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L2;
    }
    return ret_val;
} /* verift_ */




/* Subroutine */ int voirco_(integer *ptcomp)
{
    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *);
    extern /* Subroutine */ int draw_(real *), draw3_(integer *);

    integer refbd;
    extern /* Subroutine */ int thick_(real *);
    integer pt, nuextr;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);



    if (*ptcomp == 0) {
	scrtch_("Voir composante vide?...", 24L);
	return 0;
    }
    refbd = caar_(ptcomp);
    nuextr = cdar_(ptcomp);
L1:
    draw3_(&c__0);
    thick_(&c_b619);
    draw_(&bdpec2_1.bd[refbd * 6 + 384]);
    pt = bdpeca_1.conx[nuextr + (refbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (refbd << 1) + 127];
    refbd = pt;
    if (refbd != caar_(ptcomp) || nuextr != cdar_(ptcomp)) {
	goto L1;
    }
    thick_(&c_b604);
    return 0;
} /* voirco_ */




/* Subroutine */ int voirdo_(integer *ptdomn)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    double sqrt(doublereal);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *), cadr_(integer *), 
	    mapc_(S_fp, integer *), cons_(integer *, integer *);
    integer mini, maxi, step;
    extern /* Subroutine */ int gnin_(real *, real *, real *, integer *, real 
	    *), ligh3_(integer *, integer *, integer *), draw3_(integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    extern integer cadar_(integer *), cdaar_(integer *), caddr_(integer *);

    extern integer ligne_(integer *, integer *, integer *);
    integer i, compt, n, n1;
    real *x1=0, *y1=0, *x2=0, *y2=0, *x3=0, *y3=0, *x4=0,
	     *y4=0;
    extern /* Subroutine */ int thick_(real *), freel_(integer *);
    extern integer cou1rf_(integer *);
    extern /* Subroutine */ int drawq_(integer *, integer *, integer *, 
	    integer *, real *, real *, real *, real *, real *, real *, real *,
	     real *);
    extern integer caaaar_(integer *);
    real dd;
    extern integer cdaaar_(integer *);
    extern /* Subroutine */ int voirco_(integer *);
    integer pt, is, comptc, comptx, ptt, pt1, ptcomp;
    real vx, vy, xx1, xx2, yy1, yy2, vvx, vvy, *xc=0, *yc=0;

    integer nb1, nb2, nb3, nb4;
    char buf[3];
    extern /* Subroutine */ int scrtch_(char *, ftnlen), extrm2_(integer *, 
	    real *, real *, real *, real *), drw3tx_(real *, real *, integer *
	    ), drawad_(integer *, integer *), aligne_(integer *);



/*     pour tracer des quadrangles par interpolation */
/*    real x1[1000], y1[1000], x2[1000], y2[1000], x3[1000], y3[1000], x4[1000],*/
/*	     y4[1000];xc[1000], yc[1000];*/
     assert(x1 = (real *) malloc(sizeof(real)*1000));
     assert(x2 = (real *) malloc(sizeof(real)*1000));
     assert(x3 = (real *) malloc(sizeof(real)*1000));
     assert(x4 = (real *) malloc(sizeof(real)*1000));
     assert(y1 = (real *) malloc(sizeof(real)*1000));
     assert(y2 = (real *) malloc(sizeof(real)*1000));
     assert(y3 = (real *) malloc(sizeof(real)*1000));
     assert(y4 = (real *) malloc(sizeof(real)*1000));
     assert(xc = (real *) malloc(sizeof(real)*1000));
     assert(yc = (real *) malloc(sizeof(real)*1000));

    if (*ptdomn == 0) {
	scrtch_("Cet element n'appartient a aucun domaine", 40L);
	return 0;
    }
/*     affichage du numero  de ref du sous domaine */
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 3;
    ici__1.iciunit = buf;
    ici__1.icifmt = "(I3)";
    s_wsfi(&ici__1);
    i__1 = caaaar_(ptdomn);
    do_fio(&c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    e_wsfi();
    i__1 = cadar_(ptdomn);
    i = caar_(&i__1);
    i__1 = cadar_(ptdomn);
    is = cdar_(&i__1);
/*      print*,'sens du premier element de la composante exterieur',is */
    extrm2_(&i, &xx1, &yy1, &xx2, &yy2);
    vx = (xx2 - xx1) * .5f;
    vy = (yy2 - yy1) * .5f;
    if (is == 1) {
	vvx = -(doublereal)vy;
	vvy = vx;
    } else {
	vvx = vy;
	vvy = -(doublereal)vx;
    }
/* Computing 2nd power */
    r__1 = vvx;
/* Computing 2nd power */
    r__2 = vvy;
    dd = sqrt(r__1 * r__1 + r__2 * r__2);
    if (dd == 0.f) {
	dd = 1.f;
    }
    vvx = (xx1 + xx2) * .5f + vvx / dd * 1.1f / etat_1.echel;
    vvy = (yy1 + yy2) * .5f + vvy / dd * 1.1f / etat_1.echel;
/*     la couleur est dependante du numero de sous domaine */
    i__2 = caaaar_(ptdomn);
    i__1 = cou1rf_(&i__2);
    ligh3_(&c_n1, &c_n1, &i__1);
    thick_(&c_b619);
    drw3tx_(&c_b3349, &c_b609, &c__0);
    txt2d_(buf, &c__3, &vvx, &vvy, 3L);
/*     affichage des composantes du sous domaine */
    i__1 = cdar_(ptdomn);
    i = mapc_((S_fp)voirco_, &i__1);
    draw3_(&c__0);
    thick_(&c_b619);
/*     elements interieurs */
    pt = cdaar_(ptdomn);
L1:
    if (pt != 0) {
	drawad_(&listea_1.car[pt - 1], &c__1);
	pt = listed_1.cdr[pt - 1];
	goto L1;
    }
    thick_(&c_b604);
/*     teste si decoupe en quadrangles */
    ptt = cdaaar_(ptdomn);
    if (listea_1.car[ptt - 1] == 309) {
	goto LA999;
    }
    if (listea_1.car[ptt - 1] == 312) {
	goto LA999;
    }
    freel_(&bdpec1_1.link);
    ptcomp = cadar_(ptdomn);
/*     nombre de points sur le premier cote */
    if (cadr_(&ptt) == 0 || caddr_(&ptt) == 0) {
	scrtch_("ERREUR VOUS N'AVEZ PAS DEFINI LE 1ER COTE!", 42L);
/*        print*,'voirdo:erreur vous n''avez pas defini le 1er cote!' 
*/
	goto LA999 ;
    } else if (cadr_(&ptt) == caddr_(&ptt)) {
/*       un seul element */
	i__1 = cadr_(&ptt);
	bdpec1_1.link = cons_(&i__1, &c__0);
    } else {
	i__1 = cadr_(&ptt);
	i__2 = caddr_(&ptt);
	bdpec1_1.link = ligne_(&i__1, &ptcomp, &i__2);
	aligne_(&bdpec1_1.link);
    }
    compt = 1;
    pt1 = bdpec1_1.link;
L10:
    if (pt1 != 0) {
	compt = compt + bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L10;
    }
/*      print*,'voirdo:nombre de points sur le 1er cote:',compt */
/*     nombre de points sur la composante */
    freel_(&bdpec1_1.link);
/*     astuce, on fait debuter la ligne sur le premier cote */
    i__1 = cadr_(&ptt);
    i__2 = cadr_(&ptt);
    bdpec1_1.link = ligne_(&i__1, &ptcomp, &i__2);
    aligne_(&bdpec1_1.link);
    comptc = 0;
    pt1 = bdpec1_1.link;
L11:
    if (pt1 != 0) {
	comptc = comptc + bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L11;
    }
/*      print*,'voirdo:nombre de points sur la composante:',comptc */
    comptx = (comptc - (compt - 1 << 1)) / 2 + 1;
/*      print*,'voirdo:nombre de points sur le 2ieme cote:',comptx */
    n = 0;
    pt1 = bdpec1_1.link;
    xx1 = 0.f;
    yy1 = 0.f;
    n1 = 0;
    x4[0] = 1e3f;
L12:
    if (pt1 != 0) {
	extrm2_(&listea_1.car[pt1 - 1], &vvx, &vvy, &xx2, &yy2);
	gnin_(&bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384], &xc[1], &yc[1], &
		bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64], &bdpec4_1.raison[
		listea_1.car[pt1 - 1] + 64]);
/*       doit on l'inverser? */
	if (bdpecc_1.compos[(listea_1.car[pt1 - 1] << 1) + 129] == cadar_(
		ptdomn)) {
	    xc[bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1] = xx2;
	    yc[bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1] = yy2;
	    maxi = 2;
	    mini = bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64];
	    step = -1;
	} else {
	    xc[0] = vvx;
	    yc[0] = vvy;
	    mini = 1;
	    maxi = bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	    step = 1;
	}
	i__1 = maxi;
	i__2 = step;
	for (i = mini; i__2 < 0 ? i >= i__1 : i <= i__1; i += i__2) {
	    ++n;
	    ++n1;
	    xx1 += xc[i - 1];
	    yy1 += yc[i - 1];
	    if (n == 1) {
		thick_(&c_b619);
		drw3tx_(&c_b3349, &c_b609, &c__46);
		txt2d_("X", &c__1, &xc[i - 1], &yc[i - 1], 1L);
		nb1 = 1;
		x1[nb1 - 1] = xc[i - 1];
		y1[nb1 - 1] = yc[i - 1];
	    } else if (n <= compt) {
/*           premier cote */
		s_copy(buf, "I  ", 3L, 3L);
		++nb1;
		x1[nb1 - 1] = xc[i - 1];
		y1[nb1 - 1] = yc[i - 1];
		if (n == compt) {
		    nb2 = 1;
		    x2[nb2 - 1] = xc[i - 1];
		    y2[nb2 - 1] = yc[i - 1];
		}
	    } else if (n <= compt + comptx - 1) {
/*           deuxieme cote */
		s_copy(buf, "II ", 3L, 3L);
		++nb2;
		x2[nb2 - 1] = xc[i - 1];
		y2[nb2 - 1] = yc[i - 1];
		if (n == compt + comptx - 1) {
		    nb3 = 1;
		    x3[nb1 - nb3] = xc[i - 1];
		    y3[nb1 - nb3] = yc[i - 1];
		}
	    } else if (n <= (compt << 1) + comptx - 2) {
/*           troisieme cote */
		s_copy(buf, "III", 3L, 3L);
		++nb3;
		x3[nb1 - nb3] = xc[i - 1];
		y3[nb1 - nb3] = yc[i - 1];
		nb4 = 1;
		if (n == (compt << 1) + comptx - 2) {
		    x4[0] = x1[0];
		    y4[0] = y1[0];
		}
	    } else {
/*           quatrieme cote */
		s_copy(buf, "IV ", 3L, 3L);
		if (nb4 != nb2) {
		    ++nb4;
		    x4[nb2 - nb4] = xc[i - 1];
		    y4[nb2 - nb4] = yc[i - 1];
		}
	    }
	    if (n == compt || n == compt + comptx - 1 || n == (compt << 1) + 
		    comptx - 2 || n == comptc) {
/*           on est sur une transition de cote */
		thick_(&c_b619);
		if (n != comptc) {
		    drw3tx_(&c_b3349, &c_b609, &c__46);
		    txt2d_("X", &c__1, &xc[i - 1], &yc[i - 1], 1L);
		}
		drw3tx_(&c_b3349, &c_b609, &c__0);
		r__1 = xx1 / (real) n1;
		r__2 = yy1 / (real) n1;
		txt2d_(buf, &c__3, &r__1, &r__2, 3L);
		xx1 = 0.f;
		yy1 = 0.f;
		n1 = 0;
	    }
/* L13: */
	}
	pt1 = listed_1.cdr[pt1 - 1];
	goto L12;
    }
/*      print*,'voirdo:nb1=',nb1,' nb2=',nb2,' nb3=',nb3,' nb4=',nb4 */
    ++nb4;
    x4[nb4 - 1] = x3[0];
    y4[nb4 - 1] = y3[0];
/*     trace des quadrangles methode modulef */
    drawq_(&nb1, &nb2, &nb3, &nb4, x1, y1, x2, y2, x3, y3, x4, y4);
/*     trace des quadrangles methode marrocco */
/*      call drawqq(nb1,nb2,nb3,nb4,x1,y1,x2,y2,x3,y3,x4,y4) */
  LA999:
   
   free (x1);free(x2);free(x3);free(x4);free(xc);
   free (y1);free(y2);free(y3);free(y4);free(yc);
   
    return 0;
} /* voirdo_ */




/* Subroutine */ int wtrace_(void)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), i_indx(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    integer i;


    /* Fortran I/O blocks */
    /*static*/ cilist io___3329 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___3331 = { 0, 0, 0, 0, 0 };



/*     ecrit la trace */


    if (cdesig_1.vlmenu == 300) {
	io___3329.ciunit = traint_1.trace;
	s_wsle(&io___3329);
	do_lio(&c__9, &c__1, "'ECRAN           '", 18L);
	do_lio(&c__9, &c__1, " 'XXXX__YYYY'", 13L);
	do_lio(&c__4, &c__1, (char *)&cdesig_1.x, (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&cdesig_1.y, (ftnlen)sizeof(real));
	e_wsle();
    } else {
	i = i_indx(pectxt_1.txcase + (cdesig_1.nucase + (cdesig_1.numenu << 5)
		 - 33 << 4), "FINIR", 16L, 5L);
	if (i == 0) {
	    io___3331.ciunit = traint_1.trace;
	    s_wsle(&io___3331);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4),
		     16L);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, " '", 2L);
	    do_lio(&c__9, &c__1, pectxt_1.txcase + (cdesig_1.nucase + (
		    cdesig_1.numenu << 5) - 33 << 4), 16L);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, " 0. 0.", 6L);
	    e_wsle();
	}
    }
    return 0;
} /* wtrace_ */




/* Subroutine */ int ygibbs_(void)
{
    /* System generated locals */
    integer i__1;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    , s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    integer prenu, pvois, lvois, pfold, pfnew;
    extern /* Subroutine */ int gibbsa_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    integer pptvoi, plibre, err;
    char buf[256];
    extern /* Subroutine */ int gibbsv_(integer *, integer *, integer *, 
	    integer *, integer *, integer *), scrtch_(char *, ftnlen), 
	    mshrnm_(integer *, integer *, real *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___3344 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3345 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___3346 = { 0, 6, 0, 0, 0 };


    if (bdmsh1_1.nbs <= 0 || bdmsh1_1.nbt <= 0) {
	return 0;
    }
    prenu = 1;
    pptvoi = prenu + bdmsh1_1.nbs + 1;
    pvois = pptvoi + bdmsh1_1.nbs + 1;
    lvois = bdmsh0_1.lwork - pvois + 1 - bdmsh1_1.nbt * 3;
    gibbsv_(&bdwrk1_1.work[pptvoi - 1], &bdwrk1_1.work[pvois - 1], &lvois, &
	    bdwrk1_1.work[prenu - 1], &bdwrk1_1.work[bdmsh0_1.lwork - 
	    bdmsh1_1.nbt * 3], &err);
    if (err != 0) {
	return 0;
    }
    plibre = pvois + lvois;
    if (bdmsh0_1.lwork - plibre + 1 >= bdmsh1_1.nbs * 11 + 1) {
	gibbsa_(&bdmsh1_1.nbs, &bdwrk1_1.work[pptvoi - 1], &bdwrk1_1.work[
		pvois - 1], &bdwrk1_1.work[prenu - 1], &bdwrk1_1.work[plibre 
		- 1], &bdwrk1_1.work[plibre + bdmsh1_1.nbs - 1], &
		bdwrk1_1.work[plibre + bdmsh1_1.nbs * 3], &bdwrk1_1.work[
		plibre + (bdmsh1_1.nbs << 2)], &bdwrk1_1.work[plibre + 
		bdmsh1_1.nbs * 5], &bdwrk1_1.work[plibre + bdmsh1_1.nbs * 6 + 
		1], &bdwrk1_1.work[plibre + bdmsh1_1.nbs * 7 + 1], &pfold, &
		pfnew, &c__0, &c__6);
	if (pfnew >= pfold) {
	    ici__1.icierr = 0;
	    ici__1.icirnum = 1;
	    ici__1.icirlen = 256;
	    ici__1.iciunit = buf;
	    ici__1.icifmt = "(a,2(a,i10))";
	    s_wsfi(&ici__1);
	    do_fio(&c__1, "on ne renumerote pas parce que :", 32L);
	    do_fio(&c__1, "profile avant =", 15L);
	    do_fio(&c__1, (char *)&pfold, (ftnlen)sizeof(integer));
	    do_fio(&c__1, " , profile apres =", 18L);
	    do_fio(&c__1, (char *)&pfnew, (ftnlen)sizeof(integer));
	    e_wsfi();
	    scrtch_(buf, 256L);
	} else {
	    ici__1.icierr = 0;
	    ici__1.icirnum = 1;
	    ici__1.icirlen = 256;
	    ici__1.iciunit = buf;
	    ici__1.icifmt = "(a,2(a,i10))";
	    s_wsfi(&ici__1);
	    do_fio(&c__1, "on renumerote :", 15L);
	    do_fio(&c__1, "profile avant =", 15L);
	    do_fio(&c__1, (char *)&pfold, (ftnlen)sizeof(integer));
	    do_fio(&c__1, " , profile apres =", 18L);
	    do_fio(&c__1, (char *)&pfnew, (ftnlen)sizeof(integer));
	    e_wsfi();
	    scrtch_(buf, 256L);
/*#define xwork ((real *) bdwrk1_1.work)*/
	    mshrnm_(&bdwrk1_1.work[prenu - 1], &bdwrk1_1.work[pptvoi - 1], &
		    bdwrk1_3.xwork[pptvoi - 1]);
/*#undef xwork*/
		    
	}
    } else {
	s_wsle(&io___3344);
	do_lio(&c__9, &c__1, " plibre =", 9L);
	do_lio(&c__3, &c__1, (char *)&plibre, (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___3345);
	do_lio(&c__9, &c__1, " long util =", 12L);
	i__1 = bdmsh0_1.lwork - plibre + 1;
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___3346);
	do_lio(&c__9, &c__1, " long demande =", 15L);
	i__1 = bdmsh1_1.nbs * 3 + 1;
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	e_wsle();
	scrtch_("PAS ASSEZ DE PLACE MEMORE POUR RENUMEROTER", 42L);
    }
    return 0;
} /* ygibbs_ */




