#include "emc2_h.h"
 
/* Subroutine */ int afetat_(void)
{
    /* Format strings */
    static char fmt_999[] = "(\002RADIUS=\002,g12.6,\002 ;ANGLE=\002,g12.6"
	    ",\002 ;DISTANCE=\002,g12.6,\002 ;RATIO=\002,g12.6,\002 ;NUMBER"
	    "=\002,i4,\002 ;SCALE=\002,g12.6)";
    static char fmt_997[] = "(\002NUREF=\002,i4,\002 ;Nb_INTERVALS=\002,i4"
	    ",\002 ;Lg_INTERVAL=\002,g12.6,\002 ;RATIO=\002,g12.6,\002 ;SCALE="
	    "\002,g12.6)";
    static char fmt_996[] = "(a,a,\002Scale=\002,g12.6,\002 ; MIN_ANGLE_T"
	    "=\002,f7.2,\002 ; MAX_ANGLE_T=\002,f7.2,\002 ; MIN_ANGLE_Q=\002,"
	    "f7.2,\002 ; MAX_ANGLE_Q=\002,f7.2)";

    /* System generated locals */
    address a__1[2];
    integer i__1, i__2[2];
    real r__1, r__2, r__3, r__4;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_indx(char *, char *, ftnlen, ftnlen);
    double acos(doublereal);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer i_len(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    real f[4];
    integer i, j;

    char kelem[30];
    extern /* Subroutine */ int thick_(real *), cprim_(char *, integer *, 
	    ftnlen), fentr2_(real *, real *, real *, real *), masqu2_(real *, 
	    real *, real *, real *), drw3tx_(real *, real *, integer *);
    real ym;
    char buf[256], kbgptf[30];
    extern /* Subroutine */ int noirci_(real *), limits_(integer *);


/*     affiche dans la fenetre reserv (en bas), l'etat du systeme */



    ym = (pec_1.reserv[2] + pec_1.reserv[3]) / 2.1f;
    f[0] = pec_1.reserv[0];
    f[1] = pec_1.reserv[1];
    f[2] = pec_1.reserv[2];
    f[3] = ym;
    noirci_(f);
    fentr2_(f, &f[1], &f[2], &f[3]);
/*      call masqu2(f(1),f(2),f(3),f(4)) */
    masqu2_(&c_b609, &c_b614, &c_b609, &c_b614);
    ligh3_(&c_n1, &c_n1, pec_1.colore);
    thick_(&c_b619);
    limits_(&c__0);
/*       affichage de l'etat selon l'application */
    if (pec_1.appli == 511) {
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 256;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_999;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&etat_1.rayon, (ftnlen)sizeof(real));
	r__1 = etat_1.angle * 180.f / 3.141592653f;
	do_fio(&c__1, (char *)&r__1, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&etat_1.distan, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&etat_1.raport, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&etat_1.nombre, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&etat_1.echel, (ftnlen)sizeof(real));
	e_wsfi();
/*999   format('RAYON=',g12.6                                         
  #FR*/
/*   +       ,' ;ANGLE=',g12.6                                        
  #FR*/
/*   +       ,' ;DISTANCE=',g12.6                                     
  #FR*/
/*   +       ,' ;RAPPORT=',g12.6                                      
  #FR*/
/*   +       ,' ;NOMBRE=',i4                                          
  #FR*/
/*   +       ,' ;ECHELLE=',g12.6                                      
  #FR*/
/*   +         )                                                      
  #FR*/
/*      elseif(appli.eq.apli1)then */
    } else if (pec_1.appli == 513) {
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 256;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_997;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&etat_1.nureff, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&etat_1.nbintr, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&etat_1.lgintr, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&etat_1.raisoo, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&etat_1.echel, (ftnlen)sizeof(real));
	e_wsfi();
/*997    format('NUREF=',i4                                           
  #FR*/
/*   +       ,' ;Nb_INTERVALS=',i4                                    
  #FR*/
/*   +       ,' ;Lg_INTERVAL=',g12.6                                  
  #FR*/
/*   +       ,' ;RAISON=',g12.6                                       
  #FR*/
/*   +       ,' ;ECHELLE=',g12.6                                      
  #FR*/
/*   +         )                                                      
  #FR*/
    } else if (pec_1.appli == 514) {
	if (etat_1.mkelem) {
	    s_copy(kelem, "Mark_bad_elem;", 30L, 14L);
	} else {
	    s_copy(kelem, "No_mark_bad_elem;", 30L, 17L);
	}
	if (etat_1.bgptf) {
	    s_copy(kbgptf, "Edit_bord;", 30L, 10L);
	} else {
	    s_copy(kbgptf, "No_edit_bord;", 30L, 13L);
	}
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 256;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_996;
	s_wsfi(&ici__1);
	do_fio(&c__1, kbgptf, i_indx(kbgptf, ";", 30L, 1L));
	do_fio(&c__1, kelem, i_indx(kelem, ";", 30L, 1L));
	do_fio(&c__1, (char *)&etat_1.echel, (ftnlen)sizeof(real));
	r__1 = acos(etat_1.cosmnt) * 180.f / 3.141592653f;
	do_fio(&c__1, (char *)&r__1, (ftnlen)sizeof(real));
	r__2 = acos(etat_1.cosmxt) * 180 / 3.141592653f;
	do_fio(&c__1, (char *)&r__2, (ftnlen)sizeof(real));
	r__3 = acos(etat_1.cosmnq) * 180.f / 3.141592653f;
	do_fio(&c__1, (char *)&r__3, (ftnlen)sizeof(real));
	r__4 = acos(etat_1.cosmxq) * 180 / 3.141592653f;
	do_fio(&c__1, (char *)&r__4, (ftnlen)sizeof(real));
	e_wsfi();
/*996    format(a,a,'Echelle=',g12.6,K                                
  #FR*/
/*   +        ' ; ANGLE_MIN_T=',f7.2,                                 
 #FR*/
/*   +        ' ; ANGLE_MAX_T=',f7.2,                                 
 #FR*/
/*   +        ' ; ANGLE_MIN_Q=',f7.2,                                 
 #FR*/
/*   +        ' ; ANGLE_MAX_Q=',f7.2)                                 
 #FR*/
    } else {
	s_copy(buf, "APPLICATION_INCONNUE_DANS_AFETAT", 256L, 32L);
	j = 50;
    }

    cprim_(buf, &j, 256L);
    if (traint_1.trace != 0) {
/*       buf(j+1:) = '; Trace sur:'//tracex(1:50)                     
  #FR*/
	i__1 = j;
/* Writing concatenation */
	i__2[0] = 11, a__1[0] = "; Log File:";
	i__2[1] = 50, a__1[1] = trainx_1.tracex;
	s_cat(buf + i__1, a__1, i__2, &c__2, 256 - i__1);
    } else {
/*       buf(j+1:) = '; Pas de Trace '                                
  #FR*/
	i__1 = j;
	s_copy(buf + i__1, "; No Log File ", 256 - i__1, 14L);
    }
    for (i = i_len(buf, 256L); i >= 1; --i) {
	if (buf[i - 1] != ' ') {
	    j = i;
	    goto L98;
	}
/* L99: */
    }
L98:
    thick_(&c_b604);
    r__1 = (pec_1.reserv[1] - pec_1.reserv[0]) / 132.f;
    drw3tx_(&r__1, &c_b609, &c__0);
    txt2d_(buf, &j, &c_b661, &c_b662, 256L);
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* afetat_ */




/* Subroutine */ int affich_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer indx;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);

    extern /* Subroutine */ int thick_(real *), fentr2_(real *, real *, real *
	    , real *);
    extern /* Subroutine */ int limits_(integer *), drwmsh_(integer *, 
	    integer *), drawad_(integer *, integer *);


/*     elle affiche toute la bd selon l'application */


/*     materialisation de la fenetre de travail */
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    thick_(&c_b619);
    ligh3_(&c_n1, &c_n1, &pec_1.colofe);
    limits_(&c__0);
/*     materialisation de l'ecran */
    fentr2_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]);
    thick_(&c_b604);
    ligh3_(&c_n1, &c_n1, &pec_1.coloec);
    limits_(&c__0);
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    if (pec_1.appli == 514) {
	drwmsh_(&c__0, &c__0);
	return 0;
    }
    i__1 = bdpec1_1.ptbd;
    for (indx = 1; indx <= i__1; ++indx) {
	drawad_(&indx, &c__0);
/* L2: */
    }
    return 0;
} /* affich_ */




/* Subroutine */ int afmenu_(integer *n)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer numn;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    draw3_(integer *);
    integer i;

    integer numin, numax;
    extern /* Subroutine */ int thick_(real *), fentr2_(real *, real *, real *
	    , real *), masqu2_(real *, real *, real *, real *);
    extern /* Subroutine */ int menumk_(integer *, integer *, integer *), 
	    limits_(integer *);


/*      save */
/*    si n >=0  affiche le n iem menu */
/*             n'affiche pas le marquage des cases */
/*    si n  =0  affiche touts les menus actifs et les differents cadres */
/*             n'affiche pas le marquage des cases */
/*    si n  <0  affiche touts les menus actifs et les differents cadres */
/*              affiche aussi le marquage des cases */



    if (*n == 0) {
	numin = 1;
	numax = 16;
    } else if (*n < 0) {
	numin = 1;
	numax = 16;
    } else {
	numin = *n;
	numax = *n;
    }
    draw3_(&c__0);
    i__1 = numax;
    for (numn = numin; numn <= i__1; ++numn) {
	for (i = 1; i <= 32; ++i) {
/*        on inverse le numn pour signifier que l'on veut tracer a
 tout */
/*           prix */
	    i__2 = -numn;
	    menumk_(&i__2, &i, &pec_1.mkcase[i + (numn << 5) - 33]);
/* L99: */
	}
    }
/*     materialisation de la fenetre de travail */
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    thick_(&c_b619);
    ligh3_(&c_n1, &c_n1, &pec_1.colofe);
    limits_(&c__0);
/*     materialisation de l'ecran */
    fentr2_(pec_1.ecran, &pec_1.ecran[1], &pec_1.ecran[2], &pec_1.ecran[3]);
    thick_(&c_b604);
    ligh3_(&c_n1, &c_n1, &pec_1.coloec);
    limits_(&c__0);
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* afmenu_ */




/* Subroutine */ int aligne_(integer *l)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */

    integer pt1;

/*     rend >0 le car de la liste l */


/*     on rend les adresses de l >0 */
    pt1 = *l;
L1:
    if (pt1 != 0) {
	listea_1.car[pt1 - 1] = (i__1 = listea_1.car[pt1 - 1], abs(i__1));
	pt1 = listed_1.cdr[pt1 - 1];
	goto L1;
    }
    return 0;
} /* aligne_ */




integer alloc_(void)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    extern /* Subroutine */ int scrtch_(char *, ftnlen);

    /* Fortran I/O blocks */
    /*static*/ cilist io___282 = { 0, 6, 0, 0, 0 };



/*      alloc  recherche une place de alloc dans bd on la retourne dans a 
*/

    i__1 = bdpec1_1.mxbd;
    for (ret_val = 1; ret_val <= i__1; ++ret_val) {
	if (bdpec2_1.bd[ret_val * 6 + 384] == -1e3f) {
	    bdpec1_1.ptbd = max(bdpec1_1.ptbd,ret_val);
	    bdpec3_1.nbnode[ret_val + 64] = 2;
	    bdpec4_1.raison[ret_val + 64] = 1.f;
	    bdpec5_1.nuref[(ret_val << 1) + 128] = 0;
	    bdpec5_1.nuref[(ret_val << 1) + 129] = 0;
	    bdpec6_1.nuref1[(ret_val << 1) + 128] = 0;
	    bdpec6_1.nuref1[(ret_val << 1) + 129] = 0;
	    bdpec7_1.nuref2[(ret_val << 1) + 128] = 0;
	    bdpec7_1.nuref2[(ret_val << 1) + 129] = 0;
	    bdpecd_1.fissur[ret_val + 64] = FALSE_;
	    bdpec8_1.adp1[ret_val + 64] = 0;
	    bdpec9_1.adp2[ret_val + 64] = 0;
	    bdpece_1.adjabd[ret_val + 64] = 0;
	    bdpec2_1.bd[ret_val * 6 + 384] = -99.f;
	    bdpec2_1.bd[ret_val * 6 + 385] = 0.f;
	    bdpec2_1.bd[ret_val * 6 + 386] = 0.f;
	    bdpec2_1.bd[ret_val * 6 + 387] = 0.f;
	    bdpec2_1.bd[ret_val * 6 + 388] = 0.f;
	    bdpec2_1.bd[ret_val * 6 + 389] = 0.f;
	    return ret_val;
	}
/* L9001: */
    }
    s_wsle(&io___282);
    do_lio(&c__9, &c__1, " mxbd =", 7L);
    do_lio(&c__3, &c__1, (char *)&bdpec1_1.mxbd, (ftnlen)sizeof(integer));
    e_wsle();
    scrtch_("ALLOC:ERREUR:PLUS DE PLACE LIBRE DANS BD", 40L);
    ret_val = 0;
    return ret_val;
} /* alloc_ */





/*     f_lisp */
integer appenx_(integer *s, integer *l)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern integer last_(integer *);


/*     renvoie: appenx = la liste s concatenee avec l */
/*                 si s = nil : appenx = l */
/*     elle ne modifie pas la liste l ni s */


    ret_val = *s;
    if (ret_val != 0) {
	listed_1.cdr[last_(&ret_val) - 1] = *l;
    } else {
	ret_val = *l;
    }
    return ret_val;
} /* appenx_ */

integer appli2_(integer *act)
{
    /* Format strings */
    static char fmt_4912[] = "(1x,\002ATTENTION: LE NOMBRE DE POINTS DU SOUS"
	    " DOMAINE\002,\002 EST BIZAREMENT REPARTI, ON INTERVERTI LES DESI"
	    "GNATIONS\002)";
    static char fmt_7312[] = "(1x,\002ATTENTION: LE NOMBRE DE POINTS DU SOUS"
	    " DOMAINE\002,\002 EST BIZAREMENT REPARTI, ON INTERVERTI LES DESI"
	    "GNATIONS\002)";

    /* System generated locals */
    integer ret_val, i__1, i__2, i__3;
    real r__1, r__2, r__3, r__4;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfi(icilist *), do_fio(integer *, char *, ftnlen)
	    , e_wsfi(void);
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int afmenu_(integer *), scrtch_(char *, ftnlen), 
	    menumk_(integer *, integer *, integer *), afetat_(void);
    extern integer caar_(integer *), cdar_(integer *), cadr_(integer *);
    extern /* Subroutine */ int drawad_(integer *, integer *);
    extern integer cddr_(integer *);
    extern /* Subroutine */ int coherx_(integer *, integer *), aligne_(
	    integer *);
    extern integer mapc_(S_fp, integer *);
    extern /* Subroutine */ int nodlig_(integer *, integer *), extrm2_(
	    integer *, real *, real *, real *, real *), lookdo_(void);
    extern integer cons_(integer *, integer *), last_(integer *), sens_(
	    integer *);
    static integer padr[5], prem[5];
    static logical bool;
    static integer numn, next[5];
    extern /* Subroutine */ int draw_(real *), addomn_(integer *), voirco_(
	    integer *), voirdo_(integer *), dtdomn_(integer *), nodelm_(
	    integer *, integer *), genbas_(integer *, real *, integer *), 
	    dtcodo_(integer *, integer *);
    extern integer nbintlk_(integer *);
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    draw3_(integer *), facbd_();
    extern integer caaar_(integer *), cadar_(integer *), cdddr_(integer *);

    extern integer ligne_(integer *, integer *, integer *);
    static real stack[30]	/* was [6][5] */;
    static integer label, i, j, pttbd, adres2, count, linki[5], mkcas1, 
	    mkcas2, mkcas3;
    extern /* Subroutine */ int gener2_(integer *), freel_(integer *), 
	    drp1p2_(real *, real *, real *), thick_(real *);
    static integer compt1, compt2, compt3, compt4;
    extern integer cdaaar_(integer *);
    extern integer cddddr_(integer *), appenx_(integer *, integer *), removx_(
	    integer *, integer *), nrever_(integer *), pkcomp_(integer *), 
	    pkdomn_(integer *, integer *);
    extern doublereal lngelm_(integer *);
    extern logical verifd_(integer *), verift_(void);
    extern /* Subroutine */ int refext_(integer *), refelm_(integer *), 
	    reselm_(integer *), drawbd_(), dofiss_(integer *), unfiss_(
	    integer *);
    static real xx1, xx2, yy1, yy2, dd1, dd2, ax[6];
    static integer pstack, pt, pt1, pt2, ptcomp, ptdomn, nuextr, nbn, comptc, 
	    der[5], preced[5];
    static char buf[130];
    extern /* Subroutine */ int noirci_(real *), demkmn_(integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___359 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___396 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___400 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___401 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___402 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___403 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___404 = { 0, 6, 0, 0, 0 };




/*     actions de application 2 (menu 6) (au dessus) */



/*      external anal4,monit,lireg4 */
/*      integer anal4,monit,lireg4 */

/*       integer pile(64),debutg,sizpil,ppile */
/*      stack = pile des entrees      (pointee par pstack) */
/*      padr  = pile des adresses des objets pointes (pointee par pstack) 
*/
/*      axe */

/*     case marquee,numero menu */
    ret_val = 0;
    if (*act == 0) {
/*        action vide */
	return ret_val;
    } else if (*act < 0) {
	s_wsle(&io___359);
	do_lio(&c__9, &c__1, "initialisation de preparation maillage", 38L);
	e_wsle();
/*        on genere sur la sortie standart */
	label = 6;
	pstack = 0;
	mkcas1 = 4;
	mkcas2 = 2;
	mkcas3 = 2;
	numn = 6;
	pec_1.appli = 513;
	for (i = 4; i <= 14; ++i) {
	    pec_1.acmenu[i - 1] = FALSE_;
/* L901: */
	}
	pec_1.acmenu[5] = TRUE_;
	noirci_(&pec_1.fmenu[20]);
	demkmn_(&c__6);
	afmenu_(&c__6);
	pec_1.calcu = 0;
	scrtch_("application preparation du maillage", 35L);
/*         i=analx(action,0) */
	return ret_val;
    } else if (*act == 999) {
/*        action speciale d'appel du niveau superieur si il existe */
/*         i=analx(action,vlmenu) */
	return ret_val;
    }
    switch (*act) {
	case 1:  goto L1;
	case 2:  goto L2;
	case 3:  goto L3;
	case 4:  goto L4;
	case 5:  goto L5;
	case 6:  goto L6;
	case 7:  goto L7;
	case 8:  goto L8;
	case 9:  goto L9;
	case 10:  goto L10;
	case 11:  goto L11;
	case 12:  goto L12;
	case 13:  goto L13;
	case 14:  goto L14;
	case 15:  goto L15;
	case 16:  goto L16;
	case 17:  goto L17;
	case 18:  goto L18;
	case 19:  goto L19;
	case 20:  goto L20;
	case 21:  goto L21;
	case 22:  goto L22;
	case 23:  goto L23;
	case 24:  goto L24;
	case 25:  goto L25;
	case 26:  goto L26;
	case 27:  goto L27;
	case 28:  goto L28;
	case 29:  goto L29;
	case 30:  goto L30;
	case 31:  goto L31;
	case 32:  goto L32;
	case 33:  goto L33;
	case 34:  goto L34;
	case 35:  goto L35;
	case 36:  goto L36;
	case 37:  goto L37;
	case 38:  goto L38;
	case 39:  goto L39;
	case 40:  goto L40;
	case 41:  goto L41;
	case 42:  goto L42;
	case 43:  goto L43;
	case 44:  goto L44;
	case 45:  goto L45;
	case 46:  goto L46;
	case 47:  goto L47;
	case 48:  goto L48;
	case 49:  goto L49;
	case 50:  goto L50;
	case 51:  goto L51;
	case 52:  goto L52;
	case 53:  goto L53;
	case 54:  goto L54;
	case 55:  goto L55;
	case 56:  goto L56;
	case 57:  goto L57;
	case 58:  goto L58;
	case 59:  goto L59;
	case 60:  goto L60;
	case 61:  goto L61;
	case 62:  goto L62;
	case 63:  goto L63;
	case 64:  goto L64;
	case 65:  goto L65;
	case 66:  goto L66;
	case 67:  goto L67;
	case 68:  goto L68;
	case 69:  goto L69;
	case 70:  goto L70;
	case 71:  goto L71;
	case 72:  goto L72;
	case 73:  goto L73;
    }
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 130;
    ici__1.iciunit = buf;
    ici__1.icifmt = "('APPLI2, ACTION ERRONNEE:=',I6)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&(*act), (ftnlen)sizeof(integer));
    e_wsfi();
    scrtch_(buf, 130L);
    return ret_val;
L1:
/*        call scrtch('On a rien compris!')                             #F
R*/
    scrtch_("We do not understand!", 21L);
    menumk_(&numn, &mkcas1, &c__0);
    menumk_(&numn, &mkcas2, &c__0);
    menumk_(&numn, &mkcas3, &c__0);
    return ret_val;
L2:
/*         print*,act,': init' */
    pstack = 0;
/*        axe = oy */
    ax[0] = -1.f;
    ax[1] = 1.f;
    ax[2] = 0.f;
    ax[3] = 0.f;
    return ret_val;
L3:
/*         print*,act,': push' */
    ++pstack;
    if (pstack > 4) {
	scrtch_("APPLI2:ERREUR DANS PUSH:OVERFLOW", 32L);
	pstack = 0;
	return ret_val;
    }
    padr[pstack - 1] = cdesig_1.adr;
    if (cdesig_1.adr == 0) {
	return ret_val;
    }
/*        on empile l'element */
    for (i = 0; i <= 5; ++i) {
	stack[i + pstack * 6 - 6] = bdpec2_1.bd[i + cdesig_1.adr * 6 + 384];
/* L301: */
    }
    return ret_val;
L4:
/*         print*,act,': push_coord  , adresse du support:',adr */
    ++pstack;
    if (pstack > 4) {
	scrtch_("APPLI2:ERREUR DANS PUSH:OVERFLOW", 32L);
	pstack = 0;
	return ret_val;
    }
    padr[pstack - 1] = cdesig_1.adr;
    cdesig_1.adr = 0;
    stack[pstack * 6 - 6] = 0.f;
    stack[pstack * 6 - 5] = cdesig_1.x;
    stack[pstack * 6 - 4] = cdesig_1.y;
    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
    draw_(&stack[pstack * 6 - 6]);
    return ret_val;
L5:
/*         print*,act,': nuref',numer */
    etat_1.nureff = cdesig_1.numer;
    afetat_();
    return ret_val;
L6:
/*         print*,act,': generer' */
    if (verift_()) {
	gener2_(&label);
    } else {
	scrtch_("APPLI2:ERREUR DANS LA VERIFICATION DES DOMAINES", 47L);
    }
    return ret_val;
L7:
/*         print*,act,': raison',numer */
    etat_1.raisoo = dabs(cdesig_1.numer);
    afetat_();
    return ret_val;
L8:
/*         print*,act,': nbnode',numer */
/* Computing MIN */
/* Computing MAX */
    i__3 = (i__1 = (integer) cdesig_1.numer, abs(i__1));
    i__2 = max(i__3,1);
    etat_1.nbintr = min(i__2,1000);
    afetat_();
    return ret_val;
L9:
/*         print*,act,': ref_ligne' */
/*        affecte un numero de ref a la ligne (a chaque partie de la lign 
*/
/*        en stack(1) on a (a ou s), en stack(2) on a point ou coord */
/*        la ligne doit appartenir a une meme composante (ptcomp) */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
/*        affecte nureff aux elements de link */
    i = mapc_((S_fp)refelm_, &bdpec1_1.link);
    return ret_val;
L10:
/*         print*,act,': ref_noeuds_ligne' */
/*        affecte un numero de ref aux noeuds de la ligne */
/*         (extremitees de chaque partie) */
/*        en stack(1) on a (a ou s), en stack(2) on a point ou coord */
/*        la ligne doit appartenir a une meme composante (ptcomp) */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
/*        affecte nureff aux extremitees des elements de link */
    i = mapc_((S_fp)refext_, &bdpec1_1.link);
    return ret_val;
L11:
/*         print*,act,': ref_noeuds_point',padr(1) */
/*        affecte un numero de ref a un point ou a une extremitee */
/*        en stack(0,1) on a  p a s spl ou coord */
    if (padr[0] == 0) {
/*          call scrtch('On ne peut changer la ref d''un point immedia
t'#FR*/
	scrtch_("It is impossible to change the ref of  immediate points", 
		55L);
	return ret_val;
    }
    i = padr[0];
    drawad_(&i, &c_n1);
    if (cdesig_1.vlmenu == 300) {
/*          recherche de quelle extremitee il sagit */
	if (cdesig_1.nextrm == 1) {
/*             print*,'extremite 1' */
	    if (bdpecd_1.fissur[i + 64]) {
		if (sens_(&i) == 1) {
		    bdpec6_1.nuref1[(i << 1) + 128] = etat_1.nureff;
		} else {
		    bdpec6_1.nuref1[(i << 1) + 129] = etat_1.nureff;
		}
	    } else {
		bdpec6_1.nuref1[(i << 1) + 128] = etat_1.nureff;
		bdpec6_1.nuref1[(i << 1) + 129] = etat_1.nureff;
	    }
/*            coherence a l'extremite 1 */
	    coherx_(&i, &c__1);
	} else if (cdesig_1.nextrm == 2) {
/*             print*,'extremite 2' */
	    if (bdpecd_1.fissur[i + 64]) {
		if (sens_(&i) == 1) {
		    bdpec7_1.nuref2[(i << 1) + 128] = etat_1.nureff;
		} else {
		    bdpec7_1.nuref2[(i << 1) + 129] = etat_1.nureff;
		}
	    } else {
		bdpec7_1.nuref2[(i << 1) + 128] = etat_1.nureff;
		bdpec7_1.nuref2[(i << 1) + 129] = etat_1.nureff;
	    }
/*            coherence a l'extremite 2 */
	    coherx_(&i, &c__2);
	} else {
	    scrtch_("ON NE PEUT REFERENCER UN POINT IMMEDIAT", 39L);
	}
    } else {
/*          numero de ref au point */
	bdpec5_1.nuref[(i << 1) + 128] = etat_1.nureff;
	bdpec5_1.nuref[(i << 1) + 129] = etat_1.nureff;
    }
    drawad_(&i, &c__0);
    return ret_val;
L12:
/*         print*,act,': nbnode_ligne' */
/*        repartie le nombre d'intervals sur les differentes */
/*        parties de la ligne */
/*        en stack(1) on a (a ou s), en stack(2) on a point ou coord */
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
    aligne_(&bdpec1_1.link);
    nodlig_(&bdpec1_1.link, &etat_1.nbintr);
    freel_(&bdpec1_1.link);
    return ret_val;
L13:
/*         print*,act,': extremitee2:' */
/*         calcul la deuxieme extremitee de l'element au niveau 2 de pile 
*/
/*         et met cette extremitee au niveau 2 de pile */
    if (padr[1] == 0) {
	scrtch_("On ne peut calculer les extremitees d'un point immediat", 
		55L);
	return ret_val;
    }
    extrm2_(&padr[1], &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
    r__1 = cdesig_1.x - xx2;
/* Computing 2nd power */
    r__2 = cdesig_1.y - yy2;
/* Computing 2nd power */
    r__3 = cdesig_1.x - xx1;
/* Computing 2nd power */
    r__4 = cdesig_1.y - yy1;
    if (r__1 * r__1 + r__2 * r__2 < r__3 * r__3 + r__4 * r__4) {
	stack[7] = xx2;
	stack[8] = yy2;
    } else {
	stack[7] = xx1;
	stack[8] = yy1;
    }
    stack[6] = 0.f;
    cdesig_1.vlmenu = 300;
    cdesig_1.adr = 0;
    return ret_val;
L14:
/*         print*,act,': ligne_interieur ' */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
    aligne_(&bdpec1_1.link);
    listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1] = appenx_(&
	    listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1], &
	    bdpec1_1.link);
    i = mapc_((S_fp)facbd_, &bdpec1_1.link);
    i = mapc_((S_fp)drawbd_, &bdpec1_1.link);
    return ret_val;
L15:
/*        voir tout domaines */
    lookdo_();
    return ret_val;
L16:
/*         print*,act,':composante_exterieur=',ptcomp,' du domaine',ptdom 
*/
/*        action venant apres une designation de domaine */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    return ret_val;
L17:
/*         print*,act,': add_composante',ptcomp,' au domaine',ptdomn */
    if (ptdomn != 0) {
/*           print*,'on complete le domaine',ptdomn,' par la composant
e' */
/*     +           ,ptcomp */
/*          on l'insert apres la premiere composante (exterieure) en t
ete */
/*           des trous (si il y en une) */
	i__1 = cons_(&ptcomp, &c__0);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = appenx_(&listed_1.cdr[
		listea_1.car[ptdomn - 1] - 1], &i__1);
    }
    return ret_val;
L18:
/*         print*,act,': voir_composante',ptcomp */
/*         (ptcomp retourne par pick) */
    voirco_(&ptcomp);
    return ret_val;
L19:
/*         print*,act,': pick_composante dont on a designe l''element' */
/*     +         ,padr(pstack) */
/*           ( a | s | spl) en stack(pstack) renvoie ptcomp pointant sur 
*/
/*         une cellule  dont le car et le cdr pointent */
/*         sur les composantes auquelles l'element appartient */
    pt2 = pkcomp_(&padr[pstack - 1]);
/*         on prend toujours le car, c'est a dire celui du cote >0 (gauch 
*/
/*         de l'element designe */
    ptcomp = listea_1.car[pt2 - 1];
    return ret_val;
L20:
/*        mark1 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas1, &c__0);
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
	mkcas1 = cdesig_1.nucase;
	menumk_(&numn, &mkcas1, &c__18);
    }
    return ret_val;
L21:
/*         print*,'raison_ligne: pstack=',pstack */
/*        affecte la raison a la ligne */
/*        en stack(1) on a (a ou s), en stack(2) on a point ou coord */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
/*        affecte la raison raisoo aux elements de la liste link */
    i = mapc_((S_fp)reselm_, &bdpec1_1.link);
    freel_(&bdpec1_1.link);
    return ret_val;
L22:
/*         print*,act,': raison_compo',ptcomp */
/*        affecte une raison  a touts les elements de la composante ptcom 
*/
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
/*        affecte la raison raisoo aux elements de la liste link */
    i = mapc_((S_fp)reselm_, &bdpec1_1.link);
    freel_(&bdpec1_1.link);
    return ret_val;
L23:
/*         print*,act,': raison_elm',padr(1) */
/*        affecte la raison raisoo a padr(1) */
    reselm_(padr);
    return ret_val;
L24:
/*         print*,act,': voir_domaine',ptdomn */
    if (verifd_(&ptdomn)) {
	voirdo_(&ptdomn);
    }
    return ret_val;
L25:
/*         print*,act,': pick_domaine, dont on a designer la composante' 
*/
/*     +         ,ptcomp */
/*            ( a | s | p) en stack(pstack) renvoie ptdomn pointant sur */
/*            le domaine auquel appartient l'element */
/*            on a toujours appeler pick_composante avant, donc ptcomp es 
*/
    ptdomn = pkdomn_(&ptcomp, &padr[pstack - 1]);
    return ret_val;
L26:
/*         print*,act,': retirer_domaine',ptdomn */
    dtdomn_(&ptdomn);
    return ret_val;
L27:
/*         print*,act,': verif_domaine',ptdomn */
    bool = verifd_(&ptdomn);
    return ret_val;
L28:
/*         print*,act,': raz_domns' */
L2801:
    ptdomn = bdpec1_1.sdomn;
    if (ptdomn != 0) {
	dtdomn_(&ptdomn);
	goto L2801;
    }
    return ret_val;
L29:
/*        mark2 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
	mkcas2 = cdesig_1.nucase;
	menumk_(&numn, &mkcas2, &c__18);
    }
    return ret_val;
L30:
/*         print*,act,': retirer_element_interieur',padr(pstack) */
/*     +             ,' au domaine', ptdomn */
    if (ptdomn != 0) {
	listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1] = 
		removx_(&padr[pstack - 1], &listed_1.cdr[listea_1.car[
		listea_1.car[ptdomn - 1] - 1] - 1]);
    }
    return ret_val;
L31:
/*         print*,act,': element_interieur',padr(pstack) */
    if (ptdomn != 0) {
	listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1] = cons_(&
		padr[pstack - 1], &listed_1.cdr[listea_1.car[listea_1.car[
		ptdomn - 1] - 1] - 1]);
	drawad_(&padr[pstack - 1], &c_n1);
	drawad_(&padr[pstack - 1], &c__0);
    }
    return ret_val;
L32:
/*         print*,act,': numero_domaine',nureff */
    etat_1.nudsd = etat_1.nureff;
/*        affecte un numero de sous domaine au domaine ptdomn */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1] 
	    - 1] = etat_1.nudsd;
    if (verifd_(&ptdomn)) {
	voirdo_(&ptdomn);
    }
    return ret_val;
L33:
/*        axe passant par les 2 points en pile */
    drp1p2_(ax, stack, &stack[6]);
    thick_(&c_b619);
    draw3_(&c__0);
    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
    draw_(ax);
    return ret_val;
L34:
/*         print*,act,': nbnode_elm',padr(1) */
/*        affect le nombre d'intervals nbintr a l'element padr(1) */
    compt1 = etat_1.nbintr + 1;
    nodelm_(padr, &compt1);
    return ret_val;
L35:
/*         print*,act,': nbnode_compo',ptcomp */
/*        affecte  nbintr intervals a la composante ptcomp */
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    aligne_(&bdpec1_1.link);
    nodlig_(&bdpec1_1.link, &etat_1.nbintr);
    freel_(&bdpec1_1.link);
    return ret_val;
L36:
/*         print*,act,': ref_noeuds_compo',ptcomp */
/*        affecte un numero de reference a touts les noeuds */
/*              de la composante ptcomp */
/*        ptcomp pointe sur la composante. */
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
/*        affecte nureff aux extremitees des elements de link */
    i = mapc_((S_fp)refext_, &bdpec1_1.link);
    return ret_val;
L37:
/*         print*,act,': ref_noeuds_domn',ptdomn */
/*        affecte un numero de reference a touts les noeuds */
/*              du domaine ptdomn */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
    }
/*        traitement des composantes du domaine */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    pt2 = cdar_(&ptdomn);
L3700:
    if (pt2 != 0) {
	bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[listea_1.car[pt2 - 
		1] - 1] - 1], &listea_1.car[pt2 - 1], &listea_1.car[
		listea_1.car[listea_1.car[pt2 - 1] - 1] - 1]);
/*          affecte nureff aux extremitees des elements de link */
	i = mapc_((S_fp)refext_, &bdpec1_1.link);
	freel_(&bdpec1_1.link);
/*          composante suivante */
	pt2 = listed_1.cdr[pt2 - 1];
	goto L3700;
    }
/*        traitement des elements interieurs du domaine */
/*        affecte nureff aux extremitees des elements interieurs */
    i = mapc_((S_fp)refext_, &listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 
	    1] - 1] - 1]);
    return ret_val;
L38:
/*         print*,act,': ref_ligne_compo',ptcomp */
/*        affecte un numero de ref a chaque element de la composante ptco 
*/
/*        ptcomp pointe sur la composante. */
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
/*        affecte nureff aux elements de link */
    i = mapc_((S_fp)refelm_, &bdpec1_1.link);
    freel_(&bdpec1_1.link);
    return ret_val;
L39:
/*         print*,act,': ref_ligne_domn',ptdomn */
/*        affecte un numero de ref a chaque element du domaine ptdomn */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
    }
/*        traitement des composantes du domaine */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    pt2 = cdar_(&ptdomn);
L3900:
    if (pt2 != 0) {
	bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[listea_1.car[pt2 - 
		1] - 1] - 1], &listea_1.car[pt2 - 1], &listea_1.car[
		listea_1.car[listea_1.car[pt2 - 1] - 1] - 1]);
/*          affecte nureff aux elements de link */
	i = mapc_((S_fp)refelm_, &bdpec1_1.link);
	freel_(&bdpec1_1.link);
/*          composante suivante */
	pt2 = listed_1.cdr[pt2 - 1];
	goto L3900;
    }
/*        traitement des elements interieurs du domaine */
/*        affecte nureff aux elements interieurs */
    i = mapc_((S_fp)refelm_, &listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 
	    1] - 1] - 1]);
    return ret_val;
L40:
/*       print*,act,': ref_noeuds_elm',padr(1) */
/*      affecte un numero de ref aux 2 extremitees de l'element padr(1) */
    if (sens_(padr) == 1) {
	refext_(padr);
    } else {
	i__1 = -padr[0];
	refext_(&i__1);
    }
    return ret_val;
L41:
/*       print*,act,': ref_ligne_elm',padr(1) */
/*      affecte un numero de ref a l'element padr(1) */
    if (sens_(padr) == 1) {
	refelm_(padr);
    } else {
	i__1 = -padr[0];
	refelm_(&i__1);
    }
    return ret_val;
L42:
/*       print*,'gen_base  generation d''une base pour vision' */
/*              (permet de faire des objets de rotation ou des prismes) */
    genbas_(&label, ax, &ptcomp);
    return ret_val;
L43:
/*       print*,act,': retirer_comp',ptcomp,' au domaine',ptdomn */
    if (ptdomn == 0) {
	scrtch_("DOMAINE NON DETERMINE", 21L);
	return ret_val;
    }
    dtcodo_(&ptdomn, &ptcomp);
    return ret_val;
L44:
/*      triangle domaine en triangles */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 309;
    return ret_val;
L45:
/*      ligne_premier_cote domaine en quadrangles pures */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 310;
    freel_(&bdpec1_1.link);
    ptcomp = cadar_(&ptdomn);
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
/*      affichage de la premiere ligne */
    i = mapc_((S_fp)facbd_, &bdpec1_1.link);
    i = mapc_((S_fp)drawbd_, &bdpec1_1.link);
/*      on sauve l'adresse des elements de debut et de fin du premier cot 
*/
    listea_1.car[listed_1.cdr[pt - 1] - 1] = listea_1.car[bdpec1_1.link - 1];
    listea_1.car[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] = listea_1.car[
	    last_(&bdpec1_1.link) - 1];
L4599:
/*      on force la composante exterieure a avoir son premier element */
/*      identique au premier element pour quadrangle (ceci pour la genera 
*/
/*      adresse debut de la composante */
    pttbd = caar_(&ptcomp);
/*      debut de la composante a droite ou a gauche */
    nuextr = cdar_(&ptcomp);
/*      adresse 1ere ligne du quadrangle */
    adres2 = cadr_(&pt);
/*      on suit les chainages conx a partir de pttbd */
/*      jusqu"a ce que l'on retrouve adres2 */
L4500:
    pt1 = bdpeca_1.conx[nuextr + (pttbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (pttbd << 1) + 127];
    pttbd = pt1;
    if (pttbd == adres2) {
	listed_1.cdr[listea_1.car[ptcomp - 1] - 1] = nuextr;
	listea_1.car[listea_1.car[ptcomp - 1] - 1] = cadr_(&pt);
    } else {
	goto L4500;
    }
    return ret_val;
L46:
/*      regulier  quadrangles en triangles reguliers ou pas */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 311;
/* Computing MIN */
/* Computing MAX */
    i__2 = (integer) cdesig_1.numer;
    i__1 = max(i__2,-1);
    listea_1.car[cddddr_(&pt) - 1] = min(i__1,2);
    goto L4599;
L47:
/*      coins    quadrangles  en triangles coins traites ou pas */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[caaar_(&ptdomn) - 1] = etat_1.nudsd;
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 311;
    if (cdesig_1.numer != 0.f) {
	cdesig_1.numer = -1.f;
    }
    listea_1.car[cdddr_(&pt) - 1] = cdesig_1.numer;
    goto L4599;
L48:
/*      elm_premier_cote domaine en quadrangles pures */
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[caaar_(&ptdomn) - 1] = etat_1.nudsd;
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 310;
    ptcomp = cadar_(&ptdomn);
/*      affichage du premier cote */
    drawad_(padr, &c_n1);
    drawad_(padr, &c__1);
/*      on sauve l'adresse des elements de debut et de fin du premier cot 
*/
    listea_1.car[listed_1.cdr[pt - 1] - 1] = padr[0];
    listea_1.car[cddr_(&pt) - 1] = padr[0];
    goto L4599;
L49:
/*      quatre_cotes ( on a en pile les 4 sommets du quadrangle) */
/*        en stack(0,1) on a :  p, a, s, spl, coord */
    count = 0;
L4955:
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[caaar_(&ptdomn) - 1] = etat_1.nudsd;
    }
/*      link de tout les elements de la composante */
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    aligne_(&bdpec1_1.link);
/*      nombre de points sur la composante */
    comptc = 0;
    pt1 = bdpec1_1.link;
L4911:
    if (pt1 != 0) {
	comptc = comptc + bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L4911;
    }
/*      recherche de padr(i) (i=1...4) de son suivant et de son predecess 
*/
    for (i = 1; i <= 4; ++i) {
	next[i - 1] = 0;
	pt1 = bdpec1_1.link;
	preced[i - 1] = listea_1.car[last_(&bdpec1_1.link) - 1];
L4999:
	++j;
	if (pt1 != 0) {
	    if (listea_1.car[pt1 - 1] == padr[i - 1]) {
		if (listed_1.cdr[pt1 - 1] == 0) {
		    next[i - 1] = listea_1.car[bdpec1_1.link - 1];
		} else {
		    next[i - 1] = cadr_(&pt1);
		}
	    } else {
		preced[i - 1] = listea_1.car[pt1 - 1];
		pt1 = listed_1.cdr[pt1 - 1];
		goto L4999;
	    }
	}
	if (next[i - 1] == 0) {
	    scrtch_("ERREUR GRAVE, ON NE RETROUVE PAS LES ELEMENTS DESIGNES", 
		    54L);
	    return ret_val;
	}
/* L4998: */
    }
    padr[4] = padr[0];
    stack[25] = stack[1];
    stack[26] = stack[2];
    next[4] = next[0];
    preced[4] = preced[0];
    for (i = 1; i <= 4; ++i) {
/*        creation des premiers et derniers elements des cotes */
/*        extremitees du suivant de i */
	if (next[i - 1] == 0) {
	    scrtch_("Aucun des 4 sommets ne doivent etre des points immediats"
		    , 56L);
	    return ret_val;
	}
	extrm2_(&next[i - 1], &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	r__1 = stack[i * 6 - 5] - xx1;
/* Computing 2nd power */
	r__2 = stack[i * 6 - 4] - yy1;
	dd1 = sqrt(r__1 * r__1 + r__2 * r__2);
/* Computing 2nd power */
	r__1 = stack[i * 6 - 5] - xx2;
/* Computing 2nd power */
	r__2 = stack[i * 6 - 4] - yy2;
	dd2 = sqrt(r__1 * r__1 + r__2 * r__2);
	if (dd1 <= eps_1.eps || dd2 <= eps_1.eps) {
	    prem[i - 1] = next[i - 1];
	} else {
	    prem[i - 1] = padr[i - 1];
	}
/*        extremitees du suivant de i+1 */
	extrm2_(&next[i], &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	r__1 = stack[(i + 1) * 6 - 5] - xx1;
/* Computing 2nd power */
	r__2 = stack[(i + 1) * 6 - 4] - yy1;
	dd1 = sqrt(r__1 * r__1 + r__2 * r__2);
/* Computing 2nd power */
	r__1 = stack[(i + 1) * 6 - 5] - xx2;
/* Computing 2nd power */
	r__2 = stack[(i + 1) * 6 - 4] - yy2;
	dd2 = sqrt(r__1 * r__1 + r__2 * r__2);
	if (dd1 <= eps_1.eps || dd2 <= eps_1.eps) {
	    der[i - 1] = padr[i];
	} else {
	    der[i - 1] = preced[i];
	}
	linki[i - 1] = 0;
	if (prem[i - 1] == der[i - 1]) {
	    linki[i - 1] = cons_(&prem[i - 1], &c__0);
	} else {
	    linki[i - 1] = ligne_(&prem[i - 1], &ptcomp, &der[i - 1]);
	    aligne_(&linki[i - 1]);
	}
/* L4997: */
    }
/*      nombre d'intervals sur le premier cote */
    compt1 = 0;
    pt1 = linki[0];
L4901:
    if (pt1 != 0) {
	compt1 = compt1 + bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L4901;
    }
/*      nombre d'intervals sur le deuxieme cote */
    compt2 = 0;
    pt1 = linki[1];
L4902:
    if (pt1 != 0) {
	compt2 = compt2 + bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L4902;
    }
    if (comptc - (compt1 << 1) < 0) {
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 130;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_4912;
	s_wsfi(&ici__1);
	e_wsfi();
	scrtch_(buf, 130L);
	s_wsle(&io___396);
	do_lio(&c__9, &c__1, "APPLI2 49:NOMBRE DE POINTS SUR LA COMPOSANTE,", 
		45L);
	do_lio(&c__3, &c__1, (char *)&comptc, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " SUR 1ER COTE,", 14L);
	do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer));
	e_wsle();
	++count;
	if (count <= 1) {
/*          on interverti 2 et 4 */
	    i = padr[1];
	    padr[1] = padr[3];
	    padr[3] = i;
	    for (i = 0; i <= 5; ++i) {
		xx1 = stack[i + 6];
		stack[i + 6] = stack[i + 18];
		stack[i + 18] = xx1;
/* L4956: */
	    }
	    goto L4955;
	} else {
	    scrtch_("ON ABANDONNE, REDESIGNEZ CE QUADRANGLE!", 39L);
	    return ret_val;
	}
    }
/*      affectation du bon nombre d'intervals au 3ieme cote */
    i__1 = nrever_(&linki[2]);
    nodlig_(&i__1, &compt1);
/*      affectation du bon nombre d'intervals au 4ieme cote */
    i__1 = nrever_(&linki[3]);
    nodlig_(&i__1, &compt2);
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 310;
    ptcomp = cadar_(&ptdomn);
/*      affichage de la premiere ligne */
    i = mapc_((S_fp)facbd_, linki);
    i = mapc_((S_fp)drawbd_, linki);
/*      on sauve l'adresse des elements de debut et de fin du premier cot 
*/
    listea_1.car[listed_1.cdr[pt - 1] - 1] = listea_1.car[linki[0] - 1];
    listea_1.car[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] = listea_1.car[
	    last_(linki) - 1];
    freel_(linki);
    freel_(&linki[1]);
    freel_(&linki[2]);
    freel_(&linki[3]);
    goto L4599;
L50:
/*        umark1 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas1, &c__0);
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L51:
/*        umark2 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L52:
/*        lg_interval  recupere la longueur d'un interval ==> lgintr */
/* Computing MAX */
    r__1 = dabs(cdesig_1.numer);
    etat_1.lgintr = dmax(r__1,eps_1.eps);
    afetat_();
    return ret_val;
L53:
/*        lg_ligne   calcule le nombre de noeuds de chaque element */
/*                   en fonction de lgintr et de la longueur de la ligne 
*/
/*        en stack(1) on a (a ou s), en stack(2) on a point ou coord */
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
    aligne_(&bdpec1_1.link);
    pt = bdpec1_1.link;
L5300:
    if (pt != 0) {
	nbn = (integer) (lngelm_(&listea_1.car[pt - 1]) / etat_1.lgintr) + 1;
	nodelm_(&listea_1.car[pt - 1], &nbn);
	pt = listed_1.cdr[pt - 1];
	goto L5300;
    }
    freel_(&bdpec1_1.link);
    return ret_val;
L54:
/*        lg_compo   calcule le nombre de noeuds de chaque element */
/*                   en fonction de lgintr et de la longueur de la compos 
*/
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    aligne_(&bdpec1_1.link);
    pt = bdpec1_1.link;
L5400:
    if (pt != 0) {
	nbn = (integer) (lngelm_(&listea_1.car[pt - 1]) / etat_1.lgintr) + 1;
	nodelm_(&listea_1.car[pt - 1], &nbn);
	pt = listed_1.cdr[pt - 1];
	goto L5400;
    }
    freel_(&bdpec1_1.link);
    return ret_val;
L55:
/*        lg_elem   calcule le nombre de noeuds de l'element */
/*                  en fonction de lgintr et de la longueur de l'element 
*/
    nbn = (integer) (lngelm_(padr) / etat_1.lgintr) + 1;
    nodelm_(padr, &nbn);
    return ret_val;
L56:
/*        mark3 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas3, &c__0);
	mkcas3 = cdesig_1.nucase;
	menumk_(&numn, &mkcas3, &c__18);
    }
    return ret_val;
L57:
/*        umark3 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L58:
/*        de_fissure_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    if (bdpecd_1.fissur[i + 64]) {
		unfiss_(&i);
	    }
	}
/* L5800: */
    }
    return ret_val;
L59:
/*        de_fissure_ligne */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
    i = mapc_((S_fp)unfiss_, &bdpec1_1.link);
    return ret_val;
L60:
/*        de_fissure_compo */
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    i = mapc_((S_fp)unfiss_, &bdpec1_1.link);
    return ret_val;
L61:
/*        de_fissure_elm */
    unfiss_(padr);
    return ret_val;
L62:
/*        fissure_ligne */
    bdpec1_1.link = ligne_(padr, &ptcomp, &padr[1]);
    i = mapc_((S_fp)dofiss_, &bdpec1_1.link);
    return ret_val;
L63:
/*        fissure_compo */
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    i = mapc_((S_fp)dofiss_, &bdpec1_1.link);
    return ret_val;
L64:
/*        fissure_elm */
    dofiss_(padr);
    return ret_val;
L65:
/*        fissure_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    dofiss_(&i);
	}
/* L6500: */
    }
    return ret_val;
L66:
/*        nbnode_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    compt1 = etat_1.nbintr + 1;
	    nodelm_(&i, &compt1);
	}
/* L6600: */
    }
    return ret_val;
L67:
/*        raison_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    reselm_(&i);
	}
/* L6700: */
    }
    return ret_val;
L68:
/*        ref_noeuds_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	refext_(&i);
	if (bdpecd_1.fissur[i + 64]) {
	    i__2 = -i;
	    refext_(&i__2);
	}
/* L6800: */
    }
    return ret_val;
L69:
/*        ref_ligne_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    refelm_(&i);
	    if (bdpecd_1.fissur[i + 64]) {
		i__2 = -i;
		refelm_(&i__2);
	    }
	}
/* L6900: */
    }
    return ret_val;
L70:
/*        lg_interval_tout */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    nbn = (integer) (lngelm_(&i) / etat_1.lgintr) + 1;
	    nodelm_(&i, &nbn);
	}
/* L7000: */
    }
    return ret_val;
L71:
/*        verif_tous_domaines */
    ptdomn = bdpec1_1.sdomn;
L7100:
    if (ptdomn != 0) {
	bool = verifd_(&ptdomn);
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L7100;
    }
    return ret_val;
L72:
/*        numero_tous_domaines */
    etat_1.nudsd = etat_1.nureff;
    ptdomn = bdpec1_1.sdomn;
L7200:
    if (ptdomn != 0) {
/*          affecte un numero de sous domaine au domaine ptdomn */
	listea_1.car[listea_1.car[listea_1.car[listea_1.car[ptdomn - 1] - 1] 
		- 1] - 1] = etat_1.nudsd;
	if (verifd_(&ptdomn)) {
	    voirdo_(&ptdomn);
	}
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L7200;
    }
    return ret_val;
L73:
/*      quatre_cotes_BANDE ( on a en pile les 4 sommets du quadrangle) */
/*        en stack(0,1) on a :  p, a, s, spl, coord */
    count = 0;
L7355:
    if (ptcomp == 0) {
	scrtch_("L'ELEMENT DESIGNE N'EST PAS UNE COMPOSANTE", 42L);
    } else if (ptdomn == 0) {
	addomn_(&ptdomn);
	listed_1.cdr[listea_1.car[ptdomn - 1] - 1] = cons_(&ptcomp, &c__0);
	listea_1.car[caaar_(&ptdomn) - 1] = etat_1.nudsd;
    }
/*      link de tout les elements de la composante */
    freel_(&bdpec1_1.link);
    bdpec1_1.link = ligne_(&listea_1.car[listea_1.car[ptcomp - 1] - 1], &
	    ptcomp, &listea_1.car[listea_1.car[ptcomp - 1] - 1]);
    aligne_(&bdpec1_1.link);
    i__1 = -bdpec1_1.link;
    comptc = nbintlk_(&i__1);
/*      nombre de points sur la composante */
/*      recherche de padr(i) (i=1...4) de son suivant et de son predecess 
*/
    for (i = 1; i <= 4; ++i) {
	next[i - 1] = 0;
	pt1 = bdpec1_1.link;
	preced[i - 1] = listea_1.car[last_(&bdpec1_1.link) - 1];
L7399:
	++j;
	if (pt1 != 0) {
	    if (listea_1.car[pt1 - 1] == padr[i - 1]) {
		if (listed_1.cdr[pt1 - 1] == 0) {
		    next[i - 1] = listea_1.car[bdpec1_1.link - 1];
		} else {
		    next[i - 1] = cadr_(&pt1);
		}
	    } else {
		preced[i - 1] = listea_1.car[pt1 - 1];
		pt1 = listed_1.cdr[pt1 - 1];
		goto L7399;
	    }
	}
	if (next[i - 1] == 0) {
	    scrtch_("ERREUR GRAVE, ON NE RETROUVE PAS LES ELEMENTS DESIGNES", 
		    54L);
	    return ret_val;
	}
/* L7398: */
    }
    padr[4] = padr[0];
    stack[25] = stack[1];
    stack[26] = stack[2];
    next[4] = next[0];
    preced[4] = preced[0];
    for (i = 1; i <= 4; ++i) {
/*        creation des premiers et derniers elements des cotes */
/*        extremitees du suivant de i */
	if (next[i - 1] == 0) {
	    scrtch_("Aucun des 4 sommets ne doivent etre des points immediats"
		    , 56L);
	    return ret_val;
	}
	extrm2_(&next[i - 1], &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	r__1 = stack[i * 6 - 5] - xx1;
/* Computing 2nd power */
	r__2 = stack[i * 6 - 4] - yy1;
	dd1 = sqrt(r__1 * r__1 + r__2 * r__2);
/* Computing 2nd power */
	r__1 = stack[i * 6 - 5] - xx2;
/* Computing 2nd power */
	r__2 = stack[i * 6 - 4] - yy2;
	dd2 = sqrt(r__1 * r__1 + r__2 * r__2);
	if (dd1 <= eps_1.eps || dd2 <= eps_1.eps) {
	    prem[i - 1] = next[i - 1];
	} else {
	    prem[i - 1] = padr[i - 1];
	}
/*        extremitees du suivant de i+1 */
	extrm2_(&next[i], &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	r__1 = stack[(i + 1) * 6 - 5] - xx1;
/* Computing 2nd power */
	r__2 = stack[(i + 1) * 6 - 4] - yy1;
	dd1 = sqrt(r__1 * r__1 + r__2 * r__2);
/* Computing 2nd power */
	r__1 = stack[(i + 1) * 6 - 5] - xx2;
/* Computing 2nd power */
	r__2 = stack[(i + 1) * 6 - 4] - yy2;
	dd2 = sqrt(r__1 * r__1 + r__2 * r__2);
	if (dd1 <= eps_1.eps || dd2 <= eps_1.eps) {
	    der[i - 1] = padr[i];
	} else {
	    der[i - 1] = preced[i];
	}
	linki[i - 1] = 0;
	if (prem[i - 1] == der[i - 1]) {
	    linki[i - 1] = cons_(&prem[i - 1], &c__0);
	} else {
	    linki[i - 1] = ligne_(&prem[i - 1], &ptcomp, &der[i - 1]);
	    aligne_(&linki[i - 1]);
	}
/* L7397: */
    }
    i__1 = -linki[0];
    compt1 = nbintlk_(&i__1);
    i__1 = -linki[1];
    compt2 = nbintlk_(&i__1);
    i__1 = -linki[2];
    compt3 = nbintlk_(&i__1);
    i__1 = -linki[3];
    compt4 = nbintlk_(&i__1);
    s_wsle(&io___400);
    do_lio(&c__9, &c__1, "+", 1L);
    do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt2, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt3, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt4, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " = ", 3L);
    do_lio(&c__3, &c__1, (char *)&comptc, (ftnlen)sizeof(integer));
    e_wsle();
    if (comptc != compt1 + compt2 + compt3 + compt4) {
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 130;
	ici__1.iciunit = buf;
	ici__1.icifmt = fmt_7312;
	s_wsfi(&ici__1);
	e_wsfi();
	scrtch_(buf, 130L);
	s_wsle(&io___401);
	do_lio(&c__9, &c__1, "APPLI2 73::NOMBRE DE POINTS SUR Les cote 2 & 4:"
		, 47L);
	do_lio(&c__3, &c__1, (char *)&compt2, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt4, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " ou cote 1 & 3 =", 16L);
	do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt3, (ftnlen)sizeof(integer));
	e_wsle();
	++count;
	if (count <= 1) {
/*          on interverti 2 et 4 */
	    i = padr[1];
	    padr[1] = padr[3];
	    padr[3] = i;
	    for (i = 0; i <= 5; ++i) {
		xx1 = stack[i + 6];
		stack[i + 6] = stack[i + 18];
		stack[i + 18] = xx1;
/* L7356: */
	    }
	    goto L7355;
	} else {
	    scrtch_("ON ABANDONNE, REDESIGNEZ CE QUADRANGLE!", 39L);
	    freel_(linki);
	    freel_(&linki[1]);
	    freel_(&linki[2]);
	    freel_(&linki[3]);
	    return ret_val;
	}
    }
    s_wsle(&io___402);
    do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt2, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt3, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&compt4, (ftnlen)sizeof(integer));
    e_wsle();
    for (i = 1; i <= 4; ++i) {
	s_wsle(&io___403);
	do_lio(&c__9, &c__1, " link ", 6L);
	do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&linki[i - 1], (ftnlen)sizeof(integer));
	i__1 = last_(&linki[i - 1]);
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___404);
	do_lio(&c__9, &c__1, "   car(", 7L);
	do_lio(&c__3, &c__1, (char *)&listea_1.car[linki[i - 1] - 1], (ftnlen)
		sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&listea_1.car[last_(&linki[i - 1]) - 1], 
		(ftnlen)sizeof(integer));
	e_wsle();
    }
    pt = cdaaar_(&ptdomn);
    listea_1.car[pt - 1] = 312;
    ptcomp = cadar_(&ptdomn);
/*      affichage de la premiere ligne */
    i = mapc_((S_fp)facbd_, linki);
    i = mapc_((S_fp)drawbd_, linki);
    if (compt2 == compt4) {
	i = mapc_((S_fp)facbd_, linki);
	i = mapc_((S_fp)drawbd_, linki);
	listea_1.car[listed_1.cdr[pt - 1] - 1] = listea_1.car[linki[0] - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] = 
		listea_1.car[last_(linki) - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] 
		- 1] = listea_1.car[linki[1] - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[listed_1.cdr[listed_1.cdr[pt - 
		1] - 1] - 1] - 1] - 1] = listea_1.car[last_(&linki[1]) - 1];
    } else {
	i = mapc_((S_fp)facbd_, &linki[1]);
	i = mapc_((S_fp)drawbd_, &linki[1]);
	listea_1.car[listed_1.cdr[pt - 1] - 1] = listea_1.car[linki[1] - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] = 
		listea_1.car[last_(&linki[1]) - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[listed_1.cdr[pt - 1] - 1] - 1] 
		- 1] = listea_1.car[linki[2] - 1];
	listea_1.car[listed_1.cdr[listed_1.cdr[listed_1.cdr[listed_1.cdr[pt - 
		1] - 1] - 1] - 1] - 1] = listea_1.car[last_(&linki[2]) - 1];
    }
    freel_(linki);
    freel_(&linki[1]);
    freel_(&linki[2]);
    freel_(&linki[3]);
/*      on force la composante exterieure a avoir son premier element */
/*      identique au premier element pour quadrangle (ceci pour la genera 
*/
/*      adresse debut de la composante */
    pttbd = caar_(&ptcomp);
/*      debut de la composante a droite ou a gauche */
    nuextr = cdar_(&ptcomp);
/*      adresse 1ere ligne du quadrangle */
    adres2 = cadr_(&pt);
/*      on suit les chainages conx a partir de pttbd */
/*      jusqu"a ce que l'on retrouve adres2 */
L7300:
    pt1 = bdpeca_1.conx[nuextr + (pttbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (pttbd << 1) + 127];
    pttbd = pt1;
    if (pttbd == adres2) {
	listed_1.cdr[listea_1.car[ptcomp - 1] - 1] = nuextr;
	listea_1.car[listea_1.car[ptcomp - 1] - 1] = cadr_(&pt);
    } else {
	goto L7300;
    }
    return ret_val;
} /* appli2_ */



