#include <assert.h>
#include <stdlib.h>
#include "emc2_h.h"

integer calcul_(integer *act)
{
    /* System generated locals */
    integer ret_val, i__1;
    real r__1, r__2;
    doublereal d__1, d__2, d__3, d__4;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double pow_ri(real *, integer *), d_int(doublereal *), pow_di(doublereal *
	    , integer *), pow_dd(doublereal *, doublereal *), sin(doublereal),
	     cos(doublereal), tan(doublereal), atan(doublereal), atan2(
	    doublereal, doublereal), exp(doublereal), log(doublereal), d_lg10(
	    doublereal *), sqrt(doublereal), d_mod(doublereal *, doublereal *)
	    , d_sign(doublereal *, doublereal *), d_nint(doublereal *);

    /* Local variables */
    static integer deci;
    static real accu;
    static integer *oper=0;
    static doublereal *rstk=0;
    static real savx, savy;
    extern doublereal dtc1c2_(real *, real *);

    extern doublereal atang2_(real *, real *);
    static integer ptstk;
    static real p1[3], p2[3], d1[4], d2[4];
    extern /* Subroutine */ int drp1p2_(real *, real *, real *), afcalc_(void)
	    ;
    static integer ii;
    extern doublereal dtp1xx_(real *, real *);
    extern doublereal longsp_(integer *);
    static integer nuchif, ptoper, * cparam=0, op, iex, is, ex;
    static real res[6];
    static integer savadr;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);

    /* Fortran I/O blocks */
    /*static*/ cilist io___581 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___589 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___591 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___593 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___596 = { 0, 6, 0, 0, 0 };


/*                       calculette */
/*       actions pour calculette */


/*      pour calculette */

/*     mxval=taille de la pile d'evaluation des expressions */
/*     pile d'evaluation */
/*     mxoper = taille de la pile des operateurs */
/*      pile des operateurs */
/*     compte des parametres d'une fonction */
    ret_val = 0;
    if (*act == 0) {
/*        action vide */
	return ret_val;
    } else if (*act < 0) {
	s_wsle(&io___581);
	do_lio(&c__9, &c__1, "INITIALISATION DE CALCULETTE", 28L);
	e_wsle();	
	if(!oper) assert(oper=(integer*) malloc(sizeof(integer)*100));
	if(!cparam) assert(cparam=(integer*) malloc(sizeof(integer)*100));
	if(!rstk) assert(rstk=(doublereal*) malloc(sizeof(doublereal)*100));
	ptoper = 0;
	ptstk = 0;
	nuchif = 0;
	deci = 0;
	accu = 0.f;
	ex = 0;
	iex = 1;
	cdesig_1.numer = 0.f;
	return ret_val;
    }
    if (*act > 100) {
/*        erreurs */
	if (*act == 101) {
	    scrtch_("ERREUR IL MANQUE UNE PARENTHESE...", 34L);
	} else {
	    scrtch_("ERREURE INCONNUE.....................", 37L);
	}
	return ret_val;
    }
    switch (*act) {
	case 1:  goto L1;
	case 2:  goto L2;
	case 3:  goto L3;
	case 4:  goto L4;
	case 5:  goto L5;
	case 6:  goto L6;
	case 7:  goto L7;
	case 8:  goto L8;
	case 9:  goto L9;
	case 10:  goto L10;
	case 11:  goto L11;
	case 12:  goto L12;
	case 13:  goto L13;
	case 14:  goto L14;
	case 15:  goto L15;
	case 16:  goto L16;
	case 17:  goto L17;
	case 18:  goto L18;
	case 19:  goto L19;
	case 20:  goto L20;
	case 21:  goto L21;
	case 22:  goto L22;
	case 23:  goto L23;
	case 24:  goto L24;
	case 25:  goto L25;
	case 26:  goto L26;
	case 27:  goto L27;
	case 28:  goto L28;
    }
    scrtch_("CALCULETTE:ERREUR SYSTEME,ACTION ERRONNEE", 41L);
    s_wsle(&io___589);
    do_lio(&c__9, &c__1, "ERREUR:CALCULETTE,ACTION ERRONNEE", 33L);
    do_lio(&c__3, &c__1, (char *)&(*act), (ftnlen)sizeof(integer));
    e_wsle();
    return ret_val;
L1:
/*     [debut_nombre] */
    ex = 0;
    iex = 1;
    nuchif = 0;
    deci = 0;
    accu = 0.f;
    nuchif = 0;
    return ret_val;
L2:
/*        push_chiffre */
    ++nuchif;
    if (deci == 0) {
	accu = accu * 10.f + (real) (cdesig_1.vlmenu - 9000);
    } else if (deci == 1) {
	accu += (real) (cdesig_1.vlmenu - 9000) / pow_ri(&c_b1576, &nuchif);
    } else {
	ex = ex * 10 + (real) (cdesig_1.vlmenu - 9000);
    }
    i__1 = iex * ex;
    cdesig_1.numer = accu * pow_ri(&c_b1576, &i__1);
    afcalc_();
    return ret_val;
L3:
/*        pt_deci */
    nuchif = 0;
    deci = 1;
    return ret_val;
L4:
/*        clear */
    nuchif = 0;
    deci = 0;
    accu = 0.f;
    iex = 1;
    ex = 0;
    cdesig_1.numer = 0.f;
    afcalc_();
    return ret_val;
L5:
/*        mauvaise_sortie */
    scrtch_("VOUS NE SORTIREZ DE LA CALCULETTE QU'EN TAPANT =", 48L);
    return ret_val;
L6:
/*        raz */
    ptoper = 0;
    ptstk = 0;
    return ret_val;
L7:
/*        exposante d'un nombre */
    deci = 2;
    return ret_val;
L8:
/*        plus2 */
    rstk[ptstk - 2] += rstk[ptstk - 1];
    goto L999;
L9:
/*        moins2 */
    rstk[ptstk - 2] -= rstk[ptstk - 1];
    goto L999;
L10:
/*        mul2 */
    rstk[ptstk - 2] *= rstk[ptstk - 1];
    goto L999;
L11:
/*        div2 */
    if (rstk[ptstk - 1] != 0.) {
	rstk[ptstk - 2] /= rstk[ptstk - 1];
    } else {
	scrtch_("DIVISION PAR ZERO", 17L);
    }
    goto L999;
L12:
/*        moins exp */
    iex = -1;
    return ret_val;
L13:
/*        moins1 */
    rstk[ptstk - 1] = -rstk[ptstk - 1];
    goto L1000;
L14:
/*        exponentiel2 */
    if (d_int(&rstk[ptstk - 1]) - rstk[ptstk - 1] == 0.) {
/*          puissance entiere */
	i__1 = (integer) rstk[ptstk - 1];
	rstk[ptstk - 2] = pow_di(&rstk[ptstk - 2], &i__1);
    } else {
/*          puissance real */
	if (rstk[ptstk - 2] < 0.) {
	    scrtch_(" ATTENTION NOMBRE < 0 A UNE PUISSANCE REELLE", 44L);
	    rstk[ptstk - 2] = (d__1 = rstk[ptstk - 2], abs(d__1));
	}
	rstk[ptstk - 2] = pow_dd(&rstk[ptstk - 2], &rstk[ptstk - 1]);
    }
    goto L999;
L15:
/*        constante */
    ex = 0;
    iex = 1;
    nuchif = 0;
    deci = 0;
    accu = 0.f;
    ++ptstk;
    rstk[ptstk - 1] = cdesig_1.numer;
    return ret_val;
L16:
/*        valeur de id predefinis */
    ++ptstk;
    if (cdesig_1.vlmenu == 9990) {
/*          pi */
	cdesig_1.numer = 3.141592653f;
    } else if (cdesig_1.vlmenu == 9991) {
/*          yes */
	cdesig_1.numer = 0.f;
    } else if (cdesig_1.vlmenu == 9992) {
/*          no */
	cdesig_1.numer = -1.f;
    }
    rstk[ptstk - 1] = cdesig_1.numer;
    goto L1000;
L17:
/*         print*,'qnufonction',oper(ptoper),' ptstk=',ptstk */
    if (ptoper < 1) {
	scrtch_("CALCULETTE:MANQUE OPERATEUR", 27L);
	s_wsle(&io___591);
	do_lio(&c__9, &c__1, "CALCULETTE:MANQUE OPERATEUR", 27L);
	do_lio(&c__3, &c__1, (char *)&ptoper, (ftnlen)sizeof(integer));
	e_wsle();
	return ret_val;
    } else if (cparam[ptoper - 1] < 1) {
	scrtch_("CALCULETTE:MANQUE LES ARGUMENTS DE LA FONCTION", 46L);
	s_wsle(&io___593);
	do_lio(&c__9, &c__1, "CALCULETTE:MANQUE LES ARGUMENTS DE LA FONCTION",
		 46L);
	do_lio(&c__3, &c__1, (char *)&cparam[ptoper - 1], (ftnlen)sizeof(
		integer));
	e_wsle();
	return ret_val;
    }
    op = oper[ptoper - 1];
    --ptoper;
    switch (op - 9500) {
	case 1:  goto L171;
	case 2:  goto L172;
	case 3:  goto L173;
	case 4:  goto L174;
	case 5:  goto L175;
	case 6:  goto L176;
	case 7:  goto L177;
	case 8:  goto L178;
	case 9:  goto L179;
	case 10:  goto L1700;
	case 11:  goto L1701;
	case 12:  goto L1702;
	case 13:  goto L1703;
	case 14:  goto L1704;
	case 15:  goto L1705;
	case 16:  goto L1706;
    }
    scrtch_("CALCULETTE:ERREUR FONCTION INCONNU", 34L);
    s_wsle(&io___596);
    do_lio(&c__9, &c__1, "CALCULETTE:ERREUR FONCTION INCONNU", 34L);
    do_lio(&c__3, &c__1, (char *)&op, (ftnlen)sizeof(integer));
    e_wsle();
    goto L17000;
L171:
    rstk[ptstk - 1] = sin(rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L172:
    rstk[ptstk - 1] = cos(rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L173:
    rstk[ptstk - 1] = tan(rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L174:
    rstk[ptstk - 1] = atan(rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L175:
    if (rstk[ptstk - 2] == 0. && rstk[ptstk - 1] == 0.) {
	rstk[ptstk - 2] = 0.f;
    } else {
	rstk[ptstk - 2] = atan2(rstk[ptstk - 2], rstk[ptstk - 1]);
    }
    is = 2;
    goto L17000;
L176:
/* Computing MIN */
/* Computing MAX */
    d__3 = -89., d__4 = rstk[ptstk - 1];
    d__1 = 89., d__2 = max(d__3,d__4);
    rstk[ptstk - 1] = min(d__1,d__2);
    rstk[ptstk - 1] = exp(rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L177:
    if (rstk[ptstk - 1] < 0.) {
	scrtch_("ATTENTION DANS LOG PARAM<0", 26L);
    }
    rstk[ptstk - 1] = log((d__1 = rstk[ptstk - 1], abs(d__1)));
    is = 1;
    goto L17000;
L178:
    if (rstk[ptstk - 1] < 0.) {
	scrtch_("ATTENTION DANS LOG10 PARAM<0", 28L);
    }
    d__2 = (d__1 = rstk[ptstk - 1], abs(d__1));
    rstk[ptstk - 1] = d_lg10(&d__2);
    is = 1;
    goto L17000;
L179:
    if (rstk[ptstk - 1] < 0.) {
	scrtch_("ATTENTION DANS SQRT PARAM<0", 27L);
    }
    rstk[ptstk - 1] = sqrt((d__1 = rstk[ptstk - 1], abs(d__1)));
    is = 1;
    goto L17000;
L1700:
    rstk[ptstk - 2] = d_mod(&rstk[ptstk - 2], &rstk[ptstk - 1]);
    is = 2;
    goto L17000;
L1701:
    rstk[ptstk - 1] = (d__1 = rstk[ptstk - 1], abs(d__1));
    is = 1;
    goto L17000;
L1702:
    if (rstk[ptstk - 1] != 0.) {
	rstk[ptstk - 1] = d_sign(&c_b1621, &rstk[ptstk - 1]);
    }
    is = 1;
    goto L17000;
L1703:
    rstk[ptstk - 1] = d_int(&rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L1704:
    rstk[ptstk - 1] = d_nint(&rstk[ptstk - 1]);
    is = 1;
    goto L17000;
L1705:
    i__1 = ptstk - cparam[ptoper - 1] + 2;
    for (ii = ptstk; ii >= i__1; --ii) {
/* Computing MIN */
	d__1 = rstk[ptstk - cparam[ptoper - 1]], d__2 = rstk[ii - 1];
	rstk[ptstk - cparam[ptoper - 1]] = min(d__1,d__2);
/* L17050: */
    }
    is = cparam[ptoper - 1];
    goto L17000;
L1706:
    i__1 = ptstk - cparam[ptoper - 1] + 2;
    for (ii = ptstk; ii >= i__1; --ii) {
/* Computing MAX */
	d__1 = rstk[ptstk - cparam[ptoper - 1]], d__2 = rstk[ii - 1];
	rstk[ptstk - cparam[ptoper - 1]] = max(d__1,d__2);
/* L17060: */
    }
    is = cparam[ptoper - 1];
    goto L17000;

L17000:
    ptstk = ptstk - is + 1;
    goto L1000;
L18:
/*         print*,'addparam',cparam(ptoper)+1 */
    ++cparam[ptoper - 1];
    return ret_val;
L19:
/*         print*,'idfonction on empile',vlmenu */
    ++ptoper;
    oper[ptoper - 1] = cdesig_1.vlmenu;
    cparam[ptoper - 1] = 0;
    return ret_val;
L20:
/*     rayon */
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] > 0.f) {
/*       carcle */
	cdesig_1.numer = bdpec2_1.bd[cdesig_1.adr * 6 + 384];
    } else {
/*       arc */
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 386];
	cdesig_1.numer = sqrt(r__1 * r__1 + r__2 * r__2);
    }
    afcalc_();
    return ret_val;
L21:
/*     longueur */
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -3.f) {
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 386];
	cdesig_1.numer = sqrt(r__1 * r__1 + r__2 * r__2);
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -2.f) {
/*       arc */
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 386];
	cdesig_1.numer = sqrt(r__1 * r__1 + r__2 * r__2) * bdpec2_1.bd[
		cdesig_1.adr * 6 + 389];
    } else {
/*       spline */
	cdesig_1.numer = longsp_(&cdesig_1.adr);
    }
    afcalc_();
    return ret_val;
L22:
/*     angle d'un arc en radiants */
    cdesig_1.numer = bdpec2_1.bd[cdesig_1.adr * 6 + 389];
    afcalc_();
    return ret_val;
L23:
/*     distance:dtp1xx */
    if (savadr == 0) {
	res[0] = 0.f;
	res[1] = savx;
	res[2] = savy;
	if (cdesig_1.adr == 0) {
	    p2[0] = 0.f;
	    p2[1] = cdesig_1.x;
	    p2[2] = cdesig_1.y;
	    cdesig_1.numer = dtp1xx_(res, p2);
	} else {
	    cdesig_1.numer = dtp1xx_(res, &bdpec2_1.bd[cdesig_1.adr * 6 + 384]
		    );
	}
    } else {
	cdesig_1.numer = dtp1xx_(&bdpec2_1.bd[savadr * 6 + 384], &bdpec2_1.bd[
		cdesig_1.adr * 6 + 384]);
    }
    afcalc_();
    return ret_val;
L24:
/*     distance:dtc1c2 */
    cdesig_1.numer = dtc1c2_(&bdpec2_1.bd[savadr * 6 + 384], &bdpec2_1.bd[
	    cdesig_1.adr * 6 + 384]);
    afcalc_();
    return ret_val;
L25:
/*     push_adr */
    savadr = cdesig_1.adr;
    savx = cdesig_1.x;
    savy = cdesig_1.y;
    return ret_val;
L26:
/*     angle_droite (le plus petit angle positif)(en radiants) */
    if (bdpec2_1.bd[savadr * 6 + 384] == -3.f) {
	p1[0] = 0.f;
	p1[1] = bdpec2_1.bd[savadr * 6 + 385];
	p1[2] = bdpec2_1.bd[savadr * 6 + 386];
	p2[0] = 0.f;
	p2[1] = bdpec2_1.bd[savadr * 6 + 387];
	p2[2] = bdpec2_1.bd[savadr * 6 + 388];
	drp1p2_(d1, p1, p2);
    } else {
	d1[0] = -1.f;
	d1[1] = bdpec2_1.bd[savadr * 6 + 385];
	d1[2] = bdpec2_1.bd[savadr * 6 + 386];
	d1[3] = bdpec2_1.bd[savadr * 6 + 387];
    }
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -3.f) {
	p1[0] = 0.f;
	p1[1] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	p1[2] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	p2[0] = 0.f;
	p2[1] = bdpec2_1.bd[cdesig_1.adr * 6 + 387];
	p2[2] = bdpec2_1.bd[cdesig_1.adr * 6 + 388];
	drp1p2_(d2, p1, p2);
    } else {
	d2[0] = -1.f;
	d2[1] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	d2[2] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	d2[3] = bdpec2_1.bd[cdesig_1.adr * 6 + 387];
    }
    cdesig_1.numer = atang2_(&d1[2], &d1[1]) - atang2_(&d2[2], &d2[1]);
    if (cdesig_1.numer < 0.f) {
	cdesig_1.numer += 3.141592653f;
    }
    if (cdesig_1.numer > 1.5707963265f) {
	cdesig_1.numer = 3.141592653f - cdesig_1.numer;
    }
    cdesig_1.numer = cdesig_1.numer;
    afcalc_();
    return ret_val;
L27:
/*     push_coord */
    savadr = 0;
    savx = cdesig_1.x;
    savy = cdesig_1.y;
    return ret_val;
L28:
/*     dtcoord: distance entre (point | coord) et coord */
    if (savadr == 0) {
/* Computing 2nd power */
	r__1 = savx - cdesig_1.x;
/* Computing 2nd power */
	r__2 = savy - cdesig_1.y;
	cdesig_1.numer = sqrt(r__1 * r__1 + r__2 * r__2);
    } else {
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[savadr * 6 + 385] - cdesig_1.x;
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[savadr * 6 + 386] - cdesig_1.y;
	cdesig_1.numer = sqrt(r__1 * r__1 + r__2 * r__2);
    }
    afcalc_();
    return ret_val;
L999:
    --ptstk;
L1000:
    if ((d__1 = rstk[ptstk - 1], abs(d__1)) <= 1e30) {
	cdesig_1.numer = rstk[ptstk - 1];
    } else {
	scrtch_("Overflow dans la calculette, on prend 0", 39L);
	cdesig_1.numer = 0.f;
    }
    afcalc_();
    return ret_val;
} /* calcul_ */




/* Subroutine */ int ccctg3_(real *c1, real *c2, real *c3, doublereal *p, 
	real *c, real *ptg, integer *type, integer *nb)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3, r__4, r__5, r__6, r__7, r__8, r__9;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    doublereal rccc, epsr;
    integer i, j, k, n;
    doublereal r[6]	/* was [2][3] */;
    extern /* Subroutine */ int ptgcc_(real *, real *, real *, real *);
    logical droit;
    integer ii;
    doublereal ccc[12]	/* was [4][3] */;
    integer cas[6]	/* was [2][3] */;
    real det, ctg[4], eps2, ptg1[4], ptg2[4], ptg3[4];
    doublereal dccc;

    /* Fortran I/O blocks */
    /*static*/ cilist io___622 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___623 = { 0, 6, 0, 0, 0 };


/*      integer plus,moins,extern,intern,sens(2,3),inclu(2,3),ni,ns */
/*      parameter (plus=0,moins=1,intern=0,extern=1) */
    /* Parameter adjustments */
    --type;
    ptg -= 24;
    c -= 6;

    /* Function Body */
/* Computing 2nd power */
    r__1 = eps_1.eps;
    eps2 = r__1 * r__1;
    if (p[0] == -1e3) {
	return 0;
    }
    for (i = 0; i <= 3; ++i) {
	ccc[i] = c1[i];
	ccc[i + 4] = c2[i];
	ccc[i + 8] = c3[i];
/* L10: */
    }
    epsr = 0.;
    for (i = 1; i <= 3; ++i) {
	if (ccc[(i << 2) - 4] == -1.) {
	    droit = TRUE_;
	    rccc = 0.f;
	    dccc = -(ccc[(i << 2) - 3] * p[1] + ccc[(i << 2) - 2] * p[2] + 
		    ccc[(i << 2) - 1]);
	} else {
	    droit = FALSE_;
	    rccc = ccc[(i << 2) - 4];
/* Computing 2nd power */
	    d__1 = ccc[(i << 2) - 3] - p[1];
/* Computing 2nd power */
	    d__2 = ccc[(i << 2) - 2] - p[2];
	    dccc = sqrt(d__1 * d__1 + d__2 * d__2);
	}
	if (dccc > rccc) {
	    r[(i << 1) - 2] = dccc - rccc;
	    r[(i << 1) - 1] = dccc + rccc;
	    cas[(i << 1) - 2] = 0;
	    cas[(i << 1) - 1] = 1;
/*          sens(1,i)=moins */
/*          sens(2,i)=plus */
/*          inclu(1,i)=extern */
/*          inclu(2,i)=extern */
	} else {
	    r[(i << 1) - 2] = rccc - dccc;
	    r[(i << 1) - 1] = dccc + rccc;
	    cas[(i << 1) - 2] = 2;
	    cas[(i << 1) - 1] = 1;
/*          sens(1,i)=plus */
/*          sens(2,i)=plus */
/*          inclu(1,i)=intern */
/*          inclu(2,i)=extern */
	}
	if (droit) {
	    r[(i << 1) - 1] = -1.f;
	}
/* Computing MAX */
	d__1 = r[(i << 1) - 2], d__2 = r[(i << 1) - 1], d__1 = max(d__1,d__2);
	epsr = max(d__1,epsr);
/* L20: */
    }
/* Computing MIN */
    d__1 = .01, d__2 = eps_1.eps * epsr;
    epsr = min(d__1,d__2);
/*      print '(1x,a4,1pd10.3,1x,a3,6(1x,1pd15.8))' */
/*     &      ,'eps',epsr,' r = ',r */
    for (i = 1; i <= 2; ++i) {
	if (r[i - 1] >= 0.) {
	    for (j = 1; j <= 2; ++j) {
		if (r[j + 1] >= 0. && (d__1 = r[i - 1] - r[j + 1], abs(d__1)) 
			<= epsr) {
		    for (k = 1; k <= 2; ++k) {
			if (r[k + 3] >= 0. && (d__1 = r[i - 1] - r[k + 3], 
				abs(d__1)) <= epsr) {
/*             ni = inclu(i,1)*4 + inclu(j,2)*2 + 
inclu(k,3) */
/*              ns = sens(i,1)*4 + sens(j,2)*2 + s
ens(k,3) */
			    n = cas[i - 1] * 9 + cas[j + 1] * 3 + cas[k + 3];
/*             calcule de points de tangence */
			    ctg[0] = r[i - 1];
			    ctg[1] = p[1];
			    ctg[2] = p[2];
			    i__1 = *nb;
			    for (ii = 1; ii <= i__1; ++ii) {
/* Computing MAX */
				r__4 = eps2, r__5 = eps_1.eps * ctg[0];
/* Computing MAX */
				r__6 = eps2, r__7 = eps_1.eps * ctg[1];
/* Computing MAX */
				r__8 = eps2, r__9 = eps_1.eps * ctg[2];
				if ((r__1 = ctg[0] - c[ii * 6], dabs(r__1)) <=
					 dmax(r__4,r__5) && (r__2 = ctg[1] - 
					c[ii * 6 + 1], dabs(r__2)) <= dmax(
					r__6,r__7) && (r__3 = ctg[2] - c[ii * 
					6 + 2], dabs(r__3)) <= dmax(r__8,r__9)
					) {
				    return 0;
				}
/* L25: */
			    }
			    ++(*nb);
			    if (*nb > 8) {
				s_wsle(&io___622);
				do_lio(&c__9, &c__1, " ccctgc:c'est ETRANGE "
					"on a plus ", 32L);
				do_lio(&c__9, &c__1, "de 8 solutions (GRAVE "
					"ERREUR)!", 30L);
				e_wsle();
				s_wsle(&io___623);
				do_lio(&c__9, &c__1, " cercle rater = ", 16L);
				do_lio(&c__4, &c__4, (char *)&ctg[0], (ftnlen)
					sizeof(real));
				e_wsle();
				return 0;
			    }
			    ptgcc_(ptg1, ctg, c1, &c_b609);
			    ptgcc_(ptg2, ctg, c2, &c_b609);
			    ptgcc_(ptg3, ctg, c3, &c_b609);
			    det = (ptg2[1] - ptg1[1]) * (ptg3[2] - ptg1[2]) - 
				    (ptg2[2] - ptg1[2]) * (ptg3[1] - ptg1[1]);
			    if (det > 0.f) {
				n = n;
/*               print *,' i,j,k +',i,j,k */
/*     & ,'inclu',ni,inclu(i,1),inclu(j,2),inc
lu(k,3) */
/*     & ,' sens ',ns,sens(i,1),sens(j,2),sens
(k,3),' n = ',ni+1,9+ns */
/*     & ,' cas ',n,cas(i,1),cas(j,2),cas(k,3)
, */
			    } else {
				n += 27;
/*                print *,' i,j,k -',i,j,k */
/*     &   ,'inclu',ni,inclu(i,1),inclu(j,2),i
nclu(k,3) */
/*     &   ,' sens ',ns,sens(i,1),sens(j,2),se
ns(k,3),' n = ',ni+1,15-ns */
/*     &   ,' cas ',n,cas(i,1),cas(j,2),cas(k,
3) */
			    }
			    c[*nb * 6] = ctg[0];
			    c[*nb * 6 + 1] = ctg[1];
			    c[*nb * 6 + 2] = ctg[2];
			    ptg[(*nb * 3 + 1) * 6] = ptg1[0];
			    ptg[(*nb * 3 + 1) * 6 + 1] = ptg1[1];
			    ptg[(*nb * 3 + 1) * 6 + 2] = ptg1[2];
			    ptg[(*nb * 3 + 2) * 6] = ptg2[0];
			    ptg[(*nb * 3 + 2) * 6 + 1] = ptg2[1];
			    ptg[(*nb * 3 + 2) * 6 + 2] = ptg2[2];
			    ptg[(*nb * 3 + 3) * 6] = ptg3[0];
			    ptg[(*nb * 3 + 3) * 6 + 1] = ptg3[1];
			    ptg[(*nb * 3 + 3) * 6 + 2] = ptg3[2];
			    type[*nb] = n;
			}
/* L30: */
		    }
		}
/* L40: */
	    }
	}
/* L50: */
    }
    return 0;
} /* ccctg3_ */

#undef coulls


/* Subroutine */ int ccntc_(real *c, real *cnt, real *c2, integer *nb)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real dd;


/*     c  = cercle de centre cnt et tangent a c2 */
/*     nb = nombre de solutions */



    /* Parameter adjustments */
    c -= 6;

    /* Function Body */
    c[6] = -1e3f;
    c[12] = -1e3f;
    if (c2[0] == -1e3f || cnt[0] != 0.f) {
	return 0;
    }
    c[7] = cnt[1];
    c[8] = cnt[2];
    c[13] = cnt[1];
    c[14] = cnt[2];
    *nb = 1;
    if (c2[0] == 0.f) {
/* Computing 2nd power */
	r__1 = cnt[1] - c2[1];
/* Computing 2nd power */
	r__2 = cnt[2] - c2[2];
	c[6] = sqrt(r__1 * r__1 + r__2 * r__2);
    } else if (c2[0] == -1.f) {
	c[6] = (r__1 = c2[1] * cnt[1] + c2[2] * cnt[2] + c2[3], dabs(r__1));
    } else if (c2[0] >= 0.f) {
/* Computing 2nd power */
	r__1 = cnt[1] - c2[1];
/* Computing 2nd power */
	r__2 = cnt[2] - c2[2];
	dd = sqrt(r__1 * r__1 + r__2 * r__2);
	if (dd <= c2[0]) {
/*         cnt est interieur a c2 (une solution) */
	    c[6] = c2[0] - dd;
	} else {
/*         cnt est exterieur a c2 (2 solutions) */
	    *nb = 2;
	    c[6] = dd - c2[0];
	    c[12] = dd + c2[0];
	}
    }
    return 0;
} /* ccntc_ */

#undef coulls


integer cdaaar_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listea_1.car[listea_1.car[listea_1.car[*l - 1] - 1]
	     - 1] - 1];
    return ret_val;
} /* cdaaar_ */

integer cdaar_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listea_1.car[listea_1.car[*l - 1] - 1] - 1];
    return ret_val;
} /* cdaar_ */

integer cdar_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listea_1.car[*l - 1] - 1];
    return ret_val;
} /* cdar_ */

integer cddddr_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listed_1.cdr[listed_1.cdr[listed_1.cdr[*l - 1] - 1]
	     - 1] - 1];
    return ret_val;
} /* cddddr_ */

integer cdddr_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listed_1.cdr[listed_1.cdr[*l - 1] - 1] - 1];
    return ret_val;
} /* cdddr_ */

integer cddr_(integer *l)
{
    /* System generated locals */
    integer ret_val;

    ret_val = listed_1.cdr[listed_1.cdr[*l - 1] - 1];
    return ret_val;
} /* cddr_ */

/* Subroutine */ int chtrgl_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, j;


/* --------------------------------------------------- */
/*     but : chainage des triangles par sous domaine */
/* --------------------------------------------------- */
    i__1 = bdmsh1_1.nbsd;
    for (i = 1; i <= i__1; ++i) {
	bdmsh2_1.tetsd[i - 1] = 1073741824;
/* L10: */
    }
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	j = bdmsha_1.reft[i - 1];
	bdmsha_1.reft[i - 1] = bdmsh2_1.tetsd[j - 1];
	bdmsh2_1.tetsd[j - 1] = i;
/* L20: */
    }
    i__1 = bdmsh1_1.nbsd;
    for (i = 1; i <= i__1; ++i) {
	if (bdmshj_1.ptorsd[i - 1] == i) {
	    bdmshi_1.strfsd[i - 1] = 1.f;
	} else {
	    bdmsh2_1.tetsd[i - 1] = bdmshj_1.ptorsd[i - 1];
	}
/* L30: */
    }
    return 0;
} /* chtrgl_ */




/* Subroutine */ int clnfnt_(void)
{
    real f[4];
    extern /* Subroutine */ int noirci_(real *), inqfnt_(real *, real *, real 
	    *, real *);

    inqfnt_(f, &f[1], &f[2], &f[3]);
    noirci_(f);
    return 0;
} /* clnfnt_ */

/* Subroutine */ int cmp2d_(doublereal *trf, doublereal *trf0)
{
    integer i, j, k;
    doublereal trf1[9]	/* was [3][3] */;

    /* Parameter adjustments */
    trf0 -= 4;
    trf -= 4;

    /* Function Body */
    for (j = 1; j <= 3; ++j) {
	for (i = 1; i <= 3; ++i) {
	    trf1[i + j * 3 - 4] = 0.f;
	    for (k = 1; k <= 3; ++k) {
		trf1[i + j * 3 - 4] += trf0[i + k * 3] * trf[k + j * 3];
/* L10: */
	    }
/* L20: */
	}
/* L30: */
    }
    for (j = 1; j <= 3; ++j) {
	for (i = 1; i <= 3; ++i) {
	    trf[i + j * 3] = trf1[i + j * 3 - 4];
/* L40: */
	}
/* L50: */
    }
    return 0;
} /* cmp2d_ */

/* Subroutine */ int cnqadd_(doublereal *p3, doublereal *ax, doublereal *a, 
	doublereal *bx, doublereal *b, doublereal *cx, doublereal *c)
{
    p3[0] += *a * *b * *c;
    p3[1] = p3[1] + *ax * *b * *c + *a * *bx * *c + *a * *b * *cx;
    p3[2] = p3[2] + *a * *bx * *cx + *ax * *b * *cx + *ax * *bx * *c;
    p3[3] += *ax * *bx * *cx;
/* ---------------------------------------------------------------------- 
*/
/*      subroutine draw8(c8) */
/*      double precision c8(0:3) */
/*      real c(0:3) */
/*      integer i,j */
/*      i=0 */
/*      if(c8(0).eq.-1.) i=3 */
/*      if(c8(0).ge.0.) i=2 */
/*      if(i.eq.0) return */
/*      do 1 j=0,i */
/*       c(j)=c8(j) */
/* 1     continue */
/*      call draw(c) */
/*      end */
/* ---------------------------------------------------------------------- 
*/
    return 0;
} /* cnqadd_ */

/* Subroutine */ int cnqasy_(doublereal *cnq, doublereal *asymp1, doublereal *
	asymp2)
{
    /* System generated locals */
    real r__1;
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal long_, c[6], d;
    integer i;
    doublereal delta, a1, a2, b1, b2, cnqmx, c1, c2, t1, t2, z1, z2, a11, a12,
	     a21, cc, a22, dd, az, bz, cz;
    doublereal det, eps2;

    /* Parameter adjustments */
    --cnq;

    /* Function Body */
/* Computing 2nd power */
    r__1 = eps_1.eps;
    eps2 = r__1 * r__1;
    cnqmx = 0.f;
    for (i = 1; i <= 6; ++i) {
/* Computing MAX */
	d__2 = cnqmx, d__3 = (d__1 = cnq[i], abs(d__1));
	cnqmx = max(d__2,d__3);
/* L10: */
    }
    asymp1[0] = -1e3f;
    asymp2[0] = -1e3f;
    if (cnqmx <= 1e-20) {
	return 0;
    }
    for (i = 1; i <= 6; ++i) {
	c[i - 1] = cnq[i] / cnqmx;
/* L20: */
    }
/* Computing MAX */
    d__1 = abs(c[0]), d__2 = abs(c[3]), d__1 = max(d__1,d__2), d__2 = abs(c[1]
	    );
/* Computing 2nd power */
    r__1 = eps_1.eps;
    if (max(d__1,d__2) < r__1 * r__1) {
/* Computing 2nd power */
	d__1 = c[4];
/* Computing 2nd power */
	d__2 = c[5];
	long_ = sqrt(d__1 * d__1 + d__2 * d__2);
	if (long_ > eps_1.eps) {
	    asymp1[0] = -1.f;
	    asymp1[1] = c[4] / long_;
	    asymp1[2] = c[5] / long_;
	    asymp1[3] = c[2] / long_;
	}
	return 0;
    }
/*   si on poser */
/*      x = a  t  + c */
/*      y = b  t  + d */
/*      et l'on fait tendre t -> infini alors on a equation suivante : */
/* (1)  cxx a a + cxy a b +cyy b b = 0 */
/*      et : a a + b b = 1 */
    if (abs(c[0]) > abs(c[1])) {
	if (abs(c[0]) <= eps2) {

/*         c(xx) = c(yy) = 0 */

	    a1 = 1.;
	    a2 = 0.;
	    b1 = 0.;
	    b2 = 1.;
	} else {

/*         x = t y */
/*                  2 */
/*         c(xx)   t  + c(xy) t + c(yy) = 0 */

/* Computing 2nd power */
	    d__1 = c[3];
	    delta = d__1 * d__1 - c[0] * 4.f * c[1];
	    if (delta >= -eps2) {
		delta = max(delta,0.);
		delta = sqrt(delta);
		t1 = (-c[3] + delta) * .5f / c[0];
		t2 = (-c[3] - delta) * .5f / c[0];
/* Computing 2nd power */
		d__1 = t1;
		a1 = t1 / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t2;
		a2 = t2 / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t1;
		b1 = 1.f / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t2;
		b2 = 1.f / sqrt(d__1 * d__1 + 1);
	    } else {
		return 0;
	    }
	}
    } else {
	if (abs(c[1]) <= eps2) {

/*         c(yy) = c(xx) = 0 */

	    a1 = 1.;
	    a2 = 0.;
	    b1 = 0.;
	    b2 = 1.;
	} else {

/*        y = t x */
/*                 2 */
/*        c(yy)   t  + c(xy) t + c(xx) = 0 */

/* Computing 2nd power */
	    d__1 = c[3];
	    delta = d__1 * d__1 - c[1] * 4.f * c[0];
	    if (delta >= -eps2) {
		if (delta <= eps2) {
		    delta = 0.;
		}
		delta = sqrt(delta);
		t1 = (-c[3] + delta) * .5f / c[1];
		t2 = (-c[3] - delta) * .5f / c[1];
/* Computing 2nd power */
		d__1 = t1;
		b1 = t1 / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t2;
		b2 = t2 / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t1;
		a1 = 1.f / sqrt(d__1 * d__1 + 1);
/* Computing 2nd power */
		d__1 = t2;
		a2 = 1.f / sqrt(d__1 * d__1 + 1);
	    } else {
		return 0;
	    }
	}
    }
/*    l'equation : */
/*  (2)    cxx 2ac + cxy (ad+bc) + cyy 2bd + cx a + cy b */
/*  (2')   (2a cxx+ b cxy) c + (2b cyy + a cxy) d + cx a+cy b =0 */

    a11 = c[0] * 2 * a1 + c[3] * b1;
    a21 = c[0] * 2 * a2 + c[3] * b2;
    a12 = c[1] * 2 * b1 + c[3] * a1;
    a22 = c[1] * 2 * b2 + c[3] * a2;
    c1 = -(c[4] * a1 + c[5] * b1);
    c2 = -(c[4] * a2 + c[5] * b2);
    det = a11 * a22 - a12 * a21;
/* Computing 2nd power */
    d__1 = eps2;
    if (abs(det) <= d__1 * d__1) {
/*       les doites sont paralleles */
/*       x = a t - b z */
/*       y = b t + a z */
/*       remacque l'equation de la droite est : -b x + a y - z = 0 */
/*       car a a + b b = 1 */
/*       le probleme est trouve z */
/*       l'equation en z est : */
/*                    2              2 */
/*  (3)      cxx(at-bz) + cyy (bt+az) + cxy (at-bz)(bt+az) */

/*          +  cx (at-bz) + c2 (bt +az) + cte = 0 */
/*                     2 */
/*       les termes en t   : */
/*          2       2 */
/*         a cxx + b cyy + ab cxy = 0 d'apres (1) */

/*       les terme en t */
/*                                    2    2 */
/*         ( -2ab  cxx + 2ab  cyy + (a  - b ) cxy ) z */
/*       les termes constants */
/*               2       2              2 */
/*         (cxx b + cyy a  - cxy a b ) z  +(- cx b + cy a) z + cte */

/* Computing 2nd power */
	d__1 = a1;
/* Computing 2nd power */
	d__2 = b1;
	d = a1 * 2.f * b1 * (c[1] - c[0]) + (d__1 * d__1 - d__2 * d__2) * c[3]
		;
	if (abs(d) <= eps_1.eps) {
	    az = c[0] * b1 * b1 + c[1] * a1 * a1 - c[3] * a1 * b1;
	    bz = -c[4] * b1 + c[5] * a1;
	    cz = c[2];
/* Computing 2nd power */
	    d__1 = bz;
	    delta = d__1 * d__1 - az * 4.f * cz;
	    if (delta > -eps2) {
		delta = max(delta,0.);
		delta = sqrt(delta);
		z1 = (-bz + delta) * .5f / az;
		z2 = (-bz - delta) * .5f / az;
		asymp1[0] = -1.f;
		asymp2[0] = -1.f;
		asymp1[1] = -b1;
		asymp2[1] = -b1;
		asymp1[2] = a1;
		asymp2[2] = a1;
		asymp1[3] = -z1;
		asymp2[3] = -z2;
	    }
	}
    } else {
	cc = (c1 * a22 - c2 * a12) / det;
	dd = (a11 * c2 - a21 * c1) / det;
	asymp1[0] = -1.f;
	asymp2[0] = -1.f;
	asymp1[1] = -b1;
	asymp2[1] = -b2;
	asymp1[2] = a1;
	asymp2[2] = a2;
	asymp1[3] = b1 * cc - a1 * dd;
	asymp2[3] = b2 * cc - a2 * dd;
    }
    return 0;
} /* cnqasy_ */

#undef coulls


/* Subroutine */ int cnqcc2_(real *ff1, real *ff2, doublereal *r, doublereal *
	eqc)
{
    /* System generated locals */
    real r__1;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer i;
    doublereal v, a2, b2, c2, f1[4], f2[4], c1[6], v1, v2, dp[4], lx[3], ly[3]
	    , ox, oy;
    extern /* Subroutine */ int cnqsub_(doublereal *, doublereal *, 
	    doublereal *, doublereal *);

/*     in : */
/*      soit hyperbole define par f1 ,f2 ,r si  r < dst(f1,f2) */
/*      telle de  abs(d(f1,m)-d(f2,m))= r */
/*      soit une ellipse */
/*      soit une parabole */
/*      soit 2 droite */
/*     out : */
/*     eqc  est l'equation cartesien de la conique */
/*     eqc(x,y)=eqc(1)*x*x+eqc(2)*y*y+eqc(3)+eqc(4)*x*y+eqc(5)*x+eqc(6)*y 
*/



    /* Parameter adjustments */
    --eqc;

    /* Function Body */
    for (i = 0; i <= 3; ++i) {
	f1[i] = ff1[i];
	f2[i] = ff2[i];
/* L5: */
    }
    for (i = 1; i <= 6; ++i) {
	c1[i - 1] = 0.f;
	eqc[i] = 0.f;
/* L10: */
    }
    if (f1[0] >= 0. && f2[0] >= 0.) {
	v1 = f2[1] - f1[1];
	v2 = f2[2] - f1[2];
/* Computing 2nd power */
	d__1 = v1;
/* Computing 2nd power */
	d__2 = v2;
	v = d__1 * d__1 + d__2 * d__2;
	c2 = v / 4.f;
	a2 = *r * *r / 4.f;
	b2 = c2 - a2;
/*       print *,' foyer 1,2,rayon,distance des foyers:',f1,f2,r,sqrt(
v) */
/*       print *,' a2,b2,c2 =',a2,a2,b2 */
/* Computing 2nd power */
	r__1 = eps_1.eps;
	if (abs(b2) <= r__1 * r__1) {
	    c1[5] = 1.f;
	} else /* if(complicated condition) */ {
/* Computing 2nd power */
	    r__1 = eps_1.eps;
	    if (abs(a2) <= r__1 * r__1) {
		c1[4] = 1.f;
	    } else {
		c1[0] = 1.f / a2;
		c1[1] = -1.f / b2;
		c1[2] = -1.f;
	    }
	}
	lx[0] = -(f1[1] + f2[1]) / 2.f;
	ly[0] = -(f1[2] + f2[2]) / 2.f;
	v = sqrt(v);
	if (v <= eps_1.eps) {
	    lx[1] = 1.f;
	    ly[1] = 0.f;
	    lx[2] = 0.f;
	    ly[2] = 1.f;
	    if (abs(*r) <= eps_1.eps) {
		for (i = 1; i <= 6; ++i) {
		    c1[i - 1] = 0.f;
/* L20: */
		}
	    }
	} else {
	    lx[1] = v1 / v;
	    ly[1] = -v2 / v;
	    lx[2] = -ly[1];
	    ly[2] = lx[1];
	    ox = lx[1] * lx[0] + lx[2] * ly[0];
	    oy = ly[1] * lx[0] + ly[2] * ly[0];
	    lx[0] = ox;
	    ly[0] = oy;
	}
/*       print *,' c1 = ',c1 */
/*       print *,' lx = ',lx */
/*       print *,' ly = ',ly */
	cnqsub_(c1, lx, ly, &eqc[1]);
    } else if (f1[0] == -1. && f2[0] == -1.) {

/*       (f1+f2)(f1-f2) = 0 */

	eqc[1] = (f1[1] + f2[1]) * (f1[1] - f2[1]);
	eqc[2] = (f1[2] + f2[2]) * (f1[2] - f2[2]);
	eqc[3] = (f1[3] + f2[3]) * (f1[3] - f2[3]);
	eqc[4] = (f1[1] + f2[1]) * (f1[2] - f2[2]) + (f1[2] + f2[2]) * (f1[1] 
		- f2[1]);
	eqc[5] = (f1[1] + f2[1]) * (f1[3] - f2[3]) + (f1[3] + f2[3]) * (f1[1] 
		- f2[1]);
	eqc[6] = (f1[2] + f2[2]) * (f1[3] - f2[3]) + (f1[3] + f2[3]) * (f1[2] 
		- f2[2]);
    } else if (f1[0] == -1. && f2[0] >= 0.) {
/*       on a une parabole */
	dp[1] = -f1[2];
	dp[2] = f1[1];
	dp[3] = -(dp[1] * f2[1] - dp[2] * f2[2]);
	b2 = f1[1] * f2[1] + f1[2] * f2[2] + f1[3] + *r;
	c2 = b2 * -.5f;
	c1[1] = 1.;
	c1[4] = c2 * 4.f;
	lx[1] = f1[1];
	lx[2] = f1[2];
	lx[0] = -c2 - (lx[1] * f2[1] + lx[2] * f2[2]);
	ly[1] = -f1[2];
	ly[2] = f1[1];
	ly[0] = -(ly[1] * f2[1] + ly[2] * f2[2]);
	cnqsub_(c1, lx, ly, &eqc[1]);
    } else if (f1[0] >= 0. && f2[0] == -1.) {
/*       on a une parabole */
	b2 = f1[1] * f2[1] + f1[2] * f2[2] + f2[3] + *r;
	c2 = b2 * -.5f;
	c1[1] = 1.;
	c1[4] = c2 * 4.f;
	lx[1] = f2[1];
	lx[2] = f2[2];
	lx[0] = -c2 - (lx[1] * f1[1] + lx[2] * f1[2]);
	ly[1] = -f2[2];
	ly[2] = f2[1];
	ly[0] = -(ly[1] * f1[1] + ly[2] * f1[2]);
	cnqsub_(c1, lx, ly, &eqc[1]);
    }
    return 0;
} /* cnqcc2_ */

#undef coulls


/* Subroutine */ int cnqdrt_(doublereal *cnq, doublereal *d1, doublereal *pt)
{
    /* System generated locals */
    real r__1;
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    doublereal beta;
    extern doublereal cnqp_(doublereal *, doublereal *);
    doublereal a, b, c, d, e, f, gamma, alpha, t1, t2, aa, bb, cc, cc1, cc2;
    doublereal det;

    /* Fortran I/O blocks */
    /*static*/ cilist io___702 = { 0, 6, 0, 0, 0 };



/*     pt = points d'intersections de la conique cnq et de la droite d1 */

/*     la conique est sous le forme homogene */
/*             2          2 */
/*     cnq(1)*x + cnq(2)*y + cnq(3) + cnq(4)*x*y + cnq(5)*x + cnq(6)*y = 
*/
/*     d1 est sous la forme: d1(1)*x + d1(2)*y + d1(3) = 0 */
/*        avec: d1(1)**2 + d1(2)**2 = 1 */



/*      call drawcq(cnq) */
    /* Parameter adjustments */
    pt -= 4;
    --cnq;

    /* Function Body */
    pt[4] = -1e3f;
    pt[8] = -1e3f;
    if (d1[0] == -1e3) {
	return 0;
    }
/*     pour que la conique s'ecrive sous la forme: */
/*        2     2 */
/*     a*x + b*y + c*x*y + d*x + e*y + f */
    a = cnq[1];
    b = cnq[2];
    c = cnq[4];
    d = cnq[5];
    e = cnq[6];
    f = cnq[3];
/*     normalisation de la conique */
/* Computing MAX */
    d__1 = abs(a), d__2 = abs(b), d__1 = max(d__1,d__2), d__2 = abs(c), d__1 =
	     max(d__1,d__2), d__2 = abs(d), d__1 = max(d__1,d__2), d__2 = abs(
	    e), d__1 = max(d__1,d__2), d__2 = abs(f);
    det = max(d__1,d__2);
/* Computing 4th power */
    r__1 = eps_1.eps, r__1 *= r__1;
    if (det <= r__1 * r__1) {
	return 0;
    }
    a /= det;
    b /= det;
    c /= det;
    d /= det;
    e /= det;
    f /= det;
    alpha = d1[1];
    beta = d1[2];
    gamma = d1[3];
/*     d1 est sous la forme: alpha * x + beta * y + gamma = 0 */
/*         avec alpha**2 + beta**2 = 1 */
/*     ou bien sous la forme: */
/*       d = t * v + p */
/*     avec p= -alpha*gamma   et v= -beta */
/*             -beta*gamma          alpha */
/*     si t parametrise la droite d1 sous la forme: */
/*        x= -t * beta  - alpha * gamma */
/*        y=  t * alpha - beta  * gamma */
/*     en reportant ceci dans la conique, */
/*     les coefs de l'equation du 2 ieme degre en t sont: */
/*         2 */
/*     aa*t + bb*t + cc=0 */

/* Computing 2nd power */
    d__1 = beta;
/* Computing 2nd power */
    d__2 = alpha;
    aa = d__1 * d__1 * a + d__2 * d__2 * b - alpha * beta * c;
/* Computing 2nd power */
    d__1 = beta;
/* Computing 2nd power */
    d__2 = alpha;
    bb = alpha * 2.f * beta * gamma * (a - b) + gamma * c * (d__1 * d__1 - 
	    d__2 * d__2) - beta * d + alpha * e;
/* Computing 2nd power */
    d__1 = gamma;
/* Computing 2nd power */
    d__2 = alpha;
/* Computing 2nd power */
    d__3 = beta;
    cc = d__1 * d__1 * (d__2 * d__2 * a + d__3 * d__3 * b + alpha * beta * c) 
	    - alpha * gamma * d - beta * gamma * e + f;
/* Computing MAX */
    d__1 = abs(aa), d__2 = abs(bb), d__1 = max(d__1,d__2), d__2 = abs(cc);
    det = max(d__1,d__2);
/* Computing 4th power */
    r__1 = eps_1.eps, r__1 *= r__1;
    if (det < r__1 * r__1) {
	return 0;
    }
    aa /= det;
    bb /= det;
    cc /= det;
/* Computing 2nd power */
    r__1 = eps_1.eps;
    if (abs(aa) < r__1 * r__1) {
/*       equation degeneree de degre 1 */
/* Computing 2nd power */
	r__1 = eps_1.eps;
	if (abs(bb) < r__1 * r__1) {
	    return 0;
	} else {
	    t1 = -cc / bb;
	    t2 = t1;
	}
    } else {
/* Computing 2nd power */
	d__1 = bb;
	det = d__1 * d__1 - aa * 4.f * cc;
	if (det >= 0.) {
/*         2 racines */
	    det = sqrt(det);
	    t1 = (-bb + det) / (aa * 2.f);
	    t2 = (-bb - det) / (aa * 2.f);
	} else {
/*         pas de racines reelles */
	    return 0;
	}
    }

/*     d'ou les 2 points d'intersections: */
    pt[4] = 0.f;
    pt[5] = -(alpha * gamma + t1 * beta);
    pt[6] = t1 * alpha - beta * gamma;
    pt[8] = 0.f;
    pt[9] = -(alpha * gamma + t2 * beta);
    pt[10] = t2 * alpha - beta * gamma;
/*     verif si les points sont sur la conique */
    cc1 = cnqp_(&cnq[1], &pt[4]);
    cc2 = cnqp_(&cnq[1], &pt[8]);
/* Computing MAX */
    d__1 = abs(cc1), d__2 = abs(cc2);
    if (max(d__1,d__2) > eps_1.eps) {
	s_wsle(&io___702);
	do_lio(&c__9, &c__1, "ecart des points de la conique", 30L);
	do_lio(&c__5, &c__1, (char *)&cc1, (ftnlen)sizeof(doublereal));
	do_lio(&c__5, &c__1, (char *)&cc2, (ftnlen)sizeof(doublereal));
	e_wsle();
    }
    return 0;
} /* cnqdrt_ */

#undef coulls


/* Subroutine */ int cnqint_(doublereal *cc1, doublereal *cc2, doublereal *
	int_)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;
    doublereal d__1, d__2, d__3, d__4, d__5, d__6;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern doublereal cnqp_(doublereal *, doublereal *);
    doublereal pmax;
    extern /* Subroutine */ int pa03ad_(doublereal *, doublereal *, integer *)
	    ;
    integer i, k;
    doublereal c1[6], c2[6], q1, p3[4], q2, w1, w2, ca[6], cd[6];
    integer nb;
    extern /* Subroutine */ int cnqadd_(doublereal *, doublereal *, 
	    doublereal *, doublereal *, doublereal *, doublereal *, 
	    doublereal *);
    doublereal rr[3];
    extern /* Subroutine */ int cnqdrt_(doublereal *, doublereal *, 
	    doublereal *), cnqasy_(doublereal *, doublereal *, doublereal *);
    doublereal c1p, c2p, c1mx, c2mx, asy1[4], asy2[4];

    /* Fortran I/O blocks */
    /*static*/ cilist io___723 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___724 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___725 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___726 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___727 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___728 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___729 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    int_ -= 4;
    --cc2;
    --cc1;

    /* Function Body */
    for (i = 1; i <= 4; ++i) {
	int_[i * 4] = -1e3f;
/* L10: */
    }
    c1mx = 0.;
    c2mx = 0.;
    for (i = 1; i <= 6; ++i) {
/* Computing MAX */
	d__2 = (d__1 = cc1[i], abs(d__1));
	c1mx = max(d__2,c1mx);
/* Computing MAX */
	d__2 = (d__1 = cc2[i], abs(d__1));
	c2mx = max(d__2,c2mx);
/* L20: */
    }
/* Computing 3rd power */
    r__1 = eps_1.eps, r__2 = r__1;
    if (min(c1mx,c2mx) <= r__2 * (r__1 * r__1)) {
	return 0;
    }
    for (i = 1; i <= 6; ++i) {
	c1[i - 1] = cc1[i] / c1mx;
	c2[i - 1] = cc2[i] / c2mx;
/* L30: */
    }
    p3[0] = 0.f;
    p3[1] = 0.f;
    p3[2] = 0.f;
    p3[3] = 0.f;
    cnqadd_(p3, c1, c2, &c1[1], &c2[1], &c1[2], &c2[2]);
    d__1 = c1[3] * .5f;
    d__2 = c2[3] * .5f;
    d__3 = c1[4] * .5f;
    d__4 = c2[4] * .5f;
    d__5 = c1[5] * .5f;
    d__6 = c2[5] * .5f;
    cnqadd_(p3, &d__1, &d__2, &d__3, &d__4, &d__5, &d__6);
    d__1 = c1[5] * .5f;
    d__2 = c2[5] * .5f;
    d__3 = c1[3] * .5f;
    d__4 = c2[3] * .5f;
    d__5 = c1[4] * .5f;
    d__6 = c2[4] * .5f;
    cnqadd_(p3, &d__1, &d__2, &d__3, &d__4, &d__5, &d__6);
    d__1 = c1[4] * -.5f;
    d__2 = c2[4] * -.5f;
    d__3 = c1[4] * .5f;
    d__4 = c2[4] * .5f;
    cnqadd_(p3, &d__1, &d__2, &c1[1], &c2[1], &d__3, &d__4);
    d__1 = c1[5] * -.5f;
    d__2 = c2[5] * -.5f;
    d__3 = c1[5] * .5f;
    d__4 = c2[5] * .5f;
    cnqadd_(p3, &d__1, &d__2, &d__3, &d__4, c1, c2);
    d__1 = -c1[2];
    d__2 = -c2[2];
    d__3 = c1[3] * .5f;
    d__4 = c2[3] * .5f;
    d__5 = c1[3] * .5f;
    d__6 = c2[3] * .5f;
    cnqadd_(p3, &d__1, &d__2, &d__3, &d__4, &d__5, &d__6);
    nb = 0;
/* Computing MAX */
    d__1 = abs(p3[0]), d__2 = abs(p3[1]), d__1 = max(d__1,d__2), d__2 = abs(
	    p3[2]), d__1 = max(d__1,d__2), d__2 = abs(p3[3]);
    pmax = max(d__1,d__2);
/* Computing 2nd power */
    r__1 = eps_1.eps;
/* Computing 3rd power */
    r__2 = eps_1.eps, r__3 = r__2;
    if (abs(p3[3]) > r__1 * r__1 * pmax && pmax > r__3 * (r__2 * r__2)) {
	pa03ad_(p3, rr, &nb);
    }
/*      print *,' p3 = ',p3,' nb zero =',nb,(rr(i),i=1,nb) */
    if (nb > 0) {
	q1 = rr[min(nb,2) - 1];
	q2 = 1.;
	w1 = 1.;
	w2 = 0.;
    } else {
	q1 = 1.;
	q2 = 0.;
	w1 = 0.;
	w2 = 1.;
    }
/*     la conique degenere cd a pour equation :  q1*c1 + q2*c2 = 0. */
    for (i = 1; i <= 6; ++i) {
	cd[i - 1] = q1 * c1[i - 1] + q2 * c2[i - 1];
	ca[i - 1] = w1 * c1[i - 1] + w2 * c2[i - 1];
/* L50: */
    }
/*     ca est une conique du faiseau genere par c1,c2 differente de cd */
    cnqasy_(cd, asy1, asy2);
/*      call drawcq (cd) */
/*      call drawcq (ca) */
/*      if(asy1(0).eq.vide.or.asy2(0).eq.vide) then */
/*        print *,' une des deux asymptote est vide ' */
/*        print *, asy1(0),asy2(0) */
/*        call drawcq(cd) */
/*        print *,' conique =',cd */
/*      endif */
/*      print *, asy1(0),asy2(0) */
/*      call draw8(asy1) */
/*      call draw8(asy2) */
    cnqdrt_(ca, asy1, &int_[4]);
    cnqdrt_(ca, asy2, &int_[12]);
    for (i = 1; i <= 4; ++i) {
	if (int_[i * 4] == 0.) {
	    c1p = cnqp_(c1, &int_[i * 4]);
	    c2p = cnqp_(c2, &int_[i * 4]);
/* Computing MAX */
	    d__1 = abs(c1p), d__2 = abs(c2p);
	    if (max(d__1,d__2) >= eps_1.eps) {
		s_wsle(&io___723);
		do_lio(&c__9, &c__1, " cnqint :", 9L);
		do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " ecart = ", 9L);
		do_lio(&c__5, &c__1, (char *)&c1p, (ftnlen)sizeof(doublereal))
			;
		do_lio(&c__5, &c__1, (char *)&c2p, (ftnlen)sizeof(doublereal))
			;
		e_wsle();
/*          call drawcq(cd) */
		s_wsle(&io___724);
		do_lio(&c__9, &c__1, " cd = ", 6L);
		do_lio(&c__5, &c__6, (char *)&cd[0], (ftnlen)sizeof(
			doublereal));
		e_wsle();
		s_wsle(&io___725);
		do_lio(&c__9, &c__1, " c1 = ", 6L);
		do_lio(&c__5, &c__6, (char *)&cc1[1], (ftnlen)sizeof(
			doublereal));
		e_wsle();
		s_wsle(&io___726);
		do_lio(&c__9, &c__1, " c2 = ", 6L);
		do_lio(&c__5, &c__6, (char *)&cc2[1], (ftnlen)sizeof(
			doublereal));
		e_wsle();
		s_wsle(&io___727);
		do_lio(&c__5, &c__4, (char *)&asy1[0], (ftnlen)sizeof(
			doublereal));
		e_wsle();
		s_wsle(&io___728);
		do_lio(&c__5, &c__4, (char *)&asy2[0], (ftnlen)sizeof(
			doublereal));
		e_wsle();
		s_wsle(&io___729);
		do_lio(&c__9, &c__1, " p3 = ", 6L);
		do_lio(&c__5, &c__4, (char *)&p3[0], (ftnlen)sizeof(
			doublereal));
		do_lio(&c__9, &c__1, " nb zero =", 10L);
		do_lio(&c__3, &c__1, (char *)&nb, (ftnlen)sizeof(integer));
		i__1 = nb;
		for (k = 1; k <= i__1; ++k) {
		    do_lio(&c__5, &c__1, (char *)&rr[k - 1], (ftnlen)sizeof(
			    doublereal));
		}
		e_wsle();
	    }
	}
/* L100: */
    }
    return 0;
} /* cnqint_ */

#undef coulls


doublereal cnqp_(doublereal *cnp, doublereal *p)
{
    /* System generated locals */
    doublereal ret_val, d__1, d__2;

    /* Local variables */
    doublereal d;
    integer i;
    doublereal cnq[6];


/*     rend la valeur de la conique pour le point p */

    /* Parameter adjustments */
    --cnp;

    /* Function Body */
    ret_val = 0.f;
    if (p[0] == -1e3) {
	return ret_val;
    }
/* Computing MAX */
    d__1 = abs(cnp[1]), d__2 = abs(cnp[2]), d__1 = max(d__1,d__2), d__2 = abs(
	    cnp[3]), d__1 = max(d__1,d__2), d__2 = abs(cnp[4]), d__1 = max(
	    d__1,d__2), d__2 = abs(cnp[5]), d__1 = max(d__1,d__2), d__2 = abs(
	    cnp[6]);
    d = max(d__1,d__2);
    if (d == 0.) {
	ret_val = 0.f;
	return ret_val;
    }
    for (i = 1; i <= 6; ++i) {
	cnq[i - 1] = cnp[i] / d;
/* L1: */
    }
/* Computing 2nd power */
    d__1 = p[1];
/* Computing 2nd power */
    d__2 = p[2];
    ret_val = cnq[0] * (d__1 * d__1) + cnq[1] * (d__2 * d__2) + cnq[2] + cnq[
	    3] * p[1] * p[2] + cnq[4] * p[1] + cnq[5] * p[2];
    return ret_val;
} /* cnqp_ */

#undef coulls


/* Subroutine */ int cnqsu1_(doublereal *c, doublereal *a, doublereal *l1, 
	doublereal *l2)
{
    /* Parameter adjustments */
    --c;

    /* Function Body */
    c[1] += *a * (l1[1] * l2[1]);
    c[2] += *a * (l1[2] * l2[2]);
    c[3] += *a * (l1[0] * l2[0]);
    c[4] += *a * (l1[1] * l2[2] + l1[2] * l2[1]);
    c[5] += *a * (l1[1] * l2[0] + l1[0] * l2[1]);
    c[6] += *a * (l1[2] * l2[0] + l1[0] * l2[2]);
    return 0;
} /* cnqsu1_ */

/* Subroutine */ int cnqsub_(doublereal *c1, doublereal *lx, doublereal *ly, 
	doublereal *c2)
{
    /* Initialized data */

    /*static*/ doublereal un[3] = { 1.,0.,0. };

    integer i;
    extern /* Subroutine */ int cnqsu1_(doublereal *, doublereal *, 
	    doublereal *, doublereal *);

/* -----------------------------------------------------------------------
 */
/* in : */
/*      c1 (x,y)=c1(1)*x**2+c1(2)*y**2+c1(3)+c1(4)*x*y+c1(5)*x+c1(6)*y */
/*      lx(x,y) = lx(0) + lx(1)*x + lx(2)*y */
/*      ly(x,y) = ly(0) + ly(1)*x + ly(2)*y */
/* out: */
/*      c2(x,y)=c1(lx(x,y),ly(x,y)) */
/*      c2 (x,y)=c2(1)*x*y+c2(2)*y*y+c2(3)+c2(4)*x*y+c2(5)*x+c2(6)*y */
/* -----------------------------------------------------------------------
 */
    /* Parameter adjustments */
    --c2;
    --c1;

    /* Function Body */
    for (i = 1; i <= 6; ++i) {
	c2[i] = 0.f;
/* L10: */
    }
    cnqsu1_(&c2[1], &c1[1], lx, lx);
    cnqsu1_(&c2[1], &c1[2], ly, ly);
    cnqsu1_(&c2[1], &c1[3], un, un);
    cnqsu1_(&c2[1], &c1[4], lx, ly);
    cnqsu1_(&c2[1], &c1[5], lx, un);
    cnqsu1_(&c2[1], &c1[6], ly, un);
    return 0;
} /* cnqsub_ */

/***************************************************************************************/
int constr2_75(real res[96],real stack[36],integer padr[16],real pttg[288],integer tnum[8])
{
integer k,i,libre,nbsol;
real ang1,ang2,ang3,dx,dy,rapp,epsr;
logical bool1;
integer i__1;
 real r__1,r__2;
    extern logical drawp_(real *), draws_(real *);
    extern integer  alloc_(void);
    extern int ctgccc_(real *, real *,  real *, real *, real *, integer *, integer *),
           drawad_(integer *, integer *);
    extern doublereal atang2_(real *, real *);
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sqrt(doublereal), r_mod(real *, real *);
    integer f_inqu(inlist *), s_rsle(cilist *), e_rsle(void), f_clos(cllist *)
	    , i_nint(real *);
    double cos(doublereal), sin(doublereal), pow_ri(real *, integer *);
    
    /*static*/ cilist io___803 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___804 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___805 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___806 = { 0, 6, 0, 0, 0 };

/* OLD -- VERSION */
/* -OLDc        interpolation_arcs */
/* -OLD         k=min(nombre+2,mxnode/2) */
/* -OLD         j =min(k,nombre) */
/* -OLDc        prends les extremitees  1 des 2 arcs */
/* -OLD         res(0,1)=segmen */
/* -OLD         res(1,1)=bd(3,padr(1)) */
/* -OLD         res(2,1)=bd(4,padr(1)) */
/* -OLD         res(3,1)=bd(3,padr(2)) */
/* -OLD         res(4,1)=bd(4,padr(2)) */
/* -OLD         call gnin(res(0,1),xc(1),yc(1),k,raport) */
/* -OLDc        prends les milieux des 2 arcs */
/* -OLD         res(0,1)=segmen */
/* -OLD         i=padr(1) */
/* -OLD         ang1=bd(5,i)*0.5 */
/* -OLD         dx=bd(3,i)-bd(1,i) */
/* -OLD         dy=bd(4,i)-bd(2,i) */
/* -OLD         res(1,1)=bd(1,i)+dx*cos(ang1) - dy*sin(ang1) */
/* -OLD         res(2,1)=bd(2,i)+dx*sin(ang1) + dy*cos(ang1) */
/* -OLD         i=padr(2) */
/* -OLD         ang1=bd(5,i)*0.5 */
/* -OLD         dx=bd(3,i)-bd(1,i) */
/* -OLD         dy=bd(4,i)-bd(2,i) */
/* -OLD         res(3,1)=bd(1,i)+dx*cos(ang1) - dy*sin(ang1) */
/* -OLD         res(4,1)=bd(2,i)+dx*sin(ang1) + dy*cos(ang1) */
/* -OLD         call gnin(res(0,1),xc(1+j),yc(1+j),k,raport) */
/* -OLDc        prends les extremitees 2 des 2 arcs */
/* -OLD         i=padr(1) */
/* -OLD         ang1=bd(5,i) */
/* -OLD         dx=bd(3,i)-bd(1,i) */
/* -OLD         dy=bd(4,i)-bd(2,i) */
/* -OLD         res(1,1)=bd(1,i)+dx*cos(ang1) - dy*sin(ang1) */
/* -OLD         res(2,1)=bd(2,i)+dx*sin(ang1) + dy*cos(ang1) */
/* -OLD         i=padr(2) */
/* -OLD         ang1=bd(5,i) */
/* -OLD         dx=bd(3,i)-bd(1,i) */
/* -OLD         dy=bd(4,i)-bd(2,i) */
/* -OLD         res(3,1)=bd(1,i)+dx*cos(ang1) - dy*sin(ang1) */
/* -OLD         res(4,1)=bd(2,i)+dx*sin(ang1) + dy*cos(ang1) */
/* -OLD         call gnin(res(0,1),xc(1+2*j),yc(1+2*j),k,raport) */
/* -OLDc        creation des j arcs intermediaires passant par i,i+j,i+2*j
 */
/* -OLD         do 7501 i=1,j */
/* -OLD           libre=alloc() */
/* -OLD           adr=libre */
/* -OLD           if(adr.eq.nil)then */
/* -OLD             return */
/* -OLD           endif */
/* -OLD           rais(1)=xc(i) */
/* -OLD           rais(2)=yc(i) */
/* -OLD           rais(3)=xc(i+j) */
/* -OLD           rais(4)=yc(i+j) */
/* -OLD           rais(5)=xc(i+2*j) */
/* -OLD           rais(6)=yc(i+2*j) */
/* -OLD           call arc3p(rais(1),rais(3),rais(5),bd(1,libre)) */
/* -OLD           bd(0,libre)=arc */
/* -OLD           raison(libre)       =raison(padr(1)) */
/* -OLD           nuref(gauche,libre) =nuref (gauche,padr(1)) */
/* -OLD           nuref1(gauche,libre)=nuref1(gauche,padr(1)) */
/* -OLD           nuref2(gauche,libre)=nuref2(gauche,padr(1)) */
/* -OLD           nuref(droit,libre)  =nuref (droit,padr(1)) */
/* -OLD           nuref1(droit,libre) =nuref1(droit,padr(1)) */
/* -OLD           nuref2(droit,libre) =nuref2(droit,padr(1)) */
/* -OLD           nbnode(libre)       =nbnode(padr(1)) */
/* -OLD           call drawad(libre,0) */
/* -OLD7501     continue */
/* --- NEW VERSION F. Hecht -------- */
/*        interpolation_arcs */
    k = etat_1.nombre + 2;
/*        calcule de ext arc et mileux --- */
/*         res(0,1)=segmen */
/*        les extermite 1 */
    i = padr[0];
    ang2 = bdpec2_1.bd[i * 6 + 389] * .5f;
    ang3 = bdpec2_1.bd[i * 6 + 389];
    dx = bdpec2_1.bd[i * 6 + 387] - bdpec2_1.bd[i * 6 + 385];
    dy = bdpec2_1.bd[i * 6 + 388] - bdpec2_1.bd[i * 6 + 386];
    res[1] = bdpec2_1.bd[i * 6 + 387];
    res[2] = bdpec2_1.bd[i * 6 + 388];
    res[7] = bdpec2_1.bd[i * 6 + 385] + dx * cos(ang2) - dy * sin(ang2);
    res[8] = bdpec2_1.bd[i * 6 + 386] + dx * sin(ang2) + dy * cos(ang2);
    res[13] = bdpec2_1.bd[i * 6 + 385] + dx * cos(ang3) - dy * sin(ang3);
    res[14] = bdpec2_1.bd[i * 6 + 386] + dx * sin(ang3) + dy * cos(ang3);
    i = padr[1];
    ang2 = bdpec2_1.bd[i * 6 + 389] * .5f;
    ang3 = bdpec2_1.bd[i * 6 + 389];
    dx = bdpec2_1.bd[i * 6 + 387] - bdpec2_1.bd[i * 6 + 385];
    dy = bdpec2_1.bd[i * 6 + 388] - bdpec2_1.bd[i * 6 + 386];
    res[3] = bdpec2_1.bd[i * 6 + 387];
    res[4] = bdpec2_1.bd[i * 6 + 388];
    res[9] = bdpec2_1.bd[i * 6 + 385] + dx * cos(ang2) - dy * sin(ang2);
    res[10] = bdpec2_1.bd[i * 6 + 386] + dx * sin(ang2) + dy * cos(ang2);
    res[15] = bdpec2_1.bd[i * 6 + 385] + dx * cos(ang3) - dy * sin(ang3);
    res[16] = bdpec2_1.bd[i * 6 + 386] + dx * sin(ang3) + dy * cos(ang3);
    bool1 = draws_(res);
    bool1 = draws_(&res[6]);
    bool1 = draws_(&res[12]);
    if ((r__1 = etat_1.raport - 1, dabs(r__1)) <= .001f) {
	rapp = 1.f / (etat_1.nombre + 1);
    } else {
	i__1 = etat_1.nombre + 1;
	rapp = (etat_1.raport - 1.f) / (pow_ri(&etat_1.raport, &i__1) - 1.f);
    }
    res[0] = 0.f;
    res[6] = 0.f;
    res[12] = 0.f;
    res[19] = (res[3] - res[1]) * rapp;
    res[20] = (res[4] - res[2]) * rapp;
    res[25] = (res[9] - res[7]) * rapp;
    res[26] = (res[10] - res[8]) * rapp;
    res[31] = (res[15] - res[13]) * rapp;
    res[32] = (res[16] - res[14]) * rapp;
    res[18] = (bdpec4_1.raison[padr[1] + 64] - bdpec4_1.raison[padr[0] + 64]) 
	    * rapp;
    res[24] = (bdpec3_1.nbnode[padr[1] + 64] - bdpec3_1.nbnode[padr[0] + 64]) 
	    * rapp;
    res[22] = bdpec4_1.raison[padr[0] + 64];
    res[29] = (real) bdpec3_1.nbnode[padr[0] + 64];
/* -------------- */
    i__1 = etat_1.nombre;
    for (i = 1; i <= i__1; ++i) {
	res[1] += res[19];
	res[2] += res[20];
	res[7] += res[25];
	res[8] += res[26];
	res[13] += res[31];
	res[14] += res[32];
	res[22] += res[18];
	res[22] += res[18];
	res[29] += res[24];
	bool1 = drawp_(res);
	bool1 = drawp_(&res[6]);
	bool1 = drawp_(&res[12]);
/* ------------ */
	res[19] *= etat_1.raport;
	res[20] *= etat_1.raport;
	res[25] *= etat_1.raport;
	res[26] *= etat_1.raport;
	res[31] *= etat_1.raport;
	res[32] *= etat_1.raport;
	res[18] *= etat_1.raport;
	res[24] *= etat_1.raport;
	libre = alloc_();
	cdesig_1.adr = libre;
	if (cdesig_1.adr == 0) {
	    return ;
	}
/* Computing MAX */
	r__1 = dabs(res[1]), r__2 = dabs(res[2]), r__1 = max(r__1,r__2), r__2 
		= dabs(res[7]), r__1 = max(r__1,r__2), r__2 = dabs(res[8]), 
		r__1 = max(r__1,r__2), r__2 = dabs(res[13]), r__1 = max(r__1,
		r__2), r__2 = dabs(res[14]);
	epsr = dmax(r__1,r__2) * .001f;
	if ((r__1 = res[1] - res[7], dabs(r__1)) < epsr && (r__2 = res[2] - 
		res[8], dabs(r__2)) < epsr) {
/*               2 premiers points confondus ( demi cercle positif
) */
	    ang3 = 3.141592653f;
	    bdpec2_1.bd[libre * 6 + 384] = -2.f;
	    bdpec2_1.bd[libre * 6 + 385] = (res[1] + res[13]) * .5f;
	    bdpec2_1.bd[libre * 6 + 386] = (res[2] + res[14]) * .5f;
	    bdpec2_1.bd[libre * 6 + 387] = res[1];
	    bdpec2_1.bd[libre * 6 + 388] = res[2];
	    bdpec2_1.bd[libre * 6 + 389] = ang3;
	} else if ((r__1 = res[13] - res[7], dabs(r__1)) < epsr && (r__2 = 
		res[14] - res[8], dabs(r__2)) < epsr) {
/*               2 derniers points confondus ( demi cercle negatif
) */
	    ang3 = -3.141592653f;
	    bdpec2_1.bd[libre * 6 + 384] = -2.f;
	    bdpec2_1.bd[libre * 6 + 385] = (res[1] + res[13]) * .5f;
	    bdpec2_1.bd[libre * 6 + 386] = (res[2] + res[14]) * .5f;
	    bdpec2_1.bd[libre * 6 + 387] = res[1];
	    bdpec2_1.bd[libre * 6 + 388] = res[2];
	    bdpec2_1.bd[libre * 6 + 389] = ang3;
	} else if ((r__1 = res[13] - res[1], dabs(r__1)) < epsr && (r__2 = 
		res[14] - res[2], dabs(r__2)) < epsr) {
/*               premier et dernier point confondus (arc d'angle 2
*pi) */
	    ang3 = 6.283185306f;
	    bdpec2_1.bd[libre * 6 + 384] = -2.f;
	    bdpec2_1.bd[libre * 6 + 385] = (res[1] + res[7]) * .5f;
	    bdpec2_1.bd[libre * 6 + 386] = (res[2] + res[8]) * .5f;
	    bdpec2_1.bd[libre * 6 + 387] = res[1];
	    bdpec2_1.bd[libre * 6 + 388] = res[2];
	    bdpec2_1.bd[libre * 6 + 389] = ang3;
	} else {
	    ctgccc_(&res[36], res, &res[6], &res[12], pttg, tnum, &nbsol);
	    if (nbsol >= 1 && res[36] > 0.f) {
		bdpec2_1.bd[libre * 6 + 384] = -2.f;
		bdpec2_1.bd[libre * 6 + 385] = res[37];
		bdpec2_1.bd[libre * 6 + 386] = res[38];
		bdpec2_1.bd[libre * 6 + 387] = res[1];
		bdpec2_1.bd[libre * 6 + 388] = res[2];
		ang2 = 0.f;
		r__1 = res[2] - res[38];
		r__2 = res[1] - res[37];
		ang1 = atang2_(&r__1, &r__2);
		r__1 = res[8] - res[38];
		r__2 = res[7] - res[37];
		ang2 = atang2_(&r__1, &r__2) - ang1;
		r__1 = res[14] - res[38];
		r__2 = res[13] - res[37];
		ang3 = atang2_(&r__1, &r__2) - ang1;
/*            print *,ang2,ang3 */
		r__1 = ang2 + 12.566370612f;
		ang2 = r_mod(&r__1, &c_b28);
		r__1 = ang3 + 12.566370612f;
		ang3 = r_mod(&r__1, &c_b28);
		if (ang2 < 0.f) {
		    ang2 += 6.283185306f;
		}
		if (ang3 < 0.f) {
		    ang3 += 6.283185306f;
		}
/*            print *,ang2,ang3 */
		if (ang2 > ang3) {
		    ang3 += -6.283185306f;
		}
		bdpec2_1.bd[libre * 6 + 389] = ang3;
	    } else {
		s_wsle(&io___803);
		do_lio(&c__9, &c__1, " ERREUR construction arc3p --> segment"
			" ? ", 41L);
		e_wsle();
		s_wsle(&io___804);
		do_lio(&c__4, &c__1, (char *)&res[1], (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&res[2], (ftnlen)sizeof(real));
		e_wsle();
		s_wsle(&io___805);
		do_lio(&c__4, &c__1, (char *)&res[7], (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&res[8], (ftnlen)sizeof(real));
		e_wsle();
		s_wsle(&io___806);
		do_lio(&c__4, &c__1, (char *)&res[13], (ftnlen)sizeof(real));
		do_lio(&c__4, &c__1, (char *)&res[14], (ftnlen)sizeof(real));
		e_wsle();
		bdpec2_1.bd[libre * 6 + 384] = -3.f;
		bdpec2_1.bd[libre * 6 + 385] = res[1];
		bdpec2_1.bd[libre * 6 + 386] = res[2];
		bdpec2_1.bd[libre * 6 + 387] = res[13];
		bdpec2_1.bd[libre * 6 + 388] = res[14];
	    }
	}
	bdpec4_1.raison[libre + 64] = res[22];
	bdpec5_1.nuref[(libre << 1) + 128] = bdpec5_1.nuref[(padr[0] << 1) + 
		128];
	bdpec6_1.nuref1[(libre << 1) + 128] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 128];
	bdpec7_1.nuref2[(libre << 1) + 128] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 128];
	bdpec5_1.nuref[(libre << 1) + 129] = bdpec5_1.nuref[(padr[0] << 1) + 
		129];
	bdpec6_1.nuref1[(libre << 1) + 129] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 129];
	bdpec7_1.nuref2[(libre << 1) + 129] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 129];
	bdpec3_1.nbnode[libre + 64] = i_nint(&res[29]);
	drawad_(&libre, &c__0);
/* L7501: */
    }
}

integer cnstr2_(integer *act)
{
    /* System generated locals */
    integer ret_val, i__1, i__2, i__3;
    real r__1, r__2, r__3, r__4;
    cllist cl__1;
    inlist ioin__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sqrt(doublereal), r_mod(real *, real *);
    integer f_inqu(inlist *), s_rsle(cilist *), e_rsle(void), f_clos(cllist *)
	    , i_nint(real *);
    double cos(doublereal), sin(doublereal), pow_ri(real *, integer *);

    /* Local variables */
    extern /* Subroutine */ int afmenu_(integer *), scrtch_(char *, ftnlen), 
	    itspxx_(real *, real *, real *, integer *, integer *, integer *, 
	    integer *), drawad_(integer *, integer *), ptgcc_(real *, real *, 
	    real *, real *), cr8_(real *, real *, real *, real *, real *, 
	    integer *, integer *, real *, real *), ctgccc_(real *, real *, 
	    real *, real *, real *, integer *, integer *), degen_(integer *), 
	    invers_(integer *), cutpc_(real *, integer *, real *, real *, 
	    integer *, integer *, integer *, integer *);
    static integer nbnd[16];
    extern /* Subroutine */ int dumpad_(integer *), acnt_(real *, real *);
    extern integer cons_(integer *, integer *), last_(integer *);
    static real dist, rais[16], rapp;
    static integer nurf[32]	/* was [2][16] */, padr[16];
    static real * pttg=0	/* was [6][3][16] */, epsr;
    static integer tnum[8], nfpt;
    static logical bool;
    static integer numn;
    extern /* Subroutine */ int draw_(real *), intext_(char *, integer *, 
	    char *, integer *, ftnlen, ftnlen), gnin_(real *, real *, real *, 
	    integer *, real *), rtbd_(integer *, real *), extrm2_(integer *, 
	    real *, real *, real *, real *), afetat_(void), ptangc_(real *, 
	    real *, integer *, real *), menumk_(integer *, integer *, integer 
	    *), ligh3_(integer *, integer *, integer *);
    static logical bool1;
    extern /* Subroutine */ int pjp1d_(real *, real *, real *, real *);
    static real dist2;
    static integer nurf1[32]	/* was [2][16] */, nurf2[32]	/* was [2][16]
	     */;

    extern doublereal atang2_(real *, real *);
    extern integer fndrs_(integer *, integer *), fndra_(integer *, integer *),
	     alloc_(void);
    static real stack[36]	/* was [6][6] */, desig[18]	/* was [6][3] 
	    */;
    static integer cnstr[3], solut, libre, i, j, k, nbsol;
    extern logical drawp_(real *), draws_(real *);
    static integer mkcas1, mkcas2, mkcas3;
    extern /* Subroutine */ int drp1p2_(real *, real *, real *), pjp1c1_(real 
	    *, real *, real *), itc1c2_(real *, real *, real *), ccntc_(real *
	    , real *, real *, integer *);
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen), appenx_(integer *, integer *), length_(integer *);
    static integer typcre;
    extern doublereal dtp1xx_(real *, real *), dtp1sp_(real *, integer *, 
	    integer *);
    extern integer fndrsp_(integer *, integer *);
    extern logical testpx_(real *, real *);
    static real ang1, ang2, ang3, res[96]	/* was [6][16] */, pm[4], pj[
	    4], dx, dy, savept[6], pw[4], xx1, yy1, xx2, yy2;
    static integer pstack, ii, mjx, adrspl, tetspl, pt, pt1, gen;
    static real *xc=0, *yc=0;
    static char namept[32];
    extern /* Subroutine */ int noirci_(real *), demkmn_(integer *);
    extern void cnstr2_75(real res[96],real stack[36],
        integer padr[16],real *pttg,integer tnum[8]);

    /* Fortran I/O blocks */
    /*static*/ cilist io___749 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___773 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___776 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___781 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___784 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___785 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___786 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___797 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___798 = { 0, 6, 0, 0, 0 };




/*     actions de construction (menu 4) (au dessus) */



/*      external anal4,monit,lireg4 */
/*      integer anal4,monit,lireg4 */

/*       integer pile(64),debutg,sizpil,ppile */

/*      stack = pile des entrees      (pointee par pstack) */
/*      padr  = pile des adresses des objets pointes (pointee par pstack) 
*/
/*      desig = pile des designations (pointee par pstack) */
/*      res = pile des resultats le resultat choisi par ambiguite est */
/*            pointe par solut */
/*      solut = numero de la solution la meilleur */
/*      nbsol = nombre de solutions possibles */
/*         ....... on a en plus pour ctgccc ....... */
/*      pttg  = pile des trois points de tangence pour chaque solution */
/*      tnum  = pile des numero des solutions dans un ensemble ( 0...53) 
*/
/*      typcre = type a creer (vide,point,droite,cercle,segment,arc,splin 
*/


/* ----  dcl pour les splines */
/*      gen=0 pour couper les splines (itspxx) */
/*      tableau pour recevoir les points intermediaires */
/*      nom du fichier de lecture des points */
/*      etiquette logique du fichier de lecture des points */
/* ------------------------------------ */
/*      case marquee,numero menu */
    ret_val = 0;
    if (*act == 0) {
/*        action vide */
	return ret_val;
    } else if (*act < 0) {
/*         print*,'initialisation de cnstr2' */
    if (!xc) assert(xc = (real*) malloc (sizeof(real)*1001));
    if (!yc) assert(yc = (real*) malloc (sizeof(real)*1001));
    if (!pttg) assert(pttg = (real*) malloc (sizeof(real)*288));

	pstack = 0;
	desig[0] = 0.f;
	desig[6] = 0.f;
	desig[12] = 0.f;
	etat_1.copies = 0;
	etat_1.nombre = 0;
	typcre = -1e3f;
	adrspl = 0;
	mkcas1 = 1;
	mkcas2 = 19;
	mkcas3 = 1;
	numn = 4;
	pec_1.appli = 511;
	for (i = 4; i <= 14; ++i) {
	    pec_1.acmenu[i - 1] = FALSE_;
/* L701: */
	}
	pec_1.acmenu[3] = TRUE_;
	noirci_(&pec_1.fmenu[12]);
	demkmn_(&c__4);
	afmenu_(&c__4);
	pec_1.calcu = 0;
/*        i=analx(action,0) */
	return ret_val;
    } else if (*act == 999) {
/*        action speciale d'appel du niveau superieur si il existe */
/*         i=analx(action,vlmenu) */
	return ret_val;
    }
    switch (*act) {
/*	case 1:  goto L1;
	case 2:  goto L2;
	case 3:  goto L3;*/
		case 1:
      /*      init1 */
      pstack = 1;
      return ret_val;
    case 2:
      /*      init */
       pstack = 0;
       return ret_val;
	case 3:
      /*        init2 */
       pstack = 2;
       return ret_val;

	case 4:  goto L4;
	case 5:  goto L5;
	case 6:  goto L6;
	case 7:  goto L7;
	case 8:  goto L8;
	case 9:  goto L9;
	case 10:  goto L10;
	case 11:  goto L11;
	case 12:  goto L12;
	case 13:  goto L13;
	case 14:  goto L14;
	case 15:  goto L15;
	case 16:  goto L16;
	case 17:  goto L17;
	case 18:  goto L18;
	case 19:  goto L19;
	case 20:  goto L20;
	case 21:  goto L21;
	case 22:  goto L22;
	case 23:  goto L23;
	case 24:  goto L24;
	case 25:  goto L25;
	case 26:  goto L26;
	case 27:  goto L27;
	case 28:  goto L28;
	case 29:  goto L29;
	case 30:  goto L30;
	case 31:  goto L31;
	case 32:  goto L32;
	case 33:  goto L33;
	case 34:  goto L34;
	case 35:  goto L35;
	case 36:  goto L36;
	case 37:  goto L37;
	case 38:  goto L38;
	case 39:  goto L39;
	case 40:  goto L40;
	case 41:  goto L41;
	case 42:  goto L42;
	case 43:  goto L43;
	case 44:  goto L44;
	case 45:  goto L45;
	case 46:  goto L46;
	case 47:  goto L47;
	case 48:  goto L48;
	case 49:  goto L49;
	case 50:  goto L50;
	case 51:  goto L51;
	case 52:  goto L52;
	case 53:  goto L53;
	case 54:  goto L54;
	case 55:  goto L55;
	case 56:  goto L56;
	case 57:  goto L57;
	case 58:  goto L58;
	case 59:  goto L59;
	case 60:  goto L60;
	case 61:  goto L61;
	case 62:  goto L62;
	case 63:  goto L63;
	case 64:  goto L64;
	case 65:  goto L65;
	case 66:  goto L66;
	case 67:  goto L67;
	case 68:  goto L68;
	case 69:  goto L69;
	case 70:  goto L70;
	case 71:  goto L71;
	case 72:  goto L72;
	case 73:  goto L73;
	case 74:  goto L74;
	case 75:  goto L75;
	case 76:  goto L76;
    }
    scrtch_("cnstr2:ERREUR systeme: action erronnee.", 39L);
    s_wsle(&io___749);
    do_lio(&c__9, &c__1, "cnstr2:ERREUR systeme: action erronnee:", 39L);
    do_lio(&c__3, &c__1, (char *)&(*act), (ftnlen)sizeof(integer));
    e_wsle();
    return ret_val;
L4:
/*        push */
    ++pstack;
    if (pstack > 3) {
	scrtch_("cnstr2:ERREUR dans push:overflow", 32L);
	pstack = 0;
	return ret_val;
    }
/*        on empile la designation */
    desig[pstack * 6 - 5] = cdesig_1.x;
    desig[pstack * 6 - 4] = cdesig_1.y;
/*         print*,'cnstr2:on empile l''element d''adresse',adr,' de type: 
*/
/*     +         ,bd(0,adr),bd(1,adr),bd(2,adr) */
/*        on empile la contrainte */
    cnstr[pstack - 1] = cdesig_1.cnstrn;
    padr[pstack - 1] = cdesig_1.adr;
    if (cdesig_1.adr == 0) {
	return ret_val;
    }
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -2.f) {
/*          on empile le cercle qui le sous tend */
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[cdesig_1.adr * 6 + 385] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 387];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[cdesig_1.adr * 6 + 386] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 388];
	stack[pstack * 6 - 6] = sqrt(r__1 * r__1 + r__2 * r__2);
	stack[pstack * 6 - 5] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	stack[pstack * 6 - 4] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -3.f) {
/*          on empile la droite qui le supporte */
	stack[24] = 0.f;
	stack[25] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	stack[26] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	stack[30] = 0.f;
	stack[31] = bdpec2_1.bd[cdesig_1.adr * 6 + 387];
	stack[32] = bdpec2_1.bd[cdesig_1.adr * 6 + 388];
	drp1p2_(&stack[pstack * 6 - 6], &stack[24], &stack[30]);
    } else {
/*          on empile l'element */
	for (i = 0; i <= 5; ++i) {
	    stack[i + pstack * 6 - 6] = bdpec2_1.bd[i + cdesig_1.adr * 6 + 
		    384];
/* L4001: */
	}
    }
    rais[0] = 1.f;
    nurf[0] = 0;
    nurf1[0] = 0;
    nurf2[0] = 0;
    nurf[1] = 0;
    nurf1[1] = 0;
    nurf2[1] = 0;
    nbnd[0] = 2;
    rais[1] = 1.f;
    nurf[2] = 0;
    nurf1[2] = 0;
    nurf2[2] = 0;
    nurf[3] = 0;
    nurf1[3] = 0;
    nurf2[3] = 0;
    nbnd[1] = 2;
    return ret_val;
L5:
/*      push_coord */
    ++pstack;
    if (pstack > 3) {
	scrtch_("cnstr2:ERREUR dans push_coord:overflow", 38L);
	pstack = 0;
	return ret_val;
    }
/*        on empile la contrainte */
    cnstr[pstack - 1] = cdesig_1.cnstrn;
/*        on empile la designation */
    desig[pstack * 6 - 5] = cdesig_1.x;
    desig[pstack * 6 - 4] = cdesig_1.y;
    padr[pstack - 1] = cdesig_1.adr;
    cdesig_1.adr = 0;
    stack[pstack * 6 - 6] = 0.f;
    stack[pstack * 6 - 5] = cdesig_1.x;
    stack[pstack * 6 - 4] = cdesig_1.y;
    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
    draw_(&stack[pstack * 6 - 6]);
    rais[0] = 1.f;
    nurf[0] = 0;
    nurf1[0] = 0;
    nurf2[0] = 0;
    nurf[1] = 0;
    nurf1[1] = 0;
    nurf2[1] = 0;
    nbnd[0] = 2;
    rais[1] = 1.f;
    nurf[2] = 0;
    nurf1[2] = 0;
    nurf2[2] = 0;
    nurf[3] = 0;
    nurf1[3] = 0;
    nurf2[3] = 0;
    nbnd[1] = 2;
    return ret_val;
L6:
/*      creer (on suppose que l'on avait le resultat dans res(*,solut) */
/*            et que alloc a trouver une place libre en libre dans la bd) 
*/
    if (solut == 0 || libre == 0) {
	return ret_val;
    }
    for (i = 0; i <= 5; ++i) {
	bdpec2_1.bd[i + libre * 6 + 384] = res[i + solut * 6 - 6];
/* L6001: */
    }
    bdpec4_1.raison[libre + 64] = rais[solut - 1];
    bdpec5_1.nuref[(libre << 1) + 128] = nurf[(solut << 1) - 2];
    bdpec6_1.nuref1[(libre << 1) + 128] = nurf1[(solut << 1) - 2];
    bdpec7_1.nuref2[(libre << 1) + 128] = nurf2[(solut << 1) - 2];
    bdpec5_1.nuref[(libre << 1) + 129] = nurf[(solut << 1) - 2];
    bdpec6_1.nuref1[(libre << 1) + 129] = nurf1[(solut << 1) - 1];
    bdpec7_1.nuref2[(libre << 1) + 129] = nurf2[(solut << 1) - 1];
    bdpec3_1.nbnode[libre + 64] = nbnd[solut - 1];
/*        ellimination des degenerescences */
    cdesig_1.adr = libre;
    goto L23;
L7:
/*      point_immediat */
    for (i = 0; i <= 5; ++i) {
	res[i] = stack[i + pstack * 6 - 6];
/* L7001: */
    }
    rais[0] = 1.f;
    nurf[0] = 0;
    nurf1[0] = 0;
    nurf2[0] = 0;
    nurf[1] = 0;
    nurf1[1] = 0;
    nurf2[1] = 0;
    nbnd[0] = 2;
    nbsol = 1;
    return ret_val;
L8:
/*        res_egal_bd */
    if (cdesig_1.adr == 0) {
	goto L7;
    }
    for (i = 0; i <= 5; ++i) {
	res[i] = bdpec2_1.bd[i + cdesig_1.adr * 6 + 384];
/* L8001: */
    }
    rais[0] = bdpec4_1.raison[cdesig_1.adr + 64];
    nurf[0] = bdpec5_1.nuref[(cdesig_1.adr << 1) + 128];
    nurf1[0] = bdpec6_1.nuref1[(cdesig_1.adr << 1) + 128];
    nurf2[0] = bdpec7_1.nuref2[(cdesig_1.adr << 1) + 128];
    nurf[1] = bdpec5_1.nuref[(cdesig_1.adr << 1) + 129];
    nurf1[1] = bdpec6_1.nuref1[(cdesig_1.adr << 1) + 129];
    nurf2[1] = bdpec7_1.nuref2[(cdesig_1.adr << 1) + 129];
    nbnd[0] = bdpec3_1.nbnode[cdesig_1.adr + 64];
    solut = 1;
    return ret_val;
L9:
/*        alloc */
    libre = alloc_();
    cdesig_1.adr = libre;
    return ret_val;
L10:
/*      pjpd */
    if (stack[0] == 0.f) {
/*          projection du point stack(*,1) sur droite stack(*,2) */
	r__1 = -(doublereal)etat_1.distan;
	pjp1d_(res, stack, &stack[6], &r__1);
    } else {
/*          projection sur droite stack(*,1) du point stack(*,2) */
	r__1 = -(doublereal)etat_1.distan;
	pjp1d_(res, &stack[6], stack, &r__1);
    }
    nbsol = 1;
    return ret_val;
L11:
/*      pjpc */
    if (stack[0] == 0.f) {
/*           projection du point stack(*,1) sur le cercle stack(*,2) 
*/
	for (i = 0; i <= 5; ++i) {
	    dist = stack[i];
	    stack[i] = stack[i + 6];
	    stack[i + 6] = dist;
	    dist = desig[i];
	    desig[i] = desig[i + 6];
	    desig[i + 6] = dist;
/* L11101: */
	}
	i = padr[0];
	padr[0] = padr[1];
	padr[1] = i;
    }
/*           projection sur cercle stack(*,1) du point stack(*,2) */
    pjp1c1_(res, &stack[6], stack);
/* Computing 2nd power */
    r__1 = desig[1] - res[1];
/* Computing 2nd power */
    r__2 = desig[2] - res[2];
/* Computing 2nd power */
    r__3 = desig[1] - res[7];
/* Computing 2nd power */
    r__4 = desig[2] - res[8];
    if (r__1 * r__1 + r__2 * r__2 > r__3 * r__3 + r__4 * r__4) {
	res[1] = res[7];
	res[2] = res[8];
    }
    nbsol = 1;
    return ret_val;
L12:
/*        itcc   (on ne coupe pas les splines */
    gen = 1;
L1200:
    if (padr[0] == padr[1]) {
	nbsol = 0;
	return ret_val;
    }
    if (stack[0] == -4.f || stack[6] == -4.f) {
/*          pas plus de 16 points d'intersections */
	itspxx_(res, stack, &stack[6], &k, padr, &padr[1], &gen);
/*          effacement des splines */
	if (k != 0 && bdpec2_1.bd[padr[0] * 6 + 384] == -4.f && gen == 0) {
	    drawad_(padr, &c_n1);
	    bdpec2_1.bd[padr[0] * 6 + 384] = -1e3f;
	}
	if (k != 0 && bdpec2_1.bd[padr[1] * 6 + 384] == -4.f && gen == 0) {
	    drawad_(&padr[1], &c_n1);
	    bdpec2_1.bd[padr[1] * 6 + 384] = -1e3f;
	}
    } else {
	itc1c2_(res, stack, &stack[6]);
	k = 2;
    }
    nbsol = 0;
/*         k=nombre maxi de points d'intersections */
    i__1 = k;
    for (i = 1; i <= i__1; ++i) {
	if (res[0] == 0.f) {
	    ++nbsol;
	    for (j = 0; j <= 5; ++j) {
		res[j + nbsol * 6 - 6] = res[j + i * 6 - 6];
		pttg[j + (nbsol * 3 + 1) * 6 - 24] = res[j + i * 6 - 6];
		pttg[j + (nbsol * 3 + 2) * 6 - 24] = res[j + i * 6 - 6];
/* L12010: */
	    }
	}
/* L12020: */
    }
    return ret_val;
L13:
/*      crcnt centre en pstack  + rayon */
    res[0] = etat_1.rayon;
    res[1] = stack[pstack * 6 - 5];
    res[2] = stack[pstack * 6 - 4];
    nbsol = 1;
    return ret_val;
L14:
/*      ccntc cercle de centre en pstack=1 avec contrainte en pstack */
    ccntc_(res, stack, &stack[pstack * 6 - 6], &nbsol);
    return ret_val;
L15:
/*        arc_rond centre en stack(1) + rayon (angle = 2*pi) */
    res[0] = -2.f;
    res[1] = stack[1];
    res[2] = stack[2];
    res[3] = res[1] + etat_1.rayon;
    res[4] = res[2];
    res[5] = 6.283185306f;
    solut = 1;
    rais[solut - 1] = 1.f;
    nurf[(solut << 1) - 2] = 0;
    nurf1[(solut << 1) - 2] = 0;
    nurf2[(solut << 1) - 2] = 0;
    nurf[(solut << 1) - 1] = 0;
    nurf1[(solut << 1) - 1] = 0;
    nurf2[(solut << 1) - 1] = 0;
    nbnd[solut - 1] = 2;
    return ret_val;
L16:
/*      acacnt arc de centre en stack(1),une contrainte en stack(2) */
/*        +  (angle | une contrainte en stack(3)) */
/*        est utilise apres un call a ccntc et ambiguite */
    if (solut == 0) {
	scrtch_("ERREUR:acacnt:arc vide", 22L);
	return ret_val;
    }
    if (res[solut * 6 - 6] < 0.f) {
	scrtch_("ERREUR:acacnt:arc vide", 22L);
	solut = 0;
	return ret_val;
    }
    i = (solut + 1) % 16 + 1;
    res[i * 6 - 6] = -2.f;
    res[i * 6 - 5] = res[solut * 6 - 5];
    res[i * 6 - 4] = res[solut * 6 - 4];
    ptgcc_(pj, &res[solut * 6 - 6], &stack[6], &c_b609);
    res[i * 6 - 3] = pj[1];
    res[i * 6 - 2] = pj[2];
    if (pstack == 2) {
/*          on prend l'angle qui est en radiants */
	res[i * 6 - 1] = etat_1.angle;
    } else {
/*          on prend la deuxieme contrainte pour trouver l'angle, */
/*            (on tournera dans le sens positif) */
	ptgcc_(pj, &res[solut * 6 - 6], &stack[12], &c_b609);
	r__1 = res[i * 6 - 2] - res[i * 6 - 4];
	r__2 = res[i * 6 - 3] - res[i * 6 - 5];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = pj[2] - res[i * 6 - 4];
	r__2 = pj[1] - res[i * 6 - 5];
	ang2 = atang2_(&r__1, &r__2);
	ang2 = ang2 - ang1 + 6.283185306f;
	ang2 = r_mod(&ang2, &c_b28);
	if (ang2 < 0.f) {
	    ang2 += 6.283185306f;
	}
	res[i * 6 - 1] = ang2;
    }
    solut = i;
    rais[solut - 1] = 1.f;
    nurf[(solut << 1) - 2] = 0;
    nurf1[(solut << 1) - 2] = 0;
    nurf2[(solut << 1) - 2] = 0;
    nurf[(solut << 1) - 1] = 0;
    nurf1[(solut << 1) - 1] = 0;
    nurf2[(solut << 1) - 1] = 0;
    nbnd[solut - 1] = 2;
    return ret_val;
L17:
/*         acr8 appele apres cr8 et ambiguite_cr8. */
/*                on a les deux contraintes en pile stack */
/*                on cree un arc positif allant des contraintes 1 a 2 de 
*/
/*           si une des deux contraintes est un point et si ce point */
/*           appartient a l'autre contrainte alors on cree un arc de (ang 
*/
    if (solut == 0) {
	scrtch_("ERREUR:acr8:arc vide", 20L);
	return ret_val;
    }
    if (res[solut * 6 - 6] < 0.f) {
	scrtch_("ERREUR:acr8:arc vide", 20L);
	solut = 0;
	return ret_val;
    }
    i = (solut + 1) % 16 + 1;
    res[i * 6 - 6] = -2.f;
    res[i * 6 - 5] = res[solut * 6 - 5];
    res[i * 6 - 4] = res[solut * 6 - 4];
    ptgcc_(pj, &res[solut * 6 - 6], stack, &c_b609);
    res[i * 6 - 3] = pj[1];
    res[i * 6 - 2] = pj[2];
    if (stack[0] == 0.f && stack[6] != 0.f) {
/*          ce point est'il sur l'autre element de contrainte? */
	dist2 = dtp1xx_(stack, &stack[6]);
	if (dist2 < eps_1.eps) {
/*            dans ce cas on utilise l'angle courant */
/*             (cas d'un point appartenant a l'autre element de co
ntraint */
/*             (car dans ce cas on obtiendrait un angle de 0 ou 2*
pi) */
	    res[i * 6 - 1] = etat_1.angle;
	    solut = i;
	    rais[solut - 1] = 1.f;
	    nurf[(solut << 1) - 2] = 0;
	    nurf1[(solut << 1) - 2] = 0;
	    nurf2[(solut << 1) - 2] = 0;
	    nurf[(solut << 1) - 1] = 0;
	    nurf1[(solut << 1) - 1] = 0;
	    nurf2[(solut << 1) - 1] = 0;
	    nbnd[solut - 1] = 2;
	    return ret_val;
	}
    } else if (stack[6] == 0.f && stack[0] != 0.f) {
/*          ce point est'il sur l'autre element de contrainte? */
	dist2 = dtp1xx_(&stack[6], stack);
	if (dist2 < eps_1.eps) {
/*            dans ce cas on utilise l'angle courant */
/*             (cas d'un point appartenant a l'autre element de co
ntraint */
/*             (car dans ce cas on obtiendrait un angle de 0 ou 2*
pi) */
	    res[i * 6 - 1] = etat_1.angle;
	    solut = i;
	    rais[solut - 1] = 1.f;
	    nurf[(solut << 1) - 2] = 0;
	    nurf1[(solut << 1) - 2] = 0;
	    nurf2[(solut << 1) - 2] = 0;
	    nurf[(solut << 1) - 1] = 0;
	    nurf1[(solut << 1) - 1] = 0;
	    nurf2[(solut << 1) - 1] = 0;
	    nbnd[solut - 1] = 2;
	    return ret_val;
	}
    }
/*        on prend la deuxieme contrainte pour trouver l'angle, */
/*          (on tournera dans le sens positif) */
    ptgcc_(pj, &res[solut * 6 - 6], &stack[6], &c_b609);
    r__1 = res[i * 6 - 2] - res[i * 6 - 4];
    r__2 = res[i * 6 - 3] - res[i * 6 - 5];
    ang1 = atang2_(&r__1, &r__2);
    r__1 = pj[2] - res[i * 6 - 4];
    r__2 = pj[1] - res[i * 6 - 5];
    ang2 = atang2_(&r__1, &r__2);
    ang2 = ang2 - ang1 + 6.283185306f;
    ang2 = r_mod(&ang2, &c_b28);
    if (ang2 <= 0.f) {
	ang2 += 6.283185306f;
    }
    res[i * 6 - 1] = ang2;
    solut = i;
    rais[solut - 1] = 1.f;
    nurf[(solut << 1) - 2] = 0;
    nurf1[(solut << 1) - 2] = 0;
    nurf2[(solut << 1) - 2] = 0;
    nurf[(solut << 1) - 1] = 0;
    nurf1[(solut << 1) - 1] = 0;
    nurf2[(solut << 1) - 1] = 0;
    nbnd[solut - 1] = 2;
    return ret_val;
L18:
/*        accc    (arc defini par 3 contraintes, apres ctgccc, on fait */
/*                 passer l'arc par les 3 points de tangence du cercle) */
/*                      (pttg(*,*,solut)) */
    if (solut == 0) {
	scrtch_("ERREUR:accc:arc vide", 20L);
	return ret_val;
    }
    if (res[solut * 6 - 6] < 0.f) {
	scrtch_("ERREUR:accc:arc vide", 20L);
	solut = 0;
	return ret_val;
    }
    i = (solut + 1) % 16 + 1;
    res[i * 6 - 6] = -2.f;
/*        centre */
    res[i * 6 - 5] = res[solut * 6 - 5];
    res[i * 6 - 4] = res[solut * 6 - 4];
/*        premier point */
    res[i * 6 - 3] = pttg[(solut * 3 + 1) * 6 - 23];
    res[i * 6 - 2] = pttg[(solut * 3 + 1) * 6 - 22];
/*        angle */
    ang2 = 0.f;
    if (pttg[(solut * 3 + 1) * 6 - 23] == pttg[(solut * 3 + 2) * 6 - 23] && 
	    pttg[(solut * 3 + 1) * 6 - 22] == pttg[(solut * 3 + 2) * 6 - 22]) 
	    {
/*          2 premiers points confondus ( demi cercle positif) */
	ang3 = 3.141592653f;
    } else if (pttg[(solut * 3 + 1) * 6 - 23] == pttg[(solut * 3 + 2) * 6 - 
	    23] && pttg[(solut * 3 + 1) * 6 - 22] == pttg[(solut * 3 + 2) * 6 
	    - 22]) {
/*          2 derniers points confondus ( demi cercle negatif) */
	ang3 = -3.141592653f;
    } else if (pttg[(solut * 3 + 1) * 6 - 23] == pttg[(solut * 3 + 3) * 6 - 
	    23] && pttg[(solut * 3 + 1) * 6 - 22] == pttg[(solut * 3 + 3) * 6 
	    - 22]) {
/*          premier et dernier point confondus (arc d'angle 2*pi) */
	ang3 = 6.283185306f;
    } else {
	r__1 = pttg[(solut * 3 + 1) * 6 - 22] - res[i * 6 - 4];
	r__2 = pttg[(solut * 3 + 1) * 6 - 23] - res[i * 6 - 5];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = pttg[(solut * 3 + 2) * 6 - 22] - res[i * 6 - 4];
	r__2 = pttg[(solut * 3 + 2) * 6 - 23] - res[i * 6 - 5];
	ang2 = atang2_(&r__1, &r__2) - ang1;
	r__1 = pttg[(solut * 3 + 3) * 6 - 22] - res[i * 6 - 4];
	r__2 = pttg[(solut * 3 + 3) * 6 - 23] - res[i * 6 - 5];
	ang3 = atang2_(&r__1, &r__2) - ang1;
	r__1 = ang2 + 12.566370612f;
	ang2 = r_mod(&r__1, &c_b28);
	r__1 = ang3 + 12.566370612f;
	ang3 = r_mod(&r__1, &c_b28);
	if (ang2 < 0.f) {
	    ang2 += 6.283185306f;
	}
	if (ang3 < 0.f) {
	    ang3 += 6.283185306f;
	}
    }
    res[i * 6 - 1] = ang3;
    if (ang2 > ang3) {
	res[i * 6 - 1] += -6.283185306f;
    }
    solut = i;
    rais[solut - 1] = 1.f;
    nurf[(solut << 1) - 2] = 0;
    nurf1[(solut << 1) - 2] = 0;
    nurf2[(solut << 1) - 2] = 0;
    nurf[(solut << 1) - 1] = 0;
    nurf1[(solut << 1) - 1] = 0;
    nurf2[(solut << 1) - 1] = 0;
    nbnd[solut - 1] = 2;
    return ret_val;
L19:
/*        cr8 */
    if ((real) typcre == -1.f || (real) typcre == -3.f) {
	cr8_(stack, &stack[6], &c_b1849, res, pttg, tnum, &nbsol, &
		etat_1.angle, &etat_1.distan);
    } else {
	cr8_(stack, &stack[6], &etat_1.rayon, res, pttg, tnum, &nbsol, &
		etat_1.angle, &etat_1.distan);
    }
    return ret_val;
L20:
/*        adrcr8 arondi de rayon et 2 contraintes appele apres adcr8 */
/*              donc l'arc est deja mis en res(*solut) */
/*              si les contraintes sont de type a ou s , on modifie */
/*              leurs extremitees dans la bd, sinon on ne fait rien */
    if (padr[0] == 0 || solut == 0) {
	return ret_val;
    }
    if (bdpec2_1.bd[padr[0] * 6 + 384] == -2.f || bdpec2_1.bd[padr[0] * 6 + 
	    384] == -3.f) {
	acnt_(&res[solut * 6 - 6], &bdpec2_1.bd[padr[0] * 6 + 384]);
    }
    if (bdpec2_1.bd[padr[1] * 6 + 384] == -2.f || bdpec2_1.bd[padr[1] * 6 + 
	    384] == -3.f) {
	acnt_(&res[solut * 6 - 6], &bdpec2_1.bd[padr[1] * 6 + 384]);
    }
    return ret_val;
L21:
/*        ctgccc      cercle defini par 3 contraintes */
    ctgccc_(res, stack, &stack[6], &stack[12], pttg, tnum, &nbsol);
    return ret_val;
L22:
/*        itcc_cut  (on coupe les splines ) */
    gen = 0;
    goto L1200;
L23:
/*        ellimination des degenerescences de bd(*,adr) */
    degen_(&cdesig_1.adr);
    return ret_val;
L24:
/*        creer_spline  apres alloc */
    if (libre == 0) {
	return ret_val;
    }
    adrspl = libre;
    libre = 0;
    bdpec2_1.bd[adrspl * 6 + 384] = -4.f;
/*        nombre de points=0 */
    bdpec2_1.bd[adrspl * 6 + 385] = 0.f;
/*        tete de liste des sommets = nil */
    bdpec2_1.bd[adrspl * 6 + 386] = 0.f;
    bdpec4_1.raison[adrspl + 64] = 1.f;
    bdpec5_1.nuref[(adrspl << 1) + 128] = 0;
    bdpec6_1.nuref1[(adrspl << 1) + 128] = 0;
    bdpec7_1.nuref2[(adrspl << 1) + 128] = 0;
    bdpec5_1.nuref[(adrspl << 1) + 129] = 0;
    bdpec6_1.nuref1[(adrspl << 1) + 129] = 0;
    bdpec7_1.nuref2[(adrspl << 1) + 129] = 0;
    bdpec3_1.nbnode[adrspl + 64] = 2;
    return ret_val;
L25:
/*        add_point_spline */
    if (bdpec2_1.bd[adrspl * 6 + 385] >= 500.f) {
	scrtch_("attention, trop de points sur cette spline", 42L);
	s_wsle(&io___773);
	do_lio(&c__9, &c__1, "cnstr2:trop de points sur cette spline", 38L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[adrspl * 6 + 385], (ftnlen)
		sizeof(real));
	e_wsle();
	libre = 0;
	return ret_val;
    }
    tetspl = bdpec2_1.bd[adrspl * 6 + 386];
    if (padr[pstack - 1] == 0) {
	cdesig_1.adr = libre;
	bdpec2_1.bd[cdesig_1.adr * 6 + 384] = 0.f;
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = cdesig_1.x;
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = cdesig_1.y;
	bdpec5_1.nuref[(cdesig_1.adr << 1) + 128] = 0;
	bdpec5_1.nuref[(cdesig_1.adr << 1) + 129] = 0;
    } else if (bdpec2_1.bd[padr[pstack - 1] * 6 + 384] != 0.f) {
	cdesig_1.adr = libre;
	bdpec2_1.bd[cdesig_1.adr * 6 + 384] = 0.f;
	bdpec2_1.bd[cdesig_1.adr * 6 + 385] = stack[pstack * 6 - 5];
	bdpec2_1.bd[cdesig_1.adr * 6 + 386] = stack[pstack * 6 - 4];
	bdpec5_1.nuref[(cdesig_1.adr << 1) + 128] = 0;
	bdpec5_1.nuref[(cdesig_1.adr << 1) + 129] = 0;
    } else if (bdpec2_1.bd[padr[pstack - 1] * 6 + 384] == 0.f) {
	cdesig_1.adr = padr[pstack - 1];
    } else {
	scrtch_("25: add_point_spline: cas non traite", 36L);
	return ret_val;
    }
    libre = 0;
/*        effacer l'ancienne spline */
    drawad_(&adrspl, &c_n1);
/*        afficher le nouveau point */
    drawad_(&cdesig_1.adr, &c__0);
    i__1 = cons_(&cdesig_1.adr, &c__0);
    tetspl = appenx_(&tetspl, &i__1);
    bdpec2_1.bd[adrspl * 6 + 385] = (real) length_(&tetspl);
    bdpec2_1.bd[adrspl * 6 + 386] = (real) tetspl;
    if (bdpec2_1.bd[adrspl * 6 + 385] >= 2.f) {
/*          tracer la nouvelle spline */
	drawad_(&adrspl, &c__0);
    }
    return ret_val;
L26:
/*        complementaire_arc (adr) */
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] != -2.f) {
	return ret_val;
    }
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 389] < 0.f) {
	bdpec2_1.bd[cdesig_1.adr * 6 + 389] += 6.283185306f;
    } else {
	bdpec2_1.bd[cdesig_1.adr * 6 + 389] += -6.283185306f;
    }
/*        on inverse le numero de ref */
    i = bdpec5_1.nuref[(cdesig_1.adr << 1) + 128];
    bdpec5_1.nuref[(cdesig_1.adr << 1) + 128] = bdpec5_1.nuref[(cdesig_1.adr 
	    << 1) + 129];
    bdpec5_1.nuref[(cdesig_1.adr << 1) + 129] = i;
/*        on inverse les numeros de ref des extremitees */
    i = bdpec6_1.nuref1[(cdesig_1.adr << 1) + 128];
    bdpec6_1.nuref1[(cdesig_1.adr << 1) + 128] = bdpec6_1.nuref1[(
	    cdesig_1.adr << 1) + 129];
    bdpec6_1.nuref1[(cdesig_1.adr << 1) + 129] = i;
    i = bdpec7_1.nuref2[(cdesig_1.adr << 1) + 128];
    bdpec7_1.nuref2[(cdesig_1.adr << 1) + 128] = bdpec7_1.nuref2[(
	    cdesig_1.adr << 1) + 129];
    bdpec7_1.nuref2[(cdesig_1.adr << 1) + 129] = i;
    return ret_val;
L27:
/*        inverser arc ou segment ou spline */
    invers_(&cdesig_1.adr);
    return ret_val;
L28:
/*        retourner */
    if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -2.f) {
	bdpec2_1.bd[cdesig_1.adr * 6 + 389] = -(doublereal)bdpec2_1.bd[
		cdesig_1.adr * 6 + 389];
    } else if (bdpec2_1.bd[cdesig_1.adr * 6 + 384] == -3.f) {
	bdpec2_1.bd[cdesig_1.adr * 6 + 387] = bdpec2_1.bd[cdesig_1.adr * 6 + 
		385] * 2.f - bdpec2_1.bd[cdesig_1.adr * 6 + 387];
	bdpec2_1.bd[cdesig_1.adr * 6 + 388] = bdpec2_1.bd[cdesig_1.adr * 6 + 
		386] * 2.f - bdpec2_1.bd[cdesig_1.adr * 6 + 388];
    }
/*        on inverse le numero de ref */
    i = bdpec5_1.nuref[(cdesig_1.adr << 1) + 128];
    bdpec5_1.nuref[(cdesig_1.adr << 1) + 128] = bdpec5_1.nuref[(cdesig_1.adr 
	    << 1) + 129];
    bdpec5_1.nuref[(cdesig_1.adr << 1) + 129] = i;
/*        on inverse les numeros de ref des extremitees */
    i = bdpec6_1.nuref1[(cdesig_1.adr << 1) + 128];
    bdpec6_1.nuref1[(cdesig_1.adr << 1) + 128] = bdpec6_1.nuref1[(
	    cdesig_1.adr << 1) + 129];
    bdpec6_1.nuref1[(cdesig_1.adr << 1) + 129] = i;
    i = bdpec7_1.nuref2[(cdesig_1.adr << 1) + 128];
    bdpec7_1.nuref2[(cdesig_1.adr << 1) + 128] = bdpec7_1.nuref2[(
	    cdesig_1.adr << 1) + 129];
    bdpec7_1.nuref2[(cdesig_1.adr << 1) + 129] = i;
    return ret_val;
L29:
/*        couper l'element adr par stack(1) */
    solut = 1;
/*        effacer l'element */
    drawad_(&cdesig_1.adr, &c_n1);
    cutpc_(stack, &cdesig_1.adr, &res[solut * 6 - 6], &rais[solut - 1], &nurf[
	    (solut << 1) - 2], &nurf1[(solut << 1) - 2], &nurf2[(solut << 1) 
	    - 2], &nbnd[solut - 1]);
    degen_(&cdesig_1.adr);
/*        affichage partiel */
    drawad_(&cdesig_1.adr, &c__0);
    return ret_val;
L30:
/*        couper_xx coupe (arc | segment |spline) par (arc | segment|spli 
*/
/*        on a apres itcc: nbsol= nombre de solutions */
/*                         res(*,1:nbsol)=points d'intersections */
/*           le cas des spline a deja ete resolu */
    if (nbsol == 0 || libre == 0) {
	return ret_val;
    }
/*        on ne garde que les points d'intersections qui appartiennent */
/*         aux deux elements */
    j = 2;
    i__1 = nbsol;
    for (solut = 1; solut <= i__1; ++solut) {
	if (! (testpx_(&res[solut * 6 - 6], &bdpec2_1.bd[padr[0] * 6 + 384]) 
		&& testpx_(&res[solut * 6 - 6], &bdpec2_1.bd[padr[1] * 6 + 
		384]))) {
	    res[solut * 6 - 6] = -1e3f;
	}
/* L3004: */
    }
/*        pour touts les points d'intersections */
/*         print*,'cnstr2:nbsol=',nbsol */
    i__1 = nbsol;
    for (solut = 1; solut <= i__1; ++solut) {
/*           print*,'cnstr2:solut=',solut */
/*          pour touts les elements designes ou crees */
	mjx = j;
	i__2 = mjx;
	for (k = 1; k <= i__2; ++k) {
/*             print*,'cnstr2:k=',k */
/*            on ne traite pas le cas des spline car elles ont ete
 */
/*             traitees par itspxx */
	    if (padr[k - 1] != 0 && bdpec2_1.bd[padr[k - 1] * 6 + 384] != 
		    -1e3f && res[solut * 6 - 6] != -1e3f) {
		libre = alloc_();
		cdesig_1.adr = libre;
		drawad_(&padr[k - 1], &c_n1);
/*               print*,'cnstr2:on coupe  adresse=',padr(k) */
		dumpad_(&padr[k - 1]);
		s_wsle(&io___776);
		do_lio(&c__9, &c__1, "   par le point", 15L);
		do_lio(&c__4, &c__1, (char *)&res[solut * 6 - 6], (ftnlen)
			sizeof(real));
		do_lio(&c__4, &c__1, (char *)&res[solut * 6 - 5], (ftnlen)
			sizeof(real));
		do_lio(&c__4, &c__1, (char *)&res[solut * 6 - 4], (ftnlen)
			sizeof(real));
		e_wsle();
		cutpc_(&res[solut * 6 - 6], &padr[k - 1], &bdpec2_1.bd[libre *
			 6 + 384], &bdpec4_1.raison[libre + 64], &
			bdpec5_1.nuref[(libre << 1) + 128], &bdpec6_1.nuref1[(
			libre << 1) + 128], &bdpec7_1.nuref2[(libre << 1) + 
			128], &bdpec3_1.nbnode[libre + 64]);
		degen_(&padr[k - 1]);
		degen_(&libre);
		if (bdpec2_1.bd[libre * 6 + 384] != -1e3f) {
/*                on empile l'element cree */
		    if (j < 16) {
			++j;
			padr[j - 1] = libre;
/*                   print*,'cnstr2:on empile a l''adr
esse',libre */
			drawad_(&libre, &c__0);
/*                   print*,'cnstr2: dump de libre' */
/*                   call dumpad(libre) */
			drawad_(&libre, &c__0);
		    } else {
			scrtch_("overflow de padr dans couper_xx (30)", 36L);
		    }
		}
		drawad_(&padr[k - 1], &c__0);
/*               print*,'cnstr2:dump de padr(',k,')' */
/*               call dumpad(padr(k)) */
	    }
/* L3003: */
	}
/* L3002: */
    }
    return ret_val;
L31:
/*        c_p */
    typcre = 0.f;
    return ret_val;
L32:
/*        c_d */
    typcre = -1.f;
    return ret_val;
L33:
/*        c_c */
    typcre = 1.f;
    return ret_val;
L34:
/*        c_s */
    typcre = -3.f;
    return ret_val;
L35:
/*        c_a */
    typcre = -2.f;
    return ret_val;
L36:
/*        c_sp */
    typcre = -4.f;
    return ret_val;
L37:
/*        read_points   lecture sur fichier de coordonnees de points et */
/*                      mise en bd */
/*        call intext('Donner le nom du fichier de points:',32,namept,i)#F
R*/
    intext_("Give the file name of points:", &c__32, namept, &i, 29L, 32L);
    if (i == 0) {
	goto L3777;
    }
    ioin__1.inerr = 0;
    ioin__1.infilen = i;
    ioin__1.infile = namept;
    ioin__1.inex = &bool;
    ioin__1.inopen = &bool1;
    ioin__1.innum = 0;
    ioin__1.innamed = 0;
    ioin__1.inname = 0;
    ioin__1.inacc = 0;
    ioin__1.inseq = 0;
    ioin__1.indir = 0;
    ioin__1.infmt = 0;
    ioin__1.inform = 0;
    ioin__1.inunf = 0;
    ioin__1.inrecl = 0;
    ioin__1.innrec = 0;
    ioin__1.inblank = 0;
    f_inqu(&ioin__1);
    if (bool1 && bool) {
	scrtch_("le fichier est deja ouvert?. changer de nom!", 44L);
	goto L37;
    }
    if (! bool) {
	scrtch_("le fichier n'existe pas?. changer de nom!", 41L);
	goto L37;
    }
    if (fouvri_(&nfpt, namept, " ", &c__0, 32L, 1L) != 0) {
	scrtch_("pb dans open de votre fichier, changer de nom!", 46L);
	goto L37;
    }
L3799:
    libre = alloc_();
    cdesig_1.adr = libre;
    if (libre != 0) {
	solut = 1;
	bdpec2_1.bd[libre * 6 + 384] = 0.f;
	io___781.ciunit = nfpt;
	i__1 = s_rsle(&io___781);
	if (i__1 != 0) {
	    goto L3788;
	}
	i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[libre * 6 + 385], (
		ftnlen)sizeof(real));
	if (i__1 != 0) {
	    goto L3788;
	}
	i__1 = do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[libre * 6 + 386], (
		ftnlen)sizeof(real));
	if (i__1 != 0) {
	    goto L3788;
	}
	i__1 = e_rsle();
	bdpec2_1.bd[libre * 6 + 387] = 0.f;
	bdpec2_1.bd[libre * 6 + 388] = 0.f;
	bdpec2_1.bd[libre * 6 + 389] = 0.f;
	bdpec4_1.raison[libre + 64] = 1.f;
	bdpec5_1.nuref[(libre << 1) + 128] = 0.f;
	bdpec6_1.nuref1[(libre << 1) + 128] = 0.f;
	bdpec7_1.nuref2[(libre << 1) + 128] = 0.f;
	bdpec5_1.nuref[(libre << 1) + 129] = 0.f;
	bdpec6_1.nuref1[(libre << 1) + 129] = 0.f;
	bdpec7_1.nuref2[(libre << 1) + 129] = 0.f;
	bdpec3_1.nbnode[libre + 64] = 2;
	drawad_(&cdesig_1.adr, &c__0);
	goto L3799;
    }
L3788:
    cl__1.cerr = 0;
    cl__1.cunit = nfpt;
    cl__1.csta = 0;
    f_clos(&cl__1);
L3777:
    return ret_val;
L38:
/*        ajouter_points_intermediaires */
    i = padr[0];
    j = etat_1.nombre + 2;
    if (i != 0) {
	if (bdpec2_1.bd[i * 6 + 384] == 0.f) {
	    i = 0;
	}
    }
    if (i == 0) {
/*          cas de 2 points */
	res[0] = -3.f;
	res[1] = stack[1];
	res[2] = stack[2];
	res[3] = stack[7];
	res[4] = stack[8];
	gnin_(res, &xc[1], &yc[1], &j, &etat_1.raport);
    } else {
	gnin_(&bdpec2_1.bd[cdesig_1.adr * 6 + 384], &xc[1], &yc[1], &j, &
		etat_1.raport);
    }
/*        creation des nombre points intermediaires */
    i__1 = etat_1.nombre;
    for (i = 1; i <= i__1; ++i) {
	libre = alloc_();
	cdesig_1.adr = libre;
	if (cdesig_1.adr == 0) {
	    return ret_val;
	}
	bdpec2_1.bd[libre * 6 + 384] = 0.f;
	bdpec2_1.bd[libre * 6 + 385] = xc[i];
	bdpec2_1.bd[libre * 6 + 386] = yc[i];
	bdpec4_1.raison[libre + 64] = 1.f;
	bdpec5_1.nuref[(libre << 1) + 128] = 0;
	bdpec6_1.nuref1[(libre << 1) + 128] = 0;
	bdpec7_1.nuref2[(libre << 1) + 128] = 0;
	bdpec5_1.nuref[(libre << 1) + 129] = 0;
	bdpec6_1.nuref1[(libre << 1) + 129] = 0;
	bdpec7_1.nuref2[(libre << 1) + 129] = 0;
	bdpec3_1.nbnode[libre + 64] = 2;
	drawad_(&libre, &c__0);
/* L3801: */
    }
    return ret_val;
L39:
/*        c_idem_a */
    solut = 1;
    res[solut * 6 - 6] = stack[pstack * 6 - 6];
    res[solut * 6 - 5] = stack[pstack * 6 - 5];
    res[solut * 6 - 4] = stack[pstack * 6 - 4];
    return ret_val;
L40:
/*        <copies> teste si des copies sont encore a faire */
    if (etat_1.copies <= 0) {
/*           print*,'cnstr2:<copies> renvoie faux' */
	ret_val = -1;
	etat_1.copies = etat_1.nombre;
    } else {
/*           print*,'cnstr2:<copies> renvoie vrais. copies=',copies */
	--etat_1.copies;
    }
    return ret_val;
L41:
/*        rotation de centre stack(*,1) + angle     de bd(*,adr) */
    rtbd_(&c__0, stack);
    return ret_val;
L42:
/*        translation de stack(*,1) a stack(*,2)    de bd(*,adr) */
    rtbd_(&c__1, stack);
    return ret_val;
L43:
/*        symetrie par rapport a stack(*,1)         de bd(*,adr) */
    rtbd_(&c__3, stack);
    return ret_val;
L44:
/*        homothetie de centre stack(*,1) + raport  de bd(*,adr) */
    rtbd_(&c__2, stack);
    return ret_val;
L45:
/*      contourage: on cree le contour sur l'element qui est en niveau 1 
*/
/*        il est limite par le point savept et res(solut) */
/*        si c'est un arc, il est de sens positif (on peut le complemente 
*/
/*         designant le menu complemente_arc */
/*        le resultat est dans res(solut=1) */
    if (solut == 0) {
	scrtch_("contourage: pas de solution", 27L);
	s_wsle(&io___784);
	do_lio(&c__9, &c__1, "cnstr2:stack(1)=", 16L);
	for (i = 0; i <= 5; ++i) {
	    do_lio(&c__4, &c__1, (char *)&stack[i], (ftnlen)sizeof(real));
	}
	e_wsle();
	s_wsle(&io___785);
	do_lio(&c__9, &c__1, "cnstr2:stack(1)=", 16L);
	for (i = 0; i <= 5; ++i) {
	    do_lio(&c__4, &c__1, (char *)&stack[i], (ftnlen)sizeof(real));
	}
	e_wsle();
	s_wsle(&io___786);
	do_lio(&c__9, &c__1, "cnstr2:savept=", 14L);
	for (i = 0; i <= 5; ++i) {
	    do_lio(&c__4, &c__1, (char *)&savept[i], (ftnlen)sizeof(real));
	}
	e_wsle();
    } else if (stack[0] > 0.f) {
/*          arc de centre stack(1), une contrainte en savept, */
/*                                  une contrainte en res(solut) */
/*           print*,'contour arc voir acacnt (16)',(stack(i,1),i=0,5) 
*/
	i = (solut + 1) % 16 + 1;
	res[i * 6 - 6] = -2.f;
	res[i * 6 - 5] = stack[1];
	res[i * 6 - 4] = stack[2];
	res[i * 6 - 3] = res[solut * 6 - 5];
	res[i * 6 - 2] = res[solut * 6 - 4];
	r__1 = res[i * 6 - 2] - res[i * 6 - 4];
	r__2 = res[i * 6 - 3] - res[i * 6 - 5];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = savept[2] - res[i * 6 - 4];
	r__2 = savept[1] - res[i * 6 - 5];
	ang2 = atang2_(&r__1, &r__2);
	ang2 = ang2 - ang1 + 6.283185306f;
	ang2 = r_mod(&ang2, &c_b28);
	if (ang2 < 0.f) {
	    ang2 += 6.283185306f;
	}
	res[i * 6 - 1] = ang2;
	solut = i;
    } else {
/*           print*,'cnstr2:contour segment',(stack(i,1),i=0,5) */
	i = (solut + 1) % 16 + 1;
	res[i * 6 - 6] = -3.f;
	res[i * 6 - 5] = savept[1];
	res[i * 6 - 4] = savept[2];
	res[i * 6 - 3] = res[solut * 6 - 5];
	res[i * 6 - 2] = res[solut * 6 - 4];
	solut = i;
    }
    if (solut != 0) {
	rais[solut - 1] = 1.f;
	nurf[(solut << 1) - 2] = 0;
	nurf1[(solut << 1) - 2] = 0;
	nurf2[(solut << 1) - 2] = 0;
	nurf[(solut << 1) - 1] = 0;
	nurf1[(solut << 1) - 1] = 0;
	nurf2[(solut << 1) - 1] = 0;
	nbnd[solut - 1] = 2;
    }
    return ret_val;
L46:
/*        shift pour le contourage sauve le point d'intersection res(solu 
*/
    if (solut == 0) {
	scrtch_("shift:solution nulle?", 21L);
/*           print*,'cnstr2:shift:solution nulle?' */
	savept[0] = -1e3f;
    } else if (res[solut * 6 - 6] == 0.f) {
/*           print*,'cnstr2:shift:solution point' */
	savept[0] = 0.f;
	savept[1] = res[solut * 6 - 5];
	savept[2] = res[solut * 6 - 4];
    } else if (res[solut * 6 - 6] == -2.f) {
/*           print*,'cnstr2:shift:solution arc' */
	savept[0] = 0.f;
	savept[1] = res[solut * 6 - 3];
	savept[2] = res[solut * 6 - 2];
    } else if (res[solut * 6 - 6] == -3.f) {
/*           print*,'cnstr2:shift:solution segment' */
	savept[0] = 0.f;
	savept[1] = res[solut * 6 - 3];
	savept[2] = res[solut * 6 - 2];
    }
/*        puis on decale les elements de la pile stack de 1 vers le bas */
    for (i = 1; i <= 2; ++i) {
	desig[i * 6 - 5] = desig[(i + 1) * 6 - 5];
	desig[i * 6 - 4] = desig[(i + 1) * 6 - 4];
	padr[i - 1] = padr[i];
	for (j = 0; j <= 5; ++j) {
	    stack[j + i * 6 - 6] = stack[j + (i + 1) * 6 - 6];
/* L4602: */
	}
/* L4601: */
    }
    return ret_val;
L47:
/*        changer_angle de bd(padr(1)) */
    drawad_(padr, &c_n1);
    bdpec2_1.bd[padr[0] * 6 + 389] = etat_1.angle;
    cdesig_1.adr = padr[0];
    return ret_val;
L48:
/*        changer_rayon de bd(padr(1)) */
    drawad_(padr, &c_n1);
    if (bdpec2_1.bd[padr[0] * 6 + 384] > 0.f) {
/*          cercle */
	bdpec2_1.bd[padr[0] * 6 + 384] = etat_1.rayon;
    } else {
/*          arc */
	dx = bdpec2_1.bd[padr[0] * 6 + 387] - bdpec2_1.bd[padr[0] * 6 + 385];
	dy = bdpec2_1.bd[padr[0] * 6 + 388] - bdpec2_1.bd[padr[0] * 6 + 386];
	dist = sqrt(dx * dx + dy * dy);
	dx /= dist;
	dy /= dist;
	bdpec2_1.bd[padr[0] * 6 + 387] = bdpec2_1.bd[padr[0] * 6 + 385] + dx *
		 etat_1.rayon;
	bdpec2_1.bd[padr[0] * 6 + 388] = bdpec2_1.bd[padr[0] * 6 + 386] + dy *
		 etat_1.rayon;
    }
    cdesig_1.adr = padr[0];
    return ret_val;
L49:
/*        changer_point de bd(padr(1)) par stack(2) */
    if (padr[0] == 0) {
	scrtch_("on ne peut changer un point immediat", 36L);
	cdesig_1.adr = 0;
	return ret_val;
    }
    drawad_(padr, &c_n1);
    if (cnstr[0] == 353) {
	if (bdpec2_1.bd[padr[0] * 6 + 384] == -2.f || bdpec2_1.bd[padr[0] * 6 
		+ 384] > 0.f) {
	    bdpec2_1.bd[padr[0] * 6 + 385] = stack[7];
	    bdpec2_1.bd[padr[0] * 6 + 386] = stack[8];
	}
    } else if (cnstr[0] == 352) {
	if (bdpec2_1.bd[padr[0] * 6 + 384] == -3.f) {
	    extrm2_(padr, &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	    r__1 = xx1 - desig[1];
/* Computing 2nd power */
	    r__2 = yy1 - desig[2];
/* Computing 2nd power */
	    r__3 = xx2 - desig[1];
/* Computing 2nd power */
	    r__4 = yy2 - desig[2];
	    if (r__1 * r__1 + r__2 * r__2 < r__3 * r__3 + r__4 * r__4) {
		bdpec2_1.bd[padr[0] * 6 + 385] = stack[7];
		bdpec2_1.bd[padr[0] * 6 + 386] = stack[8];
	    } else {
		bdpec2_1.bd[padr[0] * 6 + 387] = stack[7];
		bdpec2_1.bd[padr[0] * 6 + 388] = stack[8];
	    }
	} else if (bdpec2_1.bd[padr[0] * 6 + 384] == -2.f) {
	    extrm2_(padr, &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	    r__1 = xx1 - desig[1];
/* Computing 2nd power */
	    r__2 = yy1 - desig[2];
/* Computing 2nd power */
	    r__3 = xx2 - desig[1];
/* Computing 2nd power */
	    r__4 = yy2 - desig[2];
	    if (r__1 * r__1 + r__2 * r__2 < r__3 * r__3 + r__4 * r__4) {
		bdpec2_1.bd[padr[0] * 6 + 387] = stack[7];
		bdpec2_1.bd[padr[0] * 6 + 388] = stack[8];
	    } else {
		bdpec2_1.bd[padr[0] * 6 + 387] = stack[7];
		bdpec2_1.bd[padr[0] * 6 + 388] = stack[8];
		bdpec2_1.bd[padr[0] * 6 + 389] = -(doublereal)bdpec2_1.bd[
			padr[0] * 6 + 389];
	    }
	} else if (bdpec2_1.bd[padr[0] * 6 + 384] == -4.f) {
	    extrm2_(padr, &xx1, &yy1, &xx2, &yy2);
/* Computing 2nd power */
	    r__1 = xx1 - desig[1];
/* Computing 2nd power */
	    r__2 = yy1 - desig[2];
/* Computing 2nd power */
	    r__3 = xx2 - desig[1];
/* Computing 2nd power */
	    r__4 = yy2 - desig[2];
	    if (r__1 * r__1 + r__2 * r__2 < r__3 * r__3 + r__4 * r__4) {
/*              premier point */
		pt = bdpec2_1.bd[padr[0] * 6 + 386];
	    } else {
/*              dernier point */
		i__1 = (integer) bdpec2_1.bd[padr[0] * 6 + 386];
		pt = last_(&i__1);
	    }
	    bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385] = stack[7];
	    bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386] = stack[8];
	}
    } else if (cnstr[0] == 351) {
	if (bdpec2_1.bd[padr[0] * 6 + 384] == 0.f) {
	    i__1 = bdpec1_1.ptbd;
	    for (i = 1; i <= i__1; ++i) {
		if (bdpec2_1.bd[i * 6 + 384] == -4.f) {
		    pt = bdpec2_1.bd[i * 6 + 386];
L4902:
		    if (pt != 0) {
			if (listea_1.car[pt - 1] == padr[0]) {
			    drawad_(&i, &c_n1);
			    bdpec2_1.bd[padr[0] * 6 + 385] = stack[7];
			    bdpec2_1.bd[padr[0] * 6 + 386] = stack[8];
			    drawad_(&i, &c__0);
			}
			pt = listed_1.cdr[pt - 1];
			goto L4902;
		    }
		}
/* L4901: */
	    }
	    bdpec2_1.bd[padr[0] * 6 + 385] = stack[7];
	    bdpec2_1.bd[padr[0] * 6 + 386] = stack[8];
	}
    }
    cdesig_1.adr = padr[0];
    return ret_val;
L50:
/*        distance */
    etat_1.distan = cdesig_1.numer;
    afetat_();
    return ret_val;
L51:
/*        angle */
    etat_1.angle = cdesig_1.numer * 3.141592653f / 180.f;
    afetat_();
    return ret_val;
L52:
/*        rayon */
    etat_1.rayon = dabs(cdesig_1.numer);
    if (etat_1.rayon == 0.f) {
	scrtch_("attention: rayon nul,on le rend =1.", 35L);
	etat_1.rayon = 1.f;
    }
    afetat_();
    return ret_val;
L53:
/*        effacer */
    drawad_(&cdesig_1.adr, &c_n1);
    return ret_val;
L54:
/*        rapport */
    etat_1.raport = dabs(cdesig_1.numer);
    afetat_();
    return ret_val;
L55:
/*        nombre */
    etat_1.nombre = cdesig_1.numer;
    etat_1.copies = etat_1.nombre;
    afetat_();
    return ret_val;
L56:
/*      segment apres ambiguite_cr8, passe du resultat (solut) de type dr 
*/
/*            au segment allant des contraintes stack(*,1) a stack(*,2) */
    if (solut == 0) {
	scrtch_("ERREUR:segment:segment vide", 27L);
	return ret_val;
    }
    if (res[solut * 6 - 6] != -1.f) {
	scrtch_("ERREUR:segment:segment vide", 27L);
	solut = 0;
	return ret_val;
    }
    i = (solut + 1) % 16 + 1;
    res[i * 6 - 6] = -3.f;
    if (stack[0] >= 0.f && stack[6] >= 0.f) {
/*          deux contraintes arc | cercles (segment tangent) */
	ptgcc_(pj, &res[solut * 6 - 6], stack, &c_b609);
	res[i * 6 - 5] = pj[1];
	res[i * 6 - 4] = pj[2];
/* Computing 2nd power */
	r__2 = stack[7] - stack[1];
/* Computing 2nd power */
	r__3 = stack[8] - stack[2];
	if (stack[0] == 0.f && stack[6] > 0.f && (r__1 = sqrt(r__2 * r__2 + 
		r__3 * r__3) - stack[6], dabs(r__1)) < eps_1.eps) {
/*            la premiere contrainte est un point qui est sur l'au
tre */
/*            contrainte qui est un cercle */
	    ptangc_(stack, &stack[6], &padr[1], pj);
	} else /* if(complicated condition) */ {
/* Computing 2nd power */
	    r__2 = stack[1] - stack[7];
/* Computing 2nd power */
	    r__3 = stack[2] - stack[8];
	    if (stack[6] == 0.f && stack[0] > 0.f && (r__1 = sqrt(r__2 * r__2 
		    + r__3 * r__3) - stack[0], dabs(r__1)) < eps_1.eps) {
/*            la deuxieme contrainte est un point qui est sur 
l'autre */
/*            contrainte qui est un cercle */
		ptangc_(&stack[6], stack, padr, pj);
	    } else {
		ptgcc_(pj, &res[solut * 6 - 6], &stack[6], &c_b609);
	    }
	}
    } else if (stack[0] == -1.f && stack[6] == -1.f) {
/*          deux contraintes de droites */
	ptgcc_(pj, &res[solut * 6 - 6], stack, &c_b609);
	if (pj[0] != -1e3f) {
	    res[i * 6 - 5] = pj[1];
	    res[i * 6 - 4] = pj[2];
	    ptgcc_(pj, &stack[6], &res[solut * 6 - 6], &etat_1.distan);
	} else {
/*            contraintes paralleles */
	    if (bdpec2_1.bd[padr[0] * 6 + 384] == -3.f && bdpec2_1.bd[padr[1] 
		    * 6 + 384] == -3.f) {
		if (padr[0] == padr[1]) {
		    pw[0] = 0.f;
		    pw[1] = bdpec2_1.bd[padr[0] * 6 + 385];
		    pw[2] = bdpec2_1.bd[padr[0] * 6 + 386];
		    pjp1d_(pj, pw, &res[solut * 6 - 6], &c_b609);
		    res[i * 6 - 5] = pj[1];
		    res[i * 6 - 4] = pj[2];
		    pw[0] = 0.f;
		    pw[1] = bdpec2_1.bd[padr[0] * 6 + 387];
		    pw[2] = bdpec2_1.bd[padr[0] * 6 + 388];
		    pjp1d_(pj, pw, &res[solut * 6 - 6], &c_b609);
		} else {
		    res[i * 6 - 5] = (bdpec2_1.bd[padr[0] * 6 + 385] + 
			    bdpec2_1.bd[padr[1] * 6 + 385]) * .5f;
		    res[i * 6 - 4] = (bdpec2_1.bd[padr[0] * 6 + 386] + 
			    bdpec2_1.bd[padr[1] * 6 + 386]) * .5f;
		    pj[0] = 0.f;
		    pj[1] = (bdpec2_1.bd[padr[0] * 6 + 387] + bdpec2_1.bd[
			    padr[1] * 6 + 387]) * .5f;
		    pj[2] = (bdpec2_1.bd[padr[0] * 6 + 388] + bdpec2_1.bd[
			    padr[1] * 6 + 388]) * .5f;
		}
	    } else {
		scrtch_("segment:construction impossible", 31L);
		res[i * 6 - 6] = -1e3f;
	    }
	}
    } else if (stack[0] == -1.f) {
/*           print*,'cnstr2:res(solut) est // a stack(*,1) et est tang
ent */
/*     +           ,' a stack(*,2)' */
	ptgcc_(pj, &res[solut * 6 - 6], &stack[6], &c_b609);
	res[i * 6 - 5] = pj[1];
	res[i * 6 - 4] = pj[2];
	ptgcc_(pj, &stack[6], &res[solut * 6 - 6], &etat_1.distan);
    } else if (stack[6] == -1.f) {
/*           print*,'cnstr2:res(solut) est // a stack(*,2) et est tang
ent */
/*     +           ,' a stack(*,1)' */
	ptgcc_(pj, &res[solut * 6 - 6], stack, &c_b609);
	res[i * 6 - 5] = pj[1];
	res[i * 6 - 4] = pj[2];
	ptgcc_(pj, stack, &res[solut * 6 - 6], &etat_1.distan);
    }
    res[i * 6 - 3] = pj[1];
    res[i * 6 - 2] = pj[2];
    solut = i;
    rais[solut - 1] = 1.f;
    nurf[(solut << 1) - 2] = 0;
    nurf1[(solut << 1) - 2] = 0;
    nurf2[(solut << 1) - 2] = 0;
    nurf[(solut << 1) - 1] = 0;
    nurf1[(solut << 1) - 1] = 0;
    nurf2[(solut << 1) - 1] = 0;
    nbnd[solut - 1] = 2;
    return ret_val;
L57:
/*      tracer l'element pointe par adr */
    drawad_(&cdesig_1.adr, &c__0);
    return ret_val;
L58:
/*      ambiguite_cr8 (leve de l'ambiguite si solutions multiples cas cr8 
*/
/*        dans res   on a nbsol  resultats types */
/*        dans stack on a pstack elements de contrainte types */
/*        dans desig on a pstack points de designation des contraintes */
/*        dans pttg(0:5,2,i) on a les 2 points de tangence sur le cercle 
*/
/*              solution (res(*,i) ) */
/*        dans tnum(i) on a le numero de la solution (1...54) */
    if (nbsol == 0) {
	scrtch_("BIZARRE, il n'y a pas de solution a votre probleme?", 51L);
	solut = 0;
	return ret_val;
    }
    if (nbsol == 1) {
	solut = 1;
	return ret_val;
    }
    dist = 1e30f;
    solut = 0;
    pm[0] = 0.f;
    i__1 = nbsol;
    for (i = 1; i <= i__1; ++i) {
	dist2 = 0.f;
	if (pttg[(i * 3 + 1) * 6 - 24] == -1e3f) {
/*            on prend le milieu des points de designation */
	    pm[1] = (desig[1] + desig[7]) / 2.f;
	    pm[2] = (desig[2] + desig[8]) / 2.f;
	    dist2 = (r__1 = res[i * 6 - 5] * pm[1] + res[i * 6 - 4] * pm[2] + 
		    res[i * 6 - 3], dabs(r__1));
	} else {
	    if (pstack >= 2) {
		k = pstack;
	    } else {
		k = 1;
	    }
	    i__2 = k;
	    for (j = 1; j <= i__2; ++j) {
		if (res[i * 6 - 6] == -1.f) {
		    dist2 += (r__1 = res[i * 6 - 5] * desig[j * 6 - 5] + res[
			    i * 6 - 4] * desig[j * 6 - 4] + res[i * 6 - 3], 
			    dabs(r__1));
		} else {
/* Computing 2nd power */
		    r__1 = desig[j * 6 - 5] - pttg[(j + i * 3) * 6 - 23];
/* Computing 2nd power */
		    r__2 = desig[j * 6 - 4] - pttg[(j + i * 3) * 6 - 22];
		    dist2 = dist2 + r__1 * r__1 + r__2 * r__2;
		}
/* L58002: */
	    }
	    dist2 /= k;
	}
	if (dist2 < dist) {
	    dist = dist2;
	    solut = i;
	}
/* L58001: */
    }
/*         do 58003 j=1,pstack */
/*           write(debugt,'(i1)')j */
/*           call txt2d('tg' // debugt,3,pttg(1,j,solut),pttg(2,j,solut)) 
*/
/*           call txt2d('ds' // debugt,3,desig(1,j),desig(2,j)) */
/* 58003    continue */
    if (solut == 0) {
	scrtch_("ERREUR:ambiguite_cr8:solut est nul", 34L);
	s_wsle(&io___797);
	do_lio(&c__9, &c__1, "cnstr2:nbsol=", 13L);
	do_lio(&c__3, &c__1, (char *)&nbsol, (ftnlen)sizeof(integer));
	i__1 = nbsol;
	for (j = 1; j <= i__1; ++j) {
	    do_lio(&c__4, &c__1, (char *)&res[j * 6 - 6], (ftnlen)sizeof(real)
		    );
	}
	e_wsle();
    }
    return ret_val;
L59:
/*        ambiguite_ccc (leve de l'ambiguite si solutions multiples cas c 
*/
/*        dans res   on a nbsol  resultats types */
/*        dans stack on a pstack elements de contrainte types */
/*        dans desig on a pstack points de designation des contraintes */
/*        dans pttg(0:5,3,i) on a les 3 points de tangence sur le cercle 
*/
/*              solution (res(*,i) ) */
/*        dans tnum(i) on a le numero de la solution (1...54) */
    solut = 0;
    if (nbsol == 1) {
	solut = 1;
	return ret_val;
    }
/*        on recherche la solution dont les points de designation */
/*        sont les plus proche des points de tangence */
    dist = 1e30f;
    i__1 = nbsol;
    for (i = 1; i <= i__1; ++i) {
	dist2 = 0.f;
	i__2 = pstack;
	for (j = 1; j <= i__2; ++j) {
/* Computing 2nd power */
	    r__1 = desig[j * 6 - 5] - pttg[(j + i * 3) * 6 - 23];
/* Computing 2nd power */
	    r__2 = desig[j * 6 - 4] - pttg[(j + i * 3) * 6 - 22];
	    dist2 = dist2 + r__1 * r__1 + r__2 * r__2;
/* L59002: */
	}
	dist2 /= pstack;
	if (dist2 < dist) {
	    dist = dist2;
	    solut = i;
	}
/* L59001: */
    }
/*         do 59003 j=1,pstack */
/*           write(debugt,'(i1)')j */
/*           call txt2d('tg' // debugt,3,pttg(1,j,solut),pttg(2,j,solut)) 
*/
/*           call txt2d('ds' // debugt,3,desig(1,j),desig(2,j)) */
/* 59003    continue */
    if (solut == 0) {
	scrtch_("ERREUR:ambiguite_ccc:solut est nul", 34L);
	s_wsle(&io___798);
	do_lio(&c__9, &c__1, "cnstr2:nbsol=", 13L);
	do_lio(&c__3, &c__1, (char *)&nbsol, (ftnlen)sizeof(integer));
	i__1 = nbsol;
	for (j = 1; j <= i__1; ++j) {
	    do_lio(&c__4, &c__1, (char *)&res[j * 6 - 6], (ftnlen)sizeof(real)
		    );
	}
	e_wsle();
    }
    return ret_val;
L60:
/*        pas_compris */
/*        call scrtch('On a rien compris!')                             #F
R*/
    scrtch_("We do not understand!", 21L);
    return ret_val;
L61:
/*        ajouter_p_spline */
/*        en pstack=1 on a la spline */
/*        en pstack=2 on a le point */
/*        effacer la spline */
    drawad_(padr, &c_n1);
/*        recherche du segment de la spline le plus proche du point */
    dist = dtp1sp_(&bdpec2_1.bd[padr[1] * 6 + 384], padr, &pt);
/*        on trace le point */
    drawad_(&padr[1], &c__0);
/*        on rajoute le point */
    listed_1.cdr[pt - 1] = cons_(&padr[1], &listed_1.cdr[pt - 1]);
    cdesig_1.adr = padr[0];
    return ret_val;
L62:
/*        ajouter_coord_spline */
/*        en pstack=1 on a la spline */
/*        en pstack=2 on a le point (coord) alloc a deja ete appelle */
    bdpec2_1.bd[libre * 6 + 384] = 0.f;
    bdpec2_1.bd[libre * 6 + 385] = stack[7];
    bdpec2_1.bd[libre * 6 + 386] = stack[8];
/*        effacer la spline */
    drawad_(padr, &c_n1);
/*        recherche du segment de la spline le plus proche du point */
    dist = dtp1sp_(&bdpec2_1.bd[libre * 6 + 384], padr, &pt);
/*        on trace le point */
    drawad_(&libre, &c__0);
/*        on rajoute le point */
    listed_1.cdr[pt - 1] = cons_(&libre, &listed_1.cdr[pt - 1]);
    libre = 0;
    cdesig_1.adr = padr[0];
    return ret_val;
L63:
/*        fondre_2_segments */
/*        on a les 2 segments en pile */
    if (padr[0] == padr[1]) {
	scrtch_("on ne peut fondre un element avec lui meme", 42L);
	cdesig_1.adr = 0;
    } else {
	cdesig_1.adr = fndrs_(padr, &padr[1]);
    }
    return ret_val;
L64:
/*        fondre_2_arcs */
/*        on a les 2 arcs en pile */
    if (padr[0] == padr[1]) {
	scrtch_("on ne peut fondre un element avec lui meme", 42L);
	cdesig_1.adr = 0;
    } else {
	cdesig_1.adr = fndra_(padr, &padr[1]);
    }
    return ret_val;
L65:
/*        fondre_2_splines */
/*        on a les 2 splines en pile */
    if (padr[0] == padr[1]) {
	scrtch_("on ne peut fondre un element avec lui meme", 42L);
	cdesig_1.adr = 0;
    } else {
	cdesig_1.adr = fndrsp_(padr, &padr[1]);
    }
    return ret_val;
L66:
/*        arc_idem_c */
    solut = 1;
    res[solut * 6 - 6] = -2.f;
    res[solut * 6 - 5] = stack[pstack * 6 - 5];
    res[solut * 6 - 4] = stack[pstack * 6 - 4];
    res[solut * 6 - 3] = stack[pstack * 6 - 5] + stack[pstack * 6 - 6];
    res[solut * 6 - 2] = stack[pstack * 6 - 4];
    res[solut * 6 - 1] = 6.283185306f;
    return ret_val;
L67:
/*        mark1 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas1, &c__0);
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
	mkcas1 = cdesig_1.nucase;
	menumk_(&numn, &mkcas1, &c__18);
    }
    return ret_val;
L68:
/*        umark1 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas1, &c__0);
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L69:
/*        mark2 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
	mkcas2 = cdesig_1.nucase;
	menumk_(&numn, &mkcas2, &c__18);
    }
    return ret_val;
L70:
/*        umark2 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas2, &c__0);
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L71:
/*        mark3 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas3, &c__0);
	mkcas3 = cdesig_1.nucase;
	menumk_(&numn, &mkcas3, &c__18);
    }
    return ret_val;
L72:
/*        umark3 */
    if (cdesig_1.numenu == numn) {
	menumk_(&numn, &mkcas3, &c__0);
    }
    return ret_val;
L73:
/*        interpolation_segments */
/* Computing MIN */
    i__1 = etat_1.nombre + 2;
    k = min(i__1,500);
    j = min(k,etat_1.nombre);
/*        prends les extremitees  1 des 2 segments */
    res[0] = -3.f;
    res[1] = bdpec2_1.bd[padr[0] * 6 + 385];
    res[2] = bdpec2_1.bd[padr[0] * 6 + 386];
    res[3] = bdpec2_1.bd[padr[1] * 6 + 385];
    res[4] = bdpec2_1.bd[padr[1] * 6 + 386];
    gnin_(res, &xc[1], &yc[1], &k, &etat_1.raport);
/*        prends les extremitees  2 des 2 segments */
    res[0] = -3.f;
    res[1] = bdpec2_1.bd[padr[0] * 6 + 387];
    res[2] = bdpec2_1.bd[padr[0] * 6 + 388];
    res[3] = bdpec2_1.bd[padr[1] * 6 + 387];
    res[4] = bdpec2_1.bd[padr[1] * 6 + 388];
    gnin_(res, &xc[j + 1], &yc[j + 1], &k, &etat_1.raport);
/*        creation des j segments intermediaires */
    i__1 = j;
    for (i = 1; i <= i__1; ++i) {
	libre = alloc_();
	cdesig_1.adr = libre;
	if (cdesig_1.adr == 0) {
	    return ret_val;
	}
	bdpec2_1.bd[libre * 6 + 384] = -3.f;
	bdpec2_1.bd[libre * 6 + 385] = xc[i];
	bdpec2_1.bd[libre * 6 + 386] = yc[i];
	bdpec2_1.bd[libre * 6 + 387] = xc[i + j];
	bdpec2_1.bd[libre * 6 + 388] = yc[i + j];
	bdpec4_1.raison[libre + 64] = bdpec4_1.raison[padr[0] + 64];
	bdpec5_1.nuref[(libre << 1) + 128] = bdpec5_1.nuref[(padr[0] << 1) + 
		128];
	bdpec6_1.nuref1[(libre << 1) + 128] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 128];
	bdpec7_1.nuref2[(libre << 1) + 128] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 128];
	bdpec5_1.nuref[(libre << 1) + 129] = bdpec5_1.nuref[(padr[0] << 1) + 
		129];
	bdpec6_1.nuref1[(libre << 1) + 129] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 129];
	bdpec7_1.nuref2[(libre << 1) + 129] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 129];
	bdpec3_1.nbnode[libre + 64] = bdpec3_1.nbnode[padr[0] + 64];
	drawad_(&libre, &c__0);
/* L7301: */
    }
    return ret_val;
L74:
/*        interpolation_splines */
/*        ont'elles meme nombre de points */
    if (bdpec2_1.bd[padr[0] * 6 + 385] != bdpec2_1.bd[padr[1] * 6 + 385]) {
	scrtch_("splines n'ayant pas le meme nombre de points", 44L);
	return ret_val;
    }
/* Computing MIN */
    i__1 = etat_1.nombre + 2, i__2 = 1000 / i_nint(&bdpec2_1.bd[padr[0] * 6 + 
	    385]);
    k = min(i__1,i__2);
    j = min(k,etat_1.nombre);
    pt1 = bdpec2_1.bd[padr[0] * 6 + 386];
    pt = bdpec2_1.bd[padr[1] * 6 + 386];
    i = 0;
L7402:
    if (pt != 0) {
	res[0] = -3.f;
	res[1] = bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 385];
	res[2] = bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 386];
	res[3] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
	res[4] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
	gnin_(res, &xc[i * j + 1], &yc[i * j + 1], &k, &etat_1.raport);
	++i;
	pt1 = listed_1.cdr[pt1 - 1];
	pt = listed_1.cdr[pt - 1];
	goto L7402;
    }
/*        creation des j splines intermediaires */
    k = bdpec2_1.bd[padr[0] * 6 + 385];
    i__1 = j;
    for (i = 1; i <= i__1; ++i) {
	libre = alloc_();
	if (libre == 0) {
	    return ret_val;
	}
	adrspl = libre;
	tetspl = 0;
	bdpec4_1.raison[adrspl + 64] = bdpec4_1.raison[padr[0] + 64];
	bdpec5_1.nuref[(adrspl << 1) + 128] = bdpec5_1.nuref[(padr[0] << 1) + 
		128];
	bdpec6_1.nuref1[(adrspl << 1) + 128] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 128];
	bdpec7_1.nuref2[(adrspl << 1) + 128] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 128];
	bdpec5_1.nuref[(adrspl << 1) + 129] = bdpec5_1.nuref[(padr[0] << 1) + 
		129];
	bdpec6_1.nuref1[(adrspl << 1) + 129] = bdpec6_1.nuref1[(padr[0] << 1) 
		+ 129];
	bdpec7_1.nuref2[(adrspl << 1) + 129] = bdpec7_1.nuref2[(padr[0] << 1) 
		+ 129];
	bdpec3_1.nbnode[adrspl + 64] = bdpec3_1.nbnode[padr[0] + 64];
/*          on met les points de definitions de la spline */
	i__2 = k;
	for (ii = 1; ii <= i__2; ++ii) {
	    libre = alloc_();
	    if (libre == 0) {
		return ret_val;
	    }
	    bdpec2_1.bd[libre * 6 + 384] = 0.f;
	    bdpec2_1.bd[libre * 6 + 385] = xc[i - 1 + (ii - 1) * j + 1];
	    bdpec2_1.bd[libre * 6 + 386] = yc[i - 1 + (ii - 1) * j + 1];
	    i__3 = cons_(&libre, &c__0);
	    tetspl = appenx_(&tetspl, &i__3);
/* L7403: */
	}
	bdpec2_1.bd[adrspl * 6 + 384] = -4.f;
	bdpec2_1.bd[adrspl * 6 + 385] = (real) length_(&tetspl);
	bdpec2_1.bd[adrspl * 6 + 386] = (real) tetspl;
	drawad_(&adrspl, &c__0);
/* L7401: */
    }
    return ret_val;
L75: 
    constr2_75(res,stack,padr,pttg,tnum);
   return ret_val;

/* ----  FIN NEW VERSION ----- */
L76:
/*          d_idem_s    droite sur un segment */
    solut = 1;
    res[solut * 6 - 6] = stack[pstack * 6 - 6];
    res[solut * 6 - 5] = stack[pstack * 6 - 5];
    res[solut * 6 - 4] = stack[pstack * 6 - 4];
    res[solut * 6 - 3] = stack[pstack * 6 - 3];
    res[solut * 6 - 2] = stack[pstack * 6 - 2];
    res[solut * 6 - 1] = stack[pstack * 6 - 1];
    return ret_val;
} /* cnstr2_ */




/* Subroutine */ int cohefi_(void)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    integer i;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), coherx_(integer *, 
	    integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___811 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___812 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___813 = { 0, 6, 0, 0, 0 };




/*     effectue la coherence de fissur sur toute la bd */

/*     fissur peut etre true meme si le numero de ref a gauche et a droit 
*/
/*                           sont egaux */
/*     mais fissur ne peut etre false si ils sont differents. */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if ((bdpec2_1.bd[i * 6 + 384] == -3.f || bdpec2_1.bd[i * 6 + 384] == 
		-2.f || bdpec2_1.bd[i * 6 + 384] == -4.f) && ! 
		bdpecd_1.fissur[i + 64]) {
	    if (bdpec5_1.nuref[(i << 1) + 128] != bdpec5_1.nuref[(i << 1) + 
		    129]) {
		scrtch_("cohefi:ERREUR fissure nurefg -= nurefd ", 39L);
		s_wsle(&io___811);
		do_lio(&c__9, &c__1, "cohefi:ERREUR fissure en", 24L);
		do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref_g=", 9L);
		do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(i << 1) + 128], 
			(ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref_d=", 9L);
		do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(i << 1) + 129], 
			(ftnlen)sizeof(integer));
		e_wsle();
		bdpec5_1.nuref[(i << 1) + 129] = bdpec5_1.nuref[(i << 1) + 
			128];
	    }
	    if (bdpec6_1.nuref1[(i << 1) + 128] != bdpec6_1.nuref1[(i << 1) + 
		    129]) {
		scrtch_("cohefi:ERREUR fissure nuref1g -= nuref1d ", 41L);
		s_wsle(&io___812);
		do_lio(&c__9, &c__1, "cohefi:ERREUR fissure en", 24L);
		do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref1_g=", 10L);
		do_lio(&c__3, &c__1, (char *)&bdpec6_1.nuref1[(i << 1) + 128],
			 (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref1_d=", 10L);
		do_lio(&c__3, &c__1, (char *)&bdpec6_1.nuref1[(i << 1) + 129],
			 (ftnlen)sizeof(integer));
		e_wsle();
		coherx_(&i, &c__1);
	    }
	    if (bdpec7_1.nuref2[(i << 1) + 128] != bdpec7_1.nuref2[(i << 1) + 
		    129]) {
		s_wsle(&io___813);
		do_lio(&c__9, &c__1, "cohefi:ERREUR fissure en", 24L);
		do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref2_g=", 10L);
		do_lio(&c__3, &c__1, (char *)&bdpec7_1.nuref2[(i << 1) + 128],
			 (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nuref2_d=", 10L);
		do_lio(&c__3, &c__1, (char *)&bdpec7_1.nuref2[(i << 1) + 129],
			 (ftnlen)sizeof(integer));
		e_wsle();
		coherx_(&i, &c__2);
	    }
	}
/* L1: */
    }
    return 0;
} /* cohefi_ */




/* Subroutine */ int coherx_(integer *i, integer *extrm)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    extern /* Subroutine */ int back_(integer *);
    extern integer caar_(integer *), cdar_(integer *), mapc_(S_fp, integer *),
	     cons_(integer *, integer *);
    integer adpx;

    integer j, k, nunur[2], l[2];
    extern /* Subroutine */ int freel_(integer *);
    extern integer revers_(integer *);
    integer pt, ptt[2];
    extern /* Subroutine */ int drawad_(integer *, integer *);



/*     effectue la coherence des numeros de ref a l'extremite extrm de */
/*       l'element i */
/*     extrm=1 ou 2 pour extremite 1 ou 2 */
/*     pour cela on effectue la propagation du nuref de l'extremite */
/*     extrem de i a gauche et a droite jusqu'a: */
/*                 la premiere fissure */
/*              ou l'element i lui meme */
/*      print*,'.....................................................' */
/*      print*,'coherx:i=',i,' extrm=',extrm */
/*      call dumpbd */
    if (! bdpecd_1.fissur[*i + 64]) {
	bdpec5_1.nuref[(*i << 1) + 129] = bdpec5_1.nuref[(*i << 1) + 128];
	bdpec6_1.nuref1[(*i << 1) + 129] = bdpec6_1.nuref1[(*i << 1) + 128];
	bdpec7_1.nuref2[(*i << 1) + 129] = bdpec7_1.nuref2[(*i << 1) + 128];
    }
/*     adresse du point extremite */
    if (*extrm == 1) {
	adpx = bdpec8_1.adp1[*i + 64];
	nunur[0] = bdpec6_1.nuref1[(*i << 1) + 128];
	nunur[1] = bdpec6_1.nuref1[(*i << 1) + 129];
    } else {
	adpx = bdpec9_1.adp2[*i + 64];
	nunur[0] = bdpec7_1.nuref2[(*i << 1) + 128];
	nunur[1] = bdpec7_1.nuref2[(*i << 1) + 129];
    }
/*      print*,'coherx:adpx=',adpx,' nunur(gauche)=',nunur(gauche) */
/*     $                           ,' nunur(droit)=',nunur(droit) */
/*     creation des 2 listes l des elements adjacent a gauche et a droite 
*/
/*      de i (on s'arete sur la 1ere fissure ou sur i) */
    ptt[0] = bdpece_1.adjabd[adpx + 64];
    ptt[1] = revers_(&bdpece_1.adjabd[adpx + 64]);
    l[0] = 0;
    l[1] = 0;
    for (k = 1; k <= 2; ++k) {
	pt = ptt[k - 1];
	j = 0;
L1:
	if (pt != j) {
	    if (j != 0) {
/*           on complete la liste l */
		i__2 = caar_(&pt);
		i__3 = cdar_(&pt);
		i__1 = cons_(&i__2, &i__3);
		l[k - 1] = cons_(&i__1, &l[k - 1]);
	    }
	    if (j == 0 && caar_(&pt) == *i) {
		j = pt;
	    } else if (j != 0 && caar_(&pt) == *i) {
		goto L20;
	    } else if (j != 0 && bdpecd_1.fissur[caar_(&pt) + 64]) {
		goto L10;
	    }
	    pt = listed_1.cdr[pt - 1];
/*         on reboucle eventuelement */
	    if (pt == 0) {
		pt = ptt[k - 1];
	    }
	    goto L1;
	}
L10:
	;
    }
L20:
/*     propagation en tournant des 2 cotes */
    for (k = 1; k <= 2; ++k) {
	pt = l[k - 1];
L2:
	if (pt != 0) {
/*         selon l'extremitee qui est adjacente au point */
	    if (cdar_(&pt) == 1) {
/*           extremite 1 */
		if (! bdpecd_1.fissur[caar_(&pt) + 64]) {
		    bdpec6_1.nuref1[(caar_(&pt) << 1) + 128] = nunur[k - 1];
		    bdpec6_1.nuref1[(caar_(&pt) << 1) + 129] = nunur[k - 1];
		} else {
		    if (k == 1) {
			bdpec6_1.nuref1[(caar_(&pt) << 1) + 129] = nunur[k - 
				1];
		    } else {
			bdpec6_1.nuref1[(caar_(&pt) << 1) + 128] = nunur[k - 
				1];
		    }
		}
	    } else {
/*           extremite 2 */
		if (! bdpecd_1.fissur[caar_(&pt) + 64]) {
		    bdpec7_1.nuref2[(caar_(&pt) << 1) + 128] = nunur[k - 1];
		    bdpec7_1.nuref2[(caar_(&pt) << 1) + 129] = nunur[k - 1];
		} else {
		    if (k == 1) {
			bdpec7_1.nuref2[(caar_(&pt) << 1) + 128] = nunur[k - 
				1];
		    } else {
			bdpec7_1.nuref2[(caar_(&pt) << 1) + 129] = nunur[k - 
				1];
		    }
		}
	    }
	    i__1 = caar_(&pt);
	    drawad_(&i__1, &c__0);
	    pt = listed_1.cdr[pt - 1];
	    goto L2;
	}
/* L11: */
    }
/*     liberation */
    freel_(&ptt[1]);
    j = mapc_((S_fp)back_, &l[1]);
    j = mapc_((S_fp)back_, l);
    freel_(l);
    freel_(&l[1]);
/*      call dumpbd */
/*      print*,'.....................................................' */
    return 0;
} /* coherx_ */




integer colorf_(integer *rf)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer ib, ir, iv;


/*     renvoie la couleur correspondant a la reference rf */
/*       codee en      r +256*v +(2**16)*b */


    if (*rf == 0) {
	ir = ctabc3_1.color[3] * 255.f;
	iv = ctabc3_1.color[4] * 255.f;
	ib = ctabc3_1.color[5] * 255.f;
    } else {
	ir = ctabc3_1.color[(abs(*rf) % 16 + 3) * 3 - 3] * 255.f;
	iv = ctabc3_1.color[(abs(*rf) % 16 + 3) * 3 - 2] * 255.f;
	ib = ctabc3_1.color[(abs(*rf) % 16 + 3) * 3 - 1] * 255.f;
    }
/* Computing MIN */
    i__1 = max(ir,0);
    ir = min(i__1,255);
/* Computing MIN */
    i__1 = max(iv,0);
    iv = min(i__1,255);
/* Computing MIN */
    i__1 = max(ib,0);
    ib = min(i__1,255);
/*      print*,'colorf: rf=',rf,' r=',ir,' v=',iv,' b=',ib */
    ret_val = ir + (iv << 8) + (ib << 16);
    return ret_val;
} /* colorf_ */

#undef coulls


/* Subroutine */ int compres_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */

    integer i;
    integer top, buttom, pt;



/*     compress la bd en application construction */

    if (bdpec1_1.typebd != 511) {
	return 0;
    }
/*     pour les points, nbnode va servir de flag pour savoir si le point 
*/
/*         appartient a une spline */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == 0.f) {
	    bdpec3_1.nbnode[i + 64] = 0;
	}
/* L4: */
    }
/*     recherche des point appartenant aux splines */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    pt = bdpec2_1.bd[i * 6 + 386];
L6:
	    if (pt != 0) {
		bdpec3_1.nbnode[listea_1.car[pt - 1] + 64] = -i;
		pt = listed_1.cdr[pt - 1];
		goto L6;
	    }
	}
/* L5: */
    }
/*     compression des elements */
    buttom = 1;
    top = bdpec1_1.ptbd;
L1:
    if (top > buttom) {
	if (bdpec2_1.bd[buttom * 6 + 384] != -1e3f) {
	    ++buttom;
	    goto L1;
	} else {
/*         il y a une place vide en buttom (bas) */
	    if (bdpec2_1.bd[top * 6 + 384] != -1e3f) {
/*            copier top ===> buttom */
		for (i = 0; i <= 5; ++i) {
		    bdpec2_1.bd[i + buttom * 6 + 384] = bdpec2_1.bd[i + top * 
			    6 + 384];
/* L99: */
		}
		for (i = 1; i <= 2; ++i) {
		    bdpec5_1.nuref[i + (buttom << 1) + 127] = bdpec5_1.nuref[
			    i + (top << 1) + 127];
		    bdpec6_1.nuref1[i + (buttom << 1) + 127] = 
			    bdpec6_1.nuref1[i + (top << 1) + 127];
		    bdpec7_1.nuref2[i + (buttom << 1) + 127] = 
			    bdpec7_1.nuref2[i + (top << 1) + 127];
/* L98: */
		}
		bdpec4_1.raison[buttom + 64] = bdpec4_1.raison[top + 64];
		bdpecd_1.fissur[buttom + 64] = bdpecd_1.fissur[top + 64];
		if (bdpec2_1.bd[top * 6 + 384] == 0.f && bdpec3_1.nbnode[top 
			+ 64] < 0) {
/*              point flagger, on le chaine avec le point 
cree */
		    bdpec3_1.nbnode[top + 64] = buttom;
		    bdpec3_1.nbnode[buttom + 64] = 0;
		} else {
		    bdpec3_1.nbnode[buttom + 64] = bdpec3_1.nbnode[top + 64];
		}
		bdpec2_1.bd[top * 6 + 384] = -1e3f;
		--top;
		++buttom;
		goto L1;
	    } else {
		--top;
		goto L1;
	    }
	}
    }
/*     resolution des ref dans les splines */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    pt = bdpec2_1.bd[i * 6 + 386];
L8:
	    if (pt != 0) {
		if (bdpec3_1.nbnode[listea_1.car[pt - 1] + 64] > 0) {
		    listea_1.car[pt - 1] = bdpec3_1.nbnode[listea_1.car[pt - 
			    1] + 64];
		}
		pt = listed_1.cdr[pt - 1];
		goto L8;
	    }
	}
/* L7: */
    }
/*     recherche de la taille de la bd */
    for (i = bdpec1_1.ptbd; i >= 1; --i) {
	if (bdpec2_1.bd[i * 6 + 384] != -1e3f) {
	    goto L3;
	}
/* L2: */
    }
    i = 0;
L3:
    bdpec1_1.ptbd = i;
    bdpec1_1.finbd = i;
    bdmsh4_1.finbd3 = i;
    return 0;
} /* compres_ */




/* Subroutine */ int connex_(void)
{
    /* Initialized data */

    /*static*/ integer nextrx[2] = { 2,1 };

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_paus(char *, ftnlen);

    /* Local variables */
    extern integer cons_(integer *, integer *);
    extern /* Subroutine */ int draw_(real *);

    integer i, j, k;
    extern /* Subroutine */ int thick_(real *);
    extern integer nxadja_(integer *, integer *, integer *);
    integer idebut, jdebut, nuextr;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);

    /* Fortran I/O blocks */
    /*static*/ cilist io___844 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___845 = { 0, 6, 0, 0, 0 };




/*     fabrique toutes les composantes connexes */

/*     dans les composantes le cdr(car(ptcomp)) indique sur quelle compos 
*/
/*     on est ( la droite ou la gauche). */
/*     pour avoir l'extremitee suivante */
    i__1 = bdpec1_1.ptbd;
    for (i = 1; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    for (j = 1; j <= 2; ++j) {
		bdpeca_1.conx[j + (i << 1) + 127] = nxadja_(&i, &nextrx[j - 1]
			, &nuextr);
		bdpecb_1.cnx[j + (i << 1) + 127] = nuextr;
		bdpecc_1.compos[j + (i << 1) + 127] = 0;
/* L2: */
	    }
	}
/* L1: */
    }
    bdpec1_1.comp = 0;
    idebut = 1;
L999:
/*      print*,'recherche d''une ligne n''ayant pas ses deux chainages' */
/*     +      ,' de composantes connexes crees' */
    i__1 = bdpec1_1.ptbd;
    for (i = idebut; i <= i__1; ++i) {
	if (bdpec2_1.bd[i * 6 + 384] == -2.f || bdpec2_1.bd[i * 6 + 384] == 
		-3.f || bdpec2_1.bd[i * 6 + 384] == -4.f) {
	    if (bdpecc_1.compos[(i << 1) + 128] == 0) {
		j = 1;
/*            print*,'connex:l''element',i,' a sa composante g
auche' */
/*     +            ,' non calculee' */
		goto L4;
	    } else if (bdpecc_1.compos[(i << 1) + 129] == 0) {
		j = 2;
/*            print*,'connex:l''element',i,' a sa composante d
roite' */
/*     +            ,' non calculee' */
		goto L4;
	    }
	}
/* L3: */
    }
/*     tout les chainages des composantes connexes sont pleins */
    return 0;
L4:
/*     creation de la composante */
    i__1 = cons_(&i, &j);
    bdpec1_1.comp = cons_(&i__1, &bdpec1_1.comp);
/*      print*,'connex:numero de composante',compos(j,i) */
    idebut = i;
    jdebut = j;
L5:
/*     le suivant de i est le precedant dans la liste des adjacents */
/*     de i en son extremitee 1 ou 2 selon la composante de i que l'on */
/*     parcourt */
/*     verification que la composante cnx(j,i) de conx(j,i) est libre */
/*     creation du pointeur inverse vers la composante */
    if (bdpecc_1.compos[j + (i << 1) + 127] != 0) {
	scrtch_("CONNEX: ERREUR COMPOSANTE DEJA OCCUPEE", 38L);
	s_wsle(&io___844);
	do_lio(&c__9, &c__1, "CONNEX:", 7L);
	do_lio(&c__3, &c__1, (char *)&bdpeca_1.conx[j + (i << 1) + 127], (
		ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " SUIVANT DE", 11L);
	do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " A SA COMPOSANTE", 16L);
	do_lio(&c__3, &c__1, (char *)&bdpecc_1.compos[j + (i << 1) + 127], (
		ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " DE DEJA OCCUPEE", 16L);
	e_wsle();
	s_wsle(&io___845);
	do_lio(&c__9, &c__1, " CONX(1:2,I),CNX(1:2,I)=", 24L);
	do_lio(&c__3, &c__1, (char *)&bdpeca_1.conx[(i << 1) + 128], (ftnlen)
		sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&bdpeca_1.conx[(i << 1) + 129], (ftnlen)
		sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&bdpecb_1.cnx[(i << 1) + 128], (ftnlen)
		sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&bdpecb_1.cnx[(i << 1) + 129], (ftnlen)
		sizeof(integer));
	e_wsle();
	thick_(&c_b619);
	draw_(&bdpec2_1.bd[i * 6 + 384]);
	draw_(&bdpec2_1.bd[bdpeca_1.conx[j + (i << 1) + 127] * 6 + 384]);
	thick_(&c_b604);
	s_paus("", 0L);
	goto L999;
    }
/*     creation du pointeur inverse vers la composante */
    bdpecc_1.compos[j + (i << 1) + 127] = bdpec1_1.comp;
    k = i;
    i = bdpeca_1.conx[j + (k << 1) + 127];
    j = bdpecb_1.cnx[j + (k << 1) + 127];
    if (i != idebut || j != jdebut) {
/*       element suivant de la composante */
	goto L5;
    } else {
/*       une autre composante */
	goto L999;
    }
    return 0;
} /* connex_ */




integer cons_(integer *pt1, integer *pt2)
{
    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern /* Subroutine */ int tilt_(void);

    /* Fortran I/O blocks */
    /*static*/ cilist io___847 = { 0, 6, 0, 0, 0 };



/*     renvoie: cons= pointeur sur un element de liste dont */
/*     le car est pt1 et le cdr est pt2 */


    ret_val = listes_1.free;
    if (listes_1.free == 0) {
	s_wsle(&io___847);
	do_lio(&c__9, &c__1, "cons: ERREUR:plus de place en liste...", 38L);
	e_wsle();
	assert(0 /* tilt() */);
    } else {
	listes_1.free = listed_1.cdr[ret_val - 1];
	listed_1.cdr[ret_val - 1] = *pt2;
	listea_1.car[ret_val - 1] = *pt1;
    }
    return ret_val;
} /* cons_ */

integer cou1rf_(integer *rf)
{
    /* System generated locals */
    integer ret_val;

/*   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*   but : affectation des couleurs pour emc2 */
/*   --- */
/*   +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/*        mxcou intervient dans: inicol iniiso cou1rf */
/*      coulls(1)       fond */
/*      coulls(2)       pas_fond */
/*      coulls(3:mxcou) autre couleur */

    if (*rf == -1) {
/*        couleur particuliere (pas couleur du fond) */
	ret_val = ctabco_2.coulls[1];
    } else if (*rf == -2) {
/*        couleur des textes   (pas couleur du fond) */
	ret_val = ctabco_2.coulls[1];
    } else {
/*        couleurs des references vont de 3 a mxcou pour les ref -= 0 
*/
	ret_val = ctabco_2.coulls[abs(*rf) % 18 + 1];
    }
/*      print*,'cou1rf: reference=',rf,' cou1rf=',cou1rf */
    return ret_val;
} /* cou1rf_ */

/* Subroutine */ int cprim_(char *buf, integer *l, ftnlen buf_len)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer i_indx(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);

    /* Local variables */
    integer i;


/*     comprime les blancs et les zeros de trop */

L1:
    i = i_indx(buf, ".000000 ", buf_len, 8L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 6 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, ".00000 ", buf_len, 7L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 5 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, ".0000 ", buf_len, 6L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 4 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, ".000 ", buf_len, 5L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 3 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, ".00 ", buf_len, 4L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 2 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, ".0 ", buf_len, 3L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 1 - i__1, 1L);
	goto L1;
    }
    i = i_indx(buf, "00000E", buf_len, 6L);
    if (i != 0) {
	s_copy(buf + (i - 1), " ", 5L, 1L);
	goto L1;
    }
    i = i_indx(buf, "0000E", buf_len, 5L);
    if (i != 0) {
	s_copy(buf + (i - 1), " ", 4L, 1L);
	goto L1;
    }
    i = i_indx(buf, "000E", buf_len, 4L);
    if (i != 0) {
	s_copy(buf + (i - 1), " ", 3L, 1L);
	goto L1;
    }
    i = i_indx(buf, "00E", buf_len, 3L);
    if (i != 0) {
	s_copy(buf + (i - 1), " ", 2L, 1L);
	goto L1;
    }
    i = i_indx(buf, "0E", buf_len, 2L);
    if (i != 0) {
	buf[i - 1] = ' ';
	goto L1;
    }
    i = i_indx(buf, "E+00", buf_len, 4L);
    if (i != 0) {
	i__1 = i;
	s_copy(buf + i__1, " ", i + 4 - i__1, 1L);
	goto L1;
    }
    *l = 1;
    i__1 = i_len(buf, buf_len);
    for (i = 1; i <= i__1; ++i) {
	if (buf[i - 1] != ' ') {
	    buf[*l - 1] = buf[i - 1];
	    ++(*l);
	}
/* L2: */
    }
    --(*l);
    i__1 = *l;
    s_copy(buf + i__1, " ", i_len(buf, buf_len) - i__1, 1L);
    return 0;
} /* cprim_ */

/* Subroutine */ int cr8_(real *c1, real *c2, real *r, real *c, real *ptg, 
	integer *type, integer *nbsol, real *alpha, real *dist)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int itd1d_(real *, real *, real *);
    real d[4];
    integer i, j, k;
    extern /* Subroutine */ int dp1d1a_(real *, real *, real *, real *);
    real m[4];
    extern /* Subroutine */ int bsd1d2_(real *, real *, real *), itc1c2_(real 
	    *, real *, real *), ptgcc_(real *, real *, real *, real *), 
	    drp1p2_(real *, real *, real *);
    real r1, r2, cc[16]	/* was [4][4] */, pp[12]	/* was [6][2] */;
    extern /* Subroutine */ int addray_(real *, real *, real *);


/*     retourne dans c les nbsol solutions du cercle  de rayon r */
/*     tangent a c1 et c2 */
/*     dans ptg les deux points de tangence de la solution(i) avec c1 et 
*/
/*     dans type(i) numero de la solution */
/*     si c1=point et c2=droite et r=droite on tourne de alpha /c1 */
/*     si c2=point et c1=droite et r=droite on tourne de alpha /c2 */



    /* Parameter adjustments */
    --type;
    ptg -= 24;
    c -= 6;

    /* Function Body */
    for (i = 1; i <= 8; ++i) {
	c[i * 6] = -1e3f;
	ptg[(i * 3 + 1) * 6] = -1e3f;
	ptg[(i * 3 + 2) * 6] = -1e3f;
	type[i] = i;
/* L20: */
    }
    *nbsol = 0;
    if (c1[0] == -1e3f || c2[0] == -1e3f || *r == -1e3f) {
	return 0;
    }
    if (*r > 0.f) {
/*       on demande des solutions de type cercle */
	r__1 = -(doublereal)(*r);
	addray_(c1, &r__1, cc);
	addray_(c1, r, &cc[4]);
	r__1 = -(doublereal)(*r);
	addray_(c2, &r__1, &cc[8]);
	addray_(c2, r, &cc[12]);
/*        call draw(cc(0,1)) */
/*        call draw(cc(0,2)) */
/*        call draw(cc(0,3)) */
/*        call draw(cc(0,4)) */
	itc1c2_(&c[6], cc, &cc[8]);
	itc1c2_(&c[18], cc, &cc[12]);
	itc1c2_(&c[30], &cc[4], &cc[8]);
	itc1c2_(&c[42], &cc[4], &cc[12]);
	for (i = 1; i <= 8; ++i) {
	    if (c[i * 6] == 0.f) {
		c[i * 6] = *r;
		ptgcc_(&ptg[(i * 3 + 1) * 6], &c[i * 6], c1, &c_b609);
		ptgcc_(&ptg[(i * 3 + 2) * 6], &c[i * 6], c2, &c_b609);
	    }
/* L1: */
	}
	*nbsol = 8;
    } else if (*r == 0.f) {
/*       on demande des solutions de type point (intersections c1 c2 )
 */
	itc1c2_(&c[6], c1, c2);
	*nbsol = 2;
	for (i = 0; i <= 3; ++i) {
	    ptg[i + 24] = c[i + 6];
	    ptg[i + 30] = c[i + 6];
	    ptg[i + 42] = c[i + 12];
	    ptg[i + 48] = c[i + 12];
/* L2: */
	}
    } else if (*r == -1.f) {
/*       ici on demande des solutions de type droite */
	if (c1[0] == -1.f) {
	    if (c2[0] == -1.f) {
		if (c1[1] == c2[1] && c1[2] == c2[2] && c1[3] == c2[3]) {
/*              c1 et c2 sont identiques, on construit les
 droites // c1 */
/*              a une distance dist de c1 */
		    c[6] = c1[0];
		    c[7] = c1[1];
		    c[8] = c1[2];
		    c[9] = c1[3] + *dist;
		    c[12] = c1[0];
		    c[13] = c1[1];
		    c[14] = c1[2];
		    c[15] = c1[3] - *dist;
		} else {
/*              c1 et c2 sont differentes, (on prend les b
issectrices) */
		    bsd1d2_(&c[6], c1, c2);
		}
		*nbsol = 2;
	    } else if (c2[0] == 0.f) {
/*           c1 est une droite et c2 est un point */
/*               (rend la droite faisant un angle alpha / c1 p
assant par */
		dp1d1a_(&c[6], c2, c1, alpha);
		*nbsol = 1;
	    } else {
/*           c1 est une droite et c2 est un cercle */
/*             (rend les // a c1 et tangent a c2) */
		dp1d1a_(d, c2, c1, &c_b2168);
		itc1c2_(pp, d, c2);
		dp1d1a_(&c[6], pp, c1, &c_b609);
		dp1d1a_(&c[12], &pp[6], c1, &c_b609);
		*nbsol = 2;
		for (i = 0; i <= 3; ++i) {
		    ptg[i + 30] = pp[i];
		    ptg[i + 48] = pp[i + 6];
/* L9: */
		}
		itd1d_(&ptg[24], c1, d);
		itd1d_(&ptg[42], c1, d);
	    }
	} else if (c1[0] == 0.f) {
	    if (c2[0] == -1.f) {
/*           c1 est un point et c2 est une droite */
/*             rend la droite faisant un angle alpha / c2 pass
ant par c1 */
		dp1d1a_(&c[6], c1, c2, alpha);
		*nbsol = 1;
	    } else if (c2[0] == 0.f) {
/*           c1 est un point et c2 est un point */
/*             (rend droite passant par c1 et c2) */
		drp1p2_(&c[6], c1, c2);
		*nbsol = 1;
	    } else {
/*           c1 est un point et c2 est un cercle */
/* Computing 2nd power */
		r__1 = c1[1] - c2[1];
/* Computing 2nd power */
		r__2 = c1[2] - c2[2];
		m[0] = sqrt(r__1 * r__1 + r__2 * r__2);
/*           c1 est'il sur c2? */
		if ((r__1 = m[0] - c2[0], dabs(r__1)) < eps_1.eps) {
/*             c1 est sur c2, on rend la droite tangente a
 c2 en c1 */
		    drp1p2_(m, c1, c2);
		    dp1d1a_(&c[6], c1, m, &c_b2168);
		    *nbsol = 1;
		    for (i = 0; i <= 3; ++i) {
			ptg[i + 24] = c1[i];
			ptg[i + 30] = c1[i];
/* L3: */
		    }
		} else {
		    m[0] /= 2.f;
		    m[1] = (c1[1] + c2[1]) / 2.f;
		    m[2] = (c1[2] + c2[2]) / 2.f;
		    itc1c2_(pp, m, c2);
		    drp1p2_(&c[6], c1, pp);
		    drp1p2_(&c[12], c1, &pp[6]);
		    *nbsol = 2;
		    for (i = 0; i <= 3; ++i) {
			ptg[i + 24] = c1[i];
			ptg[i + 42] = c1[i];
/* L4: */
		    }
		    ptgcc_(&ptg[30], &c[6], c2, &c_b609);
		    ptgcc_(&ptg[48], &c[12], c2, &c_b609);
		}
	    }
	} else if (c1[0] > 0.f) {
	    if (c2[0] == -1.f) {
/*           c1 est un cercle et c2 est une droite */
/*             rend les // a c2 et tangentes a c1 */
		dp1d1a_(d, c1, c2, &c_b2168);
		itc1c2_(pp, d, c1);
		dp1d1a_(&c[6], pp, c2, &c_b609);
		dp1d1a_(&c[12], &pp[6], c2, &c_b609);
		*nbsol = 2;
		for (i = 0; i <= 3; ++i) {
		    ptg[i + 24] = pp[i];
		    ptg[i + 42] = pp[i + 6];
/* L8: */
		}
		itd1d_(&ptg[30], c2, d);
		itd1d_(&ptg[48], c2, d);
	    } else if (c2[0] == 0.f) {
/*           c1 est un cercle et c2 est un point */
/* Computing 2nd power */
		r__1 = c1[1] - c2[1];
/* Computing 2nd power */
		r__2 = c1[2] - c2[2];
		m[0] = sqrt(r__1 * r__1 + r__2 * r__2);
/*           c2 est'il sur c1 ? */
		if ((r__1 = m[0] - c1[0], dabs(r__1)) < eps_1.eps) {
/*             c2 est sur c1, on rend la droite tangente a
 c1 en c2 */
		    drp1p2_(m, c2, c1);
		    dp1d1a_(&c[6], c2, m, &c_b2168);
		    *nbsol = 1;
		    for (i = 0; i <= 3; ++i) {
			ptg[i + 24] = c2[i];
			ptg[i + 30] = c2[i];
/* L5: */
		    }
		} else {
		    m[0] /= 2.f;
		    m[1] = (c1[1] + c2[1]) / 2.f;
		    m[2] = (c1[2] + c2[2]) / 2.f;
		    itc1c2_(pp, c1, m);
		    drp1p2_(&c[6], c2, pp);
		    drp1p2_(&c[12], c2, &pp[6]);
		    *nbsol = 2;
		    for (i = 0; i <= 3; ++i) {
			ptg[i + 30] = c2[i];
			ptg[i + 48] = c2[i];
/* L6: */
		    }
		    ptgcc_(&ptg[24], &c[6], c1, &c_b609);
		    ptgcc_(&ptg[42], &c[12], c1, &c_b609);
		}
	    } else {
/*           c1 est un cercle et c2 est un cercle */
/* Computing 2nd power */
		r__1 = c1[1] - c2[1];
/* Computing 2nd power */
		r__2 = c1[2] - c2[2];
		m[0] = sqrt(r__1 * r__1 + r__2 * r__2) / 2.f;
		m[1] = (c1[1] + c2[1]) / 2.f;
		m[2] = (c1[2] + c2[2]) / 2.f;
		r1 = c1[0];
		r2 = c2[0];
/*           on construit les solution croisees ( 3 et 4) */
		addray_(c1, c2, cc);
		itc1c2_(pp, cc, m);
		if (pp[0] == -1e3f) {
		    *nbsol = 2;
		} else {
		    drp1p2_(&c[18], pp, c2);
		    drp1p2_(&c[24], &pp[6], c2);
		    c[21] -= r2;
		    c[27] += r2;
		    *nbsol = 4;
		}
		if (r1 > r2) {
		    r__1 = -(doublereal)r2;
		    addray_(c1, &r__1, cc);
		    itc1c2_(pp, cc, m);
		    drp1p2_(&c[6], pp, c2);
		    drp1p2_(&c[12], &pp[6], c2);
		    c[9] += r2;
		    c[15] -= r2;
		} else if (r1 == r2) {
		    drp1p2_(&c[6], c1, c2);
		    drp1p2_(&c[12], c1, c2);
		    c[9] += r2;
		    c[15] -= r2;
		} else {
/*             r1 < r2 */
		    r__1 = -(doublereal)r1;
		    addray_(c2, &r__1, cc);
		    itc1c2_(pp, m, cc);
		    drp1p2_(&c[6], c1, pp);
		    drp1p2_(&c[12], c1, &pp[6]);
		    c[9] += r1;
		    c[15] -= r1;
		}
		i__1 = *nbsol;
		for (i = 1; i <= i__1; ++i) {
		    ptgcc_(&ptg[(i * 3 + 1) * 6], &c[i * 6], c1, &c_b609);
		    ptgcc_(&ptg[(i * 3 + 2) * 6], &c[i * 6], c2, &c_b609);
/* L7: */
		}
	    }
	}
    }
/*     tassement des solutions */
    j = 0;
    i__1 = *nbsol;
    for (i = 1; i <= i__1; ++i) {
	if (c[i * 6] != -1e3f) {
	    ++j;
	    type[j] = type[i];
	    for (k = 0; k <= 5; ++k) {
		c[k + j * 6] = c[k + i * 6];
		ptg[k + (j * 3 + 1) * 6] = ptg[k + (i * 3 + 1) * 6];
		ptg[k + (j * 3 + 2) * 6] = ptg[k + (i * 3 + 2) * 6];
/* L98: */
	    }
	}
/* L99: */
    }
    *nbsol = j;
    return 0;
} /* cr8_ */

#undef coulls


/* Subroutine */ int ctgccc_(real *c, real *c1, real *c2, real *c3, real *ptg,
	 integer *type, integer *nb)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal pint[64]	/* was [4][16] */;
    integer i, j;
    extern /* Subroutine */ int ccctg3_(real *, real *, real *, doublereal *, 
	    real *, real *, integer *, integer *), cnqcc2_(real *, real *, 
	    doublereal *, doublereal *), cnqint_(doublereal *, doublereal *, 
	    doublereal *);
    doublereal ca12[6], ca13[6], ca23[6], cb12[6], cb13[6], cb23[6], ra12, 
	    rb12, ra13, rb13, ra23, rb23;

/*      real ctr(0:3) */
/*      print *,' entrer dans ctgccc c1=',c1,'c2=',c2,'c3=',c3 */
/*     teste du cas particulier ou c1 c2 c3 sont des points et que */
/*       deux d'entre eux sont egaux */
    /* Parameter adjustments */
    --type;
    ptg -= 24;
    c -= 6;

    /* Function Body */
    *nb = 1;
    ptg[24] = 0.f;
    ptg[25] = c1[1];
    ptg[26] = c1[2];
    ptg[30] = 0.f;
    ptg[31] = c2[1];
    ptg[32] = c2[2];
    ptg[36] = 0.f;
    ptg[37] = c3[1];
    ptg[38] = c3[2];
    type[1] = 1;
    c[6] = 0.f;
/*      print*,'ctgccc: c1(0)=',c1(0),' c2(0)=',c2(0),' c3(0)=',c3(0) */
    if (c1[0] == 0.f && c2[0] == 0.f && c3[0] == 0.f) {
/*        print*,'ctgccc: 3 points en contrainte' */
	if (c1[1] == c2[1] && c1[2] == c2[2]) {
/*          print*,'ctgccc: c1 = c2' */
/* Computing 2nd power */
	    r__1 = c1[1] - c3[1];
/* Computing 2nd power */
	    r__2 = c1[2] - c3[2];
	    c[6] = sqrt(r__1 * r__1 + r__2 * r__2) * .5f;
	    c[7] = (c1[1] + c3[1]) * .5f;
	    c[8] = (c1[2] + c3[2]) * .5f;
	} else if (c1[1] == c3[1] && c1[2] == c3[2]) {
/*          print*,'ctgccc: c1 = c3' */
/* Computing 2nd power */
	    r__1 = c1[1] - c2[1];
/* Computing 2nd power */
	    r__2 = c1[2] - c2[2];
	    c[6] = sqrt(r__1 * r__1 + r__2 * r__2) * .5f;
	    c[7] = (c1[1] + c2[1]) * .5f;
	    c[8] = (c1[2] + c2[2]) * .5f;
	} else if (c3[1] == c2[1] && c3[2] == c2[2]) {
/*          print*,'ctgccc: c3 = c2' */
/* Computing 2nd power */
	    r__1 = c1[1] - c3[1];
/* Computing 2nd power */
	    r__2 = c1[2] - c3[2];
	    c[6] = sqrt(r__1 * r__1 + r__2 * r__2) * .5f;
	    c[7] = (c1[1] + c3[1]) * .5f;
	    c[8] = (c1[2] + c3[2]) * .5f;
	}
	if (c[6] != 0.f) {
/*          print*,'ctgccc: cas particuliers 2 points confondus' 
*/
/*          print*,'centre=',c(1,1),c(2,1),' rayon=',c(0,1) */
	    return 0;
	}
    }
    *nb = 0;
    for (i = 1; i <= 8; ++i) {
	pint[(i << 2) - 4] = -1e3f;
	pint[(i << 2) - 3] = 0.;
	pint[(i << 2) - 2] = 0.;
	pint[(i << 2) - 1] = 0.;
	c[i * 6] = -1e3f;
	ptg[(i * 3 + 1) * 6] = -1e3f;
	ptg[(i * 3 + 2) * 6] = -1e3f;
	ptg[(i * 3 + 3) * 6] = -1e3f;
	for (j = 1; j <= 5; ++j) {
	    c[j + i * 6] = 0.f;
	    ptg[j + (i * 3 + 1) * 6] = 0.f;
	    ptg[j + (i * 3 + 2) * 6] = 0.f;
	    ptg[j + (i * 3 + 3) * 6] = 0.f;
/* L1: */
	}
    }
    ra12 = dmax(c1[0],0.f) + dmax(c2[0],0.f);
    rb12 = dmax(c1[0],0.f) - dmax(c2[0],0.f);
    if (rb12 >= 0.) {
	rb12 = -rb12;
    }
    ra13 = dmax(c1[0],0.f) + dmax(c3[0],0.f);
    rb13 = dmax(c1[0],0.f) - dmax(c3[0],0.f);
    if (rb13 >= 0.) {
	rb13 = -rb13;
    }
    ra23 = dmax(c2[0],0.f) + dmax(c3[0],0.f);
    rb23 = dmax(c2[0],0.f) - dmax(c3[0],0.f);
    if (rb23 >= 0.) {
	rb23 = -rb23;
    }
    cnqcc2_(c1, c2, &ra12, ca12);
    cnqcc2_(c1, c2, &rb12, cb12);
    cnqcc2_(c1, c3, &ra13, ca13);
    cnqcc2_(c1, c3, &rb13, cb13);
    cnqcc2_(c2, c3, &ra23, ca23);
    cnqcc2_(c2, c3, &rb23, cb23);
/*      print *,' ca12 ',ca12 */
/*      print *,' cb12 ',cb12 */
/*      print *,' ca13 ',ca13 */
/*      print *,' cb13 ',cb13 */
/*      print *,' ca23 ',ca23 */
/*      print *,' cb23 ',cb23 */
/*      call draw3(4) */
/*      call ligh3 (-1,-1,2*(1+6+36)) */
    cnqint_(ca12, ca13, pint);
    cnqint_(ca12, cb13, &pint[16]);
    cnqint_(cb12, ca13, &pint[32]);
    cnqint_(cb12, cb13, &pint[48]);
/*      call draw3(2) */
/*      call ligh3 (-1,-1,2) */
/*      call drawcq (ca12) */
/*      call ligh3 (-1,-1,4) */
/*      call drawcq (cb12) */
/*      call ligh3 (-1,-1,6*2) */
/*      call drawcq (ca13) */
/*      call ligh3 (-1,-1,6*4) */
/*      call drawcq (cb13) */
/*      call ligh3 (-1,-1,36*2) */
/*      call drawcq (ca23) */
/*      call ligh3 (-1,-1,36*4) */
/*      call drawcq (cb23) */
/*      call draw3(0) */
/*      call ligh3 (-1,-1,5+30) */
    for (i = 1; i <= 16; ++i) {
/*       ctr(0)=pint(0,i) */
/*       if(ctr(0).eq.0) then */
/*         ctr(1)=pint(1,i) */
/*         ctr(2)=pint(2,i) */
/*         write(ch,'(i2)') i */
/*         call txt2d (ch,2,ctr(1),ctr(2)) */
/*         call draw(ctr) */
/*       endif */
	ccctg3_(c1, c2, c3, &pint[(i << 2) - 4], &c[6], &ptg[24], &type[1], 
		nb);
/* L20: */
    }
/*      call ligh3 (-1,-1,210) */
/*      do 30 i=1,8 */
/*       if(c(0,i).ge.0.) then */
/*         write(ch,'(i2)') i */
/*         call txt2d (ch(2:2),1,c(1,i),c(2,i)) */
/*       endif */
/*       call draw(c(0,i)) */
/* 30    continue */
/*      call ligh3(-1,-1,215) */
    return 0;
} /* ctgccc_ */

#undef coulls


/* Subroutine */ int cutpc_(real *pp, integer *ad, real *cc, real *rais, 
	integer *nurf, integer *nurf1, integer *nurf2, integer *nbnd)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), sqrt(doublereal);

    /* Local variables */
    integer iadr;
    real deno;
    extern integer cons_(integer *, integer *);
    real dmin_, long_;
    integer *tgen/*[500]*/;
    real *xgen/*[2000]*/, *ygen/*[2000]*/;
    extern /* Subroutine */ int pjp1d_(real *, real *, real *, real *);

    extern integer alloc_(void);
    integer i, n, nbgen, libre;
    extern doublereal atang2_(real *, real *);
    extern /* Subroutine */ int drp1p2_(real *, real *, real *);
    real dd[4];
    extern integer length_(integer *);
    extern logical testpx_(real *, real *);
    extern doublereal dtp1xx_(real *, real *);
    real pp1[4], pp2[4], dx, dy, ang, ang1, ang2, rap, ddd, densit, ss[5];
    integer pt, nupred, nproch, nnn;
    real *xsp/*[501]*/, *ysp/*[501]*/;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), genspl_(real *, real 
	    *, integer *, real *, real *, real *, real *, integer *, integer *
	    , integer *);
   assert(tgen = (integer *) malloc(sizeof(integer)*500));
   assert(xgen = (real *) malloc(sizeof(real)*2000));
   assert(ygen = (real *) malloc(sizeof(real)*2000));
   assert(ysp  = (real *) malloc(sizeof(real)*501));
   assert(xsp  = (real *) malloc(sizeof(real)*501));


/*     coupe l'element d'adresse ad dans la bd a la projection de pp */
/*     sur l'element. on modifie l'element d'adrese ad dans la bd, */
/*     et l'element creer en plus est mis dans cc */
/*     rais,nurf,nurf1,nurf2,nbnd valent raison(ad),nuref(*,ad),nuref1(*, 
*/
/*                                       nuref2(*,ad),ndnode(ad) */



    /* Parameter adjustments */
    --nurf2;
    --nurf1;
    --nurf;

    /* Function Body */
    if (pp[0] != 0.f) {
	cc[0] = -1e3f;
	free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
	return 0;
    } else if (bdpec2_1.bd[*ad * 6 + 384] >= 0.f || bdpec2_1.bd[*ad * 6 + 384]
	     == -1.f) {
	cc[0] = -1e3f;
	free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
    return 0;
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
	if (! testpx_(pp, &bdpec2_1.bd[*ad * 6 + 384])) {
/*         on n'est pas dans l'angle */
	    cc[0] = -1e3f;
	    free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
        return 0;
	}
/*       l'arc cree aura le meme centre */
	cc[0] = -2.f;
	cc[1] = bdpec2_1.bd[*ad * 6 + 385];
	cc[2] = bdpec2_1.bd[*ad * 6 + 386];
	dx = bdpec2_1.bd[*ad * 6 + 387] - bdpec2_1.bd[*ad * 6 + 385];
	dy = bdpec2_1.bd[*ad * 6 + 388] - bdpec2_1.bd[*ad * 6 + 386];
	r__1 = pp[2] - bdpec2_1.bd[*ad * 6 + 386];
	r__2 = pp[1] - bdpec2_1.bd[*ad * 6 + 385];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = bdpec2_1.bd[*ad * 6 + 388] - bdpec2_1.bd[*ad * 6 + 386];
	r__2 = bdpec2_1.bd[*ad * 6 + 387] - bdpec2_1.bd[*ad * 6 + 385];
	ang2 = atang2_(&r__1, &r__2);
	if (bdpec2_1.bd[*ad * 6 + 389] < 0.f) {
	    ang = ang1 - ang2;
	    if (ang > 0.f) {
		ang += -6.283185306f;
	    }
	} else {
	    ang = ang1 - ang2;
	    if (ang < 0.f) {
		ang += 6.283185306f;
	    }
	}
	cc[5] = bdpec2_1.bd[*ad * 6 + 389] - ang;
	bdpec2_1.bd[*ad * 6 + 389] = ang;
	cc[3] = bdpec2_1.bd[*ad * 6 + 385] + dx * cos(ang) - dy * sin(ang);
	cc[4] = bdpec2_1.bd[*ad * 6 + 386] + dx * sin(ang) + dy * cos(ang);
	if ((r__1 = bdpec2_1.bd[*ad * 6 + 389], dabs(r__1)) == 0.f) {
	    scrtch_("ARC D'ANGLE NUL", 15L);
	    bdpec2_1.bd[*ad * 6 + 384] = -1e3f;
	    rap = 1.f;
	} else {
	    rap = cc[5] / bdpec2_1.bd[*ad * 6 + 389];
	}
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -3.f) {
	if (! testpx_(pp, &bdpec2_1.bd[*ad * 6 + 384])) {
/*         la projection de pp n'est pas sur le segment */
	    cc[0] = -1e3f;
	     free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
        return 0;
	}
	pp1[0] = 0.f;
	pp1[1] = bdpec2_1.bd[*ad * 6 + 385];
	pp1[2] = bdpec2_1.bd[*ad * 6 + 386];
	pp2[0] = 0.f;
	pp2[1] = bdpec2_1.bd[*ad * 6 + 387];
	pp2[2] = bdpec2_1.bd[*ad * 6 + 388];
	drp1p2_(dd, pp1, pp2);
	pjp1d_(cc, pp, dd, &c_b609);
	cc[0] = -3.f;
	cc[3] = bdpec2_1.bd[*ad * 6 + 387];
	cc[4] = bdpec2_1.bd[*ad * 6 + 388];
	bdpec2_1.bd[*ad * 6 + 387] = cc[1];
	bdpec2_1.bd[*ad * 6 + 388] = cc[2];
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[*ad * 6 + 387] - bdpec2_1.bd[*ad * 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[*ad * 6 + 388] - bdpec2_1.bd[*ad * 6 + 386];
	deno = r__1 * r__1 + r__2 * r__2;
	if (dabs(deno) == 0.f) {
	    scrtch_("SEGMENT DE LONGUEUR NULLE", 25L);
	    bdpec2_1.bd[*ad * 6 + 384] = -1e3f;
	    rap = 1.f;
	} else {
/* Computing 2nd power */
	    r__1 = cc[3] - cc[1];
/* Computing 2nd power */
	    r__2 = cc[4] - cc[2];
	    rap = (r__1 * r__1 + r__2 * r__2) / deno;
	}
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -4.f) {
	if (! testpx_(pp, &bdpec2_1.bd[*ad * 6 + 384]) || bdpec2_1.bd[*ad * 6 
		+ 385] == 1.f) {
/*         pp n'est pas sur la spline */
	    cc[0] = -1e3f;
	    free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
         return 0;
	}
	i__1 = (integer) bdpec2_1.bd[*ad * 6 + 386];
	bdpec2_1.bd[*ad * 6 + 385] = (real) length_(&i__1);
	pt = bdpec2_1.bd[*ad * 6 + 386];
	n = 0;
L3:
	if (pt != 0) {
	    ++n;
	    if (n <= 500) {
		xsp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
		ysp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
/*           on en profite pour tester si pp est un point de c
ontrol */
		if (pp[1] == xsp[n] && pp[2] == ysp[n]) {
		    if (n == 1 || (real) n == bdpec2_1.bd[*ad * 6 + 385]) {
/*               couper une spline par ses extremitees
 on ne fait rien */
			cc[0] = -1e3f;
			    free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
           return 0;
		    }
/*       print*,'section d"une spline par l"un de ses poin
ts de control' */
		    cc[0] = -4.f;
		    cc[2] = (real) cons_(&listea_1.car[pt - 1], &listed_1.cdr[
			    pt - 1]);
		    listed_1.cdr[pt - 1] = 0;
		    rap = bdpec2_1.bd[*ad * 6 + 386] / n;
		    i__1 = (integer) cc[2];
		    cc[1] = (real) length_(&i__1);
		    i__1 = (integer) bdpec2_1.bd[*ad * 6 + 386];
		    bdpec2_1.bd[*ad * 6 + 385] = (real) length_(&i__1);
		    goto L9876;
		}
		pt = listed_1.cdr[pt - 1];
		goto L3;
	    }
	}
	densit = 1.f;
	genspl_(xsp, ysp, &n, &eps_1.eps, &densit, xgen, ygen, &c__2000, &
		nbgen, tgen);
/*       recherche du segment de la spline le plus proche de pp */
	dmin_ = 1e30f;
	long_ = 0.f;
	deno = 0.f;
	nproch = 0;
	i__1 = nbgen - 1;
	for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	    r__1 = xgen[i - 1] - xgen[i];
/* Computing 2nd power */
	    r__2 = ygen[i - 1] - ygen[i];
	    long_ += sqrt(r__1 * r__1 + r__2 * r__2);
	    ss[0] = -3.f;
	    ss[1] = xgen[i - 1];
	    ss[2] = ygen[i - 1];
	    ss[3] = xgen[i];
	    ss[4] = ygen[i];
	    ddd = dtp1xx_(pp, ss);
	    if (ddd <= dmin_) {
		if (ddd == dmin_) {
/*             on teste si on a une extremitee, dans ce ca
s on choisi */
/*              ce qui n'est pas une extremitee */
		    if (i != 1 && i != nbgen) {
			nproch = i;
			deno = long_;
		    }
		} else {
		    nproch = i;
		    deno = long_;
		}
		dmin_ = ddd;
	    }
/* L1: */
	}
	if (nproch != 1 && nproch != nbgen) {
/*         recherche du numero du point de control precedant */
	    i__1 = n;
	    for (i = 1; i <= i__1; ++i) {
		if (tgen[i - 1] <= nproch) {
		    nupred = i;
		}
/* L2: */
	    }
/*         recherche de l'adresse de ce point de control */
	    pt = bdpec2_1.bd[*ad * 6 + 386];
	    nnn = 1;
	    iadr = 0;
L4:
	    if (pt != 0) {
		if (nnn == nupred) {
		    iadr = pt;
		    goto L5;
		}
		++nnn;
		pt = listed_1.cdr[pt - 1];
		goto L4;
	    }
L5:
	    ss[0] = -3.f;
	    ss[1] = xgen[nproch - 1];
	    ss[2] = ygen[nproch - 1];
	    ss[3] = xgen[nproch];
	    ss[4] = ygen[nproch];
/*         teste si le point d'intersection est sur le segment */
	    if (! testpx_(pp, ss)) {
		cc[0] = -1e3f;
		    free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
         return 0;
	    }
/*         on cree le point d'intersection */
	    libre = alloc_();
	    if (libre == 0) {
		cc[0] = -1e3f;
		    free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
         return 0;
	    }
	    bdpec2_1.bd[libre * 6 + 384] = 0.f;
	    bdpec2_1.bd[libre * 6 + 385] = pp[1];
	    bdpec2_1.bd[libre * 6 + 386] = pp[2];
	    bdpec5_1.nuref[(libre << 1) + 128] = bdpec5_1.nuref[(*ad << 1) + 
		    128];
	    bdpec5_1.nuref[(libre << 1) + 129] = bdpec5_1.nuref[(*ad << 1) + 
		    129];
/*         deuxieme morceau de la spline */
	    cc[0] = -4.f;
	    cc[2] = (real) cons_(&libre, &listed_1.cdr[iadr - 1]);
/*         modif du premier morceau de la spline */
	    listed_1.cdr[iadr - 1] = cons_(&libre, &c__0);
	    i__1 = (integer) cc[2];
	    cc[1] = (real) length_(&i__1);
	    i__1 = (integer) bdpec2_1.bd[*ad * 6 + 386];
	    bdpec2_1.bd[*ad * 6 + 385] = (real) length_(&i__1);
	    if (deno == 0.f) {
		deno = 1.f;
	    }
	    rap = long_ / deno;
	} else {
	    cc[0] = -1e3f;
	    rap = 1.f;
	}
    }
L9876:
    *rais = bdpec4_1.raison[*ad + 64];
    nurf[1] = bdpec5_1.nuref[(*ad << 1) + 128];
    nurf1[1] = bdpec5_1.nuref[(*ad << 1) + 128];
    nurf2[1] = bdpec7_1.nuref2[(*ad << 1) + 128];
    bdpec7_1.nuref2[(*ad << 1) + 128] = bdpec5_1.nuref[(*ad << 1) + 128];
    nurf[2] = nurf[1];
    nurf1[2] = nurf1[1];
    nurf2[2] = nurf2[1];
    bdpec7_1.nuref2[(*ad << 1) + 129] = bdpec7_1.nuref2[(*ad << 1) + 128];
    if (dabs(rap) <= 5e-6f) {
	rap = 1.f;
    }
/* Computing MAX */
    i__1 = (integer) (bdpec3_1.nbnode[*ad + 64] / (1.f / rap + 1.f));
    *nbnd = max(i__1,2);
/* Computing MAX */
    i__1 = (integer) (bdpec3_1.nbnode[*ad + 64] / (rap + 1.f));
    bdpec3_1.nbnode[*ad + 64] = max(i__1,2);
        free(tgen);free(xgen);free(ygen);free(xsp);free(ysp);
     return 0;
} /* cutpc_ */




/* Subroutine */ int degen_(integer *iadr)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double r_mod(real *, real *), sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    extern integer length_(integer *);
    integer pt, preced;

    /* Fortran I/O blocks */
    /*static*/ cilist io___910 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___911 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___912 = { 0, 6, 0, 0, 0 };




/*     ellimination des degenerescences de bd(*,iadr) */
    if (*iadr != 0) {
	if (bdpec2_1.bd[*iadr * 6 + 384] == -2.f) {
	    if ((r__1 = bdpec2_1.bd[*iadr * 6 + 389], dabs(r__1)) > 
		    6.283185306f) {
		bdpec2_1.bd[*iadr * 6 + 389] = r_mod(&bdpec2_1.bd[*iadr * 6 + 
			389], &c_b28);
	    }
	    if ((r__1 = bdpec2_1.bd[*iadr * 6 + 389], dabs(r__1)) <= 5e-6f) {
		bdpec2_1.bd[*iadr * 6 + 389] = 6.283185306f;
	    }
/* Computing 2nd power */
	    r__1 = bdpec2_1.bd[*iadr * 6 + 385] - bdpec2_1.bd[*iadr * 6 + 387]
		    ;
/* Computing 2nd power */
	    r__2 = bdpec2_1.bd[*iadr * 6 + 386] - bdpec2_1.bd[*iadr * 6 + 388]
		    ;
	    if (sqrt(r__1 * r__1 + r__2 * r__2) < eps_1.eps) {
/*           call scrtch('degen:arc  degenere') */
		s_wsle(&io___910);
		do_lio(&c__9, &c__1, "degen:  R  =", 12L);
/* Computing 2nd power */
		r__2 = bdpec2_1.bd[*iadr * 6 + 385] - bdpec2_1.bd[*iadr * 6 + 
			387];
/* Computing 2nd power */
		r__3 = bdpec2_1.bd[*iadr * 6 + 386] - bdpec2_1.bd[*iadr * 6 + 
			388];
		r__1 = sqrt(r__2 * r__2 + r__3 * r__3);
		do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
		e_wsle();
		bdpec2_1.bd[*iadr * 6 + 384] = -1e3f;
	    } else if ((r__2 = (r__1 = bdpec2_1.bd[*iadr * 6 + 389], dabs(
		    r__1)) - 6.283185306f, dabs(r__2)) <= 5e-6f) {
/*           arc ferme on force 4 noeuds */
/* Computing MAX */
		i__1 = bdpec3_1.nbnode[*iadr + 64];
		bdpec3_1.nbnode[*iadr + 64] = max(i__1,4);
	    } else if ((r__1 = bdpec2_1.bd[*iadr * 6 + 389], dabs(r__1)) >= 
		    3.1415876530000002f) {
/*           arc d'angle > pi on force 3 noeuds */
/* Computing MAX */
		i__1 = bdpec3_1.nbnode[*iadr + 64];
		bdpec3_1.nbnode[*iadr + 64] = max(i__1,3);
	    }
	} else if (bdpec2_1.bd[*iadr * 6 + 384] > 0.f) {
	    if (bdpec2_1.bd[*iadr * 6 + 384] < 9.9999999999999991e-31f) {
/*            call scrtch('degen:cercle degenere') */
		s_wsle(&io___911);
		do_lio(&c__9, &c__1, "DEGEN:CERCLE DEGENERE: R=", 25L);
		do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iadr * 6 + 384], (
			ftnlen)sizeof(real));
		e_wsle();
		bdpec2_1.bd[*iadr * 6 + 384] = -1e3f;
	    }
	} else if (bdpec2_1.bd[*iadr * 6 + 384] == -3.f) {
/* Computing MAX */
	    i__1 = bdpec3_1.nbnode[*iadr + 64];
	    bdpec3_1.nbnode[*iadr + 64] = max(i__1,2);
/*        teste si longueur trop petite */
/* Computing 2nd power */
	    r__1 = bdpec2_1.bd[*iadr * 6 + 385] - bdpec2_1.bd[*iadr * 6 + 387]
		    ;
/* Computing 2nd power */
	    r__2 = bdpec2_1.bd[*iadr * 6 + 386] - bdpec2_1.bd[*iadr * 6 + 388]
		    ;
	    if (sqrt(r__1 * r__1 + r__2 * r__2) < eps_1.eps) {
/*           call scrtch('degen: segment degenere') */
		s_wsle(&io___912);
		do_lio(&c__9, &c__1, "DEGEN: SEGMENT DEGENERE:   L =", 30L);
/* Computing 2nd power */
		r__2 = bdpec2_1.bd[*iadr * 6 + 385] - bdpec2_1.bd[*iadr * 6 + 
			387];
/* Computing 2nd power */
		r__3 = bdpec2_1.bd[*iadr * 6 + 386] - bdpec2_1.bd[*iadr * 6 + 
			388];
		r__1 = sqrt(r__2 * r__2 + r__3 * r__3);
		do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
		e_wsle();
		bdpec2_1.bd[*iadr * 6 + 384] = -1e3f;
	    }
	} else if (bdpec2_1.bd[*iadr * 6 + 384] == -4.f) {
	    i__1 = (integer) bdpec2_1.bd[*iadr * 6 + 386];
	    bdpec2_1.bd[*iadr * 6 + 385] = (real) length_(&i__1);
	    if (bdpec2_1.bd[*iadr * 6 + 385] == 1.f) {
/*           call scrtch('degen:un seul point de definition po
ur la' */
/*     $              // ' spline') */
		bdpec2_1.bd[*iadr * 6 + 384] = -1e3f;
	    } else {
		pt = bdpec2_1.bd[*iadr * 6 + 386];
		preced = 0;
L1:
		if (pt != 0) {
/*            teste si 2 points consecutifs sont confondus
 */
		    if (preced != 0) {
			if ((r__1 = bdpec2_1.bd[listea_1.car[preced - 1] * 6 
				+ 385] - bdpec2_1.bd[listea_1.car[pt - 1] * 6 
				+ 385], dabs(r__1)) <= eps_1.eps && (r__2 = 
				bdpec2_1.bd[listea_1.car[preced - 1] * 6 + 
				386] - bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 
				386], dabs(r__2)) <= eps_1.eps) {
/*                ellimine pt */
			    listed_1.cdr[preced - 1] = listed_1.cdr[pt - 1];
			    pt = listed_1.cdr[pt - 1];
			    goto L1;
			}
		    }
		    preced = pt;
		    pt = listed_1.cdr[pt - 1];
		    goto L1;
		}
	    }
	}
    }
    return 0;
} /* degen_ */




/* Subroutine */ int demkmn_(integer *numn)
{
    /* Local variables */
    integer i;


/* --------------------------------------------------------------- */
/*  but : unmark  toutes les cases du menu numn */
/* --------------------------------------------------------------- */
    for (i = 1; i <= 32; ++i) {
	pec_1.mkcase[i + (*numn << 5) - 33] = 0;
/* L10: */
    }
    return 0;
} /* demkmn_ */




integer design_(integer *act)
{
    /* System generated locals */
    address a__1[3];
    integer ret_val, i__1, i__2[3];
    real r__1, r__2, r__3, r__4;
    char ch__1[47];
    icilist ici__1;
    cllist cl__1;
    inlist ioin__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sqrt(doublereal), sin(doublereal), cos(doublereal);
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer f_inqu(inlist *), s_rsle(cilist *), e_rsle(void), f_clos(cllist *)
	    ;

    /* Local variables */
    static integer nfbd;
    static real dist;
    static logical bool;
    static real minr, maxr;
    static integer numn, mini, maxi;
    extern integer anal1_(I_fp, integer *);
    static logical bool1;
    extern /* Subroutine */ int pjp1d_(real *, real *, real *, real *);

    static real x1, y1, x2, y2, sinus;
    static integer i, mkint, ptpil, ppadr[16];
    static real stack[12]	/* was [6][2] */;
    static integer nbsol;
    extern /* Subroutine */ int drp1p2_(real *, real *, real *), innum_(char *
	    , real *, integer *, logical *, integer *, integer *, integer *, 
	    integer *, real *, real *, ftnlen), pjp1c1_(real *, real *, real *
	    ), itc1c2_(real *, real *, real *), fentr2_(real *, real *, real *
	    , real *), masqu2_(real *, real *, real *, real *), afcalc_(void);
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen), gecran_(), calcul_(integer *);
    extern doublereal proche_(integer *, real *, real *, integer *);
    extern integer sproch_(real *, real *), tproch_(real *, real *), aproch_(
	    real *, real *);
    static integer typele, nivsup;
    static real dx, dy, cosinu;
    static integer io, mkmint;
    static char buf[80];
    static integer ppmenu[2];
    static real ppx[2], ppy[2], res[96]	/* was [6][16] */, xx;
    extern /* Subroutine */ int mkdesi_(integer *, integer *, integer *), 
	    affich_(void), scrtch_(char *, ftnlen), menumk_(integer *, 
	    integer *, integer *), extrm2_(integer *, real *, real *, real *, 
	    real *), itspxx_(real *, real *, real *, integer *, integer *, 
	    integer *, integer *), intext_(char *, integer *, char *, integer 
	    *, ftnlen, ftnlen);

    /* Fortran I/O blocks */
    /*static*/ cilist io___922 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___927 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___957 = { 1, 0, 1, 0, 0 };




/*     actions de designation (menu 1) (en bas) */


/*     pour gestion de l'ecran */
/*      integer pile(64),debutg,sizpil,ppile */
/*     pour calculette */
/*      type clique   (p_tab|p_xy| p | d | c | a |s) */
/*      cases marquees: mkele pour p d c a s tablette xy qlconq */
/*                      mkpar pour +proche exterm centre milieu */
/*                      mkint pour intersection */
/*     piles pour intersection */


    ret_val = 0;
/* ------------------------------------------------------------ */
    switch (*act) {
	case 1:  goto L1;
	case 2:  goto L2;
	case 3:  goto L3;
	case 4:  goto L4;
	case 5:  goto L5;
	case 6:  goto L6;
	case 7:  goto L7;
	case 8:  goto L8;
	case 9:  goto L9;
	case 10:  goto L10;
	case 11:  goto L11;
	case 12:  goto L12;
	case 13:  goto L13;
    }
/* ------------------------------------------------------------ */
    if (*act == 0) {
/*        action vide */
    } else if (*act < 0) {
	s_wsle(&io___922);
	do_lio(&c__9, &c__1, "INITIALISATION DE DESIGNATION", 29L);
	e_wsle();
/*        pour gecran */
/* -old         ppile=1 */
/* -old         pile(ppile)=1 */
/* -old         debutg=1 */
/* -old         sizpil=64 */
/*        init de calculette */
	ret_val = calcul_(act);
/*        on est a priori en pt_tablette du menu construction */
/*        initi des type a designe */
	mkdesi_(&typele, &cdesig_1.cnstrn, &c_n1);
	mkdesi_(&typele, &cdesig_1.cnstrn, &c__313);
	numn = 1;
	nivsup = 4;
/*        on met a priori l'axe horizontal */
	i = 1;
	bdpec2_1.bd[i * 6 + 384] = -1.f;
	bdpec2_1.bd[i * 6 + 385] = 0.f;
	bdpec2_1.bd[i * 6 + 386] = 1.f;
	bdpec2_1.bd[i * 6 + 387] = 0.f;
/*        on met a priori l'axe vertical */
	++i;
	bdpec2_1.bd[i * 6 + 384] = -1.f;
	bdpec2_1.bd[i * 6 + 385] = 1.f;
	bdpec2_1.bd[i * 6 + 386] = 0.f;
	bdpec2_1.bd[i * 6 + 387] = 0.f;
	bdpec1_1.ptbd = 2;
	affich_();
	i = anal1_((I_fp)gecran_, &c__0);
    } else if (*act >= 300 && *act <= 399) {
/*        predicat utilisateur */
	if (cdesig_1.vlmenu == *act) {
	    ret_val = 0;
	} else {
	    ret_val = -1;
	}
    } else if (*act == 999) {
/*        action speciale d'appel du niveau superieur (1) gecran */
	fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &
		pec_1.fentre[3]);
	masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &
		pec_1.masque[3]);
	i = anal1_((I_fp)gecran_, &cdesig_1.vlmenu);
/*        i=anal1(pile,debutg,gecran,sizpil,ppile,lireg1,vlmenu) */
    } else if (*act >= 1000) {
	i__1 = *act - 1000;
	ret_val = calcul_(&i__1);
    } else {
	scrtch_("DESIGNATION:ERREUR SYSTEME,ACTION ERRONNEE", 42L);
	s_wsle(&io___927);
	do_lio(&c__9, &c__1, "ERREUR:DESIGNATION,ACTION ERRONNEE", 34L);
	do_lio(&c__3, &c__1, (char *)&(*act), (ftnlen)sizeof(integer));
	e_wsle();
    }
    return ret_val;
L1:
/*        set_type_et_contrainte */
    mkdesi_(&typele, &cdesig_1.cnstrn, &cdesig_1.vlmenu);
    return ret_val;
L2:
/*        call scrtch('PAS COMPRIS')                                    #F
R*/
    scrtch_("not understand", 14L);
    return ret_val;
L3:
/*        push empile le resultat de coord */
/* Computing MIN */
    i__1 = ptpil + 1;
    ptpil = min(i__1,2);
    ppmenu[ptpil - 1] = cdesig_1.vlmenu;
    ppx[ptpil - 1] = cdesig_1.x;
    ppy[ptpil - 1] = cdesig_1.y;
    ppadr[ptpil - 1] = cdesig_1.adr;
    stack[ptpil * 6 - 6] = -1e3f;
    if (ppmenu[ptpil - 1] == 304) {
/*          on empile le cercle qui le sous tend */
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[cdesig_1.adr * 6 + 385] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 387];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[cdesig_1.adr * 6 + 386] - bdpec2_1.bd[cdesig_1.adr 
		* 6 + 388];
	stack[ptpil * 6 - 6] = sqrt(r__1 * r__1 + r__2 * r__2);
	stack[ptpil * 6 - 5] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	stack[ptpil * 6 - 4] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
    } else if (ppmenu[ptpil - 1] == 305) {
/*          on empile la droite qui le supporte */
	res[0] = 0.f;
	res[1] = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	res[2] = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	res[6] = 0.f;
	res[7] = bdpec2_1.bd[cdesig_1.adr * 6 + 387];
	res[8] = bdpec2_1.bd[cdesig_1.adr * 6 + 388];
	drp1p2_(&stack[ptpil * 6 - 6], res, &res[6]);
    } else if (cdesig_1.adr != 0) {
/*          on empile l'element */
	for (i = 0; i <= 5; ++i) {
	    stack[i + ptpil * 6 - 6] = bdpec2_1.bd[i + cdesig_1.adr * 6 + 384]
		    ;
/* L1701: */
	}
    } else {
/*          on empile les coordonnees */
	stack[ptpil * 6 - 6] = 0.f;
	stack[ptpil * 6 - 5] = cdesig_1.x;
	stack[ptpil * 6 - 6] = cdesig_1.y;
    }
    return ret_val;
L4:
/*        init_intersection */
    ptpil = 0;
    mkint = cdesig_1.nucase;
    mkmint = cdesig_1.numenu;
    menumk_(&cdesig_1.numenu, &mkint, &c__18);
/*            on se met en +_proche */
    mkdesi_(&typele, &cdesig_1.cnstrn, &c__351);
    return ret_val;
L5:
/*        coord on a recuperer x,y */
    cdesig_1.vlmenu = typele;
    cdesig_1.nextrm = 0;
/*         print*,'design:typele=',typele */
    if (typele == 308) {
	cdsmsh_1.adrsom = sproch_(&x1, &y1);
	if (cdsmsh_1.adrsom == 0) {
	    ret_val = -1;
	    return ret_val;
	}
    } else if (typele == 310) {
	cdsmsh_1.adrare = aproch_(&x1, &y1);
	if (cdsmsh_1.adrare == 0) {
	    ret_val = -1;
	    return ret_val;
	}
    } else if (typele == 309 || typele == 311) {
	cdsmsh_1.adrtri = tproch_(&x1, &y1);
	if (cdsmsh_1.adrtri == 0) {
	    ret_val = -1;
	    return ret_val;
	}
    } else if (typele == 313) {
	cdesig_1.adr = 0;
	bdpec2_1.bd[384] = 0.f;
	bdpec2_1.bd[385] = cdesig_1.x;
	bdpec2_1.bd[385] = cdesig_1.y;
	cdesig_1.vlmenu = 300;
    } else if (typele == 301) {
	dist = proche_(&cdesig_1.vlmenu, &cdesig_1.x, &cdesig_1.y, &
		cdesig_1.adr);
	if (dist == 1e30f) {
	    ret_val = -1;
	    return ret_val;
	}
	cdesig_1.x = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	cdesig_1.y = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
    } else {
	dist = proche_(&cdesig_1.vlmenu, &cdesig_1.x, &cdesig_1.y, &
		cdesig_1.adr);
	if (dist == 1e30f) {
	    ret_val = -1;
	    return ret_val;
	}
    }
    if (cdesig_1.cnstrn == 351) {
/*          pas de contraintes */
/*           print*,'design:retourne:cnstrn=',cnstrn,' adr=',adr */
/*     +           ,' vlmenu=',vlmenu */
	return ret_val;
    } else if (cdesig_1.cnstrn == 352) {
	if (cdesig_1.vlmenu == 300) {
	} else if (cdesig_1.vlmenu == 301) {
	} else {
	    if (cdesig_1.vlmenu == 312 || cdesig_1.vlmenu == 304 || 
		    cdesig_1.vlmenu == 305) {
		extrm2_(&cdesig_1.adr, &x1, &y1, &x2, &y2);
/* Computing 2nd power */
		r__1 = x1 - cdesig_1.xdesig;
/* Computing 2nd power */
		r__2 = y1 - cdesig_1.ydesig;
/* Computing 2nd power */
		r__3 = x2 - cdesig_1.xdesig;
/* Computing 2nd power */
		r__4 = y2 - cdesig_1.ydesig;
		if (r__1 * r__1 + r__2 * r__2 < r__3 * r__3 + r__4 * r__4) {
		    cdesig_1.nextrm = 1;
		    cdesig_1.x = x1;
		    cdesig_1.y = y1;
		} else {
		    cdesig_1.nextrm = 2;
		    cdesig_1.x = x2;
		    cdesig_1.y = y2;
		}
	    } else {
		ret_val = -1;
		return ret_val;
	    }
	}
    } else if (cdesig_1.cnstrn == 353) {
	if (cdesig_1.vlmenu == 300) {
	} else if (cdesig_1.vlmenu == 301) {
	} else if (cdesig_1.vlmenu == 303 || cdesig_1.vlmenu == 304) {
	    cdesig_1.x = bdpec2_1.bd[cdesig_1.adr * 6 + 385];
	    cdesig_1.y = bdpec2_1.bd[cdesig_1.adr * 6 + 386];
	} else {
	    ret_val = -1;
	    return ret_val;
	}
    } else if (cdesig_1.cnstrn == 354) {
	if (cdesig_1.vlmenu == 300) {
	} else if (cdesig_1.vlmenu == 301) {
	} else if (cdesig_1.vlmenu == 304) {
	    dx = bdpec2_1.bd[cdesig_1.adr * 6 + 387] - bdpec2_1.bd[
		    cdesig_1.adr * 6 + 385];
	    dy = bdpec2_1.bd[cdesig_1.adr * 6 + 388] - bdpec2_1.bd[
		    cdesig_1.adr * 6 + 386];
	    sinus = sin(bdpec2_1.bd[cdesig_1.adr * 6 + 389] / 2.f);
	    cosinu = cos(bdpec2_1.bd[cdesig_1.adr * 6 + 389] / 2.f);
	    cdesig_1.x = bdpec2_1.bd[cdesig_1.adr * 6 + 385] + dx * cosinu - 
		    dy * sinus;
	    cdesig_1.y = bdpec2_1.bd[cdesig_1.adr * 6 + 386] + dx * sinus + 
		    dy * cosinu;
	} else if (cdesig_1.vlmenu == 305) {
	    cdesig_1.x = (bdpec2_1.bd[cdesig_1.adr * 6 + 385] + bdpec2_1.bd[
		    cdesig_1.adr * 6 + 387]) / 2.f;
	    cdesig_1.y = (bdpec2_1.bd[cdesig_1.adr * 6 + 386] + bdpec2_1.bd[
		    cdesig_1.adr * 6 + 388]) / 2.f;
	} else {
	    ret_val = -1;
	    return ret_val;
	}
    }
    bdpec2_1.bd[384] = 0.f;
    bdpec2_1.bd[385] = cdesig_1.x;
    bdpec2_1.bd[385] = cdesig_1.y;
    cdesig_1.vlmenu = 300;
    return ret_val;
L6:
/*        valeur */
    afcalc_();
    cdesig_1.vlmenu = 306;
    if (traint_1.ptintr != 0) {
/*           on est en interpretation */
	io = traint_1.ptintr;
/*           pour tromper innum  .... */
	traint_1.ptintr = 0;
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 80;
	ici__1.iciunit = buf;
	ici__1.icifmt = "(g13.6)";
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&cdesig_1.numer, (ftnlen)sizeof(real));
	e_wsfi();
/* Writing concatenation */
	i__2[0] = 16, a__1[0] = "Valeur courante:";
	i__2[1] = 13, a__1[1] = buf;
	i__2[2] = 18, a__1[2] = " Entrez la valeur!";
	s_cat(ch__1, a__1, i__2, &c__3, 47L);
	innum_(ch__1, &cdesig_1.numer, &i, &bool, &c__1, &c__0, &mini, &maxi, 
		&minr, &maxr, 47L);
	traint_1.ptintr = io;
    }
    return ret_val;
L7:
/*        intersection des 2 elements en pile */
    nbsol = 0;
    if (ppmenu[0] == 312 || ppmenu[1] == 312) {
	itspxx_(res, stack, &stack[6], &nbsol, ppadr, &ppadr[1], &c__1);
    } else if (ppmenu[0] == 301 || ppmenu[0] == 300) {
	if (ppmenu[1] == 301 || ppmenu[1] == 300) {
/*            cas embettant intersection de 2 points, on renvoie l
e milie */
	    res[0] = 0.f;
	    res[1] = (stack[1] + stack[7]) * .5f;
	    res[2] = (stack[2] + stack[8]) * .5f;
	    nbsol = 1;
	} else if (ppmenu[1] == 302 || ppmenu[1] == 305) {
/*            pjpd */
	    pjp1d_(res, stack, &stack[6], &c_b609);
	    nbsol = 1;
	} else if (ppmenu[1] == 303 || ppmenu[1] == 304) {
/*            pjpc */
	    pjp1c1_(res, stack, &stack[6]);
	    nbsol = 2;
	}
    } else if (ppmenu[0] == 302 || ppmenu[0] == 305) {
	if (ppmenu[1] == 300) {
/*            pjpd */
	    pjp1d_(res, &stack[6], stack, &c_b609);
	    nbsol = 1;
	} else {
/*            itcc */
	    itc1c2_(res, stack, &stack[6]);
	    nbsol = 2;
	}
    } else if (ppmenu[0] == 303 || ppmenu[0] == 304) {
	if (ppmenu[1] == 301 || ppmenu[1] == 300) {
/*            pjpc */
	    pjp1c1_(res, &stack[6], stack);
	    nbsol = 2;
	} else {
/*            itcc */
	    itc1c2_(res, stack, &stack[6]);
	    nbsol = 2;
	}
    }
    if (nbsol >= 2) {
/*          recherche la solution la plus proche du 2 iem point de des
ign */
	i__1 = nbsol;
	for (i = 2; i <= i__1; ++i) {
/* Computing 2nd power */
	    r__1 = ppx[1] - res[1];
/* Computing 2nd power */
	    r__2 = ppy[1] - res[2];
/* Computing 2nd power */
	    r__3 = ppx[1] - res[i * 6 - 5];
/* Computing 2nd power */
	    r__4 = ppy[1] - res[i * 6 - 4];
	    if (r__1 * r__1 + r__2 * r__2 > r__3 * r__3 + r__4 * r__4) {
		res[1] = res[i * 6 - 5];
		res[2] = res[i * 6 - 4];
	    }
/* L77: */
	}
    }
    if (res[0] != 0.f) {
	cdesig_1.vlmenu = ppmenu[1];
	cdesig_1.adr = ppadr[1];
	cdesig_1.x = ppx[1];
	cdesig_1.y = ppy[1];
    } else {
	cdesig_1.x = res[1];
	cdesig_1.y = res[2];
	cdesig_1.adr = 0;
	cdesig_1.vlmenu = 300;
	cdesig_1.vlmenu = 300;
    }
    return ret_val;
L8:
/*         [new_menu_designe] */
    mkdesi_(&typele, &cdesig_1.cnstrn, &c__0);
    return ret_val;
L9:
/*       on unmark la case intersection */
    menumk_(&mkmint, &mkint, &c__0);
    return ret_val;
L10:
/*        lire_x */
    xx = cdesig_1.numer;
    return ret_val;
L11:
/*        lire_y */
    if (traint_1.ptintr != 0) {
/*           on est en interpretation */
	io = traint_1.ptintr;
/*           pour tromper innum  .... */
	traint_1.ptintr = 0;
	innum_("Entrez X!", &cdesig_1.x, &i, &bool, &c__1, &c__0, &mini, &
		maxi, &minr, &maxr, 9L);
	innum_("Entrez Y!", &cdesig_1.y, &i, &bool, &c__1, &c__0, &mini, &
		maxi, &minr, &maxr, 9L);
	traint_1.ptintr = io;
    } else {
	cdesig_1.y = cdesig_1.numer;
	cdesig_1.x = xx;
    }
    cdesig_1.adr = 0;
    bdpec2_1.bd[384] = 0.f;
    bdpec2_1.bd[385] = cdesig_1.x;
    bdpec2_1.bd[385] = cdesig_1.y;
    cdesig_1.xdesig = cdesig_1.x;
    cdesig_1.ydesig = cdesig_1.y;
    cdesig_1.vlmenu = 300;
    cdesig_1.cnstrn = 351;
/*         print*,'lirexy: x,y',x,y */
    return ret_val;
L12:
/*      call scrtch('MAUVAISE DESIGNATION, RECOMMENCEZ!')               #F
R*/
    scrtch_("BAD PICK, RETRY!!", 17L);
    return ret_val;
L13:
/*       print*,'lire_file avec des x,y dedant' */
/*       demande du nom du fichier */
/*       call intext('Nom du fichier de lecture des X,Y:'               #F
R*/
    intext_(" X,Y file name:", &c__80, buf, &i, 15L, 80L);
    if (i == 0) {
/*         call scrtch('Nom vide => on abandonne ')                   
  #FR*/
	scrtch_("Name empty => cancel ", 21L);
	return ret_val;
    } else {
	ioin__1.inerr = 0;
	ioin__1.infilen = i;
	ioin__1.infile = buf;
	ioin__1.inex = &bool;
	ioin__1.inopen = &bool1;
	ioin__1.innum = 0;
	ioin__1.innamed = 0;
	ioin__1.inname = 0;
	ioin__1.inacc = 0;
	ioin__1.inseq = 0;
	ioin__1.indir = 0;
	ioin__1.infmt = 0;
	ioin__1.inform = 0;
	ioin__1.inunf = 0;
	ioin__1.inrecl = 0;
	ioin__1.innrec = 0;
	ioin__1.inblank = 0;
	f_inqu(&ioin__1);
	if (! bool) {
	    scrtch_("Le fichier n'existe pas. Changez de nom!", 40L);
	    goto L13;
	} else if (bool1) {
	    scrtch_("Le fichier est deja ouvert. Changez de nom!", 43L);
	    goto L13;
	}
	if (fouvri_(&nfbd, buf, " ", &c__0, i, 1L) != 0) {
	    scrtch_("Pb dans open de votre fichier. Changer de nom!", 46L);
	    goto L13;
	}
    }
/*       lecture du fichier */
L1300:
    io___957.ciunit = nfbd;
    i__1 = s_rsle(&io___957);
    if (i__1 != 0) {
	goto L1301;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&cdesig_1.x, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L1301;
    }
    i__1 = do_lio(&c__4, &c__1, (char *)&cdesig_1.y, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L1301;
    }
    i__1 = e_rsle();
    cdesig_1.xdesig = cdesig_1.x;
    cdesig_1.ydesig = cdesig_1.y;
    cdesig_1.numer = cdesig_1.y;
    cdesig_1.adr = 0;
    bdpec2_1.bd[384] = 0.f;
    bdpec2_1.bd[385] = cdesig_1.x;
    bdpec2_1.bd[385] = cdesig_1.y;
    cdesig_1.vlmenu = 300;
    cdesig_1.cnstrn = 351;
/*        action speciale d'appel du niveau superieur (1) gecran */
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    i = anal1_((I_fp)gecran_, &cdesig_1.vlmenu);
    if (i != -1) {
	i = anal1_((I_fp)gecran_, &c__0);
    }
/*        i=anal1(pile,debutg,gecran,sizpil,ppile,lireg1,vlmenu) */
    goto L1300;
L1301:
    cl__1.cerr = 0;
    cl__1.cunit = nfbd;
    cl__1.csta = 0;
    f_clos(&cl__1);
    scrtch_("Fin de la lecture du fichier", 28L);
    return ret_val;
} /* design_ */




/* Subroutine */ int dofiss_(integer *j)
{
    /* Local variables */

    integer i;
    extern /* Subroutine */ int drawad_(integer *, integer *);

/*     fissure l'element j */

    i = abs(*j);
    drawad_(&i, &c_n1);
    bdpecd_1.fissur[i + 64] = TRUE_;
    drawad_(&i, &c__1);
    return 0;
} /* dofiss_ */




/* Subroutine */ int dp1d1a_(real *d, real *p1, real *d1, real *alpha)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sin(doublereal), cos(doublereal);

    /* Local variables */
    real sinus, cosinu;

    /* Fortran I/O blocks */
    /*static*/ cilist io___963 = { 0, 6, 0, 0, 0 };



/*     d= droite passant par le point p1 et faisant un angle alpha */
/*         par rapport a la droite d1 */



    d[0] = -1e3f;
    if (d1[0] == -1e3f || p1[0] == -1e3f) {
	return 0;
    }
    if (d1[0] != -1.f || p1[0] < 0.f) {
	s_wsle(&io___963);
	do_lio(&c__9, &c__1, "ERREUR:DP1D1A, MAUVAIS TYPE", 27L);
	do_lio(&c__4, &c__1, (char *)&d1[0], (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&p1[0], (ftnlen)sizeof(real));
	e_wsle();
	return 0;
    }
    sinus = sin(*alpha);
    cosinu = cos(*alpha);
    d[0] = -1.f;
    d[1] = d1[1] * cosinu - d1[2] * sinus;
    d[2] = d1[1] * sinus + d1[2] * cosinu;
    d[3] = -(doublereal)d[1] * p1[1] - d[2] * p1[2];
    return 0;
} /* dp1d1a_ */

#undef coulls


/* Subroutine */ int draw_(real *c)
{
    /* Local variables */
    logical l;
    extern logical drawa_(real *), drawc_(real *), drawd_(real *), drawp_(
	    real *), draws_(real *), drawsp_(real *);


/*     trace c */



    if (c[0] == -1e3f) {
	return 0;
    } else if (c[0] == -1.f) {
	l = drawd_(c);
    } else if (c[0] == 0.f) {
	l = drawp_(c);
    } else if (c[0] > 0.f) {
	l = drawc_(c);
    } else if (c[0] == -2.f) {
	l = drawa_(c);
    } else if (c[0] == -3.f) {
	l = draws_(c);
    } else if (c[0] == -4.f) {
	l = drawsp_(c);
    }
    return 0;
} /* draw_ */

#undef coulls

