#include "emc2_h.h"

logical drawa_(real *aa)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sin(doublereal), cos(doublereal);

    /* Local variables */
    integer i;
    real r;

    real sinus, x0, y0, x1, y1;
    extern /* Subroutine */ int lin2to_(real *, real *);
    real dd[2];
    extern /* Subroutine */ int mov2to_(real *, real *);
    real dalpha;
    real cosinu, rr, pp[2];
    integer nbc;
    extern logical tstrjt_(integer *);
    extern /* Subroutine */ int drawfl_(real *, real *), drawmk_(real *, real 
	    *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___972 = { 0, 6, 0, 0, 0 };



/*     trace l'arc aa (aa(1),aa(2)=centre; aa(3),aa(4)=point; aa(5)=angle 
*/


    ret_val = FALSE_;

    if (aa[0] != -2.f) {
	return ret_val;
    }
/* Computing 2nd power */
    r__1 = aa[1] - aa[3];
/* Computing 2nd power */
    r__2 = aa[2] - aa[4];
    r = sqrt(r__1 * r__1 + r__2 * r__2);
    if (r < eps_1.eps || dabs(aa[5]) < 5e-6f) {
	s_wsle(&io___972);
	do_lio(&c__9, &c__1, "DRAWA: TRACE IMPOSSIBLE,R=", 26L);
	do_lio(&c__4, &c__1, (char *)&r, (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " ANG=", 5L);
	r__1 = dabs(aa[5]);
	do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
	e_wsle();
	return ret_val;
    }
    rr = r * (pec_1.fentre[1] - pec_1.fentre[0]) / (pec_1.masque[1] - 
	    pec_1.masque[0]);
    nbc = (sqrt(rr / 3) * 30.f + 2) * (r__1 = aa[5] / 6.283185306f, dabs(r__1)
	    );
/* Computing MIN */
    i__1 = max(nbc,20);
    nbc = min(i__1,200);
    dalpha = aa[5] / nbc;
    sinus = sin(dalpha);
    cosinu = cos(dalpha);
    mov2to_(&aa[3], &aa[4]);
    x0 = aa[3] - aa[1];
    y0 = aa[4] - aa[2];
    i__1 = nbc;
    for (i = 1; i <= i__1; ++i) {
	x1 = x0 * cosinu - y0 * sinus;
	y1 = x0 * sinus + y0 * cosinu;
	r__1 = x1 + aa[1];
	r__2 = y1 + aa[2];
	lin2to_(&r__1, &r__2);
	ret_val = ret_val || ! tstrjt_(&c__0);
	x0 = x1;
	y0 = y1;
/* L1: */
    }
    if (pec_1.appli == 514) {
	return ret_val;
    }
    if (! ret_val) {
	return ret_val;
    }
/*      pour le trace de la fleche */
    dalpha = aa[5];
    sinus = sin(dalpha);
    cosinu = cos(dalpha);
    x0 = aa[3] - aa[1];
    y0 = aa[4] - aa[2];
/*      position de la fleche en p (fin de l'arc) et de la marque en debu 
*/
    pp[0] = aa[1] + x0 * cosinu - y0 * sinus;
    pp[1] = aa[2] + x0 * sinus + y0 * cosinu;
    x0 = pp[0] - aa[1];
    y0 = pp[1] - aa[2];
/* Computing 2nd power */
    r__1 = x0;
/* Computing 2nd power */
    r__2 = y0;
    rr = sqrt(r__1 * r__1 + r__2 * r__2);
    if (rr < eps_1.eps || dabs(aa[5]) < 5e-6f) {
	return ret_val;
    }
    x0 /= rr;
    y0 /= rr;
    dd[0] = -(doublereal)y0;
    dd[1] = x0;
    if (aa[5] < 0.f) {
	dd[0] = y0;
	dd[1] = -(doublereal)x0;
    }
    drawfl_(pp, dd);
    pp[0] = aa[3];
    pp[1] = aa[4];
    x0 = pp[0] - aa[1];
    y0 = pp[1] - aa[2];
    x0 /= rr;
    y0 /= rr;
    dd[0] = -(doublereal)y0;
    dd[1] = x0;
    drawmk_(pp, dd);
    return ret_val;
} /* drawa_ */




/* Subroutine */ int drawad_(integer *ad, integer *imode)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer mode;
    extern /* Subroutine */ int draw_(real *), ligh3_(integer *, integer *, 
	    integer *), draw3_(integer *);

    extern logical drawp_(real *), drawa_(real *), draws_(real *);
    extern /* Subroutine */ int thick_(real *), noeud2_(integer *, integer *);
    extern integer cou1rf_(integer *);
    extern logical drawsp_(real *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___989 = { 0, 6, 0, 0, 0 };



/*      elle trace l'element d'adresse ad dans la bd */
/*      elle le fait selon l'appication en cours */
/*      imode=-1 fond */
/*      imode=0 normal */
/*      imode=1 hight light */



    if (*ad == 0) {
/*        print*,'drawad:adresse nulle: goto 11111' */
	goto L11111;
    }
    thick_(&c_b604);
    draw3_(&c__0);
    if (pec_1.appli != 513) {
/*       constr */
	mode = *imode;
    } else {
/*       appli2 ou appli3 */
/*       teste si fissure */
	if (bdpecd_1.fissur[*ad + 64] && *imode != -1) {
	    mode = 1;
	} else {
	    mode = *imode;
	}
    }
    if (pec_1.appli == 511) {
/*       affichage pour construction */
	if (bdpec2_1.bd[*ad * 6 + 384] == -1e3f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -1.f) {
	    draw3_(&c__2);
	    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
	} else if (bdpec2_1.bd[*ad * 6 + 384] == 0.f) {
	    draw3_(&c__2);
	    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
	} else if (bdpec2_1.bd[*ad * 6 + 384] > 0.f) {
	    draw3_(&c__2);
	    ligh3_(&c_n1, &c_n1, &pec_1.coloro);
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
	    ligh3_(&c_n1, &c_n1, &pec_1.colove);
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -3.f) {
	    ligh3_(&c_n1, &c_n1, &pec_1.colove);
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -4.f) {
	    ligh3_(&c_n1, &c_n1, &pec_1.colove);
	}
	if (mode == -1) {
	    ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	}
	draw_(&bdpec2_1.bd[*ad * 6 + 384]);
    } else if (pec_1.appli == 513) {
/*        print*,'drawad:affichage pour application 2' */
	if (mode == 0) {
	    draw3_(&c__0);
	    thick_(&c_b604);
	} else {
	    draw3_(&c__0);
	    thick_(&c_b619);
	}
	if (bdpec2_1.bd[*ad * 6 + 384] == -1e3f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -1.f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == 0.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawp_(&bdpec2_1.bd[*ad * 6 + 384])) {
		noeud2_(ad, &mode);
	    }
	} else if (bdpec2_1.bd[*ad * 6 + 384] > 0.f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawa_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -3.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (draws_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -4.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawsp_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	}
    } else if (pec_1.appli == 514) {
/*        print*,'drawad:affichage pour application 3 (temporaire)' */
	if (mode == 0) {
	    thick_(&c_b604);
	    if (bdpecd_1.fissur[*ad + 64]) {
		draw3_(&c__2);
	    } else {
		draw3_(&c__4);
	    }
	} else {
	    draw3_(&c__0);
	    thick_(&c_b619);
	}
	if (bdpec2_1.bd[*ad * 6 + 384] == -1e3f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -1.f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == 0.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawp_(&bdpec2_1.bd[*ad * 6 + 384])) {
		noeud2_(ad, &mode);
	    }
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] > 0.f) {
	    goto L11111;
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawa_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -3.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (draws_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	} else if (bdpec2_1.bd[*ad * 6 + 384] == -4.f) {
	    if (mode == -1) {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    } else {
		i__1 = cou1rf_(&bdpec5_1.nuref[(*ad << 1) + 128]);
		ligh3_(&c_n1, &c_n1, &i__1);
	    }
	    if (drawsp_(&bdpec2_1.bd[*ad * 6 + 384])) {
/*             tracer des noeud2 et des refs */
		noeud2_(ad, &mode);
	    }
	}
    } else {
	s_wsle(&io___989);
	do_lio(&c__9, &c__1, "DRAWAD:APPLICATION INCONNUE", 27L);
	e_wsle();
    }
L11111:
    thick_(&c_b604);
    draw3_(&c__0);
    return 0;
} /* drawad_ */




/* Subroutine */ int drawbd_(integer *i)
{
    /* Local variables */
    extern /* Subroutine */ int draw_(real *);
    integer j;



/*     trace l'element i de bd */


    j = abs(*i);
    draw_(&bdpec2_1.bd[j * 6 + 384]);
    return 0;
} /* drawbd_ */




logical drawc_(real *c)
{
    /* System generated locals */
    real r__1, r__2, r__3, r__4;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal), cos(doublereal), sin(doublereal);

    /* Local variables */
    real cmsq[4];
    integer topo, i;
    real p[12]	/* was [6][2] */, alpha;
    extern /* Subroutine */ int itc1c2_(real *, real *, real *);
    real alpha1, alpha2;
    extern doublereal atang2_(real *, real *);
    extern /* Subroutine */ int lin2to_(real *, real *), mov2to_(real *, real 
	    *);
    real dalpha;
    extern /* Subroutine */ int topocc_(real *, real *, integer *);
    extern /* Subroutine */ int inqmsq_(real *, real *, real *, real *);
    real msq[4];


/*     trace le cercle c */


    ret_val = FALSE_;

    if (c[0] <= 0.f) {
	return ret_val;
    }
    inqmsq_(msq, &msq[1], &msq[2], &msq[3]);
/* Computing 2nd power */
    r__1 = msq[1] - msq[0];
/* Computing 2nd power */
    r__2 = msq[3] - msq[2];
    cmsq[0] = sqrt(r__1 * r__1 + r__2 * r__2) / 2.f;
    cmsq[1] = (msq[0] + msq[1]) / 2.f;
    cmsq[2] = (msq[2] + msq[3]) / 2.f;
    topocc_(c, cmsq, &topo);
    if (topo == 0 || topo == 2) {
	ret_val = FALSE_;
	return ret_val;
    }
    alpha1 = 0.f;
    alpha2 = 6.283185306f;
    if (topo == 3) {
/*       intersection des 2 cercles */
	itc1c2_(p, c, cmsq);
	if (p[0] == 0.f && p[6] == 0.f) {
	    for (i = 1; i <= 2; ++i) {
		p[i * 6 - 5] -= c[1];
		p[i * 6 - 4] -= c[2];
/* L2: */
	    }
	    alpha1 = atang2_(&p[2], &p[1]);
	    alpha2 = atang2_(&p[8], &p[7]);
	    if (alpha2 - alpha1 <= 0.f) {
		alpha2 += 6.283185306f;
	    }
	}
    }
/* Computing MIN */
/* Computing MAX */
    r__2 = c[0] * 200.f / cmsq[0];
    r__1 = dmax(r__2,20.f);
    dalpha = 6.283185306f / dmin(r__1,3e3f);
    r__1 = c[1] + c[0] * cos(alpha1);
    r__2 = c[2] + c[0] * sin(alpha1);
    mov2to_(&r__1, &r__2);
    r__1 = alpha2;
    r__2 = dalpha;
    for (alpha = alpha1; r__2 < 0 ? alpha >= r__1 : alpha <= r__1; alpha += 
	    r__2) {
	r__3 = c[1] + c[0] * cos(alpha);
	r__4 = c[2] + c[0] * sin(alpha);
	lin2to_(&r__3, &r__4);
/* L1: */
    }
    r__2 = c[1] + c[0] * cos(alpha2);
    r__1 = c[2] + c[0] * sin(alpha2);
    lin2to_(&r__2, &r__1);
    ret_val = TRUE_;
    return ret_val;
} /* drawc_ */

#undef coulls


logical drawd_(real *d)
{
    /* System generated locals */
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real p1[2], p2[2];
    logical fclpp2;
    extern /* Subroutine */ int scso2d_(real *, real *, real *, logical *, 
	    logical *), lin2to_(real *, real *), mov2to_(real *, real *);
    logical frejet;
    extern /* Subroutine */ int drawfl_(real *, real *);
    extern /* Subroutine */ int inqmsq_(real *, real *, real *, real *);
    real msq[4];


/*     trace la droite d */


    ret_val = FALSE_;



    if (d[0] != -1.f) {
	return ret_val;
    }
    inqmsq_(msq, &msq[1], &msq[2], &msq[3]);
    if (d[2] != 0.f) {
/*        intersection avec msq(1) */
	p1[0] = msq[0];
	p1[1] = -(doublereal)(d[3] + d[1] * p1[0]) / d[2];
/*        intersection avec msq(2) */
	p2[0] = msq[1];
	p2[1] = -(doublereal)(d[3] + d[1] * p2[0]) / d[2];
    } else if (d[1] != 0.f) {
/*        intersection avec msq(3) */
	p1[1] = msq[2];
	p1[0] = -(doublereal)(d[3] + d[2] * p1[1]) / d[1];
/*        intersection avec msq(4) */
	p2[1] = msq[3];
	p2[0] = -(doublereal)(d[3] + d[2] * p2[1]) / d[1];
    }
    scso2d_(p1, p2, msq, &frejet, &fclpp2);
    ret_val = ! frejet;
/*      pour la fleche */
    if (ret_val) {
	mov2to_(p1, &p1[1]);
	lin2to_(p2, &p2[1]);
/*        flechage du sens au milieu de p1 p2 */
	p1[0] = (p1[0] + p2[0]) / 2.f;
	p1[1] = (p1[1] + p2[1]) / 2.f;
/*        direction de la droite */
	p2[0] = d[2] / sqrt(d[1] * d[1] + d[2] * d[2]);
	p2[1] = -(doublereal)d[1] / sqrt(d[1] * d[1] + d[2] * d[2]);
	drawfl_(p1, p2);
    }
    return ret_val;
} /* drawd_ */

#undef coulls


/* Subroutine */ int drawfl_(real *pp, real *dd)
{
    /* Local variables */
    real f[6]	/* was [2][3] */;
    integer i;

    extern /* Subroutine */ int lin2to_(real *, real *);
    real fleche[6]	/* was [2][3] */, ll;
    extern /* Subroutine */ int mov2to_(real *, real *);


/*      trace une fleche en pp dans la direction dd(normalisee) */



/*      taille de la fleche */
    /* Parameter adjustments */
    --dd;
    --pp;

    /* Function Body */
    ll = (pec_1.masque[1] - pec_1.masque[0]) / 20.f;
    f[0] = ll * -.3f;
    f[1] = ll * .1f;
    f[2] = 0.f;
    f[3] = 0.f;
    f[4] = ll * -.3f;
    f[5] = ll * -.1f;
/*        on tourne la fleche */
    for (i = 1; i <= 3; ++i) {
	fleche[(i << 1) - 2] = f[(i << 1) - 2] * dd[1] - f[(i << 1) - 1] * dd[
		2];
	fleche[(i << 1) - 1] = f[(i << 1) - 2] * dd[2] + f[(i << 1) - 1] * dd[
		1];
/* L1: */
    }
/*        on la positionne en p */
    for (i = 1; i <= 3; ++i) {
	fleche[(i << 1) - 2] += pp[1];
	fleche[(i << 1) - 1] += pp[2];
/* L2: */
    }
/*        on la trace */
    mov2to_(fleche, &fleche[1]);
    lin2to_(&fleche[2], &fleche[3]);
    lin2to_(&fleche[4], &fleche[5]);
    return 0;
} /* drawfl_ */




/* Subroutine */ int drawmk_(real *pp, real *dd)
{
    /* Local variables */
    real mark[4]	/* was [2][2] */, f[6]	/* was [2][3] */;
    integer i;

    extern /* Subroutine */ int lin2to_(real *, real *);
    real ll;
    extern /* Subroutine */ int mov2to_(real *, real *);


/*      trace une marque en pp dans la direction dd(normalisee) */



/*      taille de la marque */
    /* Parameter adjustments */
    --dd;
    --pp;

    /* Function Body */
    ll = (pec_1.masque[1] - pec_1.masque[0]) / 20.f;
    f[0] = 0.f;
    f[1] = ll * .1f;
    f[2] = 0.f;
    f[3] = ll * -.1f;
/*        on tourne la mark */
    for (i = 1; i <= 2; ++i) {
	mark[(i << 1) - 2] = f[(i << 1) - 2] * dd[1] - f[(i << 1) - 1] * dd[2]
		;
	mark[(i << 1) - 1] = f[(i << 1) - 2] * dd[2] + f[(i << 1) - 1] * dd[1]
		;
/* L1: */
    }
/*        on la positionne en pp */
    for (i = 1; i <= 2; ++i) {
	mark[(i << 1) - 2] += pp[1];
	mark[(i << 1) - 1] += pp[2];
/* L2: */
    }
/*        on la trace */
    mov2to_(mark, &mark[1]);
    lin2to_(&mark[2], &mark[3]);
    return 0;
} /* drawmk_ */




logical drawp_(real *pp)
{
    /* System generated locals */
    real r__1, r__2;
    logical ret_val;

    /* Local variables */
    extern /* Subroutine */ int txt2d_(char *, integer *, real *, real *, 
	    ftnlen);
    real l;

    extern /* Subroutine */ int lin2to_(real *, real *), mov2to_(real *, real 
	    *), drw3tx_(real *, real *, integer *);


/*      trace le point pp */




    ret_val = FALSE_;
    if (pp[0] != 0.f) {
	return ret_val;
    }
    if (pp[1] > pec_1.masque[1] || pp[1] < pec_1.masque[0]) {
	return ret_val;
    }
    if (pp[2] > pec_1.masque[3] || pp[2] < pec_1.masque[2]) {
	return ret_val;
    }
    ret_val = TRUE_;
    if (pec_1.appli == 514) {
	drw3tx_(&c_b662, &c_b609, &c__0);
	txt2d_("*", &c__1, &pp[1], &pp[2], 1L);
    } else {
/*      longueur de la croix = 1/200 de l'ecran */
	l = (pec_1.masque[1] - pec_1.masque[0]) / 200.f;
	r__1 = pp[1] - l;
	r__2 = pp[2] - l;
	mov2to_(&r__1, &r__2);
	r__1 = pp[1] + l;
	r__2 = pp[2] + l;
	lin2to_(&r__1, &r__2);
/*       drawp=drawp.and.(.not.tstrjt(0)) */
	r__1 = pp[1] - l;
	r__2 = pp[2] + l;
	mov2to_(&r__1, &r__2);
	r__1 = pp[1] + l;
	r__2 = pp[2] - l;
	lin2to_(&r__1, &r__2);
/*       drawp=drawp.and.(.not.tstrjt(0)) */
    }
    return ret_val;
} /* drawp_ */




/* Subroutine */ int drawq_(integer *nb1, integer *nb2, integer *nb3, integer 
	*nb4, real *x1, real *y1, real *x2, real *y2, real *x3, real *y3, 
	real *x4, real *y4)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */

    real l1, l2, l3, l4, w;
    integer i, j, l;
/*    real f1[1000], f2[1000], f3[1000], f4[1000];*/
    real * f1,*f2,*f3,*f4;
    extern /* Subroutine */ int thick_(real *);
    real ff1[2], ff2[2], ff3[2], ff4[2], xc, yc;
    integer lm1;
  /*  real xx[2000]	/* was [2][1000] */ /*, yy[2000]	/* was [2][1000] */
    real *xx,*yy;
    void  free ( void * );
    void * malloc(size_t );
    extern /* Subroutine */ int mov2to_(real *, real *), lin2to_(real *, real 
	    *);
	

/*       1------->n1 */
/*    1              1 */
/*    |              | */
/*    |              | */
/*    |              | */
/*    |              | */
/*    v              v */
/*    n4 1------->n3 n2 */

/*     visualisation d'un quadrangle avec les lignes interieures */


/*      real sigma */

/*      print*,'drawq:nb1=',nb1,' nb2=',nb2,' nb3=',nb3,' nb4=',nb4 */
/*      print*,'x1=',(x1(i),i=1,nb1) */
/*      print*,'y1=',(y1(i),i=1,nb1) */
/*      print*,'x2=',(x2(i),i=2,nb2) */
/*      print*,'y2=',(y2(i),i=2,nb2) */
/*      print*,'x3=',(x3(i),i=3,nb3) */
/*      print*,'y3=',(y3(i),i=3,nb3) */
/*      print*,'x4=',(x4(i),i=4,nb4) */
/*      print*,'y4=',(y4(i),i=4,nb4) */
    /* Parameter adjustments */
     /*   real f1[1000], f2[1000], f3[1000], f4[1000];*/
     f1 = (real *) malloc (sizeof(real)*1000);
     f2 = (real *) malloc (sizeof(real)*1000);
     f3 = (real *) malloc (sizeof(real)*1000);
     f4 = (real *) malloc (sizeof(real)*1000);
     xx = (real *) malloc (sizeof(real)*2000);
     yy = (real *) malloc (sizeof(real)*2000);
     if ( ! f1 ) goto LA999;
     if ( ! f2 ) goto LA999;
     if ( ! f3 ) goto LA999;
     if ( ! f4 ) goto LA999;
     if ( ! xx ) goto LA999;
     if ( ! yy ) goto LA999;
    --y4;
    --x4;
    --y3;
    --x3;
    --y2;
    --x2;
    --y1;
    --x1;

    /* Function Body */
    l1 = 0.f;
    i__1 = *nb1 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x1[i + 1] - x1[i];
/* Computing 2nd power */
	r__2 = y1[i + 1] - y1[i];
	l1 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L1: */
    }
    l2 = 0.f;
    i__1 = *nb2 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x2[i + 1] - x2[i];
/* Computing 2nd power */
	r__2 = y2[i + 1] - y2[i];
	l2 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L2: */
    }
    l3 = 0.f;
    i__1 = *nb3 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x3[i + 1] - x3[i];
/* Computing 2nd power */
	r__2 = y3[i + 1] - y3[i];
	l3 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L3: */
    }
    l4 = 0.f;
    i__1 = *nb4 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x4[i + 1] - x4[i];
/* Computing 2nd power */
	r__2 = y4[i + 1] - y4[i];
	l4 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L4: */
    }
    w = 0.f;
    f1[0] = 0.f;
    i__1 = *nb1 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x1[i + 1] - x1[i];
/* Computing 2nd power */
	r__2 = y1[i + 1] - y1[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f1[i] = w / l1;
/* L10: */
    }
    w = 0.f;
    f2[0] = 0.f;
    i__1 = *nb2 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x2[i + 1] - x2[i];
/* Computing 2nd power */
	r__2 = y2[i + 1] - y2[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f2[i] = w / l2;
/* L20: */
    }
    w = 0.f;
    f3[0] = 0.f;
    i__1 = *nb3 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x3[i + 1] - x3[i];
/* Computing 2nd power */
	r__2 = y3[i + 1] - y3[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f3[i] = w / l3;
/* L30: */
    }
    w = 0.f;
    f4[0] = 0.f;
    i__1 = *nb4 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x4[i + 1] - x4[i];
/* Computing 2nd power */
	r__2 = y4[i + 1] - y4[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f4[i] = w / l4;
/* L40: */
    }
    thick_(&c_b604);
    i__1 = *nb1;
    for (i = 1; i <= i__1; ++i) {
	l = i % 2 + 1;
	lm1 = (i + 1) % 2 + 1;
	ff1[0] = x1[i];
	ff1[1] = y1[i];
	ff3[0] = x3[i];
	ff3[1] = y3[i];
	i__2 = *nb2;
	for (j = 1; j <= i__2; ++j) {
/*          xc= ((nb1-i)*f1(i) + (i-1)*f3(i))/(nb1-1) */
/*          yc= ((nb2-j)*f4(j) + (j-1)*f2(j))/(nb2-1) */
	    xc = ((*nb2 - j) * f1[i - 1] + (j - 1) * f3[i - 1]) / (*nb2 - 1);
	    yc = ((*nb1 - i) * f4[j - 1] + (i - 1) * f2[j - 1]) / (*nb1 - 1);
	    ff2[0] = x2[j];
	    ff2[1] = y2[j];
	    ff4[0] = x4[j];
	    ff4[1] = y4[j];
/*          do 102 k=1,nb1-1 */
/*            if(xc.ge.f1(k).and.xc.lt.f1(k+1))then */
/*              sigma=(xc-f1(k))/(f1(k+1)-f1(k)) */
/*              ff1(1)=x1(k)+(x1(k+1)-x1(k))*sigma */
/*              ff1(2)=y1(k)+(y1(k+1)-y1(k))*sigma */
/*            endif */
/*            if(xc.ge.f3(k).and.xc.lt.f3(k+1))then */
/*              sigma=(xc-f3(k))/(f3(k+1)-f3(k)) */
/*              ff3(1)=x3(k)+(x3(k+1)-x3(k))*sigma */
/*              ff3(2)=y3(k)+(y3(k+1)-y3(k))*sigma */
/*            endif */
/* 102       continue */
/*          do 103 k=1,nb2-1 */
/*            if(yc.ge.f2(k).and.yc.lt.f2(k+1))then */
/*              sigma=(yc-f2(k))/(f2(k+1)-f2(k)) */
/*              ff2(1)=x2(k)+(x2(k+1)-x2(k))*sigma */
/*              ff2(2)=y2(k)+(y2(k+1)-y2(k))*sigma */
/*            endif */
/*            if(yc.ge.f4(k).and.yc.lt.f4(k+1))then */
/*              sigma=(yc-f4(k))/(f4(k+1)-f4(k)) */
/*              ff4(1)=x4(k)+(x4(k+1)-x4(k))*sigma */
/*              ff4(2)=y4(k)+(y4(k+1)-y4(k))*sigma */
/*            endif */
/* 103       continue */
	    xx[l + (j << 1) - 3] = (1.f - yc) * ff1[0] + xc * ff2[0] + yc * 
		    ff3[0] + (1 - xc) * ff4[0] - ((1 - xc) * (1 - yc) * x4[1] 
		    + xc * (1 - yc) * x1[*nb1] + xc * yc * x2[*nb2] + (1 - xc)
		     * yc * x3[1]);
	    yy[l + (j << 1) - 3] = (1.f - yc) * ff1[1] + xc * ff2[1] + yc * 
		    ff3[1] + (1 - xc) * ff4[1] - ((1 - xc) * (1 - yc) * y4[1] 
		    + xc * (1 - yc) * y1[*nb1] + xc * yc * y2[*nb2] + (1 - xc)
		     * yc * y3[1]);
	    if (j > 1) {
		mov2to_(&xx[l + (j - 1 << 1) - 3], &yy[l + (j - 1 << 1) - 3]);
		lin2to_(&xx[l + (j << 1) - 3], &yy[l + (j << 1) - 3]);
	    }
	    if (i > 1) {
		mov2to_(&xx[l + (j << 1) - 3], &yy[l + (j << 1) - 3]);
		lin2to_(&xx[lm1 + (j << 1) - 3], &yy[lm1 + (j << 1) - 3]);
	    }
/* L101: */
	}
/* L100: */
    }
LA999:
     free(f1);
     free(f2);
     free(f3);
     free(f4);
     free(xx);
     free(yy);
      
    return 0;
} /* drawq_ */




logical draws_(real *sgm)
{
    /* System generated locals */
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */

    real p1[2], d1[2];
    extern /* Subroutine */ int lin2to_(real *, real *);
    real dd;
    extern /* Subroutine */ int mov2to_(real *, real *);
    extern logical tstrjt_(integer *);
    extern /* Subroutine */ int drawfl_(real *, real *), drawmk_(real *, real 
	    *);


/*      trace le segment sgm (sgm(1),sgm(2)=point; sgm(3),sgm(4)=point) */




    if (sgm[0] != -3.f) {
	return ret_val;
    }
    mov2to_(&sgm[1], &sgm[2]);
    lin2to_(&sgm[3], &sgm[4]);
    ret_val = ! tstrjt_(&c__0);
    if (pec_1.appli == 514) {
	return ret_val;
    }
    if (! ret_val) {
	return ret_val;
    }
/*      pour le trace de la fleche en fin de segment et la marque en debu 
*/
    p1[0] = sgm[3];
    p1[1] = sgm[4];
    d1[0] = sgm[3] - sgm[1];
    d1[1] = sgm[4] - sgm[2];
/* Computing 2nd power */
    r__1 = d1[0];
/* Computing 2nd power */
    r__2 = d1[1];
    dd = sqrt(r__1 * r__1 + r__2 * r__2);
    d1[0] /= dd;
    d1[1] /= dd;
    drawfl_(p1, d1);
    p1[0] = sgm[1];
    p1[1] = sgm[2];
    drawmk_(p1, d1);
    return ret_val;
} /* draws_ */




logical drawsp_(real *sp)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int back_(integer *);

    integer n;
    extern integer length_(integer *);
    extern logical traspl_(real *, real *, integer *, real *, real *, real *, 
	    real *);
    integer pt, preced, pt1;
    real xsp[501], ysp[501], densit, tg1[2], tg2[2], pp[2];
    extern /* Subroutine */ int drawmk_(real *, real *), drawfl_(real *, real 
	    *);


/*     trace la spline sp: sp(1)=nombre de sommets, sp(2)=tete liste somm 
*/


    pt = sp[2];
    n = 0;
    preced = 0;
L1:
    if (pt != 0) {
	++n;
	if (n <= 500) {
	    xsp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
	    ysp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
/*          teste si 2 points identiques en sequence */
	    if (n > 1) {
/* Computing 2nd power */
		r__1 = xsp[n] - xsp[n - 1];
/* Computing 2nd power */
		r__2 = ysp[n] - ysp[n - 1];
		if (sqrt(r__1 * r__1 + r__2 * r__2) <= eps_1.eps) {
/*              degenerescence */
		    if (preced != 0) {
			listed_1.cdr[preced - 1] = listed_1.cdr[pt - 1];
		    } else {
			sp[2] = (real) listed_1.cdr[pt - 1];
		    }
		    pt1 = pt;
		    pt = listed_1.cdr[pt - 1];
		    back_(&pt1);
		    i__1 = (integer) sp[2];
		    sp[1] = (real) length_(&i__1);
		    --n;
		    goto L1;
		}
	    }
	    preced = pt;
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
    }
    i__1 = (integer) sp[2];
    sp[1] = (real) length_(&i__1);
    densit = 1.f;
    ret_val = traspl_(xsp, ysp, &n, &eps_1.eps, &densit, tg1, tg2);
    if (pec_1.appli == 514) {
	return ret_val;
    }
    if (! ret_val || n < 2) {
	return ret_val;
    }
/*      pour le trace de la fleche en fin de spline et la marque en debut 
*/
    pp[0] = xsp[1];
    pp[1] = ysp[1];
    drawmk_(pp, tg1);
    pp[0] = xsp[n];
    pp[1] = ysp[n];
    drawfl_(pp, tg2);
    return ret_val;
} /* drawsp_ */




/* Subroutine */ int drp1p2_(real *d, real *p1, real *p2)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double sqrt(doublereal);

    /* Local variables */
    real r;

    /* Fortran I/O blocks */
    /*static*/ cilist io___1072 = { 0, 6, 0, 0, 0 };



/*     d= droite passant par les points p1 et p2, orientee de p1 vers p2 
*/
/*       ou vide */



    d[0] = -1e3f;
    if (p1[0] == -1e3f || p2[0] == -1e3f) {
	return 0;
    }
    if (p1[0] < 0.f || p2[0] < 0.f) {
	s_wsle(&io___1072);
	do_lio(&c__9, &c__1, "ERREUR:DRP1P2, MAUVAIS TYPE", 27L);
	do_lio(&c__4, &c__1, (char *)&p1[0], (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&p2[0], (ftnlen)sizeof(real));
	e_wsle();
	return 0;
    }
    d[1] = p1[2] - p2[2];
    d[2] = p2[1] - p1[1];
/* Computing 2nd power */
    r__1 = d[1];
/* Computing 2nd power */
    r__2 = d[2];
    r = sqrt(r__1 * r__1 + r__2 * r__2);
    if (r != 0.f) {
	d[0] = -1.f;
	d[1] /= r;
	d[2] /= r;
	d[3] = -(doublereal)(d[1] * p1[1] + d[2] * p1[2]);
    }
    return 0;
} /* drp1p2_ */

#undef coulls


/* Subroutine */ int drwmsh_(integer *ksd, integer *opt)
{
    /* System generated locals */
    address a__1[3];
    integer i__1, i__2, i__3[3];
    real r__1, r__2;
    char ch__1[9];

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);

    /* Local variables */
    real xmin, ymin, xmax, ymax;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    draw3_(integer *), txt2d_(char *, integer *, real *, real *, 
	    ftnlen);
    integer i, j, k;
    real q[9]	/* was [3][3] */;

    integer i7, typet;
    logical notrf, trrft;
    integer coula, couls;
    extern /* Subroutine */ int thick_(real *), noeud2_(integer *, integer *);
    extern integer cou1rf_(integer *);
    extern /* Subroutine */ int debfac_(integer *), lin2to_(real *, real *);
    integer ie;
    real hh;
    integer at;
    extern /* Subroutine */ int mov2to_(real *, real *);
    integer iep, ie1, isd;
    real det, xx, yy;
    logical ltrace, sdorgi;
    integer bda, coulsd;
    char ch7[7];
    extern logical emshge_(integer *);
    extern /* Subroutine */ int commen_(char *, ftnlen), drawad_(integer *, 
	    integer *);
    integer isd1, isd2;
    extern /* Subroutine */ int drw3tx_(real *, real *, integer *), strint_(
	    integer *, char *, integer *, ftnlen), ctrtxt_(real *, real *), 
	    finfac_(void);

    /* Fortran I/O blocks */
    /*static*/ cilist io___1091 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1108 = { 0, 6, 0, 0, 0 };



/*     tracer d'un sous domaine ksd ou de tous si ksd = 0 */
/*     si opt = 1 => on efface */
/*     si opt < 1 => on trace */
/*     si optdrw = 1  => on ne trace pas les ref */

    commen_("DEBUT DRWMSH", 12L);
    bdpecd_1.fissur[64] = FALSE_;
    if (*ksd == 0) {
	if (bdmsh1_1.nbt > 0) {
	    pec_1.msqoto[0] = 1e30f;
	    pec_1.msqoto[1] = -1e30f;
	    pec_1.msqoto[2] = 1e30f;
	    pec_1.msqoto[3] = -1e30f;
	}
	isd1 = 1;
	isd2 = bdmsh1_1.nbsd;
    } else {
	isd1 = *ksd;
	isd2 = *ksd;
    }
/*     dans work on va marquer les aretes et les triangles,les sommets */
/*        deja dessiner */
    i__1 = bdmsh1_1.nbt + bdmsh1_1.nba + bdmsh4_1.finbd3;
    for (i = 1; i <= i__1; ++i) {
	bdwrk1_1.work[i - 1] = 0;
/* L5: */
    }
    i__1 = isd2;
    for (isd = isd1; isd <= i__1; ++isd) {
	trrft = FALSE_;
	if (bdmshf_1.refsd[isd - 1] != -1073741824) {
	    notrf = bdmshj_1.ptorsd[isd - 1] == isd;
	    thick_(&c_b604);
	    coulsd = cou1rf_(&bdmshf_1.refsd[isd - 1]);
	    sdorgi = bdmshj_1.ptorsd[isd - 1] == isd;
	    if (*opt == 1) {
		coulsd = ctabco_1.fond;
	    }
	    ligh3_(&c_n1, &c_n1, &coulsd);
	    if (notrf) {
		typet = 0;
	    } else {
		typet = 2;
	    }
	    draw3_(&typet);
	    iep = 0;
	    ie = bdmsh2_1.tetsd[bdmshj_1.ptorsd[isd - 1] - 1];
L10:
	    if (ie == 1073741824) {
		goto L100;
	    } else if (bdmsh9_1.nsea[ie * 6 - 6] <= 0) {
/*          suppression des element vides */
		if (iep == 0) {
		    bdmsh2_1.tetsd[bdmshj_1.ptorsd[isd - 1] - 1] = 
			    bdmsha_1.reft[ie - 1];
		} else {
		    bdmsha_1.reft[iep - 1] = bdmsha_1.reft[ie - 1];
		}
/*          chainage de elements vide */
/*          print *,'drwmsh: on dechaine l''element ',ie,reft(
ie),finsd */
		ie1 = bdmsha_1.reft[ie - 1];
		bdmsha_1.reft[ie - 1] = bdmsh3_1.freetr;
		bdmsh3_1.freetr = ie;
		ie = ie1;
		goto L10;
	    } else if (bdmsha_1.reft[ie - 1] > 0) {
/*          tracer de l'element ie */
/*          on  marque l'element */
		bdwrk1_1.work[ie - 1] = isd;
/*          calcule des coordonnes des 3 sommets du triangle 
*/
/*          on verifie si il a il a tracer quelque chose */
		ltrace = FALSE_;
		for (i = 1; i <= 3; ++i) {
		    at = bdmsh9_1.nsea[i + 3 + ie * 6 - 7];
		    if (at > 0) {
			if (bdwrk1_1.work[at / 8 - 1] != isd) {
			    ltrace = TRUE_;
			}
		    } else {
			if (bdwrk1_1.work[bdmsh1_1.nbt - at - 1] != isd) {
			    ltrace = TRUE_;
			}
		    }
/* L15: */
		}
		if (ltrace) {
/*            il a y quel chose a tracer */
		    if (notrf) {
			for (i = 1; i <= 3; ++i) {
			    if (bdmsh9_1.nsea[i + ie * 6 - 7] > bdmsh1_1.nbs 
				    || bdmsh9_1.nsea[i + ie * 6 - 7] <= 0) {
				s_wsle(&io___1091);
				do_lio(&c__9, &c__1, "l element foutue ", 17L)
					;
				do_lio(&c__3, &c__1, (char *)&ie, (ftnlen)
					sizeof(integer));
				do_lio(&c__9, &c__1, " s= ", 4L);
				for (j = 1; j <= 3; ++j) {
				    do_lio(&c__3, &c__1, (char *)&
					    bdmsh9_1.nsea[j + ie * 6 - 7], (
					    ftnlen)sizeof(integer));
				}
				e_wsle();
				goto L90;
			    }
			    for (j = 1; j <= 2; ++j) {
				q[j + i * 3 - 4] = bdmsh5_1.cr[j + (
					bdmsh9_1.nsea[i + ie * 6 - 7] << 1) - 
					3];
/* L20: */
			    }
			}
		    } else {
			for (i = 1; i <= 3; ++i) {
			    for (j = 1; j <= 2; ++j) {
				q[j + i * 3 - 4] = bdmshh_1.trfsd[j + (isd * 
					3 + 1) * 3 - 13] * bdmsh5_1.cr[(
					bdmsh9_1.nsea[i + ie * 6 - 7] << 1) - 
					2] + bdmshh_1.trfsd[j + (isd * 3 + 2) 
					* 3 - 13] * bdmsh5_1.cr[(
					bdmsh9_1.nsea[i + ie * 6 - 7] << 1) - 
					1] + bdmshh_1.trfsd[j + (isd * 3 + 3) 
					* 3 - 13];
/* L40: */
			    }
			}
		    }
		    det = (bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 6 - 5] << 1) - 2] 
			    - bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 6 - 6] << 1) - 
			    2]) * (bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 6 - 4] << 
			    1) - 1] - bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 6 - 6] 
			    << 1) - 1]) - (bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 6 
			    - 5] << 1) - 1] - bdmsh5_1.cr[(bdmsh9_1.nsea[ie * 
			    6 - 6] << 1) - 1]) * (bdmsh5_1.cr[(bdmsh9_1.nsea[
			    ie * 6 - 4] << 1) - 2] - bdmsh5_1.cr[(
			    bdmsh9_1.nsea[ie * 6 - 6] << 1) - 2]);
		    if (det > 0.f) {
/* Computing MIN */
			r__1 = min(q[0],q[3]);
			xmin = dmin(r__1,q[6]);
/* Computing MAX */
			r__1 = max(q[0],q[3]);
			xmax = dmax(r__1,q[6]);
/* Computing MIN */
			r__1 = min(q[1],q[4]);
			ymin = dmin(r__1,q[7]);
/* Computing MAX */
			r__1 = max(q[1],q[4]);
			ymax = dmax(r__1,q[7]);
			pec_1.msqoto[0] = dmin(xmin,pec_1.msqoto[0]);
			pec_1.msqoto[1] = dmax(xmax,pec_1.msqoto[1]);
			pec_1.msqoto[2] = dmin(ymin,pec_1.msqoto[2]);
			pec_1.msqoto[3] = dmax(ymax,pec_1.msqoto[3]);
			if (xmin >= pec_1.masque[1] || xmax <= pec_1.masque[0]
				 || ymin >= pec_1.masque[3] || ymax <= 
				pec_1.masque[2]) {
			} else {
			    j = 3;
			    for (i = 1; i <= 3; ++i) {
				at = bdmsh9_1.nsea[j + 3 + ie * 6 - 7];
				if (at < 0) {
				    if (bdwrk1_1.work[bdmsh1_1.nbt - at - 1] 
					    != isd) {
					draw3_(&c__0);
					bda = (i__2 = bdmshe_1.refa[-at - 1], 
						abs(i__2));
					if (bda == 0) {
					    coula = cou1rf_(&c__0);
					} else {
					    coula = cou1rf_(&bdpec5_1.nuref[(
						    bda << 1) + 128]);
					}
					if (sdorgi) {
					    if (bdpecd_1.fissur[bda + 64]) {
			  thick_(&c_b604);
			  draw3_(&c__3);
					    } else {
			  bdwrk1_1.work[bdmsh1_1.nbt - at - 1] = isd;
			  thick_(&c_b619);
					    }
					} else {
					    if (*opt == 1) {
			  coula = ctabco_1.fond;
					    }
					}
					ligh3_(&c_n1, &c_n1, &coula);
					mov2to_(&q[j * 3 - 3], &q[j * 3 - 2]);
					lin2to_(&q[i * 3 - 3], &q[i * 3 - 2]);
					k = (i__2 = bdmshe_1.refa[-at - 1], 
						abs(i__2));
					if (k > 0) {
					    if (bdwrk1_1.work[bdmsh1_1.nbt + 
						    bdmsh1_1.nba + k - 1] == 
						    0) {
			  bdwrk1_1.work[bdmsh1_1.nbt + bdmsh1_1.nba + k - 1] =
				   1;
			  drawad_(&k, &c__0);
					    }
					}
					ligh3_(&c_n1, &c_n1, &coulsd);
					draw3_(&typet);
					thick_(&c_b604);
				    }
				} else {
				    at /= 8;
				    if (bdwrk1_1.work[at - 1] != isd) {
					if (bdmshb_1.apavue[ie - 1] != j) {
					    mov2to_(&q[j * 3 - 3], &q[j * 3 - 
						    2]);
					    lin2to_(&q[i * 3 - 3], &q[i * 3 - 
						    2]);
					}
				    }
				}
				j = i;
/* L50: */
			    }
			    if (etat_1.mkelem) {
				if (! emshge_(&ie) && bdmshm_1.optdrw != 1) {
				    drw3tx_(&c_b2460, &c_b609, &c__0);
				    r__1 = (q[0] + q[3] + q[6]) / 3.f;
				    r__2 = (q[1] + q[4] + q[7]) / 3.f;
				    txt2d_("0", &c__1, &r__1, &r__2, 1L);
				}
			    }
/*               dessin des sommets references */
			    for (i = 1; i <= 3; ++i) {
				k = (i__2 = bdmsh8_1.refs[bdmsh9_1.nsea[i + 
					ie * 6 - 7] - 1], abs(i__2));
				if (k != 0) {
				    if (bdpecd_1.fissur[k + 64]) {
/* ----------------------- cas  des fi
ssures ----------------------
------- */
					if (bdwrk1_1.work[bdmsh1_1.nbt + 
						bdmsh1_1.nba + k - 1] == 0) {
					    bdwrk1_1.work[bdmsh1_1.nbt + 
						    bdmsh1_1.nba + k - 1] = 1;
					    if (bdpec2_1.bd[k * 6 + 384] == 
						    0.f) {
/*                        le sommet est fissure */
/*                        on trace le numero de  ref
erence */
			  couls = cou1rf_(&bdpec5_1.nuref[(k << 1) + 128]);
			  if (*opt == 1) {
			      couls = ctabco_1.fond;
			  }
			  ligh3_(&c_n1, &c_n1, &couls);
			  strint_(&bdpec5_1.nuref[(k << 1) + 128], ch7, &i7, 
				  7L);
			  xx = (q[0] + q[3] + q[6]) / 3.f - q[i * 3 - 3];
			  yy = (q[1] + q[4] + q[7]) / 3.f - q[i * 3 - 2];
			  if (xx < 0.f) {
			      xx = 1.f;
			  } else {
			      xx = 0.f;
			  }
			  if (yy < 0.f) {
			      yy = 1.f;
			  } else {
			      yy = 0.f;
			  }
			  ctrtxt_(&xx, &yy);
			  drw3tx_(&c_b2468, &c_b609, &c__0);
			  if (bdmshm_1.optdrw != 1) {
/* Writing concatenation */
			      i__3[0] = 1, a__1[0] = "{";
			      i__3[1] = i7, a__1[1] = ch7;
			      i__3[2] = 1, a__1[2] = "}";
			      s_cat(ch__1, a__1, i__3, &c__3, 9L);
			      i__2 = i7 + 2;
			      r__1 = (q[0] + q[3] + q[6] + q[i * 3 - 3] * 2) /
				       5.f;
			      r__2 = (q[1] + q[4] + q[7] + q[i * 3 - 2] * 2) /
				       5.f;
			      txt2d_(ch__1, &i__2, &r__1, &r__2, i7 + 2);
			  }
			  ligh3_(&c_n1, &c_n1, &coulsd);
			  ctrtxt_(&c_b609, &c_b609);
					    } else {
			  if (*opt != 1) {
			      drawad_(&k, &c__0);
			  }
					    }
					}
				    } else {
/*                    on ne marque que
 les sommets originaux(non fis
sure) */
					if (bdpec2_1.bd[k * 6 + 384] == 0.f) {
					    couls = cou1rf_(&bdpec5_1.nuref[(
						    k << 1) + 128]);
					    if (*opt == 1) {
			  couls = ctabco_1.fond;
					    }
					    ligh3_(&c_n1, &c_n1, &couls);
					    drw3tx_(&c_b662, &c_b609, &c__0);
					    if (bdmshm_1.optdrw != 1) {
			  txt2d_("*", &c__1, &q[i * 3 - 3], &q[i * 3 - 2], 1L)
				  ;
					    }
					    if (bdwrk1_1.work[bdmsh1_1.nbt + 
						    bdmsh1_1.nba + k - 1] == 
						    0) {
			  bdwrk1_1.work[bdmsh1_1.nbt + bdmsh1_1.nba + k - 1] =
				   1;
			  if (bdmshm_1.optdrw != 1) {
			      noeud2_(&k, &c__0);
			  }
					    }
					    ligh3_(&c_n1, &c_n1, &coulsd);
					}
				    }
				}
/* L52: */
			    }
			    if (! trrft && xmin >= pec_1.masque[0] && xmax <= 
				    pec_1.masque[1] && ymin >= pec_1.masque[2]
				     && ymax <= pec_1.masque[3]) {
				trrft = TRUE_;
				if (bdmshf_1.refsd[isd - 1] != 0) {
				    thick_(&c_b619);
/* Computing MAX */
				    r__1 = xmax - xmin, r__2 = ymax - ymin;
				    hh = dmax(r__1,r__2);
				    strint_(&bdmshf_1.refsd[isd - 1], ch7, &
					    i7, 7L);
/* Computing MAX */
				    r__2 = hh * etat_1.echel / max(2,i7);
				    r__1 = dmax(r__2,.5f);
				    drw3tx_(&r__1, &c_b609, &c__0);
				    if (bdmshm_1.optdrw != 1) {
					r__1 = xmin + hh * .1f;
					r__2 = ymin + hh * .1f;
					txt2d_(ch7, &i7, &r__1, &r__2, i7);
				    }
				    thick_(&c_b604);
				}
			    }
			}
		    } else {
			s_wsle(&io___1108);
			do_lio(&c__9, &c__1, " element negatif : ", 19L);
			do_lio(&c__3, &c__1, (char *)&ie, (ftnlen)sizeof(
				integer));
			for (i = 1; i <= 6; ++i) {
			    do_lio(&c__3, &c__1, (char *)&bdmsh9_1.nsea[i + 
				    ie * 6 - 7], (ftnlen)sizeof(integer));
			}
			e_wsle();
			ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
			debfac_(&c__0);
			mov2to_(&q[6], &q[7]);
			for (i = 1; i <= 3; ++i) {
			    lin2to_(&q[i * 3 - 3], &q[i * 3 - 2]);
/* L60: */
			}
			finfac_();
			ligh3_(&c_n1, &c_n1, &coulsd);
		    }
		}
L90:
		iep = ie;
		ie = bdmsha_1.reft[iep - 1];
		goto L10;
	    }
	}
L100:
	;
    }
    thick_(&c_b604);
    ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
    draw3_(&c__0);
    if (pec_1.msqoto[0] > pec_1.msqoto[1] || pec_1.msqoto[2] > pec_1.msqoto[3]
	    ) {
/*       on n'a pas trouve d'elements a tracer, on garde l'ancien masq
ue */
	pec_1.msqoto[0] = pec_1.masque[0];
	pec_1.msqoto[1] = pec_1.masque[1];
	pec_1.msqoto[2] = pec_1.masque[2];
	pec_1.msqoto[3] = pec_1.masque[3];
    }
    commen_("FIN DRWMSH", 10L);
    return 0;
} /* drwmsh_ */




doublereal dtc1c2_(real *c1, real *c2)
{
    /* System generated locals */
    real ret_val, r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real d;


/*     retourne la distance entre c1 et c2 */



    if (c1[0] == -1e3f || c2[0] == -1e3f) {
	ret_val = 0.f;
    } else if (c1[0] >= 0.f) {
	if (c2[0] >= 0.f) {
/*         c1 et c2 sont des cercles */
/* Computing 2nd power */
	    r__1 = c1[1] - c2[1];
/* Computing 2nd power */
	    r__2 = c1[2] - c2[2];
	    d = sqrt(r__1 * r__1 + r__2 * r__2);
	    ret_val = (r__2 = (r__1 = d - dmax(c1[0],c2[0]), dabs(r__1)) - 
		    dmin(c1[0],c2[0]), dabs(r__2));
	} else {
/*         c1 est un cercle et c2 une droite */
	    d = (r__1 = c2[1] * c1[1] + c2[2] * c1[2] + c2[3], dabs(r__1));
	    ret_val = (r__1 = d - c1[0], dabs(r__1));
	}
    } else {
	if (c2[0] >= 0.f) {
/*         c1 est une droite et c2 un cercle */
	    d = (r__1 = c1[1] * c2[1] + c1[2] * c2[2] + c1[3], dabs(r__1));
	    ret_val = (r__1 = d - c2[0], dabs(r__1));
	} else {
/*         c1 et c2 sont des droites */
	    if (c1[1] != c2[1] || c1[2] != c2[2]) {
		ret_val = 0.f;
	    } else {
		ret_val = (r__1 = c1[3] - c2[3], dabs(r__1));
	    }
	}
    }
    return ret_val;
} /* dtc1c2_ */

#undef coulls


/* Subroutine */ int dtcodo_(integer *ptdomn, integer *ptcomp)
{
    /* Local variables */

    extern integer removx_(integer *, integer *);


/*     elle retire la composante ptcomp au domaine ptdomn */


    if (*ptdomn != 0) {
	listed_1.cdr[listea_1.car[*ptdomn - 1] - 1] = removx_(ptcomp, &
		listed_1.cdr[listea_1.car[*ptdomn - 1] - 1]);
    }
    return 0;
} /* dtcodo_ */




/* Subroutine */ int dtdomn_(integer *ptdomn)
{
    /* Local variables */

    extern /* Subroutine */ int freel_(integer *);
    extern integer removx_(integer *, integer *);


/*     detruit le domaine ptdomn */


    bdpec1_1.sdomn = removx_(&listea_1.car[*ptdomn - 1], &bdpec1_1.sdomn);
    if (*ptdomn != 0) {
	freel_(&listea_1.car[listea_1.car[listea_1.car[*ptdomn - 1] - 1] - 1])
		;
	freel_(&listea_1.car[listea_1.car[*ptdomn - 1] - 1]);
	freel_(&listea_1.car[*ptdomn - 1]);
    }
    return 0;
} /* dtdomn_ */




doublereal dtp1sp_(real *p1, integer *sp, integer *ptt)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    real dist;

    integer pt, pt1, preced;
    real ss[6];
    extern doublereal dtp1xx_(real *, real *);


/*     retourne la distance entre le point p1 et la spline d'adresse sp */
/*     (on recherche la distance min aux segments reliants les points */
/*      de definition) */
/*     elle retourne aussi dans ptt le pointeur sur le cons dont le car */
/*     pointe sur le premier point du segment le plus proche de x,y */


    ret_val = 1e30f;
    *ptt = 0;
    if (bdpec2_1.bd[*sp * 6 + 384] != -4.f) {
	return ret_val;
    }
    ss[0] = -3.f;
    pt = bdpec2_1.bd[*sp * 6 + 386];
    if (pt != 0) {
	pt1 = listea_1.car[pt - 1];
	ss[1] = bdpec2_1.bd[pt1 * 6 + 385];
	ss[2] = bdpec2_1.bd[pt1 * 6 + 386];
	preced = pt;
	*ptt = preced;
	pt = listed_1.cdr[pt - 1];
L1:
	if (pt != 0) {
	    pt1 = listea_1.car[pt - 1];
	    ss[3] = bdpec2_1.bd[pt1 * 6 + 385];
	    ss[4] = bdpec2_1.bd[pt1 * 6 + 386];
	    dist = dtp1xx_(p1, ss);
	    if (dist < ret_val) {
		ret_val = dist;
		*ptt = preced;
	    }
	    ss[1] = ss[3];
	    ss[2] = ss[4];
	    preced = pt;
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
    }
    return ret_val;
} /* dtp1sp_ */




doublereal dtp1xx_(real *p1, real *c2)
{
    /* System generated locals */
    real ret_val, r__1, r__2, r__3, r__4, r__5, r__6;

    /* Builtin functions */
    double sqrt(doublereal), cos(doublereal), sin(doublereal), r_mod(real *, 
	    real *);

    /* Local variables */
    real d[4];
    extern /* Subroutine */ int dp1d1a_(real *, real *, real *, real *);
    real r;
    extern /* Subroutine */ int drp1p2_(real *, real *, real *);
    extern doublereal atang2_(real *, real *);
    real dx, dy;
    real pp1[4], pp2[4], ps1, ps2, ang, p1p2[4], ang1, ang2;


/*     retourne la distance entre le point p1 et l'element c2 */



    if (p1[0] == -1e3f || c2[0] == -1e3f) {
	ret_val = 0.f;
    } else if (c2[0] >= 0.f) {
/* Computing 2nd power */
	r__2 = p1[1] - c2[1];
/* Computing 2nd power */
	r__3 = p1[2] - c2[2];
	ret_val = (r__1 = sqrt(r__2 * r__2 + r__3 * r__3) - c2[0], dabs(r__1))
		;
    } else if (c2[0] == -1.f) {
	ret_val = (r__1 = c2[1] * p1[1] + c2[2] * p1[2] + c2[3], dabs(r__1));
    } else if (c2[0] == -3.f) {
	pp1[0] = 0.f;
	pp1[1] = c2[1];
	pp1[2] = c2[2];
	pp2[0] = 0.f;
	pp2[1] = c2[3];
	pp2[2] = c2[4];
	drp1p2_(p1p2, pp1, pp2);
	ret_val = (r__1 = p1p2[1] * p1[1] + p1p2[2] * p1[2] + p1p2[3], dabs(
		r__1));
	dp1d1a_(d, p1, p1p2, &c_b2168);
	ps1 = d[1] * c2[1] + d[2] * c2[2] + d[3];
	ps2 = d[1] * c2[3] + d[2] * c2[4] + d[3];
	if (ps1 * ps2 > 0.f) {
/* Computing MIN */
/* Computing 2nd power */
	    r__3 = p1[1] - c2[1];
/* Computing 2nd power */
	    r__4 = p1[2] - c2[2];
/* Computing 2nd power */
	    r__5 = p1[1] - c2[3];
/* Computing 2nd power */
	    r__6 = p1[2] - c2[4];
	    r__1 = sqrt(r__3 * r__3 + r__4 * r__4), r__2 = sqrt(r__5 * r__5 + 
		    r__6 * r__6);
	    ret_val = dmin(r__1,r__2);
	}
    } else if (c2[0] == -2.f) {
/* Computing 2nd power */
	r__1 = c2[1] - c2[3];
/* Computing 2nd power */
	r__2 = c2[2] - c2[4];
	r = sqrt(r__1 * r__1 + r__2 * r__2);
	dx = c2[3] - c2[1];
	dy = c2[4] - c2[2];
	pp2[1] = c2[1] + dx * cos(c2[5]) - dy * sin(c2[5]);
	pp2[2] = c2[2] + dx * sin(c2[5]) + dy * cos(c2[5]);
	r__1 = p1[2] - c2[2];
	r__2 = p1[1] - c2[1];
	ang1 = atang2_(&r__1, &r__2);
	r__1 = c2[4] - c2[2];
	r__2 = c2[3] - c2[1];
	ang2 = atang2_(&r__1, &r__2);
	r__1 = ang1 - ang2 + 6.283185306f;
	ang = r_mod(&r__1, &c_b28);
	if (c2[5] < 0.f) {
	    ang += -6.283185306f;
	    if (ang >= c2[5]) {
/* Computing 2nd power */
		r__2 = p1[1] - c2[1];
/* Computing 2nd power */
		r__3 = p1[2] - c2[2];
		ret_val = (r__1 = sqrt(r__2 * r__2 + r__3 * r__3) - r, dabs(
			r__1));
	    } else {
/* Computing MIN */
/* Computing 2nd power */
		r__3 = p1[1] - c2[3];
/* Computing 2nd power */
		r__4 = p1[2] - c2[4];
/* Computing 2nd power */
		r__5 = p1[1] - pp2[1];
/* Computing 2nd power */
		r__6 = p1[2] - pp2[2];
		r__1 = r__3 * r__3 + r__4 * r__4, r__2 = r__5 * r__5 + r__6 * 
			r__6;
		ret_val = sqrt((dmin(r__1,r__2)));
	    }
	} else {
	    if (ang <= c2[5]) {
/* Computing 2nd power */
		r__2 = p1[1] - c2[1];
/* Computing 2nd power */
		r__3 = p1[2] - c2[2];
		ret_val = (r__1 = sqrt(r__2 * r__2 + r__3 * r__3) - r, dabs(
			r__1));
	    } else {
/* Computing MIN */
/* Computing 2nd power */
		r__3 = p1[1] - c2[3];
/* Computing 2nd power */
		r__4 = p1[2] - c2[4];
/* Computing 2nd power */
		r__5 = p1[1] - pp2[1];
/* Computing 2nd power */
		r__6 = p1[2] - pp2[2];
		r__1 = r__3 * r__3 + r__4 * r__4, r__2 = r__5 * r__5 + r__6 * 
			r__6;
		ret_val = sqrt((dmin(r__1,r__2)));
	    }
	}
    }
    return ret_val;
} /* dtp1xx_ */

#undef coulls


/* Subroutine */ int dumpad_(integer *ad)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double cos(doublereal), sin(doublereal);

    /* Local variables */

    real x2, y2;
    integer pt;
    real dx, dy;

    /* Fortran I/O blocks */
    /*static*/ cilist io___1141 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1142 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1143 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1144 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1149 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1150 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1152 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1153 = { 0, 6, 0, 0, 0 };


/*     dump l'element d'adresse ad */


    if (bdpec2_1.bd[*ad * 6 + 384] == 0.f) {
	s_wsle(&io___1141);
	do_lio(&c__9, &c__1, "POINT X=", 8L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " Y=", 3L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 386], (ftnlen)
		sizeof(real));
	e_wsle();
    } else if (bdpec2_1.bd[*ad * 6 + 384] > 0.f) {
	s_wsle(&io___1142);
	do_lio(&c__9, &c__1, "CERCLE R=", 9L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 384], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " X=", 3L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " Y=", 3L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 386], (ftnlen)
		sizeof(real));
	e_wsle();
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -1.f) {
	s_wsle(&io___1143);
	do_lio(&c__9, &c__1, "DROITE A=", 9L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " B=", 3L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 386], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " C=", 3L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 387], (ftnlen)
		sizeof(real));
	e_wsle();
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -3.f) {
	s_wsle(&io___1144);
	do_lio(&c__9, &c__1, "SEGMENT X1,Y1=", 14L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 386], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " X2,Y2=", 7L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 387], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 388], (ftnlen)
		sizeof(real));
	e_wsle();
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -2.f) {
	dx = bdpec2_1.bd[*ad * 6 + 387] - bdpec2_1.bd[*ad * 6 + 385];
	dy = bdpec2_1.bd[*ad * 6 + 388] - bdpec2_1.bd[*ad * 6 + 386];
	x2 = bdpec2_1.bd[*ad * 6 + 385] + dx * cos(bdpec2_1.bd[*ad * 6 + 389])
		 - dy * sin(bdpec2_1.bd[*ad * 6 + 389]);
	y2 = bdpec2_1.bd[*ad * 6 + 386] + dx * sin(bdpec2_1.bd[*ad * 6 + 389])
		 + dy * cos(bdpec2_1.bd[*ad * 6 + 389]);
	s_wsle(&io___1149);
	do_lio(&c__9, &c__1, "ARC XC,YC=", 10L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 386], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " P1X,P1Y=", 9L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 387], (ftnlen)
		sizeof(real));
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 388], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " P2X,P2Y=", 9L);
	do_lio(&c__4, &c__1, (char *)&x2, (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&y2, (ftnlen)sizeof(real));
	do_lio(&c__9, &c__1, " ALPHA=", 7L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 389], (ftnlen)
		sizeof(real));
	e_wsle();
    } else if (bdpec2_1.bd[*ad * 6 + 384] == -4.f) {
	s_wsle(&io___1150);
	do_lio(&c__9, &c__1, "SPLINE NB POINTS=", 17L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 385], (ftnlen)
		sizeof(real));
	e_wsle();
	pt = bdpec2_1.bd[*ad * 6 + 386];
L1:
	if (pt != 0) {
	    s_wsle(&io___1152);
	    do_lio(&c__9, &c__1, "          PT CONTROL X,Y=", 25L);
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[listea_1.car[pt - 1] * 
		    6 + 385], (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[listea_1.car[pt - 1] * 
		    6 + 386], (ftnlen)sizeof(real));
	    e_wsle();
	    pt = listed_1.cdr[pt - 1];
	    goto L1;
	}
    } else {
	s_wsle(&io___1153);
	do_lio(&c__9, &c__1, "DUMPAD TYPE INCONNU ", 20L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*ad * 6 + 384], (ftnlen)
		sizeof(real));
	e_wsle();
    }
    return 0;
} /* dumpad_ */




/* Subroutine */ int ecrms1_(integer *nf, integer *refpts, integer *reftri)
{
    /* Format strings */
    static char fmt_499[] = "(/,10(1x,i6))";
    static char fmt_498[] = "(/,3(3(1x,i6),1x,i1))";
    static char fmt_497[] = "(/,1(3(1x,i15),3(/3(1x,1pd25.16))))";

    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6, i__7, i__8, i__9;
    cilist ci__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void), i_sign(integer *, integer *);

    /* Local variables */
    integer nbbd;

    integer i, j, k, j1, j2;
    integer cas, pt, nb;

    /* Fortran I/O blocks */
    /*static*/ cilist io___1157 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1160 = { 0, 0, 0, fmt_499, 0 };
    /*static*/ cilist io___1161 = { 0, 0, 0, fmt_498, 0 };
    /*static*/ cilist io___1162 = { 0, 0, 0, fmt_499, 0 };
    /*static*/ cilist io___1163 = { 0, 0, 0, fmt_497, 0 };
    /*static*/ cilist io___1170 = { 0, 0, 0, fmt_499, 0 };
    /*static*/ cilist io___1171 = { 0, 0, 0, fmt_499, 0 };
    /*static*/ cilist io___1172 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1173 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1174 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1175 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1176 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1178 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1179 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1180 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    --reftri;

    /* Function Body */
    io___1157.ciunit = *nf;
    s_wsle(&io___1157);
    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbs, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nba, (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsd, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " -- nbt,nbs,nba,nbsd------", 26L);
    e_wsle();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, "-version2-  coordonnee des sommets ------  ", 43L);
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(2(3(1x,1pe12.5),1x,i5,2x))";
    s_wsfe(&ci__1);
    i__1 = bdmsh1_1.nbs;
    for (j = 1; j <= i__1; ++j) {
	for (i = 1; i <= 2; ++i) {
	    do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (j << 1) - 3], (ftnlen)
		    sizeof(real));
	}
	do_fio(&c__1, (char *)&bdmsh7_1.abcurv[j - 1], (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&bdmsh6_1.nsorig[j - 1], (ftnlen)sizeof(integer)
		);
    }
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, "-- arete du maillage-----------------------", 43L);
    e_wsfe();
    io___1160.ciunit = *nf;
    s_wsfe(&io___1160);
    i__1 = bdmsh1_1.nba;
    for (j = 1; j <= i__1; ++j) {
	for (i = 1; i <= 2; ++i) {
	    do_fio(&c__1, (char *)&bdmshc_1.aretbd[i + (j << 1) - 3], (ftnlen)
		    sizeof(integer));
	}
    }
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, "-version2- numero des sommets des triangles", 43L);
    e_wsfe();
    io___1161.ciunit = *nf;
    s_wsfe(&io___1161);
    i__1 = bdmsh1_1.nbt;
    for (j = 1; j <= i__1; ++j) {
	for (i = 1; i <= 3; ++i) {
	    do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
		    sizeof(integer));
	}
	do_fio(&c__1, (char *)&bdmshb_1.apavue[j - 1], (ftnlen)sizeof(integer)
		);
    }
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, "--pointeur des sous domaine des triangles --- read *, (re"
	    "ft(i),i=1,nbt)", 71L);
    e_wsfe();
    io___1162.ciunit = *nf;
    s_wsfe(&io___1162);
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	do_fio(&c__1, (char *)&bdmsha_1.reft[i - 1], (ftnlen)sizeof(integer));
    }
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, "-- reference  des sous domaines  ---------------read *,(r"
	    "efsd(j),j=1,nbsd)", 74L);
    e_wsfe();
    io___1163.ciunit = *nf;
    s_wsfe(&io___1163);
    i__1 = bdmsh1_1.nbsd;
    for (j = 1; j <= i__1; ++j) {
	do_fio(&c__1, (char *)&bdmshf_1.refsd[j - 1], (ftnlen)sizeof(integer))
		;
	do_fio(&c__1, (char *)&bdmshj_1.ptorsd[j - 1], (ftnlen)sizeof(integer)
		);
	do_fio(&c__1, (char *)&bdmshi_1.strfsd[j - 1], (ftnlen)sizeof(integer)
		);
	for (j2 = 1; j2 <= 3; ++j2) {
	    for (j1 = 1; j1 <= 3; ++j1) {
		do_fio(&c__1, (char *)&bdmshh_1.trfsd[j1 + (j2 + j * 3) * 3 - 
			13], (ftnlen)sizeof(doublereal));
	    }
	}
    }
    e_wsfe();
    refpts[0] = 0;
    i__1 = bdmsh4_1.finbd3;
    for (i = 1; i <= i__1; ++i) {
	refpts[i] = -1073741824;
/* L20: */
    }
/*   ----- boucle sur tout les ref d'arete et de sommet (cas = nba, nbs) 
*/
    j = 0;
    for (cas = 1; cas <= 2; ++cas) {
	if (cas == 1) {
	    nb = bdmsh1_1.nba;
	} else {
	    nb = bdmsh1_1.nbs;
	}
	i__1 = nb;
	for (i = 1; i <= i__1; ++i) {
	    if (cas == 1) {
		k = (i__2 = bdmshe_1.refa[i - 1], abs(i__2));
	    } else {
		k = (i__2 = bdmsh8_1.refs[i - 1], abs(i__2));
	    }
	    if (refpts[k] == -1073741824) {
		++j;
		reftri[j] = k;
		refpts[k] = j;
		if (bdpec2_1.bd[k * 6 + 384] != 0.f) {
		    if (refpts[bdpec6_1.nuref1[(k << 1) + 128]] == 
			    -1073741824) {
			++j;
			reftri[j] = bdpec6_1.nuref1[(k << 1) + 128];
			refpts[reftri[j]] = j;
		    }
		    if (refpts[bdpec7_1.nuref2[(k << 1) + 128]] == 
			    -1073741824) {
			++j;
			reftri[j] = bdpec7_1.nuref2[(k << 1) + 128];
			refpts[reftri[j]] = j;
		    }
		}
	    }
/* L40: */
	}
/* L30: */
    }
    nbbd = j;
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, " --pointeur des sommets sur la BD--------- read *,refs(i)"
	    ",i=1,nbs) ", 67L);
    e_wsfe();
    io___1170.ciunit = *nf;
    s_wsfe(&io___1170);
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	i__5 = (i__3 = refpts[i__2 = bdmsh8_1.refs[i - 1], abs(i__2)], abs(
		i__3));
	i__4 = i_sign(&i__5, &bdmsh8_1.refs[i - 1]);
	do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
    }
    e_wsfe();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, " --pointeur des arete sur la BD----------- read *,refa(i)"
	    ",i=1,nbs) ", 67L);
    e_wsfe();
    io___1171.ciunit = *nf;
    s_wsfe(&io___1171);
    i__2 = bdmsh1_1.nba;
    for (i = 1; i <= i__2; ++i) {
	i__5 = (i__4 = refpts[i__3 = bdmshe_1.refa[i - 1], abs(i__3)], abs(
		i__4));
	do_fio(&c__1, (char *)&i__5, (ftnlen)sizeof(integer));
    }
    e_wsfe();
    io___1172.ciunit = *nf;
    s_wsle(&io___1172);
    do_lio(&c__3, &c__1, (char *)&nbbd, (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " -- nbbd =  nb d'arcs et de segments,de points de "
	    "la BD --", 58L);
    e_wsle();
    ci__1.cierr = 0;
    ci__1.ciunit = *nf;
    ci__1.cifmt = "(a)";
    s_wsfe(&ci__1);
    do_fio(&c__1, " -version2- bd =  read *,'type'bd(i,j),i=1,5),nuref(GAUCH"
	    "E,j),j=1,nbbd ", 71L);
    e_wsfe();
    i__3 = nbbd;
    for (i = 1; i <= i__3; ++i) {
	k = reftri[i];
	if (bdpec2_1.bd[k * 6 + 384] == -2.f) {
	    io___1173.ciunit = *nf;
	    s_wsle(&io___1173);
	    do_lio(&c__9, &c__1, "'arc    '", 9L);
	    for (j = 1; j <= 5; ++j) {
		do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j + k * 6 + 384], (
			ftnlen)sizeof(real));
	    }
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 128], (
		    ftnlen)sizeof(integer));
	    i__5 = (i__4 = refpts[bdpec6_1.nuref1[(k << 1) + 128]], abs(i__4))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__5, (ftnlen)sizeof(integer));
	    i__1 = (i__2 = refpts[bdpec7_1.nuref2[(k << 1) + 128]], abs(i__2))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 129], (
		    ftnlen)sizeof(integer));
	    i__7 = (i__6 = refpts[bdpec6_1.nuref1[(k << 1) + 129]], abs(i__6))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__7, (ftnlen)sizeof(integer));
	    i__9 = (i__8 = refpts[bdpec7_1.nuref2[(k << 1) + 129]], abs(i__8))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__9, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[k + 64], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[k + 64], (ftnlen)
		    sizeof(real));
	    do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[k + 64], (ftnlen)
		    sizeof(logical));
	    e_wsle();
	} else if (bdpec2_1.bd[k * 6 + 384] == 0.f) {
	    io___1174.ciunit = *nf;
	    s_wsle(&io___1174);
	    do_lio(&c__9, &c__1, "'point  '", 9L);
	    for (j = 1; j <= 2; ++j) {
		do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j + k * 6 + 384], (
			ftnlen)sizeof(real));
	    }
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 128], (
		    ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&c__0, (ftnlen)sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&c_b614, (ftnlen)sizeof(real));
	    do_lio(&c__8, &c__1, (char *)&c__0, (ftnlen)sizeof(logical));
	    e_wsle();
	} else if (bdpec2_1.bd[k * 6 + 384] == -3.f) {
	    io___1175.ciunit = *nf;
	    s_wsle(&io___1175);
	    do_lio(&c__9, &c__1, "'segment'", 9L);
	    for (j = 1; j <= 4; ++j) {
		do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j + k * 6 + 384], (
			ftnlen)sizeof(real));
	    }
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 128], (
		    ftnlen)sizeof(integer));
	    i__5 = (i__4 = refpts[bdpec6_1.nuref1[(k << 1) + 128]], abs(i__4))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__5, (ftnlen)sizeof(integer));
	    i__1 = (i__2 = refpts[bdpec7_1.nuref2[(k << 1) + 128]], abs(i__2))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 129], (
		    ftnlen)sizeof(integer));
	    i__7 = (i__6 = refpts[bdpec6_1.nuref1[(k << 1) + 129]], abs(i__6))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__7, (ftnlen)sizeof(integer));
	    i__9 = (i__8 = refpts[bdpec7_1.nuref2[(k << 1) + 129]], abs(i__8))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__9, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[k + 64], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[k + 64], (ftnlen)
		    sizeof(real));
	    do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[k + 64], (ftnlen)
		    sizeof(logical));
	    e_wsle();
	} else if (bdpec2_1.bd[k * 6 + 384] == -4.f) {
	    io___1176.ciunit = *nf;
	    s_wsle(&io___1176);
	    do_lio(&c__9, &c__1, "'spline'", 8L);
	    for (j = 1; j <= 2; ++j) {
		do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j + k * 6 + 384], (
			ftnlen)sizeof(real));
	    }
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&c_b609, (ftnlen)sizeof(real));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 128], (
		    ftnlen)sizeof(integer));
	    i__5 = (i__4 = refpts[bdpec6_1.nuref1[(k << 1) + 128]], abs(i__4))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__5, (ftnlen)sizeof(integer));
	    i__1 = (i__2 = refpts[bdpec7_1.nuref2[(k << 1) + 128]], abs(i__2))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec5_1.nuref[(k << 1) + 129], (
		    ftnlen)sizeof(integer));
	    i__7 = (i__6 = refpts[bdpec6_1.nuref1[(k << 1) + 129]], abs(i__6))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__7, (ftnlen)sizeof(integer));
	    i__9 = (i__8 = refpts[bdpec7_1.nuref2[(k << 1) + 129]], abs(i__8))
		    ;
	    do_lio(&c__3, &c__1, (char *)&i__9, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdpec3_1.nbnode[k + 64], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__4, &c__1, (char *)&bdpec4_1.raison[k + 64], (ftnlen)
		    sizeof(real));
	    do_lio(&c__8, &c__1, (char *)&bdpecd_1.fissur[k + 64], (ftnlen)
		    sizeof(logical));
	    e_wsle();
	    pt = bdpec2_1.bd[k * 6 + 386];
L45:
	    if (pt != 0) {
		io___1178.ciunit = *nf;
		s_wsle(&io___1178);
		do_lio(&c__9, &c__1, "'pt spline'", 11L);
		for (j = 1; j <= 2; ++j) {
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j + 
			    listea_1.car[pt - 1] * 6 + 384], (ftnlen)sizeof(
			    real));
		}
		e_wsle();
		pt = listed_1.cdr[pt - 1];
		goto L45;
	    }
	} else {
	    io___1179.ciunit = *nf;
	    s_wsle(&io___1179);
	    do_lio(&c__9, &c__1, "..ERREUR.. ", 11L);
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[k * 6 + 384], (ftnlen)
		    sizeof(real));
	    do_lio(&c__9, &c__1, " l'element de bd inconnue dans ecrmsh", 37L)
		    ;
	    e_wsle();
	    s_wsle(&io___1180);
	    do_lio(&c__9, &c__1, "..ERREUR.. ", 11L);
	    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[k * 6 + 384], (ftnlen)
		    sizeof(real));
	    do_lio(&c__9, &c__1, " l'element de bd inconnue dans ecrmsh", 37L)
		    ;
	    e_wsle();
	}
/* L50: */
    }
    return 0;
} /* ecrms1_ */


#ifdef ecrmsh_

/* Subroutine */ int ecrmsh_(void)
{
    /* System generated locals */
    address a__1[3], a__2[4], a__3[2];
    integer i__1[3], i__2, i__3[4], i__4, i__5, i__6, i__7, i__8[2];
    char ch__1[109], ch__2[115];
    cilist ci__1;
    cllist cl__1;

    /* Builtin functions */
    integer s_cmp(char *, char *, ftnlen, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer i_len(char *, ftnlen);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer s_wsue(cilist *), do_uio(integer *, char *, ftnlen), e_wsue(void),
	     s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void), f_clos(cllist *);

    /* Local variables */
    char type[80];
    integer i, j;

    char forme[11];
    extern /* Subroutine */ int ecrms1_(integer *, integer *, integer *);
    integer ii, nf;
    char fichie[80];
    extern /* Subroutine */ int genadj_(integer *, real *, integer *, integer 
	    *);
    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen);
    integer err;
    char yes[10];
    extern integer rfsomm_(integer *);
    extern /* Subroutine */ int scrtch_(char *, ftnlen), intext_(char *, 
	    integer *, char *, integer *, ftnlen, ftnlen), ecrnop_(integer *, 
	    integer *, integer *, integer *), chtrgl_(void);

    /* Fortran I/O blocks */
    /*static*/ cilist io___1193 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1194 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1195 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1196 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1197 = { 0, 0, 0, 0, 0 };


L5:
    if (bdmsh1_1.nbt == 0) {
	scrtch_(" il n'y a rien a ecrire ", 24L);
	return 0;
    }
/*     call intext('donnez le type du maillage '                        #F
R*/
    intext_("give the type of mesh (nopo am am_fmt mesh amdba cnet):", &c__50,
	     type, &ii, 55L, 80L);
    if (ii == 0 || s_cmp(type, "MESH", 80L, 4L) == 0 || s_cmp(type, "mesh", 
	    80L, 4L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".mesh", 80L, 5L);
	ii = i_len(".mesh", 5L);
    } else if (s_cmp(type, "NOPO", 80L, 4L) == 0 || s_cmp(type, "nopo", 80L, 
	    4L) == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".nopo", 80L, 5L);
	ii = i_len(".nopo", 5L);
    } else if (s_cmp(type, "AM", 80L, 2L) == 0 || s_cmp(type, "am", 80L, 2L) 
	    == 0) {
	s_copy(forme, "unformatted", 11L, 11L);
	s_copy(type, ".am", 80L, 3L);
	ii = i_len(".am", 3L);
    } else if (s_cmp(type, "AM_FMT", 80L, 6L) == 0 || s_cmp(type, "am_fmt", 
	    80L, 6L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".am_fmt", 80L, 7L);
	ii = i_len(".am_fmt", 7L);
    } else if (s_cmp(type, "CNET", 80L, 4L) == 0 || s_cmp(type, "cnet", 80L, 
	    4L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".cnet", 80L, 5L);
	ii = i_len(".am_fmt", 7L);
    } else if (s_cmp(type, "AMDBA", 80L, 5L) == 0 || s_cmp(type, "amdba", 80L,
	     5L) == 0) {
	s_copy(forme, "formatted", 11L, 9L);
	s_copy(type, ".amdba", 80L, 6L);
	ii = i_len(".amdba", 6L);
    } else {
/* Writing concatenation */
	i__1[0] = 16, a__1[0] = "mauvais type : '";
	i__1[1] = ii, a__1[1] = type;
	i__1[2] = 13, a__1[2] = "' recommencez";
	s_cat(ch__1, a__1, i__1, &c__3, 109L);
	scrtch_(ch__1, ii + 29);
	goto L5;
    }
L10:
/*     call intext('donnez le prefix des noms de fichiers '             #F
R*/
    intext_("give the prefix part of file's names: type(1:ii) de generation:",
	     &c__50, fichie, &i, 63L, 80L);
    if (i == 0) {
/*      call scrtch('nom de fichier vide, on abandonne !')            
  #FR*/
	scrtch_("file name empty => cancel !", 27L);
	return 0;
    }
    i__2 = i;
    s_copy(fichie + i__2, type, 80 - i__2, 80L);
    if (fouvri_(&nf, fichie, forme, &c__0, i + ii, 11L) != 0) {
	scrtch_("pb dans open de votre fichier, changer de nom.", 46L);
	goto L10;
    }
/* Writing concatenation */
    i__3[0] = 16, a__2[0] = "open du fichier ";
    i__3[1] = 11, a__2[1] = forme;
    i__3[2] = 8, a__2[2] = " de nom:";
    i__3[3] = i + ii, a__2[3] = fichie;
    s_cat(ch__2, a__2, i__3, &c__4, 115L);
    scrtch_(ch__2, i + ii + 35);
/* -----on compresse le maillage ----------------- */
    i__2 = bdmsh0_1.nbpmx + bdmsh0_1.nbtmx;
/*#define xwork ((real *) bdwrk1_1.work)*/
    genadj_(&bdwrk1_1.work[bdmsh0_1.nbpmx], &bdwrk1_3.xwork[bdmsh0_1.nbpmx], &
	    bdwrk1_1.work[bdmsh0_1.nbpmx * 3], &i__2);
/*#undef xwork*/
    bdpec5_1.nuref[128] = 0;
    err = 0;
    if (s_cmp(type, ".mesh", 80L, 5L) == 0) {
	ecrms1_(&nf, bdwrk1_1.work, &bdwrk1_1.work[bdpec1_1.mxbd + 1]);
    } else if (s_cmp(type, ".nopo", 80L, 5L) == 0) {
/* old        call ecrnop(tri,nbtmx*2+1,nf,err) */
/* --      verif ref ssd */
	j = 0;
	i__2 = bdmsh1_1.nbsd;
	for (i = 1; i <= i__2; ++i) {
	    if (bdmshf_1.refsd[j - 1] == 0) {
		++j;
	    }
	}
	if (j != 0) {
L20:
	    intext_("Be carefull some ref. domain are equal to 0  (Bug in co"
		    "maco), do you continue (y,n)  ", &c__10, yes, &i, 85L, 
		    10L);
/*       call intext('Attention , il y a des ref de sous domaine n
ulle '#FR*/
/*   +    // '(Bug dans comaco), On continue  (o,n)  ',10,yes,i)  
      #FR*/
	    if (i != 1) {
		goto L20;
	    } else if (*yes == 'n' || *yes == 'N') {
		return 0;
	    } else if (*yes != 'y' && *yes != 'Y' && *yes != 'o' && *yes != 
		    'O') {
		goto L20;
	    }
	}
	ecrnop_(bdwrk1_1.work, &bdmsh0_1.lwork, &nf, &err);
    } else if (s_cmp(type, ".am", 80L, 3L) == 0) {
	io___1193.ciunit = nf;
	s_wsue(&io___1193);
	do_uio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
	do_uio(&c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	e_wsue();
	io___1194.ciunit = nf;
	s_wsue(&io___1194);
	i__2 = bdmsh1_1.nbt;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_uio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	}
	i__4 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_uio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	}
	i__5 = bdmsh1_1.nbt;
	for (i = 1; i <= i__5; ++i) {
	    do_uio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	i__6 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__6; ++i) {
	    i__7 = rfsomm_(&i);
	    do_uio(&c__1, (char *)&i__7, (ftnlen)sizeof(integer));
	}
	e_wsue();
    } else if (s_cmp(type, ".am_fmt", 80L, 7L) == 0) {
	io___1195.ciunit = nf;
	s_wsle(&io___1195);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "  -- nbs,nbt ", 13L);
	e_wsle();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(2(3(1x,     i6),3x))";
	s_wsfe(&ci__1);
	i__2 = bdmsh1_1.nbt;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(2(2(1x,1pe14.6),3x))";
	s_wsfe(&ci__1);
	i__2 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__2; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(10(1x,i7))";
	s_wsfe(&ci__1);
	i__2 = bdmsh1_1.nbt;
	for (i = 1; i <= i__2; ++i) {
	    do_fio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(10(1x,i7))";
	s_wsfe(&ci__1);
	i__2 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__2; ++i) {
	    i__4 = rfsomm_(&i);
	    do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else if (s_cmp(type, ".cnet", 80L, 5L) == 0) {
	io___1196.ciunit = nf;
	s_wsle(&io___1196);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "  -- nbs,nbt ", 13L);
	e_wsle();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(2(3(1x,     i6),3x))";
	s_wsfe(&ci__1);
	i__4 = bdmsh1_1.nbt;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(2(2(1x,1pe14.6),3x))";
	s_wsfe(&ci__1);
	i__4 = bdmsh1_1.nbsrft;
	for (j = 1; j <= i__4; ++j) {
	    for (i = 1; i <= 2; ++i) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[i + (bdmsh6_1.nsorig[j - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(10(1x,i7))";
	s_wsfe(&ci__1);
	i__4 = bdmsh1_1.nbt;
	for (i = 1; i <= i__4; ++i) {
	    do_fio(&c__1, (char *)&bdmsha_1.reft[i - 1], (ftnlen)sizeof(
		    integer));
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(10(1x,i7))";
	s_wsfe(&ci__1);
	i__4 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__4; ++i) {
	    i__2 = rfsomm_(&i);
	    do_fio(&c__1, (char *)&i__2, (ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else if (s_cmp(type, ".amdba", 80L, 6L) == 0) {
	io___1197.ciunit = nf;
	s_wsle(&io___1197);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer)
		);
	do_lio(&c__3, &c__1, (char *)&bdmsh1_1.nbt, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "  -- nbs,nbt ", 13L);
	e_wsle();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(1(1x,i10,2(1x,1pe15.7),4x,i5))";
	s_wsfe(&ci__1);
	i__2 = bdmsh1_1.nbsrft;
	for (i = 1; i <= i__2; ++i) {
	    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
	    for (j = 1; j <= 2; ++j) {
		do_fio(&c__1, (char *)&bdmsh5_1.cr[j + (bdmsh6_1.nsorig[i - 1]
			 << 1) - 3], (ftnlen)sizeof(real));
	    }
	    i__4 = rfsomm_(&i);
	    do_fio(&c__1, (char *)&i__4, (ftnlen)sizeof(integer));
	}
	e_wsfe();
	ci__1.cierr = 0;
	ci__1.ciunit = nf;
	ci__1.cifmt = "(1(1x,i6,3(1x,i6),4x,i5))";
	s_wsfe(&ci__1);
	i__4 = bdmsh1_1.nbt;
	for (j = 1; j <= i__4; ++j) {
	    do_fio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 3; ++i) {
		do_fio(&c__1, (char *)&bdmsh9_1.nsea[i + j * 6 - 7], (ftnlen)
			sizeof(integer));
	    }
	    do_fio(&c__1, (char *)&bdmshf_1.refsd[bdmsha_1.reft[j - 1] - 1], (
		    ftnlen)sizeof(integer));
	}
	e_wsfe();
    } else {
/* Writing concatenation */
	i__8[0] = 29, a__3[0] = "ERREUR ecrmsh dans les types ";
	i__8[1] = ii - 1, a__3[1] = type + 1;
	s_cat(ch__1, a__3, i__8, &c__2, 109L);
	scrtch_(ch__1, ii + 28);
	err = 1;
    }
    if (err != 0) {
	scrtch_("ERREUR generation pas assez de place memoire", 44L);
	cl__1.cerr = 0;
	cl__1.cunit = nf;
	cl__1.csta = "delete";
	f_clos(&cl__1);
    } else {
	cl__1.cerr = 0;
	cl__1.cunit = nf;
	cl__1.csta = 0;
	f_clos(&cl__1);
    }
    chtrgl_();
    return 0;
} /* ecrmsh_ */
#endif



/* Subroutine */ int ecrnop_(integer *m, integer *lm, integer *nfnopo, 
	integer *err)
{
    /* Format strings */
    static char fmt_2000[] = "(1x,\002quelques parametres lies au maillag"
	    "e\002/1x,\002------------------------------------\002/5x,i10,"
	    "\002 noeud2\002/5x,i10,\002 triangles\002/5x,i10,\002 quadrangles"
	    "\002/5x,i10,\002 sous-domaine\002/5x,i10,\002 references differe"
	    "ntes\002/5x,i10,\002 elements avec au moins une reference\002/5x"
	    ",i10,\002 (encombrement reel de nop5)\002/5x,i10,\002 (1/2 large"
	    "ur de bande\002/)";
    static char fmt_1000[] = "(1x,10(\002*\002),\002 fin generation nopo sur"
	    " fichier\002,i5/)";

    /* System generated locals */
    integer i__1, i__2;
    alist al__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void), f_rew(alist *), s_wsue(cilist *), do_uio(integer *,
	     char *, ftnlen), e_wsue(void);

    /* Local variables */
    integer ndsd, ndsr;
    extern /* Subroutine */ int gnop5_(integer *, integer *, integer *, 
	    integer *, integer *);
    integer lnop5, i, k;

    integer lpgdn;
    extern integer nbrfs_(integer *, integer *);
    integer nef;
    extern integer nbrfsd_(integer *, integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___1206 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1207 = { 0, 6, 0, fmt_2000, 0 };
    /*static*/ cilist io___1208 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1209 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1211 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1212 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1214 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___1215 = { 0, 6, 0, fmt_1000, 0 };



/* calcul des aretes,numerotation,generation de nop5 , */
/* en meme temps calcul de nef,lnop5,lpgon */

    /* Parameter adjustments */
    --m;

    /* Function Body */
    *err = 0;
/*     calcule de ndsd (nb de sous domaine */
    ndsd = nbrfsd_(&m[1], lm);
/*     calcule de ndsr (nb de ref) */
    ndsr = nbrfs_(&m[1], lm);
    lnop5 = *lm;
    gnop5_(&m[1], &lnop5, &nef, &lpgdn, err);
    if (*err != 0) {
	s_wsle(&io___1206);
	do_lio(&c__9, &c__1, "ERREUR ecrnop : la longueur de nop5 est trop g"
		"rand: ", 52L);
	do_lio(&c__3, &c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "<", 1L);
	do_lio(&c__3, &c__1, (char *)&(*lm), (ftnlen)sizeof(integer));
	e_wsle();
	return 0;
    }
    s_wsfe(&io___1207);
    do_fio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&ndsd, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&ndsr, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&nef, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&lpgdn, (ftnlen)sizeof(integer));
    e_wsfe();

/* ecriture sur nfnopo des tableaux de sd nopo */
/* ------------------------------------------- */
/*     descripteur */
/* ---------------------------- */
    al__1.aerr = 0;
    al__1.aunit = *nfnopo;
    f_rew(&al__1);
    io___1208.ciunit = *nfnopo;
    s_wsue(&io___1208);
    do_uio(&c__1, (char *)&c__13, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__6, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__32, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__27, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    i__1 = bdmsh1_1.nbsrft << 1;
    do_uio(&c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__2, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    e_wsue();
/* nop0  lon=32 */
/* ------------- */
    io___1209.ciunit = *nfnopo;
    s_wsue(&io___1209);
    do_uio(&c__1, (char *)&c__32, (ftnlen)sizeof(integer));
    for (i = 1; i <= 10; ++i) {
	do_uio(&c__1, "GEME", 4L);
	do_uio(&c__1, "SH  ", 4L);
    }
    for (i = 1; i <= 8; ++i) {
	do_uio(&c__1, "    ", 4L);
    }
    do_uio(&c__1, "NOPO", 4L);
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    e_wsue();

/* nop1 inexistant (ntcam=0) */
/* nop2 */
    io___1211.ciunit = *nfnopo;
    s_wsue(&io___1211);
    do_uio(&c__1, (char *)&c__27, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__2, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&ndsr, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&ndsd, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    i__1 = bdmsh1_1.nbtria + bdmsh1_1.nbquad;
    do_uio(&c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&bdmsh1_1.nbtria, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&bdmsh1_1.nbquad, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&nef, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&bdmsh1_1.nbsrft, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__2, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&lpgdn, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__0, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
    do_uio(&c__1, (char *)&c__1, (ftnlen)sizeof(integer));
    e_wsue();
/* nop3 inexistant (nbem=0) */
/* nop4 coordonnees simple precision */
    io___1212.ciunit = *nfnopo;
    s_wsue(&io___1212);
    i__1 = bdmsh1_1.nbsrft << 1;
    do_uio(&c__1, (char *)&i__1, (ftnlen)sizeof(integer));
    i__2 = bdmsh1_1.nbsrft;
    for (i = 1; i <= i__2; ++i) {
	for (k = 1; k <= 2; ++k) {
	    do_uio(&c__1, (char *)&bdmsh5_1.cr[k + (bdmsh6_1.nsorig[i - 1] << 
		    1) - 3], (ftnlen)sizeof(real));
	}
    }
    e_wsue();
/* nop5 */
    io___1214.ciunit = *nfnopo;
    s_wsue(&io___1214);
    do_uio(&c__1, (char *)&lnop5, (ftnlen)sizeof(integer));
    i__1 = lnop5;
    for (i = 1; i <= i__1; ++i) {
	do_uio(&c__1, (char *)&m[i], (ftnlen)sizeof(integer));
    }
    e_wsue();

    s_wsfe(&io___1215);
    do_fio(&c__1, (char *)&(*nfnopo), (ftnlen)sizeof(integer));
    e_wsfe();
    return 0;
} /* ecrnop_ */




/* Subroutine */ int emshap_(integer *t, integer *s, real *c, integer *nu, 
	integer *reft, integer *apavue, integer *areadj, integer *tete, 
	integer *nbt, integer *nbs, real *cosmin, real *cosmax, integer *iop, 
	integer *err)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i, t1, t2, t3;
    extern logical emshcv_(real *, integer *, integer *, integer *, real *, 
	    real *);
    extern /* Subroutine */ int mshdwe_(integer *);
    integer ia2, ia3;
    extern /* Subroutine */ int emshot_(real *, integer *, integer *, integer 
	    *, integer *, integer *, integer *, integer *, integer *);
    integer ta2, ta3, tta;

    /* Fortran I/O blocks */
    /*static*/ cilist io___1218 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1224 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1227 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1228 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1229 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1230 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    areadj -= 3;
    --apavue;
    --reft;
    nu -= 7;
    c -= 3;

    /* Function Body */
    *err = -1;
    if (apavue[*t] != 0) {
	if (apavue[*t] != 4) {
	    return 0;
	} else {
	    for (i = 4; i <= 6; ++i) {
		if (! emshcv_(&c[3], &nu[7], &i, t, cosmin, cosmax)) {
		    *err = -2;
		    return 0;
		}
		if (apavue[nu[i + *t * 6] / 8] != 0) {
		    return 0;
		}
/* L10: */
	    }
	}
    }
    *err = 0;
    t1 = *t;
    if (*iop % 10 >= 9) {
	s_wsle(&io___1218);
	do_lio(&c__9, &c__1, " t old", 6L);
	do_lio(&c__3, &c__1, (char *)&(*t), (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t1 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
    }
    if (*tete == 0) {
	++(*nbt);
	t2 = *nbt;
    } else {
	t2 = *tete;
	*tete = reft[*tete];
    }
    if (*tete == 0) {
	++(*nbt);
	t3 = *nbt;
    } else {
	t3 = *tete;
	*tete = reft[*tete];
    }
/*     decoupe du triangle t (s1 s2 s3 ) en trois triangle */

/*                               s3 */
/*                            /\ */
/*                          / |  \ */
/*                        /   |    \ */
/*                      /     |      \ */
/*                    /       |        \ */
/*                  /   t3    |      t2  \ */
/*                /          .x..          \ */
/*              /        .... s  ....        \ */
/*            /      ....            ....      \ */
/*          /    ....        t1          ....    \ */
/*        /  ....                            ....  \ */
/*       -------------------------------------------- */
/*   s1                                              s2 */

    if (apavue[t1] == 4) {
	apavue[t1] = 1;
	apavue[t2] = 2;
	apavue[t3] = 3;
	apavue[nu[*t * 6 + 4] / 8] = nu[*t * 6 + 4] % 8 - 3;
	apavue[nu[*t * 6 + 5] / 8] = nu[*t * 6 + 5] % 8 - 3;
	apavue[nu[*t * 6 + 6] / 8] = nu[*t * 6 + 6] % 8 - 3;
    } else {
	apavue[t1] = 0;
	apavue[t2] = 0;
	apavue[t3] = 0;
    }
/*     chanaige du sous domaine */
    reft[t3] = reft[t1];
    reft[t1] = t2;
    reft[t2] = t3;
    nu[t2 * 6 + 1] = *s;
    nu[t2 * 6 + 2] = nu[*t * 6 + 2];
    nu[t2 * 6 + 3] = nu[*t * 6 + 3];
    nu[t2 * 6 + 4] = (t1 << 3) + 5;
    nu[t2 * 6 + 5] = nu[*t * 6 + 5];
    nu[t2 * 6 + 6] = (t3 << 3) + 5;
    nu[t3 * 6 + 1] = nu[*t * 6 + 1];
    nu[t3 * 6 + 2] = *s;
    nu[t3 * 6 + 3] = nu[*t * 6 + 3];
    nu[t3 * 6 + 4] = (t1 << 3) + 6;
    nu[t3 * 6 + 5] = (t2 << 3) + 6;
    nu[t3 * 6 + 6] = nu[*t * 6 + 6];
    tta = nu[*t * 6 + 5];
    if (tta > 0) {
	ta2 = tta / 8;
	ia2 = tta - (ta2 << 3);
	nu[ia2 + ta2 * 6] = (t2 << 3) + 5;
	if (*iop % 10 >= 9) {
	    s_wsle(&io___1224);
	    do_lio(&c__9, &c__1, " ta2 ", 5L);
	    do_lio(&c__3, &c__1, (char *)&ta2, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&ia2, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 6; ++i) {
		do_lio(&c__3, &c__1, (char *)&nu[i + ta2 * 6], (ftnlen)sizeof(
			integer));
	    }
	    e_wsle();
	}
    } else if (tta < 0) {
	if (areadj[(-tta << 1) + 1] / 8 == t2) {
	    areadj[(-tta << 1) + 1] = (t2 << 3) + 5;
	} else {
	    areadj[(-tta << 1) + 2] = (t2 << 3) + 5;
	}
    }
    tta = nu[*t * 6 + 6];
    if (tta > 0) {
	ta3 = tta / 8;
	ia3 = tta - (ta3 << 3);
	nu[ia3 + ta3 * 6] = (t3 << 3) + 6;
	if (*iop % 10 >= 9) {
	    s_wsle(&io___1227);
	    do_lio(&c__9, &c__1, " ta3 ", 5L);
	    do_lio(&c__3, &c__1, (char *)&ta3, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&ia3, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 6; ++i) {
		do_lio(&c__3, &c__1, (char *)&nu[i + ta3 * 6], (ftnlen)sizeof(
			integer));
	    }
	    e_wsle();
	}
    } else if (tta < 0) {
	if (areadj[(-tta << 1) + 1] / 8 == t3) {
	    areadj[(-tta << 1) + 1] = (t3 << 3) + 5;
	} else {
	    areadj[(-tta << 1) + 2] = (t3 << 3) + 5;
	}
    }
    nu[t1 * 6 + 3] = *s;
    nu[t1 * 6 + 5] = (t2 << 3) + 4;
    nu[t1 * 6 + 6] = (t3 << 3) + 4;
    if (*iop >= 50) {
	mshdwe_(&t1);
    }
    if (*iop >= 50) {
	mshdwe_(&t2);
    }
    if (*iop >= 50) {
	mshdwe_(&t3);
    }
    if (*iop % 10 >= 9) {
	s_wsle(&io___1228);
	do_lio(&c__9, &c__1, " t1 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t1, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t1 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
	s_wsle(&io___1229);
	do_lio(&c__9, &c__1, " t2 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t2, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t2 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
	s_wsle(&io___1230);
	do_lio(&c__9, &c__1, " t3 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t3, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t3 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
    }
    emshot_(&c[3], &nu[7], &apavue[1], &areadj[3], &t1, &c__4, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    emshot_(&c[3], &nu[7], &apavue[1], &areadj[3], &t2, &c__5, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    emshot_(&c[3], &nu[7], &apavue[1], &areadj[3], &t3, &c__6, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    return 0;
} /* emshap_ */

logical emshcv_(real *cr, integer *nsea, integer *a1, integer *t1, real *
	cosmin, real *cosmax)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* System generated locals */
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real long_, test, long1, long2;
    integer i, a2, s0, s1, s2, t2, i11, i12, i13, i21, i22, i23, ss[4];
    real cosinu;
    integer tt1;
    real det1, det2;

/* -----------------------------------------------------------------------
 */
/*     but dit si les quadrangle forme avec l'arete at de t1 est correct 
*/
/* -----------------------------------------------------------------------
 */
    /* Parameter adjustments */
    nsea -= 7;
    cr -= 3;

    /* Function Body */
    ret_val = FALSE_;
    tt1 = nsea[*a1 + *t1 * 6];
    if (tt1 <= 0) {
	return ret_val;
    }
    t2 = tt1 / 8;
    a2 = tt1 - (t2 << 3);
    i11 = *a1 - 3;
    i12 = mod3[i11 - 1];
    i13 = mod3[i12 - 1];
    i21 = a2 - 3;
    i22 = mod3[i21 - 1];
    i23 = mod3[i22 - 1];
    ss[0] = nsea[i13 + *t1 * 6];
    ss[1] = nsea[i11 + *t1 * 6];
    ss[2] = nsea[i23 + t2 * 6];
    ss[3] = nsea[i12 + *t1 * 6];
    det1 = (cr[(ss[1] << 1) + 1] - cr[(ss[0] << 1) + 1]) * (cr[(ss[2] << 1) + 
	    2] - cr[(ss[0] << 1) + 2]) - (cr[(ss[1] << 1) + 2] - cr[(ss[0] << 
	    1) + 2]) * (cr[(ss[2] << 1) + 1] - cr[(ss[0] << 1) + 1]);
    det2 = (cr[(ss[2] << 1) + 1] - cr[(ss[0] << 1) + 1]) * (cr[(ss[3] << 1) + 
	    2] - cr[(ss[0] << 1) + 2]) - (cr[(ss[2] << 1) + 2] - cr[(ss[0] << 
	    1) + 2]) * (cr[(ss[3] << 1) + 1] - cr[(ss[0] << 1) + 1]);
    test = (r__1 = det1 + det2, dabs(r__1)) * .05f;
    if (det1 <= test) {
	return ret_val;
    }
    if (det2 <= test) {
	return ret_val;
    }
    s1 = ss[2];
    s0 = ss[3];
/* Computing 2nd power */
    r__1 = cr[(s1 << 1) + 1] - cr[(s0 << 1) + 1];
/* Computing 2nd power */
    r__2 = cr[(s1 << 1) + 2] - cr[(s0 << 1) + 2];
    long1 = r__1 * r__1 + r__2 * r__2;
    for (i = 1; i <= 4; ++i) {
	s2 = ss[i - 1];
	cosinu = (cr[(s1 << 1) + 1] - cr[(s0 << 1) + 1]) * (cr[(s2 << 1) + 1] 
		- cr[(s0 << 1) + 1]) + (cr[(s1 << 1) + 2] - cr[(s0 << 1) + 2])
		 * (cr[(s2 << 1) + 2] - cr[(s0 << 1) + 2]);
/* Computing 2nd power */
	r__1 = cr[(s2 << 1) + 1] - cr[(s0 << 1) + 1];
/* Computing 2nd power */
	r__2 = cr[(s2 << 1) + 2] - cr[(s0 << 1) + 2];
	long2 = r__1 * r__1 + r__2 * r__2;
	s1 = s0;
	s0 = s2;
/*      attention le cos est une fonction decroissante */
	long_ = sqrt(long1 * long2);
	if (cosinu > *cosmin * long_) {
	    return ret_val;
	}
	if (cosinu < *cosmax * long_) {
	    return ret_val;
	}
	long1 = long2;
/* L10: */
    }
    ret_val = TRUE_;
    return ret_val;
} /* emshcv_ */

/* Subroutine */ int emshdw_(real *c, integer *nu, integer *apavue, integer *
	i6, integer *t, integer *iop)
{
    /* Initialized data */

    /*static*/ integer p3[3] = { 2,3,1 };

    /* System generated locals */
    integer nu_dim1, nu_offset;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_paus(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    integer i;
    real x, y;
    extern /* Subroutine */ int lin2to_(real *, real *), poly2f_(real *, real 
	    *, integer *, integer *, integer *, integer *), mov2to_(real *, 
	    real *);
    real xx[4], yy[4];
    char ch3[3];


/* routine de trace d un triangle */
/* ------------------------------- */
    /* Parameter adjustments */
    --apavue;
    nu_dim1 = *i6;
    nu_offset = nu_dim1 + 1;
    nu -= nu_offset;
    c -= 3;

    /* Function Body */
    for (i = 1; i <= 3; ++i) {
	xx[i - 1] = c[(nu[i + *t * nu_dim1] << 1) + 1];
	yy[i - 1] = c[(nu[i + *t * nu_dim1] << 1) + 2];
/* L10: */
    }
    poly2f_(xx, yy, &c__3, &ctabco_1.fond, &ctabco_1.pafond, &c__2);
    if (apavue[*t] >= 1 && apavue[*t] <= 3) {
	ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	mov2to_(&xx[p3[apavue[*t] - 1] - 1], &yy[p3[apavue[*t] - 1] - 1]);
	lin2to_(&xx[apavue[*t] - 1], &yy[apavue[*t] - 1]);
	ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
    }
    if (*iop >= 90) {
	x = (xx[0] + xx[1] + xx[2]) / 3;
	y = (yy[0] + yy[1] + yy[2]) / 3;
	ligh3_(&c_n1, &c_n1, &ctabco_1.rouges);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 3;
	ici__1.iciunit = ch3;
	ici__1.icifmt = "(i3)";
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&(*t), (ftnlen)sizeof(integer));
	e_wsfi();
	txt2d_(ch3, &c__3, &x, &y, 3L);
    }
    if (*iop >= 100) {
	s_paus("", 0L);
    }
    return 0;
} /* emshdw_ */

#undef coulls


logical emshge_(integer *t1)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1;
    real r__1, r__2;
    logical ret_val;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real long_, test, long1, long2;
    integer i;

    integer a1, s1, s0, s2, t2, a2, i11, i12, i13, i21, i22, i23;
    real cosinu, cosmin, cosmax;
    integer ss[4], tt1, nse;
    real det1, det2;

/* -----------------------------------------------------------------------
 */
/*     but dit si l'element t1 est correct */
/* -----------------------------------------------------------------------
 */
    ret_val = FALSE_;
    if (bdmshb_1.apavue[*t1 - 1] == 0) {
	ss[0] = bdmsh9_1.nsea[*t1 * 6 - 6];
	ss[1] = bdmsh9_1.nsea[*t1 * 6 - 5];
	ss[2] = bdmsh9_1.nsea[*t1 * 6 - 4];
	det1 = (bdmsh5_1.cr[(ss[1] << 1) - 2] - bdmsh5_1.cr[(ss[0] << 1) - 2])
		 * (bdmsh5_1.cr[(ss[2] << 1) - 1] - bdmsh5_1.cr[(ss[0] << 1) 
		- 1]) - (bdmsh5_1.cr[(ss[1] << 1) - 1] - bdmsh5_1.cr[(ss[0] <<
		 1) - 1]) * (bdmsh5_1.cr[(ss[2] << 1) - 2] - bdmsh5_1.cr[(ss[
		0] << 1) - 2]);
	if (det1 <= 0.f) {
	    return ret_val;
	}
	nse = 3;
	cosmin = etat_1.cosmnt;
	cosmax = etat_1.cosmxt;
    } else {
	a1 = bdmshb_1.apavue[*t1 - 1] + 3;
	tt1 = bdmsh9_1.nsea[a1 + *t1 * 6 - 7];
	if (tt1 <= 0) {
	    return ret_val;
	}
	t2 = tt1 / 8;
	a2 = tt1 - (t2 << 3);
	i11 = a1 - 3;
	i12 = mod3[i11 - 1];
	i13 = mod3[i12 - 1];
	i21 = a2 - 3;
	i22 = mod3[i21 - 1];
	i23 = mod3[i22 - 1];
	ss[0] = bdmsh9_1.nsea[i13 + *t1 * 6 - 7];
	ss[1] = bdmsh9_1.nsea[i11 + *t1 * 6 - 7];
	ss[2] = bdmsh9_1.nsea[i23 + t2 * 6 - 7];
	ss[3] = bdmsh9_1.nsea[i12 + *t1 * 6 - 7];
	det1 = (bdmsh5_1.cr[(ss[1] << 1) - 2] - bdmsh5_1.cr[(ss[0] << 1) - 2])
		 * (bdmsh5_1.cr[(ss[2] << 1) - 1] - bdmsh5_1.cr[(ss[0] << 1) 
		- 1]) - (bdmsh5_1.cr[(ss[1] << 1) - 1] - bdmsh5_1.cr[(ss[0] <<
		 1) - 1]) * (bdmsh5_1.cr[(ss[2] << 1) - 2] - bdmsh5_1.cr[(ss[
		0] << 1) - 2]);
	det2 = (bdmsh5_1.cr[(ss[2] << 1) - 2] - bdmsh5_1.cr[(ss[0] << 1) - 2])
		 * (bdmsh5_1.cr[(ss[3] << 1) - 1] - bdmsh5_1.cr[(ss[0] << 1) 
		- 1]) - (bdmsh5_1.cr[(ss[2] << 1) - 1] - bdmsh5_1.cr[(ss[0] <<
		 1) - 1]) * (bdmsh5_1.cr[(ss[3] << 1) - 2] - bdmsh5_1.cr[(ss[
		0] << 1) - 2]);
	test = (dabs(det1) + dabs(det2)) * .05f;
	if (det1 <= test) {
	    return ret_val;
	}
	if (det2 <= test) {
	    return ret_val;
	}
	det1 = (bdmsh5_1.cr[(ss[1] << 1) - 2] - bdmsh5_1.cr[(ss[0] << 1) - 2])
		 * (bdmsh5_1.cr[(ss[3] << 1) - 1] - bdmsh5_1.cr[(ss[0] << 1) 
		- 1]) - (bdmsh5_1.cr[(ss[1] << 1) - 1] - bdmsh5_1.cr[(ss[0] <<
		 1) - 1]) * (bdmsh5_1.cr[(ss[3] << 1) - 2] - bdmsh5_1.cr[(ss[
		0] << 1) - 2]);
	if (det1 <= test) {
	    return ret_val;
	}
	det2 = (bdmsh5_1.cr[(ss[2] << 1) - 2] - bdmsh5_1.cr[(ss[1] << 1) - 2])
		 * (bdmsh5_1.cr[(ss[3] << 1) - 1] - bdmsh5_1.cr[(ss[1] << 1) 
		- 1]) - (bdmsh5_1.cr[(ss[2] << 1) - 1] - bdmsh5_1.cr[(ss[1] <<
		 1) - 1]) * (bdmsh5_1.cr[(ss[3] << 1) - 2] - bdmsh5_1.cr[(ss[
		1] << 1) - 2]);
	if (det2 <= test) {
	    return ret_val;
	}
	nse = 4;
	cosmin = etat_1.cosmnq;
	cosmax = etat_1.cosmxq;
    }
    s1 = ss[nse - 2];
    s0 = ss[nse - 1];
/* Computing 2nd power */
    r__1 = bdmsh5_1.cr[(s1 << 1) - 2] - bdmsh5_1.cr[(s0 << 1) - 2];
/* Computing 2nd power */
    r__2 = bdmsh5_1.cr[(s1 << 1) - 1] - bdmsh5_1.cr[(s0 << 1) - 1];
    long1 = r__1 * r__1 + r__2 * r__2;
    i__1 = nse;
    for (i = 1; i <= i__1; ++i) {
	s2 = ss[i - 1];
	cosinu = (bdmsh5_1.cr[(s1 << 1) - 2] - bdmsh5_1.cr[(s0 << 1) - 2]) * (
		bdmsh5_1.cr[(s2 << 1) - 2] - bdmsh5_1.cr[(s0 << 1) - 2]) + (
		bdmsh5_1.cr[(s1 << 1) - 1] - bdmsh5_1.cr[(s0 << 1) - 1]) * (
		bdmsh5_1.cr[(s2 << 1) - 1] - bdmsh5_1.cr[(s0 << 1) - 1]);
/* Computing 2nd power */
	r__1 = bdmsh5_1.cr[(s2 << 1) - 2] - bdmsh5_1.cr[(s0 << 1) - 2];
/* Computing 2nd power */
	r__2 = bdmsh5_1.cr[(s2 << 1) - 1] - bdmsh5_1.cr[(s0 << 1) - 1];
	long2 = r__1 * r__1 + r__2 * r__2;
	s1 = s0;
	s0 = s2;
/*      attention le cos est une fonction decroissante */
	long_ = sqrt(long1 * long2);
	if (cosinu > cosmin * long_) {
	    return ret_val;
	}
	if (cosinu < cosmax * long_) {
	    return ret_val;
	}
	long1 = long2;
/* L10: */
    }
    ret_val = TRUE_;
    return ret_val;
} /* emshge_ */




/* Subroutine */ int emshot_(real *c, integer *nu, integer *apavue, integer *
	areadj, integer *t, integer *a, integer *nbs, integer *iop, integer *
	err)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer pile[512]	/* was [2][256] */, i, a1, a2, s1, t1, t2, s2, s3, s4,
	     aa, i11, i12, i13, i21, i22, i23, tt;
    extern /* Subroutine */ int emshdw_(real *, integer *, integer *, integer 
	    *, integer *, integer *);
    integer tt1;
    doublereal cos1, cos2, sin1, sin2;

    /* Fortran I/O blocks */
    /*static*/ cilist io___1310 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1315 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    areadj -= 3;
    --apavue;
    nu -= 7;
    c -= 3;

    /* Function Body */
    *err = 0;
    i = 1;
    pile[(i << 1) - 2] = *t;
    pile[(i << 1) - 1] = *a;
L10:
    if (i > 0) {
	t1 = pile[(i << 1) - 2];
	a1 = pile[(i << 1) - 1];
	--i;
	if (t1 <= 0) {
	    goto L10;
	}
/*  ---   on optimise si tout les arete sont vue */
	if (apavue[t1] != 0) {
	    goto L10;
	}
	tt1 = nu[a1 + t1 * 6];
	if (tt1 <= 0) {
	    goto L10;
	}
	t2 = tt1 / 8;
	a2 = tt1 - (t2 << 3);
/*        print *,' emshot :t1,a1,t2,a2 =',t,a,nu(a,t)/8,mod(nu(a,t),8
) */
/*     &         ,' niveau = ',i */
	i11 = a1 - 3;
	i12 = mod3[i11 - 1];
	i13 = mod3[i12 - 1];
	i21 = a2 - 3;
	i22 = mod3[i21 - 1];
	i23 = mod3[i22 - 1];
	s1 = nu[i13 + t1 * 6];
	s2 = nu[i11 + t1 * 6];
	s3 = nu[i12 + t1 * 6];
	s4 = nu[i23 + t2 * 6];
/*        print *,i11,i12,i13,nu(i11,t1),nu(i12,t1),nu(i13,t1) */
/*        print *,i21,i22,i23,nu(i21,t2),nu(i22,t2),nu(i23,t2) */
/*        print *,s1,s2,s3,s4 */
/*              critere d optimisation du quadrilatere */
/* ---------------------------------------------------- */
	sin1 = (doublereal) (c[(s3 << 1) + 2] - c[(s1 << 1) + 2]) * (
		doublereal) (c[(s2 << 1) + 1] - c[(s1 << 1) + 1]) - (
		doublereal) (c[(s3 << 1) + 1] - c[(s1 << 1) + 1]) * (
		doublereal) (c[(s2 << 1) + 2] - c[(s1 << 1) + 2]);
	cos1 = (doublereal) (c[(s3 << 1) + 1] - c[(s1 << 1) + 1]) * (
		doublereal) (c[(s3 << 1) + 1] - c[(s2 << 1) + 1]) + (
		doublereal) (c[(s3 << 1) + 2] - c[(s1 << 1) + 2]) * (
		doublereal) (c[(s3 << 1) + 2] - c[(s2 << 1) + 2]);
	if (sin1 == 0. && cos1 == 0.) {
	    s_wsle(&io___1310);
	    do_lio(&c__9, &c__1, "fatal ERROR emshot:", 19L);
	    do_lio(&c__9, &c__1, "3 points confondus ", 19L);
	    do_lio(&c__3, &c__1, (char *)&s1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&s2, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&s3, (ftnlen)sizeof(integer));
	    e_wsle();
	    *err = 20;
	    return 0;
	}
/*       b est la cotangente de angle (s1,s3,s2) */
	sin2 = (doublereal) (c[(s4 << 1) + 1] - c[(s1 << 1) + 1]) * (
		doublereal) (c[(s2 << 1) + 2] - c[(s1 << 1) + 2]) - (
		doublereal) (c[(s4 << 1) + 2] - c[(s1 << 1) + 2]) * (
		doublereal) (c[(s2 << 1) + 1] - c[(s1 << 1) + 1]);
	cos2 = (doublereal) (c[(s4 << 1) + 1] - c[(s2 << 1) + 1]) * (
		doublereal) (c[(s4 << 1) + 1] - c[(s1 << 1) + 1]) + (
		doublereal) (c[(s4 << 1) + 2] - c[(s2 << 1) + 2]) * (
		doublereal) (c[(s4 << 1) + 2] - c[(s1 << 1) + 2]);
	if ((cos2 * sin1 + cos1 * sin2) * sin1 >= 0.) {
	    goto L10;
	}
/*       on inverse le quadrilatere */
/*       update des sommets */
/* ------------------------- */
	nu[i12 + t1 * 6] = s4;
	nu[i22 + t2 * 6] = s1;
/*       update des aretes a1,a2 */
/* ------------------------------- */
	tt1 = nu[i22 + 3 + t2 * 6];
	nu[a1 + t1 * 6] = tt1;
	if (tt1 > 0) {
	    tt = tt1 / 8;
	    aa = tt1 - (tt << 3);
	    nu[aa + tt * 6] = a1 + (t1 << 3);
	} else if (tt1 < 0) {
	    if (areadj[(-tt1 << 1) + 1] / 8 == t2) {
		areadj[(-tt1 << 1) + 1] = a1 + (t1 << 3);
	    } else {
		areadj[(-tt1 << 1) + 2] = a1 + (t1 << 3);
	    }
	}
	tt1 = nu[i12 + 3 + t1 * 6];
	nu[a2 + t2 * 6] = tt1;
	if (tt1 > 0) {
	    tt = tt1 / 8;
	    aa = tt1 - (tt << 3);
	    nu[aa + tt * 6] = a2 + (t2 << 3);
	} else if (tt1 < 0) {
	    if (areadj[(-tt1 << 1) + 1] / 8 == t1) {
		areadj[(-tt1 << 1) + 1] = a2 + (t2 << 3);
	    } else {
		areadj[(-tt1 << 1) + 2] = a2 + (t2 << 3);
	    }
	}
	nu[i12 + 3 + t1 * 6] = i22 + 3 + (t2 << 3);
	nu[i22 + 3 + t2 * 6] = i12 + 3 + (t1 << 3);
	if (i + 4 > 256) {
	    s_wsle(&io___1315);
	    do_lio(&c__9, &c__1, " fatal ERROR emshot la pile est trop petit"
		    "e ", 44L);
	    do_lio(&c__3, &c__1, (char *)&c__256, (ftnlen)sizeof(integer));
	    e_wsle();
	    *err = 21;
	    return 0;
	}
	if (*iop >= 50) {
	    emshdw_(&c[3], &nu[7], &apavue[1], &c__6, &t1, iop);
	}
	if (*iop >= 50) {
	    emshdw_(&c[3], &nu[7], &apavue[1], &c__6, &t2, iop);
	}
	++i;
	pile[(i << 1) - 2] = t1;
	pile[(i << 1) - 1] = a1;
	++i;
	pile[(i << 1) - 2] = t2;
	pile[(i << 1) - 1] = a2;
	++i;
	pile[(i << 1) - 2] = t1;
	pile[(i << 1) - 1] = i13 + 3;
	++i;
	pile[(i << 1) - 2] = t2;
	pile[(i << 1) - 1] = i23 + 3;
	goto L10;
    }
    return 0;
} /* emshot_ */

/* Subroutine */ int emshqa_(integer *are, integer *t, integer *opt, integer *
	err)
{
    /* Local variables */
    integer i;

    integer ie;
    extern logical emshcv_(real *, integer *, integer *, integer *, real *, 
	    real *);
    extern /* Subroutine */ int mshdwe_(integer *), scrtch_(char *, ftnlen), 
	    emshap_(integer *, integer *, real *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, real *, 
	    real *, integer *, integer *);

/* -----------------------------------------------------------------------
 */
/*   but : quadrangulariser un 2 triangles adjacent par l'arete are,t */
/*      si are est un arete */
/*      sinon les 3 triangles adjacents  a t et t (are = 0) */
/* -----------------------------------------------------------------------
 */
    if (bdmshb_1.apavue[*t - 1] == 0) {
	if (*are >= 4 && *are <= 6) {
	    if (emshcv_(bdmsh5_1.cr, bdmsh9_1.nsea, are, t, &etat_1.cosmnq, &
		    etat_1.cosmxq)) {
		i = bdmsh9_1.nsea[*are + *t * 6 - 7];
		ie = i / 8;
		if (bdmshb_1.apavue[ie - 1] == 0) {
		    i -= ie << 3;
		    bdmshb_1.apavue[ie - 1] = i - 3;
		    bdmshb_1.apavue[*t - 1] = *are - 3;
		    bdmsh1_1.nbtria += -2;
		    ++bdmsh1_1.nbquad;
		    if (*opt >= 50) {
			mshdwe_(t);
		    }
		    if (*opt >= 50) {
			mshdwe_(&ie);
		    }
		} else {
		    scrtch_("on ne peut quadranguler que des triangles adjac"
			    "ent", 50L);
		    *err = 3;
		}
	    } else {
		if (bdmsh9_1.nsea[*are + *t * 6 - 7] < 0) {
		    *err = 4;
		    scrtch_("on ne quadrangule pas (arete frontiere)", 39L);
		} else {
		    *err = 5;
		    scrtch_("on ne quadrangule pas (limites angulaires)", 42L)
			    ;
		}
	    }
	} else {
/*          on ajoute un point au milieux du triangle */
	    if (etat_1.cosmxq > -.5f) {
		scrtch_("on ne peut quadrangulariser ces 4 triangles (1 angl"
			"e = 120 degres)", 66L);
		*err = 2;
		return 0;
	    }
	    ++bdmsh1_1.nbs;
	    if (bdmsh1_1.nbs >= bdmsh0_1.nbpmx) {
		scrtch_("appli3.emshqa:trop de sommets generes", 37L);
		*err = 2;
		return 0;
	    }
	    bdmsh5_1.cr[(bdmsh1_1.nbs << 1) - 2] = (bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 6] << 1) - 2] + bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 5] << 1) - 2] + bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 4] << 1) - 2]) / 3.f;
	    bdmsh5_1.cr[(bdmsh1_1.nbs << 1) - 1] = (bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 6] << 1) - 1] + bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 5] << 1) - 1] + bdmsh5_1.cr[(
		    bdmsh9_1.nsea[*t * 6 - 4] << 1) - 1]) / 3.f;
	    bdmsh8_1.refs[bdmsh1_1.nbs - 1] = 0;
	    bdmsh7_1.abcurv[bdmsh1_1.nbs - 1] = 0.f;
	    bdmsh6_1.nsorig[bdmsh1_1.nbs - 1] = bdmsh1_1.nbs;
/*         print *,' add point x,y',x,y,' t ',t,nbs,freetr,nbt */
	    bdmshb_1.apavue[*t - 1] = 4;
	    emshap_(t, &bdmsh1_1.nbs, bdmsh5_1.cr, bdmsh9_1.nsea, 
		    bdmsha_1.reft, bdmshb_1.apavue, bdmshd_1.areadj, &
		    bdmsh3_1.freetr, &bdmsh1_1.nbt, &bdmsh1_1.nbs, &
		    etat_1.cosmnq, &etat_1.cosmxq, opt, err);
	    if (*err == -1) {
		--bdmsh1_1.nbs;
		scrtch_("on ne peut quadrangulariser ces 4 triangles", 43L);
		bdmshb_1.apavue[*t - 1] = 0;
	    } else if (*err == -2) {
		--bdmsh1_1.nbs;
		scrtch_("on ne peut quadrangulariser ces 4 triangles (pb ang"
			"le)", 54L);
		bdmshb_1.apavue[*t - 1] = 0;
	    } else {
		bdmsh1_1.nbtria += -4;
		bdmsh1_1.nbquad += 3;
	    }
	}
    } else {
	scrtch_("on ne peut quadranguler que des triangles origine", 49L);
	*err = 1;
    }
    return 0;
} /* emshqa_ */




/* Subroutine */ int emshqq_(integer *t, integer *opt, integer *err)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, j, k;

    integer count, aa;
    extern /* Subroutine */ int lin2to_(real *, real *);
    integer ta;
    extern /* Subroutine */ int mov2to_(real *, real *);
    integer tt, cas;
    real xx, yy;
    extern logical emshcv_(real *, integer *, integer *, integer *, real *, 
	    real *);
    extern /* Subroutine */ int emshtr_(integer *, integer *), emshqa_(
	    integer *, integer *, integer *, integer *);

    if (*t >= 0 && *t <= bdmsh1_1.nbt) {
/*       le tableau work sert de marque de 1 a nbt et de pile apres nb
t+1 */
	tt = *t;
	i__1 = bdmsh1_1.nbt;
	for (i = 1; i <= i__1; ++i) {
	    bdwrk1_1.work[i - 1] = 0;
/* L10: */
	}
	cas = 2;
	if (*t == 0) {
	    goto L100;
	}
L15:
	i = bdmsh0_1.nbtmx + 3;
	bdwrk1_1.work[i - 3] = 0;
	bdwrk1_1.work[i - 2] = tt;
	bdwrk1_1.work[i - 1] = 6;
	emshtr_(&tt, opt);
	bdwrk1_1.work[tt - 1] = -1;
L20:
/* ----  ------------------------------- */
/*      en w(i) => numero de l'arete courante */
/*      en w(i-1) => numero du triangle courant */
/*      en w(i-2) = compteur */
/* ----  ------------------------------- */
	if (i > bdmsh0_1.nbtmx) {
	    ++bdwrk1_1.work[i - 3];
	    if (bdwrk1_1.work[i - 3] <= 3) {
		++bdwrk1_1.work[i - 1];
		if (bdwrk1_1.work[i - 1] == 7) {
		    bdwrk1_1.work[i - 1] = 4;
		}
		if (emshcv_(bdmsh5_1.cr, bdmsh9_1.nsea, &bdwrk1_1.work[i - 1],
			 &bdwrk1_1.work[i - 2], &etat_1.cosmnq, &
			etat_1.cosmxq)) {
		    ta = bdmsh9_1.nsea[bdwrk1_1.work[i - 1] + bdwrk1_1.work[i 
			    - 2] * 6 - 7] / 8;
		    if (bdwrk1_1.work[ta - 1] == 0) {
/* ----  ---------  empile ------------ */
/*            -- on marque avec le pere -- */
			aa = bdmsh9_1.nsea[bdwrk1_1.work[i - 1] + 
				bdwrk1_1.work[i - 2] * 6 - 7] - (ta << 3);
			bdwrk1_1.work[ta - 1] = bdwrk1_1.work[i - 2];
			emshtr_(&ta, opt);
			xx = (bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 - 6] << 1) - 
				2] + bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 - 5] <<
				 1) - 2] + bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 
				- 4] << 1) - 2]) / 3;
			yy = (bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 - 6] << 1) - 
				1] + bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 - 5] <<
				 1) - 1] + bdmsh5_1.cr[(bdmsh9_1.nsea[ta * 6 
				- 4] << 1) - 1]) / 3;
			mov2to_(&xx, &yy);
			tt = bdwrk1_1.work[i - 2];
			xx = (bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 - 6] << 1) - 
				2] + bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 - 5] <<
				 1) - 2] + bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 
				- 4] << 1) - 2]) / 3;
			yy = (bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 - 6] << 1) - 
				1] + bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 - 5] <<
				 1) - 1] + bdmsh5_1.cr[(bdmsh9_1.nsea[tt * 6 
				- 4] << 1) - 1]) / 3;
			lin2to_(&xx, &yy);
			i += 3;
			bdwrk1_1.work[i - 3] = 0;
			bdwrk1_1.work[i - 2] = ta;
			bdwrk1_1.work[i - 1] = aa;
/* ----  --------- fin empile -------- */
		    }
		}
	    } else {
/* ----  -----  depile  ---------------------- */
		tt = bdwrk1_1.work[i - 2];
		count = 0;
		for (j = 4; j <= 6; ++j) {
		    ta = bdmsh9_1.nsea[j + tt * 6 - 7];
		    if (ta > 0) {
			ta /= 8;
			if (bdwrk1_1.work[ta - 1] == tt && bdmshb_1.apavue[ta 
				- 1] == 0) {
/*                 on compte les fils triangles */
			    ++count;
			    k = j;
			}
		    }
/* L30: */
		}
		if (count == 1) {
		    emshqa_(&k, &tt, opt, err);
		} else if (count == 2) {
		    if (i - 3 > bdmsh0_1.nbtmx) {
			emshqa_(&c__0, &tt, opt, err);
/*              on marque les 2 triangles generes reft
(tt) et reft(reft(t */
			if (*err == 0) {
			    bdwrk1_1.work[bdmsha_1.reft[tt - 1] - 1] = 
				    bdwrk1_1.work[tt - 1];
			    bdwrk1_1.work[bdmsha_1.reft[bdmsha_1.reft[tt - 1] 
				    - 1] - 1] = bdwrk1_1.work[tt - 1];
			    emshtr_(&bdwrk1_1.work[i - 5], opt);
			} else {
/*            xx = (cr(1,nsea(1,tt))+cr(1,nsea(2,t
t))+cr(1,nsea(3,tt)))/3 */
/*            yy = (cr(2,nsea(1,tt))+cr(2,nsea(2,t
t))+cr(2,nsea(3,tt)))/3 */
/*                 call txt2d ('0',1,xx,yy) */
/*                 pause 'decoupe en 3 quadrangles
' */
			}
		    } else {
			emshqa_(&k, &tt, opt, err);
			if (*err != 0) {
/*            xx = (cr(1,nsea(1,tt))+cr(1,nsea(2,t
t))+cr(1,nsea(3,tt)))/3 */
/*            yy = (cr(2,nsea(1,tt))+cr(2,nsea(2,t
t))+cr(2,nsea(3,tt)))/3 */
/*                 call txt2d ('0',1,xx,yy) */
/*                 pause 'decoupe en 1 quadrangle'
 */
			}
		    }
/*            else */
/*               print *,'tt=',tt,', count =',count */
		}
		i += -3;
/* ---------  fin  depile ------------------------------ */
	    }
	    goto L20;
	}
L100:
	if (*t == 0) {
/*        recherche d'une autre racine */
/*        on commence par recherche */
/*             les traingle avec 2 aretes frontieres    (cas 2) */
/*        puis   les triangles avec 1 aretes frontieres (cas 1) */
/*        puis   les triangles avec 0 aretes frontieres (cas 0) */
	    i__1 = bdmsh1_1.nbt;
	    for (i = 1; i <= i__1; ++i) {
		if (bdwrk1_1.work[i - 1] == 0 && bdmsh9_1.nsea[i * 6 - 6] > 0)
			 {
		    if (cas != 0) {
			k = 0;
			for (j = 4; j <= 6; ++j) {
			    if (bdmsh9_1.nsea[j + i * 6 - 7] <= 0) {
				++k;
			    }
/* L110: */
			}
			if (cas != k) {
			    goto L120;
			}
		    }
		    tt = i;
		    goto L15;
		}
L120:
		;
	    }
	    --cas;
	    if (cas >= 0) {
		goto L100;
	    }
	}
    }
    return 0;
} /* emshqq_ */




/* Subroutine */ int emshr1_(integer *iop, integer *jsom, integer *jtri)
{

    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer ntri;
    extern /* Subroutine */ int txt2d_(char *, integer *, real *, real *, 
	    ftnlen);
    integer i, j, k;

    integer s4[4];
    extern /* Subroutine */ int drw3tx_(real *, real *, integer *);
    integer ra4[4], nse;
    extern integer mshele_(integer *, integer *, integer *);
    integer lsttri[100], lstvoi[100], nbvois;
    extern logical emshge_(integer *);
    extern doublereal acurxy_(integer *, real *, real *, real *, real *);
    real xx1, yy1, xxx, aa1;
    extern /* Subroutine */ int lstrgl_(integer *, integer *, integer *, 
	    integer *, integer *);
    real yyy;
    extern /* Subroutine */ int mshdwe_(integer *), scrtch_(char *, ftnlen);

    /* Fortran I/O blocks */
    /*static*/ cilist io___1350 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___1354 = { 0, 6, 0, 0, 0 };


/*     si bgptf = .true. => ou peut bouger les points frontieres */
    if (! etat_1.bgptf && bdmsh8_1.refs[*jsom - 1] != 0) {
	return 0;
    }
/*     ++++++++++++++++++++++++++++++++++++++++++++++ */
    lstrgl_(lsttri, &c__100, &ntri, jsom, jtri);
    if (ntri == 0) {
	return 0;
    }
    xx1 = bdmsh5_1.cr[(*jsom << 1) - 2];
    yy1 = bdmsh5_1.cr[(*jsom << 1) - 1];
    aa1 = bdmsh7_1.abcurv[*jsom - 1];
    xxx = 0.f;
    yyy = 0.f;
    nbvois = 0;
    i__1 = ntri;
    for (i = 1; i <= i__1; ++i) {
	i__2 = -lsttri[i - 1];
	nse = mshele_(&i__2, s4, ra4);
	if (nse != 3 && nse != 4) {
	    s_wsle(&io___1350);
	    do_lio(&c__9, &c__1, "emshr1: nse,s4=", 15L);
	    do_lio(&c__3, &c__1, (char *)&nse, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__4, (char *)&s4[0], (ftnlen)sizeof(integer));
	    e_wsle();
	}
	i__2 = nse;
	for (j = 1; j <= i__2; ++j) {
	    if (s4[j - 1] != *jsom) {
		i__3 = nbvois;
		for (k = 1; k <= i__3; ++k) {
		    if (lstvoi[k - 1] == s4[j - 1]) {
			goto L20;
		    }
/* L10: */
		}
		if (nbvois >= 100) {
		    goto L1000;
		}
		++nbvois;
		lstvoi[nbvois - 1] = s4[j - 1];
		xxx += bdmsh5_1.cr[(s4[j - 1] << 1) - 2];
		yyy += bdmsh5_1.cr[(s4[j - 1] << 1) - 1];
	    }
L20:
	    ;
	}
/* L30: */
    }
    xxx /= nbvois;
    yyy /= nbvois;
    if ((real) nbvois <= 0.f) {
	s_wsle(&io___1354);
	do_lio(&c__9, &c__1, "emshr1: ERREUR nbvois = 0", 25L);
	e_wsle();
    } else {
	if (bdmsh8_1.refs[*jsom - 1] == 0) {
	    bdmsh5_1.cr[(*jsom << 1) - 2] = xxx;
	    bdmsh5_1.cr[(*jsom << 1) - 1] = yyy;
	} else {
	    bdmsh7_1.abcurv[*jsom - 1] = acurxy_(&bdmsh8_1.refs[*jsom - 1], &
		    xxx, &yyy, &bdmsh5_1.cr[(*jsom << 1) - 2], &bdmsh5_1.cr[(*
		    jsom << 1) - 1]);
	    if (bdmsh7_1.abcurv[*jsom - 1] <= 0.f || bdmsh7_1.abcurv[*jsom - 
		    1] >= 1.f) {
		bdmsh5_1.cr[(*jsom << 1) - 2] = xx1;
		bdmsh5_1.cr[(*jsom << 1) - 1] = yy1;
		bdmsh7_1.abcurv[*jsom - 1] = aa1;
		return 0;
	    }
	}
	i__1 = ntri;
	for (i = 1; i <= i__1; ++i) {
	    if (! emshge_(&lsttri[i - 1])) {
/*            print *,' on ne regularise pas car on genere ' 
*/
/*     +             ,' des elements mauvais nbvois =',nbvois 
*/
		bdmsh5_1.cr[(*jsom << 1) - 2] = xx1;
		bdmsh5_1.cr[(*jsom << 1) - 1] = yy1;
		bdmsh7_1.abcurv[*jsom - 1] = aa1;
		drw3tx_(&c_b3236, &c_b609, &c__0);
		txt2d_("0", &c__1, &xx1, &yy1, 1L);
		r__1 = xxx / nbvois;
		r__2 = yyy / nbvois;
		txt2d_("O", &c__1, &r__1, &r__2, 1L);
		return 0;
	    }
/* L40: */
	}
	if (*iop != 0) {
	    i__1 = ntri;
	    for (i = 1; i <= i__1; ++i) {
		mshdwe_(&lsttri[i - 1]);
/* L50: */
	    }
	}
    }
    return 0;
L1000:
    scrtch_("ERREUR emshr1:trops de sommets voisin d'un autre sommet", 55L);
    txt2d_("0", &c__1, &xx1, &yy1, 1L);
    return 0;
} /* emshr1_ */



