#include "emc2_h.h"



/* Subroutine */ int genspl_(real *x, real *y, integer *nn, real *eps, real *
	densit, real *xgen, real *ygen, integer *maxgen, integer *nbgen, 
	integer *tgen)
{
    /* Initialized data */

    static real m[16]	/* was [4][4] */ = { 2.f,-2.f,1.f,1.f,-3.f,3.f,-2.f,
	    -1.f,0.f,0.f,1.f,0.f,1.f,0.f,0.f,0.f };

    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3, r__4, r__5;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real scal, step, a, c[3], d;
    integer i, j, k, l, n;
    real *p=0	/* was [501][2] */, t, w[12]	/* was [4][3] */, dd;
    integer nd;
    real tg[6]	/* was [2][3] */;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    real normal[3], ddd;

    /* Fortran I/O blocks */
    static cilist io___1878 = { 0, 6, 0, 0, 0 };


/* =======================================================================
 */

/* but : approximer les points ( x(i),y(i) ) de r2 par une courbe */
/* ----  et la generer dans xgen,ygen */

/* parametres d'entree : x      : tableau des abcisses */
/* --------------------- y      : tableau des ordonnees */
/*                       nn     : nombre de points a tracer */
/*                       eps    : les reels egaux a eps pres sont pris eg 
*/
/*                       densit : densite lineique de points de tracer */

/* parametres de sortie : densit : si densit est < 0 densit est rendu pos 
*/
/*                        xgen,ygen,nbgen */
/*                        tgen: tableau de pointeurs sur xgen,ygen, indiq 
*/
/*                              ou sont les points de definition */


/* auteur :     saltel eric modulef 29/9/86 */
/* -------- */



/*           nombre maxi de points de definition pour une spline */
    /* Parameter adjustments */
    if(! (p = (real*)malloc(sizeof(real)*1002))) goto LA999;
    --tgen;
    --ygen;
    --xgen;
    /* Function Body */
    n = *nn;
    if (n >= 500) {
/*       ERREURE */
	scrtch_("ERREUR:GENSPL: SPLINE AVEC TROP DE POINTS. ON TRONQUE", 53L);
	n = 499;
    }
    i__1 = n;
    for (i = 1; i <= i__1; ++i) {
	p[i] = x[i];
	p[i + 501] = y[i];
/* L87655: */
    }
    if (*nbgen < 0) {
	*nbgen = *maxgen;
    }
    step = .1f;
    *nbgen = 0;
/*     teste si courbe fermee */
/* Computing 2nd power */
    r__1 = p[1] - p[n];
/* Computing 2nd power */
    r__2 = p[502] - p[n + 501];
    if (sqrt(r__1 * r__1 + r__2 * r__2) <= *eps) {
/*       courbe fermee, on rajoute en 0 le point n-1 */
/*       courbe fermee, on rajoute en n+1 le point 2 */
	for (i = 1; i <= 2; ++i) {
	    p[i * 501 - 501] = p[n - 1 + i * 501 - 501];
	    p[n + 1 + i * 501 - 501] = p[i * 501 - 499];
/* L87656: */
	}
    } else {
	if (n == 2) {
	    for (i = 1; i <= 2; ++i) {
/*           on rajoute un point p(0) virtuel symetrique de p(
2) */
/*                           / point p(1) */
		p[i * 501 - 501] = p[i * 501 - 500] * 2.f - p[i * 501 - 499];
/*           on rajoute un point  p(n+1) virtuel symetrique de
 p(n-1) */
/*                           / point p(n) */
		p[n + 1 + i * 501 - 501] = p[n + i * 501 - 501] * 2.f - p[n - 
			1 + i * 501 - 501];
/* L87657: */
	    }
	} else {
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(1),p(2) */
/* Computing 2nd power */
		r__1 = p[i * 501 - 499] - p[i * 501 - 500];
		dd += r__1 * r__1;
/* L87658: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(1),p(2) */
		normal[i - 1] = (p[i * 501 - 499] - p[i * 501 - 500]) / dd;
/* L87659: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[i * 501 - 500] + p[i * 501 - 499]) * 
			.5f;
/*           produit scalaire   normal.p(3) */
		scal += normal[i - 1] * p[i * 501 - 498];
/* L87660: */
	    }
/*         on rajoute un point p(0) virtuel symetrique de p(3) */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[i * 501 - 501] = p[i * 501 - 498] - (d + scal) * 2.f * 
			normal[i - 1];
/* L87661: */
	    }
/*          call mov2to((p(1,1)+p(2,1))/2.,(p(1,2)+p(2,2))/2.) */
/*          call lin2of(normal(2),-normal(1)) */
/*          call txt2d('0',1,p(0,1),p(0,2)) */
	    dd = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           longueur p(n-1),p(n) */
/* Computing 2nd power */
		r__1 = p[n - 1 + i * 501 - 501] - p[n + i * 501 - 501];
		dd += r__1 * r__1;
/* L87662: */
	    }
	    dd = sqrt(dd);
	    if (dd == 0.f) {
		dd = 1.f;
	    }
	    for (i = 1; i <= 2; ++i) {
/*           normale au plan mediateur de p(n-1),p(n) */
		normal[i - 1] = (p[n + i * 501 - 501] - p[n - 1 + i * 501 - 
			501]) / dd;
/* L87663: */
	    }
	    d = 0.f;
	    scal = 0.f;
	    for (i = 1; i <= 2; ++i) {
/*           coef d du plan mediateur */
		d -= normal[i - 1] * (p[n - 1 + i * 501 - 501] + p[n + i * 
			501 - 501]) * .5f;
/*           produit scalaire normal.p(n-2) */
		scal += normal[i - 1] * p[n - 2 + i * 501 - 501];
/* L87664: */
	    }
/*         on rajoute un point p(n+1) virtuel symetrique de p(n-2)
 */
/*                      / plan mediateur */
	    for (i = 1; i <= 2; ++i) {
		p[n + 1 + i * 501 - 501] = p[n - 2 + i * 501 - 501] - (d + 
			scal) * 2.f * normal[i - 1];
/* L87665: */
	    }
/*          call mov2to((p(n-1,1)+p(n,1))/2.,(p(n-1,2)+p(n,2))/2.)
 */
/*          call lin2of(normal(2),-normal(1)) */
/*          call txt2d('n+1',3,p(n+1,1),p(n+1,2)) */
	}
    }
    i__1 = n - 1;
    for (i = 1; i <= i__1; ++i) {
/*       longueur de p(i),p(i+1) */
	d = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 1 + nd * 501 - 501];
	    d += r__1 * r__1;
/* L87667: */
	}
	d = sqrt(d);
/*       longueur de p(i+1),p(i-1) */
	dd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + 1 + nd * 501 - 501] - p[i - 1 + nd * 501 - 501];
	    dd += r__1 * r__1;
/* L87668: */
	}
	dd = sqrt(dd);
/*       longueur de p(i),p(i+2) */
	ddd = 0.f;
	for (nd = 1; nd <= 2; ++nd) {
/* Computing 2nd power */
	    r__1 = p[i + nd * 501 - 501] - p[i + 2 + nd * 501 - 501];
	    ddd += r__1 * r__1;
/* L87669: */
	}
	ddd = sqrt(ddd);
	if (dd <= d * 1e-5f) {
	    dd = 1.f;
	}
	if (ddd <= d * 1e-5f) {
	    ddd = 1.f;
	}
/*       calcul des tangentes aux 2 points p(i) et p(i+1) */
/* Computing MIN */
	r__1 = d, r__2 = dd * .5f, r__1 = min(r__1,r__2), r__2 = ddd * .5f;
	a = dmin(r__1,r__2);
	for (nd = 1; nd <= 2; ++nd) {
	    tg[(nd << 1) - 2] = a * ((p[i + 1 + nd * 501 - 501] - p[i - 1 + 
		    nd * 501 - 501]) / dd);
	    tg[(nd << 1) - 1] = a * ((p[i + 2 + nd * 501 - 501] - p[i + nd * 
		    501 - 501]) / ddd);
/* L87670: */
	}
	for (nd = 1; nd <= 2; ++nd) {
	    for (k = 1; k <= 4; ++k) {
		w[k + (nd << 2) - 5] = 0.f;
		for (l = 1; l <= 2; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * p[i + l - 1 
			    + nd * 501 - 501];
/* L87673: */
		}
		for (l = 3; l <= 4; ++l) {
		    w[k + (nd << 2) - 5] += m[l + (k << 2) - 5] * tg[l - 2 + (
			    nd << 1) - 3];
/* L87674: */
		}
/* L87672: */
	    }
/* L87671: */
	}
	tgen[i] = *nbgen + 1;
	r__1 = 1.f - step + step * .51f;
	r__2 = step;
	for (t = 0.f; r__2 < 0 ? t >= r__1 : t <= r__1; t += r__2) {
	    for (nd = 1; nd <= 2; ++nd) {
/* Computing 3rd power */
		r__3 = t, r__4 = r__3;
/* Computing 2nd power */
		r__5 = t;
		c[nd - 1] = r__4 * (r__3 * r__3) * w[(nd << 2) - 4] + r__5 * 
			r__5 * w[(nd << 2) - 3] + t * w[(nd << 2) - 2] + w[(
			nd << 2) - 1];
/* L87676: */
	    }
	    if (*nbgen < *maxgen - 1) {
		++(*nbgen);
		xgen[*nbgen] = c[0];
		ygen[*nbgen] = c[1];
	    }
/* L87675: */
	}
/* L87666: */
    }
    ++(*nbgen);
    xgen[*nbgen] = x[n];
    ygen[*nbgen] = y[n];
    tgen[n] = *nbgen + 1;
    j = 1;
    i__1 = *nbgen;
    for (i = 2; i <= i__1; ++i) {
	if ((r__2 = xgen[i - 1] - xgen[i], dabs(r__2)) + (r__1 = ygen[i - 1] 
		- ygen[i], dabs(r__1)) != 0.f) {
	    ++j;
	    xgen[j] = xgen[i];
	    ygen[j] = ygen[i];
	}
/* L87777: */
    }
    if (j != *nbgen) {
	s_wsle(&io___1878);
	do_lio(&c__9, &c__1, " BIZARRE genspl : il y a des points doubles", 
		43L);
	e_wsle();
    }
    *nbgen = j;
    LA999: free(p);
    return 0;
} /* genspl_ */

/* Subroutine */ int gibbs1_(integer *n, integer *record, integer *ptvois)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer crit, i, j, l, r, rec;

/* -----------------------------------------------------------------------
 */
/*     routine appele par gibbs0 */
/* -----------------------------------------------------------------------
 */
/*     but: trie record (ensemble de n sommet) telle que l'ordre des somm 
*/
/*     soit croissant (ordre du sommet i est ptvois(i+1)-ptvois(i)) */
/* -----------------------------------------------------------------------
 */

    /* Parameter adjustments */
    --ptvois;
    --record;

    /* Function Body */
    if (*n <= 1) {
	return 0;
    }
    l = *n / 2 + 1;
    r = *n;
L2:
    if (l <= 1) {
	goto L20;
    }
    --l;
    rec = record[l];
    crit = ptvois[record[l] + 1] - ptvois[record[l]];
    goto L3;
L20:
    rec = record[r];
    crit = ptvois[record[r] + 1] - ptvois[record[r]];
    record[r] = record[1];
    --r;
    if (r == 1) {
	goto L999;
    }
L3:
    j = l;
L4:
    i = j;
    j <<= 1;
    if ((i__1 = j - r) < 0) {
	goto L5;
    } else if (i__1 == 0) {
	goto L6;
    } else {
	goto L8;
    }
L5:
    if (ptvois[record[j] + 1] - ptvois[record[j]] < ptvois[record[j + 1] + 1] 
	    - ptvois[record[j + 1]]) {
	++j;
    }
L6:
    if (crit >= ptvois[record[j] + 1] - ptvois[record[j]]) {
	goto L8;
    }
    record[i] = record[j];
    goto L4;
L8:
    record[i] = rec;
    goto L2;
L999:
    record[1] = rec;
    return 0;
} /* gibbs1_ */

/* Subroutine */ int gibbs2_(integer *n, integer *record, integer *criter)
{
    integer crit, i, j, l, r, rec;


/*     trie record selon les valeurs de criter(record(.)) croissantes */


    /* Parameter adjustments */
    --criter;
    --record;

    /* Function Body */
    if (*n <= 1) {
	return 0;
    }
    l = *n / 2 + 1;
    r = *n;
L2:
    if (l <= 1) {
	goto L20;
    }
    --l;
    rec = record[l];
    crit = criter[rec];
    goto L3;
L20:
    rec = record[r];
    crit = criter[rec];
    record[r] = record[1];
    --r;
    if (r == 1) {
	goto L999;
    }
L3:
    j = l;
L4:
    i = j;
    j <<= 1;
    if (j - r < 0) {
	goto L5;
    } else if (j == r) {
	goto L6;
    } else {
	goto L8;
    }
L5:
    if (criter[record[j]] < criter[record[j + 1]]) {
	++j;
    }
L6:
    if (crit >= criter[record[j]]) {
	goto L8;
    }
    record[i] = record[j];
    goto L4;
L8:
    record[i] = rec;
    goto L2;
L999:
    record[1] = rec;
    return 0;
} /* gibbs2_ */

/* Subroutine */ int gibbsa_(integer *n, integer *ptvois, integer *vois, 
	integer *r, integer *m, integer *nv, integer *nx, integer *ny, 
	integer *nn, integer *w1, integer *w2, integer *pfold, integer *pfnew,
	 integer *impre, integer *nfout)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    integer nbcc, degi, bold, bnew, i, j, k, p, degre, x, y, devic, p1, p2;
    extern /* Subroutine */ int gibbs1_(integer *, integer *, integer *);
    integer pf;
    extern /* Subroutine */ int gibbsb_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *),
	     gibbsd_(integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), enddev_(integer *), gibbst_(integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    integer nbpass, niveau, pf1, option, old, new_, opt, new1;

    /* Fortran I/O blocks */
    static cilist io___1894 = { 0, 0, 0, 0, 0 };
    static cilist io___1907 = { 0, 0, 0, 0, 0 };
    static cilist io___1908 = { 0, 0, 0, 0, 0 };
    static cilist io___1914 = { 0, 0, 0, 0, 0 };
    static cilist io___1915 = { 0, 0, 0, 0, 0 };
    static cilist io___1919 = { 0, 0, 0, 0, 0 };
    static cilist io___1920 = { 0, 0, 0, 0, 0 };


/* -----------------------------------------------------------------------
 */
/*  but: calculer une renumerotation des sommets d'un graphe defini par: 
*/
/*     par la methode de gibbs */
/* -----------------------------------------------------------------------
 */
/*  entree */
/* -------- */
/*     n = nb de sommet du graphe */
/*      les voisins d'un sommet i ont pour numero : */
/*     ( vois(j) , j=ptvois(i),ptvois(i+1)-1 ) */

/*     impre   parametre d'impression */
/*     nfout   numero du fichier pour impression */

/*  sortie */
/*  ------ */
/*     r(1:n) tableau donnant la nouvelle numerotation: */
/*       r(i) = nouveau numero du sommet i */
/*     pfolf = ancien  profile */
/*     pfnew = nouveau profile */

/*  tableau de travail : */
/*  -------------------- */
/*     m(n) */
/*     nv(0:n+n) */
/*     nx(n) */
/*     ny(n) */
/*     nn(0:n) */
/*     w1(n) */
/*     w2(n) */

/* -----------------------------------------------------------------------
 */
/*     programmeur f. hecht inria le 3/02/1987 */
/* -----------------------------------------------------------------------
 */

/*     tri des voisins d'un sommet du graphe par degre croissant */
/* --------------------------------------------------------------- */
    /* Parameter adjustments */
    --w2;
    --w1;
    --ny;
    --nx;
    --m;
    --r;
    --vois;
    --ptvois;

    /* Function Body */
    p2 = ptvois[1] - 1;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	p1 = p2 + 1;
	p2 = ptvois[i + 1] - 1;
	i__2 = p2 - p1 + 1;
	gibbs1_(&i__2, &vois[p1], &ptvois[1]);
	if (*impre <= -9) {
	    io___1894.ciunit = *nfout;
	    s_wsle(&io___1894);
	    do_lio(&c__9, &c__1, "les voisin de ", 14L);
	    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, "sont: ", 6L);
	    i__2 = p2;
	    for (j = p1; j <= i__2; ++j) {
		do_lio(&c__3, &c__1, (char *)&vois[j], (ftnlen)sizeof(integer)
			);
	    }
	    e_wsle();
	}
/* L10: */
    }
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	r[i] = 0;
/* L20: */
    }
/*     boucle sur les composante connexe du graphe */
    new_ = 0;
    nbcc = 0;
L30:
    if (new_ < *n) {
	++nbcc;
/*       recherche d'une racine y (un sommet non numerote) de degree m
ini */
	y = 0;
	degre = *n + 1;
	i__1 = *n;
	for (i = 1; i <= i__1; ++i) {
	    if (r[i] <= 0) {
		degi = ptvois[i + 1] - ptvois[i];
		if (degi < degre) {
		    degre = degi;
		    y = i;
		}
	    }
/* L40: */
	}
	if (y == 0) {
	    enddev_(&devic);
	    s_stop("fatale ERREUR  gibbs 2 : pb racine", 34L);
	}
	gibbsd_(&y, n, &ptvois[1], &vois[1], nv, &r[1], &niveau);
	nbpass = 0;
L50:
	++nbpass;
	x = y;
	p = niveau;
	k = 0;
	i__1 = nv[p + 1];
	for (i = nv[p] + 1; i <= i__1; ++i) {
	    ++k;
	    m[k] = nv[i];
/* L60: */
	}
	gibbs1_(&k, &m[1], &ptvois[1]);
	i__1 = k;
	for (i = 1; i <= i__1; ++i) {
	    y = m[i];
	    gibbsd_(&y, n, &ptvois[1], &vois[1], nv, &r[1], &niveau);
	    if (niveau > p) {
		goto L50;
	    }
/* L70: */
	}
	y = m[1];
	if (*impre < 0) {
	    io___1907.ciunit = *nfout;
	    s_wsle(&io___1907);
	    do_lio(&c__9, &c__1, "    nb de pass pour trouver le pseudo diam"
		    "etre", 46L);
	    do_lio(&c__3, &c__1, (char *)&nbpass, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " x=", 3L);
	    do_lio(&c__3, &c__1, (char *)&x, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, ",y=", 3L);
	    do_lio(&c__3, &c__1, (char *)&y, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " de la composante connexe ", 26L);
	    do_lio(&c__3, &c__1, (char *)&nbcc, (ftnlen)sizeof(integer));
	    e_wsle();
	    io___1908.ciunit = *nfout;
	    s_wsle(&io___1908);
	    for (i = 1; i <= 78; ++i) {
		do_lio(&c__9, &c__1, "-", 1L);
	    }
	    e_wsle();
	}
/*       optimisation de la descendance de la numerotation */
/*       ------------------------------------------------- */
	gibbsb_(&x, &y, n, &ptvois[1], &vois[1], &nx[1], &ny[1], nv, nn, &m[1]
		, &w1[1], &w2[1], &r[1], impre, nfout);

/*     renumerotation de cuthill mac kee avec la meilleur des 4 option
s */
/*     --------------------------------------------------------------
--- */
	pf = 1073741824;
	option = -2;
	new1 = new_;
	for (opt = -2; opt <= 2; ++opt) {
	    new_ = new1;
	    if (opt != 0) {
		gibbst_(n, &p, nv, nn, &ptvois[1], &vois[1], &m[1], &r[1], &
			new_, &opt, &pf1, impre, nfout);
		if (pf1 < pf) {
		    pf = pf1;
		    option = opt;
		}
	    }
/* L80: */
	}
	if (*impre != 0) {
	    io___1914.ciunit = *nfout;
	    s_wsle(&io___1914);
	    do_lio(&c__9, &c__1, "    on a choisi l'option ", 25L);
	    do_lio(&c__3, &c__1, (char *)&option, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, ", new =", 7L);
	    do_lio(&c__3, &c__1, (char *)&new_, (ftnlen)sizeof(integer));
	    e_wsle();
	}
	new_ = new1;
	gibbst_(n, &p, nv, nn, &ptvois[1], &vois[1], &m[1], &r[1], &new_, &
		option, &pf1, impre, nfout);
	goto L30;
    }
    if (*impre != 0) {
	io___1915.ciunit = *nfout;
	s_wsle(&io___1915);
	do_lio(&c__9, &c__1, "   nb de composante connexe du graphe =", 39L);
	do_lio(&c__3, &c__1, (char *)&nbcc, (ftnlen)sizeof(integer));
	e_wsle();
    }
/*     calcul du profile */
    *pfold = 0;
    *pfnew = 0;
    bnew = 0;
    bold = 0;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	old = i;
	new_ = r[i];
	i__2 = ptvois[i + 1] - 1;
	for (j = ptvois[i]; j <= i__2; ++j) {
/* Computing MIN */
	    i__3 = old, i__4 = vois[j];
	    old = min(i__3,i__4);
/* Computing MIN */
	    i__3 = new_, i__4 = r[vois[j]];
	    new_ = min(i__3,i__4);
/* L100: */
	}
	*pfold = *pfold + i - old + 1;
/* Computing MAX */
	i__2 = bold, i__3 = i - old + 1;
	bold = max(i__2,i__3);
	*pfnew = *pfnew + r[i] - new_ + 1;
/* Computing MAX */
	i__2 = bnew, i__3 = r[i] - new_ + 1;
	bnew = max(i__2,i__3);
/* L110: */
    }
    if (*impre != 0) {
	io___1919.ciunit = *nfout;
	s_wsle(&io___1919);
	do_lio(&c__9, &c__1, "profile  old  = ", 16L);
	do_lio(&c__3, &c__1, (char *)&(*pfold), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", profile  new = ", 17L);
	do_lio(&c__3, &c__1, (char *)&(*pfnew), (ftnlen)sizeof(integer));
	e_wsle();
	io___1920.ciunit = *nfout;
	s_wsle(&io___1920);
	do_lio(&c__9, &c__1, "1/2 bande old = ", 16L);
	do_lio(&c__3, &c__1, (char *)&bold, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", 1/2 band new = ", 17L);
	do_lio(&c__3, &c__1, (char *)&bnew, (ftnlen)sizeof(integer));
	e_wsle();
    }
    return 0;
} /* gibbsa_ */

/* Subroutine */ int gibbsb_(integer *x, integer *y, integer *n, integer *
	ptvois, integer *vois, integer *nx, integer *ny, integer *nv, integer 
	*nn, integer *m, integer *wh, integer *wl, integer *r, integer *impre,
	 integer *nfout)
{
    /* Format strings */
    static char fmt_5555[] = "(\002            --------   \002,a,/,5(15x,10("
	    "i5)/))";

    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void);

    /* Local variables */
    logical flag_;
    integer i, j, k, p, s, h0, i1, l0, i2;
    extern /* Subroutine */ int gibbs1_(integer *, integer *, integer *);
    integer lg;
    extern /* Subroutine */ int gibbsc_(integer *, integer *, integer *, 
	    integer *, integer *), gibbsd_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *), gibbsi_(char *, 
	    integer *, integer *, integer *, integer *, integer *, ftnlen);
    integer niveau, mxcanx, mxcany, nbc;

    /* Fortran I/O blocks */
    static cilist io___1931 = { 0, 0, 0, 0, 0 };
    static cilist io___1932 = { 0, 0, 0, fmt_5555, 0 };
    static cilist io___1933 = { 0, 0, 0, fmt_5555, 0 };
    static cilist io___1937 = { 0, 0, 0, 0, 0 };
    static cilist io___1938 = { 0, 0, 0, fmt_5555, 0 };
    static cilist io___1941 = { 0, 0, 0, 0, 0 };
    static cilist io___1942 = { 0, 0, 0, 0, 0 };
    static cilist io___1943 = { 0, 0, 0, fmt_5555, 0 };


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
/* ...................................................................... 
*/
/*     attention on met la descente optimiser dans r <0 ou nulle */
/* .......................................................................
 */
    /* Parameter adjustments */
    --r;
    --m;
    --ny;
    --nx;
    --vois;
    --ptvois;

    /* Function Body */
    gibbsd_(y, n, &ptvois[1], &vois[1], nv, &r[1], &niveau);
    gibbsi_("nv y =", n, nv, &niveau, impre, nfout, 6L);
    gibbsc_(&ny[1], nv, &niveau, n, &mxcany);
    gibbsd_(x, n, &ptvois[1], &vois[1], nv, &r[1], &niveau);
    gibbsi_("nv x =", n, nv, &niveau, impre, nfout, 6L);
    p = niveau;
    gibbsc_(&nx[1], nv, &niveau, n, &mxcanx);
    flag_ = FALSE_;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (nx[i] + ny[i] == p) {
	    r[i] = -nx[i];
	} else if (nx[i] >= 0) {
	    flag_ = TRUE_;
	    r[i] = -1073741824;
	} else {
	    if (r[i] <= 0) {
		r[i] = -1073741822;
	    }
	}
/* L20: */
    }
    if (flag_) {
/*       calcul des composantes connexe du graphe sans les sommets de 
nn */
/*       ------------------------------------------------------------
--- */
	j = *n;
	k = 0;
	nbc = 0;
	nv[nbc] = j;
L30:
	++k;
	if (k <= *n) {
	    if (r[k] == -1073741824) {
/*           recherche de la fermeture transitive partant de k
 */
		++nbc;
		i = -1;
		s = k;
L40:
		++i;
		wl[i] = ptvois[s];
		wh[i] = ptvois[s + 1];
		++j;
		nv[j] = s;
		r[s] = -1073741823;
L50:
		if (i >= 0) {
		    if (wl[i] < wh[i]) {
			s = vois[wl[i]];
			++wl[i];
			if (r[s] == -1073741824) {
			    goto L40;
			}
			goto L50;
		    }
		    --i;
		    goto L50;
		}
		nv[nbc] = j;
		m[nbc] = nbc;
	    }
	    goto L30;
	}
	if (*impre < 0) {
	    io___1931.ciunit = *nfout;
	    s_wsle(&io___1931);
	    do_lio(&c__9, &c__1, " nb de composante connexe du graphe reduit"
		    " =", 44L);
	    do_lio(&c__3, &c__1, (char *)&nbc, (ftnlen)sizeof(integer));
	    e_wsle();
	}
/* --------------- fin de construction des composantes connexes------
--- */
/*        nv(0)=n */
	if (*impre <= -10) {
	    io___1932.ciunit = *nfout;
	    s_wsfe(&io___1932);
	    do_fio(&c__1, "nv(0:n+n) = ", 12L);
	    i__1 = *n + *n;
	    for (i = 0; i <= i__1; ++i) {
		do_fio(&c__1, (char *)&nv[i], (ftnlen)sizeof(integer));
	    }
	    e_wsfe();
	}
	gibbs1_(&nbc, &m[1], nv);
	if (*impre <= -10) {
	    io___1933.ciunit = *nfout;
	    s_wsfe(&io___1933);
	    do_fio(&c__1, "trie m =", 8L);
	    i__1 = nbc;
	    for (i = 1; i <= i__1; ++i) {
		do_fio(&c__1, (char *)&m[i], (ftnlen)sizeof(integer));
	    }
	    e_wsfe();
	}
	i__1 = p;
	for (i = 0; i <= i__1; ++i) {
	    nn[i] = 0;
/* L60: */
	}
	i__1 = *n;
	for (i = 1; i <= i__1; ++i) {
	    j = -r[i];
	    if (j >= 0 && j <= p) {
		++nn[j];
	    }
/* L70: */
	}

/*       boucle sur les composante connexes par ordre croissantes */
/*       -------------------------------------------------------- */
	for (k = nbc; k >= 1; --k) {
	    i = m[k];
	    i1 = nv[i - 1] + 1;
	    i2 = nv[i];
	    lg = i2 - i1 + 1;
	    if (*impre <= -7) {
		io___1937.ciunit = *nfout;
		s_wsle(&io___1937);
		do_lio(&c__3, &c__1, (char *)&k, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " composante ", 12L);
		do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, ",lg=", 4L);
		do_lio(&c__3, &c__1, (char *)&lg, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, ",i1,i2=", 7L);
		do_lio(&c__3, &c__1, (char *)&i1, (ftnlen)sizeof(integer));
		do_lio(&c__3, &c__1, (char *)&i2, (ftnlen)sizeof(integer));
		e_wsle();
	    }
	    if (*impre <= -8) {
		io___1938.ciunit = *nfout;
		s_wsfe(&io___1938);
		do_fio(&c__1, " ", 1L);
		i__1 = i2;
		for (i = i1; i <= i__1; ++i) {
		    do_fio(&c__1, (char *)&nv[i], (ftnlen)sizeof(integer));
		}
		e_wsfe();
	    }
	    h0 = 0;
	    l0 = 0;
	    i__1 = p;
	    for (j = 0; j <= i__1; ++j) {
		wh[j] = nn[j];
		wl[j] = nn[j];
/* L90: */
	    }
	    i__1 = i2;
	    for (i = i1; i <= i__1; ++i) {
		s = nv[i];
		++wh[nx[s]];
		++wl[p - ny[s]];
/* L100: */
	    }
	    i__1 = p;
	    for (j = 0; j <= i__1; ++j) {
		if (wh[j] != nn[j]) {
/* Computing MAX */
		    i__2 = wh[j];
		    h0 = max(i__2,h0);
		}
		if (wl[j] != nn[j]) {
/* Computing MAX */
		    i__2 = wl[j];
		    l0 = max(i__2,l0);
		}
/* L110: */
	    }
	    if (h0 < l0 || h0 == l0 && mxcanx <= mxcany) {
		if (*impre <= -2) {
		    io___1941.ciunit = *nfout;
		    s_wsle(&io___1941);
		    do_lio(&c__9, &c__1, "         h0 = ", 14L);
		    do_lio(&c__3, &c__1, (char *)&h0, (ftnlen)sizeof(integer))
			    ;
		    do_lio(&c__9, &c__1, ",l0 = ", 6L);
		    do_lio(&c__3, &c__1, (char *)&l0, (ftnlen)sizeof(integer))
			    ;
		    do_lio(&c__9, &c__1, "  ------- XXXX --------", 23L);
		    e_wsle();
		}
		i__1 = i2;
		for (i = i1; i <= i__1; ++i) {
		    s = nv[i];
		    r[s] = -nx[s];
		    ++nn[-r[s]];
/* L120: */
		}
	    } else {
		if (*impre <= -2) {
		    io___1942.ciunit = *nfout;
		    s_wsle(&io___1942);
		    do_lio(&c__9, &c__1, "         h0 = ", 14L);
		    do_lio(&c__3, &c__1, (char *)&h0, (ftnlen)sizeof(integer))
			    ;
		    do_lio(&c__9, &c__1, ",l0 = ", 6L);
		    do_lio(&c__3, &c__1, (char *)&l0, (ftnlen)sizeof(integer))
			    ;
		    do_lio(&c__9, &c__1, "  ------- YYYY --------", 23L);
		    e_wsle();
		}
		i__1 = i2;
		for (i = i1; i <= i__1; ++i) {
		    s = nv[i];
		    r[s] = -p + ny[s];
		    ++nn[-r[s]];
/* L130: */
		}
	    }
/* L140: */
	}
    }
/*     on met les nouveaux niveaux de la descendance optimiser dans nn */
/*     ----------------------------------------------------------------- 
*/
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (r[i] > 0) {
	    nn[i] = -1;
	} else if (r[i] == -1073741822) {
	    nn[i] = -2;
	} else {
	    nn[i] = -r[i];
	}
/* L150: */
    }
    if (*impre <= -10) {
	io___1943.ciunit = *nfout;
	s_wsfe(&io___1943);
	do_fio(&c__1, " nn(i)=", 7L);
	i__1 = *n;
	for (i = 1; i <= i__1; ++i) {
	    do_fio(&c__1, (char *)&nn[i], (ftnlen)sizeof(integer));
	}
	e_wsfe();
    }
    return 0;
} /* gibbsb_ */

/* Subroutine */ int gibbsc_(integer *nz, integer *nv, integer *niveau, 
	integer *n, integer *mxz)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    integer i, j;

/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
    /* Parameter adjustments */
    --nz;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	nz[i] = -1;
/* L10: */
    }
    *mxz = 0;
    i__1 = *niveau;
    for (i = 0; i <= i__1; ++i) {
/* Computing MAX */
	i__2 = *mxz, i__3 = nv[i + 1] - nv[i];
	*mxz = max(i__2,i__3);
	i__2 = nv[i + 1];
	for (j = nv[i] + 1; j <= i__2; ++j) {
	    nz[nv[j]] = i;
/* L20: */
	}
    }
    return 0;
} /* gibbsc_ */

/* Subroutine */ int gibbsd_(integer *racine, integer *n, integer *ptvois, 
	integer *vois, integer *nv, integer *r, integer *niveau)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer i, k, s, sv, stk, stk1, stk2;

/* -----------------------------------------------------------------------
 */
/*     but construire la structure des descendant de racine  du graphe */
/* -----------------------------------------------------------------------
 */
/*     sortie : */
/*     -------- */
/*     nv est la structure des niveaux */
/*     les sommets du niveau (i =0,niveau_ sont defini par : */
/*        (nv(j),j=nv(i),nv(i+1)-1) */

/*     le tableau r(i) n'est modifier que sur les sommets */
/*       de la composante connexe du graphe contenant la racine */

/* -----------------------------------------------------------------------
 */

/*     on demark tout les sommets non remuneroter */
/* -------------------------------------------------- */
    /* Parameter adjustments */
    --r;
    --vois;
    --ptvois;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (r[i] < 0) {
	    r[i] = 0;
	}
/* L10: */
    }

/*    initialisation */

    stk = *n - 1;
    nv[0] = stk;
    stk2 = stk;
    *niveau = 0;
    ++stk;
    nv[stk] = *racine;
    r[*racine] = -1;
L20:
    if (stk2 < stk) {
	++(*niveau);
	stk1 = stk2 + 1;
	nv[*niveau] = stk;
	stk2 = stk;
/*        print *,' ------- niveau =',niveau,' stk=',stk1,stk2 */
	i__1 = stk2;
	for (k = stk1; k <= i__1; ++k) {
	    s = nv[k];
/*         print *,'----------------- s=',s */
	    i__2 = ptvois[s + 1] - 1;
	    for (i = ptvois[s]; i <= i__2; ++i) {
/*               pour tout les sommets (sv) voisin */
/*                d'un sommet (s) du niveau precedent */
		sv = vois[i];
/*          print *,' voisin =',sv */
/*               si le sommet n'est pas marque on le marque et
 on l'ajout */
		if (r[sv] == 0) {
		    ++stk;
		    nv[stk] = sv;
		    r[sv] = -1;
		}
/* L30: */
	    }
/* L40: */
	}
	goto L20;
    }
    --(*niveau);
/*      call pnv(' gibbsd ',n,nv,niveau) */
    return 0;
} /* gibbsd_ */

/* Subroutine */ int gibbsi_(char *ch, integer *n, integer *nv, integer *
	niveau, integer *impre, integer *nfout, ftnlen ch_len)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i, j;

    /* Fortran I/O blocks */
    static cilist io___1953 = { 0, 0, 0, 0, 0 };
    static cilist io___1954 = { 0, 0, 0, 0, 0 };
    static cilist io___1955 = { 0, 0, 0, 0, 0 };
    static cilist io___1957 = { 0, 0, 0, 0, 0 };
    static cilist io___1959 = { 0, 0, 0, 0, 0 };


/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
    if (*impre <= -8) {
	io___1953.ciunit = *nfout;
	s_wsle(&io___1953);
	do_lio(&c__9, &c__1, "______________________________________________"
		"________________", 62L);
	e_wsle();
	io___1954.ciunit = *nfout;
	s_wsle(&io___1954);
	do_lio(&c__9, &c__1, ch, ch_len);
	e_wsle();
	io___1955.ciunit = *nfout;
	s_wsle(&io___1955);
	do_lio(&c__9, &c__1, " la stucture des niveaux est : ", 31L);
	e_wsle();
	i__1 = *niveau;
	for (i = 0; i <= i__1; ++i) {
	    io___1957.ciunit = *nfout;
	    s_wsle(&io___1957);
	    do_lio(&c__9, &c__1, "niveau ", 7L);
	    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " sommet=", 8L);
	    i__2 = nv[i + 1];
	    for (j = nv[i] + 1; j <= i__2; ++j) {
		do_lio(&c__3, &c__1, (char *)&nv[j], (ftnlen)sizeof(integer));
	    }
	    e_wsle();
/* L1: */
	}
	io___1959.ciunit = *nfout;
	s_wsle(&io___1959);
	do_lio(&c__9, &c__1, ".............................................."
		"................", 62L);
	e_wsle();
    }
    return 0;
} /* gibbsi_ */

/* Subroutine */ int gibbst_(integer *n, integer *p, integer *nv, integer *nn,
	 integer *ptvois, integer *vois, integer *m, integer *r, integer *
	new_, integer *option, integer *pfnew, integer *impre, integer *nfout)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer nbsc, bnew, knew, step, plus, i, j, k, s, debut, i1, i2;
    extern /* Subroutine */ int gibbs2_(integer *, integer *, integer *), 
	    gibbsi_(char *, integer *, integer *, integer *, integer *, 
	    integer *, ftnlen);
    integer fin;

    /* Fortran I/O blocks */
    static cilist io___1973 = { 0, 0, 0, 0, 0 };



/*     construction de la stucture de niveau dans nv a partir de nn */
/*     ------------------------------------------------------------ */
    /* Parameter adjustments */
    --r;
    --m;
    --vois;
    --ptvois;

    /* Function Body */
    nv[0] = *n;
    i__1 = *p + 1;
    for (i = 1; i <= i__1; ++i) {
	nv[i] = 0;
/* L150: */
    }
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (nn[i] >= 0) {
	    ++nv[nn[i] + 1];
	}
/* L160: */
    }
    i__1 = *p;
    for (i = 0; i <= i__1; ++i) {
	nv[i + 1] += nv[i];
/* L170: */
    }
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (nn[i] >= 0) {
	    j = nn[i];
	    ++nv[j];
	    nv[nv[j]] = i;
	}
/* L180: */
    }
    for (i = *p; i >= 0; --i) {
	nv[i + 1] = nv[i];
/* L190: */
    }
    nv[0] = *n;
    nbsc = nv[*p + 1] - nv[0];
/*     --- fin de la construction ------------------------------------ */
    if (*option == -2) {
	i__1 = *impre - 1;
	gibbsi_("nv optim=", n, nv, p, &i__1, nfout, 9L);
    }
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	m[i] = *n * 3 + ptvois[i + 1] - ptvois[i];
/* L10: */
    }
    if (abs(*option) == 1) {
	debut = 0;
	fin = *p;
	step = 1;
    } else {
	debut = *p;
	fin = 0;
	step = -1;
    }
    i__1 = fin;
    i__2 = step;
    for (i = debut; i__2 < 0 ? i >= i__1 : i <= i__1; i += i__2) {
	i1 = nv[i] + 1;
	i2 = nv[i + 1];
	i__3 = i2 - i1 + 1;
	gibbs2_(&i__3, &nv[i1], &m[1]);
	i__3 = i2;
	for (j = i1; j <= i__3; ++j) {
	    s = nv[j];
	    i__4 = ptvois[s + 1] - 1;
	    for (k = ptvois[s]; k <= i__4; ++k) {
/* Computing MIN */
		i__5 = m[vois[k]];
		m[vois[k]] = min(i__5,j);
/* L20: */
	    }
/* L30: */
	}
/* L40: */
    }
    if (*option > 0) {
	knew = *new_;
	plus = 1;
    } else {
	knew = *new_ + nbsc + 1;
	plus = -1;
    }
    *new_ += nbsc;
/*      if(option.gt.0) then */
/*        do 60 k = debut , fin , step */
/*          do 60 j = nv(k+1),nv(k)+1,-1 */
/*            knew = knew + plus */
/*            r(nv(j)) = knew */
/* 60      continue */
/*      else */
    i__2 = fin;
    i__1 = step;
    for (k = debut; i__1 < 0 ? k >= i__2 : k <= i__2; k += i__1) {
	i__3 = nv[k + 1];
	for (j = nv[k] + 1; j <= i__3; ++j) {
	    knew += plus;
	    r[nv[j]] = knew;
/* L70: */
	}
    }
/*      endif */
    *pfnew = 0;
    bnew = 0;
    i__3 = *n;
    for (i = 1; i <= i__3; ++i) {
	k = r[i];
	if (k > 0) {
	    i__1 = ptvois[i + 1] - 1;
	    for (j = ptvois[i]; j <= i__1; ++j) {
		if (r[vois[j]] > 0) {
/* Computing MIN */
		    i__2 = k, i__4 = r[vois[j]];
		    k = min(i__2,i__4);
		}
/* L100: */
	    }
	    *pfnew = *pfnew + r[i] - k + 1;
/* Computing MAX */
	    i__1 = bnew, i__2 = r[i] - k + 1;
	    bnew = max(i__1,i__2);
	}
/* L110: */
    }
    if (*impre < 0 || *impre > 2) {
	io___1973.ciunit = *nfout;
	s_wsle(&io___1973);
	do_lio(&c__9, &c__1, "      option =", 14L);
	do_lio(&c__3, &c__1, (char *)&(*option), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", profile =", 11L);
	do_lio(&c__3, &c__1, (char *)&(*pfnew), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", 1/2 bande =", 13L);
	do_lio(&c__3, &c__1, (char *)&bnew, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", new=", 6L);
	do_lio(&c__3, &c__1, (char *)&(*new_), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, ", nbs composante=", 17L);
	do_lio(&c__3, &c__1, (char *)&nbsc, (ftnlen)sizeof(integer));
	e_wsle();
    }
    return 0;
} /* gibbst_ */

/* Subroutine */ int gibbsv_(integer *ptvoi, integer *vois, integer *lvois, 
	integer *w, integer *v, integer *err)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer i, j, k, t;

    integer ss, iii, ptv;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    integer ptv1;

    /* Parameter adjustments */
    --v;
    --w;
    --vois;
    --ptvoi;

    /* Function Body */
    *err = 1;
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	w[i] = -1;
	ptvoi[i] = 0;
/* L10: */
    }
    ptvoi[bdmsh1_1.nbs + 1] = 0;
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	if (bdmsh9_1.nsea[i * 6 - 6] > 0) {
	    for (j = 1; j <= 3; ++j) {
		ss = bdmsh9_1.nsea[j + i * 6 - 7];
		++ptvoi[ss + 1];
		w[ss] = 0;
/* L15: */
	    }
	}
/* L20: */
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	ptvoi[i + 1] += ptvoi[i];
/* L21: */
    }
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	if (bdmsh9_1.nsea[i * 6 - 6] > 0) {
	    for (j = 1; j <= 3; ++j) {
		ss = bdmsh9_1.nsea[j + i * 6 - 7];
		++ptvoi[ss];
		v[ptvoi[ss]] = i;
/* L22: */
	    }
	}
/* L23: */
    }
    ptv1 = 0;
    iii = 1;
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	ptv = ptv1 + 1;
	ptv1 = ptvoi[i];
	ptvoi[i] = iii;
	i__2 = ptv1;
	for (j = ptv; j <= i__2; ++j) {
	    t = v[j];
	    for (k = 1; k <= 3; ++k) {
		ss = bdmsh9_1.nsea[k + t * 6 - 7];
		if (w[ss] != i) {
		    w[ss] = i;
		    if (iii > *lvois) {
			*err = 2;
			scrtch_("pas assez de place memoire", 26L);
			return 0;
		    }
		    vois[iii] = ss;
		    ++iii;
		}
/* L30: */
	    }
/* L40: */
	}
/*         print *,' i=',i,' ptvoi=',ptvoi(i) */
/*     +          ,'v=',(vois(k),k=ptvoi(i),iii-1) */
/* L50: */
    }
    ptvoi[bdmsh1_1.nbs + 1] = iii;
    *lvois = iii - 1;
    *err = 0;
    return 0;
} /* gibbsv_ */




/* Subroutine */ int gmshq_(integer *topwork, integer *ptdomn, integer *nssd, 
	integer *err)
{
    /* Local variables */
    integer k;

    extern /* Subroutine */ int gmshq0_(integer *, integer *, integer *, real 
	    *, real *, real *, real *, real *, real *, real *, real *, real *,
	     real *, real *, real *, real *, real *, integer *, integer *);

    k = *topwork + 1;
/*#define xwork ((real *) bdwrk1_1.work)*/
    gmshq0_(ptdomn, nssd, err, &bdwrk1_3.xwork[k - 1], &bdwrk1_3.xwork[k + 999], &bdwrk1_3.xwork[k + 
	    1999], &bdwrk1_3.xwork[k + 2999], &bdwrk1_3.xwork[k + 3999], &bdwrk1_3.xwork[k + 4999], &
	    bdwrk1_3.xwork[k + 5999], &bdwrk1_3.xwork[k + 6999], &bdwrk1_3.xwork[k + 7999], &bdwrk1_3.xwork[k + 
	    8999], &bdwrk1_3.xwork[k + 9999], &bdwrk1_3.xwork[k + 10999], &bdwrk1_3.xwork[k + 11999], &
	    bdwrk1_3.xwork[k + 12999], &bdwrk1_1.work[k + 13999], &bdwrk1_1.work[k + 
	    14000 + bdmsh0_1.nbpmx - 1]);
/*#undef xwork*/
    return 0;
} /* gmshq_ */




/* Subroutine */ int gmshq0_(integer *ptdomn, integer *nssd, integer *err, 
	real *xc, real *yc, real *x1, real *x2, real *x3, real *x4, real *y1, 
	real *y2, real *y3, real *y4, real *f1, real *f2, real *f3, real *f4, 
	integer *w1, integer *w2)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern /* Subroutine */ int genban_(integer *, integer *, integer *, 
	    integer *, real *, real *, real *, real *, real *, real *, real *,
	     real *, integer *, integer *, integer *, integer *, real *, real 
	    *, real *, real *, integer *, integer *);
    extern integer cadr_(integer *);
    integer mini, maxi, step;
    extern /* Subroutine */ int gnin_(real *, real *, real *, integer *, real 
	    *);
    extern integer cadar_(integer *), caddr_(integer *);

    extern integer ligne_(integer *, integer *, integer *);
    integer i, n, n1, compt1, compt2;
    extern integer cadddr_(integer *), cdaaar_(integer *);
    extern integer cddddr_(integer *);
    integer comptc, ptt, pt1, ptcomp, compt3, compt4, cmp1, cmp2, cmp3, cmp4;
    real xx1, xx2, yy1, yy2, vvx, vvy;
    integer nb1, nb2, nb3, nb4;
    extern /* Subroutine */ int freel_(integer *), aligne_(integer *);
    extern integer nbintlk_(integer *), ligne1_(integer *, integer *, integer 
	    *);
    extern /* Subroutine */ int scrtch_(char *, ftnlen), extrm2_(integer *, 
	    real *, real *, real *, real *), gmshqq_(integer *, integer *, 
	    integer *, integer *, real *, real *, real *, real *, real *, 
	    real *, real *, real *, integer *, integer *, integer *, integer *
	    , real *, real *, real *, real *, integer *, integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___1999 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2021 = { 0, 6, 0, 0, 0 };



/*     pour tracer des quadrangles par interpolation */
    /* Parameter adjustments */
    --w2;
    --w1;
    --f4;
    --f3;
    --f2;
    --f1;
    --y4;
    --y3;
    --y2;
    --y1;
    --x4;
    --x3;
    --x2;
    --x1;
    --yc;
    --xc;

    /* Function Body */
    if (*err != 0) {
	return 0;
    }
    if (*ptdomn == 0) {
	return 0;
    }
/*     teste si decoupe en quadrangles */
    ptt = cdaaar_(ptdomn);
    if (listea_1.car[ptt - 1] == 309) {
	return 0;
    }
    ptcomp = cadar_(ptdomn);
/*     nombre de points sur la composante */
/*     astuce, on fait debuter la ligne sur le premier cote */
    freel_(&bdpec1_1.link);
    i__1 = cadr_(&ptt);
    i__2 = cadr_(&ptt);
    bdpec1_1.link = ligne_(&i__1, &ptcomp, &i__2);
    aligne_(&bdpec1_1.link);
    i__1 = -bdpec1_1.link;
    comptc = nbintlk_(&i__1);
/*     nombre de points sur le premier cote */
    i__2 = cadr_(&ptt);
    i__3 = caddr_(&ptt);
    i__1 = ligne1_(&i__2, &ptcomp, &i__3);
    compt1 = nbintlk_(&i__1);
    if (compt1 == 0) {
	scrtch_("ERREUR VOUS N'AVEZ PAS DEFINI LE 1ER COTE!", 42L);
	*err = 200;
	return 0;
/*        print*,'voirdo:erreur vous n''avez pas defini le 1er cote!' 
*/
    }
    if (listea_1.car[ptt - 1] == 312) {
	i__2 = cadddr_(&ptt);
	i__3 = cadddr_(&listed_1.cdr[ptt - 1]);
	i__1 = ligne1_(&i__2, &ptcomp, &i__3);
	compt2 = nbintlk_(&i__1);
	if (compt2 == 0) {
	    scrtch_("ERREUR VOUS N'AVEZ PAS DEFINI LE 2ER COTE!", 42L);
	    *err = 200;
	    return 0;
/*        print*,'voirdo:erreur vous n''avez pas defini le 1er cot
e!' */
	}
	compt4 = compt2;
	compt3 = (i__1 = comptc - (compt1 + compt2 + compt2), abs(i__1));
    } else {
	compt2 = (comptc - (compt1 << 1)) / 2;
	compt3 = compt1;
	compt4 = compt2;
    }
/*       print *,'gmshq0: comptc,compt1,compt2,compt3,compt4 =', */
/*     +          comptc,compt1,compt2,compt3,compt4 */
    if (comptc != compt1 + compt2 + compt3 + compt4) {
	s_wsle(&io___1999);
	do_lio(&c__9, &c__1, "gmshq0: comptc,compt1,compt2,compt3,compt4 =", 
		44L);
	do_lio(&c__3, &c__1, (char *)&comptc, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt1, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt2, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt3, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&compt4, (ftnlen)sizeof(integer));
	e_wsle();
	scrtch_("ERREUR nb de point contour!", 27L);
	*err = 300;
    }
/*      print*,'voirdo:nombre de points sur le 1er cote:',compt */
    cmp1 = compt1 + 1;
    cmp2 = cmp1 + compt2;
    cmp3 = cmp2 + compt3;
    cmp4 = cmp3 + compt4;
    nb1 = 0;
    nb2 = 0;
    nb3 = compt3 + 2;
    nb4 = compt4 + 2;
/*      print*,'voirdo:nombre de points sur le 2ieme cote:',comptx */
    n = 0;
    pt1 = bdpec1_1.link;
L12:
    if (pt1 != 0) {
	xx1 = 0.f;
	yy1 = 0.f;
	n1 = 0;
	extrm2_(&listea_1.car[pt1 - 1], &vvx, &vvy, &xx2, &yy2);
	gnin_(&bdpec2_1.bd[listea_1.car[pt1 - 1] * 6 + 384], &xc[2], &yc[2], &
		bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64], &bdpec4_1.raison[
		listea_1.car[pt1 - 1] + 64]);
/*       doit on l'inverser? */
	if (bdpecc_1.compos[(listea_1.car[pt1 - 1] << 1) + 129] == cadar_(
		ptdomn)) {
	    xc[bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64]] = xx2;
	    yc[bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64]] = yy2;
	    maxi = 2;
	    mini = bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64];
	    step = -1;
	} else {
	    xc[1] = vvx;
	    yc[1] = vvy;
	    mini = 1;
	    maxi = bdpec3_1.nbnode[listea_1.car[pt1 - 1] + 64] - 1;
	    step = 1;
	}
	i__1 = maxi;
	i__2 = step;
	for (i = mini; i__2 < 0 ? i >= i__1 : i <= i__1; i += i__2) {
	    ++n;
	    ++n1;
	    xx1 += xc[i];
	    yy1 += yc[i];
	    if (n < cmp1) {
/*           premier cote [ [ */
		++nb1;
		x1[nb1] = xc[i];
		y1[nb1] = yc[i];
	    } else if (n < cmp2) {
/*           deuxieme cote [ [ */
		++nb2;
		x2[nb2] = xc[i];
		y2[nb2] = yc[i];
	    } else if (n < cmp3) {
/*           troisieme cote ]  ] */
		--nb3;
		x3[nb3] = xc[i];
		y3[nb3] = yc[i];
	    } else if (n < cmp4) {
/*           quatrieme cote ]  ] */
		--nb4;
		x4[nb4] = xc[i];
		y4[nb4] = yc[i];
	    }
/* L13: */
	}
	pt1 = listed_1.cdr[pt1 - 1];
	goto L12;
    }
/*      print*,'gmshq0:nb1=',nb1,' nb2=',nb2,' nb3=',nb3,' nb4=',nb4 */
/*      print*, cmp1,cmp2,cmp3,cmp4,n */
    nb1 = compt1 + 1;
    nb2 = compt2 + 1;
    nb3 = compt3 + 1;
    nb4 = compt4 + 1;
/* --  update de extremites ------ */
    x1[nb1] = x2[1];
    y1[nb1] = y2[1];
    x2[nb2] = x3[nb3];
    y2[nb2] = y3[nb3];
    x3[1] = x4[nb4];
    y3[1] = y4[nb4];
    x4[1] = x1[1];
    y4[1] = y1[1];
/*      print*, 'cote1=',nb1,(x1(i),y1(i),i=1,nb1) */
/*      print*, 'cote2=',nb2,(x2(i),y2(i),i=1,nb2) */
/*      print*, 'cote3=',nb3,(x3(i),y3(i),i=1,nb3) */
/*      print*, 'cote4=',nb4,(x4(i),y4(i),i=1,nb4) */
/*     trace des quadrangles methode modulef */
    if (nb1 == nb3 && nb2 == nb4) {
	gmshqq_(&nb1, &nb2, &nb3, &nb4, &x1[1], &y1[1], &x2[1], &y2[1], &x3[1]
		, &y3[1], &x4[1], &y4[1], nssd, &listea_1.car[cddddr_(&ptt) - 
		1], &listea_1.car[ptt - 1], err, &f1[1], &f2[1], &f3[1], &f4[
		1], &w1[1], &w2[1]);
    } else if (nb2 == nb4) {
	genban_(&nb1, &nb2, &nb3, &nb4, &x1[1], &y1[1], &x2[1], &y2[1], &x3[1]
		, &y3[1], &x4[1], &y4[1], nssd, &listea_1.car[cddddr_(&ptt) - 
		1], &listea_1.car[ptt - 1], err, &f1[1], &f2[1], &f3[1], &f4[
		1], &w1[1], &w2[1]);
    } else {
	s_wsle(&io___2021);
	do_lio(&c__9, &c__1, " erreur ", 8L);
	do_lio(&c__3, &c__1, (char *)&nb1, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nb2, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nb3, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&nb4, (ftnlen)sizeof(integer));
	e_wsle();
	scrtch_(" Nb de point invalide ", 22L);
	*err = 500;
	return 0;
    }
    return 0;
} /* gmshq0_ */




/* Subroutine */ int gmshqq_(integer *nb1, integer *nb2, integer *nb3, 
	integer *nb4, real *x1, real *y1, real *x2, real *y2, real *x3, real *
	y3, real *x4, real *y4, integer *nssd, integer *opti, integer *decoup,
	 integer *err, real *f1, real *f2, real *f3, real *f4, integer *w1, 
	integer *w2)
{
    /* Initialized data */

    /*static*/ integer idc[12]	/* was [3][2][2] */ = { 1,3,4,3,1,2,2,4,1,4,2,
	    3 };

    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer choix, quadr;

    real l1, l2, l3, l4, w;
    integer i, ii[4], nbpcom;
    real ld2, ld1;

    real det;
    integer ijk;

    integer nbt0, nbt1;
    real ff1[2], ff2[2], ff3[2], ff4[2], xc, yc;
    integer j, k;
    real xx, yy;
    integer nbs1;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), rcpnts_(integer *, 
	    real *, integer *, real *, integer *, integer *, integer *, real *
	    , integer *, integer *, integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2044 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2045 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2055 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2056 = { 0, 6, 0, 0, 0 };


/*       1------->n1 */
/*    1              1 */
/*    |              | */
/*    |              | */
/*    |              | */
/*    |              | */
/*    v              v */
/*    n4 1------->n3 n2 */

/*     visualisation d'un quadrangle avec les lignes interieures */


    /* Parameter adjustments */
    --w2;
    --w1;
    --f4;
    --f3;
    --f2;
    --f1;
    --y4;
    --x4;
    --y3;
    --x3;
    --y2;
    --x2;
    --y1;
    --x1;

    /* Function Body */
    if (*decoup == 310) {
	quadr = 1;
    } else {
	quadr = 0;
    }
/* c      print *,' decoup = ',decoup,' option = ',opti */
/* c      print *,' nbs = ',nbs,nb1,nb2,nb3,nb4, */
    nbs1 = bdmsh1_1.nbs;
    if (bdmsh1_1.nbs + *nb1 * *nb2 > bdmsh0_1.nbpmx) {
	scrtch_("ERREUR gmshqq ( genere mesh quadrangle): trop de point a ge"
		"ner", 62L);
	return 0;
    }
    l1 = 0.f;
    i__1 = *nb1 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x1[i + 1] - x1[i];
/* Computing 2nd power */
	r__2 = y1[i + 1] - y1[i];
	l1 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L1: */
    }
    l2 = 0.f;
    i__1 = *nb2 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x2[i + 1] - x2[i];
/* Computing 2nd power */
	r__2 = y2[i + 1] - y2[i];
	l2 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L2: */
    }
    l3 = 0.f;
    i__1 = *nb3 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x3[i + 1] - x3[i];
/* Computing 2nd power */
	r__2 = y3[i + 1] - y3[i];
	l3 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L3: */
    }
    l4 = 0.f;
    i__1 = *nb4 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x4[i + 1] - x4[i];
/* Computing 2nd power */
	r__2 = y4[i + 1] - y4[i];
	l4 += sqrt(r__1 * r__1 + r__2 * r__2);
/* L4: */
    }
    w = 0.f;
    f1[1] = 0.f;
    i__1 = *nb1 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x1[i + 1] - x1[i];
/* Computing 2nd power */
	r__2 = y1[i + 1] - y1[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f1[i + 1] = w / l1;
/* L10: */
    }
    w = 0.f;
    f2[1] = 0.f;
    i__1 = *nb2 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x2[i + 1] - x2[i];
/* Computing 2nd power */
	r__2 = y2[i + 1] - y2[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f2[i + 1] = w / l2;
/* L20: */
    }
    w = 0.f;
    f3[1] = 0.f;
    i__1 = *nb3 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x3[i + 1] - x3[i];
/* Computing 2nd power */
	r__2 = y3[i + 1] - y3[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f3[i + 1] = w / l3;
/* L30: */
    }
    w = 0.f;
    f4[1] = 0.f;
    i__1 = *nb4 - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = x4[i + 1] - x4[i];
/* Computing 2nd power */
	r__2 = y4[i + 1] - y4[i];
	w += sqrt(r__1 * r__1 + r__2 * r__2);
	f4[i + 1] = w / l4;
/* L40: */
    }
    i__1 = *nb1;
    for (i = 1; i <= i__1; ++i) {
	ff1[0] = x1[i];
	ff1[1] = y1[i];
	ff3[0] = x3[i];
	ff3[1] = y3[i];
	i__2 = *nb2;
	for (j = 1; j <= i__2; ++j) {
	    xc = ((*nb2 - j) * f1[i] + (j - 1) * f3[i]) / (*nb2 - 1);
	    yc = ((*nb1 - i) * f4[j] + (i - 1) * f2[j]) / (*nb1 - 1);
	    ff2[0] = x2[j];
	    ff2[1] = y2[j];
	    ff4[0] = x4[j];
	    ff4[1] = y4[j];
	    xx = (1.f - yc) * ff1[0] + xc * ff2[0] + yc * ff3[0] + (1 - xc) * 
		    ff4[0] - ((1 - xc) * (1 - yc) * x4[1] + xc * (1 - yc) * 
		    x1[*nb1] + xc * yc * x2[*nb2] + (1 - xc) * yc * x3[1]);
	    yy = (1.f - yc) * ff1[1] + xc * ff2[1] + yc * ff3[1] + (1 - xc) * 
		    ff4[1] - ((1 - xc) * (1 - yc) * y4[1] + xc * (1 - yc) * 
		    y1[*nb1] + xc * yc * y2[*nb2] + (1 - xc) * yc * y3[1]);
	    ++nbs1;
	    bdmsh5_1.cr[(nbs1 << 1) - 2] = xx;
	    bdmsh5_1.cr[(nbs1 << 1) - 1] = yy;
/* L101: */
	}
/* L100: */
    }
/* c    on recolle les point du maillage --- avec les points existant */
    i__1 = nbs1 - bdmsh1_1.nbs;
    rcpnts_(&c__2, bdmsh5_1.cr, &bdmsh1_1.nbs, &bdmsh5_1.cr[(bdmsh1_1.nbs + 1 
	    << 1) - 2], &i__1, &w1[1], &w1[bdmsh1_1.nbs + 1], &c_b3716, &w2[1]
	    , &bdmsh1_1.nbs, &nbpcom);
    j = bdmsh1_1.nbs;
    i__1 = nbs1;
    for (i = bdmsh1_1.nbs + 1; i <= i__1; ++i) {
	if (w1[i] > bdmsh1_1.nbs || w1[i] <= 0) {
	    ++j;
	    w1[i] = j;
	    bdmsh5_1.cr[(j << 1) - 2] = bdmsh5_1.cr[(i << 1) - 2];
	    bdmsh5_1.cr[(j << 1) - 1] = bdmsh5_1.cr[(i << 1) - 1];
	    bdmsh8_1.refs[j - 1] = 0;
	}
/* L130: */
    }
    if (nbs1 - j != *nb1 + *nb2 + *nb3 + *nb4 - 4) {
	scrtch_("++ le nb de points recolles <>   du nb points frontieres ", 
		57L);
	s_wsle(&io___2044);
	do_lio(&c__9, &c__1, "  nb de points recolles = ", 26L);
	i__1 = nbs1 - j;
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___2045);
	do_lio(&c__9, &c__1, "  nb points frontieres  =", 25L);
	i__1 = *nb1 + *nb2 + *nb3 + *nb4 - 4;
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	e_wsle();
	*err = -101;
    }
/* -------------------------- */
    nbs1 = j;
    nbt0 = 0;
    nbt1 = 0;
    k = bdmsh1_1.nbs;
    i__1 = *nb1 - 1;
    for (i = 1; i <= i__1; ++i) {
	i__2 = *nb2 - 1;
	for (j = 1; j <= i__2; ++j) {
	    ++k;
	    ii[0] = w1[k];
	    ii[1] = w1[k + 1];
	    ii[3] = w1[k + *nb2];
	    ii[2] = w1[k + *nb2 + 1];
	    if (*opti == 1) {
		choix = 1;
	    } else if (*opti == 2) {
		choix = 2;
	    } else {
/*    ----    on decoupe avec la plus courte diagonale  -----
-- */
/* Computing 2nd power */
		r__1 = bdmsh5_1.cr[(ii[0] << 1) - 2] - bdmsh5_1.cr[(ii[2] << 
			1) - 2];
/* Computing 2nd power */
		r__2 = bdmsh5_1.cr[(ii[0] << 1) - 1] - bdmsh5_1.cr[(ii[2] << 
			1) - 1];
		ld1 = r__1 * r__1 + r__2 * r__2;
/* Computing 2nd power */
		r__1 = bdmsh5_1.cr[(ii[1] << 1) - 2] - bdmsh5_1.cr[(ii[3] << 
			1) - 2];
/* Computing 2nd power */
		r__2 = bdmsh5_1.cr[(ii[1] << 1) - 1] - bdmsh5_1.cr[(ii[3] << 
			1) - 1];
		ld2 = r__1 * r__1 + r__2 * r__2;
		if (ld2 - ld1 < -(doublereal)(ld2 + ld1) / 1e4f) {
		    choix = 2;
		} else {
		    choix = 1;
		}
	    }
	    for (ijk = 1; ijk <= 2; ++ijk) {
		++bdmsh1_1.nbt;
		bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 6] = ii[idc[(ijk + (choix << 
			1)) * 3 - 9] - 1];
		bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 5] = ii[idc[(ijk + (choix << 
			1)) * 3 - 8] - 1];
		bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 4] = ii[idc[(ijk + (choix << 
			1)) * 3 - 7] - 1];
		bdmshb_1.apavue[bdmsh1_1.nbt - 1] = quadr;
		det = (bdmsh5_1.cr[(bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 5] << 1) 
			- 2] - bdmsh5_1.cr[(bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 
			6] << 1) - 2]) * (bdmsh5_1.cr[(bdmsh9_1.nsea[
			bdmsh1_1.nbt * 6 - 4] << 1) - 1] - bdmsh5_1.cr[(
			bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 6] << 1) - 1]) - (
			bdmsh5_1.cr[(bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 5] << 1)
			 - 1] - bdmsh5_1.cr[(bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 
			6] << 1) - 1]) * (bdmsh5_1.cr[(bdmsh9_1.nsea[
			bdmsh1_1.nbt * 6 - 4] << 1) - 2] - bdmsh5_1.cr[(
			bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 6] << 1) - 2]);
		if (det < 0.f) {
		    bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 6] = ii[idc[(ijk + (
			    choix << 1)) * 3 - 8] - 1];
		    bdmsh9_1.nsea[bdmsh1_1.nbt * 6 - 5] = ii[idc[(ijk + (
			    choix << 1)) * 3 - 9] - 1];
		    ++nbt0;
		} else {
		    ++nbt1;
		}
		bdmsha_1.reft[bdmsh1_1.nbt - 1] = *nssd;
/* L190: */
	    }
/* L200: */
	}
	++k;
/* L210: */
    }
    bdmsh1_1.nbs = nbs1;
    if (nbt1 * nbt0 != 0) {
	s_wsle(&io___2055);
	do_lio(&c__9, &c__1, " nb de triangles positif =", 26L);
	do_lio(&c__3, &c__1, (char *)&nbt1, (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___2056);
	do_lio(&c__9, &c__1, " nb de triangles negatif =", 26L);
	do_lio(&c__3, &c__1, (char *)&nbt0, (ftnlen)sizeof(integer));
	e_wsle();
	*err = -100;
	scrtch_(" ERREUR maillage quadrangle element < 0 ", 40L);
    }
    return 0;
} /* gmshqq_ */




/* Subroutine */ int gnin_(real *cc, real *xc, real *yc, integer *nbnod, real 
	*res)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    double pow_ri(real *, integer *), cos(doublereal), sin(doublereal);

    /* Local variables */
    integer indx;
    real long_;

    real *acurv=0;
    integer j, i, n, nbgen;
    real dlong, dd;
    real dalpha, rap, dx, dy, xx, yy;
    integer ptt;
    real densit, * xsp=0,* ysp=0;
    extern /* Subroutine */ int scrtch_(char *, ftnlen), acursp_(real *, real 
	    *, integer *, real *, real *, integer *, real *, real *);


/*     genere les points intermediaire de l'element cc(0:5) */
/*     dans xc,yc  avec la raison res (il ne genere pas les points extrem 
*/
/*       peut modifier nbnod..... */


/*     +    ,xgen(maxgen),ygen(maxgen),cumul */
/*      integer tgen(1:mxpdef) */
    /* Parameter adjustments */
     if( !(acurv = (real*) malloc(sizeof(real)*100))) goto LA999;
     if( !(xsp = (real*) malloc(sizeof(real)*501))) goto LA999;
     if( !(ysp = (real*) malloc(sizeof(real)*501))) goto LA999;
     
    --yc;
    --xc;

    /* Function Body */
    if (cc[0] == -2.f) {
	if (*nbnod > 2) {
	    if (*res == 1.f) {
		dalpha = cc[5] / (*nbnod - 1);
	    } else {
		i__1 = *nbnod - 1;
		rap = (*res - 1.f) / (pow_ri(res, &i__1) - 1.f);
		dalpha = cc[5] * rap;
	    }
	    dd = 0.f;
	    dx = cc[3] - cc[1];
	    dy = cc[4] - cc[2];
/* Computing MIN */
	    i__2 = *nbnod - 2;
	    i__1 = min(i__2,1000);
	    for (j = 1; j <= i__1; ++j) {
		dd += dalpha;
		xc[j] = cc[1] + dx * cos(dd) - dy * sin(dd);
		yc[j] = cc[2] + dx * sin(dd) + dy * cos(dd);
		dalpha *= *res;
/* L31: */
	    }
	}
    } else if (cc[0] == -3.f) {
	if (*nbnod > 2) {
	    if (*res == 1.f) {
		dx = (cc[3] - cc[1]) / (*nbnod - 1);
		dy = (cc[4] - cc[2]) / (*nbnod - 1);
	    } else {
		i__1 = *nbnod - 1;
		rap = (*res - 1.f) / (pow_ri(res, &i__1) - 1.f);
		dx = (cc[3] - cc[1]) * rap;
		dy = (cc[4] - cc[2]) * rap;
	    }
	    xx = cc[1];
	    yy = cc[2];
/* Computing MIN */
	    i__2 = *nbnod - 2;
	    i__1 = min(i__2,1000);
	    for (i = 1; i <= i__1; ++i) {
		xx += dx;
		yy += dy;
		xc[i] = xx;
		yc[i] = yy;
		dx *= *res;
		dy *= *res;
/* L1: */
	    }
	}
    } else if (cc[0] == -4.f) {
	ptt = cc[2];
	n = 0;
L3:
	if (ptt != 0) {
	    ++n;
	    if (n <= 500) {
		xsp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 385];
		ysp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 386];
		ptt = listed_1.cdr[ptt - 1];
		goto L3;
	    }
	}
	densit = 1.f;
	eps_1.eps = 1e-5f;
/* x7       continue */
/* x        call genspl(xsp,ysp,n,eps,densit,xgen,ygen,maxgen */
/* x     +                                     ,nbgen,tgen) */
/* xc        print*,'gninsp:densit=',densit,' nbgen=',nbgen */
/* x        if(nbgen.eq.maxgen)then */
/* x          densit=densit/2. */
/* x          goto 7 */
/* x        endif */
	if (*nbnod > 2) {
/* x          long=0. */
/* x          do 4 i=1,nbgen-1 */
/* x           long=long+sqrt((xgen(i)-xgen(i+1))**2+(ygen(i)-ygen
(i+1))** */
/* x4         continue */
	    long_ = 1.f;
	    if (*res == 1.f) {
		dlong = long_ / (*nbnod - 1);
	    } else {
		i__1 = *nbnod - 1;
		rap = (*res - 1.f) / (pow_ri(res, &i__1) - 1.f);
		dlong = long_ * rap;
	    }
/* x          indx=1 */
/* xc         longueur sur intermediaires */
	    long_ = 0.f;
/* xc         longueur sur generes */
/* x          cumul=0. */
/* x          do 5 i=1,min(nbnod-2,mxnode) */
/* x            long=long+dlong */
/* x6           continue */
/* x            dx=xgen(indx+1)-xgen(indx) */
/* x            dy=ygen(indx+1)-ygen(indx) */
/* x            dd=sqrt(dx**2+dy**2) */
/* x            if(cumul+dd.lt.long)then */
/* x              if(indx.lt.nbgen)then */
/* x                indx=indx+1 */
/* x                cumul=cumul+dd */
/* x                goto 6 */
/* x              endif */
/* x            endif */
/* x            xc(i)=xgen(indx)+dx*abs(long-cumul)/dd */
/* x            yc(i)=ygen(indx)+dy*abs(long-cumul)/dd */
/* x            dlong=dlong*res */
/* x5         continue */
/* x        endif */
	    indx = 1;
L100:
/* Computing MIN */
	    i__1 = 100, i__2 = *nbnod - 2 - indx + 1;
	    nbgen = min(i__1,i__2);
	    if (nbgen > 0) {
		i__1 = nbgen;
		for (i = 1; i <= i__1; ++i) {
		    long_ += dlong;
		    acurv[i - 1] = long_;
		    dlong *= *res;
/* L90: */
		}
		if (indx + nbgen > *nbnod) {
		    scrtch_("ERREUR GNIN: trop de points", 27L);
		    goto LA999;
		}
		acursp_(xsp, ysp, &n, &eps_1.eps, acurv, &nbgen, &xc[indx], &
			yc[indx]);
		indx += nbgen;
		goto L100;
	    }
	}
    } else {
	*nbnod = 0;
    }
    LA999:
    free(acurv);free(ysp);free(xsp);
    return 0;
} /* gnin_ */




/* Subroutine */ int gnop5_(integer *nop5, integer *lnop5, integer *nef, 
	integer *lgpdn, integer *err)
{
    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Local variables */
    integer imin, imax, inig, somm, i, j;

    integer i5, l5, i11, jb;
    extern integer rfsomm_(integer *), mshele_(integer *, integer *, integer *
	    );
    integer ra4[4], no5l[20];


/* construction du tableau nop5 de nopo pour une triangulation donnee par 
*/

    /* Parameter adjustments */
    --nop5;

    /* Function Body */
    *lgpdn = 0;
    *nef = 0;
    i5 = 0;
    i__1 = bdmsh1_1.nbt;
    for (j = 1; j <= i__1; ++j) {
	imin = bdmsh1_1.nbsrft;
	imax = 0;
	no5l[3] = mshele_(&j, &no5l[4], ra4);
	if (no5l[3] != 0) {
	    no5l[0] = no5l[3];
	    no5l[2] = bdmshf_1.refsd[bdmsha_1.reft[j - 1] - 1];
	    inig = no5l[3] + 5;
	    no5l[inig - 1] = 4;
	    i11 = inig + no5l[3];
	    i__2 = no5l[3];
	    for (jb = 1; jb <= i__2; ++jb) {
		somm = no5l[jb + 3];
		no5l[i11 + jb - 1] = rfsomm_(&somm);
		if (no5l[i11 + jb - 1] != 0) {
/* Computing MIN */
		    i__3 = no5l[inig - 1];
		    no5l[inig - 1] = min(i__3,3);
		}
		no5l[inig + jb - 1] = ra4[jb - 1];
		if (no5l[inig + jb - 1] != 0) {
		    no5l[inig - 1] = 2;
		}
		imin = min(imin,somm);
		imax = max(imax,somm);
/* L10: */
	    }
	    if (no5l[inig - 1] == 3) {
		i__2 = no5l[3];
		for (i = 1; i <= i__2; ++i) {
		    no5l[inig + i - 1] = no5l[i11 + i - 1];
/* L15: */
		}
		no5l[1] = no5l[3] + 1;
	    } else if (no5l[inig - 1] == 2) {
		no5l[1] = (no5l[3] << 1) + 1;
	    } else {
		no5l[1] = 0;
	    }
	    if (no5l[1] != 0) {
		++(*nef);
	    }
/* Computing MAX */
	    i__2 = *lgpdn, i__3 = imax - imin + 1;
	    *lgpdn = max(i__2,i__3);
	    l5 = inig - 1 + no5l[1];
	    if (i5 + l5 > *lnop5) {
		*err = 1;
		i5 += l5;
	    } else {
		i__2 = l5;
		for (i = 1; i <= i__2; ++i) {
		    ++i5;
		    nop5[i5] = no5l[i - 1];
/* L20: */
		}
	    }
	}
/* L30: */
    }
    *lnop5 = i5;
    return 0;
} /* gnop5_ */




/* Subroutine */ int inicol_(void)
{
    /* Initialized data */

    /*static*/ real fondx[3] = { 1.f,1.f,1.f };
    /*static*/ real nfondx[3] = { 0.f,0.f,0.f };
    /*static*/ real rougex[3] = { 1.f,0.f,0.f };
    /*static*/ real vertx[3] = { 0.f,1.f,0.f };
    /*static*/ real bleux[3] = { 0.f,0.f,1.f };
    /*static*/ real jaunex[3] = { 1.f,1.f,0.f };
    /*static*/ real magenx[3] = { 1.f,0.f,1.f };
    /*static*/ real cyanx[3] = { 0.f,1.f,1.f };
    /*static*/ real rougcx[3] = { 1.f,.75f,.75f };
    /*static*/ real vertcx[3] = { .75f,1.f,.75f };
    /*static*/ real bleucx[3] = { .75f,.75f,1.f };
    /*static*/ real jauncx[3] = { 1.f,1.f,.75f };
    /*static*/ real magecx[3] = { 1.f,.75f,1.f };
    /*static*/ real cyancx[3] = { .75f,1.f,1.f };
    /*static*/ real rougsx[3] = { .75f,.0f,.0f };
    /*static*/ real vertsx[3] = { .0f,.6f,.0f };
    /*static*/ real bleusx[3] = { .0f,.0f,.75f };
    /*static*/ real jaunsx[3] = { .5f,.5f,.0f };
    /*static*/ real magesx[3] = { .6f,.0f,.6f };
    /*static*/ real cyansx[3] = { .0f,.6f,.6f };

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer maxi, ires;
    real *b=0;
    integer i, j;
    real *r=0, *v=0;
    integer nbcol;
    extern /* Subroutine */ int inbcol_(integer *), inqtbc_(real *, real *, 
	    real *, integer *, integer *), settbc_(real *, real *, real *, 
	    integer *, integer *, integer *);
    extern integer zfndtc_(real *, real *, real *, real *, real *, real *, 
	    integer *);
    extern logical zlintm_(real *, real *, real *, integer *);
    extern /* Subroutine */ int zivrvb_(real *, real *, real *, real *, real *
	    , real *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2121 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2123 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2124 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2125 = { 0, 6, 0, 0, 0 };


/*     INIT DES COULEURS */
/*     CALCUL L'INDEX DANS LA TABLE DES COULEURS DES COULEURS */
/*      DONT ON AURA BESOIN */
/*        MXCOU INTERVIENT DANS: INICOL INIISO COULRF */
/*     COULEUR DU FOND */
/*     OPPOSEE DE LA COULEUR DU FOND */
/*               COULEUR DES REFERENCES */


     if(!( r = (real*) malloc(sizeof(real)*257))) goto LA999;
     if(!( v = (real*) malloc(sizeof(real)*257))) goto LA999;
     if(!( b = (real*) malloc(sizeof(real)*257))) goto LA999;


    for (i = 1; i <= 3; ++i) {
	ctabc3_1.color[i - 1] = fondx[i - 1];
	ctabc3_1.color[i + 2] = nfondx[i - 1];
	ctabc3_1.color[i + 5] = rougex[i - 1];
	ctabc3_1.color[i + 8] = vertx[i - 1];
	ctabc3_1.color[i + 11] = bleux[i - 1];
	ctabc3_1.color[i + 14] = jaunex[i - 1];
	ctabc3_1.color[i + 17] = magenx[i - 1];
	ctabc3_1.color[i + 20] = cyanx[i - 1];
	ctabc3_1.color[i + 23] = rougcx[i - 1];
	ctabc3_1.color[i + 26] = vertcx[i - 1];
	ctabc3_1.color[i + 29] = bleucx[i - 1];
	ctabc3_1.color[i + 32] = jauncx[i - 1];
	ctabc3_1.color[i + 35] = magecx[i - 1];
	ctabc3_1.color[i + 38] = cyancx[i - 1];
	ctabc3_1.color[i + 41] = rougsx[i - 1];
	ctabc3_1.color[i + 44] = vertsx[i - 1];
	ctabc3_1.color[i + 47] = bleusx[i - 1];
	ctabc3_1.color[i + 50] = jaunsx[i - 1];
	ctabc3_1.color[i + 53] = magesx[i - 1];
	ctabc3_1.color[i + 56] = cyansx[i - 1];
/* L7: */
    }
/*     DEMANDE LE NOMBRE MAXI DE COULEURS */
    inbcol_(&nbcol);
/*     DEMANDE LA TABLE DE COULEURS */
    nbcol = min(nbcol,256);
    maxi = min(nbcol,20);
    i__1 = nbcol - 1;
    inqtbc_(r, v, b, &c__0, &i__1);
    i__1 = nbcol - 1;
    settbc_(r, v, b, &c__0, &i__1, &ires);
/*       COULEUR DU FOND */
    ctabc3_1.color[0] = r[0];
    ctabc3_1.color[1] = v[0];
    ctabc3_1.color[2] = b[0];
    ctabco_2.coulls[0] = 0;
/*       OPPOSEE DE LA COULEUR DU FOND */
    zivrvb_(r, v, b, &ctabc3_1.color[3], &ctabc3_1.color[4], &ctabc3_1.color[
	    5]);
    if (ires != 0) {
/*       TABLE DE COULEUR NON MODIFIABLE */
/*       =============================== */
/*       ANALYSE DE LA TABLE DE COULEUR POUR DETECTER SI ON A AFFAIRE 
*/
/*       A UN TERMINAL LINEAIRE EN COULEURS */
	if (zlintm_(r, v, b, &nbcol)) {
	    s_wsle(&io___2121);
	    do_lio(&c__9, &c__1, "INICOL: TERMINAL EN GRISE NON MODIFIABLE N"
		    "BCOL=", 47L);
	    do_lio(&c__3, &c__1, (char *)&nbcol, (ftnlen)sizeof(integer));
	    e_wsle();
	    ctabc3_1.color[0] = r[0];
	    ctabc3_1.color[1] = v[0];
	    ctabc3_1.color[2] = b[0];
	    ctabco_2.coulls[0] = 0;
	    for (j = 2; j <= 20; ++j) {
		ctabc3_1.color[j * 3 - 3] = r[nbcol - 1];
		ctabc3_1.color[j * 3 - 2] = v[nbcol - 1];
		ctabc3_1.color[j * 3 - 1] = b[nbcol - 1];
		ctabco_2.coulls[j - 1] = nbcol - 1;
/* L6: */
	    }
	} else {
	    s_wsle(&io___2123);
	    do_lio(&c__9, &c__1, "INICOL: TERMINAL COULEUR NON MODIFIABLE NB"
		    "COL=", 46L);
	    do_lio(&c__3, &c__1, (char *)&nbcol, (ftnlen)sizeof(integer));
	    e_wsle();
	    for (i = 2; i <= 20; ++i) {
/*           RECHERCHE DE LA COULEUR LA PLUS PROCHE */
		ctabco_2.coulls[i - 1] = zfndtc_(&ctabc3_1.color[i * 3 - 3], &
			ctabc3_1.color[i * 3 - 2], &ctabc3_1.color[i * 3 - 1],
			 r, v, b, &nbcol);
/*            PRINT*,' I=',I,' COLOR=',COLOR(1,I),COLOR(2,I),C
OLOR(3,I) */
/*     +            ,'  COULLS=',COULLS(I) */
/* L1: */
	    }
/*          PRINT*,'R=',(R(K),K=0,NBCOL-1) */
/*          PRINT*,'V=',(V(K),K=0,NBCOL-1) */
/*          PRINT*,'B=',(B(K),K=0,NBCOL-1) */
	}
    } else {
/*       TABLE DE COULEUR MODIFIABLE */
/*       =========================== */
/*       ANALYSE DE LA TABLE DE COULEUR POUR DETECTER SI ON A AFFAIRE 
*/
/*       A UN TERMINAL LINEAIRE EN COULEURS */
	if (zlintm_(r, v, b, &nbcol)) {
	    s_wsle(&io___2124);
	    do_lio(&c__9, &c__1, "INICOL: TERMINAL EN GRISE MODIFIABLE NBCOL="
		    , 43L);
	    do_lio(&c__3, &c__1, (char *)&nbcol, (ftnlen)sizeof(integer));
	    e_wsle();
	    ctabc3_1.color[0] = r[0];
	    ctabc3_1.color[1] = v[0];
	    ctabc3_1.color[2] = b[0];
	    ctabco_2.coulls[0] = 0;
	    for (j = 2; j <= 20; ++j) {
		ctabc3_1.color[j * 3 - 3] = r[nbcol - 1];
		ctabc3_1.color[j * 3 - 2] = v[nbcol - 1];
		ctabc3_1.color[j * 3 - 1] = b[nbcol - 1];
		ctabco_2.coulls[j - 1] = nbcol - 1;
/* L60: */
	    }
	} else {
	    s_wsle(&io___2125);
	    do_lio(&c__9, &c__1, "INICOL: TERMINAL COULEUR MODIFIABLE NBCOL=",
		     42L);
	    do_lio(&c__3, &c__1, (char *)&nbcol, (ftnlen)sizeof(integer));
	    e_wsle();
/*         DANS INIISO, IL NE FAUT PAS MODIFIER CES COULEURS */
	    i__1 = maxi;
	    for (i = 2; i <= i__1; ++i) {
		r[i - 1] = ctabc3_1.color[i * 3 - 3];
		v[i - 1] = ctabc3_1.color[i * 3 - 2];
		b[i - 1] = ctabc3_1.color[i * 3 - 1];
		ctabco_2.coulls[i - 1] = i - 1;
/* L3: */
	    }
	    if (maxi < 20) {
		for (i = maxi + 1; i <= 20; ++i) {
		    ctabco_2.coulls[i - 1] = ctabco_2.coulls[i % (maxi - 1) + 
			    1];
/* L9: */
		}
	    }
/*         ON FORCE LA TABLE DE COULEUR */
	    i__1 = maxi - 1;
	    settbc_(r, v, b, &c__0, &i__1, &ires);
	}
    }
    LA999:
     free(r);free(v);free(b);
    return 0;
} /* inicol_ */

/*     f_lisp */
/* Subroutine */ int inilst_(void)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i;


/*     initialise les listes */


    i__1 = listes_1.mxlist;
    for (i = 1; i <= i__1; ++i) {
	listed_1.cdr[i - 1] = i + 1;
	listea_1.car[i - 1] = 0;
/* L1: */
    }
    listed_1.cdr[listes_1.mxlist - 1] = 0;
    listes_1.free = 1;
    return 0;
} /* inilst_ */

/* Subroutine */ int inimn_(void)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    integer numn, i, j;


#ifdef FRENCH


    for (j = 1; j <= 16; ++j) {
	pec_1.acmenu[j - 1] = FALSE_;
	for (i = 1; i <= 32; ++i) {
	    pec_1.flcase[i + (j << 5) - 33] = FALSE_;
	    pec_1.mkcase[i + (j << 5) - 33] = 0;
/* L999: */
	}
/* L998: */
    }
/* -----------------------------------------------------------------------
 */
/* ----------- attention designation doit connaitre le numero des cases de
 */
/* -----------------------------------------------------------------------
 */

/*                 ---------  menu 1 (types a designer)(en bas) -------- 
*/
/*                                (pour construction et maillage) */
    numn = 1;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_CONSTR", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT/p", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 301;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DROITE/d", 16L, 8L)
	    ;
/*     txcase(i, numn)='STRT LINE/l'                                    #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 302;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CERCLE/c", 16L, 8L)
	    ;
/*     txcase(i, numn)='CIRCLE/c'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 303;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMT/s", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "P MOUSE/m", 16L, 
	    9L);
/*     txcase(i,numn)='MOUSE P/m'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PT XY/x", 16L, 7L);
/*     txcase(i,numn)='XY PT/x'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Fi_XY/<", 16L, 7L);
/*     txcase(i,numn)='XY FILE/<'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 314;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QLCONQ/q", 16L, 8L)
	    ;
/*     txcase(i,numn)='ANY/q'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "+ PROCHE\\p", 16L, 
	    10L);
/*     txcase(i,numn)='NEAREST ^n'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTREM\\e", 16L, 
	    8L);
/*     txcase(i,numn)='EXTREM ^e'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 352;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTRE\\c", 16L, 
	    8L);
/*     txcase(i,numn)='CENTER\\c'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 353;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MILIEU\\m", 16L, 
	    8L);
/*     txcase(i,numn)='MIDDLE ^m'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 354;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERS/i", 16L, 8L)
	    ;
/*     txcase(i,numn)='INTERS/i'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 355;
/*       ... ne pas affecter 306 car  '='  est defini dans calcule */
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L1: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*               ---------  menu 2 (gestion ecran)( a droite) -------- */
    numn = 2;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "GESTION_ECRAN", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ZOOM +", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 401;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ZOOM -", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 402;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLATION", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 403;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ECHELLE", 16L, 7L);
/*     txcase(i, numn)='SCALE'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 404;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAFRAICHIR", 16L, 
	    10L);
/*     txcase(i, numn)='REFRESH'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 405;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "C_MASQUE", 16L, 8L)
	    ;
/*     txcase(i, numn)='C_MASK'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 406;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PRECEDENTE", 16L, 
	    10L);
/*     txcase(i, numn)='PREVIOUS'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 407;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SUIVANTE", 16L, 8L)
	    ;
/*     txcase(i, numn)='NEXT'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 408;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "VOIR_TOUT", 16L, 
	    9L);
/*     txcase(i, numn)='SHOW_ALL'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 409;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L2: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = i;
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*     nombre de colonnes */
/*             ---------  menu 3 (generalitees) (a gauche) -------- */
    numn = 3;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "GENERAUX", 16L, 8L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "FINIR ^z", 16L, 8L)
	    ;
/*     txcase(i, numn)='QUIT ^z'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 501;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERROGER", 16L, 
	    10L);
/*     txcase(i, numn)='QUERY'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 502;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DETRUIRE", 16L, 8L)
	    ;
/*     txcase(i, numn)='DESTRUCT'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 503;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SAUVER", 16L, 6L);
/*     txcase(i, numn)='SAVE'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 504;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RESTAURER", 16L, 
	    9L);
/*     txcase(i, numn)='RESTORE'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 505;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAZ_BD", 16L, 6L);
/*     txcase(i, numn)='RESET_DB'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 506;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HARD_COPY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 507;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SOFT_COPY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 508;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SHELL", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 509;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRACE", 16L, 5L);
/*     txcase(i, numn)='LOG FILE'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 510;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERPRETE", 16L, 
	    10L);
/*     txcase(i, numn)='INTERPRET'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 512;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CONSTRUCTION", 16L,
	     12L);
    pec_1.vcase[i + (numn << 5) - 33] = 511;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PREP_MESH", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 513;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EDIT_MESH", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 514;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L3: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = i;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 4 (creation) (en haut) -------- */
    numn = 4;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "CONSTRUCTION", 16L, 12L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 601;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CERCLE", 16L, 6L);
/*     txcase(i,numn)='CIRCLE'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 603;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 604;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARRONDI", 16L, 7L);
/*     txcase(i,numn)='ROUND'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 610;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTRE", 16L, 6L);
/*     txcase(i,numn)='CENTER'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 607;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DISTANCE", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 608;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RETOURNER", 16L, 
	    9L);
/*     txcase(i,numn)='SWAP'                                            #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 618;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COMPLE_ARC", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 619;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COUPER", 16L, 6L);
/*     txcase(i,numn)='CUT'                                             #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 621;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "AJOUTER", 16L, 7L);
/*     txcase(i,numn)='ADD'                                             #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 625;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAPPORT", 16L, 7L);
/*     txcase(i,numn)='RATIO'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 617;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ROTATION", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 611;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SYMETRIE", 16L, 8L)
	    ;
/*     txcase(i,numn)='SYMMETRY'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 613;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DROITE", 16L, 6L);
/*     txcase(i,numn)='STRT LINE'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 602;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 605;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 624;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CONTOURAGE", 16L, 
	    10L);
/*     txcase(i,numn)='OUTLINE'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 622;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAYON", 16L, 5L);
/*     txcase(i,numn)='RADIUS'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 606;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANGLE", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 609;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INVERSER", 16L, 8L)
	    ;
/*     txcase(i,numn)='INVERT'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 620;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "FONDRE", 16L, 6L);
/*     txcase(i,numn)='MERGE'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 626;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CHANGER", 16L, 7L);
/*     txcase(i,numn)='CHANGE'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 623;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "IDEM", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 615;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NOMBRE", 16L, 6L);
/*     txcase(i,numn)='NUMBER'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 616;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLAT", 16L, 8L)
	    ;
/*     txcase(i,numn)='TRANSLAT'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 612;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HOMOTHETIE", 16L, 
	    10L);
/*     txcase(i,numn)='HOMOTHETY'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 614;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L4: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 5 (application 1 ) (en haut) -------- */
    numn = 5;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "APPLICATION_1", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L5: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 6 (application 2 ) (en haut) -------- */
    numn = 6;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "MAILLAGE", 16L, 8L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "LIGNE", 16L, 5L);
/*     txcase(i,numn)='LINE'                                            #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 701;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COMPOSANTE", 16L, 
	    10L);
/*     txcase(i,numn)='COMPONENT'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 710;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DEFISSURE", 16L, 
	    9L);
/*     txcase(i,numn)='UNCRACK'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 723;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAISON", 16L, 6L);
/*     txcase(i,numn)='RATIO'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 716;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REF_NOEUD", 16L, 
	    9L);
/*     txcase(i,numn)='NODE_REF'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 705;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REF_DOMAIN", 16L, 
	    10L);
/*     txcase(i,numn)='DOMAIN_REF'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 717;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DEF DOMAI", 16L, 
	    9L);
/*     txcase(i,numn)='DOMAIN DEF'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 714;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUADRANGLE", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 704;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REGULIER", 16L, 8L)
	    ;
/*     txcase(i,numn)='REGULAR'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 707;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RETIRER", 16L, 7L);
/*     txcase(i,numn)='REMOVE'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 719;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "VOIR", 16L, 4L);
/*     txcase(i,numn)='SHOW'                                            #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 713;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "GENERER", 16L, 7L);
/*     txcase(i,numn)='GENERATE'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 708;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DOMAINE", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 711;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TOUT", 16L, 4L);
/*     txcase(i,numn)='ALL'                                             #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 718;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "FISSURE ", 16L, 8L)
	    ;
/*     txcase(i,numn)='CRACK'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 722;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Nb_INTERVAL", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 702;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REF_LIGNE", 16L, 
	    9L);
/*     txcase(i,numn)='LINE_REF'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 706;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Lg_INTERVAL", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 721;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERIEUR", 16L, 
	    9L);
/*     txcase(i,numn)='INTERIOR'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 712;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRIANGLES", 16L, 
	    9L);
/*     txcase(i,numn)='TRIANGLES'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 703;
    ++i;
/*     txcase(i,numn)='COINS'                                           #G
B*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CORNERS", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 709;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "VERIFIER", 16L, 8L)
	    ;
/*     txcase(i,numn)='VERIFY'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 715;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "BANDES", 16L, 6L);
/*     txcase(i,numn)='STRIP'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 744;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Gen. Base", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 720;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	if (pec_1.vcase[j + (numn << 5) - 33] != 0) {
	    pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
	}
/* L6: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 7 (application 3 ) (en haut) -------- */
    numn = 7;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "MESH_PTG", 16L, 8L);
    i = 1;
/* ------------- premiere  ligne  --------- */
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REGULARISER", 16L, 
	    11L);
/*     txcase(i,numn)='REGULARIZE'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 802;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DELAUNAY", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 803;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "AJOUTER", 16L, 7L);
/*     txcase(i,numn)='ADD'                                             #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 804;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "BOUGER", 16L, 6L);
/*     txcase(i,numn)='MOVE'                                            #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 805;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SUPPRIMER", 16L, 
	    9L);
/*     txcase(i,numn)='SUPRESS'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 806;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RETOURNER", 16L, 
	    9L);
/*     txcase(i,numn)='SWAP'                                            #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 817;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MODIF_REF", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 812;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "FISSURE", 16L, 7L);
/*     txcase(i,numn)='CRACK'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 814;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRIANGULER", 16L, 
	    10L);
/*     txcase(i,numn)='TRIANGULATE'                                     #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 818;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANGLE MIN", 16L, 
	    9L);
/*     txcase(i,numn)='MIN ANGLE'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 820;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MARK ELEMENT", 16L,
	     12L);
    pec_1.vcase[i + (numn << 5) - 33] = 822;
/* ------------- seconde ligne */
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RENUMEROTER", 16L, 
	    11L);
/*     txcase(i,numn)='RENUMBER'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 816;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TOUT", 16L, 4L);
/*     txcase(i,numn)='ALL'                                             #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 813;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ORIGINAUX", 16L, 
	    9L);
/*     txcase(i,numn)='ORIGINALS'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 815;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EVALUER", 16L, 7L);
/*     txcase(i,numn)='EVALUATE'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 811;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ROTATION", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 807;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLATION", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 808;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SYMETRIE", 16L, 8L)
	    ;
/*     txcase(i,numn)='SYMMETRY'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 809;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HOMOTHETIE", 16L, 
	    10L);
/*     txcase(i,numn)='HOMOTHETY'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 810;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUADRANGULER", 16L,
	     12L);
/*     txcase(i,numn)='QUADRANGULATE'                                   #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 819;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANGLE MAX", 16L, 
	    9L);
/*     txcase(i,numn)='MAX ANGLE'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 821;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "FRONTIERE", 16L, 
	    9L);
/*     txcase(i,numn)='BOUNDARY'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 823;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = pec_1.vcase[j + (numn << 5) - 33]
		 != 0;
/* L7: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*                 ---------  menu  (types a designer)(en bas)  (mxmenu-4 
*/
/*                                (pour  maillage) */
    numn = 12;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_MAILLAGE", 16L, 15L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT/p", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 301;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT/s", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "P MOUSE/m", 16L, 
	    9L);
/*     txcase(i,numn)='MOUSE P/m'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PT XY/x", 16L, 7L);
/*     txcase(i,numn)='XY PT /x'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QLCONQ/q", 16L, 8L)
	    ;
/*     txcase(i,numn)='ANY/q'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "+ PROCHE\\p", 16L, 
	    10L);
/*     txcase(i,numn)='NEAREST ^n'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTREM\\e", 16L, 
	    8L);
/*     txcase(i,numn)='EXTREM ^e'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 352;
/*       ... ne pas affecter 306 car c'est '=' il est defini dans calcule 
*/
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L14: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             -------- designation (suite pour hecht) (mxmenu -3) (en ba 
*/
    numn = 13;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_MSHPTG", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SOMMET/v", 16L, 8L)
	    ;
/*     txcase(i,numn)='VERTEX/v'                                        #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 308;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARETE/l", 16L, 7L);
/*     txcase(i,numn)='EDGE/l'                                          #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 310;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ELEMENT/f", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 309;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "S_DOM/r", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 311;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT/s", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "P MOUSE/m", 16L, 
	    9L);
/*     txcase(i,numn)='MOUSE P/m'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PT XY/x", 16L, 7L);
/*     txcase(i,numn)='XY PT/x'                                         #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QLCONQ/q", 16L, 8L)
	    ;
/*     txcase(i,numn)='ANY/q'                                           #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "+ PROCHE\\p", 16L, 
	    10L);
/*     txcase(i,numn)='NEAREST ^n'                                      #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTERM \\e", 16L, 
	    9L);
/*     txcase(i,numn)='EXTERM ^e'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 352;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTRE\\c", 16L, 
	    8L);
/*     txcase(i,numn)='CENTER ^c'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 353;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MILIEU\\m", 16L, 
	    8L);
/*     txcase(i,numn)='MIDLLE ^m'                                       #G
B*/
    pec_1.vcase[i + (numn << 5) - 33] = 354;
/*       ... ne pas affecter 306 car c'est '=' il est defini dans calcule 
*/
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L13: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             -------- menux (mxmenu-2) (calculette zone affichage) */
    numn = 14;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), " ", 16L, 1L);
    pec_1.flcase[(numn << 5) - 32] = TRUE_;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 1;
/*             -------- menux (mxmenu-1) (calculette fonctions) (a droite 
*/
    numn = 15;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "F_CALCULETTE", 16L, 12L);
    s_copy(pectxt_1.txcase + ((numn << 5) - 32 << 4), "SIN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 32] = 9501;
    s_copy(pectxt_1.txcase + ((numn << 5) - 31 << 4), "COS", 16L, 3L);
    pec_1.vcase[(numn << 5) - 31] = 9502;
    s_copy(pectxt_1.txcase + ((numn << 5) - 30 << 4), "TAN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 30] = 9503;
    s_copy(pectxt_1.txcase + ((numn << 5) - 29 << 4), "ATAN", 16L, 4L);
    pec_1.vcase[(numn << 5) - 29] = 9504;
    s_copy(pectxt_1.txcase + ((numn << 5) - 28 << 4), "ATAN2", 16L, 5L);
    pec_1.vcase[(numn << 5) - 28] = 9505;
    s_copy(pectxt_1.txcase + ((numn << 5) - 27 << 4), "EXP", 16L, 3L);
    pec_1.vcase[(numn << 5) - 27] = 9506;
    s_copy(pectxt_1.txcase + ((numn << 5) - 26 << 4), "LOG", 16L, 3L);
    pec_1.vcase[(numn << 5) - 26] = 9507;
    s_copy(pectxt_1.txcase + ((numn << 5) - 25 << 4), "LOG10", 16L, 5L);
    pec_1.vcase[(numn << 5) - 25] = 9508;
    s_copy(pectxt_1.txcase + ((numn << 5) - 24 << 4), "SQRT", 16L, 4L);
    pec_1.vcase[(numn << 5) - 24] = 9509;
    s_copy(pectxt_1.txcase + ((numn << 5) - 23 << 4), "MOD", 16L, 3L);
    pec_1.vcase[(numn << 5) - 23] = 9510;
    s_copy(pectxt_1.txcase + ((numn << 5) - 22 << 4), "ABS", 16L, 3L);
    pec_1.vcase[(numn << 5) - 22] = 9511;
    s_copy(pectxt_1.txcase + ((numn << 5) - 21 << 4), "SIGN", 16L, 4L);
    pec_1.vcase[(numn << 5) - 21] = 9512;
    s_copy(pectxt_1.txcase + ((numn << 5) - 20 << 4), "INT", 16L, 3L);
    pec_1.vcase[(numn << 5) - 20] = 9513;
    s_copy(pectxt_1.txcase + ((numn << 5) - 19 << 4), "NINT", 16L, 4L);
    pec_1.vcase[(numn << 5) - 19] = 9514;
    s_copy(pectxt_1.txcase + ((numn << 5) - 18 << 4), "MIN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 18] = 9515;
    s_copy(pectxt_1.txcase + ((numn << 5) - 17 << 4), "MAX", 16L, 3L);
    pec_1.vcase[(numn << 5) - 17] = 9516;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 9;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 2;
    s_copy(pectxt_1.txcase + (pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(
	    numn << 1) - 1] + (numn << 5) - 33 << 4), "POP", 16L, 3L);
    pec_1.vcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] + 
	    (numn << 5) - 33] = 9599;
    for (i = 1; i <= 16; ++i) {
	pec_1.flcase[i + (numn << 5) - 33] = TRUE_;
/* L98: */
    }
    pec_1.flcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] 
	    + (numn << 5) - 33] = TRUE_;
/*             -------- menux (mxmenu)   (calculette numerique) (a droite 
*/
    numn = 16;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "N_CALCULETTE", 16L, 12L);
    s_copy(pectxt_1.txcase + ((numn << 5) - 32 << 4), "1", 16L, 1L);
    pec_1.vcase[(numn << 5) - 32] = 9001;
    s_copy(pectxt_1.txcase + ((numn << 5) - 31 << 4), "2", 16L, 1L);
    pec_1.vcase[(numn << 5) - 31] = 9002;
    s_copy(pectxt_1.txcase + ((numn << 5) - 30 << 4), "3", 16L, 1L);
    pec_1.vcase[(numn << 5) - 30] = 9003;
    s_copy(pectxt_1.txcase + ((numn << 5) - 29 << 4), "4", 16L, 1L);
    pec_1.vcase[(numn << 5) - 29] = 9004;
    s_copy(pectxt_1.txcase + ((numn << 5) - 28 << 4), "5", 16L, 1L);
    pec_1.vcase[(numn << 5) - 28] = 9005;
    s_copy(pectxt_1.txcase + ((numn << 5) - 27 << 4), "6", 16L, 1L);
    pec_1.vcase[(numn << 5) - 27] = 9006;
    s_copy(pectxt_1.txcase + ((numn << 5) - 26 << 4), "7", 16L, 1L);
    pec_1.vcase[(numn << 5) - 26] = 9007;
    s_copy(pectxt_1.txcase + ((numn << 5) - 25 << 4), "8", 16L, 1L);
    pec_1.vcase[(numn << 5) - 25] = 9008;
    s_copy(pectxt_1.txcase + ((numn << 5) - 24 << 4), "9", 16L, 1L);
    pec_1.vcase[(numn << 5) - 24] = 9009;
    s_copy(pectxt_1.txcase + ((numn << 5) - 23 << 4), "0", 16L, 1L);
    pec_1.vcase[(numn << 5) - 23] = 9000;
    s_copy(pectxt_1.txcase + ((numn << 5) - 22 << 4), "=", 16L, 1L);
    pec_1.vcase[(numn << 5) - 22] = 306;
    s_copy(pectxt_1.txcase + ((numn << 5) - 21 << 4), "+", 16L, 1L);
    pec_1.vcase[(numn << 5) - 21] = 9012;
    s_copy(pectxt_1.txcase + ((numn << 5) - 20 << 4), "-", 16L, 1L);
    pec_1.vcase[(numn << 5) - 20] = 9013;
    s_copy(pectxt_1.txcase + ((numn << 5) - 19 << 4), "*", 16L, 1L);
    pec_1.vcase[(numn << 5) - 19] = 9014;
    s_copy(pectxt_1.txcase + ((numn << 5) - 18 << 4), "/", 16L, 1L);
    pec_1.vcase[(numn << 5) - 18] = 9015;
    s_copy(pectxt_1.txcase + ((numn << 5) - 17 << 4), ".", 16L, 1L);
    pec_1.vcase[(numn << 5) - 17] = 9016;
    s_copy(pectxt_1.txcase + ((numn << 5) - 16 << 4), "C", 16L, 1L);
    pec_1.vcase[(numn << 5) - 16] = 9017;
    s_copy(pectxt_1.txcase + ((numn << 5) - 15 << 4), "|", 16L, 1L);
    pec_1.vcase[(numn << 5) - 15] = 9018;
    s_copy(pectxt_1.txcase + ((numn << 5) - 14 << 4), "(", 16L, 1L);
    pec_1.vcase[(numn << 5) - 14] = 9019;
    s_copy(pectxt_1.txcase + ((numn << 5) - 13 << 4), ")", 16L, 1L);
    pec_1.vcase[(numn << 5) - 13] = 9020;
    s_copy(pectxt_1.txcase + ((numn << 5) - 12 << 4), ",", 16L, 1L);
    pec_1.vcase[(numn << 5) - 12] = 9021;
    s_copy(pectxt_1.txcase + ((numn << 5) - 11 << 4), "PI", 16L, 2L);
    pec_1.vcase[(numn << 5) - 11] = 9990;
    s_copy(pectxt_1.txcase + ((numn << 5) - 10 << 4), "Y", 16L, 1L);
    pec_1.vcase[(numn << 5) - 10] = 9991;
    s_copy(pectxt_1.txcase + ((numn << 5) - 9 << 4), "NO", 16L, 2L);
    pec_1.vcase[(numn << 5) - 9] = 9992;
    s_copy(pectxt_1.txcase + ((numn << 5) - 8 << 4), "AC", 16L, 2L);
    pec_1.vcase[(numn << 5) - 8] = 9025;
    s_copy(pectxt_1.txcase + ((numn << 5) - 7 << 4), "E", 16L, 1L);
    pec_1.vcase[(numn << 5) - 7] = 9010;
    s_copy(pectxt_1.txcase + ((numn << 5) - 6 << 4), "Ra", 16L, 2L);
    pec_1.vcase[(numn << 5) - 6] = 9100;
    s_copy(pectxt_1.txcase + ((numn << 5) - 5 << 4), "Ag", 16L, 2L);
    pec_1.vcase[(numn << 5) - 5] = 9101;
    s_copy(pectxt_1.txcase + ((numn << 5) - 4 << 4), "Lg", 16L, 2L);
    pec_1.vcase[(numn << 5) - 4] = 9102;
    s_copy(pectxt_1.txcase + ((numn << 5) - 3 << 4), "Di", 16L, 2L);
    pec_1.vcase[(numn << 5) - 3] = 9103;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 8;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 4;
    s_copy(pectxt_1.txcase + (pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(
	    numn << 1) - 1] + (numn << 5) - 33 << 4), "POP", 16L, 3L);
    pec_1.vcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] + 
	    (numn << 5) - 33] = 9599;
    for (i = 1; i <= 30; ++i) {
	pec_1.flcase[i + (numn << 5) - 33] = TRUE_;
/* L99: */
    }
    pec_1.flcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] 
	    + (numn << 5) - 33] = TRUE_;


#else
/*     initialisation du contenu des menus */



/*     raz des menus */
    for (j = 1; j <= 16; ++j) {
	pec_1.acmenu[j - 1] = FALSE_;
	for (i = 1; i <= 32; ++i) {
	    pec_1.flcase[i + (j << 5) - 33] = FALSE_;
	    pec_1.mkcase[i + (j << 5) - 33] = 0;
/* L999: */
	}
/* L998: */
    }
/* -----------------------------------------------------------------------
 */
/* ----------- attention designation doit connaitre le numero des cases de
 */
/* -----------------------------------------------------------------------
 */

/*                 ---------  menu 1 (types a designer)(en bas) -------- 
*/
/*                                (pour construction et maillage) */
    numn = 1;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_CONSTR", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT/p", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 301;
    ++i;
/*     txcase(i, numn)='DROITE/d'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "STRT LINE/l", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 302;
    ++i;
/*     txcase(i, numn)='CERCLE/c'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CIRCLE/c", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 303;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMT/s", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
/*     txcase(i,numn)='P MOUSE/m'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MOUSE P/m", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
/*     txcase(i,numn)='PT XY/x'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "XY PT/x", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
/*     txcase(i,numn)='Fi_XY/<'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "XY FILE/<", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 314;
    ++i;
/*     txcase(i,numn)='QLCONQ/q'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANY/q", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
/*     txcase(i,numn)='+ PROCHE\\p'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NEAREST ^n", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
/*     txcase(i,numn)='EXTREM\\e'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTREM ^e", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 352;
    ++i;
/*     txcase(i,numn)='CENTRE\\c'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTER\\c", 16L, 
	    8L);
    pec_1.vcase[i + (numn << 5) - 33] = 353;
    ++i;
/*     txcase(i,numn)='MILIEU\\m'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MIDDLE ^m", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 354;
    ++i;
/*     txcase(i,numn)='INTERS/i'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERS/i", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 355;
/*       ... ne pas affecter 306 car  '='  est defini dans calcule */
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L1: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*               ---------  menu 2 (gestion ecran)( a droite) -------- */
    numn = 2;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "GESTION_ECRAN", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ZOOM +", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 401;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ZOOM -", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 402;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLATION", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 403;
    ++i;
/*     txcase(i, numn)='ECHELLE'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SCALE", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 404;
    ++i;
/*     txcase(i, numn)='RAFRAICHIR'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REFRESH", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 405;
    ++i;
/*     txcase(i, numn)='C_MASQUE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "C_MASK", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 406;
    ++i;
/*     txcase(i, numn)='PRECEDENTE'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PREVIOUS", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 407;
    ++i;
/*     txcase(i, numn)='SUIVANTE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NEXT", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 408;
    ++i;
/*     txcase(i, numn)='VOIR_TOUT'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SHOW_ALL", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 409;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L2: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = i;
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*     nombre de colonnes */
/*             ---------  menu 3 (generalitees) (a gauche) -------- */
    numn = 3;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "GENERAUX", 16L, 8L);
    i = 1;
/*     txcase(i, numn)='FINIR ^z'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUIT ^z", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 501;
    ++i;
/*     txcase(i, numn)='INTERROGER'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUERY", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 502;
    ++i;
/*     txcase(i, numn)='DETRUIRE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DESTRUCT", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 503;
    ++i;
/*     txcase(i, numn)='SAUVER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SAVE", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 504;
    ++i;
/*     txcase(i, numn)='RESTAURER'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RESTORE", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 505;
    ++i;
/*     txcase(i, numn)='RAZ_BD'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RESET_DB", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 506;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HARD_COPY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 507;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SOFT_COPY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 508;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SHELL", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 509;
    ++i;
/*     txcase(i, numn)='TRACE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "LOG FILE", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 510;
    ++i;
/*     txcase(i, numn)='INTERPRETE'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERPRET", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 512;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CONSTRUCTION", 16L,
	     12L);
    pec_1.vcase[i + (numn << 5) - 33] = 511;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "PREP_MESH", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 513;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EDIT_MESH", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 514;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L3: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = i;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 4 (creation) (en haut) -------- */
    numn = 4;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "CONSTRUCTION", 16L, 12L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 601;
    ++i;
/*     txcase(i,numn)='CERCLE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CIRCLE", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 603;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 604;
    ++i;
/*     txcase(i,numn)='ARRONDI'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ROUND", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 610;
    ++i;
/*     txcase(i,numn)='CENTRE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTER", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 607;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DISTANCE", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 608;
    ++i;
/*     txcase(i,numn)='RETOURNER'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SWAP", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 618;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COMPLE_ARC", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 619;
    ++i;
/*     txcase(i,numn)='COUPER'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CUT", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 621;
    ++i;
/*     txcase(i,numn)='AJOUTER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ADD", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 625;
    ++i;
/*     txcase(i,numn)='RAPPORT'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RATIO", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 617;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ROTATION", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 611;
    ++i;
/*     txcase(i,numn)='SYMETRIE'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SYMMETRY", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 613;
    ++i;
/*     txcase(i,numn)='DROITE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "STRT LINE", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 602;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 605;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 624;
    ++i;
/*     txcase(i,numn)='CONTOURAGE'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "OUTLINE", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 622;
    ++i;
/*     txcase(i,numn)='RAYON'                                           #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RADIUS", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 606;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANGLE", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 609;
    ++i;
/*     txcase(i,numn)='INVERSER'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INVERT", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 620;
    ++i;
/*     txcase(i,numn)='FONDRE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MERGE", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 626;
    ++i;
/*     txcase(i,numn)='CHANGER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CHANGE", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 623;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "IDEM", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 615;
    ++i;
/*     txcase(i,numn)='NOMBRE'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NUMBER", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 616;
    ++i;
/*     txcase(i,numn)='TRANSLAT'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLAT", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 612;
    ++i;
/*     txcase(i,numn)='HOMOTHETIE'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HOMOTHETY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 614;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L4: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 5 (application 1 ) (en haut) -------- */
    numn = 5;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "APPLICATION_1", 16L, 13L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), " ", 16L, 1L);
    pec_1.vcase[i + (numn << 5) - 33] = 0;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L5: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 6 (application 2 ) (en haut) -------- */
    numn = 6;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "MAILLAGE", 16L, 8L);
    i = 1;
/*     txcase(i,numn)='LIGNE'                                           #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "LINE", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 701;
    ++i;
/*     txcase(i,numn)='COMPOSANTE'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COMPONENT", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 710;
    ++i;
/*     txcase(i,numn)='DEFISSURE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "UNCRACK", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 723;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RAISON", 16L, 6L);
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RATIO", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 716;
    ++i;
/*     txcase(i,numn)='REF_NOEUD'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NODE_REF", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 705;
    ++i;
/*     txcase(i,numn)='REF_DOMAIN'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DOMAIN_REF", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 717;
    ++i;
/*     txcase(i,numn)='DEF DOMAI'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DOMAIN DEF", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 714;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUADRANGLE", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 704;
    ++i;
/*     txcase(i,numn)='REGULIER'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REGULAR", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 707;
    ++i;
/*     txcase(i,numn)='RETIRER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REMOVE", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 719;
    ++i;
/*     txcase(i,numn)='VOIR'                                            #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SHOW", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 713;
    ++i;
/*     txcase(i,numn)='GENERER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "GENERATE", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 708;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DOMAINE", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 711;
    ++i;
/*     txcase(i,numn)='TOUT'                                            #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ALL", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 718;
    ++i;
/*     txcase(i,numn)='FISSURE '                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CRACK", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 722;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Nb_INTERVAL", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 702;
    ++i;
/*     txcase(i,numn)='REF_LIGNE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "LINE_REF", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 706;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Lg_INTERVAL", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 721;
    ++i;
/*     txcase(i,numn)='INTERIEUR'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "INTERIOR", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 712;
    ++i;
/*     txcase(i,numn)='TRIANGLES'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRIANGLES", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 703;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "COINS", 16L, 5L);
/*     txcase(i,numn)='CORNERS'                                         #F
R*/
    pec_1.vcase[i + (numn << 5) - 33] = 709;
    ++i;
/*     txcase(i,numn)='VERIFIER'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "VERIFY", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 715;
    ++i;
/*     txcase(i,numn)='BANDES'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "STRIP", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 744;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "Gen. Base", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 720;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	if (pec_1.vcase[j + (numn << 5) - 33] != 0) {
	    pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
	}
/* L6: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             ---------  menu 7 (application 3 ) (en haut) -------- */
    numn = 7;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "MESH_PTG", 16L, 8L);
    i = 1;
/* ------------- premiere  ligne  --------- */
/*     txcase(i,numn)='REGULARISER'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "REGULARIZE", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 802;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "DELAUNAY", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 803;
    ++i;
/*     txcase(i,numn)='AJOUTER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ADD", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 804;
    ++i;
/*     txcase(i,numn)='BOUGER'                                          #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MOVE", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 805;
    ++i;
/*     txcase(i,numn)='SUPPRIMER'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SUPRESS", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 806;
    ++i;
/*     txcase(i,numn)='RETOURNER'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SWAP", 16L, 4L);
    pec_1.vcase[i + (numn << 5) - 33] = 817;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MODIF_REF", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 812;
    ++i;
/*     txcase(i,numn)='FISSURE'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CRACK", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 814;
    ++i;
/*     txcase(i,numn)='TRIANGULER'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRIANGULATE", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 818;
    ++i;
/*     txcase(i,numn)='ANGLE MIN'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MIN ANGLE", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 820;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MARK ELEMENT", 16L,
	     12L);
    pec_1.vcase[i + (numn << 5) - 33] = 822;
/* ------------- seconde ligne */
    ++i;
/*     txcase(i,numn)='RENUMEROTER'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "RENUMBER", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 816;
    ++i;
/*     txcase(i,numn)='TOUT'                                            #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ALL", 16L, 3L);
    pec_1.vcase[i + (numn << 5) - 33] = 813;
    ++i;
/*     txcase(i,numn)='ORIGINAUX'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ORIGINALS", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 815;
    ++i;
/*     txcase(i,numn)='EVALUER'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EVALUATE", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 811;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ROTATION", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 807;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "TRANSLATION", 16L, 
	    11L);
    pec_1.vcase[i + (numn << 5) - 33] = 808;
    ++i;
/*     txcase(i,numn)='SYMETRIE'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SYMMETRY", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 809;
    ++i;
/*     txcase(i,numn)='HOMOTHETIE'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "HOMOTHETY", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 810;
    ++i;
/*     txcase(i,numn)='QUADRANGULER'                                    #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "QUADRANGULATE", 
	    16L, 13L);
    pec_1.vcase[i + (numn << 5) - 33] = 819;
    ++i;
/*     txcase(i,numn)='ANGLE MAX'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MAX ANGLE", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 821;
    ++i;
/*     txcase(i,numn)='FRONTIERE'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "BOUNDARY", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 823;
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = pec_1.vcase[j + (numn << 5) - 33]
		 != 0;
/* L7: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 2;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*                 ---------  menu  (types a designer)(en bas)  (mxmenu-4 
*/
/*                                (pour  maillage) */
    numn = 12;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_MAILLAGE", 16L, 15L);
    i = 1;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "POINT/p", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 301;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT/s", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
/*     txcase(i,numn)='P MOUSE/m'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MOUSE P/m", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
/*     txcase(i,numn)='PT XY/x'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "XY PT /x", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
/*     txcase(i,numn)='QLCONQ/q'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANY/q", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
/*     txcase(i,numn)='+ PROCHE\\p'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NEAREST ^n", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
/*     txcase(i,numn)='EXTREM\\e'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTREM ^e", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 352;
/*       ... ne pas affecter 306 car c'est '=' il est defini dans calcule 
*/
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L14: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             -------- designation (suite pour hecht) (mxmenu -3) (en ba 
*/
    numn = 13;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "DESIGN_MSHPTG", 16L, 13L);
    i = 1;
/*     txcase(i,numn)='SOMMET/v'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "VERTEX/v", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 308;
    ++i;
/*     txcase(i,numn)='ARETE/l'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EDGE/d", 16L, 6L);
    pec_1.vcase[i + (numn << 5) - 33] = 310;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ELEMENT/f", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 309;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "S_DOM/r", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 311;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ARC/a", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 304;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SEGMENT/s", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 305;
    ++i;
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "SPLINE/~", 16L, 8L)
	    ;
    pec_1.vcase[i + (numn << 5) - 33] = 312;
    ++i;
/*     txcase(i,numn)='P MOUSE/m'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MOUSE P/m", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 313;
    ++i;
/*     txcase(i,numn)='PT XY/x'                                         #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "XY PT/x", 16L, 7L);
    pec_1.vcase[i + (numn << 5) - 33] = 315;
    ++i;
/*     txcase(i,numn)='QLCONQ/q'                                        #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "ANY/q", 16L, 5L);
    pec_1.vcase[i + (numn << 5) - 33] = 307;
    ++i;
/*     txcase(i,numn)='+ PROCHE\\p'                                     #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "NEAREST ^n", 16L, 
	    10L);
    pec_1.vcase[i + (numn << 5) - 33] = 351;
    ++i;
/*     txcase(i,numn)='EXTERM \\e'                                      #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "EXTERM ^e", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 352;
    ++i;
/*     txcase(i,numn)='CENTRE\\c'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "CENTER ^c", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 353;
    ++i;
/*     txcase(i,numn)='MILIEU\\m'                                       #F
R*/
    s_copy(pectxt_1.txcase + (i + (numn << 5) - 33 << 4), "MIDLLE ^m", 16L, 
	    9L);
    pec_1.vcase[i + (numn << 5) - 33] = 354;
/*       ... ne pas affecter 306 car c'est '=' il est defini dans calcule 
*/
    i__1 = i;
    for (j = 1; j <= i__1; ++j) {
	pec_1.flcase[j + (numn << 5) - 33] = TRUE_;
/* L13: */
    }
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = i / pec_1.cmenu[(numn << 1) - 2];
    if (i % pec_1.cmenu[(numn << 1) - 2] != 0) {
	++pec_1.cmenu[(numn << 1) - 1];
    }
/*             -------- menux (mxmenu-2) (calculette zone affichage) */
    numn = 14;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), " ", 16L, 1L);
    pec_1.flcase[(numn << 5) - 32] = TRUE_;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 1;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 1;
/*             -------- menux (mxmenu-1) (calculette fonctions) (a droite 
*/
    numn = 15;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "F_CALCULETTE", 16L, 12L);
    s_copy(pectxt_1.txcase + ((numn << 5) - 32 << 4), "SIN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 32] = 9501;
    s_copy(pectxt_1.txcase + ((numn << 5) - 31 << 4), "COS", 16L, 3L);
    pec_1.vcase[(numn << 5) - 31] = 9502;
    s_copy(pectxt_1.txcase + ((numn << 5) - 30 << 4), "TAN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 30] = 9503;
    s_copy(pectxt_1.txcase + ((numn << 5) - 29 << 4), "ATAN", 16L, 4L);
    pec_1.vcase[(numn << 5) - 29] = 9504;
    s_copy(pectxt_1.txcase + ((numn << 5) - 28 << 4), "ATAN2", 16L, 5L);
    pec_1.vcase[(numn << 5) - 28] = 9505;
    s_copy(pectxt_1.txcase + ((numn << 5) - 27 << 4), "EXP", 16L, 3L);
    pec_1.vcase[(numn << 5) - 27] = 9506;
    s_copy(pectxt_1.txcase + ((numn << 5) - 26 << 4), "LOG", 16L, 3L);
    pec_1.vcase[(numn << 5) - 26] = 9507;
    s_copy(pectxt_1.txcase + ((numn << 5) - 25 << 4), "LOG10", 16L, 5L);
    pec_1.vcase[(numn << 5) - 25] = 9508;
    s_copy(pectxt_1.txcase + ((numn << 5) - 24 << 4), "SQRT", 16L, 4L);
    pec_1.vcase[(numn << 5) - 24] = 9509;
    s_copy(pectxt_1.txcase + ((numn << 5) - 23 << 4), "MOD", 16L, 3L);
    pec_1.vcase[(numn << 5) - 23] = 9510;
    s_copy(pectxt_1.txcase + ((numn << 5) - 22 << 4), "ABS", 16L, 3L);
    pec_1.vcase[(numn << 5) - 22] = 9511;
    s_copy(pectxt_1.txcase + ((numn << 5) - 21 << 4), "SIGN", 16L, 4L);
    pec_1.vcase[(numn << 5) - 21] = 9512;
    s_copy(pectxt_1.txcase + ((numn << 5) - 20 << 4), "INT", 16L, 3L);
    pec_1.vcase[(numn << 5) - 20] = 9513;
    s_copy(pectxt_1.txcase + ((numn << 5) - 19 << 4), "NINT", 16L, 4L);
    pec_1.vcase[(numn << 5) - 19] = 9514;
    s_copy(pectxt_1.txcase + ((numn << 5) - 18 << 4), "MIN", 16L, 3L);
    pec_1.vcase[(numn << 5) - 18] = 9515;
    s_copy(pectxt_1.txcase + ((numn << 5) - 17 << 4), "MAX", 16L, 3L);
    pec_1.vcase[(numn << 5) - 17] = 9516;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 9;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 2;
    s_copy(pectxt_1.txcase + (pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(
	    numn << 1) - 1] + (numn << 5) - 33 << 4), "POP", 16L, 3L);
    pec_1.vcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] + 
	    (numn << 5) - 33] = 9599;
    for (i = 1; i <= 16; ++i) {
	pec_1.flcase[i + (numn << 5) - 33] = TRUE_;
/* L98: */
    }
    pec_1.flcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] 
	    + (numn << 5) - 33] = TRUE_;
/*             -------- menux (mxmenu)   (calculette numerique) (a droite 
*/
    numn = 16;
/*     nom de ce menu */
    s_copy(pectxt_1.txmenu + (numn - 1 << 4), "N_CALCULETTE", 16L, 12L);
    s_copy(pectxt_1.txcase + ((numn << 5) - 32 << 4), "1", 16L, 1L);
    pec_1.vcase[(numn << 5) - 32] = 9001;
    s_copy(pectxt_1.txcase + ((numn << 5) - 31 << 4), "2", 16L, 1L);
    pec_1.vcase[(numn << 5) - 31] = 9002;
    s_copy(pectxt_1.txcase + ((numn << 5) - 30 << 4), "3", 16L, 1L);
    pec_1.vcase[(numn << 5) - 30] = 9003;
    s_copy(pectxt_1.txcase + ((numn << 5) - 29 << 4), "4", 16L, 1L);
    pec_1.vcase[(numn << 5) - 29] = 9004;
    s_copy(pectxt_1.txcase + ((numn << 5) - 28 << 4), "5", 16L, 1L);
    pec_1.vcase[(numn << 5) - 28] = 9005;
    s_copy(pectxt_1.txcase + ((numn << 5) - 27 << 4), "6", 16L, 1L);
    pec_1.vcase[(numn << 5) - 27] = 9006;
    s_copy(pectxt_1.txcase + ((numn << 5) - 26 << 4), "7", 16L, 1L);
    pec_1.vcase[(numn << 5) - 26] = 9007;
    s_copy(pectxt_1.txcase + ((numn << 5) - 25 << 4), "8", 16L, 1L);
    pec_1.vcase[(numn << 5) - 25] = 9008;
    s_copy(pectxt_1.txcase + ((numn << 5) - 24 << 4), "9", 16L, 1L);
    pec_1.vcase[(numn << 5) - 24] = 9009;
    s_copy(pectxt_1.txcase + ((numn << 5) - 23 << 4), "0", 16L, 1L);
    pec_1.vcase[(numn << 5) - 23] = 9000;
    s_copy(pectxt_1.txcase + ((numn << 5) - 22 << 4), "=", 16L, 1L);
    pec_1.vcase[(numn << 5) - 22] = 306;
    s_copy(pectxt_1.txcase + ((numn << 5) - 21 << 4), "+", 16L, 1L);
    pec_1.vcase[(numn << 5) - 21] = 9012;
    s_copy(pectxt_1.txcase + ((numn << 5) - 20 << 4), "-", 16L, 1L);
    pec_1.vcase[(numn << 5) - 20] = 9013;
    s_copy(pectxt_1.txcase + ((numn << 5) - 19 << 4), "*", 16L, 1L);
    pec_1.vcase[(numn << 5) - 19] = 9014;
    s_copy(pectxt_1.txcase + ((numn << 5) - 18 << 4), "/", 16L, 1L);
    pec_1.vcase[(numn << 5) - 18] = 9015;
    s_copy(pectxt_1.txcase + ((numn << 5) - 17 << 4), ".", 16L, 1L);
    pec_1.vcase[(numn << 5) - 17] = 9016;
    s_copy(pectxt_1.txcase + ((numn << 5) - 16 << 4), "C", 16L, 1L);
    pec_1.vcase[(numn << 5) - 16] = 9017;
    s_copy(pectxt_1.txcase + ((numn << 5) - 15 << 4), "|", 16L, 1L);
    pec_1.vcase[(numn << 5) - 15] = 9018;
    s_copy(pectxt_1.txcase + ((numn << 5) - 14 << 4), "(", 16L, 1L);
    pec_1.vcase[(numn << 5) - 14] = 9019;
    s_copy(pectxt_1.txcase + ((numn << 5) - 13 << 4), ")", 16L, 1L);
    pec_1.vcase[(numn << 5) - 13] = 9020;
    s_copy(pectxt_1.txcase + ((numn << 5) - 12 << 4), ",", 16L, 1L);
    pec_1.vcase[(numn << 5) - 12] = 9021;
    s_copy(pectxt_1.txcase + ((numn << 5) - 11 << 4), "PI", 16L, 2L);
    pec_1.vcase[(numn << 5) - 11] = 9990;
    s_copy(pectxt_1.txcase + ((numn << 5) - 10 << 4), "Y", 16L, 1L);
    pec_1.vcase[(numn << 5) - 10] = 9991;
    s_copy(pectxt_1.txcase + ((numn << 5) - 9 << 4), "NO", 16L, 2L);
    pec_1.vcase[(numn << 5) - 9] = 9992;
    s_copy(pectxt_1.txcase + ((numn << 5) - 8 << 4), "AC", 16L, 2L);
    pec_1.vcase[(numn << 5) - 8] = 9025;
    s_copy(pectxt_1.txcase + ((numn << 5) - 7 << 4), "E", 16L, 1L);
    pec_1.vcase[(numn << 5) - 7] = 9010;
    s_copy(pectxt_1.txcase + ((numn << 5) - 6 << 4), "Ra", 16L, 2L);
    pec_1.vcase[(numn << 5) - 6] = 9100;
    s_copy(pectxt_1.txcase + ((numn << 5) - 5 << 4), "Ag", 16L, 2L);
    pec_1.vcase[(numn << 5) - 5] = 9101;
    s_copy(pectxt_1.txcase + ((numn << 5) - 4 << 4), "Lg", 16L, 2L);
    pec_1.vcase[(numn << 5) - 4] = 9102;
    s_copy(pectxt_1.txcase + ((numn << 5) - 3 << 4), "Di", 16L, 2L);
    pec_1.vcase[(numn << 5) - 3] = 9103;
/*     nombre de lignes */
    pec_1.cmenu[(numn << 1) - 2] = 8;
/*     nombre de colonnes */
    pec_1.cmenu[(numn << 1) - 1] = 4;
    s_copy(pectxt_1.txcase + (pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(
	    numn << 1) - 1] + (numn << 5) - 33 << 4), "POP", 16L, 3L);
    pec_1.vcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] + 
	    (numn << 5) - 33] = 9599;
    for (i = 1; i <= 30; ++i) {
	pec_1.flcase[i + (numn << 5) - 33] = TRUE_;
/* L99: */
    }
    pec_1.flcase[pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1) - 1] 
	    + (numn << 5) - 33] = TRUE_;
    return 0;
#endif

    return 0;
   
} /* inimn_ */




logical init2_(integer *iinit)
{
    /* System generated locals */
    real r__1, r__2, r__3, r__4;
    logical ret_val;

    /* Builtin functions */
    integer i_len(char *, ftnlen);

    /* Local variables */
    real xmin, ymin;
    integer numn;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    integer i, j;

    extern /* Subroutine */ int inimn_(void);
    integer nbcara;
    integer ccc1, ccc2, ccc3, ccc4, ccc5;
    static real screen[4];
    real screen1[4], dx, dy, rrr, vvv, bbb, sss;
    extern /* Subroutine */ int szscrn_(real *, real *, real *, real *), 
	    inqcol_(real *, real *, real *);


/*     initialisation de la position des menus et fenetres */
/*      si */


/*    --- on sauve la taille de l'ecran */
/*      taille des menus */
/*      les tailles suivantes sont en % de la taille de l'ecran */

/*     init des contenu des menus */
/*     dyresv= hauteur de la zone reservee ( affichage etat + ligne scrat 
*/
/*     dymn1 = hauteur menu designation          (1) */
/*     dymn2 = hauteur menu gestion ecran        (2) */
/*     dxmn2 = largeur menu gestion ecran        (2) */
/*     dxmn3 = largeur menu generalites          (3) */
/*     dymn4 = hauteur menu application          (4,5,6,7) */
/*     dycalc= hauteur fenetre valeur calculette (mxmenu-2) */
/*     marge = petite marge autour les fenetres */
    ret_val = FALSE_;
    if (*iinit != 0) {
	szscrn_(screen1, &screen1[1], &screen1[2], &screen1[3]);
	if ((r__1 = screen1[0] - screen[0], dabs(r__1)) + (r__2 = screen1[1] 
		- screen[1], dabs(r__2)) + (r__3 = screen1[2] - screen[2], 
		dabs(r__3)) + (r__4 = screen1[3] - screen[3], dabs(r__4)) == 
		0.f) {
	    return ret_val;
	}
    }
    ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
    inqcol_(&rrr, &vvv, &bbb);
    sss = rrr + vvv + bbb;
    if (sss > .5f) {
/*       fond clair */
	ccc1 = ctabco_1.rouges;
	ccc2 = ctabco_1.bleus;
	ccc3 = ctabco_1.verts;
	ccc4 = ctabco_1.magens;
	ccc5 = ctabco_1.cyans;
	pec_1.coloro = ctabco_1.rouges;
	pec_1.colove = ctabco_1.verts;
    } else {
/*       fond sombre */
	ccc1 = ctabco_1.rougec;
	ccc2 = ctabco_1.jaune;
	ccc3 = ctabco_1.magenc;
	ccc4 = ctabco_1.cyanc;
	ccc5 = ctabco_1.vertc;
	pec_1.coloro = ctabco_1.rouge;
	pec_1.colove = ctabco_1.vert;
    }
    szscrn_(screen, &screen[1], &screen[2], &screen[3]);
    ret_val = TRUE_;
    if (*iinit == 0) {
	inimn_();
    }
    nbcara = i_len(pectxt_1.txcase, 16L) + 3;
    for (i = 1; i <= 16; ++i) {
	pec_1.szchmn[i - 1] = 1.f;
	for (j = 1; j <= 4; ++j) {
/* L1: */
	    pec_1.fmenu[j + (i << 2) - 5] = 0.f;
	}
    }
/*     demande de la taille de l'ecran */
/*     ecran en % */
    pec_1.ecran[0] = 0.f;
    pec_1.ecran[1] = 100.f;
    pec_1.ecran[2] = 0.f;
    pec_1.ecran[3] = 100.f;
/*     fenetre reservee */
    pec_1.reserv[0] = pec_1.ecran[0] + .5f;
    pec_1.reserv[1] = pec_1.ecran[1] - .5f;
    pec_1.reserv[2] = pec_1.ecran[2] + .5f;
    pec_1.reserv[3] = pec_1.ecran[2] + 8.f - .5f;
    pec_1.colore[1] = ccc2;
    pec_1.colore[0] = ctabco_1.pafond;
/*     definition de l'ecran */
    pec_1.ecran[2] += 8.f;
    pec_1.ecran[0] = pec_1.ecran[0];
    pec_1.ecran[1] += -.5f;
    pec_1.ecran[2] = pec_1.ecran[2];
    pec_1.ecran[3] = pec_1.ecran[3];
    pec_1.coloec = ctabco_1.pafond;
/*                 ---------  menu 1 (types a designer) -------- */
/*     en bas */
    numn = 1;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[2] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.ecran[2] + 5.f;
    pec_1.colomn[numn - 1] = ccc3;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 13);
/*                 ---------  menu 2 (gestion ecran) */
/*     a droite */
    numn = 2;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[1] - 10.f - .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.fmenu[(numn << 2) - 4] + 10.f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[3] - 8.f - 30.f - .5f - .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.ecran[3] - 8.f - .5f - .5f;
    pec_1.colomn[numn - 1] = ccc4;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 15);
/*                 ---------  menu 3 (generalitees) */
/*     a gauche */
    numn = 3;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.fmenu[(numn << 2) - 4] + 10.f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.fmenu[3] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.ecran[3] - 8.f - .5f - .5f;
    pec_1.colomn[numn - 1] = ccc5;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 15);
/*                  ---------  menu 4 (construction) -------- */
/*     en haut */
    numn = 4;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[3] - 8.f - .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[(numn << 2) - 2] + 8.f;
    pec_1.colomn[numn - 1] = ctabco_1.pafond;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 14);
/*                  ---------  menu 5 (application 1 ) -------- */
/*     en haut */
    numn = 5;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[3] - 8.f - .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[(numn << 2) - 2] + 8.f;
    pec_1.colomn[numn - 1] = ctabco_1.pafond;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 14);
/*                  ---------  menu 6 (application 2 ) -------- */
/*     en haut */
    numn = 6;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[3] - 8.f - .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[(numn << 2) - 2] + 8.f;
    pec_1.colomn[numn - 1] = ctabco_1.pafond;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 14);
/*                  ---------  menu 7 (application 3 ) -------- */
/*     en haut */
    numn = 7;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[3] - 8.f - .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[(numn << 2) - 2] + 8.f;
    pec_1.colomn[numn - 1] = ctabco_1.pafond;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 15);
/*                 ---------  menu designation maillage (mxmenu-4)------- 
*/
/*     en bas */
    numn = 12;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[2] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.ecran[2] + 5.f;
    pec_1.colomn[numn - 1] = ccc3;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 14);
/*                 ---------  menu designation (suite pour hecht)   (mxme 
*/
/*     en bas */
    numn = 13;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[0] + .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.ecran[1] - .5f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.ecran[2] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.ecran[2] + 5.f;
    pec_1.colomn[numn - 1] = ccc3;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 14);
/*                 ---------  fenetre de la valeur de la calculette (mxne 
*/
/*     a droite sous menu2 */
    numn = 14;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[1] - 10.f - .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.fmenu[(numn << 2) - 4] + 10.f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.fmenu[6] - .5f - 4.f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[6] - .5f;
    pec_1.colomn[numn - 1] = ccc2;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 13);
/*                 ---------  menu mxmenu-1   (calculette partie fonction 
*/
/*     a droite sous menu2 */
    numn = 15;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[1] - 10.f - .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.fmenu[(numn << 2) - 4] + 10.f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.fmenu[3] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[54] - .5f;
    pec_1.colomn[numn - 1] = ccc3;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 7);
/*                 ---------  menu mxmenu     (calculette partie numeriqu 
*/
/*     a droite sous menu2 */
    numn = 16;
    pec_1.fmenu[(numn << 2) - 4] = pec_1.ecran[1] - 10.f - .5f;
    pec_1.fmenu[(numn << 2) - 3] = pec_1.fmenu[(numn << 2) - 4] + 10.f;
    pec_1.fmenu[(numn << 2) - 2] = pec_1.fmenu[3] + .5f;
    pec_1.fmenu[(numn << 2) - 1] = pec_1.fmenu[54] - .5f;
    pec_1.colomn[numn - 1] = ccc3;
    pec_1.szchmn[numn - 1] = (real) (pec_1.cmenu[(numn << 1) - 1] * 5);
/*     fenetre de travail */
    pec_1.fentre[0] = pec_1.fmenu[9] + .5f;
    pec_1.fentre[1] = pec_1.fmenu[4] - .5f;
    pec_1.fentre[2] = pec_1.fmenu[3] + .5f;
    pec_1.fentre[3] = pec_1.fmenu[14] - .5f;
    pec_1.colofe = ccc2;
/*     calcule en c.m. des fenetres qui etaient definies en % de l'ecran 
*/
    dx = (screen[1] - screen[0]) / 100.f;
    dy = (screen[3] - screen[2]) / 100.f;
    xmin = screen[0];
    ymin = screen[2];
    for (i = 1; i <= 2; ++i) {
	pec_1.ecran[i - 1] = xmin + dx * pec_1.ecran[i - 1];
	pec_1.reserv[i - 1] = xmin + dx * pec_1.reserv[i - 1];
	pec_1.fentre[i - 1] = xmin + dx * pec_1.fentre[i - 1];
	for (j = 1; j <= 16; ++j) {
	    pec_1.fmenu[i + (j << 2) - 5] = xmin + dx * pec_1.fmenu[i + (j << 
		    2) - 5];
/* L97: */
	}
/* L98: */
    }
    for (i = 3; i <= 4; ++i) {
	pec_1.ecran[i - 1] = ymin + dy * pec_1.ecran[i - 1];
	pec_1.reserv[i - 1] = ymin + dy * pec_1.reserv[i - 1];
	pec_1.fentre[i - 1] = ymin + dy * pec_1.fentre[i - 1];
	for (j = 1; j <= 16; ++j) {
	    pec_1.fmenu[i + (j << 2) - 5] = ymin + dy * pec_1.fmenu[i + (j << 
		    2) - 5];
/* L95: */
	}
/* L96: */
    }
/*     masque de travail initial centre en (0,0) */
    pec_1.masque[0] = -(doublereal)(pec_1.fentre[1] - pec_1.fentre[0]) * .5f;
    pec_1.masque[1] = (pec_1.fentre[1] - pec_1.fentre[0]) * .5f;
    pec_1.masque[2] = -(doublereal)(pec_1.fentre[3] - pec_1.fentre[2]) * .5f;
    pec_1.masque[3] = (pec_1.fentre[3] - pec_1.fentre[2]) * .5f;
/*     activation des menus et calcul de la taille des caracteres en cm */
    for (i = 1; i <= 16; ++i) {
/* Computing MAX */
	r__1 = pec_1.szchmn[i - 1];
	pec_1.szchmn[i - 1] = (pec_1.fmenu[(i << 2) - 3] - pec_1.fmenu[(i << 
		2) - 4]) / dmax(r__1,.01f);
/* L88: */
    }
    if (*iinit == 0) {
	for (i = 1; i <= 16; ++i) {
	    pec_1.acmenu[i - 1] = FALSE_;
/* L99: */
	}
/*       gestion ecran */
	pec_1.acmenu[1] = TRUE_;
/*       generalitees */
	pec_1.acmenu[2] = TRUE_;
/*      calculette numerique */
	pec_1.acmenu[15] = TRUE_;
    }
    return ret_val;
} /* init2_ */




/* Subroutine */ int innum_(char *outext, real *reel, integer *intg, logical *
	bool, integer *type, integer *contrs, integer *mini, integer *maxi, 
	real *minr, real *maxr, ftnlen outext_len)
{
    /* System generated locals */
    address a__1[3], a__2[2];
    integer i__1, i__2[3], i__3[2];
    real r__1, r__2;

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer s_rsle(cilist *), i_len(char *, ftnlen), do_lio(integer *, 
	    integer *, char *, ftnlen), e_rsle(void);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer i_indx(char *, char *, ftnlen, ftnlen), s_wsle(cilist *), e_wsle(
	    void);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    real f[4];
    integer i;

    integer i1, nbcin;
    char intxt[256];
    extern /* Subroutine */ int thick_(real *), dring_(void), fentr2_(real *, 
	    real *, real *, real *), masqu2_(real *, real *, real *, real *), 
	    drw3tx_(real *, real *, integer *);
    real ym;
    char buf[256];
    extern /* Subroutine */ int scrtch_(char *, ftnlen), noirci_(real *), 
	    getnum_(char *, real *, real *, real *, integer *, logical *, 
	    integer *, integer *, integer *, integer *, real *, real *, 
	    ftnlen), inquot_(char *, char *, integer *, ftnlen, ftnlen);
    char buf1[256];

    /* Fortran I/O blocks */
    /*static*/ cilist io___2159 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2165 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2166 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2167 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2168 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2169 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2170 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2171 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2174 = { 0, 0, 0, 0, 0 };



/*     affiche dans la fenetre reserv (en haut), outext et attend */
/*     un nombre en entree  de type type (0=entier, 1=real, 2=logical) . 
*/
/*         si constr=0 pas de contraintes */
/*         si constr -= 0 contraintes et: selon  type */
/*            mini,maxi   min et max en entier */
/*            minr,maxr   min et max en float */



/*     teste si on est en interpretation */
    if (traint_1.ptintr != 0) {
/*       on lit le texte sur le fichier d'interpretation */
	s_copy(intxt, " ", 256L, 1L);
	io___2159.ciunit = traint_1.interp[traint_1.ptintr - 1];
	i__1 = s_rsle(&io___2159);
	if (i__1 != 0) {
	    goto L100009;
	}
	i__1 = do_lio(&c__9, &c__1, buf, i_len(outext, outext_len));
	if (i__1 != 0) {
	    goto L100009;
	}
	i__1 = do_lio(&c__9, &c__1, intxt, 256L);
	if (i__1 != 0) {
	    goto L100009;
	}
	i__1 = e_rsle();
L100009:
	if (i__1 < 0) {
	    goto L2;
	}
	if (i__1 > 0) {
	    goto L1;
	}
/*       recherche de la fin de la chaine */
	for (nbcin = i_len(intxt, 256L); nbcin >= 1; --nbcin) {
	    if (intxt[nbcin - 1] == ';') {
		goto L11;
	    }
/* L10: */
	}
	nbcin = 1;
L11:
	s_copy(intxt + (nbcin - 1), " ", 256 - (nbcin - 1), 1L);
	--nbcin;
	if (nbcin == 0) {
	    scrtch_(outext, i_len(outext, outext_len));
/*          print*,'innum:',outext(1:len(outext)) */
	} else {
/* Writing concatenation */
	    i__2[0] = i_len(outext, outext_len), a__1[0] = outext;
	    i__2[1] = 1, a__1[1] = " ";
	    i__2[2] = nbcin, a__1[2] = intxt;
	    s_cat(buf, a__1, i__2, &c__3, 256L);
	    scrtch_(buf, i_len(outext, outext_len) + nbcin + 1);
/*          print*,'innum:',buf(1:len(outext)+nbcin+1) */
	}
    } else {
/*       on n'est pas en interpretation */
	ym = (pec_1.reserv[2] + pec_1.reserv[3]) / 2.1f;
	f[0] = pec_1.reserv[0];
	f[1] = pec_1.reserv[1];
	f[2] = ym;
	f[3] = pec_1.reserv[3];
	noirci_(f);
	fentr2_(f, &f[1], &f[2], &f[3]);
	masqu2_(f, &f[1], &f[2], &f[3]);
	ligh3_(&c_n1, &c_n1, &pec_1.colore[1]);
	thick_(&c_b619);
/*        call limits(0) */
	thick_(&c_b604);
	r__1 = (pec_1.reserv[1] - pec_1.reserv[0]) / 132.f;
	drw3tx_(&r__1, &c_b609, &c__0);
	i = i_indx(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), " ", 16L, 1L)
		;
	if (i == 0) {
	    i = i_len(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), 16L);
	}
/* Writing concatenation */
	i__2[0] = i, a__1[0] = pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4);
	i__2[1] = 1, a__1[1] = ":";
	i__2[2] = i_len(outext, outext_len), a__1[2] = outext;
	s_cat(buf, a__1, i__2, &c__3, 256L);
	s_copy(intxt, " ", 256L, 1L);
	nbcin = 0;
/*       pour attirer l'attention de l'utilisateur */
	dring_();
	r__1 = f[0] + (f[1] - f[0]) * .005f;
	r__2 = f[2] + (f[3] - f[2]) * .3f;
	getnum_(buf, &r__1, &r__2, reel, intg, bool, type, contrs, mini, maxi,
		 minr, maxr, i_len(outext, outext_len) + 17);
	if (*type == 0) {
	    if (*contrs == 0) {
		s_wsle(&io___2165);
		do_lio(&c__9, &c__1, "INNUM:", 6L);
		do_lio(&c__9, &c__1, buf, i_len(outext, outext_len) + 17);
		e_wsle();
	    } else {
		s_wsle(&io___2166);
		do_lio(&c__9, &c__1, "                   min=", 23L);
		do_lio(&c__3, &c__1, (char *)&(*mini), (ftnlen)sizeof(integer)
			);
		do_lio(&c__9, &c__1, " maxi=", 6L);
		do_lio(&c__3, &c__1, (char *)&(*maxi), (ftnlen)sizeof(integer)
			);
		e_wsle();
	    }
	    s_wsle(&io___2167);
	    do_lio(&c__9, &c__1, "                     :", 22L);
	    do_lio(&c__3, &c__1, (char *)&(*intg), (ftnlen)sizeof(integer));
	    e_wsle();
	} else if (*type == 1) {
	    if (*contrs == 0) {
		s_wsle(&io___2168);
		do_lio(&c__9, &c__1, "INNUM:", 6L);
		do_lio(&c__9, &c__1, buf, i_len(outext, outext_len) + 17);
		e_wsle();
	    } else {
		s_wsle(&io___2169);
		do_lio(&c__9, &c__1, "                    min=", 24L);
		do_lio(&c__4, &c__1, (char *)&(*minr), (ftnlen)sizeof(real));
		do_lio(&c__9, &c__1, " maxr=", 6L);
		do_lio(&c__3, &c__1, (char *)&(*maxi), (ftnlen)sizeof(integer)
			);
		e_wsle();
	    }
	    s_wsle(&io___2170);
	    do_lio(&c__9, &c__1, "                      :", 23L);
	    do_lio(&c__4, &c__1, (char *)&(*reel), (ftnlen)sizeof(real));
	    e_wsle();
	} else if (*type == 2) {
	    s_wsle(&io___2171);
	    do_lio(&c__9, &c__1, "INNUM:", 6L);
	    do_lio(&c__9, &c__1, buf, i_len(outext, outext_len) + 17);
	    do_lio(&c__8, &c__1, (char *)&(*bool), (ftnlen)sizeof(logical));
	    e_wsle();
	}
	etat_1.scrtc = TRUE_;
    }
/*     teste si on est en trace */
L1:
    if (traint_1.trace != 0) {
	if (nbcin == 0) {
	    *buf = ';';
	} else {
/* Writing concatenation */
	    i__3[0] = nbcin, a__2[0] = intxt;
	    i__3[1] = 1, a__2[1] = ";";
	    s_cat(buf, a__2, i__3, &c__2, 256L);
	}
	inquot_(buf, buf1, &i1, nbcin + 1, 256L);
	inquot_(outext, buf, &i, i_len(outext, outext_len), 256L);
	io___2174.ciunit = traint_1.trace;
	s_wsle(&io___2174);
	do_lio(&c__9, &c__1, buf, i);
	do_lio(&c__9, &c__1, " ", 1L);
	do_lio(&c__9, &c__1, buf1, i1);
	e_wsle();
    }
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
L2:
    nbcin = 0;
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* innum_ */




/* Subroutine */ int inquot_(char *in, char *out, integer *lout, ftnlen 
	in_len, ftnlen out_len)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer i_len(char *, ftnlen);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    integer i, lin;


/*     inquot =  la chaine in entre quote */

    lin = i_len(in, in_len);
    *lout = 1;
    s_copy(out, "'", 2L, 1L);
    i__1 = lin;
    for (i = 1; i <= i__1; ++i) {
	if (in[i - 1] != '\'') {
	    ++(*lout);
	    out[*lout - 1] = in[i - 1];
	} else {
	    ++(*lout);
	    out[*lout - 1] = in[i - 1];
	    ++(*lout);
	    out[*lout - 1] = in[i - 1];
	}
/* L1: */
    }
    ++(*lout);
    out[*lout - 1] = '\'';
    return 0;
} /* inquot_ */

/* Subroutine */ int intext_(char *outext, integer *nbcmax, char *intxt, 
	integer *nbcin, ftnlen outext_len, ftnlen intxt_len)
{
    /* System generated locals */
    address a__1[3], a__2[2];
    integer i__1, i__2[3], i__3[2];
    real r__1;

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer s_rsle(cilist *), i_len(char *, ftnlen), do_lio(integer *, 
	    integer *, char *, ftnlen), e_rsle(void), s_wsle(cilist *), 
	    e_wsle(void);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer i_indx(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    real f[4];
    integer i, l;

    integer i1;
    extern /* Subroutine */ int thick_(real *), fentr2_(real *, real *, real *
	    , real *), masqu2_(real *, real *, real *, real *);
    integer ll;
    extern /* Subroutine */ int drw3tx_(real *, real *, integer *);
    real ym;
    char buf[256];
    extern /* Subroutine */ int scrtch_(char *, ftnlen), noirci_(real *), 
	    getext_(char *, real *, real *, integer *, char *, integer *, 
	    ftnlen, ftnlen);
    real xxx;
    extern /* Subroutine */ int inquot_(char *, char *, integer *, ftnlen, 
	    ftnlen);
    real yyy;
    char buf1[256];

    /* Fortran I/O blocks */
    /*static*/ cilist io___2180 = { 1, 0, 1, 0, 0 };
    /*static*/ cilist io___2182 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2183 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2190 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2192 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2195 = { 0, 0, 0, 0, 0 };



/*     affiche dans la fenetre reserv (en haut), outext et attend */
/*     un texte en entree (intxt) de nbcmax caracteres au plus */
/*     nbcin= nombre de caracteres effectivement entres */



/*     teste si on est en interpretation */
    if (traint_1.ptintr != 0) {
/*       on lit le texte sur le fichier */
	s_copy(intxt, " ", (*nbcmax), 1L);
	io___2180.ciunit = traint_1.interp[traint_1.ptintr - 1];
	i__1 = s_rsle(&io___2180);
	if (i__1 != 0) {
	    goto L100010;
	}
	i__1 = do_lio(&c__9, &c__1, buf, i_len(outext, outext_len));
	if (i__1 != 0) {
	    goto L100010;
	}
	i__1 = do_lio(&c__9, &c__1, intxt, (max(1,*nbcmax)));
	if (i__1 != 0) {
	    goto L100010;
	}
	i__1 = e_rsle();
L100010:
	if (i__1 < 0) {
	    goto L2;
	}
	if (i__1 > 0) {
	    goto L1;
	}
/*       recherche de la fin de la chaine */
	for (*nbcin = *nbcmax; *nbcin >= 1; --(*nbcin)) {
	    if (intxt[*nbcin - 1] == ';') {
		goto L11;
	    }
/* L10: */
	}
	*nbcin = 1;
L11:
	s_copy(intxt + (*nbcin - 1), " ", intxt_len - (*nbcin - 1), 1L);
	--(*nbcin);
	if (*nbcin == 0) {
	    scrtch_(outext, i_len(outext, outext_len));
	    s_wsle(&io___2182);
	    do_lio(&c__9, &c__1, "INTEXT:", 7L);
	    do_lio(&c__9, &c__1, outext, i_len(outext, outext_len));
	    e_wsle();
	} else {
/* Writing concatenation */
	    i__2[0] = i_len(outext, outext_len), a__1[0] = outext;
	    i__2[1] = 1, a__1[1] = " ";
	    i__2[2] = *nbcin, a__1[2] = intxt;
	    s_cat(buf, a__1, i__2, &c__3, 256L);
	    scrtch_(buf, i_len(outext, outext_len) + *nbcin + 1);
	    s_wsle(&io___2183);
	    do_lio(&c__9, &c__1, "INTEXT:", 7L);
	    do_lio(&c__9, &c__1, buf, i_len(outext, outext_len) + *nbcin + 1);
	    e_wsle();
	}
    } else {
	ym = (pec_1.reserv[2] + pec_1.reserv[3]) / 2.1f;
	f[0] = pec_1.reserv[0];
	f[1] = pec_1.reserv[1];
	f[2] = ym;
	f[3] = pec_1.reserv[3];
	noirci_(f);
	fentr2_(f, &f[1], &f[2], &f[3]);
	masqu2_(f, &f[1], &f[2], &f[3]);
	ligh3_(&c_n1, &c_n1, &pec_1.colore[1]);
	thick_(&c_b619);
/*        call limits(0) */
	thick_(&c_b604);
	r__1 = (pec_1.reserv[1] - pec_1.reserv[0]) / 132.f;
	drw3tx_(&r__1, &c_b609, &c__0);
	i = i_indx(pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4), " ", 16L, 1L)
		;
	if (i == 0) {
	    i = 16;
	}
/* Writing concatenation */
	i__2[0] = i, a__1[0] = pectxt_1.txmenu + (cdesig_1.numenu - 1 << 4);
	i__2[1] = 1, a__1[1] = ":";
	i__2[2] = i_len(outext, outext_len), a__1[2] = outext;
	s_cat(buf, a__1, i__2, &c__3, 256L);
	s_copy(intxt, " ", intxt_len, 1L);
	xxx = f[0] + (f[1] - f[0]) * .005f;
	yyy = f[2] + (f[3] - f[2]) * .3f;
	*nbcin = 0;
	i__1 = min(*nbcmax,256);
	getext_(buf, &xxx, &yyy, &i__1, intxt, nbcin, i + 1 + i_len(outext, 
		outext_len), intxt_len);
	if (*nbcin > 0) {
	    for (l = *nbcin; l >= 1; --l) {
		*nbcin = l;
		if (intxt[l - 1] != ' ') {
		    goto L98;
		}
/* L99: */
	    }
	    *nbcin = 0;
L98:
	    ;
	}
	if (*nbcin != 0) {
	    s_wsle(&io___2190);
	    do_lio(&c__9, &c__1, "INTEXT:", 7L);
	    do_lio(&c__9, &c__1, buf, i + 1 + i_len(outext, outext_len));
	    i__1 = *nbcin;
	    for (ll = 1; ll <= i__1; ++ll) {
		do_lio(&c__9, &c__1, intxt + (ll - 1), 1L);
	    }
	    e_wsle();
	} else {
	    s_wsle(&io___2192);
	    do_lio(&c__9, &c__1, "INTEXT:", 7L);
	    do_lio(&c__9, &c__1, buf, i + 1 + i_len(outext, outext_len));
	    e_wsle();
	}
	etat_1.scrtc = TRUE_;
    }
/*     teste si on est en trace */
L1:
    if (traint_1.trace != 0) {
	if (*nbcin == 0) {
	    *buf = ';';
	} else {
/* Writing concatenation */
	    i__3[0] = *nbcin, a__2[0] = intxt;
	    i__3[1] = 1, a__2[1] = ";";
	    s_cat(buf, a__2, i__3, &c__2, 256L);
	}
	inquot_(buf, buf1, &i1, *nbcin + 1, 256L);
	inquot_(outext, buf, &i, i_len(outext, outext_len), 256L);
	io___2195.ciunit = traint_1.trace;
	s_wsle(&io___2195);
	do_lio(&c__9, &c__1, buf, i);
	do_lio(&c__9, &c__1, " ", 1L);
	do_lio(&c__9, &c__1, buf1, i1);
	e_wsle();
    }
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
L2:
    *nbcin = 0;
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* intext_ */




/* Subroutine */ int invers_(integer *iad)
{
    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */

    integer i;
    extern integer nrever_(integer *);
    integer pt;
    real dx, dy;

/*     inverse l'element d'adresse iad */


    if (bdpec2_1.bd[*iad * 6 + 384] == -2.f) {
	dx = bdpec2_1.bd[*iad * 6 + 387] - bdpec2_1.bd[*iad * 6 + 385];
	dy = bdpec2_1.bd[*iad * 6 + 388] - bdpec2_1.bd[*iad * 6 + 386];
	bdpec2_1.bd[*iad * 6 + 387] = bdpec2_1.bd[*iad * 6 + 385] + dx * cos(
		bdpec2_1.bd[*iad * 6 + 389]) - dy * sin(bdpec2_1.bd[*iad * 6 
		+ 389]);
	bdpec2_1.bd[*iad * 6 + 388] = bdpec2_1.bd[*iad * 6 + 386] + dx * sin(
		bdpec2_1.bd[*iad * 6 + 389]) + dy * cos(bdpec2_1.bd[*iad * 6 
		+ 389]);
	bdpec2_1.bd[*iad * 6 + 389] = -(doublereal)bdpec2_1.bd[*iad * 6 + 389]
		;
    } else if (bdpec2_1.bd[*iad * 6 + 384] == -3.f) {
	dx = bdpec2_1.bd[*iad * 6 + 385];
	bdpec2_1.bd[*iad * 6 + 385] = bdpec2_1.bd[*iad * 6 + 387];
	bdpec2_1.bd[*iad * 6 + 387] = dx;
	dy = bdpec2_1.bd[*iad * 6 + 386];
	bdpec2_1.bd[*iad * 6 + 386] = bdpec2_1.bd[*iad * 6 + 388];
	bdpec2_1.bd[*iad * 6 + 388] = dy;
    } else if (bdpec2_1.bd[*iad * 6 + 384] == -4.f) {
	pt = bdpec2_1.bd[*iad * 6 + 386];
	bdpec2_1.bd[*iad * 6 + 386] = (real) nrever_(&pt);
    }
/*        on inverse le numero de ref */
    i = bdpec5_1.nuref[(*iad << 1) + 128];
    bdpec5_1.nuref[(*iad << 1) + 128] = bdpec5_1.nuref[(*iad << 1) + 129];
    bdpec5_1.nuref[(*iad << 1) + 129] = i;
/*        on inverse les numeros de ref des extremitees */
    i = bdpec6_1.nuref1[(*iad << 1) + 128];
    bdpec6_1.nuref1[(*iad << 1) + 128] = bdpec7_1.nuref2[(*iad << 1) + 129];
    bdpec7_1.nuref2[(*iad << 1) + 129] = i;
    i = bdpec7_1.nuref2[(*iad << 1) + 128];
    bdpec7_1.nuref2[(*iad << 1) + 128] = bdpec6_1.nuref1[(*iad << 1) + 129];
    bdpec6_1.nuref1[(*iad << 1) + 129] = i;
/*        on inverse la raison */
    if (bdpec4_1.raison[*iad + 64] <= 0.f) {
	bdpec4_1.raison[*iad + 64] = 1.f;
    }
    bdpec4_1.raison[*iad + 64] = 1.f / bdpec4_1.raison[*iad + 64];
    return 0;
} /* invers_ */



