#include <assert.h>

#include "emc2_h.h"

/* Subroutine */ int itc1c2_(real *p, real *c1, real *c2)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int itd1d_(real *, real *, real *), pjp1d_(real *,
	     real *, real *, real *), dp1d1a_(real *, real *, real *, real *),
	     drp1p2_(real *, real *, real *);
    real dh, dp[4], ds, dx;
    real dcc[4];


/*      p = points d'intersections de c1 avec c2 */



    /* Parameter adjustments */
    p -= 6;

    /* Function Body */
    p[6] = -1e3f;
    p[12] = -1e3f;
    if (c1[0] == -1e3f || c2[0] == -1e3f) {
	return 0;
    }
    if (c1[0] == -1.f) {
	if (c2[0] == -1.f) {
/*         c1 et c2 sont des droites */
	    itd1d_(&p[6], c1, c2);
	    p[12] = p[6];
	    p[13] = p[7];
	    p[14] = p[8];
	} else {
/*         c1 est une droite et c2 est un cercle ou un point */
	    ds = c1[1] * c2[1] + c1[2] * c2[2] + c1[3];
	    dh = (c2[0] - ds) * (c2[0] + ds);
	    if (c2[0] - dabs(ds) >= -(doublereal)eps_1.eps) {
		if (dh > 0.f) {
		    dh = sqrt(dh);
		    if (dh < eps_1.eps) {
			dh = 0.f;
		    }
		} else {
		    dh = 0.f;
		}
		pjp1d_(&p[6], c2, c1, &dh);
		r__1 = -(doublereal)dh;
		pjp1d_(&p[12], c2, c1, &r__1);
	    }
	}
    } else {
	if (c2[0] == -1.f) {
/*         c1 est un cercle ou un point et c2 est une droite */
	    ds = c2[1] * c1[1] + c2[2] * c1[2] + c2[3];
	    dh = (c1[0] - ds) * (c1[0] + ds);
	    if (c1[0] - dabs(ds) >= -(doublereal)eps_1.eps) {
		if (dh > 0.f) {
		    dh = sqrt(dh);
		    if (dh < eps_1.eps) {
			dh = 0.f;
		    }
		} else {
		    dh = 0.f;
		}
		r__1 = -(doublereal)dh;
		pjp1d_(&p[6], c1, c2, &r__1);
		pjp1d_(&p[12], c1, c2, &dh);
	    }
	} else {
/*         c1 et c2 sont des cercles ou des points */
/* Computing 2nd power */
	    r__1 = c1[1] - c2[1];
/* Computing 2nd power */
	    r__2 = c1[2] - c2[2];
	    ds = sqrt(r__1 * r__1 + r__2 * r__2);
	    if (ds >= eps_1.eps) {
/* Computing 2nd power */
		r__1 = c1[1] - c2[1];
/* Computing 2nd power */
		r__2 = c1[2] - c2[2];
/* Computing 2nd power */
		r__3 = c1[0];
		dh = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);
		dx = (dh - c2[0]) * (dh + c2[0]) / (ds * 2.f);
		dh = (c1[0] - dx) * (c1[0] + dx);
		if (dh >= -(doublereal)eps_1.eps) {
		    if (dh > eps_1.eps) {
			dh = sqrt(dh);
		    } else {
			dh = 0.f;
		    }
		    drp1p2_(dcc, c1, c2);
		    dp1d1a_(dp, c1, dcc, &c_b2168);
		    dp[3] += dx;
		    pjp1d_(&p[6], c2, dp, &dh);
		    r__1 = -(doublereal)dh;
		    pjp1d_(&p[12], c2, dp, &r__1);
		}
	    }
	}
    }
    return 0;
} /* itc1c2_ */

#undef coulls


/* Subroutine */ int itd1d_(real *p, real *d1, real *d2)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    /* Fortran I/O blocks */
    /*static*/ cilist io___2210 = { 0, 6, 0, 0, 0 };



/*     p   =  point d'intersection des deux droites d1 d2 | vide */


    p[0] = -1e3f;
    if (d1[0] == -1e3f || d2[0] == -1e3f) {
	return 0;
    }
    if (d1[0] != -1.f || d2[0] != -1.f) {
	s_wsle(&io___2210);
	do_lio(&c__9, &c__1, "ERREUR:ITD1D, MAUVAIS TYPE", 26L);
	do_lio(&c__4, &c__1, (char *)&d1[0], (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&d2[0], (ftnlen)sizeof(real));
	e_wsle();
	return 0;
    }
    p[2] = d1[2] * d2[1] - d1[1] * d2[2];
    if (p[2] != 0.f) {
	p[0] = 0.f;
	p[1] = (d2[2] * d1[3] - d1[2] * d2[3]) / p[2];
	p[2] = (d1[1] * d2[3] - d2[1] * d1[3]) / p[2];
    }
    return 0;
} /* itd1d_ */

#undef coulls


/* Subroutine */ int itrace_(integer *ini, integer *numn, integer *trac, 
	integer *mkcas1, integer *mkcas2)
{
    /* System generated locals */
    address a__1[2], a__2[3];
    integer i__1[2], i__2[3], i__3;
    real r__1, r__2;
    char ch__1[267], ch__2[295];
    cilist ci__1;
    icilist ici__1;
    cllist cl__1;
    inlist ioin__1;

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);
    integer f_inqu(inlist *), f_clos(cllist *), s_rsfe(cilist *), e_rsfe(void)
	    , s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), i_len(char *, ftnlen);

    /* Local variables */
    logical bool;
    extern /* Subroutine */ int tilt_(void);
    integer i, j;

    integer nbtrac;
    char buf[256];

    extern integer fouvri_(integer *, char *, char *, integer *, ftnlen, 
	    ftnlen);
    extern /* Subroutine */ int intext_(char *, integer *, char *, integer *, 
	    ftnlen, ftnlen), scrtch_(char *, ftnlen), menumk_(integer *, 
	    integer *, integer *), afetat_(void);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2219 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___2220 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___2221 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___2222 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___2223 = { 0, 0, 0, 0, 0 };
    /*static*/ cilist io___2224 = { 0, 0, 0, 0, 0 };


/*     si ini=vrais on demande le nom du fichier */
/*           =faux  on trace sur le fichier trace */
/*     init de trace sur fichier */
    nbtrac = 0;
/* L15: */
    if (*ini == 0) {
/*          call intext('nom du fichier de trace?',100,buf,i)         
  #FR*/
	intext_("name of log file??", &c__100, buf, &i, 18L, 256L);
    } else {
	i = 8;
	s_copy(buf, "trace   ", 256L, 8L);
L1505:
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 3;
	ici__1.iciunit = buf + 5;
	ici__1.icifmt = "(i3.3)";
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&nbtrac, (ftnlen)sizeof(integer));
	e_wsfi();
	ioin__1.inerr = 0;
	ioin__1.infilen = i + 11;
/* Writing concatenation */
	i__1[0] = i, a__1[0] = buf;
	i__1[1] = 11, a__1[1] = ".emc2_trace";
	s_cat(ch__1, a__1, i__1, &c__2, 267L);
	ioin__1.infile = ch__1;
	ioin__1.inex = &bool;
	ioin__1.inopen = 0;
	ioin__1.innum = 0;
	ioin__1.innamed = 0;
	ioin__1.inname = 0;
	ioin__1.inacc = 0;
	ioin__1.inseq = 0;
	ioin__1.indir = 0;
	ioin__1.infmt = 0;
	ioin__1.inform = 0;
	ioin__1.inunf = 0;
	ioin__1.inrecl = 0;
	ioin__1.innrec = 0;
	ioin__1.inblank = 0;
	f_inqu(&ioin__1);
	if (bool) {
	    if (nbtrac >= 999) {
		scrtch_("ITRACE:FATALE ERREUR TOUS LES FICHIERS DE TRACE EXI"
			"STENT", 56L);
		assert(0 /* tilt() */);
	    } else {
		++nbtrac;
		goto L1505;
	    }
	}
    }
    if (traint_1.trace != 0) {
	if (traint_1.ptintr == 0) {
	    scrtch_("on ferme la  trace precedante", 29L);
	    cl__1.cerr = 0;
	    cl__1.cunit = traint_1.trace;
	    cl__1.csta = 0;
	    f_clos(&cl__1);
	    traint_1.trace = 0;
/*            demarquage de la trace */
	    menumk_(numn, trac, &c__0);
	} else {
	    scrtch_("on ne peut pas changer de trace car on interprete", 49L);
	    return 0;
	}
    }
    if (i != 0) {
/*          print*,'on demande de tracer sur:''',buf(1:i)//extrac,''''
 */
/*          teste si demande de append + nom du fichier */
	if (*buf == '+') {
	    *buf = ' ';
	    j = 2;
	} else {
	    j = 1;
	}
/*           print*,'trace: open:''',buf(j:i),'''' */
/* Writing concatenation */
	i__1[0] = i - (j - 1), a__1[0] = buf + (j - 1);
	i__1[1] = 11, a__1[1] = ".emc2_trace";
	s_cat(ch__1, a__1, i__1, &c__2, 267L);
	if (fouvri_(&traint_1.trace, ch__1, " ", &c__0, i - (j - 1) + 11, 1L) 
		!= 0) {
	    traint_1.trace = 6;
	    menumk_(numn, trac, &c__0);
/* Writing concatenation */
	    i__2[0] = 28, a__2[0] = "PB ouverture fichier TRACE: ";
	    i__2[1] = i - (j - 1), a__2[1] = buf + (j - 1);
	    i__2[2] = 11, a__2[2] = ".emc2_trace";
	    s_cat(ch__2, a__2, i__2, &c__3, 295L);
	    scrtch_(ch__2, i - (j - 1) + 39);
	    s_copy(trainx_1.tracex, "/dev/null", 128L, 9L);
	    afetat_();
	    return 0;
	}
	s_copy(trainx_1.tracex, " ", 128L, 1L);
	s_copy(trainx_1.tracex, buf, i, i);
	if (j == 2) {
/*            append, on lit jusqu'a la fin sans initialisation du
 */
/*            contexte de trace */
L1503:
	    ci__1.cierr = 1;
	    ci__1.ciend = 1;
	    ci__1.ciunit = traint_1.trace;
	    ci__1.cifmt = "(a256)";
	    i__3 = s_rsfe(&ci__1);
	    if (i__3 != 0) {
		goto L1502;
	    }
	    i__3 = do_fio(&c__1, buf, 256L);
	    if (i__3 != 0) {
		goto L1502;
	    }
	    i__3 = e_rsfe();
	    if (i__3 != 0) {
		goto L1502;
	    }
	    goto L1503;
L1502:
	    ;
	} else {
/*            initialisation du contexte de trace */
/*            application courante */
	    io___2219.ciunit = traint_1.trace;
	    s_wsle(&io___2219);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, pectxt_1.txmenu + (*numn - 1 << 4), 16L);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, " '", 2L);
	    do_lio(&c__9, &c__1, pectxt_1.txcase + (*mkcas2 + (*numn << 5) - 
		    33 << 4), 16L);
	    do_lio(&c__9, &c__1, "'", 1L);
	    do_lio(&c__9, &c__1, " 0. 0.", 6L);
	    e_wsle();
/*            echelle courante */
	    io___2220.ciunit = traint_1.trace;
	    s_wsle(&io___2220);
	    do_lio(&c__9, &c__1, "'GESTION_ECRAN   ' 'ECHELLE         ' 0. 0."
		    , 43L);
	    e_wsle();
	    ici__1.icierr = 0;
	    ici__1.icirnum = 1;
	    ici__1.icirlen = 256;
	    ici__1.iciunit = buf;
	    ici__1.icifmt = "(f10.4)";
	    s_wsfi(&ici__1);
	    do_fio(&c__1, (char *)&etat_1.echel, (ftnlen)sizeof(real));
	    e_wsfi();
	    for (i = 1; i <= 10; ++i) {
		if (buf[i - 1] != ' ') {
		    io___2221.ciunit = traint_1.trace;
		    s_wsle(&io___2221);
		    do_lio(&c__9, &c__1, "'N_CALCULETTE    ' '", 20L);
		    do_lio(&c__9, &c__1, buf + (i - 1), 1L);
		    do_lio(&c__9, &c__1, "               ' 0. 0.", 22L);
		    e_wsle();
		}
/* L1501: */
	    }
	    io___2222.ciunit = traint_1.trace;
	    s_wsle(&io___2222);
	    do_lio(&c__9, &c__1, "'N_CALCULETTE    ' '=               ' 0. 0."
		    , 43L);
	    e_wsle();
/*             centre du masque courant */
	    io___2223.ciunit = traint_1.trace;
	    s_wsle(&io___2223);
	    do_lio(&c__9, &c__1, "'GESTION_ECRAN   ' 'C_MASQUE        ' 0. 0."
		    , 43L);
	    e_wsle();
	    io___2224.ciunit = traint_1.trace;
	    s_wsle(&io___2224);
	    do_lio(&c__9, &c__1, "'ECRAN           ' 'XXXX__YYYY'", 31L);
	    r__1 = (pec_1.masque[0] + pec_1.masque[1]) * .5f;
	    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
	    r__2 = (pec_1.masque[2] + pec_1.masque[3]) * .5f;
	    do_lio(&c__4, &c__1, (char *)&r__2, (ftnlen)sizeof(real));
	    e_wsle();
	}
    } else {
	s_copy(trainx_1.tracex, " ", i_len(trainx_1.tracex, 128L), 1L);
	menumk_(numn, mkcas1, &c__0);
    }
    afetat_();
    return 0;
} /* itrace_ */




/* Subroutine */ int itspxx_(real *pp, real *cc1, real *cc2, integer *nbpt, 
	integer *iad1, integer *iad2, integer *gen)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern integer cons_(integer *, integer *);
    extern /* Subroutine */ int pjp1d_(real *, real *, real *, real *);
    integer *flag1=0, *flag2, *tgen1, *tgen2;
    real *xgen1=0, *ygen1=0, *xgen2=0, *ygen2=0;

    extern integer alloc_(void);
    integer i, j, k, n, iadsp;
    real c1[6], c2[6], p1[4], p2[4], teste[6];
    integer nbgen1, nbgen2, n2;
    extern /* Subroutine */ int drp1p2_(real *, real *, real *), thick_(real *
	    ), itc1c2_(real *, real *, real *);
    integer *nurfi1=0	/* was [2][2000] */, *nurfi2=0	/* 
	    was [2][2000] */;
    extern /* Subroutine */ int lin2to_(real *, real *), degen_(integer *);
    extern integer length_(integer *);
    extern logical testpx_(real *, real *);
    integer pt;
    real res[12]	/* was [6][2] */, ss[6], ccc[5], ccc1[5], densit,* xsp=0, *ysp;
 integer ad1, ad2;
    extern /* Subroutine */ int genspl_(real *, real *, integer *, real *, 
	    real *, real *, real *, integer *, integer *, integer *), scrtch_(
	    char *, ftnlen), mov2to_(real *, real *), drawad_(integer *, 
	    integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2251 = { 0, 6, 0, 0, 0 };



/*      pp = tableau des points d'intersections de cc1 avec cc2 */
/*           (au moins un des deux est une spline) */
/*      nbpt = nombre de points d'intersections */
/*      gen =0  on genere directement les splines crees par sect */
/*           =1 on ne calcule que les point d'intersections */


/*      logical close1,close2 */
/*     nuref des points d'intersection */
    /* Parameter adjustments */
    /* real    xsp[501], ysp[501];*/
    /*    integer nurfi1[4000]	 was [2][2000] */
             /* , nurfi2[4000]	 was [2][2000] ;*/
/*    real xgen1[2000], ygen1[2000], xgen2[2000], ygen2[2000];*/
/*    integer flag1[2000], flag2[2000], tgen1[500], tgen2[500];*/
    assert ( xsp = (real*) malloc(sizeof(real)*501) );
    assert ( ysp = (real*) malloc(sizeof(real)*501) );
    assert ( xgen1 = (real*) malloc(sizeof(real)*2000) );
    assert ( ygen1 = (real*) malloc(sizeof(real)*2000) );
    assert ( xgen2 = (real*) malloc(sizeof(real)*2000) );
    assert ( ygen2 = (real*) malloc(sizeof(real)*2000) );
    assert ( xgen2 = (real*) malloc(sizeof(real)*2000) );
    assert ( ygen2 = (real*) malloc(sizeof(real)*2000) );
    assert ( flag1 = (integer*) malloc(sizeof(integer)*2000) );
    assert ( flag2 = (integer*) malloc(sizeof(integer)*2000) );
    assert ( tgen1 = (integer*) malloc(sizeof(integer)*500) );
    assert ( tgen2 = (integer*) malloc(sizeof(integer)*500) );
    assert ( nurfi1 = (integer*) malloc(sizeof(integer)*4000) );
    assert ( nurfi2 = (integer*) malloc(sizeof(integer)*4000) );
    pp -= 6;

    /* Function Body */
    for (i = 1; i <= 16; ++i) {
	pp[i * 6] = -1e3f;
/* L1: */
    }
    *nbpt = 0;
    if (cc1[0] == -1e3f || cc2[0] == -1e3f) {
	goto LA999;
    }
    if (cc1[0] != -4.f) {
/*       c1 sera toujours une spline */
	ad1 = *iad2;
	ad2 = *iad1;
	for (i = 0; i <= 5; ++i) {
	    c1[i] = cc2[i];
	    c2[i] = cc1[i];
/* L999: */
	}
    } else {
	ad1 = *iad1;
	ad2 = *iad2;
	for (i = 0; i <= 5; ++i) {
	    c1[i] = cc1[i];
	    c2[i] = cc2[i];
/* L998: */
	}
    }
    for (i = 0; i <= 5; ++i) {
	teste[i] = c2[i];
/* L9997: */
    }
/*     on approxime toujours c1 par une suite de segments */
    pt = c1[2];
    n = 0;
L2:
    if (pt != 0) {
	++n;
	if (n <= 500) {
	    xsp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
	    ysp[n] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
	    pt = listed_1.cdr[pt - 1];
	    goto L2;
	}
    }
    densit = 1.f;
/*      print*,'c1 a',n,' points de controle' */
/* x      if(xsp(1).eq.xsp(n).and.ysp(1).eq.ysp(n))then */
/* xc        print*,'c1 est fermee' */
/* x        close1=.true. */
/* x      else */
/* xc        print*,'c1 est ouverte' */
/* x        close1=.false. */
/* x      endif */
    genspl_(xsp, ysp, &n, &eps_1.eps, &densit, xgen1, ygen1, &c__2000, &
	    nbgen1, tgen1);
    tgen1[n] = nbgen1;
    n2 = 0;
    nbgen2 = 2;
    if (c2[0] == -4.f) {
/*       on aproxime c2 par une suite de segments */
	pt = c2[2];
L3:
	if (pt != 0) {
	    ++n2;
	    if (n2 <= 500) {
		xsp[n2] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 385];
		ysp[n2] = bdpec2_1.bd[listea_1.car[pt - 1] * 6 + 386];
		pt = listed_1.cdr[pt - 1];
		goto L3;
	    }
	}
	densit = 1.f;
/*        print*,'c2 a',n2,' points de controls' */
/* x        if(xsp(1).eq.xsp(n2).and.ysp(1).eq.ysp(n2))then */
/* xc          print*,'c2 est fermee' */
/* x          close2=.true. */
/* x        else */
/* xc          print*,'c2 est ouverte' */
/* x          close2=.false. */
/* x        endif */
	genspl_(xsp, ysp, &n2, &eps_1.eps, &densit, xgen2, ygen2, &c__2000, &
		nbgen2, tgen2);
	tgen2[n] = nbgen2;
    }
/*     on considere qu'une spline est une suite de nbgen segments */
/*     on coupe touts les segments de la spline c1 par c2 */
    if (c2[0] == -3.f) {
/*       on fait la droite support dans ccc */
	p1[0] = 0.f;
	p1[1] = c2[1];
	p1[2] = c2[2];
	p2[0] = 0.f;
	p2[1] = c2[3];
	p2[2] = c2[4];
	drp1p2_(ccc, p1, p2);
    } else if (c2[0] == -2.f) {
/*       on fait le cercle support dans ccc */
/* Computing 2nd power */
	r__1 = c2[1] - c2[3];
/* Computing 2nd power */
	r__2 = c2[2] - c2[4];
	ccc[0] = sqrt(r__1 * r__1 + r__2 * r__2);
	ccc[1] = c2[1];
	ccc[2] = c2[2];
    } else if (c2[0] == -1.f) {
/*       on met c2 dans ccc */
	ccc[0] = c2[0];
	ccc[1] = c2[1];
	ccc[2] = c2[2];
	ccc[3] = c2[3];
    } else if (c2[0] >= 0.f) {
/*       on met c2 dans ccc */
	ccc[0] = c2[0];
	ccc[1] = c2[1];
	ccc[2] = c2[2];
	ccc[3] = c2[3];
    } else if (c2[0] == -4.f) {
	scrtch_("INTERSECTION SPLINE/SPLINE,      KEEP VERY COOL .......... "
		"  REGARDE LA BEBETE QUI BOUGE...", 91L);
    } else {
	scrtch_("ITSPXX: TYPE INCONNU", 20L);
	s_wsle(&io___2251);
	do_lio(&c__9, &c__1, "ITSPXX: TYPE INCONNU", 20L);
	do_lio(&c__4, &c__1, (char *)&c2[0], (ftnlen)sizeof(real));
	e_wsle();
	goto LA999;
    }
/*      print*,'itspxx:nbgen1=',nbgen1 */
    for (i = 1; i <= 2000; ++i) {
	flag1[i - 1] = 0;
	flag2[i - 1] = 0;
/* L13: */
    }
    i__1 = nbgen1 - 1;
    for (i = 1; i <= i__1; ++i) {
/*       on coupe touts les segments de la spline c1 par ccc support d
e c */
/*       ccc1 : droite support des segments aproximants la spline c1 
*/
	p1[0] = 0.f;
	p1[1] = xgen1[i - 1];
	p1[2] = ygen1[i - 1];
	p2[0] = 0.f;
	p2[1] = xgen1[i];
	p2[2] = ygen1[i];
	ss[0] = -3.f;
	ss[1] = p1[1];
	ss[2] = p1[2];
	ss[3] = p2[1];
	ss[4] = p2[2];
	drp1p2_(ccc1, p1, p2);
	if (c2[0] == -4.f) {
/*         on dessine la 1ere spline pour faire passer le temps a 
l'utili */
	    thick_(&c_b619);
	    mov2to_(&ss[1], &ss[2]);
	    lin2to_(&ss[3], &ss[4]);
	    thick_(&c_b604);
	}
	i__2 = nbgen2 - 1;
	for (k = 1; k <= i__2; ++k) {
	    if (c2[0] == -4.f) {
		p1[0] = 0.f;
		p1[1] = xgen2[k - 1];
		p1[2] = ygen2[k - 1];
		p2[0] = 0.f;
		p2[1] = xgen2[k];
		p2[2] = ygen2[k];
		drp1p2_(ccc, p1, p2);
		teste[0] = -3.f;
		teste[1] = p1[1];
		teste[2] = p1[2];
		teste[3] = p2[1];
		teste[4] = p2[2];
	    }
	    if (ccc[0] == 0.f) {
		pjp1d_(res, ccc, ccc1, &c_b609);
/*           2ieme solution vide (il n'y en n'a qu'une) */
		res[6] = -1e3f;
	    } else {
		itc1c2_(res, ccc1, ccc);
	    }
	    for (j = 1; j <= 2; ++j) {
/*            print*,'itspxx:res(0,j)=',res(0,j),' x,y=',res(1
,j),res(2,j */
		if (res[j * 6 - 6] != -1e3f) {
		    if (testpx_(&res[j * 6 - 6], ss) && testpx_(&res[j * 6 - 
			    6], teste)) {
			if (*nbpt < 16) {
			    if (*nbpt < 1 || *nbpt >= 1 && (pp[*nbpt * 6 + 1] 
				    != res[j * 6 - 5] || pp[*nbpt * 6 + 2] != 
				    res[j * 6 - 4])) {
/*                    print*,'itspxx: res dans
 c2 et ss, on l''empile' */
				++(*nbpt);
				pp[*nbpt * 6] = 0.f;
				pp[*nbpt * 6 + 1] = res[j * 6 - 5];
				pp[*nbpt * 6 + 2] = res[j * 6 - 4];
/*                   flag1 pointe sur le point
 d'intersection */
				flag1[i - 1] = *nbpt;
				nurfi1[(i << 1) - 2] = bdpec5_1.nuref[(ad2 << 
					1) + 128];
				nurfi1[(i << 1) - 1] = bdpec5_1.nuref[(ad2 << 
					1) + 128];
				if (c2[0] == -4.f) {
/*                     flag2 pointe sur le
 point d'intersection */
				    flag2[k - 1] = *nbpt;
				    nurfi2[(k << 1) - 2] = bdpec5_1.nuref[(
					    ad2 << 1) + 128];
				    nurfi2[(k << 1) - 1] = bdpec5_1.nuref[(
					    ad2 << 1) + 128];
				}
			    }
			} else {
			    scrtch_("ITSPXX:OVERFLOW DES POINTS D'INTERSECTI"
				    "ONS (nombre>16)", 54L);
			}
		    }
		}
/* L11: */
	    }
/* L12: */
	}
/* L10: */
    }
/*      print*,'itspxx: nbpt=',nbpt */
    i__1 = *nbpt;
    for (i = 1; i <= i__1; ++i) {
/*        print*,'type=',pp(0,i),' x,y=',pp(1,i),pp(2,i) */
/* L888: */
    }
/*     teste si on demande de decouper les splines */
    if (*gen != 0) {
	goto LA999;
    }
/*     fabrication des morceaux de spline pour c1 */
    if (*nbpt == 0) {
	goto LA999;
    }
    pt = c1[2];
    i = 0;
    iadsp = alloc_();
    bdpec2_1.bd[iadsp * 6 + 384] = -4.f;
    bdpec2_1.bd[iadsp * 6 + 386] = 0.f;
    bdpec4_1.raison[iadsp + 64] = bdpec4_1.raison[ad1 + 64];
    bdpec5_1.nuref[(iadsp << 1) + 128] = bdpec5_1.nuref[(ad1 << 1) + 128];
    bdpec5_1.nuref[(iadsp << 1) + 129] = bdpec5_1.nuref[(ad1 << 1) + 128];
L100:
    if (pt != 0) {
	++i;
	i__1 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
	bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&listea_1.car[pt - 1], &
		i__1);
/*       on regarde si entre tgen1(i) et tgen1(i+1) il y a une interse
cti */
	i__1 = tgen1[i];
	for (j = tgen1[i - 1]; j <= i__1; ++j) {
	    if (flag1[j - 1] != 0) {
/*            print*,'intersection apres le',i,' iem point de 
control' */
/*            print*,'tgen1(',i,')=',tgen1(i) */
/*     +       ,' tgen1(',i+1,')=',tgen1(i+1),' flag1(',j,')='
,flag1(j) */
		k = alloc_();
		bdpec2_1.bd[k * 6 + 384] = 0.f;
		bdpec2_1.bd[k * 6 + 385] = pp[flag1[j - 1] * 6 + 1];
		bdpec2_1.bd[k * 6 + 386] = pp[flag1[j - 1] * 6 + 2];
/*            print*,'on alloue un point en:',k,' x,y=',bd(1,k
),bd(2,k) */
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&k, &i__2);
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		bdpec2_1.bd[iadsp * 6 + 385] = (real) length_(&i__2);
		bdpec6_1.nuref1[(iadsp << 1) + 128] = nurfi1[(j << 1) - 2];
		bdpec7_1.nuref2[(iadsp << 1) + 128] = nurfi1[(j << 1) - 2];
		bdpec6_1.nuref1[(iadsp << 1) + 129] = nurfi1[(j << 1) - 1];
		bdpec7_1.nuref2[(iadsp << 1) + 129] = nurfi1[(j << 1) - 1];
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		i__3 = (integer) bdpec2_1.bd[ad1 * 6 + 386];
		bdpec3_1.nbnode[iadsp + 64] = bdpec3_1.nbnode[ad1 + 64] * ((
			real) length_(&i__2) / (real) length_(&i__3));
		degen_(&iadsp);
		drawad_(&iadsp, &c__0);
/*           preparation de la suivante */
		iadsp = alloc_();
		bdpec2_1.bd[iadsp * 6 + 384] = -4.f;
		bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&k, &c__0);
		bdpec4_1.raison[iadsp + 64] = bdpec4_1.raison[ad1 + 64];
		bdpec5_1.nuref[(iadsp << 1) + 128] = bdpec5_1.nuref[(ad1 << 1)
			 + 128];
		bdpec5_1.nuref[(iadsp << 1) + 129] = bdpec5_1.nuref[(ad1 << 1)
			 + 129];
	    }
/* L101: */
	}
	pt = listed_1.cdr[pt - 1];
	goto L100;
    }
/*     fabrication des morceaux de spline pour c2 */
    if (c2[0] != -4.f) {
	goto LA999;
    }
    pt = c2[2];
    i = 0;
    iadsp = alloc_();
    bdpec2_1.bd[iadsp * 6 + 384] = -4.f;
    bdpec2_1.bd[iadsp * 6 + 386] = 0.f;
    bdpec4_1.raison[iadsp + 64] = bdpec4_1.raison[ad2 + 64];
    bdpec5_1.nuref[(iadsp << 1) + 128] = bdpec5_1.nuref[(ad2 << 1) + 128];
    bdpec5_1.nuref[(iadsp << 1) + 129] = bdpec5_1.nuref[(ad2 << 1) + 129];
L102:
    if (pt != 0) {
	++i;
	i__1 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
	bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&listea_1.car[pt - 1], &
		i__1);
/*       on regarde si entre tgen2(i) et tgen2(i+1) il y a une interse
cti */
	i__1 = tgen2[i];
	for (j = tgen2[i - 1]; j <= i__1; ++j) {
	    if (flag2[j - 1] != 0) {
/*            print*,'intersection apres le',i,' iem point de 
control' */
/*            print*,'tgen2(',i,')=',tgen2(i) */
/*     +       ,' tgen2(',i+1,')=',tgen2(i+1),' flag2(',j,')='
,flag2(j) */
		k = alloc_();
		bdpec2_1.bd[k * 6 + 384] = 0.f;
		bdpec2_1.bd[k * 6 + 385] = pp[flag2[j - 1] * 6 + 1];
		bdpec2_1.bd[k * 6 + 386] = pp[flag2[j - 1] * 6 + 2];
/*            print*,'on alloue un point en:',k,' x,y=',bd(1,k
),bd(2,k) */
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&k, &i__2);
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		bdpec2_1.bd[iadsp * 6 + 385] = (real) length_(&i__2);
		bdpec6_1.nuref1[(iadsp << 1) + 128] = nurfi2[(j << 1) - 2];
		bdpec7_1.nuref2[(iadsp << 1) + 128] = nurfi2[(j << 1) - 2];
		bdpec6_1.nuref1[(iadsp << 1) + 129] = nurfi2[(j << 1) - 1];
		bdpec7_1.nuref2[(iadsp << 1) + 129] = nurfi2[(j << 1) - 1];
		i__2 = (integer) bdpec2_1.bd[iadsp * 6 + 386];
		i__3 = (integer) bdpec2_1.bd[ad2 * 6 + 386];
		bdpec3_1.nbnode[iadsp + 64] = bdpec3_1.nbnode[ad2 + 64] * ((
			real) length_(&i__2) / (real) length_(&i__3));
		degen_(&iadsp);
		drawad_(&iadsp, &c__0);
/*           preparation de la suivante */
		iadsp = alloc_();
		bdpec2_1.bd[iadsp * 6 + 384] = -4.f;
		bdpec2_1.bd[iadsp * 6 + 386] = (real) cons_(&k, &c__0);
		bdpec4_1.raison[iadsp + 64] = bdpec4_1.raison[ad2 + 64];
		bdpec5_1.nuref[(iadsp << 1) + 128] = bdpec5_1.nuref[(ad2 << 1)
			 + 128];
		bdpec5_1.nuref[(iadsp << 1) + 129] = bdpec5_1.nuref[(ad2 << 1)
			 + 129];
	    }
/* L103: */
	}
	pt = listed_1.cdr[pt - 1];
	goto L102;
    }
        LA999:
   free( xsp);
    free ( ysp);/* = (real*) malloc(sizeof(real)*501) );*/
    free ( xgen1);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( ygen1);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( xgen2);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( ygen2);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( xgen2);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( ygen2);/* = (real*) malloc(sizeof(real)*2000) );*/
    free ( flag1);/* = (integer*) malloc(sizeof(integer)*2000) );*/
    free ( flag2);/* = (integer*) malloc(sizeof(integer)*2000) );*/
    free ( tgen1);/* = (integer*) malloc(sizeof(integer)*500) );*/
    free ( tgen2);/* = (integer*) malloc(sizeof(integer)*500) );*/
    free ( nurfi1);/* = (integer*) malloc(sizeof(integer)*4000) );*/
    free ( nurfi2);/* = (integer*) malloc(sizeof(integer)*4000) );*/

    return 0;
} /* itspxx_ */




/*     f_lisp */
integer last_(integer *pt1)
{
    /* System generated locals */
    integer ret_val;


/*     last=pointeur sur le dernier cons de la la liste pt1 */


    ret_val = *pt1;
    if (*pt1 != 0) {
L1:
	if (listed_1.cdr[ret_val - 1] != 0) {
	    ret_val = listed_1.cdr[ret_val - 1];
	    goto L1;
	}
    }
    return ret_val;
} /* last_ */

/*     f_lisp */
integer length_(integer *pt)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    integer pt1;


/*     length=nombre d'elements de la liste pt */


    pt1 = *pt;
    ret_val = 0;
L1:
    if (pt1 != 0) {
	++ret_val;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L1;
    }
    return ret_val;
} /* length_ */

integer ligne_(integer *adress, integer *ptcomp, integer *adres2)
{
    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Local variables */
    extern integer cons_(integer *, integer *);
    integer cote;

    integer pttbd;
    extern integer appenx_(integer *, integer *);
    integer pt, nuextr;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);


/*     elle link les elements de la bd dans une liste de tete ligne */
/*     de facon a ce que l'on parcourt les elements depuis celui */
/*     d'adresse adress jusqu'a celui d'adresse adres2. et cela en */
/*     tournant dans le sens de la composante */
/*     dans le cas de fissure: */
/*     les adresses sont >0 si on considere l'element a gauche */
/*                       <0 si on considere l'element a droite */


/*      integer count */
    ret_val = 0;
/*     verification que adres2 est bien dans ptcomp */
    if (bdpecc_1.compos[(*adres2 << 1) + 128] == 0 && bdpecc_1.compos[(*
	    adres2 << 1) + 129] == 0) {
	scrtch_("LIGNE:ERREUR:LA 2IEME EXTREMITEE N'APPARTIENT A AUCUNE COMP"
		"OSANTE", 65L);
	return ret_val;
    } else if (*ptcomp != bdpecc_1.compos[(*adres2 << 1) + 128] && *ptcomp != 
	    bdpecc_1.compos[(*adres2 << 1) + 129]) {
	scrtch_("LIGNE:ERREUR:LA 2IEME EXTREMITEE N'APPARTIENT PAS A LA MEME"
		" COMPOSANTE", 70L);
	return ret_val;
    }
/*     chainage des arc et des segments et des splines dans la liste lign 
*/
    nuextr = listed_1.cdr[listea_1.car[*ptcomp - 1] - 1];
    pttbd = listea_1.car[listea_1.car[*ptcomp - 1] - 1];
    if (nuextr != 2 && nuextr != 1) {
	scrtch_("ligne: ERREUR dans chainage composante???...", 44L);
	return ret_val;
    }
/*     recherche de adress */
L3:
    pt = bdpeca_1.conx[nuextr + (pttbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (pttbd << 1) + 127];
    pttbd = pt;
    cote = nuextr;
    if (pttbd != *adress) {
	goto L3;
    } else {
/*       on met en tete l'element adress */
	if (bdpecd_1.fissur[pttbd + 64]) {
	    if (cote == 1) {
		i__1 = cons_(&pttbd, &c__0);
		ret_val = appenx_(&ret_val, &i__1);
	    } else {
		i__2 = -pttbd;
		i__1 = cons_(&i__2, &c__0);
		ret_val = appenx_(&ret_val, &i__1);
	    }
	} else {
	    i__1 = cons_(&pttbd, &c__0);
	    ret_val = appenx_(&ret_val, &i__1);
	}
/*        count=1 */
    }
/*     on suit les chainages conx a partir de adress */
/*     jusqu"a ce que l'on retrouve adres2 */
L2:
    pt = bdpeca_1.conx[nuextr + (pttbd << 1) + 127];
    nuextr = bdpecb_1.cnx[nuextr + (pttbd << 1) + 127];
    pttbd = pt;
    cote = nuextr;
/*     dans le cas ou adress=adres2 on ne veut pas mettre adress 2 fois */
    if (pttbd != *adress) {
/*       on met l'element en fin de liste ligne */
	if (bdpecd_1.fissur[pttbd + 64]) {
	    if (cote == 1) {
		i__1 = cons_(&pttbd, &c__0);
		ret_val = appenx_(&ret_val, &i__1);
	    } else {
		i__2 = -pttbd;
		i__1 = cons_(&i__2, &c__0);
		ret_val = appenx_(&ret_val, &i__1);
	    }
	} else {
	    i__1 = cons_(&pttbd, &c__0);
	    ret_val = appenx_(&ret_val, &i__1);
	}
/*        count=count+1 */
    }
    if (pttbd != *adres2) {
	goto L2;
    }
/*      print*,'ligne: nombre d''elements=',count */
    return ret_val;
} /* ligne_ */




integer ligne1_(integer *adress, integer *ptcomp, integer *adres2)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern integer cons_(integer *, integer *), ligne_(integer *, integer *, 
	    integer *);

/* ---   meme que ligne mais si adress = adres2 => 1 elemet */
/* --   et non tout la composante --- */
    if (*adress == *adres2) {
	ret_val = cons_(adress, &c__0);
    } else {
	ret_val = ligne_(adress, ptcomp, adres2);
    }
    return ret_val;
} /* ligne1_ */

doublereal lngelm_(integer *i)
{
    /* System generated locals */
    real ret_val, r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */

    extern doublereal longsp_(integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2273 = { 0, 6, 0, 0, 0 };



/*     lngelm = longueur de l'element i */


    if (bdpec2_1.bd[*i * 6 + 384] == -3.f) {
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[*i * 6 + 387] - bdpec2_1.bd[*i * 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[*i * 6 + 388] - bdpec2_1.bd[*i * 6 + 386];
	ret_val = sqrt(r__1 * r__1 + r__2 * r__2);
    } else if (bdpec2_1.bd[*i * 6 + 384] == -2.f) {
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[*i * 6 + 387] - bdpec2_1.bd[*i * 6 + 385];
/* Computing 2nd power */
	r__3 = bdpec2_1.bd[*i * 6 + 388] - bdpec2_1.bd[*i * 6 + 386];
	ret_val = sqrt(r__2 * r__2 + r__3 * r__3) * (r__1 = bdpec2_1.bd[*i * 
		6 + 389], dabs(r__1));
    } else if (bdpec2_1.bd[*i * 6 + 384] == -4.f) {
	ret_val = longsp_(i);
    } else {
	s_wsle(&io___2273);
	do_lio(&c__9, &c__1, "LNGELM:TYPE INCONNUE:", 21L);
	do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*i * 6 + 384], (ftnlen)
		sizeof(real));
	do_lio(&c__9, &c__1, " LONGUEURE=0", 12L);
	e_wsle();
	ret_val = 0.f;
    }
    return ret_val;
} /* lngelm_ */




doublereal longsp_(integer *iadr)
{
    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real xgen[2000], ygen[2000];
    integer tgen[500];

    integer n, nbgen, i;
    real densit, xsp[501], ysp[501];
    integer ptt;
    extern /* Subroutine */ int genspl_(real *, real *, integer *, real *, 
	    real *, real *, real *, integer *, integer *, integer *);


/*     retourne la longueur de la spline iadr */


    ptt = bdpec2_1.bd[*iadr * 6 + 386];
    n = 0;
L3:
    if (ptt != 0) {
	++n;
	if (n <= 500) {
	    xsp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 385];
	    ysp[n] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 386];
	    ptt = listed_1.cdr[ptt - 1];
	    goto L3;
	}
    }
    densit = 1.f;
    genspl_(xsp, ysp, &n, &eps_1.eps, &densit, xgen, ygen, &c__2000, &nbgen, 
	    tgen);
    ret_val = 0.f;
    i__1 = nbgen - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = xgen[i - 1] - xgen[i];
/* Computing 2nd power */
	r__2 = ygen[i - 1] - ygen[i];
	ret_val += sqrt(r__1 * r__1 + r__2 * r__2);
/* L4: */
    }
    return ret_val;
} /* longsp_ */




/* Subroutine */ int lookdo_(void)
{
    /* Local variables */

    integer ptdomn;
    extern /* Subroutine */ int voirdo_(integer *);

/*     visualise touts les domaines */


    ptdomn = bdpec1_1.sdomn;
L1:
    if (ptdomn != 0) {
	voirdo_(&ptdomn);
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L1;
    }
    return 0;
} /* lookdo_ */




/* Subroutine */ int lstrgl_(integer *lsttri, integer *mxltr, integer *ntri, 
	integer *jsom, integer *jtri)
{
    /* Initialized data */

    /*static*/ integer p3[3] = { 2,3,1 };

    /* Local variables */
    integer sens, i, t;

    integer t1;
    integer tt;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);

    /* Parameter adjustments */
    --lsttri;

    /* Function Body */
    *ntri = 0;
    if (*jsom != 0) {
	sens = 1;
	t = *jtri;
	tt = t;
L1010:
	++(*ntri);
	if (*ntri <= *mxltr) {
	    lsttri[*ntri] = t;
	}
L1020:
	t1 = t;
	for (i = 1; i <= 3; ++i) {
	    if (bdmsh9_1.nsea[i + t * 6 - 7] == *jsom) {
		if (sens == 1) {
		    t = bdmsh9_1.nsea[i + 3 + t * 6 - 7];
		} else if (sens == -1) {
		    t = bdmsh9_1.nsea[p3[p3[i - 1] - 1] + 3 + t * 6 - 7];
		}
		if (t > 0) {
		    t /= 8;
		} else if (t < 0) {
		    if (! bdpecd_1.fissur[bdmshe_1.refa[-t - 1] + 64]) {
			if (bdmshd_1.areadj[(-t << 1) - 2] / 8 == t1) {
			    t = bdmshd_1.areadj[(-t << 1) - 1] / 8;
			} else {
			    t = bdmshd_1.areadj[(-t << 1) - 2] / 8;
			}
		    }
		}
		if (t <= 0) {
		    sens = -sens;
		    t = tt;
		    if (sens == -1) {
/*                print *,' le triangle change de sens
 ' */
			goto L1020;
		    }
		    goto L1040;
		}
		if (t == tt) {
		    goto L1040;
		}
		goto L1010;
	    }
/* L1030: */
	}
    }
L1040:
/*      print *,' le nombre de voisins du sommet ',jsom,' est :',ntri */
/*      print *,(lsttri(i),i=1,ntri) */
    if (*mxltr < *ntri) {
	scrtch_(" TROPS DE SOMMETS VOISINS D'UN SOMMET", 37L);
	*ntri = 0;
    }
    return 0;
} /* lstrgl_ */




/*     f_lisp */
integer mapc_(S_fp f, integer *l)
{
    /* System generated locals */
    integer ret_val;


/*     mapc applique la routine f sur touts les car(l) */
/*     mapc retourne nil */


    ret_val = *l;
L1:
    if (ret_val != 0) {
	(*f)(&listea_1.car[ret_val - 1]);
	ret_val = listed_1.cdr[ret_val - 1];
	goto L1;
    }
    return ret_val;
} /* mapc_ */

/* Subroutine */ int menumk_(integer *nuumn, integer *l, integer *mark)
{
    /* Initialized data */

    /*static*/ real xcase[4] = { 0.f,1.f,1.f,0.f };
    /*static*/ real ycase[4] = { 0.f,0.f,1.f,1.f };
    /*static*/ real xcas1[4] = { .02f,.98f,.98f,.02f };
    /*static*/ real ycas1[4] = { .02f,.02f,.98f,.98f };

    /* System generated locals */
    address a__1[2];
    integer i__1[2];
    real r__1, r__2, r__3, r__4;
    char ch__1[17];

    /* Builtin functions */
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int clip_(logical *);
    integer numn;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    integer i, j;

    extern /* Subroutine */ int thick_(real *), fentr2_(real *, real *, real *
	    , real *), masqu2_(real *, real *, real *, real *), poly2f_(real *
	    , real *, integer *, integer *, integer *, integer *), drw3tx_(
	    real *, real *, integer *);
    integer coltxt,times=0;
    char marque[1];
    extern /* Subroutine */ int cliphd_(logical *);


/*     elle met le marquage mark dans la case l du menu nuumn */
/*       mark peut valoir: */
/*           vmark marque en v */
/*           cmark marque en carre plein */
/*           qmark marque en q */
/*          unmark demarque la case */
/*      si nuumn est <0 cela signifie pas d'optimisation pour le trace */


    numn = abs(*nuumn);
    if (! pec_1.acmenu[numn - 1]) {
	return 0;
    }
    if (*l <= 0 || *l > pec_1.cmenu[(numn << 1) - 2] * pec_1.cmenu[(numn << 1)
	     - 1]) {
	return 0;
    }
/*     numero de colonne */
    i = (*l - 1) % pec_1.cmenu[(numn << 1) - 1];
/*     numero de ligne */
    j = pec_1.cmenu[(numn << 1) - 2] - (*l - 1) / pec_1.cmenu[(numn << 1) - 1]
	     - 1;
/*     si la case est marque pareille a ce que l'on veut lui mettre */
/*      et que l'on accepte l'optimisation */
    if (pec_1.mkcase[*l + (numn << 5) - 33] == *mark && *nuumn > 0) {
	return 0;
    }
/*       fenetre sur la case */
/*          (pour empecher le debordement du texte (si clipping hard)) */
    r__1 = pec_1.fmenu[(numn << 2) - 4] + (pec_1.fmenu[(numn << 2) - 3] - 
	    pec_1.fmenu[(numn << 2) - 4]) / pec_1.cmenu[(numn << 1) - 1] * i;
    r__2 = pec_1.fmenu[(numn << 2) - 4] + (pec_1.fmenu[(numn << 2) - 3] - 
	    pec_1.fmenu[(numn << 2) - 4]) / pec_1.cmenu[(numn << 1) - 1] * (i 
	    + 1);
    r__3 = pec_1.fmenu[(numn << 2) - 2] + (pec_1.fmenu[(numn << 2) - 1] - 
	    pec_1.fmenu[(numn << 2) - 2]) / pec_1.cmenu[(numn << 1) - 2] * j;
    r__4 = pec_1.fmenu[(numn << 2) - 2] + (pec_1.fmenu[(numn << 2) - 1] - 
	    pec_1.fmenu[(numn << 2) - 2]) / pec_1.cmenu[(numn << 1) - 2] * (j 
	    + 1);
    fentr2_(&r__1, &r__2, &r__3, &r__4);
    masqu2_(&c_b609, &c_b614, &c_b609, &c_b614);
/*     sinon: effacer la case et tracer du contour */
    clip_((logical*)&c__0);
    if (*mark != 0 && pec_1.flcase[*l + (numn << 5) - 33]) {
	poly2f_(xcase, ycase, &c__4, &ctabco_1.fond, &ctabco_1.pafond, &c__2);
	poly2f_(xcas1, ycas1, &c__4, &pec_1.colomn[numn - 1], &ctabco_1.fond, 
		&c__2);
	coltxt = ctabco_1.fond;
    } else {
	poly2f_(xcase, ycase, &c__4, &ctabco_1.fond, &ctabco_1.pafond, &c__2);
	coltxt = pec_1.colomn[numn - 1];
    }
    clip_((logical*)&c__1);
    cliphd_((logical*)&c__1);
    if (pec_1.flcase[*l + (numn << 5) - 33]) {
	pec_1.mkcase[*l + (numn << 5) - 33] = *mark;
	if (pec_1.mkcase[*l + (numn << 5) - 33] != 0) {
	    thick_(&c_b3419);
	} else {
	    thick_(&c_b604);
	}
/*       marquage de la case  l */
	if (*mark == 18) {
	    *marque = '>';
	} else if (*mark == 19) {
	    *marque = '@';
	} else if (*mark == 20) {
	    *marque = '&';
	} else {
/*         ici: (mark.eq.unmark) */
	    *marque = ' ';
	    pec_1.mkcase[*l + (numn << 5) - 33] = 0;
	}
	ligh3_(&c_n1, &c_n1, &coltxt);
/* Computing MAX */
	r__2 = pec_1.szchmn[numn - 1];
	r__1 = dmax(r__2,.2f);
	drw3tx_(&r__1, &c_b609, &times);
/* Writing concatenation */
	i__1[0] = 1, a__1[0] = marque;
	i__1[1] = 16, a__1[1] = pectxt_1.txcase + (*l + (numn << 5) - 33 << 4)
		;
	s_cat(ch__1, a__1, i__1, &c__2, 17L);
	txt2d_(ch__1, &c__17, &c_b5530, &c_b2460, 17L);
	thick_(&c_b604);
	ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
    }
    fentr2_(pec_1.fentre, &pec_1.fentre[1], &pec_1.fentre[2], &pec_1.fentre[3]
	    );
    masqu2_(pec_1.masque, &pec_1.masque[1], &pec_1.masque[2], &pec_1.masque[3]
	    );
    return 0;
} /* menumk_ */




/* Subroutine */ int mkdesi_(integer *typele, integer *typpar, integer *
	typnew)
{
    /* Initialized data */

    static integer aplold = -1;
    static integer numnde = 0;
    static logical flagep[60]	/* was [15][4] */ = { TRUE_,TRUE_,TRUE_,TRUE_,
	    TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,TRUE_,
	    FALSE_,FALSE_,FALSE_,TRUE_,TRUE_,TRUE_,TRUE_,FALSE_,FALSE_,FALSE_,
	    FALSE_,TRUE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,TRUE_,TRUE_,
	    FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,
	    FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,TRUE_,TRUE_,TRUE_,TRUE_,FALSE_,
	    FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_,FALSE_ };

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    integer i, j;
    extern /* Subroutine */ int clean_(void);

    extern /* Subroutine */ int afcalc_(void), affich_(void);
    static integer casele[15], caspar[4];
    extern /* Subroutine */ int inqfac_(logical *), noirci_(real *), enddev_(
	    integer *), afmenu_(integer *), afetat_(void), menumk_(integer *, 
	    integer *, integer *);
    logical ffac;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2319 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2324 = { 0, 6, 0, 0, 0 };


/* ---------------------------------------------------------------------- 
*/
/*      but : marquer les case de la designation courant */
/*      de retourne les types a designer */
/*      et de changer le menu de designation en cas de changement */
/*      d'application */
/* -------------------------------------------------------------------- */
/*     in : */
/*     typele type de l'element designe (cercle,droite ....) precedent */
/*     typpar contraint (+proche,centre,milieu,extremite) precedent */
/*     typnew = nouveau type  si typnew = 0 => init */

/*     out: */
/*      typele type de l'element designe (cercle,droite ....) */
/*      typpar contraint (+proche,centre,milieu,extremite) */
/* --------------------------------------------------------------------- 
*/
/*      correspondance entre nu terminal et nucase */
/*              d_point        =301; */
/*              d_droite       =302; */
/*              d_cercle       =303; */
/*              d_arc          =304; */
/*              d_segment      =305; */
/*              nu              306; */
/*              qlconq         =307; */
/*              sommet         =308; */
/*              triangle       =309; */
/*              arete          =310; */
/*              sous_dom       =311; */
/*              d_spline       =312; */

/*              pt_tablette    =313; */
/*              filexy         =314; */
/*              pt_xy          =315; */

/* --------------   le_plus_proche =351 -------------- */
/* --------------   extremite      =352 -------------- */
/* -------------    centre         =353 -------------- */
/* ------------     milieu         =354 -------------- */
    if (aplold != pec_1.appli || *typnew == -1) {
	inqfac_(&ffac);
/*       inite de casele et caspar si changement de numenu */
	if (numnde > 0) {
	    pec_1.acmenu[numnde - 1] = FALSE_;
	    if (ffac) {
		noirci_(&pec_1.fmenu[(numnde << 2) - 4]);
	    }
	}
	aplold = pec_1.appli;
	if (pec_1.appli == 511) {
	    numnde = 1;
	} else if (pec_1.appli == 513) {
	    numnde = 12;
	} else if (pec_1.appli == 514) {
	    numnde = 13;
	} else {
	    s_wsle(&io___2319);
	    do_lio(&c__9, &c__1, "MKDESI:  PB SOFT DANS LES MENU DESIGNATION "
		    , 43L);
	    do_lio(&c__9, &c__1, "DE L'APPLICATION =", 18L);
	    do_lio(&c__3, &c__1, (char *)&pec_1.appli, (ftnlen)sizeof(integer)
		    );
	    e_wsle();
	    enddev_(&pec_1.devic);
	    s_stop("FATAL ERREUR", 12L);
	}
	pec_1.acmenu[numnde - 1] = TRUE_;
	if (ffac) {
	    noirci_(&pec_1.fmenu[(numnde << 2) - 4]);
	    afmenu_(&numnde);
	    noirci_(pec_1.fentre);
	} else {
/*        tektro ou device sans effacement selectif */
	    clean_();
/*        affichage des menus et des differents cadres */
	    afmenu_(&c__0);
/*        affichage de la zone reservee */
	    afcalc_();
	}
	affich_();
	afetat_();
	for (i = 301; i <= 315; ++i) {
	    casele[i - 301] = 0;
/* L10: */
	}
	for (i = 351; i <= 354; ++i) {
	    caspar[i - 351] = 0;
/* L20: */
	}
	for (i = 1; i <= 32; ++i) {
	    if (pec_1.flcase[i + (numnde << 5) - 33]) {
		j = pec_1.vcase[i + (numnde << 5) - 33];
		if (j >= 301 && j <= 315) {
		    casele[j - 301] = i;
		} else if (j >= 351 && j <= 354) {
		    caspar[j - 351] = i;
		}
	    }
/* L30: */
	}
/*       on unmark toute les cases et on mark quelconque et +_proche 
*/
	goto L100;
    }
    if (*typnew <= 0) {
	return 0;
    }
    if (*typnew >= 301 && *typnew <= 315) {
	if (casele[*typnew - 301] != 0) {
	    if (*typnew != *typele) {
		menumk_(&numnde, &casele[*typele - 301], &c__0);
		*typele = *typnew;
		menumk_(&numnde, &casele[*typele - 301], &c__18);
	    }
	    if (! flagep[*typele + *typpar * 15 - 5566]) {
		menumk_(&numnde, &caspar[*typpar - 351], &c__0);
		*typpar = 351;
		menumk_(&numnde, &caspar[*typpar - 351], &c__18);
	    }
	    return 0;
	}
    } else if (*typnew >= 351 && *typnew <= 354) {
	if (caspar[*typnew - 351] != 0) {
	    if (*typnew != *typpar) {
		menumk_(&numnde, &caspar[*typpar - 351], &c__0);
		*typpar = *typnew;
		menumk_(&numnde, &caspar[*typpar - 351], &c__18);
	    }
	    if (! flagep[*typele + *typpar * 15 - 5566]) {
		menumk_(&numnde, &casele[*typele - 301], &c__0);
		*typele = 307;
		menumk_(&numnde, &casele[*typele - 301], &c__18);
	    }
	    return 0;
	}
    }
    s_wsle(&io___2324);
    do_lio(&c__9, &c__1, " MKDESI : BIZARRE CASE INCONNUE ", 32L);
    do_lio(&c__3, &c__1, (char *)&(*typnew), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " ON MET EN + PROCHE QUELCONQUE", 30L);
    do_lio(&c__3, &c__1, (char *)&numnde, (ftnlen)sizeof(integer));
    e_wsle();
L100:
    for (i = 1; i <= 32; ++i) {
	if (pec_1.flcase[i + (numnde << 5) - 33]) {
	    menumk_(&numnde, &i, &c__0);
	}
/* L40: */
    }
    *typele = 307;
    *typpar = 351;
    menumk_(&numnde, &caspar[*typpar - 351], &c__18);
    menumk_(&numnde, &casele[*typele - 301], &c__18);
    return 0;
} /* mkdesi_ */




/* Subroutine */ int msha1p_(integer *t, integer *s, integer *c, integer *nu, 
	integer *reft, integer *tete, integer *nbt, integer *nbs, integer *
	iop, integer *err)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer i, t1, t2, t3, ia2, ia3;
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *);
    integer ta2, ta3;
    extern /* Subroutine */ int mshopt_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *);
    integer tta;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2326 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2333 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2336 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2337 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2338 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2339 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    --reft;
    nu -= 7;
    c -= 3;

    /* Function Body */
    t1 = *t;
    if (*iop % 10 >= 9) {
	s_wsle(&io___2326);
	do_lio(&c__9, &c__1, " t old", 6L);
	do_lio(&c__3, &c__1, (char *)&(*t), (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t1 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
    }
    if (*tete == 0) {
	++(*nbt);
	t2 = *nbt;
    } else {
	t2 = *tete;
	*tete = nu[*tete * 6 + 1];
    }
    if (*tete == 0) {
	++(*nbt);
	t3 = *nbt;
    } else {
	t3 = *tete;
	*tete = nu[*tete * 6 + 1];
    }
    nu[t2 * 6 + 1] = *s;
    nu[t2 * 6 + 2] = nu[*t * 6 + 2];
    nu[t2 * 6 + 3] = nu[*t * 6 + 3];
    nu[t2 * 6 + 4] = (t1 << 3) + 5;
    nu[t2 * 6 + 5] = nu[*t * 6 + 5];
    nu[t2 * 6 + 6] = (t3 << 3) + 5;
    nu[t3 * 6 + 1] = nu[*t * 6 + 1];
    nu[t3 * 6 + 2] = *s;
    nu[t3 * 6 + 3] = nu[*t * 6 + 3];
    nu[t3 * 6 + 4] = (t1 << 3) + 6;
    nu[t3 * 6 + 5] = (t2 << 3) + 6;
    nu[t3 * 6 + 6] = nu[*t * 6 + 6];
    tta = nu[*t * 6 + 5];
    if (tta > 0) {
	ta2 = tta / 8;
	ia2 = tta - (ta2 << 3);
	nu[ia2 + ta2 * 6] = (t2 << 3) + 5;
	if (*iop % 10 >= 9) {
	    s_wsle(&io___2333);
	    do_lio(&c__9, &c__1, " ta2 ", 5L);
	    do_lio(&c__3, &c__1, (char *)&ta2, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&ia2, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 6; ++i) {
		do_lio(&c__3, &c__1, (char *)&nu[i + ta2 * 6], (ftnlen)sizeof(
			integer));
	    }
	    e_wsle();
	}
    }
    tta = nu[*t * 6 + 6];
    if (tta > 0) {
	ta3 = tta / 8;
	ia3 = tta - (ta3 << 3);
	nu[ia3 + ta3 * 6] = (t3 << 3) + 6;
	if (*iop % 10 >= 9) {
	    s_wsle(&io___2336);
	    do_lio(&c__9, &c__1, " ta3 ", 5L);
	    do_lio(&c__3, &c__1, (char *)&ta3, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&ia3, (ftnlen)sizeof(integer));
	    for (i = 1; i <= 6; ++i) {
		do_lio(&c__3, &c__1, (char *)&nu[i + ta3 * 6], (ftnlen)sizeof(
			integer));
	    }
	    e_wsle();
	}
    }
    nu[t1 * 6 + 3] = *s;
    nu[t1 * 6 + 5] = (t2 << 3) + 4;
    nu[t1 * 6 + 6] = (t3 << 3) + 4;
    reft[t2] = reft[*t];
    reft[t3] = reft[*t];
    if (*iop >= 50) {
	mshdrw_(&c[3], &nu[7], &c__6, &t1, iop);
    }
    if (*iop >= 50) {
	mshdrw_(&c[3], &nu[7], &c__6, &t2, iop);
    }
    if (*iop >= 50) {
	mshdrw_(&c[3], &nu[7], &c__6, &t3, iop);
    }
    if (*iop % 10 >= 9) {
	s_wsle(&io___2337);
	do_lio(&c__9, &c__1, " t1 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t1, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t1 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
	s_wsle(&io___2338);
	do_lio(&c__9, &c__1, " t2 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t2, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t2 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
	s_wsle(&io___2339);
	do_lio(&c__9, &c__1, " t3 ", 4L);
	do_lio(&c__3, &c__1, (char *)&t3, (ftnlen)sizeof(integer));
	for (i = 1; i <= 6; ++i) {
	    do_lio(&c__3, &c__1, (char *)&nu[i + t3 * 6], (ftnlen)sizeof(
		    integer));
	}
	e_wsle();
    }
    mshopt_(&c[3], &nu[7], &t1, &c__4, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    mshopt_(&c[3], &nu[7], &t2, &c__5, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    mshopt_(&c[3], &nu[7], &t3, &c__6, nbs, iop, err);
    if (*err != 0) {
	return 0;
    }
    return 0;
} /* msha1p_ */

/* Subroutine */ int mshcvx_(logical *direct, integer *c, integer *nu, 
	integer *pfold, integer *nbs, integer *iop, integer *err)
{
    integer t, a4, a5, i1, i2, i3, i4, i5, i6, s1, s2, s3, t4, t5, pf, pp, ps;
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *), mshopt_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *);
    integer tt4, tt5, det, ppf, psf;

    /* Parameter adjustments */
    nu -= 7;
    c -= 3;

    /* Function Body */
    if (*direct) {
	pp = 3;
	ps = 4;
	i1 = 1;
	i2 = 3;
	i3 = 2;
	i4 = 6;
	i5 = 5;
	i6 = 4;
    } else {
	pp = 4;
	ps = 3;
	i1 = 1;
	i2 = 2;
	i3 = 3;
	i4 = 4;
	i5 = 5;
	i6 = 6;
    }
L10:
    ppf = *pfold;
    pf = nu[ps + *pfold * 6];
    psf = nu[ps + pf * 6];
    s1 = nu[ppf * 6 + 1];
    s2 = nu[pf * 6 + 1];
    s3 = nu[psf * 6 + 1];
    det = (c[(s2 << 1) + 1] - c[(s1 << 1) + 1]) * (c[(s3 << 1) + 2] - c[(s1 <<
	     1) + 2]) - (c[(s2 << 1) + 2] - c[(s1 << 1) + 2]) * (c[(s3 << 1) 
	    + 1] - c[(s1 << 1) + 1]);
/*      print *,' mshcvx convexification de ', s1,s2,s3,det,direct */
    if (! (*direct) && det > 0 || *direct && det < 0) {
/*       on ajoute un triangle t et on detruit une arete */
/*       ----------------------------------------------- */
	if (*direct) {
	    tt4 = nu[ppf * 6 + 2];
	    tt5 = nu[pf * 6 + 2];
	} else {
	    tt4 = nu[pf * 6 + 2];
	    tt5 = nu[psf * 6 + 2];
	}
	t4 = tt4 / 8;
	t5 = tt5 / 8;
	a4 = tt4 - (t4 << 3);
	a5 = tt5 - (t5 << 3);
/*       destruction de l'arete frontiere en pf */
/*       -------------------------------------- */
	nu[ps + ppf * 6] = psf;
	nu[pp + psf * 6] = ppf;
/*       on remplace l'arete frontiere par l'element genere */
/*       --------------------------------------------------- */
	t = pf;
/*       update de l'arete non detruite */
/*       ------------------------------ */
	if (*direct) {
	    nu[ppf * 6 + 2] = (t << 3) + i6;
	} else {
	    nu[psf * 6 + 2] = (t << 3) + i6;
	}
/*       on cree l'element */
/*       ----------------- */
	nu[i1 + t * 6] = s1;
	nu[i2 + t * 6] = s2;
	nu[i3 + t * 6] = s3;
	nu[i4 + t * 6] = (t4 << 3) + a4;
	nu[i5 + t * 6] = (t5 << 3) + a5;
	if (*direct) {
	    nu[i6 + t * 6] = -ppf;
	} else {
	    nu[i6 + t * 6] = -psf;
	}
	nu[a4 + t4 * 6] = (t << 3) + i4;
	nu[a5 + t5 * 6] = (t << 3) + i5;
	if (*iop >= 50) {
	    mshdrw_(&c[3], &nu[7], &c__6, &t, iop);
	}
	mshopt_(&c[3], &nu[7], &t5, &a5, nbs, iop, err);
	if (*err != 0) {
	    return 0;
	}
	goto L10;
    }
    return 0;
} /* mshcvx_ */

/* Subroutine */ int mshcxi_(integer *c, integer *nu, integer *tri, integer *
	nbs, integer *tete, integer *iop, integer *err)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer free, ttaf, i, j, s, t, pf;
    extern integer mshlcl_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *), mshcvx_(logical *, integer *, integer *, 
	    integer *, integer *, integer *, integer *), mshopt_(integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    integer iaf, taf, npf, ppf, psf;

/*     initialisation de la free liste dans nu */
    /* Parameter adjustments */
    --tri;
    nu -= 7;
    c -= 3;

    /* Function Body */
    i__1 = *nbs + *nbs - 2;
    for (i = 1; i <= i__1; ++i) {
	nu[i * 6 + 1] = i + 1;
	for (j = 2; j <= 6; ++j) {
	    nu[j + i * 6] = 0;
/* L10: */
	}
    }
    nu[(*nbs + *nbs - 2) * 6 + 1] = 0;
    free = 1;
/*     initialisation du premier triangle */
    t = free;
    free = nu[free * 6 + 1];
/*     initialisation de la liste frontiere */
    *tete = free;
    pf = free;
    for (i = 1; i <= 3; ++i) {
	nu[i + t * 6] = tri[i];
	nu[i + 3 + t * 6] = -pf;
	ppf = pf;
	free = nu[pf * 6 + 1];
	pf = free;
	if (i == 3) {
	    pf = *tete;
	}
	nu[ppf * 6 + 1] = tri[i];
	nu[ppf * 6 + 2] = i + 3 + (t << 3);
	nu[ppf * 6 + 4] = pf;
	nu[pf * 6 + 3] = ppf;
/* L20: */
    }
    if (*iop >= 50) {
	mshdrw_(&c[3], &nu[7], &c__6, &t, iop);
    }
/*      print *,' free =',free,' nu =' */
/*      print '(6(i12))',((nu(i,j),i=1,6).j=1,4) */
    i__1 = *nbs;
    for (i = 4; i <= i__1; ++i) {
	s = tri[i];
/*       print *,' on attaque le sommet ',s */
/*       print *,'++++++++++++++++++++++++++++++' */
	pf = mshlcl_(&c[3], &nu[7], tete, &s, nbs);
/*      creation d'un nouveau triangle et modification de la frontiere
 */
/*      --------------------------------------------------------------
 */
	t = free;
	free = nu[free * 6 + 1];
	npf = free;
	free = nu[free * 6 + 1];
	psf = nu[pf * 6 + 4];
	ttaf = nu[pf * 6 + 2];
	taf = ttaf / 8;
	iaf = ttaf - (taf << 3);

/*                  npf */
/*               1  x s               --- */
/*                 / \                --- */
/*              4 /   \ 6        ---  vide --- */
/*               /  t  \              --- */
/*            2 /   5   \ 3           --- */
/* ------ --<---x---------x---------x- frontiere--<--- */
/*          psf \  iaf  /  pf         --- */
/*               \ taf /         --- omega --- */
/*                \   /               --- */
/*                 \ /                --- */
/*                  x                 --- */
/*                                    --- */
/*     generation  de l'element t */
	nu[t * 6 + 1] = s;
	nu[t * 6 + 2] = nu[psf * 6 + 1];
	nu[t * 6 + 3] = nu[pf * 6 + 1];
	nu[t * 6 + 4] = -npf;
	nu[t * 6 + 5] = (taf << 3) + iaf;
	nu[t * 6 + 6] = -pf;
	nu[iaf + taf * 6] = (t << 3) + 5;
/*      update de la liste frontiere */
	nu[npf * 6 + 4] = psf;
	nu[pf * 6 + 4] = npf;
	nu[npf * 6 + 3] = pf;
	nu[psf * 6 + 3] = npf;
	nu[npf * 6 + 1] = s;
	nu[npf * 6 + 2] = (t << 3) + 4;
	nu[pf * 6 + 2] = (t << 3) + 6;
	if (*iop >= 50) {
	    mshdrw_(&c[3], &nu[7], &c__6, &t, iop);
	}
	mshopt_(&c[3], &nu[7], &t, &c__5, nbs, iop, err);
	if (*err != 0) {
	    return 0;
	}
	mshcvx_((logical*)&c__1, &c[3], &nu[7], &npf, nbs, iop, err);
	if (*err != 0) {
	    return 0;
	}
	mshcvx_((logical*)&c__0, &c[3], &nu[7], &npf, nbs, iop, err);
	if (*err != 0) {
	    return 0;
	}
/* L30: */
    }
    return 0;
} /* mshcxi_ */

/* Subroutine */ int mshdr1_(real *c, integer *nu, integer *i6, integer *t, 
	integer *iop)
{
    /* System generated locals */
    integer nu_dim1, nu_offset;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_paus(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    integer i;
    real x, y;
    extern /* Subroutine */ int poly2f_(real *, real *, integer *, integer *, 
	    integer *, integer *);
    real xx[4], yy[4];
    char ch3[3];


/* routine de trace d un triangle */
/* ------------------------------- */
    /* Parameter adjustments */
    nu_dim1 = *i6;
    nu_offset = nu_dim1 + 1;
    nu -= nu_offset;
    c -= 3;

    /* Function Body */
    for (i = 1; i <= 3; ++i) {
	xx[i - 1] = c[(nu[i + *t * nu_dim1] << 1) + 1];
	yy[i - 1] = c[(nu[i + *t * nu_dim1] << 1) + 2];
/* L10: */
    }
    poly2f_(xx, yy, &c__3, &ctabco_1.fond, &ctabco_1.pafond, &c__2);
    if (*iop >= 90) {
	x = (xx[0] + xx[1] + xx[2]) / 3;
	y = (yy[0] + yy[1] + yy[2]) / 3;
	ligh3_(&c_n1, &c_n1, &ctabco_1.rouges);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = 3;
	ici__1.iciunit = ch3;
	ici__1.icifmt = "(i3)";
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&(*t), (ftnlen)sizeof(integer));
	e_wsfi();
	txt2d_(ch3, &c__3, &x, &y, 3L);
    }
    if (*iop >= 100) {
	s_paus("", 0L);
    }
    return 0;
} /* mshdr1_ */

#undef coulls


/* Subroutine */ int mshdrw_(integer *c, integer *nu, integer *i6, integer *t,
	 integer *iop)
{
    /* System generated locals */
    integer nu_dim1, nu_offset;
    real r__1, r__2;
    icilist ici__1;

    /* Builtin functions */
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;
    /* Subroutine */ int s_paus(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);
    real x, y;
    integer i1, i2, i3;
    extern /* Subroutine */ int debfac_(integer *), lin2to_(real *, real *), 
	    mov2to_(real *, real *), finfac_(void);
    char ch3[3];

    /* Parameter adjustments */
    nu_dim1 = *i6;
    nu_offset = nu_dim1 + 1;
    nu -= nu_offset;
    c -= 3;

    /* Function Body */
    ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
/*      if(mod(iop,10).eq.9) */
/*     &   print *,'mshdrw :t=',t,('x,y=',(c(j,nu(k,t)),j=1,2),k=1,3) */
    debfac_(&c__0);
    r__1 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 2];
    mov2to_(&r__1, &r__2);
    r__1 = (real) c[(nu[*t * nu_dim1 + 2] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 2] << 1) + 2];
    lin2to_(&r__1, &r__2);
    r__1 = (real) c[(nu[*t * nu_dim1 + 3] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 3] << 1) + 2];
    lin2to_(&r__1, &r__2);
    finfac_();
    i1 = nu[*t * nu_dim1 + 1];
    i2 = nu[*t * nu_dim1 + 2];
    i3 = nu[*t * nu_dim1 + 3];
    x = (real) ((c[(i1 << 1) + 1] + c[(i2 << 1) + 1] + c[(i3 << 1) + 1]) / 3);
    y = (real) ((c[(i1 << 1) + 2] + c[(i2 << 1) + 2] + c[(i3 << 1) + 2]) / 3);
    ligh3_(&c_n1, &c_n1, &ctabco_1.rouges);
    ici__1.icierr = 0;
    ici__1.icirnum = 1;
    ici__1.icirlen = 3;
    ici__1.iciunit = ch3;
    ici__1.icifmt = "(i3)";
    s_wsfi(&ici__1);
    do_fio(&c__1, (char *)&(*t), (ftnlen)sizeof(integer));
    e_wsfi();
    if (*iop >= 90) {
	txt2d_(ch3, &c__3, &x, &y, 3L);
    }
    ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
    r__1 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 2];
    mov2to_(&r__1, &r__2);
    r__1 = (real) c[(nu[*t * nu_dim1 + 2] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 2] << 1) + 2];
    lin2to_(&r__1, &r__2);
    r__1 = (real) c[(nu[*t * nu_dim1 + 3] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 3] << 1) + 2];
    lin2to_(&r__1, &r__2);
    r__1 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 1];
    r__2 = (real) c[(nu[*t * nu_dim1 + 1] << 1) + 2];
    lin2to_(&r__1, &r__2);
/*      print *,(nu(i,t),i=1,6) */
    if (*iop >= 100) {
	s_paus("", 0L);
    }
    return 0;
} /* mshdrw_ */

#undef coulls


/* Subroutine */ int mshdwe_(integer *t)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, s4[4];

    extern /* Subroutine */ int poly2f_(real *, real *, integer *, integer *, 
	    integer *, integer *);
    extern integer mshele_(integer *, integer *, integer *);
    integer ra4[4], nse;

    real xxx[4], yyy[4];

/* -------------------------------------------------------------- */
/*  but : effacer et trace l'element t */
/* -------------------------------------------------------------- */
    i__1 = -(*t);
    nse = mshele_(&i__1, s4, ra4);
    i__1 = nse;
    for (i = 1; i <= i__1; ++i) {
	xxx[i - 1] = bdmsh5_1.cr[(s4[i - 1] << 1) - 2];
	yyy[i - 1] = bdmsh5_1.cr[(s4[i - 1] << 1) - 1];
/* L10: */
    }
    poly2f_(xxx, yyy, &nse, &ctabco_1.fond, &ctabco_1.pafond, &c__2);
    return 0;
} /* mshdwe_ */




integer mshele_(integer *tt, integer *s4, integer *ra4)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer i, j, k, t;

    extern integer rfaret_(integer *, integer *);

/* -----------------------------------------------------------------------
 */
/*     but: donne les sommet de l'element t */
/*   1)  si tt est negatif on donne toujours les sommets de l'element */
/*      construit a partir du triangle   abs(tt) */
/*   2)   si tt est positif on ne donne les sommets est un triangle ou */
/*        si cette un quadrangle forme des triangles tt et tt1 et tt>tt1 
*/
/*       le second cas permet de ne pas dupliquer les quadrangles */
/* -----------------------------------------------------------------------
 */
    /* Parameter adjustments */
    --ra4;
    --s4;

    /* Function Body */
    t = abs(*tt);
    if (t > 0 && t <= bdmsh1_1.nbt) {
	if (bdmsh9_1.nsea[t * 6 - 6] > 0) {
	    if (bdmshb_1.apavue[t - 1] >= 1 && bdmshb_1.apavue[t - 1] <= 3) {
		i = bdmsh9_1.nsea[bdmshb_1.apavue[t - 1] + 3 + t * 6 - 7];
		j = i / 8;
/* x            i = i - (2**3)*j */
		if (j > 0 && j > *tt) {
		    k = mod3[bdmshb_1.apavue[t - 1] - 1];
		    s4[1] = bdmsh9_1.nsea[k + t * 6 - 7];
		    i__1 = k + 3;
		    ra4[1] = rfaret_(&t, &i__1);
		    k = mod3[k - 1];
		    s4[2] = bdmsh9_1.nsea[k + t * 6 - 7];
		    i__1 = k + 3;
		    ra4[2] = rfaret_(&t, &i__1);
		    k = mod3[k - 1];
		    s4[3] = bdmsh9_1.nsea[k + t * 6 - 7];
		    k = mod3[bdmshb_1.apavue[j - 1] - 1];
		    i__1 = k + 3;
		    ra4[3] = rfaret_(&j, &i__1);
		    k = mod3[k - 1];
		    s4[4] = bdmsh9_1.nsea[k + j * 6 - 7];
		    i__1 = k + 3;
		    ra4[4] = rfaret_(&j, &i__1);
		    ret_val = 4;
		} else {
		    ret_val = 0;
		}
	    } else {
		s4[1] = bdmsh9_1.nsea[t * 6 - 6];
		s4[2] = bdmsh9_1.nsea[t * 6 - 5];
		s4[3] = bdmsh9_1.nsea[t * 6 - 4];
		ra4[1] = rfaret_(&t, &c__4);
		ra4[2] = rfaret_(&t, &c__5);
		ra4[3] = rfaret_(&t, &c__6);
		ret_val = 3;
	    }
	} else {
	    ret_val = 0;
	}
    } else {
	ret_val = 0;
    }
    return ret_val;
} /* mshele_ */




/* Subroutine */ int mshfr1_(integer *c, integer *nu, integer *nbs, integer *
	it1, integer *ita, integer *is1, integer *s2, integer *iop, integer *
	err)
{
    /* Initialized data */

    /*static*/ integer p3[5] = { 2,3,1,2,3 };

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer nbac, t, x, y, l1, l2, s1, s3;
    extern /* Subroutine */ int mshfr2_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    integer la, ta;
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *);
    integer det, lst[768]	/* was [3][256] */;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2414 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2417 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2420 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    nu -= 7;
    c -= 3;

    /* Function Body */
    t = *it1;
    s1 = nu[*is1 + t * 6];
    x = c[(*s2 << 1) + 1] - c[(s1 << 1) + 1];
    y = c[(*s2 << 1) + 2] - c[(s1 << 1) + 2];
    nbac = 0;
    l1 = *is1;
    l2 = p3[l1 - 1];
/*      l3 = p3(l2) */
    la = l2 + 3;
/*      print *,'  mshfr1 :',it1,is1,s1,s2 */
L20:
    ++nbac;
    if (nbac > 256) {
	s_wsle(&io___2414);
	do_lio(&c__9, &c__1, " fatal ERROR mshfr1 : lst trop petit ", 37L);
	do_lio(&c__3, &c__1, (char *)&nbac, (ftnlen)sizeof(integer));
	do_lio(&c__3, &c__1, (char *)&c__256, (ftnlen)sizeof(integer));
	e_wsle();
	*err = 8;
	return 0;
    }
    lst[nbac * 3 - 2] = t;
    lst[nbac * 3 - 1] = la;
    if (*iop >= 70) {
	mshdrw_(&c[3], &nu[7], &c__6, &t, iop);
    }
    ta = nu[la + t * 6];
    if (ta <= 0) {
	s_wsle(&io___2417);
	do_lio(&c__9, &c__1, " fatal ERROR mshfr1:la frontiere est croisee e"
		"n ", 48L);
	do_lio(&c__3, &c__1, (char *)&t, (ftnlen)sizeof(integer));
	e_wsle();
	*err = 9;
	return 0;
    }
    t = ta / 8;
    la = ta - (t << 3);
    s3 = nu[p3[la - 3] + t * 6];
    if (s3 != *s2) {
	det = x * (c[(s3 << 1) + 2] - c[(s1 << 1) + 2]) - y * (c[(s3 << 1) + 
		1] - c[(s1 << 1) + 1]);
/*        print *,' s3 = ',s3,det */
	if (det > 0) {
	    la = p3[la - 4] + 3;
	} else if (det < 0) {
	    la = p3[la - 3] + 3;
	} else {
	    s_wsle(&io___2420);
	    do_lio(&c__9, &c__1, " fatal ERROR mshfr1: le point ", 30L);
	    do_lio(&c__3, &c__1, (char *)&s3, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " qui ne doit pas etre frontiere , l'est", 
		    39L);
	    e_wsle();
	    *err = 10;
	    return 0;
	}
	goto L20;
    }
/*     c'est la que l'on peut construire la nouvelle frontiere */
/*     avec lst,nbac */
    if (*iop >= 70) {
	mshdrw_(&c[3], &nu[7], &c__6, &t, iop);
    }
    mshfr2_(&c[3], &nu[7], nbs, lst, &nbac, it1, ita, &s1, s2, iop, err);
    return 0;
} /* mshfr1_ */

/* Subroutine */ int mshfr2_(integer *c, integer *nu, integer *nbs, integer *
	lst, integer *nbac, integer *t, integer *ta, integer *ss1, integer *
	ss2, integer *iop, integer *err)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, x, y, a1, a2, pplst, s1, pslst, ptlst, s2, s3, s4, ttlst, t1, 
	    t2, aa, i11, i12, i13, i21, i22, i23, x41, y41, tt;
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *), mshopt_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *);
    integer tt1, aas, det1, det2, det3, det4;

    /* Parameter adjustments */
    lst -= 4;
    nu -= 7;
    c -= 3;

    /* Function Body */
    x = c[(*ss1 << 1) + 1] - c[(*ss2 << 1) + 1];
    y = c[(*ss1 << 1) + 2] - c[(*ss2 << 1) + 2];
    i__1 = *nbac - 1;
    for (i = 1; i <= i__1; ++i) {
	lst[i * 3 + 1] = i + 1;
/* L10: */
    }
    lst[*nbac * 3 + 1] = 0;
    ttlst = 1;
L20:
    ptlst = ttlst;
    pplst = 0;
L30:
    if (ptlst > 0) {
	t1 = lst[ptlst * 3 + 2];
	a1 = lst[ptlst * 3 + 3];
	tt1 = nu[a1 + t1 * 6];
	t2 = tt1 / 8;
	a2 = tt1 - (t2 << 3);
	i11 = a1 - 3;
	i12 = mod3[i11 - 1];
	i13 = mod3[i12 - 1];
	i21 = a2 - 3;
	i22 = mod3[i21 - 1];
	i23 = mod3[i22 - 1];
	s1 = nu[i13 + t1 * 6];
	s2 = nu[i11 + t1 * 6];
	s3 = nu[i12 + t1 * 6];
	s4 = nu[i23 + t2 * 6];
	x41 = c[(s4 << 1) + 1] - c[(s1 << 1) + 1];
	y41 = c[(s4 << 1) + 2] - c[(s1 << 1) + 2];
	det2 = (c[(s2 << 1) + 1] - c[(s1 << 1) + 1]) * y41 - (c[(s2 << 1) + 2]
		 - c[(s1 << 1) + 2]) * x41;
	det3 = (c[(s3 << 1) + 1] - c[(s1 << 1) + 1]) * y41 - (c[(s3 << 1) + 2]
		 - c[(s1 << 1) + 2]) * x41;
	if (det2 > 0 && det3 < 0) {
/*         le quadrilataire est convexe on le retourne */
/*         update des sommets */
/* ------------------------- */
	    nu[i12 + t1 * 6] = s4;
	    nu[i22 + t2 * 6] = s1;
/*         update du pointeur suivant */
/* ----------------------------------- */
	    pslst = lst[ptlst * 3 + 1];
	    if (pslst > 0) {
		aas = lst[pslst * 3 + 3];
		if (aas == i22 + 3) {
		    lst[pslst * 3 + 2] = t1;
		    lst[pslst * 3 + 3] = i11 + 3;
		}
	    }
/*         update des aretes a1,a2 */
/* ------------------------------- */
	    tt1 = nu[i22 + 3 + t2 * 6];
	    nu[a1 + t1 * 6] = tt1;
	    if (tt1 > 0) {
		tt = tt1 / 8;
		aa = tt1 - (tt << 3);
		nu[aa + tt * 6] = a1 + (t1 << 3);
	    } else if (tt1 != -1073741824) {
		nu[-tt1 * 6 + 2] = a1 + (t1 << 3);
	    }
	    tt1 = nu[i12 + 3 + t1 * 6];
	    nu[a2 + t2 * 6] = tt1;
	    if (tt1 > 0) {
		tt = tt1 / 8;
		aa = tt1 - (tt << 3);
		nu[aa + tt * 6] = a2 + (t2 << 3);
	    } else if (tt1 != -1073741824) {
		nu[-tt1 * 6 + 2] = a2 + (t2 << 3);
	    }
	    nu[i12 + 3 + t1 * 6] = i22 + 3 + (t2 << 3);
	    nu[i22 + 3 + t2 * 6] = i12 + 3 + (t1 << 3);
	    det1 = (c[(s1 << 1) + 1] - c[(*ss1 << 1) + 1]) * y - (c[(s1 << 1) 
		    + 2] - c[(*ss1 << 1) + 2]) * x;
	    det4 = (c[(s4 << 1) + 1] - c[(*ss1 << 1) + 1]) * y - (c[(s4 << 1) 
		    + 2] - c[(*ss1 << 1) + 2]) * x;
	    if (*iop >= 50) {
		mshdrw_(&c[3], &nu[7], &c__6, &t1, iop);
	    }
	    if (*iop >= 50) {
		mshdrw_(&c[3], &nu[7], &c__6, &t2, iop);
	    }
	    if (det1 < 0 && det4 > 0) {
/*           le sommets s4 est dans omega */
		lst[ptlst * 3 + 2] = t2;
		lst[ptlst * 3 + 3] = i22 + 3;
	    } else if (det1 > 0 && det4 < 0) {
/*           le sommets s1 est dans omega */
		lst[ptlst * 3 + 2] = t1;
		lst[ptlst * 3 + 3] = i12 + 3;
	    } else {
/*           print *,'    on supprime l''arete dans  lst ',t1,
a1,t2,a2 */
		if (pplst == 0) {
		    ttlst = lst[ptlst * 3 + 1];
		    ptlst = ttlst;
		} else {
		    ptlst = lst[ptlst * 3 + 1];
		    lst[pplst * 3 + 1] = ptlst;
		}
		goto L30;
	    }
	}
	pplst = ptlst;
	ptlst = lst[ptlst * 3 + 1];
	goto L30;
    }
    if (ttlst != 0) {
	goto L20;
    }
    nu[i12 + 3 + t1 * 6] = -1073741824;
    nu[i22 + 3 + t2 * 6] = -1073741824;
    *t = t2;
    *ta = t1;
    i__1 = *nbac;
    for (i = 1; i <= i__1; ++i) {
	mshopt_(&c[3], &nu[7], &lst[i * 3 + 2], &c__4, nbs, iop, err);
	mshopt_(&c[3], &nu[7], &lst[i * 3 + 2], &c__5, nbs, iop, err);
	mshopt_(&c[3], &nu[7], &lst[i * 3 + 2], &c__6, nbs, iop, err);
/* L40: */
    }
    return 0;
} /* mshfr2_ */

/* Subroutine */ int mshfrt_(integer *c, integer *nu, integer *nbs, integer *
	arete, integer *nba, integer *sd, integer *nbsd, integer *reft, 
	integer *w, integer *iop, integer *err)
{
    /* Initialized data */

    /*static*/ integer p3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;
    cilist ci__1;

    /* Builtin functions */
    /* Subroutine */ int s_paus(char *, ftnlen);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void);

    /* Local variables */
    integer nbac;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    integer a;
    extern /* Subroutine */ int txt2d_(char *, integer *, real *, real *, 
	    ftnlen);
    integer i, j, t, itera, impre, s1, s2;
    extern /* Subroutine */ int mshfr1_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *),
	     lin2to_(real *, real *);
    integer ie, ap, ta;
    extern /* Subroutine */ int mov2to_(real *, real *);
    integer is, nbacpp;
    extern /* Subroutine */ int clnfnt_(void);
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *);
    integer is1, ss1, s2t, s3t, isd, jsd, nbt, det2, det3, err1;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2462 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2466 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2467 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2468 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2469 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2470 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2471 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2472 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2474 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2475 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2487 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2488 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2489 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2492 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2493 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2494 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2495 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2496 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2497 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2498 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    --w;
    --reft;
    sd -= 3;
    arete -= 3;
    nu -= 7;
    c -= 3;

    /* Function Body */
    impre = *iop % 10;
    if (*nba == 0) {
	return 0;
    }
    nbt = *nbs + *nbs - 2;
    if (*iop >= 70) {
	s_paus("", 0L);
	clnfnt_();
	ligh3_(&c_n1, &c_n1, &ctabco_1.verts);
    }
    i__1 = *nbs;
    for (i = 1; i <= i__1; ++i) {
	reft[i] = 0;
/* L10: */
    }
    i__1 = *nba;
    for (i = 1; i <= i__1; ++i) {
	reft[arete[(i << 1) + 1]] = -1073741824;
	reft[arete[(i << 1) + 2]] = -1073741824;
/* L20: */
    }
    nbac = 0;
    i__1 = *nba;
    for (a = 1; a <= i__1; ++a) {
/* Computing MIN */
	i__2 = arete[(a << 1) + 1], i__3 = arete[(a << 1) + 2];
	s1 = min(i__2,i__3);
/* Computing MAX */
	i__2 = arete[(a << 1) + 1], i__3 = arete[(a << 1) + 2];
	s2 = max(i__2,i__3);
	if (s1 == s2) {
	    s_wsle(&io___2462);
	    do_lio(&c__9, &c__1, " WARNING :mshfrt l'arete ", 25L);
	    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " de sommets :", 13L);
	    do_lio(&c__3, &c__1, (char *)&s1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&s2, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " est degeneree", 14L);
	    e_wsle();
	    ++nbac;
	} else {
	    w[a] = reft[s1];
	    reft[s1] = a;
	    if (*iop >= 50) {
		r__1 = (real) c[(s1 << 1) + 1];
		r__2 = (real) c[(s1 << 1) + 2];
		mov2to_(&r__1, &r__2);
		r__1 = (real) c[(s2 << 1) + 1];
		r__2 = (real) c[(s2 << 1) + 2];
		lin2to_(&r__1, &r__2);
	    }
	}
/* L30: */
    }
    nbacpp = 1;
    itera = 0;
    err1 = 0;
L50:
    ++itera;
    if (err1 != 0) {
	*err = err1;
	return 0;
    }
    if (nbac < *nba) {
	if (nbacpp == 0) {
	    s_wsle(&io___2466);
	    do_lio(&c__9, &c__1, " fatal ERROR mshfrt :l'algorithme boucle :",
		     42L);
	    do_lio(&c__3, &c__1, (char *)&(*nba), (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&nbac, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " iteration =", 12L);
	    do_lio(&c__3, &c__1, (char *)&itera, (ftnlen)sizeof(integer));
	    e_wsle();
	    if (impre >= 9) {
		s_wsle(&io___2467);
		do_lio(&c__9, &c__1, " dump ", 6L);
		e_wsle();
		s_wsle(&io___2468);
		do_lio(&c__9, &c__1, " nbt = ", 7L);
		do_lio(&c__3, &c__1, (char *)&nbt, (ftnlen)sizeof(integer));
		do_lio(&c__9, &c__1, " nbs =", 6L);
		do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(integer))
			;
		e_wsle();
		s_wsle(&io___2469);
		do_lio(&c__9, &c__1, " tetes de listes =", 18L);
		e_wsle();
		ci__1.cierr = 0;
		ci__1.ciunit = 6;
		ci__1.cifmt = "(6(i5,i9,';'))";
		s_wsfe(&ci__1);
		i__1 = *nbs;
		for (i = 1; i <= i__1; ++i) {
		    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&reft[i], (ftnlen)sizeof(integer));
		}
		e_wsfe();
		s_wsle(&io___2470);
		do_lio(&c__9, &c__1, " chainage  = ", 13L);
		e_wsle();
		ci__1.cierr = 0;
		ci__1.ciunit = 6;
		ci__1.cifmt = "(4(i5,i6,i6,';'))";
		s_wsfe(&ci__1);
		i__1 = *nba;
		for (i = 1; i <= i__1; ++i) {
		    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&w[i], (ftnlen)sizeof(integer));
		}
		e_wsfe();
		s_wsle(&io___2471);
		do_lio(&c__9, &c__1, " arete = ", 9L);
		e_wsle();
		ci__1.cierr = 0;
		ci__1.ciunit = 6;
		ci__1.cifmt = "(4(i5,i6,i6,';'))";
		s_wsfe(&ci__1);
		i__1 = *nba;
		for (i = 1; i <= i__1; ++i) {
		    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&arete[(i << 1) + 1], (ftnlen)
			    sizeof(integer));
		    do_fio(&c__1, (char *)&arete[(i << 1) + 2], (ftnlen)
			    sizeof(integer));
		}
		e_wsfe();
		s_wsle(&io___2472);
		do_lio(&c__9, &c__1, " i , nu(1:6,i) = ", 17L);
		e_wsle();
		ci__1.cierr = 0;
		ci__1.ciunit = 6;
		ci__1.cifmt = "(10(i5,6(i12)/))";
		s_wsfe(&ci__1);
		i__1 = nbt;
		for (i = 1; i <= i__1; ++i) {
		    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
		    for (j = 1; j <= 6; ++j) {
			do_fio(&c__1, (char *)&nu[j + i * 6], (ftnlen)sizeof(
				integer));
		    }
		}
		e_wsfe();
	    }
	    i__1 = *nbs;
	    for (i = 1; i <= i__1; ++i) {
		a = reft[i];
L60:
		if (a > 0) {
		    s1 = arete[(i << 1) + 1];
		    s2 = arete[(i << 1) + 2];
		    s_wsle(&io___2474);
		    do_lio(&c__9, &c__1, " arete ", 7L);
		    do_lio(&c__3, &c__1, (char *)&a, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, "  s1 = ", 7L);
		    do_lio(&c__3, &c__1, (char *)&s1, (ftnlen)sizeof(integer))
			    ;
		    do_lio(&c__9, &c__1, " s2 = ", 6L);
		    do_lio(&c__3, &c__1, (char *)&s2, (ftnlen)sizeof(integer))
			    ;
		    e_wsle();
		    if (*iop >= 10) {
			r__1 = (real) c[(s1 << 1) + 1];
			r__2 = (real) c[(s1 << 1) + 2];
			txt2d_("O", &c__1, &r__1, &r__2, 1L);
			r__1 = (real) c[(s2 << 1) + 1];
			r__2 = (real) c[(s2 << 1) + 2];
			txt2d_("X", &c__1, &r__1, &r__2, 1L);
		    }
		    a = w[a];
		    goto L60;
		}
/* L70: */
	    }
	    if (*iop >= 10) {
		s_paus("", 0L);
	    }
	    *err = 7;
	    return 0;
	}
/* ------------------------------------------------------------------
--- */
/*     on s'occupe des aretes a forcer */
/* ------------------------------------------------------------------
--- */
	if (impre >= 9) {
	    s_wsle(&io___2475);
	    do_lio(&c__9, &c__1, "   on s'occupe des aretes a forcer", 34L);
	    e_wsle();
	}
	nbacpp = 0;
	i__1 = nbt;
	for (ie = 1; ie <= i__1; ++ie) {
	    if (nu[ie * 6 + 5] != 0) {
		for (is = 1; is <= 3; ++is) {
		    s1 = nu[is + ie * 6];
		    s2t = nu[p3[is - 1] + ie * 6];
		    ss1 = min(s1,s2t);
		    ap = 0;
		    a = reft[ss1];
L80:
		    if (a > 0) {
/* Computing MAX */
			i__2 = arete[(a << 1) + 1], i__3 = arete[(a << 1) + 2]
				;
			s2 = max(i__2,i__3);
/* x              t    = ie */
/* x              ta   = 0 */
			if (s2 == max(s1,s2t)) {
			    if (*iop >= 70) {
				mshdrw_(&c[3], &nu[7], &c__6, &ie, iop);
			    }
			    if (nu[is + 3 + ie * 6] > 0) {
				ta = nu[is + 3 + ie * 6] / 8;
				i = nu[is + 3 + ie * 6] - (ta << 3);
				nu[i + ta * 6] = -1073741824;
			    }
			    nu[is + 3 + ie * 6] = -1073741824;
			    goto L100;
			}
			ap = a;
			a = w[a];
			goto L80;
		    }
		    if (itera == 1) {
			goto L110;
		    }
		    ss1 = s1;
		    ap = 0;
		    a = reft[ss1];
L90:
		    if (a > 0) {
/* Computing MAX */
			i__2 = arete[(a << 1) + 1], i__3 = arete[(a << 1) + 2]
				;
			s2 = max(i__2,i__3);
			t = ie;
			ta = 0;
/*             recherche si l' element coupe l''arete 
a */
			is1 = is;
			s3t = nu[p3[p3[is - 1] - 1] + t * 6];
			det2 = (c[(s2t << 1) + 1] - c[(s1 << 1) + 1]) * (c[(
				s2 << 1) + 2] - c[(s1 << 1) + 2]) - (c[(s2t <<
				 1) + 2] - c[(s1 << 1) + 2]) * (c[(s2 << 1) + 
				1] - c[(s1 << 1) + 1]);
			det3 = (c[(s3t << 1) + 1] - c[(s1 << 1) + 1]) * (c[(
				s2 << 1) + 2] - c[(s1 << 1) + 2]) - (c[(s3t <<
				 1) + 2] - c[(s1 << 1) + 2]) * (c[(s2 << 1) + 
				1] - c[(s1 << 1) + 1]);
			if (impre >= 9) {
			    s_wsle(&io___2487);
			    do_lio(&c__9, &c__1, "t,is,det2,det3,s1,s2,s2t,s"
				    "3t = ", 31L);
			    do_lio(&c__3, &c__1, (char *)&t, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__3, &c__1, (char *)&is, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__3, &c__1, (char *)&det2, (ftnlen)
				    sizeof(integer));
			    do_lio(&c__3, &c__1, (char *)&det3, (ftnlen)
				    sizeof(integer));
			    do_lio(&c__3, &c__1, (char *)&s1, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__3, &c__1, (char *)&s2, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__3, &c__1, (char *)&s2t, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__3, &c__1, (char *)&s3t, (ftnlen)sizeof(
				    integer));
			    e_wsle();
			}
			if (det2 > 0 && det3 < 0) {
			    mshfr1_(&c[3], &nu[7], nbs, &t, &ta, &is1, &s2, 
				    iop, err);
			    if (*err != 0) {
				return 0;
			    }
			    goto L100;
			} else if (det2 == 0 && reft[s2t] == 0) {
			    s_wsle(&io___2488);
			    do_lio(&c__9, &c__1, " fatal ERROR mshfrt: le po"
				    "int ", 30L);
			    do_lio(&c__3, &c__1, (char *)&s2t, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " qui ne doit pas etre fron"
				    "tiere , l'est", 39L);
			    e_wsle();
			    err1 = 10;
			} else if (det3 == 0 && reft[s3t] == 0) {
			    s_wsle(&io___2489);
			    do_lio(&c__9, &c__1, " fatal ERROR mshfrt: le po"
				    "int ", 30L);
			    do_lio(&c__3, &c__1, (char *)&s3t, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " qui ne doit pas etre fron"
				    "tiere , l'est", 39L);
			    e_wsle();
			    err1 = 10;
			}
			ap = a;
			a = w[a];
			goto L90;
		    }
		    goto L110;
L100:
		    ++nbacpp;
		    if (ap == 0) {
			reft[ss1] = w[a];
		    } else {
			w[ap] = w[a];
		    }
		    if (nbac + nbacpp == *nba) {
			goto L130;
		    }
L110:
		    ;
		}
	    }
/* L120: */
	}
	nbac += nbacpp;
	goto L50;
    }
L130:
/* -----------------------------------------------------------------------
 */
/*     prise en compte des sous domaines */
/* -----------------------------------------------------------------------
 */
    i__1 = *nbs + *nbsd + *nbsd;
    for (i = 1; i <= i__1; ++i) {
	w[i] = 0;
/* L140: */
    }
    i__1 = *nbsd;
    for (i = 1; i <= i__1; ++i) {
	a = (i__2 = sd[(i << 1) + 1], abs(i__2));
/* Computing MIN */
	i__2 = arete[(a << 1) + 1], i__3 = arete[(a << 1) + 2];
	s1 = min(i__2,i__3);
	w[i + i] = w[s1 + *nbsd + *nbsd];
	w[s1 + *nbsd + *nbsd] = i;
/* L150: */
    }
    i__1 = nbt;
    for (t = 1; t <= i__1; ++t) {
	reft[t] = -1073741824;
	if (nu[t * 6 + 6] != 0) {
	    for (i = 1; i <= 3; ++i) {
/* Computing MIN */
		i__2 = nu[i + t * 6], i__3 = nu[p3[i - 1] + t * 6];
		ss1 = min(i__2,i__3);
		jsd = *nbsd + *nbsd + ss1;
L160:
		isd = w[jsd];
		if (isd > 0) {
		    a = sd[(isd << 1) + 1];
		    if (a > 0) {
			if (nu[i + t * 6] == arete[(a << 1) + 1] && nu[p3[i - 
				1] + t * 6] == arete[(a << 1) + 2]) {
			    reft[t] = sd[(isd << 1) + 2];
			    w[isd + isd - 1] = t;
			    w[jsd] = w[isd + isd];
			    goto L170;
			}
		    } else if (a < 0) {
			if (nu[i + t * 6] == arete[(-a << 1) + 2] && nu[p3[i 
				- 1] + t * 6] == arete[(-a << 1) + 1]) {
			    reft[t] = sd[(isd << 1) + 2];
			    w[isd + isd - 1] = t;
			    w[jsd] = w[isd + isd];
			    goto L170;
			}
		    } else {
			s_wsle(&io___2492);
			do_lio(&c__9, &c__1, " fatale ERREUR sous domaine ", 
				28L);
			do_lio(&c__3, &c__1, (char *)&isd, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " arete nulle", 12L);
			e_wsle();
			*err = 11;
		    }
		    jsd = isd + isd;
		    goto L160;
		}
L170:
		;
	    }
	}
/* L180: */
    }
    i__1 = *nbsd;
    for (isd = 1; isd <= i__1; ++isd) {
	if (w[isd + isd - 1] == 0) {
	    *err = 11;
	    s_wsle(&io___2493);
	    do_lio(&c__9, &c__1, " fatale ERREUR mshfrt le sous domaine ", 
		    38L);
	    do_lio(&c__3, &c__1, (char *)&isd, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " n'est reference par aucun element ", 35L);
	    e_wsle();
	    s_wsle(&io___2494);
	    do_lio(&c__9, &c__1, " revoir l'orientation ", 22L);
	    do_lio(&c__9, &c__1, " ou la definition des sous domaines", 35L);
	    e_wsle();
	} else {
	    w[isd + isd] = 3;
	}
/* L190: */
    }
    if (*err != 0) {
	s_wsle(&io___2495);
	do_lio(&c__9, &c__1, "fatal ERROR mshfrt :les sous domaines sont mal"
		" definit", 54L);
	e_wsle();
	s_wsle(&io___2496);
	do_lio(&c__9, &c__1, " l'arete ", 9L);
	do_lio(&c__3, &c__1, (char *)&a, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " est reference plus d'une fois ", 31L);
	e_wsle();
	s_wsle(&io___2497);
	do_lio(&c__9, &c__1, " nombre de sous domaine ", 24L);
	do_lio(&c__3, &c__1, (char *)&(*nbsd), (ftnlen)sizeof(integer));
	e_wsle();
	ci__1.cierr = 0;
	ci__1.ciunit = 6;
	ci__1.cifmt = "(a,/,10(/,i4,a,i10,a,i10))";
	s_wsfe(&ci__1);
	do_fio(&c__1, "sous domaine ", 13L);
	i__1 = *nbsd;
	for (i = 1; i <= i__1; ++i) {
	    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
	    do_fio(&c__1, " arete= ", 8L);
	    do_fio(&c__1, (char *)&sd[(i << 1) + 1], (ftnlen)sizeof(integer));
	    do_fio(&c__1, " ref= ", 6L);
	    do_fio(&c__1, (char *)&sd[(i << 1) + 2], (ftnlen)sizeof(integer));
	}
	e_wsfe();
	return 0;
    }
    if (*iop >= 80) {
	clnfnt_();
    }
    i = *nbsd + *nbsd;
L200:
    if (i > 0) {
	++w[i];
	if (w[i] <= 6) {
	    ta = nu[w[i] + w[i - 1] * 6];
	    if (ta > 0) {
		ta /= 8;
		if (nu[ta * 6 + 1] > 0) {
		    if (*iop >= 80) {
			mshdrw_(&c[3], &nu[7], &c__6, &ta, iop);
		    }
		    nu[ta * 6 + 1] = -nu[ta * 6 + 1];
		    if (reft[ta] != reft[w[i - 1]]) {
			if (reft[ta] != -1073741824) {
			    s_wsle(&io___2498);
			    do_lio(&c__9, &c__1, " mshfrt :ERROR sous domain"
				    "e element ", 36L);
			    do_lio(&c__3, &c__1, (char *)&ta, (ftnlen)sizeof(
				    integer));
			    do_lio(&c__9, &c__1, " ref old = ", 11L);
			    do_lio(&c__3, &c__1, (char *)&reft[ta], (ftnlen)
				    sizeof(integer));
			    do_lio(&c__9, &c__1, " ref new = ", 11L);
			    do_lio(&c__3, &c__1, (char *)&reft[w[i - 1]], (
				    ftnlen)sizeof(integer));
			    e_wsle();
			} else {
			    reft[ta] = reft[w[i - 1]];
			}
			w[i + 1] = ta;
			w[i + 2] = 3;
			i += 2;
		    }
		}
	    }
	} else {
	    i += -2;
	}
	goto L200;
    }
    i__1 = nbt;
    for (ie = 1; ie <= i__1; ++ie) {
	if (reft[ie] != -1073741824) {
	    nu[ie * 6 + 1] = (i__2 = nu[ie * 6 + 1], abs(i__2));
	} else {
	    for (i = 1; i <= 6; ++i) {
		nu[i + ie * 6] = 0;
/* L210: */
	    }
	}
/* L220: */
    }
    return 0;
} /* mshfrt_ */

#undef coulls


/* Subroutine */ int mshfsm_(integer *isom, integer *iare, integer *lst, 
	integer *llst)
{
    /* Initialized data */

    /*static*/ integer nexta[6]	/* was [3][2] */ = { 6,4,5,5,6,4 };
    /*static*/ integer p3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1, i__2, i__3;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer jare, told, iter, jsom, sens, somm, lfrt, i, j, k, t;

    integer i1, i2, j1, t1, ptrot, sfiss[65], aa;
    extern /* Subroutine */ int poly2f_(real *, real *, integer *, integer *, 
	    integer *, integer *);
    integer abd, ibd, nbfiss, un;
    real xx[3], yy[3];
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    integer sbd1, sbd2, nbs1;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2512 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2523 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2524 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2525 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2527 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2528 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    lst -= 4;

    /* Function Body */
/* ---------------------------------------------------------------------- 
*/
/*     def lst */
/*      on tourne autour du sommet dans le sens direct */
/*      ----------------------------------------------- */
/*      i) si lst(1,i) >0 alors c'est un numero de triangle */
/*                               et lst(2,i) = numero un sommet */
/*                               dans le traingle */
/*      ii) si lst(1,i) <0 alors c'est - un numero arete */
/*                               et lst(2,i) donne: extremite */
/*                                 et le sens du support */
/*                                1 extremite */
/*                                2 extremite */
/*      iii)si lst(1,i) = 0 =>  on rancontre la frontiere */
/* ---------------------------------------------------------------------- 
*/
    nbs1 = bdmsh1_1.nbs;
    jsom = abs(*isom);
    jare = *iare;
    sens = 1;
    ptrot = jsom;
    somm = bdmshc_1.aretbd[ptrot + (jare << 1) - 3];
/*      print *,('+',i=1,79) */
/*      print *,' mshfsm : on tourne autour de ',somm,' en partant de ' */
/*     +       ,jsom,jare */
    t = bdmshd_1.areadj[jsom + (jare << 1) - 3];
    *llst = 1;
    lst[*llst * 3 + 1] = -jare;
    lst[*llst * 3 + 2] = jsom;
    iter = 0;
L10:
    ++iter;
    if (iter > 1000) {
	s_wsle(&io___2512);
	do_lio(&c__9, &c__1, " mshfsm ca boucle autour du sommet ", 35L);
	do_lio(&c__3, &c__1, (char *)&somm, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " pb maillage : on saute ce sommet ", 34L);
	e_wsle();
	return 0;
    }
    if (t > 0) {
/*       t est un triangle */
/* ---------------------------------- */
	aa = t;
	t = aa / 8;
	aa -= t << 3;
	if (sens == 1) {
	    i = aa - 3;
	} else {
	    i = p3[aa - 4];
	}
	++(*llst);
	lst[*llst * 3 + 1] = t;
	lst[*llst * 3 + 2] = i;
	told = t;
	t = bdmsh9_1.nsea[nexta[aa + sens * 3 - 7] + t * 6 - 7];
	goto L10;
    } else if (t < 0) {
/*       t est une arete */
/* ---------------------------------- */
	t = -t;
/* ------ */
/*        print *,'on butte sur une arete ',t,' frontiere de sous doma
ine */
/*     +         ,' les triangles adjacents :',areadj(1,t)/8,areadj(2,
t)/ */
	if (t != jare) {
	    ++(*llst);
	    lst[*llst * 3 + 1] = -t;
	    if (bdmshd_1.areadj[(t << 1) - 2] / 8 == told) {
		t1 = bdmshd_1.areadj[(t << 1) - 1];
	    } else {
		t1 = bdmshd_1.areadj[(t << 1) - 2];
	    }
	    if (bdmshc_1.aretbd[(t << 1) - 2] == somm) {
		lst[*llst * 3 + 2] = 1;
	    } else {
		lst[*llst * 3 + 2] = 2;
	    }
	    t = t1;
	    goto L10;
	} else {
/*          print *,' on a retrouver l''arete de depart',t */
	}
    } else {
/*        print *,'on butte sur la frontiere' */
/* ---------------------------------- */
	if (sens == 1) {
/*          print *,'on repart dans l''autre sens' */
	    ++(*llst);
	    lst[*llst * 3 + 1] = 0;
	    lst[*llst * 3 + 2] = 0;
	    lfrt = *llst;
	    sens = 2;
	    ptrot = 3 - jsom;
	    t = bdmshd_1.areadj[ptrot + (jare << 1) - 3];
	    goto L10;
	}
    }
    if (sens == 2) {
/*       on retourne la partie apres la frontiere */
	i = lfrt + 1;
	j = *llst;
L20:
	if (i < j) {
	    k = lst[i * 3 + 1];
	    lst[i * 3 + 1] = lst[j * 3 + 1];
	    lst[j * 3 + 1] = k;
	    k = lst[i * 3 + 2];
	    lst[i * 3 + 2] = lst[j * 3 + 2];
	    lst[j * 3 + 2] = k;
	    ++i;
	    --j;
	    goto L20;
	}
    }
    ++(*llst);
    lst[*llst * 3 + 1] = lst[4];
    lst[*llst * 3 + 2] = lst[5];
/*     construction des sommets de la fissure */
    nbfiss = 0;
    un = 0;
    sfiss[nbfiss] = 0;
    i__1 = *llst;
    for (i = 1; i <= i__1; ++i) {
	if (lst[i * 3 + 1] > 0) {
	    if (nbfiss <= 64) {
		sfiss[nbfiss] = bdmsh9_1.nsea[lst[i * 3 + 2] + lst[i * 3 + 1] 
			* 6 - 7];
	    }
	    un = 1;
	} else if (lst[i * 3 + 1] < 0) {
	    if (bdpecd_1.fissur[(i__2 = bdmshe_1.refa[-lst[i * 3 + 1] - 1], 
		    abs(i__2)) + 64]) {
		nbfiss += un;
		if (nbfiss <= 64) {
		    sfiss[nbfiss] = 0;
		}
		un = 0;
	    } else {
		un = 1;
	    }
	} else {
	    nbfiss += un;
	    if (nbfiss <= 64) {
		sfiss[nbfiss] = 0;
	    }
	    un = 0;
	}
	lst[i * 3 + 3] = nbfiss;
/* L30: */
    }
    if (sfiss[0] == 0) {
	if (sfiss[nbfiss] != 0) {
	    sfiss[0] = sfiss[nbfiss];
	} else {
	    s_wsle(&io___2523);
	    do_lio(&c__9, &c__1, "mshfsm: le nombre de fissure du sommet ", 
		    39L);
	    do_lio(&c__3, &c__1, (char *)&somm, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&bdmsh6_1.nsorig[somm - 1], (ftnlen)
		    sizeof(integer));
	    do_lio(&c__9, &c__1, " = ", 3L);
	    do_lio(&c__3, &c__1, (char *)&nbfiss, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " sommet =", 9L);
	    i__1 = nbfiss;
	    for (i = 0; i <= i__1; ++i) {
		do_lio(&c__3, &c__1, (char *)&sfiss[i], (ftnlen)sizeof(
			integer));
	    }
	    e_wsle();
	    s_wsle(&io___2524);
	    do_lio(&c__9, &c__1, "mshfsm: pb soft autour du sommet ", 33L);
	    do_lio(&c__3, &c__1, (char *)&somm, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " on ne le fissure pas", 21L);
	    e_wsle();
	    sfiss[0] = somm;
	    nbfiss = 0;
	}
    } else if (sfiss[nbfiss] == 0) {
	sfiss[nbfiss] = sfiss[0];
    }
/*      if(nbfiss.gt.1.and.abs(refa(jare)).ne.abs(refs(somm))) */
/*     +      print *,'mshfsm: le nombre de fissure du sommet ' */
/*     +       ,somm,nsorig(somm) ,' = ',nbfiss,' sommet =' */
/*     +       , (sfiss(i),i=0,nbfiss) */
    if (nbfiss > 64) {
	scrtch_(" on ne peut pas fissurer: il y a plus de 64 fissures sur un"
		" sommet", 66L);
	s_wsle(&io___2525);
	do_lio(&c__9, &c__1, " il y a plus de 64 fissures sur un sommet:", 
		42L);
	do_lio(&c__3, &c__1, (char *)&nbfiss, (ftnlen)sizeof(integer));
	e_wsle();
	nbfiss = 0;
    }
    if (nbfiss > 1) {
/*      verification que tout les sommet fissures sont differents */
/* ------------------------------------------------------------- */
	i__1 = nbfiss;
	for (i = 1; i <= i__1; ++i) {
	    i__2 = i;
	    for (j = 1; j <= i__2; ++j) {
		if (sfiss[i] == sfiss[j] && (i != j || sfiss[i] == 
			bdmsh6_1.nsorig[sfiss[i] - 1])) {
/*         il faut cree un point */
		    if (bdmsh1_1.nbs < bdmsh0_1.nbpmx && bdmsh4_1.finbd3 < 
			    bdpec1_1.mxbd) {
			++bdmsh1_1.nbs;
/*            print *,'mshfsm: on cree le point',nbs 
*/
			bdmsh5_1.cr[(bdmsh1_1.nbs << 1) - 2] = bdmsh5_1.cr[(
				somm << 1) - 2];
			bdmsh5_1.cr[(bdmsh1_1.nbs << 1) - 1] = bdmsh5_1.cr[(
				somm << 1) - 2];
			bdmsh8_1.refs[bdmsh1_1.nbs - 1] = bdmsh4_1.finbd3;
			bdmsh7_1.abcurv[bdmsh1_1.nbs - 1] = bdmsh7_1.abcurv[
				sfiss[i] - 1];
			bdmsh6_1.nsorig[bdmsh1_1.nbs - 1] = bdmsh6_1.nsorig[
				sfiss[i] - 1];
			ibd = (i__3 = bdmsh8_1.refs[sfiss[i] - 1], abs(i__3));
			sfiss[i] = bdmsh1_1.nbs;
			if (bdpec2_1.bd[ibd * 6 + 384] == 0.f) {
			    ++bdmsh4_1.finbd3;
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 384] = 0.f;
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 385] = 
				    bdmsh5_1.cr[(sfiss[i] << 1) - 2];
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 386] = 
				    bdmsh5_1.cr[(sfiss[i] << 1) - 1];
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 387] = 0.f;
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 388] = 0.f;
			    bdpec2_1.bd[bdmsh4_1.finbd3 * 6 + 389] = 0.f;
			    bdpec5_1.nuref[(bdmsh4_1.finbd3 << 1) + 128] = 
				    bdpec5_1.nuref[(ibd << 1) + 128];
			    bdpec5_1.nuref[(bdmsh4_1.finbd3 << 1) + 129] = 
				    bdpec5_1.nuref[(ibd << 1) + 128];
			    bdmsh8_1.refs[bdmsh1_1.nbs - 1] = bdmsh4_1.finbd3;
			} else {
			    if (nbfiss != 2 || (i__3 = bdmshe_1.refa[jare - 1]
				    , abs(i__3)) != ibd) {
				s_wsle(&io___2527);
				do_lio(&c__9, &c__1, " mshfsm : BIZARRE pb s"
					"oft ou mesh faux", 38L);
				do_lio(&c__9, &c__1, " i=", 3L);
				do_lio(&c__3, &c__1, (char *)&i, (ftnlen)
					sizeof(integer));
				do_lio(&c__9, &c__1, ",sfiss(i)=", 10L);
				do_lio(&c__3, &c__1, (char *)&sfiss[i], (
					ftnlen)sizeof(integer));
				do_lio(&c__3, &c__1, (char *)&bdmshe_1.refa[
					jare - 1], (ftnlen)sizeof(integer));
				do_lio(&c__3, &c__1, (char *)&ibd, (ftnlen)
					sizeof(integer));
				do_lio(&c__9, &c__1, ",nbfiss=", 8L);
				do_lio(&c__3, &c__1, (char *)&nbfiss, (ftnlen)
					sizeof(integer));
				e_wsle();
				s_wsle(&io___2528);
				do_lio(&c__9, &c__1, " ---------------------"
					"----------------", 38L);
				e_wsle();
				bdmsh8_1.refs[sfiss[i] - 1] = ibd;
			    } else {
/*               dans ce cas il ne peut pas y 
avoir de frontiere */
				if (jsom == 1) {
				    bdmsh8_1.refs[abs(sfiss[2]) - 1] = ibd;
				    bdmsh8_1.refs[abs(sfiss[1]) - 1] = -ibd;
				} else {
				    bdmsh8_1.refs[abs(sfiss[2]) - 1] = -ibd;
				    bdmsh8_1.refs[abs(sfiss[1]) - 1] = ibd;
				}
			    }
			}
		    } else {
			scrtch_("trop de sommet generer on ne peut pas fissu"
				"re", 45L);
		    }
		}
/* L40: */
	    }
/* L50: */
	}
    } else {
/*      le sommet n'est pas fissure */
/* ------------------------------------- */
	sfiss[1] = bdmsh6_1.nsorig[somm - 1];
	sfiss[0] = bdmsh6_1.nsorig[somm - 1];
    }
    sfiss[0] = sfiss[nbfiss];
/* --------- ruse pour visualiser la fissure -----------------------------
 */
/*     on ne cree pas le point correct mais un point deplace */
    if (nbfiss > 1) {
	i__1 = nbfiss;
	for (i = 1; i <= i__1; ++i) {
	    j = sfiss[i];
	    bdpecd_1.fissur[(i__2 = bdmsh8_1.refs[j - 1], abs(i__2)) + 64] = 
		    TRUE_;
	    if (j > nbs1) {
		j1 = 1;
		bdmsh5_1.cr[(j << 1) - 2] = bdmsh5_1.cr[(somm << 1) - 2];
		bdmsh5_1.cr[(j << 1) - 1] = bdmsh5_1.cr[(somm << 1) - 1];
		i__2 = *llst - 1;
		for (k = 1; k <= i__2; ++k) {
		    if (lst[k * 3 + 1] > 0) {
			if (sfiss[lst[k * 3 + 3]] == j) {
			    j1 += 12;
			    i1 = bdmsh9_1.nsea[p3[lst[k * 3 + 2] - 1] + lst[k 
				    * 3 + 1] * 6 - 7];
			    i2 = bdmsh9_1.nsea[p3[p3[lst[k * 3 + 2] - 1] - 1] 
				    + lst[k * 3 + 1] * 6 - 7];
			    bdmsh5_1.cr[(j << 1) - 2] = bdmsh5_1.cr[(j << 1) 
				    - 2] + bdmsh5_1.cr[(somm << 1) - 2] * 10 
				    + bdmsh5_1.cr[(i2 << 1) - 2] + 
				    bdmsh5_1.cr[(i1 << 1) - 2];
			    bdmsh5_1.cr[(j << 1) - 1] = bdmsh5_1.cr[(j << 1) 
				    - 1] + bdmsh5_1.cr[(somm << 1) - 1] * 10 
				    + bdmsh5_1.cr[(i2 << 1) - 1] + 
				    bdmsh5_1.cr[(i1 << 1) - 1];
			}
		    }
/* L35: */
		}
		bdmsh5_1.cr[(j << 1) - 2] /= j1;
		bdmsh5_1.cr[(j << 1) - 1] /= j1;
	    }
/* L52: */
	}
    } else {
	bdpecd_1.fissur[(i__1 = bdmsh8_1.refs[somm - 1], abs(i__1)) + 64] = 
		FALSE_;
    }
/* -----------------------------------------------------------------------
 */
/*     update de nsea des triangles */
    i__1 = *llst;
    for (i = 1; i <= i__1; ++i) {
	if (lst[i * 3 + 1] > 0) {
	    if (bdmsh6_1.nsorig[sfiss[lst[i * 3 + 3]] - 1] != sfiss[lst[i * 3 
		    + 3]]) {
		for (j = 1; j <= 3; ++j) {
		    xx[j - 1] = bdmsh5_1.cr[(bdmsh9_1.nsea[j + lst[i * 3 + 1] 
			    * 6 - 7] << 1) - 2];
		    yy[j - 1] = bdmsh5_1.cr[(bdmsh9_1.nsea[j + lst[i * 3 + 1] 
			    * 6 - 7] << 1) - 1];
/* L55: */
		}
		poly2f_(xx, yy, &c__3, &ctabco_1.fond, &ctabco_1.pafond, &
			c__0);
		xx[lst[i * 3 + 2] - 1] = bdmsh5_1.cr[(sfiss[lst[i * 3 + 3]] <<
			 1) - 2];
		yy[lst[i * 3 + 2] - 1] = bdmsh5_1.cr[(sfiss[lst[i * 3 + 3]] <<
			 1) - 1];
		poly2f_(xx, yy, &c__3, &ctabco_1.fond, &ctabco_1.pafond, &
			c__2);
	    }
	    bdmsh9_1.nsea[lst[i * 3 + 2] + lst[i * 3 + 1] * 6 - 7] = sfiss[
		    lst[i * 3 + 3]];
	}
/* L60: */
    }
/*      print *,' mshfsm : sortie llst =',llst,'------------------------- 
*/
    if (*isom >= 0) {
	return 0;
    }
/* ---------------------------------------------------------------------- 
*/
/*     on fait l'init de la bd de l'appli3 nuref1 et nuref2 */
/*     sont des pointeur sur des point de la bd si isom < 0 */
/* -----------------------------------------------------------------------
 */
    ibd = (i__1 = bdmsh8_1.refs[somm - 1], abs(i__1));
    if (bdpec2_1.bd[ibd * 6 + 384] != 0.f) {
	return 0;
    }
    sbd1 = (i__1 = bdmsh8_1.refs[sfiss[lst[(*llst - 1) * 3 + 3]] - 1], abs(
	    i__1));
    i__1 = *llst - 1;
    for (i = 1; i <= i__1; ++i) {
	if (lst[i * 3 + 1] < 0) {
	    abd = (i__2 = bdmshe_1.refa[-lst[i * 3 + 1] - 1], abs(i__2));
	    sbd2 = (i__2 = bdmsh8_1.refs[sfiss[lst[i * 3 + 3]] - 1], abs(i__2)
		    );
/*         print *,'bd=',abd,' sommet avant =',sbd1,' sommet apres
 =',sbd */
	    if (bdpec8_1.adp1[abd + 64] == ibd) {
		bdpec5_1.nuref[(sbd1 << 1) + 128] = bdpec6_1.nuref1[(abd << 1)
			 + 129];
		bdpec5_1.nuref[(sbd1 << 1) + 129] = bdpec6_1.nuref1[(abd << 1)
			 + 129];
		bdpec5_1.nuref[(sbd2 << 1) + 128] = bdpec6_1.nuref1[(abd << 1)
			 + 128];
		bdpec5_1.nuref[(sbd2 << 1) + 129] = bdpec6_1.nuref1[(abd << 1)
			 + 128];
		bdpec6_1.nuref1[(abd << 1) + 129] = sbd1;
		bdpec6_1.nuref1[(abd << 1) + 128] = sbd2;
		bdpec8_1.adp1[abd + 64] = -bdpec8_1.adp1[abd + 64];
	    }
	    if (bdpec9_1.adp2[abd + 64] == ibd) {
		bdpec5_1.nuref[(sbd2 << 1) + 128] = bdpec7_1.nuref2[(abd << 1)
			 + 129];
		bdpec5_1.nuref[(sbd2 << 1) + 129] = bdpec7_1.nuref2[(abd << 1)
			 + 129];
		bdpec5_1.nuref[(sbd1 << 1) + 128] = bdpec7_1.nuref2[(abd << 1)
			 + 128];
		bdpec5_1.nuref[(sbd1 << 1) + 129] = bdpec7_1.nuref2[(abd << 1)
			 + 128];
		bdpec7_1.nuref2[(abd << 1) + 129] = sbd2;
		bdpec7_1.nuref2[(abd << 1) + 128] = sbd1;
		bdpec9_1.adp2[abd + 64] = -bdpec9_1.adp2[abd + 64];
	    }
	    sbd1 = sbd2;
	}
/* L70: */
    }
    return 0;
} /* mshfsm_ */




/* Subroutine */ int mshfss_(integer *ibd)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer deux, llst, i;

    integer ia;
    integer un;
    extern /* Subroutine */ int mshfsm_(integer *, integer *, integer *, 
	    integer *);

/* -----------------------------------------------------------------------
 */
/*     but: gener des fissure dans un maillages */
/* -----------------------------------------------------------------------
 */
    bdpecd_1.fissur[64] = TRUE_;
    if (*ibd >= 0) {
	un = 1;
	deux = 2;
    } else {
/*       pour init (changer les nuref1 et 2 en pointeur sur la bd) */
	un = -1;
	deux = -2;
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	bdwrk1_1.work[i - 1] = 0;
/* L10: */
    }
    i__1 = bdmsh1_1.nba;
    for (ia = 1; ia <= i__1; ++ia) {
	if ((i__2 = bdmshe_1.refa[ia - 1], abs(i__2)) == *ibd || *ibd <= 0) {
	    if (bdwrk1_1.work[bdmshc_1.aretbd[(ia << 1) - 2] - 1] == 0) {
		mshfsm_(&un, &ia, &bdwrk1_1.work[bdmsh0_1.nbpmx * 2], &llst);
	    }
	    if (bdwrk1_1.work[bdmshc_1.aretbd[(ia << 1) - 1] - 1] == 0) {
		mshfsm_(&deux, &ia, &bdwrk1_1.work[bdmsh0_1.nbpmx * 2], &llst)
			;
	    }
	    bdwrk1_1.work[bdmshc_1.aretbd[(ia << 1) - 2] - 1] = 1;
	    bdwrk1_1.work[bdmshc_1.aretbd[(ia << 1) - 1] - 1] = 1;
	}
/* L100: */
    }
/*     on demarque les extremite des element de bd */
    i__1 = bdmsh4_1.finbd3;
    for (i = 1; i <= i__1; ++i) {
	bdpec8_1.adp1[i + 64] = (i__2 = bdpec8_1.adp1[i + 64], abs(i__2));
	bdpec9_1.adp2[i + 64] = (i__2 = bdpec9_1.adp2[i + 64], abs(i__2));
/* L200: */
    }
    bdpecd_1.fissur[64] = FALSE_;
    return 0;
} /* mshfss_ */




/* Subroutine */ int mshgpt_(integer *c, real *cr, integer *nu, real *h, 
	integer *reft, integer *nbs, integer *nbsmx, integer *nbt, real *coef,
	 real *puis, real *trfri, integer *iop, integer *err)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2, r__3;
    doublereal d__1, d__2, d__3, d__4, d__5, d__6, d__7, d__8;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double pow_dd(doublereal *, doublereal *), sqrt(doublereal);
    integer i_nint(real *);

    /* Local variables */
    real aire;
    integer tete;
    real hmoy;
    logical impr1, impr2;
    integer t;
    real x, y;
    integer itera;
    logical impre;
    real h1, h2, h3;
    integer s1, s2, s3;
    extern /* Subroutine */ int msha1p_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *);
    real hs;
    integer ix, iy, nbsold;
    extern /* Subroutine */ int clnfnt_(void);
    real det, pui;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2549 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2568 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2569 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2570 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2571 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2572 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2573 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2574 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2575 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    --trfri;
    --reft;
    --h;
    nu -= 7;
    cr -= 3;
    c -= 3;

    /* Function Body */
    impre = *iop % 10 > 1;
    impr1 = *iop % 10 > 2;
    impr2 = *iop % 10 >= 8;
    pui = *puis;
    if (impre) {
	s_wsle(&io___2549);
	do_lio(&c__9, &c__1, "mshgpt:  nbs = ", 15L);
	do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " nbsmx = ", 9L);
	do_lio(&c__3, &c__1, (char *)&(*nbsmx), (ftnlen)sizeof(integer));
	e_wsle();
    }
    *nbt = (*nbs << 1) - 2;
    if (*nbs >= *nbsmx) {
	return 0;
    }
    if (*iop >= 50) {
	clnfnt_();
    }
    tete = 0;
/*     initialisation de la liste des triangles libre */
    i__1 = *nbt;
    for (t = 1; t <= i__1; ++t) {
	if (nu[t * 6 + 6] == 0) {
	    nu[t * 6 + 1] = tete;
	    tete = t;
	}
/* L10: */
    }
    itera = 0;
L20:
    ++itera;
    nbsold = *nbs;
    i__1 = *nbt;
    for (t = 1; t <= i__1; ++t) {
	if (nu[t * 6 + 6] != 0) {
	    s1 = nu[t * 6 + 1];
	    s2 = nu[t * 6 + 2];
	    s3 = nu[t * 6 + 3];
/*        calcul de 2 fois l'aire du triangle */
	    det = (cr[(s2 << 1) + 1] - cr[(s1 << 1) + 1]) * (cr[(s3 << 1) + 2]
		     - cr[(s1 << 1) + 2]) - (cr[(s2 << 1) + 2] - cr[(s1 << 1) 
		    + 2]) * (cr[(s3 << 1) + 1] - cr[(s1 << 1) + 1]);
	    aire = det * *coef;
/*        pour des problemes overflow on adimensionne */
/*        --------------------------------------------- */
	    hmoy = (h[s1] + h[s2] + h[s3]) / 3.f;
	    h1 = h[s1] / hmoy;
	    h2 = h[s2] / hmoy;
	    h3 = h[s3] / hmoy;
	    if (*puis > .001f) {
		d__2 = (doublereal) h1;
		d__3 = (doublereal) pui;
		d__4 = (doublereal) h2;
		d__5 = (doublereal) pui;
		d__6 = (doublereal) h3;
		d__7 = (doublereal) pui;
		d__1 = (pow_dd(&d__2, &d__3) + pow_dd(&d__4, &d__5) + pow_dd(&
			d__6, &d__7)) / 3.f;
		d__8 = (doublereal) (1.f / pui);
		hs = pow_dd(&d__1, &d__8);
	    } else if (*puis > -.5f) {
		d__1 = (doublereal) (h1 * h2 * h3);
		hs = pow_dd(&d__1, &c_b6026);
	    } else if (*puis > -1.5f) {
		hs = h1 * 3.f * h2 * h3 / (h1 * h2 + h1 * h3 + h2 * h3);
	    } else if (*puis > -2.5f) {
/* Computing 2nd power */
		r__1 = h1 * h2;
/* Computing 2nd power */
		r__2 = h1 * h3;
/* Computing 2nd power */
		r__3 = h2 * h3;
		hs = h1 * h2 * h3 / sqrt((r__1 * r__1 + r__2 * r__2 + r__3 * 
			r__3) / 3.f);
	    } else if (*puis > -3.5f) {
/* Computing MIN */
		r__1 = min(h1,h2);
		hs = dmin(r__1,h3);
	    } else {
/* Computing MAX */
		r__1 = max(h1,h2);
		hs = dmax(r__1,h3);
	    }
	    hs *= hmoy;
	    if (aire > hs * hs) {
		h1 = 1.f;
		h2 = 1.f;
		h3 = 1.f;
		x = (cr[(s1 << 1) + 1] * h1 + cr[(s2 << 1) + 1] * h2 + cr[(s3 
			<< 1) + 1] * h3) / (h1 + h2 + h3);
		y = (cr[(s1 << 1) + 2] * h1 + cr[(s2 << 1) + 2] * h2 + cr[(s3 
			<< 1) + 2] * h3) / (h1 + h2 + h3);
		r__1 = trfri[1] * (x - trfri[2]);
		ix = i_nint(&r__1);
		r__1 = trfri[1] * (y - trfri[3]) - trfri[4];
		iy = i_nint(&r__1);
		if ((c[(s2 << 1) + 1] - ix) * (c[(s3 << 1) + 2] - iy) - (c[(
			s2 << 1) + 2] - iy) * (c[(s3 << 1) + 1] - ix) <= 0 || 
			(ix - c[(s1 << 1) + 1]) * (c[(s3 << 1) + 2] - c[(s1 <<
			 1) + 2]) - (iy - c[(s1 << 1) + 2]) * (c[(s3 << 1) + 
			1] - c[(s1 << 1) + 1]) <= 0 || (c[(s2 << 1) + 1] - c[(
			s1 << 1) + 1]) * (iy - c[(s1 << 1) + 2]) - (c[(s2 << 
			1) + 2] - c[(s1 << 1) + 2]) * (ix - c[(s1 << 1) + 1]) 
			<= 0) {
		    if (impr1) {
			s_wsle(&io___2568);
			do_lio(&c__9, &c__1, "WARNING mshgpt: le point gener"
				"e n'est pas dans", 46L);
			do_lio(&c__9, &c__1, " le triangle", 12L);
			do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " h =", 4L);
			do_lio(&c__4, &c__1, (char *)&h1, (ftnlen)sizeof(real)
				);
			do_lio(&c__4, &c__1, (char *)&h2, (ftnlen)sizeof(real)
				);
			do_lio(&c__4, &c__1, (char *)&h3, (ftnlen)sizeof(real)
				);
			do_lio(&c__9, &c__1, " h(s) =", 7L);
			do_lio(&c__4, &c__1, (char *)&hs, (ftnlen)sizeof(real)
				);
			e_wsle();
			s_wsle(&io___2569);
			do_lio(&c__9, &c__1, " s1  ", 5L);
			do_lio(&c__3, &c__1, (char *)&c[(s1 << 1) + 1], (
				ftnlen)sizeof(integer));
			do_lio(&c__3, &c__1, (char *)&c[(s1 << 1) + 2], (
				ftnlen)sizeof(integer));
			do_lio(&c__9, &c__1, " s2  ", 5L);
			do_lio(&c__3, &c__1, (char *)&c[(s2 << 1) + 1], (
				ftnlen)sizeof(integer));
			do_lio(&c__3, &c__1, (char *)&c[(s2 << 1) + 2], (
				ftnlen)sizeof(integer));
			do_lio(&c__9, &c__1, " s3  ", 5L);
			do_lio(&c__3, &c__1, (char *)&c[(s3 << 1) + 1], (
				ftnlen)sizeof(integer));
			do_lio(&c__3, &c__1, (char *)&c[(s3 << 1) + 2], (
				ftnlen)sizeof(integer));
			do_lio(&c__9, &c__1, " nbs ", 5L);
			do_lio(&c__3, &c__1, (char *)&ix, (ftnlen)sizeof(
				integer));
			do_lio(&c__3, &c__1, (char *)&iy, (ftnlen)sizeof(
				integer));
			e_wsle();
		    }
		} else {
		    if (*nbs >= *nbsmx) {
			s_wsle(&io___2570);
			do_lio(&c__9, &c__1, " WARNING mshgpt :on ne peut pl"
				"us cree de points ", 48L);
			e_wsle();
			s_wsle(&io___2571);
			do_lio(&c__9, &c__1, " nb de point = ", 15L);
			do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " nb de point maximal=", 21L);
			do_lio(&c__3, &c__1, (char *)&(*nbsmx), (ftnlen)
				sizeof(integer));
			e_wsle();
			return 0;
		    }
		    ++(*nbs);
		    c[(*nbs << 1) + 1] = ix;
		    c[(*nbs << 1) + 2] = iy;
		    cr[(*nbs << 1) + 1] = ix / trfri[1] + trfri[2];
		    cr[(*nbs << 1) + 2] = (iy + trfri[4]) / trfri[1] + trfri[
			    3];
		    h[*nbs] = hs;
		    if (impr2) {
			s_wsle(&io___2572);
			do_lio(&c__9, &c__1, "mhsgpt: triangle ", 17L);
			do_lio(&c__3, &c__1, (char *)&t, (ftnlen)sizeof(
				integer));
			do_lio(&c__9, &c__1, " generation du point", 20L);
			do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(
				integer));
			do_lio(&c__4, &c__1, (char *)&cr[(*nbs << 1) + 1], (
				ftnlen)sizeof(real));
			do_lio(&c__4, &c__1, (char *)&cr[(*nbs << 1) + 2], (
				ftnlen)sizeof(real));
			e_wsle();
		    }
		    msha1p_(&t, nbs, &c[3], &nu[7], &reft[1], &tete, nbt, nbs,
			     iop, err);
		    if (*err != 0) {
			return 0;
		    }
		}
	    }
	}
/* L100: */
    }
    if (impr1) {
	s_wsle(&io___2573);
	do_lio(&c__9, &c__1, " iterations de generation des point", 35L);
	do_lio(&c__3, &c__1, (char *)&itera, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " nb de points ", 14L);
	do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(integer));
	e_wsle();
    }
    if (nbsold != *nbs) {
	goto L20;
    }
    if (impre) {
	s_wsle(&io___2574);
	do_lio(&c__9, &c__1, "mshptg : nb d'iteration:", 24L);
	do_lio(&c__3, &c__1, (char *)&itera, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "et nb de points", 15L);
	do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___2575);
	do_lio(&c__9, &c__1, "----------------------------------------------"
		"--------", 54L);
	e_wsle();
    }
    return 0;
} /* mshgpt_ */

integer mshlcl_(integer *c, integer *nu, integer *tete, integer *s, integer *
	nbs)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    logical init;
    integer x, y, pt, det, ppt;

    /* Parameter adjustments */
    nu -= 7;
    c -= 3;

    /* Function Body */
    x = c[(*s << 1) + 1];
    y = c[(*s << 1) + 2];
    init = TRUE_;
    pt = *tete;
L10:
    ppt = pt;
    pt = nu[pt * 6 + 4];
    if (pt != *tete) {
	det = x * c[(nu[pt * 6 + 1] << 1) + 2] - y * c[(nu[pt * 6 + 1] << 1) 
		+ 1];
	if (det < 0) {
	    init = FALSE_;
	    goto L10;
	} else if (init && det == 0) {
	    goto L10;
	}
    }
    ret_val = ppt;
    return ret_val;
} /* mshlcl_ */

/* Subroutine */ int mshopt_(integer *c, integer *nu, integer *t, integer *a, 
	integer *nbs, integer *iop, integer *err)
{
    /* Initialized data */

    /*static*/ integer mod3[3] = { 2,3,1 };

    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    integer pile[2048]	/* was [2][1024] */;
    real reel1, reel2;
    doublereal reel8;
    integer i, a1, a2, s1, t1, t2, s2, s3, s4, aa, i11, i12, i13, i21, i22, 
	    i23, tt;
    extern /* Subroutine */ int mshdrw_(integer *, integer *, integer *, 
	    integer *, integer *);
    integer tt1, sgn, cos1, cos2, sin1, sin2;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2602 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2611 = { 0, 6, 0, 0, 0 };


    /* Parameter adjustments */
    nu -= 7;
    c -= 3;

    /* Function Body */
    i = 1;
    pile[(i << 1) - 2] = *t;
    pile[(i << 1) - 1] = *a;
L10:
    if (i > 0) {
	t1 = pile[(i << 1) - 2];
	a1 = pile[(i << 1) - 1];
	--i;
	if (t1 <= 0) {
	    goto L10;
	}
	tt1 = nu[a1 + t1 * 6];
	if (tt1 <= 0) {
	    goto L10;
	}
	t2 = tt1 / 8;
	a2 = tt1 - (t2 << 3);
/*        print *,' mshopt :t1,a1,t2,a2 =',t,a,nu(a,t)/8,mod(nu(a,t),8
) */
/*     &         ,' niveau = ',i */
	i11 = a1 - 3;
	i12 = mod3[i11 - 1];
	i13 = mod3[i12 - 1];
	i21 = a2 - 3;
	i22 = mod3[i21 - 1];
	i23 = mod3[i22 - 1];
	s1 = nu[i13 + t1 * 6];
	s2 = nu[i11 + t1 * 6];
	s3 = nu[i12 + t1 * 6];
	s4 = nu[i23 + t2 * 6];
/*        print *,i11,i12,i13,nu(i11,t1),nu(i12,t1),nu(i13,t1) */
/*        print *,i21,i22,i23,nu(i21,t2),nu(i22,t2),nu(i23,t2) */
/*        print *,s1,s2,s3,s4 */
/*              critere d optimisation du quadrilatere */
/* ---------------------------------------------------- */
	sin1 = (c[(s3 << 1) + 2] - c[(s1 << 1) + 2]) * (c[(s2 << 1) + 1] - c[(
		s1 << 1) + 1]) - (c[(s3 << 1) + 1] - c[(s1 << 1) + 1]) * (c[(
		s2 << 1) + 2] - c[(s1 << 1) + 2]);
	cos1 = (c[(s3 << 1) + 1] - c[(s1 << 1) + 1]) * (c[(s3 << 1) + 1] - c[(
		s2 << 1) + 1]) + (c[(s3 << 1) + 2] - c[(s1 << 1) + 2]) * (c[(
		s3 << 1) + 2] - c[(s2 << 1) + 2]);
	if (sin1 == 0 && cos1 == 0) {
	    s_wsle(&io___2602);
	    do_lio(&c__9, &c__1, "fatal ERROR mshopt:", 19L);
	    do_lio(&c__9, &c__1, "3 points confondus ", 19L);
	    do_lio(&c__3, &c__1, (char *)&s1, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&s2, (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&s3, (ftnlen)sizeof(integer));
	    e_wsle();
	    *err = 20;
	    return 0;
	}
/*       b est la cotangente de angle (s1,s3,s2) */
	sin2 = (c[(s4 << 1) + 1] - c[(s1 << 1) + 1]) * (c[(s2 << 1) + 2] - c[(
		s1 << 1) + 2]) - (c[(s4 << 1) + 2] - c[(s1 << 1) + 2]) * (c[(
		s2 << 1) + 1] - c[(s1 << 1) + 1]);
	cos2 = (c[(s4 << 1) + 1] - c[(s2 << 1) + 1]) * (c[(s4 << 1) + 1] - c[(
		s1 << 1) + 1]) + (c[(s4 << 1) + 2] - c[(s2 << 1) + 2]) * (c[(
		s4 << 1) + 2] - c[(s1 << 1) + 2]);
	reel1 = (real) cos2 * (real) sin1;
	reel2 = (real) cos1 * (real) sin2;
	if (dabs(reel1) + dabs(reel2) >= 1073741824.f) {
/*          print *,'on a un overflow en entier on calcule en reel
*8' */
	    reel8 = (doublereal) cos2 * (doublereal) sin1 + (doublereal) cos1 
		    * (doublereal) sin2;
/* Computing MIN */
	    d__1 = max(reel8,-1.);
	    reel8 = min(d__1,1.);
	    sgn = (integer) reel8;
	} else {
	    sgn = cos2 * sin1 + cos1 * sin2;
	}
/* Computing MIN */
	i__1 = max(sgn,-1);
	if (min(i__1,1) * sin1 >= 0) {
	    goto L10;
	}
/*       on inverse le quadrilatere */
/*       update des sommets */
/* ------------------------- */
	nu[i12 + t1 * 6] = s4;
	nu[i22 + t2 * 6] = s1;
/*       update des aretes a1,a2 */
/* ------------------------------- */
	tt1 = nu[i22 + 3 + t2 * 6];
	nu[a1 + t1 * 6] = tt1;
	if (tt1 > 0) {
	    tt = tt1 / 8;
	    aa = tt1 - (tt << 3);
	    nu[aa + tt * 6] = a1 + (t1 << 3);
	} else if (tt1 != -1073741824) {
	    nu[-tt1 * 6 + 2] = a1 + (t1 << 3);
	}
	tt1 = nu[i12 + 3 + t1 * 6];
	nu[a2 + t2 * 6] = tt1;
	if (tt1 > 0) {
	    tt = tt1 / 8;
	    aa = tt1 - (tt << 3);
	    nu[aa + tt * 6] = a2 + (t2 << 3);
	} else if (tt1 != -1073741824) {
	    nu[-tt1 * 6 + 2] = a2 + (t2 << 3);
	}
	nu[i12 + 3 + t1 * 6] = i22 + 3 + (t2 << 3);
	nu[i22 + 3 + t2 * 6] = i12 + 3 + (t1 << 3);
	if (i + 4 > 1024) {
	    s_wsle(&io___2611);
	    do_lio(&c__9, &c__1, " fatal ERROR mshopt la pile est trop petit"
		    "e ", 44L);
	    do_lio(&c__3, &c__1, (char *)&c__1024, (ftnlen)sizeof(integer));
	    e_wsle();
	    *err = 21;
	    return 0;
	}
	if (*iop >= 50) {
	    mshdrw_(&c[3], &nu[7], &c__6, &t1, iop);
	}
	if (*iop >= 50) {
	    mshdrw_(&c[3], &nu[7], &c__6, &t2, iop);
	}
	++i;
	pile[(i << 1) - 2] = t1;
	pile[(i << 1) - 1] = a1;
	++i;
	pile[(i << 1) - 2] = t2;
	pile[(i << 1) - 1] = a2;
	++i;
	pile[(i << 1) - 2] = t1;
	pile[(i << 1) - 1] = i13 + 3;
	++i;
	pile[(i << 1) - 2] = t2;
	pile[(i << 1) - 1] = i23 + 3;
	goto L10;
    }
    return 0;
} /* mshopt_ */

/* Subroutine */ int mshptg_(real *cr, real *h, integer *c, integer *nu, 
	integer *nbs, integer *nbsmx, integer *tri, integer *arete, integer *
	nba, integer *sd, integer *nbsd, integer *reft, integer *nbt, real *
	coef, real *puis, integer *iop, logical *regul, integer *err)
{
    /* System generated locals */
    integer i__1, i__2;
    cilist ci__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void), s_wsfe(cilist *), do_fio(integer *, char *, ftnlen),
	     e_wsfe(void);

    /* Local variables */
    integer tete;
    extern /* Subroutine */ int ligh3_(integer *, integer *, integer *);
    integer i, j, k, t, impre;
    real trfri[4];
    extern /* Subroutine */ int clnfnt_(void);
    integer nbsgrn, nbtgrn;
    extern /* Subroutine */ int mshcxi_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *), mshrgl_(real *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *, real *, integer *);
    extern /* Subroutine */ int mshfrt_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), mshgpt_(integer *, real *, integer *, real 
	    *, integer *, integer *, integer *, integer *, real *, real *, 
	    real *, integer *, integer *), mshtri_(real *, integer *, integer 
	    *, integer *, integer *, real *, integer *, integer *), mshdrw_(
	    integer *, integer *, integer *, integer *, integer *), mshvoi_(
	    integer *, integer *, integer *, integer *, integer *);

    /* Fortran I/O blocks */
    /*static*/ cilist io___2614 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2618 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2619 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2621 = { 0, 6, 0, 0, 0 };


/* -----------------------------------------------------------------------
 */
/*      but:  construire une triangulation a partir d'un ensemble de */
/*             points et d'un maillage frontalier */
/* -----------------------------------------------------------------------
 */
/*     entre : */
/*     ------- */
/*           cr(2,nbsmx)  tableau des coordonnees des nbs points donnes */

/*           h (nbsmx)    tableau du h local voulu autour de chaque point 
*/
/*                          donnes */

/*           nbs          nombre de points donnes */
/*           nbsmx        nombre de points maximal a cree */
/*                        si nbs  = nbsmx ont ne cree pas de points */
/*                        si nbs  < nbsmx => erreur */

/*           arete(2,nba) tableau des aretes du maillage a forcer */
/*                          exemple :la frontiere */

/*           nba          le nombre d'aretes du maillage */

/*           sd(2,nbsd)   tableau definisant les nbsd  sous domaine */
/*                          (reference des triangles gerener) */
/*                          abs(sd(1,i)) =  numero d'une l'arete */
/*                          si sd(1,i) est positive alors le sous domaine 
*/
/*                          est a gauche de l'arete sinon il est a droite 
*/
/*                          sd(2,i) donne le numero du sous doimaine */

/*           iop          option de trace et d'impression */
/*                        1) impre = mod(iop,10) */
/*                           impre = 0 => pas impression */
/*                           impre > 4 => le resultat est imprime */
/*                           impre > 5 => debug */
/*                        2) iop  <10 ==> pas de graphique */
/*                            iop > 9  on trace le  mailage construit */
/*                            iop > 29  + numero des points */
/*                            iop > 49  on  trace  tout les mouvement */
/*                                      des triangles */
/*                            iop > 99  un (cr) est attendu apres tracer 
*/
/*                                      de triangle */
/*                            le graphique utilise fortran-3d */
/*                            ------------------------------- */

/*           puis         coefficent de generation des points */
/*                        .1  => on propage plus loin les raffinements */
/*                               donnes par h */
/*                        .25 => valeur conseillee */

/*           coef         coefficent sur le test arret */
/*                          le valeur conseillee est .75 */
/*                          remarque le nombre de points generes est en */
/*                          o(coef**2) */

/*          regul        = .true. => regularisation */
/*          regul        = .false. => pas de regularisation */

/*        tableaux de travail: */
/*        -------------------- */

/*           c(2,nbsmx)    tableau d'entiers (copie de coordonnees) */
/*           tri(ltri)     tableau d'entiers */

/*        out : */
/*        ----- */

/*         nbs         nombre de points   donnes + generes */
/*         nbt         nombre de triangles generes */
/*         cr(1:2,nbs) coordonnees des sommets donnes + generes */
/*         nu(1:3,nbt) sommets des triangles (tableau des connections) */
/*                       telle que les sommets tourne dans le sens direct 
*/
/*         reft(1:nbt) numero de sous domaine de chaque triangle */

/*         err    si err = 0 alors pas de probleme */
/*                sinon nbt = 0 et pas de triangulation */

/*     dimension des tableaux */
/*     ---------------------- */
/*     definition des parameters */
/*     nbtmx = 2*(nbsmx-1) ,  ltri = max(4*nbsmx+2*nbsd,nba) */

/*     integer : nu(6*nbtmx) , reft(nbtmx) , c(2*nbsmx) , tri(ltri) */
/*     integer : arete(2,nba), sd(2,nbsd) */
/*     real    : cr(2*nbsmx) , h(nbsmx) */

/* ---------------------------------------------------------------------- 
*/
/*     programmeur f.hecht, inria rocquencourt, 78153 le chesnay, france 
*/
/*           version 1.0  mars 1986 */
/* -----------------------------------------------------------------------
 */
/*    dcl */
/* ...... dcl des variables locales ......................................
 */
/* ...... dcl des parametres de la regularisations` */
/* ...... fin dens dcl....................................................
 */
    /* Parameter adjustments */
    --reft;
    sd -= 3;
    arete -= 3;
    --tri;
    --nu;
    c -= 3;
    --h;
    cr -= 3;

    /* Function Body */
    impre = *iop % 10;
    *err = 0;
    *nbt = 0;
    if (*nbs < 3 || *nbsmx < *nbs) {
	*err = 1;
	s_wsle(&io___2614);
	do_lio(&c__9, &c__1, "fatal ERROR mshpts : le nombre de points ", 41L)
		;
	do_lio(&c__3, &c__1, (char *)&(*nbs), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " est < 3 ou > ", 14L);
	do_lio(&c__3, &c__1, (char *)&(*nbsmx), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " nb de maximal ", 15L);
	e_wsle();
	return 0;
    }
/* ------------------------- */
/* preparation des donnees */
/* ------------------------- */
    mshtri_(&cr[3], &c[3], nbs, &tri[1], &tri[*nbs + 1], trfri, iop, err);
    if (*err != 0) {
	return 0;
    }
    if (*iop >= 50) {
	clnfnt_();
    }
/* -------------------------------- */
/* maillage de l enveloppe convexe */
/* -------------------------------- */
    mshcxi_(&c[3], &nu[1], &tri[1], nbs, &tete, iop, err);
/* -----------------------------------------------------------------------
 */
/*     definition de tableau nu(1:6,2*nbs-2) */
/* -----------------------------------------------------------------------
 */
/*     nu(*,ie) definit soit un element ,soit un sommet frontiere */
/*     si nu(5:6,ie) = (0,0) alors ie est un sommet frontiere */
/*     avec nu(1,ie) = numero du sommet */
/*          nu(2,ie) = 8*t + a */
/*                     ou t est le numero du triangle ayant l'arete */
/*                     frontiere (a) dont le premier sommet est nu(1,ie) 
*/
/*          nu(3,ie) = pointeur dans nu sur sommet frontiere precedent */
/*          nu(4,ie) = pointeur dans nu sur sommet frontiere suivant */

/*     sinon ie est un element : */
/*          nu(1:3,ie) numero des 3 sommets du triangle ie tournant dans 
*/
/*                     le sens direct */
/*          nu(4:6,ie) = (d4,d5,d6) donnee des 3 aretes ai */
/*           ai est forme des sommets nu(i-3,ie),nu(mod(i,3)+1,ie) */
/*           si di < 0 alors arete i est frontiere et -di est pointeur */
/*             sur 1er sommet frontiere de i */
/*           sinon arete est interne et di = 8*ta + ata */
/*              ou ta est le numero du triangle adjacent a l'arete */
/*              et ata est le numero de l'arete dans ta */
/* -----------------------------------------------------------------------
 */
    if (*err != 0) {
	return 0;
    }

    i__1 = *nbs;
    for (i = 1; i <= i__1; ++i) {
	tri[i] = 0;
/* L10: */
    }
    if (impre > 4) {
	s_wsle(&io___2618);
	do_lio(&c__9, &c__1, "frontiere convexe tete =", 24L);
	do_lio(&c__3, &c__1, (char *)&tete, (ftnlen)sizeof(integer));
	e_wsle();
    }
    i = tete;
L20:
    if (impre > 4) {
	s_wsle(&io___2619);
	do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " s = ", 5L);
	do_lio(&c__3, &c__1, (char *)&nu[(i - 1) * 6 + 1], (ftnlen)sizeof(
		integer));
	do_lio(&c__9, &c__1, " t = ", 5L);
	i__1 = nu[(i - 1) * 6 + 2] / 8;
	do_lio(&c__3, &c__1, (char *)&i__1, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " a= ", 4L);
	i__2 = ((i - 1) * 6 + 2) % 8;
	do_lio(&c__3, &c__1, (char *)&i__2, (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, " precedent =", 12L);
	do_lio(&c__3, &c__1, (char *)&nu[(i - 1) * 6 + 3], (ftnlen)sizeof(
		integer));
	e_wsle();
    }
    j = nu[(i - 1) * 6 + 4];
    tri[nu[(i - 1) * 6 + 1]] = nu[(j - 1) * 6 + 1];
    i = j;
    if (i != tete) {
	goto L20;
    }
/* ----------------------------- */
/* traitement frontiere */
/* ----------------------------- */
    if (impre >= 4) {
	s_wsle(&io___2621);
	do_lio(&c__9, &c__1, " les elements ", 14L);
	e_wsle();
    }
    mshfrt_(&c[3], &nu[1], nbs, &arete[3], nba, &sd[3], nbsd, &reft[1], &tri[
	    1], iop, err);
    if (*err != 0) {
	return 0;
    }
/* ------------------------------------------------------------------- */
/*       on a modifie nu les sommets frontiere n'ont plus de sens */
/*       ainsi que les pointeurs sur ces elements */
/* ------------------------------------------------------------------- */
    nbsgrn = *nbs;
    mshgpt_(&c[3], &cr[3], &nu[1], &h[1], &reft[1], &nbsgrn, nbsmx, &nbtgrn, 
	    coef, puis, trfri, iop, err);
    if (*err != 0) {
	return 0;
    }
    if (*iop >= 10) {
	clnfnt_();
	ligh3_(&c_n1, &c_n1, &ctabco_1.pafond);
    }
/*     construction du tableau nu(1:3,1:nbt) */
/* ------------------------------------------ */
    *nbt = 0;
    k = 0;
    j = 1;
    i__1 = nbtgrn;
    for (t = 1; t <= i__1; ++t) {
	if (nu[j + 5] != 0) {
	    ++(*nbt);
	    reft[*nbt] = reft[t];
	    for (i = 0; i <= 2; ++i) {
		++k;
		nu[k] = nu[j + i];
/* L190: */
	    }
	    if (*iop >= 10) {
		mshdrw_(&c[3], &nu[1], &c__3, nbt, iop);
	    }
	    if (impre > 4) {
		ci__1.cierr = 0;
		ci__1.ciunit = 6;
		ci__1.cifmt = "(7i12)";
		s_wsfe(&ci__1);
		do_fio(&c__1, (char *)&t, (ftnlen)sizeof(integer));
		for (i = 0; i <= 5; ++i) {
		    do_fio(&c__1, (char *)&nu[j + i], (ftnlen)sizeof(integer))
			    ;
		}
		e_wsfe();
	    }
	}
	j += 6;
/* L200: */
    }
/*     dans nu il y a (s1(t),s2(t),s3(t),t=1,nbt) */
/*     ou s1 s2 s3 sont les 3 sommets de t */
/* ------------------------------------------------ */
    i__1 = *nbs;
    for (i = 1; i <= i__1; ++i) {
	tri[i] = 1;
/* L210: */
    }
    i__1 = nbsgrn;
    for (i = *nbs + 1; i <= i__1; ++i) {
	tri[i] = 0;
/* L220: */
    }
    if (*regul) {
	mshvoi_(&nu[1], &tri[nbsgrn + 1], &nu[*nbt * 3 + 1], nbt, &nbsgrn);
	mshrgl_(&cr[3], &tri[1], &nbsgrn, &nu[1], &tri[nbsgrn + 1], &nu[*nbt *
		 3 + 1], nbt, &c_b6208, &c__20, &c_b661, iop);
    }
    *nbs = nbsgrn;
    return 0;
} /* mshptg_ */

#undef coulls


/* Subroutine */ int mshrgl_(real *cc, integer *nrfs, integer *nsb, integer *
	nnu, integer *w1, integer *w, integer *ntb, real *omega, integer *
	itermx, real *eeps, integer *iop)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4;
    real r__1, r__2, r__3, r__4;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real depx, depy;
    integer iter;
    real xmin, ymin, xmax, ymax;
    integer i, j, k, impre, i1, i2;
    extern /* Subroutine */ int mshdr1_(real *, integer *, integer *, integer 
	    *, integer *), masqu2_(real *, real *, real *, real *);
    integer ic;
    real bx, by, dx;
    integer is;
    extern /* Subroutine */ int clnfnt_(void);
    real err;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2645 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2646 = { 0, 6, 0, 0, 0 };




/* regularisation par moyenne barycentrique */
/* ----------------------------------------- */
    /* Parameter adjustments */
    --w;
    --nnu;
    --nrfs;
    cc -= 3;

    /* Function Body */
    impre = *iop % 10;
    xmin = cc[3];
    ymin = cc[4];
    xmax = cc[3];
    ymax = cc[4];
    i__1 = *nsb;
    for (ic = 1; ic <= i__1; ++ic) {
/* Computing MIN */
	r__1 = cc[(ic << 1) + 1];
	xmin = dmin(r__1,xmin);
/* Computing MIN */
	r__1 = cc[(ic << 1) + 2];
	ymin = dmin(r__1,ymin);
/* Computing MAX */
	r__1 = cc[(ic << 1) + 1];
	xmax = dmax(r__1,xmax);
/* Computing MAX */
	r__1 = cc[(ic << 1) + 2];
	ymax = dmax(r__1,ymax);
/* L10: */
    }
/* Computing MAX */
    r__1 = xmax - xmin, r__2 = ymax - ymin;
    dx = dmax(r__1,r__2);
/* -------graphique------------- */
    if (*iop >= 10) {
	r__1 = xmin - dx * .01f;
	r__2 = xmin + dx * 1.01f;
	r__3 = ymin - dx * .01f;
	r__4 = ymin + dx * 1.01f;
	masqu2_(&r__1, &r__2, &r__3, &r__4);
    }
/* ----------------------------- */
    i__1 = *itermx;
    for (iter = 1; iter <= i__1; ++iter) {
	err = 0.f;
	i2 = w1[0];
/* ------------graphique------trace a la fin de chaque iteration--- */
	if (*iop >= 30 && (*iop >= 40 && iter == 1)) {
	    clnfnt_();
	    i__2 = *ntb;
	    for (j = 1; j <= i__2; ++j) {
		mshdr1_(&cc[3], &nnu[1], &c__3, &j, iop);
/* L15: */
	    }
	}
/* -------------------------------- */
	i__2 = *nsb;
	for (is = 1; is <= i__2; ++is) {
	    i1 = i2 + 1;
	    i2 = w1[is];
	    if (i2 >= i1 && nrfs[is] == 0) {
		bx = 0.f;
		by = 0.f;
		i__3 = i2;
		for (i = i1; i <= i__3; ++i) {
		    if (w[i] % 3 == 0) {
			k = w[i] - 2;
		    } else {
			k = w[i] + 1;
		    }
		    bx += cc[(nnu[k] << 1) + 1];
		    by += cc[(nnu[k] << 1) + 2];
/* L20: */
		}
		bx /= i2 - i1 + 1;
		by /= i2 - i1 + 1;
		depx = *omega * (cc[(is << 1) + 1] - bx);
		depy = *omega * (cc[(is << 1) + 2] - by);
		cc[(is << 1) + 1] -= depx;
		cc[(is << 1) + 2] -= depy;
/* Computing MAX */
		r__1 = err, r__2 = dabs(depx), r__1 = max(r__1,r__2), r__2 = 
			dabs(depy);
		err = dmax(r__1,r__2);
/* -----------graphique-------trace au fur et a mesure---- */
		if (*iop >= 40) {
		    i__3 = i2;
		    for (i = i1; i <= i__3; ++i) {
			i__4 = (w[i] + 2) / 3;
			mshdr1_(&cc[3], &nnu[1], &c__3, &i__4, iop);
/* L30: */
		    }
		}
/* ------------------------------- */
	    }
/* L40: */
	}
	if (impre >= 3) {
	    s_wsle(&io___2645);
	    do_lio(&c__9, &c__1, " iteration ", 11L);
	    do_lio(&c__3, &c__1, (char *)&iter, (ftnlen)sizeof(integer));
	    do_lio(&c__9, &c__1, " deplacement maximal : ", 23L);
	    do_lio(&c__4, &c__1, (char *)&err, (ftnlen)sizeof(real));
	    r__1 = err / dx;
	    do_lio(&c__4, &c__1, (char *)&r__1, (ftnlen)sizeof(real));
	    e_wsle();
	}
	if (err <= *eeps * dx) {
/* ------------graphique------trace a la fin de la regularisation
--- */
	    if (*iop >= 20 && *iop < 40) {
		clnfnt_();
		i__2 = *ntb;
		for (j = 1; j <= i__2; ++j) {
		    mshdr1_(&cc[3], &nnu[1], &c__3, &j, iop);
/* L46: */
		}
	    }
/* -------------------------------- */
	    return 0;
	}
/* L50: */
    }
    s_wsle(&io___2646);
    do_lio(&c__9, &c__1, " WARNING mshrlg : on a pas converge en ", 39L);
    do_lio(&c__3, &c__1, (char *)&(*itermx), (ftnlen)sizeof(integer));
    do_lio(&c__9, &c__1, " iterations", 11L);
    e_wsle();
    return 0;
} /* mshrgl_ */

/* Subroutine */ int mshrnm_(integer *renu, integer *iw, real *rw)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, j;


/* -----------------------------------------------------------------------
 */
/*  but renumeroter la le maillage avec le tableau renu */
/* -----------------------------------------------------------------------
 */
/* ----    les triangles */
    /* Parameter adjustments */
    --rw;
    --iw;
    --renu;

    /* Function Body */
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	if (bdmsh9_1.nsea[i * 6 - 6] > 0) {
	    for (j = 1; j <= 3; ++j) {
		bdmsh9_1.nsea[j + i * 6 - 7] = renu[bdmsh9_1.nsea[j + i * 6 - 
			7]];
/* L50: */
	    }
	}
/* L60: */
    }
/* ----    les aretes frontiere de sous domaine */
    i__1 = bdmsh1_1.nba;
    for (i = 1; i <= i__1; ++i) {
	bdmshc_1.aretbd[(i << 1) - 2] = renu[bdmshc_1.aretbd[(i << 1) - 2]];
	bdmshc_1.aretbd[(i << 1) - 1] = renu[bdmshc_1.aretbd[(i << 1) - 1]];
/* L70: */
    }
/* ----  renum des sommets ------------------ */
    for (j = 1; j <= 2; ++j) {
	i__1 = bdmsh1_1.nbs;
	for (i = 1; i <= i__1; ++i) {
	    rw[i] = bdmsh5_1.cr[j + (i << 1) - 3];
/* L80: */
	}
	i__1 = bdmsh1_1.nbs;
	for (i = 1; i <= i__1; ++i) {
	    if (renu[i] != 0) {
		bdmsh5_1.cr[j + (renu[i] << 1) - 3] = rw[i];
	    }
/* L90: */
	}
/* L100: */
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	if (renu[i] != 0) {
	    iw[i] = bdmsh8_1.refs[i - 1];
	}
/* L110: */
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	if (renu[i] != 0) {
	    bdmsh8_1.refs[renu[i] - 1] = iw[i];
	}
/* L120: */
    }
/* -----   abcurv  sommets ------------ */
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	rw[i] = bdmsh7_1.abcurv[i - 1];
/* L130: */
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	if (renu[i] != 0) {
	    bdmsh7_1.abcurv[renu[i] - 1] = rw[i];
	}
/* L140: */
    }
/* -----   nsorig ------------ */
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	iw[i] = bdmsh6_1.nsorig[i - 1];
/* L150: */
    }
    i__1 = bdmsh1_1.nbs;
    for (i = 1; i <= i__1; ++i) {
	if (renu[i] != 0) {
	    bdmsh6_1.nsorig[renu[i] - 1] = renu[iw[i]];
	}
/* L160: */
    }
    return 0;
} /* mshrnm_ */




/* Subroutine */ int mshtr1_(integer *criter, integer *record, integer *n)
{
    integer crit, i, j, l, r, rec;

/*     trie selon les valeurs de criter croissantes */
/*     record suit le reordonnancement */


    /* Parameter adjustments */
    --record;
    --criter;

    /* Function Body */
    if (*n <= 1) {
	return 0;
    }
    l = *n / 2 + 1;
    r = *n;
L2:
    if (l <= 1) {
	goto L20;
    }
    --l;
    rec = record[l];
    crit = criter[l];
    goto L3;
L20:
    rec = record[r];
    crit = criter[r];
    record[r] = record[1];
    criter[r] = criter[1];
    --r;
    if (r == 1) {
	goto L999;
    }
L3:
    j = l;
L4:
    i = j;
    j <<= 1;
    if (j - r < 0) {
	goto L5;
    } else if (j == r) {
	goto L6;
    } else {
	goto L8;
    }
L5:
    if (criter[j] < criter[j + 1]) {
	++j;
    }
L6:
    if (crit >= criter[j]) {
	goto L8;
    }
    record[i] = record[j];
    criter[i] = criter[j];
    goto L4;
L8:
    record[i] = rec;
    criter[i] = crit;
    goto L2;
L999:
    record[1] = rec;
    criter[1] = crit;
    return 0;
} /* mshtr1_ */

/* Subroutine */ int mshtri_(real *ccr, integer *cc, integer *nsb, integer *
	ttri, integer *nnu, real *trfri, integer *iop, integer *err)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    integer i_nint(real *), s_wsle(cilist *), do_lio(integer *, integer *, 
	    char *, ftnlen), e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    integer ierr, trik;
    real xmin, ymin, xmax, ymax;
    integer i, j, k, devic;
    extern /* Subroutine */ int fentr2_(real *, real *, real *, real *), 
	    masqu2_(real *, real *, real *, real *);
    integer ic, jc;
    extern /* Subroutine */ int mshtr1_(integer *, integer *, integer *);
    integer ip;
    extern /* Subroutine */ int enddev_(integer *);
    integer xx;
    real aa1, aa2;
    extern /* Subroutine */ int inqfnt_(real *, real *, real *, real *);
    real xx1, xx2, yy1, yy2;
    integer iii, det;
    real dxx;
    integer tri3;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2676 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2677 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2678 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2681 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2682 = { 0, 6, 0, 0, 0 };



    /* Parameter adjustments */
    --trfri;
    --nnu;
    --ttri;
    cc -= 3;
    ccr -= 3;

    /* Function Body */
    ierr = 0;
    iii = 1;
    xmin = ccr[3];
    ymin = ccr[4];
    xmax = ccr[3];
    ymax = ccr[4];
    i__1 = *nsb;
    for (ic = 1; ic <= i__1; ++ic) {
/* Computing MIN */
	r__1 = ccr[(ic << 1) + 1];
	xmin = dmin(r__1,xmin);
/* Computing MIN */
	r__1 = ccr[(ic << 1) + 2];
	ymin = dmin(r__1,ymin);
/* Computing MAX */
	r__1 = ccr[(ic << 1) + 1];
	xmax = dmax(r__1,xmax);
/* Computing MAX */
	r__1 = ccr[(ic << 1) + 2];
	ymax = dmax(r__1,ymax);
	ttri[ic] = ic;
	if (ccr[(ic << 1) + 1] < ccr[(iii << 1) + 1]) {
	    iii = ic;
	}
/* L10: */
    }
    aa1 = 32767.f / (xmax - xmin);
    aa2 = 32767.f / (ymax - ymin);
    aa1 = dmin(aa1,aa2);
    aa2 = aa1 * (ccr[(iii << 1) + 2] - ymin);
    trfri[1] = aa1;
    trfri[2] = ccr[(iii << 1) + 1];
    trfri[3] = ymin;
    trfri[4] = aa2;
    i__1 = *nsb;
    for (ic = 1; ic <= i__1; ++ic) {
	r__1 = aa1 * (ccr[(ic << 1) + 1] - ccr[(iii << 1) + 1]);
	cc[(ic << 1) + 1] = i_nint(&r__1);
	r__1 = aa1 * (ccr[(ic << 1) + 2] - ymin) - aa2;
	cc[(ic << 1) + 2] = i_nint(&r__1);
/* Computing 2nd power */
	i__2 = cc[(ic << 1) + 1];
/* Computing 2nd power */
	i__3 = cc[(ic << 1) + 2];
	nnu[ic] = i__2 * i__2 + i__3 * i__3;
/* L20: */
    }
    if (*iop >= 10) {
/* fentr2 : taille du dessin en cm */
/* -------------------------------- */
	inqfnt_(&xx1, &xx2, &yy1, &yy2);
/*       call szscrn (xx1,xx2,yy1,yy2) */
/* Computing MIN */
	r__1 = xx2 - xx1, r__2 = yy2 - yy1;
	dxx = dmin(r__1,r__2);
	r__1 = xx1 + dxx;
	r__2 = yy1 + dxx;
	fentr2_(&xx1, &r__1, &yy1, &r__2);
/*       print*,'fnte =',xx1,xx2,yy1,yy2,' fnts =',xx1,xx1+dxx,yy1,yy1
+dx */
	r__1 = -327.67000000000002f - aa2;
	r__2 = 33094.669999999998f - aa2;
	masqu2_(&c_b6267, &c_b6268, &r__1, &r__2);
/*       print*,'msq =',-.01*precis      ,    1.01*precis */
/*     &            ,-.01*precis-aa2  ,    1.01*precis-aa2 */
    }
/* ---------------------------------------------------------- */
    if (*nsb > 1) {
	mshtr1_(&nnu[1], &ttri[1], nsb);
    }
    ip = 1;
    xx = nnu[ip];
    i__1 = *nsb;
    for (jc = 1; jc <= i__1; ++jc) {
	if (nnu[jc] > xx) {
	    if (jc - ip > 1) {
		i__2 = jc - ip;
		mshtr1_(&nnu[ip], &ttri[ip], &i__2);
	    }
	    i__2 = jc - 2;
	    for (i = ip; i <= i__2; ++i) {
		if (nnu[i] == nnu[i + 1]) {
		    ++ierr;
		    s_wsle(&io___2676);
		    do_lio(&c__9, &c__1, " ERROR les points ", 18L);
		    do_lio(&c__3, &c__1, (char *)&ttri[i], (ftnlen)sizeof(
			    integer));
		    do_lio(&c__3, &c__1, (char *)&ttri[i + 1], (ftnlen)sizeof(
			    integer));
		    do_lio(&c__9, &c__1, " sont egaux", 11L);
		    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i] << 1) + 1], (
			    ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i] << 1) + 2], (
			    ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i + 1] << 1) + 1],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i + 1] << 1) + 2],
			     (ftnlen)sizeof(real));
		    e_wsle();
		}
/* L25: */
	    }
	    xx = nnu[jc];
	    ip = jc;
	}
	ic = ttri[jc];
	nnu[jc] = cc[(ic << 1) + 2];
/* L30: */
    }
    if (*nsb - ip > 1) {
	i__1 = *nsb - ip;
	mshtr1_(&nnu[ip], &ttri[ip], &i__1);
    }
    i__1 = jc - 2;
    for (i = ip; i <= i__1; ++i) {
	if (nnu[i] == nnu[i + 1]) {
	    ++ierr;
	    s_wsle(&io___2677);
	    do_lio(&c__9, &c__1, " ERROR les points ", 18L);
	    do_lio(&c__3, &c__1, (char *)&ttri[i], (ftnlen)sizeof(integer));
	    do_lio(&c__3, &c__1, (char *)&ttri[i + 1], (ftnlen)sizeof(integer)
		    );
	    do_lio(&c__9, &c__1, " sont egaux", 11L);
	    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i] << 1) + 1], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i] << 1) + 2], (ftnlen)
		    sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i + 1] << 1) + 1], (
		    ftnlen)sizeof(real));
	    do_lio(&c__4, &c__1, (char *)&ccr[(ttri[i + 1] << 1) + 2], (
		    ftnlen)sizeof(real));
	    e_wsle();
	}
/* L35: */
    }
    if (ierr != 0) {
	*err = 2;
	s_wsle(&io___2678);
	do_lio(&c__9, &c__1, " fatal ERROR mshtri:il y a des points confondus"
		, 47L);
	e_wsle();
	return 0;
    }
    k = 2;
L50:
    if (k <= *nsb) {
	++k;
	det = cc[(ttri[2] << 1) + 1] * cc[(ttri[k] << 1) + 2] - cc[(ttri[2] <<
		 1) + 2] * cc[(ttri[k] << 1) + 1];
	if (det == 0) {
	    goto L50;
	}
    } else {
	s_wsle(&io___2681);
	do_lio(&c__9, &c__1, "fatal ERROR mshtri tous les points sont alignes"
		, 47L);
	e_wsle();
	s_wsle(&io___2682);
	do_lio(&c__9, &c__1, "ttri =", 6L);
	i__1 = *nsb;
	for (k = 1; k <= i__1; ++k) {
	    do_lio(&c__3, &c__1, (char *)&ttri[k], (ftnlen)sizeof(integer));
	}
	e_wsle();
	*err = 3;
	devic = 0;
	enddev_(&devic);
	s_stop("FATAL ERROR", 11L);
    }
/*     k est le premier point non aligne */
    trik = ttri[k];
    for (j = k - 1; j >= 3; --j) {
	ttri[j + 1] = ttri[j];
/* L60: */
    }
    ttri[3] = trik;
    if (det < 0) {
/*       on inverse les  points 2 3 tries */
	tri3 = ttri[3];
	ttri[3] = ttri[2];
	ttri[2] = tri3;
    }
    return 0;
} /* mshtri_ */

/* Subroutine */ int mshvoi_(integer *nu, integer *w1, integer *w, integer *
	nbt, integer *nbs)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i, is;


/* recherche du voisinage */
/* ----------------------- */
    /* Parameter adjustments */
    --w;
    --nu;

    /* Function Body */
    i__1 = *nbs;
    for (i = 1; i <= i__1; ++i) {
	w1[i] = 0;
/* L10: */
    }
    i__1 = *nbt * 3;
    for (i = 1; i <= i__1; ++i) {
	++w1[nu[i]];
/* L30: */
    }
    w1[0] = 0;
    i__1 = *nbs;
    for (i = 1; i <= i__1; ++i) {
	w1[i] = w1[i - 1] + w1[i];
/* L40: */
    }
    i__1 = *nbt * 3;
    for (i = 1; i <= i__1; ++i) {
	is = nu[i] - 1;
	++w1[is];
	w[w1[is]] = i;
/* L60: */
    }
    for (i = *nbs; i >= 1; --i) {
	w1[i] = w1[i - 1];
/* L70: */
    }
    w1[0] = 0;
    return 0;
} /* mshvoi_ */

integer nbintlk_(integer *lst)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer compt;

    extern /* Subroutine */ int freel_(integer *);
    integer pt1;


/* ---    nb d'intervalle sur liste -- */
/* --   si lst >0 => on vide la liste -- */
    compt = 0;
    pt1 = abs(*lst);
L4500:
    if (pt1 != 0) {
	compt = compt + bdpec3_1.nbnode[(i__1 = listea_1.car[pt1 - 1], abs(
		i__1)) + 64] - 1;
	pt1 = listed_1.cdr[pt1 - 1];
	goto L4500;
    }
    ret_val = compt;
    if (*lst > 0) {
	freel_(lst);
    }
    return ret_val;
} /* nbintlk_ */




integer nbrfs_(integer *m, integer *lm)
{
    /* System generated locals */
    integer ret_val, i__1;

    /* Local variables */
    integer i, j, l, r;

    integer mn, mx;
    extern integer rfsomm_(integer *), rfaret_(integer *, integer *);
    extern /* Subroutine */ int scrtch_(char *, ftnlen);

/*     ref sommets */
/* w      k = 0 */
/* w      do 20 i=1,nbsrft */
/* w       r = rfsomm(i) */
/* w       if(r.ne.0) then */
/* w         do 10 j=1,k */
/* w          if(r.eq.m(j)) goto 20 */
/* w10       continue */
/* w         if(k.lt.lm) then */
/* w           k = k + 1 */
/* w           m(k)=r */
/* w         endif */
/* w       endif */
/* w20    continue */
/* w      do 50 i=1,nbt */
/* w       do 40 j=4,6 */
/* w        l=nsea(j,i) */
/* w        if(l.lt.0) then */
/* w          r = rfaret(i,j) */
/* w          if(r.ne.0) then */
/* w            do 30 l=1,k */
/* w             if(r.eq.m(l)) goto 40 */
/* w30          continue */
/* w            if(k.lt.lm) then */
/* w              k = k + 1 */
/* w              m(k)=r */
/* w            endif */
/* w          endif */
/* w        endif */
/* w40     continue */
/* w50    continue */
/* w      nbrfs = k */
    /* Parameter adjustments */
    --m;

    /* Function Body */
    mn = rfsomm_(&c__1);
    mx = mn;
    i__1 = bdmsh1_1.nbsrft;
    for (i = 2; i <= i__1; ++i) {
	r = rfsomm_(&i);
	mn = min(r,mn);
	mx = max(r,mx);
/* L20: */
    }
    i__1 = bdmsh1_1.nbt;
    for (i = 1; i <= i__1; ++i) {
	for (j = 4; j <= 6; ++j) {
	    l = bdmsh9_1.nsea[j + i * 6 - 7];
	    if (l < 0) {
		r = rfaret_(&i, &j);
		mn = min(r,mn);
		mx = max(r,mx);
	    }
/* L40: */
	}
/* L50: */
    }
    ret_val = mx;
    if (mn < 0) {
	scrtch_("ATTENTION il y a des ref d'aretes ou de sommets < 0", 51L);
    }
    return ret_val;
} /* nbrfs_ */




integer nbrfsd_(integer *m, integer *lm)
{
    /* System generated locals */
    integer ret_val, i__1, i__2, i__3;

    /* Local variables */
    integer i;

    integer mn, mx;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);

/* w      k = 0 */
/* w      do 20 i=1,nbt */
/* w       r = refsd(reft(i)) */
/* w       do 10 j=1,k */
/* w        if(r.eq.m(j)) goto 20 */
/* w10     continue */
/* w       if(k.lt.lm) then */
/* w         k = k + 1 */
/* w         m(k)=r */
/* w       endif */
/* w20    continue */
/* w      nbrfsd = k */
    /* Parameter adjustments */
    --m;

    /* Function Body */
    mn = bdmshf_1.refsd[bdmsha_1.reft[0] - 1];
    mx = bdmshf_1.refsd[bdmsha_1.reft[0] - 1];
    i__1 = bdmsh1_1.nbt;
    for (i = 2; i <= i__1; ++i) {
/* Computing MIN */
	i__2 = mn, i__3 = bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1];
	mn = min(i__2,i__3);
/* Computing MAX */
	i__2 = mx, i__3 = bdmshf_1.refsd[bdmsha_1.reft[i - 1] - 1];
	mx = max(i__2,i__3);
/* L10: */
    }
    ret_val = mx;
    if (mn <= 0) {
	scrtch_(" ATTENTION il a des ref SD < 1", 30L);
    }
    return ret_val;
} /* nbrfsd_ */




/* Subroutine */ int nodelm_(integer *i, integer *nbn)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern integer last_(integer *);

    integer pt, pt1;
    extern /* Subroutine */ int drawad_(integer *, integer *);


/*      affect nbn points (extremitees incluses) */
/*       a l'element i (peut modifier nbn) */


    if (*i == 0) {
	return 0;
    }
    drawad_(i, &c_n1);
    bdpec3_1.nbnode[*i + 64] = max(*nbn,2);
    if (bdpec2_1.bd[*i * 6 + 384] == -2.f) {
	if ((r__2 = (r__1 = bdpec2_1.bd[*i * 6 + 389], dabs(r__1)) - 
		6.283185306f, dabs(r__2)) <= 5e-6f) {
/*         arc ferme on force 4 noeuds */
/* Computing MAX */
	    i__1 = bdpec3_1.nbnode[*i + 64];
	    bdpec3_1.nbnode[*i + 64] = max(i__1,4);
	} else if ((r__1 = bdpec2_1.bd[*i * 6 + 389], dabs(r__1)) >= 
		3.1415876530000002f) {
/*         arc d'angle > pi on force 3 noeuds */
/* Computing MAX */
	    i__1 = bdpec3_1.nbnode[*i + 64];
	    bdpec3_1.nbnode[*i + 64] = max(i__1,3);
	}
    } else if (bdpec2_1.bd[*i * 6 + 384] == -4.f) {
	pt = listea_1.car[(integer) bdpec2_1.bd[*i * 6 + 386] - 1];
	i__1 = (integer) bdpec2_1.bd[*i * 6 + 386];
	pt1 = listea_1.car[last_(&i__1) - 1];
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[pt1 * 6 + 385] - bdpec2_1.bd[pt * 6 + 385];
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[pt1 * 6 + 386] - bdpec2_1.bd[pt * 6 + 386];
	if (sqrt(r__1 * r__1 + r__2 * r__2) <= eps_1.eps) {
/*         spline fermee on lui force 4 noeuds */
/* Computing MAX */
	    i__1 = bdpec3_1.nbnode[*i + 64];
	    bdpec3_1.nbnode[*i + 64] = max(i__1,4);
	}
    }
    *nbn = bdpec3_1.nbnode[*i + 64];
    drawad_(i, &c__0);
    return 0;
} /* nodelm_ */




/* Subroutine */ int nodlig_(integer *ptlign, integer *nbnood)
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    integer i_nint(real *);

    /* Local variables */
    integer snbn;
    real dist1, dist2;

    integer nbint;
    extern doublereal lngelm_(integer *);
    integer pt, pt1, nbn;
    extern /* Subroutine */ int nodelm_(integer *, integer *);



/*        repartie le nombre d'intervals nbnood sur */
/*        les differentes parties de la ligne ptlign */

    pt = *ptlign;
    dist1 = 0.f;
    nbn = 0;
L1200:
    if (pt != 0) {
	pt1 = listea_1.car[pt - 1];
	nbn = nbn + bdpec3_1.nbnode[pt1 + 64] - 1;
/*          cumul des abcisses curvilignes */
	dist1 += lngelm_(&pt1);
	pt = listed_1.cdr[pt - 1];
	goto L1200;
    }
/*         print*,'nodlig: nbn=',nbn,' nbnood=',nbnood */
    if (nbn == *nbnood) {
	return 0;
    }
    nbn = *nbnood;
    pt = *ptlign;
L1201:
    if (pt != 0) {
	pt1 = listea_1.car[pt - 1];
	if (listed_1.cdr[pt - 1] == 0) {
/*            on affecte le residu si c'est le dernier element de 
la lign */
	    snbn = nbn + 1;
	    nodelm_(&pt1, &snbn);
	} else {
/*            nombre d'intervals proportionellement a l'abcisse cu
rvilign */
	    dist2 = lngelm_(&pt1);
	    r__1 = *nbnood * (dist2 / dist1);
	    nbint = i_nint(&r__1);
/*            affect le nombre d'intermediaires snbn=nbint+1 */
	    snbn = nbint + 1;
	    nodelm_(&pt1, &snbn);
	    nbint = snbn - 1;
	    nbn -= nbint;
	}
	pt = listed_1.cdr[pt - 1];
	goto L1201;
    }
    return 0;
} /* nodlig_ */




/* Subroutine */ int noeud2_(integer *adress, integer *mode)
{
    /* System generated locals */
    address a__1[3];
    integer i__1, i__2, i__3[3];
    real r__1, r__2;
    char ch__1[10];

    /* Builtin functions */
    double sqrt(doublereal), cos(doublereal), sin(doublereal), atan2(
	    doublereal, doublereal), r_mod(real *, real *);
    /* Subroutine */ int s_cat(char *, char **, integer *, integer *, ftnlen);

    /* Local variables */
    real cosa;
    extern integer last_(integer *);
    real sina, xgen[3], ygen[3];
    extern /* Subroutine */ int gnin_(real *, real *, real *, integer *, real 
	    *), ligh3_(integer *, integer *, integer *), draw3_(integer *), 
	    txt2d_(char *, integer *, real *, real *, ftnlen);

    real alpha, theta;
    integer i, j, j0, j1, j2, nunur;
    real l, r;
    extern /* Subroutine */ int thick_(real *), lin2of_(real *, real *);
    extern integer cou1rf_(integer *);
    real dx, dy, dalpha, xc[1001], yc[1001];
    integer ptt;
    char buf[8];
    real lontxt, vx[3], vy[3], vvx[6]	/* was [2][3] */, vvy[6]	/* 
	    was [2][3] */, modulv;
    extern /* Subroutine */ int drw3tx_(real *, real *, integer *), strint_(
	    integer *, char *, integer *, ftnlen), mov2to_(real *, real *), 
	    ctrtxt_(real *, real *);


/*     trace les noeud2 et les refs de l'element  bd(adress) */
/*      mode=-1 fond */
/*      mode=0 normal */
/*      mode=1 hight light */


/*     lontxt= taille caractere en unitees utilisateur */
/*     sixtxt= taille caracteres en c.m. */
/*     (1)=debut, (2)=milieu, (3)=fin */
/*     (vx,vy)=vecteur normal de decalage/(genx,geny) en cas de fissure */
/*     (vvx,vvy)=vecteur  de decalage a gauche et a droit */
/*               / (genx,geny) en cas de fissure */
/* --    modif f.hecht mars 89  option de tracer softcp */
    if (pec_1.appli == 514 && bdmshm_1.optdrw == 1) {
	return 0;
    }
    if (bdpec3_1.nbnode[*adress + 64] > 0) {
	gnin_(&bdpec2_1.bd[*adress * 6 + 384], &xc[1], &yc[1], &
		bdpec3_1.nbnode[*adress + 64], &bdpec4_1.raison[*adress + 64])
		;
    }
    for (i = 1; i <= 3; ++i) {
	vx[i - 1] = 0.f;
	vy[i - 1] = 1.f;
/* L2: */
    }
    lontxt = (pec_1.masque[1] - pec_1.masque[0]) * .21f / (pec_1.fentre[1] - 
	    pec_1.fentre[0]);
/*     longueur du tirete en cas de fissure (3 caracteres) */
    modulv = lontxt * 2.f;
    drw3tx_(&c_b6348, &c_b609, &c__0);
    if (bdpec2_1.bd[*adress * 6 + 384] == 0.f) {
	xgen[1] = bdpec2_1.bd[*adress * 6 + 385];
	ygen[1] = bdpec2_1.bd[*adress * 6 + 386];
    } else if (bdpec2_1.bd[*adress * 6 + 384] == -3.f) {
	xgen[0] = bdpec2_1.bd[*adress * 6 + 385];
	ygen[0] = bdpec2_1.bd[*adress * 6 + 386];
	xgen[1] = (bdpec2_1.bd[*adress * 6 + 385] + bdpec2_1.bd[*adress * 6 + 
		387]) / 2.f;
	ygen[1] = (bdpec2_1.bd[*adress * 6 + 386] + bdpec2_1.bd[*adress * 6 + 
		388]) / 2.f;
	xgen[2] = bdpec2_1.bd[*adress * 6 + 387];
	ygen[2] = bdpec2_1.bd[*adress * 6 + 388];
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[*adress * 6 + 387] - bdpec2_1.bd[*adress * 6 + 385]
		;
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[*adress * 6 + 388] - bdpec2_1.bd[*adress * 6 + 386]
		;
	l = sqrt(r__1 * r__1 + r__2 * r__2);
	if (l <= eps_1.eps) {
	    l = 1.f;
	}
	vx[0] = (bdpec2_1.bd[*adress * 6 + 388] - bdpec2_1.bd[*adress * 6 + 
		386]) / l * modulv;
	vy[0] = -(doublereal)(bdpec2_1.bd[*adress * 6 + 387] - bdpec2_1.bd[*
		adress * 6 + 385]) / l * modulv;
	vx[1] = vx[0];
	vy[1] = vy[0];
	vx[2] = vx[0];
	vy[2] = vy[0];
    } else if (bdpec2_1.bd[*adress * 6 + 384] == -2.f) {
	dx = bdpec2_1.bd[*adress * 6 + 387] - bdpec2_1.bd[*adress * 6 + 385];
	dy = bdpec2_1.bd[*adress * 6 + 388] - bdpec2_1.bd[*adress * 6 + 386];
	xgen[0] = bdpec2_1.bd[*adress * 6 + 387];
	ygen[0] = bdpec2_1.bd[*adress * 6 + 388];
	dalpha = bdpec2_1.bd[*adress * 6 + 389] / 2.f;
	xgen[1] = bdpec2_1.bd[*adress * 6 + 385] + dx * cos(dalpha) - dy * 
		sin(dalpha);
	ygen[1] = bdpec2_1.bd[*adress * 6 + 386] + dx * sin(dalpha) + dy * 
		cos(dalpha);
	dalpha = bdpec2_1.bd[*adress * 6 + 389];
	xgen[2] = bdpec2_1.bd[*adress * 6 + 385] + dx * cos(dalpha) - dy * 
		sin(dalpha);
	ygen[2] = bdpec2_1.bd[*adress * 6 + 386] + dx * sin(dalpha) + dy * 
		cos(dalpha);
/* Computing 2nd power */
	r__1 = bdpec2_1.bd[*adress * 6 + 387] - bdpec2_1.bd[*adress * 6 + 385]
		;
/* Computing 2nd power */
	r__2 = bdpec2_1.bd[*adress * 6 + 388] - bdpec2_1.bd[*adress * 6 + 386]
		;
	r = sqrt(r__1 * r__1 + r__2 * r__2) / modulv;
	if (r <= eps_1.eps) {
	    r = 1.f;
	}
	vx[0] = (xgen[0] - bdpec2_1.bd[*adress * 6 + 385]) / r;
	vy[0] = (ygen[0] - bdpec2_1.bd[*adress * 6 + 386]) / r;
	vx[1] = (xgen[1] - bdpec2_1.bd[*adress * 6 + 385]) / r;
	vy[1] = (ygen[1] - bdpec2_1.bd[*adress * 6 + 386]) / r;
	vx[2] = (xgen[2] - bdpec2_1.bd[*adress * 6 + 385]) / r;
	vy[2] = (ygen[2] - bdpec2_1.bd[*adress * 6 + 386]) / r;
    } else if (bdpec2_1.bd[*adress * 6 + 384] == -4.f) {
/*       calcul du point visualisation du numero de ref */
/*       de l'element */
/* x        n=bd(1,adress) */
	ptt = bdpec2_1.bd[*adress * 6 + 386];
	xc[0] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 385];
	yc[0] = bdpec2_1.bd[listea_1.car[ptt - 1] * 6 + 386];
	xc[bdpec3_1.nbnode[*adress + 64] - 1] = bdpec2_1.bd[listea_1.car[
		last_(&ptt) - 1] * 6 + 385];
	yc[bdpec3_1.nbnode[*adress + 64] - 1] = bdpec2_1.bd[listea_1.car[
		last_(&ptt) - 1] * 6 + 386];
	xgen[0] = xc[0];
	ygen[0] = yc[0];
	xgen[1] = xc[(bdpec3_1.nbnode[*adress + 64] - 1) / 2];
	ygen[1] = yc[(bdpec3_1.nbnode[*adress + 64] - 1) / 2];
	xgen[2] = xc[bdpec3_1.nbnode[*adress + 64] - 1];
	ygen[2] = yc[bdpec3_1.nbnode[*adress + 64] - 1];
	vx[0] = yc[1] - yc[0];
	vy[0] = -(doublereal)(xc[1] - xc[0]);
	j1 = bdpec3_1.nbnode[*adress + 64] - 1;
/* Computing MAX */
	i__1 = j1 / 2 - 1;
	j0 = max(i__1,0);
/* Computing MIN */
	i__1 = j1 / 2 + 1;
	j2 = min(i__1,j1);
	vx[1] = -(doublereal)(yc[j0] - yc[j2]);
	vy[1] = xc[j0] - xc[j2];
	vx[2] = yc[j1] - yc[j1 - 1];
	vy[2] = -(doublereal)(xc[j1] - xc[j1 - 1]);
    } else {
	return 0;
    }
    for (i = 1; i <= 3; ++i) {
/* Computing 2nd power */
	r__1 = vx[i - 1];
/* Computing 2nd power */
	r__2 = vy[i - 1];
	l = sqrt(r__1 * r__1 + r__2 * r__2) / modulv;
	if (l > eps_1.eps) {
	    vx[i - 1] /= l;
	    vy[i - 1] /= l;
	} else {
	    vx[i - 1] = 0.f;
	    vy[i - 1] = modulv;
	}
/* L10: */
    }
/*     calcul de vvx et vvy */
    if (bdpecd_1.fissur[*adress + 64]) {
	alpha = 1.047197551f;
	cosa = cos(alpha);
	sina = sin(alpha);
	vvx[1] = vx[0] * cosa - vy[0] * sina;
	vvy[1] = vx[0] * sina + vy[0] * cosa;
	vvx[0] = -(doublereal)vx[0] * cosa - vy[0] * sina;
	vvy[0] = vx[0] * sina - vy[0] * cosa;
	vvx[3] = vx[1];
	vvy[3] = vy[1];
	vvx[2] = -(doublereal)vx[1];
	vvy[2] = -(doublereal)vy[1];
	vvx[5] = vx[2] * cosa + vy[2] * sina;
	vvy[5] = -(doublereal)vx[2] * sina + vy[2] * cosa;
	vvx[4] = -(doublereal)vx[2] * cosa + vy[2] * sina;
	vvy[4] = -(doublereal)vx[2] * sina - vy[2] * cosa;
    } else {
	for (i = 1; i <= 2; ++i) {
	    for (j = 1; j <= 3; ++j) {
		vvx[i + (j << 1) - 3] = 0.f;
		vvy[i + (j << 1) - 3] = 0.f;
/* L20: */
	    }
	}
    }
    thick_(&c_b604);
    draw3_(&c__0);
/*     calcul du sens de l'ecriture */
    r__1 = atan2(vy[1], vx[1]) + 4.7123889795f;
    theta = r_mod(&r__1, &c_b6355) * 2.f / 3.141592653f;
    if (theta > 1.f) {
	theta += -2.f;
    }
    drw3tx_(&c_b6348, &theta, &c__0);
/*     visualisation du numero de ref de l'element en  xgen(2),ygen(2) */
/*                      ============= */
    if (bdpecd_1.fissur[*adress + 64]) {
	j1 = 2;
    } else {
	j1 = 1;
    }
    i__1 = j1;
    for (j = 1; j <= i__1; ++j) {
	if (bdpec5_1.nuref[j + (*adress << 1) + 127] > 0) {
	    if (*mode == 0 || *mode == 1) {
		i__2 = cou1rf_(&bdpec5_1.nuref[j + (*adress << 1) + 127]);
		ligh3_(&c_n1, &c_n1, &i__2);
	    } else {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    }
	    strint_(&bdpec5_1.nuref[j + (*adress << 1) + 127], buf, &i, 8L);
	    if (bdpecd_1.fissur[*adress + 64]) {
		draw3_(&c__1);
		thick_(&c_b604);
		mov2to_(&xgen[1], &ygen[1]);
		r__1 = vvx[j + 1] * .666f;
		r__2 = vvy[j + 1] * .666f;
		lin2of_(&r__1, &r__2);
/*           texte centre */
		ctrtxt_(&c_b619, &c_b619);
	    } else {
/*           texte centre en bas */
		ctrtxt_(&c_b619, &c_b6368);
	    }
/* Writing concatenation */
	    i__3[0] = 1, a__1[0] = "[";
	    i__3[1] = i, a__1[1] = buf;
	    i__3[2] = 1, a__1[2] = "]";
	    s_cat(ch__1, a__1, i__3, &c__3, 10L);
	    i__2 = i + 2;
	    r__1 = xgen[1] + vvx[j + 1];
	    r__2 = ygen[1] + vvy[j + 1];
	    txt2d_(ch__1, &i__2, &r__1, &r__2, i + 2);
	}
/* L6: */
    }
    ctrtxt_(&c_b609, &c_b609);
    if (bdpec2_1.bd[*adress * 6 + 384] == 0.f || pec_1.appli == 514) {
	return 0;
    }
/*     ++++++++++++++++++++++++++++++++++++++++++  -----> */
/*      visualisation des noeuds */
/*      ========================= */
    if (*mode == 0 || *mode == 1) {
	i__1 = cou1rf_(&bdpec5_1.nuref[(*adress << 1) + 128]);
	ligh3_(&c_n1, &c_n1, &i__1);
    } else {
	ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
    }
    drw3tx_(&c_b6378, &c_b609, &c__0);
    i__1 = bdpec3_1.nbnode[*adress + 64] - 2;
    for (i = 1; i <= i__1; ++i) {
	txt2d_("+", &c__1, &xc[i], &yc[i], 1L);
/* L1: */
    }
/*     visualisation du numero des refs des extremitees de l'element */
/*                      =============================== */
/* --------- 1 extremite -------------------- */
/*     calcul du sens de l'ecriture et du centrage du text */
    if (bdpecd_1.fissur[*adress + 64]) {
	r__1 = atan2(vy[0], vx[0]) + 7.8539816325f;
	theta = r_mod(&r__1, &c_b28) * 2.f / 3.141592653f;
/*        print *,' ext1 theta=',theta,' vx,vy=',vx(1),vy(1) */
	if (theta > 1.f && theta <= 3.f) {
	    ctrtxt_(&c_b614, &c_b619);
	} else {
	    ctrtxt_(&c_b609, &c_b619);
	}
	r__1 = theta + 1;
	theta = r_mod(&r__1, &c_b6389) - 1;
	j1 = 2;
    } else {
	ctrtxt_(&c_b609, &c_b609);
	theta = 0.f;
	j1 = 1;
    }
    i__1 = j1;
    for (j = 1; j <= i__1; ++j) {
	nunur = bdpec6_1.nuref1[j + (*adress << 1) + 127];
	if (nunur != 0) {
	    if (*mode == 0 || *mode == 1) {
		i__2 = cou1rf_(&nunur);
		ligh3_(&c_n1, &c_n1, &i__2);
	    } else {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    }
	    strint_(&nunur, buf, &i, 8L);
	    txt2d_("*", &c__1, xgen, ygen, 1L);
	    if (bdpecd_1.fissur[*adress + 64]) {
		draw3_(&c__1);
		thick_(&c_b604);
		mov2to_(xgen, ygen);
		lin2of_(&vvx[j - 1], &vvy[j - 1]);
	    }
	    drw3tx_(&c_b6348, &theta, &c__0);
/* Writing concatenation */
	    i__3[0] = 1, a__1[0] = "(";
	    i__3[1] = i, a__1[1] = buf;
	    i__3[2] = 1, a__1[2] = ")";
	    s_cat(ch__1, a__1, i__3, &c__3, 10L);
	    i__2 = i + 2;
	    r__1 = xgen[0] + vvx[j - 1];
	    r__2 = ygen[0] + vvy[j - 1];
	    txt2d_(ch__1, &i__2, &r__1, &r__2, i + 2);
	}
/* L5: */
    }

/*     2 extremite */
/* -------------------- */
/*     calcul du sens de l'ecriture et du centrage du text */
    if (bdpecd_1.fissur[*adress + 64]) {
	r__1 = atan2(vy[2], vx[2]) + 7.8539816325f;
	theta = r_mod(&r__1, &c_b28) * 2.f / 3.141592653f;
	if (theta > 1.f && theta <= 3.f) {
	    ctrtxt_(&c_b609, &c_b619);
	} else {
	    ctrtxt_(&c_b614, &c_b619);
	}
	r__1 = theta + 1;
	theta = r_mod(&r__1, &c_b6389) - 1;
	j1 = 2;
    } else {
	ctrtxt_(&c_b609, &c_b609);
	theta = 0.f;
	j1 = 1;
    }
    i__1 = j1;
    for (j = 1; j <= i__1; ++j) {
	nunur = bdpec7_1.nuref2[j + (*adress << 1) + 127];
	if (nunur != 0) {
	    if (*mode == 0 || *mode == 1) {
		i__2 = cou1rf_(&nunur);
		ligh3_(&c_n1, &c_n1, &i__2);
	    } else {
		ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
	    }
	    strint_(&nunur, buf, &i, 8L);
	    drw3tx_(&c_b6378, &c_b609, &c__0);
	    txt2d_("*", &c__1, &xgen[2], &ygen[2], 1L);
	    if (bdpecd_1.fissur[*adress + 64]) {
		draw3_(&c__1);
		thick_(&c_b604);
		mov2to_(&xgen[2], &ygen[2]);
		lin2of_(&vvx[j + 3], &vvy[j + 3]);
	    }
	    drw3tx_(&c_b6348, &theta, &c__0);
/* Writing concatenation */
	    i__3[0] = 1, a__1[0] = "(";
	    i__3[1] = i, a__1[1] = buf;
	    i__3[2] = 1, a__1[2] = ")";
	    s_cat(ch__1, a__1, i__3, &c__3, 10L);
	    i__2 = i + 2;
	    r__1 = xgen[2] + vvx[j + 3];
	    r__2 = ygen[2] + vvy[j + 3];
	    txt2d_(ch__1, &i__2, &r__1, &r__2, i + 2);
	}
/* L7: */
    }
    thick_(&c_b604);
    draw3_(&c__0);
    ctrtxt_(&c_b609, &c_b609);
    return 0;
} /* noeud2_ */




/* Subroutine */ int noirci_(real *rec)
{
    /* Local variables */
    extern /* Subroutine */ int clip_(logical *), ligh3_(integer *, integer *,
	     integer *);
    logical f2, f3;

    extern /* Subroutine */ int debfac_(integer *), finfac_(void);
    logical fz;
    extern /* Subroutine */ int inqclp_(logical *, logical *, logical *), 
	    linsrn_(real *, real *, real *, real *);


/*     elle remplit le rectangle rec en couleur du fond */
/*     rec= xmin,xmax,ymin,ymax (en c.m.) */


/*     couleur du fond (0) */

/*     inq des flag de clip */
    /* Parameter adjustments */
    --rec;

    /* Function Body */
    inqclp_(&f2, &f3, &fz);
    clip_((logical*)&c__0);
    ligh3_(&c_n1, &c_n1, &ctabco_1.fond);
    debfac_(&c__1);
    linsrn_(&rec[1], &rec[3], &rec[2], &rec[3]);
    linsrn_(&rec[2], &rec[3], &rec[2], &rec[4]);
    linsrn_(&rec[2], &rec[4], &rec[1], &rec[4]);
    linsrn_(&rec[1], &rec[4], &rec[1], &rec[3]);
    finfac_();
    clip_(&f2);
    return 0;
} /* noirci_ */




/*     f_lisp */
integer nrever_(integer *pt1)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    integer preced;


/*     nrever= pointeur sur la liste pt1 inversee (sur place) */
/*     elle modifie  la liste pt1  et pt1 */
/*                                    === */


    preced = 0;
L1:
    if (*pt1 != 0) {
	ret_val = listed_1.cdr[*pt1 - 1];
	listed_1.cdr[*pt1 - 1] = preced;
	preced = *pt1;
	*pt1 = ret_val;
	goto L1;
    }
    ret_val = preced;
    *pt1 = preced;
    return ret_val;
} /* nrever_ */

integer nxadja_(integer *i, integer *extrmi, integer *extrma)
{
    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern integer caar_(integer *), cdar_(integer *), last_(integer *);
    integer tete;

    integer pttbd;
    integer pt1, preced;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2768 = { 0, 6, 0, 0, 0 };





/*     entree:i,extrmi */
/*     sortie:nxadja,extrma */
/*     nxadja= adresse dans bd du precedant dans la liste des adjacents */
/*         de i (en son extremite extrmi) */
/*     extrma= extremite de nxadja */
    pttbd = *i;
/*     recherche de pttbd dans la liste des adjacents en son extremite ex 
*/
/*      print*,'nxadja:adp1(',pttbd,')=',adp1(pttbd) */
/*     +           ,' ,adp2(',pttbd,')=',adp2(pttbd) */
/*     +           ,' ,extrmi=',extrmi */
    if (*extrmi == 1) {
	tete = bdpece_1.adjabd[bdpec8_1.adp1[pttbd + 64] + 64];
    } else {
	tete = bdpece_1.adjabd[bdpec9_1.adp2[pttbd + 64] + 64];
    }
/* L2: */
    preced = 0;
    pt1 = tete;
L1:
    if (pt1 != 0) {
	if (caar_(&pt1) != pttbd || cdar_(&pt1) != *extrmi) {
	    preced = pt1;
	    pt1 = listed_1.cdr[pt1 - 1];
	    goto L1;
	} else {
/*         on a retrouver pttbd en pt1, son precedant est preced 
*/
	    if (preced == 0) {
		preced = last_(&tete);
	    }
	    ret_val = caar_(&preced);
	    *extrma = cdar_(&preced);
	    return ret_val;
	}
    }
    s_wsle(&io___2768);
    do_lio(&c__9, &c__1, "NXADJA:ERREUR ON N'A PAS RETROUVER L'ELEMENT DANS", 
	    49L);
    do_lio(&c__9, &c__1, " LA LISTE DES ADJACENTS", 23L);
    do_lio(&c__3, &c__1, (char *)&pttbd, (ftnlen)sizeof(integer));
    e_wsle();
    ret_val = 0;
    *extrma = 0;
    return ret_val;
} /* nxadja_ */




/* Subroutine */ int overdc_(integer *iad)
{
    /* System generated locals */
    real r__1, r__2, r__3, r__4, r__5, r__6, r__7, r__8;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    extern /* Subroutine */ int draw_(real *);

    extern doublereal atang2_(real *, real *);
    integer i, j;
    real p1[2], p2[2], q1[2], q2[2];
    extern /* Subroutine */ int thick_(real *);
    integer pt1, pt2;
    real a1i, a2i, a1j, a2j;
    extern /* Subroutine */ int scrtch_(char *, ftnlen);
    real eps2;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2775 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2780 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2783 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2784 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2785 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2786 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2787 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2788 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2789 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2790 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2791 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2792 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2793 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2794 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2795 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2798 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2801 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2802 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2803 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2804 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2805 = { 0, 6, 0, 0, 0 };
    /*static*/ cilist io___2806 = { 0, 6, 0, 0, 0 };



/*     teste si les elements du support bd(*,iad) qui sont dans la liste 
*/
/*     nuref(iad) se superposent, on detruit ceux qui se superposent */
/*     les supports sont soit des droites soit des arcs. */


    eps2 = eps_1.eps * eps_1.eps;
    eps2 = eps_1.eps;
    if (bdpec2_1.bd[*iad * 6 + 384] == -1.f) {
/*       les elements sont des segments */
	pt1 = bdpec5_1.nuref[(*iad << 1) + 128];
L10:
	if (pt1 != 0) {
	    i = listea_1.car[pt1 - 1];
	    if (bdpec2_1.bd[i * 6 + 384] != -3.f) {
		if (bdpec2_1.bd[i * 6 + 384] != -1e3f) {
		    scrtch_("OVERBD:ERREUR MAUVAIS TYPE", 26L);
		    s_wsle(&io___2775);
		    do_lio(&c__9, &c__1, "OVERBD:ERREUR MAUVAIS TYPE POUR I", 
			    33L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    e_wsle();
		}
		pt1 = listed_1.cdr[pt1 - 1];
		goto L10;
	    }
	    p1[0] = bdpec2_1.bd[i * 6 + 385];
	    p1[1] = bdpec2_1.bd[i * 6 + 386];
	    p2[0] = bdpec2_1.bd[i * 6 + 387];
	    p2[1] = bdpec2_1.bd[i * 6 + 388];
	    pt2 = listed_1.cdr[pt1 - 1];
L20:
	    if (pt2 != 0) {
		j = listea_1.car[pt2 - 1];
		if (bdpec2_1.bd[j * 6 + 384] != -3.f) {
		    if (bdpec2_1.bd[j * 6 + 384] != -1e3f) {
			scrtch_("OVERBD:ERREUR MAUVAIS TYPE", 26L);
			s_wsle(&io___2780);
			do_lio(&c__9, &c__1, "OVERBD:ERREUR MAUVAIS TYPE POU"
				"R J", 33L);
			do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384]
				, (ftnlen)sizeof(real));
			e_wsle();
		    }
		    pt2 = listed_1.cdr[pt2 - 1];
		    goto L20;
		}
		q1[0] = bdpec2_1.bd[j * 6 + 385];
		q1[1] = bdpec2_1.bd[j * 6 + 386];
		q2[0] = bdpec2_1.bd[j * 6 + 387];
		q2[1] = bdpec2_1.bd[j * 6 + 388];
/*            teste si bd(*,i) et bd(*,j) se superposent */
/*                     est ce que q1 est entre p1 et p2 ? */
		if ((p1[0] - q1[0]) * (p2[0] - q1[0]) + (p1[1] - q1[1]) * (p2[
			1] - q1[1]) < -(doublereal)eps2 || (p1[0] - q2[0]) * (
			p2[0] - q2[0]) + (p1[1] - q2[1]) * (p2[1] - q2[1]) < 
			-(doublereal)eps2) {
/*                     est ce que q2 est entre p1 et p2 ? 
*/
		    s_wsle(&io___2783);
		    do_lio(&c__9, &c__1, "SUPERPOSITION, ON ANNULE ELEMENT", 
			    32L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		    s_wsle(&io___2784);
		    do_lio(&c__9, &c__1, "I=", 2L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  P1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&p1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " P2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&p2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2785);
		    do_lio(&c__9, &c__1, "J=", 2L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  Q1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&q1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " Q2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&q2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2786);
		    do_lio(&c__9, &c__1, "SUPPORT:DROITE=", 15L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 384],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 385],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 386],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 387],
			     (ftnlen)sizeof(real));
		    e_wsle();
		    scrtch_("SUPERPOSITION, ON ANNULE ELEMENT J", 34L);
		    thick_(&c_b619);
		    draw_(&bdpec2_1.bd[j * 6 + 384]);
		    thick_(&c_b604);
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
/*               pause */
		}
/*                     est ce que p1 est entre q1 et q2 ? */
		if ((q1[0] - p1[0]) * (q2[0] - p1[0]) + (q1[1] - p1[1]) * (q2[
			1] - p1[1]) < -(doublereal)eps2 || (q1[0] - p2[0]) * (
			q2[0] - p2[0]) + (q1[1] - p2[1]) * (q2[1] - p2[1]) < 
			-(doublereal)eps2) {
/*                     est ce que p2 est entre q1 et q2 ? 
*/
		    s_wsle(&io___2787);
		    do_lio(&c__9, &c__1, "SUPERPOSITION, ON ANNULE ELEMENT", 
			    32L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		    s_wsle(&io___2788);
		    do_lio(&c__9, &c__1, "I=", 2L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  P1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&p1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " P2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&p2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2789);
		    do_lio(&c__9, &c__1, "J=", 2L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  Q1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&q1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " Q2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&q2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2790);
		    do_lio(&c__9, &c__1, "SUPPORT:DROITE=", 15L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 384],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 385],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 386],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 387],
			     (ftnlen)sizeof(real));
		    e_wsle();
		    scrtch_("SUPERPOSITION, ON ANNULE ELEMENT J", 34L);
		    thick_(&c_b619);
		    draw_(&bdpec2_1.bd[j * 6 + 384]);
		    thick_(&c_b604);
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
/*               pause */
		}
/*            les segments sont ils egaux ? */
		if ((r__1 = p1[0] - q1[0], dabs(r__1)) <= eps_1.eps && (r__2 =
			 p1[1] - q1[1], dabs(r__2)) <= eps_1.eps && (r__3 = 
			p2[0] - q2[0], dabs(r__3)) <= eps_1.eps && (r__4 = p2[
			1] - q2[1], dabs(r__4)) <= eps_1.eps || (r__5 = p1[0] 
			- q2[0], dabs(r__5)) <= eps_1.eps && (r__6 = p1[1] - 
			q2[1], dabs(r__6)) <= eps_1.eps && (r__7 = p2[0] - q1[
			0], dabs(r__7)) <= eps_1.eps && (r__8 = p2[1] - q1[1],
			 dabs(r__8)) <= eps_1.eps) {
		    s_wsle(&io___2791);
		    do_lio(&c__9, &c__1, "EGALITEE, ON ANNULE ELEMENT", 27L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		    s_wsle(&io___2792);
		    do_lio(&c__9, &c__1, "I=", 2L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  P1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&p1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " P2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&p2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2793);
		    do_lio(&c__9, &c__1, "J=", 2L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  Q1=", 5L);
		    do_lio(&c__4, &c__2, (char *)&q1[0], (ftnlen)sizeof(real))
			    ;
		    do_lio(&c__9, &c__1, " Q2=", 4L);
		    do_lio(&c__4, &c__2, (char *)&q2[0], (ftnlen)sizeof(real))
			    ;
		    e_wsle();
		    s_wsle(&io___2794);
		    do_lio(&c__9, &c__1, "SUPPORT:DROITE=", 15L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 384],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 385],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 386],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 387],
			     (ftnlen)sizeof(real));
		    e_wsle();
		    scrtch_("EGALITEE, ON ANNULE ELEMENT J", 29L);
		    thick_(&c_b619);
		    draw_(&bdpec2_1.bd[j * 6 + 384]);
		    thick_(&c_b604);
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
/*               pause */
		}
		pt2 = listed_1.cdr[pt2 - 1];
		goto L20;
	    }
	    pt1 = listed_1.cdr[pt1 - 1];
	    goto L10;
	}
    } else if (bdpec2_1.bd[*iad * 6 + 384] > 0.f) {
/*       les elements sont des arcs */
	pt1 = bdpec5_1.nuref[(*iad << 1) + 128];
L1:
	if (pt1 != 0) {
	    i = listea_1.car[pt1 - 1];
	    if (bdpec2_1.bd[i * 6 + 384] != -2.f) {
		if (bdpec2_1.bd[i * 6 + 384] != -1e3f) {
		    scrtch_("OVERBD:ERREUR MAUVAIS TYPE", 26L);
		    s_wsle(&io___2795);
		    do_lio(&c__9, &c__1, "OVERBD:ERREUR MAUVAIS TYPE POUR I", 
			    33L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    e_wsle();
		}
		pt1 = listed_1.cdr[pt1 - 1];
		goto L1;
	    }
	    r__1 = bdpec2_1.bd[i * 6 + 388] - bdpec2_1.bd[i * 6 + 386];
	    r__2 = bdpec2_1.bd[i * 6 + 387] - bdpec2_1.bd[i * 6 + 385];
	    a1i = atang2_(&r__1, &r__2);
	    if (bdpec2_1.bd[i * 6 + 389] > 0.f) {
		a2i = a1i + bdpec2_1.bd[i * 6 + 389];
	    } else {
		a1i += bdpec2_1.bd[i * 6 + 389];
		if (a1i < 0.f) {
		    a1i += 6.283185306f;
		}
		a2i = a1i - bdpec2_1.bd[i * 6 + 389];
	    }
	    pt2 = listed_1.cdr[pt1 - 1];
L2:
	    if (pt2 != 0) {
		j = listea_1.car[pt2 - 1];
		if (bdpec2_1.bd[j * 6 + 384] != -2.f) {
		    if (bdpec2_1.bd[j * 6 + 384] != -1e3f) {
			scrtch_("OVERBD:ERREUR MAUVAIS TYPE", 26L);
			s_wsle(&io___2798);
			do_lio(&c__9, &c__1, "OVERBD:ERREUR MAUVAIS TYPE POU"
				"R J", 33L);
			do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384]
				, (ftnlen)sizeof(real));
			e_wsle();
		    }
		    pt2 = listed_1.cdr[pt2 - 1];
		    goto L2;
		}
		r__1 = bdpec2_1.bd[j * 6 + 388] - bdpec2_1.bd[j * 6 + 386];
		r__2 = bdpec2_1.bd[j * 6 + 387] - bdpec2_1.bd[j * 6 + 385];
		a1j = atang2_(&r__1, &r__2);
		if (bdpec2_1.bd[j * 6 + 389] > 0.f) {
		    a2j = a1j + bdpec2_1.bd[j * 6 + 389];
		} else {
		    a1j += bdpec2_1.bd[j * 6 + 389];
		    if (a1j < 0.f) {
			a1j += 6.283185306f;
		    }
		    a2j = a1j - bdpec2_1.bd[j * 6 + 389];
		}
		if (a2i >= 6.283185306f && a2j < 6.283185306f) {
		    a1j += 6.283185306f;
		    a2j += 6.283185306f;
		}
/*            ici on va de a1i a a2i dans le sens positif (2*p
i > a1i > 0 */
/*                          a2i peut etre >2*pi */
/*            ici on va de a1j a a2j dans le sens positif */
/*            teste si bd(*,i) et bd(*,j) se superposent */
/*                      est ce que a1j est entre a1i et a2i ? 
*/
		if (a1j > a1i + 5e-6f && a1j < a2i - 5e-6f || a2j > a1i + 
			5e-6f && a2j < a2i - 5e-6f || a1i > a1j + 5e-6f && 
			a1i < a2j - 5e-6f || a2i > a1j + 5e-6f && a2i < a2j - 
			5e-6f) {
/*                      est ce que a2j est entre a1i et a2
i ? */
/*                      est ce que a1i est entre a1j et a2
j ? */
/*                      est ce que a2i est entre a1j et a2
j ? */
		    s_wsle(&io___2801);
		    do_lio(&c__9, &c__1, "SUPERPOSITION, ON ANNULE ELEMENT", 
			    32L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		    s_wsle(&io___2802);
		    do_lio(&c__9, &c__1, "I=", 2L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  A1I=", 6L);
		    do_lio(&c__4, &c__1, (char *)&a1i, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, " A2I=", 5L);
		    do_lio(&c__4, &c__1, (char *)&a2i, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "     J=", 7L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  A1J=", 6L);
		    do_lio(&c__4, &c__1, (char *)&a1j, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, " A2J=", 5L);
		    do_lio(&c__4, &c__1, (char *)&a2j, (ftnlen)sizeof(real));
		    e_wsle();
		    s_wsle(&io___2803);
		    do_lio(&c__9, &c__1, "SUPPORT:CERCLE=", 15L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 384],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 385],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 386],
			     (ftnlen)sizeof(real));
		    e_wsle();
		    scrtch_("SUPERPOSITION, ON ANNULE ELEMENT J", 34L);
		    thick_(&c_b619);
		    draw_(&bdpec2_1.bd[j * 6 + 384]);
		    thick_(&c_b604);
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
/*               pause */
		}
/*            les arcs sont ils egaux ? */
		if ((r__1 = a1j - a1i, dabs(r__1)) <= 5e-6f && (r__2 = a2j - 
			a2i, dabs(r__2)) <= 5e-6f) {
		    s_wsle(&io___2804);
		    do_lio(&c__9, &c__1, "EGALITEE, ON ANNULE ELEMENT", 27L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    e_wsle();
		    s_wsle(&io___2805);
		    do_lio(&c__9, &c__1, "I=", 2L);
		    do_lio(&c__3, &c__1, (char *)&i, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[i * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  A1I=", 6L);
		    do_lio(&c__4, &c__1, (char *)&a1i, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, " A2I=", 5L);
		    do_lio(&c__4, &c__1, (char *)&a2i, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "     J=", 7L);
		    do_lio(&c__3, &c__1, (char *)&j, (ftnlen)sizeof(integer));
		    do_lio(&c__9, &c__1, " TYPE=", 6L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[j * 6 + 384], (
			    ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, "  A1J=", 6L);
		    do_lio(&c__4, &c__1, (char *)&a1j, (ftnlen)sizeof(real));
		    do_lio(&c__9, &c__1, " A2J=", 5L);
		    do_lio(&c__4, &c__1, (char *)&a2j, (ftnlen)sizeof(real));
		    e_wsle();
		    s_wsle(&io___2806);
		    do_lio(&c__9, &c__1, "SUPPORT:CERCLE=", 15L);
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 384],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 385],
			     (ftnlen)sizeof(real));
		    do_lio(&c__4, &c__1, (char *)&bdpec2_1.bd[*iad * 6 + 386],
			     (ftnlen)sizeof(real));
		    e_wsle();
		    scrtch_("EGALITEE, ON ANNULE ELEMENT J ", 30L);
		    thick_(&c_b619);
		    draw_(&bdpec2_1.bd[j * 6 + 384]);
		    thick_(&c_b604);
		    bdpec2_1.bd[j * 6 + 384] = -1e3f;
/*               pause */
		}
		pt2 = listed_1.cdr[pt2 - 1];
		goto L2;
	    }
	    pt1 = listed_1.cdr[pt1 - 1];
	    goto L1;
	}
    }
    return 0;
} /* overdc_ */




/* Subroutine */ int pa03ad_(doublereal *aa, doublereal *r, integer *n)
{
    /* Initialized data */

    /*static*/ doublereal c1 = 1.;
    /*static*/ doublereal c5 = .5;
    /*static*/ doublereal c3 = 3.;
    /*static*/ doublereal c0 = 0.;
    /*static*/ doublereal c4 = 4.;
    /*static*/ doublereal c23 = .666666666666666667;
    /*static*/ doublereal xinf = 1e38;

    /* System generated locals */
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double sqrt(doublereal), atan2(doublereal, doublereal), cos(doublereal), 
	    d_sign(doublereal *, doublereal *), pow_dd(doublereal *, 
	    doublereal *);

    /* Local variables */
    doublereal a[3], b[2], x, y, z, ta, tb, tc, te, tf;

/*  standard fortran 66 (a verified pfort subroutine) */
/* ************************************************************** */
/* *  purpose....                                               * */
/* *  to find the roots of the real cubic ......                * */
/* *          a(4)*x**3+a(3)*x**2+a(2)*x+a(1)                   * */
/* *                                                            * */
/* *  argument list....                                         * */
/* *  aa  is a real array of length 4 which will contain the    * */
/* *      coefficients a.                                       * */
/* *  r   is a real array which will have its components        * */
/* *      set to the roots.if there are three real roots,then   * */
/* *      r(1).le.r(2).le.r(3). for one real root,r(1) is set   * */
/* *      to it,r(2) is set to the real part of both complex    * */
/* *      roots and r(3) is set to the imaginary part which is  * */
/* *      is positive.the dummy value of 1d+70 is returned for  * */
/* *      each infinite root.this corresponds to a zero         * */
/* *      leading coefficient.                                  * */
/* *  n   is an integer whose value will be set by the routine  * */
/* *      to the number of real roots.                          * */
/* ************************************************************** */
    /* Parameter adjustments */
    --r;
    --aa;

    /* Function Body */

/*     is leading coefficient zero,ie infinite root. */
    if (aa[4] == c0) {
	goto L80;
    }
    if (aa[1] == c0) {
	goto L70;
    }
    a[2] = aa[3] / (c3 * aa[4]);
    a[1] = aa[2] / (c3 * aa[4]);
    a[0] = aa[1] / aa[4];
    x = a[1] - a[2] * a[2];
    y = a[0] - a[2] * (x + x + a[1]);
/* Computing 2nd power */
    d__1 = y;
/* Computing 3rd power */
    d__2 = x, d__3 = d__2;
    z = d__1 * d__1 + c4 * (d__3 * (d__2 * d__2));
    if (z >= c0) {
	goto L100;
    }

/*     there are three real roots. */
    *n = 3;
    r[1] = sqrt(-x) * -2.;
    y /= r[1] * x;
    x = r[1];
    y = atan2(sqrt(c1 - y), sqrt(c1 + y)) * c23;
    if (a[2] < c0) {
	y += 2.094395102393195;
    }

/*     calculate root which does not involve cancellation */
    r[1] = x * cos(y) - a[2];

/*     deflate cubic from optimal end. */
L10:
    b[0] = -a[0] / r[1];
    b[1] = (b[0] - c3 * a[1]) / r[1];
/* Computing 3rd power */
    d__2 = r[1], d__3 = d__2;
    if ((d__1 = d__3 * (d__2 * d__2), abs(d__1)) <= abs(a[0])) {
	b[1] = r[1] + c3 * a[2];
    }
L20:
    x = b[1] * b[1] - c4 * b[0];

/*     is the pair of roots real or complex. */
    if (x < c0) {
	goto L60;
    }
    r[3] = -d_sign(&c5, &b[1]) * (sqrt(x) + abs(b[1]));
    r[2] = c0;
    if (r[3] != c0) {
	r[2] = b[0] / r[3];
    }
    if (r[1] <= r[2]) {
	goto L30;
    }
    ta = r[2];
    r[2] = r[1];
    r[1] = ta;
L30:
    if (r[2] <= r[3]) {
	goto L50;
    }
    ta = r[3];
    if (r[1] <= r[3]) {
	goto L40;
    }
    ta = r[1];
    r[1] = r[3];
L40:
    r[3] = r[2];
    r[2] = ta;
L50:
    *n = 3;
    return 0;
L60:
    r[2] = -c5 * b[1];
    r[3] = c5 * sqrt(-x);
    *n = 1;
    return 0;
L70:
    r[1] = c0;
    b[0] = aa[2] / aa[4];
    b[1] = aa[3] / aa[4];
    goto L20;

/*     the cubic has leading coefficient zero,ie quadratic */
L80:
    r[1] = xinf;
    if (aa[3] == c0) {
	goto L90;
    }
    b[0] = aa[1] / aa[3];
    b[1] = aa[2] / aa[3];
    goto L20;

/*     cubic has first two leading coefficients zero */
L90:
    if (aa[2] != c0) {
	r[1] = -aa[1] / aa[2];
    }
    r[2] = xinf;
    r[3] = xinf;
    *n = 3;
    return 0;

/*     there is one real root. */
L100:
    *n = 1;
    ta = sqrt(z);
    tb = (abs(y) + ta) * c5;
    tc = pow_dd(&tb, &c_b6784);
    if (tc > 0.) {
	goto L110;
    }
    r[1] = -a[2];
    r[2] = -a[2];
    r[3] = -a[2];
    *n = 3;
    return 0;
L110:
/* Computing 3rd power */
    d__1 = tc, d__2 = d__1;
    tc -= (d__2 * (d__1 * d__1) - tb) / (c3 * tc * tc);
    te = tc * tc + abs(x);
/* Computing 2nd power */
    d__1 = x / tc;
    tf = c1 / (d__1 * d__1 + te);
    if (x < c0) {
	goto L120;
    }
    x = te / tc;
    z = y * tf;
    goto L130;
L120:
    x = ta * tf;
    z = d_sign(&c1, &y) * te / tc;
L130:
    if (z * a[2] < c0) {
	goto L140;
    }
    r[1] = -z - a[2];
    goto L10;
L140:
    r[2] = c5 * z - a[2];
    r[3] = c5 * sqrt(c3) * abs(x);
    r[1] = -a[0] / (r[2] * r[2] + r[3] * r[3]);
    return 0;
} /* pa03ad_ */

/* Subroutine */ int pjp1c1_(real *pj, real *p1, real *c1)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real dist, pp[2];

    /* Fortran I/O blocks */
    /*static*/ cilist io___2825 = { 0, 6, 0, 0, 0 };



/*     pj = points projection de p1 sur cercle c1 */



    /* Parameter adjustments */
    pj -= 4;

    /* Function Body */
    if (c1[0] == -1e3f || p1[0] == -1e3f) {
	return 0;
    }
    if (c1[0] <= 0.f || p1[0] < 0.f) {
	s_wsle(&io___2825);
	do_lio(&c__9, &c__1, "ERREUR:PJP1C1, MAUVAIS TYPE", 27L);
	do_lio(&c__4, &c__1, (char *)&c1[0], (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&p1[0], (ftnlen)sizeof(real));
	e_wsle();
	return 0;
    }
    pp[0] = p1[1] - c1[1];
    pp[1] = p1[2] - c1[2];
/* Computing 2nd power */
    r__1 = pp[0];
/* Computing 2nd power */
    r__2 = pp[1];
    dist = r__1 * r__1 + r__2 * r__2;
    if (dist != 0.f) {
	pp[0] /= dist;
	pp[1] /= dist;
    }
    pj[4] = 0.f;
    pj[5] = c1[1] + pp[0] * c1[0];
    pj[6] = c1[2] + pp[1] * c1[0];
    pj[8] = 0.f;
    pj[9] = c1[1] - pp[0] * c1[0];
    pj[10] = c1[2] - pp[1] * c1[0];
    return 0;
} /* pjp1c1_ */

#undef coulls


/* Subroutine */ int pjp1d_(real *pj, real *p1, real *d1, real *delta)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    real puis;

    /* Fortran I/O blocks */
    /*static*/ cilist io___2829 = { 0, 6, 0, 0, 0 };



/*     pj = point a une distance delta de la projection de p1 sur d1 */
/*          (delta est signe) */



    pj[0] = -1e3f;
    if (d1[0] == -1e3f || p1[0] == -1e3f) {
	return 0;
    }
    if (d1[0] != -1.f || p1[0] < 0.f) {
	s_wsle(&io___2829);
	do_lio(&c__9, &c__1, "ERREUR:PJP1D, MAUVAIS TYPE", 26L);
	do_lio(&c__4, &c__1, (char *)&d1[0], (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&p1[0], (ftnlen)sizeof(real));
	e_wsle();
	return 0;
    }
    puis = d1[1] * p1[1] + d1[2] * p1[2] + d1[3];
    pj[1] = p1[1] - puis * d1[1];
    pj[2] = p1[2] - puis * d1[2];
    if (*delta != 0.f) {
	pj[1] -= *delta * d1[2];
	pj[2] += *delta * d1[1];
    }
    pj[0] = 0.f;
    return 0;
} /* pjp1d_ */

#undef coulls


integer pkcomp_(integer *refbd)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    extern integer cons_(integer *, integer *), sens_(integer *);




/*     pkcomp=pointeur sur un cons dont le car et le cdr pointent */
/*        sur des deux composantes aux  quelles l'element refbd appartien 
*/
/*        le car pointe sur celui qui est le plus probable d'apres la */
/*        position de designation */

    if (sens_(refbd) == 1) {
	ret_val = cons_(&bdpecc_1.compos[(*refbd << 1) + 128], &
		bdpecc_1.compos[(*refbd << 1) + 129]);
    } else {
	ret_val = cons_(&bdpecc_1.compos[(*refbd << 1) + 129], &
		bdpecc_1.compos[(*refbd << 1) + 128]);
    }
/*      print*,'pkcomp: l''element',refbd,' appartient aux 2 composantes' 
*/
/*     +     ,car(pkcomp),' et',cdr(pkcomp) */
    return ret_val;
} /* pkcomp_ */




integer pkdomn_(integer *ptcomp, integer *pttbd)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */

    integer ptdomn, pt1;


/*     pkdomn=pointeur sur domaine contenant la composante ptcomp ou */
/*     l'element interieur pttbd */


/*      print*,'pkdomn:on recherche la composante ptcomp=',ptcomp */
    ret_val = 0;
    ptdomn = bdpec1_1.sdomn;
/*     parcourt des sous domaines (ptdomn) */
L1001:
    if (ptdomn != 0) {
	pt1 = listed_1.cdr[listea_1.car[ptdomn - 1] - 1];
/*       parcourt des composantes */
L1002:
	if (pt1 != 0) {
	    if (listea_1.car[pt1 - 1] == *ptcomp) {
		ret_val = ptdomn;
		return ret_val;
	    }
	    pt1 = listed_1.cdr[pt1 - 1];
	    goto L1002;
	}
/*       domaine suivant */
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L1001;
    }
/*      print*,'pkdomn: la composante',ptcomp */
/*     +       ,' n''appartient a aucun sous domaine' */
/*      print*,'pkdomn: recherche de l''element interieur',pttbd */
    ret_val = 0;
    ptdomn = bdpec1_1.sdomn;
/*     parcourt des sous domaines (ptdomn) */
L2001:
    if (ptdomn != 0) {
	pt1 = listed_1.cdr[listea_1.car[listea_1.car[ptdomn - 1] - 1] - 1];
/*       parcourt des elements interieurs */
L2002:
	if (pt1 != 0) {
	    if (listea_1.car[pt1 - 1] == *pttbd) {
		ret_val = ptdomn;
		return ret_val;
	    }
	    pt1 = listed_1.cdr[pt1 - 1];
	    goto L2002;
	}
/*       domaine suivant */
	ptdomn = listed_1.cdr[ptdomn - 1];
	goto L2001;
    }
/*      print*,'pkdomn:l''element',pttbd,' n''est interieur a aucun' */
/*     +      ,' sous domaine' */
    return ret_val;
} /* pkdomn_ */




doublereal proche_(integer *type, real *xx, real *yy, integer *iadr)
{
    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer indx;
    real dist2;

    real p1[4];
    extern doublereal dtp1xx_(real *, real *), dtp1sp_(real *, integer *, 
	    integer *);
    integer tty, ptbdxx, pt;


/*     iadr adresse dans bd de l'element de type type le plus */
/*         proche de xx,yy */
/*         si type=qlconq on recherche pour tout les types */
/*              (selon les applications) et on renvoie type */



    ptbdxx = bdpec1_1.ptbd;
    if (pec_1.appli == 514) {
	ptbdxx = bdmsh4_1.finbd3;
    }
    if (*type == 307) {
	ret_val = 1e30f;
	dist2 = 1e30f;
	p1[0] = 0.f;
	p1[1] = *xx;
	p1[2] = *yy;
	tty = 0;
	*iadr = 0;
	i__1 = ptbdxx;
	for (indx = 1; indx <= i__1; ++indx) {
	    if (bdpec2_1.bd[indx * 6 + 384] == 0.f && pec_1.appli != 514) {
/* Computing 2nd power */
		r__1 = *xx - bdpec2_1.bd[indx * 6 + 385];
/* Computing 2nd power */
		r__2 = *yy - bdpec2_1.bd[indx * 6 + 386];
		dist2 = sqrt(r__1 * r__1 + r__2 * r__2);
		tty = 301;
	    } else if (bdpec2_1.bd[indx * 6 + 384] == -1.f && pec_1.appli != 
		    513 && pec_1.appli != 514) {
		dist2 = (r__1 = bdpec2_1.bd[indx * 6 + 385] * *xx + 
			bdpec2_1.bd[indx * 6 + 386] * *yy + bdpec2_1.bd[indx *
			 6 + 387], dabs(r__1));
		tty = 302;
	    } else if (bdpec2_1.bd[indx * 6 + 384] > 0.f && pec_1.appli != 
		    513 && pec_1.appli != 514) {
/* Computing 2nd power */
		r__1 = *xx - bdpec2_1.bd[indx * 6 + 385];
/* Computing 2nd power */
		r__2 = *yy - bdpec2_1.bd[indx * 6 + 386];
		dist2 = sqrt(r__1 * r__1 + r__2 * r__2) - bdpec2_1.bd[indx * 
			6 + 384];
		dist2 = dabs(dist2);
		tty = 303;
	    } else if (bdpec2_1.bd[indx * 6 + 384] == -2.f) {
		dist2 = dtp1xx_(p1, &bdpec2_1.bd[indx * 6 + 384]);
		tty = 304;
	    } else if (bdpec2_1.bd[indx * 6 + 384] == -3.f) {
		dist2 = dtp1xx_(p1, &bdpec2_1.bd[indx * 6 + 384]);
		tty = 305;
	    } else if (bdpec2_1.bd[indx * 6 + 384] == -4.f) {
		dist2 = dtp1sp_(p1, &indx, &pt);
		tty = 312;
	    }
	    if (dist2 < ret_val) {
		*type = tty;
		*iadr = indx;
		ret_val = dist2;
	    }
/* L2: */
	}
/*        print*,'proche: a trouve l''element de type',type */
/*     +        ,' a l''adresse',iadr */
	return ret_val;
    }
    ret_val = 1e30f;
    dist2 = 1e30f;
    p1[0] = 0.f;
    p1[1] = *xx;
    p1[2] = *yy;
    *iadr = 0;
    i__1 = ptbdxx;
    for (indx = 1; indx <= i__1; ++indx) {
	if (*type == 301) {
	    if (bdpec2_1.bd[indx * 6 + 384] == 0.f) {
/* Computing 2nd power */
		r__1 = *xx - bdpec2_1.bd[indx * 6 + 385];
/* Computing 2nd power */
		r__2 = *yy - bdpec2_1.bd[indx * 6 + 386];
		dist2 = sqrt(r__1 * r__1 + r__2 * r__2);
	    }
	} else if (*type == 302) {
	    if (bdpec2_1.bd[indx * 6 + 384] == -1.f) {
		dist2 = (r__1 = bdpec2_1.bd[indx * 6 + 385] * *xx + 
			bdpec2_1.bd[indx * 6 + 386] * *yy + bdpec2_1.bd[indx *
			 6 + 387], dabs(r__1));
	    }
	} else if (*type == 303) {
	    if (bdpec2_1.bd[indx * 6 + 384] > 0.f) {
/* Computing 2nd power */
		r__1 = *xx - bdpec2_1.bd[indx * 6 + 385];
/* Computing 2nd power */
		r__2 = *yy - bdpec2_1.bd[indx * 6 + 386];
		dist2 = sqrt(r__1 * r__1 + r__2 * r__2) - bdpec2_1.bd[indx * 
			6 + 384];
		dist2 = dabs(dist2);
	    }
	} else if (*type == 304) {
	    if (bdpec2_1.bd[indx * 6 + 384] == -2.f) {
		dist2 = dtp1xx_(p1, &bdpec2_1.bd[indx * 6 + 384]);
	    }
	} else if (*type == 305) {
	    if (bdpec2_1.bd[indx * 6 + 384] == -3.f) {
		dist2 = dtp1xx_(p1, &bdpec2_1.bd[indx * 6 + 384]);
	    }
	} else if (*type == 312) {
	    if (bdpec2_1.bd[indx * 6 + 384] == -4.f) {
/*            print*,'proche: spline bd(0,indx)=',bd(0,indx) 
*/
		dist2 = dtp1sp_(p1, &indx, &pt);
/*            print*,'proche spline: dist2=',dist2,' indx=',in
dx */
/*     +            ,' nb=',bd(1,indx) */
	    }
	}
	if (dist2 < ret_val) {
	    *iadr = indx;
	    ret_val = dist2;
	}
/* L1: */
    }
/*       if(proche.eq.infini)then */
/*         call scrtch('proche: pas d''element de ce type') */
/*       else */
/*         print*,'proche: a trouve l''element a l''adresse',iadr */
/*         print*,'proche: le type de l''element est:',type */
/*       endif */
    return ret_val;
} /* proche_ */



