/*
 * Copyright (c) 2003, 2004 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: emu10kx-midi-mk.h,v 1.5 2005/10/09 13:06:47 chibis Exp $
 * $FreeBSD$
 */

#ifndef EMU10KX_MIDI_MK_H
#define EMU10KX_MIDI_MK_H

#include "midi.h"
#include "mpu401.h"
#include "mpufoi_if.h"

/* Here is the parameter structure per a device. */
struct emu_midi_softc {
	struct mpu401 *mpu;
	mpu401_intr_t *mpu_intr;
	device_t dev;

	struct emu_sc_info *card;

	struct mtx mtx;		/* Mutex to protect the device. */

	int fflags;		/* File flags */
	int ihandle;		/* interrupt manager handle */
	/* Device-specific configuration */
	int port;		/* I/O port or I/O ptr reg */
};
#endif
