/*
 * Copyright (c) 1999 Cameron Grant <gandalf@vilnya.demon.co.uk>
 * Copyright (c) 2003 Yuriy Tsibizov <yuriy.tsibizov@gfk.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHERIN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: emu10kx-pcm.h,v 1.17 2005/10/16 17:37:44 chibis Exp $
 * $FreeBSD$
 */


#include <dev/sound/pcm/sound.h>
#include <dev/sound/pcm/ac97.h>


struct emu_pcm_voice {
	int vnum;
	int b16:1, stereo:1, busy:1, running:1, ismaster:1;
	int speed;
	int start, end, vol;
	uint32_t buf;
	struct emu_pcm_voice *slave;
	struct pcm_channel *channel;
};
/* channel registers */
struct emu_pcm_pchinfo {
	int spd, fmt, blksz, run;
	struct emu_pcm_voice *master, *slave;
	struct snd_dbuf *buffer;
	struct pcm_channel *channel;
	struct emu_pcm_info *parent;
};

struct emu_pcm_rchinfo {
	int spd, fmt, run, blksz, num;
	uint32_t idxreg, basereg, sizereg, setupreg, irqmask, iprmask;
	int ihandle;
	struct snd_dbuf *buffer;
	struct pcm_channel *channel;
	struct emu_pcm_info *parent;
};

struct dspreg {
	int left, right;
};
/* Memory managment for PCM */

struct emu_memblk {
	SLIST_ENTRY(emu_memblk) link;
	void *buf;
	bus_addr_t buf_addr;
	uint32_t pte_start, pte_size;
};

struct emu_mem {
	uint8_t bmap[MAXPAGES / 8];
	uint32_t *ptb_pages;
	void *silent_page;
	bus_addr_t silent_page_addr;
	bus_addr_t ptb_pages_addr;
	           SLIST_HEAD(, emu_memblk) blocks;
};


/* Here is the parameter structure per a device. */
struct emu_pcm_info {
	device_t dev;		/* device information */
	struct snddev_info *devinfo;	/* pcm device information */
	struct emu_sc_info *card;
	struct ac97_info *codec;
	uint32_t ac97_state[0x7F];

#if __FreeBSD_version < 500000
	void *lock;
#else
	struct mtx *lock;
#endif

	struct emu_mem mem;
	int ihandle;		/* interrupt handler */

	/* Device-specific configuration */
	unsigned int pnum, rnum;
	struct emu_pcm_voice voice[64];
	struct emu_pcm_pchinfo pch[EMU_MAX_FXBUS];
	struct emu_pcm_rchinfo rch[3];

};
